#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
/*
 * SimpleAtomicAdd.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct SimpleAtomicAddWorkload : TestWorkload {
	static constexpr auto NAME = "SimpleAtomicAdd";

	int addValue;
	int iterations;
	bool initialize;
	int initialValue;
	Key sumKey;
	double testDuration;
	std::vector<Future<Void>> clients;

	SimpleAtomicAddWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		addValue = getOption(options, "addValue"_sr, 1);
		iterations = getOption(options, "iterations"_sr, 100);
		initialize = getOption(options, "initialize"_sr, false);
		initialValue = getOption(options, "initialValue"_sr, 0);
		sumKey = getOption(options, "sumKey"_sr, "sumKey"_sr);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId) {
			return Void();
		}
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override {
		if (clientId) {
			return true;
		}
		return _check(cx, this);
	}

																#line 66 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
template <class _startActor>
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
class _startActorState {
															#line 72 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
public:
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	_startActorState(Database const& cx,SimpleAtomicAddWorkload* const& self) 
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		 : cx(cx),
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		   self(self)
															#line 81 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			if (self->initialize)
															#line 96 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			{
															#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
				StrictFuture<Void> __when_expr_0 = setInitialValue(cx, self);
															#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		for(int i = 0;i < self->iterations;++i) {
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			self->clients.push_back(timeout(applyAtomicAdd(cx, self), self->testDuration, Void()));
															#line 137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
		}
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		waitForAll(self->clients);
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	Database cx;
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	SimpleAtomicAddWorkload* self;
															#line 242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4632525666445833984UL, 11988599874330462464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	_startActor(Database const& cx,SimpleAtomicAddWorkload* const& self) 
															#line 264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, SimpleAtomicAddWorkload* const& self ) {
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
}

#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"

																#line 301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
// This generated class is to be used only via setInitialValue()
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
template <class SetInitialValueActor>
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
class SetInitialValueActorState {
															#line 307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
public:
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	SetInitialValueActorState(Database const& cx,SimpleAtomicAddWorkload* const& self) 
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		 : cx(cx),
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		   self(self),
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		   tr(cx),
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		   val(StringRef((const uint8_t*)&self->initialValue, sizeof(self->initialValue)))
															#line 320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("setInitialValue", reinterpret_cast<unsigned long>(this));

	}
	~SetInitialValueActorState() 
	{
		fdb_probe_actor_destroy("setInitialValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			;
															#line 335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetInitialValueActorState();
		static_cast<SetInitialValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		if (!static_cast<SetInitialValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetInitialValueActorState(); static_cast<SetInitialValueActor*>(this)->destroy(); return 0; }
															#line 358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
		new (&static_cast<SetInitialValueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetInitialValueActorState();
		static_cast<SetInitialValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			TraceEvent("SAASetInitialValue").detail("Key", self->sumKey).detail("Value", val);
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			tr.set(self->sumKey, val);
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			if (static_cast<SetInitialValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetInitialValueActor*>(this)->actor_wait_state = 1;
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetInitialValueActor, 0, Void >*>(static_cast<SetInitialValueActor*>(this)));
															#line 389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			TraceEvent("SAASetInitialValueError").error(e);
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			if (static_cast<SetInitialValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetInitialValueActor*>(this)->actor_wait_state = 2;
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetInitialValueActor, 1, Void >*>(static_cast<SetInitialValueActor*>(this)));
															#line 433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetInitialValueActor*>(this)->actor_wait_state > 0) static_cast<SetInitialValueActor*>(this)->actor_wait_state = 0;
		static_cast<SetInitialValueActor*>(this)->ActorCallback< SetInitialValueActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetInitialValueActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setInitialValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetInitialValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setInitialValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetInitialValueActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setInitialValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetInitialValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setInitialValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetInitialValueActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setInitialValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetInitialValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setInitialValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetInitialValueActor*>(this)->actor_wait_state > 0) static_cast<SetInitialValueActor*>(this)->actor_wait_state = 0;
		static_cast<SetInitialValueActor*>(this)->ActorCallback< SetInitialValueActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetInitialValueActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setInitialValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetInitialValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setInitialValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetInitialValueActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setInitialValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetInitialValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setInitialValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetInitialValueActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setInitialValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetInitialValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setInitialValue", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	Database cx;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	SimpleAtomicAddWorkload* self;
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	Value val;
															#line 626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
};
// This generated class is to be used only via setInitialValue()
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
class SetInitialValueActor final : public Actor<Void>, public ActorCallback< SetInitialValueActor, 0, Void >, public ActorCallback< SetInitialValueActor, 1, Void >, public FastAllocated<SetInitialValueActor>, public SetInitialValueActorState<SetInitialValueActor> {
															#line 631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
public:
	using FastAllocated<SetInitialValueActor>::operator new;
	using FastAllocated<SetInitialValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15012893086746273024UL, 489469356759518720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetInitialValueActor, 0, Void >;
friend struct ActorCallback< SetInitialValueActor, 1, Void >;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	SetInitialValueActor(Database const& cx,SimpleAtomicAddWorkload* const& self) 
															#line 649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SetInitialValueActorState<SetInitialValueActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setInitialValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1089651581605716480UL, 2357820746113838592UL);
		ActorExecutionContextHelper __helper(static_cast<SetInitialValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setInitialValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setInitialValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetInitialValueActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetInitialValueActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
[[nodiscard]] static Future<Void> setInitialValue( Database const& cx, SimpleAtomicAddWorkload* const& self ) {
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	return Future<Void>(new SetInitialValueActor(cx, self));
															#line 682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
}

#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"

																#line 687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
// This generated class is to be used only via applyAtomicAdd()
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
template <class ApplyAtomicAddActor>
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
class ApplyAtomicAddActorState {
															#line 693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
public:
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	ApplyAtomicAddActorState(Database const& cx,SimpleAtomicAddWorkload* const& self) 
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		 : cx(cx),
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		   self(self),
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		   tr(cx),
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		   val(StringRef((const uint8_t*)&self->addValue, sizeof(self->addValue)))
															#line 706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("applyAtomicAdd", reinterpret_cast<unsigned long>(this));

	}
	~ApplyAtomicAddActorState() 
	{
		fdb_probe_actor_destroy("applyAtomicAdd", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			;
															#line 721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ApplyAtomicAddActorState();
		static_cast<ApplyAtomicAddActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		if (!static_cast<ApplyAtomicAddActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ApplyAtomicAddActorState(); static_cast<ApplyAtomicAddActor*>(this)->destroy(); return 0; }
															#line 744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
		new (&static_cast<ApplyAtomicAddActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ApplyAtomicAddActorState();
		static_cast<ApplyAtomicAddActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			TraceEvent("SAABegin").detail("Key", self->sumKey).detail("Value", val);
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			tr.atomicOp(self->sumKey, val, MutationRef::AddValue);
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			if (static_cast<ApplyAtomicAddActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ApplyAtomicAddActor*>(this)->actor_wait_state = 1;
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ApplyAtomicAddActor, 0, Void >*>(static_cast<ApplyAtomicAddActor*>(this)));
															#line 775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			TraceEvent("SAABeginError").error(e);
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			if (static_cast<ApplyAtomicAddActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ApplyAtomicAddActor*>(this)->actor_wait_state = 2;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ApplyAtomicAddActor, 1, Void >*>(static_cast<ApplyAtomicAddActor*>(this)));
															#line 819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ApplyAtomicAddActor*>(this)->actor_wait_state > 0) static_cast<ApplyAtomicAddActor*>(this)->actor_wait_state = 0;
		static_cast<ApplyAtomicAddActor*>(this)->ActorCallback< ApplyAtomicAddActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ApplyAtomicAddActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("applyAtomicAdd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyAtomicAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyAtomicAdd", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ApplyAtomicAddActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("applyAtomicAdd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyAtomicAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyAtomicAdd", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ApplyAtomicAddActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("applyAtomicAdd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyAtomicAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyAtomicAdd", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ApplyAtomicAddActor*>(this)->actor_wait_state > 0) static_cast<ApplyAtomicAddActor*>(this)->actor_wait_state = 0;
		static_cast<ApplyAtomicAddActor*>(this)->ActorCallback< ApplyAtomicAddActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ApplyAtomicAddActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("applyAtomicAdd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyAtomicAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyAtomicAdd", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ApplyAtomicAddActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("applyAtomicAdd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyAtomicAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyAtomicAdd", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ApplyAtomicAddActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("applyAtomicAdd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyAtomicAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyAtomicAdd", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	Database cx;
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	SimpleAtomicAddWorkload* self;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	Value val;
															#line 1012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
};
// This generated class is to be used only via applyAtomicAdd()
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
class ApplyAtomicAddActor final : public Actor<Void>, public ActorCallback< ApplyAtomicAddActor, 0, Void >, public ActorCallback< ApplyAtomicAddActor, 1, Void >, public FastAllocated<ApplyAtomicAddActor>, public ApplyAtomicAddActorState<ApplyAtomicAddActor> {
															#line 1017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
public:
	using FastAllocated<ApplyAtomicAddActor>::operator new;
	using FastAllocated<ApplyAtomicAddActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9208983223899628800UL, 1981091463724474624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ApplyAtomicAddActor, 0, Void >;
friend struct ActorCallback< ApplyAtomicAddActor, 1, Void >;
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	ApplyAtomicAddActor(Database const& cx,SimpleAtomicAddWorkload* const& self) 
															#line 1035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ApplyAtomicAddActorState<ApplyAtomicAddActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("applyAtomicAdd", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7324268751808499456UL, 654984888104992256UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyAtomicAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("applyAtomicAdd");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("applyAtomicAdd", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ApplyAtomicAddActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ApplyAtomicAddActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
[[nodiscard]] static Future<Void> applyAtomicAdd( Database const& cx, SimpleAtomicAddWorkload* const& self ) {
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	return Future<Void>(new ApplyAtomicAddActor(cx, self));
															#line 1068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
}

#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"

																#line 1073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
// This generated class is to be used only via _check()
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
template <class _checkActor>
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
class _checkActorState {
															#line 1079 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
public:
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	_checkActorState(Database const& cx,SimpleAtomicAddWorkload* const& self) 
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		 : cx(cx),
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		   self(self),
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		   tr(cx),
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		   expectedValue(self->addValue * self->iterations)
															#line 1092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			if (self->initialize)
															#line 1107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			{
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
				expectedValue += self->initialValue;
															#line 1111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			}
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			;
															#line 1115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			TraceEvent("SAACheckKey").log();
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(self->sumKey);
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Optional<Value> >*>(static_cast<_checkActor*>(this)));
															#line 1155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			TraceEvent("SAACheckError").error(e);
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 1186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& actualValue,int loopDepth) 
	{
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		uint64_t actualValueInt = 0;
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		if (actualValue.present())
															#line 1203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
		{
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			memcpy(&actualValueInt, actualValue.get().begin(), actualValue.get().size());
															#line 1207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
		}
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		TraceEvent("SAACheckEqual") .detail("ExpectedValue", expectedValue) .detail("ActualValue", actualValueInt);
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)((expectedValue == actualValueInt)); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool((expectedValue == actualValueInt));
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && actualValue,int loopDepth) 
	{
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		uint64_t actualValueInt = 0;
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		if (actualValue.present())
															#line 1227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
		{
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
			memcpy(&actualValueInt, actualValue.get().begin(), actualValue.get().size());
															#line 1231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
		}
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		TraceEvent("SAACheckEqual") .detail("ExpectedValue", expectedValue) .detail("ActualValue", actualValueInt);
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)((expectedValue == actualValueInt)); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool((expectedValue == actualValueInt));
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& actualValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(actualValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && actualValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(actualValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	Database cx;
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	SimpleAtomicAddWorkload* self;
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	uint64_t expectedValue;
															#line 1415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _check()
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Optional<Value> >, public ActorCallback< _checkActor, 1, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 1420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12318981009184479488UL, 13065799615684946688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Optional<Value> >;
friend struct ActorCallback< _checkActor, 1, Void >;
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	_checkActor(Database const& cx,SimpleAtomicAddWorkload* const& self) 
															#line 1438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
[[nodiscard]] static Future<bool> _check( Database const& cx, SimpleAtomicAddWorkload* const& self ) {
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 1471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SimpleAtomicAdd.actor.g.cpp.py_gen"
}

#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/SimpleAtomicAdd.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<SimpleAtomicAddWorkload> SimpleAtomicAddWorkloadFactory;
