#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
/*
 * MemoryLifetime.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct MemoryLifetime : KVWorkload {
	static constexpr auto NAME = "MemoryLifetime";
	double testDuration;
	std::vector<Future<Void>> clients;

	MemoryLifetime(WorkloadContext const& wcx) : KVWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 60.0);
	}

	KeySelector getRandomKeySelector() const {
		return KeySelectorRef(getRandomKey(),
		                      deterministicRandom()->random01() < 0.5,
		                      deterministicRandom()->randomInt(-nodeCount, nodeCount));
	}

	Standalone<KeyValueRef> operator()(uint64_t n) { return KeyValueRef(keyForIndex(n, false), randomValue()); }

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }

	Future<Void> start(Database const& cx) override { return _start(cx, this); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 55 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
// This generated class is to be used only via _setup()
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
template <class _setupActor>
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
class _setupActorState {
															#line 61 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
public:
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	_setupActorState(Database const& cx,MemoryLifetime* const& self) 
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		 : cx(cx),
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		   self(self),
															#line 54 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		   loadTime()
															#line 72 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 55 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			StrictFuture<Void> __when_expr_0 = bulkSetup(cx, self, self->nodeCount, loadTime);
															#line 55 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 89 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 55 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 94 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 56 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 56 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Database cx;
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	MemoryLifetime* self;
															#line 54 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Promise<double> loadTime;
															#line 218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _setup()
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1222029294202296576UL, 13303489397359522560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	_setupActor(Database const& cx,MemoryLifetime* const& self) 
															#line 240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, MemoryLifetime* const& self ) {
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
}

#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"

																#line 277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
template <class _startActor>
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
class _startActorState {
															#line 283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
public:
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	_startActorState(Database const& cx,MemoryLifetime* const& self) 
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		 : cx(cx),
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		   self(self),
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		   startTime(now()),
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		   tr(cx),
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		   reverse(Reverse::False),
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		   snapshot(Snapshot::False)
															#line 300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			;
															#line 315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			tr = ReadYourWritesTransaction(cx);
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			int op = deterministicRandom()->randomInt(0, 4);
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (op == 0)
															#line 350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			{
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				reverse.set(deterministicRandom()->coinflip());
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				getRange_startKey = self->getRandomKey();
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				getRange_queryRange = reverse ? KeyRangeRef(normalKeys.begin, keyAfter(getRange_startKey)) : KeyRangeRef(getRange_startKey, normalKeys.end);
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				getRange_randomStart = deterministicRandom()->random01();
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				getRange_newValue = self->randomValue();
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				snapshot.set(deterministicRandom()->coinflip());
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				if (getRange_randomStart)
															#line 366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
				{
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					tr.set(getRange_startKey, getRange_newValue);
															#line 370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
				}
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = tr.getRange(getRange_queryRange, GetRangeLimits(4000), snapshot, reverse);
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				if (op == 1)
															#line 388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
				{
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					get_startKey = self->getRandomKey();
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					get_randomStart = deterministicRandom()->random01();
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					get_newValue = self->randomValue();
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					snapshot.set(deterministicRandom()->coinflip());
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					if (get_randomStart)
															#line 400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
					{
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						tr.set(get_startKey, get_newValue);
															#line 404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
					}
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					StrictFuture<Optional<Value>> __when_expr_3 = tr.get(get_startKey, snapshot);
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_3.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					if (op == 2)
															#line 422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
					{
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						getKey_selector = self->getRandomKeySelector();
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						getKey_randomStart = deterministicRandom()->random01();
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						getKey_newValue = self->randomValue();
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						snapshot.set(deterministicRandom()->coinflip());
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						if (getKey_randomStart)
															#line 434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
						{
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
							tr.set(getKey_selector.getKey(), getKey_newValue);
															#line 438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
						}
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						StrictFuture<Key> __when_expr_6 = tr.getKey(getKey_selector, snapshot);
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
						if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_6.get(), loopDepth); };
						static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Key >*>(static_cast<_startActor*>(this)));
															#line 449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						if (op == 3)
															#line 456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
						{
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
							getAddress_startKey = self->getRandomKey();
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
							StrictFuture<Standalone<VectorRef<const char*>>> __when_expr_9 = tr.getAddressesForKey(getAddress_startKey);
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
							if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
							if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1loopBody1when4(__when_expr_9.get(), loopDepth); };
							static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
							__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >*>(static_cast<_startActor*>(this)));
															#line 469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
							loopDepth = 0;
						}
						else
						{
							loopDepth = a_body1loopBody1cont18(loopDepth);
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			StrictFuture<Void> __when_expr_11 = tr.onError(e);
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_11.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (now() - startTime > self->testDuration)
															#line 521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		{
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.01);
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __getRange_res1,int loopDepth) 
	{
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		getRange_res1 = __getRange_res1;
															#line 557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __getRange_res1,int loopDepth) 
	{
		getRange_res1 = std::move(__getRange_res1);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (getRange_randomStart)
															#line 636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		{
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			tr.set(getRange_startKey, getRange_newValue);
															#line 640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		}
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr.getRange(getRange_queryRange, GetRangeLimits(4000), snapshot, reverse);
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (getRange_randomStart)
															#line 660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		{
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			tr.set(getRange_startKey, getRange_newValue);
															#line 664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		}
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr.getRange(getRange_queryRange, GetRangeLimits(4000), snapshot, reverse);
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(RangeResult const& getRange_res2,int loopDepth) 
	{
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		ASSERT(getRange_res1.size() == getRange_res2.size());
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		for(int i = 0;i < getRange_res1.size();i++) {
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (getRange_res1[i].key != getRange_res2[i].key)
															#line 763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			{
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				TraceEvent(SevError, "MemoryLifetimeCheckKeyError") .detail("Key1", printable(getRange_res1[i].key)) .detail("Key2", printable(getRange_res2[i].key)) .detail("Value1", getRange_res1[i].value.size()) .detail("Value2", getRange_res2[i].value.size()) .detail("I", i) .detail("Size", getRange_res2.size());
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				ASSERT(false);
															#line 769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			}
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (getRange_res1[i].value != getRange_res2[i].value)
															#line 773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			{
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				TraceEvent(SevError, "MemoryLifetimeCheckValueError") .detail("Key1", printable(getRange_res1[i].key)) .detail("Key2", printable(getRange_res2[i].key)) .detail("Value1", getRange_res1[i].value.size()) .detail("Value2", getRange_res2[i].value.size()) .detail("I", i) .detail("Size", getRange_res2.size());
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				ASSERT(false);
															#line 779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(RangeResult && getRange_res2,int loopDepth) 
	{
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		ASSERT(getRange_res1.size() == getRange_res2.size());
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		for(int i = 0;i < getRange_res1.size();i++) {
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (getRange_res1[i].key != getRange_res2[i].key)
															#line 794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			{
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				TraceEvent(SevError, "MemoryLifetimeCheckKeyError") .detail("Key1", printable(getRange_res1[i].key)) .detail("Key2", printable(getRange_res2[i].key)) .detail("Value1", getRange_res1[i].value.size()) .detail("Value2", getRange_res2[i].value.size()) .detail("I", i) .detail("Size", getRange_res2.size());
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				ASSERT(false);
															#line 800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			}
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (getRange_res1[i].value != getRange_res2[i].value)
															#line 804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			{
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				TraceEvent(SevError, "MemoryLifetimeCheckValueError") .detail("Key1", printable(getRange_res1[i].key)) .detail("Key2", printable(getRange_res2[i].key)) .detail("Value1", getRange_res1[i].value.size()) .detail("Value2", getRange_res2[i].value.size()) .detail("I", i) .detail("Size", getRange_res2.size());
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				ASSERT(false);
															#line 810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(RangeResult const& getRange_res2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(getRange_res2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(RangeResult && getRange_res2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(getRange_res2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(int loopDepth) 
	{
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(0.01);
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont13when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Optional<Value> const& __get_res1,int loopDepth) 
	{
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		get_res1 = __get_res1;
															#line 920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Optional<Value> && __get_res1,int loopDepth) 
	{
		get_res1 = std::move(__get_res1);
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont13cont1(Void const& _,int loopDepth) 
	{
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (get_randomStart)
															#line 999 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		{
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			tr.set(get_startKey, get_newValue);
															#line 1003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		}
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr.get(get_startKey, snapshot);
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont13cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 1014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont13cont1(Void && _,int loopDepth) 
	{
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (get_randomStart)
															#line 1023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		{
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			tr.set(get_startKey, get_newValue);
															#line 1027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		}
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr.get(get_startKey, snapshot);
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont13cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 1038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont13cont2(Optional<Value> const& get_res2,int loopDepth) 
	{
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		ASSERT(get_res1 == get_res2);
															#line 1122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13cont2(Optional<Value> && get_res2,int loopDepth) 
	{
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		ASSERT(get_res1 == get_res2);
															#line 1131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13cont1when1(Optional<Value> const& get_res2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13cont2(get_res2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13cont1when1(Optional<Value> && get_res2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13cont2(std::move(get_res2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont13cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont13cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont15(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont16(int loopDepth) 
	{
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Void> __when_expr_7 = delay(0.01);
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont16when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 1230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when3(Key const& __getKey_res1,int loopDepth) 
	{
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		getKey_res1 = __getKey_res1;
															#line 1239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Key && __getKey_res1,int loopDepth) 
	{
		getKey_res1 = std::move(__getKey_res1);
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont16cont1(Void const& _,int loopDepth) 
	{
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (getKey_randomStart)
															#line 1318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		{
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			tr.set(getKey_selector.getKey(), getKey_newValue);
															#line 1322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		}
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Key> __when_expr_8 = tr.getKey(getKey_selector, snapshot);
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont16cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Key >*>(static_cast<_startActor*>(this)));
															#line 1333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont16cont1(Void && _,int loopDepth) 
	{
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (getKey_randomStart)
															#line 1342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		{
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			tr.set(getKey_selector.getKey(), getKey_newValue);
															#line 1346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		}
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Key> __when_expr_8 = tr.getKey(getKey_selector, snapshot);
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont16cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Key >*>(static_cast<_startActor*>(this)));
															#line 1357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont16when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont16when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont16cont2(Key const& getKey_res2,int loopDepth) 
	{
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		ASSERT(getKey_res1 == getKey_res2);
															#line 1441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont16cont2(Key && getKey_res2,int loopDepth) 
	{
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		ASSERT(getKey_res1 == getKey_res2);
															#line 1450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont16cont1when1(Key const& getKey_res2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16cont2(getKey_res2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont16cont1when1(Key && getKey_res2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16cont2(std::move(getKey_res2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont16cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont16cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1cont18(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19(int loopDepth) 
	{
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(0.01);
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1loopBody1cont19when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 1549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when4(Standalone<VectorRef<const char*>> const& __getAddress_res1,int loopDepth) 
	{
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		getAddress_res1 = __getAddress_res1;
															#line 1558 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Standalone<VectorRef<const char*>> && __getAddress_res1,int loopDepth) 
	{
		getAddress_res1 = std::move(__getAddress_res1);
		loopDepth = a_body1loopBody1cont19(loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >*,Standalone<VectorRef<const char*>> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >*,Standalone<VectorRef<const char*>> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1cont19cont1(Void const& _,int loopDepth) 
	{
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		for(int i = 0;i < getAddress_res1.size();i++) {
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			ASSERT(NetworkAddress::parseOptional(getAddress_res1[i]).present());
															#line 1639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19cont1(Void && _,int loopDepth) 
	{
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		for(int i = 0;i < getAddress_res1.size();i++) {
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			ASSERT(NetworkAddress::parseOptional(getAddress_res1[i]).present());
															#line 1651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont19when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont19when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1cont22(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Database cx;
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	MemoryLifetime* self;
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	double startTime;
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Reverse reverse;
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Snapshot snapshot;
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Key getRange_startKey;
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	KeyRange getRange_queryRange;
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	bool getRange_randomStart;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Value getRange_newValue;
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	RangeResult getRange_res1;
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Key get_startKey;
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	bool get_randomStart;
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Value get_newValue;
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Optional<Value> get_res1;
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	KeySelector getKey_selector;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	bool getKey_randomStart;
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Value getKey_newValue;
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Key getKey_res1;
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Key getAddress_startKey;
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Standalone<VectorRef<const char*>> getAddress_res1;
															#line 1874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, RangeResult >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, RangeResult >, public ActorCallback< _startActor, 3, Optional<Value> >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Optional<Value> >, public ActorCallback< _startActor, 6, Key >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Key >, public ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13322526038770087168UL, 6539089557530247424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, RangeResult >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, RangeResult >;
friend struct ActorCallback< _startActor, 3, Optional<Value> >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Optional<Value> >;
friend struct ActorCallback< _startActor, 6, Key >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Key >;
friend struct ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	_startActor(Database const& cx,MemoryLifetime* const& self) 
															#line 1907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Optional<Value> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Key >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Key >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, MemoryLifetime* const& self ) {
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MemoryLifetime.actor.g.cpp.py_gen"
}

#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
};

WorkloadFactory<MemoryLifetime> MemoryLifetimeWorkloadFactory;
