#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
/*
 * KVStoreTest.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <ctime>
#include <cinttypes>
#include "fdbclient/FDBTypes.h"
#include "fmt/format.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/IKeyValueStore.h"
#include "flow/ActorCollection.h"
#include "flow/actorcompiler.h" // This must be the last #include.

extern IKeyValueStore* makeDummyKeyValueStore();

template <class T>
class TestHistogram {
public:
	TestHistogram(int minSamples = 100) : minSamples(minSamples) { reset(); }

	void reset() {
		N = 0;
		samplingRate = 1.0;
		sum = T();
		sumSQ = T();
	};

	void addSample(const T& x) {
		if (!N) {
			minSample = maxSample = x;
		} else {
			if (x < minSample)
				minSample = x;
			if (maxSample < x)
				maxSample = x;
		}
		sum += x;
		sumSQ += x * x;
		N++;
		if (deterministicRandom()->random01() < samplingRate) {
			samples.push_back(x);
			if (samples.size() == minSamples * 2) {
				deterministicRandom()->randomShuffle(samples);
				samples.resize(minSamples);
				samplingRate /= 2;
			}
		}
	}
	//	void addHistogram(const Histrogram& h2);

	T mean() const { return sum * (1.0 / N); } // exact
	const T& min() const { return minSample; }
	const T& max() const { return maxSample; }
	T stdDev() const {
		if (!N)
			return T();
		return sqrt((sumSQ * N - sum * sum) * (1.0 / (N * (N - 1))));
	}
	T percentileEstimate(double p) {
		ASSERT(p <= 1 && p >= 0);
		int size = samples.size();
		if (!size)
			return T();
		if (size == 1)
			return samples[0];
		std::sort(samples.begin(), samples.end());
		double fi = p * double(size - 1);
		int li = p * double(size - 1);
		if (li == size - 1)
			return samples.back();
		double alpha = fi - li;
		return samples[li] * (1 - alpha) + samples[li + 1] * alpha;
	}
	T medianEstimate() { return percentileEstimate(0.5); }
	uint64_t samplesCount() const { return N; }

private:
	int minSamples;
	double samplingRate;
	std::vector<T> samples;
	T minSample;
	T maxSample;
	T sum;
	T sumSQ;
	uint64_t N;
};

struct KVTest {
	IKeyValueStore* store;
	Version startVersion;
	Version lastSet;
	Version lastCommit;
	Version lastDurable;
	Map<Key, IndexedSet<Version, NoMetric>> allSets;
	int nodeCount, keyBytes;
	bool dispose;

	explicit KVTest(int nodeCount, bool dispose, int keyBytes)
	  : store(nullptr), startVersion(Version(time(nullptr)) << 30), lastSet(startVersion), lastCommit(startVersion),
	    lastDurable(startVersion), nodeCount(nodeCount), keyBytes(keyBytes), dispose(dispose) {}
	~KVTest() { close(); }
	void close() {
		if (store) {
			TraceEvent("KVTestDestroy").log();
			if (dispose)
				store->dispose();
			else
				store->close();
			store = 0;
		}
	}

	Version get(KeyRef key, Version version) {
		auto s = allSets.find(key);
		if (s == allSets.end())
			return startVersion;
		auto& sets = s->value;
		auto it = sets.lastLessOrEqual(version);
		return it != sets.end() ? *it : startVersion;
	}
	void set(KeyValueRef kv) {
		store->set(kv);
		auto s = allSets.find(kv.key);
		if (s == allSets.end()) {
			allSets.insert(MapPair<Key, IndexedSet<Version, NoMetric>>(Key(kv.key), IndexedSet<Version, NoMetric>()));
			s = allSets.find(kv.key);
		}
		s->value.insert(lastSet, NoMetric());
	}

	Key randomKey() { return makeKey(deterministicRandom()->randomInt(0, nodeCount)); }
	Key makeKey(Version value) {
		Key k;
		((KeyRef&)k) = KeyRef(new (k.arena()) uint8_t[keyBytes], keyBytes);
		memcpy((uint8_t*)k.begin(), doubleToTestKey(value).begin(), 16);
		memset((uint8_t*)k.begin() + 16, '.', keyBytes - 16);
		return k;
	}
};

															#line 160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via testKVRead()
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
template <class TestKVReadActor>
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
class TestKVReadActorState {
															#line 167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
public:
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	TestKVReadActorState(KVTest* const& test,Key const& key,TestHistogram<float>* const& latency,PerfIntCounter* const& count) 
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		 : test(test),
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   key(key),
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   latency(latency),
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   count(count),
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   s2(test->lastDurable),
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   begin(timer())
															#line 184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testKVRead", reinterpret_cast<unsigned long>(this));

	}
	~TestKVReadActorState() 
	{
		fdb_probe_actor_destroy("testKVRead", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = test->store->readValue(key);
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			if (static_cast<TestKVReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestKVReadActor*>(this)->actor_wait_state = 1;
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestKVReadActor, 0, Optional<Value> >*>(static_cast<TestKVReadActor*>(this)));
															#line 206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestKVReadActorState();
		static_cast<TestKVReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		latency->addSample(timer() - begin);
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		++*count;
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		Version v = val.present() ? BinaryReader::fromStringRef<Version>(val.get(), Unversioned()) : test->startVersion;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (v < test->startVersion)
															#line 235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		{
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			v = test->startVersion;
															#line 239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		}
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		ASSERT(s2 <= v || test->get(key, s2) == v);
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		ASSERT(v <= test->lastCommit);
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (!static_cast<TestKVReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestKVReadActorState(); static_cast<TestKVReadActor*>(this)->destroy(); return 0; }
															#line 247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		new (&static_cast<TestKVReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestKVReadActorState();
		static_cast<TestKVReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		latency->addSample(timer() - begin);
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		++*count;
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		Version v = val.present() ? BinaryReader::fromStringRef<Version>(val.get(), Unversioned()) : test->startVersion;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (v < test->startVersion)
															#line 265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		{
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			v = test->startVersion;
															#line 269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		}
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		ASSERT(s2 <= v || test->get(key, s2) == v);
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		ASSERT(v <= test->lastCommit);
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (!static_cast<TestKVReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestKVReadActorState(); static_cast<TestKVReadActor*>(this)->destroy(); return 0; }
															#line 277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		new (&static_cast<TestKVReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestKVReadActorState();
		static_cast<TestKVReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestKVReadActor*>(this)->actor_wait_state > 0) static_cast<TestKVReadActor*>(this)->actor_wait_state = 0;
		static_cast<TestKVReadActor*>(this)->ActorCallback< TestKVReadActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestKVReadActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testKVRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestKVReadActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testKVRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestKVReadActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testKVRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVRead", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	KVTest* test;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	Key key;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	TestHistogram<float>* latency;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	PerfIntCounter* count;
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	Version s2;
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	double begin;
															#line 372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testKVRead()
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
class TestKVReadActor final : public Actor<Void>, public ActorCallback< TestKVReadActor, 0, Optional<Value> >, public FastAllocated<TestKVReadActor>, public TestKVReadActorState<TestKVReadActor> {
															#line 377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestKVReadActor>::operator new;
	using FastAllocated<TestKVReadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1618232414092803328UL, 11575141519739679744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestKVReadActor, 0, Optional<Value> >;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	TestKVReadActor(KVTest* const& test,Key const& key,TestHistogram<float>* const& latency,PerfIntCounter* const& count) 
															#line 394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestKVReadActorState<TestKVReadActor>(test, key, latency, count),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testKVRead", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2871252752891656448UL, 10950339809277749248UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testKVRead");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testKVRead", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestKVReadActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
[[nodiscard]] Future<Void> testKVRead( KVTest* const& test, Key const& key, TestHistogram<float>* const& latency, PerfIntCounter* const& count ) {
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	return Future<Void>(new TestKVReadActor(test, key, latency, count));
															#line 427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
}

#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"

															#line 432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via testKVReadSaturation()
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
template <class TestKVReadSaturationActor>
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
class TestKVReadSaturationActorState {
															#line 439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
public:
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	TestKVReadSaturationActorState(KVTest* const& test,TestHistogram<float>* const& latency,PerfIntCounter* const& count) 
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		 : test(test),
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   latency(latency),
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   count(count)
															#line 450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testKVReadSaturation", reinterpret_cast<unsigned long>(this));

	}
	~TestKVReadSaturationActorState() 
	{
		fdb_probe_actor_destroy("testKVReadSaturation", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			;
															#line 465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestKVReadSaturationActorState();
		static_cast<TestKVReadSaturationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		begin = timer();
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_0 = test->store->readValue(test->randomKey());
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (static_cast<TestKVReadSaturationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TestKVReadSaturationActor*>(this)->actor_wait_state = 1;
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestKVReadSaturationActor, 0, Optional<Value> >*>(static_cast<TestKVReadSaturationActor*>(this)));
															#line 504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		latency->addSample(timer() - begin);
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		++*count;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0);
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (static_cast<TestKVReadSaturationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestKVReadSaturationActor*>(this)->actor_wait_state = 2;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestKVReadSaturationActor, 1, Void >*>(static_cast<TestKVReadSaturationActor*>(this)));
															#line 524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		latency->addSample(timer() - begin);
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		++*count;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0);
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (static_cast<TestKVReadSaturationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestKVReadSaturationActor*>(this)->actor_wait_state = 2;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestKVReadSaturationActor, 1, Void >*>(static_cast<TestKVReadSaturationActor*>(this)));
															#line 544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestKVReadSaturationActor*>(this)->actor_wait_state > 0) static_cast<TestKVReadSaturationActor*>(this)->actor_wait_state = 0;
		static_cast<TestKVReadSaturationActor*>(this)->ActorCallback< TestKVReadSaturationActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestKVReadSaturationActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testKVReadSaturation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVReadSaturationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVReadSaturation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestKVReadSaturationActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testKVReadSaturation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVReadSaturationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVReadSaturation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestKVReadSaturationActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testKVReadSaturation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVReadSaturationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVReadSaturation", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestKVReadSaturationActor*>(this)->actor_wait_state > 0) static_cast<TestKVReadSaturationActor*>(this)->actor_wait_state = 0;
		static_cast<TestKVReadSaturationActor*>(this)->ActorCallback< TestKVReadSaturationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKVReadSaturationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKVReadSaturation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVReadSaturationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVReadSaturation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestKVReadSaturationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKVReadSaturation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVReadSaturationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVReadSaturation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestKVReadSaturationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKVReadSaturation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVReadSaturationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVReadSaturation", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	KVTest* test;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	TestHistogram<float>* latency;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	PerfIntCounter* count;
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	double begin;
															#line 719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testKVReadSaturation()
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
class TestKVReadSaturationActor final : public Actor<Void>, public ActorCallback< TestKVReadSaturationActor, 0, Optional<Value> >, public ActorCallback< TestKVReadSaturationActor, 1, Void >, public FastAllocated<TestKVReadSaturationActor>, public TestKVReadSaturationActorState<TestKVReadSaturationActor> {
															#line 724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestKVReadSaturationActor>::operator new;
	using FastAllocated<TestKVReadSaturationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17714775356534157824UL, 4935463740666505984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestKVReadSaturationActor, 0, Optional<Value> >;
friend struct ActorCallback< TestKVReadSaturationActor, 1, Void >;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	TestKVReadSaturationActor(KVTest* const& test,TestHistogram<float>* const& latency,PerfIntCounter* const& count) 
															#line 742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestKVReadSaturationActorState<TestKVReadSaturationActor>(test, latency, count),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testKVReadSaturation", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7135553902097122816UL, 10347452791315808512UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVReadSaturationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testKVReadSaturation");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testKVReadSaturation", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestKVReadSaturationActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestKVReadSaturationActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
[[nodiscard]] Future<Void> testKVReadSaturation( KVTest* const& test, TestHistogram<float>* const& latency, PerfIntCounter* const& count ) {
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	return Future<Void>(new TestKVReadSaturationActor(test, latency, count));
															#line 776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
}

#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"

															#line 781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via testKVCommit()
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
template <class TestKVCommitActor>
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
class TestKVCommitActorState {
															#line 788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
public:
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	TestKVCommitActorState(KVTest* const& test,TestHistogram<float>* const& latency,PerfIntCounter* const& count) 
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		 : test(test),
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   latency(latency),
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   count(count),
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   v(test->lastSet)
															#line 801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testKVCommit", reinterpret_cast<unsigned long>(this));

	}
	~TestKVCommitActorState() 
	{
		fdb_probe_actor_destroy("testKVCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			test->lastCommit = v;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			begin = timer();
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = test->store->commit();
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			if (static_cast<TestKVCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestKVCommitActor*>(this)->actor_wait_state = 1;
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestKVCommitActor, 0, Void >*>(static_cast<TestKVCommitActor*>(this)));
															#line 827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestKVCommitActorState();
		static_cast<TestKVCommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		++*count;
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		latency->addSample(timer() - begin);
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		test->lastDurable = std::max(test->lastDurable, v);
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (!static_cast<TestKVCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestKVCommitActorState(); static_cast<TestKVCommitActor*>(this)->destroy(); return 0; }
															#line 856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		new (&static_cast<TestKVCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestKVCommitActorState();
		static_cast<TestKVCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		++*count;
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		latency->addSample(timer() - begin);
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		test->lastDurable = std::max(test->lastDurable, v);
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (!static_cast<TestKVCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestKVCommitActorState(); static_cast<TestKVCommitActor*>(this)->destroy(); return 0; }
															#line 874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		new (&static_cast<TestKVCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestKVCommitActorState();
		static_cast<TestKVCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestKVCommitActor*>(this)->actor_wait_state > 0) static_cast<TestKVCommitActor*>(this)->actor_wait_state = 0;
		static_cast<TestKVCommitActor*>(this)->ActorCallback< TestKVCommitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKVCommitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKVCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestKVCommitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKVCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestKVCommitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKVCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVCommit", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	KVTest* test;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	TestHistogram<float>* latency;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	PerfIntCounter* count;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	Version v;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	double begin;
															#line 967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testKVCommit()
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
class TestKVCommitActor final : public Actor<Void>, public ActorCallback< TestKVCommitActor, 0, Void >, public FastAllocated<TestKVCommitActor>, public TestKVCommitActorState<TestKVCommitActor> {
															#line 972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestKVCommitActor>::operator new;
	using FastAllocated<TestKVCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(122419835034541568UL, 4418203656386415360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestKVCommitActor, 0, Void >;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	TestKVCommitActor(KVTest* const& test,TestHistogram<float>* const& latency,PerfIntCounter* const& count) 
															#line 989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestKVCommitActorState<TestKVCommitActor>(test, latency, count),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testKVCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11320462906625040896UL, 18108213029770065664UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testKVCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testKVCommit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestKVCommitActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
[[nodiscard]] Future<Void> testKVCommit( KVTest* const& test, TestHistogram<float>* const& latency, PerfIntCounter* const& count ) {
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	return Future<Void>(new TestKVCommitActor(test, latency, count));
															#line 1022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
}

#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"

Future<Void> testKVStore(struct KVStoreTestWorkload* const&);

struct KVStoreTestWorkload : TestWorkload {
	static constexpr auto NAME = "KVStoreTest";
	bool enabled, saturation;
	double testDuration, operationsPerSecond;
	double commitFraction, setFraction;
	int nodeCount, keyBytes, valueBytes;
	bool doSetup, doClear, doCount;
	std::string filename;
	PerfIntCounter reads, sets, commits;
	TestHistogram<float> readLatency, commitLatency;
	double setupTook;
	KeyValueStoreType storeType;

	KVStoreTestWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), reads("Reads"), sets("Sets"), commits("Commits"), setupTook(0) {
		enabled = !clientId; // only do this on the "first" client
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		operationsPerSecond = getOption(options, "operationsPerSecond"_sr, 100e3);
		commitFraction = getOption(options, "commitFraction"_sr, .001);
		setFraction = getOption(options, "setFraction"_sr, .1);
		nodeCount = getOption(options, "nodeCount"_sr, 100000);
		keyBytes = getOption(options, "keyBytes"_sr, 8);
		valueBytes = getOption(options, "valueBytes"_sr, 8);
		doSetup = getOption(options, "setup"_sr, false);
		doClear = getOption(options, "clear"_sr, false);
		doCount = getOption(options, "count"_sr, false);
		filename = getOption(options, "filename"_sr, Value()).toString();
		saturation = getOption(options, "saturation"_sr, false);
		storeType = KeyValueStoreType::fromString(getOption(options, "storeType"_sr, "ssd"_sr).toString());
	}
	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override {
		if (enabled)
			return testKVStore(this);
		return Void();
	}
	Future<bool> check(Database const& cx) override { return true; }
	void metricsFromHistogram(std::vector<PerfMetric>& m, std::string name, TestHistogram<float>& h) const {
		m.emplace_back("Min " + name, 1000.0 * h.min(), Averaged::True);
		m.emplace_back("Average " + name, 1000.0 * h.mean(), Averaged::True);
		m.emplace_back("Median " + name, 1000.0 * h.medianEstimate(), Averaged::True);
		m.emplace_back("95%% " + name, 1000.0 * h.percentileEstimate(0.95), Averaged::True);
		m.emplace_back("Max " + name, 1000.0 * h.max(), Averaged::True);
	}
	void getMetrics(std::vector<PerfMetric>& m) override {
		if (setupTook)
			m.emplace_back("SetupTook", setupTook, Averaged::False);

		m.push_back(reads.getMetric());
		m.push_back(sets.getMetric());
		m.push_back(commits.getMetric());
		metricsFromHistogram(m, "Read Latency (ms)", readLatency);
		metricsFromHistogram(m, "Commit Latency (ms)", commitLatency);
	}
};

WorkloadFactory<KVStoreTestWorkload> KVStoreTestWorkloadFactory;

															#line 1087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via testKVStoreMain()
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
template <class TestKVStoreMainActor>
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
class TestKVStoreMainActorState {
															#line 1094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
public:
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	TestKVStoreMainActorState(KVStoreTestWorkload* const& workload,KVTest* const& ptest) 
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		 : workload(workload),
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   ptest(ptest),
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   test(*ptest),
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   ac(),
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   reads(),
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   wr(Unversioned()),
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   commitsStarted(0),
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   extraBytes(workload->valueBytes - sizeof(test.lastSet)),
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   i()
															#line 1117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testKVStoreMain", reinterpret_cast<unsigned long>(this));

	}
	~TestKVStoreMainActorState() 
	{
		fdb_probe_actor_destroy("testKVStoreMain", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			ASSERT(extraBytes >= 0);
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			extraValue = new char[extraBytes];
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			memset(extraValue, '.', extraBytes);
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			if (workload->doCount)
															#line 1138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				count = 0;
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				k = Key();
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				cst = timer();
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				;
															#line 1148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestKVStoreMainActorState();
		static_cast<TestKVStoreMainActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (workload->doSetup)
															#line 1176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		{
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			wr << Version(0);
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			wr.serializeBytes(extraValue, extraBytes);
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			printf("Building %d nodes: ", workload->nodeCount);
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			setupBegin = timer();
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			lastCommit = Void();
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			i = 0;
															#line 1190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		double elapsed = timer() - cst;
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		TraceEvent("KVStoreCount").detail("Count", count).detail("Took", elapsed);
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		fmt::print("Counted: {0} in {1:0.1f}s\n", count, elapsed);
															#line 1208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = test.store->readRange(KeyRangeRef(k, "\xff\xff\xff\xff"_sr), 1000);
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (static_cast<TestKVStoreMainActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TestKVStoreMainActor*>(this)->actor_wait_state = 1;
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestKVStoreMainActor, 0, RangeResult >*>(static_cast<TestKVStoreMainActor*>(this)));
															#line 1231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult const& kv,int loopDepth) 
	{
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		count += kv.size();
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (kv.size() < 1000)
															#line 1255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		k = keyAfter(kv[kv.size() - 1].key);
															#line 1261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult && kv,int loopDepth) 
	{
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		count += kv.size();
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (kv.size() < 1000)
															#line 1272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		k = keyAfter(kv[kv.size() - 1].key);
															#line 1278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& kv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(kv, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && kv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(kv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestKVStoreMainActor*>(this)->actor_wait_state > 0) static_cast<TestKVStoreMainActor*>(this)->actor_wait_state = 0;
		static_cast<TestKVStoreMainActor*>(this)->ActorCallback< TestKVStoreMainActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestKVStoreMainActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestKVStoreMainActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestKVStoreMainActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		t = now();
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		stopAt = t + workload->testDuration;
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (workload->saturation)
															#line 1366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		{
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			if (workload->commitFraction)
															#line 1370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			{
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				;
															#line 1374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
				loopDepth = a_body1cont4loopHead1(loopDepth);
			}
			else
			{
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				std::vector<Future<Void>> actors;
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				actors.reserve(100);
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				for(int a = 0;a < 100;a++) {
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
					actors.push_back(testKVReadSaturation(&test, &workload->readLatency, &workload->reads));
															#line 1387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
				}
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				StrictFuture<Void> __when_expr_4 = timeout(waitForAll(actors), workload->testDuration, Void());
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				if (static_cast<TestKVStoreMainActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
				static_cast<TestKVStoreMainActor*>(this)->actor_wait_state = 5;
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestKVStoreMainActor, 4, Void >*>(static_cast<TestKVStoreMainActor*>(this)));
															#line 1398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		else
		{
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			;
															#line 1406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			loopDepth = a_body1cont4loopHead2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = lastCommit;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (static_cast<TestKVStoreMainActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestKVStoreMainActor*>(this)->actor_wait_state = 3;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestKVStoreMainActor, 2, Void >*>(static_cast<TestKVStoreMainActor*>(this)));
															#line 1423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (!(i < workload->nodeCount))
															#line 1439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		test.store->set(KeyValueRef(test.makeKey(i), wr.toValue()));
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (!((i + 1) % 10000) || i + 1 == workload->nodeCount)
															#line 1447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		{
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_1 = lastCommit;
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			if (static_cast<TestKVStoreMainActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestKVStoreMainActor*>(this)->actor_wait_state = 2;
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestKVStoreMainActor, 1, Void >*>(static_cast<TestKVStoreMainActor*>(this)));
															#line 1458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		i++;
															#line 1485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		lastCommit = test.store->commit();
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		printf("ETA: %f seconds\n", (timer() - setupBegin) / i * (workload->nodeCount - i));
															#line 1496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		lastCommit = test.store->commit();
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		printf("ETA: %f seconds\n", (timer() - setupBegin) / i * (workload->nodeCount - i));
															#line 1507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestKVStoreMainActor*>(this)->actor_wait_state > 0) static_cast<TestKVStoreMainActor*>(this)->actor_wait_state = 0;
		static_cast<TestKVStoreMainActor*>(this)->ActorCallback< TestKVStoreMainActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKVStoreMainActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestKVStoreMainActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestKVStoreMainActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		workload->setupTook = timer() - setupBegin;
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		TraceEvent("KVStoreSetup").detail("Count", workload->nodeCount).detail("Took", workload->setupTook);
															#line 1593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		workload->setupTook = timer() - setupBegin;
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		TraceEvent("KVStoreSetup").detail("Count", workload->nodeCount).detail("Took", workload->setupTook);
															#line 1604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestKVStoreMainActor*>(this)->actor_wait_state > 0) static_cast<TestKVStoreMainActor*>(this)->actor_wait_state = 0;
		static_cast<TestKVStoreMainActor*>(this)->ActorCallback< TestKVStoreMainActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKVStoreMainActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestKVStoreMainActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestKVStoreMainActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (workload->doClear)
															#line 1688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		{
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			chunk = 1000000;
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			t = timer();
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			i = 0;
															#line 1696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			loopDepth = a_body1cont8loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont14(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (!(now() < stopAt))
															#line 1729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		for(int s = 0;s < 1 / workload->commitFraction;s++) {
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			++test.lastSet;
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			BinaryWriter wr(Unversioned());
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			wr << test.lastSet;
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			wr.serializeBytes(extraValue, extraBytes);
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			test.set(KeyValueRef(test.randomKey(), wr.toValue()));
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			++workload->sets;
															#line 1747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		}
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		++commitsStarted;
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		StrictFuture<Void> __when_expr_3 = testKVCommit(&test, &workload->commitLatency, &workload->commits);
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (static_cast<TestKVStoreMainActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestKVStoreMainActor*>(this)->actor_wait_state = 4;
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestKVStoreMainActor, 3, Void >*>(static_cast<TestKVStoreMainActor*>(this)));
															#line 1760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestKVStoreMainActor*>(this)->actor_wait_state > 0) static_cast<TestKVStoreMainActor*>(this)->actor_wait_state = 0;
		static_cast<TestKVStoreMainActor*>(this)->ActorCallback< TestKVStoreMainActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKVStoreMainActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestKVStoreMainActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestKVStoreMainActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestKVStoreMainActor*>(this)->actor_wait_state > 0) static_cast<TestKVStoreMainActor*>(this)->actor_wait_state = 0;
		static_cast<TestKVStoreMainActor*>(this)->ActorCallback< TestKVStoreMainActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKVStoreMainActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestKVStoreMainActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestKVStoreMainActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont13(int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopHead2(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody2(int loopDepth) 
	{
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (!(t < stopAt))
															#line 1969 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		{
			return a_body1cont4break2(loopDepth==0?0:loopDepth-1); // break
		}
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		double end = now();
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		for(;;) {
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			t += 1.0 / workload->operationsPerSecond;
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			double op = deterministicRandom()->random01();
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			if (op < workload->commitFraction)
															#line 1983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			{
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				if (workload->commits.getValue() == commitsStarted)
															#line 1987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
				{
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
					++commitsStarted;
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
					ac.add(testKVCommit(&test, &workload->commitLatency, &workload->commits));
															#line 1993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				if (op < workload->commitFraction + workload->setFraction)
															#line 2000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
				{
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
					++test.lastSet;
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
					BinaryWriter wr(Unversioned());
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
					wr << test.lastSet;
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
					wr.serializeBytes(extraValue, extraBytes);
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
					test.set(KeyValueRef(test.randomKey(), wr.toValue()));
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
					++workload->sets;
															#line 2014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
				}
				else
				{
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
					ac.add(testKVRead(&test, test.randomKey(), &workload->readLatency, &workload->reads));
															#line 2020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
				}
			}
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			if (t >= end)
															#line 2025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			{
				break;
			}
		}
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delayUntil(t);
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (static_cast<TestKVStoreMainActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody2when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestKVStoreMainActor*>(this)->actor_wait_state = 6;
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestKVStoreMainActor, 5, Void >*>(static_cast<TestKVStoreMainActor*>(this)));
															#line 2039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break2(int loopDepth) 
	{
		try {
			return a_body1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody2cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead2(0);

		return loopDepth;
	}
	int a_body1cont4loopBody2cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead2(0);

		return loopDepth;
	}
	int a_body1cont4loopBody2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestKVStoreMainActor*>(this)->actor_wait_state > 0) static_cast<TestKVStoreMainActor*>(this)->actor_wait_state = 0;
		static_cast<TestKVStoreMainActor*>(this)->ActorCallback< TestKVStoreMainActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKVStoreMainActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4loopBody2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestKVStoreMainActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4loopBody2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestKVStoreMainActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont14(int loopDepth) 
	{
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (!static_cast<TestKVStoreMainActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestKVStoreMainActorState(); static_cast<TestKVStoreMainActor*>(this)->destroy(); return 0; }
															#line 2148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		new (&static_cast<TestKVStoreMainActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestKVStoreMainActorState();
		static_cast<TestKVStoreMainActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont15(int loopDepth) 
	{
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		TraceEvent("KVStoreClear").detail("Took", timer() - t);
															#line 2160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont8loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1(int loopDepth) 
	{
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (!(i < workload->nodeCount))
															#line 2176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		{
			return a_body1cont8break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		test.store->clear(KeyRangeRef(test.makeKey(i), test.makeKey(i + chunk)));
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		StrictFuture<Void> __when_expr_6 = test.store->commit();
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (static_cast<TestKVStoreMainActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont8loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestKVStoreMainActor*>(this)->actor_wait_state = 7;
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestKVStoreMainActor, 6, Void >*>(static_cast<TestKVStoreMainActor*>(this)));
															#line 2191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8break1(int loopDepth) 
	{
		try {
			return a_body1cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		i += chunk;
															#line 2213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont8loopHead1(0);

		return loopDepth;
	}
	int a_body1cont8loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		i += chunk;
															#line 2222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont8loopHead1(0);

		return loopDepth;
	}
	int a_body1cont8loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestKVStoreMainActor*>(this)->actor_wait_state > 0) static_cast<TestKVStoreMainActor*>(this)->actor_wait_state = 0;
		static_cast<TestKVStoreMainActor*>(this)->ActorCallback< TestKVStoreMainActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKVStoreMainActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestKVStoreMainActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestKVStoreMainActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	KVStoreTestWorkload* workload;
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	KVTest* ptest;
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	KVTest& test;
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	ActorCollectionNoErrors ac;
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	std::deque<Future<Void>> reads;
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	BinaryWriter wr;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	int64_t commitsStarted;
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	int extraBytes;
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	int i;
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	char* extraValue;
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	int64_t count;
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	Key k;
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	double cst;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	double setupBegin;
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	Future<Void> lastCommit;
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	double t;
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	double stopAt;
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	int chunk;
															#line 2338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testKVStoreMain()
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
class TestKVStoreMainActor final : public Actor<Void>, public ActorCallback< TestKVStoreMainActor, 0, RangeResult >, public ActorCallback< TestKVStoreMainActor, 1, Void >, public ActorCallback< TestKVStoreMainActor, 2, Void >, public ActorCallback< TestKVStoreMainActor, 3, Void >, public ActorCallback< TestKVStoreMainActor, 4, Void >, public ActorCallback< TestKVStoreMainActor, 5, Void >, public ActorCallback< TestKVStoreMainActor, 6, Void >, public FastAllocated<TestKVStoreMainActor>, public TestKVStoreMainActorState<TestKVStoreMainActor> {
															#line 2343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestKVStoreMainActor>::operator new;
	using FastAllocated<TestKVStoreMainActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10948100167577165056UL, 6887939005050925056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestKVStoreMainActor, 0, RangeResult >;
friend struct ActorCallback< TestKVStoreMainActor, 1, Void >;
friend struct ActorCallback< TestKVStoreMainActor, 2, Void >;
friend struct ActorCallback< TestKVStoreMainActor, 3, Void >;
friend struct ActorCallback< TestKVStoreMainActor, 4, Void >;
friend struct ActorCallback< TestKVStoreMainActor, 5, Void >;
friend struct ActorCallback< TestKVStoreMainActor, 6, Void >;
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	TestKVStoreMainActor(KVStoreTestWorkload* const& workload,KVTest* const& ptest) 
															#line 2366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestKVStoreMainActorState<TestKVStoreMainActor>(workload, ptest),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testKVStoreMain", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14088039191401583104UL, 15807129450243871744UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testKVStoreMain");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testKVStoreMain", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestKVStoreMainActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestKVStoreMainActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestKVStoreMainActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestKVStoreMainActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestKVStoreMainActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestKVStoreMainActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestKVStoreMainActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
[[nodiscard]] Future<Void> testKVStoreMain( KVStoreTestWorkload* const& workload, KVTest* const& ptest ) {
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	return Future<Void>(new TestKVStoreMainActor(workload, ptest));
															#line 2405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
}

#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"

															#line 2410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via testKVStore()
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
template <class TestKVStoreActor>
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
class TestKVStoreActorState {
															#line 2417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
public:
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	TestKVStoreActorState(KVStoreTestWorkload* const& workload) 
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		 : workload(workload),
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   test(workload->nodeCount, !workload->filename.size(), workload->keyBytes),
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		   err()
															#line 2428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testKVStore", reinterpret_cast<unsigned long>(this));

	}
	~TestKVStoreActorState() 
	{
		fdb_probe_actor_destroy("testKVStore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			TraceEvent("GO").log();
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			UID id = deterministicRandom()->randomUniqueID();
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			std::string fn = workload->filename.size() ? workload->filename : id.toString();
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			if (workload->storeType == KeyValueStoreType::SSD_BTREE_V2)
															#line 2449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			{
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				test.store = keyValueStoreSQLite(fn, id, KeyValueStoreType::SSD_BTREE_V2);
															#line 2453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			}
			else
			{
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
				if (workload->storeType == KeyValueStoreType::SSD_BTREE_V1)
															#line 2459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
				{
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
					test.store = keyValueStoreSQLite(fn, id, KeyValueStoreType::SSD_BTREE_V1);
															#line 2463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
				}
				else
				{
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
					if (workload->storeType == KeyValueStoreType::SSD_REDWOOD_V1)
															#line 2469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
					{
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
						test.store = keyValueStoreRedwoodV1(fn, id);
															#line 2473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
					}
					else
					{
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
						if (workload->storeType == KeyValueStoreType::SSD_ROCKSDB_V1)
															#line 2479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
						{
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
							test.store = keyValueStoreRocksDB(fn, id, KeyValueStoreType::SSD_ROCKSDB_V1);
															#line 2483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
						}
						else
						{
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
							if (workload->storeType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 2489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
							{
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
								test.store = keyValueStoreRocksDB( fn, id, KeyValueStoreType::SSD_SHARDED_ROCKSDB);
															#line 2493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
							}
							else
							{
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
								if (workload->storeType == KeyValueStoreType::MEMORY)
															#line 2499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
								{
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
									test.store = keyValueStoreMemory(fn, id, 500e6);
															#line 2503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
								}
								else
								{
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
									if (workload->storeType == KeyValueStoreType::MEMORY_RADIXTREE)
															#line 2509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
									{
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
										test.store = keyValueStoreMemory(fn, id, 500e6, "fdr", KeyValueStoreType::MEMORY_RADIXTREE);
															#line 2513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
									}
									else
									{
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
										ASSERT(false);
															#line 2519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
									}
								}
							}
						}
					}
				}
			}
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = test.store->init();
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			if (static_cast<TestKVStoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestKVStoreActor*>(this)->actor_wait_state = 1;
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestKVStoreActor, 0, Void >*>(static_cast<TestKVStoreActor*>(this)));
															#line 2536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestKVStoreActorState();
		static_cast<TestKVStoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		main = testKVStoreMain(workload, &test);
															#line 2559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		try {
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_1 = main;
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			if (static_cast<TestKVStoreActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_2 = test.store->getError();
															#line 2569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<TestKVStoreActor*>(this)->actor_wait_state = 2;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestKVStoreActor, 1, Void >*>(static_cast<TestKVStoreActor*>(this)));
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestKVStoreActor, 2, Void >*>(static_cast<TestKVStoreActor*>(this)));
															#line 2576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		main = testKVStoreMain(workload, &test);
															#line 2591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		try {
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_1 = main;
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			if (static_cast<TestKVStoreActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_2 = test.store->getError();
															#line 2601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<TestKVStoreActor*>(this)->actor_wait_state = 2;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestKVStoreActor, 1, Void >*>(static_cast<TestKVStoreActor*>(this)));
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestKVStoreActor, 2, Void >*>(static_cast<TestKVStoreActor*>(this)));
															#line 2608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestKVStoreActor*>(this)->actor_wait_state > 0) static_cast<TestKVStoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestKVStoreActor*>(this)->ActorCallback< TestKVStoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKVStoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKVStore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestKVStoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKVStore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestKVStoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKVStore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont16(int loopDepth) 
	{
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		main.cancel();
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		Future<Void> c = test.store->onClosed();
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		test.close();
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		StrictFuture<Void> __when_expr_3 = c;
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (static_cast<TestKVStoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont16when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestKVStoreActor*>(this)->actor_wait_state = 3;
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestKVStoreActor, 3, Void >*>(static_cast<TestKVStoreActor*>(this)));
															#line 2711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			err = e;
															#line 2721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
			loopDepth = a_body1cont16(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont17(int loopDepth) 
	{
		loopDepth = a_body1cont17cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		ASSERT(false);
															#line 2754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = a_body1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		ASSERT(false);
															#line 2763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		loopDepth = a_body1cont17(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestKVStoreActor*>(this)->actor_wait_state > 0) static_cast<TestKVStoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestKVStoreActor*>(this)->ActorCallback< TestKVStoreActor, 1, Void >::remove();
		static_cast<TestKVStoreActor*>(this)->ActorCallback< TestKVStoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKVStoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKVStore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestKVStoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKVStore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestKVStoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKVStore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestKVStoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKVStore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestKVStoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKVStore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestKVStoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKVStore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont17cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont16(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16cont1(Void const& _,int loopDepth) 
	{
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (err.code() != invalid_error_code)
															#line 2906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		{
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			return a_body1Catch1(err, loopDepth);
															#line 2910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		}
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (!static_cast<TestKVStoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestKVStoreActorState(); static_cast<TestKVStoreActor*>(this)->destroy(); return 0; }
															#line 2914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		new (&static_cast<TestKVStoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestKVStoreActorState();
		static_cast<TestKVStoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16cont1(Void && _,int loopDepth) 
	{
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (err.code() != invalid_error_code)
															#line 2926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		{
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
			return a_body1Catch1(err, loopDepth);
															#line 2930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		}
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
		if (!static_cast<TestKVStoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestKVStoreActorState(); static_cast<TestKVStoreActor*>(this)->destroy(); return 0; }
															#line 2934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		new (&static_cast<TestKVStoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestKVStoreActorState();
		static_cast<TestKVStoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestKVStoreActor*>(this)->actor_wait_state > 0) static_cast<TestKVStoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestKVStoreActor*>(this)->ActorCallback< TestKVStoreActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKVStoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKVStore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestKVStoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKVStore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestKVStoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKVStore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKVStore", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	KVStoreTestWorkload* workload;
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	KVTest test;
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	Error err;
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	Future<Void> main;
															#line 3025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testKVStore()
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
class TestKVStoreActor final : public Actor<Void>, public ActorCallback< TestKVStoreActor, 0, Void >, public ActorCallback< TestKVStoreActor, 1, Void >, public ActorCallback< TestKVStoreActor, 2, Void >, public ActorCallback< TestKVStoreActor, 3, Void >, public FastAllocated<TestKVStoreActor>, public TestKVStoreActorState<TestKVStoreActor> {
															#line 3030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestKVStoreActor>::operator new;
	using FastAllocated<TestKVStoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6891111503677110272UL, 12194052548935998208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestKVStoreActor, 0, Void >;
friend struct ActorCallback< TestKVStoreActor, 1, Void >;
friend struct ActorCallback< TestKVStoreActor, 2, Void >;
friend struct ActorCallback< TestKVStoreActor, 3, Void >;
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	TestKVStoreActor(KVStoreTestWorkload* const& workload) 
															#line 3050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestKVStoreActorState<TestKVStoreActor>(workload),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testKVStore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14671514680122421504UL, 16603653526724072192UL);
		ActorExecutionContextHelper __helper(static_cast<TestKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testKVStore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testKVStore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestKVStoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestKVStoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestKVStoreActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
[[nodiscard]] Future<Void> testKVStore( KVStoreTestWorkload* const& workload ) {
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
	return Future<Void>(new TestKVStoreActor(workload));
															#line 3085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/KVStoreTest.actor.g.cpp.py_gen"
}

#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/KVStoreTest.actor.cpp"
