#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
/*
 * FileSystem.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/DDSketch.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct FileSystemWorkload : TestWorkload {
	static constexpr auto NAME = "FileSystem";
	int actorCount, writeActorCount, fileCount, pathMinChars, pathCharRange, serverCount, userIDCount;
	double testDuration, transactionsPerSecond, deletedFilesRatio;
	bool discardEdgeMeasurements, performingWrites, loggingQueries;
	std::string operationName;

	std::vector<Future<Void>> clients;
	PerfIntCounter queries, writes;
	DDSketch<double> latencies;
	DDSketch<double> writeLatencies;

	class FileSystemOp {
	public:
		virtual Future<Optional<Version>> run(FileSystemWorkload* self, Transaction* tr) = 0;
		virtual const char* name() = 0;
		virtual ~FileSystemOp() {}
	};

	FileSystemWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), queries("Queries"), writes("Latency"), latencies(), writeLatencies() {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 5000.0) / clientCount;
		double allowedLatency = getOption(options, "allowedLatency"_sr, 0.250);
		actorCount = transactionsPerSecond * allowedLatency;
		fileCount = getOption(options, "fileCount"_sr, 100000);
		pathMinChars = std::max(getOption(options, "pathMinChars"_sr, 32), 8);
		pathCharRange = std::max(getOption(options, "pathMaxChars"_sr, 128), pathMinChars) - pathMinChars;
		discardEdgeMeasurements = getOption(options, "discardEdgeMeasurements"_sr, true);
		deletedFilesRatio = getOption(options, "deletedFilesRatio"_sr, 0.01);
		serverCount = getOption(options, "serverCount"_sr, 32);
		userIDCount = getOption(options, "userIDCount"_sr, std::max(100, fileCount / 3000));
		operationName = getOption(options, "operationName"_sr, "modificationQuery"_sr).toString();
		performingWrites = getOption(options, "performingWrites"_sr, false);
		writeActorCount = getOption(options, "writeActorCount"_sr, 4);
		loggingQueries = getOption(options, "loggingQueries"_sr, false);
	}

	Future<Void> setup(Database const& cx) override { return nodeSetup(cx, this); }

	Future<Void> start(Database const& cx) override { return _start(cx, this); }

	Future<bool> check(Database const& cx) override {
		clients.clear();
		return true;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		double duration = testDuration * (discardEdgeMeasurements ? 0.75 : 1.0);
		m.emplace_back("Measured Duration", duration, Averaged::True);
		m.emplace_back("Transactions/sec", queries.getValue() / duration, Averaged::False);
		m.emplace_back("Writes/sec", writes.getValue() / duration, Averaged::False);
		m.emplace_back("Mean Latency (ms)", 1000 * latencies.mean(), Averaged::True);
		m.emplace_back("Median Latency (ms, averaged)", 1000 * latencies.median(), Averaged::True);
		m.emplace_back("90% Latency (ms, averaged)", 1000 * latencies.percentile(0.90), Averaged::True);
		m.emplace_back("98% Latency (ms, averaged)", 1000 * latencies.percentile(0.98), Averaged::True);
		m.emplace_back("Median Write Latency (ms, averaged)", 1000 * writeLatencies.median(), Averaged::True);
	}

	Key keyForFileID(uint64_t id) { return StringRef(format("/files/id/%016llx", id)); }

	void initializeFile(Transaction* tr, FileSystemWorkload* self, uint64_t id) {
		Key key = self->keyForFileID(id);

		int pathLen = self->pathMinChars + deterministicRandom()->randomInt(0, self->pathCharRange);
		std::string path = "";
		for (int i = 0; i < pathLen; i += 4)
			path +=
			    format(format("%%0%dx", std::min(pathLen - i, 4)).c_str(), deterministicRandom()->randomInt(0, 0xFFFF));
		uint64_t userID = deterministicRandom()->randomInt(0, self->userIDCount);
		int serverID = deterministicRandom()->randomInt(0, self->serverCount);
		bool deleted = deterministicRandom()->random01() < self->deletedFilesRatio;
		double time = now();

		tr->set(key, path);
		std::string keyStr(key.toString());
		tr->set(keyStr + "/size", format("%d", deterministicRandom()->randomInt(0, std::numeric_limits<int>::max())));
		tr->set(keyStr + "/server", format("%d", deterministicRandom()->randomInt(0, self->serverCount)));
		tr->set(keyStr + "/deleted", deleted ? "1"_sr : "0"_sr);
		tr->set(keyStr + "/server", format("%d", serverID));
		tr->set(keyStr + "/created", doubleToTestKey(time));
		tr->set(keyStr + "/lastupdated", doubleToTestKey(time));
		tr->set(keyStr + "/userid", format("%016llx", userID));

		if (deleted)
			tr->set(format("/files/server/%08x/deleted/%016llx", serverID, id), doubleToTestKey(time));
		tr->set(format("/files/user/%016llx/updated/%016llx/%016llx", userID, *(uint64_t*)&time, id), path);
		tr->set(format("/files/user/%016llx/path/", userID) + path, format("%016llx", id));
		// This index was not specified in the original test: it removes duplicated paths
		tr->set("/files/path/" + path, format("%016llx", id));
	}

																#line 121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via setupRange()
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
template <class SetupRangeActor>
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
class SetupRangeActorState {
															#line 127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
public:
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	SetupRangeActorState(Database const& cx,FileSystemWorkload* const& self,int const& begin,int const& end) 
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		 : cx(cx),
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   self(self),
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   begin(begin),
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   end(end),
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   tr(cx)
															#line 142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("setupRange", reinterpret_cast<unsigned long>(this));

	}
	~SetupRangeActorState() 
	{
		fdb_probe_actor_destroy("setupRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			;
															#line 157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupRangeActorState();
		static_cast<SetupRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (!static_cast<SetupRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupRangeActorState(); static_cast<SetupRangeActor*>(this)->destroy(); return 0; }
															#line 180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		new (&static_cast<SetupRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupRangeActorState();
		static_cast<SetupRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(self->keyForFileID(begin));
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			if (static_cast<SetupRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupRangeActor*>(this)->actor_wait_state = 1;
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupRangeActor, 0, Optional<Value> >*>(static_cast<SetupRangeActor*>(this)));
															#line 207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			if (static_cast<SetupRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SetupRangeActor*>(this)->actor_wait_state = 3;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetupRangeActor, 2, Void >*>(static_cast<SetupRangeActor*>(this)));
															#line 249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& f,int loopDepth) 
	{
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (f.present())
															#line 264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		for(int n = begin;n < end;n++) {
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			self->initializeFile(&tr, self, n);
															#line 272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		}
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (static_cast<SetupRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetupRangeActor*>(this)->actor_wait_state = 2;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetupRangeActor, 1, Void >*>(static_cast<SetupRangeActor*>(this)));
															#line 283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && f,int loopDepth) 
	{
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (f.present())
															#line 292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		for(int n = begin;n < end;n++) {
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			self->initializeFile(&tr, self, n);
															#line 300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		}
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (static_cast<SetupRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetupRangeActor*>(this)->actor_wait_state = 2;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetupRangeActor, 1, Void >*>(static_cast<SetupRangeActor*>(this)));
															#line 311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(f, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupRangeActor*>(this)->actor_wait_state > 0) static_cast<SetupRangeActor*>(this)->actor_wait_state = 0;
		static_cast<SetupRangeActor*>(this)->ActorCallback< SetupRangeActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< SetupRangeActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupRangeActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupRangeActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetupRangeActor*>(this)->actor_wait_state > 0) static_cast<SetupRangeActor*>(this)->actor_wait_state = 0;
		static_cast<SetupRangeActor*>(this)->ActorCallback< SetupRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetupRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetupRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SetupRangeActor*>(this)->actor_wait_state > 0) static_cast<SetupRangeActor*>(this)->actor_wait_state = 0;
		static_cast<SetupRangeActor*>(this)->ActorCallback< SetupRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SetupRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SetupRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	Database cx;
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	FileSystemWorkload* self;
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	int begin;
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	int end;
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	Transaction tr;
															#line 575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via setupRange()
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
class SetupRangeActor final : public Actor<Void>, public ActorCallback< SetupRangeActor, 0, Optional<Value> >, public ActorCallback< SetupRangeActor, 1, Void >, public ActorCallback< SetupRangeActor, 2, Void >, public FastAllocated<SetupRangeActor>, public SetupRangeActorState<SetupRangeActor> {
															#line 580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<SetupRangeActor>::operator new;
	using FastAllocated<SetupRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3839084300488014848UL, 10502369180087203328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupRangeActor, 0, Optional<Value> >;
friend struct ActorCallback< SetupRangeActor, 1, Void >;
friend struct ActorCallback< SetupRangeActor, 2, Void >;
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	SetupRangeActor(Database const& cx,FileSystemWorkload* const& self,int const& begin,int const& end) 
															#line 599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SetupRangeActorState<SetupRangeActor>(cx, self, begin, end),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(919425258501996032UL, 177333446925881344UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setupRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupRangeActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetupRangeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SetupRangeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
[[nodiscard]] Future<Void> setupRange( Database const& cx, FileSystemWorkload* const& self, int const& begin, int const& end ) {
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	return Future<Void>(new SetupRangeActor(cx, self, begin, end));
															#line 633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
}

#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"

																#line 638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via nodeSetup()
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
template <class NodeSetupActor>
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
class NodeSetupActorState {
															#line 644 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
public:
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	NodeSetupActorState(Database const& cx,FileSystemWorkload* const& self) 
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		 : cx(cx),
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   self(self),
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   i(),
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   order(),
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   nodesToSetUp(self->fileCount / self->clientCount + 1),
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   startingNode(nodesToSetUp * self->clientId),
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   batchCount(5)
															#line 663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("nodeSetup", reinterpret_cast<unsigned long>(this));

	}
	~NodeSetupActorState() 
	{
		fdb_probe_actor_destroy("nodeSetup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			for(int o = 0;o <= nodesToSetUp / batchCount;o++) {
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
				order.push_back(o * batchCount);
															#line 680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			}
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			deterministicRandom()->randomShuffle(order);
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			i = 0;
															#line 686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NodeSetupActorState();
		static_cast<NodeSetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		TraceEvent("FileSetupOK") .detail("ClientIdx", self->clientId) .detail("ClientCount", self->clientCount) .detail("StartingFile", startingNode) .detail("FilesToSetUp", nodesToSetUp);
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (!static_cast<NodeSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NodeSetupActorState(); static_cast<NodeSetupActor*>(this)->destroy(); return 0; }
															#line 711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		new (&static_cast<NodeSetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NodeSetupActorState();
		static_cast<NodeSetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (!(i < order.size()))
															#line 730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		std::vector<Future<Void>> fs;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		for(int j = 0;j < 100 && i < order.size();j++) {
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			fs.push_back(self->setupRange( cx, self, startingNode + order[i], std::min(startingNode + order[i] + batchCount, nodesToSetUp * (self->clientId + 1))));
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			i++;
															#line 742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		}
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitForAll(fs);
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (static_cast<NodeSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<NodeSetupActor*>(this)->actor_wait_state = 1;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NodeSetupActor, 0, Void >*>(static_cast<NodeSetupActor*>(this)));
															#line 753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NodeSetupActor*>(this)->actor_wait_state > 0) static_cast<NodeSetupActor*>(this)->actor_wait_state = 0;
		static_cast<NodeSetupActor*>(this)->ActorCallback< NodeSetupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NodeSetupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("nodeSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NodeSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("nodeSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NodeSetupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("nodeSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NodeSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("nodeSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NodeSetupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("nodeSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NodeSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("nodeSetup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	Database cx;
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	FileSystemWorkload* self;
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	int i;
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	std::vector<int> order;
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	int nodesToSetUp;
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	int startingNode;
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	int batchCount;
															#line 872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via nodeSetup()
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
class NodeSetupActor final : public Actor<Void>, public ActorCallback< NodeSetupActor, 0, Void >, public FastAllocated<NodeSetupActor>, public NodeSetupActorState<NodeSetupActor> {
															#line 877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<NodeSetupActor>::operator new;
	using FastAllocated<NodeSetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16165900386064641792UL, 6114080948306676992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NodeSetupActor, 0, Void >;
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	NodeSetupActor(Database const& cx,FileSystemWorkload* const& self) 
															#line 894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   NodeSetupActorState<NodeSetupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("nodeSetup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10019369052102285312UL, 16796003732029348608UL);
		ActorExecutionContextHelper __helper(static_cast<NodeSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("nodeSetup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("nodeSetup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NodeSetupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
[[nodiscard]] Future<Void> nodeSetup( Database const& cx, FileSystemWorkload* const& self ) {
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	return Future<Void>(new NodeSetupActor(cx, self));
															#line 926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
}

#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"

																#line 931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
template <class _startActor>
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
class _startActorState {
															#line 937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
public:
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	_startActorState(Database const& cx,FileSystemWorkload* const& self) 
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		 : cx(cx),
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   self(self),
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   operation()
															#line 948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			if (self->operationName == "deletionQuery")
															#line 963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			{
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
				operation = new ServerDeletionCountQuery();
															#line 967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			}
			else
			{
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
				operation = new RecentModificationQuery();
															#line 973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			}
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(self->operationClient(cx, self, operation, 0.01), 1.0, Void());
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		self->queries.clear();
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		self->writes.clear();
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (self->performingWrites)
															#line 1011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		{
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			for(int c = 0;c < self->writeActorCount;c++) {
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
				self->clients.push_back(timeout(self->writeClient(cx, self), self->testDuration, Void()));
															#line 1017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		for(int c = 0;c < self->actorCount;c++) {
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			self->clients.push_back( timeout(self->operationClient(cx, self, operation, self->actorCount / self->transactionsPerSecond), self->testDuration, Void()));
															#line 1024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		}
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(self->clients);
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		self->queries.clear();
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		self->writes.clear();
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (self->performingWrites)
															#line 1048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		{
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			for(int c = 0;c < self->writeActorCount;c++) {
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
				self->clients.push_back(timeout(self->writeClient(cx, self), self->testDuration, Void()));
															#line 1054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		for(int c = 0;c < self->actorCount;c++) {
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			self->clients.push_back( timeout(self->operationClient(cx, self, operation, self->actorCount / self->transactionsPerSecond), self->testDuration, Void()));
															#line 1061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		}
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(self->clients);
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0.01);
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0.01);
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		delete operation;
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		delete operation;
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	Database cx;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	FileSystemWorkload* self;
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	FileSystemOp* operation;
															#line 1368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18028667820263813632UL, 18125283755019848192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	_startActor(Database const& cx,FileSystemWorkload* const& self) 
															#line 1392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, FileSystemWorkload* const& self ) {
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
}

#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"

	bool shouldRecord(double clientBegin) {
		double n = now();
		return !discardEdgeMeasurements ||
		       (n > (clientBegin + testDuration * 0.125) && n < (clientBegin + testDuration * 0.875));
	}

																#line 1437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via operationClient()
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
template <class OperationClientActor>
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
class OperationClientActorState {
															#line 1443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
public:
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	OperationClientActorState(Database const& cx,FileSystemWorkload* const& self,FileSystemOp* const& operation,double const& delay) 
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		 : cx(cx),
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   self(self),
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   operation(operation),
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   delay(delay),
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   clientBegin(now()),
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   lastTime(now())
															#line 1460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("operationClient", reinterpret_cast<unsigned long>(this));

	}
	~OperationClientActorState() 
	{
		fdb_probe_actor_destroy("operationClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			;
															#line 1475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OperationClientActorState();
		static_cast<OperationClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, delay);
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (static_cast<OperationClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<OperationClientActor*>(this)->actor_wait_state = 1;
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OperationClientActor, 0, Void >*>(static_cast<OperationClientActor*>(this)));
															#line 1512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		tstart = now();
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		tr = Transaction(cx);
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		;
															#line 1525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		tstart = now();
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		tr = Transaction(cx);
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		;
															#line 1538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OperationClientActor*>(this)->actor_wait_state > 0) static_cast<OperationClientActor*>(this)->actor_wait_state = 0;
		static_cast<OperationClientActor*>(this)->ActorCallback< OperationClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OperationClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("operationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OperationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OperationClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("operationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OperationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OperationClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("operationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OperationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (self->shouldRecord(clientBegin))
															#line 1622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		{
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			++self->queries;
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			double latency = now() - tstart;
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			self->latencies.addSample(latency);
															#line 1630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			StrictFuture<Optional<Version>> __when_expr_1 = operation->run(self, &tr);
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			if (static_cast<OperationClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<OperationClientActor*>(this)->actor_wait_state = 2;
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OperationClientActor, 1, Optional<Version> >*>(static_cast<OperationClientActor*>(this)));
															#line 1655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			if (static_cast<OperationClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<OperationClientActor*>(this)->actor_wait_state = 3;
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< OperationClientActor, 2, Void >*>(static_cast<OperationClientActor*>(this)));
															#line 1697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Version> const& ver,int loopDepth) 
	{
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (ver.present())
															#line 1712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Version> && ver,int loopDepth) 
	{
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (ver.present())
															#line 1724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Version> const& ver,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(ver, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Version> && ver,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(ver), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OperationClientActor*>(this)->actor_wait_state > 0) static_cast<OperationClientActor*>(this)->actor_wait_state = 0;
		static_cast<OperationClientActor*>(this)->ActorCallback< OperationClientActor, 1, Optional<Version> >::remove();

	}
	void a_callback_fire(ActorCallback< OperationClientActor, 1, Optional<Version> >*,Optional<Version> const& value) 
	{
		fdb_probe_actor_enter("operationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OperationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OperationClientActor, 1, Optional<Version> >*,Optional<Version> && value) 
	{
		fdb_probe_actor_enter("operationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OperationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OperationClientActor, 1, Optional<Version> >*,Error err) 
	{
		fdb_probe_actor_enter("operationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OperationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<OperationClientActor*>(this)->actor_wait_state > 0) static_cast<OperationClientActor*>(this)->actor_wait_state = 0;
		static_cast<OperationClientActor*>(this)->ActorCallback< OperationClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OperationClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("operationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OperationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operationClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< OperationClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("operationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OperationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operationClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< OperationClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("operationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OperationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operationClient", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	Database cx;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	FileSystemWorkload* self;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	FileSystemOp* operation;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	double delay;
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	double clientBegin;
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	double lastTime;
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	double tstart;
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	Transaction tr;
															#line 1923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via operationClient()
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
class OperationClientActor final : public Actor<Void>, public ActorCallback< OperationClientActor, 0, Void >, public ActorCallback< OperationClientActor, 1, Optional<Version> >, public ActorCallback< OperationClientActor, 2, Void >, public FastAllocated<OperationClientActor>, public OperationClientActorState<OperationClientActor> {
															#line 1928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<OperationClientActor>::operator new;
	using FastAllocated<OperationClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4617015629898156288UL, 4731298067960103168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OperationClientActor, 0, Void >;
friend struct ActorCallback< OperationClientActor, 1, Optional<Version> >;
friend struct ActorCallback< OperationClientActor, 2, Void >;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	OperationClientActor(Database const& cx,FileSystemWorkload* const& self,FileSystemOp* const& operation,double const& delay) 
															#line 1947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   OperationClientActorState<OperationClientActor>(cx, self, operation, delay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("operationClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7932784660594843648UL, 6584906736989774592UL);
		ActorExecutionContextHelper __helper(static_cast<OperationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("operationClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("operationClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OperationClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OperationClientActor, 1, Optional<Version> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< OperationClientActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
[[nodiscard]] Future<Void> operationClient( Database const& cx, FileSystemWorkload* const& self, FileSystemOp* const& operation, double const& delay ) {
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	return Future<Void>(new OperationClientActor(cx, self, operation, delay));
															#line 1981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
}

#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"

	static int testKeyToInt(const KeyRef& p) {
		int x = 0;
		sscanf(p.toString().c_str(), "%d", &x);
		return x;
	}

																#line 1992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via writeClient()
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
template <class WriteClientActor>
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
class WriteClientActorState {
															#line 1998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
public:
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	WriteClientActorState(Database const& cx,FileSystemWorkload* const& self) 
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		 : cx(cx),
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   self(self),
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   clientBegin(now())
															#line 2009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeClient", reinterpret_cast<unsigned long>(this));

	}
	~WriteClientActorState() 
	{
		fdb_probe_actor_destroy("writeClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			;
															#line 2024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteClientActorState();
		static_cast<WriteClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		fileID = deterministicRandom()->randomInt(0, self->fileCount);
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		isDeleting = deterministicRandom()->random01() < 0.25;
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		size = isDeleting ? 0 : deterministicRandom()->randomInt(0, std::numeric_limits<int>::max());
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		keyStr = self->keyForFileID(fileID).toString();
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		tstart = now();
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		tr = Transaction(cx);
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		;
															#line 2066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (self->shouldRecord(clientBegin))
															#line 2075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		{
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			++self->writes;
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			self->writeLatencies.addSample(now() - tstart);
															#line 2081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			time = now();
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			if (isDeleting)
															#line 2101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			{
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_0 = tr.get(StringRef(keyStr + "/deleted"));
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
				if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WriteClientActor*>(this)->actor_wait_state = 1;
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 0, Optional<Value> >*>(static_cast<WriteClientActor*>(this)));
															#line 2112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
				tr.set(keyStr + "/size", format("%d", size));
															#line 2119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<WriteClientActor*>(this)->actor_wait_state = 4;
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 3, Void >*>(static_cast<WriteClientActor*>(this)));
															#line 2162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		tr.set(keyStr + "/lastupdated", doubleToTestKey(time));
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteClientActor*>(this)->actor_wait_state = 3;
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 2, Void >*>(static_cast<WriteClientActor*>(this)));
															#line 2186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		ASSERT(deleted.present());
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(StringRef(keyStr + "/server"));
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteClientActor*>(this)->actor_wait_state = 2;
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 1, Optional<Value> >*>(static_cast<WriteClientActor*>(this)));
															#line 2204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& __deleted,int loopDepth) 
	{
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		deleted = __deleted;
															#line 2213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && __deleted,int loopDepth) 
	{
		deleted = std::move(__deleted);
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteClientActor*>(this)->actor_wait_state > 0) static_cast<WriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriteClientActor*>(this)->ActorCallback< WriteClientActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteClientActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont4(Optional<Value> const& serverStr,int loopDepth) 
	{
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		ASSERT(serverStr.present());
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		int serverID = testKeyToInt(serverStr.get());
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (deleted.get().toString() == "1")
															#line 2296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		{
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			tr.set(keyStr + "/deleted", "0"_sr);
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			tr.clear(format("/files/server/%08x/deleted/%016llx", serverID, fileID));
															#line 2302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		}
		else
		{
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			tr.set(keyStr + "/deleted", "1"_sr);
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			tr.set(format("/files/server/%08x/deleted/%016llx", serverID, fileID), doubleToTestKey(time));
															#line 2310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Optional<Value> && serverStr,int loopDepth) 
	{
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		ASSERT(serverStr.present());
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		int serverID = testKeyToInt(serverStr.get());
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (deleted.get().toString() == "1")
															#line 2324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		{
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			tr.set(keyStr + "/deleted", "0"_sr);
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			tr.clear(format("/files/server/%08x/deleted/%016llx", serverID, fileID));
															#line 2330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		}
		else
		{
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			tr.set(keyStr + "/deleted", "1"_sr);
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			tr.set(format("/files/server/%08x/deleted/%016llx", serverID, fileID), doubleToTestKey(time));
															#line 2338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Optional<Value> const& serverStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(serverStr, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Optional<Value> && serverStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(serverStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteClientActor*>(this)->actor_wait_state > 0) static_cast<WriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriteClientActor*>(this)->ActorCallback< WriteClientActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteClientActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont9(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteClientActor*>(this)->actor_wait_state > 0) static_cast<WriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriteClientActor*>(this)->ActorCallback< WriteClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WriteClientActor*>(this)->actor_wait_state > 0) static_cast<WriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriteClientActor*>(this)->ActorCallback< WriteClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WriteClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	Database cx;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	FileSystemWorkload* self;
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	double clientBegin;
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	int fileID;
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	bool isDeleting;
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	int size;
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	std::string keyStr;
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	double tstart;
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	Transaction tr;
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	double time;
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	Optional<Value> deleted;
															#line 2615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeClient()
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
class WriteClientActor final : public Actor<Void>, public ActorCallback< WriteClientActor, 0, Optional<Value> >, public ActorCallback< WriteClientActor, 1, Optional<Value> >, public ActorCallback< WriteClientActor, 2, Void >, public ActorCallback< WriteClientActor, 3, Void >, public FastAllocated<WriteClientActor>, public WriteClientActorState<WriteClientActor> {
															#line 2620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteClientActor>::operator new;
	using FastAllocated<WriteClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4643684415632936960UL, 17498276743800130816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteClientActor, 0, Optional<Value> >;
friend struct ActorCallback< WriteClientActor, 1, Optional<Value> >;
friend struct ActorCallback< WriteClientActor, 2, Void >;
friend struct ActorCallback< WriteClientActor, 3, Void >;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	WriteClientActor(Database const& cx,FileSystemWorkload* const& self) 
															#line 2640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteClientActorState<WriteClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4567739696819474176UL, 14335318888042807040UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteClientActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteClientActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteClientActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WriteClientActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
[[nodiscard]] Future<Void> writeClient( Database const& cx, FileSystemWorkload* const& self ) {
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	return Future<Void>(new WriteClientActor(cx, self));
															#line 2675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
}

#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"

																#line 2680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via modificationQuery()
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
template <class ModificationQueryActor>
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
class ModificationQueryActorState {
															#line 2686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
public:
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	ModificationQueryActorState(FileSystemWorkload* const& self,Transaction* const& tr) 
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		 : self(self),
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   tr(tr),
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   userID(deterministicRandom()->randomInt(0, self->userIDCount)),
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   base(format("/files/user/%016llx", userID))
															#line 2699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("modificationQuery", reinterpret_cast<unsigned long>(this));

	}
	~ModificationQueryActorState() 
	{
		fdb_probe_actor_destroy("modificationQuery", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			if (self->loggingQueries)
															#line 2714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			{
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
				TraceEvent("UserQuery").detail("UserID", userID).detail("PathBase", base);
															#line 2718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			}
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			Key keyEnd(base + "/updated0");
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(firstGreaterOrEqual(keyEnd) - 10, firstGreaterOrEqual(keyEnd), 10);
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			if (static_cast<ModificationQueryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ModificationQueryActor*>(this)->actor_wait_state = 1;
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ModificationQueryActor, 0, RangeResult >*>(static_cast<ModificationQueryActor*>(this)));
															#line 2731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ModificationQueryActorState();
		static_cast<ModificationQueryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& val,int loopDepth) 
	{
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		Key keyBegin(base + "/updated/");
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		for(int i = val.size() - 1;i >= 0;i--) {
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			if (val[i].key.startsWith(keyBegin) && self->loggingQueries)
															#line 2758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			{
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
				TraceEvent("UserQueryResults") .detail("UserID", userID) .detail("PathBase", base) .detail("LastModified", printable(val[i].key.substr(54)));
															#line 2762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
				break;
			}
		}
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (!static_cast<ModificationQueryActor*>(this)->SAV<Optional<Version>>::futures) { (void)(Optional<Version>(Version(0))); this->~ModificationQueryActorState(); static_cast<ModificationQueryActor*>(this)->destroy(); return 0; }
															#line 2768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		new (&static_cast<ModificationQueryActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(Optional<Version>(Version(0)));
		this->~ModificationQueryActorState();
		static_cast<ModificationQueryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && val,int loopDepth) 
	{
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		Key keyBegin(base + "/updated/");
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		for(int i = val.size() - 1;i >= 0;i--) {
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			if (val[i].key.startsWith(keyBegin) && self->loggingQueries)
															#line 2784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			{
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
				TraceEvent("UserQueryResults") .detail("UserID", userID) .detail("PathBase", base) .detail("LastModified", printable(val[i].key.substr(54)));
															#line 2788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
				break;
			}
		}
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (!static_cast<ModificationQueryActor*>(this)->SAV<Optional<Version>>::futures) { (void)(Optional<Version>(Version(0))); this->~ModificationQueryActorState(); static_cast<ModificationQueryActor*>(this)->destroy(); return 0; }
															#line 2794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		new (&static_cast<ModificationQueryActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(Optional<Version>(Version(0)));
		this->~ModificationQueryActorState();
		static_cast<ModificationQueryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ModificationQueryActor*>(this)->actor_wait_state > 0) static_cast<ModificationQueryActor*>(this)->actor_wait_state = 0;
		static_cast<ModificationQueryActor*>(this)->ActorCallback< ModificationQueryActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ModificationQueryActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("modificationQuery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ModificationQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modificationQuery", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ModificationQueryActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("modificationQuery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ModificationQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modificationQuery", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ModificationQueryActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("modificationQuery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ModificationQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modificationQuery", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	FileSystemWorkload* self;
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	Transaction* tr;
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	uint64_t userID;
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	std::string base;
															#line 2885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via modificationQuery()
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
class ModificationQueryActor final : public Actor<Optional<Version>>, public ActorCallback< ModificationQueryActor, 0, RangeResult >, public FastAllocated<ModificationQueryActor>, public ModificationQueryActorState<ModificationQueryActor> {
															#line 2890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<ModificationQueryActor>::operator new;
	using FastAllocated<ModificationQueryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12400134239711802112UL, 14955564508359404800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Version>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ModificationQueryActor, 0, RangeResult >;
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	ModificationQueryActor(FileSystemWorkload* const& self,Transaction* const& tr) 
															#line 2907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		 : Actor<Optional<Version>>(),
		   ModificationQueryActorState<ModificationQueryActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("modificationQuery", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4409422898207247104UL, 2186033240460276736UL);
		ActorExecutionContextHelper __helper(static_cast<ModificationQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("modificationQuery");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("modificationQuery", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ModificationQueryActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
[[nodiscard]] Future<Optional<Version>> modificationQuery( FileSystemWorkload* const& self, Transaction* const& tr ) {
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	return Future<Optional<Version>>(new ModificationQueryActor(self, tr));
															#line 2939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
}

#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"

																#line 2944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via deletionQuery()
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
template <class DeletionQueryActor>
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
class DeletionQueryActorState {
															#line 2950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
public:
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	DeletionQueryActorState(FileSystemWorkload* const& self,Transaction* const& tr) 
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		 : self(self),
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   tr(tr),
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   serverID(deterministicRandom()->randomInt(0, self->serverCount)),
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		   base(format("/files/server/%08x/deleted", serverID))
															#line 2963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("deletionQuery", reinterpret_cast<unsigned long>(this));

	}
	~DeletionQueryActorState() 
	{
		fdb_probe_actor_destroy("deletionQuery", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			if (self->loggingQueries)
															#line 2978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			{
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
				TraceEvent("DeletionQuery").detail("ServerID", serverID).detail("PathBase", base);
															#line 2982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			}
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			keyBegin = Key(base + "/");
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			keyEnd = Key(base + "0");
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			begin = firstGreaterThan(keyBegin);
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			end = firstGreaterOrEqual(keyEnd);
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			transferred = 1000;
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			transferSize = 1000;
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			deletedFiles = 0;
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			;
															#line 3000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeletionQueryActorState();
		static_cast<DeletionQueryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (self->loggingQueries)
															#line 3023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		{
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
			TraceEvent("DeletionQueryResults") .detail("ServerID", serverID) .detail("PathBase", base) .detail("DeletedFiles", deletedFiles);
															#line 3027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		}
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (!static_cast<DeletionQueryActor*>(this)->SAV<Optional<Version>>::futures) { (void)(Optional<Version>(Version(0))); this->~DeletionQueryActorState(); static_cast<DeletionQueryActor*>(this)->destroy(); return 0; }
															#line 3031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		new (&static_cast<DeletionQueryActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(Optional<Version>(Version(0)));
		this->~DeletionQueryActorState();
		static_cast<DeletionQueryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (!(transferred == transferSize))
															#line 3050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = tr->getRange(begin, end, transferSize);
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		if (static_cast<DeletionQueryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DeletionQueryActor*>(this)->actor_wait_state = 1;
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeletionQueryActor, 0, RangeResult >*>(static_cast<DeletionQueryActor*>(this)));
															#line 3063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult const& val,int loopDepth) 
	{
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		transferred = val.size();
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		deletedFiles += transferred;
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		begin = begin + transferred;
															#line 3089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult && val,int loopDepth) 
	{
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		transferred = val.size();
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		deletedFiles += transferred;
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
		begin = begin + transferred;
															#line 3102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeletionQueryActor*>(this)->actor_wait_state > 0) static_cast<DeletionQueryActor*>(this)->actor_wait_state = 0;
		static_cast<DeletionQueryActor*>(this)->ActorCallback< DeletionQueryActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< DeletionQueryActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("deletionQuery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeletionQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deletionQuery", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeletionQueryActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("deletionQuery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeletionQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deletionQuery", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeletionQueryActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("deletionQuery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeletionQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deletionQuery", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	FileSystemWorkload* self;
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	Transaction* tr;
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	uint64_t serverID;
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	std::string base;
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	Key keyBegin;
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	Key keyEnd;
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	KeySelectorRef begin;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	KeySelectorRef end;
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	int transferred;
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	int transferSize;
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	uint64_t deletedFiles;
															#line 3204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via deletionQuery()
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
class DeletionQueryActor final : public Actor<Optional<Version>>, public ActorCallback< DeletionQueryActor, 0, RangeResult >, public FastAllocated<DeletionQueryActor>, public DeletionQueryActorState<DeletionQueryActor> {
															#line 3209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<DeletionQueryActor>::operator new;
	using FastAllocated<DeletionQueryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11849008363538110208UL, 6249927414013142272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Version>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeletionQueryActor, 0, RangeResult >;
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	DeletionQueryActor(FileSystemWorkload* const& self,Transaction* const& tr) 
															#line 3226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
		 : Actor<Optional<Version>>(),
		   DeletionQueryActorState<DeletionQueryActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deletionQuery", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16535269067593708032UL, 6028856520730620416UL);
		ActorExecutionContextHelper __helper(static_cast<DeletionQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deletionQuery");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deletionQuery", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeletionQueryActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
[[nodiscard]] Future<Optional<Version>> deletionQuery( FileSystemWorkload* const& self, Transaction* const& tr ) {
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"
	return Future<Optional<Version>>(new DeletionQueryActor(self, tr));
															#line 3258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/FileSystem.actor.g.cpp.py_gen"
}

#line 320 "/Users/ec2-user/foundationdb/fdbserver/workloads/FileSystem.actor.cpp"

	class RecentModificationQuery : public FileSystemOp {
		Future<Optional<Version>> run(FileSystemWorkload* self, Transaction* tr) override {
			return self->modificationQuery(self, tr);
		}
		const char* name() override { return "RecentUserModifications"; }
	};

	class ServerDeletionCountQuery : public FileSystemOp {
		Future<Optional<Version>> run(FileSystemWorkload* self, Transaction* tr) override {
			return self->deletionQuery(self, tr);
		}
		const char* name() override { return "ServerDeletions"; }
	};
};

WorkloadFactory<FileSystemWorkload> FileSystemWorkloadFactory;
