#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
/*
 * DiskFailureInjection.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/Status.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct DiskFailureInjectionWorkload : FailureInjectionWorkload {
	static constexpr auto NAME = "DiskFailureInjection";
	bool enabled;
	double testDuration = 60.0;
	double startDelay = 0.0;
	bool throttleDisk = false;
	int workersToThrottle = 3;
	double stallInterval = 0.0;
	double stallPeriod = 60.0;
	double throttlePeriod = 60.0;
	bool corruptFile = false;
	int workersToCorrupt = 1;
	double percentBitFlips = 10;
	double periodicBroadcastInterval = 5.0;
	std::vector<NetworkAddress> chosenWorkers;
	// Verification Mode: We run the workload indefinitely in this mode.
	// The idea is to keep going until we get a non-zero chaosMetric to ensure
	// that we haven't lost the chaos event. testDuration is ignored in this mode
	bool verificationMode = false;

	DiskFailureInjectionWorkload(WorkloadContext const& wcx, NoOptions) : FailureInjectionWorkload(wcx) {}

	DiskFailureInjectionWorkload(WorkloadContext const& wcx) : FailureInjectionWorkload(wcx) {
		enabled = !clientId; // only do this on the "first" client
		startDelay = getOption(options, "startDelay"_sr, startDelay);
		testDuration = getOption(options, "testDuration"_sr, testDuration);
		verificationMode = getOption(options, "verificationMode"_sr, verificationMode);
		throttleDisk = getOption(options, "throttleDisk"_sr, throttleDisk);
		workersToThrottle = getOption(options, "workersToThrottle"_sr, workersToThrottle);
		stallInterval = getOption(options, "stallInterval"_sr, stallInterval);
		stallPeriod = getOption(options, "stallPeriod"_sr, stallPeriod);
		throttlePeriod = getOption(options, "throttlePeriod"_sr, throttlePeriod);
		corruptFile = getOption(options, "corruptFile"_sr, corruptFile);
		workersToCorrupt = getOption(options, "workersToCorrupt"_sr, workersToCorrupt);
		percentBitFlips = getOption(options, "percentBitFlips"_sr, percentBitFlips);
		periodicBroadcastInterval = getOption(options, "periodicBroadcastInterval"_sr, periodicBroadcastInterval);
	}

	// TODO: Currently this workload doesn't play well with MachineAttrition.
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.insert("Attrition"); }

	void initFailureInjectionMode(DeterministicRandom& random) override { enabled = clientId == 0; }

	Future<Void> setup(Database const& cx) override { return Void(); }

	// Starts the workload by -
	// 1. Starting the actor to periodically check chaosMetrics and re-broadcast chaos events, and
	// 2. Starting the actor that injects failures on chosen storage servers
	Future<Void> start(Database const& cx) override {
		if (enabled) {
			auto result = diskFailureInjectionClient<WorkerInterface>(cx, this);
			//  In verification mode, we want to wait until periodicEventBroadcast actor returns which indicates that
			//  a non-zero chaosMetric was found.
			if (verificationMode) {
				return (periodicEventBroadcast(this) && delay(testDuration)) || result;
			} else {
				// Else we honor the testDuration
				return timeout(periodicEventBroadcast(this) && result, testDuration, Void());
			}
		} else
			return Void();
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	static void checkDiskFailureInjectionResult(Future<Void> res, WorkerInterface worker) {
		if (res.isError()) {
			auto err = res.getError();
			if (err.code() == error_code_client_invalid_operation) {
				TraceEvent(SevError, "ChaosDisabled")
				    .detail("OnEndpoint", worker.waitFailure.getEndpoint().addresses.address.toString());
			} else {
				TraceEvent(SevError, "DiskFailureInjectionFailed")
				    .error(err)
				    .detail("OnEndpoint", worker.waitFailure.getEndpoint().addresses.address.toString());
			}
		}
	}

	// Sets the disk delay request
																#line 114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
// This generated class is to be used only via injectDiskDelays()
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
template <class InjectDiskDelaysActor>
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
class InjectDiskDelaysActorState {
															#line 120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
public:
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	InjectDiskDelaysActorState(WorkerInterface const& worker,double const& stallInterval,double const& stallPeriod,double const& throttlePeriod) 
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		 : worker(worker),
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		   stallInterval(stallInterval),
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		   stallPeriod(stallPeriod),
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		   throttlePeriod(throttlePeriod),
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		   res()
															#line 135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("injectDiskDelays", reinterpret_cast<unsigned long>(this));

	}
	~InjectDiskDelaysActorState() 
	{
		fdb_probe_actor_destroy("injectDiskDelays", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			SetFailureInjection::DiskFailureCommand diskFailure;
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			diskFailure.stallInterval = stallInterval;
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			diskFailure.stallPeriod = stallPeriod;
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			diskFailure.throttlePeriod = throttlePeriod;
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			SetFailureInjection req;
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			req.diskFailure = diskFailure;
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			res = worker.clientInterface.setFailureInjection.getReply(req);
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ready(res);
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			static_cast<InjectDiskDelaysActor*>(this)->actor_wait_state = 1;
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InjectDiskDelaysActor, 0, Void >*>(static_cast<InjectDiskDelaysActor*>(this)));
															#line 170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<InjectDiskDelaysActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		checkDiskFailureInjectionResult(res, worker);
															#line 192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		checkDiskFailureInjectionResult(res, worker);
															#line 201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InjectDiskDelaysActor*>(this)->actor_wait_state > 0) static_cast<InjectDiskDelaysActor*>(this)->actor_wait_state = 0;
		static_cast<InjectDiskDelaysActor*>(this)->ActorCallback< InjectDiskDelaysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InjectDiskDelaysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("injectDiskDelays", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InjectDiskDelaysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("injectDiskDelays", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InjectDiskDelaysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("injectDiskDelays", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InjectDiskDelaysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("injectDiskDelays", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InjectDiskDelaysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("injectDiskDelays", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InjectDiskDelaysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("injectDiskDelays", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		delete static_cast<InjectDiskDelaysActor*>(this);
															#line 285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	WorkerInterface worker;
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	double stallInterval;
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	double stallPeriod;
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	double throttlePeriod;
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	Future<Void> res;
															#line 300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via injectDiskDelays()
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
class InjectDiskDelaysActor final : public Actor<void>, public ActorCallback< InjectDiskDelaysActor, 0, Void >, public FastAllocated<InjectDiskDelaysActor>, public InjectDiskDelaysActorState<InjectDiskDelaysActor> {
															#line 305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
public:
	using FastAllocated<InjectDiskDelaysActor>::operator new;
	using FastAllocated<InjectDiskDelaysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3898999106740402432UL, 6770538494206893568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< InjectDiskDelaysActor, 0, Void >;
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	InjectDiskDelaysActor(WorkerInterface const& worker,double const& stallInterval,double const& stallPeriod,double const& throttlePeriod) 
															#line 322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   InjectDiskDelaysActorState<InjectDiskDelaysActor>(worker, stallInterval, stallPeriod, throttlePeriod),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("injectDiskDelays", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(681122861787478528UL, 17294461721888505088UL);
		ActorExecutionContextHelper __helper(static_cast<InjectDiskDelaysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("injectDiskDelays");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("injectDiskDelays", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
void injectDiskDelays( WorkerInterface const& worker, double const& stallInterval, double const& stallPeriod, double const& throttlePeriod ) {
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	new InjectDiskDelaysActor(worker, stallInterval, stallPeriod, throttlePeriod);
															#line 345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
}

#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"

	// Sets the disk corruption request
																#line 351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
// This generated class is to be used only via injectBitFlips()
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
template <class InjectBitFlipsActor>
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
class InjectBitFlipsActorState {
															#line 357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
public:
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	InjectBitFlipsActorState(WorkerInterface const& worker,double const& percentage) 
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		 : worker(worker),
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		   percentage(percentage),
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		   res()
															#line 368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("injectBitFlips", reinterpret_cast<unsigned long>(this));

	}
	~InjectBitFlipsActorState() 
	{
		fdb_probe_actor_destroy("injectBitFlips", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			SetFailureInjection::FlipBitsCommand flipBits;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			flipBits.percentBitFlips = percentage;
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			SetFailureInjection req;
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			req.flipBits = flipBits;
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			res = worker.clientInterface.setFailureInjection.getReply(req);
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ready(res);
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			static_cast<InjectBitFlipsActor*>(this)->actor_wait_state = 1;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InjectBitFlipsActor, 0, Void >*>(static_cast<InjectBitFlipsActor*>(this)));
															#line 399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<InjectBitFlipsActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		checkDiskFailureInjectionResult(res, worker);
															#line 421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		checkDiskFailureInjectionResult(res, worker);
															#line 430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InjectBitFlipsActor*>(this)->actor_wait_state > 0) static_cast<InjectBitFlipsActor*>(this)->actor_wait_state = 0;
		static_cast<InjectBitFlipsActor*>(this)->ActorCallback< InjectBitFlipsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InjectBitFlipsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("injectBitFlips", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InjectBitFlipsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("injectBitFlips", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InjectBitFlipsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("injectBitFlips", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InjectBitFlipsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("injectBitFlips", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InjectBitFlipsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("injectBitFlips", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InjectBitFlipsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("injectBitFlips", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		delete static_cast<InjectBitFlipsActor*>(this);
															#line 514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	WorkerInterface worker;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	double percentage;
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	Future<Void> res;
															#line 525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via injectBitFlips()
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
class InjectBitFlipsActor final : public Actor<void>, public ActorCallback< InjectBitFlipsActor, 0, Void >, public FastAllocated<InjectBitFlipsActor>, public InjectBitFlipsActorState<InjectBitFlipsActor> {
															#line 530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
public:
	using FastAllocated<InjectBitFlipsActor>::operator new;
	using FastAllocated<InjectBitFlipsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14679753776366769920UL, 13060534164018995200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< InjectBitFlipsActor, 0, Void >;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	InjectBitFlipsActor(WorkerInterface const& worker,double const& percentage) 
															#line 547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   InjectBitFlipsActorState<InjectBitFlipsActor>(worker, percentage),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("injectBitFlips", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5919030770414266624UL, 17992130897833102336UL);
		ActorExecutionContextHelper __helper(static_cast<InjectBitFlipsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("injectBitFlips");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("injectBitFlips", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
void injectBitFlips( WorkerInterface const& worker, double const& percentage ) {
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	new InjectBitFlipsActor(worker, percentage);
															#line 570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
}

#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"

	// Choose random storage servers to inject disk failures.
	// We currently only inject disk failure on storage servers. Can be expanded to include
	// other worker types in future
																#line 578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
// This generated class is to be used only via diskFailureInjectionClient()
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
template <class W, class DiskFailureInjectionClientActor>
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
class DiskFailureInjectionClientActorState {
															#line 584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
public:
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	DiskFailureInjectionClientActorState(Database const& cx,DiskFailureInjectionWorkload* const& self) 
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		 : cx(cx),
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		   self(self)
															#line 593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this));

	}
	~DiskFailureInjectionClientActorState() 
	{
		fdb_probe_actor_destroy("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ::delay(self->startDelay);
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			if (static_cast<DiskFailureInjectionClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DiskFailureInjectionClientActor*>(this)->actor_wait_state = 1;
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DiskFailureInjectionClientActor, 0, Void >*>(static_cast<DiskFailureInjectionClientActor*>(this)));
															#line 615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DiskFailureInjectionClientActorState();
		static_cast<DiskFailureInjectionClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		lastTime = now();
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		machines = std::vector<W>();
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		throttledWorkers = 0;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		corruptedWorkers = 0;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		;
															#line 646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		lastTime = now();
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		machines = std::vector<W>();
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		throttledWorkers = 0;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		corruptedWorkers = 0;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		;
															#line 663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DiskFailureInjectionClientActor*>(this)->actor_wait_state > 0) static_cast<DiskFailureInjectionClientActor*>(this)->actor_wait_state = 0;
		static_cast<DiskFailureInjectionClientActor*>(this)->ActorCallback< DiskFailureInjectionClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DiskFailureInjectionClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiskFailureInjectionClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DiskFailureInjectionClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiskFailureInjectionClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DiskFailureInjectionClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiskFailureInjectionClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = poisson(&lastTime, 1);
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (static_cast<DiskFailureInjectionClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DiskFailureInjectionClientActor*>(this)->actor_wait_state = 2;
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DiskFailureInjectionClientActor, 1, Void >*>(static_cast<DiskFailureInjectionClientActor*>(this)));
															#line 761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		try {
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			StrictFuture<std::pair<std::vector<W>, int>> __when_expr_2 = getStorageWorkers(cx, self->dbInfo, false);
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			if (static_cast<DiskFailureInjectionClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DiskFailureInjectionClientActor*>(this)->actor_wait_state = 3;
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DiskFailureInjectionClientActor, 2, std::pair<std::vector<W>, int> >*>(static_cast<DiskFailureInjectionClientActor*>(this)));
															#line 778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		try {
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			StrictFuture<std::pair<std::vector<W>, int>> __when_expr_2 = getStorageWorkers(cx, self->dbInfo, false);
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			if (static_cast<DiskFailureInjectionClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DiskFailureInjectionClientActor*>(this)->actor_wait_state = 3;
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DiskFailureInjectionClientActor, 2, std::pair<std::vector<W>, int> >*>(static_cast<DiskFailureInjectionClientActor*>(this)));
															#line 801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DiskFailureInjectionClientActor*>(this)->actor_wait_state > 0) static_cast<DiskFailureInjectionClientActor*>(this)->actor_wait_state = 0;
		static_cast<DiskFailureInjectionClientActor*>(this)->ActorCallback< DiskFailureInjectionClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DiskFailureInjectionClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiskFailureInjectionClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DiskFailureInjectionClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiskFailureInjectionClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DiskFailureInjectionClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiskFailureInjectionClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		auto machine = deterministicRandom()->randomChoice(machines);
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (find(self->chosenWorkers.begin(), self->chosenWorkers.end(), machine.address()) != self->chosenWorkers.end())
															#line 893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopHead1(loopDepth); // continue
		}
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		self->chosenWorkers.emplace_back(machine.address());
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (self->throttleDisk && (throttledWorkers++ < self->workersToThrottle))
															#line 901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		{
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			self->injectDiskDelays(machine, self->stallInterval, self->stallPeriod, self->throttlePeriod);
															#line 905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		}
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (self->corruptFile && (corruptedWorkers++ < self->workersToCorrupt))
															#line 909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		{
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			if (g_simulator == g_network)
															#line 913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			{
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
				g_simulator->corruptWorkerMap[machine.address()] = true;
															#line 917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			}
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			self->injectBitFlips(machine, self->percentBitFlips);
															#line 921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			TraceEvent("ChaosCouldNotGetStorages").error(e);
															#line 932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			return a_body1cont1loopHead1(loopDepth); // continue
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(std::pair<std::vector<W>, int> const& m,int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (m.second > 0)
															#line 947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		{
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			return a_body1cont1loopBody1cont1Catch1(operation_failed(), loopDepth);
															#line 951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		}
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		machines = std::move(m.first);
															#line 955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(std::pair<std::vector<W>, int> && m,int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (m.second > 0)
															#line 964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		{
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			return a_body1cont1loopBody1cont1Catch1(operation_failed(), loopDepth);
															#line 968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		}
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		machines = std::move(m.first);
															#line 972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(std::pair<std::vector<W>, int> const& m,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(m, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(std::pair<std::vector<W>, int> && m,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(m), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DiskFailureInjectionClientActor*>(this)->actor_wait_state > 0) static_cast<DiskFailureInjectionClientActor*>(this)->actor_wait_state = 0;
		static_cast<DiskFailureInjectionClientActor*>(this)->ActorCallback< DiskFailureInjectionClientActor, 2, std::pair<std::vector<W>, int> >::remove();

	}
	void a_callback_fire(ActorCallback< DiskFailureInjectionClientActor, 2, std::pair<std::vector<W>, int> >*,std::pair<std::vector<W>, int> const& value) 
	{
		fdb_probe_actor_enter("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiskFailureInjectionClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DiskFailureInjectionClientActor, 2, std::pair<std::vector<W>, int> >*,std::pair<std::vector<W>, int> && value) 
	{
		fdb_probe_actor_enter("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiskFailureInjectionClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DiskFailureInjectionClientActor, 2, std::pair<std::vector<W>, int> >*,Error err) 
	{
		fdb_probe_actor_enter("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiskFailureInjectionClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	Database cx;
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	DiskFailureInjectionWorkload* self;
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	double lastTime;
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	std::vector<W> machines;
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	int throttledWorkers;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	int corruptedWorkers;
															#line 1077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via diskFailureInjectionClient()
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
template <class W>
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
class DiskFailureInjectionClientActor final : public Actor<Void>, public ActorCallback< DiskFailureInjectionClientActor<W>, 0, Void >, public ActorCallback< DiskFailureInjectionClientActor<W>, 1, Void >, public ActorCallback< DiskFailureInjectionClientActor<W>, 2, std::pair<std::vector<W>, int> >, public FastAllocated<DiskFailureInjectionClientActor<W>>, public DiskFailureInjectionClientActorState<W, DiskFailureInjectionClientActor<W>> {
															#line 1084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
public:
	using FastAllocated<DiskFailureInjectionClientActor<W>>::operator new;
	using FastAllocated<DiskFailureInjectionClientActor<W>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6490475515325330944UL, 11900516696044363008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DiskFailureInjectionClientActor<W>, 0, Void >;
friend struct ActorCallback< DiskFailureInjectionClientActor<W>, 1, Void >;
friend struct ActorCallback< DiskFailureInjectionClientActor<W>, 2, std::pair<std::vector<W>, int> >;
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	DiskFailureInjectionClientActor(Database const& cx,DiskFailureInjectionWorkload* const& self) 
															#line 1103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DiskFailureInjectionClientActorState<W, DiskFailureInjectionClientActor<W>>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7510669331376144128UL, 18273567127578994176UL);
		ActorExecutionContextHelper __helper(static_cast<DiskFailureInjectionClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("diskFailureInjectionClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("diskFailureInjectionClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DiskFailureInjectionClientActor<W>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DiskFailureInjectionClientActor<W>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DiskFailureInjectionClientActor<W>, 2, std::pair<std::vector<W>, int> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
template <class W>
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
[[nodiscard]] Future<Void> diskFailureInjectionClient( Database const& cx, DiskFailureInjectionWorkload* const& self ) {
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	return Future<Void>(new DiskFailureInjectionClientActor<W>(cx, self));
															#line 1139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
}

#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"

	// Resend the chaos event to previously chosen workers, in case some workers got restarted and lost their chaos
	// config
																#line 1146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
// This generated class is to be used only via reSendChaos()
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
template <class ReSendChaosActor>
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
class ReSendChaosActorState {
															#line 1152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
public:
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	ReSendChaosActorState(DiskFailureInjectionWorkload* const& self) 
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		 : self(self),
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		   throttledWorkers(0),
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		   corruptedWorkers(0),
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		   workersMap()
															#line 1165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("reSendChaos", reinterpret_cast<unsigned long>(this));

	}
	~ReSendChaosActorState() 
	{
		fdb_probe_actor_destroy("reSendChaos", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			if (static_cast<ReSendChaosActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReSendChaosActor*>(this)->actor_wait_state = 1;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReSendChaosActor, 0, std::vector<WorkerDetails> >*>(static_cast<ReSendChaosActor*>(this)));
															#line 1187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReSendChaosActorState();
		static_cast<ReSendChaosActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		for( auto worker : workers ) {
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			workersMap[worker.interf.address()] = worker.interf;
															#line 1212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		}
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		TraceEvent("ResendChaos") .detail("ChosenWorkersSize", self->chosenWorkers.size()) .detail("FoundWorkers", workersMap.size()) .detail("ResendToNumber", std::count_if(self->chosenWorkers.begin(), self->chosenWorkers.end(), [&map = std::as_const(workersMap)](auto const& addr) { return map.contains(addr); }));
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		for( auto& workerAddress : self->chosenWorkers ) {
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			auto itr = workersMap.find(workerAddress);
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			if (itr != workersMap.end())
															#line 1222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			{
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
				if (self->throttleDisk && (throttledWorkers++ < self->workersToThrottle))
															#line 1226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
				{
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
					self->injectDiskDelays(itr->second, self->stallInterval, self->stallPeriod, self->throttlePeriod);
															#line 1230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
				}
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
				if (self->corruptFile && (corruptedWorkers++ < self->workersToCorrupt))
															#line 1234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
				{
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
					if (g_simulator == g_network)
															#line 1238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
					{
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
						g_simulator->corruptWorkerMap[workerAddress] = true;
															#line 1242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
					}
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
					self->injectBitFlips(itr->second, self->percentBitFlips);
															#line 1246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
				}
			}
		}
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (!static_cast<ReSendChaosActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReSendChaosActorState(); static_cast<ReSendChaosActor*>(this)->destroy(); return 0; }
															#line 1252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		new (&static_cast<ReSendChaosActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReSendChaosActorState();
		static_cast<ReSendChaosActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		workers = __workers;
															#line 1264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReSendChaosActor*>(this)->actor_wait_state > 0) static_cast<ReSendChaosActor*>(this)->actor_wait_state = 0;
		static_cast<ReSendChaosActor*>(this)->ActorCallback< ReSendChaosActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< ReSendChaosActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("reSendChaos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReSendChaosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reSendChaos", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReSendChaosActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("reSendChaos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReSendChaosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reSendChaos", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReSendChaosActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("reSendChaos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReSendChaosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reSendChaos", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	DiskFailureInjectionWorkload* self;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	int throttledWorkers;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	int corruptedWorkers;
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	std::map<NetworkAddress, WorkerInterface> workersMap;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 1349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via reSendChaos()
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
class ReSendChaosActor final : public Actor<Void>, public ActorCallback< ReSendChaosActor, 0, std::vector<WorkerDetails> >, public FastAllocated<ReSendChaosActor>, public ReSendChaosActorState<ReSendChaosActor> {
															#line 1354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReSendChaosActor>::operator new;
	using FastAllocated<ReSendChaosActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5972260967194005248UL, 5855229568343905024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReSendChaosActor, 0, std::vector<WorkerDetails> >;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	ReSendChaosActor(DiskFailureInjectionWorkload* const& self) 
															#line 1371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ReSendChaosActorState<ReSendChaosActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reSendChaos", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4326312777094868480UL, 3622822932103631360UL);
		ActorExecutionContextHelper __helper(static_cast<ReSendChaosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reSendChaos");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reSendChaos", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReSendChaosActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
[[nodiscard]] static Future<Void> reSendChaos( DiskFailureInjectionWorkload* const& self ) {
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	return Future<Void>(new ReSendChaosActor(self));
															#line 1403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
}

#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"

	// Fetches chaosMetrics and verifies that chaos events are happening for enabled workers
																#line 1409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
// This generated class is to be used only via chaosGetStatus()
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
template <class ChaosGetStatusActor>
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
class ChaosGetStatusActorState {
															#line 1415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
public:
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	ChaosGetStatusActorState(DiskFailureInjectionWorkload* const& self) 
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		 : self(self),
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		   foundChaosMetrics(0)
															#line 1424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("chaosGetStatus", reinterpret_cast<unsigned long>(this));

	}
	~ChaosGetStatusActorState() 
	{
		fdb_probe_actor_destroy("chaosGetStatus", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			if (static_cast<ChaosGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChaosGetStatusActor*>(this)->actor_wait_state = 1;
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChaosGetStatusActor, 0, std::vector<WorkerDetails> >*>(static_cast<ChaosGetStatusActor*>(this)));
															#line 1446 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChaosGetStatusActorState();
		static_cast<ChaosGetStatusActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		Future<Optional<std::pair<WorkerEvents, std::set<std::string>>>> latestEventsFuture;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		latestEventsFuture = latestEventOnWorkers(workers, "ChaosMetrics");
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		StrictFuture<Optional<std::pair<WorkerEvents, std::set<std::string>>>> __when_expr_1 = latestEventsFuture;
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (static_cast<ChaosGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChaosGetStatusActor*>(this)->actor_wait_state = 2;
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChaosGetStatusActor, 1, Optional<std::pair<WorkerEvents, std::set<std::string>>> >*>(static_cast<ChaosGetStatusActor*>(this)));
															#line 1480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		workers = __workers;
															#line 1489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChaosGetStatusActor*>(this)->actor_wait_state > 0) static_cast<ChaosGetStatusActor*>(this)->actor_wait_state = 0;
		static_cast<ChaosGetStatusActor*>(this)->ActorCallback< ChaosGetStatusActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< ChaosGetStatusActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("chaosGetStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosGetStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChaosGetStatusActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("chaosGetStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosGetStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChaosGetStatusActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("chaosGetStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosGetStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		cMetrics = workerEvents.present() ? workerEvents.get().first : WorkerEvents();
															#line 1568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		try {
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			for( auto& workerAddress : self->chosenWorkers ) {
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
				auto chaosMetrics = cMetrics.find(workerAddress);
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
				if (chaosMetrics != cMetrics.end())
															#line 1576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
				{
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
					if (self->throttleDisk)
															#line 1580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
					{
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
						int diskDelays = chaosMetrics->second.getInt("DiskDelays");
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
						if (diskDelays > 0)
															#line 1586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
						{
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
							foundChaosMetrics += diskDelays;
															#line 1590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
						}
					}
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
					if (self->corruptFile)
															#line 1595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
					{
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
						int bitFlips = chaosMetrics->second.getInt("BitFlips");
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
						if (bitFlips > 0)
															#line 1601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
						{
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
							foundChaosMetrics += bitFlips;
															#line 1605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
						}
					}
				}
			}
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Optional<std::pair<WorkerEvents, std::set<std::string>>> const& __workerEvents,int loopDepth) 
	{
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		workerEvents = __workerEvents;
															#line 1624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<std::pair<WorkerEvents, std::set<std::string>>> && __workerEvents,int loopDepth) 
	{
		workerEvents = std::move(__workerEvents);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChaosGetStatusActor*>(this)->actor_wait_state > 0) static_cast<ChaosGetStatusActor*>(this)->actor_wait_state = 0;
		static_cast<ChaosGetStatusActor*>(this)->ActorCallback< ChaosGetStatusActor, 1, Optional<std::pair<WorkerEvents, std::set<std::string>>> >::remove();

	}
	void a_callback_fire(ActorCallback< ChaosGetStatusActor, 1, Optional<std::pair<WorkerEvents, std::set<std::string>>> >*,Optional<std::pair<WorkerEvents, std::set<std::string>>> const& value) 
	{
		fdb_probe_actor_enter("chaosGetStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosGetStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChaosGetStatusActor, 1, Optional<std::pair<WorkerEvents, std::set<std::string>>> >*,Optional<std::pair<WorkerEvents, std::set<std::string>>> && value) 
	{
		fdb_probe_actor_enter("chaosGetStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosGetStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChaosGetStatusActor, 1, Optional<std::pair<WorkerEvents, std::set<std::string>>> >*,Error err) 
	{
		fdb_probe_actor_enter("chaosGetStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosGetStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (!static_cast<ChaosGetStatusActor*>(this)->SAV<int>::futures) { (void)(foundChaosMetrics); this->~ChaosGetStatusActorState(); static_cast<ChaosGetStatusActor*>(this)->destroy(); return 0; }
															#line 1703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		new (&static_cast<ChaosGetStatusActor*>(this)->SAV< int >::value()) int(std::move(foundChaosMetrics)); // state_var_RVO
		this->~ChaosGetStatusActorState();
		static_cast<ChaosGetStatusActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			if (e.code() != error_code_attribute_not_found)
															#line 1716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			{
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
				TraceEvent(SevError, "ChaosGetStatus").error(e);
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	DiskFailureInjectionWorkload* self;
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	int foundChaosMetrics;
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	Optional<std::pair<WorkerEvents, std::set<std::string>>> workerEvents;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	WorkerEvents cMetrics;
															#line 1757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via chaosGetStatus()
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
class ChaosGetStatusActor final : public Actor<int>, public ActorCallback< ChaosGetStatusActor, 0, std::vector<WorkerDetails> >, public ActorCallback< ChaosGetStatusActor, 1, Optional<std::pair<WorkerEvents, std::set<std::string>>> >, public FastAllocated<ChaosGetStatusActor>, public ChaosGetStatusActorState<ChaosGetStatusActor> {
															#line 1762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
public:
	using FastAllocated<ChaosGetStatusActor>::operator new;
	using FastAllocated<ChaosGetStatusActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5480346760442327552UL, 17346671358713029888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChaosGetStatusActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< ChaosGetStatusActor, 1, Optional<std::pair<WorkerEvents, std::set<std::string>>> >;
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	ChaosGetStatusActor(DiskFailureInjectionWorkload* const& self) 
															#line 1780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   ChaosGetStatusActorState<ChaosGetStatusActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("chaosGetStatus", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11235370377393379328UL, 14288066851922157824UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("chaosGetStatus");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("chaosGetStatus", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChaosGetStatusActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChaosGetStatusActor, 1, Optional<std::pair<WorkerEvents, std::set<std::string>>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
[[nodiscard]] static Future<int> chaosGetStatus( DiskFailureInjectionWorkload* const& self ) {
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	return Future<int>(new ChaosGetStatusActor(self));
															#line 1813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
}

#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"

	// Periodically re-send the chaos event in case of a process restart
																#line 1819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
// This generated class is to be used only via periodicEventBroadcast()
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
template <class PeriodicEventBroadcastActor>
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
class PeriodicEventBroadcastActorState {
															#line 1825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
public:
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	PeriodicEventBroadcastActorState(DiskFailureInjectionWorkload* const& self) 
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		 : self(self)
															#line 1832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("periodicEventBroadcast", reinterpret_cast<unsigned long>(this));

	}
	~PeriodicEventBroadcastActorState() 
	{
		fdb_probe_actor_destroy("periodicEventBroadcast", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ::delay(self->startDelay);
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			if (static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state = 1;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PeriodicEventBroadcastActor, 0, Void >*>(static_cast<PeriodicEventBroadcastActor*>(this)));
															#line 1854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PeriodicEventBroadcastActorState();
		static_cast<PeriodicEventBroadcastActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		start = now();
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		elapsed = 0.0;
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		;
															#line 1881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		start = now();
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		elapsed = 0.0;
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		;
															#line 1894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state > 0) static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state = 0;
		static_cast<PeriodicEventBroadcastActor*>(this)->ActorCallback< PeriodicEventBroadcastActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PeriodicEventBroadcastActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PeriodicEventBroadcastActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PeriodicEventBroadcastActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayUntil(start + elapsed);
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state = 2;
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PeriodicEventBroadcastActor, 1, Void >*>(static_cast<PeriodicEventBroadcastActor*>(this)));
															#line 1992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = reSendChaos(self);
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state = 3;
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PeriodicEventBroadcastActor, 2, Void >*>(static_cast<PeriodicEventBroadcastActor*>(this)));
															#line 2008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = reSendChaos(self);
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state = 3;
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PeriodicEventBroadcastActor, 2, Void >*>(static_cast<PeriodicEventBroadcastActor*>(this)));
															#line 2024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state > 0) static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state = 0;
		static_cast<PeriodicEventBroadcastActor*>(this)->ActorCallback< PeriodicEventBroadcastActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PeriodicEventBroadcastActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PeriodicEventBroadcastActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PeriodicEventBroadcastActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		elapsed += self->periodicBroadcastInterval;
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delayUntil(start + elapsed);
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state = 4;
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PeriodicEventBroadcastActor, 3, Void >*>(static_cast<PeriodicEventBroadcastActor*>(this)));
															#line 2117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		elapsed += self->periodicBroadcastInterval;
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delayUntil(start + elapsed);
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state = 4;
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PeriodicEventBroadcastActor, 3, Void >*>(static_cast<PeriodicEventBroadcastActor*>(this)));
															#line 2135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state > 0) static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state = 0;
		static_cast<PeriodicEventBroadcastActor*>(this)->ActorCallback< PeriodicEventBroadcastActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PeriodicEventBroadcastActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PeriodicEventBroadcastActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PeriodicEventBroadcastActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		StrictFuture<int> __when_expr_4 = chaosGetStatus(self);
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state = 5;
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PeriodicEventBroadcastActor, 4, int >*>(static_cast<PeriodicEventBroadcastActor*>(this)));
															#line 2226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		StrictFuture<int> __when_expr_4 = chaosGetStatus(self);
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state = 5;
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PeriodicEventBroadcastActor, 4, int >*>(static_cast<PeriodicEventBroadcastActor*>(this)));
															#line 2242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state > 0) static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state = 0;
		static_cast<PeriodicEventBroadcastActor*>(this)->ActorCallback< PeriodicEventBroadcastActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PeriodicEventBroadcastActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PeriodicEventBroadcastActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PeriodicEventBroadcastActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont4(int const& foundChaosMetrics,int loopDepth) 
	{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (foundChaosMetrics > 0)
															#line 2326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		{
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			TraceEvent("FoundChaos") .detail("ChaosMetricCount", foundChaosMetrics) .detail("ClientID", self->clientId);
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			if (!static_cast<PeriodicEventBroadcastActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PeriodicEventBroadcastActorState(); static_cast<PeriodicEventBroadcastActor*>(this)->destroy(); return 0; }
															#line 2332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			new (&static_cast<PeriodicEventBroadcastActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~PeriodicEventBroadcastActorState();
			static_cast<PeriodicEventBroadcastActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(int && foundChaosMetrics,int loopDepth) 
	{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
		if (foundChaosMetrics > 0)
															#line 2346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		{
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			TraceEvent("FoundChaos") .detail("ChaosMetricCount", foundChaosMetrics) .detail("ClientID", self->clientId);
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
			if (!static_cast<PeriodicEventBroadcastActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PeriodicEventBroadcastActorState(); static_cast<PeriodicEventBroadcastActor*>(this)->destroy(); return 0; }
															#line 2352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
			new (&static_cast<PeriodicEventBroadcastActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~PeriodicEventBroadcastActorState();
			static_cast<PeriodicEventBroadcastActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(int const& foundChaosMetrics,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(foundChaosMetrics, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(int && foundChaosMetrics,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(foundChaosMetrics), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state > 0) static_cast<PeriodicEventBroadcastActor*>(this)->actor_wait_state = 0;
		static_cast<PeriodicEventBroadcastActor*>(this)->ActorCallback< PeriodicEventBroadcastActor, 4, int >::remove();

	}
	void a_callback_fire(ActorCallback< PeriodicEventBroadcastActor, 4, int >*,int const& value) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< PeriodicEventBroadcastActor, 4, int >*,int && value) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< PeriodicEventBroadcastActor, 4, int >*,Error err) 
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	DiskFailureInjectionWorkload* self;
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	double start;
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	double elapsed;
															#line 2443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via periodicEventBroadcast()
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
class PeriodicEventBroadcastActor final : public Actor<Void>, public ActorCallback< PeriodicEventBroadcastActor, 0, Void >, public ActorCallback< PeriodicEventBroadcastActor, 1, Void >, public ActorCallback< PeriodicEventBroadcastActor, 2, Void >, public ActorCallback< PeriodicEventBroadcastActor, 3, Void >, public ActorCallback< PeriodicEventBroadcastActor, 4, int >, public FastAllocated<PeriodicEventBroadcastActor>, public PeriodicEventBroadcastActorState<PeriodicEventBroadcastActor> {
															#line 2448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
public:
	using FastAllocated<PeriodicEventBroadcastActor>::operator new;
	using FastAllocated<PeriodicEventBroadcastActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15665903334382291712UL, 17156450103847527168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PeriodicEventBroadcastActor, 0, Void >;
friend struct ActorCallback< PeriodicEventBroadcastActor, 1, Void >;
friend struct ActorCallback< PeriodicEventBroadcastActor, 2, Void >;
friend struct ActorCallback< PeriodicEventBroadcastActor, 3, Void >;
friend struct ActorCallback< PeriodicEventBroadcastActor, 4, int >;
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	PeriodicEventBroadcastActor(DiskFailureInjectionWorkload* const& self) 
															#line 2469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PeriodicEventBroadcastActorState<PeriodicEventBroadcastActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6304356016528455936UL, 716472045906653952UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicEventBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("periodicEventBroadcast");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("periodicEventBroadcast", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PeriodicEventBroadcastActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PeriodicEventBroadcastActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PeriodicEventBroadcastActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PeriodicEventBroadcastActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< PeriodicEventBroadcastActor, 4, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
[[nodiscard]] static Future<Void> periodicEventBroadcast( DiskFailureInjectionWorkload* const& self ) {
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
	return Future<Void>(new PeriodicEventBroadcastActor(self));
															#line 2505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/DiskFailureInjection.actor.g.cpp.py_gen"
}

#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/DiskFailureInjection.actor.cpp"
};
WorkloadFactory<DiskFailureInjectionWorkload> DiskFailureInjectionWorkloadFactory;
FailureInjectorFactory<DiskFailureInjectionWorkload> DiskFailureInjectionWorkloadFailureInjectionFactory;
