#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
/*
 * ConsistencyCheckUrgent.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <math.h>
#include "boost/lexical_cast.hpp"

#include "flow/IRandom.h"
#include "flow/ProcessEvents.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/FDBTypes.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/IRateControl.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/Knobs.h"
#include "flow/DeterministicRandom.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/StorageServerInterface.h"
#include "flow/network.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// The ConsistencyCheckUrgent workload is designed to support the consistency check
// urgent feature, a distributed version of the consistency check which emphasizes
// the completeness of checking and the distributed fashion.
// The ConsistencyCheckUrgent workload emphasizes the completeness of data consistency check ---
// if any shard is failed to check, this information will be propagated to the user.
// To support to the distributed fashion, the ConsistencyCheckUrgent workload takes
// rangesToCheck and consistencyCheckerId as the input and check the data consistency of
// the input ranges.
// On the other hand, the ConsistencyCheck workload is used for a single-threaded consistency
// check feature and includes many checks other than the data consistency check, such as
// shard size estimation evaluation. However, the ConsistencyCheck workload cannot guarantee
// the complete check and users cannot specify input range to check. Therefore, the
// ConsistencyCheck workload cannot meet the requirement of the consistency check urgent feature.
struct ConsistencyCheckUrgentWorkload : TestWorkload {
	static constexpr auto NAME = "ConsistencyCheckUrgent";

	int64_t consistencyCheckerId;

	ConsistencyCheckUrgentWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		consistencyCheckerId = sharedRandomNumber;
	}

																#line 64 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getKeyLocationsForRangeList()
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
template <class GetKeyLocationsForRangeListActor>
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
class GetKeyLocationsForRangeListActorState {
															#line 70 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
public:
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	GetKeyLocationsForRangeListActorState(Database const& cx,std::vector<KeyRange> const& ranges,ConsistencyCheckUrgentWorkload* const& self) 
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		 : cx(cx),
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		   ranges(ranges),
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		   self(self),
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		   beginKeyToReadKeyServer(),
															#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		   endKeyToReadKeyServer()
															#line 85 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyLocationsForRangeListActorState() 
	{
		fdb_probe_actor_destroy("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			for(int i = 0;i < ranges.size();i++) {
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				if (i == 0 || ranges[i].begin < beginKeyToReadKeyServer)
															#line 102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				{
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					beginKeyToReadKeyServer = ranges[i].begin;
															#line 106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				}
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				if (i == 0 || ranges[i].end > endKeyToReadKeyServer)
															#line 110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				{
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					endKeyToReadKeyServer = ranges[i].end;
															#line 114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				}
			}
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterGetKeyLocationsForRangeList") .detail("RangeBegin", beginKeyToReadKeyServer) .detail("RangeEnd", endKeyToReadKeyServer) .detail("ClientCount", self->clientCount) .detail("ClientId", self->clientId);
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			res = std::vector<std::pair<KeyRange, Value>>();
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			tr = Transaction(cx);
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			;
															#line 125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyLocationsForRangeListActorState();
		static_cast<GetKeyLocationsForRangeListActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (!static_cast<GetKeyLocationsForRangeListActor*>(this)->SAV<std::vector<std::pair<KeyRange, Value>>>::futures) { (void)(res); this->~GetKeyLocationsForRangeListActorState(); static_cast<GetKeyLocationsForRangeListActor*>(this)->destroy(); return 0; }
															#line 148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		new (&static_cast<GetKeyLocationsForRangeListActor*>(this)->SAV< std::vector<std::pair<KeyRange, Value>> >::value()) std::vector<std::pair<KeyRange, Value>>(std::move(res)); // state_var_RVO
		this->~GetKeyLocationsForRangeListActorState();
		static_cast<GetKeyLocationsForRangeListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			KeyRange rangeToRead = Standalone(KeyRangeRef(beginKeyToReadKeyServer, endKeyToReadKeyServer));
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, keyServersPrefix, rangeToRead, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES);
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (static_cast<GetKeyLocationsForRangeListActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKeyLocationsForRangeListActor*>(this)->actor_wait_state = 1;
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocationsForRangeListActor, 0, RangeResult >*>(static_cast<GetKeyLocationsForRangeListActor*>(this)));
															#line 183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterRetryGetKeyLocationsForRangeList") .error(e) .detail("ClientCount", self->clientCount) .detail("ClientId", self->clientId);
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (static_cast<GetKeyLocationsForRangeListActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetKeyLocationsForRangeListActor*>(this)->actor_wait_state = 2;
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocationsForRangeListActor, 1, Void >*>(static_cast<GetKeyLocationsForRangeListActor*>(this)));
															#line 227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& readResult,int loopDepth) 
	{
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;++i) {
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			KeyRange rangeToCheck = Standalone(KeyRangeRef(readResult[i].key, readResult[i + 1].key));
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			Value valueToCheck = Standalone(readResult[i].value);
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			bool toAdd = false;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			for( const auto& range : ranges ) {
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				if (rangeToCheck.intersects(range) == true)
															#line 252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				{
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					toAdd = true;
															#line 256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
					break;
				}
			}
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (toAdd == true)
															#line 262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				res.push_back(std::make_pair(rangeToCheck, valueToCheck));
															#line 266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			beginKeyToReadKeyServer = readResult[i + 1].key;
															#line 270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (beginKeyToReadKeyServer >= endKeyToReadKeyServer)
															#line 274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && readResult,int loopDepth) 
	{
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;++i) {
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			KeyRange rangeToCheck = Standalone(KeyRangeRef(readResult[i].key, readResult[i + 1].key));
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			Value valueToCheck = Standalone(readResult[i].value);
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			bool toAdd = false;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			for( const auto& range : ranges ) {
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				if (rangeToCheck.intersects(range) == true)
															#line 296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				{
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					toAdd = true;
															#line 300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
					break;
				}
			}
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (toAdd == true)
															#line 306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				res.push_back(std::make_pair(rangeToCheck, valueToCheck));
															#line 310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			beginKeyToReadKeyServer = readResult[i + 1].key;
															#line 314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (beginKeyToReadKeyServer >= endKeyToReadKeyServer)
															#line 318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& readResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(readResult, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && readResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(readResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyLocationsForRangeListActor*>(this)->actor_wait_state > 0) static_cast<GetKeyLocationsForRangeListActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyLocationsForRangeListActor*>(this)->ActorCallback< GetKeyLocationsForRangeListActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsForRangeListActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsForRangeListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsForRangeListActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsForRangeListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyLocationsForRangeListActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsForRangeListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyLocationsForRangeListActor*>(this)->actor_wait_state > 0) static_cast<GetKeyLocationsForRangeListActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyLocationsForRangeListActor*>(this)->ActorCallback< GetKeyLocationsForRangeListActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsForRangeListActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsForRangeListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsForRangeListActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsForRangeListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyLocationsForRangeListActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsForRangeListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	Database cx;
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	ConsistencyCheckUrgentWorkload* self;
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	Key beginKeyToReadKeyServer;
															#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	Key endKeyToReadKeyServer;
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	std::vector<std::pair<KeyRange, Value>> res;
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	Transaction tr;
															#line 515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getKeyLocationsForRangeList()
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
class GetKeyLocationsForRangeListActor final : public Actor<std::vector<std::pair<KeyRange, Value>>>, public ActorCallback< GetKeyLocationsForRangeListActor, 0, RangeResult >, public ActorCallback< GetKeyLocationsForRangeListActor, 1, Void >, public FastAllocated<GetKeyLocationsForRangeListActor>, public GetKeyLocationsForRangeListActorState<GetKeyLocationsForRangeListActor> {
															#line 520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetKeyLocationsForRangeListActor>::operator new;
	using FastAllocated<GetKeyLocationsForRangeListActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(531752466972618496UL, 15414033472061814016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<KeyRange, Value>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyLocationsForRangeListActor, 0, RangeResult >;
friend struct ActorCallback< GetKeyLocationsForRangeListActor, 1, Void >;
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	GetKeyLocationsForRangeListActor(Database const& cx,std::vector<KeyRange> const& ranges,ConsistencyCheckUrgentWorkload* const& self) 
															#line 538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		 : Actor<std::vector<std::pair<KeyRange, Value>>>(),
		   GetKeyLocationsForRangeListActorState<GetKeyLocationsForRangeListActor>(cx, ranges, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(938853452240254208UL, 4590311321882889984UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsForRangeListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyLocationsForRangeList");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyLocationsForRangeList", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyLocationsForRangeListActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyLocationsForRangeListActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
[[nodiscard]] Future<std::vector<std::pair<KeyRange, Value>>> getKeyLocationsForRangeList( Database const& cx, std::vector<KeyRange> const& ranges, ConsistencyCheckUrgentWorkload* const& self ) {
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	return Future<std::vector<std::pair<KeyRange, Value>>>(new GetKeyLocationsForRangeListActor(cx, ranges, self));
															#line 571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
}

#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"

																#line 576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getVersion()
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
template <class GetVersionActor>
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
class GetVersionActorState {
															#line 582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
public:
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	GetVersionActorState(Database const& cx) 
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		 : cx(cx)
															#line 589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionActorState() 
	{
		fdb_probe_actor_destroy("getVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			;
															#line 604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		tr = Transaction(cx);
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		try {
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (static_cast<GetVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionActor*>(this)->actor_wait_state = 1;
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionActor, 0, Version >*>(static_cast<GetVersionActor*>(this)));
															#line 647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (static_cast<GetVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetVersionActor*>(this)->actor_wait_state = 2;
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetVersionActor, 1, Void >*>(static_cast<GetVersionActor*>(this)));
															#line 676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& version,int loopDepth) 
	{
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionActor*>(this)->SAV< Version >::value()) Version(version);
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && version,int loopDepth) 
	{
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionActor*>(this)->SAV< Version >::value()) Version(version);
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionActor*>(this)->actor_wait_state > 0) static_cast<GetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionActor*>(this)->ActorCallback< GetVersionActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetVersionActor*>(this)->actor_wait_state > 0) static_cast<GetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionActor*>(this)->ActorCallback< GetVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	Database cx;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	Transaction tr;
															#line 877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getVersion()
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
class GetVersionActor final : public Actor<Version>, public ActorCallback< GetVersionActor, 0, Version >, public ActorCallback< GetVersionActor, 1, Void >, public FastAllocated<GetVersionActor>, public GetVersionActorState<GetVersionActor> {
															#line 882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetVersionActor>::operator new;
	using FastAllocated<GetVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8087913083251931392UL, 5827621136837133568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionActor, 0, Version >;
friend struct ActorCallback< GetVersionActor, 1, Void >;
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	GetVersionActor(Database const& cx) 
															#line 900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   GetVersionActorState<GetVersionActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4509831120537103360UL, 13615306933804954880UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
[[nodiscard]] Future<Version> getVersion( Database const& cx ) {
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	return Future<Version>(new GetVersionActor(cx));
															#line 933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
}

#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"

																#line 938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
// This generated class is to be used only via checkDataConsistencyUrgent()
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
template <class CheckDataConsistencyUrgentActor>
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
class CheckDataConsistencyUrgentActorState {
															#line 944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
public:
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	CheckDataConsistencyUrgentActorState(Database const& cx,std::vector<KeyRange> const& rangesToCheck,ConsistencyCheckUrgentWorkload* const& self,int const& consistencyCheckEpoch) 
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		 : cx(cx),
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		   rangesToCheck(rangesToCheck),
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		   self(self),
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		   consistencyCheckEpoch(consistencyCheckEpoch),
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		   shardLocationPairList(),
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		   retryCount(0)
															#line 961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this));

	}
	~CheckDataConsistencyUrgentActorState() 
	{
		fdb_probe_actor_destroy("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			;
															#line 976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckDataConsistencyUrgentActorState();
		static_cast<CheckDataConsistencyUrgentActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterStartTask") .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("RangeToCheck", rangesToCheck.size()) .detail("ShardToCheck", shardLocationPairList.size()) .detail("ClientCount", self->clientCount) .detail("ClientId", self->clientId) .detail("ConsistencyCheckEpoch", consistencyCheckEpoch);
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		rateLimiter = Reference<IRateControl>(new SpeedLimit(CLIENT_KNOBS->CONSISTENCY_CHECK_RATE_LIMIT_MAX, 1));
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		failedRanges = KeyRangeMap<bool>();
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		failedRanges.insert(allKeys, false);
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		numShardThisClient = shardLocationPairList.size();
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		numShardToCheck = -1;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		numCompleteShards = 0;
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		numFailedShards = 0;
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		shardIdx = 0;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		;
															#line 1017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			shardLocationPairList.clear();
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(shardLocationPairList, self->getKeyLocationsForRangeList(cx, rangesToCheck, self));
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 1;
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 0, Void >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 1043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			TraceEvent(SevWarn, "ConsistencyCheckUrgent_TesterGetKeyLocationListFailed") .error(e) .detail("RetryCount", retryCount) .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ClientId", self->clientId) .detail("ClientCount", self->clientCount) .detail("ConsistencyCheckEpoch", consistencyCheckEpoch);
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1090 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 2;
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 1, Void >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 1095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyUrgentActor*>(this)->ActorCallback< CheckDataConsistencyUrgentActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyUrgentActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		retryCount++;
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (retryCount > 50)
															#line 1199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			return a_body1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 1203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		retryCount++;
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (retryCount > 50)
															#line 1215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			return a_body1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 1219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyUrgentActor*>(this)->ActorCallback< CheckDataConsistencyUrgentActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyUrgentActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		failedRanges.coalesce(allKeys);
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		failedRangesToCheck = std::vector<KeyRange>();
															#line 551 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		failedRangesList = failedRanges.ranges();
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		failedRangesIter = failedRangesList.begin();
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		for(;failedRangesIter != failedRangesList.end();++failedRangesIter) {
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (failedRangesIter->value())
															#line 1314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				failedRangesToCheck.push_back(failedRangesIter->range());
															#line 1318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
		}
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (failedRangesToCheck.size() > 0)
															#line 1323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (consistencyCheckEpoch < CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RETRY_DEPTH_MAX)
															#line 1327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				StrictFuture<Void> __when_expr_10 = delay(60.0);
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont2when1(__when_expr_10.get(), loopDepth); };
				static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 11;
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 10, Void >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 1338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				TraceEvent(SevWarn, "ConsistencyCheckUrgent_TesterRetryDepthMax") .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("FailedCollectedRangeCount", failedRangesToCheck.size()) .detail("ConsistencyCheckEpoch", consistencyCheckEpoch) .detail("ClientId", self->clientId) .detail("ClientCount", self->clientCount);
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				return a_body1Catch1(consistency_check_urgent_task_failed(), loopDepth);
															#line 1347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (!(shardIdx < shardLocationPairList.size()))
															#line 1368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		numShardToCheck = numShardThisClient - shardIdx;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		range = shardLocationPairList[shardIdx].first;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		sourceStorageServers = std::vector<UID>();
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		destStorageServers = std::vector<UID>();
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		storageServerToTagMap = std::unordered_map<UID, Tag>();
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		retryCount = 0;
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		;
															#line 1386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1continue1(int loopDepth) 
	{
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		++shardIdx;
															#line 1408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (sourceStorageServers.size() == 0)
															#line 1417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			TraceEvent(SevWarnAlways, "ConsistencyCheckUrgent_TesterEmptySourceServers") .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ClientId", self->clientId) .detail("ClientCount", self->clientCount) .detail("ShardBegin", range.begin) .detail("ShardEnd", range.end) .detail("ConsistencyCheckEpoch", consistencyCheckEpoch);
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			numCompleteShards++;
															#line 1423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			return a_body1cont1continue1(loopDepth); // continue
		}
		else
		{
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (sourceStorageServers.size() == 1)
															#line 1430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				TraceEvent(SevWarn, "ConsistencyCheckUrgent_TesterSingleReplica") .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ClientId", self->clientId) .detail("ClientCount", self->clientCount) .detail("ShardBegin", range.begin) .detail("ShardEnd", range.end) .detail("ConsistencyCheckEpoch", consistencyCheckEpoch);
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				numCompleteShards++;
															#line 1436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				return a_body1cont1continue1(loopDepth); // continue
			}
		}
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		storageServers = sourceStorageServers;
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		storageServerInterfaces = std::vector<StorageServerInterface>();
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		retryCount = 0;
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		;
															#line 1448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			Transaction tr(cx);
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			StrictFuture<RangeResult> __when_expr_2 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 3;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 2, RangeResult >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 1480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 1519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			TraceEvent(SevWarn, "ConsistencyCheckUrgent_TesterGetUIDtoTagMapFailed") .error(e) .detail("RetryCount", retryCount) .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ClientId", self->clientId) .detail("ClientCount", self->clientCount) .detail("ShardBegin", range.begin) .detail("ShardEnd", range.end) .detail("ConsistencyCheckEpoch", consistencyCheckEpoch);
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(5.0);
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 4;
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 3, Void >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 1532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(RangeResult const& UIDtoTagMap,int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, shardLocationPairList[shardIdx].second, sourceStorageServers, destStorageServers, false);
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 1551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			storageServerToTagMap.reserve(UIDtoTagMap.size());
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			for( auto& it : UIDtoTagMap ) {
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				storageServerToTagMap[decodeServerTagKey(it.key)] = decodeServerTagValue(it.value);
															#line 1559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
		}
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(RangeResult && UIDtoTagMap,int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, shardLocationPairList[shardIdx].second, sourceStorageServers, destStorageServers, false);
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 1574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			storageServerToTagMap.reserve(UIDtoTagMap.size());
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			for( auto& it : UIDtoTagMap ) {
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				storageServerToTagMap[decodeServerTagKey(it.key)] = decodeServerTagValue(it.value);
															#line 1582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
		}
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(RangeResult const& UIDtoTagMap,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(UIDtoTagMap, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(RangeResult && UIDtoTagMap,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(UIDtoTagMap), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyUrgentActor*>(this)->ActorCallback< CheckDataConsistencyUrgentActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyUrgentActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		retryCount++;
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (retryCount > 50)
															#line 1670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			return a_body1Catch1(timed_out(), std::max(0, loopDepth - 2));
															#line 1674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		retryCount++;
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (retryCount > 50)
															#line 1686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			return a_body1Catch1(timed_out(), std::max(0, loopDepth - 2));
															#line 1690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyUrgentActor*>(this)->ActorCallback< CheckDataConsistencyUrgentActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyUrgentActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		totalReadAmount = 0;
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		shardReadAmount = 0;
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		shardKeyCompared = 0;
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		valueAvailableToCheck = true;
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		begin = firstGreaterOrEqual(range.begin);
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		;
															#line 1785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			Transaction tr(cx);
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			std::vector<Future<Optional<Value>>> serverListEntries;
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			for(int s = 0;s < storageServers.size();s++) {
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				serverListEntries.push_back(tr.get(serverListKeyFor(storageServers[s])));
															#line 1814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			StrictFuture<std::vector<Optional<Value>>> __when_expr_4 = getAll(serverListEntries);
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont1loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 5;
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 4, std::vector<Optional<Value>> >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 1825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 1864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			StrictFuture<Void> __when_expr_5 = delay(5.0);
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 6;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 5, Void >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 1875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont2(int loopDepth) 
	{
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (!serverListValues[s].present())
															#line 1892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				TraceEvent(SevWarn, "ConsistencyCheckUrgent_TesterGetServerInterfaceFailed") .detail("SSID", storageServers[s]) .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ClientId", self->clientId) .detail("ClientCount", self->clientCount) .detail("ShardBegin", range.begin) .detail("ShardEnd", range.end) .detail("RetryCount", retryCount) .detail("ConsistencyCheckEpoch", consistencyCheckEpoch);
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				return a_body1cont1loopBody1cont1loopBody1Catch1(operation_failed(), loopDepth);
															#line 1898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			storageServerInterfaces.push_back(decodeServerListValue(serverListValues[s].get()));
															#line 1902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 1906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			for(int j = 0;j < storageServers.size();j++) {
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				auto iter = storageServerToTagMap.find(storageServers[j]);
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				ASSERT_WE_THINK(iter != storageServerToTagMap.end());
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				cx->addSSIdTagMapping(storageServerInterfaces[j].id(), iter->second);
															#line 1916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
		}
		return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(std::vector<Optional<Value>> const& __serverListValues,int loopDepth) 
	{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		serverListValues = __serverListValues;
															#line 1927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(std::vector<Optional<Value>> && __serverListValues,int loopDepth) 
	{
		serverListValues = std::move(__serverListValues);
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyUrgentActor*>(this)->ActorCallback< CheckDataConsistencyUrgentActor, 4, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 4, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 4, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyUrgentActor, 4, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		retryCount++;
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (retryCount > 10)
															#line 2008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			return a_body1Catch1(timed_out(), std::max(0, loopDepth - 2));
															#line 2012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		retryCount++;
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (retryCount > 10)
															#line 2024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			return a_body1Catch1(timed_out(), std::max(0, loopDepth - 2));
															#line 2028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyUrgentActor*>(this)->ActorCallback< CheckDataConsistencyUrgentActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyUrgentActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont7(int loopDepth) 
	{
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (!valueAvailableToCheck)
															#line 2113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 510 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			numFailedShards++;
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterShardFailed") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ClientId", self->clientId) .detail("ClientCount", self->clientCount) .detail("NumCompletedShards", numCompleteShards) .detail("NumFailedShards", numFailedShards) .detail("NumShardThisClient", numShardThisClient) .detail("NumShardToCheckThisEpoch", numShardToCheck - 1) .detail("ShardBegin", range.begin) .detail("ShardEnd", range.end) .detail("ReplicaCount", storageServers.size()) .detail("ConsistencyCheckEpoch", consistencyCheckEpoch) .detail("ShardBytesRead", shardReadAmount) .detail("ShardKeysCompared", shardKeyCompared);
															#line 2119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
		else
		{
															#line 528 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			numCompleteShards++;
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterShardComplete") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ClientId", self->clientId) .detail("ClientCount", self->clientCount) .detail("ShardBegin", range.begin) .detail("ShardEnd", range.end) .detail("ReplicaCount", storageServers.size()) .detail("NumCompletedShards", numCompleteShards) .detail("NumFailedShards", numFailedShards) .detail("NumShardThisClient", numShardThisClient) .detail("NumShardToCheckThisEpoch", numShardToCheck - 1) .detail("ConsistencyCheckEpoch", consistencyCheckEpoch) .detail("ShardBytesRead", shardReadAmount) .detail("ShardKeysCompared", shardKeyCompared);
															#line 2127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		++shardIdx;
															#line 2131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1(int loopDepth) 
	{
		try {
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			StrictFuture<Version> __when_expr_6 = self->getVersion(cx);
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1cont3loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1when1(__when_expr_6.get(), loopDepth); };
			static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 7;
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 6, Version >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 2155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 2194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterRetryDataConsistency").error(e);
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			StrictFuture<Void> __when_expr_9 = delay(5.0);
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont3loopBody1Catch1when1(__when_expr_9.get(), loopDepth); };
			static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 10;
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 9, Void >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 2207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont2(Version const& version,int loopDepth) 
	{
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		req = GetKeyValuesRequest();
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		req.begin = begin;
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		req.end = firstGreaterOrEqual(range.end);
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		req.limit = 1e4;
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (g_network->isSimulated() && SERVER_KNOBS->CONSISTENCY_CHECK_BACKWARD_READ)
															#line 2230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			req.limit = -1e4;
															#line 2234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		req.limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		req.version = version;
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		req.tags = TagSet();
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		j = 0;
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		for(j = 0;j < storageServerInterfaces.size();j++) {
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			resetReply(req);
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 2252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				cx->getLatestCommitVersion( storageServerInterfaces[j], req.version, req.ssLatestCommitVersions);
															#line 2256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			keyValueFutures.push_back( storageServerInterfaces[j].getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 2260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(keyValueFutures);
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1cont3loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 8;
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 7, Void >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 2271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont2(Version && version,int loopDepth) 
	{
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		req = GetKeyValuesRequest();
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		req.begin = begin;
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		req.end = firstGreaterOrEqual(range.end);
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		req.limit = 1e4;
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (g_network->isSimulated() && SERVER_KNOBS->CONSISTENCY_CHECK_BACKWARD_READ)
															#line 2288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			req.limit = -1e4;
															#line 2292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		req.limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		req.version = version;
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		req.tags = TagSet();
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		j = 0;
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		for(j = 0;j < storageServerInterfaces.size();j++) {
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			resetReply(req);
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 2310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				cx->getLatestCommitVersion( storageServerInterfaces[j], req.version, req.ssLatestCommitVersions);
															#line 2314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			keyValueFutures.push_back( storageServerInterfaces[j].getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 2318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(keyValueFutures);
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1cont3loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 8;
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 7, Void >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 2329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyUrgentActor*>(this)->ActorCallback< CheckDataConsistencyUrgentActor, 6, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 6, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 6, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyUrgentActor, 6, Version >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		for(j = 0;j < keyValueFutures.size();j++) {
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[j].get();
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (!rangeResult.present() || rangeResult.get().error.present())
															#line 2417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				valueAvailableToCheck = false;
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				TraceEvent e(SevInfo, "ConsistencyCheckUrgent_TesterGetRangeError");
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				e.detail("ResultPresent", rangeResult.present());
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				e.detail("StorageServer", storageServerInterfaces[j].uniqueID);
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				if (rangeResult.present())
															#line 2429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				{
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					e.detail("ErrorPresent", rangeResult.get().error.present());
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					if (rangeResult.get().error.present())
															#line 2435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
					{
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
						e.detail("Error", rangeResult.get().error.get().what());
															#line 2439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					e.detail("ResultNotPresentWithError", rangeResult.getError().what());
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					if (g_network->isSimulated() && g_simulator->getProcessByAddress(storageServerInterfaces[j].address())->failed)
															#line 2448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
					{
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
						e.detail("MachineFailed", "True");
															#line 2452 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
					}
				}
				break;
			}
		}
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (!valueAvailableToCheck)
															#line 2460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			failedRanges.insert(range, true);
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterShardAddedToRetry") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ClientId", self->clientId) .detail("ClientCount", self->clientCount) .detail("ShardBegin", range.begin) .detail("ShardEnd", range.end) .detail("ConsistencyCheckEpoch", consistencyCheckEpoch);
															#line 2466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			return a_body1cont1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		firstValidServer = -1;
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		totalReadAmount = 0;
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		for(j = 0;j < keyValueFutures.size();j++) {
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[j].get();
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			ASSERT(rangeResult.present() && !rangeResult.get().error.present());
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			current = rangeResult.get();
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			totalReadAmount += current.data.expectedSize();
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (firstValidServer == -1)
															#line 2485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				firstValidServer = j;
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				GetKeyValuesReply reference = keyValueFutures[firstValidServer].get().get();
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				shardKeyCompared += current.data.size();
															#line 2493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
			else
			{
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				GetKeyValuesReply reference = keyValueFutures[firstValidServer].get().get();
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				if (current.data != reference.data || current.more != reference.more)
															#line 2501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				{
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					int currentUniques = 0;
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					int referenceUniques = 0;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					int valueMismatches = 0;
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					int matchingKVPairs = 0;
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					KeyRef currentUniqueKey;
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					KeyRef referenceUniqueKey;
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					KeyRef valueMismatchKey;
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					int currentI = 0;
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					int referenceI = 0;
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					for(;currentI < current.data.size() || referenceI < reference.data.size();) {
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
						if (currentI >= current.data.size())
															#line 2525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
						{
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
							referenceUniqueKey = reference.data[referenceI].key;
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
							referenceUniques++;
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
							referenceI++;
															#line 2533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
						}
						else
						{
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
							if (referenceI >= reference.data.size())
															#line 2539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
							{
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
								currentUniqueKey = current.data[currentI].key;
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
								currentUniques++;
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
								currentI++;
															#line 2547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
							}
							else
							{
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
								KeyValueRef currentKV = current.data[currentI];
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
								KeyValueRef referenceKV = reference.data[referenceI];
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
								if (currentKV.key == referenceKV.key)
															#line 2557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
								{
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
									if (currentKV.value == referenceKV.value)
															#line 2561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
									{
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										matchingKVPairs++;
															#line 2565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
									}
									else
									{
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										valueMismatchKey = currentKV.key;
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										valueMismatches++;
															#line 2573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
									}
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
									currentI++;
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
									referenceI++;
															#line 2579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
								}
								else
								{
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
									if (currentKV.key < referenceKV.key)
															#line 2585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
									{
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										currentUniqueKey = currentKV.key;
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										currentUniques++;
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										currentI++;
															#line 2593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
									}
									else
									{
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										referenceUniqueKey = referenceKV.key;
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										referenceUniques++;
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										referenceI++;
															#line 2603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
									}
								}
							}
						}
					}
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					TraceEvent(SevError, "ConsistencyCheck_DataInconsistent") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail(format("StorageServer%d", j).c_str(), storageServers[j].toString()) .detail(format("StorageServer%d", firstValidServer).c_str(), storageServers[firstValidServer].toString()) .detail("RangeBegin", req.begin.getKey()) .detail("RangeEnd", req.end.getKey()) .detail("VersionNumber", req.version) .detail(format("Server%dUniques", j).c_str(), currentUniques) .detail(format("Server%dUniqueKey", j).c_str(), currentUniqueKey) .detail(format("Server%dUniques", firstValidServer).c_str(), referenceUniques) .detail(format("Server%dUniqueKey", firstValidServer).c_str(), referenceUniqueKey) .detail("ValueMismatches", valueMismatches) .detail("ValueMismatchKey", valueMismatchKey) .detail("MatchingKVPairs", matchingKVPairs) .detail("IsTSS", storageServerInterfaces[j].isTss() || storageServerInterfaces[firstValidServer].isTss() ? "True" : "False") .detail("ShardBegin", range.begin) .detail("ShardEnd", range.end);
															#line 2611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				}
			}
		}
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		StrictFuture<Void> __when_expr_8 = rateLimiter->getAllowance(totalReadAmount);
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1cont3loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont3when1(__when_expr_8.get(), loopDepth); };
		static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 9;
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 8, Void >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 2624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		for(j = 0;j < keyValueFutures.size();j++) {
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[j].get();
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (!rangeResult.present() || rangeResult.get().error.present())
															#line 2637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				valueAvailableToCheck = false;
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				TraceEvent e(SevInfo, "ConsistencyCheckUrgent_TesterGetRangeError");
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				e.detail("ResultPresent", rangeResult.present());
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				e.detail("StorageServer", storageServerInterfaces[j].uniqueID);
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				if (rangeResult.present())
															#line 2649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				{
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					e.detail("ErrorPresent", rangeResult.get().error.present());
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					if (rangeResult.get().error.present())
															#line 2655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
					{
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
						e.detail("Error", rangeResult.get().error.get().what());
															#line 2659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					e.detail("ResultNotPresentWithError", rangeResult.getError().what());
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					if (g_network->isSimulated() && g_simulator->getProcessByAddress(storageServerInterfaces[j].address())->failed)
															#line 2668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
					{
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
						e.detail("MachineFailed", "True");
															#line 2672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
					}
				}
				break;
			}
		}
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (!valueAvailableToCheck)
															#line 2680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			failedRanges.insert(range, true);
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterShardAddedToRetry") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ClientId", self->clientId) .detail("ClientCount", self->clientCount) .detail("ShardBegin", range.begin) .detail("ShardEnd", range.end) .detail("ConsistencyCheckEpoch", consistencyCheckEpoch);
															#line 2686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			return a_body1cont1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		firstValidServer = -1;
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		totalReadAmount = 0;
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		for(j = 0;j < keyValueFutures.size();j++) {
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[j].get();
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			ASSERT(rangeResult.present() && !rangeResult.get().error.present());
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			current = rangeResult.get();
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			totalReadAmount += current.data.expectedSize();
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (firstValidServer == -1)
															#line 2705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				firstValidServer = j;
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				GetKeyValuesReply reference = keyValueFutures[firstValidServer].get().get();
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				shardKeyCompared += current.data.size();
															#line 2713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
			else
			{
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				GetKeyValuesReply reference = keyValueFutures[firstValidServer].get().get();
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				if (current.data != reference.data || current.more != reference.more)
															#line 2721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				{
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					int currentUniques = 0;
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					int referenceUniques = 0;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					int valueMismatches = 0;
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					int matchingKVPairs = 0;
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					KeyRef currentUniqueKey;
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					KeyRef referenceUniqueKey;
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					KeyRef valueMismatchKey;
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					int currentI = 0;
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					int referenceI = 0;
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					for(;currentI < current.data.size() || referenceI < reference.data.size();) {
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
						if (currentI >= current.data.size())
															#line 2745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
						{
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
							referenceUniqueKey = reference.data[referenceI].key;
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
							referenceUniques++;
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
							referenceI++;
															#line 2753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
						}
						else
						{
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
							if (referenceI >= reference.data.size())
															#line 2759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
							{
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
								currentUniqueKey = current.data[currentI].key;
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
								currentUniques++;
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
								currentI++;
															#line 2767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
							}
							else
							{
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
								KeyValueRef currentKV = current.data[currentI];
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
								KeyValueRef referenceKV = reference.data[referenceI];
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
								if (currentKV.key == referenceKV.key)
															#line 2777 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
								{
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
									if (currentKV.value == referenceKV.value)
															#line 2781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
									{
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										matchingKVPairs++;
															#line 2785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
									}
									else
									{
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										valueMismatchKey = currentKV.key;
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										valueMismatches++;
															#line 2793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
									}
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
									currentI++;
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
									referenceI++;
															#line 2799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
								}
								else
								{
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
									if (currentKV.key < referenceKV.key)
															#line 2805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
									{
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										currentUniqueKey = currentKV.key;
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										currentUniques++;
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										currentI++;
															#line 2813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
									}
									else
									{
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										referenceUniqueKey = referenceKV.key;
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										referenceUniques++;
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
										referenceI++;
															#line 2823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
									}
								}
							}
						}
					}
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					TraceEvent(SevError, "ConsistencyCheck_DataInconsistent") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail(format("StorageServer%d", j).c_str(), storageServers[j].toString()) .detail(format("StorageServer%d", firstValidServer).c_str(), storageServers[firstValidServer].toString()) .detail("RangeBegin", req.begin.getKey()) .detail("RangeEnd", req.end.getKey()) .detail("VersionNumber", req.version) .detail(format("Server%dUniques", j).c_str(), currentUniques) .detail(format("Server%dUniqueKey", j).c_str(), currentUniqueKey) .detail(format("Server%dUniques", firstValidServer).c_str(), referenceUniques) .detail(format("Server%dUniqueKey", firstValidServer).c_str(), referenceUniqueKey) .detail("ValueMismatches", valueMismatches) .detail("ValueMismatchKey", valueMismatchKey) .detail("MatchingKVPairs", matchingKVPairs) .detail("IsTSS", storageServerInterfaces[j].isTss() || storageServerInterfaces[firstValidServer].isTss() ? "True" : "False") .detail("ShardBegin", range.begin) .detail("ShardEnd", range.end);
															#line 2831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				}
			}
		}
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		StrictFuture<Void> __when_expr_8 = rateLimiter->getAllowance(totalReadAmount);
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1cont3loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont3when1(__when_expr_8.get(), loopDepth); };
		static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 9;
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 8, Void >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 2844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyUrgentActor*>(this)->ActorCallback< CheckDataConsistencyUrgentActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont3loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont3loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyUrgentActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1cont3loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		shardReadAmount += totalReadAmount;
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		ASSERT(firstValidServer != -1);
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (keyValueFutures[firstValidServer].get().get().more)
															#line 2932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 488 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			VectorRef<KeyValueRef> result = keyValueFutures[firstValidServer].get().get().data;
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			ASSERT(result.size() > 0);
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			begin = firstGreaterThan(result[result.size() - 1].key);
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			ASSERT(begin.getKey() != allKeys.end);
															#line 2942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
		else
		{
			return a_body1cont1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont33(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		shardReadAmount += totalReadAmount;
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		ASSERT(firstValidServer != -1);
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (keyValueFutures[firstValidServer].get().get().more)
															#line 2960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 488 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			VectorRef<KeyValueRef> result = keyValueFutures[firstValidServer].get().get().data;
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			ASSERT(result.size() > 0);
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			begin = firstGreaterThan(result[result.size() - 1].key);
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			ASSERT(begin.getKey() != allKeys.end);
															#line 2970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
		else
		{
			return a_body1cont1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont33(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyUrgentActor*>(this)->ActorCallback< CheckDataConsistencyUrgentActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont3loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont3loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyUrgentActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1cont3loopBody1cont33(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyUrgentActor*>(this)->ActorCallback< CheckDataConsistencyUrgentActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont3loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont3loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyUrgentActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (consistencyCheckEpoch == 0)
															#line 3159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		{
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterEndTask") .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ShardCount", shardLocationPairList.size()) .detail("ClientId", self->clientId) .detail("ClientCount", self->clientCount);
															#line 3163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (!static_cast<CheckDataConsistencyUrgentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyUrgentActorState(); static_cast<CheckDataConsistencyUrgentActor*>(this)->destroy(); return 0; }
															#line 3167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		new (&static_cast<CheckDataConsistencyUrgentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckDataConsistencyUrgentActorState();
		static_cast<CheckDataConsistencyUrgentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterRetryFailedRanges") .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("FailedCollectedRangeCount", failedRangesToCheck.size()) .detail("ConsistencyCheckEpoch", consistencyCheckEpoch) .detail("ClientId", self->clientId) .detail("ClientCount", self->clientCount);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		StrictFuture<Void> __when_expr_11 = self->checkDataConsistencyUrgent(cx, failedRangesToCheck, self, consistencyCheckEpoch + 1);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont7when1(__when_expr_11.get(), loopDepth); };
		static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 12;
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 11, Void >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 3194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterRetryFailedRanges") .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("FailedCollectedRangeCount", failedRangesToCheck.size()) .detail("ConsistencyCheckEpoch", consistencyCheckEpoch) .detail("ClientId", self->clientId) .detail("ClientCount", self->clientCount);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		StrictFuture<Void> __when_expr_11 = self->checkDataConsistencyUrgent(cx, failedRangesToCheck, self, consistencyCheckEpoch + 1);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont7when1(__when_expr_11.get(), loopDepth); };
		static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 12;
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyUrgentActor, 11, Void >*>(static_cast<CheckDataConsistencyUrgentActor*>(this)));
															#line 3212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyUrgentActor*>(this)->ActorCallback< CheckDataConsistencyUrgentActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyUrgentActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyUrgentActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyUrgentActor*>(this)->ActorCallback< CheckDataConsistencyUrgentActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyUrgentActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyUrgentActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	Database cx;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	std::vector<KeyRange> rangesToCheck;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	ConsistencyCheckUrgentWorkload* self;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	int consistencyCheckEpoch;
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	std::vector<std::pair<KeyRange, Value>> shardLocationPairList;
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	int retryCount;
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	Reference<IRateControl> rateLimiter;
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	KeyRangeMap<bool> failedRanges;
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	int64_t numShardThisClient;
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	int64_t numShardToCheck;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	int64_t numCompleteShards;
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	int64_t numFailedShards;
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	int shardIdx;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	KeyRangeRef range;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	std::vector<UID> sourceStorageServers;
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	std::vector<UID> destStorageServers;
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	std::unordered_map<UID, Tag> storageServerToTagMap;
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	std::vector<UID> storageServers;
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	std::vector<StorageServerInterface> storageServerInterfaces;
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	std::vector<Optional<Value>> serverListValues;
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	int64_t totalReadAmount;
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	int64_t shardReadAmount;
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	int64_t shardKeyCompared;
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	bool valueAvailableToCheck;
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	KeySelector begin;
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	GetKeyValuesRequest req;
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyValuesReply>>> keyValueFutures;
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	int j;
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	int firstValidServer;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	GetKeyValuesReply current;
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	std::vector<KeyRange> failedRangesToCheck;
															#line 551 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	KeyRangeMap<bool>::Ranges failedRangesList;
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	KeyRangeMap<bool>::iterator failedRangesIter;
															#line 3445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkDataConsistencyUrgent()
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
class CheckDataConsistencyUrgentActor final : public Actor<Void>, public ActorCallback< CheckDataConsistencyUrgentActor, 0, Void >, public ActorCallback< CheckDataConsistencyUrgentActor, 1, Void >, public ActorCallback< CheckDataConsistencyUrgentActor, 2, RangeResult >, public ActorCallback< CheckDataConsistencyUrgentActor, 3, Void >, public ActorCallback< CheckDataConsistencyUrgentActor, 4, std::vector<Optional<Value>> >, public ActorCallback< CheckDataConsistencyUrgentActor, 5, Void >, public ActorCallback< CheckDataConsistencyUrgentActor, 6, Version >, public ActorCallback< CheckDataConsistencyUrgentActor, 7, Void >, public ActorCallback< CheckDataConsistencyUrgentActor, 8, Void >, public ActorCallback< CheckDataConsistencyUrgentActor, 9, Void >, public ActorCallback< CheckDataConsistencyUrgentActor, 10, Void >, public ActorCallback< CheckDataConsistencyUrgentActor, 11, Void >, public FastAllocated<CheckDataConsistencyUrgentActor>, public CheckDataConsistencyUrgentActorState<CheckDataConsistencyUrgentActor> {
															#line 3450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckDataConsistencyUrgentActor>::operator new;
	using FastAllocated<CheckDataConsistencyUrgentActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3950851174203916800UL, 13277741076442770432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckDataConsistencyUrgentActor, 0, Void >;
friend struct ActorCallback< CheckDataConsistencyUrgentActor, 1, Void >;
friend struct ActorCallback< CheckDataConsistencyUrgentActor, 2, RangeResult >;
friend struct ActorCallback< CheckDataConsistencyUrgentActor, 3, Void >;
friend struct ActorCallback< CheckDataConsistencyUrgentActor, 4, std::vector<Optional<Value>> >;
friend struct ActorCallback< CheckDataConsistencyUrgentActor, 5, Void >;
friend struct ActorCallback< CheckDataConsistencyUrgentActor, 6, Version >;
friend struct ActorCallback< CheckDataConsistencyUrgentActor, 7, Void >;
friend struct ActorCallback< CheckDataConsistencyUrgentActor, 8, Void >;
friend struct ActorCallback< CheckDataConsistencyUrgentActor, 9, Void >;
friend struct ActorCallback< CheckDataConsistencyUrgentActor, 10, Void >;
friend struct ActorCallback< CheckDataConsistencyUrgentActor, 11, Void >;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	CheckDataConsistencyUrgentActor(Database const& cx,std::vector<KeyRange> const& rangesToCheck,ConsistencyCheckUrgentWorkload* const& self,int const& consistencyCheckEpoch) 
															#line 3478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckDataConsistencyUrgentActorState<CheckDataConsistencyUrgentActor>(cx, rangesToCheck, self, consistencyCheckEpoch),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16258864572408875008UL, 11519307912219267072UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyUrgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkDataConsistencyUrgent");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkDataConsistencyUrgent", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckDataConsistencyUrgentActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckDataConsistencyUrgentActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckDataConsistencyUrgentActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckDataConsistencyUrgentActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckDataConsistencyUrgentActor, 4, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CheckDataConsistencyUrgentActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CheckDataConsistencyUrgentActor, 6, Version >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CheckDataConsistencyUrgentActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CheckDataConsistencyUrgentActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CheckDataConsistencyUrgentActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< CheckDataConsistencyUrgentActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< CheckDataConsistencyUrgentActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
[[nodiscard]] Future<Void> checkDataConsistencyUrgent( Database const& cx, std::vector<KeyRange> const& rangesToCheck, ConsistencyCheckUrgentWorkload* const& self, int const& consistencyCheckEpoch ) {
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	return Future<Void>(new CheckDataConsistencyUrgentActor(cx, rangesToCheck, self, consistencyCheckEpoch));
															#line 3521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
}

#line 589 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"

																#line 3526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
template <class _startActor>
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
class _startActorState {
															#line 3532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
public:
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	_startActorState(Database const& cx,ConsistencyCheckUrgentWorkload* const& self) 
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		 : cx(cx),
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		   self(self)
															#line 3541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterStart") .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ClientCount", self->clientCount) .detail("ClientId", self->clientId);
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				if (self->rangesToCheck.size() == 0)
															#line 3559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				{
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterExit") .detail("Reason", "AssignedEmptyRangeToCheck") .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ClientCount", self->clientCount) .detail("ClientId", self->clientId);
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
					new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~_startActorState();
					static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				if (g_network->isSimulated() && deterministicRandom()->coinflip())
															#line 3573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				{
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterMimicFailure") .detail("ClientCount", self->clientCount) .detail("ClientId", self->clientId);
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					return a_body1Catch2(operation_failed(), loopDepth);
															#line 3579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				}
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->checkDataConsistencyUrgent(cx, self->rangesToCheck, self, 0);
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 3590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			std::string reason;
															#line 621 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			Severity sev = SevInfo;
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			{
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
			}
			else
			{
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
				if (e.code() == error_code_timed_out)
															#line 3646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				{
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					reason = "Operation retried too many times";
															#line 3650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
				}
				else
				{
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
					if (e.code() == error_code_consistency_check_urgent_task_failed)
															#line 3656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
					{
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
						reason = "Retry failed ranges for too many times";
															#line 3660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
					}
					else
					{
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
						reason = "Unexpected failure";
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
						sev = SevWarnAlways;
															#line 3668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
					}
				}
			}
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			TraceEvent(sev, "ConsistencyCheckUrgent_TesterExit") .error(e) .detail("Reason", reason) .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ClientCount", self->clientCount) .detail("ClientId", self->clientId);
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
			return a_body1Catch1(consistency_check_urgent_task_failed(), loopDepth);
															#line 3676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterExit") .detail("Reason", "CompleteCheck") .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ClientCount", self->clientCount) .detail("ClientId", self->clientId);
															#line 3690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterExit") .detail("Reason", "CompleteCheck") .detail("ConsistencyCheckerId", self->consistencyCheckerId) .detail("ClientCount", self->clientCount) .detail("ClientId", self->clientId);
															#line 3699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	Database cx;
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	ConsistencyCheckUrgentWorkload* self;
															#line 3796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 3801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17618561063733198080UL, 17075883667521314560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	_startActor(Database const& cx,ConsistencyCheckUrgentWorkload* const& self) 
															#line 3818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, ConsistencyCheckUrgentWorkload* const& self ) {
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 3850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheckUrgent.actor.g.cpp.py_gen"
}

#line 642 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheckUrgent.actor.cpp"

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		TraceEvent("ConsistencyCheckUrgent_EnterWorkload").detail("ConsistencyCheckerId", consistencyCheckerId);
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<ConsistencyCheckUrgentWorkload> ConsistencyCheckUrgentWorkloadFactory;
