#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
/*
 * ChangeConfig.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/ClusterInterface.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/Schemas.h"
#include "flow/ApiVersion.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct ChangeConfigWorkload : TestWorkload {
	static constexpr auto NAME = "ChangeConfig";
	double minDelayBeforeChange, maxDelayBeforeChange;
	std::string configMode; //<\"single\"|\"double\"|\"triple\">
	std::string networkAddresses; // comma separated list e.g. "127.0.0.1:4000,127.0.0.1:4001"
	int coordinatorChanges; // number of times to change coordinators. Only applied if `coordinators` is set to `auto`

	ChangeConfigWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		minDelayBeforeChange = getOption(options, "minDelayBeforeChange"_sr, 0);
		maxDelayBeforeChange = getOption(options, "maxDelayBeforeChange"_sr, 0);
		ASSERT(maxDelayBeforeChange >= minDelayBeforeChange);
		configMode = getOption(options, "configMode"_sr, StringRef()).toString();
		networkAddresses = getOption(options, "coordinators"_sr, StringRef()).toString();
		coordinatorChanges = getOption(options, "coordinatorChanges"_sr, 1);
		if (networkAddresses != "auto") {
			coordinatorChanges = 1;
		}
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.insert("all"); }

	Future<Void> start(Database const& cx) override {
		if (this->clientId != 0)
			return Void();
		return ChangeConfigClient(cx->clone(), this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	std::string getConfigMode(const std::string& configMode, bool existingDB) {
		std::string res = configMode;
		if (existingDB) {
			size_t pos = res.find("new ");
			if (pos != std::string::npos) {
				res.replace(pos, 4, ""); // 4 is the length of "new "
			}
		}
		return res;
	}

																#line 76 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
// This generated class is to be used only via configureExtraDatabase()
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
template <class ConfigureExtraDatabaseActor>
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
class ConfigureExtraDatabaseActorState {
															#line 82 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
public:
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	ConfigureExtraDatabaseActorState(ChangeConfigWorkload* const& self,Database const& db) 
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		 : self(self),
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		   db(db)
															#line 91 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("configureExtraDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureExtraDatabaseActorState() 
	{
		fdb_probe_actor_destroy("configureExtraDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(5 * deterministicRandom()->random01());
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 1;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureExtraDatabaseActor, 0, Void >*>(static_cast<ConfigureExtraDatabaseActor*>(this)));
															#line 113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureExtraDatabaseActorState();
		static_cast<ConfigureExtraDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (self->configMode.size())
															#line 136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		{
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			existingDB = false;
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (g_simulator->startingDisabledConfiguration != "")
															#line 142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			{
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				StrictFuture<Void> __when_expr_1 = success( ManagementAPI::changeConfig(db.getReference(), g_simulator->startingDisabledConfiguration, true));
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 2;
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureExtraDatabaseActor, 1, Void >*>(static_cast<ConfigureExtraDatabaseActor*>(this)));
															#line 153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (self->configMode.size())
															#line 172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		{
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			existingDB = false;
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (g_simulator->startingDisabledConfiguration != "")
															#line 178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			{
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				StrictFuture<Void> __when_expr_1 = success( ManagementAPI::changeConfig(db.getReference(), g_simulator->startingDisabledConfiguration, true));
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 2;
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureExtraDatabaseActor, 1, Void >*>(static_cast<ConfigureExtraDatabaseActor*>(this)));
															#line 189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureExtraDatabaseActor*>(this)->ActorCallback< ConfigureExtraDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureExtraDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureExtraDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureExtraDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (self->networkAddresses.size())
															#line 283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		{
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (self->networkAddresses == "auto")
															#line 287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			{
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				StrictFuture<Void> __when_expr_4 = CoordinatorsChangeActor(db, self, true);
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when1(__when_expr_4.get(), loopDepth); };
				static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 5;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ConfigureExtraDatabaseActor, 4, Void >*>(static_cast<ConfigureExtraDatabaseActor*>(this)));
															#line 298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				StrictFuture<Void> __when_expr_5 = CoordinatorsChangeActor(db, self);
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2when2(__when_expr_5.get(), loopDepth); };
				static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 6;
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ConfigureExtraDatabaseActor, 5, Void >*>(static_cast<ConfigureExtraDatabaseActor*>(this)));
															#line 312 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		std::string configMode = self->getConfigMode(self->configMode, existingDB);
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(ManagementAPI::changeConfig(db.getReference(), configMode, true));
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 4;
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConfigureExtraDatabaseActor, 3, Void >*>(static_cast<ConfigureExtraDatabaseActor*>(this)));
															#line 336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		TraceEvent("WaitForReplicasExtra").log();
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForFullReplication(db);
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 3;
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigureExtraDatabaseActor, 2, Void >*>(static_cast<ConfigureExtraDatabaseActor*>(this)));
															#line 354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		TraceEvent("WaitForReplicasExtra").log();
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForFullReplication(db);
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 3;
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigureExtraDatabaseActor, 2, Void >*>(static_cast<ConfigureExtraDatabaseActor*>(this)));
															#line 372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureExtraDatabaseActor*>(this)->ActorCallback< ConfigureExtraDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureExtraDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigureExtraDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigureExtraDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		TraceEvent("WaitForReplicasExtraEnd").log();
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		existingDB = true;
															#line 458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		TraceEvent("WaitForReplicasExtraEnd").log();
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		existingDB = true;
															#line 469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureExtraDatabaseActor*>(this)->ActorCallback< ConfigureExtraDatabaseActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureExtraDatabaseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConfigureExtraDatabaseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConfigureExtraDatabaseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureExtraDatabaseActor*>(this)->ActorCallback< ConfigureExtraDatabaseActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureExtraDatabaseActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConfigureExtraDatabaseActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConfigureExtraDatabaseActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(5 * deterministicRandom()->random01());
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 7;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ConfigureExtraDatabaseActor, 6, Void >*>(static_cast<ConfigureExtraDatabaseActor*>(this)));
															#line 647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureExtraDatabaseActor*>(this)->ActorCallback< ConfigureExtraDatabaseActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureExtraDatabaseActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ConfigureExtraDatabaseActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ConfigureExtraDatabaseActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureExtraDatabaseActor*>(this)->ActorCallback< ConfigureExtraDatabaseActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureExtraDatabaseActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ConfigureExtraDatabaseActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ConfigureExtraDatabaseActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (!static_cast<ConfigureExtraDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureExtraDatabaseActorState(); static_cast<ConfigureExtraDatabaseActor*>(this)->destroy(); return 0; }
															#line 836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		new (&static_cast<ConfigureExtraDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureExtraDatabaseActorState();
		static_cast<ConfigureExtraDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (!static_cast<ConfigureExtraDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureExtraDatabaseActorState(); static_cast<ConfigureExtraDatabaseActor*>(this)->destroy(); return 0; }
															#line 848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		new (&static_cast<ConfigureExtraDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureExtraDatabaseActorState();
		static_cast<ConfigureExtraDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ConfigureExtraDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureExtraDatabaseActor*>(this)->ActorCallback< ConfigureExtraDatabaseActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureExtraDatabaseActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ConfigureExtraDatabaseActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ConfigureExtraDatabaseActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	ChangeConfigWorkload* self;
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	Database db;
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	bool existingDB;
															#line 937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
};
// This generated class is to be used only via configureExtraDatabase()
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
class ConfigureExtraDatabaseActor final : public Actor<Void>, public ActorCallback< ConfigureExtraDatabaseActor, 0, Void >, public ActorCallback< ConfigureExtraDatabaseActor, 1, Void >, public ActorCallback< ConfigureExtraDatabaseActor, 2, Void >, public ActorCallback< ConfigureExtraDatabaseActor, 3, Void >, public ActorCallback< ConfigureExtraDatabaseActor, 4, Void >, public ActorCallback< ConfigureExtraDatabaseActor, 5, Void >, public ActorCallback< ConfigureExtraDatabaseActor, 6, Void >, public FastAllocated<ConfigureExtraDatabaseActor>, public ConfigureExtraDatabaseActorState<ConfigureExtraDatabaseActor> {
															#line 942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
public:
	using FastAllocated<ConfigureExtraDatabaseActor>::operator new;
	using FastAllocated<ConfigureExtraDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6195974284971426816UL, 1059233511834987520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureExtraDatabaseActor, 0, Void >;
friend struct ActorCallback< ConfigureExtraDatabaseActor, 1, Void >;
friend struct ActorCallback< ConfigureExtraDatabaseActor, 2, Void >;
friend struct ActorCallback< ConfigureExtraDatabaseActor, 3, Void >;
friend struct ActorCallback< ConfigureExtraDatabaseActor, 4, Void >;
friend struct ActorCallback< ConfigureExtraDatabaseActor, 5, Void >;
friend struct ActorCallback< ConfigureExtraDatabaseActor, 6, Void >;
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	ConfigureExtraDatabaseActor(ChangeConfigWorkload* const& self,Database const& db) 
															#line 965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ConfigureExtraDatabaseActorState<ConfigureExtraDatabaseActor>(self, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureExtraDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12630918261217692160UL, 12774306246722886912UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureExtraDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureExtraDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureExtraDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureExtraDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigureExtraDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConfigureExtraDatabaseActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConfigureExtraDatabaseActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ConfigureExtraDatabaseActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ConfigureExtraDatabaseActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ConfigureExtraDatabaseActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
[[nodiscard]] Future<Void> configureExtraDatabase( ChangeConfigWorkload* const& self, Database const& db ) {
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	return Future<Void>(new ConfigureExtraDatabaseActor(self, db));
															#line 1003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
}

#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"

	// When simulating multiple clusters, this actor sets the starting configuration
	// for the extra clusters.
	Future<Void> configureExtraDatabases(ChangeConfigWorkload* self) {
		std::vector<Future<Void>> futures;
		if (g_network->isSimulated()) {
			for (auto extraDatabase : g_simulator->extraDatabases) {
				Database db = Database::createSimulatedExtraDatabase(extraDatabase);
				futures.push_back(configureExtraDatabase(self, db));
			}
		}
		return waitForAll(futures);
	}

	// Either changes the database configuration, or changes the coordinators based on the parameters
	// of the workload.
																#line 1023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
// This generated class is to be used only via ChangeConfigClient()
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
template <class ChangeConfigClientActor>
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
class ChangeConfigClientActorState {
															#line 1029 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
public:
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	ChangeConfigClientActorState(Database const& cx,ChangeConfigWorkload* const& self) 
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		 : cx(cx),
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		   self(self)
															#line 1038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("ChangeConfigClient", reinterpret_cast<unsigned long>(this));

	}
	~ChangeConfigClientActorState() 
	{
		fdb_probe_actor_destroy("ChangeConfigClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->minDelayBeforeChange + deterministicRandom()->random01() * (self->maxDelayBeforeChange - self->minDelayBeforeChange));
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 1;
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigClientActor, 0, Void >*>(static_cast<ChangeConfigClientActor*>(this)));
															#line 1060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeConfigClientActorState();
		static_cast<ChangeConfigClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		extraConfigureBefore = deterministicRandom()->random01() < 0.5;
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (extraConfigureBefore)
															#line 1085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		{
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->configureExtraDatabases(self);
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 2;
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigClientActor, 1, Void >*>(static_cast<ChangeConfigClientActor*>(this)));
															#line 1096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		extraConfigureBefore = deterministicRandom()->random01() < 0.5;
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (extraConfigureBefore)
															#line 1112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		{
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->configureExtraDatabases(self);
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 2;
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigClientActor, 1, Void >*>(static_cast<ChangeConfigClientActor*>(this)));
															#line 1123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigClientActor*>(this)->ActorCallback< ChangeConfigClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeConfigClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (self->configMode.size())
															#line 1212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		{
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			existingDB = false;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (g_network->isSimulated() && g_simulator->startingDisabledConfiguration != "")
															#line 1218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			{
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				StrictFuture<Void> __when_expr_2 = success( ManagementAPI::changeConfig(cx.getReference(), g_simulator->startingDisabledConfiguration, true));
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
				static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 3;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigClientActor, 2, Void >*>(static_cast<ChangeConfigClientActor*>(this)));
															#line 1229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont5(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigClientActor*>(this)->ActorCallback< ChangeConfigClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeConfigClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if ((g_network->isSimulated() && g_simulator->configDBType != ConfigDBType::SIMPLE) || !g_network->isSimulated())
															#line 1335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		{
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (self->networkAddresses.size())
															#line 1339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			{
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				i = int();
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				i = 0;
															#line 1345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				loopDepth = a_body1cont4loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont11(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		std::string configMode = self->getConfigMode(self->configMode, existingDB);
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(ManagementAPI::changeConfig(cx.getReference(), configMode, true));
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 5;
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigClientActor, 4, Void >*>(static_cast<ChangeConfigClientActor*>(this)));
															#line 1373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		TraceEvent("WaitForReplicas").log();
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForFullReplication(cx);
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 4;
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigClientActor, 3, Void >*>(static_cast<ChangeConfigClientActor*>(this)));
															#line 1391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		TraceEvent("WaitForReplicas").log();
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForFullReplication(cx);
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 4;
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigClientActor, 3, Void >*>(static_cast<ChangeConfigClientActor*>(this)));
															#line 1409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigClientActor*>(this)->ActorCallback< ChangeConfigClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeConfigClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		TraceEvent("WaitForReplicasEnd").log();
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		existingDB = true;
															#line 1495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		TraceEvent("WaitForReplicasEnd").log();
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		existingDB = true;
															#line 1506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigClientActor*>(this)->ActorCallback< ChangeConfigClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangeConfigClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigClientActor*>(this)->ActorCallback< ChangeConfigClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ChangeConfigClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (!extraConfigureBefore)
															#line 1677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		{
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			StrictFuture<Void> __when_expr_7 = self->configureExtraDatabases(self);
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont10when1(__when_expr_7.get(), loopDepth); };
			static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 8;
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigClientActor, 7, Void >*>(static_cast<ChangeConfigClientActor*>(this)));
															#line 1688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (!(i < self->coordinatorChanges))
															#line 1721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (i > 0)
															#line 1727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		{
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			StrictFuture<Void> __when_expr_5 = delay(20);
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 6;
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigClientActor, 5, Void >*>(static_cast<ChangeConfigClientActor*>(this)));
															#line 1738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		StrictFuture<Void> __when_expr_6 = CoordinatorsChangeActor(cx, self, self->networkAddresses == "auto");
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 7;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigClientActor, 6, Void >*>(static_cast<ChangeConfigClientActor*>(this)));
															#line 1772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigClientActor*>(this)->ActorCallback< ChangeConfigClientActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ChangeConfigClientActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont4loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		++i;
															#line 1868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		++i;
															#line 1877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigClientActor*>(this)->ActorCallback< ChangeConfigClientActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ChangeConfigClientActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (!static_cast<ChangeConfigClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeConfigClientActorState(); static_cast<ChangeConfigClientActor*>(this)->destroy(); return 0; }
															#line 1961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		new (&static_cast<ChangeConfigClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeConfigClientActorState();
		static_cast<ChangeConfigClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ChangeConfigClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigClientActor*>(this)->ActorCallback< ChangeConfigClientActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ChangeConfigClientActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ChangeConfigClientActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	Database cx;
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	ChangeConfigWorkload* self;
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	bool extraConfigureBefore;
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	bool existingDB;
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	int i;
															#line 2066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
};
// This generated class is to be used only via ChangeConfigClient()
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
class ChangeConfigClientActor final : public Actor<Void>, public ActorCallback< ChangeConfigClientActor, 0, Void >, public ActorCallback< ChangeConfigClientActor, 1, Void >, public ActorCallback< ChangeConfigClientActor, 2, Void >, public ActorCallback< ChangeConfigClientActor, 3, Void >, public ActorCallback< ChangeConfigClientActor, 4, Void >, public ActorCallback< ChangeConfigClientActor, 5, Void >, public ActorCallback< ChangeConfigClientActor, 6, Void >, public ActorCallback< ChangeConfigClientActor, 7, Void >, public FastAllocated<ChangeConfigClientActor>, public ChangeConfigClientActorState<ChangeConfigClientActor> {
															#line 2071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
public:
	using FastAllocated<ChangeConfigClientActor>::operator new;
	using FastAllocated<ChangeConfigClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(93533288399729664UL, 10408944178876753920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeConfigClientActor, 0, Void >;
friend struct ActorCallback< ChangeConfigClientActor, 1, Void >;
friend struct ActorCallback< ChangeConfigClientActor, 2, Void >;
friend struct ActorCallback< ChangeConfigClientActor, 3, Void >;
friend struct ActorCallback< ChangeConfigClientActor, 4, Void >;
friend struct ActorCallback< ChangeConfigClientActor, 5, Void >;
friend struct ActorCallback< ChangeConfigClientActor, 6, Void >;
friend struct ActorCallback< ChangeConfigClientActor, 7, Void >;
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	ChangeConfigClientActor(Database const& cx,ChangeConfigWorkload* const& self) 
															#line 2095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ChangeConfigClientActorState<ChangeConfigClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ChangeConfigClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5019872240246110976UL, 6023107808395144704UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ChangeConfigClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ChangeConfigClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeConfigClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeConfigClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeConfigClientActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangeConfigClientActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ChangeConfigClientActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ChangeConfigClientActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ChangeConfigClientActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ChangeConfigClientActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
[[nodiscard]] Future<Void> ChangeConfigClient( Database const& cx, ChangeConfigWorkload* const& self ) {
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	return Future<Void>(new ChangeConfigClientActor(cx, self));
															#line 2134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
}

#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"

																#line 2139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
// This generated class is to be used only via CoordinatorsChangeActor()
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
template <class CoordinatorsChangeActorActor>
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
class CoordinatorsChangeActorActorState {
															#line 2145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
public:
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	CoordinatorsChangeActorActorState(Database const& cx,ChangeConfigWorkload* const& self,bool const& autoChange = false) 
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		 : cx(cx),
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		   self(self),
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		   autoChange(autoChange),
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		   tr(cx),
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		   notEnoughMachineResults(0),
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		   desiredCoordinatorsKey()
															#line 2162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this));

	}
	~CoordinatorsChangeActorActorState() 
	{
		fdb_probe_actor_destroy("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (autoChange)
															#line 2177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			{
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				;
															#line 2181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				desiredCoordinatorsKey = self->networkAddresses;
															#line 2188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CoordinatorsChangeActorActorState();
		static_cast<CoordinatorsChangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		;
															#line 2212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get("auto_coordinators"_sr.withPrefix( SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin));
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 1;
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsChangeActorActor, 0, Optional<Value> >*>(static_cast<CoordinatorsChangeActorActor*>(this)));
															#line 2244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 2279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			{
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_1 = tr.get(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::ERRORMSG).begin);
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
				static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 2;
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsChangeActorActor, 1, Optional<Value> >*>(static_cast<CoordinatorsChangeActorActor*>(this)));
															#line 2290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when2(__when_expr_3.get(), loopDepth); };
				static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 4;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsChangeActorActor, 3, Void >*>(static_cast<CoordinatorsChangeActorActor*>(this)));
															#line 2304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& newCoordinatorsKey,int loopDepth) 
	{
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(newCoordinatorsKey.present());
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		desiredCoordinatorsKey = newCoordinatorsKey.get().toString();
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		tr.reset();
															#line 2324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && newCoordinatorsKey,int loopDepth) 
	{
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(newCoordinatorsKey.present());
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		desiredCoordinatorsKey = newCoordinatorsKey.get().toString();
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		tr.reset();
															#line 2337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& newCoordinatorsKey,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(newCoordinatorsKey, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && newCoordinatorsKey,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(newCoordinatorsKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsChangeActorActor*>(this)->ActorCallback< CoordinatorsChangeActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CoordinatorsChangeActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 5;
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsChangeActorActor, 4, Void >*>(static_cast<CoordinatorsChangeActorActor*>(this)));
															#line 2428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(errorMsg.present());
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		std::string errorStr;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		TraceEvent(SevDebug, "GetAutoCoordinatorsChange") .detail("ErrorMessage", valueObj["message"].get_str());
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "auto_coordinators");
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (valueObj["retriable"].get_bool() && notEnoughMachineResults < 1)
															#line 2451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		{
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			notEnoughMachineResults++;
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(1.0);
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 3;
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsChangeActorActor, 2, Void >*>(static_cast<CoordinatorsChangeActorActor*>(this)));
															#line 2464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(errorMsg.present());
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		std::string errorStr;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		TraceEvent(SevDebug, "GetAutoCoordinatorsChange") .detail("ErrorMessage", valueObj["message"].get_str());
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "auto_coordinators");
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (valueObj["retriable"].get_bool() && notEnoughMachineResults < 1)
															#line 2492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		{
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			notEnoughMachineResults++;
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(1.0);
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 3;
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsChangeActorActor, 2, Void >*>(static_cast<CoordinatorsChangeActorActor*>(this)));
															#line 2505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsChangeActorActor*>(this)->ActorCallback< CoordinatorsChangeActorActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CoordinatorsChangeActorActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		tr.reset();
															#line 2600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		tr.reset();
															#line 2609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsChangeActorActor*>(this)->ActorCallback< CoordinatorsChangeActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CoordinatorsChangeActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsChangeActorActor*>(this)->ActorCallback< CoordinatorsChangeActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CoordinatorsChangeActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsChangeActorActor*>(this)->ActorCallback< CoordinatorsChangeActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CoordinatorsChangeActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (!static_cast<CoordinatorsChangeActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CoordinatorsChangeActorActorState(); static_cast<CoordinatorsChangeActorActor*>(this)->destroy(); return 0; }
															#line 2867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		new (&static_cast<CoordinatorsChangeActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CoordinatorsChangeActorActorState();
		static_cast<CoordinatorsChangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			tr.setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			tr.set("processes"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("coordinators")), Value(desiredCoordinatorsKey));
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			TraceEvent(SevDebug, "CoordinatorsChangeBeforeCommit") .detail("Auto", autoChange) .detail("NewCoordinatorsKey", describe(desiredCoordinatorsKey));
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 6;
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsChangeActorActor, 5, Void >*>(static_cast<CoordinatorsChangeActorActor*>(this)));
															#line 2900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			err = Error(e);
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 2937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
			{
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_6 = tr.get(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::ERRORMSG).begin);
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
				static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 7;
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsChangeActorActor, 6, Optional<Value> >*>(static_cast<CoordinatorsChangeActorActor*>(this)));
															#line 2948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				StrictFuture<Void> __when_expr_7 = tr.onError(err);
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when2(__when_expr_7.get(), loopDepth); };
				static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 8;
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsChangeActorActor, 7, Void >*>(static_cast<CoordinatorsChangeActorActor*>(this)));
															#line 2962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(false);
															#line 2978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(false);
															#line 2987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsChangeActorActor*>(this)->ActorCallback< CoordinatorsChangeActorActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CoordinatorsChangeActorActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		StrictFuture<Void> __when_expr_8 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 9;
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsChangeActorActor, 8, Void >*>(static_cast<CoordinatorsChangeActorActor*>(this)));
															#line 3091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont2(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(errorMsg.present());
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		std::string errorStr;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsChangeError") .detail("Auto", autoChange) .detail("ErrorMessage", valueObj["message"].get_str());
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "coordinators");
															#line 3112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont2(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(errorMsg.present());
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		std::string errorStr;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsChangeError") .detail("Auto", autoChange) .detail("ErrorMessage", valueObj["message"].get_str());
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "coordinators");
															#line 3133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont2(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont2(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsChangeActorActor*>(this)->ActorCallback< CoordinatorsChangeActorActor, 6, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 6, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 6, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CoordinatorsChangeActorActor, 6, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsChangeActorActor*>(this)->ActorCallback< CoordinatorsChangeActorActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CoordinatorsChangeActorActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1Catch1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsChangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsChangeActorActor*>(this)->ActorCallback< CoordinatorsChangeActorActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CoordinatorsChangeActorActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CoordinatorsChangeActorActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	Database cx;
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	ChangeConfigWorkload* self;
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	bool autoChange;
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	int notEnoughMachineResults;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	std::string desiredCoordinatorsKey;
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	Error err;
															#line 3401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
};
// This generated class is to be used only via CoordinatorsChangeActor()
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
class CoordinatorsChangeActorActor final : public Actor<Void>, public ActorCallback< CoordinatorsChangeActorActor, 0, Optional<Value> >, public ActorCallback< CoordinatorsChangeActorActor, 1, Optional<Value> >, public ActorCallback< CoordinatorsChangeActorActor, 2, Void >, public ActorCallback< CoordinatorsChangeActorActor, 3, Void >, public ActorCallback< CoordinatorsChangeActorActor, 4, Void >, public ActorCallback< CoordinatorsChangeActorActor, 5, Void >, public ActorCallback< CoordinatorsChangeActorActor, 6, Optional<Value> >, public ActorCallback< CoordinatorsChangeActorActor, 7, Void >, public ActorCallback< CoordinatorsChangeActorActor, 8, Void >, public FastAllocated<CoordinatorsChangeActorActor>, public CoordinatorsChangeActorActorState<CoordinatorsChangeActorActor> {
															#line 3406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
public:
	using FastAllocated<CoordinatorsChangeActorActor>::operator new;
	using FastAllocated<CoordinatorsChangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10327448744473642496UL, 15489029677030356736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CoordinatorsChangeActorActor, 0, Optional<Value> >;
friend struct ActorCallback< CoordinatorsChangeActorActor, 1, Optional<Value> >;
friend struct ActorCallback< CoordinatorsChangeActorActor, 2, Void >;
friend struct ActorCallback< CoordinatorsChangeActorActor, 3, Void >;
friend struct ActorCallback< CoordinatorsChangeActorActor, 4, Void >;
friend struct ActorCallback< CoordinatorsChangeActorActor, 5, Void >;
friend struct ActorCallback< CoordinatorsChangeActorActor, 6, Optional<Value> >;
friend struct ActorCallback< CoordinatorsChangeActorActor, 7, Void >;
friend struct ActorCallback< CoordinatorsChangeActorActor, 8, Void >;
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	CoordinatorsChangeActorActor(Database const& cx,ChangeConfigWorkload* const& self,bool const& autoChange = false) 
															#line 3431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CoordinatorsChangeActorActorState<CoordinatorsChangeActorActor>(cx, self, autoChange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9756632427775761664UL, 6761619512001087488UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsChangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("CoordinatorsChangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("CoordinatorsChangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CoordinatorsChangeActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CoordinatorsChangeActorActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CoordinatorsChangeActorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CoordinatorsChangeActorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CoordinatorsChangeActorActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CoordinatorsChangeActorActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CoordinatorsChangeActorActor, 6, Optional<Value> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CoordinatorsChangeActorActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CoordinatorsChangeActorActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
[[nodiscard]] static Future<Void> CoordinatorsChangeActor( Database const& cx, ChangeConfigWorkload* const& self, bool const& autoChange = false ) {
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
	return Future<Void>(new CoordinatorsChangeActorActor(cx, self, autoChange));
															#line 3471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeConfig.actor.g.cpp.py_gen"
}

#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeConfig.actor.cpp"
};

WorkloadFactory<ChangeConfigWorkload> ChangeConfigWorkloadFactory;
