#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
/*
 * BulkLoading.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BulkLoading.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/BulkLoadUtil.actor.h"
#include "fdbserver/RocksDBCheckpointUtils.actor.h"
#include "fdbserver/StorageMetrics.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

const std::string simulationBulkLoadFolder = joinPath("simfdb", "bulkload");

struct BulkLoadTaskTestUnit {
	BulkLoadTaskTestUnit() = default;

	size_t getTotalBytes() const {
		size_t bytes = 0;
		for (const auto& kv : data) {
			bytes = bytes + kv.expectedSize(); // This size is different from size used by fetchKeys
		}
		return bytes;
	}

	size_t getKeyCount() const { return data.size(); }

	KeyRange getRange() const { return bulkLoadTask.getRange(); }

	std::string toString() const {
		return "[BulkLoadTaskTestUnit]: [Bytes]: " + std::to_string(getTotalBytes()) +
		       ", [Keys]: " + std::to_string(getKeyCount());
	}

	BulkLoadTaskState bulkLoadTask;
	std::vector<KeyValue> data;
};

struct BulkLoading : TestWorkload {
	static constexpr auto NAME = "BulkLoadingWorkload";
	const bool enabled = true;
	bool pass = true;
	bool debugging = false;
	bool backgroundTrafficEnabled = deterministicRandom()->coinflip();
	UID jobId = deterministicRandom()->randomUniqueID();
	bool initializeBulkLoadMetadata = deterministicRandom()->coinflip();

	// This workload is not compatible with following workload because they will race in changing the DD mode
	// This workload is not compatible with RandomRangeLock for the conflict in range lock
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomMoveKeys",
		             "DataLossRecovery",
		             "IDDTxnProcessorApiCorrectness",
		             "PerpetualWiggleStatsWorkload",
		             "PhysicalShardMove",
		             "StorageCorruption",
		             "StorageServerCheckpointRestoreTest",
		             "ValidateStorage",
		             "RandomRangeLock",
		             "BulkDumping" });
	}

	BulkLoading(WorkloadContext const& wcx) : TestWorkload(wcx), enabled(true), pass(true) {}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override { return _start(this, cx); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 93 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
// This generated class is to be used only via clearAllBulkLoadTask()
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class ClearAllBulkLoadTaskActor>
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class ClearAllBulkLoadTaskActorState {
															#line 99 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	ClearAllBulkLoadTaskActorState(Database const& cx) 
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : cx(cx),
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   tr(cx)
															#line 108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this));

	}
	~ClearAllBulkLoadTaskActorState() 
	{
		fdb_probe_actor_destroy("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearAllBulkLoadTaskActorState();
		static_cast<ClearAllBulkLoadTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<ClearAllBulkLoadTaskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearAllBulkLoadTaskActorState(); static_cast<ClearAllBulkLoadTaskActor*>(this)->destroy(); return 0; }
															#line 146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<ClearAllBulkLoadTaskActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearAllBulkLoadTaskActorState();
		static_cast<ClearAllBulkLoadTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_0 = krmSetRange(&tr, bulkLoadTaskPrefix, normalKeys, bulkLoadTaskStateValue(BulkLoadTaskState()));
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state = 1;
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >*>(static_cast<ClearAllBulkLoadTaskActor*>(this)));
															#line 177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state = 3;
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >*>(static_cast<ClearAllBulkLoadTaskActor*>(this)));
															#line 219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state = 2;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >*>(static_cast<ClearAllBulkLoadTaskActor*>(this)));
															#line 241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state = 2;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >*>(static_cast<ClearAllBulkLoadTaskActor*>(this)));
															#line 257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAllBulkLoadTaskActor*>(this)->ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAllBulkLoadTaskActor*>(this)->ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAllBulkLoadTaskActor*>(this)->ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clearAllBulkLoadTask()
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class ClearAllBulkLoadTaskActor final : public Actor<Void>, public ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >, public ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >, public ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >, public FastAllocated<ClearAllBulkLoadTaskActor>, public ClearAllBulkLoadTaskActorState<ClearAllBulkLoadTaskActor> {
															#line 520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClearAllBulkLoadTaskActor>::operator new;
	using FastAllocated<ClearAllBulkLoadTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9856580766879961344UL, 4332536727382609152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >;
friend struct ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >;
friend struct ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >;
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	ClearAllBulkLoadTaskActor(Database const& cx) 
															#line 539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClearAllBulkLoadTaskActorState<ClearAllBulkLoadTaskActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6120341800804442880UL, 10309690102109238528UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearAllBulkLoadTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<Void> clearAllBulkLoadTask( Database const& cx ) {
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<Void>(new ClearAllBulkLoadTaskActor(cx));
															#line 573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
}

#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

	// Submit task can be failed due to range lock reject
																#line 579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
// This generated class is to be used only via submitBulkLoadTask()
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class SubmitBulkLoadTaskActor>
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class SubmitBulkLoadTaskActorState {
															#line 585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	SubmitBulkLoadTaskActorState(Database const& cx,BulkLoadTaskState const& bulkLoadTask) 
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : cx(cx),
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   bulkLoadTask(bulkLoadTask)
															#line 594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("submitBulkLoadTask", reinterpret_cast<unsigned long>(this));

	}
	~SubmitBulkLoadTaskActorState() 
	{
		fdb_probe_actor_destroy("submitBulkLoadTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SubmitBulkLoadTaskActorState();
		static_cast<SubmitBulkLoadTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<SubmitBulkLoadTaskActor*>(this)->SAV<bool>::futures) { (void)(true); this->~SubmitBulkLoadTaskActorState(); static_cast<SubmitBulkLoadTaskActor*>(this)->destroy(); return 0; }
															#line 632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<SubmitBulkLoadTaskActor*>(this)->SAV< bool >::value()) bool(true);
		this->~SubmitBulkLoadTaskActorState();
		static_cast<SubmitBulkLoadTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			tr = Transaction(cx);
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_0 = setBulkLoadSubmissionTransaction(&tr, bulkLoadTask);
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 1;
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SubmitBulkLoadTaskActor, 0, Void >*>(static_cast<SubmitBulkLoadTaskActor*>(this)));
															#line 661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			TraceEvent(SevWarn, "BulkLoadingSubmitBulkLoadTaskError") .setMaxEventLength(-1) .setMaxFieldLength(-1) .errorUnsuppressed(e) .detail("BulkLoadTaskState", bulkLoadTask.toString());
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (e.code() == error_code_range_lock_reject)
															#line 698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (!static_cast<SubmitBulkLoadTaskActor*>(this)->SAV<bool>::futures) { (void)(false); this->~SubmitBulkLoadTaskActorState(); static_cast<SubmitBulkLoadTaskActor*>(this)->destroy(); return 0; }
															#line 702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				new (&static_cast<SubmitBulkLoadTaskActor*>(this)->SAV< bool >::value()) bool(false);
				this->~SubmitBulkLoadTaskActorState();
				static_cast<SubmitBulkLoadTaskActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(0.1);
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 4;
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SubmitBulkLoadTaskActor, 3, Void >*>(static_cast<SubmitBulkLoadTaskActor*>(this)));
															#line 717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = takeExclusiveReadLockOnRange(&tr, bulkLoadTask.getRange(), rangeLockNameForBulkLoad);
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 2;
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SubmitBulkLoadTaskActor, 1, Void >*>(static_cast<SubmitBulkLoadTaskActor*>(this)));
															#line 739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = takeExclusiveReadLockOnRange(&tr, bulkLoadTask.getRange(), rangeLockNameForBulkLoad);
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 2;
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SubmitBulkLoadTaskActor, 1, Void >*>(static_cast<SubmitBulkLoadTaskActor*>(this)));
															#line 755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitBulkLoadTaskActor*>(this)->ActorCallback< SubmitBulkLoadTaskActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitBulkLoadTaskActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SubmitBulkLoadTaskActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SubmitBulkLoadTaskActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 3;
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SubmitBulkLoadTaskActor, 2, Void >*>(static_cast<SubmitBulkLoadTaskActor*>(this)));
															#line 846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 3;
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SubmitBulkLoadTaskActor, 2, Void >*>(static_cast<SubmitBulkLoadTaskActor*>(this)));
															#line 862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitBulkLoadTaskActor*>(this)->ActorCallback< SubmitBulkLoadTaskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitBulkLoadTaskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SubmitBulkLoadTaskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SubmitBulkLoadTaskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadingSubmitBulkLoadTask") .detail("BulkLoadTaskState", bulkLoadTask.toString());
															#line 946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadingSubmitBulkLoadTask") .detail("BulkLoadTaskState", bulkLoadTask.toString());
															#line 955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitBulkLoadTaskActor*>(this)->ActorCallback< SubmitBulkLoadTaskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitBulkLoadTaskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SubmitBulkLoadTaskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SubmitBulkLoadTaskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitBulkLoadTaskActor*>(this)->ActorCallback< SubmitBulkLoadTaskActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitBulkLoadTaskActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SubmitBulkLoadTaskActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SubmitBulkLoadTaskActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoadTaskState bulkLoadTask;
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 1128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
};
// This generated class is to be used only via submitBulkLoadTask()
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class SubmitBulkLoadTaskActor final : public Actor<bool>, public ActorCallback< SubmitBulkLoadTaskActor, 0, Void >, public ActorCallback< SubmitBulkLoadTaskActor, 1, Void >, public ActorCallback< SubmitBulkLoadTaskActor, 2, Void >, public ActorCallback< SubmitBulkLoadTaskActor, 3, Void >, public FastAllocated<SubmitBulkLoadTaskActor>, public SubmitBulkLoadTaskActorState<SubmitBulkLoadTaskActor> {
															#line 1133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
	using FastAllocated<SubmitBulkLoadTaskActor>::operator new;
	using FastAllocated<SubmitBulkLoadTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10666697683157224192UL, 12733422973022246912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SubmitBulkLoadTaskActor, 0, Void >;
friend struct ActorCallback< SubmitBulkLoadTaskActor, 1, Void >;
friend struct ActorCallback< SubmitBulkLoadTaskActor, 2, Void >;
friend struct ActorCallback< SubmitBulkLoadTaskActor, 3, Void >;
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	SubmitBulkLoadTaskActor(Database const& cx,BulkLoadTaskState const& bulkLoadTask) 
															#line 1153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   SubmitBulkLoadTaskActorState<SubmitBulkLoadTaskActor>(cx, bulkLoadTask),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7626601752670957568UL, 15362552488201644288UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("submitBulkLoadTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SubmitBulkLoadTaskActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SubmitBulkLoadTaskActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SubmitBulkLoadTaskActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SubmitBulkLoadTaskActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<bool> submitBulkLoadTask( Database const& cx, BulkLoadTaskState const& bulkLoadTask ) {
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<bool>(new SubmitBulkLoadTaskActor(cx, bulkLoadTask));
															#line 1188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
}

#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

	// Finish task must always succeed
																#line 1194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
// This generated class is to be used only via finalizeBulkLoadTask()
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class FinalizeBulkLoadTaskActor>
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class FinalizeBulkLoadTaskActorState {
															#line 1200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	FinalizeBulkLoadTaskActorState(Database const& cx,KeyRange const& range,UID const& taskId) 
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : cx(cx),
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   range(range),
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   taskId(taskId)
															#line 1211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this));

	}
	~FinalizeBulkLoadTaskActorState() 
	{
		fdb_probe_actor_destroy("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 1226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinalizeBulkLoadTaskActorState();
		static_cast<FinalizeBulkLoadTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<FinalizeBulkLoadTaskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinalizeBulkLoadTaskActorState(); static_cast<FinalizeBulkLoadTaskActor*>(this)->destroy(); return 0; }
															#line 1249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<FinalizeBulkLoadTaskActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinalizeBulkLoadTaskActorState();
		static_cast<FinalizeBulkLoadTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			tr = Transaction(cx);
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_0 = setBulkLoadFinalizeTransaction(&tr, range, taskId);
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 1;
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >*>(static_cast<FinalizeBulkLoadTaskActor*>(this)));
															#line 1278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			TraceEvent(SevWarn, "BulkLoadingAcknowledgeBulkLoadTaskError") .errorUnsuppressed(e) .detail("TaskID", taskId.toString()) .detail("TaskRange", range);
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			ASSERT(e.code() != error_code_bulkload_task_outdated && e.code() != error_code_range_lock_reject);
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(0.1);
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 4;
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FinalizeBulkLoadTaskActor, 3, Void >*>(static_cast<FinalizeBulkLoadTaskActor*>(this)));
															#line 1324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = releaseExclusiveReadLockOnRange(&tr, range, rangeLockNameForBulkLoad);
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 2;
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >*>(static_cast<FinalizeBulkLoadTaskActor*>(this)));
															#line 1346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = releaseExclusiveReadLockOnRange(&tr, range, rangeLockNameForBulkLoad);
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 2;
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >*>(static_cast<FinalizeBulkLoadTaskActor*>(this)));
															#line 1362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<FinalizeBulkLoadTaskActor*>(this)->ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 3;
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >*>(static_cast<FinalizeBulkLoadTaskActor*>(this)));
															#line 1453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 3;
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >*>(static_cast<FinalizeBulkLoadTaskActor*>(this)));
															#line 1469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<FinalizeBulkLoadTaskActor*>(this)->ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadingAcknowledgeBulkLoadTask") .detail("TaskID", taskId.toString()) .detail("TaskRange", range);
															#line 1553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadingAcknowledgeBulkLoadTask") .detail("TaskID", taskId.toString()) .detail("TaskRange", range);
															#line 1562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<FinalizeBulkLoadTaskActor*>(this)->ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<FinalizeBulkLoadTaskActor*>(this)->ActorCallback< FinalizeBulkLoadTaskActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinalizeBulkLoadTaskActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FinalizeBulkLoadTaskActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FinalizeBulkLoadTaskActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	KeyRange range;
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	UID taskId;
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 1737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
};
// This generated class is to be used only via finalizeBulkLoadTask()
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class FinalizeBulkLoadTaskActor final : public Actor<Void>, public ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >, public ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >, public ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >, public ActorCallback< FinalizeBulkLoadTaskActor, 3, Void >, public FastAllocated<FinalizeBulkLoadTaskActor>, public FinalizeBulkLoadTaskActorState<FinalizeBulkLoadTaskActor> {
															#line 1742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
	using FastAllocated<FinalizeBulkLoadTaskActor>::operator new;
	using FastAllocated<FinalizeBulkLoadTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17370506221182543872UL, 17156658910662683648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >;
friend struct ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >;
friend struct ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >;
friend struct ActorCallback< FinalizeBulkLoadTaskActor, 3, Void >;
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	FinalizeBulkLoadTaskActor(Database const& cx,KeyRange const& range,UID const& taskId) 
															#line 1762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FinalizeBulkLoadTaskActorState<FinalizeBulkLoadTaskActor>(cx, range, taskId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11877883446389486336UL, 6580607135629378560UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finalizeBulkLoadTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FinalizeBulkLoadTaskActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<Void> finalizeBulkLoadTask( Database const& cx, KeyRange const& range, UID const& taskId ) {
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<Void>(new FinalizeBulkLoadTaskActor(cx, range, taskId));
															#line 1797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
}

#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

																#line 1802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
// This generated class is to be used only via checkDDEnabled()
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class CheckDDEnabledActor>
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class CheckDDEnabledActorState {
															#line 1808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	CheckDDEnabledActorState(Database const& cx) 
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : cx(cx)
															#line 1815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkDDEnabled", reinterpret_cast<unsigned long>(this));

	}
	~CheckDDEnabledActorState() 
	{
		fdb_probe_actor_destroy("checkDDEnabled", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 1830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckDDEnabledActorState();
		static_cast<CheckDDEnabledActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		tr = Transaction(cx);
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		try {
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			ddMode = 1;
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(dataDistributionModeKey);
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<CheckDDEnabledActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckDDEnabledActor*>(this)->actor_wait_state = 1;
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >*>(static_cast<CheckDDEnabledActor*>(this)));
															#line 1875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<CheckDDEnabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckDDEnabledActor*>(this)->actor_wait_state = 2;
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDDEnabledActor, 1, Void >*>(static_cast<CheckDDEnabledActor*>(this)));
															#line 1904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& mode,int loopDepth) 
	{
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (mode.present())
															#line 1919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			rd >> ddMode;
															#line 1925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<CheckDDEnabledActor*>(this)->SAV<bool>::futures) { (void)(ddMode == 1); this->~CheckDDEnabledActorState(); static_cast<CheckDDEnabledActor*>(this)->destroy(); return 0; }
															#line 1929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<CheckDDEnabledActor*>(this)->SAV< bool >::value()) bool(ddMode == 1);
		this->~CheckDDEnabledActorState();
		static_cast<CheckDDEnabledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && mode,int loopDepth) 
	{
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (mode.present())
															#line 1941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			rd >> ddMode;
															#line 1947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<CheckDDEnabledActor*>(this)->SAV<bool>::futures) { (void)(ddMode == 1); this->~CheckDDEnabledActorState(); static_cast<CheckDDEnabledActor*>(this)->destroy(); return 0; }
															#line 1951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<CheckDDEnabledActor*>(this)->SAV< bool >::value()) bool(ddMode == 1);
		this->~CheckDDEnabledActorState();
		static_cast<CheckDDEnabledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& mode,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(mode, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && mode,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(mode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckDDEnabledActor*>(this)->actor_wait_state > 0) static_cast<CheckDDEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDDEnabledActor*>(this)->ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkDDEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDDEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDDEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkDDEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDDEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDDEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkDDEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDDEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDDEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckDDEnabledActor*>(this)->actor_wait_state > 0) static_cast<CheckDDEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDDEnabledActor*>(this)->ActorCallback< CheckDDEnabledActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDDEnabledActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDDEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDDEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDDEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckDDEnabledActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDDEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDDEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDDEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckDDEnabledActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDDEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDDEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDDEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	int ddMode;
															#line 2127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkDDEnabled()
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class CheckDDEnabledActor final : public Actor<bool>, public ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >, public ActorCallback< CheckDDEnabledActor, 1, Void >, public FastAllocated<CheckDDEnabledActor>, public CheckDDEnabledActorState<CheckDDEnabledActor> {
															#line 2132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckDDEnabledActor>::operator new;
	using FastAllocated<CheckDDEnabledActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6453245663219920384UL, 2079471742231700224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckDDEnabledActor, 1, Void >;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	CheckDDEnabledActor(Database const& cx) 
															#line 2150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   CheckDDEnabledActorState<CheckDDEnabledActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkDDEnabled", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11220408577052478208UL, 10499007195067868160UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDDEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkDDEnabled");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkDDEnabled", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckDDEnabledActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<bool> checkDDEnabled( Database const& cx ) {
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<bool>(new CheckDDEnabledActor(cx));
															#line 2183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
}

#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

	// First return value is whether all tasks are complete or error.
	// Second return value is the error tasks.
																#line 2190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
// This generated class is to be used only via checkAllTaskCompleteOrError()
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class CheckAllTaskCompleteOrErrorActor>
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class CheckAllTaskCompleteOrErrorActorState {
															#line 2196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	CheckAllTaskCompleteOrErrorActorState(Database const& cx) 
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : cx(cx),
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   tr(cx),
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   beginKey(allKeys.begin),
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   endKey(allKeys.end),
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   errorTasks()
															#line 2211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this));

	}
	~CheckAllTaskCompleteOrErrorActorState() 
	{
		fdb_probe_actor_destroy("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 2226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckAllTaskCompleteOrErrorActorState();
		static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->SAV<std::pair<bool, std::vector<BulkLoadTaskState>>>::futures) { (void)(std::make_pair(true, errorTasks)); this->~CheckAllTaskCompleteOrErrorActorState(); static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->SAV< std::pair<bool, std::vector<BulkLoadTaskState>> >::value()) std::pair<bool, std::vector<BulkLoadTaskState>>(std::make_pair(true, errorTasks));
		this->~CheckAllTaskCompleteOrErrorActorState();
		static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!(beginKey < endKey))
															#line 2268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, bulkLoadTaskPrefix, Standalone(KeyRangeRef(beginKey, endKey)));
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 1;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >*>(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)));
															#line 2284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 2;
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >*>(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)));
															#line 2326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult const& res,int loopDepth) 
	{
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for(int i = 0;i < res.size() - 1;i++) {
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!res[i].value.empty())
															#line 2343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				BulkLoadTaskState bulkLoadTaskState = decodeBulkLoadTaskState(res[i].value);
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (!bulkLoadTaskState.isValid())
															#line 2349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (bulkLoadTaskState.getRange() != KeyRangeRef(res[i].key, res[i + 1].key))
															#line 2355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (bulkLoadTaskState.phase != BulkLoadPhase::Complete && bulkLoadTaskState.phase != BulkLoadPhase::Error)
															#line 2361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("BulkLoadingWorkLoadIncompleteTasks") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					if (!static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->SAV<std::pair<bool, std::vector<BulkLoadTaskState>>>::futures) { (void)(std::make_pair(false, errorTasks)); this->~CheckAllTaskCompleteOrErrorActorState(); static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
					new (&static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->SAV< std::pair<bool, std::vector<BulkLoadTaskState>> >::value()) std::pair<bool, std::vector<BulkLoadTaskState>>(std::make_pair(false, errorTasks));
					this->~CheckAllTaskCompleteOrErrorActorState();
					static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (bulkLoadTaskState.phase == BulkLoadPhase::Error)
															#line 2375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("BulkLoadingWorkLoadFailedTasks") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					errorTasks.push_back(bulkLoadTaskState);
															#line 2381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				}
			}
		}
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		beginKey = res[res.size() - 1].key;
															#line 2387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && res,int loopDepth) 
	{
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for(int i = 0;i < res.size() - 1;i++) {
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!res[i].value.empty())
															#line 2398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				BulkLoadTaskState bulkLoadTaskState = decodeBulkLoadTaskState(res[i].value);
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (!bulkLoadTaskState.isValid())
															#line 2404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (bulkLoadTaskState.getRange() != KeyRangeRef(res[i].key, res[i + 1].key))
															#line 2410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (bulkLoadTaskState.phase != BulkLoadPhase::Complete && bulkLoadTaskState.phase != BulkLoadPhase::Error)
															#line 2416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("BulkLoadingWorkLoadIncompleteTasks") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					if (!static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->SAV<std::pair<bool, std::vector<BulkLoadTaskState>>>::futures) { (void)(std::make_pair(false, errorTasks)); this->~CheckAllTaskCompleteOrErrorActorState(); static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
					new (&static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->SAV< std::pair<bool, std::vector<BulkLoadTaskState>> >::value()) std::pair<bool, std::vector<BulkLoadTaskState>>(std::make_pair(false, errorTasks));
					this->~CheckAllTaskCompleteOrErrorActorState();
					static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (bulkLoadTaskState.phase == BulkLoadPhase::Error)
															#line 2430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("BulkLoadingWorkLoadFailedTasks") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					errorTasks.push_back(bulkLoadTaskState);
															#line 2436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				}
			}
		}
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		beginKey = res[res.size() - 1].key;
															#line 2442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Key beginKey;
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Key endKey;
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<BulkLoadTaskState> errorTasks;
															#line 2632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkAllTaskCompleteOrError()
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class CheckAllTaskCompleteOrErrorActor final : public Actor<std::pair<bool, std::vector<BulkLoadTaskState>>>, public ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >, public ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >, public FastAllocated<CheckAllTaskCompleteOrErrorActor>, public CheckAllTaskCompleteOrErrorActorState<CheckAllTaskCompleteOrErrorActor> {
															#line 2637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckAllTaskCompleteOrErrorActor>::operator new;
	using FastAllocated<CheckAllTaskCompleteOrErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11435172729486241792UL, 12100672659459666944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<bool, std::vector<BulkLoadTaskState>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >;
friend struct ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >;
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	CheckAllTaskCompleteOrErrorActor(Database const& cx) 
															#line 2655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		 : Actor<std::pair<bool, std::vector<BulkLoadTaskState>>>(),
		   CheckAllTaskCompleteOrErrorActorState<CheckAllTaskCompleteOrErrorActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10583912992162580992UL, 13840933963605920512UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkAllTaskCompleteOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<std::pair<bool, std::vector<BulkLoadTaskState>>> checkAllTaskCompleteOrError( Database const& cx ) {
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<std::pair<bool, std::vector<BulkLoadTaskState>>>(new CheckAllTaskCompleteOrErrorActor(cx));
															#line 2688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
}

#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

																#line 2693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
// This generated class is to be used only via waitUntilAllTaskCompleteOrError()
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class WaitUntilAllTaskCompleteOrErrorActor>
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class WaitUntilAllTaskCompleteOrErrorActorState {
															#line 2699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	WaitUntilAllTaskCompleteOrErrorActorState(BulkLoading* const& self,Database const& cx) 
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : self(self),
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   cx(cx)
															#line 2708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this));

	}
	~WaitUntilAllTaskCompleteOrErrorActorState() 
	{
		fdb_probe_actor_destroy("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 2723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitUntilAllTaskCompleteOrErrorActorState();
		static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::pair<bool, std::vector<BulkLoadTaskState>>> __when_expr_0 = self->checkAllTaskCompleteOrError(cx);
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 1;
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >*>(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)));
															#line 2760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(std::pair<bool, std::vector<BulkLoadTaskState>> const& res,int loopDepth) 
	{
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (res.first)
															#line 2769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(res.second); this->~WaitUntilAllTaskCompleteOrErrorActorState(); static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			new (&static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(res.second);
			this->~WaitUntilAllTaskCompleteOrErrorActorState();
			static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(10.0);
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 2;
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >*>(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)));
															#line 2788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(std::pair<bool, std::vector<BulkLoadTaskState>> && res,int loopDepth) 
	{
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (res.first)
															#line 2797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(res.second); this->~WaitUntilAllTaskCompleteOrErrorActorState(); static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			new (&static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(res.second);
			this->~WaitUntilAllTaskCompleteOrErrorActorState();
			static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(10.0);
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 2;
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >*>(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)));
															#line 2816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::pair<bool, std::vector<BulkLoadTaskState>> const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::pair<bool, std::vector<BulkLoadTaskState>> && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >*,std::pair<bool, std::vector<BulkLoadTaskState>> const& value) 
	{
		fdb_probe_actor_enter("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >*,std::pair<bool, std::vector<BulkLoadTaskState>> && value) 
	{
		fdb_probe_actor_enter("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoading* self;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 2987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitUntilAllTaskCompleteOrError()
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class WaitUntilAllTaskCompleteOrErrorActor final : public Actor<std::vector<BulkLoadTaskState>>, public ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >, public ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >, public FastAllocated<WaitUntilAllTaskCompleteOrErrorActor>, public WaitUntilAllTaskCompleteOrErrorActorState<WaitUntilAllTaskCompleteOrErrorActor> {
															#line 2992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitUntilAllTaskCompleteOrErrorActor>::operator new;
	using FastAllocated<WaitUntilAllTaskCompleteOrErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9866016926930860032UL, 1022072299785770496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<BulkLoadTaskState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >;
friend struct ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	WaitUntilAllTaskCompleteOrErrorActor(BulkLoading* const& self,Database const& cx) 
															#line 3010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		 : Actor<std::vector<BulkLoadTaskState>>(),
		   WaitUntilAllTaskCompleteOrErrorActorState<WaitUntilAllTaskCompleteOrErrorActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1358020137240995584UL, 12847694799185404160UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitUntilAllTaskCompleteOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<std::vector<BulkLoadTaskState>> waitUntilAllTaskCompleteOrError( BulkLoading* const& self, Database const& cx ) {
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<std::vector<BulkLoadTaskState>>(new WaitUntilAllTaskCompleteOrErrorActor(self, cx));
															#line 3043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
}

#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

																#line 3048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
// This generated class is to be used only via checkBulkLoadMetadataCleared()
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class CheckBulkLoadMetadataClearedActor>
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class CheckBulkLoadMetadataClearedActorState {
															#line 3054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	CheckBulkLoadMetadataClearedActorState(BulkLoading* const& self,Database const& cx) 
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : self(self),
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   cx(cx),
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   beginKey(normalKeys.begin),
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   endKey(normalKeys.end),
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   tr(cx)
															#line 3069 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this));

	}
	~CheckBulkLoadMetadataClearedActorState() 
	{
		fdb_probe_actor_destroy("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 3084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckBulkLoadMetadataClearedActorState();
		static_cast<CheckBulkLoadMetadataClearedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<CheckBulkLoadMetadataClearedActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckBulkLoadMetadataClearedActorState(); static_cast<CheckBulkLoadMetadataClearedActor*>(this)->destroy(); return 0; }
															#line 3107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<CheckBulkLoadMetadataClearedActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckBulkLoadMetadataClearedActorState();
		static_cast<CheckBulkLoadMetadataClearedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!(beginKey < endKey))
															#line 3126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, bulkLoadTaskPrefix, KeyRangeRef(beginKey, endKey));
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state = 1;
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >*>(static_cast<CheckBulkLoadMetadataClearedActor*>(this)));
															#line 3142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state = 2;
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >*>(static_cast<CheckBulkLoadMetadataClearedActor*>(this)));
															#line 3184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult const& res,int loopDepth) 
	{
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		int clearedCount = 0;
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		int nonEmptyCount = 0;
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for(int i = 0;i < res.size() - 1;i++) {
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			ASSERT(!self->initializeBulkLoadMetadata || !res[i].value.empty());
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (res[i].value.empty())
															#line 3207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			BulkLoadTaskState bulkLoadTaskState = decodeBulkLoadTaskState(res[i].value);
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!bulkLoadTaskState.isValid())
															#line 3215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				clearedCount++;
															#line 3219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				continue;
			}
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			KeyRange currentRange = Standalone(KeyRangeRef(res[i].key, res[i + 1].key));
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (bulkLoadTaskState.getRange() == currentRange)
															#line 3226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				TraceEvent("BulkLoadingWorkLoadMetadataNotCleared") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("BulkLoadTask", bulkLoadTaskState.toString());
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (!static_cast<CheckBulkLoadMetadataClearedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckBulkLoadMetadataClearedActorState(); static_cast<CheckBulkLoadMetadataClearedActor*>(this)->destroy(); return 0; }
															#line 3232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				new (&static_cast<CheckBulkLoadMetadataClearedActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckBulkLoadMetadataClearedActorState();
				static_cast<CheckBulkLoadMetadataClearedActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			ASSERT(bulkLoadTaskState.getRange().contains(currentRange));
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			nonEmptyCount++;
															#line 3242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (self->initializeBulkLoadMetadata && (clearedCount > nonEmptyCount + 1))
															#line 3246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			TraceEvent(SevError, "BulkLoadingWorkLoadTooManyClearedCount") .detail("ClearedCount", clearedCount) .detail("NonEmptyCount", nonEmptyCount);
															#line 3250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		beginKey = res.back().key;
															#line 3254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && res,int loopDepth) 
	{
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		int clearedCount = 0;
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		int nonEmptyCount = 0;
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for(int i = 0;i < res.size() - 1;i++) {
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			ASSERT(!self->initializeBulkLoadMetadata || !res[i].value.empty());
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (res[i].value.empty())
															#line 3271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			BulkLoadTaskState bulkLoadTaskState = decodeBulkLoadTaskState(res[i].value);
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!bulkLoadTaskState.isValid())
															#line 3279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				clearedCount++;
															#line 3283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				continue;
			}
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			KeyRange currentRange = Standalone(KeyRangeRef(res[i].key, res[i + 1].key));
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (bulkLoadTaskState.getRange() == currentRange)
															#line 3290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				TraceEvent("BulkLoadingWorkLoadMetadataNotCleared") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("BulkLoadTask", bulkLoadTaskState.toString());
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (!static_cast<CheckBulkLoadMetadataClearedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckBulkLoadMetadataClearedActorState(); static_cast<CheckBulkLoadMetadataClearedActor*>(this)->destroy(); return 0; }
															#line 3296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				new (&static_cast<CheckBulkLoadMetadataClearedActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckBulkLoadMetadataClearedActorState();
				static_cast<CheckBulkLoadMetadataClearedActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			ASSERT(bulkLoadTaskState.getRange().contains(currentRange));
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			nonEmptyCount++;
															#line 3306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (self->initializeBulkLoadMetadata && (clearedCount > nonEmptyCount + 1))
															#line 3310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			TraceEvent(SevError, "BulkLoadingWorkLoadTooManyClearedCount") .detail("ClearedCount", clearedCount) .detail("NonEmptyCount", nonEmptyCount);
															#line 3314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		beginKey = res.back().key;
															#line 3318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state > 0) static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckBulkLoadMetadataClearedActor*>(this)->ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBulkLoadMetadataClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBulkLoadMetadataClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBulkLoadMetadataClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state > 0) static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckBulkLoadMetadataClearedActor*>(this)->ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBulkLoadMetadataClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBulkLoadMetadataClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBulkLoadMetadataClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoading* self;
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Key beginKey;
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Key endKey;
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 3508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkBulkLoadMetadataCleared()
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class CheckBulkLoadMetadataClearedActor final : public Actor<bool>, public ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >, public ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >, public FastAllocated<CheckBulkLoadMetadataClearedActor>, public CheckBulkLoadMetadataClearedActorState<CheckBulkLoadMetadataClearedActor> {
															#line 3513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckBulkLoadMetadataClearedActor>::operator new;
	using FastAllocated<CheckBulkLoadMetadataClearedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10161789555861533952UL, 17981736250024399616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >;
friend struct ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >;
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	CheckBulkLoadMetadataClearedActor(BulkLoading* const& self,Database const& cx) 
															#line 3531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   CheckBulkLoadMetadataClearedActorState<CheckBulkLoadMetadataClearedActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11181173172931235840UL, 4303967593809216000UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBulkLoadMetadataClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkBulkLoadMetadataCleared");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<bool> checkBulkLoadMetadataCleared( BulkLoading* const& self, Database const& cx ) {
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<bool>(new CheckBulkLoadMetadataClearedActor(self, cx));
															#line 3564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
}

#line 276 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

	bool keyContainedInRanges(const Key& key, const std::vector<KeyRange>& ranges) {
		for (const auto& range : ranges) {
			if (range.contains(key)) {
				return true;
			}
		}
		return false;
	}

																#line 3578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
// This generated class is to be used only via getKvsFromDB()
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class GetKvsFromDBActor>
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class GetKvsFromDBActorState {
															#line 3584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	GetKvsFromDBActorState(BulkLoading* const& self,Database const& cx,std::vector<KeyRange> const& ignoreRanges,std::vector<KeyRange> const& loadedRanges) 
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : self(self),
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   cx(cx),
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   ignoreRanges(ignoreRanges),
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   loadedRanges(loadedRanges),
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   res(),
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   tr(cx)
															#line 3601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getKvsFromDB", reinterpret_cast<unsigned long>(this));

	}
	~GetKvsFromDBActorState() 
	{
		fdb_probe_actor_destroy("getKvsFromDB", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			TraceEvent("BulkLoadingWorkLoadGetKVSFromDBStart");
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 3618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKvsFromDBActorState();
		static_cast<GetKvsFromDBActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadGetKVSFromDBDone");
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<GetKvsFromDBActor*>(this)->SAV<std::vector<KeyValue>>::futures) { (void)(res); this->~GetKvsFromDBActorState(); static_cast<GetKvsFromDBActor*>(this)->destroy(); return 0; }
															#line 3643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<GetKvsFromDBActor*>(this)->SAV< std::vector<KeyValue> >::value()) std::vector<KeyValue>(std::move(res)); // state_var_RVO
		this->~GetKvsFromDBActorState();
		static_cast<GetKvsFromDBActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(normalKeys, CLIENT_KNOBS->TOO_MANY);
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<GetKvsFromDBActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKvsFromDBActor*>(this)->actor_wait_state = 1;
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKvsFromDBActor, 0, RangeResult >*>(static_cast<GetKvsFromDBActor*>(this)));
															#line 3670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<GetKvsFromDBActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetKvsFromDBActor*>(this)->actor_wait_state = 2;
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKvsFromDBActor, 1, Void >*>(static_cast<GetKvsFromDBActor*>(this)));
															#line 3712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& result,int loopDepth) 
	{
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(!result.more);
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for(int i = 0;i < result.size();i++) {
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (self->keyContainedInRanges(result[i].key, ignoreRanges))
															#line 3731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (self->backgroundTrafficEnabled && !self->keyContainedInRanges(result[i].key, loadedRanges))
															#line 3737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			res.push_back(Standalone(KeyValueRef(result[i].key, result[i].value)));
															#line 3743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && result,int loopDepth) 
	{
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(!result.more);
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for(int i = 0;i < result.size();i++) {
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (self->keyContainedInRanges(result[i].key, ignoreRanges))
															#line 3757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (self->backgroundTrafficEnabled && !self->keyContainedInRanges(result[i].key, loadedRanges))
															#line 3763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			res.push_back(Standalone(KeyValueRef(result[i].key, result[i].value)));
															#line 3769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKvsFromDBActor*>(this)->actor_wait_state > 0) static_cast<GetKvsFromDBActor*>(this)->actor_wait_state = 0;
		static_cast<GetKvsFromDBActor*>(this)->ActorCallback< GetKvsFromDBActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetKvsFromDBActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getKvsFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKvsFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKvsFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKvsFromDBActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getKvsFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKvsFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKvsFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKvsFromDBActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getKvsFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKvsFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKvsFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKvsFromDBActor*>(this)->actor_wait_state > 0) static_cast<GetKvsFromDBActor*>(this)->actor_wait_state = 0;
		static_cast<GetKvsFromDBActor*>(this)->ActorCallback< GetKvsFromDBActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKvsFromDBActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKvsFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKvsFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKvsFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKvsFromDBActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKvsFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKvsFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKvsFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKvsFromDBActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKvsFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKvsFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKvsFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoading* self;
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyRange> ignoreRanges;
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyRange> loadedRanges;
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyValue> res;
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 3949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getKvsFromDB()
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class GetKvsFromDBActor final : public Actor<std::vector<KeyValue>>, public ActorCallback< GetKvsFromDBActor, 0, RangeResult >, public ActorCallback< GetKvsFromDBActor, 1, Void >, public FastAllocated<GetKvsFromDBActor>, public GetKvsFromDBActorState<GetKvsFromDBActor> {
															#line 3954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetKvsFromDBActor>::operator new;
	using FastAllocated<GetKvsFromDBActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14941240465052462336UL, 10186441115983264000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyValue>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKvsFromDBActor, 0, RangeResult >;
friend struct ActorCallback< GetKvsFromDBActor, 1, Void >;
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	GetKvsFromDBActor(BulkLoading* const& self,Database const& cx,std::vector<KeyRange> const& ignoreRanges,std::vector<KeyRange> const& loadedRanges) 
															#line 3972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		 : Actor<std::vector<KeyValue>>(),
		   GetKvsFromDBActorState<GetKvsFromDBActor>(self, cx, ignoreRanges, loadedRanges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKvsFromDB", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(291331993281915904UL, 13819770196307862784UL);
		ActorExecutionContextHelper __helper(static_cast<GetKvsFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKvsFromDB");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKvsFromDB", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKvsFromDBActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKvsFromDBActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<std::vector<KeyValue>> getKvsFromDB( BulkLoading* const& self, Database const& cx, std::vector<KeyRange> const& ignoreRanges, std::vector<KeyRange> const& loadedRanges ) {
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<std::vector<KeyValue>>(new GetKvsFromDBActor(self, cx, ignoreRanges, loadedRanges));
															#line 4005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
}

#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

	Standalone<StringRef> getRandomStringRef() const {
		int stringLength = deterministicRandom()->randomInt(1, 10);
		Standalone<StringRef> stringBuffer = makeString(stringLength);
		deterministicRandom()->randomBytes(mutateString(stringBuffer), stringLength);
		return stringBuffer;
	}

	KeyRange getRandomRange(BulkLoading* self, KeyRange scope) const {
		loop {
			Standalone<StringRef> keyA = self->getRandomStringRef();
			Standalone<StringRef> keyB = self->getRandomStringRef();
			if (!scope.contains(keyA) || !scope.contains(keyB)) {
				continue;
			}
			KeyRange range = keyA < keyB ? KeyRangeRef(keyA, keyB) : KeyRangeRef(keyB, keyA);
			if (range.empty() || range.singleKeyRange()) {
				continue;
			}
			return range;
		}
	}

	std::vector<KeyValue> generateOrderedKVS(BulkLoading* self, KeyRange range, size_t count) {
		std::set<Key> keys; // ordered
		while (keys.size() < count) {
			Standalone<StringRef> str = self->getRandomStringRef();
			Key key = range.begin.withSuffix(str);
			if (keys.contains(key)) {
				continue;
			}
			if (!range.contains(key)) {
				continue;
			}
			keys.insert(key);
		}
		std::vector<KeyValue> res;
		for (const auto& key : keys) {
			Value val = self->getRandomStringRef();
			res.push_back(Standalone(KeyValueRef(key, val)));
		}
		return res; // ordered
	}

	BulkLoadFileSet generateSSTFiles(BulkLoading* self, std::string rootPath, BulkLoadTaskTestUnit task) {
		const std::string dataFileNameBase = deterministicRandom()->randomUniqueID().toString();
		const std::string dataFileName = dataFileNameBase + "-data.sst";
		const std::string sampleFileName = dataFileNameBase + "-sample.sst";
		BulkLoadFileSet res(rootPath, "", generateEmptyManifestFileName(), dataFileName, "", BulkLoadChecksum());
		std::string folder = res.getFolder();
		platform::eraseDirectoryRecursive(folder);
		ASSERT(platform::createDirectory(folder));
		std::string dataFile = res.getDataFileFullPath();
		std::unique_ptr<IRocksDBSstFileWriter> sstWriter = newRocksDBSstFileWriter();
		sstWriter->open(abspath(dataFile));
		std::vector<KeyValue> bytesSample;
		for (const auto& kv : task.data) {
			ByteSampleInfo sampleInfo = isKeyValueInSample(kv);
			if (sampleInfo.inSample) {
				Key sampleKey = kv.key;
				Value sampleValue = BinaryWriter::toValue(sampleInfo.sampledSize, Unversioned());
				bytesSample.push_back(Standalone(KeyValueRef(sampleKey, sampleValue)));
			}
			sstWriter->write(kv.key, kv.value);
		}
		TraceEvent("BulkLoadingDataProduced")
		    .detail("Task", task.bulkLoadTask.toString())
		    .detail("LoadKeyCount", task.data.size())
		    .detail("BytesSampleSize", bytesSample.size())
		    .detail("Folder", folder)
		    .detail("DataFile", dataFile);

		if (self->debugging) {
			TraceEvent e("DebugBulkLoadDataProducedKVS");
			e.setMaxEventLength(-1);
			e.setMaxFieldLength(-1);
			e.detail("Task", task.bulkLoadTask.toString());
			e.detail("LoadKeyCount", task.data.size());
			int counter = 0;
			for (const auto& kv : task.data) {
				e.detail("Key" + std::to_string(counter), kv.key);
				e.detail("Val" + std::to_string(counter), kv.value);
				counter++;
			}
		}
		ASSERT(sstWriter->finish());

		res.setByteSampleFileName(sampleFileName);
		std::string bytesSampleFile = res.getBytesSampleFileFullPath();
		if (bytesSample.size() > 0) {
			sstWriter->open(abspath(bytesSampleFile));
			for (const auto& kv : bytesSample) {
				sstWriter->write(kv.key, kv.value);
			}
			TraceEvent("BulkLoadingByteSampleProduced")
			    .detail("Task", task.bulkLoadTask.toString())
			    .detail("LoadKeyCount", task.data.size())
			    .detail("BytesSampleSize", bytesSample.size())
			    .detail("Folder", folder)
			    .detail("DataFile", dataFile)
			    .detail("BytesSampleFile", bytesSampleFile);
			ASSERT(sstWriter->finish());
		} else {
			res.removeByteSampleFile();
		}
		TraceEvent("BulkLoadingProduceDataToLoad").detail("Folder", folder).detail("LoadKeyCount", task.data.size());
		return res;
	}

	std::vector<Key> getAllKeys(const std::vector<KeyValue>& kvs) {
		std::vector<Key> res;
		for (const auto& kv : kvs) {
			res.push_back(kv.key);
		}
		return res;
	}

	BulkLoadTaskTestUnit generateBulkLoadTaskUnit(BulkLoading* self,
	                                              std::string folderPath,
	                                              int dataSize,
	                                              Optional<KeyRange> range = Optional<KeyRange>()) {
		KeyRange rangeToLoad = range.present() ? range.get() : self->getRandomRange(self, normalKeys);
		BulkLoadTaskTestUnit taskUnit;
		taskUnit.data = self->generateOrderedKVS(self, rangeToLoad, dataSize);
		BulkLoadFileSet fileSet = self->generateSSTFiles(self, folderPath, taskUnit);
		taskUnit.bulkLoadTask =
		    createBulkLoadTask(self->jobId,
		                       rangeToLoad,
		                       fileSet,
		                       BulkLoadByteSampleSetting(0,
		                                                 "hashlittle2", // use function name to represent the method
		                                                 SERVER_KNOBS->BYTE_SAMPLING_FACTOR,
		                                                 SERVER_KNOBS->BYTE_SAMPLING_OVERHEAD,
		                                                 SERVER_KNOBS->MIN_BYTE_SAMPLING_PROBABILITY),
		                       /*snapshotVersion=*/invalidVersion,
		                       taskUnit.getTotalBytes(),
		                       taskUnit.getKeyCount(),
		                       BulkLoadType::SST,
		                       BulkLoadTransportMethod::CP);
		TraceEvent("BulkLoadingWorkLoadTaskUnitGenerated")
		    .detail("TaskUnit", taskUnit.toString())
		    .detail("RangeToLoad", rangeToLoad)
		    .detail("Data", describe(self->getAllKeys(taskUnit.data)));
		return taskUnit;
	}

	bool checkSame(BulkLoading* self, std::vector<KeyValue> kvs, std::vector<KeyValue> kvsdb) {
		if (kvs.size() != kvsdb.size()) {
			TraceEvent(SevError, "BulkLoadingWorkLoadDataWrong")
			    .detail("Reason", "KeyValue count wrong")
			    .detail("KVS", kvs.size())
			    .detail("DB", kvsdb.size());
			if (self->debugging) {
				TraceEvent e("DebugBulkLoadKVS");
				e.setMaxEventLength(-1);
				e.setMaxFieldLength(-1);
				int counter = 0;
				for (const auto& kv : kvs) {
					e.detail("Key" + std::to_string(counter), kv.key);
					e.detail("Val" + std::to_string(counter), kv.value);
					counter++;
				}
				TraceEvent e1("DebugBulkLoadDB");
				e1.setMaxEventLength(-1);
				e1.setMaxFieldLength(-1);
				counter = 0;
				for (const auto& kv : kvsdb) {
					e1.detail("Key" + std::to_string(counter), kv.key);
					e1.detail("Val" + std::to_string(counter), kv.value);
					counter++;
				}
			}
			return false;
		}
		std::sort(kvs.begin(), kvs.end(), [](KeyValue a, KeyValue b) { return a.key < b.key; });
		std::sort(kvsdb.begin(), kvsdb.end(), [](KeyValue a, KeyValue b) { return a.key < b.key; });
		for (int i = 0; i < kvs.size(); i++) {
			if (kvs[i].key != kvsdb[i].key) {
				TraceEvent(SevError, "BulkLoadingWorkLoadDataWrong")
				    .detail("Reason", "Key mismatch")
				    .detail("KVS", kvs[i])
				    .detail("DB", kvsdb[i])
				    .detail("AllKVS", describe(self->getAllKeys(kvs)))
				    .detail("AllDB", describe(self->getAllKeys(kvsdb)));
				return false;
			} else if (kvs[i].value != kvsdb[i].value) {
				TraceEvent(SevError, "BulkLoadingWorkLoadDataWrong")
				    .detail("Reason", "Value mismatch")
				    .detail("KVS", kvs[i])
				    .detail("DB", kvsdb[i]);
				return false;
			}
		}
		return true;
	}

	// Issue three non-overlapping tasks and check data consistency and correctness
																#line 4206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
// This generated class is to be used only via simpleTest()
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class SimpleTestActor>
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class SimpleTestActorState {
															#line 4212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	SimpleTestActorState(BulkLoading* const& self,Database const& cx) 
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : self(self),
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   cx(cx)
															#line 4221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("simpleTest", reinterpret_cast<unsigned long>(this));

	}
	~SimpleTestActorState() 
	{
		fdb_probe_actor_destroy("simpleTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			TraceEvent("BulkLoadingWorkLoadSimpleTestBegin");
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			oldBulkLoadMode = 0;
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			bulkLoadTaskStates = std::vector<BulkLoadTaskState>();
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			taskRanges = std::vector<KeyRange>();
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			errorRanges = std::vector<KeyRange>();
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			taskUnits = std::vector<BulkLoadTaskTestUnit>();
															#line 518 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			i = 0;
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			i = 0;
															#line 4250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SimpleTestActorState();
		static_cast<SimpleTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 535 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestIssuedTasks");
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 2;
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 1, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 4282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!(i < 2))
															#line 4298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 520 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		std::string indexStr = std::to_string(i);
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		std::string indexStrNext = std::to_string(i + 1);
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		Key beginKey = StringRef(indexStr);
															#line 523 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		Key endKey = StringRef(indexStrNext);
															#line 524 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		std::string folderPath = joinPath(simulationBulkLoadFolder, indexStr);
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		int dataSize = std::pow(10, deterministicRandom()->randomInt(0, 4));
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		BulkLoadTaskTestUnit taskUnit = self->generateBulkLoadTaskUnit(self, folderPath, dataSize, KeyRangeRef(beginKey, endKey));
															#line 528 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		bulkLoadTaskStates.push_back(taskUnit.bulkLoadTask);
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		taskRanges.push_back(taskUnit.bulkLoadTask.getRange());
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		taskUnits.push_back(taskUnit);
															#line 531 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<bool> __when_expr_0 = self->submitBulkLoadTask(cx, taskUnit.bulkLoadTask);
															#line 531 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 1;
															#line 531 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 0, bool >*>(static_cast<SimpleTestActor*>(this)));
															#line 4331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& succeed,int loopDepth) 
	{
															#line 532 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(succeed);
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i++;
															#line 4355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && succeed,int loopDepth) 
	{
															#line 532 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(succeed);
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i++;
															#line 4366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& succeed,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(succeed, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && succeed,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(succeed), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_2 = self->waitUntilAllTaskCompleteOrError(self, cx);
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 3;
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >*>(static_cast<SimpleTestActor*>(this)));
															#line 4459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_2 = self->waitUntilAllTaskCompleteOrError(self, cx);
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 3;
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >*>(static_cast<SimpleTestActor*>(this)));
															#line 4477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for( const auto& errorTask : errorTasks ) {
															#line 540 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			errorRanges.push_back(errorTask.getRange());
															#line 4563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestAllComplete");
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(oldBulkLoadMode, setBulkLoadMode(cx, 0));
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 4;
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 3, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 4576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for( const auto& errorTask : errorTasks ) {
															#line 540 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			errorRanges.push_back(errorTask.getRange());
															#line 4587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestAllComplete");
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(oldBulkLoadMode, setBulkLoadMode(cx, 0));
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 4;
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 3, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 4600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont3(errorTasks, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(errorTasks), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 0);
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<KeyValue>> __when_expr_4 = self->getKvsFromDB(self, cx, errorRanges, taskRanges);
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 5;
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >*>(static_cast<SimpleTestActor*>(this)));
															#line 4693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 0);
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<KeyValue>> __when_expr_4 = self->getKvsFromDB(self, cx, errorRanges, taskRanges);
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 5;
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >*>(static_cast<SimpleTestActor*>(this)));
															#line 4711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		kvs = std::vector<KeyValue>();
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for(int j = 0;j < taskUnits.size();j++) {
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			bool rangeTaskError = false;
															#line 551 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			for( const auto& errorRange : errorRanges ) {
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (taskUnits[j].getRange() == errorRange)
															#line 4803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					rangeTaskError = true;
															#line 4807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
					break;
				}
			}
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (rangeTaskError)
															#line 4813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			kvs.insert(kvs.end(), taskUnits[j].data.begin(), taskUnits[j].data.end());
															#line 4819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(self->checkSame(self, kvs, dbkvs));
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_5 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 6;
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 5, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 4832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<KeyValue> const& __dbkvs,int loopDepth) 
	{
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		dbkvs = __dbkvs;
															#line 4841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<KeyValue> && __dbkvs,int loopDepth) 
	{
		dbkvs = std::move(__dbkvs);
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >*,std::vector<KeyValue> const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >*,std::vector<KeyValue> && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i = 0;
															#line 4922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i = 0;
															#line 4933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12(int loopDepth) 
	{
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_7 = acknowledgeAllErrorBulkLoadTasks(cx, self->jobId, normalKeys);
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont12when1(__when_expr_7.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 8;
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 7, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 5024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1(int loopDepth) 
	{
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!(i < bulkLoadTaskStates.size()))
															#line 5040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
			return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->finalizeBulkLoadTask(cx, bulkLoadTaskStates[i].getRange(), bulkLoadTaskStates[i].getTaskId());
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 7;
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 6, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 5053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i++;
															#line 5075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i++;
															#line 5084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont12cont1(Void const& _,int loopDepth) 
	{
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		;
															#line 5168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1(Void && _,int loopDepth) 
	{
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		;
															#line 5177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont12cont2(int loopDepth) 
	{
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestComplete");
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<SimpleTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimpleTestActorState(); static_cast<SimpleTestActor*>(this)->destroy(); return 0; }
															#line 5263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<SimpleTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SimpleTestActorState();
		static_cast<SimpleTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1(int loopDepth) 
	{
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<bool> __when_expr_8 = self->checkBulkLoadMetadataCleared(self, cx);
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1when1(__when_expr_8.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 9;
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 8, bool >*>(static_cast<SimpleTestActor*>(this)));
															#line 5289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont1(bool const& cleared,int loopDepth) 
	{
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (cleared)
															#line 5311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
			return a_body1cont12cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_9 = delay(1.0);
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 10;
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 9, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 5324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont1(bool && cleared,int loopDepth) 
	{
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (cleared)
															#line 5333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
			return a_body1cont12cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_9 = delay(1.0);
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 10;
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 9, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 5346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when1(bool const& cleared,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont1(cleared, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when1(bool && cleared,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont1(std::move(cleared), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 8, bool >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 8, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 8, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 8, bool >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont12cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoading* self;
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	int oldBulkLoadMode;
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<BulkLoadTaskState> bulkLoadTaskStates;
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyRange> taskRanges;
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyRange> errorRanges;
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<BulkLoadTaskTestUnit> taskUnits;
															#line 518 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	int i;
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyValue> dbkvs;
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyValue> kvs;
															#line 5533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
};
// This generated class is to be used only via simpleTest()
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class SimpleTestActor final : public Actor<Void>, public ActorCallback< SimpleTestActor, 0, bool >, public ActorCallback< SimpleTestActor, 1, Void >, public ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >, public ActorCallback< SimpleTestActor, 3, Void >, public ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >, public ActorCallback< SimpleTestActor, 5, Void >, public ActorCallback< SimpleTestActor, 6, Void >, public ActorCallback< SimpleTestActor, 7, Void >, public ActorCallback< SimpleTestActor, 8, bool >, public ActorCallback< SimpleTestActor, 9, Void >, public FastAllocated<SimpleTestActor>, public SimpleTestActorState<SimpleTestActor> {
															#line 5538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
	using FastAllocated<SimpleTestActor>::operator new;
	using FastAllocated<SimpleTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16173656683164655616UL, 6101712821306383616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SimpleTestActor, 0, bool >;
friend struct ActorCallback< SimpleTestActor, 1, Void >;
friend struct ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >;
friend struct ActorCallback< SimpleTestActor, 3, Void >;
friend struct ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >;
friend struct ActorCallback< SimpleTestActor, 5, Void >;
friend struct ActorCallback< SimpleTestActor, 6, Void >;
friend struct ActorCallback< SimpleTestActor, 7, Void >;
friend struct ActorCallback< SimpleTestActor, 8, bool >;
friend struct ActorCallback< SimpleTestActor, 9, Void >;
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	SimpleTestActor(BulkLoading* const& self,Database const& cx) 
															#line 5564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SimpleTestActorState<SimpleTestActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8221372827192469248UL, 17085292377102575616UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("simpleTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SimpleTestActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SimpleTestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SimpleTestActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< SimpleTestActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< SimpleTestActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< SimpleTestActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< SimpleTestActor, 8, bool >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< SimpleTestActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<Void> simpleTest( BulkLoading* const& self, Database const& cx ) {
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<Void>(new SimpleTestActor(self, cx));
															#line 5605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
}

#line 581 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

																#line 5610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
// This generated class is to be used only via setKeys()
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class SetKeysActor>
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class SetKeysActorState {
															#line 5616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	SetKeysActorState(Database const& cx,std::vector<KeyValue> const& kvs) 
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : cx(cx),
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   kvs(kvs),
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   tr(cx)
															#line 5627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("setKeys", reinterpret_cast<unsigned long>(this));

	}
	~SetKeysActorState() 
	{
		fdb_probe_actor_destroy("setKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 5642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			for( const auto& kv : kvs ) {
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				tr.set(kv.key, kv.value);
															#line 5675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			}
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<SetKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetKeysActor*>(this)->actor_wait_state = 1;
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetKeysActor, 0, Void >*>(static_cast<SetKeysActor*>(this)));
															#line 5686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<SetKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetKeysActor*>(this)->actor_wait_state = 2;
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetKeysActor, 1, Void >*>(static_cast<SetKeysActor*>(this)));
															#line 5715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<SetKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeysActorState(); static_cast<SetKeysActor*>(this)->destroy(); return 0; }
															#line 5730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<SetKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<SetKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeysActorState(); static_cast<SetKeysActor*>(this)->destroy(); return 0; }
															#line 5742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<SetKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetKeysActor*>(this)->actor_wait_state > 0) static_cast<SetKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeysActor*>(this)->ActorCallback< SetKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetKeysActor*>(this)->actor_wait_state > 0) static_cast<SetKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeysActor*>(this)->ActorCallback< SetKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyValue> kvs;
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 5918 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
};
// This generated class is to be used only via setKeys()
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class SetKeysActor final : public Actor<Void>, public ActorCallback< SetKeysActor, 0, Void >, public ActorCallback< SetKeysActor, 1, Void >, public FastAllocated<SetKeysActor>, public SetKeysActorState<SetKeysActor> {
															#line 5923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
	using FastAllocated<SetKeysActor>::operator new;
	using FastAllocated<SetKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15749001503167614464UL, 9772701276893487616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetKeysActor, 0, Void >;
friend struct ActorCallback< SetKeysActor, 1, Void >;
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	SetKeysActor(Database const& cx,std::vector<KeyValue> const& kvs) 
															#line 5941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SetKeysActorState<SetKeysActor>(cx, kvs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13837835877790460416UL, 6372757415257859072UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetKeysActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<Void> setKeys( Database const& cx, std::vector<KeyValue> const& kvs ) {
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<Void>(new SetKeysActor(cx, kvs));
															#line 5974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
}

#line 596 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

																#line 5979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
// This generated class is to be used only via backgroundWriteTraffic()
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class BackgroundWriteTrafficActor>
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class BackgroundWriteTrafficActorState {
															#line 5985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BackgroundWriteTrafficActorState(BulkLoading* const& self,Database const& cx) 
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : self(self),
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   cx(cx)
															#line 5994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this));

	}
	~BackgroundWriteTrafficActorState() 
	{
		fdb_probe_actor_destroy("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 6009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BackgroundWriteTrafficActorState();
		static_cast<BackgroundWriteTrafficActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 599 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		int keyCount = deterministicRandom()->randomInt(1, 20);
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		std::vector<KeyValue> kvs = self->generateOrderedKVS(self, normalKeys, keyCount);
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->setKeys(cx, kvs);
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state = 1;
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BackgroundWriteTrafficActor, 0, Void >*>(static_cast<BackgroundWriteTrafficActor*>(this)));
															#line 6050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		double delayTime = deterministicRandom()->random01() * 5.0;
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(delayTime);
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state = 2;
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BackgroundWriteTrafficActor, 1, Void >*>(static_cast<BackgroundWriteTrafficActor*>(this)));
															#line 6068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		double delayTime = deterministicRandom()->random01() * 5.0;
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(delayTime);
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state = 2;
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BackgroundWriteTrafficActor, 1, Void >*>(static_cast<BackgroundWriteTrafficActor*>(this)));
															#line 6086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state > 0) static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundWriteTrafficActor*>(this)->ActorCallback< BackgroundWriteTrafficActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundWriteTrafficActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundWriteTrafficActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BackgroundWriteTrafficActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundWriteTrafficActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BackgroundWriteTrafficActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundWriteTrafficActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state > 0) static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundWriteTrafficActor*>(this)->ActorCallback< BackgroundWriteTrafficActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundWriteTrafficActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundWriteTrafficActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BackgroundWriteTrafficActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundWriteTrafficActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BackgroundWriteTrafficActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundWriteTrafficActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoading* self;
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 6257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
};
// This generated class is to be used only via backgroundWriteTraffic()
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class BackgroundWriteTrafficActor final : public Actor<Void>, public ActorCallback< BackgroundWriteTrafficActor, 0, Void >, public ActorCallback< BackgroundWriteTrafficActor, 1, Void >, public FastAllocated<BackgroundWriteTrafficActor>, public BackgroundWriteTrafficActorState<BackgroundWriteTrafficActor> {
															#line 6262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
	using FastAllocated<BackgroundWriteTrafficActor>::operator new;
	using FastAllocated<BackgroundWriteTrafficActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18436587476407999744UL, 4685468733341699328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BackgroundWriteTrafficActor, 0, Void >;
friend struct ActorCallback< BackgroundWriteTrafficActor, 1, Void >;
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BackgroundWriteTrafficActor(BulkLoading* const& self,Database const& cx) 
															#line 6280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   BackgroundWriteTrafficActorState<BackgroundWriteTrafficActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(976740153564628992UL, 14086179552707660032UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundWriteTrafficActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("backgroundWriteTraffic");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BackgroundWriteTrafficActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BackgroundWriteTrafficActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<Void> backgroundWriteTraffic( BulkLoading* const& self, Database const& cx ) {
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<Void>(new BackgroundWriteTrafficActor(self, cx));
															#line 6313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
}

#line 606 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

																#line 6318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
// This generated class is to be used only via complexTest()
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class ComplexTestActor>
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class ComplexTestActorState {
															#line 6324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	ComplexTestActorState(BulkLoading* const& self,Database const& cx) 
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : self(self),
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   cx(cx),
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   taskMap()
															#line 6335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("complexTest", reinterpret_cast<unsigned long>(this));

	}
	~ComplexTestActorState() 
	{
		fdb_probe_actor_destroy("complexTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			taskMap.insert(allKeys, Optional<BulkLoadTaskTestUnit>());
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			i = 0;
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			oldBulkLoadMode = 0;
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			taskUnit = BulkLoadTaskTestUnit();
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			outdatedRanges = std::vector<KeyRange>();
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			errorRanges = std::vector<KeyRange>();
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ComplexTestActor*>(this)->actor_wait_state = 1;
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 0, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 6369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ComplexTestActorState();
		static_cast<ComplexTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 618 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		;
															#line 6394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 618 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		;
															#line 6405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_7 = self->waitUntilAllTaskCompleteOrError(self, cx);
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 8;
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >*>(static_cast<ComplexTestActor*>(this)));
															#line 6496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!(i < 3))
															#line 6512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		std::string folderPath = joinPath(simulationBulkLoadFolder, std::to_string(i));
															#line 621 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		int dataSize = std::pow(10, deterministicRandom()->randomInt(0, 4));
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		taskUnit = self->generateBulkLoadTaskUnit(self, folderPath, dataSize);
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(normalKeys.contains(taskUnit.bulkLoadTask.getRange()));
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<bool> __when_expr_1 = self->submitBulkLoadTask(cx, taskUnit.bulkLoadTask);
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 2;
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 1, bool >*>(static_cast<ComplexTestActor*>(this)));
															#line 6533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(bool const& succeed,int loopDepth) 
	{
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (succeed)
															#line 6555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			taskMap.insert(taskUnit.bulkLoadTask.getRange(), taskUnit);
															#line 6559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 6563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_2 = self->waitUntilAllTaskCompleteOrError(self, cx);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ComplexTestActor*>(this)->actor_wait_state = 3;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >*>(static_cast<ComplexTestActor*>(this)));
															#line 6574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(bool && succeed,int loopDepth) 
	{
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (succeed)
															#line 6588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			taskMap.insert(taskUnit.bulkLoadTask.getRange(), taskUnit);
															#line 6592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 6596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_2 = self->waitUntilAllTaskCompleteOrError(self, cx);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ComplexTestActor*>(this)->actor_wait_state = 3;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >*>(static_cast<ComplexTestActor*>(this)));
															#line 6607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(bool const& succeed,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(succeed, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(bool && succeed,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(succeed), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 6696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_3 = store(oldBulkLoadMode, setBulkLoadMode(cx, 0));
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<ComplexTestActor*>(this)->actor_wait_state = 4;
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 3, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 6707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(errorTasks, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(errorTasks), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 6808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_6 = delay(deterministicRandom()->random01() * 5);
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont6when1(__when_expr_6.get(), loopDepth); };
			static_cast<ComplexTestActor*>(this)->actor_wait_state = 7;
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 6, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 6819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode") .detail("OldMode", oldBulkLoadMode) .detail("NewMode", 0);
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(deterministicRandom()->random01() * 5);
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 5;
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 4, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 6842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode") .detail("OldMode", oldBulkLoadMode) .detail("NewMode", 0);
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(deterministicRandom()->random01() * 5);
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 5;
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 4, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 6860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_5 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 6;
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 5, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 6951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_5 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 6;
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 5, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 6967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode") .detail("OldMode", oldBulkLoadMode) .detail("NewMode", 1);
															#line 7051 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode") .detail("OldMode", oldBulkLoadMode) .detail("NewMode", 1);
															#line 7060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont11(int loopDepth) 
	{
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i++;
															#line 7144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont3(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for( const auto& errorTask : errorTasks ) {
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			errorRanges.push_back(errorTask.getRange());
															#line 7242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_8 = store(oldBulkLoadMode, setBulkLoadMode(cx, 0));
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont3when1(__when_expr_8.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 9;
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 8, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 7253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for( const auto& errorTask : errorTasks ) {
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			errorRanges.push_back(errorTask.getRange());
															#line 7264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_8 = store(oldBulkLoadMode, setBulkLoadMode(cx, 0));
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont3when1(__when_expr_8.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 9;
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 8, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 7275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont3(errorTasks, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(errorTasks), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 652 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 0);
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		kvs = std::vector<KeyValue>();
															#line 656 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		bulkLoadTaskStates = std::vector<BulkLoadTaskState>();
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		completeTaskRanges = std::vector<KeyRange>();
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for( auto& range : taskMap.ranges() ) {
															#line 659 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!range.value().present())
															#line 7369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (range.value().get().bulkLoadTask.getRange() != range.range())
															#line 7375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				ASSERT(range.value().get().bulkLoadTask.getRange().contains(range.range()));
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				outdatedRanges.push_back(range.range());
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (self->debugging)
															#line 7383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("DebugBulkLoadOutdateTask").detail("Task", range.value().get().bulkLoadTask.toString());
															#line 7387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				}
				continue;
			}
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			bool taskError = false;
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			for( const auto& errorRange : errorRanges ) {
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (errorRange == range.range())
															#line 7397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					taskError = true;
															#line 7401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				}
			}
															#line 678 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (taskError)
															#line 7406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (self->debugging)
															#line 7410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
															#line 680 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("DebugBulkLoadErrorTask").detail("Task", range.value().get().bulkLoadTask.toString());
															#line 7414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				}
															#line 682 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				bulkLoadTaskStates.push_back(range.value().get().bulkLoadTask);
															#line 7418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				continue;
			}
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			completeTaskRanges.push_back(range.range());
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			std::vector<KeyValue> kvsToCheck = range.value().get().data;
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			kvs.insert(std::end(kvs), std::begin(kvsToCheck), std::end(kvsToCheck));
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			bulkLoadTaskStates.push_back(range.value().get().bulkLoadTask);
															#line 7429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		std::vector<KeyRange> ignoreRanges;
															#line 691 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ignoreRanges.reserve(outdatedRanges.size() + errorRanges.size());
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ignoreRanges.insert(ignoreRanges.end(), outdatedRanges.begin(), outdatedRanges.end());
															#line 693 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ignoreRanges.insert(ignoreRanges.end(), errorRanges.begin(), errorRanges.end());
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<KeyValue>> __when_expr_9 = self->getKvsFromDB(self, cx, ignoreRanges, completeTaskRanges);
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont4when1(__when_expr_9.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 10;
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >*>(static_cast<ComplexTestActor*>(this)));
															#line 7448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 652 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 0);
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		kvs = std::vector<KeyValue>();
															#line 656 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		bulkLoadTaskStates = std::vector<BulkLoadTaskState>();
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		completeTaskRanges = std::vector<KeyRange>();
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for( auto& range : taskMap.ranges() ) {
															#line 659 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!range.value().present())
															#line 7467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (range.value().get().bulkLoadTask.getRange() != range.range())
															#line 7473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				ASSERT(range.value().get().bulkLoadTask.getRange().contains(range.range()));
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				outdatedRanges.push_back(range.range());
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (self->debugging)
															#line 7481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("DebugBulkLoadOutdateTask").detail("Task", range.value().get().bulkLoadTask.toString());
															#line 7485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				}
				continue;
			}
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			bool taskError = false;
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			for( const auto& errorRange : errorRanges ) {
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (errorRange == range.range())
															#line 7495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					taskError = true;
															#line 7499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				}
			}
															#line 678 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (taskError)
															#line 7504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (self->debugging)
															#line 7508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				{
															#line 680 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("DebugBulkLoadErrorTask").detail("Task", range.value().get().bulkLoadTask.toString());
															#line 7512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				}
															#line 682 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				bulkLoadTaskStates.push_back(range.value().get().bulkLoadTask);
															#line 7516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				continue;
			}
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			completeTaskRanges.push_back(range.range());
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			std::vector<KeyValue> kvsToCheck = range.value().get().data;
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			kvs.insert(std::end(kvs), std::begin(kvsToCheck), std::end(kvsToCheck));
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			bulkLoadTaskStates.push_back(range.value().get().bulkLoadTask);
															#line 7527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		}
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		std::vector<KeyRange> ignoreRanges;
															#line 691 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ignoreRanges.reserve(outdatedRanges.size() + errorRanges.size());
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ignoreRanges.insert(ignoreRanges.end(), outdatedRanges.begin(), outdatedRanges.end());
															#line 693 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ignoreRanges.insert(ignoreRanges.end(), errorRanges.begin(), errorRanges.end());
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<KeyValue>> __when_expr_9 = self->getKvsFromDB(self, cx, ignoreRanges, completeTaskRanges);
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont4when1(__when_expr_9.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 10;
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >*>(static_cast<ComplexTestActor*>(this)));
															#line 7546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont6(std::vector<KeyValue> const& dbkvs,int loopDepth) 
	{
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(self->checkSame(self, kvs, dbkvs));
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_10 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont6when1(__when_expr_10.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 11;
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 10, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 7639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(std::vector<KeyValue> && dbkvs,int loopDepth) 
	{
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(self->checkSame(self, kvs, dbkvs));
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_10 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7652 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont6when1(__when_expr_10.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 11;
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 10, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 7657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<KeyValue> const& dbkvs,int loopDepth) 
	{
		loopDepth = a_body1cont6(dbkvs, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<KeyValue> && dbkvs,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(dbkvs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >*,std::vector<KeyValue> const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >*,std::vector<KeyValue> && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont15(Void const& _,int loopDepth) 
	{
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i = 0;
															#line 7743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1cont15loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15(Void && _,int loopDepth) 
	{
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i = 0;
															#line 7754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1cont15loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont15cont1(int loopDepth) 
	{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_12 = acknowledgeAllErrorBulkLoadTasks(cx, self->jobId, normalKeys);
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont15cont1when1(__when_expr_12.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 13;
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 12, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 7845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont15loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont15loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15loopBody1(int loopDepth) 
	{
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!(i < bulkLoadTaskStates.size()))
															#line 7861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
			return a_body1cont15break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_11 = self->finalizeBulkLoadTask(cx, bulkLoadTaskStates[i].getRange(), bulkLoadTaskStates[i].getTaskId());
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont15loopBody1when1(__when_expr_11.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 12;
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 11, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 7874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont15break1(int loopDepth) 
	{
		try {
			return a_body1cont15cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i++;
															#line 7896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont15loopHead1(0);

		return loopDepth;
	}
	int a_body1cont15loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i++;
															#line 7905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont15loopHead1(0);

		return loopDepth;
	}
	int a_body1cont15loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont15loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont15loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont15loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont15cont2(Void const& _,int loopDepth) 
	{
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		;
															#line 7989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1cont15cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2(Void && _,int loopDepth) 
	{
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		;
															#line 7998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = a_body1cont15cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont15cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont15cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont15cont3(int loopDepth) 
	{
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<std::pair<KeyRange, RangeLockState>>> __when_expr_15 = findExclusiveReadLockOnRange(cx, normalKeys, rangeLockNameForBulkLoad);
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont15cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 16;
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >*>(static_cast<ComplexTestActor*>(this)));
															#line 8089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont15cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont15cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1(int loopDepth) 
	{
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<bool> __when_expr_13 = self->checkBulkLoadMetadataCleared(self, cx);
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont15cont2loopBody1when1(__when_expr_13.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 14;
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 13, bool >*>(static_cast<ComplexTestActor*>(this)));
															#line 8112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont15cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont15cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1cont1(bool const& cleared,int loopDepth) 
	{
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (cleared)
															#line 8134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
			return a_body1cont15cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_14 = delay(1.0);
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont15cont2loopBody1cont1when1(__when_expr_14.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 15;
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 14, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 8147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1cont1(bool && cleared,int loopDepth) 
	{
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (cleared)
															#line 8156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
			return a_body1cont15cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_14 = delay(1.0);
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont15cont2loopBody1cont1when1(__when_expr_14.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 15;
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 14, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 8169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1when1(bool const& cleared,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2loopBody1cont1(cleared, loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1when1(bool && cleared,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2loopBody1cont1(std::move(cleared), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 13, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 13, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont15cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 13, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont15cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 13, bool >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont15cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont15cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont15cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont15cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont15cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont15cont4(std::vector<std::pair<KeyRange, RangeLockState>> const& res,int loopDepth) 
	{
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(res.empty());
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestComplete");
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<ComplexTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ComplexTestActorState(); static_cast<ComplexTestActor*>(this)->destroy(); return 0; }
															#line 8344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<ComplexTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ComplexTestActorState();
		static_cast<ComplexTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont15cont4(std::vector<std::pair<KeyRange, RangeLockState>> && res,int loopDepth) 
	{
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(res.empty());
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestComplete");
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<ComplexTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ComplexTestActorState(); static_cast<ComplexTestActor*>(this)->destroy(); return 0; }
															#line 8360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<ComplexTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ComplexTestActorState();
		static_cast<ComplexTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont15cont3when1(std::vector<std::pair<KeyRange, RangeLockState>> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont15cont4(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont3when1(std::vector<std::pair<KeyRange, RangeLockState>> && res,int loopDepth) 
	{
		loopDepth = a_body1cont15cont4(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont15cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont15cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 15);

	}
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoading* self;
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	KeyRangeMap<Optional<BulkLoadTaskTestUnit>> taskMap;
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	int i;
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	int oldBulkLoadMode;
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoadTaskTestUnit taskUnit;
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyRange> outdatedRanges;
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyRange> errorRanges;
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyValue> kvs;
															#line 656 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<BulkLoadTaskState> bulkLoadTaskStates;
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyRange> completeTaskRanges;
															#line 8465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
};
// This generated class is to be used only via complexTest()
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class ComplexTestActor final : public Actor<Void>, public ActorCallback< ComplexTestActor, 0, Void >, public ActorCallback< ComplexTestActor, 1, bool >, public ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >, public ActorCallback< ComplexTestActor, 3, Void >, public ActorCallback< ComplexTestActor, 4, Void >, public ActorCallback< ComplexTestActor, 5, Void >, public ActorCallback< ComplexTestActor, 6, Void >, public ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >, public ActorCallback< ComplexTestActor, 8, Void >, public ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >, public ActorCallback< ComplexTestActor, 10, Void >, public ActorCallback< ComplexTestActor, 11, Void >, public ActorCallback< ComplexTestActor, 12, Void >, public ActorCallback< ComplexTestActor, 13, bool >, public ActorCallback< ComplexTestActor, 14, Void >, public ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >, public FastAllocated<ComplexTestActor>, public ComplexTestActorState<ComplexTestActor> {
															#line 8470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
	using FastAllocated<ComplexTestActor>::operator new;
	using FastAllocated<ComplexTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1301161178910954496UL, 2653840156645618432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ComplexTestActor, 0, Void >;
friend struct ActorCallback< ComplexTestActor, 1, bool >;
friend struct ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >;
friend struct ActorCallback< ComplexTestActor, 3, Void >;
friend struct ActorCallback< ComplexTestActor, 4, Void >;
friend struct ActorCallback< ComplexTestActor, 5, Void >;
friend struct ActorCallback< ComplexTestActor, 6, Void >;
friend struct ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >;
friend struct ActorCallback< ComplexTestActor, 8, Void >;
friend struct ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >;
friend struct ActorCallback< ComplexTestActor, 10, Void >;
friend struct ActorCallback< ComplexTestActor, 11, Void >;
friend struct ActorCallback< ComplexTestActor, 12, Void >;
friend struct ActorCallback< ComplexTestActor, 13, bool >;
friend struct ActorCallback< ComplexTestActor, 14, Void >;
friend struct ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >;
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	ComplexTestActor(BulkLoading* const& self,Database const& cx) 
															#line 8502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ComplexTestActorState<ComplexTestActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(428946891448577280UL, 5305349067125682688UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("complexTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ComplexTestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ComplexTestActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ComplexTestActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ComplexTestActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ComplexTestActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ComplexTestActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ComplexTestActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< ComplexTestActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< ComplexTestActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< ComplexTestActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< ComplexTestActor, 13, bool >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< ComplexTestActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<Void> complexTest( BulkLoading* const& self, Database const& cx ) {
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<Void>(new ComplexTestActor(self, cx));
															#line 8549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
}

#line 719 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

																#line 8554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class _startActor>
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class _startActorState {
															#line 8560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	_startActorState(BulkLoading* const& self,Database const& cx) 
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : self(self),
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   cx(cx)
															#line 8569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (self->clientId != 0)
															#line 8584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
															#line 722 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 8588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_startActorState();
				static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (g_network->isSimulated())
															#line 8596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				disableConnectionFailures("BulkLoading");
															#line 8600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			}
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (self->initializeBulkLoadMetadata)
															#line 8604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			{
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->clearAllBulkLoadTask(cx);
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 8615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (self->backgroundTrafficEnabled)
															#line 8643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 738 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			trafficActors = std::vector<Future<Void>>();
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			int actorCount = deterministicRandom()->randomInt(1, 10);
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			for(int i = 0;i < actorCount;i++) {
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				trafficActors.push_back(self->backgroundWriteTraffic(self, cx));
															#line 8653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			}
		}
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = registerRangeLockOwner(cx, rangeLockNameForBulkLoad, rangeLockNameForBulkLoad);
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 8665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_2 = getAllRangeLockOwners(cx);
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 8768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_2 = getAllRangeLockOwners(cx);
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 8784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(std::vector<RangeLockOwner> const& lockOwners,int loopDepth) 
	{
															#line 748 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(lockOwners.size() == 1 && lockOwners[0].getOwnerUniqueId() == rangeLockNameForBulkLoad);
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 8870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_3 = self->simpleTest(self, cx);
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 8881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->complexTest(self, cx);
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when2(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 8895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont8(std::vector<RangeLockOwner> && lockOwners,int loopDepth) 
	{
															#line 748 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(lockOwners.size() == 1 && lockOwners[0].getOwnerUniqueId() == rangeLockNameForBulkLoad);
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 8907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		{
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_3 = self->simpleTest(self, cx);
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 8918 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->complexTest(self, cx);
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when2(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 8932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont5when1(std::vector<RangeLockOwner> const& lockOwners,int loopDepth) 
	{
		loopDepth = a_body1cont8(lockOwners, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(std::vector<RangeLockOwner> && lockOwners,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(lockOwners), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 759 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_5 = removeRangeLockOwner(cx, rangeLockNameForBulkLoad);
															#line 759 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 759 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 9024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_6 = getAllRangeLockOwners(cx);
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 9214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_6 = getAllRangeLockOwners(cx);
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 9230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont1(std::vector<RangeLockOwner> const& lockOwnersAfterRemove,int loopDepth) 
	{
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(lockOwnersAfterRemove.empty());
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 9316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont1(std::vector<RangeLockOwner> && lockOwnersAfterRemove,int loopDepth) 
	{
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(lockOwnersAfterRemove.empty());
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 9330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12when1(std::vector<RangeLockOwner> const& lockOwnersAfterRemove,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(lockOwnersAfterRemove, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(std::vector<RangeLockOwner> && lockOwnersAfterRemove,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(lockOwnersAfterRemove), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoading* self;
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 738 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<Future<Void>> trafficActors;
															#line 9419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 9424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1267483780746308096UL, 15760443831593612544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >;
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	_startActor(BulkLoading* const& self,Database const& cx) 
															#line 9447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<Void> _start( BulkLoading* const& self, Database const& cx ) {
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 9485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoading.actor.g.cpp.py_gen"
}

#line 766 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
};

WorkloadFactory<BulkLoading> BulkLoadingFactory;
