#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
/*
 * BackupToDBUpgrade.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBOptions.g.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/ApiVersion.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// TODO: explain the purpose of this workload and how it different from the
// 20+ (literally) other backup/restore workloads.

struct BackupToDBUpgradeWorkload : TestWorkload {
	static constexpr auto NAME = "BackupToDBUpgrade";
	double backupAfter, stopDifferentialAfter;
	Key backupTag, restoreTag, backupPrefix, extraPrefix;
	int backupRangesCount, backupRangeLengthMax;
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
	Database extraDB;

	// This workload is not compatible with RandomRangeLock workload because they will race in locked range
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomRangeLock" });
	}

	BackupToDBUpgradeWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		backupAfter = getOption(options, "backupAfter"_sr, deterministicRandom()->random01() * 10.0);
		backupPrefix = getOption(options, "backupPrefix"_sr, StringRef());
		backupRangeLengthMax = getOption(options, "backupRangeLengthMax"_sr, 1);
		stopDifferentialAfter = getOption(options, "stopDifferentialAfter"_sr, 60.0);
		backupTag = getOption(options, "backupTag"_sr, BackupAgentBase::getDefaultTag());
		restoreTag = getOption(options, "restoreTag"_sr, "restore"_sr);
		backupRangesCount = getOption(options, "backupRangesCount"_sr, 5);
		extraPrefix = backupPrefix.withPrefix("\xfe\xff\xfe"_sr);
		backupPrefix = backupPrefix.withPrefix("\xfe\xff\xff"_sr);

		ASSERT(backupPrefix != StringRef());

		KeyRef beginRange;
		KeyRef endRange;

		if (backupRangesCount <= 0) {
			backupRanges.push_back_deep(backupRanges.arena(),
			                            KeyRangeRef(normalKeys.begin, std::min(backupPrefix, extraPrefix)));
		} else {
			// Add backup ranges
			for (int rangeLoop = 0; rangeLoop < backupRangesCount; rangeLoop++) {
				// Get a random range of a random sizes
				beginRange = KeyRef(backupRanges.arena(),
				                    deterministicRandom()->randomAlphaNumeric(
				                        deterministicRandom()->randomInt(1, backupRangeLengthMax + 1)));
				endRange = KeyRef(backupRanges.arena(),
				                  deterministicRandom()->randomAlphaNumeric(
				                      deterministicRandom()->randomInt(1, backupRangeLengthMax + 1)));

				// Add the range to the array
				backupRanges.push_back_deep(backupRanges.arena(),
				                            (beginRange < endRange) ? KeyRangeRef(beginRange, endRange)
				                                                    : KeyRangeRef(endRange, beginRange));

				// Track the added range
				TraceEvent("DRU_BackupRange")
				    .detail("RangeBegin", (beginRange < endRange) ? printable(beginRange) : printable(endRange))
				    .detail("RangeEnd", (beginRange < endRange) ? printable(endRange) : printable(beginRange));
			}
		}

		ASSERT(g_simulator->extraDatabases.size() == 1);
		extraDB = Database::createSimulatedExtraDatabase(g_simulator->extraDatabases[0]);

		TraceEvent("DRU_Start").log();
	}

	Future<Void> setup(Database const& cx) override {
		if (clientId != 0)
			return Void();
		return _setup(cx, this);
	}

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
// This generated class is to be used only via doBackup()
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
template <class DoBackupActor>
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class DoBackupActorState {
															#line 119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
public:
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DoBackupActorState(BackupToDBUpgradeWorkload* const& self,DatabaseBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges) 
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		 : self(self),
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupAgent(backupAgent),
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   cx(cx),
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   tag(tag),
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupRanges(backupRanges)
															#line 134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doBackup", reinterpret_cast<unsigned long>(this));

	}
	~DoBackupActorState() 
	{
		fdb_probe_actor_destroy("doBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(self->extraDB));
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				;
															#line 152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(backupAgent->waitBackup(self->extraDB, tag, StopWhenDone::False));
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 4;
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 3, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_DoBackupSubmitBackupError").error(e).detail("Tag", printable(tag));
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			{
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DoBackupInDifferentialMode").detail("Tag", printable(tag));
															#line 220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			for( auto r : self->backupRanges ) {
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				if (!r.empty())
															#line 239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				{
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					auto targetRange = r.withPrefix(self->backupPrefix);
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					printf("Clearing %s in destination\n", printable(targetRange).c_str());
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					tr->addReadConflictRange(targetRange);
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					tr->clear(targetRange);
															#line 249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				}
			}
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_0 = backupAgent->submitBackup( tr, tag, backupRanges, StopWhenDone::False, self->backupPrefix, StringRef());
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 1;
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 0, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 3;
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 2, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	BackupToDBUpgradeWorkload* self;
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DatabaseBackupAgent* backupAgent;
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Database cx;
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Key tag;
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doBackup()
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class DoBackupActor final : public Actor<Void>, public ActorCallback< DoBackupActor, 0, Void >, public ActorCallback< DoBackupActor, 1, Void >, public ActorCallback< DoBackupActor, 2, Void >, public ActorCallback< DoBackupActor, 3, Void >, public FastAllocated<DoBackupActor>, public DoBackupActorState<DoBackupActor> {
															#line 724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoBackupActor>::operator new;
	using FastAllocated<DoBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3056179856360307456UL, 13736526274810210816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBackupActor, 0, Void >;
friend struct ActorCallback< DoBackupActor, 1, Void >;
friend struct ActorCallback< DoBackupActor, 2, Void >;
friend struct ActorCallback< DoBackupActor, 3, Void >;
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DoBackupActor(BackupToDBUpgradeWorkload* const& self,DatabaseBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges) 
															#line 744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoBackupActorState<DoBackupActor>(self, backupAgent, cx, tag, backupRanges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15925328432552866816UL, 11115638302355080704UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBackupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoBackupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoBackupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoBackupActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
[[nodiscard]] static Future<Void> doBackup( BackupToDBUpgradeWorkload* const& self, DatabaseBackupAgent* const& backupAgent, Database const& cx, Key const& tag, Standalone<VectorRef<KeyRangeRef>> const& backupRanges ) {
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	return Future<Void>(new DoBackupActor(self, backupAgent, cx, tag, backupRanges));
															#line 779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
}

#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"

																#line 784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
// This generated class is to be used only via checkData()
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
template <class CheckDataActor>
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class CheckDataActorState {
															#line 790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
public:
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	CheckDataActorState(Database const& cx,UID const& logUid,UID const& destUid,Key const& tag,DatabaseBackupAgent* const& backupAgent) 
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		 : cx(cx),
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   logUid(logUid),
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   destUid(destUid),
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   tag(tag),
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupAgent(backupAgent),
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupAgentKey(uidPrefixKey(logRangesRange.begin, logUid)),
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupLogValuesKey(uidPrefixKey(backupLogKeys.begin, destUid)),
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupLatestVersionsPath(uidPrefixKey(backupLatestVersionsPrefix, destUid)),
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupLatestVersionsKey(uidPrefixKey(backupLatestVersionsPath, logUid)),
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   displaySystemKeys(0)
															#line 815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkData", reinterpret_cast<unsigned long>(this));

	}
	~CheckDataActorState() 
	{
		fdb_probe_actor_destroy("checkData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			ASSERT(destUid.isValid());
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			;
															#line 832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckDataActorState();
		static_cast<CheckDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (displaySystemKeys)
															#line 855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_9 = TaskBucket::debugPrintRange(cx, "\xff"_sr, StringRef());
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1when1(__when_expr_9.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 10;
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 9, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_CheckLeftoverkeys").detail("BackupTag", printable(tag));
															#line 889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		try {
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_CheckLeftovertasks").detail("BackupTag", printable(tag));
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = backupAgent->getTaskCount(tr);
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 1;
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 0, int64_t >*>(static_cast<CheckDataActor*>(this)));
															#line 902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_CheckError").error(e);
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_8 = tr->onError(e);
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 9;
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 8, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		waitCycles = 0;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if ((taskCount) && false)
															#line 963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_EndingNonzeroTaskCount") .detail("BackupTag", printable(tag)) .detail("TaskCount", taskCount) .detail("WaitCycles", waitCycles);
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("EndingNonZeroTasks: %ld\n", (long)taskCount);
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_1 = TaskBucket::debugPrintRange(cx, "\xff"_sr, StringRef());
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 2;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 1, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t const& __taskCount,int loopDepth) 
	{
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		taskCount = __taskCount;
															#line 992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t && __taskCount,int loopDepth) 
	{
		taskCount = std::move(__taskCount);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		;
															#line 1071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = tr->getRange(KeyRange(KeyRangeRef(backupAgentKey, strinc(backupAgentKey))), 100);
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 5;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 4, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 1174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!(taskCount > 0))
															#line 1190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		waitCycles++;
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_NonzeroTaskWait") .detail("BackupTag", printable(tag)) .detail("TaskCount", taskCount) .detail("WaitCycles", waitCycles);
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		printf("%.6f Wait #%4d for %lld tasks to end\n", now(), waitCycles, (long long)taskCount);
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(20.0);
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 3;
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 2, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 1209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(taskCount, backupAgent->getTaskCount(tr));
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 4;
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 3, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 1240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(taskCount, backupAgent->getTaskCount(tr));
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 4;
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 3, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 1258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont6(RangeResult const& agentValues,int loopDepth) 
	{
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (agentValues.size() > 0)
															#line 1429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			displaySystemKeys++;
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("BackupCorrectnessLeftoverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverMutationKeys") .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			for( auto& s : agentValues ) {
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				TraceEvent("DRU_LeftoverKey") .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 1443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 1450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr->get(backupLatestVersionsKey);
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 6;
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 5, Optional<Value> >*>(static_cast<CheckDataActor*>(this)));
															#line 1461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(RangeResult && agentValues,int loopDepth) 
	{
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (agentValues.size() > 0)
															#line 1470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			displaySystemKeys++;
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("BackupCorrectnessLeftoverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverMutationKeys") .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			for( auto& s : agentValues ) {
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				TraceEvent("DRU_LeftoverKey") .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 1484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 1491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr->get(backupLatestVersionsKey);
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 6;
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 5, Optional<Value> >*>(static_cast<CheckDataActor*>(this)));
															#line 1502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(RangeResult const& agentValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(agentValues, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(RangeResult && agentValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(agentValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont7(Optional<Value> const& latestVersion,int loopDepth) 
	{
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (latestVersion.present())
															#line 1586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverVersionKey") .detail("BackupTag", printable(tag)) .detail("Key", backupLatestVersionsKey.printable()) .detail("Value", BinaryReader::fromStringRef<Version>(latestVersion.get(), Unversioned()));
															#line 1590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
		else
		{
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("No left over backup version key\n");
															#line 1596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = tr->getRange(KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 7;
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 6, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 1607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Optional<Value> && latestVersion,int loopDepth) 
	{
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (latestVersion.present())
															#line 1616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverVersionKey") .detail("BackupTag", printable(tag)) .detail("Key", backupLatestVersionsKey.printable()) .detail("Value", BinaryReader::fromStringRef<Version>(latestVersion.get(), Unversioned()));
															#line 1620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
		else
		{
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("No left over backup version key\n");
															#line 1626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = tr->getRange(KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 7;
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 6, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 1637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<Value> const& latestVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(latestVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<Value> && latestVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(latestVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont11(RangeResult const& versions,int loopDepth) 
	{
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!versions.size())
															#line 1721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<RangeResult> __when_expr_7 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont11when1(__when_expr_7.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 8;
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 7, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 1732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont11(RangeResult && versions,int loopDepth) 
	{
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!versions.size())
															#line 1746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<RangeResult> __when_expr_7 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont11when1(__when_expr_7.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 8;
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 7, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 1757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(RangeResult const& versions,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(versions, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(RangeResult && versions,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(versions), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont11cont1(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont11cont2(RangeResult const& logValues,int loopDepth) 
	{
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (logValues.size() > 0)
															#line 1852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			displaySystemKeys++;
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("BackupCorrectnessLeftoverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverLogKeys") .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey)) .detail("Version", decodeBKMutationLogKey(logValues[0].key).first);
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			for( auto& s : logValues ) {
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				TraceEvent("DRU_LeftoverKey") .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 1866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("No left over backup log keys\n");
															#line 1873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11cont2(RangeResult && logValues,int loopDepth) 
	{
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (logValues.size() > 0)
															#line 1883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			displaySystemKeys++;
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("BackupCorrectnessLeftoverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverLogKeys") .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey)) .detail("Version", decodeBKMutationLogKey(logValues[0].key).first);
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			for( auto& s : logValues ) {
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				TraceEvent("DRU_LeftoverKey") .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 1897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("No left over backup log keys\n");
															#line 1904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(RangeResult const& logValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont2(logValues, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(RangeResult && logValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont2(std::move(logValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 7, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 7, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 7, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 7, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!static_cast<CheckDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataActorState(); static_cast<CheckDataActor*>(this)->destroy(); return 0; }
															#line 2076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		new (&static_cast<CheckDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckDataActorState();
		static_cast<CheckDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Database cx;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	UID logUid;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	UID destUid;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Key tag;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DatabaseBackupAgent* backupAgent;
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Key backupAgentKey;
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Key backupLogValuesKey;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Key backupLatestVersionsPath;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Key backupLatestVersionsKey;
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	int displaySystemKeys;
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	int64_t taskCount;
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	int waitCycles;
															#line 2197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkData()
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class CheckDataActor final : public Actor<Void>, public ActorCallback< CheckDataActor, 0, int64_t >, public ActorCallback< CheckDataActor, 1, Void >, public ActorCallback< CheckDataActor, 2, Void >, public ActorCallback< CheckDataActor, 3, Void >, public ActorCallback< CheckDataActor, 4, RangeResult >, public ActorCallback< CheckDataActor, 5, Optional<Value> >, public ActorCallback< CheckDataActor, 6, RangeResult >, public ActorCallback< CheckDataActor, 7, RangeResult >, public ActorCallback< CheckDataActor, 8, Void >, public ActorCallback< CheckDataActor, 9, Void >, public FastAllocated<CheckDataActor>, public CheckDataActorState<CheckDataActor> {
															#line 2202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckDataActor>::operator new;
	using FastAllocated<CheckDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8790370190076318976UL, 9119181056674913024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckDataActor, 0, int64_t >;
friend struct ActorCallback< CheckDataActor, 1, Void >;
friend struct ActorCallback< CheckDataActor, 2, Void >;
friend struct ActorCallback< CheckDataActor, 3, Void >;
friend struct ActorCallback< CheckDataActor, 4, RangeResult >;
friend struct ActorCallback< CheckDataActor, 5, Optional<Value> >;
friend struct ActorCallback< CheckDataActor, 6, RangeResult >;
friend struct ActorCallback< CheckDataActor, 7, RangeResult >;
friend struct ActorCallback< CheckDataActor, 8, Void >;
friend struct ActorCallback< CheckDataActor, 9, Void >;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	CheckDataActor(Database const& cx,UID const& logUid,UID const& destUid,Key const& tag,DatabaseBackupAgent* const& backupAgent) 
															#line 2228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckDataActorState<CheckDataActor>(cx, logUid, destUid, tag, backupAgent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12159733170968748032UL, 9261654583238461696UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckDataActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckDataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckDataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckDataActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckDataActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CheckDataActor, 5, Optional<Value> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CheckDataActor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CheckDataActor, 7, RangeResult >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CheckDataActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CheckDataActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
[[nodiscard]] static Future<Void> checkData( Database const& cx, UID const& logUid, UID const& destUid, Key const& tag, DatabaseBackupAgent* const& backupAgent ) {
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	return Future<Void>(new CheckDataActor(cx, logUid, destUid, tag, backupAgent));
															#line 2269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
}

#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"

																#line 2274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
// This generated class is to be used only via _setup()
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
template <class _setupActor>
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class _setupActorState {
															#line 2280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
public:
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	_setupActorState(Database const& cx,BackupToDBUpgradeWorkload* const& self) 
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		 : cx(cx),
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   self(self),
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupAgent(cx)
															#line 2291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (BUGGIFY)
															#line 2306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			{
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				for( auto r : getSystemBackupRanges() ) {
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					self->backupRanges.push_back_deep(self->backupRanges.arena(), r);
															#line 2312 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				}
			}
			try {
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(self->backupAfter);
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 2325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 2354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupToDBUpgradeSetupError").error(e);
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DoBackup").detail("Tag", printable(self->backupTag));
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		b = doBackup(self, &backupAgent, self->extraDB, self->backupTag, self->backupRanges);
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DoBackupWait").detail("BackupTag", printable(self->backupTag));
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_1 = b;
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont4when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 2396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DoBackup").detail("Tag", printable(self->backupTag));
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		b = doBackup(self, &backupAgent, self->extraDB, self->backupTag, self->backupRanges);
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DoBackupWait").detail("BackupTag", printable(self->backupTag));
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_1 = b;
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont4when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 2418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DoBackupWaitEnd").detail("BackupTag", printable(self->backupTag));
															#line 2502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DoBackupWaitEnd").detail("BackupTag", printable(self->backupTag));
															#line 2511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Database cx;
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	BackupToDBUpgradeWorkload* self;
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Future<Void> b;
															#line 2612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _setup()
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 2617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14929193575057340160UL, 3696906191346051840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	_setupActor(Database const& cx,BackupToDBUpgradeWorkload* const& self) 
															#line 2635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, BackupToDBUpgradeWorkload* const& self ) {
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 2668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
}

#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"

																#line 2673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
// This generated class is to be used only via diffRanges()
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
template <class DiffRangesActor>
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class DiffRangesActorState {
															#line 2679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
public:
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DiffRangesActorState(Standalone<VectorRef<KeyRangeRef>> const& ranges,StringRef const& backupPrefix,Database const& src,Database const& dest) 
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		 : ranges(ranges),
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupPrefix(backupPrefix),
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   src(src),
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   dest(dest),
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   rangeIndex()
															#line 2694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("diffRanges", reinterpret_cast<unsigned long>(this));

	}
	~DiffRangesActorState() 
	{
		fdb_probe_actor_destroy("diffRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			rangeIndex = 0;
															#line 2709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DiffRangesActorState();
		static_cast<DiffRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!static_cast<DiffRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DiffRangesActorState(); static_cast<DiffRangesActor*>(this)->destroy(); return 0; }
															#line 2732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		new (&static_cast<DiffRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DiffRangesActorState();
		static_cast<DiffRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!(rangeIndex < ranges.size()))
															#line 2751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		range = ranges[rangeIndex];
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		begin = range.begin;
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (range.empty())
															#line 2761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
			return a_body1continue1(loopDepth); // continue
		}
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		;
															#line 2767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1continue1(int loopDepth) 
	{
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		++rangeIndex;
															#line 2789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		++rangeIndex;
															#line 2798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr = Transaction(src);
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr2 = Transaction(dest);
															#line 2816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		try {
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			;
															#line 2820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<DiffRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DiffRangesActor*>(this)->actor_wait_state = 2;
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DiffRangesActor, 1, Void >*>(static_cast<DiffRangesActor*>(this)));
															#line 2862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1(int loopDepth) 
	{
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr2.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr2.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		srcFuture = tr.getRange(KeyRangeRef(begin, range.end), 1000);
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		bkpFuture = tr2.getRange(KeyRangeRef(begin, range.end).withPrefix(backupPrefix), 1000);
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_0 = success(srcFuture) && success(bkpFuture);
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DiffRangesActor*>(this)->actor_wait_state = 1;
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DiffRangesActor, 0, Void >*>(static_cast<DiffRangesActor*>(this)));
															#line 2909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		auto src = srcFuture.get().begin();
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		auto bkp = bkpFuture.get().begin();
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for(;src != srcFuture.get().end() && bkp != bkpFuture.get().end();) {
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			KeyRef bkpKey = bkp->key.substr(backupPrefix.size());
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (src->key != bkpKey && src->value != bkp->value)
															#line 2939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			{
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				TraceEvent(SevError, "MismatchKeyAndValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 2943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			}
			else
			{
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				if (src->key != bkpKey)
															#line 2949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				{
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					TraceEvent(SevError, "MismatchKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 2953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				}
				else
				{
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					if (src->value != bkp->value)
															#line 2959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
					{
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
						TraceEvent(SevError, "MismatchValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 2963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
					}
				}
			}
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			begin = std::min(src->key, bkpKey);
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (src->key == bkpKey)
															#line 2971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			{
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				++src;
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				++bkp;
															#line 2977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			}
			else
			{
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				if (src->key < bkpKey)
															#line 2983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				{
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					++src;
															#line 2987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				}
				else
				{
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					++bkp;
															#line 2993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				}
			}
		}
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for(;src != srcFuture.get().end() && !bkpFuture.get().more;) {
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "MissingBkpKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value));
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			begin = src->key;
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			++src;
															#line 3005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for(;bkp != bkpFuture.get().end() && !srcFuture.get().more;) {
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "MissingSrcKey") .detail("BkpKey", printable(bkp->key.substr(backupPrefix.size()))) .detail("BkpVal", printable(bkp->value));
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			begin = bkp->key;
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			++bkp;
															#line 3015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!srcFuture.get().more && !bkpFuture.get().more)
															#line 3019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		begin = keyAfter(begin);
															#line 3025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		auto src = srcFuture.get().begin();
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		auto bkp = bkpFuture.get().begin();
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for(;src != srcFuture.get().end() && bkp != bkpFuture.get().end();) {
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			KeyRef bkpKey = bkp->key.substr(backupPrefix.size());
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (src->key != bkpKey && src->value != bkp->value)
															#line 3042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			{
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				TraceEvent(SevError, "MismatchKeyAndValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 3046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			}
			else
			{
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				if (src->key != bkpKey)
															#line 3052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				{
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					TraceEvent(SevError, "MismatchKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 3056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				}
				else
				{
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					if (src->value != bkp->value)
															#line 3062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
					{
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
						TraceEvent(SevError, "MismatchValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 3066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
					}
				}
			}
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			begin = std::min(src->key, bkpKey);
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (src->key == bkpKey)
															#line 3074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			{
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				++src;
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				++bkp;
															#line 3080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			}
			else
			{
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				if (src->key < bkpKey)
															#line 3086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				{
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					++src;
															#line 3090 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				}
				else
				{
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					++bkp;
															#line 3096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				}
			}
		}
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for(;src != srcFuture.get().end() && !bkpFuture.get().more;) {
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "MissingBkpKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value));
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			begin = src->key;
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			++src;
															#line 3108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for(;bkp != bkpFuture.get().end() && !srcFuture.get().more;) {
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "MissingSrcKey") .detail("BkpKey", printable(bkp->key.substr(backupPrefix.size()))) .detail("BkpVal", printable(bkp->value));
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			begin = bkp->key;
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			++bkp;
															#line 3118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!srcFuture.get().more && !bkpFuture.get().more)
															#line 3122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		begin = keyAfter(begin);
															#line 3128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state > 0) static_cast<DiffRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DiffRangesActor*>(this)->ActorCallback< DiffRangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DiffRangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state > 0) static_cast<DiffRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DiffRangesActor*>(this)->ActorCallback< DiffRangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DiffRangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	StringRef backupPrefix;
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Database src;
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Database dest;
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	int rangeIndex;
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	KeyRangeRef range;
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Key begin;
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Transaction tr;
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Transaction tr2;
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Future<RangeResult> srcFuture;
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Future<RangeResult> bkpFuture;
															#line 3317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
};
// This generated class is to be used only via diffRanges()
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class DiffRangesActor final : public Actor<Void>, public ActorCallback< DiffRangesActor, 0, Void >, public ActorCallback< DiffRangesActor, 1, Void >, public FastAllocated<DiffRangesActor>, public DiffRangesActorState<DiffRangesActor> {
															#line 3322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
public:
	using FastAllocated<DiffRangesActor>::operator new;
	using FastAllocated<DiffRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9262938146560129792UL, 1525303323017053696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DiffRangesActor, 0, Void >;
friend struct ActorCallback< DiffRangesActor, 1, Void >;
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DiffRangesActor(Standalone<VectorRef<KeyRangeRef>> const& ranges,StringRef const& backupPrefix,Database const& src,Database const& dest) 
															#line 3340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DiffRangesActorState<DiffRangesActor>(ranges, backupPrefix, src, dest),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14464715535444249600UL, 3030925669057132800UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("diffRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DiffRangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DiffRangesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
[[nodiscard]] static Future<Void> diffRanges( Standalone<VectorRef<KeyRangeRef>> const& ranges, StringRef const& backupPrefix, Database const& src, Database const& dest ) {
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	return Future<Void>(new DiffRangesActor(ranges, backupPrefix, src, dest));
															#line 3373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
}

#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"

																#line 3378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
template <class _startActor>
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class _startActorState {
															#line 3384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
public:
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	_startActorState(Database const& cx,BackupToDBUpgradeWorkload* const& self) 
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		 : cx(cx),
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   self(self),
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupAgent(cx),
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   restoreTool(self->extraDB),
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   prevBackupRanges(),
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   logUid(),
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   commitVersion(),
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   stopDifferential(delay(self->stopDifferentialAfter)),
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   waitUpgrade(backupAgent.waitUpgradeToLatestDrVersion(self->extraDB, self->backupTag))
															#line 3407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(stopDifferential) && success(waitUpgrade);
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 3429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_WaitDifferentialEnd").detail("Tag", printable(self->backupTag));
															#line 3452 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		try {
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(self->extraDB));
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			;
															#line 3458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_WaitDifferentialEnd").detail("Tag", printable(self->backupTag));
															#line 3473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		try {
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(self->extraDB));
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			;
															#line 3479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupAndRestoreCorrectnessError").error(e);
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 3584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_Locked").detail("LockedVersion", commitVersion);
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		versionCheckTr = ReadYourWritesTransaction(self->extraDB);
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		;
															#line 3602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<UID> __when_expr_1 = backupAgent.getLogUid(tr, self->backupTag);
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, UID >*>(static_cast<_startActor*>(this)));
															#line 3628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_GetRestoreRangeError").error(e);
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr->onError(e);
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 3672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(UID const& _logUid,int loopDepth) 
	{
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		logUid = _logUid;
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Optional<Key>> __when_expr_2 = tr->get(backupAgent.config.get(BinaryWriter::toValue(logUid, Unversioned())) .pack(BackupAgentBase::keyConfigBackupRanges));
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Optional<Key> >*>(static_cast<_startActor*>(this)));
															#line 3696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(UID && _logUid,int loopDepth) 
	{
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		logUid = _logUid;
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Optional<Key>> __when_expr_2 = tr->get(backupAgent.config.get(BinaryWriter::toValue(logUid, Unversioned())) .pack(BackupAgentBase::keyConfigBackupRanges));
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Optional<Key> >*>(static_cast<_startActor*>(this)));
															#line 3714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(UID const& _logUid,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_logUid, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(UID && _logUid,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_logUid), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Optional<Key> const& backupKeysPacked,int loopDepth) 
	{
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		ASSERT(backupKeysPacked.present());
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		BinaryReader br(backupKeysPacked.get(), IncludeVersion());
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		prevBackupRanges = Standalone<VectorRef<KeyRangeRef>>();
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		br >> prevBackupRanges;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_3 = lockDatabase(tr, logUid);
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 3813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Optional<Key> && backupKeysPacked,int loopDepth) 
	{
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		ASSERT(backupKeysPacked.present());
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		BinaryReader br(backupKeysPacked.get(), IncludeVersion());
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		prevBackupRanges = Standalone<VectorRef<KeyRangeRef>>();
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		br >> prevBackupRanges;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_3 = lockDatabase(tr, logUid);
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 3837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Key> const& backupKeysPacked,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(backupKeysPacked, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Key> && backupKeysPacked,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(backupKeysPacked), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Optional<Key> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Optional<Key> >*,Optional<Key> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Optional<Key> >*,Optional<Key> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Optional<Key> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr->addWriteConflictRange(singleKeyRange(StringRef()));
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 3930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr->addWriteConflictRange(singleKeyRange(StringRef()));
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 3948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		commitVersion = tr->getCommittedVersion();
															#line 4032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		commitVersion = tr->getCommittedVersion();
															#line 4041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 464 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DiffRanges").log();
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_10 = diffRanges(prevBackupRanges, self->backupPrefix, cx, self->extraDB);
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont4when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 4221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
		try {
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			versionCheckTr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			versionCheckTr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_6 = versionCheckTr.get( BinaryWriter::toValue(logUid, Unversioned()).withPrefix(applyMutationsBeginRange.begin));
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont3loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont3loopBody1when1(__when_expr_6.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 4249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_GetAppliedVersionError").error(e);
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_9 = versionCheckTr.onError(e);
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1Catch1when1(__when_expr_9.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 4293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_Applied") .detail("AppliedVersion", v.present() ? BinaryReader::fromStringRef<Version>(v.get(), Unversioned()) : -1);
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (v.present() && BinaryReader::fromStringRef<Version>(v.get(), Unversioned()) >= commitVersion)
															#line 4310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		versionWatch = versionCheckTr.watch( BinaryWriter::toValue(logUid, Unversioned()).withPrefix(applyMutationsBeginRange.begin));
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_7 = versionCheckTr.commit();
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont3loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont3loopBody1cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 4325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_Applied") .detail("AppliedVersion", v.present() ? BinaryReader::fromStringRef<Version>(v.get(), Unversioned()) : -1);
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (v.present() && BinaryReader::fromStringRef<Version>(v.get(), Unversioned()) >= commitVersion)
															#line 4336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		versionWatch = versionCheckTr.watch( BinaryWriter::toValue(logUid, Unversioned()).withPrefix(applyMutationsBeginRange.begin));
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_7 = versionCheckTr.commit();
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont3loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont3loopBody1cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 4351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_8 = versionWatch;
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont3loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont3loopBody1cont3when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 4442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_8 = versionWatch;
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont3loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont3loopBody1cont3when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 4458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont3loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		versionCheckTr.reset();
															#line 4542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		versionCheckTr.reset();
															#line 4551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont3loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont3loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont3loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 468 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_AbortBackup").detail("Tag", printable(self->backupTag));
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_11 = backupAgent.abortBackup(self->extraDB, self->backupTag);
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont5when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 4744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 468 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_AbortBackup").detail("Tag", printable(self->backupTag));
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_11 = backupAgent.abortBackup(self->extraDB, self->backupTag);
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont5when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 4762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_12 = unlockDatabase(self->extraDB, logUid);
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont6when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 4853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_12 = unlockDatabase(self->extraDB, logUid);
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont6when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 4869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_PrepareRestore").detail("RestoreTag", printable(self->restoreTag));
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr2 = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		;
															#line 4957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_PrepareRestore").detail("RestoreTag", printable(self->restoreTag));
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr2 = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		;
															#line 4970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 494 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		restoreRanges = Standalone<VectorRef<KeyRangeRef>>();
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for( auto r : prevBackupRanges ) {
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			restoreRanges.push_back_deep( restoreRanges.arena(), KeyRangeRef(r.begin.withPrefix(self->backupPrefix), r.end.withPrefix(self->backupPrefix)));
															#line 5058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
		try {
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_RestoreDb").detail("RestoreTag", printable(self->restoreTag));
															#line 504 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_15 = restoreTool.submitBackup( cx, self->restoreTag, restoreRanges, StopWhenDone::True, StringRef(), self->backupPrefix);
															#line 504 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 5067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont8Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont8when1(__when_expr_15.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 504 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 5072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont8Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1(int loopDepth) 
	{
		try {
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			tr2->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			tr2->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			for( auto r : prevBackupRanges ) {
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				if (!r.empty())
															#line 5101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				{
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					std::cout << "r: " << r.begin.printable() << " - " << r.end.printable() << std::endl;
															#line 482 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					tr2->addReadConflictRange(r);
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					tr2->clear(r);
															#line 5109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
				}
			}
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_13 = tr2->commit();
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont7loopBody1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont7loopBody1when1(__when_expr_13.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 5121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_RestoreSetupError").errorUnsuppressed(e);
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_14 = tr2->onError(e);
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1Catch1when1(__when_expr_14.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, Void >*>(static_cast<_startActor*>(this)));
															#line 5165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont7loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont7loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont7loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont7loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont7loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_16 = success(restoreTool.waitBackup(cx, self->restoreTag));
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont9when1(__when_expr_16.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, Void >*>(static_cast<_startActor*>(this)));
															#line 5361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_RestoreSubmitBackupError").error(e).detail("Tag", printable(self->restoreTag));
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 5373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			{
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				return a_body1cont1Catch1(e, loopDepth);
															#line 5377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< _startActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_17 = restoreTool.unlockBackup(cx, self->restoreTag);
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont12when1(__when_expr_17.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 18;
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _startActor, 17, Void >*>(static_cast<_startActor*>(this)));
															#line 5500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_17 = restoreTool.unlockBackup(cx, self->restoreTag);
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont12when1(__when_expr_17.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 18;
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _startActor, 17, Void >*>(static_cast<_startActor*>(this)));
															#line 5516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< _startActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< _startActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont12cont1(Void const& _,int loopDepth) 
	{
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_18 = checkData(self->extraDB, logUid, logUid, self->backupTag, &backupAgent);
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_18.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 19;
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _startActor, 18, Void >*>(static_cast<_startActor*>(this)));
															#line 5607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1(Void && _,int loopDepth) 
	{
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_18 = checkData(self->extraDB, logUid, logUid, self->backupTag, &backupAgent);
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_18.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 19;
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _startActor, 18, Void >*>(static_cast<_startActor*>(this)));
															#line 5623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< _startActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< _startActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont12cont2(Void const& _,int loopDepth) 
	{
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<UID> __when_expr_19 = restoreTool.getLogUid(cx, self->restoreTag);
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_19.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 20;
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< _startActor, 19, UID >*>(static_cast<_startActor*>(this)));
															#line 5714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2(Void && _,int loopDepth) 
	{
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<UID> __when_expr_19 = restoreTool.getLogUid(cx, self->restoreTag);
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_19.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 20;
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< _startActor, 19, UID >*>(static_cast<_startActor*>(this)));
															#line 5730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 18, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 18, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< _startActor, 18, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< _startActor, 18, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont12cont3(int loopDepth) 
	{
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_20 = checkData(cx, restoreUid, restoreUid, self->restoreTag, &restoreTool);
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1cont1Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont12cont3when1(__when_expr_20.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 21;
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< _startActor, 20, Void >*>(static_cast<_startActor*>(this)));
															#line 5821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2when1(UID const& __restoreUid,int loopDepth) 
	{
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		restoreUid = __restoreUid;
															#line 5830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2when1(UID && __restoreUid,int loopDepth) 
	{
		restoreUid = std::move(__restoreUid);
		loopDepth = a_body1cont12cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 19, UID >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 19, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont12cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< _startActor, 19, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont12cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< _startActor, 19, UID >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont12cont4(Void const& _,int loopDepth) 
	{
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_Complete").detail("BackupTag", printable(self->backupTag));
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (g_simulator->drAgents == ISimulator::BackupAgentType::BackupToDB)
															#line 5911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			g_simulator->drAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 5915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4(Void && _,int loopDepth) 
	{
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_Complete").detail("BackupTag", printable(self->backupTag));
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (g_simulator->drAgents == ISimulator::BackupAgentType::BackupToDB)
															#line 5927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		{
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			g_simulator->drAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 5931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 20, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 20, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont12cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< _startActor, 20, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont12cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< _startActor, 20, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont12cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Database cx;
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	BackupToDBUpgradeWorkload* self;
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DatabaseBackupAgent restoreTool;
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> prevBackupRanges;
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	UID logUid;
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Version commitVersion;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Future<Void> stopDifferential;
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Future<Void> waitUpgrade;
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	ReadYourWritesTransaction versionCheckTr;
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Future<Void> versionWatch;
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Reference<ReadYourWritesTransaction> tr2;
															#line 494 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> restoreRanges;
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	UID restoreUid;
															#line 6055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, UID >, public ActorCallback< _startActor, 2, Optional<Key> >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Optional<Value> >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, Void >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public ActorCallback< _startActor, 12, Void >, public ActorCallback< _startActor, 13, Void >, public ActorCallback< _startActor, 14, Void >, public ActorCallback< _startActor, 15, Void >, public ActorCallback< _startActor, 16, Void >, public ActorCallback< _startActor, 17, Void >, public ActorCallback< _startActor, 18, Void >, public ActorCallback< _startActor, 19, UID >, public ActorCallback< _startActor, 20, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 6060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17095667650243950848UL, 12396770041742366208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, UID >;
friend struct ActorCallback< _startActor, 2, Optional<Key> >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Optional<Value> >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, Void >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
friend struct ActorCallback< _startActor, 12, Void >;
friend struct ActorCallback< _startActor, 13, Void >;
friend struct ActorCallback< _startActor, 14, Void >;
friend struct ActorCallback< _startActor, 15, Void >;
friend struct ActorCallback< _startActor, 16, Void >;
friend struct ActorCallback< _startActor, 17, Void >;
friend struct ActorCallback< _startActor, 18, Void >;
friend struct ActorCallback< _startActor, 19, UID >;
friend struct ActorCallback< _startActor, 20, Void >;
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	_startActor(Database const& cx,BackupToDBUpgradeWorkload* const& self) 
															#line 6097 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, UID >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Optional<Key> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Optional<Value> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< _startActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< _startActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< _startActor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< _startActor, 18, Void >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< _startActor, 19, UID >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< _startActor, 20, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, BackupToDBUpgradeWorkload* const& self ) {
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 6149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp.py_gen"
}

#line 531 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
};

WorkloadFactory<BackupToDBUpgradeWorkload> BackupToDBUpgradeWorkloadFactory;
