#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
/*
 * BackupToDBCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/ApiVersion.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// This workload tests backing up one cluster to another.

// A workload which test the correctness of backup and restore process. The
// database must be idle after the restore completes, and this workload checks
// that the restore range does not change post restore.
struct BackupToDBCorrectnessWorkload : TestWorkload {
	static constexpr auto NAME = "BackupToDBCorrectness";
	double backupAfter, abortAndRestartAfter, restoreAfter;
	double backupStartAt, restoreStartAfterBackupFinished, stopDifferentialAfter;
	Key backupTag, restoreTag;
	Key backupPrefix, extraPrefix;
	int backupRangesCount, backupRangeLengthMax;
	bool differentialBackup, performRestore, agentRequest;
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
	static int drAgentRequests;
	Database extraDB;
	LockDB locked{ false };
	bool shareLogRange;
	bool defaultBackup;
	UID destUid;

	// This workload is not compatible with RandomRangeLock workload because they will race in locked range
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomRangeLock" });
	}

	BackupToDBCorrectnessWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		locked.set(sharedRandomNumber % 2);
		backupAfter = getOption(options, "backupAfter"_sr, 10.0);
		double minBackupAfter = getOption(options, "minBackupAfter"_sr, backupAfter);
		if (backupAfter > minBackupAfter) {
			backupAfter = deterministicRandom()->random01() * (backupAfter - minBackupAfter) + minBackupAfter;
		}
		restoreAfter = getOption(options, "restoreAfter"_sr, 35.0);
		performRestore = getOption(options, "performRestore"_sr, true);
		backupTag = getOption(options, "backupTag"_sr, BackupAgentBase::getDefaultTag());
		restoreTag = getOption(options, "restoreTag"_sr, "restore"_sr);
		backupPrefix = getOption(options, "backupPrefix"_sr, StringRef());
		backupRangesCount = getOption(options,
		                              "backupRangesCount"_sr,
		                              5); // tests can hangs if set higher than 1 + BACKUP_MAP_KEY_LOWER_LIMIT
		backupRangeLengthMax = getOption(options, "backupRangeLengthMax"_sr, 1);
		abortAndRestartAfter =
		    getOption(options,
		              "abortAndRestartAfter"_sr,
		              (!locked && deterministicRandom()->random01() < 0.5)
		                  ? deterministicRandom()->random01() * (restoreAfter - backupAfter) + backupAfter
		                  : 0.0);
		differentialBackup =
		    getOption(options, "differentialBackup"_sr, deterministicRandom()->random01() < 0.5 ? true : false);
		stopDifferentialAfter =
		    getOption(options,
		              "stopDifferentialAfter"_sr,
		              differentialBackup ? deterministicRandom()->random01() *
		                                           (restoreAfter - std::max(abortAndRestartAfter, backupAfter)) +
		                                       std::max(abortAndRestartAfter, backupAfter)
		                                 : 0.0);
		agentRequest = getOption(options, "simDrAgents"_sr, true);
		shareLogRange = getOption(options, "shareLogRange"_sr, false);
		defaultBackup = getOption(options, "defaultBackup"_sr, false);

		// Use sharedRandomNumber if shareLogRange is true so that we can ensure backup and DR both backup the same
		// range
		bool beforePrefix = shareLogRange ? (sharedRandomNumber & 1) : (deterministicRandom()->random01() < 0.5);

		if (!defaultBackup) {
			if (beforePrefix) {
				extraPrefix = backupPrefix.withPrefix("\xfe\xff\xfe"_sr);
				backupPrefix = backupPrefix.withPrefix("\xfe\xff\xff"_sr);
			} else {
				extraPrefix = backupPrefix.withPrefix("\x00\x00\x01"_sr);
				backupPrefix = backupPrefix.withPrefix("\x00\x00\00"_sr);
			}

			ASSERT(backupPrefix != StringRef());
		}

		KeyRef beginRange;
		KeyRef endRange;
		UID randomID = nondeterministicRandom()->randomUniqueID();

		if (defaultBackup) {
			addDefaultBackupRanges(backupRanges);
		} else if (shareLogRange) {
			if (beforePrefix)
				backupRanges.push_back_deep(backupRanges.arena(), KeyRangeRef(normalKeys.begin, "\xfe\xff\xfe"_sr));
			else
				backupRanges.push_back_deep(backupRanges.arena(),
				                            KeyRangeRef(strinc("\x00\x00\x01"_sr), normalKeys.end));
		} else if (backupRangesCount <= 0) {
			if (beforePrefix)
				backupRanges.push_back_deep(backupRanges.arena(),
				                            KeyRangeRef(normalKeys.begin, std::min(backupPrefix, extraPrefix)));
			else
				backupRanges.push_back_deep(backupRanges.arena(),
				                            KeyRangeRef(strinc(std::max(backupPrefix, extraPrefix)), normalKeys.end));
		} else {
			// Add backup ranges
			for (int rangeLoop = 0; rangeLoop < backupRangesCount; rangeLoop++) {
				// Get a random range of a random sizes
				beginRange = KeyRef(backupRanges.arena(),
				                    deterministicRandom()->randomAlphaNumeric(
				                        deterministicRandom()->randomInt(1, backupRangeLengthMax + 1)));
				endRange = KeyRef(backupRanges.arena(),
				                  deterministicRandom()->randomAlphaNumeric(
				                      deterministicRandom()->randomInt(1, backupRangeLengthMax + 1)));

				// Add the range to the array
				backupRanges.push_back_deep(backupRanges.arena(),
				                            (beginRange < endRange) ? KeyRangeRef(beginRange, endRange)
				                                                    : KeyRangeRef(endRange, beginRange));

				// Track the added range
				TraceEvent("BackupCorrectness_Range", randomID)
				    .detail("RangeBegin", (beginRange < endRange) ? printable(beginRange) : printable(endRange))
				    .detail("RangeEnd", (beginRange < endRange) ? printable(endRange) : printable(beginRange));
			}
		}

		ASSERT(g_simulator->extraDatabases.size() == 1);
		extraDB = Database::createSimulatedExtraDatabase(g_simulator->extraDatabases[0]);

		TraceEvent("BARW_Start").detail("Locked", locked);
	}

	Future<Void> setup(Database const& cx) override {
		if (clientId != 0) {
			return Void();
		}
		return _setup(cx, this);
	}

																#line 166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via _setup()
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
template <class _setupActor>
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class _setupActorState {
															#line 172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
public:
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	_setupActorState(Database const& cx,BackupToDBCorrectnessWorkload* const& self) 
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		 : cx(cx),
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   self(self)
															#line 181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (BUGGIFY)
															#line 196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				for( auto r : getSystemBackupRanges() ) {
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					self->backupRanges.push_back_deep(self->backupRanges.arena(), r);
															#line 202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				}
			}
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_setupActorState();
			static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Database cx;
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	BackupToDBCorrectnessWorkload* self;
															#line 233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _setup()
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class _setupActor final : public Actor<Void>, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9324232886882278912UL, 7920817682091695872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	_setupActor(Database const& cx,BackupToDBCorrectnessWorkload* const& self) 
															#line 254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, BackupToDBCorrectnessWorkload* const& self ) {
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
}

#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	// Reads a series of key ranges and returns each range.
																#line 301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via readRanges()
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
template <class ReadRangesActor>
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class ReadRangesActorState {
															#line 307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
public:
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	ReadRangesActorState(Database const& cx,Standalone<VectorRef<KeyRangeRef>> const& ranges,StringRef const& removePrefix) 
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		 : cx(cx),
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   ranges(ranges),
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   removePrefix(removePrefix)
															#line 318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readRanges", reinterpret_cast<unsigned long>(this));

	}
	~ReadRangesActorState() 
	{
		fdb_probe_actor_destroy("readRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			;
															#line 333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadRangesActorState();
		static_cast<ReadRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		tr = Transaction(cx);
															#line 363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		try {
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			results = std::vector<Future<RangeResult>>();
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for( auto& range : ranges ) {
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				results.push_back(tr.getRange(range.removePrefix(removePrefix), 1000));
															#line 371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(results);
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<ReadRangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadRangesActor*>(this)->actor_wait_state = 1;
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadRangesActor, 0, Void >*>(static_cast<ReadRangesActor*>(this)));
															#line 382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<ReadRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadRangesActor*>(this)->actor_wait_state = 2;
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadRangesActor, 1, Void >*>(static_cast<ReadRangesActor*>(this)));
															#line 411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		std::vector<RangeResult> ret;
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for( auto result : results ) {
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			ret.push_back(result.get());
															#line 430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<ReadRangesActor*>(this)->SAV<std::vector<RangeResult>>::futures) { (void)(ret); this->~ReadRangesActorState(); static_cast<ReadRangesActor*>(this)->destroy(); return 0; }
															#line 434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<ReadRangesActor*>(this)->SAV< std::vector<RangeResult> >::value()) std::vector<RangeResult>(ret);
		this->~ReadRangesActorState();
		static_cast<ReadRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		std::vector<RangeResult> ret;
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for( auto result : results ) {
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			ret.push_back(result.get());
															#line 450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<ReadRangesActor*>(this)->SAV<std::vector<RangeResult>>::futures) { (void)(ret); this->~ReadRangesActorState(); static_cast<ReadRangesActor*>(this)->destroy(); return 0; }
															#line 454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<ReadRangesActor*>(this)->SAV< std::vector<RangeResult> >::value()) std::vector<RangeResult>(ret);
		this->~ReadRangesActorState();
		static_cast<ReadRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadRangesActor*>(this)->actor_wait_state > 0) static_cast<ReadRangesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRangesActor*>(this)->ActorCallback< ReadRangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadRangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadRangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadRangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadRangesActor*>(this)->actor_wait_state > 0) static_cast<ReadRangesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRangesActor*>(this)->ActorCallback< ReadRangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadRangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadRangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadRangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRanges", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Database cx;
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	StringRef removePrefix;
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Transaction tr;
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	std::vector<Future<RangeResult>> results;
															#line 634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readRanges()
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class ReadRangesActor final : public Actor<std::vector<RangeResult>>, public ActorCallback< ReadRangesActor, 0, Void >, public ActorCallback< ReadRangesActor, 1, Void >, public FastAllocated<ReadRangesActor>, public ReadRangesActorState<ReadRangesActor> {
															#line 639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadRangesActor>::operator new;
	using FastAllocated<ReadRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11644014769245421568UL, 13265183527371819776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<RangeResult>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadRangesActor, 0, Void >;
friend struct ActorCallback< ReadRangesActor, 1, Void >;
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	ReadRangesActor(Database const& cx,Standalone<VectorRef<KeyRangeRef>> const& ranges,StringRef const& removePrefix) 
															#line 657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		 : Actor<std::vector<RangeResult>>(),
		   ReadRangesActorState<ReadRangesActor>(cx, ranges, removePrefix),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3579129534909043968UL, 2722703771075061248UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadRangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadRangesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
[[nodiscard]] static Future<std::vector<RangeResult>> readRanges( Database const& cx, Standalone<VectorRef<KeyRangeRef>> const& ranges, StringRef const& removePrefix ) {
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	return Future<std::vector<RangeResult>>(new ReadRangesActor(cx, ranges, removePrefix));
															#line 690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
}

#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"

																#line 695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via diffRanges()
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
template <class DiffRangesActor>
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class DiffRangesActorState {
															#line 701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
public:
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DiffRangesActorState(Standalone<VectorRef<KeyRangeRef>> const& ranges,StringRef const& backupPrefix,Database const& src,Database const& dest) 
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		 : ranges(ranges),
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupPrefix(backupPrefix),
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   src(src),
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   dest(dest),
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   rangeIndex()
															#line 716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("diffRanges", reinterpret_cast<unsigned long>(this));

	}
	~DiffRangesActorState() 
	{
		fdb_probe_actor_destroy("diffRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			rangeIndex = 0;
															#line 731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DiffRangesActorState();
		static_cast<DiffRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<DiffRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DiffRangesActorState(); static_cast<DiffRangesActor*>(this)->destroy(); return 0; }
															#line 754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<DiffRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DiffRangesActorState();
		static_cast<DiffRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!(rangeIndex < ranges.size()))
															#line 773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		range = ranges[rangeIndex];
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		begin = range.begin;
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		;
															#line 783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		++rangeIndex;
															#line 805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		tr = Transaction(src);
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		tr2 = Transaction(dest);
															#line 823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		try {
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			;
															#line 827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<DiffRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DiffRangesActor*>(this)->actor_wait_state = 2;
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DiffRangesActor, 1, Void >*>(static_cast<DiffRangesActor*>(this)));
															#line 869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1(int loopDepth) 
	{
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		srcFuture = tr.getRange(KeyRangeRef(begin, range.end), 1000);
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		bkpFuture = tr2.getRange(KeyRangeRef(begin, range.end).withPrefix(backupPrefix), 1000);
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_0 = success(srcFuture) && success(bkpFuture);
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DiffRangesActor*>(this)->actor_wait_state = 1;
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DiffRangesActor, 0, Void >*>(static_cast<DiffRangesActor*>(this)));
															#line 908 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		auto src = srcFuture.get().begin();
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		auto bkp = bkpFuture.get().begin();
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for(;src != srcFuture.get().end() && bkp != bkpFuture.get().end();) {
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			KeyRef bkpKey = bkp->key.substr(backupPrefix.size());
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (src->key != bkpKey && src->value != bkp->value)
															#line 938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent(SevError, "MismatchKeyAndValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (src->key != bkpKey)
															#line 948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				{
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					TraceEvent(SevError, "MismatchKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				}
				else
				{
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (src->value != bkp->value)
															#line 958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					{
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
						TraceEvent(SevError, "MismatchValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					}
				}
			}
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			begin = std::min(src->key, bkpKey);
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (src->key == bkpKey)
															#line 970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				++src;
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				++bkp;
															#line 976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (src->key < bkpKey)
															#line 982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					++src;
															#line 986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				}
				else
				{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					++bkp;
															#line 992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				}
			}
		}
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for(;src != srcFuture.get().end() && !bkpFuture.get().more;) {
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "MissingBkpKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value));
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			begin = src->key;
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			++src;
															#line 1004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for(;bkp != bkpFuture.get().end() && !srcFuture.get().more;) {
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "MissingSrcKey") .detail("BkpKey", printable(bkp->key.substr(backupPrefix.size()))) .detail("BkpVal", printable(bkp->value));
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			begin = bkp->key;
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			++bkp;
															#line 1014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!srcFuture.get().more && !bkpFuture.get().more)
															#line 1018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		begin = keyAfter(begin);
															#line 1024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		auto src = srcFuture.get().begin();
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		auto bkp = bkpFuture.get().begin();
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for(;src != srcFuture.get().end() && bkp != bkpFuture.get().end();) {
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			KeyRef bkpKey = bkp->key.substr(backupPrefix.size());
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (src->key != bkpKey && src->value != bkp->value)
															#line 1041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent(SevError, "MismatchKeyAndValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 1045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (src->key != bkpKey)
															#line 1051 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				{
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					TraceEvent(SevError, "MismatchKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 1055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				}
				else
				{
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (src->value != bkp->value)
															#line 1061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					{
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
						TraceEvent(SevError, "MismatchValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 1065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					}
				}
			}
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			begin = std::min(src->key, bkpKey);
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (src->key == bkpKey)
															#line 1073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				++src;
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				++bkp;
															#line 1079 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (src->key < bkpKey)
															#line 1085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					++src;
															#line 1089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				}
				else
				{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					++bkp;
															#line 1095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				}
			}
		}
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for(;src != srcFuture.get().end() && !bkpFuture.get().more;) {
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "MissingBkpKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value));
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			begin = src->key;
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			++src;
															#line 1107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for(;bkp != bkpFuture.get().end() && !srcFuture.get().more;) {
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "MissingSrcKey") .detail("BkpKey", printable(bkp->key.substr(backupPrefix.size()))) .detail("BkpVal", printable(bkp->value));
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			begin = bkp->key;
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			++bkp;
															#line 1117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!srcFuture.get().more && !bkpFuture.get().more)
															#line 1121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		begin = keyAfter(begin);
															#line 1127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state > 0) static_cast<DiffRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DiffRangesActor*>(this)->ActorCallback< DiffRangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DiffRangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state > 0) static_cast<DiffRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DiffRangesActor*>(this)->ActorCallback< DiffRangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DiffRangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	StringRef backupPrefix;
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Database src;
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Database dest;
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	int rangeIndex;
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	KeyRangeRef range;
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key begin;
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Transaction tr;
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Transaction tr2;
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Future<RangeResult> srcFuture;
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Future<RangeResult> bkpFuture;
															#line 1316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via diffRanges()
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class DiffRangesActor final : public Actor<Void>, public ActorCallback< DiffRangesActor, 0, Void >, public ActorCallback< DiffRangesActor, 1, Void >, public FastAllocated<DiffRangesActor>, public DiffRangesActorState<DiffRangesActor> {
															#line 1321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<DiffRangesActor>::operator new;
	using FastAllocated<DiffRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3546061611458506496UL, 16353529908346543360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DiffRangesActor, 0, Void >;
friend struct ActorCallback< DiffRangesActor, 1, Void >;
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DiffRangesActor(Standalone<VectorRef<KeyRangeRef>> const& ranges,StringRef const& backupPrefix,Database const& src,Database const& dest) 
															#line 1339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DiffRangesActorState<DiffRangesActor>(ranges, backupPrefix, src, dest),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14464715535444249600UL, 3030925669057132800UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("diffRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DiffRangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DiffRangesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> diffRanges( Standalone<VectorRef<KeyRangeRef>> const& ranges, StringRef const& backupPrefix, Database const& src, Database const& dest ) {
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	return Future<Void>(new DiffRangesActor(ranges, backupPrefix, src, dest));
															#line 1372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
}

#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"

																#line 1377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via doBackup()
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
template <class DoBackupActor>
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class DoBackupActorState {
															#line 1383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
public:
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DoBackupActorState(BackupToDBCorrectnessWorkload* const& self,double const& startDelay,DatabaseBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,double const& stopDifferentialDelay,Promise<Void> const& submitted) 
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		 : self(self),
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   startDelay(startDelay),
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupAgent(backupAgent),
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   cx(cx),
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   tag(tag),
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupRanges(backupRanges),
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   stopDifferentialDelay(stopDifferentialDelay),
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   submitted(submitted),
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID()),
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   stopDifferentialFuture(delay(stopDifferentialDelay))
															#line 1408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doBackup", reinterpret_cast<unsigned long>(this));

	}
	~DoBackupActorState() 
	{
		fdb_probe_actor_destroy("doBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(startDelay);
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 1;
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 0, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (startDelay || BUGGIFY)
															#line 1453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup1", randomID) .detail("Tag", printable(tag)) .detail("StartDelay", startDelay);
															#line 1457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			try {
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_1 = backupAgent->abortBackup(cx, tag);
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (startDelay || BUGGIFY)
															#line 1488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup1", randomID) .detail("Tag", printable(tag)) .detail("StartDelay", startDelay);
															#line 1492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			try {
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_1 = backupAgent->abortBackup(cx, tag);
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupClearAndSubmitBackup", randomID) .detail("Tag", printable(tag)) .detail("StopWhenDone", stopDifferentialDelay ? "False" : "True");
															#line 1598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		try {
			try {
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_3 = backupAgent->submitBackup(cx, tag, backupRanges, StopWhenDone{ !stopDifferentialDelay }, self->backupPrefix, StringRef(), LockDB{ self->locked }, DatabaseBackupAgent::PreBackupAction::CLEAR);
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch2(actor_cancelled(), loopDepth);
															#line 1605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 4;
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 3, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont2Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont2Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = backupAgent->unlockBackup(cx, tag);
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 3;
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 2, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded)
															#line 1650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		submitted.send(Void());
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<UID> __when_expr_4 = backupAgent->getLogUid(cx, tag);
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 5;
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 4, UID >*>(static_cast<DoBackupActor*>(this)));
															#line 1866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupSubmitBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 1878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_SubmitBackup1Exception", randomID).error(e);
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 1907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1cont2Catch1(e, loopDepth);
															#line 1911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch2(error, 0);
		} catch (...) {
			a_body1cont2Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch2(error, 0);
		} catch (...) {
			a_body1cont2Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch2(error, 0);
		} catch (...) {
			a_body1cont2Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (stopDifferentialDelay)
															#line 2040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			CODE_PROBE(!stopDifferentialFuture.isReady(), "Restore starts at specified time - stopDifferential not ready");
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_5 = stopDifferentialFuture;
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 6;
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 5, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7when1(UID const& __logUid,int loopDepth) 
	{
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		logUid = __logUid;
															#line 2067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(UID && __logUid,int loopDepth) 
	{
		logUid = std::move(__logUid);
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 4, UID >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 4, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 4, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 4, UID >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWaitBackup", randomID).detail("Tag", printable(tag));
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<UID> __when_expr_11 = backupAgent->getDestUid(cx, logUid);
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 12;
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 11, UID >*>(static_cast<DoBackupActor*>(this)));
															#line 2155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2(Void const& _,int loopDepth) 
	{
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWaitToDiscontinue", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		aborted = false;
															#line 2166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		try {
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (BUGGIFY)
															#line 2170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupWaitForRestorable", randomID).detail("Tag", printable(tag));
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<EBackupState> __when_expr_6 = backupAgent->waitBackup(cx, tag, StopWhenDone::False);
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 2178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont12cont2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_6.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 7;
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 6, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 2183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_9 = backupAgent->discontinueBackup(cx, tag);
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 2194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont12cont2Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont12cont2when2(__when_expr_9.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 10;
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 9, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2(Void && _,int loopDepth) 
	{
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWaitToDiscontinue", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		aborted = false;
															#line 2217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		try {
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (BUGGIFY)
															#line 2221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupWaitForRestorable", randomID).detail("Tag", printable(tag));
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<EBackupState> __when_expr_6 = backupAgent->waitBackup(cx, tag, StopWhenDone::False);
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 2229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont12cont2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_6.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 7;
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 6, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 2234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_9 = backupAgent->discontinueBackup(cx, tag);
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 2245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont12cont2Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont12cont2when2(__when_expr_9.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 10;
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 9, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont3(int loopDepth) 
	{
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (aborted)
															#line 2341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_10 = backupAgent->unlockBackup(cx, tag);
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont12cont3when1(__when_expr_10.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 11;
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 10, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupDiscontinueBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 2369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont12cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont4(int loopDepth) 
	{
		loopDepth = a_body1cont12cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont5(int loopDepth) 
	{
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_LastBackupFolder", randomID) .detail("BackupTag", printable(tag)) .detail("LogUid", logUid) .detail("WaitStatus", resultWait);
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (startDelay)
															#line 2397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup2", randomID) .detail("Tag", printable(tag)) .detail("WaitStatus", resultWait);
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			aborted = true;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_7 = backupAgent->abortBackup(cx, tag);
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 2407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont12cont2Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont12cont5when1(__when_expr_7.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 8;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 7, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_8 = backupAgent->discontinueBackup(cx, tag);
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 2423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont12cont2Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont12cont5when2(__when_expr_8.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 9;
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 8, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont12cont2when1(EBackupState const& __resultWait,int loopDepth) 
	{
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		resultWait = __resultWait;
															#line 2438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2when1(EBackupState && __resultWait,int loopDepth) 
	{
		resultWait = std::move(__resultWait);
		loopDepth = a_body1cont12cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 6, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 6, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 6, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 6, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont12cont6(int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont12cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont5when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont5when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont5when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont5when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont12cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont12cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont11(int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont12cont13(UID const& _destUid,int loopDepth) 
	{
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		self->destUid = _destUid;
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<EBackupState> __when_expr_12 = backupAgent->waitBackup(cx, tag, StopWhenDone::True);
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont12cont13when1(__when_expr_12.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 13;
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 12, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 2899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont13(UID && _destUid,int loopDepth) 
	{
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		self->destUid = _destUid;
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<EBackupState> __when_expr_12 = backupAgent->waitBackup(cx, tag, StopWhenDone::True);
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont12cont13when1(__when_expr_12.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 13;
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 12, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 2917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1when1(UID const& _destUid,int loopDepth) 
	{
		loopDepth = a_body1cont12cont13(_destUid, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1when1(UID && _destUid,int loopDepth) 
	{
		loopDepth = a_body1cont12cont13(std::move(_destUid), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 11, UID >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 11, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 11, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 11, UID >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont12cont13cont1(int loopDepth) 
	{
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_13 = backupAgent->unlockBackup(cx, tag);
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont12cont13cont1when1(__when_expr_13.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 14;
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 13, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 3008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont13when1(EBackupState const& __statusValue,int loopDepth) 
	{
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		statusValue = __statusValue;
															#line 3017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont13when1(EBackupState && __statusValue,int loopDepth) 
	{
		statusValue = std::move(__statusValue);
		loopDepth = a_body1cont12cont13cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 12, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 12, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont12cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 12, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont12cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 12, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont12cont13cont2(Void const& _,int loopDepth) 
	{
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		statusText = std::string();
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<std::string> __when_expr_14 = backupAgent->getStatus(cx, 5, tag);
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont12cont13cont2when1(__when_expr_14.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 15;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 14, std::string >*>(static_cast<DoBackupActor*>(this)));
															#line 3105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont13cont2(Void && _,int loopDepth) 
	{
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		statusText = std::string();
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<std::string> __when_expr_14 = backupAgent->getStatus(cx, 5, tag);
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont12cont13cont2when1(__when_expr_14.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 15;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 14, std::string >*>(static_cast<DoBackupActor*>(this)));
															#line 3123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont13cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont13cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont13cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont13cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont12cont13cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont12cont13cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont12cont13cont3(std::string const& _statusText,int loopDepth) 
	{
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		statusText = _statusText;
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupComplete", randomID) .detail("Tag", printable(tag)) .detail("Status", statusText) .detail("StatusValue", statusValue);
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 3211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont13cont3(std::string && _statusText,int loopDepth) 
	{
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		statusText = _statusText;
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupComplete", randomID) .detail("Tag", printable(tag)) .detail("Status", statusText) .detail("StatusValue", statusValue);
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 3227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont13cont2when1(std::string const& _statusText,int loopDepth) 
	{
		loopDepth = a_body1cont12cont13cont3(_statusText, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont13cont2when1(std::string && _statusText,int loopDepth) 
	{
		loopDepth = a_body1cont12cont13cont3(std::move(_statusText), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 14, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 14, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont12cont13cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 14, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont12cont13cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 14, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 14);

	}
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	BackupToDBCorrectnessWorkload* self;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	double startDelay;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DatabaseBackupAgent* backupAgent;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Database cx;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key tag;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	double stopDifferentialDelay;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Promise<Void> submitted;
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID randomID;
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Future<Void> stopDifferentialFuture;
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID logUid;
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	bool aborted;
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	EBackupState resultWait;
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	EBackupState statusValue;
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	std::string statusText;
															#line 3340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doBackup()
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class DoBackupActor final : public Actor<Void>, public ActorCallback< DoBackupActor, 0, Void >, public ActorCallback< DoBackupActor, 1, Void >, public ActorCallback< DoBackupActor, 2, Void >, public ActorCallback< DoBackupActor, 3, Void >, public ActorCallback< DoBackupActor, 4, UID >, public ActorCallback< DoBackupActor, 5, Void >, public ActorCallback< DoBackupActor, 6, EBackupState >, public ActorCallback< DoBackupActor, 7, Void >, public ActorCallback< DoBackupActor, 8, Void >, public ActorCallback< DoBackupActor, 9, Void >, public ActorCallback< DoBackupActor, 10, Void >, public ActorCallback< DoBackupActor, 11, UID >, public ActorCallback< DoBackupActor, 12, EBackupState >, public ActorCallback< DoBackupActor, 13, Void >, public ActorCallback< DoBackupActor, 14, std::string >, public FastAllocated<DoBackupActor>, public DoBackupActorState<DoBackupActor> {
															#line 3345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoBackupActor>::operator new;
	using FastAllocated<DoBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7485573248992642048UL, 1056598926218212096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBackupActor, 0, Void >;
friend struct ActorCallback< DoBackupActor, 1, Void >;
friend struct ActorCallback< DoBackupActor, 2, Void >;
friend struct ActorCallback< DoBackupActor, 3, Void >;
friend struct ActorCallback< DoBackupActor, 4, UID >;
friend struct ActorCallback< DoBackupActor, 5, Void >;
friend struct ActorCallback< DoBackupActor, 6, EBackupState >;
friend struct ActorCallback< DoBackupActor, 7, Void >;
friend struct ActorCallback< DoBackupActor, 8, Void >;
friend struct ActorCallback< DoBackupActor, 9, Void >;
friend struct ActorCallback< DoBackupActor, 10, Void >;
friend struct ActorCallback< DoBackupActor, 11, UID >;
friend struct ActorCallback< DoBackupActor, 12, EBackupState >;
friend struct ActorCallback< DoBackupActor, 13, Void >;
friend struct ActorCallback< DoBackupActor, 14, std::string >;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DoBackupActor(BackupToDBCorrectnessWorkload* const& self,double const& startDelay,DatabaseBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,double const& stopDifferentialDelay,Promise<Void> const& submitted) 
															#line 3376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoBackupActorState<DoBackupActor>(self, startDelay, backupAgent, cx, tag, backupRanges, stopDifferentialDelay, submitted),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15925328432552866816UL, 11115638302355080704UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBackupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoBackupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoBackupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoBackupActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DoBackupActor, 4, UID >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DoBackupActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DoBackupActor, 6, EBackupState >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< DoBackupActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< DoBackupActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< DoBackupActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< DoBackupActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< DoBackupActor, 11, UID >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< DoBackupActor, 12, EBackupState >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< DoBackupActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< DoBackupActor, 14, std::string >*)0, actor_cancelled()); break;
		}

	}
};
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> doBackup( BackupToDBCorrectnessWorkload* const& self, double const& startDelay, DatabaseBackupAgent* const& backupAgent, Database const& cx, Key const& tag, Standalone<VectorRef<KeyRangeRef>> const& backupRanges, double const& stopDifferentialDelay, Promise<Void> const& submitted ) {
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	return Future<Void>(new DoBackupActor(self, startDelay, backupAgent, cx, tag, backupRanges, stopDifferentialDelay, submitted));
															#line 3422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
}

#line 437 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"

																#line 3427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via checkData()
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
template <class CheckDataActor>
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class CheckDataActorState {
															#line 3433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
public:
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	CheckDataActorState(Database const& cx,UID const& logUid,UID const& destUid,UID const& randomID,Key const& tag,DatabaseBackupAgent* const& backupAgent,bool const& shareLogRange) 
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		 : cx(cx),
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   logUid(logUid),
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   destUid(destUid),
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   randomID(randomID),
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   tag(tag),
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupAgent(backupAgent),
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   shareLogRange(shareLogRange),
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupAgentKey(uidPrefixKey(logRangesRange.begin, logUid)),
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupLogValuesKey(uidPrefixKey(backupLogKeys.begin, destUid)),
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupLatestVersionsPath(uidPrefixKey(backupLatestVersionsPrefix, destUid)),
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupLatestVersionsKey(uidPrefixKey(backupLatestVersionsPath, logUid)),
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   displaySystemKeys(0)
															#line 3462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkData", reinterpret_cast<unsigned long>(this));

	}
	~CheckDataActorState() 
	{
		fdb_probe_actor_destroy("checkData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			;
															#line 3477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckDataActorState();
		static_cast<CheckDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (displaySystemKeys)
															#line 3500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_9 = TaskBucket::debugPrintRange(cx, "\xff"_sr, StringRef());
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1when1(__when_expr_9.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 10;
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 9, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 3511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_CheckLeftoverKeys", randomID).detail("BackupTag", printable(tag));
															#line 3534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		try {
															#line 461 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_CheckLeftoverTasks", randomID).detail("BackupTag", printable(tag));
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = backupAgent->getTaskCount(tr);
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 1;
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 0, int64_t >*>(static_cast<CheckDataActor*>(this)));
															#line 3547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_CheckException", randomID).error(e);
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_8 = tr->onError(e);
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 9;
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 8, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 3591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		waitCycles = 0;
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if ((taskCount) && false)
															#line 3608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_EndingNonzeroTaskCount", randomID) .detail("BackupTag", printable(tag)) .detail("TaskCount", taskCount) .detail("WaitCycles", waitCycles);
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("EndingNonZeroTasks: %ld\n", (long)taskCount);
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = TaskBucket::debugPrintRange(cx, "\xff"_sr, StringRef());
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 2;
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 1, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 3623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t const& __taskCount,int loopDepth) 
	{
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		taskCount = __taskCount;
															#line 3637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t && __taskCount,int loopDepth) 
	{
		taskCount = std::move(__taskCount);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		;
															#line 3716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = tr->getRange(KeyRange(KeyRangeRef(backupAgentKey, strinc(backupAgentKey))), 100);
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 5;
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 4, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 3819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!(taskCount > 0))
															#line 3835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		waitCycles++;
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_NonzeroTaskWait", randomID) .detail("BackupTag", printable(tag)) .detail("TaskCount", taskCount) .detail("WaitCycles", waitCycles);
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		printf("%.6f %-10s Wait #%4d for %lld tasks to end\n", now(), randomID.toString().c_str(), waitCycles, (long long)taskCount);
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(5.0);
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 3;
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 2, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 3854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 488 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(taskCount, backupAgent->getTaskCount(tr));
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 4;
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 3, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 3885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 488 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(taskCount, backupAgent->getTaskCount(tr));
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 4;
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 3, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 3903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont6(RangeResult const& agentValues,int loopDepth) 
	{
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (agentValues.size() > 0)
															#line 4074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftoverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverMutationKeys", randomID) .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 505 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for( auto& s : agentValues ) {
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_LeftoverKey", randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 4088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 4095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr->get(backupLatestVersionsKey);
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 6;
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 5, Optional<Value> >*>(static_cast<CheckDataActor*>(this)));
															#line 4106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(RangeResult && agentValues,int loopDepth) 
	{
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (agentValues.size() > 0)
															#line 4115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftoverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverMutationKeys", randomID) .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 505 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for( auto& s : agentValues ) {
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_LeftoverKey", randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 4129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 4136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr->get(backupLatestVersionsKey);
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 6;
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 5, Optional<Value> >*>(static_cast<CheckDataActor*>(this)));
															#line 4147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(RangeResult const& agentValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(agentValues, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(RangeResult && agentValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(agentValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont7(Optional<Value> const& latestVersion,int loopDepth) 
	{
															#line 518 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (latestVersion.present())
															#line 4231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverVersionKey", randomID) .detail("BackupTag", printable(tag)) .detail("Key", backupLatestVersionsKey.printable()) .detail("Value", BinaryReader::fromStringRef<Version>(latestVersion.get(), Unversioned()));
															#line 4235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 524 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("No left over backup version key\n");
															#line 4241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = tr->getRange(KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 7;
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 6, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 4252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Optional<Value> && latestVersion,int loopDepth) 
	{
															#line 518 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (latestVersion.present())
															#line 4261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverVersionKey", randomID) .detail("BackupTag", printable(tag)) .detail("Key", backupLatestVersionsKey.printable()) .detail("Value", BinaryReader::fromStringRef<Version>(latestVersion.get(), Unversioned()));
															#line 4265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 524 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("No left over backup version key\n");
															#line 4271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = tr->getRange(KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 7;
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 6, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 4282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<Value> const& latestVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(latestVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<Value> && latestVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(latestVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont11(RangeResult const& versions,int loopDepth) 
	{
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!shareLogRange || !versions.size())
															#line 4366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_7 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont11when1(__when_expr_7.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 8;
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 7, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 4377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont11(RangeResult && versions,int loopDepth) 
	{
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!shareLogRange || !versions.size())
															#line 4391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_7 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont11when1(__when_expr_7.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 8;
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 7, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 4402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(RangeResult const& versions,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(versions, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(RangeResult && versions,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(versions), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont11cont1(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont11cont2(RangeResult const& logValues,int loopDepth) 
	{
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (logValues.size() > 0)
															#line 4497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 535 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftoverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverLogKeys", randomID) .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey)) .detail("Version", decodeBKMutationLogKey(logValues[0].key).first);
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for( auto& s : logValues ) {
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_LeftoverKey", randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 4511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("No left over backup log keys\n");
															#line 4518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11cont2(RangeResult && logValues,int loopDepth) 
	{
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (logValues.size() > 0)
															#line 4528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 535 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftoverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverLogKeys", randomID) .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey)) .detail("Version", decodeBKMutationLogKey(logValues[0].key).first);
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for( auto& s : logValues ) {
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_LeftoverKey", randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 4542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("No left over backup log keys\n");
															#line 4549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(RangeResult const& logValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont2(logValues, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(RangeResult && logValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont2(std::move(logValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 7, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 7, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 7, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 7, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<CheckDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataActorState(); static_cast<CheckDataActor*>(this)->destroy(); return 0; }
															#line 4721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<CheckDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckDataActorState();
		static_cast<CheckDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Database cx;
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID logUid;
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID destUid;
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID randomID;
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key tag;
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DatabaseBackupAgent* backupAgent;
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	bool shareLogRange;
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key backupAgentKey;
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key backupLogValuesKey;
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key backupLatestVersionsPath;
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key backupLatestVersionsKey;
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	int displaySystemKeys;
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	int64_t taskCount;
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	int waitCycles;
															#line 4846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkData()
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class CheckDataActor final : public Actor<Void>, public ActorCallback< CheckDataActor, 0, int64_t >, public ActorCallback< CheckDataActor, 1, Void >, public ActorCallback< CheckDataActor, 2, Void >, public ActorCallback< CheckDataActor, 3, Void >, public ActorCallback< CheckDataActor, 4, RangeResult >, public ActorCallback< CheckDataActor, 5, Optional<Value> >, public ActorCallback< CheckDataActor, 6, RangeResult >, public ActorCallback< CheckDataActor, 7, RangeResult >, public ActorCallback< CheckDataActor, 8, Void >, public ActorCallback< CheckDataActor, 9, Void >, public FastAllocated<CheckDataActor>, public CheckDataActorState<CheckDataActor> {
															#line 4851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckDataActor>::operator new;
	using FastAllocated<CheckDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(419208712209312768UL, 11935000791192909056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckDataActor, 0, int64_t >;
friend struct ActorCallback< CheckDataActor, 1, Void >;
friend struct ActorCallback< CheckDataActor, 2, Void >;
friend struct ActorCallback< CheckDataActor, 3, Void >;
friend struct ActorCallback< CheckDataActor, 4, RangeResult >;
friend struct ActorCallback< CheckDataActor, 5, Optional<Value> >;
friend struct ActorCallback< CheckDataActor, 6, RangeResult >;
friend struct ActorCallback< CheckDataActor, 7, RangeResult >;
friend struct ActorCallback< CheckDataActor, 8, Void >;
friend struct ActorCallback< CheckDataActor, 9, Void >;
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	CheckDataActor(Database const& cx,UID const& logUid,UID const& destUid,UID const& randomID,Key const& tag,DatabaseBackupAgent* const& backupAgent,bool const& shareLogRange) 
															#line 4877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckDataActorState<CheckDataActor>(cx, logUid, destUid, randomID, tag, backupAgent, shareLogRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12159733170968748032UL, 9261654583238461696UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckDataActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckDataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckDataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckDataActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckDataActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CheckDataActor, 5, Optional<Value> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CheckDataActor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CheckDataActor, 7, RangeResult >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CheckDataActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CheckDataActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> checkData( Database const& cx, UID const& logUid, UID const& destUid, UID const& randomID, Key const& tag, DatabaseBackupAgent* const& backupAgent, bool const& shareLogRange ) {
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	return Future<Void>(new CheckDataActor(cx, logUid, destUid, randomID, tag, backupAgent, shareLogRange));
															#line 4918 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
}

#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"

																#line 4923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
template <class _startActor>
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class _startActorState {
															#line 4929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
public:
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	_startActorState(Database const& cx,BackupToDBCorrectnessWorkload* const& self) 
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		 : cx(cx),
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   self(self),
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupAgent(cx),
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   restoreTool(self->extraDB),
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   extraBackup()
															#line 4944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, DatabaseConfiguration >*>(static_cast<_startActor*>(this)));
															#line 4966 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_Arguments") .detail("BackupTag", printable(self->backupTag)) .detail("BackupAfter", self->backupAfter) .detail("AbortAndRestartAfter", self->abortAndRestartAfter) .detail("DifferentialAfter", self->stopDifferentialAfter);
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		randomID = nondeterministicRandom()->randomUniqueID();
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->agentRequest)
															#line 4993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			BackupToDBCorrectnessWorkload::drAgentRequests++;
															#line 4997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
		try {
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			startRestore = delay(self->restoreAfter);
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(self->backupAfter);
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 5011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		config = __config;
															#line 5026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupAndRestoreCorrectness").error(e);
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 5120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackup1", randomID).detail("Tag", printable(self->backupTag));
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		submitted = Promise<Void>();
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		b = doBackup(self, 0, &backupAgent, self->extraDB, self->backupTag, self->backupRanges, self->stopDifferentialAfter, submitted);
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->abortAndRestartAfter)
															#line 5140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 606 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackup2", randomID) .detail("Tag", printable(self->backupTag)) .detail("AbortWait", self->abortAndRestartAfter);
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = submitted.getFuture();
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 5153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackup1", randomID).detail("Tag", printable(self->backupTag));
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		submitted = Promise<Void>();
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		b = doBackup(self, 0, &backupAgent, self->extraDB, self->backupTag, self->backupRanges, self->stopDifferentialAfter, submitted);
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->abortAndRestartAfter)
															#line 5173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 606 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackup2", randomID) .detail("Tag", printable(self->backupTag)) .detail("AbortWait", self->abortAndRestartAfter);
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = submitted.getFuture();
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 5186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 621 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWait", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = b;
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 5284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		b = b && doBackup(self, self->abortAndRestartAfter, &backupAgent, self->extraDB, self->backupTag, self->backupRanges, self->stopDifferentialAfter, Promise<Void>());
															#line 5293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		b = b && doBackup(self, self->abortAndRestartAfter, &backupAgent, self->extraDB, self->backupTag, self->backupRanges, self->stopDifferentialAfter, Promise<Void>());
															#line 5302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupDone", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<UID> __when_expr_4 = backupAgent.getLogUid(self->extraDB, self->backupTag);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, UID >*>(static_cast<_startActor*>(this)));
															#line 5395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupDone", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<UID> __when_expr_4 = backupAgent.getLogUid(self->extraDB, self->backupTag);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, UID >*>(static_cast<_startActor*>(this)));
															#line 5413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!self->locked && self->extraPrefix != self->backupPrefix && BUGGIFY)
															#line 5497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_SubmitBackup2", randomID).detail("Tag", printable(self->backupTag));
															#line 5501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			try {
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				extraBackup = backupAgent.submitBackup(self->extraDB, self->backupTag, self->backupRanges, StopWhenDone::True, self->extraPrefix, StringRef(), self->locked, DatabaseBackupAgent::PreBackupAction::CLEAR);
															#line 5505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				loopDepth = a_body1cont13(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont9Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont9Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8when1(UID const& __logUid,int loopDepth) 
	{
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		logUid = __logUid;
															#line 5525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(UID && __logUid,int loopDepth) 
	{
		logUid = std::move(__logUid);
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, UID >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, UID >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 652 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		CODE_PROBE(!startRestore.isReady(), "Restore starts at specified time");
															#line 653 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_5 = startRestore;
															#line 653 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont10when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 653 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 5613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 644 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_SubmitBackup2Exception", randomID) .error(e) .detail("BackupTag", printable(self->backupTag));
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 5631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1cont1Catch1(e, loopDepth);
															#line 5635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->performRestore)
															#line 5664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_Restore", randomID) .detail("RestoreAfter", self->restoreAfter) .detail("BackupTag", printable(self->restoreTag));
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			restoreRange = Standalone<VectorRef<KeyRangeRef>>();
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			systemRestoreRange = Standalone<VectorRef<KeyRangeRef>>();
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for( auto r : self->backupRanges ) {
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (!r.intersects(getSystemBackupRanges()))
															#line 5676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				{
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					restoreRange.push_back_deep( restoreRange.arena(), KeyRangeRef(r.begin.withPrefix(self->backupPrefix), r.end.withPrefix(self->backupPrefix)));
															#line 5680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				}
				else
				{
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					KeyRangeRef normalKeyRange = r & normalKeys;
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					KeyRangeRef systemKeyRange = r & systemKeys;
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (!normalKeyRange.empty())
															#line 5690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					{
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
						restoreRange.push_back_deep(restoreRange.arena(), KeyRangeRef(normalKeyRange.begin.withPrefix(self->backupPrefix), normalKeyRange.end.withPrefix(self->backupPrefix)));
															#line 5694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					}
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (!systemKeyRange.empty())
															#line 5698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					{
															#line 678 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
						systemRestoreRange.push_back_deep(systemRestoreRange.arena(), systemKeyRange);
															#line 5702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					}
				}
			}
															#line 684 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (!systemRestoreRange.empty())
															#line 5708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				systemRestoreTag = "restore_system"_sr;
															#line 5712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				try {
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					StrictFuture<Void> __when_expr_6 = restoreTool.submitBackup(cx, systemRestoreTag, systemRestoreRange, StopWhenDone::True, StringRef(), self->backupPrefix, self->locked, DatabaseBackupAgent::PreBackupAction::CLEAR);
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont10cont1Catch1(actor_cancelled(), loopDepth);
															#line 5718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont10cont1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_6.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 5723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1cont10cont1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont10cont1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont10cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont10cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->performRestore)
															#line 5748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_Restore", randomID) .detail("RestoreAfter", self->restoreAfter) .detail("BackupTag", printable(self->restoreTag));
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			restoreRange = Standalone<VectorRef<KeyRangeRef>>();
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			systemRestoreRange = Standalone<VectorRef<KeyRangeRef>>();
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for( auto r : self->backupRanges ) {
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (!r.intersects(getSystemBackupRanges()))
															#line 5760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				{
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					restoreRange.push_back_deep( restoreRange.arena(), KeyRangeRef(r.begin.withPrefix(self->backupPrefix), r.end.withPrefix(self->backupPrefix)));
															#line 5764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				}
				else
				{
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					KeyRangeRef normalKeyRange = r & normalKeys;
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					KeyRangeRef systemKeyRange = r & systemKeys;
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (!normalKeyRange.empty())
															#line 5774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					{
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
						restoreRange.push_back_deep(restoreRange.arena(), KeyRangeRef(normalKeyRange.begin.withPrefix(self->backupPrefix), normalKeyRange.end.withPrefix(self->backupPrefix)));
															#line 5778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					}
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (!systemKeyRange.empty())
															#line 5782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					{
															#line 678 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
						systemRestoreRange.push_back_deep(systemRestoreRange.arena(), systemKeyRange);
															#line 5786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					}
				}
			}
															#line 684 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (!systemRestoreRange.empty())
															#line 5792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				systemRestoreTag = "restore_system"_sr;
															#line 5796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				try {
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					StrictFuture<Void> __when_expr_6 = restoreTool.submitBackup(cx, systemRestoreTag, systemRestoreRange, StopWhenDone::True, StringRef(), self->backupPrefix, self->locked, DatabaseBackupAgent::PreBackupAction::CLEAR);
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont10cont1Catch1(actor_cancelled(), loopDepth);
															#line 5802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont10cont1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_6.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 5807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1cont10cont1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont10cont1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont10cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont10cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont2(int loopDepth) 
	{
															#line 743 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (extraBackup.isValid())
															#line 5907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 744 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_WaitExtraBackup", randomID).detail("BackupTag", printable(self->backupTag));
															#line 5911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			try {
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_15 = extraBackup;
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont10cont2Catch1(actor_cancelled(), loopDepth);
															#line 5917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont10cont2Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_15.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 5922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont10cont2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont10cont2Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont10cont14(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont3(int loopDepth) 
	{
		try {
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_9 = restoreTool.submitBackup(cx, self->restoreTag, restoreRange, StopWhenDone::True, StringRef(), self->backupPrefix, self->locked, DatabaseBackupAgent::PreBackupAction::CLEAR);
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont10cont3Catch1(actor_cancelled(), loopDepth);
															#line 5945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont10cont3Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_9.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 5950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont10cont3Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10cont3Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont9(int loopDepth) 
	{
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_7 = success(restoreTool.waitBackup(cx, systemRestoreTag));
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont10cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 5972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupSubmitBackupException", randomID) .error(e) .detail("Tag", printable(systemRestoreTag));
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 5984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1cont1Catch1(e, loopDepth);
															#line 5988 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont10cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10cont10cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont11(Void const& _,int loopDepth) 
	{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_8 = restoreTool.unlockBackup(cx, systemRestoreTag);
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10cont11when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 6111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont11(Void && _,int loopDepth) 
	{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_8 = restoreTool.unlockBackup(cx, systemRestoreTag);
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10cont11when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 6127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont11cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont11cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont12(int loopDepth) 
	{
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_10 = success(restoreTool.waitBackup(cx, self->restoreTag));
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont12when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 6305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupSubmitBackupException", randomID) .error(e) .detail("Tag", printable(self->restoreTag));
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 6317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1cont1Catch1(e, loopDepth);
															#line 6321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont10cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont13cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont12cont1(Void const& _,int loopDepth) 
	{
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_11 = restoreTool.unlockBackup(cx, self->restoreTag);
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont12cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 6444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont1(Void && _,int loopDepth) 
	{
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_11 = restoreTool.unlockBackup(cx, self->restoreTag);
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont12cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 6460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10cont12cont2(Void const& _,int loopDepth) 
	{
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<std::vector<RangeResult>> __when_expr_12 = readRanges(cx, restoreRange, self->backupPrefix);
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont10cont12cont2when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, std::vector<RangeResult> >*>(static_cast<_startActor*>(this)));
															#line 6551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont2(Void && _,int loopDepth) 
	{
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<std::vector<RangeResult>> __when_expr_12 = readRanges(cx, restoreRange, self->backupPrefix);
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont10cont12cont2when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, std::vector<RangeResult> >*>(static_cast<_startActor*>(this)));
															#line 6567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10cont12cont3(int loopDepth) 
	{
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_13 = delay(5);
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont10cont12cont3when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 6658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont2when1(std::vector<RangeResult> const& __res1,int loopDepth) 
	{
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		res1 = __res1;
															#line 6667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont2when1(std::vector<RangeResult> && __res1,int loopDepth) 
	{
		res1 = std::move(__res1);
		loopDepth = a_body1cont10cont12cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, std::vector<RangeResult> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, std::vector<RangeResult> >*,std::vector<RangeResult> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont12cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, std::vector<RangeResult> >*,std::vector<RangeResult> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont12cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, std::vector<RangeResult> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10cont12cont4(Void const& _,int loopDepth) 
	{
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<std::vector<RangeResult>> __when_expr_14 = readRanges(cx, restoreRange, self->backupPrefix);
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont12cont4when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, std::vector<RangeResult> >*>(static_cast<_startActor*>(this)));
															#line 6753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont4(Void && _,int loopDepth) 
	{
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<std::vector<RangeResult>> __when_expr_14 = readRanges(cx, restoreRange, self->backupPrefix);
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont12cont4when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, std::vector<RangeResult> >*>(static_cast<_startActor*>(this)));
															#line 6769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont12cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont12cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont10cont12cont5(int loopDepth) 
	{
															#line 731 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		ASSERT(res1.size() == res2.size());
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for(int i = 0;i < res1.size();++i) {
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			auto range1 = res1.at(i);
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			auto range2 = res2.at(i);
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			ASSERT(range1.size() == range2.size());
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for(int j = 0;j < range1.size();++j) {
															#line 738 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				ASSERT(range1[j].key == range2[j].key && range1[j].value == range2[j].value);
															#line 6865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont4when1(std::vector<RangeResult> const& __res2,int loopDepth) 
	{
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		res2 = __res2;
															#line 6876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont12cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont4when1(std::vector<RangeResult> && __res2,int loopDepth) 
	{
		res2 = std::move(__res2);
		loopDepth = a_body1cont10cont12cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, std::vector<RangeResult> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, std::vector<RangeResult> >*,std::vector<RangeResult> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont12cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, std::vector<RangeResult> >*,std::vector<RangeResult> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont12cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, std::vector<RangeResult> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont10cont14(int loopDepth) 
	{
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_17 = checkData( self->extraDB, logUid, self->destUid, randomID, self->backupTag, &backupAgent, self->shareLogRange);
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont10cont14when1(__when_expr_17.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 18;
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _startActor, 17, Void >*>(static_cast<_startActor*>(this)));
															#line 6962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont15(int loopDepth) 
	{
															#line 755 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_AbortBackupExtra", randomID).detail("BackupTag", printable(self->backupTag));
															#line 6971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		try {
															#line 759 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_16 = backupAgent.abortBackup(self->extraDB, self->backupTag, PartialBackup::False, AbortOldBackup::False, DstOnly::False, WaitForDestUID::True);
															#line 759 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont10cont15Catch1(actor_cancelled(), loopDepth);
															#line 6977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont10cont15Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont15when1(__when_expr_16.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 759 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, Void >*>(static_cast<_startActor*>(this)));
															#line 6982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont10cont15Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10cont15Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 748 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_ExtraBackupException", randomID) .error(e) .detail("BackupTag", printable(self->backupTag));
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 7000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1cont1Catch1(e, loopDepth);
															#line 7004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont10cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont16(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont16(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< _startActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont10cont16cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont15cont1(int loopDepth) 
	{
		loopDepth = a_body1cont10cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont15Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 766 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_AbortBackupExtraException", randomID).error(e);
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded)
															#line 7129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			{
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1cont1Catch1(e, loopDepth);
															#line 7133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont10cont15cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont15cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont15cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont15when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont15when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont15when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10cont15Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont15Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< _startActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont15when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10cont15Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont15Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< _startActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont15Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10cont15Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont15Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont10cont15cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont15cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont14cont1(Void const& _,int loopDepth) 
	{
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->performRestore)
															#line 7249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 776 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<UID> __when_expr_18 = backupAgent.getLogUid(self->extraDB, self->restoreTag);
															#line 776 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 7255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont10cont14cont1when1(__when_expr_18.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 19;
															#line 776 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _startActor, 18, UID >*>(static_cast<_startActor*>(this)));
															#line 7260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont14cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont14cont1(Void && _,int loopDepth) 
	{
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->performRestore)
															#line 7274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 776 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<UID> __when_expr_18 = backupAgent.getLogUid(self->extraDB, self->restoreTag);
															#line 776 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 7280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont10cont14cont1when1(__when_expr_18.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 19;
															#line 776 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _startActor, 18, UID >*>(static_cast<_startActor*>(this)));
															#line 7285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont14cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont14when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont10cont14when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< _startActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont10cont14when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< _startActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont10cont14cont2(int loopDepth) 
	{
															#line 781 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_Complete", randomID).detail("BackupTag", printable(self->backupTag));
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->agentRequest)
															#line 7376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			BackupToDBCorrectnessWorkload::drAgentRequests--;
															#line 7380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if ((g_simulator->drAgents == ISimulator::BackupAgentType::BackupToDB) && (!BackupToDBCorrectnessWorkload::drAgentRequests))
															#line 7384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		{
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			g_simulator->drAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 7388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont10cont14cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14cont3(int loopDepth) 
	{
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_19 = checkData( cx, restoreUid, restoreUid, randomID, self->restoreTag, &restoreTool, self->shareLogRange);
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 7400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont10cont14cont3when1(__when_expr_19.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 20;
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< _startActor, 19, Void >*>(static_cast<_startActor*>(this)));
															#line 7405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont14cont1when1(UID const& __restoreUid,int loopDepth) 
	{
															#line 776 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		restoreUid = __restoreUid;
															#line 7414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont14cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14cont1when1(UID && __restoreUid,int loopDepth) 
	{
		restoreUid = std::move(__restoreUid);
		loopDepth = a_body1cont10cont14cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 18, UID >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 18, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont10cont14cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< _startActor, 18, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont10cont14cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< _startActor, 18, UID >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont10cont14cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 19, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 19, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont10cont14cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< _startActor, 19, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont10cont14cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< _startActor, 19, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont10cont14cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Database cx;
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	BackupToDBCorrectnessWorkload* self;
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DatabaseBackupAgent restoreTool;
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Future<Void> extraBackup;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DatabaseConfiguration config;
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID randomID;
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Future<Void> startRestore;
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Promise<Void> submitted;
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Future<Void> b;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID logUid;
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> restoreRange;
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> systemRestoreRange;
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key systemRestoreTag;
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	std::vector<RangeResult> res1;
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	std::vector<RangeResult> res2;
															#line 776 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID restoreUid;
															#line 7623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, DatabaseConfiguration >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, UID >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, Void >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public ActorCallback< _startActor, 12, std::vector<RangeResult> >, public ActorCallback< _startActor, 13, Void >, public ActorCallback< _startActor, 14, std::vector<RangeResult> >, public ActorCallback< _startActor, 15, Void >, public ActorCallback< _startActor, 16, Void >, public ActorCallback< _startActor, 17, Void >, public ActorCallback< _startActor, 18, UID >, public ActorCallback< _startActor, 19, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 7628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13588871964092279040UL, 327583667911974400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, UID >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, Void >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
friend struct ActorCallback< _startActor, 12, std::vector<RangeResult> >;
friend struct ActorCallback< _startActor, 13, Void >;
friend struct ActorCallback< _startActor, 14, std::vector<RangeResult> >;
friend struct ActorCallback< _startActor, 15, Void >;
friend struct ActorCallback< _startActor, 16, Void >;
friend struct ActorCallback< _startActor, 17, Void >;
friend struct ActorCallback< _startActor, 18, UID >;
friend struct ActorCallback< _startActor, 19, Void >;
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	_startActor(Database const& cx,BackupToDBCorrectnessWorkload* const& self) 
															#line 7664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, UID >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, std::vector<RangeResult> >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, std::vector<RangeResult> >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< _startActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< _startActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< _startActor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< _startActor, 18, UID >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< _startActor, 19, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, BackupToDBCorrectnessWorkload* const& self ) {
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 7715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp.py_gen"
}

#line 800 "/Users/ec2-user/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
};

int BackupToDBCorrectnessWorkload::drAgentRequests = 0;

WorkloadFactory<BackupToDBCorrectnessWorkload> BackupToDBCorrectnessWorkloadFactory;
