#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
/*
 * AtomicOpsApiCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/TesterInterface.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct AtomicOpsApiCorrectnessWorkload : TestWorkload {
	static constexpr auto NAME = "AtomicOpsApiCorrectness";
	bool testFailed = false;
	uint32_t opType;

private:
	static int getApiVersion(const Database& cx) { return cx->apiVersion.version(); }

	static void setApiVersion(Database* cx, int version) { (*cx)->apiVersion = ApiVersion(version); }

	Key getTestKey(std::string prefix) {
		std::string key = prefix + std::to_string(clientId);
		return StringRef(key);
	}

public:
	AtomicOpsApiCorrectnessWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		opType = getOption(options, "opType"_sr, -1);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (opType == -1)
			opType = sharedRandomNumber % 9;

		switch (opType) {
		case 0:
			CODE_PROBE(true, "Testing atomic Min");
			return testMin(cx->clone(), this);
		case 1:
			CODE_PROBE(true, "Testing atomic And");
			return testAnd(cx->clone(), this);
		case 2:
			CODE_PROBE(true, "Testing atomic ByteMin");
			return testByteMin(cx->clone(), this);
		case 3:
			CODE_PROBE(true, "Testing atomic ByteMax");
			return testByteMax(cx->clone(), this);
		case 4:
			CODE_PROBE(true, "Testing atomic Or");
			return testOr(cx->clone(), this);
		case 5:
			CODE_PROBE(true, "Testing atomic Max");
			return testMax(cx->clone(), this);
		case 6:
			CODE_PROBE(true, "Testing atomic Xor");
			return testXor(cx->clone(), this);
		case 7:
			CODE_PROBE(true, "Testing atomic Add");
			return testAdd(cx->clone(), this);
		case 8:
			CODE_PROBE(true, "Testing atomic CompareAndClear");
			return testCompareAndClear(cx->clone(), this);
		default:
			ASSERT(false);
		}

		return Void();
	}

	Future<bool> check(Database const& cx) override { return !testFailed; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	// Test Atomic ops on non existing keys that results in a set
																#line 95 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testAtomicOpSetOnNonExistingKey()
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
template <class TestAtomicOpSetOnNonExistingKeyActor>
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestAtomicOpSetOnNonExistingKeyActorState {
															#line 101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestAtomicOpSetOnNonExistingKeyActorState(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self,uint32_t const& opType,Key const& key) 
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   self(self),
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   opType(opType),
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   key(key),
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   intValue(deterministicRandom()->randomInt(0, 10000000)),
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   val(StringRef((const uint8_t*)&intValue, sizeof(intValue)))
															#line 118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this));

	}
	~TestAtomicOpSetOnNonExistingKeyActorState() 
	{
		fdb_probe_actor_destroy("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			;
															#line 133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAtomicOpSetOnNonExistingKeyActorState();
		static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_3 = runRYWTransaction( cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { return tr->get(key); });
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state = 4;
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 3, Optional<Value> >*>(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)));
															#line 164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->clear(key); return Void(); });
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state = 1;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 0, Void >*>(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)));
															#line 189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevInfo, "AtomicOpApiThrow").detail("ErrCode", e.code());
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(1);
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state = 3;
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 2, Void >*>(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)));
															#line 233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->atomicOp(key, val, opType); return Void(); });
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state = 2;
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 1, Void >*>(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)));
															#line 255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->atomicOp(key, val, opType); return Void(); });
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state = 2;
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 1, Void >*>(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)));
															#line 271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(int loopDepth) 
	{
		{
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_4 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { tr->clear(key); tr->atomicOp(key, val, opType); return tr->get(key); });
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when1(__when_expr_4.get(), loopDepth); };
			static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state = 5;
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 4, Optional<Value> >*>(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)));
															#line 537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> const& outputVal,int loopDepth) 
	{
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		uint64_t output = 0;
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() && outputVal.get().size() == sizeof(uint64_t));
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != intValue)
															#line 553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpSetOnNonExistingKeyUnexpectedOutput") .detail("OpOn", "StorageServer") .detail("Op", opType) .detail("ExpectedOutput", intValue) .detail("ActualOutput", output);
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> && outputVal,int loopDepth) 
	{
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		uint64_t output = 0;
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() && outputVal.get().size() == sizeof(uint64_t));
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != intValue)
															#line 575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpSetOnNonExistingKeyUnexpectedOutput") .detail("OpOn", "StorageServer") .detail("Op", opType) .detail("ExpectedOutput", intValue) .detail("ActualOutput", output);
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont3(outputVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(outputVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAtomicOpSetOnNonExistingKeyActorState(); static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->destroy(); return 0; }
															#line 666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAtomicOpSetOnNonExistingKeyActorState();
		static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Optional<Value> const& outputVal,int loopDepth) 
	{
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		uint64_t output = 0;
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() && outputVal.get().size() == sizeof(uint64_t));
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != intValue)
															#line 684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpSetOnNonExistingKeyUnexpectedOutput") .detail("OpOn", "RYWLayer") .detail("Op", opType) .detail("ExpectedOutput", intValue) .detail("ActualOutput", output);
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Optional<Value> && outputVal,int loopDepth) 
	{
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		uint64_t output = 0;
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() && outputVal.get().size() == sizeof(uint64_t));
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != intValue)
															#line 706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpSetOnNonExistingKeyUnexpectedOutput") .detail("OpOn", "RYWLayer") .detail("Op", opType) .detail("ExpectedOutput", intValue) .detail("ActualOutput", output);
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> const& outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont7(outputVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> && outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(outputVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Database cx;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	AtomicOpsApiCorrectnessWorkload* self;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	uint32_t opType;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Key key;
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	uint64_t intValue;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Value val;
															#line 805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testAtomicOpSetOnNonExistingKey()
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestAtomicOpSetOnNonExistingKeyActor final : public Actor<Void>, public ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 0, Void >, public ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 1, Void >, public ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 2, Void >, public ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 3, Optional<Value> >, public ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 4, Optional<Value> >, public FastAllocated<TestAtomicOpSetOnNonExistingKeyActor>, public TestAtomicOpSetOnNonExistingKeyActorState<TestAtomicOpSetOnNonExistingKeyActor> {
															#line 810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestAtomicOpSetOnNonExistingKeyActor>::operator new;
	using FastAllocated<TestAtomicOpSetOnNonExistingKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11890889147347085568UL, 16157809240156699136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 0, Void >;
friend struct ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 1, Void >;
friend struct ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 2, Void >;
friend struct ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 3, Optional<Value> >;
friend struct ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 4, Optional<Value> >;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestAtomicOpSetOnNonExistingKeyActor(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self,uint32_t const& opType,Key const& key) 
															#line 831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestAtomicOpSetOnNonExistingKeyActorState<TestAtomicOpSetOnNonExistingKeyActor>(cx, self, opType, key),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15270025501405369088UL, 11256022736871025152UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpSetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAtomicOpSetOnNonExistingKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAtomicOpSetOnNonExistingKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestAtomicOpSetOnNonExistingKeyActor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testAtomicOpSetOnNonExistingKey( Database const& cx, AtomicOpsApiCorrectnessWorkload* const& self, uint32_t const& opType, Key const& key ) {
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	return Future<Void>(new TestAtomicOpSetOnNonExistingKeyActor(cx, self, opType, key));
															#line 867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
}

#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"

	// Test Atomic ops on non existing keys that results in a unset
																#line 873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testAtomicOpUnsetOnNonExistingKey()
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
template <class TestAtomicOpUnsetOnNonExistingKeyActor>
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestAtomicOpUnsetOnNonExistingKeyActorState {
															#line 879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestAtomicOpUnsetOnNonExistingKeyActorState(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self,uint32_t const& opType,Key const& key) 
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   self(self),
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   opType(opType),
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   key(key),
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   intValue(deterministicRandom()->randomInt(0, 10000000)),
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   val(StringRef((const uint8_t*)&intValue, sizeof(intValue)))
															#line 896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this));

	}
	~TestAtomicOpUnsetOnNonExistingKeyActorState() 
	{
		fdb_probe_actor_destroy("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			;
															#line 911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAtomicOpUnsetOnNonExistingKeyActorState();
		static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_3 = runRYWTransaction( cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { return tr->get(key); });
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state = 4;
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 3, Optional<Value> >*>(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)));
															#line 942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->clear(key); return Void(); });
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state = 1;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 0, Void >*>(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)));
															#line 967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevInfo, "AtomicOpApiThrow").detail("ErrCode", e.code());
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(1);
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state = 3;
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 2, Void >*>(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)));
															#line 1011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->atomicOp(key, val, opType); return Void(); });
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state = 2;
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 1, Void >*>(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)));
															#line 1033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->atomicOp(key, val, opType); return Void(); });
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state = 2;
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 1, Void >*>(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)));
															#line 1049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(int loopDepth) 
	{
		{
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_4 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { tr->clear(key); tr->atomicOp(key, val, opType); return tr->get(key); });
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when1(__when_expr_4.get(), loopDepth); };
			static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state = 5;
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 4, Optional<Value> >*>(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)));
															#line 1315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> const& outputVal,int loopDepth) 
	{
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		uint64_t output = 0;
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() && outputVal.get().size() == sizeof(uint64_t));
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != 0)
															#line 1331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpUnsetOnNonExistingKeyUnexpectedOutput") .detail("OpOn", "StorageServer") .detail("Op", opType) .detail("ExpectedOutput", 0) .detail("ActualOutput", output);
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 1337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> && outputVal,int loopDepth) 
	{
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		uint64_t output = 0;
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() && outputVal.get().size() == sizeof(uint64_t));
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != 0)
															#line 1353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpUnsetOnNonExistingKeyUnexpectedOutput") .detail("OpOn", "StorageServer") .detail("Op", opType) .detail("ExpectedOutput", 0) .detail("ActualOutput", output);
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 1359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont3(outputVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(outputVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAtomicOpUnsetOnNonExistingKeyActorState(); static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->destroy(); return 0; }
															#line 1444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAtomicOpUnsetOnNonExistingKeyActorState();
		static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Optional<Value> const& outputVal,int loopDepth) 
	{
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		uint64_t output = 0;
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() && outputVal.get().size() == sizeof(uint64_t));
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != 0)
															#line 1462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpUnsetOnNonExistingKeyUnexpectedOutput") .detail("OpOn", "RYWLayer") .detail("Op", opType) .detail("ExpectedOutput", 0) .detail("ActualOutput", output);
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 1468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Optional<Value> && outputVal,int loopDepth) 
	{
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		uint64_t output = 0;
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() && outputVal.get().size() == sizeof(uint64_t));
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != 0)
															#line 1484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpUnsetOnNonExistingKeyUnexpectedOutput") .detail("OpOn", "RYWLayer") .detail("Op", opType) .detail("ExpectedOutput", 0) .detail("ActualOutput", output);
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 1490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> const& outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont7(outputVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> && outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(outputVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Database cx;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	AtomicOpsApiCorrectnessWorkload* self;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	uint32_t opType;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Key key;
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	uint64_t intValue;
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Value val;
															#line 1583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testAtomicOpUnsetOnNonExistingKey()
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestAtomicOpUnsetOnNonExistingKeyActor final : public Actor<Void>, public ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 0, Void >, public ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 1, Void >, public ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 2, Void >, public ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 3, Optional<Value> >, public ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 4, Optional<Value> >, public FastAllocated<TestAtomicOpUnsetOnNonExistingKeyActor>, public TestAtomicOpUnsetOnNonExistingKeyActorState<TestAtomicOpUnsetOnNonExistingKeyActor> {
															#line 1588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestAtomicOpUnsetOnNonExistingKeyActor>::operator new;
	using FastAllocated<TestAtomicOpUnsetOnNonExistingKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10223606242879866112UL, 150630326256456704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 0, Void >;
friend struct ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 1, Void >;
friend struct ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 2, Void >;
friend struct ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 3, Optional<Value> >;
friend struct ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 4, Optional<Value> >;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestAtomicOpUnsetOnNonExistingKeyActor(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self,uint32_t const& opType,Key const& key) 
															#line 1609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestAtomicOpUnsetOnNonExistingKeyActorState<TestAtomicOpUnsetOnNonExistingKeyActor>(cx, self, opType, key),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13029102372810934272UL, 15479855220829886464UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpUnsetOnNonExistingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAtomicOpUnsetOnNonExistingKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAtomicOpUnsetOnNonExistingKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestAtomicOpUnsetOnNonExistingKeyActor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testAtomicOpUnsetOnNonExistingKey( Database const& cx, AtomicOpsApiCorrectnessWorkload* const& self, uint32_t const& opType, Key const& key ) {
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	return Future<Void>(new TestAtomicOpUnsetOnNonExistingKeyActor(cx, self, opType, key));
															#line 1645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
}

#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"

	typedef std::function<Value(Value, Value)> DoAtomicOpOnEmptyValueFunction;

	// Test Atomic Ops when one of the value is empty
																#line 1653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testAtomicOpOnEmptyValue()
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
template <class TestAtomicOpOnEmptyValueActor>
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestAtomicOpOnEmptyValueActorState {
															#line 1659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestAtomicOpOnEmptyValueActorState(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self,uint32_t const& opType,Key const& key,DoAtomicOpOnEmptyValueFunction const& opFunc) 
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   self(self),
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   opType(opType),
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   key(key),
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   opFunc(opFunc),
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   existingVal(),
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   otherVal(),
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   val(deterministicRandom()->randomInt(0, 10000000))
															#line 1680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this));

	}
	~TestAtomicOpOnEmptyValueActorState() 
	{
		fdb_probe_actor_destroy("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (deterministicRandom()->random01() < 0.5)
															#line 1695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			{
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
				existingVal = StringRef((const uint8_t*)&val, sizeof(val));
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
				otherVal = StringRef();
															#line 1701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
				otherVal = StringRef((const uint8_t*)&val, sizeof(val));
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
				existingVal = StringRef();
															#line 1709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			}
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			;
															#line 1713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAtomicOpOnEmptyValueActorState();
		static_cast<TestAtomicOpOnEmptyValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_3 = runRYWTransaction( cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { return tr->get(key); });
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state = 4;
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpOnEmptyValueActor, 3, Optional<Value> >*>(static_cast<TestAtomicOpOnEmptyValueActor*>(this)));
															#line 1744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->set(key, existingVal); return Void(); });
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state = 1;
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpOnEmptyValueActor, 0, Void >*>(static_cast<TestAtomicOpOnEmptyValueActor*>(this)));
															#line 1769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevInfo, "AtomicOpApiThrow").detail("ErrCode", e.code());
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(1);
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state = 3;
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpOnEmptyValueActor, 2, Void >*>(static_cast<TestAtomicOpOnEmptyValueActor*>(this)));
															#line 1813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->atomicOp(key, otherVal, opType); return Void(); });
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state = 2;
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpOnEmptyValueActor, 1, Void >*>(static_cast<TestAtomicOpOnEmptyValueActor*>(this)));
															#line 1835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->atomicOp(key, otherVal, opType); return Void(); });
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state = 2;
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpOnEmptyValueActor, 1, Void >*>(static_cast<TestAtomicOpOnEmptyValueActor*>(this)));
															#line 1851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpOnEmptyValueActor*>(this)->ActorCallback< TestAtomicOpOnEmptyValueActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpOnEmptyValueActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpOnEmptyValueActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAtomicOpOnEmptyValueActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpOnEmptyValueActor*>(this)->ActorCallback< TestAtomicOpOnEmptyValueActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpOnEmptyValueActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpOnEmptyValueActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAtomicOpOnEmptyValueActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpOnEmptyValueActor*>(this)->ActorCallback< TestAtomicOpOnEmptyValueActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpOnEmptyValueActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpOnEmptyValueActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAtomicOpOnEmptyValueActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
		{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_4 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { tr->set(key, existingVal); tr->atomicOp(key, otherVal, opType); return tr->get(key); });
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
			static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state = 5;
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpOnEmptyValueActor, 4, Optional<Value> >*>(static_cast<TestAtomicOpOnEmptyValueActor*>(this)));
															#line 2117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont5(Optional<Value> const& outputVal,int loopDepth) 
	{
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present());
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		Value output = outputVal.get();
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != opFunc(existingVal, otherVal))
															#line 2131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpOnEmptyValueUnexpectedOutput") .detail("OpOn", "StorageServer") .detail("Op", opType) .detail("ExpectedOutput", opFunc(existingVal, otherVal).toString()) .detail("ActualOutput", output.toString());
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 2137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Optional<Value> && outputVal,int loopDepth) 
	{
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present());
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		Value output = outputVal.get();
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != opFunc(existingVal, otherVal))
															#line 2151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpOnEmptyValueUnexpectedOutput") .detail("OpOn", "StorageServer") .detail("Op", opType) .detail("ExpectedOutput", opFunc(existingVal, otherVal).toString()) .detail("ActualOutput", output.toString());
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 2157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont5(outputVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(outputVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpOnEmptyValueActor*>(this)->ActorCallback< TestAtomicOpOnEmptyValueActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpOnEmptyValueActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpOnEmptyValueActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestAtomicOpOnEmptyValueActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestAtomicOpOnEmptyValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAtomicOpOnEmptyValueActorState(); static_cast<TestAtomicOpOnEmptyValueActor*>(this)->destroy(); return 0; }
															#line 2242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestAtomicOpOnEmptyValueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAtomicOpOnEmptyValueActorState();
		static_cast<TestAtomicOpOnEmptyValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Optional<Value> const& outputVal,int loopDepth) 
	{
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present());
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		Value output = outputVal.get();
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != opFunc(existingVal, otherVal))
															#line 2258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpOnEmptyValueUnexpectedOutput") .detail("OpOn", "RYWLayer") .detail("Op", opType) .detail("ExpectedOutput", opFunc(existingVal, otherVal).toString()) .detail("ActualOutput", output.toString());
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 2264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Optional<Value> && outputVal,int loopDepth) 
	{
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present());
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		Value output = outputVal.get();
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != opFunc(existingVal, otherVal))
															#line 2278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpOnEmptyValueUnexpectedOutput") .detail("OpOn", "RYWLayer") .detail("Op", opType) .detail("ExpectedOutput", opFunc(existingVal, otherVal).toString()) .detail("ActualOutput", output.toString());
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 2284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Optional<Value> const& outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont9(outputVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Optional<Value> && outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(outputVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpOnEmptyValueActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpOnEmptyValueActor*>(this)->ActorCallback< TestAtomicOpOnEmptyValueActor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpOnEmptyValueActor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpOnEmptyValueActor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestAtomicOpOnEmptyValueActor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Database cx;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	AtomicOpsApiCorrectnessWorkload* self;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	uint32_t opType;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Key key;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	DoAtomicOpOnEmptyValueFunction opFunc;
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Value existingVal;
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Value otherVal;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	uint64_t val;
															#line 2381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testAtomicOpOnEmptyValue()
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestAtomicOpOnEmptyValueActor final : public Actor<Void>, public ActorCallback< TestAtomicOpOnEmptyValueActor, 0, Void >, public ActorCallback< TestAtomicOpOnEmptyValueActor, 1, Void >, public ActorCallback< TestAtomicOpOnEmptyValueActor, 2, Void >, public ActorCallback< TestAtomicOpOnEmptyValueActor, 3, Optional<Value> >, public ActorCallback< TestAtomicOpOnEmptyValueActor, 4, Optional<Value> >, public FastAllocated<TestAtomicOpOnEmptyValueActor>, public TestAtomicOpOnEmptyValueActorState<TestAtomicOpOnEmptyValueActor> {
															#line 2386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestAtomicOpOnEmptyValueActor>::operator new;
	using FastAllocated<TestAtomicOpOnEmptyValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12898201241301532160UL, 13371258797327136000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAtomicOpOnEmptyValueActor, 0, Void >;
friend struct ActorCallback< TestAtomicOpOnEmptyValueActor, 1, Void >;
friend struct ActorCallback< TestAtomicOpOnEmptyValueActor, 2, Void >;
friend struct ActorCallback< TestAtomicOpOnEmptyValueActor, 3, Optional<Value> >;
friend struct ActorCallback< TestAtomicOpOnEmptyValueActor, 4, Optional<Value> >;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestAtomicOpOnEmptyValueActor(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self,uint32_t const& opType,Key const& key,DoAtomicOpOnEmptyValueFunction const& opFunc) 
															#line 2407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestAtomicOpOnEmptyValueActorState<TestAtomicOpOnEmptyValueActor>(cx, self, opType, key, opFunc),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(869957710069361152UL, 7276414920250838528UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpOnEmptyValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAtomicOpOnEmptyValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAtomicOpOnEmptyValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAtomicOpOnEmptyValueActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAtomicOpOnEmptyValueActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAtomicOpOnEmptyValueActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestAtomicOpOnEmptyValueActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestAtomicOpOnEmptyValueActor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testAtomicOpOnEmptyValue( Database const& cx, AtomicOpsApiCorrectnessWorkload* const& self, uint32_t const& opType, Key const& key, DoAtomicOpOnEmptyValueFunction const& opFunc ) {
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	return Future<Void>(new TestAtomicOpOnEmptyValueActor(cx, self, opType, key, opFunc));
															#line 2443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
}

#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"

	typedef std::function<uint64_t(uint64_t, uint64_t)> DoAtomicOpFunction;

	// Test atomic ops in the normal case when the existing value is present
																#line 2451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testAtomicOpApi()
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
template <class TestAtomicOpApiActor>
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestAtomicOpApiActorState {
															#line 2457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestAtomicOpApiActorState(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self,uint32_t const& opType,Key const& key,DoAtomicOpFunction const& opFunc) 
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   self(self),
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   opType(opType),
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   key(key),
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   opFunc(opFunc),
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   intValue1(deterministicRandom()->randomInt(0, 10000000)),
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   intValue2(deterministicRandom()->randomInt(0, 10000000)),
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   val1(StringRef((const uint8_t*)&intValue1, sizeof(intValue1))),
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   val2(StringRef((const uint8_t*)&intValue2, sizeof(intValue2)))
															#line 2480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testAtomicOpApi", reinterpret_cast<unsigned long>(this));

	}
	~TestAtomicOpApiActorState() 
	{
		fdb_probe_actor_destroy("testAtomicOpApi", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			;
															#line 2495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAtomicOpApiActorState();
		static_cast<TestAtomicOpApiActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_3 = runRYWTransaction( cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { return tr->get(key); });
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state = 4;
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpApiActor, 3, Optional<Value> >*>(static_cast<TestAtomicOpApiActor*>(this)));
															#line 2526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->set(key, val1); return Void(); });
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state = 1;
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpApiActor, 0, Void >*>(static_cast<TestAtomicOpApiActor*>(this)));
															#line 2551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevInfo, "AtomicOpApiThrow").detail("ErrCode", e.code());
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(1);
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state = 3;
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpApiActor, 2, Void >*>(static_cast<TestAtomicOpApiActor*>(this)));
															#line 2595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->atomicOp(key, val2, opType); return Void(); });
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state = 2;
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpApiActor, 1, Void >*>(static_cast<TestAtomicOpApiActor*>(this)));
															#line 2617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->atomicOp(key, val2, opType); return Void(); });
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state = 2;
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpApiActor, 1, Void >*>(static_cast<TestAtomicOpApiActor*>(this)));
															#line 2633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpApiActor*>(this)->ActorCallback< TestAtomicOpApiActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpApiActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpApiActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAtomicOpApiActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpApiActor*>(this)->ActorCallback< TestAtomicOpApiActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpApiActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpApiActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAtomicOpApiActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpApiActor*>(this)->ActorCallback< TestAtomicOpApiActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpApiActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpApiActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAtomicOpApiActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(int loopDepth) 
	{
		{
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_4 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { tr->set(key, val1); tr->atomicOp(key, val2, opType); return tr->get(key); });
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when1(__when_expr_4.get(), loopDepth); };
			static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state = 5;
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestAtomicOpApiActor, 4, Optional<Value> >*>(static_cast<TestAtomicOpApiActor*>(this)));
															#line 2899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> const& outputVal,int loopDepth) 
	{
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		uint64_t output = 0;
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() && outputVal.get().size() == sizeof(uint64_t));
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != opFunc(intValue1, intValue2))
															#line 2915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpApiCorrectnessUnexpectedOutput") .detail("OpOn", "StorageServer") .detail("InValue1", intValue1) .detail("InValue2", intValue2) .detail("AtomicOp", opType) .detail("ExpectedOutput", opFunc(intValue1, intValue2)) .detail("ActualOutput", output);
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 2921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> && outputVal,int loopDepth) 
	{
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		uint64_t output = 0;
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() && outputVal.get().size() == sizeof(uint64_t));
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != opFunc(intValue1, intValue2))
															#line 2937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpApiCorrectnessUnexpectedOutput") .detail("OpOn", "StorageServer") .detail("InValue1", intValue1) .detail("InValue2", intValue2) .detail("AtomicOp", opType) .detail("ExpectedOutput", opFunc(intValue1, intValue2)) .detail("ActualOutput", output);
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 2943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont3(outputVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(outputVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpApiActor*>(this)->ActorCallback< TestAtomicOpApiActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpApiActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpApiActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestAtomicOpApiActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestAtomicOpApiActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAtomicOpApiActorState(); static_cast<TestAtomicOpApiActor*>(this)->destroy(); return 0; }
															#line 3028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestAtomicOpApiActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAtomicOpApiActorState();
		static_cast<TestAtomicOpApiActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Optional<Value> const& outputVal,int loopDepth) 
	{
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		uint64_t output = 0;
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() && outputVal.get().size() == sizeof(uint64_t));
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != opFunc(intValue1, intValue2))
															#line 3046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpApiCorrectnessUnexpectedOutput") .detail("OpOn", "RYWLayer") .detail("InValue1", intValue1) .detail("InValue2", intValue2) .detail("AtomicOp", opType) .detail("ExpectedOutput", opFunc(intValue1, intValue2)) .detail("ActualOutput", output);
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 3052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Optional<Value> && outputVal,int loopDepth) 
	{
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		uint64_t output = 0;
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() && outputVal.get().size() == sizeof(uint64_t));
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (output != opFunc(intValue1, intValue2))
															#line 3068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevError, "AtomicOpApiCorrectnessUnexpectedOutput") .detail("OpOn", "RYWLayer") .detail("InValue1", intValue1) .detail("InValue2", intValue2) .detail("AtomicOp", opType) .detail("ExpectedOutput", opFunc(intValue1, intValue2)) .detail("ActualOutput", output);
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			self->testFailed = true;
															#line 3074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> const& outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont7(outputVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> && outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(outputVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicOpApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicOpApiActor*>(this)->ActorCallback< TestAtomicOpApiActor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicOpApiActor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestAtomicOpApiActor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestAtomicOpApiActor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Database cx;
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	AtomicOpsApiCorrectnessWorkload* self;
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	uint32_t opType;
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Key key;
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	DoAtomicOpFunction opFunc;
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	uint64_t intValue1;
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	uint64_t intValue2;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Value val1;
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Value val2;
															#line 3173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testAtomicOpApi()
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestAtomicOpApiActor final : public Actor<Void>, public ActorCallback< TestAtomicOpApiActor, 0, Void >, public ActorCallback< TestAtomicOpApiActor, 1, Void >, public ActorCallback< TestAtomicOpApiActor, 2, Void >, public ActorCallback< TestAtomicOpApiActor, 3, Optional<Value> >, public ActorCallback< TestAtomicOpApiActor, 4, Optional<Value> >, public FastAllocated<TestAtomicOpApiActor>, public TestAtomicOpApiActorState<TestAtomicOpApiActor> {
															#line 3178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestAtomicOpApiActor>::operator new;
	using FastAllocated<TestAtomicOpApiActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14019725417758859264UL, 3157264417019458560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAtomicOpApiActor, 0, Void >;
friend struct ActorCallback< TestAtomicOpApiActor, 1, Void >;
friend struct ActorCallback< TestAtomicOpApiActor, 2, Void >;
friend struct ActorCallback< TestAtomicOpApiActor, 3, Optional<Value> >;
friend struct ActorCallback< TestAtomicOpApiActor, 4, Optional<Value> >;
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestAtomicOpApiActor(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self,uint32_t const& opType,Key const& key,DoAtomicOpFunction const& opFunc) 
															#line 3199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestAtomicOpApiActorState<TestAtomicOpApiActor>(cx, self, opType, key, opFunc),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAtomicOpApi", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7854773354493942272UL, 14684228193232332032UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAtomicOpApi");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAtomicOpApi", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAtomicOpApiActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAtomicOpApiActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAtomicOpApiActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestAtomicOpApiActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestAtomicOpApiActor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testAtomicOpApi( Database const& cx, AtomicOpsApiCorrectnessWorkload* const& self, uint32_t const& opType, Key const& key, DoAtomicOpFunction const& opFunc ) {
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	return Future<Void>(new TestAtomicOpApiActor(cx, self, opType, key, opFunc));
															#line 3235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
}

#line 369 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"

																#line 3240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testCompareAndClearAtomicOpApi()
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
template <class TestCompareAndClearAtomicOpApiActor>
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestCompareAndClearAtomicOpApiActorState {
															#line 3246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestCompareAndClearAtomicOpApiActorState(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self,Key const& key,bool const& keySet) 
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   self(self),
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   key(key),
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   keySet(keySet),
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   opType(MutationRef::CompareAndClear),
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   intValue1(deterministicRandom()->randomInt(0, 10000000)),
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   intValue2(deterministicRandom()->coinflip() ? intValue1 : deterministicRandom()->randomInt(0, 10000000)),
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   val1(StringRef((const uint8_t*)&intValue1, sizeof(intValue1))),
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   val2(StringRef((const uint8_t*)&intValue2, sizeof(intValue2))),
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   opFunc([keySet](uint64_t val1, uint64_t val2) { if (!keySet || val1 == val2) { return Optional<uint64_t>(); } else { return Optional<uint64_t>(val1); } })
															#line 3271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this));

	}
	~TestCompareAndClearAtomicOpApiActorState() 
	{
		fdb_probe_actor_destroy("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			;
															#line 3286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCompareAndClearAtomicOpApiActorState();
		static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		expectedOutput = Optional<uint64_t>();
															#line 3309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_3 = runRYWTransaction( cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { return tr->get(key); });
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state = 4;
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestCompareAndClearAtomicOpApiActor, 3, Optional<Value> >*>(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)));
															#line 3320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { if (keySet) { tr->set(key, val1); } else { tr->clear(key); } return Void(); });
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state = 1;
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCompareAndClearAtomicOpApiActor, 0, Void >*>(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)));
															#line 3345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevInfo, "AtomicOpApiThrow").detail("ErrCode", e.code());
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(1);
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state = 3;
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestCompareAndClearAtomicOpApiActor, 2, Void >*>(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)));
															#line 3389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->atomicOp(key, val2, opType); return Void(); });
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state = 2;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCompareAndClearAtomicOpApiActor, 1, Void >*>(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)));
															#line 3411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransactionNoRetry(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->atomicOp(key, val2, opType); return Void(); });
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state = 2;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCompareAndClearAtomicOpApiActor, 1, Void >*>(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)));
															#line 3427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state > 0) static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->ActorCallback< TestCompareAndClearAtomicOpApiActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompareAndClearAtomicOpApiActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCompareAndClearAtomicOpApiActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCompareAndClearAtomicOpApiActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state > 0) static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->ActorCallback< TestCompareAndClearAtomicOpApiActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompareAndClearAtomicOpApiActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCompareAndClearAtomicOpApiActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCompareAndClearAtomicOpApiActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state > 0) static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->ActorCallback< TestCompareAndClearAtomicOpApiActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompareAndClearAtomicOpApiActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestCompareAndClearAtomicOpApiActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestCompareAndClearAtomicOpApiActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(int loopDepth) 
	{
		{
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_4 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { if (keySet) { tr->set(key, val1); } else { tr->clear(key); } tr->atomicOp(key, val2, opType); return tr->get(key); });
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when1(__when_expr_4.get(), loopDepth); };
			static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state = 5;
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestCompareAndClearAtomicOpApiActor, 4, Optional<Value> >*>(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)));
															#line 3693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> const& outputVal,int loopDepth) 
	{
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		Optional<uint64_t> expectedOutput_ = opFunc(intValue1, intValue2);
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		expectedOutput = expectedOutput_;
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() == expectedOutput.present());
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (outputVal.present())
															#line 3709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			uint64_t output = 0;
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			ASSERT(outputVal.get().size() == sizeof(uint64_t));
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (output != expectedOutput.get())
															#line 3719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			{
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
				TraceEvent(SevError, "AtomicOpApiCorrectnessUnexpectedOutput") .detail("OpOn", "StorageServer") .detail("InValue1", intValue1) .detail("InValue2", intValue2) .detail("AtomicOp", opType) .detail("ExpectedOutput", expectedOutput.get()) .detail("ActualOutput", output);
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
				self->testFailed = true;
															#line 3725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> && outputVal,int loopDepth) 
	{
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		Optional<uint64_t> expectedOutput_ = opFunc(intValue1, intValue2);
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		expectedOutput = expectedOutput_;
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() == expectedOutput.present());
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (outputVal.present())
															#line 3742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			uint64_t output = 0;
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			ASSERT(outputVal.get().size() == sizeof(uint64_t));
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (output != expectedOutput.get())
															#line 3752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			{
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
				TraceEvent(SevError, "AtomicOpApiCorrectnessUnexpectedOutput") .detail("OpOn", "StorageServer") .detail("InValue1", intValue1) .detail("InValue2", intValue2) .detail("AtomicOp", opType) .detail("ExpectedOutput", expectedOutput.get()) .detail("ActualOutput", output);
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
				self->testFailed = true;
															#line 3758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont3(outputVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(outputVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state > 0) static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->ActorCallback< TestCompareAndClearAtomicOpApiActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompareAndClearAtomicOpApiActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestCompareAndClearAtomicOpApiActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestCompareAndClearAtomicOpApiActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 472 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCompareAndClearAtomicOpApiActorState(); static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->destroy(); return 0; }
															#line 3844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCompareAndClearAtomicOpApiActorState();
		static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Optional<Value> const& outputVal,int loopDepth) 
	{
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() == expectedOutput.present());
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (outputVal.present())
															#line 3858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			uint64_t output = 0;
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			ASSERT(outputVal.get().size() == sizeof(uint64_t));
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (output != expectedOutput.get())
															#line 3868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			{
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
				TraceEvent(SevError, "AtomicOpApiCorrectnessUnexpectedOutput") .detail("OpOn", "RYWLayer") .detail("InValue1", intValue1) .detail("InValue2", intValue2) .detail("AtomicOp", opType) .detail("ExpectedOutput", expectedOutput.get()) .detail("ActualOutput", output);
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
				self->testFailed = true;
															#line 3874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Optional<Value> && outputVal,int loopDepth) 
	{
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		ASSERT(outputVal.present() == expectedOutput.present());
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (outputVal.present())
															#line 3887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			uint64_t output = 0;
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			ASSERT(outputVal.get().size() == sizeof(uint64_t));
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			memcpy(&output, outputVal.get().begin(), outputVal.get().size());
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (output != expectedOutput.get())
															#line 3897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			{
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
				TraceEvent(SevError, "AtomicOpApiCorrectnessUnexpectedOutput") .detail("OpOn", "RYWLayer") .detail("InValue1", intValue1) .detail("InValue2", intValue2) .detail("AtomicOp", opType) .detail("ExpectedOutput", expectedOutput.get()) .detail("ActualOutput", output);
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
				self->testFailed = true;
															#line 3903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> const& outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont8(outputVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> && outputVal,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(outputVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state > 0) static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->ActorCallback< TestCompareAndClearAtomicOpApiActor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompareAndClearAtomicOpApiActor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestCompareAndClearAtomicOpApiActor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestCompareAndClearAtomicOpApiActor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Database cx;
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	AtomicOpsApiCorrectnessWorkload* self;
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Key key;
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	bool keySet;
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	uint64_t opType;
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	uint64_t intValue1;
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	uint64_t intValue2;
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Value val1;
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Value val2;
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	std::function<Optional<uint64_t>(uint64_t, uint64_t)> opFunc;
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Optional<uint64_t> expectedOutput;
															#line 4007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testCompareAndClearAtomicOpApi()
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestCompareAndClearAtomicOpApiActor final : public Actor<Void>, public ActorCallback< TestCompareAndClearAtomicOpApiActor, 0, Void >, public ActorCallback< TestCompareAndClearAtomicOpApiActor, 1, Void >, public ActorCallback< TestCompareAndClearAtomicOpApiActor, 2, Void >, public ActorCallback< TestCompareAndClearAtomicOpApiActor, 3, Optional<Value> >, public ActorCallback< TestCompareAndClearAtomicOpApiActor, 4, Optional<Value> >, public FastAllocated<TestCompareAndClearAtomicOpApiActor>, public TestCompareAndClearAtomicOpApiActorState<TestCompareAndClearAtomicOpApiActor> {
															#line 4012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestCompareAndClearAtomicOpApiActor>::operator new;
	using FastAllocated<TestCompareAndClearAtomicOpApiActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11857251959775112192UL, 160289171023980032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCompareAndClearAtomicOpApiActor, 0, Void >;
friend struct ActorCallback< TestCompareAndClearAtomicOpApiActor, 1, Void >;
friend struct ActorCallback< TestCompareAndClearAtomicOpApiActor, 2, Void >;
friend struct ActorCallback< TestCompareAndClearAtomicOpApiActor, 3, Optional<Value> >;
friend struct ActorCallback< TestCompareAndClearAtomicOpApiActor, 4, Optional<Value> >;
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestCompareAndClearAtomicOpApiActor(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self,Key const& key,bool const& keySet) 
															#line 4033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestCompareAndClearAtomicOpApiActorState<TestCompareAndClearAtomicOpApiActor>(cx, self, key, keySet),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13179245729742691072UL, 3417292357231528704UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearAtomicOpApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCompareAndClearAtomicOpApi");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCompareAndClearAtomicOpApi", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCompareAndClearAtomicOpApiActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCompareAndClearAtomicOpApiActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestCompareAndClearAtomicOpApiActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestCompareAndClearAtomicOpApiActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestCompareAndClearAtomicOpApiActor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testCompareAndClearAtomicOpApi( Database const& cx, AtomicOpsApiCorrectnessWorkload* const& self, Key const& key, bool const& keySet ) {
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	return Future<Void>(new TestCompareAndClearAtomicOpApiActor(cx, self, key, keySet));
															#line 4069 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
}

#line 474 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"

																#line 4074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testMin()
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
template <class TestMinActor>
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestMinActorState {
															#line 4080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestMinActorState(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   self(self),
															#line 476 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   currentApiVersion(getApiVersion(cx)),
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   key(self->getTestKey("test_key_min_"))
															#line 4093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testMin", reinterpret_cast<unsigned long>(this));

	}
	~TestMinActorState() 
	{
		fdb_probe_actor_destroy("testMin", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent("AtomicOpCorrectnessApiWorkload").detail("OpType", "MIN");
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			setApiVersion(&cx, 500);
															#line 482 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevInfo, "Running Atomic Op Min Correctness Test Api Version 500").log();
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->testAtomicOpUnsetOnNonExistingKey(cx, self, MutationRef::Min, key);
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestMinActor*>(this)->actor_wait_state = 1;
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestMinActor, 0, Void >*>(static_cast<TestMinActor*>(this)));
															#line 4121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestMinActorState();
		static_cast<TestMinActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi( cx, self, MutationRef::Min, key, [](uint64_t val1, uint64_t val2) { return val1 < val2 ? val1 : val2; });
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestMinActor*>(this)->actor_wait_state = 2;
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestMinActor, 1, Void >*>(static_cast<TestMinActor*>(this)));
															#line 4151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi( cx, self, MutationRef::Min, key, [](uint64_t val1, uint64_t val2) { return val1 < val2 ? val1 : val2; });
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestMinActor*>(this)->actor_wait_state = 2;
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestMinActor, 1, Void >*>(static_cast<TestMinActor*>(this)));
															#line 4167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestMinActor*>(this)->actor_wait_state > 0) static_cast<TestMinActor*>(this)->actor_wait_state = 0;
		static_cast<TestMinActor*>(this)->ActorCallback< TestMinActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMinActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestMinActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestMinActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue(cx, self, MutationRef::Min, key, [](Value v1, Value v2) -> Value { uint64_t zeroVal = 0; if (v2.size() == 0) return StringRef(); else return StringRef((const uint8_t*)&zeroVal, sizeof(zeroVal)); });
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestMinActor*>(this)->actor_wait_state = 3;
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestMinActor, 2, Void >*>(static_cast<TestMinActor*>(this)));
															#line 4258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue(cx, self, MutationRef::Min, key, [](Value v1, Value v2) -> Value { uint64_t zeroVal = 0; if (v2.size() == 0) return StringRef(); else return StringRef((const uint8_t*)&zeroVal, sizeof(zeroVal)); });
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestMinActor*>(this)->actor_wait_state = 3;
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestMinActor, 2, Void >*>(static_cast<TestMinActor*>(this)));
															#line 4274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestMinActor*>(this)->actor_wait_state > 0) static_cast<TestMinActor*>(this)->actor_wait_state = 0;
		static_cast<TestMinActor*>(this)->ActorCallback< TestMinActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMinActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestMinActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestMinActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		setApiVersion(&cx, currentApiVersion);
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		TraceEvent(SevInfo, "Running Atomic Op Min Correctness Current Api Version") .detail("Version", currentApiVersion);
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->testAtomicOpSetOnNonExistingKey(cx, self, MutationRef::Min, key);
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestMinActor*>(this)->actor_wait_state = 4;
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestMinActor, 3, Void >*>(static_cast<TestMinActor*>(this)));
															#line 4369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		setApiVersion(&cx, currentApiVersion);
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		TraceEvent(SevInfo, "Running Atomic Op Min Correctness Current Api Version") .detail("Version", currentApiVersion);
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->testAtomicOpSetOnNonExistingKey(cx, self, MutationRef::Min, key);
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestMinActor*>(this)->actor_wait_state = 4;
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestMinActor, 3, Void >*>(static_cast<TestMinActor*>(this)));
															#line 4389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestMinActor*>(this)->actor_wait_state > 0) static_cast<TestMinActor*>(this)->actor_wait_state = 0;
		static_cast<TestMinActor*>(this)->ActorCallback< TestMinActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMinActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestMinActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestMinActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->testAtomicOpApi( cx, self, MutationRef::Min, key, [](uint64_t val1, uint64_t val2) { return val1 < val2 ? val1 : val2; });
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestMinActor*>(this)->actor_wait_state = 5;
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestMinActor, 4, Void >*>(static_cast<TestMinActor*>(this)));
															#line 4480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->testAtomicOpApi( cx, self, MutationRef::Min, key, [](uint64_t val1, uint64_t val2) { return val1 < val2 ? val1 : val2; });
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestMinActor*>(this)->actor_wait_state = 5;
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestMinActor, 4, Void >*>(static_cast<TestMinActor*>(this)));
															#line 4496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestMinActor*>(this)->actor_wait_state > 0) static_cast<TestMinActor*>(this)->actor_wait_state = 0;
		static_cast<TestMinActor*>(this)->ActorCallback< TestMinActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMinActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestMinActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestMinActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->testAtomicOpOnEmptyValue(cx, self, MutationRef::Min, key, [](Value v1, Value v2) -> Value { uint64_t zeroVal = 0; if (v2.size() == 0) return StringRef(); else return StringRef((const uint8_t*)&zeroVal, sizeof(zeroVal)); });
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestMinActor*>(this)->actor_wait_state = 6;
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestMinActor, 5, Void >*>(static_cast<TestMinActor*>(this)));
															#line 4587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->testAtomicOpOnEmptyValue(cx, self, MutationRef::Min, key, [](Value v1, Value v2) -> Value { uint64_t zeroVal = 0; if (v2.size() == 0) return StringRef(); else return StringRef((const uint8_t*)&zeroVal, sizeof(zeroVal)); });
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestMinActor*>(this)->actor_wait_state = 6;
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestMinActor, 5, Void >*>(static_cast<TestMinActor*>(this)));
															#line 4603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestMinActor*>(this)->actor_wait_state > 0) static_cast<TestMinActor*>(this)->actor_wait_state = 0;
		static_cast<TestMinActor*>(this)->ActorCallback< TestMinActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMinActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestMinActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestMinActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestMinActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestMinActorState(); static_cast<TestMinActor*>(this)->destroy(); return 0; }
															#line 4687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestMinActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestMinActorState();
		static_cast<TestMinActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestMinActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestMinActorState(); static_cast<TestMinActor*>(this)->destroy(); return 0; }
															#line 4699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestMinActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestMinActorState();
		static_cast<TestMinActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestMinActor*>(this)->actor_wait_state > 0) static_cast<TestMinActor*>(this)->actor_wait_state = 0;
		static_cast<TestMinActor*>(this)->ActorCallback< TestMinActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMinActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestMinActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestMinActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Database cx;
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	AtomicOpsApiCorrectnessWorkload* self;
															#line 476 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	int currentApiVersion;
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Key key;
															#line 4790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testMin()
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestMinActor final : public Actor<Void>, public ActorCallback< TestMinActor, 0, Void >, public ActorCallback< TestMinActor, 1, Void >, public ActorCallback< TestMinActor, 2, Void >, public ActorCallback< TestMinActor, 3, Void >, public ActorCallback< TestMinActor, 4, Void >, public ActorCallback< TestMinActor, 5, Void >, public FastAllocated<TestMinActor>, public TestMinActorState<TestMinActor> {
															#line 4795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestMinActor>::operator new;
	using FastAllocated<TestMinActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(303231313591627264UL, 9300782506372529408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestMinActor, 0, Void >;
friend struct ActorCallback< TestMinActor, 1, Void >;
friend struct ActorCallback< TestMinActor, 2, Void >;
friend struct ActorCallback< TestMinActor, 3, Void >;
friend struct ActorCallback< TestMinActor, 4, Void >;
friend struct ActorCallback< TestMinActor, 5, Void >;
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestMinActor(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 4817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestMinActorState<TestMinActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testMin", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9365850514216994560UL, 17949188716782683648UL);
		ActorExecutionContextHelper __helper(static_cast<TestMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testMin");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testMin", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestMinActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestMinActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestMinActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestMinActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestMinActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestMinActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testMin( Database const& cx, AtomicOpsApiCorrectnessWorkload* const& self ) {
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	return Future<Void>(new TestMinActor(cx, self));
															#line 4854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
}

#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"

																#line 4859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testMax()
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
template <class TestMaxActor>
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestMaxActorState {
															#line 4865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestMaxActorState(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   self(self),
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   key(self->getTestKey("test_key_max_"))
															#line 4876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testMax", reinterpret_cast<unsigned long>(this));

	}
	~TestMaxActorState() 
	{
		fdb_probe_actor_destroy("testMax", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevInfo, "Running Atomic Op MAX Correctness Current Api Version").log();
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->testAtomicOpSetOnNonExistingKey(cx, self, MutationRef::Max, key);
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestMaxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestMaxActor*>(this)->actor_wait_state = 1;
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestMaxActor, 0, Void >*>(static_cast<TestMaxActor*>(this)));
															#line 4900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestMaxActorState();
		static_cast<TestMaxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi( cx, self, MutationRef::Max, key, [](uint64_t val1, uint64_t val2) { return val1 > val2 ? val1 : val2; });
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestMaxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestMaxActor*>(this)->actor_wait_state = 2;
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestMaxActor, 1, Void >*>(static_cast<TestMaxActor*>(this)));
															#line 4930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi( cx, self, MutationRef::Max, key, [](uint64_t val1, uint64_t val2) { return val1 > val2 ? val1 : val2; });
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestMaxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestMaxActor*>(this)->actor_wait_state = 2;
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestMaxActor, 1, Void >*>(static_cast<TestMaxActor*>(this)));
															#line 4946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestMaxActor*>(this)->actor_wait_state > 0) static_cast<TestMaxActor*>(this)->actor_wait_state = 0;
		static_cast<TestMaxActor*>(this)->ActorCallback< TestMaxActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMaxActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMax", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMax", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestMaxActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMax", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMax", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestMaxActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMax", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMax", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue( cx, self, MutationRef::Max, key, [](Value v1, Value v2) -> Value { return v2.size() ? v2 : StringRef(); });
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestMaxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestMaxActor*>(this)->actor_wait_state = 3;
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestMaxActor, 2, Void >*>(static_cast<TestMaxActor*>(this)));
															#line 5037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue( cx, self, MutationRef::Max, key, [](Value v1, Value v2) -> Value { return v2.size() ? v2 : StringRef(); });
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestMaxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestMaxActor*>(this)->actor_wait_state = 3;
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestMaxActor, 2, Void >*>(static_cast<TestMaxActor*>(this)));
															#line 5053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestMaxActor*>(this)->actor_wait_state > 0) static_cast<TestMaxActor*>(this)->actor_wait_state = 0;
		static_cast<TestMaxActor*>(this)->ActorCallback< TestMaxActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMaxActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMax", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMax", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestMaxActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMax", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMax", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestMaxActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMax", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMax", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestMaxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestMaxActorState(); static_cast<TestMaxActor*>(this)->destroy(); return 0; }
															#line 5137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestMaxActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestMaxActorState();
		static_cast<TestMaxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestMaxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestMaxActorState(); static_cast<TestMaxActor*>(this)->destroy(); return 0; }
															#line 5149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestMaxActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestMaxActorState();
		static_cast<TestMaxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestMaxActor*>(this)->actor_wait_state > 0) static_cast<TestMaxActor*>(this)->actor_wait_state = 0;
		static_cast<TestMaxActor*>(this)->ActorCallback< TestMaxActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMaxActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMax", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMax", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestMaxActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMax", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMax", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestMaxActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMax", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMax", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Database cx;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	AtomicOpsApiCorrectnessWorkload* self;
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Key key;
															#line 5238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testMax()
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestMaxActor final : public Actor<Void>, public ActorCallback< TestMaxActor, 0, Void >, public ActorCallback< TestMaxActor, 1, Void >, public ActorCallback< TestMaxActor, 2, Void >, public FastAllocated<TestMaxActor>, public TestMaxActorState<TestMaxActor> {
															#line 5243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestMaxActor>::operator new;
	using FastAllocated<TestMaxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14785269017367372800UL, 6509132881491106048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestMaxActor, 0, Void >;
friend struct ActorCallback< TestMaxActor, 1, Void >;
friend struct ActorCallback< TestMaxActor, 2, Void >;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestMaxActor(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 5262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestMaxActorState<TestMaxActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testMax", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10730056163875362304UL, 6115778345380380928UL);
		ActorExecutionContextHelper __helper(static_cast<TestMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testMax");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testMax", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestMaxActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestMaxActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestMaxActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testMax( Database const& cx, AtomicOpsApiCorrectnessWorkload* const& self ) {
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	return Future<Void>(new TestMaxActor(cx, self));
															#line 5296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
}

#line 524 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"

																#line 5301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testAnd()
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
template <class TestAndActor>
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestAndActorState {
															#line 5307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestAndActorState(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   self(self),
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   currentApiVersion(getApiVersion(cx)),
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   key(self->getTestKey("test_key_and_"))
															#line 5320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testAnd", reinterpret_cast<unsigned long>(this));

	}
	~TestAndActorState() 
	{
		fdb_probe_actor_destroy("testAnd", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent("AtomicOpCorrectnessApiWorkload").detail("OpType", "AND");
															#line 531 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			setApiVersion(&cx, 500);
															#line 532 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevInfo, "Running Atomic Op AND Correctness Test Api Version 500").log();
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->testAtomicOpUnsetOnNonExistingKey(cx, self, MutationRef::And, key);
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAndActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAndActor*>(this)->actor_wait_state = 1;
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAndActor, 0, Void >*>(static_cast<TestAndActor*>(this)));
															#line 5348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAndActorState();
		static_cast<TestAndActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi( cx, self, MutationRef::And, key, [](uint64_t val1, uint64_t val2) { return val1 & val2; });
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAndActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAndActor*>(this)->actor_wait_state = 2;
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAndActor, 1, Void >*>(static_cast<TestAndActor*>(this)));
															#line 5378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi( cx, self, MutationRef::And, key, [](uint64_t val1, uint64_t val2) { return val1 & val2; });
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAndActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAndActor*>(this)->actor_wait_state = 2;
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAndActor, 1, Void >*>(static_cast<TestAndActor*>(this)));
															#line 5394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAndActor*>(this)->actor_wait_state > 0) static_cast<TestAndActor*>(this)->actor_wait_state = 0;
		static_cast<TestAndActor*>(this)->ActorCallback< TestAndActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAndActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAndActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAndActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue(cx, self, MutationRef::And, key, [](Value v1, Value v2) -> Value { uint64_t zeroVal = 0; if (v2.size() == 0) return StringRef(); else return StringRef((const uint8_t*)&zeroVal, sizeof(zeroVal)); });
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAndActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAndActor*>(this)->actor_wait_state = 3;
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAndActor, 2, Void >*>(static_cast<TestAndActor*>(this)));
															#line 5485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue(cx, self, MutationRef::And, key, [](Value v1, Value v2) -> Value { uint64_t zeroVal = 0; if (v2.size() == 0) return StringRef(); else return StringRef((const uint8_t*)&zeroVal, sizeof(zeroVal)); });
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAndActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAndActor*>(this)->actor_wait_state = 3;
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAndActor, 2, Void >*>(static_cast<TestAndActor*>(this)));
															#line 5501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAndActor*>(this)->actor_wait_state > 0) static_cast<TestAndActor*>(this)->actor_wait_state = 0;
		static_cast<TestAndActor*>(this)->ActorCallback< TestAndActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAndActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAndActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAndActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		setApiVersion(&cx, currentApiVersion);
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		TraceEvent(SevInfo, "Running Atomic Op AND Correctness Current Api Version") .detail("Version", currentApiVersion);
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->testAtomicOpSetOnNonExistingKey(cx, self, MutationRef::And, key);
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAndActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAndActor*>(this)->actor_wait_state = 4;
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAndActor, 3, Void >*>(static_cast<TestAndActor*>(this)));
															#line 5596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		setApiVersion(&cx, currentApiVersion);
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		TraceEvent(SevInfo, "Running Atomic Op AND Correctness Current Api Version") .detail("Version", currentApiVersion);
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->testAtomicOpSetOnNonExistingKey(cx, self, MutationRef::And, key);
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAndActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAndActor*>(this)->actor_wait_state = 4;
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAndActor, 3, Void >*>(static_cast<TestAndActor*>(this)));
															#line 5616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAndActor*>(this)->actor_wait_state > 0) static_cast<TestAndActor*>(this)->actor_wait_state = 0;
		static_cast<TestAndActor*>(this)->ActorCallback< TestAndActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAndActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAndActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAndActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->testAtomicOpApi( cx, self, MutationRef::And, key, [](uint64_t val1, uint64_t val2) { return val1 & val2; });
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAndActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestAndActor*>(this)->actor_wait_state = 5;
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestAndActor, 4, Void >*>(static_cast<TestAndActor*>(this)));
															#line 5707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->testAtomicOpApi( cx, self, MutationRef::And, key, [](uint64_t val1, uint64_t val2) { return val1 & val2; });
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAndActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestAndActor*>(this)->actor_wait_state = 5;
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestAndActor, 4, Void >*>(static_cast<TestAndActor*>(this)));
															#line 5723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestAndActor*>(this)->actor_wait_state > 0) static_cast<TestAndActor*>(this)->actor_wait_state = 0;
		static_cast<TestAndActor*>(this)->ActorCallback< TestAndActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAndActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestAndActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestAndActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 551 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->testAtomicOpOnEmptyValue(cx, self, MutationRef::And, key, [](Value v1, Value v2) -> Value { uint64_t zeroVal = 0; if (v2.size() == 0) return StringRef(); else return StringRef((const uint8_t*)&zeroVal, sizeof(zeroVal)); });
															#line 551 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAndActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestAndActor*>(this)->actor_wait_state = 6;
															#line 551 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestAndActor, 5, Void >*>(static_cast<TestAndActor*>(this)));
															#line 5814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 551 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->testAtomicOpOnEmptyValue(cx, self, MutationRef::And, key, [](Value v1, Value v2) -> Value { uint64_t zeroVal = 0; if (v2.size() == 0) return StringRef(); else return StringRef((const uint8_t*)&zeroVal, sizeof(zeroVal)); });
															#line 551 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAndActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestAndActor*>(this)->actor_wait_state = 6;
															#line 551 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestAndActor, 5, Void >*>(static_cast<TestAndActor*>(this)));
															#line 5830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestAndActor*>(this)->actor_wait_state > 0) static_cast<TestAndActor*>(this)->actor_wait_state = 0;
		static_cast<TestAndActor*>(this)->ActorCallback< TestAndActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAndActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestAndActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestAndActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestAndActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAndActorState(); static_cast<TestAndActor*>(this)->destroy(); return 0; }
															#line 5914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestAndActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAndActorState();
		static_cast<TestAndActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestAndActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAndActorState(); static_cast<TestAndActor*>(this)->destroy(); return 0; }
															#line 5926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestAndActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAndActorState();
		static_cast<TestAndActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestAndActor*>(this)->actor_wait_state > 0) static_cast<TestAndActor*>(this)->actor_wait_state = 0;
		static_cast<TestAndActor*>(this)->ActorCallback< TestAndActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAndActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestAndActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestAndActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Database cx;
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	AtomicOpsApiCorrectnessWorkload* self;
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	int currentApiVersion;
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Key key;
															#line 6017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testAnd()
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestAndActor final : public Actor<Void>, public ActorCallback< TestAndActor, 0, Void >, public ActorCallback< TestAndActor, 1, Void >, public ActorCallback< TestAndActor, 2, Void >, public ActorCallback< TestAndActor, 3, Void >, public ActorCallback< TestAndActor, 4, Void >, public ActorCallback< TestAndActor, 5, Void >, public FastAllocated<TestAndActor>, public TestAndActorState<TestAndActor> {
															#line 6022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestAndActor>::operator new;
	using FastAllocated<TestAndActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6021049266092032256UL, 8924918889313317376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAndActor, 0, Void >;
friend struct ActorCallback< TestAndActor, 1, Void >;
friend struct ActorCallback< TestAndActor, 2, Void >;
friend struct ActorCallback< TestAndActor, 3, Void >;
friend struct ActorCallback< TestAndActor, 4, Void >;
friend struct ActorCallback< TestAndActor, 5, Void >;
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestAndActor(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 6044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestAndActorState<TestAndActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAnd", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3271023133725865216UL, 8272864840269887488UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAnd");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAnd", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAndActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAndActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAndActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestAndActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestAndActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestAndActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testAnd( Database const& cx, AtomicOpsApiCorrectnessWorkload* const& self ) {
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	return Future<Void>(new TestAndActor(cx, self));
															#line 6081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
}

#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"

																#line 6086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testOr()
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
template <class TestOrActor>
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestOrActorState {
															#line 6092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestOrActorState(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   self(self),
															#line 563 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   key(self->getTestKey("test_key_or_"))
															#line 6103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testOr", reinterpret_cast<unsigned long>(this));

	}
	~TestOrActorState() 
	{
		fdb_probe_actor_destroy("testOr", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevInfo, "Running Atomic Op OR Correctness Current Api Version").log();
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->testAtomicOpSetOnNonExistingKey(cx, self, MutationRef::Or, key);
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestOrActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestOrActor*>(this)->actor_wait_state = 1;
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestOrActor, 0, Void >*>(static_cast<TestOrActor*>(this)));
															#line 6127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestOrActorState();
		static_cast<TestOrActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi( cx, self, MutationRef::Or, key, [](uint64_t val1, uint64_t val2) { return val1 | val2; });
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestOrActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestOrActor*>(this)->actor_wait_state = 2;
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestOrActor, 1, Void >*>(static_cast<TestOrActor*>(this)));
															#line 6157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi( cx, self, MutationRef::Or, key, [](uint64_t val1, uint64_t val2) { return val1 | val2; });
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestOrActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestOrActor*>(this)->actor_wait_state = 2;
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestOrActor, 1, Void >*>(static_cast<TestOrActor*>(this)));
															#line 6173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestOrActor*>(this)->actor_wait_state > 0) static_cast<TestOrActor*>(this)->actor_wait_state = 0;
		static_cast<TestOrActor*>(this)->ActorCallback< TestOrActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestOrActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testOr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testOr", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestOrActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testOr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testOr", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestOrActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testOr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testOr", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue( cx, self, MutationRef::Or, key, [](Value v1, Value v2) -> Value { return v2.size() ? v2 : StringRef(); });
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestOrActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestOrActor*>(this)->actor_wait_state = 3;
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestOrActor, 2, Void >*>(static_cast<TestOrActor*>(this)));
															#line 6264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue( cx, self, MutationRef::Or, key, [](Value v1, Value v2) -> Value { return v2.size() ? v2 : StringRef(); });
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestOrActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestOrActor*>(this)->actor_wait_state = 3;
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestOrActor, 2, Void >*>(static_cast<TestOrActor*>(this)));
															#line 6280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestOrActor*>(this)->actor_wait_state > 0) static_cast<TestOrActor*>(this)->actor_wait_state = 0;
		static_cast<TestOrActor*>(this)->ActorCallback< TestOrActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestOrActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testOr", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testOr", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestOrActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testOr", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testOr", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestOrActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testOr", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testOr", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestOrActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestOrActorState(); static_cast<TestOrActor*>(this)->destroy(); return 0; }
															#line 6364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestOrActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestOrActorState();
		static_cast<TestOrActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestOrActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestOrActorState(); static_cast<TestOrActor*>(this)->destroy(); return 0; }
															#line 6376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestOrActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestOrActorState();
		static_cast<TestOrActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestOrActor*>(this)->actor_wait_state > 0) static_cast<TestOrActor*>(this)->actor_wait_state = 0;
		static_cast<TestOrActor*>(this)->ActorCallback< TestOrActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestOrActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testOr", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testOr", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestOrActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testOr", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testOr", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestOrActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testOr", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testOr", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Database cx;
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	AtomicOpsApiCorrectnessWorkload* self;
															#line 563 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Key key;
															#line 6465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testOr()
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestOrActor final : public Actor<Void>, public ActorCallback< TestOrActor, 0, Void >, public ActorCallback< TestOrActor, 1, Void >, public ActorCallback< TestOrActor, 2, Void >, public FastAllocated<TestOrActor>, public TestOrActorState<TestOrActor> {
															#line 6470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestOrActor>::operator new;
	using FastAllocated<TestOrActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7833135433321779712UL, 12596628201647882240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestOrActor, 0, Void >;
friend struct ActorCallback< TestOrActor, 1, Void >;
friend struct ActorCallback< TestOrActor, 2, Void >;
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestOrActor(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 6489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestOrActorState<TestOrActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testOr", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16276005319567790336UL, 17499871102622434560UL);
		ActorExecutionContextHelper __helper(static_cast<TestOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testOr");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testOr", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestOrActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestOrActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestOrActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testOr( Database const& cx, AtomicOpsApiCorrectnessWorkload* const& self ) {
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	return Future<Void>(new TestOrActor(cx, self));
															#line 6523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
}

#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"

																#line 6528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testXor()
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
template <class TestXorActor>
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestXorActorState {
															#line 6534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestXorActorState(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   self(self),
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   key(self->getTestKey("test_key_xor_"))
															#line 6545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testXor", reinterpret_cast<unsigned long>(this));

	}
	~TestXorActorState() 
	{
		fdb_probe_actor_destroy("testXor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevInfo, "Running Atomic Op XOR Correctness Current Api Version").log();
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->testAtomicOpSetOnNonExistingKey(cx, self, MutationRef::Xor, key);
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestXorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestXorActor*>(this)->actor_wait_state = 1;
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestXorActor, 0, Void >*>(static_cast<TestXorActor*>(this)));
															#line 6569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestXorActorState();
		static_cast<TestXorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi( cx, self, MutationRef::Xor, key, [](uint64_t val1, uint64_t val2) { return val1 ^ val2; });
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestXorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestXorActor*>(this)->actor_wait_state = 2;
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestXorActor, 1, Void >*>(static_cast<TestXorActor*>(this)));
															#line 6599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi( cx, self, MutationRef::Xor, key, [](uint64_t val1, uint64_t val2) { return val1 ^ val2; });
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestXorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestXorActor*>(this)->actor_wait_state = 2;
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestXorActor, 1, Void >*>(static_cast<TestXorActor*>(this)));
															#line 6615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestXorActor*>(this)->actor_wait_state > 0) static_cast<TestXorActor*>(this)->actor_wait_state = 0;
		static_cast<TestXorActor*>(this)->ActorCallback< TestXorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestXorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testXor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestXorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testXor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestXorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testXor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestXorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testXor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestXorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testXor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestXorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testXor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue( cx, self, MutationRef::Xor, key, [](Value v1, Value v2) -> Value { return v2.size() ? v2 : StringRef(); });
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestXorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestXorActor*>(this)->actor_wait_state = 3;
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestXorActor, 2, Void >*>(static_cast<TestXorActor*>(this)));
															#line 6706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue( cx, self, MutationRef::Xor, key, [](Value v1, Value v2) -> Value { return v2.size() ? v2 : StringRef(); });
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestXorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestXorActor*>(this)->actor_wait_state = 3;
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestXorActor, 2, Void >*>(static_cast<TestXorActor*>(this)));
															#line 6722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestXorActor*>(this)->actor_wait_state > 0) static_cast<TestXorActor*>(this)->actor_wait_state = 0;
		static_cast<TestXorActor*>(this)->ActorCallback< TestXorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestXorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testXor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestXorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testXor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestXorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testXor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestXorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testXor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestXorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testXor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestXorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testXor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestXorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestXorActorState(); static_cast<TestXorActor*>(this)->destroy(); return 0; }
															#line 6806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestXorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestXorActorState();
		static_cast<TestXorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestXorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestXorActorState(); static_cast<TestXorActor*>(this)->destroy(); return 0; }
															#line 6818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestXorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestXorActorState();
		static_cast<TestXorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestXorActor*>(this)->actor_wait_state > 0) static_cast<TestXorActor*>(this)->actor_wait_state = 0;
		static_cast<TestXorActor*>(this)->ActorCallback< TestXorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestXorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testXor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestXorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testXor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestXorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testXor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestXorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testXor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestXorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testXor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestXorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testXor", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Database cx;
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	AtomicOpsApiCorrectnessWorkload* self;
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Key key;
															#line 6907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testXor()
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestXorActor final : public Actor<Void>, public ActorCallback< TestXorActor, 0, Void >, public ActorCallback< TestXorActor, 1, Void >, public ActorCallback< TestXorActor, 2, Void >, public FastAllocated<TestXorActor>, public TestXorActorState<TestXorActor> {
															#line 6912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestXorActor>::operator new;
	using FastAllocated<TestXorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13660118701452177152UL, 13711809585738889472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestXorActor, 0, Void >;
friend struct ActorCallback< TestXorActor, 1, Void >;
friend struct ActorCallback< TestXorActor, 2, Void >;
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestXorActor(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 6931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestXorActorState<TestXorActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testXor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14476523455750279680UL, 16548962851218027008UL);
		ActorExecutionContextHelper __helper(static_cast<TestXorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testXor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testXor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestXorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestXorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestXorActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testXor( Database const& cx, AtomicOpsApiCorrectnessWorkload* const& self ) {
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	return Future<Void>(new TestXorActor(cx, self));
															#line 6965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
}

#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"

																#line 6970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testAdd()
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
template <class TestAddActor>
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestAddActorState {
															#line 6976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestAddActorState(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   self(self),
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   key(self->getTestKey("test_key_add_"))
															#line 6987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testAdd", reinterpret_cast<unsigned long>(this));

	}
	~TestAddActorState() 
	{
		fdb_probe_actor_destroy("testAdd", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevInfo, "Running Atomic Op ADD Correctness Current Api Version").log();
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->testAtomicOpSetOnNonExistingKey(cx, self, MutationRef::AddValue, key);
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestAddActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAddActor*>(this)->actor_wait_state = 1;
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAddActor, 0, Void >*>(static_cast<TestAddActor*>(this)));
															#line 7011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAddActorState();
		static_cast<TestAddActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi( cx, self, MutationRef::AddValue, key, [](uint64_t val1, uint64_t val2) { return val1 + val2; });
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAddActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAddActor*>(this)->actor_wait_state = 2;
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAddActor, 1, Void >*>(static_cast<TestAddActor*>(this)));
															#line 7041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi( cx, self, MutationRef::AddValue, key, [](uint64_t val1, uint64_t val2) { return val1 + val2; });
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAddActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAddActor*>(this)->actor_wait_state = 2;
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAddActor, 1, Void >*>(static_cast<TestAddActor*>(this)));
															#line 7057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAddActor*>(this)->actor_wait_state > 0) static_cast<TestAddActor*>(this)->actor_wait_state = 0;
		static_cast<TestAddActor*>(this)->ActorCallback< TestAddActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAddActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAdd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAdd", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAddActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAdd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAdd", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAddActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAdd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAdd", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue(cx, self, MutationRef::AddValue, key, [](Value v1, Value v2) -> Value { return v2.size() ? v2 : StringRef(); });
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAddActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAddActor*>(this)->actor_wait_state = 3;
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAddActor, 2, Void >*>(static_cast<TestAddActor*>(this)));
															#line 7148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue(cx, self, MutationRef::AddValue, key, [](Value v1, Value v2) -> Value { return v2.size() ? v2 : StringRef(); });
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestAddActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAddActor*>(this)->actor_wait_state = 3;
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAddActor, 2, Void >*>(static_cast<TestAddActor*>(this)));
															#line 7164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAddActor*>(this)->actor_wait_state > 0) static_cast<TestAddActor*>(this)->actor_wait_state = 0;
		static_cast<TestAddActor*>(this)->ActorCallback< TestAddActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAddActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAdd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAdd", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAddActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAdd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAdd", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAddActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAdd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAdd", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestAddActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAddActorState(); static_cast<TestAddActor*>(this)->destroy(); return 0; }
															#line 7248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestAddActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAddActorState();
		static_cast<TestAddActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestAddActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAddActorState(); static_cast<TestAddActor*>(this)->destroy(); return 0; }
															#line 7260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestAddActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAddActorState();
		static_cast<TestAddActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAddActor*>(this)->actor_wait_state > 0) static_cast<TestAddActor*>(this)->actor_wait_state = 0;
		static_cast<TestAddActor*>(this)->ActorCallback< TestAddActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAddActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAdd", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAdd", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAddActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAdd", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAdd", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAddActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAdd", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAdd", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Database cx;
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	AtomicOpsApiCorrectnessWorkload* self;
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Key key;
															#line 7349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testAdd()
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestAddActor final : public Actor<Void>, public ActorCallback< TestAddActor, 0, Void >, public ActorCallback< TestAddActor, 1, Void >, public ActorCallback< TestAddActor, 2, Void >, public FastAllocated<TestAddActor>, public TestAddActorState<TestAddActor> {
															#line 7354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestAddActor>::operator new;
	using FastAllocated<TestAddActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1955210805708195328UL, 15059643314602283520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAddActor, 0, Void >;
friend struct ActorCallback< TestAddActor, 1, Void >;
friend struct ActorCallback< TestAddActor, 2, Void >;
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestAddActor(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 7373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestAddActorState<TestAddActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAdd", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5206481740494463744UL, 11614953897463976192UL);
		ActorExecutionContextHelper __helper(static_cast<TestAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAdd");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAdd", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAddActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAddActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAddActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testAdd( Database const& cx, AtomicOpsApiCorrectnessWorkload* const& self ) {
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	return Future<Void>(new TestAddActor(cx, self));
															#line 7407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
}

#line 600 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"

																#line 7412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testCompareAndClear()
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
template <class TestCompareAndClearActor>
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestCompareAndClearActorState {
															#line 7418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestCompareAndClearActorState(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   self(self),
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   key(self->getTestKey("test_key_compare_and_clear_"))
															#line 7429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testCompareAndClear", reinterpret_cast<unsigned long>(this));

	}
	~TestCompareAndClearActorState() 
	{
		fdb_probe_actor_destroy("testCompareAndClear", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevInfo, "Running Atomic Op COMPARE_AND_CLEAR Correctness Current Api Version").log();
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->testCompareAndClearAtomicOpApi(cx, self, key, true);
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestCompareAndClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestCompareAndClearActor*>(this)->actor_wait_state = 1;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCompareAndClearActor, 0, Void >*>(static_cast<TestCompareAndClearActor*>(this)));
															#line 7453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCompareAndClearActorState();
		static_cast<TestCompareAndClearActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testCompareAndClearAtomicOpApi(cx, self, key, false);
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestCompareAndClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCompareAndClearActor*>(this)->actor_wait_state = 2;
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCompareAndClearActor, 1, Void >*>(static_cast<TestCompareAndClearActor*>(this)));
															#line 7483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testCompareAndClearAtomicOpApi(cx, self, key, false);
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestCompareAndClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCompareAndClearActor*>(this)->actor_wait_state = 2;
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCompareAndClearActor, 1, Void >*>(static_cast<TestCompareAndClearActor*>(this)));
															#line 7499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCompareAndClearActor*>(this)->actor_wait_state > 0) static_cast<TestCompareAndClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompareAndClearActor*>(this)->ActorCallback< TestCompareAndClearActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompareAndClearActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompareAndClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCompareAndClearActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompareAndClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCompareAndClearActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompareAndClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClear", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 606 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestCompareAndClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCompareAndClearActorState(); static_cast<TestCompareAndClearActor*>(this)->destroy(); return 0; }
															#line 7583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestCompareAndClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCompareAndClearActorState();
		static_cast<TestCompareAndClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 606 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestCompareAndClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCompareAndClearActorState(); static_cast<TestCompareAndClearActor*>(this)->destroy(); return 0; }
															#line 7595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestCompareAndClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCompareAndClearActorState();
		static_cast<TestCompareAndClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCompareAndClearActor*>(this)->actor_wait_state > 0) static_cast<TestCompareAndClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompareAndClearActor*>(this)->ActorCallback< TestCompareAndClearActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompareAndClearActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompareAndClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCompareAndClearActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompareAndClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCompareAndClearActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompareAndClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompareAndClear", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Database cx;
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	AtomicOpsApiCorrectnessWorkload* self;
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Key key;
															#line 7684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testCompareAndClear()
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestCompareAndClearActor final : public Actor<Void>, public ActorCallback< TestCompareAndClearActor, 0, Void >, public ActorCallback< TestCompareAndClearActor, 1, Void >, public FastAllocated<TestCompareAndClearActor>, public TestCompareAndClearActorState<TestCompareAndClearActor> {
															#line 7689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestCompareAndClearActor>::operator new;
	using FastAllocated<TestCompareAndClearActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8260028363961878016UL, 1876700746374973440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCompareAndClearActor, 0, Void >;
friend struct ActorCallback< TestCompareAndClearActor, 1, Void >;
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestCompareAndClearActor(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 7707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestCompareAndClearActorState<TestCompareAndClearActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testCompareAndClear", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11602045052978814976UL, 3341281383402835712UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompareAndClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCompareAndClear");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCompareAndClear", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCompareAndClearActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCompareAndClearActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testCompareAndClear( Database const& cx, AtomicOpsApiCorrectnessWorkload* const& self ) {
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	return Future<Void>(new TestCompareAndClearActor(cx, self));
															#line 7740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
}

#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"

																#line 7745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testByteMin()
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
template <class TestByteMinActor>
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestByteMinActorState {
															#line 7751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestByteMinActorState(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   self(self),
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   key(self->getTestKey("test_key_byte_min_"))
															#line 7762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testByteMin", reinterpret_cast<unsigned long>(this));

	}
	~TestByteMinActorState() 
	{
		fdb_probe_actor_destroy("testByteMin", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevInfo, "Running Atomic Op BYTE_MIN Correctness Current Api Version").log();
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->testAtomicOpSetOnNonExistingKey(cx, self, MutationRef::ByteMin, key);
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestByteMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestByteMinActor*>(this)->actor_wait_state = 1;
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestByteMinActor, 0, Void >*>(static_cast<TestByteMinActor*>(this)));
															#line 7786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestByteMinActorState();
		static_cast<TestByteMinActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi(cx, self, MutationRef::ByteMin, key, [](uint64_t val1, uint64_t val2) { return StringRef((const uint8_t*)&val1, sizeof(val1)) < StringRef((const uint8_t*)&val2, sizeof(val2)) ? val1 : val2; });
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestByteMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestByteMinActor*>(this)->actor_wait_state = 2;
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestByteMinActor, 1, Void >*>(static_cast<TestByteMinActor*>(this)));
															#line 7816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi(cx, self, MutationRef::ByteMin, key, [](uint64_t val1, uint64_t val2) { return StringRef((const uint8_t*)&val1, sizeof(val1)) < StringRef((const uint8_t*)&val2, sizeof(val2)) ? val1 : val2; });
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestByteMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestByteMinActor*>(this)->actor_wait_state = 2;
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestByteMinActor, 1, Void >*>(static_cast<TestByteMinActor*>(this)));
															#line 7832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestByteMinActor*>(this)->actor_wait_state > 0) static_cast<TestByteMinActor*>(this)->actor_wait_state = 0;
		static_cast<TestByteMinActor*>(this)->ActorCallback< TestByteMinActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestByteMinActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testByteMin", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMin", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestByteMinActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testByteMin", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMin", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestByteMinActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testByteMin", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMin", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue( cx, self, MutationRef::ByteMin, key, [](Value v1, Value v2) -> Value { return StringRef(); });
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestByteMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7918 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestByteMinActor*>(this)->actor_wait_state = 3;
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestByteMinActor, 2, Void >*>(static_cast<TestByteMinActor*>(this)));
															#line 7923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue( cx, self, MutationRef::ByteMin, key, [](Value v1, Value v2) -> Value { return StringRef(); });
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestByteMinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestByteMinActor*>(this)->actor_wait_state = 3;
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestByteMinActor, 2, Void >*>(static_cast<TestByteMinActor*>(this)));
															#line 7939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestByteMinActor*>(this)->actor_wait_state > 0) static_cast<TestByteMinActor*>(this)->actor_wait_state = 0;
		static_cast<TestByteMinActor*>(this)->ActorCallback< TestByteMinActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestByteMinActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testByteMin", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMin", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestByteMinActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testByteMin", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMin", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestByteMinActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testByteMin", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMin", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestByteMinActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestByteMinActorState(); static_cast<TestByteMinActor*>(this)->destroy(); return 0; }
															#line 8023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestByteMinActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestByteMinActorState();
		static_cast<TestByteMinActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestByteMinActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestByteMinActorState(); static_cast<TestByteMinActor*>(this)->destroy(); return 0; }
															#line 8035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestByteMinActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestByteMinActorState();
		static_cast<TestByteMinActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestByteMinActor*>(this)->actor_wait_state > 0) static_cast<TestByteMinActor*>(this)->actor_wait_state = 0;
		static_cast<TestByteMinActor*>(this)->ActorCallback< TestByteMinActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestByteMinActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testByteMin", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMin", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestByteMinActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testByteMin", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMin", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestByteMinActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testByteMin", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMin", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Database cx;
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	AtomicOpsApiCorrectnessWorkload* self;
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Key key;
															#line 8124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testByteMin()
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestByteMinActor final : public Actor<Void>, public ActorCallback< TestByteMinActor, 0, Void >, public ActorCallback< TestByteMinActor, 1, Void >, public ActorCallback< TestByteMinActor, 2, Void >, public FastAllocated<TestByteMinActor>, public TestByteMinActorState<TestByteMinActor> {
															#line 8129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestByteMinActor>::operator new;
	using FastAllocated<TestByteMinActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3075761696568285952UL, 346907792319290624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestByteMinActor, 0, Void >;
friend struct ActorCallback< TestByteMinActor, 1, Void >;
friend struct ActorCallback< TestByteMinActor, 2, Void >;
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestByteMinActor(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 8148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestByteMinActorState<TestByteMinActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testByteMin", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5148049341470845952UL, 15394687758895634944UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testByteMin");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testByteMin", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestByteMinActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestByteMinActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestByteMinActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testByteMin( Database const& cx, AtomicOpsApiCorrectnessWorkload* const& self ) {
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	return Future<Void>(new TestByteMinActor(cx, self));
															#line 8182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
}

#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"

																#line 8187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testByteMax()
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
template <class TestByteMaxActor>
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestByteMaxActorState {
															#line 8193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestByteMaxActorState(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   self(self),
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		   key(self->getTestKey("test_key_byte_max_"))
															#line 8204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testByteMax", reinterpret_cast<unsigned long>(this));

	}
	~TestByteMaxActorState() 
	{
		fdb_probe_actor_destroy("testByteMax", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			TraceEvent(SevInfo, "Running Atomic Op BYTE_MAX Correctness Current Api Version").log();
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->testAtomicOpSetOnNonExistingKey(cx, self, MutationRef::ByteMax, key);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			if (static_cast<TestByteMaxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestByteMaxActor*>(this)->actor_wait_state = 1;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestByteMaxActor, 0, Void >*>(static_cast<TestByteMaxActor*>(this)));
															#line 8228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestByteMaxActorState();
		static_cast<TestByteMaxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi(cx, self, MutationRef::ByteMax, key, [](uint64_t val1, uint64_t val2) { return StringRef((const uint8_t*)&val1, sizeof(val1)) > StringRef((const uint8_t*)&val2, sizeof(val2)) ? val1 : val2; });
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestByteMaxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestByteMaxActor*>(this)->actor_wait_state = 2;
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestByteMaxActor, 1, Void >*>(static_cast<TestByteMaxActor*>(this)));
															#line 8258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testAtomicOpApi(cx, self, MutationRef::ByteMax, key, [](uint64_t val1, uint64_t val2) { return StringRef((const uint8_t*)&val1, sizeof(val1)) > StringRef((const uint8_t*)&val2, sizeof(val2)) ? val1 : val2; });
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestByteMaxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestByteMaxActor*>(this)->actor_wait_state = 2;
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestByteMaxActor, 1, Void >*>(static_cast<TestByteMaxActor*>(this)));
															#line 8274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestByteMaxActor*>(this)->actor_wait_state > 0) static_cast<TestByteMaxActor*>(this)->actor_wait_state = 0;
		static_cast<TestByteMaxActor*>(this)->ActorCallback< TestByteMaxActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestByteMaxActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testByteMax", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMax", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestByteMaxActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testByteMax", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMax", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestByteMaxActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testByteMax", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMax", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue( cx, self, MutationRef::ByteMax, key, [](Value v1, Value v2) -> Value { return v1.size() ? v1 : v2; });
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestByteMaxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestByteMaxActor*>(this)->actor_wait_state = 3;
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestByteMaxActor, 2, Void >*>(static_cast<TestByteMaxActor*>(this)));
															#line 8365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAtomicOpOnEmptyValue( cx, self, MutationRef::ByteMax, key, [](Value v1, Value v2) -> Value { return v1.size() ? v1 : v2; });
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (static_cast<TestByteMaxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestByteMaxActor*>(this)->actor_wait_state = 3;
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestByteMaxActor, 2, Void >*>(static_cast<TestByteMaxActor*>(this)));
															#line 8381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestByteMaxActor*>(this)->actor_wait_state > 0) static_cast<TestByteMaxActor*>(this)->actor_wait_state = 0;
		static_cast<TestByteMaxActor*>(this)->ActorCallback< TestByteMaxActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestByteMaxActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testByteMax", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMax", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestByteMaxActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testByteMax", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMax", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestByteMaxActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testByteMax", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMax", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestByteMaxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestByteMaxActorState(); static_cast<TestByteMaxActor*>(this)->destroy(); return 0; }
															#line 8465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestByteMaxActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestByteMaxActorState();
		static_cast<TestByteMaxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
		if (!static_cast<TestByteMaxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestByteMaxActorState(); static_cast<TestByteMaxActor*>(this)->destroy(); return 0; }
															#line 8477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestByteMaxActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestByteMaxActorState();
		static_cast<TestByteMaxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestByteMaxActor*>(this)->actor_wait_state > 0) static_cast<TestByteMaxActor*>(this)->actor_wait_state = 0;
		static_cast<TestByteMaxActor*>(this)->ActorCallback< TestByteMaxActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestByteMaxActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testByteMax", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMax", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestByteMaxActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testByteMax", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMax", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestByteMaxActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testByteMax", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testByteMax", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Database cx;
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	AtomicOpsApiCorrectnessWorkload* self;
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	Key key;
															#line 8566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testByteMax()
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
class TestByteMaxActor final : public Actor<Void>, public ActorCallback< TestByteMaxActor, 0, Void >, public ActorCallback< TestByteMaxActor, 1, Void >, public ActorCallback< TestByteMaxActor, 2, Void >, public FastAllocated<TestByteMaxActor>, public TestByteMaxActorState<TestByteMaxActor> {
															#line 8571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestByteMaxActor>::operator new;
	using FastAllocated<TestByteMaxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16832377435566920192UL, 18238389001317703424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestByteMaxActor, 0, Void >;
friend struct ActorCallback< TestByteMaxActor, 1, Void >;
friend struct ActorCallback< TestByteMaxActor, 2, Void >;
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	TestByteMaxActor(Database const& cx,AtomicOpsApiCorrectnessWorkload* const& self) 
															#line 8590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestByteMaxActorState<TestByteMaxActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testByteMax", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9486291036541896704UL, 17344398860951114240UL);
		ActorExecutionContextHelper __helper(static_cast<TestByteMaxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testByteMax");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testByteMax", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestByteMaxActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestByteMaxActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestByteMaxActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testByteMax( Database const& cx, AtomicOpsApiCorrectnessWorkload* const& self ) {
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
	return Future<Void>(new TestByteMaxActor(cx, self));
															#line 8624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/AtomicOpsApiCorrectness.actor.g.cpp.py_gen"
}

#line 640 "/Users/ec2-user/foundationdb/fdbserver/workloads/AtomicOpsApiCorrectness.actor.cpp"
};

WorkloadFactory<AtomicOpsApiCorrectnessWorkload> AtomicOpsApiCorrectnessWorkloadFactory;
