#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
/*
 * ApiCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBTypes.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/QuietDatabase.h"

#include "fdbserver/MutationTracking.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/ApiWorkload.h"
#include "fdbserver/workloads/MemoryKeyValueStore.h"
#include "flow/IRandom.h"
#include "flow/actorcompiler.h" // This must be the last #include.
#include "flow/genericactors.actor.h"

// Valdiate at-rest encryption guarantees. If enabled, test injects a known 'marker' in Key and/or Values
// inserted into FDB by the workload. On shutdown, all test generated files (under simfdb/) can scanned to find if
// 'plaintext marker' is present.
const std::string ENCRYPTION_AT_REST_MARKER_STRING = "Expecto..Patronum...";

// An enum of API operation types used in the random test
enum OperationType { SET, GET, GET_RANGE, GET_RANGE_SELECTOR, GET_KEY, CLEAR, CLEAR_RANGE, UNINITIALIZED };

// A workload that executes the NativeAPIs functions and verifies that their outcomes are correct
struct ApiCorrectnessWorkload : ApiWorkload {
	static constexpr auto NAME = "ApiCorrectness";

private:
// Enable to track the activity on a particular key
#if CENABLED(0, NOT_IN_CLEAN)
#define targetKey "???"_sr

	void debugKey(KeyRef key, std::string context) {
		if (key == targetKey)
			TraceEvent("ApiCorrectnessDebugKey").detail("Context", context).detail("Key", printable(key));
	}

	void debugKey(KeyRangeRef keyRange, std::string context) {
		if (keyRange.contains(targetKey))
			TraceEvent("ApiCorrectnessDebugKey")
			    .detail("Context", context)
			    .detail("Key", printable(targetKey))
			    .detail("RangeBegin", printable(keyRange.begin))
			    .detail("RangeEnd", printable(keyRange.end));
	}

#else
	void debugKey(KeyRef key, std::string context) {}
	void debugKey(KeyRangeRef keyRange, std::string context) {}

#endif

public:
	// The number of gets that should be performed
	int numGets;

	// The number of getRanges that should be performed
	int numGetRanges;

	// The number of getRanges using key selectors that should be performed
	int numGetRangeSelectors;

	// The number of getKeys that should be performed
	int numGetKeys;

	// The number of clears that should be performed
	int numClears;

	// The number of clears using key ranges that should be performed
	int numClearRanges;

	// The smallest legal size of the database after a clear.  A smaller size will trigger a database reset
	int minSizeAfterClear;

	// The maximum number of keys that can be in this client's key space when performing the random test
	int maxRandomTestKeys;

	// The amount of time to run the random tests
	double randomTestDuration;

	// The maximum number of keys operated on in a transaction; used to prevent transaction_too_old errors
	int maxKeysPerTransaction;

	// The number of API calls made by the random test
	PerfIntCounter numRandomOperations;

	// The API being used by this client
	TransactionType transactionType;

	// Maximum time to reset DB to the original state
	double resetDBTimeout;

	// Validate data at-rest encryption guarantees
	int validateEncryptionAtRest;

	ApiCorrectnessWorkload(WorkloadContext const& wcx)
	  : ApiWorkload(wcx), numRandomOperations("Num Random Operations") {
		numGets = getOption(options, "numGets"_sr, 1000);
		numGetRanges = getOption(options, "numGetRanges"_sr, 100);
		numGetRangeSelectors = getOption(options, "numGetRangeSelectors"_sr, 100);
		numGetKeys = getOption(options, "numGetKeys"_sr, 100);
		numClears = getOption(options, "numClears"_sr, 100);
		numClearRanges = getOption(options, "numClearRanges"_sr, 100);
		minSizeAfterClear = getOption(options, "minSizeAfterClear"_sr, (int)(0.1 * numKeys));

		maxRandomTestKeys = getOption(options, "maxRandomTestKeys"_sr, numKeys);
		randomTestDuration = getOption(options, "randomTestDuration"_sr, 60.0);

		int maxTransactionBytes = getOption(options, "maxTransactionBytes"_sr, 500000);
		maxKeysPerTransaction = std::max(1, maxTransactionBytes / (maxValueLength + maxLongKeyLength));

		validateEncryptionAtRest =
		    g_network->isSimulated()
		        ? getOption(options, "validateEncryptionAtRest"_sr, deterministicRandom()->coinflip() ? 1 : 0)
		        : 0;

		resetDBTimeout = getOption(options, "resetDBTimeout"_sr, 1800.0);

		if (maxTransactionBytes > 500000) {
			TraceEvent("RemapEventSeverity")
			    .detail("TargetEvent", "LargePacketSent")
			    .detail("OriginalSeverity", SevWarnAlways)
			    .detail("NewSeverity", SevInfo);
			TraceEvent("RemapEventSeverity")
			    .detail("TargetEvent", "LargePacketReceived")
			    .detail("OriginalSeverity", SevWarnAlways)
			    .detail("NewSeverity", SevInfo);
			TraceEvent("RemapEventSeverity")
			    .detail("TargetEvent", "LargeTransaction")
			    .detail("OriginalSeverity", SevWarnAlways)
			    .detail("NewSeverity", SevInfo);
			TraceEvent("RemapEventSeverity")
			    .detail("TargetEvent", "DiskQueueMemoryWarning")
			    .detail("OriginalSeverity", SevWarnAlways)
			    .detail("NewSeverity", SevInfo);
		}
	}

	~ApiCorrectnessWorkload() override {}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.emplace_back("Number of Random Operations Performed", numRandomOperations.getValue(), Averaged::False);
	}

																#line 165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via performSetup()
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class PerformSetupActor>
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class PerformSetupActorState {
															#line 171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	PerformSetupActorState(Database const& cx,ApiCorrectnessWorkload* const& self) 
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self)
															#line 180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("performSetup", reinterpret_cast<unsigned long>(this));

	}
	~PerformSetupActorState() 
	{
		fdb_probe_actor_destroy("performSetup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<PerformSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PerformSetupActor*>(this)->actor_wait_state = 1;
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >*>(static_cast<PerformSetupActor*>(this)));
															#line 202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PerformSetupActorState();
		static_cast<PerformSetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(DatabaseConfiguration const& dbConfig,int loopDepth) 
	{
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (g_network->isSimulated() && dbConfig.encryptionAtRestMode.isEncryptionEnabled() && self->validateEncryptionAtRest)
															#line 225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			TraceEvent("EncryptionAtRestPlainTextMarkerCheckEnabled") .detail("EncryptionMode", dbConfig.encryptionAtRestMode.toString()) .detail("DataAtRestMarker", ENCRYPTION_AT_REST_MARKER_STRING);
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			g_simulator->dataAtRestPlaintextMarker = ENCRYPTION_AT_REST_MARKER_STRING;
															#line 231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		std::vector<TransactionType> types;
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(NATIVE);
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(READ_YOUR_WRITES);
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(THREAD_SAFE);
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(MULTI_VERSION);
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->chooseTransactionFactory(cx, types);
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<PerformSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PerformSetupActor*>(this)->actor_wait_state = 2;
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PerformSetupActor, 1, Void >*>(static_cast<PerformSetupActor*>(this)));
															#line 252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(DatabaseConfiguration && dbConfig,int loopDepth) 
	{
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (g_network->isSimulated() && dbConfig.encryptionAtRestMode.isEncryptionEnabled() && self->validateEncryptionAtRest)
															#line 261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			TraceEvent("EncryptionAtRestPlainTextMarkerCheckEnabled") .detail("EncryptionMode", dbConfig.encryptionAtRestMode.toString()) .detail("DataAtRestMarker", ENCRYPTION_AT_REST_MARKER_STRING);
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			g_simulator->dataAtRestPlaintextMarker = ENCRYPTION_AT_REST_MARKER_STRING;
															#line 267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		std::vector<TransactionType> types;
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(NATIVE);
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(READ_YOUR_WRITES);
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(THREAD_SAFE);
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(MULTI_VERSION);
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->chooseTransactionFactory(cx, types);
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<PerformSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PerformSetupActor*>(this)->actor_wait_state = 2;
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PerformSetupActor, 1, Void >*>(static_cast<PerformSetupActor*>(this)));
															#line 288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& dbConfig,int loopDepth) 
	{
		loopDepth = a_body1cont1(dbConfig, loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && dbConfig,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(dbConfig), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PerformSetupActor*>(this)->actor_wait_state > 0) static_cast<PerformSetupActor*>(this)->actor_wait_state = 0;
		static_cast<PerformSetupActor*>(this)->ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<PerformSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformSetupActorState(); static_cast<PerformSetupActor*>(this)->destroy(); return 0; }
															#line 372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<PerformSetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerformSetupActorState();
		static_cast<PerformSetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<PerformSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformSetupActorState(); static_cast<PerformSetupActor*>(this)->destroy(); return 0; }
															#line 384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<PerformSetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerformSetupActorState();
		static_cast<PerformSetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PerformSetupActor*>(this)->actor_wait_state > 0) static_cast<PerformSetupActor*>(this)->actor_wait_state = 0;
		static_cast<PerformSetupActor*>(this)->ActorCallback< PerformSetupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerformSetupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PerformSetupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PerformSetupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Database cx;
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via performSetup()
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class PerformSetupActor final : public Actor<Void>, public ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >, public ActorCallback< PerformSetupActor, 1, Void >, public FastAllocated<PerformSetupActor>, public PerformSetupActorState<PerformSetupActor> {
															#line 476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<PerformSetupActor>::operator new;
	using FastAllocated<PerformSetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11214056036744822528UL, 6895659768799025920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< PerformSetupActor, 1, Void >;
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	PerformSetupActor(Database const& cx,ApiCorrectnessWorkload* const& self) 
															#line 494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PerformSetupActorState<PerformSetupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(908050500225728256UL, 2892666575110672640UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("performSetup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PerformSetupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> performSetup( Database const& cx, ApiCorrectnessWorkload* const& self ) {
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<Void>(new PerformSetupActor(cx, self));
															#line 527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
}

#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	Future<Void> performSetup(Database const& cx) override { return performSetup(cx, this); }

																#line 534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via performTest()
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class PerformTestActor>
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class PerformTestActorState {
															#line 540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	PerformTestActorState(Database const& cx,Standalone<VectorRef<KeyValueRef>> const& data,ApiCorrectnessWorkload* const& self) 
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   data(data),
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self)
															#line 551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("performTest", reinterpret_cast<unsigned long>(this));

	}
	~PerformTestActorState() 
	{
		fdb_probe_actor_destroy("performTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(self->runScriptedTest(self, data), 600, Void());
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<PerformTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PerformTestActor*>(this)->actor_wait_state = 1;
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PerformTestActor, 0, Void >*>(static_cast<PerformTestActor*>(this)));
															#line 573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PerformTestActorState();
		static_cast<PerformTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!self->hasFailed())
															#line 596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
			try {
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_1 = timeoutError(::success(self->runSet(data, self)), self->resetDBTimeout);
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (static_cast<PerformTestActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<PerformTestActor*>(this)->actor_wait_state = 2;
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PerformTestActor, 1, Void >*>(static_cast<PerformTestActor*>(this)));
															#line 608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!self->hasFailed())
															#line 628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
			try {
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_1 = timeoutError(::success(self->runSet(data, self)), self->resetDBTimeout);
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (static_cast<PerformTestActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<PerformTestActor*>(this)->actor_wait_state = 2;
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PerformTestActor, 1, Void >*>(static_cast<PerformTestActor*>(this)));
															#line 640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PerformTestActor*>(this)->actor_wait_state > 0) static_cast<PerformTestActor*>(this)->actor_wait_state = 0;
		static_cast<PerformTestActor*>(this)->ActorCallback< PerformTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PerformTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<PerformTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformTestActorState(); static_cast<PerformTestActor*>(this)->destroy(); return 0; }
															#line 735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<PerformTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerformTestActorState();
		static_cast<PerformTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = timeout(self->runRandomTest(self, data), self->randomTestDuration, Void());
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<PerformTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PerformTestActor*>(this)->actor_wait_state = 3;
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PerformTestActor, 2, Void >*>(static_cast<PerformTestActor*>(this)));
															#line 754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			{
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (!self->hasFailed())
															#line 768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				{
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					self->testFailure("Timeout during database reset");
															#line 772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				}
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (!static_cast<PerformTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformTestActorState(); static_cast<PerformTestActor*>(this)->destroy(); return 0; }
															#line 776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				new (&static_cast<PerformTestActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PerformTestActorState();
				static_cast<PerformTestActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PerformTestActor*>(this)->actor_wait_state > 0) static_cast<PerformTestActor*>(this)->actor_wait_state = 0;
		static_cast<PerformTestActor*>(this)->ActorCallback< PerformTestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PerformTestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PerformTestActor*>(this)->actor_wait_state > 0) static_cast<PerformTestActor*>(this)->actor_wait_state = 0;
		static_cast<PerformTestActor*>(this)->ActorCallback< PerformTestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PerformTestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Database cx;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> data;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via performTest()
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class PerformTestActor final : public Actor<Void>, public ActorCallback< PerformTestActor, 0, Void >, public ActorCallback< PerformTestActor, 1, Void >, public ActorCallback< PerformTestActor, 2, Void >, public FastAllocated<PerformTestActor>, public PerformTestActorState<PerformTestActor> {
															#line 992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<PerformTestActor>::operator new;
	using FastAllocated<PerformTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1013964547890766336UL, 14214958836144697088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PerformTestActor, 0, Void >;
friend struct ActorCallback< PerformTestActor, 1, Void >;
friend struct ActorCallback< PerformTestActor, 2, Void >;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	PerformTestActor(Database const& cx,Standalone<VectorRef<KeyValueRef>> const& data,ApiCorrectnessWorkload* const& self) 
															#line 1011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PerformTestActorState<PerformTestActor>(cx, data, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6826498282132105984UL, 12962792935105555968UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("performTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PerformTestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PerformTestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PerformTestActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> performTest( Database const& cx, Standalone<VectorRef<KeyValueRef>> const& data, ApiCorrectnessWorkload* const& self ) {
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<Void>(new PerformTestActor(cx, data, self));
															#line 1045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
}

#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	Future<Void> performTest(Database const& cx, Standalone<VectorRef<KeyValueRef>> const& data) override {
		return performTest(cx, data, this);
	}

	// Run a scripted set of API operations
																#line 1055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via runScriptedTest()
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunScriptedTestActor>
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunScriptedTestActorState {
															#line 1061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunScriptedTestActorState(ApiCorrectnessWorkload* const& self,VectorRef<KeyValueRef> const& data) 
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : self(self),
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   data(data)
															#line 1070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runScriptedTest", reinterpret_cast<unsigned long>(this));

	}
	~RunScriptedTestActorState() 
	{
		fdb_probe_actor_destroy("runScriptedTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<bool> __when_expr_0 = self->runSet(data, self);
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 1;
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 0, bool >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunScriptedTestActorState();
		static_cast<RunScriptedTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& setResult,int loopDepth) 
	{
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!setResult)
															#line 1115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 1119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = ::success(self->runGet(data, self->numGets, self));
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 2;
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 1, Void >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool && setResult,int loopDepth) 
	{
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!setResult)
															#line 1143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 1147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = ::success(self->runGet(data, self->numGets, self));
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 2;
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 1, Void >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& setResult,int loopDepth) 
	{
		loopDepth = a_body1cont1(setResult, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && setResult,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(setResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = int();
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = 0;
															#line 1248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = int();
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = 0;
															#line 1259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = 0;
															#line 1343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(i < self->numGetRanges))
															#line 1359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = ::success(self->runGetRange(data, self));
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 3;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 2, Void >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i++;
															#line 1394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i++;
															#line 1403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = ::success(self->runGetKey(data, self->numGetKeys, self));
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 5;
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 4, Void >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(i < self->numGetRangeSelectors))
															#line 1510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = ::success(self->runGetRangeSelector(data, self));
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 4;
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 3, Void >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i++;
															#line 1545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i++;
															#line 1554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_5 = self->runClear(data, self->numClears, self);
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 6;
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 5, bool >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_5 = self->runClear(data, self->numClears, self);
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 6;
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 5, bool >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(bool const& clearResult,int loopDepth) 
	{
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!clearResult)
															#line 1745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 1749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = 0;
															#line 1757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(bool && clearResult,int loopDepth) 
	{
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!clearResult)
															#line 1766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 1770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = 0;
															#line 1778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(bool const& clearResult,int loopDepth) 
	{
		loopDepth = a_body1cont7(clearResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(bool && clearResult,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(clearResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 1862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunScriptedTestActorState();
		static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1(int loopDepth) 
	{
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(i < self->numClearRanges))
															#line 1881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (self->store.size() < self->minSizeAfterClear)
															#line 1887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<bool> __when_expr_6 = self->runSet(data, self);
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1when1(__when_expr_6.get(), loopDepth); };
			static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 7;
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 6, bool >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(int loopDepth) 
	{
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_7 = self->runClearRange(data, self);
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1cont1when1(__when_expr_7.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 8;
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 7, bool >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopBody1cont3(bool const& resetResult,int loopDepth) 
	{
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!resetResult)
															#line 1941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 1945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont3(bool && resetResult,int loopDepth) 
	{
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!resetResult)
															#line 1959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 1963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(bool const& resetResult,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont3(resetResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(bool && resetResult,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont3(std::move(resetResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 6, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 6, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 6, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 6, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont7loopBody1cont6(bool const& clearRangeResults,int loopDepth) 
	{
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!clearRangeResults)
															#line 2052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 2056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i++;
															#line 2064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont6(bool && clearRangeResults,int loopDepth) 
	{
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!clearRangeResults)
															#line 2073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 2077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i++;
															#line 2085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1when1(bool const& clearRangeResults,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont6(clearRangeResults, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1when1(bool && clearRangeResults,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont6(std::move(clearRangeResults), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 7, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 7, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 7, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 7, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int i;
															#line 2171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runScriptedTest()
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunScriptedTestActor final : public Actor<Void>, public ActorCallback< RunScriptedTestActor, 0, bool >, public ActorCallback< RunScriptedTestActor, 1, Void >, public ActorCallback< RunScriptedTestActor, 2, Void >, public ActorCallback< RunScriptedTestActor, 3, Void >, public ActorCallback< RunScriptedTestActor, 4, Void >, public ActorCallback< RunScriptedTestActor, 5, bool >, public ActorCallback< RunScriptedTestActor, 6, bool >, public ActorCallback< RunScriptedTestActor, 7, bool >, public FastAllocated<RunScriptedTestActor>, public RunScriptedTestActorState<RunScriptedTestActor> {
															#line 2176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunScriptedTestActor>::operator new;
	using FastAllocated<RunScriptedTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5359734622254789632UL, 10724226325011502336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunScriptedTestActor, 0, bool >;
friend struct ActorCallback< RunScriptedTestActor, 1, Void >;
friend struct ActorCallback< RunScriptedTestActor, 2, Void >;
friend struct ActorCallback< RunScriptedTestActor, 3, Void >;
friend struct ActorCallback< RunScriptedTestActor, 4, Void >;
friend struct ActorCallback< RunScriptedTestActor, 5, bool >;
friend struct ActorCallback< RunScriptedTestActor, 6, bool >;
friend struct ActorCallback< RunScriptedTestActor, 7, bool >;
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunScriptedTestActor(ApiCorrectnessWorkload* const& self,VectorRef<KeyValueRef> const& data) 
															#line 2200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunScriptedTestActorState<RunScriptedTestActor>(self, data),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6987836142697489664UL, 13927679211788957952UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runScriptedTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunScriptedTestActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunScriptedTestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunScriptedTestActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunScriptedTestActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunScriptedTestActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunScriptedTestActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RunScriptedTestActor, 6, bool >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< RunScriptedTestActor, 7, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> runScriptedTest( ApiCorrectnessWorkload* const& self, VectorRef<KeyValueRef> const& data ) {
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<Void>(new RunScriptedTestActor(self, data));
															#line 2239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
}

#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Generate and execute a sequence of random operations
																#line 2245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via runRandomTest()
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunRandomTestActor>
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunRandomTestActorState {
															#line 2251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunRandomTestActorState(ApiCorrectnessWorkload* const& self,Standalone<VectorRef<KeyValueRef>> const& data) 
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : self(self),
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   data(data)
															#line 2260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runRandomTest", reinterpret_cast<unsigned long>(this));

	}
	~RunRandomTestActorState() 
	{
		fdb_probe_actor_destroy("runRandomTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 2275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunRandomTestActorState();
		static_cast<RunRandomTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		double setProbability = 1 - ((double)self->store.size()) / self->maxRandomTestKeys;
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		int pdfArray[] = { 0, (int)(100 * setProbability), 100, 50, 50, 20, (int)(100 * (1 - setProbability)), (int)(10 * (1 - setProbability)) };
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		std::vector<int> pdf = std::vector<int>(pdfArray, pdfArray + 8);
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		OperationType operation = UNINITIALIZED;
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		int totalDensity = 0;
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < pdf.size();i++) {
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			totalDensity += pdf[i];
															#line 2317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		int cumulativeDensity = 0;
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		int random = deterministicRandom()->randomInt(0, totalDensity);
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < pdf.size() - 1;i++) {
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (cumulativeDensity + pdf[i] <= random && random < cumulativeDensity + pdf[i] + pdf[i + 1])
															#line 2327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			{
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				operation = (OperationType)i;
															#line 2331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				break;
			}
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			cumulativeDensity += pdf[i];
															#line 2336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		ASSERT(operation != UNINITIALIZED);
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		++self->numRandomOperations;
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (operation == SET)
															#line 2344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			bool useShortKeys = deterministicRandom()->randomInt(0, 2) == 1;
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			int minKeyLength = useShortKeys ? self->minShortKeyLength : self->minLongKeyLength;
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			int maxKeyLength = useShortKeys ? self->maxShortKeyLength : self->maxLongKeyLength;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			newData = self->generateData(std::min((uint64_t)100, self->maxRandomTestKeys - self->store.size()), minKeyLength, maxKeyLength, self->minValueLength, self->maxValueLength, self->clientPrefix, true);
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			data.append_deep(data.arena(), newData.begin(), newData.size());
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<bool> __when_expr_0 = self->runSet(newData, self);
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunRandomTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunRandomTestActor*>(this)->actor_wait_state = 1;
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunRandomTestActor, 0, bool >*>(static_cast<RunRandomTestActor*>(this)));
															#line 2365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (operation == GET)
															#line 2372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			{
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				StrictFuture<bool> __when_expr_1 = self->runGet(data, 10, self);
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (static_cast<RunRandomTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<RunRandomTestActor*>(this)->actor_wait_state = 2;
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunRandomTestActor, 1, bool >*>(static_cast<RunRandomTestActor*>(this)));
															#line 2383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (operation == GET_RANGE)
															#line 2390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				{
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					StrictFuture<bool> __when_expr_2 = self->runGetRange(data, self);
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					if (static_cast<RunRandomTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
					static_cast<RunRandomTestActor*>(this)->actor_wait_state = 3;
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunRandomTestActor, 2, bool >*>(static_cast<RunRandomTestActor*>(this)));
															#line 2401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					if (operation == GET_RANGE_SELECTOR)
															#line 2408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
					{
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
						StrictFuture<bool> __when_expr_3 = self->runGetRangeSelector(data, self);
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
						if (static_cast<RunRandomTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
						static_cast<RunRandomTestActor*>(this)->actor_wait_state = 4;
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunRandomTestActor, 3, bool >*>(static_cast<RunRandomTestActor*>(this)));
															#line 2419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
						if (operation == GET_KEY)
															#line 2426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
						{
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
							StrictFuture<bool> __when_expr_4 = self->runGetKey(data, 10, self);
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
							if (static_cast<RunRandomTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
							if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.get(), loopDepth); };
							static_cast<RunRandomTestActor*>(this)->actor_wait_state = 5;
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
							__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunRandomTestActor, 4, bool >*>(static_cast<RunRandomTestActor*>(this)));
															#line 2437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
							loopDepth = 0;
						}
						else
						{
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
							if (operation == CLEAR)
															#line 2444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
							{
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
								StrictFuture<bool> __when_expr_5 = self->runClear(data, 10, self);
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
								if (static_cast<RunRandomTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
								if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when6(__when_expr_5.get(), loopDepth); };
								static_cast<RunRandomTestActor*>(this)->actor_wait_state = 6;
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
								__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunRandomTestActor, 5, bool >*>(static_cast<RunRandomTestActor*>(this)));
															#line 2455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
								loopDepth = 0;
							}
							else
							{
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
								if (operation == CLEAR_RANGE)
															#line 2462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
								{
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
									StrictFuture<bool> __when_expr_6 = self->runClearRange(data, self);
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
									if (static_cast<RunRandomTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
									if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when7(__when_expr_6.get(), loopDepth); };
									static_cast<RunRandomTestActor*>(this)->actor_wait_state = 7;
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
									__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunRandomTestActor, 6, bool >*>(static_cast<RunRandomTestActor*>(this)));
															#line 2473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
									loopDepth = 0;
								}
								else
								{
									loopDepth = a_body1loopBody1cont20(loopDepth);
								}
							}
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5(bool const& result,int loopDepth) 
	{
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(bool && result,int loopDepth) 
	{
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunRandomTestActor*>(this)->actor_wait_state > 0) static_cast<RunRandomTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunRandomTestActor*>(this)->ActorCallback< RunRandomTestActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunRandomTestActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(bool const& result,int loopDepth) 
	{
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(bool && result,int loopDepth) 
	{
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(bool && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunRandomTestActor*>(this)->actor_wait_state > 0) static_cast<RunRandomTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunRandomTestActor*>(this)->ActorCallback< RunRandomTestActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunRandomTestActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(bool const& result,int loopDepth) 
	{
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(bool && result,int loopDepth) 
	{
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(bool && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunRandomTestActor*>(this)->actor_wait_state > 0) static_cast<RunRandomTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunRandomTestActor*>(this)->ActorCallback< RunRandomTestActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunRandomTestActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont14(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont15(bool const& result,int loopDepth) 
	{
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont15(bool && result,int loopDepth) 
	{
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(bool && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunRandomTestActor*>(this)->actor_wait_state > 0) static_cast<RunRandomTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunRandomTestActor*>(this)->ActorCallback< RunRandomTestActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunRandomTestActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont16(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont17(bool const& result,int loopDepth) 
	{
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont17(bool && result,int loopDepth) 
	{
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(bool && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunRandomTestActor*>(this)->actor_wait_state > 0) static_cast<RunRandomTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunRandomTestActor*>(this)->ActorCallback< RunRandomTestActor, 4, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 4, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 4, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunRandomTestActor, 4, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont18(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19(bool const& result,int loopDepth) 
	{
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 3084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 3088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19(bool && result,int loopDepth) 
	{
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 3102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 3106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(bool && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunRandomTestActor*>(this)->actor_wait_state > 0) static_cast<RunRandomTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunRandomTestActor*>(this)->ActorCallback< RunRandomTestActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunRandomTestActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont20(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont21(bool const& result,int loopDepth) 
	{
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 3201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 3205 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont21(bool && result,int loopDepth) 
	{
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 3219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 3223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont21(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(bool && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont21(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RunRandomTestActor*>(this)->actor_wait_state > 0) static_cast<RunRandomTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunRandomTestActor*>(this)->ActorCallback< RunRandomTestActor, 6, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 6, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 6, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunRandomTestActor, 6, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> data;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> newData;
															#line 3314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runRandomTest()
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunRandomTestActor final : public Actor<Void>, public ActorCallback< RunRandomTestActor, 0, bool >, public ActorCallback< RunRandomTestActor, 1, bool >, public ActorCallback< RunRandomTestActor, 2, bool >, public ActorCallback< RunRandomTestActor, 3, bool >, public ActorCallback< RunRandomTestActor, 4, bool >, public ActorCallback< RunRandomTestActor, 5, bool >, public ActorCallback< RunRandomTestActor, 6, bool >, public FastAllocated<RunRandomTestActor>, public RunRandomTestActorState<RunRandomTestActor> {
															#line 3319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunRandomTestActor>::operator new;
	using FastAllocated<RunRandomTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10800603875687692032UL, 146256774568002816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunRandomTestActor, 0, bool >;
friend struct ActorCallback< RunRandomTestActor, 1, bool >;
friend struct ActorCallback< RunRandomTestActor, 2, bool >;
friend struct ActorCallback< RunRandomTestActor, 3, bool >;
friend struct ActorCallback< RunRandomTestActor, 4, bool >;
friend struct ActorCallback< RunRandomTestActor, 5, bool >;
friend struct ActorCallback< RunRandomTestActor, 6, bool >;
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunRandomTestActor(ApiCorrectnessWorkload* const& self,Standalone<VectorRef<KeyValueRef>> const& data) 
															#line 3342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunRandomTestActorState<RunRandomTestActor>(self, data),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2252403300957825792UL, 17587082903059536384UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runRandomTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunRandomTestActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunRandomTestActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunRandomTestActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunRandomTestActor, 3, bool >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunRandomTestActor, 4, bool >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunRandomTestActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RunRandomTestActor, 6, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> runRandomTest( ApiCorrectnessWorkload* const& self, Standalone<VectorRef<KeyValueRef>> const& data ) {
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<Void>(new RunRandomTestActor(self, data));
															#line 3380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
}

#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Adds the key-value pairs in data to the database and memory store
																#line 3386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via runSet()
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunSetActor>
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunSetActorState {
															#line 3392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunSetActorState(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : data(data),
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self),
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   currentIndex(0)
															#line 3403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runSet", reinterpret_cast<unsigned long>(this));

	}
	~RunSetActorState() 
	{
		fdb_probe_actor_destroy("runSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 3418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunSetActorState();
		static_cast<RunSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < data.size();i++) {
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->store.set(data[i].key, data[i].value);
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->debugKey(data[i].key, "Set");
															#line 3445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_3 = self->compareDatabaseToMemory();
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunSetActor*>(this)->actor_wait_state = 4;
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunSetActor, 3, bool >*>(static_cast<RunSetActor*>(this)));
															#line 3456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(currentIndex < data.size()))
															#line 3472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		transaction = self->createTransaction();
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		;
															#line 3480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = transaction->get(data[currentIndex].key);
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunSetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunSetActor*>(this)->actor_wait_state = 1;
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunSetActor, 0, Optional<Value> >*>(static_cast<RunSetActor*>(this)));
															#line 3523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = transaction->onError(e);
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunSetActor*>(this)->actor_wait_state = 3;
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunSetActor, 2, Void >*>(static_cast<RunSetActor*>(this)));
															#line 3565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> const& value,int loopDepth) 
	{
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, data.size());i++) {
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->addReadConflictRange(singleKeyRange(data[i].key));
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->set(data[i].key, data[i].value);
															#line 3584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = transaction->commit();
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunSetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunSetActor*>(this)->actor_wait_state = 2;
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunSetActor, 1, Void >*>(static_cast<RunSetActor*>(this)));
															#line 3595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> && value,int loopDepth) 
	{
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, data.size());i++) {
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->addReadConflictRange(singleKeyRange(data[i].key));
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->set(data[i].key, data[i].value);
															#line 3608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = transaction->commit();
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunSetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunSetActor*>(this)->actor_wait_state = 2;
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunSetActor, 1, Void >*>(static_cast<RunSetActor*>(this)));
															#line 3619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunSetActor*>(this)->actor_wait_state > 0) static_cast<RunSetActor*>(this)->actor_wait_state = 0;
		static_cast<RunSetActor*>(this)->ActorCallback< RunSetActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RunSetActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunSetActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunSetActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, data.size());i++) {
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			DEBUG_MUTATION("ApiCorrectnessSet", transaction->getCommittedVersion(), MutationRef(MutationRef::DebugKey, data[i].key, data[i].value));
															#line 3705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 3709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, data.size());i++) {
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			DEBUG_MUTATION("ApiCorrectnessSet", transaction->getCommittedVersion(), MutationRef(MutationRef::DebugKey, data[i].key, data[i].value));
															#line 3720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 3724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunSetActor*>(this)->actor_wait_state > 0) static_cast<RunSetActor*>(this)->actor_wait_state = 0;
		static_cast<RunSetActor*>(this)->ActorCallback< RunSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunSetActor*>(this)->actor_wait_state > 0) static_cast<RunSetActor*>(this)->actor_wait_state = 0;
		static_cast<RunSetActor*>(this)->ActorCallback< RunSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(bool const& result,int loopDepth) 
	{
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 3895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("Set resulted in incorrect database");
															#line 3899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunSetActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunSetActorState(); static_cast<RunSetActor*>(this)->destroy(); return 0; }
															#line 3903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<RunSetActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunSetActorState();
		static_cast<RunSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(bool && result,int loopDepth) 
	{
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 3915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("Set resulted in incorrect database");
															#line 3919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunSetActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunSetActorState(); static_cast<RunSetActor*>(this)->destroy(); return 0; }
															#line 3923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<RunSetActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunSetActorState();
		static_cast<RunSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && result,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunSetActor*>(this)->actor_wait_state > 0) static_cast<RunSetActor*>(this)->actor_wait_state = 0;
		static_cast<RunSetActor*>(this)->ActorCallback< RunSetActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunSetActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunSetActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunSetActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int currentIndex;
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 4014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runSet()
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunSetActor final : public Actor<bool>, public ActorCallback< RunSetActor, 0, Optional<Value> >, public ActorCallback< RunSetActor, 1, Void >, public ActorCallback< RunSetActor, 2, Void >, public ActorCallback< RunSetActor, 3, bool >, public FastAllocated<RunSetActor>, public RunSetActorState<RunSetActor> {
															#line 4019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunSetActor>::operator new;
	using FastAllocated<RunSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7452779584109587456UL, 17305480193091175680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunSetActor, 0, Optional<Value> >;
friend struct ActorCallback< RunSetActor, 1, Void >;
friend struct ActorCallback< RunSetActor, 2, Void >;
friend struct ActorCallback< RunSetActor, 3, bool >;
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunSetActor(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 4039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   RunSetActorState<RunSetActor>(data, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10214455328005274624UL, 6148218280688426752UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunSetActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunSetActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunSetActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunSetActor, 3, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<bool> runSet( VectorRef<KeyValueRef> const& data, ApiCorrectnessWorkload* const& self ) {
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<bool>(new RunSetActor(data, self));
															#line 4074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
}

#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Gets a specified number of values from the database and memory store and compares them, returning true if all
	// results were the same
																#line 4081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via runGet()
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunGetActor>
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetActorState {
															#line 4087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetActorState(VectorRef<KeyValueRef> const& data,int const& numReads,ApiCorrectnessWorkload* const& self) 
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : data(data),
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   numReads(numReads),
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self),
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   keys()
															#line 4100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runGet", reinterpret_cast<unsigned long>(this));

	}
	~RunGetActorState() 
	{
		fdb_probe_actor_destroy("runGet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = 0;i < numReads;i++) {
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				keys.push_back_deep(keys.arena(), self->selectRandomKey(data, 0.9));
															#line 4117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			}
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			values = std::vector<Optional<Value>>();
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			currentIndex = 0;
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 4125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunGetActorState();
		static_cast<RunGetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		bool result = true;
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < keys.size();i++) {
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (values[i] != self->store.get(keys[i]))
															#line 4152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			{
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				result = false;
															#line 4156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				break;
			}
		}
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 4162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("Get returned incorrect results");
															#line 4166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunGetActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunGetActorState(); static_cast<RunGetActor*>(this)->destroy(); return 0; }
															#line 4170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<RunGetActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunGetActorState();
		static_cast<RunGetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(currentIndex < keys.size()))
															#line 4189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		transaction = self->createTransaction();
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		;
															#line 4197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			dbValueFutures = std::vector<Future<Optional<Value>>>();
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, keys.size());i++) {
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				dbValueFutures.push_back(transaction->get(keys[i]));
															#line 4237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			}
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(dbValueFutures);
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunGetActor*>(this)->actor_wait_state = 1;
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunGetActor, 0, Void >*>(static_cast<RunGetActor*>(this)));
															#line 4248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = transaction->onError(e);
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunGetActor*>(this)->actor_wait_state = 2;
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunGetActor, 1, Void >*>(static_cast<RunGetActor*>(this)));
															#line 4290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < dbValueFutures.size();i++) {
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			values.push_back(dbValueFutures[i].get());
															#line 4307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 4311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < dbValueFutures.size();i++) {
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			values.push_back(dbValueFutures[i].get());
															#line 4322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 4326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunGetActor*>(this)->actor_wait_state > 0) static_cast<RunGetActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetActor*>(this)->ActorCallback< RunGetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runGet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunGetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runGet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunGetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runGet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunGetActor*>(this)->actor_wait_state > 0) static_cast<RunGetActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetActor*>(this)->ActorCallback< RunGetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runGet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunGetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runGet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunGetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runGet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGet", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int numReads;
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRef>> keys;
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	std::vector<Optional<Value>> values;
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int currentIndex;
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	std::vector<Future<Optional<Value>>> dbValueFutures;
															#line 4509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runGet()
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetActor final : public Actor<bool>, public ActorCallback< RunGetActor, 0, Void >, public ActorCallback< RunGetActor, 1, Void >, public FastAllocated<RunGetActor>, public RunGetActorState<RunGetActor> {
															#line 4514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunGetActor>::operator new;
	using FastAllocated<RunGetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3482570923698278400UL, 1025069856127282688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunGetActor, 0, Void >;
friend struct ActorCallback< RunGetActor, 1, Void >;
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetActor(VectorRef<KeyValueRef> const& data,int const& numReads,ApiCorrectnessWorkload* const& self) 
															#line 4532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   RunGetActorState<RunGetActor>(data, numReads, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runGet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9817262855810077184UL, 4230406122534541568UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runGet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runGet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunGetActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunGetActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<bool> runGet( VectorRef<KeyValueRef> const& data, int const& numReads, ApiCorrectnessWorkload* const& self ) {
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<bool>(new RunGetActor(data, numReads, self));
															#line 4565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
}

#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Gets a single range of values from the database and memory stores and compares them, returning true if the
	// results were the same
																#line 4572 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via runGetRange()
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunGetRangeActor>
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetRangeActorState {
															#line 4578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetRangeActorState(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : data(data),
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self),
															#line 464 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   reverse(deterministicRandom()->coinflip())
															#line 4589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runGetRange", reinterpret_cast<unsigned long>(this));

	}
	~RunGetRangeActorState() 
	{
		fdb_probe_actor_destroy("runGetRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			Key key = self->selectRandomKey(data, 0.5);
															#line 468 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			Key key2 = self->selectRandomKey(data, 0.5);
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			start = std::min(key, key2);
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			end = std::max(key, key2);
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			limit = deterministicRandom()->randomInt(0, 101);
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			storeResults = self->store.getRange(KeyRangeRef(start, end), limit, reverse);
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			dbResults = RangeResult();
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			readVersion = Version();
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction = self->createTransaction();
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 4622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunGetRangeActorState();
		static_cast<RunGetRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		bool result = self->compareResults(dbResults, storeResults, readVersion);
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 4647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("GetRange returned incorrect results");
															#line 4651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 504 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunGetRangeActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunGetRangeActorState(); static_cast<RunGetRangeActor*>(this)->destroy(); return 0; }
															#line 4655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<RunGetRangeActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunGetRangeActorState();
		static_cast<RunGetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Version> __when_expr_0 = transaction->getReadVersion();
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunGetRangeActor*>(this)->actor_wait_state = 1;
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeActor, 0, Version >*>(static_cast<RunGetRangeActor*>(this)));
															#line 4682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = transaction->onError(e);
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunGetRangeActor*>(this)->actor_wait_state = 3;
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeActor, 2, Void >*>(static_cast<RunGetRangeActor*>(this)));
															#line 4724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& version,int loopDepth) 
	{
															#line 488 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		readVersion = version;
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		KeyRangeRef range(start, end);
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = transaction->getRange(range, limit, reverse);
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunGetRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunGetRangeActor*>(this)->actor_wait_state = 2;
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeActor, 1, RangeResult >*>(static_cast<RunGetRangeActor*>(this)));
															#line 4750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && version,int loopDepth) 
	{
															#line 488 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		readVersion = version;
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		KeyRangeRef range(start, end);
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = transaction->getRange(range, limit, reverse);
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunGetRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4765 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunGetRangeActor*>(this)->actor_wait_state = 2;
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeActor, 1, RangeResult >*>(static_cast<RunGetRangeActor*>(this)));
															#line 4770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunGetRangeActor*>(this)->actor_wait_state > 0) static_cast<RunGetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetRangeActor*>(this)->ActorCallback< RunGetRangeActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetRangeActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunGetRangeActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunGetRangeActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& rangeResults,int loopDepth) 
	{
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		dbResults = rangeResults;
															#line 4854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && rangeResults,int loopDepth) 
	{
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		dbResults = rangeResults;
															#line 4863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& rangeResults,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(rangeResults, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && rangeResults,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(rangeResults), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunGetRangeActor*>(this)->actor_wait_state > 0) static_cast<RunGetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetRangeActor*>(this)->ActorCallback< RunGetRangeActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetRangeActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunGetRangeActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunGetRangeActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunGetRangeActor*>(this)->actor_wait_state > 0) static_cast<RunGetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetRangeActor*>(this)->ActorCallback< RunGetRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunGetRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunGetRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 464 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reverse reverse;
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key start;
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key end;
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int limit;
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RangeResult storeResults;
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RangeResult dbResults;
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Version readVersion;
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 5050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runGetRange()
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetRangeActor final : public Actor<bool>, public ActorCallback< RunGetRangeActor, 0, Version >, public ActorCallback< RunGetRangeActor, 1, RangeResult >, public ActorCallback< RunGetRangeActor, 2, Void >, public FastAllocated<RunGetRangeActor>, public RunGetRangeActorState<RunGetRangeActor> {
															#line 5055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunGetRangeActor>::operator new;
	using FastAllocated<RunGetRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(230275824026016512UL, 13283659862680094720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunGetRangeActor, 0, Version >;
friend struct ActorCallback< RunGetRangeActor, 1, RangeResult >;
friend struct ActorCallback< RunGetRangeActor, 2, Void >;
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetRangeActor(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 5074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   RunGetRangeActorState<RunGetRangeActor>(data, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14940957793025822720UL, 4248663186857621248UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runGetRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunGetRangeActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunGetRangeActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunGetRangeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<bool> runGetRange( VectorRef<KeyValueRef> const& data, ApiCorrectnessWorkload* const& self ) {
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<bool>(new RunGetRangeActor(data, self));
															#line 5108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
}

#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Gets a single range of values using key selectors from the database and memory store and compares them, returning
	// true if the results were the same
																#line 5115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via runGetRangeSelector()
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunGetRangeSelectorActor>
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetRangeSelectorActorState {
															#line 5121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetRangeSelectorActorState(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : data(data),
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self),
															#line 510 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   reverse(deterministicRandom()->coinflip())
															#line 5132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runGetRangeSelector", reinterpret_cast<unsigned long>(this));

	}
	~RunGetRangeSelectorActorState() 
	{
		fdb_probe_actor_destroy("runGetRangeSelector", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			KeySelector selectors[2];
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			Key keys[2];
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			int maxSelectorAttempts = 100;
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			int currentSelectorAttempts = 0;
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = 0;i < 2;i++) {
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				for(;;) {
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					selectors[i] = self->generateKeySelector(data, std::min(100, maxSelectorAttempts - currentSelectorAttempts));
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					keys[i] = self->store.getKey(selectors[i]);
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					if (keys[i].startsWith(StringRef(self->clientPrefix)) || (keys[i].size() == 0 && self->clientPrefixInt == 0) || (keys[i].startsWith("\xff"_sr) && self->clientPrefixInt == self->clientCount - 1))
															#line 5163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
					{
						break;
					}
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					if (++currentSelectorAttempts == maxSelectorAttempts)
															#line 5169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
					{
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
						if (!static_cast<RunGetRangeSelectorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~RunGetRangeSelectorActorState(); static_cast<RunGetRangeSelectorActor*>(this)->destroy(); return 0; }
															#line 5173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
						new (&static_cast<RunGetRangeSelectorActor*>(this)->SAV< bool >::value()) bool(true);
						this->~RunGetRangeSelectorActorState();
						static_cast<RunGetRangeSelectorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
															#line 541 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			startSelector = KeySelector();
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			endSelector = KeySelector();
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			startKey = Key();
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			endKey = Key();
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (keys[0] < keys[1])
															#line 5191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			{
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				startSelector = selectors[0];
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				startKey = keys[0];
															#line 551 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				endSelector = selectors[1];
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				endKey = keys[1];
															#line 5201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				startSelector = selectors[1];
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				startKey = keys[1];
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				endSelector = selectors[0];
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				endKey = keys[0];
															#line 5213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			}
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			limit = deterministicRandom()->randomInt(0, 101);
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			storeResults = self->store.getRange(KeyRangeRef(startKey, endKey), limit, reverse);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			dbResults = RangeResult();
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction = self->createTransaction();
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			readVersion = Version();
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 5227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunGetRangeSelectorActorState();
		static_cast<RunGetRangeSelectorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		bool result = self->compareResults(dbResults, storeResults, readVersion);
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 5252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("GetRange (KeySelector) returned incorrect results");
															#line 5256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunGetRangeSelectorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunGetRangeSelectorActorState(); static_cast<RunGetRangeSelectorActor*>(this)->destroy(); return 0; }
															#line 5260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<RunGetRangeSelectorActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunGetRangeSelectorActorState();
		static_cast<RunGetRangeSelectorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Version> __when_expr_0 = transaction->getReadVersion();
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state = 1;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeSelectorActor, 0, Version >*>(static_cast<RunGetRangeSelectorActor*>(this)));
															#line 5287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = transaction->onError(e);
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state = 3;
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeSelectorActor, 2, Void >*>(static_cast<RunGetRangeSelectorActor*>(this)));
															#line 5329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& version,int loopDepth) 
	{
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		readVersion = version;
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = transaction->getRange(startSelector, endSelector, limit, reverse);
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state = 2;
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >*>(static_cast<RunGetRangeSelectorActor*>(this)));
															#line 5353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && version,int loopDepth) 
	{
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		readVersion = version;
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = transaction->getRange(startSelector, endSelector, limit, reverse);
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state = 2;
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >*>(static_cast<RunGetRangeSelectorActor*>(this)));
															#line 5371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state > 0) static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetRangeSelectorActor*>(this)->ActorCallback< RunGetRangeSelectorActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetRangeSelectorActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunGetRangeSelectorActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunGetRangeSelectorActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& range,int loopDepth) 
	{
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (endKey == self->store.endKey())
															#line 5455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = 0;i < range.size();i++) {
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (!range[i].key.startsWith("\xff"_sr))
															#line 5461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				{
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					dbResults.push_back_deep(dbResults.arena(), range[i]);
															#line 5465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				}
			}
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (reverse && dbResults.size() < storeResults.size())
															#line 5470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			{
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				storeResults.resize(storeResults.arena(), dbResults.size());
															#line 5474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			dbResults = range;
															#line 5481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && range,int loopDepth) 
	{
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (endKey == self->store.endKey())
															#line 5491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = 0;i < range.size();i++) {
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (!range[i].key.startsWith("\xff"_sr))
															#line 5497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				{
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					dbResults.push_back_deep(dbResults.arena(), range[i]);
															#line 5501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				}
			}
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (reverse && dbResults.size() < storeResults.size())
															#line 5506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			{
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				storeResults.resize(storeResults.arena(), dbResults.size());
															#line 5510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			dbResults = range;
															#line 5517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(range, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state > 0) static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetRangeSelectorActor*>(this)->ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state > 0) static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetRangeSelectorActor*>(this)->ActorCallback< RunGetRangeSelectorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetRangeSelectorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunGetRangeSelectorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunGetRangeSelectorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 510 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reverse reverse;
															#line 541 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	KeySelector startSelector;
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	KeySelector endSelector;
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key startKey;
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key endKey;
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int limit;
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RangeResult storeResults;
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RangeResult dbResults;
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Version readVersion;
															#line 5709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runGetRangeSelector()
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetRangeSelectorActor final : public Actor<bool>, public ActorCallback< RunGetRangeSelectorActor, 0, Version >, public ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >, public ActorCallback< RunGetRangeSelectorActor, 2, Void >, public FastAllocated<RunGetRangeSelectorActor>, public RunGetRangeSelectorActorState<RunGetRangeSelectorActor> {
															#line 5714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunGetRangeSelectorActor>::operator new;
	using FastAllocated<RunGetRangeSelectorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17747079441120919296UL, 6245471020634259968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunGetRangeSelectorActor, 0, Version >;
friend struct ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >;
friend struct ActorCallback< RunGetRangeSelectorActor, 2, Void >;
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetRangeSelectorActor(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 5733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   RunGetRangeSelectorActorState<RunGetRangeSelectorActor>(data, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7526144586924790272UL, 15002562274698689792UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runGetRangeSelector");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunGetRangeSelectorActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunGetRangeSelectorActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<bool> runGetRangeSelector( VectorRef<KeyValueRef> const& data, ApiCorrectnessWorkload* const& self ) {
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<bool>(new RunGetRangeSelectorActor(data, self));
															#line 5767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
}

#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Gets a specified number of keys from the database and memory store and compares them, returning true if all
	// results were the same
																#line 5774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via runGetKey()
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunGetKeyActor>
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetKeyActorState {
															#line 5780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetKeyActorState(VectorRef<KeyValueRef> const& data,int const& numGetKeys,ApiCorrectnessWorkload* const& self) 
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : data(data),
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   numGetKeys(numGetKeys),
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self),
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   selectors()
															#line 5793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runGetKey", reinterpret_cast<unsigned long>(this));

	}
	~RunGetKeyActorState() 
	{
		fdb_probe_actor_destroy("runGetKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = 0;i < numGetKeys;i++) {
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				selectors.push_back_deep(selectors.arena(), self->generateKeySelector(data, 100));
															#line 5810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			}
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			keys = Standalone<VectorRef<KeyRef>>();
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			currentIndex = 0;
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 5818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunGetKeyActorState();
		static_cast<RunGetKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		result = true;
															#line 646 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = int();
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = 0;
															#line 5845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(currentIndex < selectors.size()))
															#line 5861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		transaction = self->createTransaction();
															#line 621 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		;
															#line 5869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			dbKeyFutures = std::vector<Future<Standalone<KeyRef>>>();
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, selectors.size());i++) {
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				dbKeyFutures.push_back(transaction->getKey(selectors[i]));
															#line 5909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			}
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(dbKeyFutures);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunGetKeyActor*>(this)->actor_wait_state = 1;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunGetKeyActor, 0, Void >*>(static_cast<RunGetKeyActor*>(this)));
															#line 5920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = transaction->onError(e);
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunGetKeyActor*>(this)->actor_wait_state = 2;
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunGetKeyActor, 1, Void >*>(static_cast<RunGetKeyActor*>(this)));
															#line 5962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < dbKeyFutures.size();i++) {
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			keys.push_back_deep(keys.arena(), dbKeyFutures[i].get());
															#line 5979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 5983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < dbKeyFutures.size();i++) {
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			keys.push_back_deep(keys.arena(), dbKeyFutures[i].get());
															#line 5994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 5998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunGetKeyActor*>(this)->actor_wait_state > 0) static_cast<RunGetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetKeyActor*>(this)->ActorCallback< RunGetKeyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunGetKeyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunGetKeyActor*>(this)->actor_wait_state > 0) static_cast<RunGetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetKeyActor*>(this)->ActorCallback< RunGetKeyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunGetKeyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 693 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 6169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("GetKey returned incorrect results");
															#line 6173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunGetKeyActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunGetKeyActorState(); static_cast<RunGetKeyActor*>(this)->destroy(); return 0; }
															#line 6177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<RunGetKeyActor*>(this)->SAV< bool >::value()) bool(std::move(result)); // state_var_RVO
		this->~RunGetKeyActorState();
		static_cast<RunGetKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(i < selectors.size()))
															#line 6196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		Key key = self->store.getKey(selectors[i]);
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (keys[i].startsWith(StringRef(self->clientPrefix)) && keys[i] != key)
															#line 6204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 650 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			result = false;
															#line 6208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (keys[i] < StringRef(self->clientPrefix) && key != self->store.startKey())
															#line 6214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			{
															#line 652 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				result = false;
															#line 6218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 653 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (keys[i] > StringRef(self->clientPrefix + "\xff") && key != self->store.endKey())
															#line 6224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				{
															#line 654 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					result = false;
															#line 6228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
				}
			}
		}
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 6234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			printf("Bad result for key selector %s: db=%s, mem=%s\n", selectors[i].toString().c_str(), printable(keys[i]).c_str(), printable(key).c_str());
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			dir = selectors[i].offset > 0 ? 1 : -1;
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			j = int();
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			j = 0;
															#line 6244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i++;
															#line 6271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(j <= abs(selectors[i].offset)))
															#line 6293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		sel = KeySelectorRef(selectors[i].getKey(), selectors[i].orEqual, j * dir);
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		storeKey = self->store.getKey(sel);
															#line 668 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		tr = self->createTransaction();
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		dbKey = Key();
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		;
															#line 6307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(storeKey == self->store.startKey() && dbKey < StringRef(self->clientPrefix)) && !(storeKey == self->store.endKey() && dbKey > StringRef(self->clientPrefix + "\xff")))
															#line 6329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			printf("Offset %d: db=%s, mem=%s\n", j * dir, printable(dbKey).c_str(), printable(storeKey).c_str());
															#line 6333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		j++;
															#line 6337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Key> __when_expr_2 = tr->getKey(sel);
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetKeyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunGetKeyActor*>(this)->actor_wait_state = 3;
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunGetKeyActor, 2, Key >*>(static_cast<RunGetKeyActor*>(this)));
															#line 6361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 3));
															#line 6398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 3)); else return a_body1cont1loopBody1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<RunGetKeyActor*>(this)->actor_wait_state = 4;
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunGetKeyActor, 3, Void >*>(static_cast<RunGetKeyActor*>(this)));
															#line 6403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1cont2(Key const& key,int loopDepth) 
	{
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		dbKey = key;
															#line 6418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		return a_body1cont1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1cont2(Key && key,int loopDepth) 
	{
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		dbKey = key;
															#line 6427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		return a_body1cont1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1when1(Key const& key,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1cont2(key, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1when1(Key && key,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1cont2(std::move(key), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunGetKeyActor*>(this)->actor_wait_state > 0) static_cast<RunGetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetKeyActor*>(this)->ActorCallback< RunGetKeyActor, 2, Key >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 2, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 2, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunGetKeyActor, 2, Key >*,Error err) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunGetKeyActor*>(this)->actor_wait_state > 0) static_cast<RunGetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetKeyActor*>(this)->ActorCallback< RunGetKeyActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunGetKeyActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int numGetKeys;
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Standalone<VectorRef<KeySelectorRef>> selectors;
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRef>> keys;
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int currentIndex;
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	std::vector<Future<Standalone<KeyRef>>> dbKeyFutures;
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	bool result;
															#line 646 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int i;
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int dir;
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int j;
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	KeySelector sel;
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key storeKey;
															#line 668 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> tr;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key dbKey;
															#line 6626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runGetKey()
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetKeyActor final : public Actor<bool>, public ActorCallback< RunGetKeyActor, 0, Void >, public ActorCallback< RunGetKeyActor, 1, Void >, public ActorCallback< RunGetKeyActor, 2, Key >, public ActorCallback< RunGetKeyActor, 3, Void >, public FastAllocated<RunGetKeyActor>, public RunGetKeyActorState<RunGetKeyActor> {
															#line 6631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunGetKeyActor>::operator new;
	using FastAllocated<RunGetKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(51685837675108864UL, 12399725235487461632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunGetKeyActor, 0, Void >;
friend struct ActorCallback< RunGetKeyActor, 1, Void >;
friend struct ActorCallback< RunGetKeyActor, 2, Key >;
friend struct ActorCallback< RunGetKeyActor, 3, Void >;
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetKeyActor(VectorRef<KeyValueRef> const& data,int const& numGetKeys,ApiCorrectnessWorkload* const& self) 
															#line 6651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   RunGetKeyActorState<RunGetKeyActor>(data, numGetKeys, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17881606683242620416UL, 12084576079300629504UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runGetKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunGetKeyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunGetKeyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunGetKeyActor, 2, Key >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunGetKeyActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<bool> runGetKey( VectorRef<KeyValueRef> const& data, int const& numGetKeys, ApiCorrectnessWorkload* const& self ) {
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<bool>(new RunGetKeyActor(data, numGetKeys, self));
															#line 6686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
}

#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Clears a specified number of keys from the database and memory store
																#line 6692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via runClear()
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunClearActor>
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunClearActorState {
															#line 6698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunClearActorState(VectorRef<KeyValueRef> const& data,int const& numClears,ApiCorrectnessWorkload* const& self) 
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : data(data),
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   numClears(numClears),
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self),
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   keys()
															#line 6711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runClear", reinterpret_cast<unsigned long>(this));

	}
	~RunClearActorState() 
	{
		fdb_probe_actor_destroy("runClear", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = 0;i < numClears;i++) {
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				keys.push_back_deep(keys.arena(), self->selectRandomKey(data, 0.9));
															#line 6728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			}
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			currentIndex = 0;
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 6734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunClearActorState();
		static_cast<RunClearActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < keys.size();i++) {
															#line 738 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->store.clear(keys[i]);
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->debugKey(keys[i], "Clear");
															#line 6761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 743 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_3 = self->compareDatabaseToMemory();
															#line 743 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunClearActor*>(this)->actor_wait_state = 4;
															#line 743 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunClearActor, 3, bool >*>(static_cast<RunClearActor*>(this)));
															#line 6772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(currentIndex < keys.size()))
															#line 6788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		transaction = self->createTransaction();
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		;
															#line 6796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = transaction->get(keys[0]);
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunClearActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6834 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunClearActor*>(this)->actor_wait_state = 1;
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunClearActor, 0, Optional<Value> >*>(static_cast<RunClearActor*>(this)));
															#line 6839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 731 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = transaction->onError(e);
															#line 731 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunClearActor*>(this)->actor_wait_state = 3;
															#line 731 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunClearActor, 2, Void >*>(static_cast<RunClearActor*>(this)));
															#line 6881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> const& value,int loopDepth) 
	{
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, keys.size());i++) {
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->addReadConflictRange(singleKeyRange(keys[i]));
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->clear(keys[i]);
															#line 6900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = transaction->commit();
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunClearActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunClearActor*>(this)->actor_wait_state = 2;
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunClearActor, 1, Void >*>(static_cast<RunClearActor*>(this)));
															#line 6911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> && value,int loopDepth) 
	{
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, keys.size());i++) {
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->addReadConflictRange(singleKeyRange(keys[i]));
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->clear(keys[i]);
															#line 6924 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = transaction->commit();
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunClearActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunClearActor*>(this)->actor_wait_state = 2;
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunClearActor, 1, Void >*>(static_cast<RunClearActor*>(this)));
															#line 6935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunClearActor*>(this)->actor_wait_state > 0) static_cast<RunClearActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearActor*>(this)->ActorCallback< RunClearActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunClearActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunClearActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 722 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, keys.size());i++) {
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			DEBUG_MUTATION("ApiCorrectnessClear", transaction->getCommittedVersion(), MutationRef(MutationRef::DebugKey, keys[i], StringRef()));
															#line 7021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 7025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 722 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, keys.size());i++) {
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			DEBUG_MUTATION("ApiCorrectnessClear", transaction->getCommittedVersion(), MutationRef(MutationRef::DebugKey, keys[i], StringRef()));
															#line 7036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 7040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunClearActor*>(this)->actor_wait_state > 0) static_cast<RunClearActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearActor*>(this)->ActorCallback< RunClearActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunClearActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunClearActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunClearActor*>(this)->actor_wait_state > 0) static_cast<RunClearActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearActor*>(this)->ActorCallback< RunClearActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunClearActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunClearActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(bool const& result,int loopDepth) 
	{
															#line 744 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 7211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("Clear resulted in incorrect database");
															#line 7215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunClearActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunClearActorState(); static_cast<RunClearActor*>(this)->destroy(); return 0; }
															#line 7219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<RunClearActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunClearActorState();
		static_cast<RunClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(bool && result,int loopDepth) 
	{
															#line 744 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 7231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("Clear resulted in incorrect database");
															#line 7235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunClearActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunClearActorState(); static_cast<RunClearActor*>(this)->destroy(); return 0; }
															#line 7239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<RunClearActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunClearActorState();
		static_cast<RunClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1cont3(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && result,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunClearActor*>(this)->actor_wait_state > 0) static_cast<RunClearActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearActor*>(this)->ActorCallback< RunClearActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunClearActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunClearActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int numClears;
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRef>> keys;
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int currentIndex;
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 7334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runClear()
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunClearActor final : public Actor<bool>, public ActorCallback< RunClearActor, 0, Optional<Value> >, public ActorCallback< RunClearActor, 1, Void >, public ActorCallback< RunClearActor, 2, Void >, public ActorCallback< RunClearActor, 3, bool >, public FastAllocated<RunClearActor>, public RunClearActorState<RunClearActor> {
															#line 7339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunClearActor>::operator new;
	using FastAllocated<RunClearActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4269714140040399616UL, 9823950234663488512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunClearActor, 0, Optional<Value> >;
friend struct ActorCallback< RunClearActor, 1, Void >;
friend struct ActorCallback< RunClearActor, 2, Void >;
friend struct ActorCallback< RunClearActor, 3, bool >;
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunClearActor(VectorRef<KeyValueRef> const& data,int const& numClears,ApiCorrectnessWorkload* const& self) 
															#line 7359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   RunClearActorState<RunClearActor>(data, numClears, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10029780055165194752UL, 11590706061971697920UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runClear");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunClearActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunClearActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunClearActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunClearActor, 3, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<bool> runClear( VectorRef<KeyValueRef> const& data, int const& numClears, ApiCorrectnessWorkload* const& self ) {
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<bool>(new RunClearActor(data, numClears, self));
															#line 7394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
}

#line 749 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Clears a single range of keys from the database and memory store
																#line 7400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via runClearRange()
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunClearRangeActor>
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunClearRangeActorState {
															#line 7406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunClearRangeActorState(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : data(data),
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self)
															#line 7415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runClearRange", reinterpret_cast<unsigned long>(this));

	}
	~RunClearRangeActorState() 
	{
		fdb_probe_actor_destroy("runClearRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			Key key = self->selectRandomKey(data, 0.5);
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			Key key2 = self->selectRandomKey(data, 0.5);
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			start = std::min(key, key2);
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			end = std::max(key, key2);
															#line 760 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->store.clear(KeyRangeRef(start, end));
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction = self->createTransaction();
															#line 765 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 7442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunClearRangeActorState();
		static_cast<RunClearRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		self->debugKey(KeyRangeRef(start, end), "ClearRange");
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_3 = self->compareDatabaseToMemory();
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunClearRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunClearRangeActor*>(this)->actor_wait_state = 4;
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunClearRangeActor, 3, bool >*>(static_cast<RunClearRangeActor*>(this)));
															#line 7474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = transaction->get(start);
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunClearRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunClearRangeActor*>(this)->actor_wait_state = 1;
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunClearRangeActor, 0, Optional<Value> >*>(static_cast<RunClearRangeActor*>(this)));
															#line 7498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 779 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = transaction->onError(e);
															#line 779 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunClearRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunClearRangeActor*>(this)->actor_wait_state = 3;
															#line 779 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunClearRangeActor, 2, Void >*>(static_cast<RunClearRangeActor*>(this)));
															#line 7540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& value,int loopDepth) 
	{
															#line 770 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		range = KeyRangeRef(start, end);
															#line 771 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!range.empty())
															#line 7557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->addReadConflictRange(range);
															#line 7561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 774 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		transaction->clear(range);
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = transaction->commit();
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunClearRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunClearRangeActor*>(this)->actor_wait_state = 2;
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunClearRangeActor, 1, Void >*>(static_cast<RunClearRangeActor*>(this)));
															#line 7574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && value,int loopDepth) 
	{
															#line 770 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		range = KeyRangeRef(start, end);
															#line 771 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!range.empty())
															#line 7585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->addReadConflictRange(range);
															#line 7589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 774 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		transaction->clear(range);
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = transaction->commit();
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunClearRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunClearRangeActor*>(this)->actor_wait_state = 2;
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunClearRangeActor, 1, Void >*>(static_cast<RunClearRangeActor*>(this)));
															#line 7602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunClearRangeActor*>(this)->actor_wait_state > 0) static_cast<RunClearRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearRangeActor*>(this)->ActorCallback< RunClearRangeActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunClearRangeActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 776 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		DEBUG_KEY_RANGE("ApiCorrectnessClear", transaction->getCommittedVersion(), range);
															#line 7686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 776 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		DEBUG_KEY_RANGE("ApiCorrectnessClear", transaction->getCommittedVersion(), range);
															#line 7695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunClearRangeActor*>(this)->actor_wait_state > 0) static_cast<RunClearRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearRangeActor*>(this)->ActorCallback< RunClearRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunClearRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunClearRangeActor*>(this)->actor_wait_state > 0) static_cast<RunClearRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearRangeActor*>(this)->ActorCallback< RunClearRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunClearRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(bool const& result,int loopDepth) 
	{
															#line 787 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 7866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 788 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("Clear (range) resulted in incorrect database");
															#line 7870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 790 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunClearRangeActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunClearRangeActorState(); static_cast<RunClearRangeActor*>(this)->destroy(); return 0; }
															#line 7874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<RunClearRangeActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunClearRangeActorState();
		static_cast<RunClearRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(bool && result,int loopDepth) 
	{
															#line 787 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 7886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		{
															#line 788 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("Clear (range) resulted in incorrect database");
															#line 7890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		}
															#line 790 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunClearRangeActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunClearRangeActorState(); static_cast<RunClearRangeActor*>(this)->destroy(); return 0; }
															#line 7894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<RunClearRangeActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunClearRangeActorState();
		static_cast<RunClearRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && result,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunClearRangeActor*>(this)->actor_wait_state > 0) static_cast<RunClearRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearRangeActor*>(this)->ActorCallback< RunClearRangeActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunClearRangeActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key start;
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key end;
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 770 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	KeyRangeRef range;
															#line 7989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runClearRange()
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunClearRangeActor final : public Actor<bool>, public ActorCallback< RunClearRangeActor, 0, Optional<Value> >, public ActorCallback< RunClearRangeActor, 1, Void >, public ActorCallback< RunClearRangeActor, 2, Void >, public ActorCallback< RunClearRangeActor, 3, bool >, public FastAllocated<RunClearRangeActor>, public RunClearRangeActorState<RunClearRangeActor> {
															#line 7994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunClearRangeActor>::operator new;
	using FastAllocated<RunClearRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13871658684896055808UL, 15943018001333344256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunClearRangeActor, 0, Optional<Value> >;
friend struct ActorCallback< RunClearRangeActor, 1, Void >;
friend struct ActorCallback< RunClearRangeActor, 2, Void >;
friend struct ActorCallback< RunClearRangeActor, 3, bool >;
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunClearRangeActor(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 8014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   RunClearRangeActorState<RunClearRangeActor>(data, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16937313940969349120UL, 12933814195253384704UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runClearRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunClearRangeActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunClearRangeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunClearRangeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunClearRangeActor, 3, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<bool> runClearRange( VectorRef<KeyValueRef> const& data, ApiCorrectnessWorkload* const& self ) {
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<bool>(new RunClearRangeActor(data, self));
															#line 8049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ApiCorrectness.actor.g.cpp.py_gen"
}

#line 792 "/Users/ec2-user/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
};

WorkloadFactory<ApiCorrectnessWorkload> ApiCorrectnessWorkloadFactory;
