#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
/*
 * ClusterController.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <algorithm>
#include <iterator>
#include <map>
#include <memory>
#include <set>
#include <tuple>
#include <vector>

#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbclient/EncryptKeyProxyInterface.h"
#include "fdbrpc/Locality.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/ActorCollection.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/ApplyMetadataMutation.h"
#include "fdbserver/BackupInterface.h"
#include "fdbserver/BackupProgress.actor.h"
#include "fdbserver/ConfigBroadcaster.h"
#include "fdbserver/CoordinatedState.h"
#include "fdbserver/CoordinationInterface.h" // copy constructors for ServerCoordinators class
#include "fdbserver/ClusterController.actor.h"
#include "fdbserver/ClusterRecovery.actor.h"
#include "fdbserver/DataDistributorInterface.h"
#include "fdbserver/DBCoreState.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbserver/LeaderElection.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/LogSystemConfig.h"
#include "fdbserver/LogSystemDiskQueueAdapter.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/RatekeeperInterface.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/SingletonRoles.h"
#include "fdbserver/Status.actor.h"
#include "fdbserver/LatencyBandConfig.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbserver/RecoveryState.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/Replication.h"
#include "fdbrpc/ReplicationUtils.h"
#include "fdbrpc/sim_validation.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "flow/Error.h"
#include "flow/Trace.h"
#include "flow/Util.h"

#include "flow/actorcompiler.h" // This must be the last #include.

															#line 77 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getPreviousCoordinators()
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class GetPreviousCoordinatorsActor>
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class GetPreviousCoordinatorsActorState {
															#line 84 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	GetPreviousCoordinatorsActorState(ClusterControllerData* const& self) 
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(self->db.db)
															#line 93 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getPreviousCoordinators", reinterpret_cast<unsigned long>(this));

	}
	~GetPreviousCoordinatorsActorState() 
	{
		fdb_probe_actor_destroy("getPreviousCoordinators", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(previousCoordinatorsKey);
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 1;
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*>(static_cast<GetPreviousCoordinatorsActor*>(this)));
															#line 152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*>(static_cast<GetPreviousCoordinatorsActor*>(this)));
															#line 181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& previousCoordinators,int loopDepth) 
	{
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<GetPreviousCoordinatorsActor*>(this)->SAV<Optional<Value>>::futures) { (void)(previousCoordinators); this->~GetPreviousCoordinatorsActorState(); static_cast<GetPreviousCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<GetPreviousCoordinatorsActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(previousCoordinators);
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && previousCoordinators,int loopDepth) 
	{
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<GetPreviousCoordinatorsActor*>(this)->SAV<Optional<Value>>::futures) { (void)(previousCoordinators); this->~GetPreviousCoordinatorsActorState(); static_cast<GetPreviousCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<GetPreviousCoordinatorsActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(previousCoordinators);
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& previousCoordinators,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(previousCoordinators, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && previousCoordinators,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(previousCoordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<GetPreviousCoordinatorsActor*>(this)->ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<GetPreviousCoordinatorsActor*>(this)->ActorCallback< GetPreviousCoordinatorsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getPreviousCoordinators()
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class GetPreviousCoordinatorsActor final : public Actor<Optional<Value>>, public ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >, public ActorCallback< GetPreviousCoordinatorsActor, 1, Void >, public FastAllocated<GetPreviousCoordinatorsActor>, public GetPreviousCoordinatorsActorState<GetPreviousCoordinatorsActor> {
															#line 387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetPreviousCoordinatorsActor>::operator new;
	using FastAllocated<GetPreviousCoordinatorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17840947182441262080UL, 16518518689564560640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >;
friend struct ActorCallback< GetPreviousCoordinatorsActor, 1, Void >;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	GetPreviousCoordinatorsActor(ClusterControllerData* const& self) 
															#line 405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Optional<Value>>(),
		   GetPreviousCoordinatorsActorState<GetPreviousCoordinatorsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9522256357088947712UL, 3090868322878582016UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getPreviousCoordinators");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Optional<Value>> getPreviousCoordinators( ClusterControllerData* const& self ) {
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Optional<Value>>(new GetPreviousCoordinatorsActor(self));
															#line 439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 89 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

bool ClusterControllerData::processesInSameDC(const NetworkAddress& addr1, const NetworkAddress& addr2) const {
	return this->addr_locality.contains(addr1) && this->addr_locality.contains(addr2) &&
	       this->addr_locality.at(addr1).dcId().present() && this->addr_locality.at(addr2).dcId().present() &&
	       this->addr_locality.at(addr1).dcId().get() == this->addr_locality.at(addr2).dcId().get();
}

bool ClusterControllerData::transactionSystemContainsDegradedServers() {
	const ServerDBInfo& dbi = db.serverInfo->get();
	const Reference<ClusterRecoveryData> recoveryData = db.recoveryData;
	auto transactionWorkerInList = [&dbi, &recoveryData](const std::unordered_set<NetworkAddress>& serverList,
	                                                     bool skipSatellite,
	                                                     bool skipRemoteTLog,
	                                                     bool skipRemoteLogRouter) -> bool {
		for (const auto& server : serverList) {
			if (dbi.master.addresses().contains(server)) {
				return true;
			}

			// Getting the current log system config to check if any TLogs are degraded. recoveryData->logSystem has the
			// most up to date log system and we should use it whenever available.
			auto logSystemConfig = (recoveryData.isValid() && recoveryData->logSystem.isValid())
			                           ? recoveryData->logSystem->getLogSystemConfig()
			                           : dbi.logSystemConfig;
			for (const auto& logSet : logSystemConfig.tLogs) {
				if (skipSatellite && logSet.locality == tagLocalitySatellite) {
					continue;
				}

				if (!logSet.isLocal) {
					if (!skipRemoteTLog) {
						for (const auto& tlog : logSet.tLogs) {
							if (tlog.present() && tlog.interf().addresses().contains(server)) {
								return true;
							}
						}
					}
					if (!skipRemoteLogRouter) {
						for (const auto& logRouter : logSet.logRouters) {
							if (logRouter.present() && logRouter.interf().addresses().contains(server)) {
								return true;
							}
						}
					}
				} else {
					for (const auto& tlog : logSet.tLogs) {
						if (tlog.present() && tlog.interf().addresses().contains(server)) {
							return true;
						}
					}
				}
			}

			if (SERVER_KNOBS->GRAY_FAILURE_ENABLE_TLOG_RECOVERY_MONITORING && recoveryData.isValid() &&
			    recoveryData->recoveryState < RecoveryState::ACCEPTING_COMMITS) {
				// During recovery, TLogs may not be able to pull data from previous generation TLogs due to gray
				// failures. In this case, we rely on the latest recruitment information and see if any newly recruited
				// TLogs are degraded.
				for (const auto& tlog : recoveryData->primaryRecruitment.tLogs) {
					if (tlog.addresses().contains(server)) {
						return true;
					}
				}

				if (!skipSatellite) {
					for (const auto& satelliteLog : recoveryData->primaryRecruitment.satelliteTLogs) {
						if (satelliteLog.addresses().contains(server)) {
							return true;
						}
					}
				}
			}

			for (const auto& proxy : dbi.client.grvProxies) {
				if (proxy.addresses().contains(server)) {
					return true;
				}
			}

			for (const auto& proxy : dbi.client.commitProxies) {
				if (proxy.addresses().contains(server)) {
					return true;
				}
			}

			for (const auto& resolver : dbi.resolvers) {
				if (resolver.addresses().contains(server)) {
					return true;
				}
			}
		}
		return false;
	};

	// Check if transaction system contains degraded/disconnected servers. For satellite, we only
	// check for disconnection since the latency between prmary and satellite is across WAN and may not be very
	// stable.
	// TODO: Consider adding satellite latency degradation check and rely on
	//       SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY for accurate health signal
	return transactionWorkerInList(degradationInfo.degradedServers,
	                               /*skipSatellite=*/true,
	                               /*skipRemoteTLog=*/
	                               !(SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY &&
	                                 SERVER_KNOBS->CC_ENABLE_REMOTE_TLOG_DEGRADATION_MONITORING),
	                               /*skipRemoteLogRouter*/
	                               !(SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY &&
	                                 SERVER_KNOBS->CC_ENABLE_REMOTE_LOG_ROUTER_DEGRADATION_MONITORING)) ||
	       transactionWorkerInList(
	           degradationInfo.disconnectedServers,
	           /*skipSatellite=*/false,
	           /*skipRemoteTLog=*/!SERVER_KNOBS->CC_ENABLE_REMOTE_TLOG_DISCONNECT_MONITORING,
	           /*skipRemoteLogRouter*/ !SERVER_KNOBS->CC_ENABLE_REMOTE_LOG_ROUTER_DISCONNECT_MONITORING);
}

bool ClusterControllerData::remoteTransactionSystemContainsDegradedServers() {
	if (db.config.usableRegions <= 1) {
		return false;
	}

	for (const auto& excludedServer : degradationInfo.degradedServers) {
		if (addressInDbAndRemoteDc(excludedServer, db.serverInfo)) {
			return true;
		}
	}

	for (const auto& excludedServer : degradationInfo.disconnectedServers) {
		if (addressInDbAndRemoteDc(excludedServer, db.serverInfo)) {
			return true;
		}
	}

	return false;
}

// Recruit failed log routers in parallel
															#line 578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via recruitLogRouters()
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RecruitLogRoutersActor>
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class RecruitLogRoutersActorState {
															#line 585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RecruitLogRoutersActorState(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,std::vector<int> const& tagIds,int const& logSetIndex,Reference<ILogSystem> const& logSystem,LogSystemConfig const& config) 
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cluster(cluster),
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   db(db),
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tagIds(tagIds),
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   logSetIndex(logSetIndex),
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   logSystem(logSystem),
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   config(config),
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   targetDcId(db->recoveryData->remoteDcIds.size() ? db->recoveryData->remoteDcIds[0] : Optional<Key>())
															#line 604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("recruitLogRouters", reinterpret_cast<unsigned long>(this));

	}
	~RecruitLogRoutersActorState() 
	{
		fdb_probe_actor_destroy("recruitLogRouters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			std::map<Optional<Standalone<StringRef>>, int> id_used;
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->updateKnownIds(&id_used);
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			workers = cluster->getWorkersForRoleInDatacenter(targetDcId, ProcessClass::LogRouter, tagIds.size(), db->config, id_used);
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (workers.size() < tagIds.size())
															#line 625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "NotEnoughWorkersForLogRouters", cluster->id) .detail("Required", tagIds.size()) .detail("Available", workers.size()) .detail("TargetDcId", targetDcId);
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("RecruitingLogRouters", cluster->id) .detail("Count", tagIds.size()) .detail("LogSetIndex", logSetIndex) .detail("TargetDcId", targetDcId);
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			recruitments = std::vector<Future<ErrorOr<TLogInterface>>>();
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < tagIds.size();i++) {
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				Tag routerTag = Tag(tagLocalityLogRouter, tagIds[i]);
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				InitializeLogRouterRequest req;
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.reqId = deterministicRandom()->randomUniqueID();
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.recoveryCount = db->recoveryData->cstate.myDBState.recoveryCount;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.routerTag = routerTag;
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.startVersion = 0;
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.locality = config.tLogs[logSetIndex].locality;
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.isReplacement = true;
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				for( auto& tLogSet : config.tLogs ) {
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!tLogSet.isLocal && tLogSet.tLogs.size() > 0)
															#line 659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						req.tLogLocalities = tLogSet.tLogLocalities;
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						req.tLogPolicy = tLogSet.tLogPolicy;
															#line 665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
						break;
					}
				}
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (db->recoveryData->logSystem.isValid())
															#line 671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					auto lsConfig = db->recoveryData->logSystem->getLogSystemConfig();
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (lsConfig.recoveredAt.present())
															#line 677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						req.recoverAt = lsConfig.recoveredAt.get();
															#line 681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.allowDropInSim = g_network->isSimulated() && deterministicRandom()->coinflip();
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(req.allowDropInSim, "Log router recruitment requests dropped in simulation");
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("RecruitingLogRouterOnWorker", cluster->id) .detail("WorkerID", workers[i].interf.id()) .detail("Tag", routerTag) .detail("TagId", tagIds[i]);
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				recruitments.push_back(workers[i].interf.logRouter.getReplyUnlessFailedFor( req, SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY));
															#line 692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			timeout = delay(SERVER_KNOBS->CC_RERECRUIT_LOG_ROUTER_TIMEOUT);
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(recruitments) || timeout;
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<RecruitLogRoutersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RecruitLogRoutersActor*>(this)->actor_wait_state = 1;
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecruitLogRoutersActor, 0, Void >*>(static_cast<RecruitLogRoutersActor*>(this)));
															#line 705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecruitLogRoutersActorState();
		static_cast<RecruitLogRoutersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (timeout.isReady())
															#line 728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "LogRoutersRecruitmentTimeout", cluster->id) .detail("TagCount", tagIds.size()) .detail("LogSetIndex", logSetIndex);
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < recruitments.size();i++) {
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ErrorOr<TLogInterface> result = recruitments[i].get();
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (result.isError())
															#line 742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "LogRouterRecruitmentFailed", cluster->id) .error(result.getError()) .detail("TagId", tagIds[i]);
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TLogInterface logRouterInterf = result.get();
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			Tag routerTag = Tag(tagLocalityLogRouter, tagIds[i]);
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LogRouterRecruited", cluster->id) .detail("Tag", routerTag) .detail("LogRouterID", logRouterInterf.id()) .detail("WorkerID", workers[i].interf.id()) .detail("LogSetIndex", logSetIndex);
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			logSystem->updateLogRouter(logSetIndex, tagIds[i], logRouterInterf);
															#line 758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData->registrationTrigger.trigger();
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("LogRoutersRecruitmentComplete", cluster->id).detail("Count", tagIds.size());
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RecruitLogRoutersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitLogRoutersActorState(); static_cast<RecruitLogRoutersActor*>(this)->destroy(); return 0; }
															#line 766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RecruitLogRoutersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecruitLogRoutersActorState();
		static_cast<RecruitLogRoutersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (timeout.isReady())
															#line 778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "LogRoutersRecruitmentTimeout", cluster->id) .detail("TagCount", tagIds.size()) .detail("LogSetIndex", logSetIndex);
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < recruitments.size();i++) {
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ErrorOr<TLogInterface> result = recruitments[i].get();
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (result.isError())
															#line 792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "LogRouterRecruitmentFailed", cluster->id) .error(result.getError()) .detail("TagId", tagIds[i]);
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TLogInterface logRouterInterf = result.get();
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			Tag routerTag = Tag(tagLocalityLogRouter, tagIds[i]);
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LogRouterRecruited", cluster->id) .detail("Tag", routerTag) .detail("LogRouterID", logRouterInterf.id()) .detail("WorkerID", workers[i].interf.id()) .detail("LogSetIndex", logSetIndex);
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			logSystem->updateLogRouter(logSetIndex, tagIds[i], logRouterInterf);
															#line 808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData->registrationTrigger.trigger();
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("LogRoutersRecruitmentComplete", cluster->id).detail("Count", tagIds.size());
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RecruitLogRoutersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitLogRoutersActorState(); static_cast<RecruitLogRoutersActor*>(this)->destroy(); return 0; }
															#line 816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RecruitLogRoutersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecruitLogRoutersActorState();
		static_cast<RecruitLogRoutersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecruitLogRoutersActor*>(this)->actor_wait_state > 0) static_cast<RecruitLogRoutersActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitLogRoutersActor*>(this)->ActorCallback< RecruitLogRoutersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitLogRoutersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecruitLogRoutersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecruitLogRoutersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<int> tagIds;
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	int logSetIndex;
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ILogSystem> logSystem;
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	LogSystemConfig config;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<Key> targetDcId;
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<Future<ErrorOr<TLogInterface>>> recruitments;
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> timeout;
															#line 919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via recruitLogRouters()
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class RecruitLogRoutersActor final : public Actor<Void>, public ActorCallback< RecruitLogRoutersActor, 0, Void >, public FastAllocated<RecruitLogRoutersActor>, public RecruitLogRoutersActorState<RecruitLogRoutersActor> {
															#line 924 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<RecruitLogRoutersActor>::operator new;
	using FastAllocated<RecruitLogRoutersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8478609167908197376UL, 2366117119672652032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecruitLogRoutersActor, 0, Void >;
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RecruitLogRoutersActor(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,std::vector<int> const& tagIds,int const& logSetIndex,Reference<ILogSystem> const& logSystem,LogSystemConfig const& config) 
															#line 941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RecruitLogRoutersActorState<RecruitLogRoutersActor>(cluster, db, tagIds, logSetIndex, logSystem, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recruitLogRouters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4436258608070669312UL, 12249527325519498496UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recruitLogRouters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recruitLogRouters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecruitLogRoutersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> recruitLogRouters( ClusterControllerData* const& cluster, ClusterControllerData::DBInfo* const& db, std::vector<int> const& tagIds, int const& logSetIndex, Reference<ILogSystem> const& logSystem, LogSystemConfig const& config ) {
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new RecruitLogRoutersActor(cluster, db, tagIds, logSetIndex, logSystem, config));
															#line 974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 338 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorAndRecruitLogRouters()
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorAndRecruitLogRoutersActor>
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorAndRecruitLogRoutersActorState {
															#line 986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorAndRecruitLogRoutersActorState(ClusterControllerData* const& self) 
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this));

	}
	~MonitorAndRecruitLogRoutersActorState() 
	{
		fdb_probe_actor_destroy("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 1008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorAndRecruitLogRoutersActorState();
		static_cast<MonitorAndRecruitLogRoutersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 1038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(self->db.recoveryData.isValid());
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCount = self->db.recoveryData->cstate.myDBState.recoveryCount;
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		logSystem = self->db.recoveryData->logSystem;
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		config = logSystem->getLogSystemConfig();
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		logSetIndex = -1;
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < config.tLogs.size();i++) {
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (config.tLogs[i].logRouters.size() > 0)
															#line 1059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT_WE_THINK(logSetIndex == -1);
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				logSetIndex = i;
															#line 1065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (logSetIndex == -1)
															#line 1070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("NoLogRoutersToMonitor", self->id).detail("RecoveryCount", recoveryCount).log();
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 1076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::FULLY_RECOVERED))
															#line 1097 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state = 1;
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorAndRecruitLogRoutersActor, 0, Void >*>(static_cast<MonitorAndRecruitLogRoutersActor*>(this)));
															#line 1110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state > 0) static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorAndRecruitLogRoutersActor*>(this)->ActorCallback< MonitorAndRecruitLogRoutersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitLogRoutersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitLogRoutersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorAndRecruitLogRoutersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("LogRouterMonitoringStart", self->id) .detail("LogSetIndex", logSetIndex) .detail("LogRouterCount", config.tLogs[logSetIndex].logRouters.size()) .detail("IsLocal", config.tLogs[logSetIndex].isLocal) .detail("Locality", config.tLogs[logSetIndex].locality) .detail("RecoveryCount", recoveryCount);
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		failedRecuitDelay = 1.0;
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 1223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState == RecoveryState::FULLY_RECOVERED && self->db.recoveryData.isValid() && self->db.recoveryData->cstate.myDBState.recoveryCount == recoveryCount))
															#line 1245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->db.serverInfo->onChange();
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state = 2;
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorAndRecruitLogRoutersActor, 1, Void >*>(static_cast<MonitorAndRecruitLogRoutersActor*>(this)));
															#line 1258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state > 0) static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorAndRecruitLogRoutersActor*>(this)->ActorCallback< MonitorAndRecruitLogRoutersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitLogRoutersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitLogRoutersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorAndRecruitLogRoutersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->db.recoveryData.isValid() || !self->db.recoveryData->logSystem.isValid() || self->db.serverInfo->get().recoveryState < RecoveryState::FULLY_RECOVERED || self->db.recoveryData->cstate.myDBState.recoveryCount != recoveryCount)
															#line 1380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LogRouterMonitoringEnded", self->id) .detail("Reason", "RecoveryChanged") .detail("OldRecoveryCount", recoveryCount) .detail("NewRecoveryCount", self->db.recoveryData.isValid() ? self->db.recoveryData->cstate.myDBState.recoveryCount : -1);
															#line 1384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		failures = std::vector<Future<Void>>();
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		config = logSystem->getLogSystemConfig();
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(config.tLogs[logSetIndex].logRouters.size() > 0);
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < config.tLogs[logSetIndex].logRouters.size();i++) {
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(config.tLogs[logSetIndex].logRouters[i].present());
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto& logRouter = config.tLogs[logSetIndex].logRouters[i];
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			failures.push_back( waitFailureClient(logRouter.interf().waitFailure, SERVER_KNOBS->TLOG_TIMEOUT, -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY, true));
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LogRouterMonitoring", self->id) .detail("TagId", i) .detail("RouterID", logRouter.interf().id());
															#line 1403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = quorum(failures, 1);
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->db.serverInfo->onChange();
															#line 1413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1when2(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state = 3;
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorAndRecruitLogRoutersActor, 2, Void >*>(static_cast<MonitorAndRecruitLogRoutersActor*>(this)));
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorAndRecruitLogRoutersActor, 3, Void >*>(static_cast<MonitorAndRecruitLogRoutersActor*>(this)));
															#line 1420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		failedTagIds = std::vector<int>();
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		newConfig = logSystem->getLogSystemConfig();
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < failures.size();i++) {
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (failures[i].isReady() || failures[i].isError())
															#line 1448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				failedTagIds.push_back(i);
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "LogRouterMonitoringFoundFailed", self->id).detail("TagId", i);
															#line 1454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT_WE_THINK(!failedTagIds.empty());
															#line 1459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		try {
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_4 = recruitLogRouters(self, &self->db, failedTagIds, logSetIndex, logSystem, newConfig);
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont2loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state = 4;
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorAndRecruitLogRoutersActor, 4, Void >*>(static_cast<MonitorAndRecruitLogRoutersActor*>(this)));
															#line 1470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont2loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont2loopHead1(loopDepth); // continue

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state > 0) static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorAndRecruitLogRoutersActor*>(this)->ActorCallback< MonitorAndRecruitLogRoutersActor, 2, Void >::remove();
		static_cast<MonitorAndRecruitLogRoutersActor*>(this)->ActorCallback< MonitorAndRecruitLogRoutersActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitLogRoutersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitLogRoutersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorAndRecruitLogRoutersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitLogRoutersActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitLogRoutersActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorAndRecruitLogRoutersActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont2loopBody1cont4(int loopDepth) 
	{
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delay(failedRecuitDelay);
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1cont4when1(__when_expr_5.get(), loopDepth); };
		static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state = 5;
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MonitorAndRecruitLogRoutersActor, 5, Void >*>(static_cast<MonitorAndRecruitLogRoutersActor*>(this)));
															#line 1637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			CODE_PROBE(true, "Log router re-recruitment failed");
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedRecuitDelay = std::min(failedRecuitDelay * 2, 60.0);
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarnAlways, "LogRoutersRecruitmentFailed", self->id) .error(e) .detail("FailedCount", failedTagIds.size()) .detail("LogSetIndex", logSetIndex) .detail("NextRetryDelay", failedRecuitDelay);
															#line 1651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont2loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		failedRecuitDelay = 1.0;
															#line 1666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		failedRecuitDelay = 1.0;
															#line 1675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state > 0) static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorAndRecruitLogRoutersActor*>(this)->ActorCallback< MonitorAndRecruitLogRoutersActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitLogRoutersActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitLogRoutersActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorAndRecruitLogRoutersActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont2loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont10(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont10(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state > 0) static_cast<MonitorAndRecruitLogRoutersActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorAndRecruitLogRoutersActor*>(this)->ActorCallback< MonitorAndRecruitLogRoutersActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitLogRoutersActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitLogRoutersActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< MonitorAndRecruitLogRoutersActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	uint64_t recoveryCount;
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ILogSystem> logSystem;
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	LogSystemConfig config;
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	int logSetIndex;
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	double failedRecuitDelay;
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<Future<Void>> failures;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<int> failedTagIds;
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	LogSystemConfig newConfig;
															#line 1873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorAndRecruitLogRouters()
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorAndRecruitLogRoutersActor final : public Actor<Void>, public ActorCallback< MonitorAndRecruitLogRoutersActor, 0, Void >, public ActorCallback< MonitorAndRecruitLogRoutersActor, 1, Void >, public ActorCallback< MonitorAndRecruitLogRoutersActor, 2, Void >, public ActorCallback< MonitorAndRecruitLogRoutersActor, 3, Void >, public ActorCallback< MonitorAndRecruitLogRoutersActor, 4, Void >, public ActorCallback< MonitorAndRecruitLogRoutersActor, 5, Void >, public FastAllocated<MonitorAndRecruitLogRoutersActor>, public MonitorAndRecruitLogRoutersActorState<MonitorAndRecruitLogRoutersActor> {
															#line 1878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorAndRecruitLogRoutersActor>::operator new;
	using FastAllocated<MonitorAndRecruitLogRoutersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2995230544002257664UL, 12429182719583775232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorAndRecruitLogRoutersActor, 0, Void >;
friend struct ActorCallback< MonitorAndRecruitLogRoutersActor, 1, Void >;
friend struct ActorCallback< MonitorAndRecruitLogRoutersActor, 2, Void >;
friend struct ActorCallback< MonitorAndRecruitLogRoutersActor, 3, Void >;
friend struct ActorCallback< MonitorAndRecruitLogRoutersActor, 4, Void >;
friend struct ActorCallback< MonitorAndRecruitLogRoutersActor, 5, Void >;
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorAndRecruitLogRoutersActor(ClusterControllerData* const& self) 
															#line 1900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorAndRecruitLogRoutersActorState<MonitorAndRecruitLogRoutersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10378273730821967872UL, 5851003174457475072UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorAndRecruitLogRouters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorAndRecruitLogRouters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorAndRecruitLogRoutersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorAndRecruitLogRoutersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorAndRecruitLogRoutersActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorAndRecruitLogRoutersActor, 4, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorAndRecruitLogRoutersActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorAndRecruitLogRouters( ClusterControllerData* const& self ) {
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorAndRecruitLogRoutersActor(self));
															#line 1937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 456 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 1942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via clusterWatchDatabase()
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterWatchDatabaseActor>
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterWatchDatabaseActorState {
															#line 1949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterWatchDatabaseActorState(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,ServerCoordinators const& coordinators) 
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cluster(cluster),
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   db(db),
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   coordinators(coordinators),
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   iMaster(),
															#line 461 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   addActor(),
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recoveryCore()
															#line 1966 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clusterWatchDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClusterWatchDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clusterWatchDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 1981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterWatchDatabaseActorState();
		static_cast<ClusterWatchDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 468 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).log();
															#line 2011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		try {
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			recoveryStart = now();
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			newMaster = MasterInterface();
															#line 472 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			collection = Future<Void>();
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCWDB", cluster->id).detail("Recruiting", "Master");
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = recruitNewMaster(cluster, db, std::addressof(newMaster));
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 1;
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 0, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			err = e;
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCWDB", cluster->id).errorUnsuppressed(e).detail("Master", iMaster.id());
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 2056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_8 = delay(0.0);
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
				static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 5;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 8, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		iMaster = newMaster;
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->masterRegistrationCount = 0;
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryStalled = false;
															#line 482 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto dbInfo = ServerDBInfo();
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.master = iMaster;
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.id = deterministicRandom()->randomUniqueID();
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.infoGeneration = ++db->dbInfoCount;
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.masterLifetime = db->serverInfo->get().masterLifetime;
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		++dbInfo.masterLifetime;
															#line 488 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.clusterInterface = db->serverInfo->get().clusterInterface;
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.distributor = db->serverInfo->get().distributor;
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.ratekeeper = db->serverInfo->get().ratekeeper;
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.consistencyScan = db->serverInfo->get().consistencyScan;
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.latencyBandConfig = db->serverInfo->get().latencyBandConfig;
															#line 493 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.myLocality = db->serverInfo->get().myLocality;
															#line 494 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client = ClientDBInfo();
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.encryptKeyProxy = db->serverInfo->get().client.encryptKeyProxy;
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterId = db->serverInfo->get().client.clusterId;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterType = db->clusterType;
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id) .detail("NewMaster", dbInfo.master.id().toString()) .detail("Lifetime", dbInfo.masterLifetime.toString()) .detail("ChangeID", dbInfo.id);
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(dbInfo);
															#line 505 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		spinDelay = delay( SERVER_KNOBS ->MASTER_SPIN_DELAY);
															#line 510 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).detail("Watching", iMaster.id());
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData = makeReference<ClusterRecoveryData>(cluster, db->serverInfo, db->serverInfo->get().master, db->serverInfo->get().masterLifetime, coordinators, db->serverInfo->get().clusterInterface, ""_sr, addActor, db->forceRecovery);
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		collection = actorCollection(db->recoveryData->addActor.getFuture());
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore = clusterRecoveryCore(db->recoveryData);
															#line 523 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->recentHealthTriggeredRecoveryTime.push(now());
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 2141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		iMaster = newMaster;
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->masterRegistrationCount = 0;
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryStalled = false;
															#line 482 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto dbInfo = ServerDBInfo();
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.master = iMaster;
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.id = deterministicRandom()->randomUniqueID();
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.infoGeneration = ++db->dbInfoCount;
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.masterLifetime = db->serverInfo->get().masterLifetime;
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		++dbInfo.masterLifetime;
															#line 488 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.clusterInterface = db->serverInfo->get().clusterInterface;
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.distributor = db->serverInfo->get().distributor;
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.ratekeeper = db->serverInfo->get().ratekeeper;
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.consistencyScan = db->serverInfo->get().consistencyScan;
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.latencyBandConfig = db->serverInfo->get().latencyBandConfig;
															#line 493 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.myLocality = db->serverInfo->get().myLocality;
															#line 494 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client = ClientDBInfo();
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.encryptKeyProxy = db->serverInfo->get().client.encryptKeyProxy;
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterId = db->serverInfo->get().client.clusterId;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterType = db->clusterType;
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id) .detail("NewMaster", dbInfo.master.id().toString()) .detail("Lifetime", dbInfo.masterLifetime.toString()) .detail("ChangeID", dbInfo.id);
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(dbInfo);
															#line 505 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		spinDelay = delay( SERVER_KNOBS ->MASTER_SPIN_DELAY);
															#line 510 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).detail("Watching", iMaster.id());
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData = makeReference<ClusterRecoveryData>(cluster, db->serverInfo, db->serverInfo->get().master, db->serverInfo->get().masterLifetime, coordinators, db->serverInfo->get().clusterInterface, ""_sr, addActor, db->forceRecovery);
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		collection = actorCollection(db->recoveryData->addActor.getFuture());
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore = clusterRecoveryCore(db->recoveryData);
															#line 523 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->recentHealthTriggeredRecoveryTime.push(now());
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 2204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide)
															#line 2288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1loopBody1Catch1(restart_cluster_controller(), loopDepth);
															#line 2292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore.cancel();
															#line 563 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = cleanupRecoveryActorCollection(db->recoveryData, false);
															#line 563 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 3;
															#line 563 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 6, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 528 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = recoveryCore;
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = traceAfter(waitFailureClient( iMaster.waitFailure, db->masterRegistrationCount ? SERVER_KNOBS->MASTER_FAILURE_REACTION_TIME : (now() - recoveryStart) * SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY, db->masterRegistrationCount ? -SERVER_KNOBS->MASTER_FAILURE_REACTION_TIME / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY : SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY), "CCWDBMasterFailed") || traceAfter(db->forceMasterFailure.onTrigger(), "CCWDBForceMasterFailureTriggered");
															#line 2327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = db->serverInfo->onChange();
															#line 2331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when3(__when_expr_3.get(), loopDepth); };
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto __when_expr_4 = db->serverInfo->get().clusterInterface.notifyBackupWorkerDone.getFuture();
															#line 2335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<BackupWorkerDoneRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<BackupWorkerDoneRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when4(__when_expr_4.pop(), loopDepth); };
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = collection;
															#line 2340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when5(__when_expr_5.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 2;
															#line 528 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 1, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 2, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 3, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 5, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when4(BackupWorkerDoneRequest const& req,int loopDepth) 
	{
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (db->recoveryData->logSystem.isValid() && db->recoveryData->logSystem->removeBackupWorker(req))
															#line 2417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->recoveryData->registrationTrigger.trigger();
															#line 2421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		++db->recoveryData->backupWorkerDoneRequests;
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevDebug, "BackupWorkerDoneRequest", cluster->id).log();
															#line 2429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when4(BackupWorkerDoneRequest && req,int loopDepth) 
	{
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (db->recoveryData->logSystem.isValid() && db->recoveryData->logSystem->removeBackupWorker(req))
															#line 2438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->recoveryData->registrationTrigger.trigger();
															#line 2442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		++db->recoveryData->backupWorkerDoneRequests;
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevDebug, "BackupWorkerDoneRequest", cluster->id).log();
															#line 2450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when5(Void const& _,int loopDepth) 
	{
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 2459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when5(Void && _,int loopDepth) 
	{
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 2467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 1, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 2, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 3, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,BackupWorkerDoneRequest const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,BackupWorkerDoneRequest && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_7 = spinDelay;
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_7.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 4;
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 7, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_7 = spinDelay;
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_7.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 4;
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 7, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(true, "clusterWatchDatabase() master failed");
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevWarn, "DetectedFailedRecovery", cluster->id).detail("OldMaster", iMaster.id());
															#line 2883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(true, "clusterWatchDatabase() master failed");
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevWarn, "DetectedFailedRecovery", cluster->id).detail("OldMaster", iMaster.id());
															#line 2894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore.cancel();
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_9 = cleanupRecoveryActorCollection(db->recoveryData, true);
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 6;
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 9, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 3000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRemoteRequestChecker.isValid())
															#line 3098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRemoteRequestChecker.cancel();
															#line 3102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRequestChecker.isValid())
															#line 3106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRequestChecker.cancel();
															#line 3110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_tlog_failed, "Terminated due to tLog failure");
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_commit_proxy_failed, "Terminated due to commit proxy failure");
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_grv_proxy_failed, "Terminated due to GRV proxy failure");
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_resolver_failed, "Terminated due to resolver failure");
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_backup_worker_failed, "Terminated due to backup worker failure");
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_operation_failed, "Terminated due to failed operation", probe::decoration::rare);
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_restart_cluster_controller, "Terminated due to cluster-controller restart.");
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide || err.code() == error_code_coordinators_changed)
															#line 3128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 599 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerTerminate", cluster->id).errorUnsuppressed(err);
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(restart_cluster_controller(), std::max(0, loopDepth - 1));
															#line 3134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (isNormalClusterRecoveryError(err))
															#line 3138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "ClusterRecoveryRetrying", cluster->id).error(err);
															#line 3142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 606 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "ClusterWatchDatabaseRetrying", cluster->id).error(err);
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 3150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 7;
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 10, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 3161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRemoteRequestChecker.isValid())
															#line 3172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRemoteRequestChecker.cancel();
															#line 3176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRequestChecker.isValid())
															#line 3180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRequestChecker.cancel();
															#line 3184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_tlog_failed, "Terminated due to tLog failure");
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_commit_proxy_failed, "Terminated due to commit proxy failure");
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_grv_proxy_failed, "Terminated due to GRV proxy failure");
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_resolver_failed, "Terminated due to resolver failure");
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_backup_worker_failed, "Terminated due to backup worker failure");
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_operation_failed, "Terminated due to failed operation", probe::decoration::rare);
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_restart_cluster_controller, "Terminated due to cluster-controller restart.");
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide || err.code() == error_code_coordinators_changed)
															#line 3202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 599 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerTerminate", cluster->id).errorUnsuppressed(err);
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(restart_cluster_controller(), std::max(0, loopDepth - 1));
															#line 3208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (isNormalClusterRecoveryError(err))
															#line 3212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "ClusterRecoveryRetrying", cluster->id).error(err);
															#line 3216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 606 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "ClusterWatchDatabaseRetrying", cluster->id).error(err);
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 3224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 7;
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 10, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 3235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ServerCoordinators coordinators;
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MasterInterface iMaster;
															#line 461 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> recoveryCore;
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	double recoveryStart;
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MasterInterface newMaster;
															#line 472 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> collection;
															#line 505 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> spinDelay;
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Error err;
															#line 3424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clusterWatchDatabase()
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterWatchDatabaseActor final : public Actor<Void>, public ActorCallback< ClusterWatchDatabaseActor, 0, Void >, public ActorCallback< ClusterWatchDatabaseActor, 1, Void >, public ActorCallback< ClusterWatchDatabaseActor, 2, Void >, public ActorCallback< ClusterWatchDatabaseActor, 3, Void >, public ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >, public ActorCallback< ClusterWatchDatabaseActor, 5, Void >, public ActorCallback< ClusterWatchDatabaseActor, 6, Void >, public ActorCallback< ClusterWatchDatabaseActor, 7, Void >, public ActorCallback< ClusterWatchDatabaseActor, 8, Void >, public ActorCallback< ClusterWatchDatabaseActor, 9, Void >, public ActorCallback< ClusterWatchDatabaseActor, 10, Void >, public FastAllocated<ClusterWatchDatabaseActor>, public ClusterWatchDatabaseActorState<ClusterWatchDatabaseActor> {
															#line 3429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClusterWatchDatabaseActor>::operator new;
	using FastAllocated<ClusterWatchDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16354995247916866304UL, 15972014393728437504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterWatchDatabaseActor, 0, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 1, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 2, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 3, Void >;
friend struct ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 5, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 6, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 7, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 8, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 9, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 10, Void >;
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterWatchDatabaseActor(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,ServerCoordinators const& coordinators) 
															#line 3456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClusterWatchDatabaseActorState<ClusterWatchDatabaseActor>(cluster, db, coordinators),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15084720662247522304UL, 7134482422509323520UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterWatchDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 6, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 7, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 8, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 9, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterWatchDatabase( ClusterControllerData* const& cluster, ClusterControllerData::DBInfo* const& db, ServerCoordinators const& coordinators ) {
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterWatchDatabaseActor(cluster, db, coordinators));
															#line 3495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 613 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 3500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via clusterGetServerInfo()
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterGetServerInfoActor>
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterGetServerInfoActorState {
															#line 3507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterGetServerInfoActorState(ClusterControllerData::DBInfo* const& db,UID const& knownServerInfoID,ReplyPromise<ServerDBInfo> const& reply) 
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db),
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   knownServerInfoID(knownServerInfoID),
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   reply(reply)
															#line 3518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clusterGetServerInfo", reinterpret_cast<unsigned long>(this));

	}
	~ClusterGetServerInfoActorState() 
	{
		fdb_probe_actor_destroy("clusterGetServerInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 3533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterGetServerInfoActorState();
		static_cast<ClusterGetServerInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		reply.send(db->serverInfo->get());
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<ClusterGetServerInfoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterGetServerInfoActorState(); static_cast<ClusterGetServerInfoActor*>(this)->destroy(); return 0; }
															#line 3558 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<ClusterGetServerInfoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClusterGetServerInfoActorState();
		static_cast<ClusterGetServerInfoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(db->serverInfo->get().id == knownServerInfoID))
															#line 3577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yieldedFuture(db->serverInfo->onChange());
															#line 618 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(300);
															#line 3589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state = 1;
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterGetServerInfoActor, 0, Void >*>(static_cast<ClusterGetServerInfoActor*>(this)));
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterGetServerInfoActor, 1, Void >*>(static_cast<ClusterGetServerInfoActor*>(this)));
															#line 3596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state > 0) static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterGetServerInfoActor*>(this)->ActorCallback< ClusterGetServerInfoActor, 0, Void >::remove();
		static_cast<ClusterGetServerInfoActor*>(this)->ActorCallback< ClusterGetServerInfoActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID knownServerInfoID;
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReplyPromise<ServerDBInfo> reply;
															#line 3771 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clusterGetServerInfo()
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterGetServerInfoActor final : public Actor<Void>, public ActorCallback< ClusterGetServerInfoActor, 0, Void >, public ActorCallback< ClusterGetServerInfoActor, 1, Void >, public FastAllocated<ClusterGetServerInfoActor>, public ClusterGetServerInfoActorState<ClusterGetServerInfoActor> {
															#line 3776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClusterGetServerInfoActor>::operator new;
	using FastAllocated<ClusterGetServerInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8106796369488168448UL, 265852425952525056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterGetServerInfoActor, 0, Void >;
friend struct ActorCallback< ClusterGetServerInfoActor, 1, Void >;
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterGetServerInfoActor(ClusterControllerData::DBInfo* const& db,UID const& knownServerInfoID,ReplyPromise<ServerDBInfo> const& reply) 
															#line 3794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClusterGetServerInfoActorState<ClusterGetServerInfoActor>(db, knownServerInfoID, reply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8722247202050210304UL, 18223546808676413184UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterGetServerInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterGetServerInfoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterGetServerInfo( ClusterControllerData::DBInfo* const& db, UID const& knownServerInfoID, ReplyPromise<ServerDBInfo> const& reply ) {
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterGetServerInfoActor(db, knownServerInfoID, reply));
															#line 3827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 628 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 3832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via clusterOpenDatabase()
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterOpenDatabaseActor>
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterOpenDatabaseActorState {
															#line 3839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterOpenDatabaseActorState(ClusterControllerData::DBInfo* const& db,OpenDatabaseRequest const& req) 
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db),
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req)
															#line 3848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clusterOpenDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClusterOpenDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clusterOpenDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->clientStatus[req.reply.getEndpoint().getPrimaryAddress()] = std::make_pair(now(), req);
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (db->clientStatus.size() > 10000)
															#line 3865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyClientStatusEntries").suppressFor(1.0);
															#line 3869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 3873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterOpenDatabaseActorState();
		static_cast<ClusterOpenDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 644 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(db->clientInfo->get());
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<ClusterOpenDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterOpenDatabaseActorState(); static_cast<ClusterOpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 3898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<ClusterOpenDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClusterOpenDatabaseActorState();
		static_cast<ClusterOpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(db->clientInfo->get().id == req.knownClientInfoID))
															#line 3917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->clientInfo->onChange();
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(SERVER_KNOBS->COORDINATOR_REGISTER_INTERVAL);
															#line 3929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state = 1;
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterOpenDatabaseActor, 0, Void >*>(static_cast<ClusterOpenDatabaseActor*>(this)));
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterOpenDatabaseActor, 1, Void >*>(static_cast<ClusterOpenDatabaseActor*>(this)));
															#line 3936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterOpenDatabaseActor*>(this)->ActorCallback< ClusterOpenDatabaseActor, 0, Void >::remove();
		static_cast<ClusterOpenDatabaseActor*>(this)->ActorCallback< ClusterOpenDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	OpenDatabaseRequest req;
															#line 4109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clusterOpenDatabase()
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterOpenDatabaseActor final : public Actor<Void>, public ActorCallback< ClusterOpenDatabaseActor, 0, Void >, public ActorCallback< ClusterOpenDatabaseActor, 1, Void >, public FastAllocated<ClusterOpenDatabaseActor>, public ClusterOpenDatabaseActorState<ClusterOpenDatabaseActor> {
															#line 4114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClusterOpenDatabaseActor>::operator new;
	using FastAllocated<ClusterOpenDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4672961044548123136UL, 17161609222086196736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterOpenDatabaseActor, 0, Void >;
friend struct ActorCallback< ClusterOpenDatabaseActor, 1, Void >;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterOpenDatabaseActor(ClusterControllerData::DBInfo* const& db,OpenDatabaseRequest const& req) 
															#line 4132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClusterOpenDatabaseActorState<ClusterOpenDatabaseActor>(db, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4479359797486159872UL, 7876825679301567232UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterOpenDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterOpenDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterOpenDatabase( ClusterControllerData::DBInfo* const& db, OpenDatabaseRequest const& req ) {
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterOpenDatabaseActor(db, req));
															#line 4165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 647 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

void checkOutstandingRecruitmentRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingRecruitmentRequests.size(); i++) {
		Reference<RecruitWorkersInfo> info = self->outstandingRecruitmentRequests[i];
		try {
			info->rep = self->findWorkersForConfiguration(info->req);
			if (info->dbgId.present()) {
				TraceEvent("CheckOutstandingRecruitment", info->dbgId.get())
				    .detail("Request", info->req.configuration.toString());
			}
			info->waitForCompletion.trigger();
			swapAndPop(&self->outstandingRecruitmentRequests, i--);
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers || e.code() == error_code_operation_failed) {
				TraceEvent(SevWarn, "RecruitTLogMatchingSetNotAvailable", self->id).error(e);
			} else {
				TraceEvent(SevError, "RecruitTLogsRequestError", self->id).error(e);
				throw;
			}
		}
	}
}

void checkOutstandingRemoteRecruitmentRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingRemoteRecruitmentRequests.size(); i++) {
		Reference<RecruitRemoteWorkersInfo> info = self->outstandingRemoteRecruitmentRequests[i];
		try {
			info->rep = self->findRemoteWorkersForConfiguration(info->req);
			if (info->dbgId.present()) {
				TraceEvent("CheckOutstandingRemoteRecruitment", info->dbgId.get())
				    .detail("Request", info->req.configuration.toString());
			}
			info->waitForCompletion.trigger();
			swapAndPop(&self->outstandingRemoteRecruitmentRequests, i--);
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers || e.code() == error_code_operation_failed) {
				TraceEvent(SevWarn, "RecruitRemoteTLogMatchingSetNotAvailable", self->id).error(e);
			} else {
				TraceEvent(SevError, "RecruitRemoteTLogsRequestError", self->id).error(e);
				throw;
			}
		}
	}
}

void checkOutstandingStorageRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingStorageRequests.size(); i++) {
		auto& req = self->outstandingStorageRequests[i];
		try {
			if (req.second < now()) {
				req.first.reply.sendError(timed_out());
				swapAndPop(&self->outstandingStorageRequests, i--);
			} else {
				if (!self->gotProcessClasses && !req.first.criticalRecruitment)
					throw no_more_servers();

				auto worker = self->getStorageWorker(req.first);
				RecruitStorageReply rep;
				rep.worker = worker.interf;
				rep.processClass = worker.processClass;
				req.first.reply.send(rep);
				swapAndPop(&self->outstandingStorageRequests, i--);
			}
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers) {
				TraceEvent(SevWarn, "RecruitStorageNotAvailable", self->id)
				    .errorUnsuppressed(e)
				    .suppressFor(1.0)
				    .detail("OutstandingReq", i)
				    .detail("IsCriticalRecruitment", req.first.criticalRecruitment);
			} else {
				TraceEvent(SevError, "RecruitStorageError", self->id).error(e);
				throw;
			}
		}
	}
}

// Finds and returns a new process for role
WorkerDetails findNewProcessForSingleton(ClusterControllerData* self,
                                         const ProcessClass::ClusterRole role,
                                         std::map<Optional<Standalone<StringRef>>, int>& id_used) {
	// find new process in cluster for role
	WorkerDetails newWorker =
	    self->getWorkerForRoleInDatacenter(
	            self->clusterControllerDcId, role, ProcessClass::NeverAssign, self->db.config, id_used, {}, true)
	        .worker;

	// check if master's process is actually better suited for role
	if (self->onMasterIsBetter(newWorker, role)) {
		newWorker = self->id_worker[self->masterProcessId.get()].details;
	}

	// acknowledge that the pid is now potentially used by this role as well
	id_used[newWorker.interf.locality.processId()]++;

	return newWorker;
}

// Return best possible fitness for singleton. Note that lower fitness is better.
ProcessClass::Fitness findBestFitnessForSingleton(const ClusterControllerData* self,
                                                  const WorkerDetails& worker,
                                                  const ProcessClass::ClusterRole& role) {
	auto bestFitness = worker.processClass.machineClassFitness(role);
	// If the process has been marked as excluded, we take the max with ExcludeFit to ensure its fit
	// is at least as bad as ExcludeFit. This assists with successfully offboarding such processes
	// and removing them from the cluster.
	if (self->db.config.isExcludedServer(worker.interf.addresses(), worker.interf.locality)) {
		bestFitness = std::max(bestFitness, ProcessClass::ExcludeFit);
	}
	return bestFitness;
}

// Returns true iff the singleton is healthy. "Healthy" here means that
// the singleton is stable (see below) and doesn't need to be rerecruited.
// Side effects: (possibly) initiates recruitment
template <class SingletonClass>
bool isHealthySingleton(ClusterControllerData* self,
                        const WorkerDetails& newWorker,
                        const SingletonClass& singleton,
                        const ProcessClass::Fitness& bestFitness,
                        const Optional<UID> recruitingID) {
	// A singleton is stable if it exists in cluster, has not been killed off of proc and is not being recruited
	bool isStableSingleton = singleton.isPresent() &&
	                         self->id_worker.contains(singleton.getInterface().locality.processId()) &&
	                         (!recruitingID.present() || (recruitingID.get() == singleton.getInterface().id()));

	if (!isStableSingleton) {
		return false; // not healthy because unstable
	}

	auto& currWorker = self->id_worker[singleton.getInterface().locality.processId()];
	auto currFitness = currWorker.details.processClass.machineClassFitness(singleton.getClusterRole());
	if (currWorker.priorityInfo.isExcluded) {
		currFitness = ProcessClass::ExcludeFit;
	}
	// If any of the following conditions are met, we will switch the singleton's process:
	// - if the current proc is used by some non-master, non-singleton role
	// - if the current fitness is less than optimal (lower fitness is better)
	// - if currently at peak fitness but on same process as master, and the new worker is on different process
	bool shouldRerecruit =
	    self->isUsedNotMaster(currWorker.details.interf.locality.processId()) || bestFitness < currFitness ||
	    (currFitness == bestFitness && currWorker.details.interf.locality.processId() == self->masterProcessId &&
	     newWorker.interf.locality.processId() != self->masterProcessId);
	if (g_network->isSimulated() && singleton.getRole() == Role::DATA_DISTRIBUTOR &&
	    SERVER_KNOBS->CC_ENFORCE_USE_UNFIT_DD_IN_SIM) {
		// It is possible that DD location is not optimal in the simulation.
		// This can cause the simulation stuck if it always halts DD.
		// TODO(BulkLoad): this is a work around. We should figure out why DD can be repeatedly
		// terminated by CC throughout the simulation.
		shouldRerecruit = false;
	}
	if (shouldRerecruit) {
		std::string roleAbbr = singleton.getRole().abbreviation;
		TraceEvent(("CCHalt" + roleAbbr).c_str(), self->id)
		    .detail(roleAbbr + "ID", singleton.getInterface().id())
		    .detail("Excluded", currWorker.priorityInfo.isExcluded)
		    .detail("Fitness", currFitness)
		    .detail("BestFitness", bestFitness)
		    .detail("MasterProcessId", self->masterProcessId)
		    .detail("CurrentWorkerProcessId", currWorker.details.interf.locality.processId())
		    .detail("NewWorkerProcessId", newWorker.interf.locality.processId())
		    .detail("IsUsedNotMaster", self->isUsedNotMaster(currWorker.details.interf.locality.processId()));
		singleton.recruit(*self); // SIDE EFFECT: initiating recruitment
		return false; // not healthy since needed to be rerecruited
	} else {
		return true; // healthy because doesn't need to be rerecruited
	}
}

// Returns a mapping from pid->pidCount for pids
std::map<Optional<Standalone<StringRef>>, int> getColocCounts(
    const std::vector<Optional<Standalone<StringRef>>>& pids) {
	std::map<Optional<Standalone<StringRef>>, int> counts;
	for (const auto& pid : pids) {
		if (pid.present()) {
			++counts[pid];
		}
	}
	return counts;
}

// Checks if there exists a better process for each singleton (e.g. DD) compared
// to the process it is currently on.
// When adding new singletons, just follow the ratekeeper/data distributor examples.
void checkBetterSingletons(ClusterControllerData* self) {
	if (!self->masterProcessId.present() ||
	    self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS) {
		return;
	}

	// note: this map doesn't consider pids used by existing singletons
	std::map<Optional<Standalone<StringRef>>, int> id_used = self->getUsedIds();

	// We prefer spreading out other roles more than separating singletons on their own process
	// so we artificially amplify the pid count for the processes used by non-singleton roles.
	// In other words, we make the processes used for other roles less desirable to be used
	// by singletons as well.
	for (auto& it : id_used) {
		it.second *= PID_USED_AMP_FOR_NON_SINGLETON;
	}

	// Try to find a new process for each singleton.
	WorkerDetails newRKWorker = findNewProcessForSingleton(self, ProcessClass::Ratekeeper, id_used);
	WorkerDetails newDDWorker = findNewProcessForSingleton(self, ProcessClass::DataDistributor, id_used);
	WorkerDetails newCSWorker = findNewProcessForSingleton(self, ProcessClass::ConsistencyScan, id_used);

	WorkerDetails newEKPWorker;
	EncryptionAtRestMode encryptMode = self->db.config.encryptionAtRestMode;
	const bool enableKmsCommunication =
	    encryptMode.isEncryptionEnabled() || SERVER_KNOBS->ENABLE_REST_KMS_COMMUNICATION;
	if (enableKmsCommunication) {
		newEKPWorker = findNewProcessForSingleton(self, ProcessClass::EncryptKeyProxy, id_used);
	}

	// Find best possible fitnesses for each singleton.
	auto bestFitnessForRK = findBestFitnessForSingleton(self, newRKWorker, ProcessClass::Ratekeeper);
	auto bestFitnessForDD = findBestFitnessForSingleton(self, newDDWorker, ProcessClass::DataDistributor);
	auto bestFitnessForCS = findBestFitnessForSingleton(self, newCSWorker, ProcessClass::ConsistencyScan);

	ProcessClass::Fitness bestFitnessForEKP;
	if (enableKmsCommunication) {
		bestFitnessForEKP = findBestFitnessForSingleton(self, newEKPWorker, ProcessClass::EncryptKeyProxy);
	}

	auto& db = self->db.serverInfo->get();
	auto rkSingleton = RatekeeperSingleton(db.ratekeeper);
	auto ddSingleton = DataDistributorSingleton(db.distributor);
	ConsistencyScanSingleton csSingleton(db.consistencyScan);
	EncryptKeyProxySingleton ekpSingleton(db.client.encryptKeyProxy);

	// Check if the singletons are healthy.
	// side effect: try to rerecruit the singletons to more optimal processes
	bool rkHealthy = isHealthySingleton<RatekeeperSingleton>(
	    self, newRKWorker, rkSingleton, bestFitnessForRK, self->recruitingRatekeeperID);

	bool ddHealthy = isHealthySingleton<DataDistributorSingleton>(
	    self, newDDWorker, ddSingleton, bestFitnessForDD, self->recruitingDistributorID);

	bool csHealthy = isHealthySingleton<ConsistencyScanSingleton>(
	    self, newCSWorker, csSingleton, bestFitnessForCS, self->recruitingConsistencyScanID);

	bool ekpHealthy = true;
	if (enableKmsCommunication) {
		ekpHealthy = isHealthySingleton<EncryptKeyProxySingleton>(
		    self, newEKPWorker, ekpSingleton, bestFitnessForEKP, self->recruitingEncryptKeyProxyID);
	}
	// if any of the singletons are unhealthy (rerecruited or not stable), then do not
	// consider any further re-recruitments
	if (!(rkHealthy && ddHealthy && ekpHealthy && csHealthy)) {
		return;
	}

	// if we reach here, we know that the singletons are healthy so let's
	// check if we can colocate the singletons in a more optimal way
	Optional<Standalone<StringRef>> currRKProcessId = rkSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> currDDProcessId = ddSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> currCSProcessId = csSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> newRKProcessId = newRKWorker.interf.locality.processId();
	Optional<Standalone<StringRef>> newDDProcessId = newDDWorker.interf.locality.processId();
	Optional<Standalone<StringRef>> newCSProcessId = newCSWorker.interf.locality.processId();

	Optional<Standalone<StringRef>> currEKPProcessId, newEKPProcessId;
	if (enableKmsCommunication) {
		currEKPProcessId = ekpSingleton.getInterface().locality.processId();
		newEKPProcessId = newEKPWorker.interf.locality.processId();
	}

	std::vector<Optional<Standalone<StringRef>>> currPids = { currRKProcessId, currDDProcessId, currCSProcessId };
	std::vector<Optional<Standalone<StringRef>>> newPids = { newRKProcessId, newDDProcessId, newCSProcessId };
	if (enableKmsCommunication) {
		currPids.emplace_back(currEKPProcessId);
		newPids.emplace_back(newEKPProcessId);
	}

	auto currColocMap = getColocCounts(currPids);
	auto newColocMap = getColocCounts(newPids);

	// if the knob is disabled, the EKP coloc counts should have no affect on the coloc counts check below
	if (!enableKmsCommunication) {
		ASSERT(currColocMap[currEKPProcessId] == 0);
		ASSERT(newColocMap[newEKPProcessId] == 0);
	}

	// if the new coloc counts are collectively better (i.e. each singleton's coloc count has not increased)
	if (newColocMap[newRKProcessId] <= currColocMap[currRKProcessId] &&
	    newColocMap[newDDProcessId] <= currColocMap[currDDProcessId] &&
	    newColocMap[newEKPProcessId] <= currColocMap[currEKPProcessId] &&
	    newColocMap[newCSProcessId] <= currColocMap[currCSProcessId]) {
		// rerecruit the singleton for which we have found a better process, if any
		if (newColocMap[newRKProcessId] < currColocMap[currRKProcessId]) {
			rkSingleton.recruit(*self);
		} else if (newColocMap[newDDProcessId] < currColocMap[currDDProcessId]) {
			ddSingleton.recruit(*self);
		} else if (enableKmsCommunication && newColocMap[newEKPProcessId] < currColocMap[currEKPProcessId]) {
			ekpSingleton.recruit(*self);
		} else if (newColocMap[newCSProcessId] < currColocMap[currCSProcessId]) {
			csSingleton.recruit(*self);
		}
	}
}

															#line 4471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doCheckOutstandingRequests()
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoCheckOutstandingRequestsActor>
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRequestsActorState {
															#line 4478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRequestsActorState(ClusterControllerData* const& self) 
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 4485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this));

	}
	~DoCheckOutstandingRequestsActorState() 
	{
		fdb_probe_actor_destroy("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 951 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->CHECK_OUTSTANDING_INTERVAL);
															#line 951 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 1;
															#line 951 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 4508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCheckOutstandingRequestsActorState();
		static_cast<DoCheckOutstandingRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 977 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoCheckOutstandingRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoCheckOutstandingRequestsActorState(); static_cast<DoCheckOutstandingRequestsActor*>(this)->destroy(); return 0; }
															#line 4537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<DoCheckOutstandingRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoCheckOutstandingRequestsActorState();
		static_cast<DoCheckOutstandingRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 973 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 4550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 974 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevError, "CheckOutstandingError").error(e);
															#line 4554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 952 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 4570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 952 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 4579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingRecruitmentRequests(self);
															#line 963 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingStorageRequests(self);
															#line 965 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkBetterSingletons(self);
															#line 967 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->checkRecoveryStalled();
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->betterMasterExists())
															#line 4671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 969 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.forceMasterFailure.trigger();
															#line 970 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("MasterRegistrationKill", self->id).detail("MasterId", self->db.serverInfo->get().master.id());
															#line 4677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 952 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(now() - self->lastRecruitTime < SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY || !self->goodRecruitmentTime.isReady()))
															#line 4694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 954 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (now() - self->lastRecruitTime < SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY)
															#line 4700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY + 0.001 - (now() - self->lastRecruitTime));
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 2;
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 4711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 957 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->goodRecruitmentTime.isReady())
															#line 4738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 958 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->goodRecruitmentTime;
															#line 958 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 3;
															#line 958 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 4749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 4954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doCheckOutstandingRequests()
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRequestsActor final : public Actor<Void>, public ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >, public ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >, public ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >, public FastAllocated<DoCheckOutstandingRequestsActor>, public DoCheckOutstandingRequestsActorState<DoCheckOutstandingRequestsActor> {
															#line 4959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoCheckOutstandingRequestsActor>::operator new;
	using FastAllocated<DoCheckOutstandingRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10154384780948652800UL, 8326727644974511872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >;
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >;
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >;
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRequestsActor(ClusterControllerData* const& self) 
															#line 4978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoCheckOutstandingRequestsActorState<DoCheckOutstandingRequestsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18376869144156441344UL, 10196932547024268032UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doCheckOutstandingRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doCheckOutstandingRequests( ClusterControllerData* const& self ) {
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoCheckOutstandingRequestsActor(self));
															#line 5013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 979 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 5018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doCheckOutstandingRemoteRequests()
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoCheckOutstandingRemoteRequestsActor>
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRemoteRequestsActorState {
															#line 5025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRemoteRequestsActorState(ClusterControllerData* const& self) 
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 5032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this));

	}
	~DoCheckOutstandingRemoteRequestsActorState() 
	{
		fdb_probe_actor_destroy("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 982 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->CHECK_OUTSTANDING_INTERVAL);
															#line 982 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 1;
															#line 982 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*>(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)));
															#line 5055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCheckOutstandingRemoteRequestsActorState();
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoCheckOutstandingRemoteRequestsActorState(); static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->destroy(); return 0; }
															#line 5084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoCheckOutstandingRemoteRequestsActorState();
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 989 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 5097 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 990 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevError, "CheckOutstandingError").error(e);
															#line 5101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 983 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 5117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 983 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 5126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 987 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingRemoteRecruitmentRequests(self);
															#line 5210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 983 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!self->goodRemoteRecruitmentTime.isReady()))
															#line 5226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 984 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->goodRemoteRecruitmentTime;
															#line 984 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 2;
															#line 984 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*>(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)));
															#line 5239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 5359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doCheckOutstandingRemoteRequests()
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRemoteRequestsActor final : public Actor<Void>, public ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >, public ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >, public FastAllocated<DoCheckOutstandingRemoteRequestsActor>, public DoCheckOutstandingRemoteRequestsActorState<DoCheckOutstandingRemoteRequestsActor> {
															#line 5364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoCheckOutstandingRemoteRequestsActor>::operator new;
	using FastAllocated<DoCheckOutstandingRemoteRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8215803877822569216UL, 12608630358695996928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >;
friend struct ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >;
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRemoteRequestsActor(ClusterControllerData* const& self) 
															#line 5382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoCheckOutstandingRemoteRequestsActorState<DoCheckOutstandingRemoteRequestsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11202796549843407360UL, 6198894268515362560UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doCheckOutstandingRemoteRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doCheckOutstandingRemoteRequests( ClusterControllerData* const& self ) {
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoCheckOutstandingRemoteRequestsActor(self));
															#line 5416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 995 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

void checkOutstandingRequests(ClusterControllerData* self) {
	if (self->outstandingRemoteRequestChecker.isReady()) {
		self->outstandingRemoteRequestChecker = doCheckOutstandingRemoteRequests(self);
	}

	if (self->outstandingRequestChecker.isReady()) {
		self->outstandingRequestChecker = doCheckOutstandingRequests(self);
	}
}

															#line 5431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via rebootAndCheck()
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RebootAndCheckActor>
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class RebootAndCheckActorState {
															#line 5438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RebootAndCheckActorState(ClusterControllerData* const& cluster,Optional<Standalone<StringRef>> const& processID) 
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cluster(cluster),
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   processID(processID)
															#line 5447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("rebootAndCheck", reinterpret_cast<unsigned long>(this));

	}
	~RebootAndCheckActorState() 
	{
		fdb_probe_actor_destroy("rebootAndCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 1008 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(processID.present());
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto watcher = cluster->id_worker.find(processID);
															#line 1010 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(watcher != cluster->id_worker.end());
															#line 1012 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				watcher->second.reboots++;
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(g_network->isSimulated() ? SERVER_KNOBS->SIM_SHUTDOWN_TIMEOUT : SERVER_KNOBS->SHUTDOWN_TIMEOUT);
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<RebootAndCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RebootAndCheckActor*>(this)->actor_wait_state = 1;
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RebootAndCheckActor, 0, Void >*>(static_cast<RebootAndCheckActor*>(this)));
															#line 5478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RebootAndCheckActorState();
		static_cast<RebootAndCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 1017 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto watcher = cluster->id_worker.find(processID);
															#line 1018 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (watcher != cluster->id_worker.end())
															#line 5505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1019 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				watcher->second.reboots--;
															#line 1020 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (watcher->second.reboots < 2)
															#line 5511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1021 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					checkOutstandingRequests(cluster);
															#line 5515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RebootAndCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RebootAndCheckActorState(); static_cast<RebootAndCheckActor*>(this)->destroy(); return 0; }
															#line 5521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RebootAndCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RebootAndCheckActorState();
		static_cast<RebootAndCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RebootAndCheckActor*>(this)->actor_wait_state > 0) static_cast<RebootAndCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RebootAndCheckActor*>(this)->ActorCallback< RebootAndCheckActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RebootAndCheckActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RebootAndCheckActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RebootAndCheckActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<Standalone<StringRef>> processID;
															#line 5620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via rebootAndCheck()
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class RebootAndCheckActor final : public Actor<Void>, public ActorCallback< RebootAndCheckActor, 0, Void >, public FastAllocated<RebootAndCheckActor>, public RebootAndCheckActorState<RebootAndCheckActor> {
															#line 5625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<RebootAndCheckActor>::operator new;
	using FastAllocated<RebootAndCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11967462652165479168UL, 16114896608178381568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RebootAndCheckActor, 0, Void >;
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RebootAndCheckActor(ClusterControllerData* const& cluster,Optional<Standalone<StringRef>> const& processID) 
															#line 5642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RebootAndCheckActorState<RebootAndCheckActor>(cluster, processID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17703883454640654592UL, 13640791943228081920UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rebootAndCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RebootAndCheckActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> rebootAndCheck( ClusterControllerData* const& cluster, Optional<Standalone<StringRef>> const& processID ) {
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new RebootAndCheckActor(cluster, processID));
															#line 5675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1027 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 5680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via workerAvailabilityWatch()
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class WorkerAvailabilityWatchActor>
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class WorkerAvailabilityWatchActorState {
															#line 5687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerAvailabilityWatchActorState(WorkerInterface const& worker,ProcessClass const& startingClass,ClusterControllerData* const& cluster) 
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : worker(worker),
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   startingClass(startingClass),
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   cluster(cluster),
															#line 1031 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   failed((worker.address() == g_network->getLocalAddress()) ? Never() : waitFailureClient(worker.waitFailure, SERVER_KNOBS->WORKER_FAILURE_TIME))
															#line 5700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this));

	}
	~WorkerAvailabilityWatchActorState() 
	{
		fdb_probe_actor_destroy("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1034 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->updateWorkerList.set( worker.locality.processId(), ProcessData(worker.locality, startingClass, worker.stableAddress(), worker.grpcAddress()));
															#line 1039 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0);
															#line 1039 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 1;
															#line 1039 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 5724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1041 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 5747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1041 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 5756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state > 0) static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1043 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = IFailureMonitor::failureMonitor().onStateEqual( worker.storage.getEndpoint(), FailureStatus( IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable()));
															#line 1042 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 1052 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = failed;
															#line 5853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 2;
															#line 1043 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 1052 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 5860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1047 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable())
															#line 5875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->ac.add(rebootAndCheck(cluster, worker.locality.processId()));
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(cluster);
															#line 5881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1047 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable())
															#line 5891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->ac.add(rebootAndCheck(cluster, worker.locality.processId()));
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(cluster);
															#line 5897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1053 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerInfo& failedWorkerInfo = cluster->id_worker[worker.locality.processId()];
															#line 1055 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!failedWorkerInfo.reply.isSet())
															#line 5909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1056 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedWorkerInfo.reply.send( RegisterWorkerReply(failedWorkerInfo.details.processClass, failedWorkerInfo.priorityInfo));
															#line 5913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (worker.locality.processId() == cluster->masterProcessId)
															#line 5917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->masterProcessId = Optional<Key>();
															#line 5921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1062 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ClusterControllerWorkerFailed", cluster->id) .detail("ProcessId", worker.locality.processId()) .detail("ProcessClass", failedWorkerInfo.details.processClass.toString()) .detail("Address", worker.address());
															#line 1066 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->removedDBInfoEndpoints.insert(worker.updateServerDBInfo.getEndpoint());
															#line 1067 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->id_worker.erase(worker.locality.processId());
															#line 1070 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 5931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1071 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->addr_locality.erase(worker.address());
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.secondaryAddress().present())
															#line 5937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1073 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				cluster->addr_locality.erase(worker.secondaryAddress().get());
															#line 5941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1076 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->updateWorkerList.set(worker.locality.processId(), Optional<ProcessData>());
															#line 1077 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<WorkerAvailabilityWatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerAvailabilityWatchActorState(); static_cast<WorkerAvailabilityWatchActor*>(this)->destroy(); return 0; }
															#line 5948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<WorkerAvailabilityWatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1053 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerInfo& failedWorkerInfo = cluster->id_worker[worker.locality.processId()];
															#line 1055 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!failedWorkerInfo.reply.isSet())
															#line 5962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1056 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedWorkerInfo.reply.send( RegisterWorkerReply(failedWorkerInfo.details.processClass, failedWorkerInfo.priorityInfo));
															#line 5966 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (worker.locality.processId() == cluster->masterProcessId)
															#line 5970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->masterProcessId = Optional<Key>();
															#line 5974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1062 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ClusterControllerWorkerFailed", cluster->id) .detail("ProcessId", worker.locality.processId()) .detail("ProcessClass", failedWorkerInfo.details.processClass.toString()) .detail("Address", worker.address());
															#line 1066 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->removedDBInfoEndpoints.insert(worker.updateServerDBInfo.getEndpoint());
															#line 1067 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->id_worker.erase(worker.locality.processId());
															#line 1070 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 5984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1071 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->addr_locality.erase(worker.address());
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.secondaryAddress().present())
															#line 5990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1073 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				cluster->addr_locality.erase(worker.secondaryAddress().get());
															#line 5994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1076 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->updateWorkerList.set(worker.locality.processId(), Optional<ProcessData>());
															#line 1077 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<WorkerAvailabilityWatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerAvailabilityWatchActorState(); static_cast<WorkerAvailabilityWatchActor*>(this)->destroy(); return 0; }
															#line 6001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<WorkerAvailabilityWatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state > 0) static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 1, Void >::remove();
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerInterface worker;
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ProcessClass startingClass;
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 1031 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> failed;
															#line 6138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via workerAvailabilityWatch()
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class WorkerAvailabilityWatchActor final : public Actor<Void>, public ActorCallback< WorkerAvailabilityWatchActor, 0, Void >, public ActorCallback< WorkerAvailabilityWatchActor, 1, Void >, public ActorCallback< WorkerAvailabilityWatchActor, 2, Void >, public FastAllocated<WorkerAvailabilityWatchActor>, public WorkerAvailabilityWatchActorState<WorkerAvailabilityWatchActor> {
															#line 6143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<WorkerAvailabilityWatchActor>::operator new;
	using FastAllocated<WorkerAvailabilityWatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15457967308880993536UL, 8831346043081841664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerAvailabilityWatchActor, 0, Void >;
friend struct ActorCallback< WorkerAvailabilityWatchActor, 1, Void >;
friend struct ActorCallback< WorkerAvailabilityWatchActor, 2, Void >;
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerAvailabilityWatchActor(WorkerInterface const& worker,ProcessClass const& startingClass,ClusterControllerData* const& cluster) 
															#line 6162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WorkerAvailabilityWatchActorState<WorkerAvailabilityWatchActor>(worker, startingClass, cluster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10692884594389689856UL, 3271400941493304320UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerAvailabilityWatch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> workerAvailabilityWatch( WorkerInterface const& worker, ProcessClass const& startingClass, ClusterControllerData* const& cluster ) {
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new WorkerAvailabilityWatchActor(worker, startingClass, cluster));
															#line 6196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1082 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

struct FailureStatusInfo {
	FailureStatus status;
	double lastRequestTime;
	double penultimateRequestTime;

	FailureStatusInfo() : lastRequestTime(0), penultimateRequestTime(0) {}

	void insertRequest(double now) {
		penultimateRequestTime = lastRequestTime;
		lastRequestTime = now;
	}

	double latency(double now) const {
		return std::max(now - lastRequestTime, lastRequestTime - penultimateRequestTime);
	}
};

															#line 6218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via requireAll()
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RequireAllActor>
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class RequireAllActorState {
															#line 6225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RequireAllActorState(std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in) 
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : in(in),
															#line 1101 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   out(),
															#line 1102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   i()
															#line 6236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("requireAll", reinterpret_cast<unsigned long>(this));

	}
	~RequireAllActorState() 
	{
		fdb_probe_actor_destroy("requireAll", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			i = 0;
															#line 6251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RequireAllActorState();
		static_cast<RequireAllActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1109 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RequireAllActor*>(this)->SAV<std::vector<TLogInterface>>::futures) { (void)(out); this->~RequireAllActorState(); static_cast<RequireAllActor*>(this)->destroy(); return 0; }
															#line 6274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RequireAllActor*>(this)->SAV< std::vector<TLogInterface> >::value()) std::vector<TLogInterface>(std::move(out)); // state_var_RVO
		this->~RequireAllActorState();
		static_cast<RequireAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(i < in.size()))
															#line 6293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Optional<std::vector<TLogInterface>>> __when_expr_0 = in[i];
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<RequireAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RequireAllActor*>(this)->actor_wait_state = 1;
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*>(static_cast<RequireAllActor*>(this)));
															#line 6306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<std::vector<TLogInterface>> const& x,int loopDepth) 
	{
															#line 1105 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!x.present())
															#line 6328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1106 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), std::max(0, loopDepth - 1));
															#line 6332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1107 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		out.insert(out.end(), x.get().begin(), x.get().end());
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		i++;
															#line 6338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<std::vector<TLogInterface>> && x,int loopDepth) 
	{
															#line 1105 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!x.present())
															#line 6347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1106 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), std::max(0, loopDepth - 1));
															#line 6351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1107 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		out.insert(out.end(), x.get().begin(), x.get().end());
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		i++;
															#line 6357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::vector<TLogInterface>> const& x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(x, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::vector<TLogInterface>> && x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(x), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RequireAllActor*>(this)->actor_wait_state > 0) static_cast<RequireAllActor*>(this)->actor_wait_state = 0;
		static_cast<RequireAllActor*>(this)->ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >::remove();

	}
	void a_callback_fire(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Optional<std::vector<TLogInterface>> const& value) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Optional<std::vector<TLogInterface>> && value) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Error err) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<Future<Optional<std::vector<TLogInterface>>>> in;
															#line 1101 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<TLogInterface> out;
															#line 1102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	int i;
															#line 6443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via requireAll()
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class RequireAllActor final : public Actor<std::vector<TLogInterface>>, public ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >, public FastAllocated<RequireAllActor>, public RequireAllActorState<RequireAllActor> {
															#line 6448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<RequireAllActor>::operator new;
	using FastAllocated<RequireAllActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15637375376612894976UL, 17972536732225404928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<TLogInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >;
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RequireAllActor(std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in) 
															#line 6465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<std::vector<TLogInterface>>(),
		   RequireAllActorState<RequireAllActor>(in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16593527381228025088UL, 9468838150300793600UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("requireAll");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<std::vector<TLogInterface>> requireAll( std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in ) {
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<std::vector<TLogInterface>>(new RequireAllActor(in));
															#line 6498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1111 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

void clusterRecruitStorage(ClusterControllerData* self, RecruitStorageRequest req) {
	try {
		if (!self->gotProcessClasses && !req.criticalRecruitment)
			throw no_more_servers();
		auto worker = self->getStorageWorker(req);
		RecruitStorageReply rep;
		rep.worker = worker.interf;
		rep.processClass = worker.processClass;
		req.reply.send(rep);
	} catch (Error& e) {
		if (e.code() == error_code_no_more_servers) {
			self->outstandingStorageRequests.emplace_back(req, now() + SERVER_KNOBS->RECRUITMENT_TIMEOUT);
			TraceEvent(SevWarn, "RecruitStorageNotAvailable", self->id)
			    .error(e)
			    .detail("IsCriticalRecruitment", req.criticalRecruitment);
		} else {
			TraceEvent(SevError, "RecruitStorageError", self->id).error(e);
			throw; // Any other error will bring down the cluster controller
		}
	}
}

void clusterRegisterMaster(ClusterControllerData* self, RegisterMasterRequest const& req) {
	++self->registerMasterRequests;

	TraceEvent("MasterRegistrationReceived", self->id)
	    .detail("MasterId", req.id)
	    .detail("Master", req.mi.toString())
	    .detail("Tlogs", describe(req.logSystemConfig.tLogs))
	    .detail("Resolvers", req.resolvers.size())
	    .detail("RecoveryState", (int)req.recoveryState)
	    .detail("RegistrationCount", req.registrationCount)
	    .detail("CommitProxies", req.commitProxies.size())
	    .detail("GrvProxies", req.grvProxies.size())
	    .detail("RecoveryCount", req.recoveryCount)
	    .detail("Stalled", req.recoveryStalled)
	    .detail("OldestBackupEpoch", req.logSystemConfig.oldestBackupEpoch);

	// make sure the request comes from an active database
	auto db = &self->db;
	if (db->serverInfo->get().master.id() != req.id || req.registrationCount <= db->masterRegistrationCount) {
		TraceEvent("MasterRegistrationNotFound", self->id)
		    .detail("MasterId", req.id)
		    .detail("ExistingId", db->serverInfo->get().master.id())
		    .detail("RegCount", req.registrationCount)
		    .detail("ExistingRegCount", db->masterRegistrationCount);
		return;
	}

	if (req.recoveryState == RecoveryState::FULLY_RECOVERED) {
		self->db.unfinishedRecoveries = 0;
		ASSERT(!req.logSystemConfig.oldTLogs.size());
	}

	db->masterRegistrationCount = req.registrationCount;
	db->recoveryStalled = req.recoveryStalled;
	if (req.configuration.present()) {
		db->config = req.configuration.get();

		if (req.recoveryState >= RecoveryState::ACCEPTING_COMMITS) {
			self->gotFullyRecoveredConfig = true;
			db->fullyRecoveredConfig = req.configuration.get();
			for (auto& it : self->id_worker) {
				bool isExcludedFromConfig = db->fullyRecoveredConfig.isExcludedServer(
				    it.second.details.interf.addresses(), it.second.details.interf.locality);
				if (it.second.priorityInfo.isExcluded != isExcludedFromConfig) {
					it.second.priorityInfo.isExcluded = isExcludedFromConfig;
					if (!it.second.reply.isSet()) {
						it.second.reply.send(
						    RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
					}
				}
			}
		}
	}

	bool isChanged = false;
	auto dbInfo = self->db.serverInfo->get();

	if (dbInfo.recoveryState != req.recoveryState) {
		dbInfo.recoveryState = req.recoveryState;
		isChanged = true;
	}

	if (dbInfo.priorCommittedLogServers != req.priorCommittedLogServers) {
		dbInfo.priorCommittedLogServers = req.priorCommittedLogServers;
		isChanged = true;
	}

	// Construct the client information
	if (db->clientInfo->get().commitProxies != req.commitProxies ||
	    db->clientInfo->get().grvProxies != req.grvProxies ||
	    db->clientInfo->get().clusterId != db->serverInfo->get().client.clusterId ||
	    db->clientInfo->get().clusterType != db->clusterType) {
		TraceEvent("PublishNewClientInfo", self->id)
		    .detail("Master", dbInfo.master.id())
		    .detail("GrvProxies", db->clientInfo->get().grvProxies)
		    .detail("ReqGrvProxies", req.grvProxies)
		    .detail("CommitProxies", db->clientInfo->get().commitProxies)
		    .detail("GlobalConfigHistorySize", db->clientInfo->get().history.size())
		    .detail("ReqCPs", req.commitProxies)
		    .detail("ClusterId", db->serverInfo->get().client.clusterId)
		    .detail("ClientClusterId", db->clientInfo->get().clusterId)
		    .detail("ClusterType", db->clientInfo->get().clusterType)
		    .detail("ReqClusterType", db->clusterType);
		isChanged = true;
		// TODO why construct a new one and not just copy the old one and change proxies + id?
		ClientDBInfo clientInfo;
		clientInfo.encryptKeyProxy = db->serverInfo->get().client.encryptKeyProxy;
		clientInfo.id = deterministicRandom()->randomUniqueID();
		clientInfo.commitProxies = req.commitProxies;
		clientInfo.grvProxies = req.grvProxies;
		clientInfo.history = db->clientInfo->get().history;
		clientInfo.clusterId = db->serverInfo->get().client.clusterId;
		clientInfo.clusterType = db->clusterType;
		db->clientInfo->set(clientInfo);
		dbInfo.client = db->clientInfo->get();
	}

	if (!dbInfo.logSystemConfig.isEqual(req.logSystemConfig)) {
		isChanged = true;
		dbInfo.logSystemConfig = req.logSystemConfig;
	}

	if (dbInfo.resolvers != req.resolvers) {
		isChanged = true;
		dbInfo.resolvers = req.resolvers;
	}

	if (dbInfo.recoveryCount != req.recoveryCount) {
		isChanged = true;
		dbInfo.recoveryCount = req.recoveryCount;
	}

	if (isChanged) {
		dbInfo.id = deterministicRandom()->randomUniqueID();
		dbInfo.infoGeneration = ++self->db.dbInfoCount;
		self->db.serverInfo->set(dbInfo);
	}

	checkOutstandingRequests(self);
}

// Halts the registering (i.e. requesting) singleton if one is already in the process of being recruited
// or, halts the existing singleton in favour of the requesting one
template <class SingletonClass>
void haltRegisteringOrCurrentSingleton(ClusterControllerData* self,
                                       const WorkerInterface& worker,
                                       const SingletonClass& currSingleton,
                                       const SingletonClass& registeringSingleton,
                                       const Optional<UID> recruitingID) {
	ASSERT(currSingleton.getRole() == registeringSingleton.getRole());
	const UID registeringID = registeringSingleton.getInterface().id();
	const std::string roleName = currSingleton.getRole().roleName;
	const std::string roleAbbr = currSingleton.getRole().abbreviation;

	// halt the requesting singleton if it isn't the one currently being recruited
	if ((recruitingID.present() && recruitingID.get() != registeringID) ||
	    self->clusterControllerDcId != worker.locality.dcId()) {
		TraceEvent(("CCHaltRegistering" + roleName).c_str(), self->id)
		    .detail(roleAbbr + "ID", registeringID)
		    .detail("DcID", printable(self->clusterControllerDcId))
		    .detail("ReqDcID", printable(worker.locality.dcId()))
		    .detail("Recruiting" + roleAbbr + "ID", recruitingID.present() ? recruitingID.get() : UID());
		registeringSingleton.halt(*self, worker.locality.processId());
	} else if (!recruitingID.present()) {
		// if not currently recruiting, then halt previous one in favour of requesting one
		TraceEvent(("CCRegister" + roleName).c_str(), self->id).detail(roleAbbr + "ID", registeringID);
		if (currSingleton.isPresent() && currSingleton.getInterface().id() != registeringID &&
		    self->id_worker.contains(currSingleton.getInterface().locality.processId())) {
			TraceEvent(("CCHaltPrevious" + roleName).c_str(), self->id)
			    .detail(roleAbbr + "ID", currSingleton.getInterface().id())
			    .detail("DcID", printable(self->clusterControllerDcId))
			    .detail("ReqDcID", printable(worker.locality.dcId()))
			    .detail("Recruiting" + roleAbbr + "ID", recruitingID.present() ? recruitingID.get() : UID());
			currSingleton.halt(*self, currSingleton.getInterface().locality.processId());
		}
		// set the curr singleton if it doesn't exist or its different from the requesting one
		if (!currSingleton.isPresent() || currSingleton.getInterface().id() != registeringID) {
			registeringSingleton.setInterfaceToDbInfo(*self);
		}
	}
}

															#line 6687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via registerWorker()
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RegisterWorkerActor>
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class RegisterWorkerActorState {
															#line 6694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerActorState(RegisterWorkerRequest const& req,ClusterControllerData* const& self,ClusterConnectionString const& cs,ConfigBroadcaster* const& configBroadcaster) 
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : req(req),
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   self(self),
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   cs(cs),
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   configBroadcaster(configBroadcaster)
															#line 6707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("registerWorker", reinterpret_cast<unsigned long>(this));

	}
	~RegisterWorkerActorState() 
	{
		fdb_probe_actor_destroy("registerWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1300 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<std::vector<NetworkAddress>> __when_expr_0 = cs.tryResolveHostnames();
															#line 1300 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<RegisterWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegisterWorkerActor*>(this)->actor_wait_state = 1;
															#line 1300 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*>(static_cast<RegisterWorkerActor*>(this)));
															#line 6729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<NetworkAddress> const& coordinatorAddresses,int loopDepth) 
	{
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		const WorkerInterface& w = req.wi;
															#line 1303 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.clusterId.present() && self->clusterId->get().present() && req.clusterId != self->clusterId->get() && req.processClass != ProcessClass::TesterClass)
															#line 6754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevWarnAlways : SevError, "WorkerBelongsToExistingCluster", self->id) .detail("WorkerClusterId", req.clusterId) .detail("ClusterControllerClusterId", self->clusterId->get()) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId());
															#line 1310 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(invalid_cluster_id());
															#line 1311 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 6762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RegisterWorkerActorState();
			static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ProcessClass newProcessClass = req.processClass;
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto info = self->id_worker.find(w.locality.processId());
															#line 1316 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ClusterControllerPriorityInfo newPriorityInfo = req.priorityInfo;
															#line 1317 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool isCoordinator = (std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.address()) != coordinatorAddresses.end()) || (w.secondaryAddress().present() && std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.secondaryAddress().get()) != coordinatorAddresses.end());
															#line 1326 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : req.incompatiblePeers ) {
															#line 1327 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.incompatibleConnections[it] = now() + SERVER_KNOBS->INCOMPATIBLE_PEERS_LOGGING_INTERVAL;
															#line 6782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1329 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->removedDBInfoEndpoints.erase(w.updateServerDBInfo.getEndpoint());
															#line 1331 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 6788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1332 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerActualWorkers", self->id) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 1340 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 1341 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRemoteRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_REMOTE_RECRUITMENT_DELAY);
															#line 6796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1343 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerWorkerAlreadyRegistered", self->id) .suppressFor(1.0) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("Degraded", req.degraded) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 6802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1354 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (w.address() == g_network->getLocalAddress())
															#line 6806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->changingDcIds.get().first)
															#line 6810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1356 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 6814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1357 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 6818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1360 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 6825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1361 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 6829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
		else
		{
															#line 1365 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changingDcIds.get().first)
															#line 6837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1366 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 6841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1367 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 6845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1370 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 6852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1371 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 6856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1377 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end() || info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 6862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1379 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotProcessClasses)
															#line 6866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1380 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.locality.processId());
															#line 1382 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || req.initialClass.classType() == ProcessClass::UnsetClass))
															#line 6872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1384 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 6876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1386 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = req.initialClass;
															#line 6882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1388 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 6886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1391 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotFullyRecoveredConfig)
															#line 6890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1392 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.isExcluded = self->db.fullyRecoveredConfig.isExcludedServer(w.addresses(), w.locality);
															#line 6894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1396 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 6899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1397 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_worker[w.locality.processId()] = WorkerInfo(workerAvailabilityWatch(w, newProcessClass, self), req.reply, req.generation, w, req.initialClass, newProcessClass, newPriorityInfo, req.degraded, req.recoveredDiskFiles, req.issues);
															#line 1409 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 6905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1410 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				const bool addrDcChanged = self->addr_locality.contains(w.address()) && self->addr_locality[w.address()].dcId() != w.locality.dcId();
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (addrDcChanged)
															#line 6911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1413 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					TraceEvent(SevWarn, "AddrDcChanged") .detail("Addr", w.address()) .detail("ExistingLocality", self->addr_locality[w.address()].toString()) .detail("NewLocality", w.locality.toString());
															#line 6915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT_WE_THINK(!addrDcChanged);
															#line 1419 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addr_locality[w.address()] = w.locality;
															#line 1420 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (w.secondaryAddress().present())
															#line 6923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1421 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addr_locality[w.secondaryAddress().get()] = w.locality;
															#line 6927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
															#line 1424 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->masterProcessId.present() && w.locality.processId() == self->db.serverInfo->get().master.locality.processId())
															#line 6932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->masterProcessId = w.locality.processId();
															#line 6936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1428 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 6940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1429 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), self->id_worker[w.locality.processId()].watcher, isCoordinator));
															#line 6944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1435 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1436 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfo.trigger();
															#line 1437 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 6952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1438 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 6958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1439 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!info->second.reply.isSet())
															#line 6962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1440 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.reply.send(Never());
															#line 6966 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1442 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.reply = req.reply;
															#line 1443 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.processClass = newProcessClass;
															#line 1444 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.priorityInfo = newPriorityInfo;
															#line 1445 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.initialClass = req.initialClass;
															#line 1446 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.degraded = req.degraded;
															#line 1447 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.recoveredDiskFiles = req.recoveredDiskFiles;
															#line 1448 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.gen = req.generation;
															#line 1449 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.issues = req.issues;
															#line 1451 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (info->second.details.interf.id() != w.id())
															#line 6986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1452 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->removedDBInfoEndpoints.insert(info->second.details.interf.updateServerDBInfo.getEndpoint());
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.details.interf = w;
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher.cancel();
															#line 1458 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher = workerAvailabilityWatch(w, newProcessClass, self);
															#line 6996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1460 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (req.requestDbInfo)
															#line 7000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1461 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1462 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfo.trigger();
															#line 7006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1464 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 7010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1465 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), info->second.watcher, isCoordinator));
															#line 7014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1471 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 7018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1473 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(true, "Received an old worker registration request.", probe::decoration::rare);
															#line 7024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1479 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.distributorInterf.present())
															#line 7029 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1480 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = DataDistributorSingleton(self->db.serverInfo->get().distributor);
															#line 1481 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = DataDistributorSingleton(req.distributorInterf);
															#line 1482 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<DataDistributorSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingDistributorID);
															#line 7037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1486 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.ratekeeperInterf.present())
															#line 7041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1487 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = RatekeeperSingleton(self->db.serverInfo->get().ratekeeper);
															#line 1488 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = RatekeeperSingleton(req.ratekeeperInterf);
															#line 1489 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<RatekeeperSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingRatekeeperID);
															#line 7049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1493 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.config.encryptionAtRestMode.isEncryptionEnabled() && req.encryptKeyProxyInterf.present())
															#line 7053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1494 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = EncryptKeyProxySingleton(self->db.serverInfo->get().client.encryptKeyProxy);
															#line 1495 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = EncryptKeyProxySingleton(req.encryptKeyProxyInterf);
															#line 1496 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<EncryptKeyProxySingleton>( self, w, currSingleton, registeringSingleton, self->recruitingEncryptKeyProxyID);
															#line 7061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1500 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.consistencyScanInterf.present())
															#line 7065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1501 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = ConsistencyScanSingleton(self->db.serverInfo->get().consistencyScan);
															#line 1502 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = ConsistencyScanSingleton(req.consistencyScanInterf);
															#line 1503 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<ConsistencyScanSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingConsistencyScanID);
															#line 7073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1508 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!req.reply.isSet() && newPriorityInfo != req.priorityInfo)
															#line 7077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1509 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.send(RegisterWorkerReply(newProcessClass, newPriorityInfo));
															#line 7081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1512 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 7085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<NetworkAddress> && coordinatorAddresses,int loopDepth) 
	{
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		const WorkerInterface& w = req.wi;
															#line 1303 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.clusterId.present() && self->clusterId->get().present() && req.clusterId != self->clusterId->get() && req.processClass != ProcessClass::TesterClass)
															#line 7099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevWarnAlways : SevError, "WorkerBelongsToExistingCluster", self->id) .detail("WorkerClusterId", req.clusterId) .detail("ClusterControllerClusterId", self->clusterId->get()) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId());
															#line 1310 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(invalid_cluster_id());
															#line 1311 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 7107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RegisterWorkerActorState();
			static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ProcessClass newProcessClass = req.processClass;
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto info = self->id_worker.find(w.locality.processId());
															#line 1316 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ClusterControllerPriorityInfo newPriorityInfo = req.priorityInfo;
															#line 1317 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool isCoordinator = (std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.address()) != coordinatorAddresses.end()) || (w.secondaryAddress().present() && std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.secondaryAddress().get()) != coordinatorAddresses.end());
															#line 1326 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : req.incompatiblePeers ) {
															#line 1327 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.incompatibleConnections[it] = now() + SERVER_KNOBS->INCOMPATIBLE_PEERS_LOGGING_INTERVAL;
															#line 7127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1329 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->removedDBInfoEndpoints.erase(w.updateServerDBInfo.getEndpoint());
															#line 1331 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 7133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1332 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerActualWorkers", self->id) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 1340 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 1341 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRemoteRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_REMOTE_RECRUITMENT_DELAY);
															#line 7141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1343 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerWorkerAlreadyRegistered", self->id) .suppressFor(1.0) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("Degraded", req.degraded) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 7147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1354 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (w.address() == g_network->getLocalAddress())
															#line 7151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->changingDcIds.get().first)
															#line 7155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1356 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 7159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1357 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 7163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1360 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 7170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1361 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 7174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
		else
		{
															#line 1365 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changingDcIds.get().first)
															#line 7182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1366 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 7186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1367 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 7190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1370 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 7197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1371 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 7201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1377 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end() || info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 7207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1379 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotProcessClasses)
															#line 7211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1380 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.locality.processId());
															#line 1382 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || req.initialClass.classType() == ProcessClass::UnsetClass))
															#line 7217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1384 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 7221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1386 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = req.initialClass;
															#line 7227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1388 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 7231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1391 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotFullyRecoveredConfig)
															#line 7235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1392 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.isExcluded = self->db.fullyRecoveredConfig.isExcludedServer(w.addresses(), w.locality);
															#line 7239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1396 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 7244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1397 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_worker[w.locality.processId()] = WorkerInfo(workerAvailabilityWatch(w, newProcessClass, self), req.reply, req.generation, w, req.initialClass, newProcessClass, newPriorityInfo, req.degraded, req.recoveredDiskFiles, req.issues);
															#line 1409 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 7250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1410 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				const bool addrDcChanged = self->addr_locality.contains(w.address()) && self->addr_locality[w.address()].dcId() != w.locality.dcId();
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (addrDcChanged)
															#line 7256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1413 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					TraceEvent(SevWarn, "AddrDcChanged") .detail("Addr", w.address()) .detail("ExistingLocality", self->addr_locality[w.address()].toString()) .detail("NewLocality", w.locality.toString());
															#line 7260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT_WE_THINK(!addrDcChanged);
															#line 1419 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addr_locality[w.address()] = w.locality;
															#line 1420 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (w.secondaryAddress().present())
															#line 7268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1421 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addr_locality[w.secondaryAddress().get()] = w.locality;
															#line 7272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
															#line 1424 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->masterProcessId.present() && w.locality.processId() == self->db.serverInfo->get().master.locality.processId())
															#line 7277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->masterProcessId = w.locality.processId();
															#line 7281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1428 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 7285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1429 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), self->id_worker[w.locality.processId()].watcher, isCoordinator));
															#line 7289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1435 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1436 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfo.trigger();
															#line 1437 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 7297 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1438 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 7303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1439 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!info->second.reply.isSet())
															#line 7307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1440 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.reply.send(Never());
															#line 7311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1442 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.reply = req.reply;
															#line 1443 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.processClass = newProcessClass;
															#line 1444 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.priorityInfo = newPriorityInfo;
															#line 1445 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.initialClass = req.initialClass;
															#line 1446 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.degraded = req.degraded;
															#line 1447 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.recoveredDiskFiles = req.recoveredDiskFiles;
															#line 1448 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.gen = req.generation;
															#line 1449 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.issues = req.issues;
															#line 1451 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (info->second.details.interf.id() != w.id())
															#line 7331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1452 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->removedDBInfoEndpoints.insert(info->second.details.interf.updateServerDBInfo.getEndpoint());
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.details.interf = w;
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher.cancel();
															#line 1458 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher = workerAvailabilityWatch(w, newProcessClass, self);
															#line 7341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1460 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (req.requestDbInfo)
															#line 7345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1461 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1462 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfo.trigger();
															#line 7351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1464 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 7355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1465 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), info->second.watcher, isCoordinator));
															#line 7359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1471 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 7363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1473 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(true, "Received an old worker registration request.", probe::decoration::rare);
															#line 7369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1479 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.distributorInterf.present())
															#line 7374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1480 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = DataDistributorSingleton(self->db.serverInfo->get().distributor);
															#line 1481 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = DataDistributorSingleton(req.distributorInterf);
															#line 1482 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<DataDistributorSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingDistributorID);
															#line 7382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1486 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.ratekeeperInterf.present())
															#line 7386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1487 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = RatekeeperSingleton(self->db.serverInfo->get().ratekeeper);
															#line 1488 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = RatekeeperSingleton(req.ratekeeperInterf);
															#line 1489 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<RatekeeperSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingRatekeeperID);
															#line 7394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1493 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.config.encryptionAtRestMode.isEncryptionEnabled() && req.encryptKeyProxyInterf.present())
															#line 7398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1494 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = EncryptKeyProxySingleton(self->db.serverInfo->get().client.encryptKeyProxy);
															#line 1495 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = EncryptKeyProxySingleton(req.encryptKeyProxyInterf);
															#line 1496 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<EncryptKeyProxySingleton>( self, w, currSingleton, registeringSingleton, self->recruitingEncryptKeyProxyID);
															#line 7406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1500 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.consistencyScanInterf.present())
															#line 7410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1501 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = ConsistencyScanSingleton(self->db.serverInfo->get().consistencyScan);
															#line 1502 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = ConsistencyScanSingleton(req.consistencyScanInterf);
															#line 1503 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<ConsistencyScanSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingConsistencyScanID);
															#line 7418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1508 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!req.reply.isSet() && newPriorityInfo != req.priorityInfo)
															#line 7422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1509 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.send(RegisterWorkerReply(newProcessClass, newPriorityInfo));
															#line 7426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1512 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 7430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<NetworkAddress> const& coordinatorAddresses,int loopDepth) 
	{
		loopDepth = a_body1cont1(coordinatorAddresses, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<NetworkAddress> && coordinatorAddresses,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(coordinatorAddresses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterWorkerActor*>(this)->actor_wait_state > 0) static_cast<RegisterWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterWorkerActor*>(this)->ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerRequest req;
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterConnectionString cs;
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ConfigBroadcaster* configBroadcaster;
															#line 7521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via registerWorker()
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class RegisterWorkerActor final : public Actor<Void>, public ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >, public FastAllocated<RegisterWorkerActor>, public RegisterWorkerActorState<RegisterWorkerActor> {
															#line 7526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<RegisterWorkerActor>::operator new;
	using FastAllocated<RegisterWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11958722248462926080UL, 9229998790604983552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >;
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerActor(RegisterWorkerRequest const& req,ClusterControllerData* const& self,ClusterConnectionString const& cs,ConfigBroadcaster* const& configBroadcaster) 
															#line 7543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RegisterWorkerActorState<RegisterWorkerActor>(req, self, cs, configBroadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14446594949420451840UL, 3262990831982615808UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> registerWorker( RegisterWorkerRequest const& req, ClusterControllerData* const& self, ClusterConnectionString const& cs, ConfigBroadcaster* const& configBroadcaster ) {
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new RegisterWorkerActor(req, self, cs, configBroadcaster));
															#line 7576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1514 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

#define TIME_KEEPER_VERSION "1"_sr

															#line 7583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via timeKeeperSetVersion()
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TimeKeeperSetVersionActor>
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperSetVersionActorState {
															#line 7590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperSetVersionActorState(ClusterControllerData* const& self) 
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1518 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(self->cx))
															#line 7599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this));

	}
	~TimeKeeperSetVersionActorState() 
	{
		fdb_probe_actor_destroy("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1519 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 7614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeKeeperSetVersionActorState();
		static_cast<TimeKeeperSetVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1532 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<TimeKeeperSetVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TimeKeeperSetVersionActorState(); static_cast<TimeKeeperSetVersionActor*>(this)->destroy(); return 0; }
															#line 7637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<TimeKeeperSetVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TimeKeeperSetVersionActorState();
		static_cast<TimeKeeperSetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1521 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1522 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1523 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1524 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->set(timeKeeperVersionKey, TIME_KEEPER_VERSION);
															#line 1525 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 1525 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 1;
															#line 1525 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperSetVersionActor, 0, Void >*>(static_cast<TimeKeeperSetVersionActor*>(this)));
															#line 7672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1528 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 1528 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 2;
															#line 1528 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperSetVersionActor, 1, Void >*>(static_cast<TimeKeeperSetVersionActor*>(this)));
															#line 7714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperSetVersionActor*>(this)->ActorCallback< TimeKeeperSetVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperSetVersionActor*>(this)->ActorCallback< TimeKeeperSetVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1518 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 7903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via timeKeeperSetVersion()
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperSetVersionActor final : public Actor<Void>, public ActorCallback< TimeKeeperSetVersionActor, 0, Void >, public ActorCallback< TimeKeeperSetVersionActor, 1, Void >, public FastAllocated<TimeKeeperSetVersionActor>, public TimeKeeperSetVersionActorState<TimeKeeperSetVersionActor> {
															#line 7908 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<TimeKeeperSetVersionActor>::operator new;
	using FastAllocated<TimeKeeperSetVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8169394747095609600UL, 13687415134486455808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeKeeperSetVersionActor, 0, Void >;
friend struct ActorCallback< TimeKeeperSetVersionActor, 1, Void >;
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperSetVersionActor(ClusterControllerData* const& self) 
															#line 7926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TimeKeeperSetVersionActorState<TimeKeeperSetVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15389618584066260224UL, 624794717111917056UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeKeeperSetVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeKeeperSetVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TimeKeeperSetVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> timeKeeperSetVersion( ClusterControllerData* const& self ) {
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TimeKeeperSetVersionActor(self));
															#line 7960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1534 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

// This actor periodically gets read version and writes it to cluster with current timestamp as key. To avoid
// running out of space, it limits the max number of entries and clears old entries on each update. This mapping is
// used from backup and restore to get the version information for a timestamp.
															#line 7968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via timeKeeper()
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TimeKeeperActor>
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperActorState {
															#line 7975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperActorState(ClusterControllerData* const& self) 
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   versionMap(timeKeeperPrefixRange.begin)
															#line 7984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("timeKeeper", reinterpret_cast<unsigned long>(this));

	}
	~TimeKeeperActorState() 
	{
		fdb_probe_actor_destroy("timeKeeper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1541 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperStarted").log();
															#line 1543 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeKeeperSetVersion(self);
															#line 1543 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 1;
															#line 1543 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 0, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 8008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeKeeperActorState();
		static_cast<TimeKeeperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1545 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 8031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1545 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 8040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1546 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(self->cx);
															#line 1547 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 8133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1583 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(SERVER_KNOBS->TIME_KEEPER_DELAY);
															#line 1583 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 5;
															#line 1583 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 4, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 8149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1549 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			debugID = deterministicRandom()->randomUniqueID();
															#line 1550 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!g_network->isSimulated())
															#line 8168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1554 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				tr->debugTransaction(debugID);
															#line 8172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1556 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1557 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1558 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1560 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(timeKeeperDisableKey);
															#line 1560 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 2;
															#line 1560 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 1, Optional<Value> >*>(static_cast<TimeKeeperActor*>(this)));
															#line 8189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1579 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 1579 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 4;
															#line 1579 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 3, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 8231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Optional<Value> const& disableValue,int loopDepth) 
	{
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (disableValue.present())
															#line 8246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1565 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		Version v = tr->getReadVersion().get();
															#line 1566 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t currentTime = (int64_t)now();
															#line 1567 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		versionMap.set(tr, currentTime, v);
															#line 1568 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!g_network->isSimulated())
															#line 8258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1569 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperCommit", debugID).detail("Version", v);
															#line 8262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1571 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t ttl = currentTime - SERVER_KNOBS->TIME_KEEPER_DELAY * SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES;
															#line 1572 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ttl > 0)
															#line 8268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1573 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionMap.erase(tr, 0, ttl);
															#line 8272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1576 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1576 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 3;
															#line 1576 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 2, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 8283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Optional<Value> && disableValue,int loopDepth) 
	{
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (disableValue.present())
															#line 8292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1565 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		Version v = tr->getReadVersion().get();
															#line 1566 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t currentTime = (int64_t)now();
															#line 1567 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		versionMap.set(tr, currentTime, v);
															#line 1568 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!g_network->isSimulated())
															#line 8304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1569 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperCommit", debugID).detail("Version", v);
															#line 8308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1571 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t ttl = currentTime - SERVER_KNOBS->TIME_KEEPER_DELAY * SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES;
															#line 1572 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ttl > 0)
															#line 8314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1573 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionMap.erase(tr, 0, ttl);
															#line 8318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1576 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1576 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 3;
															#line 1576 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 2, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 8329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Optional<Value> const& disableValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(disableValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Optional<Value> && disableValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(disableValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	KeyBackedMap<int64_t, Version> versionMap;
															#line 1546 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1549 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID debugID;
															#line 8678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via timeKeeper()
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperActor final : public Actor<Void>, public ActorCallback< TimeKeeperActor, 0, Void >, public ActorCallback< TimeKeeperActor, 1, Optional<Value> >, public ActorCallback< TimeKeeperActor, 2, Void >, public ActorCallback< TimeKeeperActor, 3, Void >, public ActorCallback< TimeKeeperActor, 4, Void >, public FastAllocated<TimeKeeperActor>, public TimeKeeperActorState<TimeKeeperActor> {
															#line 8683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<TimeKeeperActor>::operator new;
	using FastAllocated<TimeKeeperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18212932477988292096UL, 5389386320947358720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeKeeperActor, 0, Void >;
friend struct ActorCallback< TimeKeeperActor, 1, Optional<Value> >;
friend struct ActorCallback< TimeKeeperActor, 2, Void >;
friend struct ActorCallback< TimeKeeperActor, 3, Void >;
friend struct ActorCallback< TimeKeeperActor, 4, Void >;
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperActor(ClusterControllerData* const& self) 
															#line 8704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TimeKeeperActorState<TimeKeeperActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10218480498489324032UL, 15738055826982653184UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeKeeper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeKeeperActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TimeKeeperActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TimeKeeperActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TimeKeeperActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TimeKeeperActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> timeKeeper( ClusterControllerData* const& self ) {
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TimeKeeperActor(self));
															#line 8741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1586 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 8746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via statusServer()
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class StatusServerActor>
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StatusServerActorState {
															#line 8753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StatusServerActorState(FutureStream<StatusRequest> const& requests,ClusterControllerData* const& self,ServerCoordinators const& coordinators,ConfigBroadcaster const* const& configBroadcaster) 
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : requests(requests),
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   self(self),
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   coordinators(coordinators),
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   configBroadcaster(configBroadcaster),
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   last_request_time(0.0),
															#line 1595 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   requests_batch()
															#line 8770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("statusServer", reinterpret_cast<unsigned long>(this));

	}
	~StatusServerActorState() 
	{
		fdb_probe_actor_destroy("statusServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1597 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 8785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StatusServerActorState();
		static_cast<StatusServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1600 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto __when_expr_0 = requests;
															#line 8816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<StatusRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<StatusRequest>>::value, "invalid type");
															#line 1600 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<StatusServerActor*>(this)->actor_wait_state = 1;
															#line 1600 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< StatusServerActor, 0, StatusRequest >*>(static_cast<StatusServerActor*>(this)));
															#line 8825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1689 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "StatusServerError").error(e);
															#line 1690 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 8849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(StatusRequest const& req,int loopDepth) 
	{
															#line 1601 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		++self->statusRequests;
															#line 1602 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.push_back(req);
															#line 1605 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		double next_allowed_request_time = last_request_time + SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS;
															#line 1608 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		double minwait = std::max(next_allowed_request_time - now(), 0.0);
															#line 1609 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(minwait);
															#line 1609 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 2;
															#line 1609 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 1, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 8878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(StatusRequest && req,int loopDepth) 
	{
															#line 1601 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		++self->statusRequests;
															#line 1602 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.push_back(req);
															#line 1605 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		double next_allowed_request_time = last_request_time + SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS;
															#line 1608 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		double minwait = std::max(next_allowed_request_time - now(), 0.0);
															#line 1609 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(minwait);
															#line 1609 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 2;
															#line 1609 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 1, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 8902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(StatusRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(StatusRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorSingleCallback< StatusServerActor, 0, StatusRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,StatusRequest const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,StatusRequest && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1615 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(;requests.isReady();) {
															#line 1616 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto req = requests.pop();
															#line 1617 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS > 0.0 && requests_batch.size() + 1 > SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS * SERVER_KNOBS->MAX_STATUS_REQUESTS_PER_SECOND)
															#line 8990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1620 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyStatusRequests") .suppressFor(1.0) .detail("BatchSize", requests_batch.size());
															#line 1623 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.reply.sendError(server_overloaded());
															#line 8996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1625 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.push_back(req);
															#line 9002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1630 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<WorkerDetails> workers;
															#line 1631 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<ProcessIssues> workerIssues;
															#line 1633 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1634 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			workers.push_back(it.second.details);
															#line 1635 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it.second.issues.size())
															#line 9015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1636 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				workerIssues.emplace_back(it.second.details.interf.address(), it.second.issues);
															#line 9019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1640 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<NetworkAddress> incompatibleConnections;
															#line 1641 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(auto it = self->db.incompatibleConnections.begin();it != self->db.incompatibleConnections.end();) {
															#line 1642 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it->second < now())
															#line 9028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1643 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				it = self->db.incompatibleConnections.erase(it);
															#line 9032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1645 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				incompatibleConnections.push_back(it->first);
															#line 1646 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				it++;
															#line 9040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<StatusReply>> __when_expr_2 = errorOr(clusterGetStatus(self->db.serverInfo, self->cx, workers, workerIssues, self->storageStatusInfos, &self->db.clientStatus, coordinators, incompatibleConnections, self->datacenterVersionDifference, self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference, configBroadcaster, self->excludedDegradedServers));
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9047 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 3;
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*>(static_cast<StatusServerActor*>(this)));
															#line 9052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1615 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(;requests.isReady();) {
															#line 1616 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto req = requests.pop();
															#line 1617 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS > 0.0 && requests_batch.size() + 1 > SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS * SERVER_KNOBS->MAX_STATUS_REQUESTS_PER_SECOND)
															#line 9065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1620 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyStatusRequests") .suppressFor(1.0) .detail("BatchSize", requests_batch.size());
															#line 1623 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.reply.sendError(server_overloaded());
															#line 9071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1625 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.push_back(req);
															#line 9077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1630 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<WorkerDetails> workers;
															#line 1631 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<ProcessIssues> workerIssues;
															#line 1633 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1634 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			workers.push_back(it.second.details);
															#line 1635 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it.second.issues.size())
															#line 9090 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1636 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				workerIssues.emplace_back(it.second.details.interf.address(), it.second.issues);
															#line 9094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1640 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<NetworkAddress> incompatibleConnections;
															#line 1641 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(auto it = self->db.incompatibleConnections.begin();it != self->db.incompatibleConnections.end();) {
															#line 1642 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it->second < now())
															#line 9103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1643 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				it = self->db.incompatibleConnections.erase(it);
															#line 9107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1645 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				incompatibleConnections.push_back(it->first);
															#line 1646 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				it++;
															#line 9115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<StatusReply>> __when_expr_2 = errorOr(clusterGetStatus(self->db.serverInfo, self->cx, workers, workerIssues, self->storageStatusInfos, &self->db.clientStatus, coordinators, incompatibleConnections, self->datacenterVersionDifference, self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference, configBroadcaster, self->excludedDegradedServers));
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 3;
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*>(static_cast<StatusServerActor*>(this)));
															#line 9127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 1664 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (result.isError() && result.getError().code() == error_code_actor_cancelled)
															#line 9211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1665 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1loopBody1Catch1(result.getError(), loopDepth);
															#line 9215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1669 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		last_request_time = now();
															#line 1671 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		faultToleranceRelatedStatus = Optional<StatusReply>();
															#line 1672 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 9223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(ErrorOr<StatusReply> const& __result,int loopDepth) 
	{
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		result = __result;
															#line 9232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(ErrorOr<StatusReply> && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,ErrorOr<StatusReply> const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,ErrorOr<StatusReply> && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont13(int loopDepth) 
	{
															#line 1687 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		faultToleranceRelatedStatus.reset();
															#line 9311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont13cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1(int loopDepth) 
	{
															#line 1672 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!requests_batch.empty()))
															#line 9327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (result.isError())
															#line 9333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1674 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			requests_batch.back().reply.sendError(result.getError());
															#line 9337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1675 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (requests_batch.back().statusField.empty())
															#line 9343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1676 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.back().reply.send(result.get());
															#line 9347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1678 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(requests_batch.back().statusField == "fault_tolerance");
															#line 1679 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!faultToleranceRelatedStatus.present())
															#line 9355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1680 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					faultToleranceRelatedStatus = clusterGetFaultToleranceStatus(result.get().statusStr);
															#line 9359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1682 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.back().reply.send(faultToleranceRelatedStatus.get());
															#line 9363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1684 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.pop_back();
															#line 1685 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 1685 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 4;
															#line 1685 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 3, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 9377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont13cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	FutureStream<StatusRequest> requests;
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ServerCoordinators coordinators;
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ConfigBroadcaster const* configBroadcaster;
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	double last_request_time;
															#line 1595 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<StatusRequest> requests_batch;
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ErrorOr<StatusReply> result;
															#line 1671 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<StatusReply> faultToleranceRelatedStatus;
															#line 9511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via statusServer()
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StatusServerActor final : public Actor<Void>, public ActorSingleCallback< StatusServerActor, 0, StatusRequest >, public ActorCallback< StatusServerActor, 1, Void >, public ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >, public ActorCallback< StatusServerActor, 3, Void >, public FastAllocated<StatusServerActor>, public StatusServerActorState<StatusServerActor> {
															#line 9516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<StatusServerActor>::operator new;
	using FastAllocated<StatusServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4760924598070621696UL, 9776270243930954240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< StatusServerActor, 0, StatusRequest >;
friend struct ActorCallback< StatusServerActor, 1, Void >;
friend struct ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >;
friend struct ActorCallback< StatusServerActor, 3, Void >;
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StatusServerActor(FutureStream<StatusRequest> const& requests,ClusterControllerData* const& self,ServerCoordinators const& coordinators,ConfigBroadcaster const* const& configBroadcaster) 
															#line 9536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StatusServerActorState<StatusServerActor>(requests, self, coordinators, configBroadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7571137253636277504UL, 14171083556526699776UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("statusServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< StatusServerActor, 0, StatusRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StatusServerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StatusServerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> statusServer( FutureStream<StatusRequest> const& requests, ClusterControllerData* const& self, ServerCoordinators const& coordinators, ConfigBroadcaster const* const& configBroadcaster ) {
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new StatusServerActor(requests, self, coordinators, configBroadcaster));
															#line 9572 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1694 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 9577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorProcessClasses()
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorProcessClassesActor>
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorProcessClassesActorState {
															#line 9584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorProcessClassesActorState(ClusterControllerData* const& self) 
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   trVer(self->db.db)
															#line 9593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorProcessClasses", reinterpret_cast<unsigned long>(this));

	}
	~MonitorProcessClassesActorState() 
	{
		fdb_probe_actor_destroy("monitorProcessClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1698 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 9608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorProcessClassesActorState();
		static_cast<MonitorProcessClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1726 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 9631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1700 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1701 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1703 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = trVer.get(processClassVersionKey);
															#line 1703 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 1;
															#line 1703 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1722 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = trVer.onError(e);
															#line 1722 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 4;
															#line 1722 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 3, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 1705 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (val.present())
															#line 9716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1708 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = trVer.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1708 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 2;
															#line 1708 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 1705 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (val.present())
															#line 9738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1708 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = trVer.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1708 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 2;
															#line 1708 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& processClasses,int loopDepth) 
	{
															#line 1709 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1711 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.clear(processClassKeys);
															#line 1712 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.set(processClassVersionKey, processClassVersionValue);
															#line 1713 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : processClasses ) {
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			UID processUid = decodeProcessClassKeyOld(it.key);
															#line 1715 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.set(processClassKeyFor(processUid.toString()), it.value);
															#line 9845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = trVer.commit();
															#line 1718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 3;
															#line 1718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 2, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && processClasses,int loopDepth) 
	{
															#line 1709 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1711 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.clear(processClassKeys);
															#line 1712 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.set(processClassVersionKey, processClassVersionValue);
															#line 1713 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : processClasses ) {
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			UID processUid = decodeProcessClassKeyOld(it.key);
															#line 1715 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.set(processClassKeyFor(processUid.toString()), it.value);
															#line 9875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = trVer.commit();
															#line 1718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 3;
															#line 1718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 2, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& processClasses,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(processClasses, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && processClasses,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(processClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1719 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ProcessClassUpgrade").log();
															#line 9970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1719 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ProcessClassUpgrade").log();
															#line 9979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1727 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(self->db.db);
															#line 1729 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 10159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1731 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1732 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1733 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_4 = tr.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1733 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 5;
															#line 1733 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1777 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr.onError(e);
															#line 1777 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 10230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 8;
															#line 1777 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 7, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(RangeResult const& processClasses,int loopDepth) 
	{
															#line 1734 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1736 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (processClasses != self->lastProcessClasses || !self->gotProcessClasses)
															#line 10252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1737 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_class.clear();
															#line 1738 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < processClasses.size();i++) {
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto c = decodeProcessClassValue(processClasses[i].value);
															#line 1740 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(c.classSource() != ProcessClass::CommandLineSource);
															#line 1741 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->id_class[decodeProcessClassKey(processClasses[i].key)] = c;
															#line 10264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1744 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& w : self->id_worker ) {
															#line 1745 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.first);
															#line 1746 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ProcessClass newProcessClass;
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || w.second.initialClass.classType() == ProcessClass::UnsetClass))
															#line 10274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1751 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 10278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1753 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = w.second.initialClass;
															#line 10284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1756 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (newProcessClass != w.second.details.processClass)
															#line 10288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1757 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.details.processClass = newProcessClass;
															#line 1758 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.priorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1760 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!w.second.reply.isSet())
															#line 10296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 1761 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						w.second.reply.send( RegisterWorkerReply(w.second.details.processClass, w.second.priorityInfo));
															#line 10300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1767 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->lastProcessClasses = processClasses;
															#line 1768 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->gotProcessClasses = true;
															#line 1769 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 10310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1772 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr.watch(processClassChangeKey);
															#line 1773 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 1773 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 6;
															#line 1773 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 5, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(RangeResult && processClasses,int loopDepth) 
	{
															#line 1734 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1736 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (processClasses != self->lastProcessClasses || !self->gotProcessClasses)
															#line 10334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1737 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_class.clear();
															#line 1738 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < processClasses.size();i++) {
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto c = decodeProcessClassValue(processClasses[i].value);
															#line 1740 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(c.classSource() != ProcessClass::CommandLineSource);
															#line 1741 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->id_class[decodeProcessClassKey(processClasses[i].key)] = c;
															#line 10346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1744 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& w : self->id_worker ) {
															#line 1745 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.first);
															#line 1746 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ProcessClass newProcessClass;
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || w.second.initialClass.classType() == ProcessClass::UnsetClass))
															#line 10356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1751 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 10360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1753 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = w.second.initialClass;
															#line 10366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1756 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (newProcessClass != w.second.details.processClass)
															#line 10370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1757 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.details.processClass = newProcessClass;
															#line 1758 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.priorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1760 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!w.second.reply.isSet())
															#line 10378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 1761 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						w.second.reply.send( RegisterWorkerReply(w.second.details.processClass, w.second.priorityInfo));
															#line 10382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1767 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->lastProcessClasses = processClasses;
															#line 1768 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->gotProcessClasses = true;
															#line 1769 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 10392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1772 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr.watch(processClassChangeKey);
															#line 1773 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 1773 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 6;
															#line 1773 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 5, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(RangeResult const& processClasses,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(processClasses, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(RangeResult && processClasses,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(processClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1774 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = watchFuture;
															#line 1774 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 7;
															#line 1774 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 6, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1774 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = watchFuture;
															#line 1774 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 7;
															#line 1774 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 6, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1loopBody1cont11(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction trVer;
															#line 1727 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1772 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> watchFuture;
															#line 10774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorProcessClasses()
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorProcessClassesActor final : public Actor<Void>, public ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >, public ActorCallback< MonitorProcessClassesActor, 1, RangeResult >, public ActorCallback< MonitorProcessClassesActor, 2, Void >, public ActorCallback< MonitorProcessClassesActor, 3, Void >, public ActorCallback< MonitorProcessClassesActor, 4, RangeResult >, public ActorCallback< MonitorProcessClassesActor, 5, Void >, public ActorCallback< MonitorProcessClassesActor, 6, Void >, public ActorCallback< MonitorProcessClassesActor, 7, Void >, public FastAllocated<MonitorProcessClassesActor>, public MonitorProcessClassesActorState<MonitorProcessClassesActor> {
															#line 10779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorProcessClassesActor>::operator new;
	using FastAllocated<MonitorProcessClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10589194281378446080UL, 5998003210414766080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorProcessClassesActor, 1, RangeResult >;
friend struct ActorCallback< MonitorProcessClassesActor, 2, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 3, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 4, RangeResult >;
friend struct ActorCallback< MonitorProcessClassesActor, 5, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 6, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 7, Void >;
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorProcessClassesActor(ClusterControllerData* const& self) 
															#line 10803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorProcessClassesActorState<MonitorProcessClassesActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11588372557279712768UL, 7971599830169234176UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorProcessClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorProcessClasses( ClusterControllerData* const& self ) {
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorProcessClassesActor(self));
															#line 10843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1782 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 10848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorServerInfoConfig()
															#line 1783 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorServerInfoConfigActor>
															#line 1783 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorServerInfoConfigActorState {
															#line 10855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1783 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorServerInfoConfigActorState(ClusterControllerData::DBInfo* const& db) 
															#line 1783 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1783 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db)
															#line 10862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this));

	}
	~MonitorServerInfoConfigActorState() 
	{
		fdb_probe_actor_destroy("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1784 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 10877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorServerInfoConfigActorState();
		static_cast<MonitorServerInfoConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1785 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(db->db);
															#line 1786 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 10909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1788 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1789 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1790 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 1792 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(latencyBandConfigKey);
															#line 1792 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 1;
															#line 1792 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 10945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1814 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 1814 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 10982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 4;
															#line 1814 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 3, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 10987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> const& configVal,int loopDepth) 
	{
															#line 1793 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		Optional<LatencyBandConfig> config;
															#line 1794 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (configVal.present())
															#line 11004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1795 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			config = LatencyBandConfig::parse(configVal.get());
															#line 11008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1798 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto serverInfo = db->serverInfo->get();
															#line 1799 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (config != serverInfo.latencyBandConfig)
															#line 11014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1800 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LatencyBandConfigChanged").detail("Present", config.present());
															#line 1801 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1802 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1803 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.latencyBandConfig = config;
															#line 1804 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->serverInfo->set(serverInfo);
															#line 11026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1807 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		configChangeFuture = tr.watch(latencyBandConfigKey);
															#line 1809 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 1809 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 2;
															#line 1809 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 1, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 11039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> && configVal,int loopDepth) 
	{
															#line 1793 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		Optional<LatencyBandConfig> config;
															#line 1794 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (configVal.present())
															#line 11050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1795 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			config = LatencyBandConfig::parse(configVal.get());
															#line 11054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1798 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto serverInfo = db->serverInfo->get();
															#line 1799 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (config != serverInfo.latencyBandConfig)
															#line 11060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1800 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LatencyBandConfigChanged").detail("Present", config.present());
															#line 1801 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1802 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1803 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.latencyBandConfig = config;
															#line 1804 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->serverInfo->set(serverInfo);
															#line 11072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1807 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		configChangeFuture = tr.watch(latencyBandConfigKey);
															#line 1809 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 1809 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 2;
															#line 1809 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 1, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 11085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& configVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(configVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && configVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(configVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = configChangeFuture;
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 3;
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 2, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 11176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = configChangeFuture;
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 3;
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 2, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 11192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1783 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 1785 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1807 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> configChangeFuture;
															#line 11452 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorServerInfoConfig()
															#line 1783 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorServerInfoConfigActor final : public Actor<Void>, public ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >, public ActorCallback< MonitorServerInfoConfigActor, 1, Void >, public ActorCallback< MonitorServerInfoConfigActor, 2, Void >, public ActorCallback< MonitorServerInfoConfigActor, 3, Void >, public FastAllocated<MonitorServerInfoConfigActor>, public MonitorServerInfoConfigActorState<MonitorServerInfoConfigActor> {
															#line 11457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorServerInfoConfigActor>::operator new;
	using FastAllocated<MonitorServerInfoConfigActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8760504284340775936UL, 9533083515429698048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 1, Void >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 2, Void >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 3, Void >;
															#line 1783 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorServerInfoConfigActor(ClusterControllerData::DBInfo* const& db) 
															#line 11477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorServerInfoConfigActorState<MonitorServerInfoConfigActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7361646417378993920UL, 12905750869672403968UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorServerInfoConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1783 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorServerInfoConfig( ClusterControllerData::DBInfo* const& db ) {
															#line 1783 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorServerInfoConfigActor(db));
															#line 11513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1819 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

// Monitors storage metadata changes and updates to storage servers.
															#line 11519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorStorageMetadata()
															#line 1821 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorStorageMetadataActor>
															#line 1821 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorStorageMetadataActorState {
															#line 11526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1821 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorStorageMetadataActorState(ClusterControllerData* const& self) 
															#line 1821 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1821 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1822 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   metadataMap(serverMetadataKeys.begin, IncludeVersion()),
															#line 1824 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(self->cx)),
															#line 1825 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   servers()
															#line 11539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	~MonitorStorageMetadataActorState() 
	{
		fdb_probe_actor_destroy("monitorStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1826 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 11554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorStorageMetadataActorState();
		static_cast<MonitorStorageMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1828 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			servers.clear();
															#line 1829 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1830 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1831 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1832 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1832 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 1;
															#line 1832 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 11600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1862 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 1862 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 5;
															#line 1862 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 4, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 11629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1833 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1835 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		servers.reserve(serverList.size());
															#line 1836 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto ss : serverList ) {
															#line 1837 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			servers.push_back(StorageServerMetaInfo(decodeServerListValue(ss.value)));
															#line 11650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1840 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(serverMetadataKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1840 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 2;
															#line 1840 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 11661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __serverList,int loopDepth) 
	{
															#line 1832 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverList = __serverList;
															#line 11670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __serverList,int loopDepth) 
	{
		serverList = std::move(__serverList);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1841 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!serverMetadata.more && serverMetadata.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1842 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::map<UID, StorageMetadataType> idMetadata;
															#line 1843 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& sm : serverMetadata ) {
															#line 1844 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			const UID id = decodeServerMetadataKey(sm.key);
															#line 1845 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			idMetadata[id] = decodeServerMetadataValue(sm.value);
															#line 11757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1847 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& s : servers ) {
															#line 1848 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (idMetadata.contains(s.id()))
															#line 11763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1849 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				s.metadata = idMetadata[s.id()];
															#line 11767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1851 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "StorageServerMetadataMissing", self->id).detail("ServerID", s.id());
															#line 11773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr->watch(serverMetadataChangeKey);
															#line 1856 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1856 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 3;
															#line 1856 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 2, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 11787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& __serverMetadata,int loopDepth) 
	{
															#line 1840 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverMetadata = __serverMetadata;
															#line 11796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && __serverMetadata,int loopDepth) 
	{
		serverMetadata = std::move(__serverMetadata);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1858 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->storageStatusInfos = std::move(servers);
															#line 1859 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 1859 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 4;
															#line 1859 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 3, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 11884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1858 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->storageStatusInfos = std::move(servers);
															#line 1859 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 1859 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 4;
															#line 1859 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 3, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 11902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 1860 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr->reset();
															#line 11986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 1860 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr->reset();
															#line 11995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1821 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1822 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	KeyBackedObjectMap<UID, StorageMetadataType, decltype(IncludeVersion())> metadataMap;
															#line 1824 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1825 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<StorageServerMetaInfo> servers;
															#line 1832 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RangeResult serverList;
															#line 1840 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RangeResult serverMetadata;
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> watchFuture;
															#line 12189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorStorageMetadata()
															#line 1821 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorStorageMetadataActor final : public Actor<Void>, public ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >, public ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >, public ActorCallback< MonitorStorageMetadataActor, 2, Void >, public ActorCallback< MonitorStorageMetadataActor, 3, Void >, public ActorCallback< MonitorStorageMetadataActor, 4, Void >, public FastAllocated<MonitorStorageMetadataActor>, public MonitorStorageMetadataActorState<MonitorStorageMetadataActor> {
															#line 12194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorStorageMetadataActor>::operator new;
	using FastAllocated<MonitorStorageMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11587725316598691840UL, 1488915596708011520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >;
friend struct ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >;
friend struct ActorCallback< MonitorStorageMetadataActor, 2, Void >;
friend struct ActorCallback< MonitorStorageMetadataActor, 3, Void >;
friend struct ActorCallback< MonitorStorageMetadataActor, 4, Void >;
															#line 1821 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorStorageMetadataActor(ClusterControllerData* const& self) 
															#line 12215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorStorageMetadataActorState<MonitorStorageMetadataActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8345257820642168576UL, 250769687947896832UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorStorageMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1821 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorStorageMetadata( ClusterControllerData* const& self ) {
															#line 1821 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorStorageMetadataActor(self));
															#line 12252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1866 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

// Monitors the global configuration version key for changes. When changes are
// made, the global configuration history is read and any updates are sent to
// all processes in the system by updating the ClientDBInfo object. The
// GlobalConfig actor class contains the functionality to read the latest
// history and update the processes local view.
															#line 12262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorGlobalConfig()
															#line 1872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorGlobalConfigActor>
															#line 1872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorGlobalConfigActorState {
															#line 12269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorGlobalConfigActorState(ClusterControllerData::DBInfo* const& db) 
															#line 1872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db)
															#line 12276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorGlobalConfig", reinterpret_cast<unsigned long>(this));

	}
	~MonitorGlobalConfigActorState() 
	{
		fdb_probe_actor_destroy("monitorGlobalConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1873 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 12291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorGlobalConfigActorState();
		static_cast<MonitorGlobalConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1874 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(db->db);
															#line 1875 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = ClientDBInfo();
															#line 1876 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 12325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1878 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1879 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1880 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(globalConfigVersionKey);
															#line 1880 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 1;
															#line 1880 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 12359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 12396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 5;
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 4, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 12401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 1882 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (globalConfigVersion.present())
															#line 12416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1886 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = tr.getRange(globalConfigHistoryKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1886 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 2;
															#line 1886 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 12427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& __globalConfigVersion,int loopDepth) 
	{
															#line 1880 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		globalConfigVersion = __globalConfigVersion;
															#line 12441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && __globalConfigVersion,int loopDepth) 
	{
		globalConfigVersion = std::move(__globalConfigVersion);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		globalConfigFuture = tr.watch(globalConfigVersionKey);
															#line 1951 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 1951 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 3;
															#line 1951 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 2, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 12529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(RangeResult const& globalConfigHistory,int loopDepth) 
	{
															#line 1890 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(globalConfigHistory.size() > 0);
															#line 1891 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = db->serverInfo->get().client;
															#line 1892 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.history.clear();
															#line 1894 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& kv : globalConfigHistory ) {
															#line 1895 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ObjectReader reader(kv.value.begin(), IncludeVersion());
															#line 1896 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (reader.protocolVersion() != g_network->protocolVersion() || BUGGIFY_WITH_PROB(0.01))
															#line 12548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1904 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.clear();
															#line 1905 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.emplace_back(std::numeric_limits<Version>::max());
															#line 12554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				break;
			}
															#line 1909 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			VersionHistory vh;
															#line 1910 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			reader.deserialize(vh);
															#line 1913 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			BinaryReader versionReader = BinaryReader(kv.key.removePrefix(globalConfigHistoryPrefix), Unversioned());
															#line 1915 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			Version historyCommitVersion;
															#line 1916 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionReader >> historyCommitVersion;
															#line 1917 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			historyCommitVersion = bigEndian64(historyCommitVersion);
															#line 1918 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			vh.version = historyCommitVersion;
															#line 1920 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history.push_back(std::move(vh));
															#line 12573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1923 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (clientInfo.history.size() > 0)
															#line 12577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1935 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history[0].mutations = Standalone<VectorRef<MutationRef>>();
															#line 12581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1938 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.id = deterministicRandom()->randomUniqueID();
															#line 1940 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ServerDBInfo serverInfo = db->serverInfo->get();
															#line 1941 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1942 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1943 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.client = clientInfo;
															#line 1944 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(serverInfo);
															#line 1947 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->clientInfo->set(clientInfo);
															#line 12597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(RangeResult && globalConfigHistory,int loopDepth) 
	{
															#line 1890 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(globalConfigHistory.size() > 0);
															#line 1891 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = db->serverInfo->get().client;
															#line 1892 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.history.clear();
															#line 1894 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& kv : globalConfigHistory ) {
															#line 1895 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ObjectReader reader(kv.value.begin(), IncludeVersion());
															#line 1896 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (reader.protocolVersion() != g_network->protocolVersion() || BUGGIFY_WITH_PROB(0.01))
															#line 12616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1904 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.clear();
															#line 1905 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.emplace_back(std::numeric_limits<Version>::max());
															#line 12622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				break;
			}
															#line 1909 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			VersionHistory vh;
															#line 1910 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			reader.deserialize(vh);
															#line 1913 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			BinaryReader versionReader = BinaryReader(kv.key.removePrefix(globalConfigHistoryPrefix), Unversioned());
															#line 1915 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			Version historyCommitVersion;
															#line 1916 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionReader >> historyCommitVersion;
															#line 1917 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			historyCommitVersion = bigEndian64(historyCommitVersion);
															#line 1918 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			vh.version = historyCommitVersion;
															#line 1920 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history.push_back(std::move(vh));
															#line 12641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1923 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (clientInfo.history.size() > 0)
															#line 12645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1935 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history[0].mutations = Standalone<VectorRef<MutationRef>>();
															#line 12649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1938 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.id = deterministicRandom()->randomUniqueID();
															#line 1940 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ServerDBInfo serverInfo = db->serverInfo->get();
															#line 1941 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1942 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1943 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.client = clientInfo;
															#line 1944 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(serverInfo);
															#line 1947 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->clientInfo->set(clientInfo);
															#line 12665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult const& globalConfigHistory,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(globalConfigHistory, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult && globalConfigHistory,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(globalConfigHistory), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 1952 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = globalConfigFuture;
															#line 1952 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 4;
															#line 1952 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 3, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 12756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 1952 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = globalConfigFuture;
															#line 1952 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 4;
															#line 1952 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 3, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 12772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont10(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont10(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 1874 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1875 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClientDBInfo clientInfo;
															#line 1880 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<Value> globalConfigVersion;
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> globalConfigFuture;
															#line 13036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorGlobalConfig()
															#line 1872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorGlobalConfigActor final : public Actor<Void>, public ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >, public ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >, public ActorCallback< MonitorGlobalConfigActor, 2, Void >, public ActorCallback< MonitorGlobalConfigActor, 3, Void >, public ActorCallback< MonitorGlobalConfigActor, 4, Void >, public FastAllocated<MonitorGlobalConfigActor>, public MonitorGlobalConfigActorState<MonitorGlobalConfigActor> {
															#line 13041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorGlobalConfigActor>::operator new;
	using FastAllocated<MonitorGlobalConfigActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15281610884716910336UL, 5460577013797824512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >;
friend struct ActorCallback< MonitorGlobalConfigActor, 2, Void >;
friend struct ActorCallback< MonitorGlobalConfigActor, 3, Void >;
friend struct ActorCallback< MonitorGlobalConfigActor, 4, Void >;
															#line 1872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorGlobalConfigActor(ClusterControllerData::DBInfo* const& db) 
															#line 13062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorGlobalConfigActorState<MonitorGlobalConfigActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9619138829789891328UL, 5514350300057065984UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorGlobalConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorGlobalConfig( ClusterControllerData::DBInfo* const& db ) {
															#line 1872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorGlobalConfigActor(db));
															#line 13099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1960 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 13104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updatedChangingDatacenters()
															#line 1961 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdatedChangingDatacentersActor>
															#line 1961 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangingDatacentersActorState {
															#line 13111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1961 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangingDatacentersActorState(ClusterControllerData* const& self) 
															#line 1961 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1961 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 13118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this));

	}
	~UpdatedChangingDatacentersActorState() 
	{
		fdb_probe_actor_destroy("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1963 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 1963 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 1;
															#line 1963 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 13140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdatedChangingDatacentersActorState();
		static_cast<UpdatedChangingDatacentersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1964 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 13163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1964 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 13172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1965 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->desiredDcIds.onChange();
															#line 1966 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->desiredDcIds.get().present())
															#line 13265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1967 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->changingDcIds.set(std::make_pair(false, self->desiredDcIds.get()));
															#line 13269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		else
		{
															#line 1969 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 1970 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->desiredDcIds.get().get());
															#line 1972 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->changingDcIds.set( std::make_pair(worker.priorityInfo.dcFitness > newFitness, self->desiredDcIds.get()));
															#line 1975 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangingDatacenter", self->id) .detail("OldFitness", worker.priorityInfo.dcFitness) .detail("NewFitness", newFitness);
															#line 1978 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.priorityInfo.dcFitness > newFitness)
															#line 13284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				worker.priorityInfo.dcFitness = newFitness;
															#line 1980 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!worker.reply.isSet())
															#line 13290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1981 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.reply.send(RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 13294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				loopDepth = a_body1cont1loopBody1cont3(loopDepth);
			}
			else
			{
															#line 1984 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 1985 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 13304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2012 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = onChange;
															#line 2012 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 3;
															#line 2012 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 13322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 1985 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(currentFit <= ProcessClass::NeverAssign))
															#line 13350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1986 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool updated = false;
															#line 1987 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1988 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if ((!it.second.priorityInfo.isExcluded && it.second.priorityInfo.processClassFitness == currentFit) || currentFit == ProcessClass::NeverAssign)
															#line 13360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1991 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t fitness = ClusterControllerPriorityInfo::calculateDCFitness( it.second.details.interf.locality.dcId(), self->changingDcIds.get().second.get());
															#line 1993 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (it.first != self->clusterControllerProcessId && it.second.priorityInfo.dcFitness != fitness)
															#line 13366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1995 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					updated = true;
															#line 1996 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					it.second.priorityInfo.dcFitness = fitness;
															#line 1997 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!it.second.reply.isSet())
															#line 13374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 1998 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						it.second.reply.send( RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
															#line 13378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 2004 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (updated && currentFit < ProcessClass::NeverAssign)
															#line 13385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2005 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->CC_CLASS_DELAY);
															#line 2005 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 2;
															#line 2005 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 13396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 2007 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		currentFit++;
															#line 13423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1961 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1965 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 1984 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	int currentFit;
															#line 13608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updatedChangingDatacenters()
															#line 1961 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangingDatacentersActor final : public Actor<Void>, public ActorCallback< UpdatedChangingDatacentersActor, 0, Void >, public ActorCallback< UpdatedChangingDatacentersActor, 1, Void >, public ActorCallback< UpdatedChangingDatacentersActor, 2, Void >, public FastAllocated<UpdatedChangingDatacentersActor>, public UpdatedChangingDatacentersActorState<UpdatedChangingDatacentersActor> {
															#line 13613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdatedChangingDatacentersActor>::operator new;
	using FastAllocated<UpdatedChangingDatacentersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3845572877669205760UL, 7563426506440293888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdatedChangingDatacentersActor, 0, Void >;
friend struct ActorCallback< UpdatedChangingDatacentersActor, 1, Void >;
friend struct ActorCallback< UpdatedChangingDatacentersActor, 2, Void >;
															#line 1961 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangingDatacentersActor(ClusterControllerData* const& self) 
															#line 13632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdatedChangingDatacentersActorState<UpdatedChangingDatacentersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7981795789287489024UL, 15976645570533241600UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updatedChangingDatacenters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1961 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updatedChangingDatacenters( ClusterControllerData* const& self ) {
															#line 1961 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdatedChangingDatacentersActor(self));
															#line 13667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2015 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 13672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updatedChangedDatacenters()
															#line 2016 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdatedChangedDatacentersActor>
															#line 2016 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangedDatacentersActorState {
															#line 13679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2016 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangedDatacentersActorState(ClusterControllerData* const& self) 
															#line 2016 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2016 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   changeDelay(delay(SERVER_KNOBS->CC_CHANGE_DELAY)),
															#line 2018 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   onChange(self->changingDcIds.onChange())
															#line 13690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this));

	}
	~UpdatedChangedDatacentersActorState() 
	{
		fdb_probe_actor_destroy("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2019 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 13705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdatedChangedDatacentersActorState();
		static_cast<UpdatedChangedDatacentersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2021 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = onChange;
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2025 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = changeDelay;
															#line 13741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 1;
															#line 2021 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 2025 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 13748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2022 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = delay(SERVER_KNOBS->CC_CHANGE_DELAY);
															#line 2023 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 13765 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2022 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = delay(SERVER_KNOBS->CC_CHANGE_DELAY);
															#line 2023 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 13776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = Never();
															#line 2027 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 2029 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->changedDcIds.set(self->changingDcIds.get());
															#line 2030 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->changedDcIds.get().second.present())
															#line 13791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2031 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangedDatacenter", self->id).detail("CCFirst", self->changedDcIds.get().first);
															#line 2032 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changedDcIds.get().first)
															#line 13797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2033 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 2036 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (worker.priorityInfo.dcFitness != newFitness)
															#line 13805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2037 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.priorityInfo.dcFitness = newFitness;
															#line 2038 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!worker.reply.isSet())
															#line 13811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 2039 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						worker.reply.send( RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 13815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
				loopDepth = a_body1loopBody1when2cont2(loopDepth);
			}
			else
			{
															#line 2044 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 13826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1when2loopHead1(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = Never();
															#line 2027 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 2029 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->changedDcIds.set(self->changingDcIds.get());
															#line 2030 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->changedDcIds.get().second.present())
															#line 13847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2031 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangedDatacenter", self->id).detail("CCFirst", self->changedDcIds.get().first);
															#line 2032 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changedDcIds.get().first)
															#line 13853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2033 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 2036 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (worker.priorityInfo.dcFitness != newFitness)
															#line 13861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2037 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.priorityInfo.dcFitness = newFitness;
															#line 2038 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!worker.reply.isSet())
															#line 13867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 2039 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						worker.reply.send( RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 13871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
				loopDepth = a_body1loopBody1when2cont2(loopDepth);
			}
			else
			{
															#line 2044 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 13882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1when2loopHead1(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 0, Void >::remove();
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1when2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1(int loopDepth) 
	{
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(currentFit <= ProcessClass::NeverAssign))
															#line 13986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1when2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2046 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool updated = false;
															#line 2047 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 2048 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if ((!it.second.priorityInfo.isExcluded && it.second.priorityInfo.processClassFitness == currentFit) || currentFit == ProcessClass::NeverAssign)
															#line 13996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t fitness = ClusterControllerPriorityInfo::calculateDCFitness( it.second.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 2054 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (it.first != self->clusterControllerProcessId && it.second.priorityInfo.dcFitness != fitness)
															#line 14002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2056 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					updated = true;
															#line 2057 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					it.second.priorityInfo.dcFitness = fitness;
															#line 2058 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!it.second.reply.isSet())
															#line 14010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 2059 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						it.second.reply.send(RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
															#line 14014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 2065 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (updated && currentFit < ProcessClass::NeverAssign)
															#line 14021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2066 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->CC_CLASS_DELAY);
															#line 2066 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 14027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1when2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 2;
															#line 2066 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 14032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1when2cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont1(int loopDepth) 
	{
															#line 2068 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		currentFit++;
															#line 14059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1when2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2016 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> changeDelay;
															#line 2018 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 2044 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	int currentFit;
															#line 14216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updatedChangedDatacenters()
															#line 2016 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangedDatacentersActor final : public Actor<Void>, public ActorCallback< UpdatedChangedDatacentersActor, 0, Void >, public ActorCallback< UpdatedChangedDatacentersActor, 1, Void >, public ActorCallback< UpdatedChangedDatacentersActor, 2, Void >, public FastAllocated<UpdatedChangedDatacentersActor>, public UpdatedChangedDatacentersActorState<UpdatedChangedDatacentersActor> {
															#line 14221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdatedChangedDatacentersActor>::operator new;
	using FastAllocated<UpdatedChangedDatacentersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18279692468894130688UL, 4084558363904506112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdatedChangedDatacentersActor, 0, Void >;
friend struct ActorCallback< UpdatedChangedDatacentersActor, 1, Void >;
friend struct ActorCallback< UpdatedChangedDatacentersActor, 2, Void >;
															#line 2016 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangedDatacentersActor(ClusterControllerData* const& self) 
															#line 14240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdatedChangedDatacentersActorState<UpdatedChangedDatacentersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2151090047836179200UL, 49094124038652928UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updatedChangedDatacenters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2016 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updatedChangedDatacenters( ClusterControllerData* const& self ) {
															#line 2016 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdatedChangedDatacentersActor(self));
															#line 14274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2076 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 14279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateDatacenterVersionDifference()
															#line 2077 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdateDatacenterVersionDifferenceActor>
															#line 2077 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateDatacenterVersionDifferenceActorState {
															#line 14286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2077 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateDatacenterVersionDifferenceActorState(ClusterControllerData* const& self) 
															#line 2077 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2077 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   lastLogTime(0)
															#line 14295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this));

	}
	~UpdateDatacenterVersionDifferenceActorState() 
	{
		fdb_probe_actor_destroy("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2079 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 14310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateDatacenterVersionDifferenceActorState();
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2080 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->versionDifferenceUpdated = false;
															#line 2081 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS && self->db.config.usableRegions == 1)
															#line 14342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2083 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 2086 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = 0;
															#line 2087 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = 0;
															#line 2088 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = 0;
															#line 2090 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge)
															#line 14356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2091 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 14360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2094 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2094 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 1;
															#line 2094 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 14371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2098 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		primaryLog = Optional<TLogInterface>();
															#line 2099 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		remoteLog = Optional<TLogInterface>();
															#line 2100 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().recoveryState >= RecoveryState::ALL_LOGS_RECRUITED)
															#line 14389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2101 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& logSet : self->db.serverInfo->get().logSystemConfig.tLogs ) {
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (logSet.isLocal && logSet.locality != tagLocalitySatellite)
															#line 14395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2103 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 2104 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						if (tLog.present())
															#line 14401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
						{
															#line 2105 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
							primaryLog = tLog.interf();
															#line 14405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
							break;
						}
					}
				}
															#line 2110 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!logSet.isLocal)
															#line 14412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2111 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 2112 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						if (tLog.present())
															#line 14418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
						{
															#line 2113 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
							remoteLog = tLog.interf();
															#line 14422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
							break;
						}
					}
				}
			}
		}
															#line 2121 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!primaryLog.present() || !remoteLog.present() || !self->db.serverInfo->get().ratekeeper.present())
															#line 14431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2122 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->db.serverInfo->onChange();
															#line 2122 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 2;
															#line 2122 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 14442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 2126 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->db.serverInfo->onChange();
															#line 2127 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 14545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont15(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1(int loopDepth) 
	{
															#line 2128 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		primaryMetrics = brokenPromiseToNever(primaryLog.get().getQueuingMetrics.getReply(TLogQueuingMetricsRequest()));
															#line 2130 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		remoteMetrics = brokenPromiseToNever(remoteLog.get().getQueuingMetrics.getReply(TLogQueuingMetricsRequest()));
															#line 2132 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ssVersionLagReply = brokenPromiseToNever( self->db.serverInfo->get().ratekeeper.get().getSSVersionLag.getReply(GetSSVersionLagRequest()));
															#line 2135 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = (success(primaryMetrics) && success(remoteMetrics) && success(ssVersionLagReply)) || onChange;
															#line 2135 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 14662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 3;
															#line 2135 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 14667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2136 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 14689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (primaryMetrics.get().v > 0 && remoteMetrics.get().v > 0)
															#line 14695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2141 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 2143 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 2144 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = primaryMetrics.get().v - remoteMetrics.get().v;
															#line 2145 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = (ssVersionLagReply.get().maxPrimarySSVersion > 0 && ssVersionLagReply.get().maxRemoteSSVersion > 0) ? (ssVersionLagReply.get().maxPrimarySSVersion - ssVersionLagReply.get().maxRemoteSSVersion) : 0;
															#line 2149 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = std::max(self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference);
															#line 2152 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("VersionDifferenceOldLarge").detail("OldDifference", oldDifferenceTooLarge);
															#line 2154 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge && self->datacenterVersionDifference < SERVER_KNOBS->MAX_VERSION_DIFFERENCE)
															#line 14711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 14715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2158 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (now() - lastLogTime > SERVER_KNOBS->CLUSTER_CONTROLLER_LOGGING_DELAY)
															#line 14719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2159 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				lastLogTime = now();
															#line 2160 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("DatacenterVersionDifference", self->id) .detail("Difference", self->datacenterVersionDifference) .detail("LogServerVersionDifference", self->dcLogServerVersionDifference) .detail("StorageServerVersionDifference", self->dcStorageServerVersionDifference);
															#line 14725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 2167 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->VERSION_LAG_METRIC_INTERVAL) || onChange;
															#line 2167 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 14732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 4;
															#line 2167 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 14737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2136 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 14746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (primaryMetrics.get().v > 0 && remoteMetrics.get().v > 0)
															#line 14752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2141 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 2143 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 2144 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = primaryMetrics.get().v - remoteMetrics.get().v;
															#line 2145 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = (ssVersionLagReply.get().maxPrimarySSVersion > 0 && ssVersionLagReply.get().maxRemoteSSVersion > 0) ? (ssVersionLagReply.get().maxPrimarySSVersion - ssVersionLagReply.get().maxRemoteSSVersion) : 0;
															#line 2149 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = std::max(self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference);
															#line 2152 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("VersionDifferenceOldLarge").detail("OldDifference", oldDifferenceTooLarge);
															#line 2154 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge && self->datacenterVersionDifference < SERVER_KNOBS->MAX_VERSION_DIFFERENCE)
															#line 14768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 14772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2158 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (now() - lastLogTime > SERVER_KNOBS->CLUSTER_CONTROLLER_LOGGING_DELAY)
															#line 14776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2159 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				lastLogTime = now();
															#line 2160 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("DatacenterVersionDifference", self->id) .detail("Difference", self->datacenterVersionDifference) .detail("LogServerVersionDifference", self->dcLogServerVersionDifference) .detail("StorageServerVersionDifference", self->dcStorageServerVersionDifference);
															#line 14782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 2167 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->VERSION_LAG_METRIC_INTERVAL) || onChange;
															#line 2167 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 14789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 4;
															#line 2167 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 14794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2168 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 14878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2168 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 14890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2077 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	double lastLogTime;
															#line 2098 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<TLogInterface> primaryLog;
															#line 2099 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<TLogInterface> remoteLog;
															#line 2126 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 2128 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<TLogQueuingMetricsReply> primaryMetrics;
															#line 2130 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<TLogQueuingMetricsReply> remoteMetrics;
															#line 2132 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<GetSSVersionLagReply> ssVersionLagReply;
															#line 14989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateDatacenterVersionDifference()
															#line 2077 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateDatacenterVersionDifferenceActor final : public Actor<Void>, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >, public FastAllocated<UpdateDatacenterVersionDifferenceActor>, public UpdateDatacenterVersionDifferenceActorState<UpdateDatacenterVersionDifferenceActor> {
															#line 14994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateDatacenterVersionDifferenceActor>::operator new;
	using FastAllocated<UpdateDatacenterVersionDifferenceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3364121844056152832UL, 5340921245766370560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >;
															#line 2077 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateDatacenterVersionDifferenceActor(ClusterControllerData* const& self) 
															#line 15014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateDatacenterVersionDifferenceActorState<UpdateDatacenterVersionDifferenceActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9937717957229000960UL, 3709248056524776448UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateDatacenterVersionDifference");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2077 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updateDatacenterVersionDifference( ClusterControllerData* const& self ) {
															#line 2077 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdateDatacenterVersionDifferenceActor(self));
															#line 15050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2174 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

// A background actor that periodically checks remote DC health, and `checkOutstandingRequests` if remote DC
// recovers.
															#line 15057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateRemoteDCHealth()
															#line 2177 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdateRemoteDCHealthActor>
															#line 2177 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateRemoteDCHealthActorState {
															#line 15064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2177 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateRemoteDCHealthActorState(ClusterControllerData* const& self) 
															#line 2177 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2177 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 15071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRemoteDCHealthActorState() 
	{
		fdb_probe_actor_destroy("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2180 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->INITIAL_UPDATE_CROSS_DC_INFO_DELAY);
															#line 2180 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 1;
															#line 2180 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*>(static_cast<UpdateRemoteDCHealthActor*>(this)));
															#line 15093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRemoteDCHealthActorState();
		static_cast<UpdateRemoteDCHealthActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2182 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteDCMonitorStarted = true;
															#line 2186 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->remoteTransactionSystemDegraded)
															#line 15118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2187 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 15122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2190 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 15126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2182 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteDCMonitorStarted = true;
															#line 2186 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->remoteTransactionSystemDegraded)
															#line 15137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2187 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 15141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2190 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 15145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state > 0) static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRemoteDCHealthActor*>(this)->ActorCallback< UpdateRemoteDCHealthActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2191 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool oldRemoteTransactionSystemDegraded = self->remoteTransactionSystemDegraded;
															#line 2192 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteTransactionSystemDegraded = self->remoteTransactionSystemContainsDegradedServers();
															#line 2194 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (oldRemoteTransactionSystemDegraded && !self->remoteTransactionSystemDegraded)
															#line 15240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2195 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 15244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2197 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->CHECK_REMOTE_HEALTH_INTERVAL);
															#line 2197 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 2;
															#line 2197 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*>(static_cast<UpdateRemoteDCHealthActor*>(this)));
															#line 15255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state > 0) static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRemoteDCHealthActor*>(this)->ActorCallback< UpdateRemoteDCHealthActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2177 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 15349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateRemoteDCHealth()
															#line 2177 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateRemoteDCHealthActor final : public Actor<Void>, public ActorCallback< UpdateRemoteDCHealthActor, 0, Void >, public ActorCallback< UpdateRemoteDCHealthActor, 1, Void >, public FastAllocated<UpdateRemoteDCHealthActor>, public UpdateRemoteDCHealthActorState<UpdateRemoteDCHealthActor> {
															#line 15354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateRemoteDCHealthActor>::operator new;
	using FastAllocated<UpdateRemoteDCHealthActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13582046267671739136UL, 9931873845098462208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateRemoteDCHealthActor, 0, Void >;
friend struct ActorCallback< UpdateRemoteDCHealthActor, 1, Void >;
															#line 2177 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateRemoteDCHealthActor(ClusterControllerData* const& self) 
															#line 15372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateRemoteDCHealthActorState<UpdateRemoteDCHealthActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4727392956320167168UL, 13078950417560124416UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRemoteDCHealth");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2177 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updateRemoteDCHealth( ClusterControllerData* const& self ) {
															#line 2177 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdateRemoteDCHealthActor(self));
															#line 15406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2200 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 15411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doEmptyCommit()
															#line 2201 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoEmptyCommitActor>
															#line 2201 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoEmptyCommitActorState {
															#line 15418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2201 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoEmptyCommitActorState(Database const& cx) 
															#line 2201 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2201 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cx(cx),
															#line 2202 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(cx)
															#line 15427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doEmptyCommit", reinterpret_cast<unsigned long>(this));

	}
	~DoEmptyCommitActorState() 
	{
		fdb_probe_actor_destroy("doEmptyCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 15442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2205 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2206 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2207 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.makeSelfConflicting();
															#line 2208 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 2208 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 1;
															#line 2208 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoEmptyCommitActor, 0, Void >*>(static_cast<DoEmptyCommitActor*>(this)));
															#line 15486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2211 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 2211 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 2;
															#line 2211 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoEmptyCommitActor, 1, Void >*>(static_cast<DoEmptyCommitActor*>(this)));
															#line 15515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2209 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoEmptyCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoEmptyCommitActorState(); static_cast<DoEmptyCommitActor*>(this)->destroy(); return 0; }
															#line 15530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<DoEmptyCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2209 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoEmptyCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoEmptyCommitActorState(); static_cast<DoEmptyCommitActor*>(this)->destroy(); return 0; }
															#line 15542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<DoEmptyCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state > 0) static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DoEmptyCommitActor*>(this)->ActorCallback< DoEmptyCommitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoEmptyCommitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state > 0) static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DoEmptyCommitActor*>(this)->ActorCallback< DoEmptyCommitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoEmptyCommitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2201 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Database cx;
															#line 2202 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Transaction tr;
															#line 15716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doEmptyCommit()
															#line 2201 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoEmptyCommitActor final : public Actor<Void>, public ActorCallback< DoEmptyCommitActor, 0, Void >, public ActorCallback< DoEmptyCommitActor, 1, Void >, public FastAllocated<DoEmptyCommitActor>, public DoEmptyCommitActorState<DoEmptyCommitActor> {
															#line 15721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoEmptyCommitActor>::operator new;
	using FastAllocated<DoEmptyCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2880581804633622016UL, 14941568937411022336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoEmptyCommitActor, 0, Void >;
friend struct ActorCallback< DoEmptyCommitActor, 1, Void >;
															#line 2201 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoEmptyCommitActor(Database const& cx) 
															#line 15739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoEmptyCommitActorState<DoEmptyCommitActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9964447062675513344UL, 11254058382217442560UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doEmptyCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoEmptyCommitActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoEmptyCommitActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2201 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doEmptyCommit( Database const& cx ) {
															#line 2201 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoEmptyCommitActor(cx));
															#line 15773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2215 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 15778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via handleForcedRecoveries()
															#line 2216 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class HandleForcedRecoveriesActor>
															#line 2216 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleForcedRecoveriesActorState {
															#line 15785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2216 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleForcedRecoveriesActorState(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 2216 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2216 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2216 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   interf(interf)
															#line 15794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handleForcedRecoveries", reinterpret_cast<unsigned long>(this));

	}
	~HandleForcedRecoveriesActorState() 
	{
		fdb_probe_actor_destroy("handleForcedRecoveries", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2217 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 15809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleForcedRecoveriesActorState();
		static_cast<HandleForcedRecoveriesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2218 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto __when_expr_0 = interf.clientInterface.forceRecovery.getFuture();
															#line 15839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ForceRecoveryRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ForceRecoveryRequest>>::value, "invalid type");
															#line 2218 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 1;
															#line 2218 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 15848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2219 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ForcedRecoveryStart", self->id) .detail("ClusterControllerDcId", self->clusterControllerDcId) .detail("DcId", req.dcId.printable());
															#line 2222 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		fCommit = doEmptyCommit(self->cx);
															#line 2223 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = fCommit || delay(SERVER_KNOBS->FORCE_RECOVERY_CHECK_DELAY);
															#line 2223 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 2;
															#line 2223 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 1, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 15868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ForceRecoveryRequest const& __req,int loopDepth) 
	{
															#line 2218 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req = __req;
															#line 15877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ForceRecoveryRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,ForceRecoveryRequest const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,ForceRecoveryRequest && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!fCommit.isReady() || fCommit.isError())
															#line 15956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2225 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->clusterControllerDcId != req.dcId)
															#line 15960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				std::vector<Optional<Key>> dcPriority;
															#line 2227 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(req.dcId);
															#line 2228 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(self->clusterControllerDcId);
															#line 2229 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->desiredDcIds.set(dcPriority);
															#line 15970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2231 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceRecovery = true;
															#line 2232 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceMasterFailure.trigger();
															#line 15978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2234 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = fCommit;
															#line 2234 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 3;
															#line 2234 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 2, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 15989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!fCommit.isReady() || fCommit.isError())
															#line 16003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2225 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->clusterControllerDcId != req.dcId)
															#line 16007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				std::vector<Optional<Key>> dcPriority;
															#line 2227 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(req.dcId);
															#line 2228 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(self->clusterControllerDcId);
															#line 2229 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->desiredDcIds.set(dcPriority);
															#line 16017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2231 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceRecovery = true;
															#line 2232 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceMasterFailure.trigger();
															#line 16025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2234 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = fCommit;
															#line 2234 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 3;
															#line 2234 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 2, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 16036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorCallback< HandleForcedRecoveriesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 2236 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ForcedRecoveryFinish", self->id).log();
															#line 2237 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.forceRecovery = false;
															#line 2238 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 16129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorCallback< HandleForcedRecoveriesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2216 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2216 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerFullInterface interf;
															#line 2218 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ForceRecoveryRequest req;
															#line 2222 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> fCommit;
															#line 16229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handleForcedRecoveries()
															#line 2216 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleForcedRecoveriesActor final : public Actor<Void>, public ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >, public ActorCallback< HandleForcedRecoveriesActor, 1, Void >, public ActorCallback< HandleForcedRecoveriesActor, 2, Void >, public FastAllocated<HandleForcedRecoveriesActor>, public HandleForcedRecoveriesActorState<HandleForcedRecoveriesActor> {
															#line 16234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandleForcedRecoveriesActor>::operator new;
	using FastAllocated<HandleForcedRecoveriesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6174006474720056832UL, 2387596221602033408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >;
friend struct ActorCallback< HandleForcedRecoveriesActor, 1, Void >;
friend struct ActorCallback< HandleForcedRecoveriesActor, 2, Void >;
															#line 2216 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleForcedRecoveriesActor(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 16253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandleForcedRecoveriesActorState<HandleForcedRecoveriesActor>(self, interf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14107891886794473728UL, 6151159479286482432UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleForcedRecoveries");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleForcedRecoveriesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< HandleForcedRecoveriesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2216 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> handleForcedRecoveries( ClusterControllerData* const& self, ClusterControllerFullInterface const& interf ) {
															#line 2216 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new HandleForcedRecoveriesActor(self, interf));
															#line 16288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2241 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 16293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via triggerAuditStorage()
															#line 2242 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TriggerAuditStorageActor>
															#line 2242 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class TriggerAuditStorageActorState {
															#line 16300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2242 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditStorageActorState(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 2242 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2242 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2242 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req),
															#line 2243 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   auditId()
															#line 16311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("triggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	~TriggerAuditStorageActorState() 
	{
		fdb_probe_actor_destroy("triggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2244 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(!req.cancel);
															#line 16326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			try {
															#line 2246 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 16330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerAuditStorageActorState();
		static_cast<TriggerAuditStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2274 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<TriggerAuditStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerAuditStorageActorState(); static_cast<TriggerAuditStorageActor*>(this)->destroy(); return 0; }
															#line 16359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<TriggerAuditStorageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TriggerAuditStorageActorState();
		static_cast<TriggerAuditStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2265 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevInfo, "CCTriggerAuditStorageFailed", self->id) .errorUnsuppressed(e) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(audit_storage_failed());
															#line 16374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2250 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageBegin", self->id) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString()) .detail("DDId", self->db.serverInfo->get().distributor.get().id());
															#line 2255 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TriggerAuditRequest fReq(req.getType(), req.range, req.engineType);
															#line 2256 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->db.serverInfo->get().distributor.get().triggerAudit.getReply(fReq);
															#line 2256 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 2;
															#line 2256 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TriggerAuditStorageActor, 1, UID >*>(static_cast<TriggerAuditStorageActor*>(this)));
															#line 16400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2246 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS || !self->db.serverInfo->get().distributor.present()))
															#line 16416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2248 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2248 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 1;
															#line 2248 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerAuditStorageActor, 0, Void >*>(static_cast<TriggerAuditStorageActor*>(this)));
															#line 16429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerAuditStorageActor*>(this)->ActorCallback< TriggerAuditStorageActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(UID const& auditId_,int loopDepth) 
	{
															#line 2257 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auditId = auditId_;
															#line 2258 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageEnd", self->id) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2263 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 16542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(UID && auditId_,int loopDepth) 
	{
															#line 2257 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auditId = auditId_;
															#line 2258 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageEnd", self->id) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2263 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 16555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID const& auditId_,int loopDepth) 
	{
		loopDepth = a_body1cont3(auditId_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID && auditId_,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(auditId_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerAuditStorageActor*>(this)->ActorCallback< TriggerAuditStorageActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TriggerAuditStorageActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2242 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2242 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditRequest req;
															#line 2243 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID auditId;
															#line 16654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via triggerAuditStorage()
															#line 2242 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class TriggerAuditStorageActor final : public Actor<Void>, public ActorCallback< TriggerAuditStorageActor, 0, Void >, public ActorCallback< TriggerAuditStorageActor, 1, UID >, public FastAllocated<TriggerAuditStorageActor>, public TriggerAuditStorageActorState<TriggerAuditStorageActor> {
															#line 16659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<TriggerAuditStorageActor>::operator new;
	using FastAllocated<TriggerAuditStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15074651844989486848UL, 13653263812887508480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerAuditStorageActor, 0, Void >;
friend struct ActorCallback< TriggerAuditStorageActor, 1, UID >;
															#line 2242 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditStorageActor(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 16677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TriggerAuditStorageActorState<TriggerAuditStorageActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12747449799772827392UL, 11482104197366523904UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("triggerAuditStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerAuditStorageActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TriggerAuditStorageActor, 1, UID >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2242 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> triggerAuditStorage( ClusterControllerData* const& self, TriggerAuditRequest const& req ) {
															#line 2242 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TriggerAuditStorageActor(self, req));
															#line 16711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2276 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 16716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via cancelAuditStorage()
															#line 2277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class CancelAuditStorageActor>
															#line 2277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class CancelAuditStorageActorState {
															#line 16723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	CancelAuditStorageActorState(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 2277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req)
															#line 16732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("cancelAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	~CancelAuditStorageActorState() 
	{
		fdb_probe_actor_destroy("cancelAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2278 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(req.cancel);
															#line 16747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			try {
															#line 2280 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 16751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CancelAuditStorageActorState();
		static_cast<CancelAuditStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2304 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<CancelAuditStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CancelAuditStorageActorState(); static_cast<CancelAuditStorageActor*>(this)->destroy(); return 0; }
															#line 16780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<CancelAuditStorageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CancelAuditStorageActorState();
		static_cast<CancelAuditStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2297 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevInfo, "CCCancelAuditStorageFailed", self->id) .errorUnsuppressed(e) .detail("AuditID", req.id) .detail("AuditType", req.getType());
															#line 2301 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(cancel_audit_storage_failed());
															#line 16795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2284 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCCancelAuditStorageBegin", self->id) .detail("AuditID", req.id) .detail("AuditType", req.getType()) .detail("DDId", self->db.serverInfo->get().distributor.get().id());
															#line 2288 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TriggerAuditRequest fReq(req.getType(), req.id);
															#line 2289 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->db.serverInfo->get().distributor.get().triggerAudit.getReply(fReq);
															#line 2289 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 2;
															#line 2289 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CancelAuditStorageActor, 1, UID >*>(static_cast<CancelAuditStorageActor*>(this)));
															#line 16821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2280 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS || !self->db.serverInfo->get().distributor.present()))
															#line 16837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2282 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2282 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 1;
															#line 2282 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CancelAuditStorageActor, 0, Void >*>(static_cast<CancelAuditStorageActor*>(this)));
															#line 16850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<CancelAuditStorageActor*>(this)->ActorCallback< CancelAuditStorageActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CancelAuditStorageActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(UID const& auditId,int loopDepth) 
	{
															#line 2290 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCCancelAuditStorageEnd", self->id) .detail("ReturnedAuditID", auditId) .detail("AuditID", auditId) .detail("AuditType", req.getType());
															#line 2294 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(auditId == req.id);
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 16963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(UID && auditId,int loopDepth) 
	{
															#line 2290 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCCancelAuditStorageEnd", self->id) .detail("ReturnedAuditID", auditId) .detail("AuditID", auditId) .detail("AuditType", req.getType());
															#line 2294 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(auditId == req.id);
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 16976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID const& auditId,int loopDepth) 
	{
		loopDepth = a_body1cont3(auditId, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID && auditId,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(auditId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<CancelAuditStorageActor*>(this)->ActorCallback< CancelAuditStorageActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CancelAuditStorageActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditRequest req;
															#line 17073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via cancelAuditStorage()
															#line 2277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class CancelAuditStorageActor final : public Actor<Void>, public ActorCallback< CancelAuditStorageActor, 0, Void >, public ActorCallback< CancelAuditStorageActor, 1, UID >, public FastAllocated<CancelAuditStorageActor>, public CancelAuditStorageActorState<CancelAuditStorageActor> {
															#line 17078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<CancelAuditStorageActor>::operator new;
	using FastAllocated<CancelAuditStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15336015940268342784UL, 3009297569835685632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CancelAuditStorageActor, 0, Void >;
friend struct ActorCallback< CancelAuditStorageActor, 1, UID >;
															#line 2277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	CancelAuditStorageActor(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 17096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CancelAuditStorageActorState<CancelAuditStorageActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10342539104284409856UL, 5939736706038642176UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cancelAuditStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CancelAuditStorageActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CancelAuditStorageActor, 1, UID >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> cancelAuditStorage( ClusterControllerData* const& self, TriggerAuditRequest const& req ) {
															#line 2277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new CancelAuditStorageActor(self, req));
															#line 17130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2306 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 17135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via handleTriggerAuditStorage()
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class HandleTriggerAuditStorageActor>
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleTriggerAuditStorageActorState {
															#line 17142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleTriggerAuditStorageActorState(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   interf(interf)
															#line 17151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	~HandleTriggerAuditStorageActorState() 
	{
		fdb_probe_actor_destroy("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2308 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 17166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleTriggerAuditStorageActorState();
		static_cast<HandleTriggerAuditStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2309 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto __when_expr_0 = interf.clientInterface.triggerAudit.getFuture();
															#line 17196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<TriggerAuditRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<TriggerAuditRequest>>::value, "invalid type");
															#line 2309 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state = 1;
															#line 2309 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*>(static_cast<HandleTriggerAuditStorageActor*>(this)));
															#line 17205 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(TriggerAuditRequest const& req,int loopDepth) 
	{
															#line 2310 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageReceived", self->id) .detail("ClusterControllerDcId", self->clusterControllerDcId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2315 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.cancel)
															#line 17216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2316 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(req.id.isValid());
															#line 2317 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(cancelAuditStorage(self, req));
															#line 17222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2319 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(triggerAuditStorage(self, req));
															#line 17228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(TriggerAuditRequest && req,int loopDepth) 
	{
															#line 2310 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageReceived", self->id) .detail("ClusterControllerDcId", self->clusterControllerDcId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2315 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.cancel)
															#line 17240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2316 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(req.id.isValid());
															#line 2317 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(cancelAuditStorage(self, req));
															#line 17246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2319 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(triggerAuditStorage(self, req));
															#line 17252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(TriggerAuditRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(TriggerAuditRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<HandleTriggerAuditStorageActor*>(this)->ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*,TriggerAuditRequest const& value) 
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*,TriggerAuditRequest && value) 
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerFullInterface interf;
															#line 17337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handleTriggerAuditStorage()
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleTriggerAuditStorageActor final : public Actor<Void>, public ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >, public FastAllocated<HandleTriggerAuditStorageActor>, public HandleTriggerAuditStorageActorState<HandleTriggerAuditStorageActor> {
															#line 17342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandleTriggerAuditStorageActor>::operator new;
	using FastAllocated<HandleTriggerAuditStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11697152112053377536UL, 8001232140721865216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >;
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleTriggerAuditStorageActor(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 17359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandleTriggerAuditStorageActorState<HandleTriggerAuditStorageActor>(self, interf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15197834898829094656UL, 1920184061417848064UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleTriggerAuditStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> handleTriggerAuditStorage( ClusterControllerData* const& self, ClusterControllerFullInterface const& interf ) {
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new HandleTriggerAuditStorageActor(self, interf));
															#line 17392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2323 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 17397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via startDataDistributor()
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class StartDataDistributorActor>
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartDataDistributorActorState {
															#line 17404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartDataDistributorActorState(ClusterControllerData* const& self,double const& waitTime) 
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   waitTime(waitTime)
															#line 17413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("startDataDistributor", reinterpret_cast<unsigned long>(this));

	}
	~StartDataDistributorActorState() 
	{
		fdb_probe_actor_destroy("startDataDistributor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2327 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(waitTime);
															#line 2327 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 1;
															#line 2327 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 0, Void >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 17435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartDataDistributorActorState();
		static_cast<StartDataDistributorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2329 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartDataDistributor", self->id).log();
															#line 2330 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 17460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2329 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartDataDistributor", self->id).log();
															#line 2330 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 17471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 2332 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			noDistributor = !self->db.serverInfo->get().distributor.present();
															#line 2333 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 17565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2391 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 2391 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 4;
															#line 2391 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 3, Void >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 17587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2386 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCDataDistributorRecruitError", self->id).error(e);
															#line 2387 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 17599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2388 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 17603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 2338 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (noDistributor && self->db.serverInfo->get().distributor.present())
															#line 17619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2340 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartDataDistributorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartDataDistributorActorState(); static_cast<StartDataDistributorActor*>(this)->destroy(); return 0; }
															#line 17623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<StartDataDistributorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartDataDistributorActorState();
			static_cast<StartDataDistributorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2343 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::map<Optional<Standalone<StringRef>>, int> idUsed = self->getUsedIds();
															#line 2344 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerFitnessInfo ddWorker = self->getWorkerForRoleInDatacenter(self->clusterControllerDcId, ProcessClass::DataDistributor, ProcessClass::NeverAssign, self->db.config, idUsed);
															#line 2349 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		InitializeDataDistributorRequest req(deterministicRandom()->randomUniqueID());
															#line 2350 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		worker = ddWorker.worker;
															#line 2351 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->onMasterIsBetter(worker, ProcessClass::DataDistributor))
															#line 17639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2352 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			worker = self->id_worker[self->masterProcessId.get()].details;
															#line 17643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2355 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->recruitingDistributorID = req.reqId;
															#line 2356 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCRecruitDataDistributor", self->id) .detail("Addr", worker.interf.address()) .detail("DDID", req.reqId);
															#line 2360 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<DataDistributorInterface>> __when_expr_2 = worker.interf.dataDistributor.getReplyUnlessFailedFor( req, SERVER_KNOBS->WAIT_FOR_DISTRIBUTOR_JOIN_DELAY, 0);
															#line 2360 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 3;
															#line 2360 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 17658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 2333 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!self->masterProcessId.present() || self->masterProcessId != self->db.serverInfo->get().master.locality.processId() || self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 17674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2336 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->db.serverInfo->onChange() || delay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 2336 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 2;
															#line 2336 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 1, Void >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 17687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(ErrorOr<DataDistributorInterface> const& ddInterf,int loopDepth) 
	{
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ddInterf.present())
															#line 17796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2364 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitDistributor.set(false);
															#line 2365 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingDistributorID = ddInterf.get().id();
															#line 2366 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& distributor = self->db.serverInfo->get().distributor;
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCDataDistributorRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("DDID", ddInterf.get().id());
															#line 2370 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (distributor.present() && distributor.get().id() != ddInterf.get().id() && self->id_worker.contains(distributor.get().locality.processId()))
															#line 17808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2373 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltDataDistributorAfterRecruit", self->id) .detail("DDID", distributor.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2377 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				DataDistributorSingleton(distributor).halt(*self, distributor.get().locality.processId());
															#line 17814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2379 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!distributor.present() || distributor.get().id() != ddInterf.get().id())
															#line 17818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2380 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setDistributor(ddInterf.get());
															#line 17822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2382 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartDataDistributorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartDataDistributorActorState(); static_cast<StartDataDistributorActor*>(this)->destroy(); return 0; }
															#line 17828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<StartDataDistributorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartDataDistributorActorState();
			static_cast<StartDataDistributorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(ErrorOr<DataDistributorInterface> && ddInterf,int loopDepth) 
	{
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ddInterf.present())
															#line 17842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2364 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitDistributor.set(false);
															#line 2365 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingDistributorID = ddInterf.get().id();
															#line 2366 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& distributor = self->db.serverInfo->get().distributor;
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCDataDistributorRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("DDID", ddInterf.get().id());
															#line 2370 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (distributor.present() && distributor.get().id() != ddInterf.get().id() && self->id_worker.contains(distributor.get().locality.processId()))
															#line 17854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2373 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltDataDistributorAfterRecruit", self->id) .detail("DDID", distributor.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2377 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				DataDistributorSingleton(distributor).halt(*self, distributor.get().locality.processId());
															#line 17860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2379 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!distributor.present() || distributor.get().id() != ddInterf.get().id())
															#line 17864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2380 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setDistributor(ddInterf.get());
															#line 17868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2382 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartDataDistributorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartDataDistributorActorState(); static_cast<StartDataDistributorActor*>(this)->destroy(); return 0; }
															#line 17874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<StartDataDistributorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartDataDistributorActorState();
			static_cast<StartDataDistributorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<DataDistributorInterface> const& ddInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(ddInterf, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<DataDistributorInterface> && ddInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(ddInterf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*,ErrorOr<DataDistributorInterface> const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*,ErrorOr<DataDistributorInterface> && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	double waitTime;
															#line 2332 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	bool noDistributor;
															#line 2350 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerDetails worker;
															#line 18067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via startDataDistributor()
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartDataDistributorActor final : public Actor<Void>, public ActorCallback< StartDataDistributorActor, 0, Void >, public ActorCallback< StartDataDistributorActor, 1, Void >, public ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >, public ActorCallback< StartDataDistributorActor, 3, Void >, public FastAllocated<StartDataDistributorActor>, public StartDataDistributorActorState<StartDataDistributorActor> {
															#line 18072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<StartDataDistributorActor>::operator new;
	using FastAllocated<StartDataDistributorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10414696453020215808UL, 13338021313260800768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartDataDistributorActor, 0, Void >;
friend struct ActorCallback< StartDataDistributorActor, 1, Void >;
friend struct ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >;
friend struct ActorCallback< StartDataDistributorActor, 3, Void >;
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartDataDistributorActor(ClusterControllerData* const& self,double const& waitTime) 
															#line 18092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StartDataDistributorActorState<StartDataDistributorActor>(self, waitTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8266636108691840000UL, 3944324526065100544UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startDataDistributor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartDataDistributorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartDataDistributorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StartDataDistributorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> startDataDistributor( ClusterControllerData* const& self, double const& waitTime ) {
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new StartDataDistributorActor(self, waitTime));
															#line 18128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2394 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 18133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorDataDistributor()
															#line 2395 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorDataDistributorActor>
															#line 2395 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorDataDistributorActorState {
															#line 18140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2395 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorDataDistributorActorState(ClusterControllerData* const& self) 
															#line 2395 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2395 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2396 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recruitThrottler()
															#line 18149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorDataDistributor", reinterpret_cast<unsigned long>(this));

	}
	~MonitorDataDistributorActorState() 
	{
		fdb_probe_actor_destroy("monitorDataDistributor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2397 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 18164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorDataDistributorActorState();
		static_cast<MonitorDataDistributorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2401 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 18187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2397 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 18203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 1;
															#line 2398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorDataDistributorActor, 0, Void >*>(static_cast<MonitorDataDistributorActor*>(this)));
															#line 18216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorDataDistributorActor*>(this)->ActorCallback< MonitorDataDistributorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorDataDistributorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2402 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool ddExist = self->db.serverInfo->get().distributor.present();
															#line 2403 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevInfo, "CCMonitorDataDistributor", self->id) .detail("Recruiting", self->recruitDistributor.get()) .detail("Existing", ddExist) .detail("ExistingDD", ddExist ? self->db.serverInfo->get().distributor.get().id().toString() : "");
															#line 2408 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().distributor.present() && !self->recruitDistributor.get())
															#line 18336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2410 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitFailureClient(self->db.serverInfo->get().distributor.get().waitFailure, SERVER_KNOBS->DD_FAILURE_TIME);
															#line 2409 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 2417 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->recruitDistributor.onChange();
															#line 18346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 2;
															#line 2410 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorDataDistributorActor, 1, Void >*>(static_cast<MonitorDataDistributorActor*>(this)));
															#line 2417 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorDataDistributorActor, 2, Void >*>(static_cast<MonitorDataDistributorActor*>(this)));
															#line 18353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 2420 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = startDataDistributor(self, recruitThrottler.newRecruitment());
															#line 2420 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 3;
															#line 2420 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorDataDistributorActor, 3, Void >*>(static_cast<MonitorDataDistributorActor*>(this)));
															#line 18367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2412 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		const auto& distributor = self->db.serverInfo->get().distributor;
															#line 2413 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCDataDistributorDied", self->id).detail("DDID", distributor.get().id());
															#line 2414 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		DataDistributorSingleton(distributor).halt(*self, distributor.get().locality.processId());
															#line 2415 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.clearInterf(ProcessClass::DataDistributorClass);
															#line 18395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2412 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		const auto& distributor = self->db.serverInfo->get().distributor;
															#line 2413 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCDataDistributorDied", self->id).detail("DDID", distributor.get().id());
															#line 2414 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		DataDistributorSingleton(distributor).halt(*self, distributor.get().locality.processId());
															#line 2415 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.clearInterf(ProcessClass::DataDistributorClass);
															#line 18410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorDataDistributorActor*>(this)->ActorCallback< MonitorDataDistributorActor, 1, Void >::remove();
		static_cast<MonitorDataDistributorActor*>(this)->ActorCallback< MonitorDataDistributorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorDataDistributorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorDataDistributorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorDataDistributorActor*>(this)->ActorCallback< MonitorDataDistributorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorDataDistributorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2395 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2396 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	SingletonRecruitThrottler recruitThrottler;
															#line 18639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorDataDistributor()
															#line 2395 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorDataDistributorActor final : public Actor<Void>, public ActorCallback< MonitorDataDistributorActor, 0, Void >, public ActorCallback< MonitorDataDistributorActor, 1, Void >, public ActorCallback< MonitorDataDistributorActor, 2, Void >, public ActorCallback< MonitorDataDistributorActor, 3, Void >, public FastAllocated<MonitorDataDistributorActor>, public MonitorDataDistributorActorState<MonitorDataDistributorActor> {
															#line 18644 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorDataDistributorActor>::operator new;
	using FastAllocated<MonitorDataDistributorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9615759156922222848UL, 7947795182021831424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorDataDistributorActor, 0, Void >;
friend struct ActorCallback< MonitorDataDistributorActor, 1, Void >;
friend struct ActorCallback< MonitorDataDistributorActor, 2, Void >;
friend struct ActorCallback< MonitorDataDistributorActor, 3, Void >;
															#line 2395 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorDataDistributorActor(ClusterControllerData* const& self) 
															#line 18664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorDataDistributorActorState<MonitorDataDistributorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3240252173218499840UL, 15914322439490313216UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorDataDistributor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorDataDistributorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorDataDistributorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorDataDistributorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2395 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorDataDistributor( ClusterControllerData* const& self ) {
															#line 2395 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorDataDistributorActor(self));
															#line 18699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2424 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 18704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via startRatekeeper()
															#line 2425 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class StartRatekeeperActor>
															#line 2425 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartRatekeeperActorState {
															#line 18711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2425 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartRatekeeperActorState(ClusterControllerData* const& self,double const& waitTime) 
															#line 2425 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2425 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2425 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   waitTime(waitTime)
															#line 18720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("startRatekeeper", reinterpret_cast<unsigned long>(this));

	}
	~StartRatekeeperActorState() 
	{
		fdb_probe_actor_destroy("startRatekeeper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2428 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(waitTime);
															#line 2428 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 1;
															#line 2428 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartRatekeeperActor, 0, Void >*>(static_cast<StartRatekeeperActor*>(this)));
															#line 18742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartRatekeeperActorState();
		static_cast<StartRatekeeperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2430 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartRatekeeper", self->id).log();
															#line 2431 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 18767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2430 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartRatekeeper", self->id).log();
															#line 2431 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 18778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<StartRatekeeperActor*>(this)->ActorCallback< StartRatekeeperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartRatekeeperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 2433 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			no_ratekeeper = !self->db.serverInfo->get().ratekeeper.present();
															#line 2434 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 18872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2489 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 2489 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 4;
															#line 2489 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartRatekeeperActor, 3, Void >*>(static_cast<StartRatekeeperActor*>(this)));
															#line 18894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2484 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCRatekeeperRecruitError", self->id).error(e);
															#line 2485 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 18906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2486 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 18910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 2439 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (no_ratekeeper && self->db.serverInfo->get().ratekeeper.present())
															#line 18926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2441 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartRatekeeperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRatekeeperActorState(); static_cast<StartRatekeeperActor*>(this)->destroy(); return 0; }
															#line 18930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<StartRatekeeperActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartRatekeeperActorState();
			static_cast<StartRatekeeperActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2444 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::map<Optional<Standalone<StringRef>>, int> id_used = self->getUsedIds();
															#line 2445 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerFitnessInfo rkWorker = self->getWorkerForRoleInDatacenter(self->clusterControllerDcId, ProcessClass::Ratekeeper, ProcessClass::NeverAssign, self->db.config, id_used);
															#line 2450 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		InitializeRatekeeperRequest req(deterministicRandom()->randomUniqueID());
															#line 2451 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		worker = rkWorker.worker;
															#line 2452 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->onMasterIsBetter(worker, ProcessClass::Ratekeeper))
															#line 18946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2453 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			worker = self->id_worker[self->masterProcessId.get()].details;
															#line 18950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2456 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->recruitingRatekeeperID = req.reqId;
															#line 2457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCRecruitRatekeeper", self->id) .detail("Addr", worker.interf.address()) .detail("RKID", req.reqId);
															#line 2461 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<RatekeeperInterface>> __when_expr_2 = worker.interf.ratekeeper.getReplyUnlessFailedFor(req, SERVER_KNOBS->WAIT_FOR_RATEKEEPER_JOIN_DELAY, 0);
															#line 2461 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 18960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 3;
															#line 2461 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*>(static_cast<StartRatekeeperActor*>(this)));
															#line 18965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 2434 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!self->masterProcessId.present() || self->masterProcessId != self->db.serverInfo->get().master.locality.processId() || self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 18981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2437 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->db.serverInfo->onChange() || delay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 2437 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 2;
															#line 2437 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartRatekeeperActor, 1, Void >*>(static_cast<StartRatekeeperActor*>(this)));
															#line 18994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<StartRatekeeperActor*>(this)->ActorCallback< StartRatekeeperActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartRatekeeperActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(ErrorOr<RatekeeperInterface> const& interf,int loopDepth) 
	{
															#line 2463 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (interf.present())
															#line 19103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2464 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitRatekeeper.set(false);
															#line 2465 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingRatekeeperID = interf.get().id();
															#line 2466 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& ratekeeper = self->db.serverInfo->get().ratekeeper;
															#line 2467 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCRatekeeperRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("RKID", interf.get().id());
															#line 2470 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (ratekeeper.present() && ratekeeper.get().id() != interf.get().id() && self->id_worker.contains(ratekeeper.get().locality.processId()))
															#line 19115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2472 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltRatekeeperAfterRecruit", self->id) .detail("RKID", ratekeeper.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2475 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				RatekeeperSingleton(ratekeeper).halt(*self, ratekeeper.get().locality.processId());
															#line 19121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2477 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!ratekeeper.present() || ratekeeper.get().id() != interf.get().id())
															#line 19125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2478 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setRatekeeper(interf.get());
															#line 19129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2480 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2481 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartRatekeeperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRatekeeperActorState(); static_cast<StartRatekeeperActor*>(this)->destroy(); return 0; }
															#line 19135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<StartRatekeeperActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartRatekeeperActorState();
			static_cast<StartRatekeeperActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(ErrorOr<RatekeeperInterface> && interf,int loopDepth) 
	{
															#line 2463 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (interf.present())
															#line 19149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2464 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitRatekeeper.set(false);
															#line 2465 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingRatekeeperID = interf.get().id();
															#line 2466 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& ratekeeper = self->db.serverInfo->get().ratekeeper;
															#line 2467 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCRatekeeperRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("RKID", interf.get().id());
															#line 2470 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (ratekeeper.present() && ratekeeper.get().id() != interf.get().id() && self->id_worker.contains(ratekeeper.get().locality.processId()))
															#line 19161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2472 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltRatekeeperAfterRecruit", self->id) .detail("RKID", ratekeeper.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2475 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				RatekeeperSingleton(ratekeeper).halt(*self, ratekeeper.get().locality.processId());
															#line 19167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2477 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!ratekeeper.present() || ratekeeper.get().id() != interf.get().id())
															#line 19171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2478 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setRatekeeper(interf.get());
															#line 19175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2480 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2481 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartRatekeeperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRatekeeperActorState(); static_cast<StartRatekeeperActor*>(this)->destroy(); return 0; }
															#line 19181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<StartRatekeeperActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartRatekeeperActorState();
			static_cast<StartRatekeeperActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<RatekeeperInterface> const& interf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(interf, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<RatekeeperInterface> && interf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(interf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<StartRatekeeperActor*>(this)->ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*,ErrorOr<RatekeeperInterface> const& value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*,ErrorOr<RatekeeperInterface> && value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<StartRatekeeperActor*>(this)->ActorCallback< StartRatekeeperActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartRatekeeperActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2425 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2425 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	double waitTime;
															#line 2433 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	bool no_ratekeeper;
															#line 2451 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerDetails worker;
															#line 19374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via startRatekeeper()
															#line 2425 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartRatekeeperActor final : public Actor<Void>, public ActorCallback< StartRatekeeperActor, 0, Void >, public ActorCallback< StartRatekeeperActor, 1, Void >, public ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >, public ActorCallback< StartRatekeeperActor, 3, Void >, public FastAllocated<StartRatekeeperActor>, public StartRatekeeperActorState<StartRatekeeperActor> {
															#line 19379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<StartRatekeeperActor>::operator new;
	using FastAllocated<StartRatekeeperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12421954740040793856UL, 5818062914251346944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartRatekeeperActor, 0, Void >;
friend struct ActorCallback< StartRatekeeperActor, 1, Void >;
friend struct ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >;
friend struct ActorCallback< StartRatekeeperActor, 3, Void >;
															#line 2425 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartRatekeeperActor(ClusterControllerData* const& self,double const& waitTime) 
															#line 19399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StartRatekeeperActorState<StartRatekeeperActor>(self, waitTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3469128922560809472UL, 14309449484042826496UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startRatekeeper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartRatekeeperActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartRatekeeperActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StartRatekeeperActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2425 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> startRatekeeper( ClusterControllerData* const& self, double const& waitTime ) {
															#line 2425 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new StartRatekeeperActor(self, waitTime));
															#line 19435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2492 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 19440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorRatekeeper()
															#line 2493 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorRatekeeperActor>
															#line 2493 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorRatekeeperActorState {
															#line 19447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2493 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorRatekeeperActorState(ClusterControllerData* const& self) 
															#line 2493 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2493 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2494 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recruitThrottler()
															#line 19456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorRatekeeper", reinterpret_cast<unsigned long>(this));

	}
	~MonitorRatekeeperActorState() 
	{
		fdb_probe_actor_destroy("monitorRatekeeper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2495 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 19471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorRatekeeperActorState();
		static_cast<MonitorRatekeeperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2499 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 19494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2495 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 19510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2496 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2496 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 19518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state = 1;
															#line 2496 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorRatekeeperActor, 0, Void >*>(static_cast<MonitorRatekeeperActor*>(this)));
															#line 19523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRatekeeperActor*>(this)->ActorCallback< MonitorRatekeeperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorRatekeeperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2500 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().ratekeeper.present() && !self->recruitRatekeeper.get())
															#line 19639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2502 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitFailureClient(self->db.serverInfo->get().ratekeeper.get().waitFailure, SERVER_KNOBS->RATEKEEPER_FAILURE_TIME);
															#line 2501 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 19645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 2509 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->recruitRatekeeper.onChange();
															#line 19649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state = 2;
															#line 2502 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorRatekeeperActor, 1, Void >*>(static_cast<MonitorRatekeeperActor*>(this)));
															#line 2509 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorRatekeeperActor, 2, Void >*>(static_cast<MonitorRatekeeperActor*>(this)));
															#line 19656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 2512 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = startRatekeeper(self, recruitThrottler.newRecruitment());
															#line 2512 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 19665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state = 3;
															#line 2512 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorRatekeeperActor, 3, Void >*>(static_cast<MonitorRatekeeperActor*>(this)));
															#line 19670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		const auto& ratekeeper = self->db.serverInfo->get().ratekeeper;
															#line 2505 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCRatekeeperDied", self->id).detail("RKID", ratekeeper.get().id());
															#line 2506 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		RatekeeperSingleton(ratekeeper).halt(*self, ratekeeper.get().locality.processId());
															#line 2507 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.clearInterf(ProcessClass::RatekeeperClass);
															#line 19698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		const auto& ratekeeper = self->db.serverInfo->get().ratekeeper;
															#line 2505 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCRatekeeperDied", self->id).detail("RKID", ratekeeper.get().id());
															#line 2506 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		RatekeeperSingleton(ratekeeper).halt(*self, ratekeeper.get().locality.processId());
															#line 2507 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.clearInterf(ProcessClass::RatekeeperClass);
															#line 19713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRatekeeperActor*>(this)->ActorCallback< MonitorRatekeeperActor, 1, Void >::remove();
		static_cast<MonitorRatekeeperActor*>(this)->ActorCallback< MonitorRatekeeperActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorRatekeeperActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorRatekeeperActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRatekeeperActor*>(this)->ActorCallback< MonitorRatekeeperActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 3, Void >*,Void && valu