#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
/*
 * DataDistributionCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "boost/lexical_cast.hpp"

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBTypes.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/Knobs.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

															#line 38 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via setDDMode()
															#line 36 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
template <class SetDDModeActor>
															#line 36 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
class SetDDModeActorState {
															#line 44 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
public:
															#line 36 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	SetDDModeActorState(Reference<IDatabase> const& db,int const& mode) 
															#line 36 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
															#line 36 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		 : db(db),
															#line 36 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		   mode(mode),
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 55 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("setDDMode", reinterpret_cast<unsigned long>(this));

	}
	~SetDDModeActorState() 
	{
		fdb_probe_actor_destroy("setDDMode", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			;
															#line 70 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetDDModeActorState();
		static_cast<SetDDModeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 39 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		try {
															#line 41 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			tr->set(fdb_cli::ddModeSpecialKey, boost::lexical_cast<std::string>(mode));
															#line 42 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			if (mode)
															#line 106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			{
															#line 45 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
				resultFuture = tr->getRange(fdb_cli::maintenanceSpecialKeyRange, CLIENT_KNOBS->TOO_MANY);
															#line 47 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = safeThreadFutureToFuture(resultFuture);
															#line 47 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
				if (static_cast<SetDDModeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SetDDModeActor*>(this)->actor_wait_state = 1;
															#line 47 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetDDModeActor, 0, RangeResult >*>(static_cast<SetDDModeActor*>(this)));
															#line 119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 58 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			TraceEvent("SetDDModeRetrying").error(e);
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			if (static_cast<SetDDModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SetDDModeActor*>(this)->actor_wait_state = 3;
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetDDModeActor, 2, Void >*>(static_cast<SetDDModeActor*>(this)));
															#line 155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 55 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 55 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		if (static_cast<SetDDModeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetDDModeActor*>(this)->actor_wait_state = 2;
															#line 55 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetDDModeActor, 1, Void >*>(static_cast<SetDDModeActor*>(this)));
															#line 177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult const& res,int loopDepth) 
	{
															#line 48 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		ASSERT(res.size() <= 1);
															#line 49 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		if (res.size() == 1 && res[0].key == fdb_cli::ignoreSSFailureSpecialKey)
															#line 188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		{
															#line 51 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			tr->clear(fdb_cli::maintenanceSpecialKeyRange);
															#line 192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		}
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		tr->clear(fdb_cli::ddIgnoreRebalanceSpecialKey);
															#line 196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && res,int loopDepth) 
	{
															#line 48 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		ASSERT(res.size() <= 1);
															#line 49 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		if (res.size() == 1 && res[0].key == fdb_cli::ignoreSSFailureSpecialKey)
															#line 207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		{
															#line 51 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			tr->clear(fdb_cli::maintenanceSpecialKeyRange);
															#line 211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		}
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		tr->clear(fdb_cli::ddIgnoreRebalanceSpecialKey);
															#line 215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetDDModeActor*>(this)->actor_wait_state > 0) static_cast<SetDDModeActor*>(this)->actor_wait_state = 0;
		static_cast<SetDDModeActor*>(this)->ActorCallback< SetDDModeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SetDDModeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("setDDMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetDDModeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("setDDMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetDDModeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("setDDMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDMode", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 56 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		if (!static_cast<SetDDModeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetDDModeActorState(); static_cast<SetDDModeActor*>(this)->destroy(); return 0; }
															#line 299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		new (&static_cast<SetDDModeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetDDModeActorState();
		static_cast<SetDDModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 56 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		if (!static_cast<SetDDModeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetDDModeActorState(); static_cast<SetDDModeActor*>(this)->destroy(); return 0; }
															#line 311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		new (&static_cast<SetDDModeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetDDModeActorState();
		static_cast<SetDDModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetDDModeActor*>(this)->actor_wait_state > 0) static_cast<SetDDModeActor*>(this)->actor_wait_state = 0;
		static_cast<SetDDModeActor*>(this)->ActorCallback< SetDDModeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetDDModeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setDDMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetDDModeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setDDMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetDDModeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setDDMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDMode", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SetDDModeActor*>(this)->actor_wait_state > 0) static_cast<SetDDModeActor*>(this)->actor_wait_state = 0;
		static_cast<SetDDModeActor*>(this)->ActorCallback< SetDDModeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetDDModeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setDDMode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDMode", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SetDDModeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setDDMode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDMode", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SetDDModeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setDDMode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDMode", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 36 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 36 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	int mode;
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 45 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	ThreadFuture<RangeResult> resultFuture;
															#line 489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via setDDMode()
															#line 36 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
class SetDDModeActor final : public Actor<Void>, public ActorCallback< SetDDModeActor, 0, RangeResult >, public ActorCallback< SetDDModeActor, 1, Void >, public ActorCallback< SetDDModeActor, 2, Void >, public FastAllocated<SetDDModeActor>, public SetDDModeActorState<SetDDModeActor> {
															#line 494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<SetDDModeActor>::operator new;
	using FastAllocated<SetDDModeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16925853413884857600UL, 9380396884669707264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetDDModeActor, 0, RangeResult >;
friend struct ActorCallback< SetDDModeActor, 1, Void >;
friend struct ActorCallback< SetDDModeActor, 2, Void >;
															#line 36 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	SetDDModeActor(Reference<IDatabase> const& db,int const& mode) 
															#line 513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SetDDModeActorState<SetDDModeActor>(db, mode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setDDMode", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3750982474694156544UL, 11167414918040745728UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setDDMode");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setDDMode", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetDDModeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetDDModeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SetDDModeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 36 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
[[nodiscard]] Future<Void> setDDMode( Reference<IDatabase> const& db, int const& mode ) {
															#line 36 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	return Future<Void>(new SetDDModeActor(db, mode));
															#line 547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
}

#line 63 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"

															#line 552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via setDDIgnoreRebalanceSwitch()
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
template <class SetDDIgnoreRebalanceSwitchActor>
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
class SetDDIgnoreRebalanceSwitchActorState {
															#line 558 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
public:
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	SetDDIgnoreRebalanceSwitchActorState(Reference<IDatabase> const& db,uint8_t const& DDIgnoreOptionMask,bool const& setMaskedBit) 
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		 : db(db),
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		   DDIgnoreOptionMask(DDIgnoreOptionMask),
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		   setMaskedBit(setMaskedBit),
															#line 65 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this));

	}
	~SetDDIgnoreRebalanceSwitchActorState() 
	{
		fdb_probe_actor_destroy("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 66 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			;
															#line 586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetDDIgnoreRebalanceSwitchActorState();
		static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 67 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 68 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		try {
															#line 70 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			resultFuture = tr->get(rebalanceDDIgnoreKey);
															#line 71 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = safeThreadFutureToFuture(resultFuture);
															#line 71 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			if (static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->actor_wait_state = 1;
															#line 71 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetDDIgnoreRebalanceSwitchActor, 0, Optional<Value> >*>(static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)));
															#line 631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			if (static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->actor_wait_state = 3;
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetDDIgnoreRebalanceSwitchActor, 2, Void >*>(static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)));
															#line 660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 72 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		uint8_t oldValue = DDIgnore::NONE;
															#line 73 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		if (v.present())
															#line 677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		{
															#line 74 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			if (v.get().size() > 0)
															#line 681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			{
															#line 75 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
				oldValue = BinaryReader::fromStringRef<uint8_t>(v.get(), Unversioned());
															#line 685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 79 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
				oldValue = DDIgnore::ALL;
															#line 691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			}
		}
															#line 83 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		uint8_t newValue = setMaskedBit ? (oldValue | DDIgnoreOptionMask) : (oldValue & ~DDIgnoreOptionMask);
															#line 84 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		if (newValue > 0)
															#line 698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		{
															#line 85 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			tr->set(fdb_cli::ddIgnoreRebalanceSpecialKey, BinaryWriter::toValue(newValue, Unversioned()));
															#line 702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 87 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			tr->clear(fdb_cli::ddIgnoreRebalanceSpecialKey);
															#line 708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		}
															#line 89 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 89 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		if (static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->actor_wait_state = 2;
															#line 89 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetDDIgnoreRebalanceSwitchActor, 1, Void >*>(static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)));
															#line 719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 72 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		uint8_t oldValue = DDIgnore::NONE;
															#line 73 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		if (v.present())
															#line 730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		{
															#line 74 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			if (v.get().size() > 0)
															#line 734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			{
															#line 75 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
				oldValue = BinaryReader::fromStringRef<uint8_t>(v.get(), Unversioned());
															#line 738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 79 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
				oldValue = DDIgnore::ALL;
															#line 744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			}
		}
															#line 83 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		uint8_t newValue = setMaskedBit ? (oldValue | DDIgnoreOptionMask) : (oldValue & ~DDIgnoreOptionMask);
															#line 84 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		if (newValue > 0)
															#line 751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		{
															#line 85 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			tr->set(fdb_cli::ddIgnoreRebalanceSpecialKey, BinaryWriter::toValue(newValue, Unversioned()));
															#line 755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 87 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			tr->clear(fdb_cli::ddIgnoreRebalanceSpecialKey);
															#line 761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		}
															#line 89 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 89 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		if (static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->actor_wait_state = 2;
															#line 89 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetDDIgnoreRebalanceSwitchActor, 1, Void >*>(static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)));
															#line 772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->actor_wait_state > 0) static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->ActorCallback< SetDDIgnoreRebalanceSwitchActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< SetDDIgnoreRebalanceSwitchActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetDDIgnoreRebalanceSwitchActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetDDIgnoreRebalanceSwitchActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 90 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		if (!static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetDDIgnoreRebalanceSwitchActorState(); static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->destroy(); return 0; }
															#line 856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		new (&static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetDDIgnoreRebalanceSwitchActorState();
		static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 90 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		if (!static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetDDIgnoreRebalanceSwitchActorState(); static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->destroy(); return 0; }
															#line 868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		new (&static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetDDIgnoreRebalanceSwitchActorState();
		static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->actor_wait_state > 0) static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->ActorCallback< SetDDIgnoreRebalanceSwitchActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetDDIgnoreRebalanceSwitchActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetDDIgnoreRebalanceSwitchActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetDDIgnoreRebalanceSwitchActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->actor_wait_state > 0) static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->ActorCallback< SetDDIgnoreRebalanceSwitchActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetDDIgnoreRebalanceSwitchActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SetDDIgnoreRebalanceSwitchActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SetDDIgnoreRebalanceSwitchActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	uint8_t DDIgnoreOptionMask;
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	bool setMaskedBit;
															#line 65 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 70 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	ThreadFuture<Optional<Value>> resultFuture;
															#line 1048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via setDDIgnoreRebalanceSwitch()
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
class SetDDIgnoreRebalanceSwitchActor final : public Actor<Void>, public ActorCallback< SetDDIgnoreRebalanceSwitchActor, 0, Optional<Value> >, public ActorCallback< SetDDIgnoreRebalanceSwitchActor, 1, Void >, public ActorCallback< SetDDIgnoreRebalanceSwitchActor, 2, Void >, public FastAllocated<SetDDIgnoreRebalanceSwitchActor>, public SetDDIgnoreRebalanceSwitchActorState<SetDDIgnoreRebalanceSwitchActor> {
															#line 1053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<SetDDIgnoreRebalanceSwitchActor>::operator new;
	using FastAllocated<SetDDIgnoreRebalanceSwitchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3834674659985879808UL, 5592315163776817408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetDDIgnoreRebalanceSwitchActor, 0, Optional<Value> >;
friend struct ActorCallback< SetDDIgnoreRebalanceSwitchActor, 1, Void >;
friend struct ActorCallback< SetDDIgnoreRebalanceSwitchActor, 2, Void >;
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	SetDDIgnoreRebalanceSwitchActor(Reference<IDatabase> const& db,uint8_t const& DDIgnoreOptionMask,bool const& setMaskedBit) 
															#line 1072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SetDDIgnoreRebalanceSwitchActorState<SetDDIgnoreRebalanceSwitchActor>(db, DDIgnoreOptionMask, setMaskedBit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14772800207968230656UL, 18076040247206155776UL);
		ActorExecutionContextHelper __helper(static_cast<SetDDIgnoreRebalanceSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setDDIgnoreRebalanceSwitch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setDDIgnoreRebalanceSwitch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetDDIgnoreRebalanceSwitchActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetDDIgnoreRebalanceSwitchActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SetDDIgnoreRebalanceSwitchActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
[[nodiscard]] Future<Void> setDDIgnoreRebalanceSwitch( Reference<IDatabase> const& db, uint8_t const& DDIgnoreOptionMask, bool const& setMaskedBit ) {
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	return Future<Void>(new SetDDIgnoreRebalanceSwitchActor(db, DDIgnoreOptionMask, setMaskedBit));
															#line 1106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
}

#line 96 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"

// set masked bit
Future<Void> setDDIgnoreRebalanceOn(Reference<IDatabase> db, uint8_t DDIgnoreOptionMask) {
	return setDDIgnoreRebalanceSwitch(db, DDIgnoreOptionMask, true);
}

// reset masked bit
Future<Void> setDDIgnoreRebalanceOff(Reference<IDatabase> db, uint8_t DDIgnoreOptionMask) {
	return setDDIgnoreRebalanceSwitch(db, DDIgnoreOptionMask, false);
}

} // namespace

namespace fdb_cli {

const KeyRef ddModeSpecialKey = "\xff\xff/management/data_distribution/mode"_sr;
const KeyRef ddIgnoreRebalanceSpecialKey = "\xff\xff/management/data_distribution/rebalance_ignored"_sr;
constexpr auto usage =
    "Usage: datadistribution <on|off|disable <ssfailure|rebalance|rebalance_disk|rebalance_read>|enable "
    "<ssfailure|rebalance|rebalance_disk|rebalance_read>>\n";
															#line 1130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via dataDistributionCommandActor()
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
template <class DataDistributionCommandActorActor>
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
class DataDistributionCommandActorActorState {
															#line 1136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
public:
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	DataDistributionCommandActorActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		 : db(db),
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		   tokens(tokens),
															#line 117 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		   result(true)
															#line 1147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~DataDistributionCommandActorActorState() 
	{
		fdb_probe_actor_destroy("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 118 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
			if (tokens.size() != 2 && tokens.size() != 3)
															#line 1162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
			{
															#line 119 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
				printf(usage);
															#line 120 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
				result = false;
															#line 1168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1(loopDepth);
			}
			else
			{
															#line 122 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
				if (tokencmp(tokens[1], "on"))
															#line 1175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
				{
															#line 123 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
					StrictFuture<Void> __when_expr_0 = success(setDDMode(db, 1));
															#line 123 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
					if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 1;
															#line 123 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DataDistributionCommandActorActor, 0, Void >*>(static_cast<DataDistributionCommandActorActor*>(this)));
															#line 1186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 125 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
					if (tokencmp(tokens[1], "off"))
															#line 1193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
					{
															#line 126 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
						StrictFuture<Void> __when_expr_1 = success(setDDMode(db, 0));
															#line 126 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
						if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
						static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 2;
															#line 126 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DataDistributionCommandActorActor, 1, Void >*>(static_cast<DataDistributionCommandActorActor*>(this)));
															#line 1204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 128 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
						if (tokencmp(tokens[1], "disable"))
															#line 1211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
						{
															#line 129 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
							if (tokencmp(tokens[2], "ssfailure"))
															#line 1215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
							{
															#line 130 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
								StrictFuture<Void> __when_expr_2 = success((setHealthyZone(db, "IgnoreSSFailures"_sr, 0)));
															#line 130 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
								if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
								if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
								static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 3;
															#line 130 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
								__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DataDistributionCommandActorActor, 2, Void >*>(static_cast<DataDistributionCommandActorActor*>(this)));
															#line 1226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
								loopDepth = 0;
							}
							else
							{
															#line 132 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
								if (tokencmp(tokens[2], "rebalance"))
															#line 1233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
								{
															#line 133 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
									StrictFuture<Void> __when_expr_3 = setDDIgnoreRebalanceOn(db, DDIgnore::REBALANCE_DISK | DDIgnore::REBALANCE_READ);
															#line 133 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
									if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
									if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when4(__when_expr_3.get(), loopDepth); };
									static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 4;
															#line 133 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
									__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DataDistributionCommandActorActor, 3, Void >*>(static_cast<DataDistributionCommandActorActor*>(this)));
															#line 1244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
									loopDepth = 0;
								}
								else
								{
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
									if (tokencmp(tokens[2], "rebalance_disk"))
															#line 1251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
									{
															#line 136 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
										StrictFuture<Void> __when_expr_4 = setDDIgnoreRebalanceOn(db, DDIgnore::REBALANCE_DISK);
															#line 136 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
										if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
										if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1when5(__when_expr_4.get(), loopDepth); };
										static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 5;
															#line 136 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
										__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DataDistributionCommandActorActor, 4, Void >*>(static_cast<DataDistributionCommandActorActor*>(this)));
															#line 1262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
										loopDepth = 0;
									}
									else
									{
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
										if (tokencmp(tokens[2], "rebalance_read"))
															#line 1269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
										{
															#line 139 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
											StrictFuture<Void> __when_expr_5 = setDDIgnoreRebalanceOn(db, DDIgnore::REBALANCE_READ);
															#line 139 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
											if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
											if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1when6(__when_expr_5.get(), loopDepth); };
											static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 6;
															#line 139 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
											__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DataDistributionCommandActorActor, 5, Void >*>(static_cast<DataDistributionCommandActorActor*>(this)));
															#line 1280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
											loopDepth = 0;
										}
										else
										{
															#line 142 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
											printf(usage);
															#line 143 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
											result = false;
															#line 1289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
											loopDepth = a_body1cont16(loopDepth);
										}
									}
								}
							}
						}
						else
						{
															#line 145 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
							if (tokencmp(tokens[1], "enable"))
															#line 1300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
							{
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
								if (tokencmp(tokens[2], "ssfailure"))
															#line 1304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
								{
															#line 147 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
									StrictFuture<Void> __when_expr_6 = success((clearHealthyZone(db, false, true)));
															#line 147 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
									if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
									if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1when7(__when_expr_6.get(), loopDepth); };
									static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 7;
															#line 147 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
									__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DataDistributionCommandActorActor, 6, Void >*>(static_cast<DataDistributionCommandActorActor*>(this)));
															#line 1315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
									loopDepth = 0;
								}
								else
								{
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
									if (tokencmp(tokens[2], "rebalance"))
															#line 1322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
									{
															#line 150 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
										StrictFuture<Void> __when_expr_7 = setDDIgnoreRebalanceOff(db, DDIgnore::REBALANCE_DISK | DDIgnore::REBALANCE_READ);
															#line 150 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
										if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
										if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1when8(__when_expr_7.get(), loopDepth); };
										static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 8;
															#line 150 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
										__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DataDistributionCommandActorActor, 7, Void >*>(static_cast<DataDistributionCommandActorActor*>(this)));
															#line 1333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
										loopDepth = 0;
									}
									else
									{
															#line 152 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
										if (tokencmp(tokens[2], "rebalance_disk"))
															#line 1340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
										{
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
											StrictFuture<Void> __when_expr_8 = setDDIgnoreRebalanceOff(db, DDIgnore::REBALANCE_DISK);
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
											if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
											if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1when9(__when_expr_8.get(), loopDepth); };
											static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 9;
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
											__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DataDistributionCommandActorActor, 8, Void >*>(static_cast<DataDistributionCommandActorActor*>(this)));
															#line 1351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
											loopDepth = 0;
										}
										else
										{
															#line 155 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
											if (tokencmp(tokens[2], "rebalance_read"))
															#line 1358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
											{
															#line 156 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
												StrictFuture<Void> __when_expr_9 = setDDIgnoreRebalanceOff(db, DDIgnore::REBALANCE_READ);
															#line 156 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
												if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
												if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1when10(__when_expr_9.get(), loopDepth); };
												static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 10;
															#line 156 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
												__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DataDistributionCommandActorActor, 9, Void >*>(static_cast<DataDistributionCommandActorActor*>(this)));
															#line 1369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
												loopDepth = 0;
											}
											else
											{
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
												printf(usage);
															#line 160 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
												result = false;
															#line 1378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
												loopDepth = a_body1cont26(loopDepth);
											}
										}
									}
								}
							}
							else
							{
															#line 163 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
								printf(usage);
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
								result = false;
															#line 1391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
								loopDepth = a_body1cont19(loopDepth);
							}
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DataDistributionCommandActorActorState();
		static_cast<DataDistributionCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 167 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		if (!static_cast<DataDistributionCommandActorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~DataDistributionCommandActorActorState(); static_cast<DataDistributionCommandActorActor*>(this)->destroy(); return 0; }
															#line 1419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		new (&static_cast<DataDistributionCommandActorActor*>(this)->SAV< bool >::value()) bool(std::move(result)); // state_var_RVO
		this->~DataDistributionCommandActorActorState();
		static_cast<DataDistributionCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 124 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is turned on.\n");
															#line 1437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 124 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is turned on.\n");
															#line 1446 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state > 0) static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<DataDistributionCommandActorActor*>(this)->ActorCallback< DataDistributionCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DataDistributionCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 127 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is turned off.\n");
															#line 1536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 127 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is turned off.\n");
															#line 1545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state > 0) static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<DataDistributionCommandActorActor*>(this)->ActorCallback< DataDistributionCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DataDistributionCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is disabled for storage server failures.\n");
															#line 1641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is disabled for storage server failures.\n");
															#line 1650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state > 0) static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<DataDistributionCommandActorActor*>(this)->ActorCallback< DataDistributionCommandActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DataDistributionCommandActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
															#line 134 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is disabled for rebalance.\n");
															#line 1740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
															#line 134 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is disabled for rebalance.\n");
															#line 1749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state > 0) static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<DataDistributionCommandActorActor*>(this)->ActorCallback< DataDistributionCommandActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DataDistributionCommandActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont14(int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont15(Void const& _,int loopDepth) 
	{
															#line 137 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is disabled for rebalance_disk.\n");
															#line 1839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont15(Void && _,int loopDepth) 
	{
															#line 137 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is disabled for rebalance_disk.\n");
															#line 1848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state > 0) static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<DataDistributionCommandActorActor*>(this)->ActorCallback< DataDistributionCommandActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DataDistributionCommandActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont16(int loopDepth) 
	{
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont17(Void const& _,int loopDepth) 
	{
															#line 140 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is disabled for rebalance_read.\n");
															#line 1938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1cont17(Void && _,int loopDepth) 
	{
															#line 140 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is disabled for rebalance_read.\n");
															#line 1947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1when6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont17(_, loopDepth);

		return loopDepth;
	}
	int a_body1when6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont17(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state > 0) static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<DataDistributionCommandActorActor*>(this)->ActorCallback< DataDistributionCommandActorActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DataDistributionCommandActorActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont19(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont20(int loopDepth) 
	{
		loopDepth = a_body1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1cont21(Void const& _,int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is enabled for storage server failures.\n");
															#line 2043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1cont21(Void && _,int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is enabled for storage server failures.\n");
															#line 2052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1when7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont21(_, loopDepth);

		return loopDepth;
	}
	int a_body1when7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont21(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state > 0) static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<DataDistributionCommandActorActor*>(this)->ActorCallback< DataDistributionCommandActorActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DataDistributionCommandActorActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont22(int loopDepth) 
	{
		loopDepth = a_body1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1cont23(Void const& _,int loopDepth) 
	{
															#line 151 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is enabled for rebalance.\n");
															#line 2142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1cont23(Void && _,int loopDepth) 
	{
															#line 151 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is enabled for rebalance.\n");
															#line 2151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1when8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont23(_, loopDepth);

		return loopDepth;
	}
	int a_body1when8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont23(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state > 0) static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<DataDistributionCommandActorActor*>(this)->ActorCallback< DataDistributionCommandActorActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< DataDistributionCommandActorActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont24(int loopDepth) 
	{
		loopDepth = a_body1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1cont25(Void const& _,int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is enabled for rebalance_disk.\n");
															#line 2241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1cont25(Void && _,int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is enabled for rebalance_disk.\n");
															#line 2250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1when9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont25(_, loopDepth);

		return loopDepth;
	}
	int a_body1when9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont25(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state > 0) static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<DataDistributionCommandActorActor*>(this)->ActorCallback< DataDistributionCommandActorActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< DataDistributionCommandActorActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont26(int loopDepth) 
	{
		loopDepth = a_body1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1cont27(Void const& _,int loopDepth) 
	{
															#line 157 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is enabled for rebalance_read.\n");
															#line 2340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont26(loopDepth);

		return loopDepth;
	}
	int a_body1cont27(Void && _,int loopDepth) 
	{
															#line 157 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
		printf("Data distribution is enabled for rebalance_read.\n");
															#line 2349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont26(loopDepth);

		return loopDepth;
	}
	int a_body1when10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont27(_, loopDepth);

		return loopDepth;
	}
	int a_body1when10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont27(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state > 0) static_cast<DataDistributionCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<DataDistributionCommandActorActor*>(this)->ActorCallback< DataDistributionCommandActorActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1when10(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< DataDistributionCommandActorActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< DataDistributionCommandActorActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 117 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	bool result;
															#line 2435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via dataDistributionCommandActor()
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
class DataDistributionCommandActorActor final : public Actor<bool>, public ActorCallback< DataDistributionCommandActorActor, 0, Void >, public ActorCallback< DataDistributionCommandActorActor, 1, Void >, public ActorCallback< DataDistributionCommandActorActor, 2, Void >, public ActorCallback< DataDistributionCommandActorActor, 3, Void >, public ActorCallback< DataDistributionCommandActorActor, 4, Void >, public ActorCallback< DataDistributionCommandActorActor, 5, Void >, public ActorCallback< DataDistributionCommandActorActor, 6, Void >, public ActorCallback< DataDistributionCommandActorActor, 7, Void >, public ActorCallback< DataDistributionCommandActorActor, 8, Void >, public ActorCallback< DataDistributionCommandActorActor, 9, Void >, public FastAllocated<DataDistributionCommandActorActor>, public DataDistributionCommandActorActorState<DataDistributionCommandActorActor> {
															#line 2440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<DataDistributionCommandActorActor>::operator new;
	using FastAllocated<DataDistributionCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9332544345871932928UL, 1167677558012250624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DataDistributionCommandActorActor, 0, Void >;
friend struct ActorCallback< DataDistributionCommandActorActor, 1, Void >;
friend struct ActorCallback< DataDistributionCommandActorActor, 2, Void >;
friend struct ActorCallback< DataDistributionCommandActorActor, 3, Void >;
friend struct ActorCallback< DataDistributionCommandActorActor, 4, Void >;
friend struct ActorCallback< DataDistributionCommandActorActor, 5, Void >;
friend struct ActorCallback< DataDistributionCommandActorActor, 6, Void >;
friend struct ActorCallback< DataDistributionCommandActorActor, 7, Void >;
friend struct ActorCallback< DataDistributionCommandActorActor, 8, Void >;
friend struct ActorCallback< DataDistributionCommandActorActor, 9, Void >;
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	DataDistributionCommandActorActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 2466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   DataDistributionCommandActorActorState<DataDistributionCommandActorActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8536122563241886976UL, 13417161533757783040UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dataDistributionCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dataDistributionCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DataDistributionCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DataDistributionCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DataDistributionCommandActorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DataDistributionCommandActorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DataDistributionCommandActorActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DataDistributionCommandActorActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DataDistributionCommandActorActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< DataDistributionCommandActorActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< DataDistributionCommandActorActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< DataDistributionCommandActorActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
[[nodiscard]] Future<bool> dataDistributionCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"
	return Future<bool>(new DataDistributionCommandActorActor(db, tokens));
															#line 2507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/DataDistributionCommand.actor.g.cpp.py_gen"
}

#line 169 "/Users/ec2-user/foundationdb/fdbcli/DataDistributionCommand.actor.cpp"

// hidden commands, no help text for now
CommandFactory dataDistributionFactory("datadistribution");
} // namespace fdb_cli
