/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.EventKeeper;
import com.apple.foundationdb.FDBTransaction;
import com.apple.foundationdb.FakeFDBTransaction;
import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MapEventKeeper;
import com.apple.foundationdb.RangeQuery;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class EventKeeperTest {
    EventKeeperTest() {
    }

    @Test
    @Disabled(value="Ignored because ctest will actually add the library and cause this to segfault")
    void testSetVersion() throws Exception {
        MapEventKeeper mapEventKeeper = new MapEventKeeper();
        try (FDBTransaction fDBTransaction = new FDBTransaction(1L, null, null, (EventKeeper)mapEventKeeper);){
            Assertions.assertThrows(UnsatisfiedLinkError.class, () -> fDBTransaction.setReadVersion(1L), (String)"Test should call a bad native method");
            long l = mapEventKeeper.getCount((EventKeeper.Event)EventKeeper.Events.JNI_CALL);
            Assertions.assertEquals((long)1L, (long)l, (String)"Unexpected number of JNI calls:");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    @Test
    @Disabled(value="Ignored because ctest will actually add the library and cause this to segfault")
    void testGetReadVersion() throws Exception {
        MapEventKeeper mapEventKeeper = new MapEventKeeper();
        try (FDBTransaction fDBTransaction = new FDBTransaction(1L, null, null, (EventKeeper)mapEventKeeper);){
            Assertions.assertThrows(UnsatisfiedLinkError.class, () -> fDBTransaction.getReadVersion(), (String)"Test should call a bad native method");
            long l = mapEventKeeper.getCount((EventKeeper.Event)EventKeeper.Events.JNI_CALL);
            Assertions.assertEquals((long)1L, (long)l, (String)"Unexpected number of JNI calls:");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    @Test
    void testGetRangeRecordsFetches() throws Exception {
        MapEventKeeper mapEventKeeper = new MapEventKeeper();
        List<KeyValue> list = Arrays.asList(new KeyValue("hello".getBytes(), "goodbye".getBytes()));
        FakeFDBTransaction fakeFDBTransaction = new FakeFDBTransaction(list, 1L, null, null);
        RangeQuery rangeQuery = new RangeQuery((FDBTransaction)fakeFDBTransaction, true, KeySelector.firstGreaterOrEqual((byte[])new byte[]{0}), KeySelector.firstGreaterOrEqual((byte[])new byte[]{-1}), -1, false, StreamingMode.ITERATOR, (EventKeeper)mapEventKeeper);
        RangeQuery.AsyncRangeIterator asyncRangeIterator = rangeQuery.iterator();
        ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>();
        while (asyncRangeIterator.hasNext()) {
            arrayList.add((KeyValue)asyncRangeIterator.next());
        }
        Assertions.assertEquals((int)list.size(), (int)arrayList.size(), (String)"Incorrect iterated list, size incorrect.");
        int n = 0;
        for (KeyValue keyValue : list) {
            byte[] byArray = keyValue.getKey();
            byte[] byArray2 = keyValue.getValue();
            n += byArray.length + 4;
            n += byArray2.length + 4;
            boolean bl = false;
            for (KeyValue keyValue2 : arrayList) {
                byte[] byArray3 = keyValue2.getKey();
                byte[] byArray4 = keyValue2.getValue();
                if (ByteArrayUtil.compareTo((byte[])byArray, (int)0, (int)byArray.length, (byte[])byArray3, (int)0, (int)byArray3.length) != 0) continue;
                int n2 = ByteArrayUtil.compareTo((byte[])byArray2, (int)0, (int)byArray2.length, (byte[])byArray4, (int)0, (int)byArray4.length);
                Assertions.assertEquals((int)0, (int)n2, (String)"Incorrect value returned");
                bl = true;
                break;
            }
            Assertions.assertTrue((boolean)bl, (String)"missing key!");
        }
        Assertions.assertEquals((long)1L, (long)mapEventKeeper.getCount((EventKeeper.Event)EventKeeper.Events.RANGE_QUERY_FETCHES), (String)"Unexpected number of chunk fetches");
        Assertions.assertEquals((long)list.size(), (long)mapEventKeeper.getCount((EventKeeper.Event)EventKeeper.Events.RANGE_QUERY_RECORDS_FETCHED), (String)"Unexpected number of tuples fetched");
        Assertions.assertEquals((long)n, (long)mapEventKeeper.getCount((EventKeeper.Event)EventKeeper.Events.BYTES_FETCHED), (String)"Incorrect number of bytes fetched");
    }
}

