#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
/*
 * MetaclusterUtil.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2023 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/MultiVersionTransaction.h"
#include "fdbclient/ThreadSafeTransaction.h"

#include "metacluster/MetaclusterUtil.actor.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster::util {

std::pair<ClusterUsage, ClusterUsage> metaclusterCapacity(std::map<ClusterName, DataClusterMetadata> const& clusters) {
	ClusterUsage tenantGroupCapacity;
	ClusterUsage tenantGroupsAllocated;
	for (auto cluster : clusters) {
		tenantGroupCapacity.numTenantGroups +=
		    std::max(cluster.second.entry.capacity.numTenantGroups, cluster.second.entry.allocated.numTenantGroups);
		tenantGroupsAllocated.numTenantGroups += cluster.second.entry.allocated.numTenantGroups;
	}
	return { tenantGroupCapacity, tenantGroupsAllocated };
}

															#line 46 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/MetaclusterUtil.actor.g.cpp"
// This generated class is to be used only via openDatabase()
															#line 44 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
template <class OpenDatabaseActor>
															#line 44 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
class OpenDatabaseActorState {
															#line 52 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/MetaclusterUtil.actor.g.cpp"
public:
															#line 44 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	OpenDatabaseActorState(ClusterConnectionString const& connectionString) 
															#line 44 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
															#line 44 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		 : connectionString(connectionString)
															#line 59 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/MetaclusterUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("openDatabase", reinterpret_cast<unsigned long>(this));

	}
	~OpenDatabaseActorState() 
	{
		fdb_probe_actor_destroy("openDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 45 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			if (g_network->isSimulated())
															#line 74 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/MetaclusterUtil.actor.g.cpp"
			{
															#line 46 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
				Reference<IClusterConnectionRecord> clusterFile = makeReference<ClusterConnectionMemoryRecord>(connectionString);
															#line 48 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
				Database nativeDb = Database::createDatabase(clusterFile, ApiVersion::LATEST_VERSION);
															#line 49 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
				StrictFuture<Reference<IDatabase>> __when_expr_0 = unsafeThreadFutureToFuture(ThreadSafeDatabase::createFromExistingDatabase(nativeDb));
															#line 49 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
				if (static_cast<OpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 84 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/MetaclusterUtil.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<OpenDatabaseActor*>(this)->actor_wait_state = 1;
															#line 49 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >*>(static_cast<OpenDatabaseActor*>(this)));
															#line 89 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/MetaclusterUtil.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 54 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
				if (!static_cast<OpenDatabaseActor*>(this)->SAV<Reference<IDatabase>>::futures) { (void)(MultiVersionApi::api->createDatabaseFromConnectionString(connectionString.toString().c_str())); this->~OpenDatabaseActorState(); static_cast<OpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 96 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/MetaclusterUtil.actor.g.cpp"
				new (&static_cast<OpenDatabaseActor*>(this)->SAV< Reference<IDatabase> >::value()) Reference<IDatabase>(MultiVersionApi::api->createDatabaseFromConnectionString(connectionString.toString().c_str()));
				this->~OpenDatabaseActorState();
				static_cast<OpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OpenDatabaseActorState();
		static_cast<OpenDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<IDatabase> const& threadSafeDb,int loopDepth) 
	{
															#line 51 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		MultiVersionApi::api->selectApiVersion(ApiVersion::LATEST_VERSION);
															#line 52 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		if (!static_cast<OpenDatabaseActor*>(this)->SAV<Reference<IDatabase>>::futures) { (void)(MultiVersionDatabase::debugCreateFromExistingDatabase(threadSafeDb)); this->~OpenDatabaseActorState(); static_cast<OpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/MetaclusterUtil.actor.g.cpp"
		new (&static_cast<OpenDatabaseActor*>(this)->SAV< Reference<IDatabase> >::value()) Reference<IDatabase>(MultiVersionDatabase::debugCreateFromExistingDatabase(threadSafeDb));
		this->~OpenDatabaseActorState();
		static_cast<OpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<IDatabase> && threadSafeDb,int loopDepth) 
	{
															#line 51 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		MultiVersionApi::api->selectApiVersion(ApiVersion::LATEST_VERSION);
															#line 52 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		if (!static_cast<OpenDatabaseActor*>(this)->SAV<Reference<IDatabase>>::futures) { (void)(MultiVersionDatabase::debugCreateFromExistingDatabase(threadSafeDb)); this->~OpenDatabaseActorState(); static_cast<OpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/MetaclusterUtil.actor.g.cpp"
		new (&static_cast<OpenDatabaseActor*>(this)->SAV< Reference<IDatabase> >::value()) Reference<IDatabase>(MultiVersionDatabase::debugCreateFromExistingDatabase(threadSafeDb));
		this->~OpenDatabaseActorState();
		static_cast<OpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> const& threadSafeDb,int loopDepth) 
	{
		loopDepth = a_body1cont2(threadSafeDb, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> && threadSafeDb,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(threadSafeDb), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OpenDatabaseActor*>(this)->actor_wait_state > 0) static_cast<OpenDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<OpenDatabaseActor*>(this)->ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 44 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	ClusterConnectionString connectionString;
															#line 212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/MetaclusterUtil.actor.g.cpp"
};
// This generated class is to be used only via openDatabase()
															#line 44 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
class OpenDatabaseActor final : public Actor<Reference<IDatabase>>, public ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >, public FastAllocated<OpenDatabaseActor>, public OpenDatabaseActorState<OpenDatabaseActor> {
															#line 217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/MetaclusterUtil.actor.g.cpp"
public:
	using FastAllocated<OpenDatabaseActor>::operator new;
	using FastAllocated<OpenDatabaseActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Reference<IDatabase>>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >;
															#line 44 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	OpenDatabaseActor(ClusterConnectionString const& connectionString) 
															#line 228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/MetaclusterUtil.actor.g.cpp"
		 : Actor<Reference<IDatabase>>(),
		   OpenDatabaseActorState<OpenDatabaseActor>(connectionString)
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("openDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 44 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
[[nodiscard]] Future<Reference<IDatabase>> openDatabase( ClusterConnectionString const& connectionString ) {
															#line 44 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	return Future<Reference<IDatabase>>(new OpenDatabaseActor(connectionString));
															#line 255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/MetaclusterUtil.actor.g.cpp"
}

#line 57 "/Users/ec2-user/foundationdb/metacluster/MetaclusterUtil.actor.cpp"

}; // namespace metacluster::util