/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.TransactionContext;
import java.util.concurrent.atomic.AtomicInteger;

public class SerialTest {
    public static void main(String[] stringArray) throws InterruptedException {
        try {
            FDB fDB = FDB.selectAPIVersion((int)730);
            try (Database database = fDB.open();){
                SerialTest.runTests(1000, (TransactionContext)database);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void runTests(int n, TransactionContext transactionContext) {
        System.out.println("Running tests...");
        long l = System.currentTimeMillis();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        for (int i = 0; i < n; ++i) {
            try {
                transactionContext.run(transaction -> {
                    byte[] byArray = (byte[])transaction.get("count".getBytes()).join();
                    int n = Integer.parseInt(new String(byArray));
                    transaction.set("count".getBytes(), Integer.toString(n + 1).getBytes());
                    atomicInteger.set(n);
                    return null;
                });
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        System.out.println(" Transactions:    " + n);
        System.out.println(" Total Time:      " + d);
        System.out.println(" Gets+Sets / sec: " + (double)n / d);
        System.out.println(" Count:           " + atomicInteger.get());
        System.exit(0);
    }

    private SerialTest() {
    }
}

