/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.test.ContinuousSample;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class ParallelRandomScan {
    private static final int ROWS = 1000000;
    private static final int DURATION_MS = 2000;
    private static final int PARALLELISM_MIN = 10;
    private static final int PARALLELISM_MAX = 100;
    private static final int PARALLELISM_STEP = 5;

    public static void main(String[] stringArray) throws InterruptedException {
        FDB fDB = FDB.selectAPIVersion((int)730);
        try (Database database = fDB.open(stringArray[0]);){
            for (int i = 10; i <= 100; i += 5) {
                ParallelRandomScan.runTest(database, i, 1000000, 2000);
                Thread.sleep(1000L);
            }
        }
    }

    private static void runTest(Database database, int n, int n2, int n3) throws InterruptedException {
        Random random = new Random();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        AtomicInteger atomicInteger2 = new AtomicInteger(0);
        Semaphore semaphore = new Semaphore(n);
        ContinuousSample continuousSample = new ContinuousSample(1000);
        try (Transaction transaction = database.createTransaction();){
            transaction.options().setReadYourWritesDisable();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            transaction.getReadVersion().join();
            long l = System.currentTimeMillis();
            while (true) {
                semaphore.acquire();
                if (System.currentTimeMillis() - l > (long)n3) break;
                int n4 = random.nextInt(n2 - 1);
                byteBuffer.putInt(0, n4);
                AsyncIterable asyncIterable = transaction.getRange(byteBuffer.array(), ByteArrayUtil.strinc((byte[])byteBuffer.array()), 1, false, StreamingMode.SMALL);
                long l2 = System.nanoTime();
                AsyncIterator asyncIterator = asyncIterable.iterator();
                CompletionStage completionStage = asyncIterator.onHasNext().thenApplyAsync(bl -> {
                    if (!bl.booleanValue()) {
                        return null;
                    }
                    return (KeyValue)asyncIterator.next();
                }, (Executor)FDB.DEFAULT_EXECUTOR);
                ((CompletableFuture)completionStage).whenCompleteAsync((keyValue, throwable) -> {
                    if (keyValue != null) {
                        atomicInteger.incrementAndGet();
                        long l2 = System.nanoTime() - l2;
                        ContinuousSample continuousSample2 = continuousSample;
                        synchronized (continuousSample2) {
                            continuousSample.addSample(l2);
                        }
                    } else if (throwable != null) {
                        atomicInteger2.incrementAndGet();
                    }
                    semaphore.release();
                }, (Executor)FDB.DEFAULT_EXECUTOR);
            }
            semaphore.release();
            semaphore.acquire(n);
            long l3 = System.currentTimeMillis();
            double d = (double)atomicInteger.get() / ((double)(l3 - l) / 1000.0);
            System.out.println(n + " ->\t" + d);
            System.out.println(String.format("  Reads: %d, errors: %d, time: %dms", atomicInteger.get(), atomicInteger2.get(), (int)(l3 - l)));
            System.out.println(String.format("  Mean: %.2f, Median: %d, 98%%: %d", continuousSample.mean(), continuousSample.median(), continuousSample.percentile(0.98)));
        }
    }

    private ParallelRandomScan() {
    }
}

