/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.Transaction;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;

public class BlockingBenchmark {
    private static final int REPS = 100000;
    private static final int PARALLEL = 100;

    public static void main(String[] stringArray) throws InterruptedException {
        FDB fDB = FDB.selectAPIVersion((int)730);
        try (Database database = fDB.open();
             Transaction transaction = database.createTransaction();){
            transaction.setReadVersion(100000L);
            System.out.println("readVersion().join():");
            BlockingBenchmark.runTests(transaction, completableFuture -> {
                try {
                    completableFuture.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            });
            System.out.println("readVersion().get():");
            BlockingBenchmark.runTests(transaction, completableFuture -> {
                try {
                    completableFuture.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            });
            System.out.println("readVersion().thenApplyAsync(identity).get():");
            BlockingBenchmark.runTests(transaction, completableFuture -> {
                try {
                    ((CompletableFuture)completableFuture.thenApplyAsync(Function.identity(), (Executor)FDB.DEFAULT_EXECUTOR)).get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            });
            System.out.println("readVersion().thenApplyAsync^10(identity).get():");
            BlockingBenchmark.runTests(transaction, completionStage -> {
                for (int i = 0; i < 10; ++i) {
                    completionStage = completionStage.thenApplyAsync(Function.identity(), (Executor)FDB.DEFAULT_EXECUTOR);
                }
                try {
                    completionStage.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            });
            System.out.println("readVersion().get^100():");
            BlockingBenchmark.runTests(transaction, completableFuture -> {
                for (int i = 0; i < 100; ++i) {
                    try {
                        completableFuture.get();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            });
        }
    }

    private static void runTests(Transaction transaction, Function<CompletableFuture<Long>, Void> function) {
        for (int i = 0; i < 4; ++i) {
            int n;
            long l = System.currentTimeMillis();
            for (int j = 0; j < 100000; ++j) {
                function.apply(transaction.getReadVersion());
            }
            long l2 = System.currentTimeMillis() - l;
            System.out.println("  100000 done in " + l2 + "ms -> " + (double)l2 * 1000.0 / 100000.0 + " us latency");
            ArrayList<CompletableFuture> arrayList = new ArrayList<CompletableFuture>(100);
            for (n = 0; n < 100; ++n) {
                arrayList.add(null);
            }
            l = System.currentTimeMillis();
            for (n = 0; n < 100000; n += 100) {
                int n2;
                for (n2 = 0; n2 < 100; ++n2) {
                    arrayList.set(n2, transaction.getReadVersion());
                }
                for (n2 = 0; n2 < 100; ++n2) {
                    function.apply((CompletableFuture)arrayList.get(n2));
                }
            }
            l2 = System.currentTimeMillis() - l;
            System.out.println("  100000 done in " + l2 + "ms -> " + 100000L / l2 + " KHz");
        }
    }

    private BlockingBenchmark() {
    }
}

