#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
/*
 * DirectoryLayer.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "DirectoryLayer.h"
#include "DirectoryPartition.h"

namespace FDB {
const uint8_t DirectoryLayer::LITTLE_ENDIAN_LONG_ONE[8] = { 1, 0, 0, 0, 0, 0, 0, 0 };
const StringRef DirectoryLayer::HIGH_CONTENTION_KEY = "hca"_sr;
const StringRef DirectoryLayer::LAYER_KEY = "layer"_sr;
const StringRef DirectoryLayer::VERSION_KEY = "version"_sr;
const int64_t DirectoryLayer::SUB_DIR_KEY = 0;

const uint32_t DirectoryLayer::VERSION[3] = { 1, 0, 0 };

const StringRef DirectoryLayer::DEFAULT_NODE_SUBSPACE_PREFIX = "\xfe"_sr;
const Subspace DirectoryLayer::DEFAULT_NODE_SUBSPACE = Subspace(DEFAULT_NODE_SUBSPACE_PREFIX);
const Subspace DirectoryLayer::DEFAULT_CONTENT_SUBSPACE = Subspace();
const StringRef DirectoryLayer::PARTITION_LAYER = "partition"_sr;

DirectoryLayer::DirectoryLayer(Subspace nodeSubspace, Subspace contentSubspace, bool allowManualPrefixes)
  : rootNode(nodeSubspace.get(nodeSubspace.key())), nodeSubspace(nodeSubspace), contentSubspace(contentSubspace),
    allocator(rootNode.get(HIGH_CONTENTION_KEY)), allowManualPrefixes(allowManualPrefixes) {}

Subspace DirectoryLayer::nodeWithPrefix(StringRef const& prefix) const {
	return nodeSubspace.get(prefix);
}

template <class T>
Optional<Subspace> DirectoryLayer::nodeWithPrefix(Optional<T> const& prefix) const {
	if (!prefix.present()) {
		return Optional<Subspace>();
	}

	return nodeWithPrefix(prefix.get());
}

															#line 57 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
// This generated class is to be used only via find()
															#line 55 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
template <class FindActor>
															#line 55 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class FindActorState {
															#line 63 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
															#line 55 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	FindActorState(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path) 
															#line 55 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
															#line 55 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		 : dirLayer(dirLayer),
															#line 55 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   tr(tr),
															#line 55 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   path(path),
															#line 58 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   pathIndex(0),
															#line 59 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   node(DirectoryLayer::Node(dirLayer, dirLayer->rootNode, IDirectory::Path(), path))
															#line 78 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("find", reinterpret_cast<unsigned long>(this));

	}
	~FindActorState() 
	{
		fdb_probe_actor_destroy("find", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			;
															#line 93 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FindActorState();
		static_cast<FindActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 77 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!node.loadedMetadata)
															#line 116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 78 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<DirectoryLayer::Node> __when_expr_2 = node.loadMetadata(tr);
															#line 78 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<FindActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<FindActor*>(this)->actor_wait_state = 3;
															#line 78 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FindActor, 2, DirectoryLayer::Node >*>(static_cast<FindActor*>(this)));
															#line 127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 61 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!(pathIndex != path.size()))
															#line 148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 62 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		ASSERT(node.subspace.present());
															#line 63 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<Optional<FDBStandalone<ValueRef>>> __when_expr_0 = tr->get(node.subspace.get().get(DirectoryLayer::SUB_DIR_KEY).get(path[pathIndex], true).key());
															#line 63 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<FindActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FindActor*>(this)->actor_wait_state = 1;
															#line 63 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FindActor, 0, Optional<FDBStandalone<ValueRef>> >*>(static_cast<FindActor*>(this)));
															#line 163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<FDBStandalone<ValueRef>> const& val,int loopDepth) 
	{
															#line 66 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		node.path.push_back(path[pathIndex]);
															#line 67 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		node = DirectoryLayer::Node(dirLayer, dirLayer->nodeWithPrefix(val), node.path, path);
															#line 69 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<DirectoryLayer::Node> __when_expr_1 = node.loadMetadata(tr);
															#line 69 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<FindActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FindActor*>(this)->actor_wait_state = 2;
															#line 69 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FindActor, 1, DirectoryLayer::Node >*>(static_cast<FindActor*>(this)));
															#line 196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<FDBStandalone<ValueRef>> && val,int loopDepth) 
	{
															#line 66 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		node.path.push_back(path[pathIndex]);
															#line 67 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		node = DirectoryLayer::Node(dirLayer, dirLayer->nodeWithPrefix(val), node.path, path);
															#line 69 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<DirectoryLayer::Node> __when_expr_1 = node.loadMetadata(tr);
															#line 69 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<FindActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FindActor*>(this)->actor_wait_state = 2;
															#line 69 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FindActor, 1, DirectoryLayer::Node >*>(static_cast<FindActor*>(this)));
															#line 216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<FDBStandalone<ValueRef>> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<FDBStandalone<ValueRef>> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FindActor*>(this)->actor_wait_state > 0) static_cast<FindActor*>(this)->actor_wait_state = 0;
		static_cast<FindActor*>(this)->ActorCallback< FindActor, 0, Optional<FDBStandalone<ValueRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< FindActor, 0, Optional<FDBStandalone<ValueRef>> >*,Optional<FDBStandalone<ValueRef>> const& value) 
	{
		fdb_probe_actor_enter("find", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("find", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FindActor, 0, Optional<FDBStandalone<ValueRef>> >*,Optional<FDBStandalone<ValueRef>> && value) 
	{
		fdb_probe_actor_enter("find", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("find", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FindActor, 0, Optional<FDBStandalone<ValueRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("find", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FindActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("find", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(DirectoryLayer::Node const& _node,int loopDepth) 
	{
															#line 70 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		node = _node;
															#line 72 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!node.exists() || node.layer == DirectoryLayer::PARTITION_LAYER)
															#line 302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 73 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!static_cast<FindActor*>(this)->SAV<DirectoryLayer::Node>::futures) { (void)(node); this->~FindActorState(); static_cast<FindActor*>(this)->destroy(); return 0; }
															#line 306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			new (&static_cast<FindActor*>(this)->SAV< DirectoryLayer::Node >::value()) DirectoryLayer::Node(std::move(node)); // state_var_RVO
			this->~FindActorState();
			static_cast<FindActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 61 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		++pathIndex;
															#line 314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(DirectoryLayer::Node && _node,int loopDepth) 
	{
															#line 70 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		node = _node;
															#line 72 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!node.exists() || node.layer == DirectoryLayer::PARTITION_LAYER)
															#line 325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 73 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!static_cast<FindActor*>(this)->SAV<DirectoryLayer::Node>::futures) { (void)(node); this->~FindActorState(); static_cast<FindActor*>(this)->destroy(); return 0; }
															#line 329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			new (&static_cast<FindActor*>(this)->SAV< DirectoryLayer::Node >::value()) DirectoryLayer::Node(std::move(node)); // state_var_RVO
			this->~FindActorState();
			static_cast<FindActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 61 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		++pathIndex;
															#line 337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(DirectoryLayer::Node const& _node,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_node, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(DirectoryLayer::Node && _node,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_node), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FindActor*>(this)->actor_wait_state > 0) static_cast<FindActor*>(this)->actor_wait_state = 0;
		static_cast<FindActor*>(this)->ActorCallback< FindActor, 1, DirectoryLayer::Node >::remove();

	}
	void a_callback_fire(ActorCallback< FindActor, 1, DirectoryLayer::Node >*,DirectoryLayer::Node const& value) 
	{
		fdb_probe_actor_enter("find", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("find", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FindActor, 1, DirectoryLayer::Node >*,DirectoryLayer::Node && value) 
	{
		fdb_probe_actor_enter("find", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("find", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FindActor, 1, DirectoryLayer::Node >*,Error err) 
	{
		fdb_probe_actor_enter("find", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FindActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("find", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 82 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<FindActor*>(this)->SAV<DirectoryLayer::Node>::futures) { (void)(node); this->~FindActorState(); static_cast<FindActor*>(this)->destroy(); return 0; }
															#line 421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<FindActor*>(this)->SAV< DirectoryLayer::Node >::value()) DirectoryLayer::Node(std::move(node)); // state_var_RVO
		this->~FindActorState();
		static_cast<FindActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(DirectoryLayer::Node const& _node,int loopDepth) 
	{
															#line 79 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		node = _node;
															#line 433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(DirectoryLayer::Node && _node,int loopDepth) 
	{
															#line 79 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		node = _node;
															#line 442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(DirectoryLayer::Node const& _node,int loopDepth) 
	{
		loopDepth = a_body1cont3(_node, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(DirectoryLayer::Node && _node,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_node), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FindActor*>(this)->actor_wait_state > 0) static_cast<FindActor*>(this)->actor_wait_state = 0;
		static_cast<FindActor*>(this)->ActorCallback< FindActor, 2, DirectoryLayer::Node >::remove();

	}
	void a_callback_fire(ActorCallback< FindActor, 2, DirectoryLayer::Node >*,DirectoryLayer::Node const& value) 
	{
		fdb_probe_actor_enter("find", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("find", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FindActor, 2, DirectoryLayer::Node >*,DirectoryLayer::Node && value) 
	{
		fdb_probe_actor_enter("find", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("find", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FindActor, 2, DirectoryLayer::Node >*,Error err) 
	{
		fdb_probe_actor_enter("find", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FindActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("find", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 55 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<DirectoryLayer> dirLayer;
															#line 55 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<Transaction> tr;
															#line 55 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	IDirectory::Path path;
															#line 58 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	int pathIndex;
															#line 59 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	DirectoryLayer::Node node;
															#line 532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via find()
															#line 55 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class FindActor final : public Actor<DirectoryLayer::Node>, public ActorCallback< FindActor, 0, Optional<FDBStandalone<ValueRef>> >, public ActorCallback< FindActor, 1, DirectoryLayer::Node >, public ActorCallback< FindActor, 2, DirectoryLayer::Node >, public FastAllocated<FindActor>, public FindActorState<FindActor> {
															#line 537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
	using FastAllocated<FindActor>::operator new;
	using FastAllocated<FindActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17737096045944639232UL, 2955974673493720320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<DirectoryLayer::Node>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FindActor, 0, Optional<FDBStandalone<ValueRef>> >;
friend struct ActorCallback< FindActor, 1, DirectoryLayer::Node >;
friend struct ActorCallback< FindActor, 2, DirectoryLayer::Node >;
															#line 55 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	FindActor(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path) 
															#line 556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		 : Actor<DirectoryLayer::Node>(),
		   FindActorState<FindActor>(dirLayer, tr, path),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("find", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11199712412897200384UL, 11465448914590933248UL);
		ActorExecutionContextHelper __helper(static_cast<FindActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("find");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("find", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FindActor, 0, Optional<FDBStandalone<ValueRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FindActor, 1, DirectoryLayer::Node >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FindActor, 2, DirectoryLayer::Node >*)0, actor_cancelled()); break;
		}

	}
};
															#line 55 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
[[nodiscard]] Future<DirectoryLayer::Node> find( Reference<DirectoryLayer> const& dirLayer, Reference<Transaction> const& tr, IDirectory::Path const& path ) {
															#line 55 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	return Future<DirectoryLayer::Node>(new FindActor(dirLayer, tr, path));
															#line 590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
}

#line 84 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"

IDirectory::Path DirectoryLayer::toAbsolutePath(IDirectory::Path const& subpath) const {
	Path path;

	path.reserve(this->path.size() + subpath.size());
	path.insert(path.end(), this->path.begin(), this->path.end());
	path.insert(path.end(), subpath.begin(), subpath.end());

	return path;
}

Reference<DirectorySubspace> DirectoryLayer::contentsOfNode(Subspace const& node,
                                                            Path const& path,
                                                            Standalone<StringRef> const& layer) {
	Standalone<StringRef> prefix = nodeSubspace.unpack(node.key()).getString(0);

	if (layer == PARTITION_LAYER) {
		return Reference<DirectorySubspace>(
		    new DirectoryPartition(toAbsolutePath(path), prefix, Reference<DirectoryLayer>::addRef(this)));
	} else {
		return Reference<DirectorySubspace>(
		    new DirectorySubspace(toAbsolutePath(path), prefix, Reference<DirectoryLayer>::addRef(this), layer));
	}
}

Reference<DirectorySubspace> DirectoryLayer::openInternal(Standalone<StringRef> const& layer,
                                                          Node const& existingNode,
                                                          bool allowOpen) {
	if (!allowOpen) {
		throw directory_already_exists();
	}
	if (layer.size() > 0 && layer != existingNode.layer) {
		throw mismatched_layer();
	}

	return existingNode.getContents();
}

Future<Reference<DirectorySubspace>> DirectoryLayer::open(Reference<Transaction> const& tr,
                                                          Path const& path,
                                                          Standalone<StringRef> const& layer) {
	return createOrOpenInternal(tr, path, layer, Optional<Standalone<StringRef>>(), false, true);
}

void DirectoryLayer::initializeDirectory(Reference<Transaction> const& tr) const {
	tr->set(rootNode.pack(VERSION_KEY), StringRef((uint8_t*)VERSION, 12));
}

															#line 642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
// This generated class is to be used only via checkVersionInternal()
															#line 132 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
template <class CheckVersionInternalActor>
															#line 132 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class CheckVersionInternalActorState {
															#line 648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
															#line 132 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	CheckVersionInternalActorState(const DirectoryLayer* const& dirLayer,Reference<Transaction> const& tr,bool const& writeAccess) 
															#line 132 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
															#line 132 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		 : dirLayer(dirLayer),
															#line 132 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   tr(tr),
															#line 132 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   writeAccess(writeAccess)
															#line 659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkVersionInternal", reinterpret_cast<unsigned long>(this));

	}
	~CheckVersionInternalActorState() 
	{
		fdb_probe_actor_destroy("checkVersionInternal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 133 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<Optional<FDBStandalone<ValueRef>>> __when_expr_0 = tr->get(dirLayer->rootNode.pack(DirectoryLayer::VERSION_KEY));
															#line 133 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<CheckVersionInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckVersionInternalActor*>(this)->actor_wait_state = 1;
															#line 133 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckVersionInternalActor, 0, Optional<FDBStandalone<ValueRef>> >*>(static_cast<CheckVersionInternalActor*>(this)));
															#line 681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckVersionInternalActorState();
		static_cast<CheckVersionInternalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<FDBStandalone<ValueRef>> const& versionBytes,int loopDepth) 
	{
															#line 136 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!versionBytes.present())
															#line 704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 137 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (writeAccess)
															#line 708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 138 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				dirLayer->initializeDirectory(tr);
															#line 712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
															#line 140 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!static_cast<CheckVersionInternalActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckVersionInternalActorState(); static_cast<CheckVersionInternalActor*>(this)->destroy(); return 0; }
															#line 716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			new (&static_cast<CheckVersionInternalActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckVersionInternalActorState();
			static_cast<CheckVersionInternalActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 142 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (versionBytes.get().size() != 12)
															#line 726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 143 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				return a_body1Catch1(invalid_directory_layer_metadata(), loopDepth);
															#line 730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
															#line 145 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (((uint32_t*)versionBytes.get().begin())[0] > DirectoryLayer::VERSION[0])
															#line 734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 146 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				return a_body1Catch1(incompatible_directory_version(), loopDepth);
															#line 738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 147 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				if (((uint32_t*)versionBytes.get().begin())[1] > DirectoryLayer::VERSION[1] && writeAccess)
															#line 744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				{
															#line 148 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
					return a_body1Catch1(incompatible_directory_version(), loopDepth);
															#line 748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				}
			}
		}
															#line 152 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<CheckVersionInternalActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckVersionInternalActorState(); static_cast<CheckVersionInternalActor*>(this)->destroy(); return 0; }
															#line 754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<CheckVersionInternalActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckVersionInternalActorState();
		static_cast<CheckVersionInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<FDBStandalone<ValueRef>> && versionBytes,int loopDepth) 
	{
															#line 136 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!versionBytes.present())
															#line 766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 137 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (writeAccess)
															#line 770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 138 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				dirLayer->initializeDirectory(tr);
															#line 774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
															#line 140 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!static_cast<CheckVersionInternalActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckVersionInternalActorState(); static_cast<CheckVersionInternalActor*>(this)->destroy(); return 0; }
															#line 778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			new (&static_cast<CheckVersionInternalActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckVersionInternalActorState();
			static_cast<CheckVersionInternalActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 142 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (versionBytes.get().size() != 12)
															#line 788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 143 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				return a_body1Catch1(invalid_directory_layer_metadata(), loopDepth);
															#line 792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
															#line 145 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (((uint32_t*)versionBytes.get().begin())[0] > DirectoryLayer::VERSION[0])
															#line 796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 146 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				return a_body1Catch1(incompatible_directory_version(), loopDepth);
															#line 800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 147 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				if (((uint32_t*)versionBytes.get().begin())[1] > DirectoryLayer::VERSION[1] && writeAccess)
															#line 806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				{
															#line 148 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
					return a_body1Catch1(incompatible_directory_version(), loopDepth);
															#line 810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				}
			}
		}
															#line 152 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<CheckVersionInternalActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckVersionInternalActorState(); static_cast<CheckVersionInternalActor*>(this)->destroy(); return 0; }
															#line 816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<CheckVersionInternalActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckVersionInternalActorState();
		static_cast<CheckVersionInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<FDBStandalone<ValueRef>> const& versionBytes,int loopDepth) 
	{
		loopDepth = a_body1cont1(versionBytes, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<FDBStandalone<ValueRef>> && versionBytes,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(versionBytes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckVersionInternalActor*>(this)->actor_wait_state > 0) static_cast<CheckVersionInternalActor*>(this)->actor_wait_state = 0;
		static_cast<CheckVersionInternalActor*>(this)->ActorCallback< CheckVersionInternalActor, 0, Optional<FDBStandalone<ValueRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckVersionInternalActor, 0, Optional<FDBStandalone<ValueRef>> >*,Optional<FDBStandalone<ValueRef>> const& value) 
	{
		fdb_probe_actor_enter("checkVersionInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckVersionInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkVersionInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckVersionInternalActor, 0, Optional<FDBStandalone<ValueRef>> >*,Optional<FDBStandalone<ValueRef>> && value) 
	{
		fdb_probe_actor_enter("checkVersionInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckVersionInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkVersionInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckVersionInternalActor, 0, Optional<FDBStandalone<ValueRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkVersionInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckVersionInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkVersionInternal", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 132 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	const DirectoryLayer* dirLayer;
															#line 132 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<Transaction> tr;
															#line 132 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	bool writeAccess;
															#line 905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkVersionInternal()
															#line 132 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class CheckVersionInternalActor final : public Actor<Void>, public ActorCallback< CheckVersionInternalActor, 0, Optional<FDBStandalone<ValueRef>> >, public FastAllocated<CheckVersionInternalActor>, public CheckVersionInternalActorState<CheckVersionInternalActor> {
															#line 910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckVersionInternalActor>::operator new;
	using FastAllocated<CheckVersionInternalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9582130496336822784UL, 6654699001726808832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckVersionInternalActor, 0, Optional<FDBStandalone<ValueRef>> >;
															#line 132 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	CheckVersionInternalActor(const DirectoryLayer* const& dirLayer,Reference<Transaction> const& tr,bool const& writeAccess) 
															#line 927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckVersionInternalActorState<CheckVersionInternalActor>(dirLayer, tr, writeAccess),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkVersionInternal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17369331621163951104UL, 1964655294195592960UL);
		ActorExecutionContextHelper __helper(static_cast<CheckVersionInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkVersionInternal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkVersionInternal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckVersionInternalActor, 0, Optional<FDBStandalone<ValueRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 132 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
[[nodiscard]] Future<Void> checkVersionInternal( const DirectoryLayer* const& dirLayer, Reference<Transaction> const& tr, bool const& writeAccess ) {
															#line 132 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	return Future<Void>(new CheckVersionInternalActor(dirLayer, tr, writeAccess));
															#line 959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
}

#line 154 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"

Future<Void> DirectoryLayer::checkVersion(Reference<Transaction> const& tr, bool writeAccess) const {
	return checkVersionInternal(this, tr, writeAccess);
}

															#line 968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
// This generated class is to be used only via getPrefix()
															#line 159 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
template <class GetPrefixActor>
															#line 159 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class GetPrefixActorState {
															#line 974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
															#line 159 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	GetPrefixActorState(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,Optional<Standalone<StringRef>> const& prefix) 
															#line 159 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
															#line 159 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		 : dirLayer(dirLayer),
															#line 159 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   tr(tr),
															#line 159 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   prefix(prefix)
															#line 985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getPrefix", reinterpret_cast<unsigned long>(this));

	}
	~GetPrefixActorState() 
	{
		fdb_probe_actor_destroy("getPrefix", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 162 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!prefix.present())
															#line 1000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 163 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				StrictFuture<Standalone<StringRef>> __when_expr_0 = dirLayer->allocator.allocate(tr);
															#line 163 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				if (static_cast<GetPrefixActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetPrefixActor*>(this)->actor_wait_state = 1;
															#line 163 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetPrefixActor, 0, Standalone<StringRef> >*>(static_cast<GetPrefixActor*>(this)));
															#line 1011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetPrefixActorState();
		static_cast<GetPrefixActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 175 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<GetPrefixActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(prefix.get()); this->~GetPrefixActorState(); static_cast<GetPrefixActor*>(this)->destroy(); return 0; }
															#line 1039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<GetPrefixActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(prefix.get());
		this->~GetPrefixActorState();
		static_cast<GetPrefixActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Standalone<StringRef> const& allocated,int loopDepth) 
	{
															#line 164 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		finalPrefix = allocated.withPrefix(dirLayer->contentSubspace.key());
															#line 166 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_1 = tr->getRange(KeyRangeRef(finalPrefix, strinc(finalPrefix)), 1);
															#line 166 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<GetPrefixActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetPrefixActor*>(this)->actor_wait_state = 2;
															#line 166 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetPrefixActor, 1, FDBStandalone<RangeResultRef> >*>(static_cast<GetPrefixActor*>(this)));
															#line 1060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Standalone<StringRef> && allocated,int loopDepth) 
	{
															#line 164 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		finalPrefix = allocated.withPrefix(dirLayer->contentSubspace.key());
															#line 166 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_1 = tr->getRange(KeyRangeRef(finalPrefix, strinc(finalPrefix)), 1);
															#line 166 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<GetPrefixActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetPrefixActor*>(this)->actor_wait_state = 2;
															#line 166 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetPrefixActor, 1, FDBStandalone<RangeResultRef> >*>(static_cast<GetPrefixActor*>(this)));
															#line 1078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& allocated,int loopDepth) 
	{
		loopDepth = a_body1cont2(allocated, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && allocated,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(allocated), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetPrefixActor*>(this)->actor_wait_state > 0) static_cast<GetPrefixActor*>(this)->actor_wait_state = 0;
		static_cast<GetPrefixActor*>(this)->ActorCallback< GetPrefixActor, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< GetPrefixActor, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("getPrefix", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPrefix", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetPrefixActor, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("getPrefix", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPrefix", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetPrefixActor, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("getPrefix", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetPrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPrefix", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(FDBStandalone<RangeResultRef> const& result,int loopDepth) 
	{
															#line 168 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (result.size() > 0)
															#line 1162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 169 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			return a_body1Catch1(directory_prefix_not_empty(), loopDepth);
															#line 1166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 172 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<GetPrefixActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(finalPrefix); this->~GetPrefixActorState(); static_cast<GetPrefixActor*>(this)->destroy(); return 0; }
															#line 1170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<GetPrefixActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(std::move(finalPrefix)); // state_var_RVO
		this->~GetPrefixActorState();
		static_cast<GetPrefixActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(FDBStandalone<RangeResultRef> && result,int loopDepth) 
	{
															#line 168 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (result.size() > 0)
															#line 1182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 169 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			return a_body1Catch1(directory_prefix_not_empty(), loopDepth);
															#line 1186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 172 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<GetPrefixActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(finalPrefix); this->~GetPrefixActorState(); static_cast<GetPrefixActor*>(this)->destroy(); return 0; }
															#line 1190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<GetPrefixActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(std::move(finalPrefix)); // state_var_RVO
		this->~GetPrefixActorState();
		static_cast<GetPrefixActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(FDBStandalone<RangeResultRef> const& result,int loopDepth) 
	{
		loopDepth = a_body1cont3(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(FDBStandalone<RangeResultRef> && result,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetPrefixActor*>(this)->actor_wait_state > 0) static_cast<GetPrefixActor*>(this)->actor_wait_state = 0;
		static_cast<GetPrefixActor*>(this)->ActorCallback< GetPrefixActor, 1, FDBStandalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< GetPrefixActor, 1, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("getPrefix", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPrefix", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetPrefixActor, 1, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("getPrefix", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPrefix", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetPrefixActor, 1, FDBStandalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("getPrefix", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetPrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPrefix", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 159 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<DirectoryLayer> dirLayer;
															#line 159 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<Transaction> tr;
															#line 159 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Optional<Standalone<StringRef>> prefix;
															#line 164 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Standalone<StringRef> finalPrefix;
															#line 1281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getPrefix()
															#line 159 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class GetPrefixActor final : public Actor<Standalone<StringRef>>, public ActorCallback< GetPrefixActor, 0, Standalone<StringRef> >, public ActorCallback< GetPrefixActor, 1, FDBStandalone<RangeResultRef> >, public FastAllocated<GetPrefixActor>, public GetPrefixActorState<GetPrefixActor> {
															#line 1286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetPrefixActor>::operator new;
	using FastAllocated<GetPrefixActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8122326452268244736UL, 15485302654270949376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetPrefixActor, 0, Standalone<StringRef> >;
friend struct ActorCallback< GetPrefixActor, 1, FDBStandalone<RangeResultRef> >;
															#line 159 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	GetPrefixActor(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,Optional<Standalone<StringRef>> const& prefix) 
															#line 1304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		 : Actor<Standalone<StringRef>>(),
		   GetPrefixActorState<GetPrefixActor>(dirLayer, tr, prefix),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getPrefix", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(176528568015735552UL, 15422948981513402368UL);
		ActorExecutionContextHelper __helper(static_cast<GetPrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getPrefix");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getPrefix", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetPrefixActor, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetPrefixActor, 1, FDBStandalone<RangeResultRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 159 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
[[nodiscard]] Future<Standalone<StringRef>> getPrefix( Reference<DirectoryLayer> const& dirLayer, Reference<Transaction> const& tr, Optional<Standalone<StringRef>> const& prefix ) {
															#line 159 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	return Future<Standalone<StringRef>>(new GetPrefixActor(dirLayer, tr, prefix));
															#line 1337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
}

#line 177 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"

															#line 1342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
// This generated class is to be used only via nodeContainingKey()
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
template <class NodeContainingKeyActor>
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class NodeContainingKeyActorState {
															#line 1348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	NodeContainingKeyActorState(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,Standalone<StringRef> const& key,bool const& snapshot) 
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		 : dirLayer(dirLayer),
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   tr(tr),
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   key(key),
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   snapshot(snapshot)
															#line 1361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("nodeContainingKey", reinterpret_cast<unsigned long>(this));

	}
	~NodeContainingKeyActorState() 
	{
		fdb_probe_actor_destroy("nodeContainingKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 182 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (key.startsWith(dirLayer->nodeSubspace.key()))
															#line 1376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 183 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				if (!static_cast<NodeContainingKeyActor*>(this)->SAV<Optional<Subspace>>::futures) { (void)(dirLayer->rootNode); this->~NodeContainingKeyActorState(); static_cast<NodeContainingKeyActor*>(this)->destroy(); return 0; }
															#line 1380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				new (&static_cast<NodeContainingKeyActor*>(this)->SAV< Optional<Subspace> >::value()) Optional<Subspace>(dirLayer->rootNode);
				this->~NodeContainingKeyActorState();
				static_cast<NodeContainingKeyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 186 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			KeyRange range = KeyRangeRef(dirLayer->nodeSubspace.range().begin, keyAfter(dirLayer->nodeSubspace.pack(key)));
															#line 187 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_0 = tr->getRange(range, 1, snapshot, true);
															#line 187 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<NodeContainingKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<NodeContainingKeyActor*>(this)->actor_wait_state = 1;
															#line 187 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NodeContainingKeyActor, 0, FDBStandalone<RangeResultRef> >*>(static_cast<NodeContainingKeyActor*>(this)));
															#line 1397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NodeContainingKeyActorState();
		static_cast<NodeContainingKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(FDBStandalone<RangeResultRef> const& result,int loopDepth) 
	{
															#line 189 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (result.size() > 0)
															#line 1420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 190 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			Standalone<StringRef> prevPrefix = dirLayer->nodeSubspace.unpack(result[0].key).getString(0);
															#line 191 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (key.startsWith(prevPrefix))
															#line 1426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 192 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				if (!static_cast<NodeContainingKeyActor*>(this)->SAV<Optional<Subspace>>::futures) { (void)(dirLayer->nodeWithPrefix(prevPrefix)); this->~NodeContainingKeyActorState(); static_cast<NodeContainingKeyActor*>(this)->destroy(); return 0; }
															#line 1430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				new (&static_cast<NodeContainingKeyActor*>(this)->SAV< Optional<Subspace> >::value()) Optional<Subspace>(dirLayer->nodeWithPrefix(prevPrefix));
				this->~NodeContainingKeyActorState();
				static_cast<NodeContainingKeyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 196 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<NodeContainingKeyActor*>(this)->SAV<Optional<Subspace>>::futures) { (void)(Optional<Subspace>()); this->~NodeContainingKeyActorState(); static_cast<NodeContainingKeyActor*>(this)->destroy(); return 0; }
															#line 1439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<NodeContainingKeyActor*>(this)->SAV< Optional<Subspace> >::value()) Optional<Subspace>(Optional<Subspace>());
		this->~NodeContainingKeyActorState();
		static_cast<NodeContainingKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(FDBStandalone<RangeResultRef> && result,int loopDepth) 
	{
															#line 189 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (result.size() > 0)
															#line 1451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 190 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			Standalone<StringRef> prevPrefix = dirLayer->nodeSubspace.unpack(result[0].key).getString(0);
															#line 191 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (key.startsWith(prevPrefix))
															#line 1457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 192 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				if (!static_cast<NodeContainingKeyActor*>(this)->SAV<Optional<Subspace>>::futures) { (void)(dirLayer->nodeWithPrefix(prevPrefix)); this->~NodeContainingKeyActorState(); static_cast<NodeContainingKeyActor*>(this)->destroy(); return 0; }
															#line 1461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				new (&static_cast<NodeContainingKeyActor*>(this)->SAV< Optional<Subspace> >::value()) Optional<Subspace>(dirLayer->nodeWithPrefix(prevPrefix));
				this->~NodeContainingKeyActorState();
				static_cast<NodeContainingKeyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 196 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<NodeContainingKeyActor*>(this)->SAV<Optional<Subspace>>::futures) { (void)(Optional<Subspace>()); this->~NodeContainingKeyActorState(); static_cast<NodeContainingKeyActor*>(this)->destroy(); return 0; }
															#line 1470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<NodeContainingKeyActor*>(this)->SAV< Optional<Subspace> >::value()) Optional<Subspace>(Optional<Subspace>());
		this->~NodeContainingKeyActorState();
		static_cast<NodeContainingKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(FDBStandalone<RangeResultRef> const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(FDBStandalone<RangeResultRef> && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NodeContainingKeyActor*>(this)->actor_wait_state > 0) static_cast<NodeContainingKeyActor*>(this)->actor_wait_state = 0;
		static_cast<NodeContainingKeyActor*>(this)->ActorCallback< NodeContainingKeyActor, 0, FDBStandalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< NodeContainingKeyActor, 0, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("nodeContainingKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NodeContainingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("nodeContainingKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NodeContainingKeyActor, 0, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("nodeContainingKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NodeContainingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("nodeContainingKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NodeContainingKeyActor, 0, FDBStandalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("nodeContainingKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NodeContainingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("nodeContainingKey", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<DirectoryLayer> dirLayer;
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<Transaction> tr;
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Standalone<StringRef> key;
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	bool snapshot;
															#line 1561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via nodeContainingKey()
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class NodeContainingKeyActor final : public Actor<Optional<Subspace>>, public ActorCallback< NodeContainingKeyActor, 0, FDBStandalone<RangeResultRef> >, public FastAllocated<NodeContainingKeyActor>, public NodeContainingKeyActorState<NodeContainingKeyActor> {
															#line 1566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
	using FastAllocated<NodeContainingKeyActor>::operator new;
	using FastAllocated<NodeContainingKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8074492981211824896UL, 15432059570204250880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Subspace>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NodeContainingKeyActor, 0, FDBStandalone<RangeResultRef> >;
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	NodeContainingKeyActor(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,Standalone<StringRef> const& key,bool const& snapshot) 
															#line 1583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		 : Actor<Optional<Subspace>>(),
		   NodeContainingKeyActorState<NodeContainingKeyActor>(dirLayer, tr, key, snapshot),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("nodeContainingKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3115727684074368768UL, 12158243033328833792UL);
		ActorExecutionContextHelper __helper(static_cast<NodeContainingKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("nodeContainingKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("nodeContainingKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NodeContainingKeyActor, 0, FDBStandalone<RangeResultRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
[[nodiscard]] Future<Optional<Subspace>> nodeContainingKey( Reference<DirectoryLayer> const& dirLayer, Reference<Transaction> const& tr, Standalone<StringRef> const& key, bool const& snapshot ) {
															#line 178 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	return Future<Optional<Subspace>>(new NodeContainingKeyActor(dirLayer, tr, key, snapshot));
															#line 1615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
}

#line 198 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"

															#line 1620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
// This generated class is to be used only via isPrefixFree()
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
template <class IsPrefixFreeActor>
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class IsPrefixFreeActorState {
															#line 1626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	IsPrefixFreeActorState(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,Standalone<StringRef> const& prefix,bool const& snapshot) 
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		 : dirLayer(dirLayer),
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   tr(tr),
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   prefix(prefix),
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   snapshot(snapshot)
															#line 1639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("isPrefixFree", reinterpret_cast<unsigned long>(this));

	}
	~IsPrefixFreeActorState() 
	{
		fdb_probe_actor_destroy("isPrefixFree", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 203 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!prefix.size())
															#line 1654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 204 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				if (!static_cast<IsPrefixFreeActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsPrefixFreeActorState(); static_cast<IsPrefixFreeActor*>(this)->destroy(); return 0; }
															#line 1658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				new (&static_cast<IsPrefixFreeActor*>(this)->SAV< bool >::value()) bool(false);
				this->~IsPrefixFreeActorState();
				static_cast<IsPrefixFreeActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 207 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<Optional<Subspace>> __when_expr_0 = nodeContainingKey(dirLayer, tr, prefix, snapshot);
															#line 207 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<IsPrefixFreeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IsPrefixFreeActor*>(this)->actor_wait_state = 1;
															#line 207 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IsPrefixFreeActor, 0, Optional<Subspace> >*>(static_cast<IsPrefixFreeActor*>(this)));
															#line 1673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IsPrefixFreeActorState();
		static_cast<IsPrefixFreeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Subspace> const& node,int loopDepth) 
	{
															#line 208 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (node.present())
															#line 1696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 209 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!static_cast<IsPrefixFreeActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsPrefixFreeActorState(); static_cast<IsPrefixFreeActor*>(this)->destroy(); return 0; }
															#line 1700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			new (&static_cast<IsPrefixFreeActor*>(this)->SAV< bool >::value()) bool(false);
			this->~IsPrefixFreeActorState();
			static_cast<IsPrefixFreeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 212 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_1 = tr->getRange( KeyRangeRef(dirLayer->nodeSubspace.pack(prefix), dirLayer->nodeSubspace.pack(strinc(prefix))), 1, snapshot);
															#line 212 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<IsPrefixFreeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<IsPrefixFreeActor*>(this)->actor_wait_state = 2;
															#line 212 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IsPrefixFreeActor, 1, FDBStandalone<RangeResultRef> >*>(static_cast<IsPrefixFreeActor*>(this)));
															#line 1715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Subspace> && node,int loopDepth) 
	{
															#line 208 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (node.present())
															#line 1724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 209 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!static_cast<IsPrefixFreeActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsPrefixFreeActorState(); static_cast<IsPrefixFreeActor*>(this)->destroy(); return 0; }
															#line 1728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			new (&static_cast<IsPrefixFreeActor*>(this)->SAV< bool >::value()) bool(false);
			this->~IsPrefixFreeActorState();
			static_cast<IsPrefixFreeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 212 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_1 = tr->getRange( KeyRangeRef(dirLayer->nodeSubspace.pack(prefix), dirLayer->nodeSubspace.pack(strinc(prefix))), 1, snapshot);
															#line 212 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<IsPrefixFreeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<IsPrefixFreeActor*>(this)->actor_wait_state = 2;
															#line 212 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IsPrefixFreeActor, 1, FDBStandalone<RangeResultRef> >*>(static_cast<IsPrefixFreeActor*>(this)));
															#line 1743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Subspace> const& node,int loopDepth) 
	{
		loopDepth = a_body1cont1(node, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Subspace> && node,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(node), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IsPrefixFreeActor*>(this)->actor_wait_state > 0) static_cast<IsPrefixFreeActor*>(this)->actor_wait_state = 0;
		static_cast<IsPrefixFreeActor*>(this)->ActorCallback< IsPrefixFreeActor, 0, Optional<Subspace> >::remove();

	}
	void a_callback_fire(ActorCallback< IsPrefixFreeActor, 0, Optional<Subspace> >*,Optional<Subspace> const& value) 
	{
		fdb_probe_actor_enter("isPrefixFree", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsPrefixFreeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isPrefixFree", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IsPrefixFreeActor, 0, Optional<Subspace> >*,Optional<Subspace> && value) 
	{
		fdb_probe_actor_enter("isPrefixFree", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsPrefixFreeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isPrefixFree", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IsPrefixFreeActor, 0, Optional<Subspace> >*,Error err) 
	{
		fdb_probe_actor_enter("isPrefixFree", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsPrefixFreeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isPrefixFree", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(FDBStandalone<RangeResultRef> const& result,int loopDepth) 
	{
															#line 214 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<IsPrefixFreeActor*>(this)->SAV<bool>::futures) { (void)(!result.size()); this->~IsPrefixFreeActorState(); static_cast<IsPrefixFreeActor*>(this)->destroy(); return 0; }
															#line 1827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<IsPrefixFreeActor*>(this)->SAV< bool >::value()) bool(!result.size());
		this->~IsPrefixFreeActorState();
		static_cast<IsPrefixFreeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(FDBStandalone<RangeResultRef> && result,int loopDepth) 
	{
															#line 214 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<IsPrefixFreeActor*>(this)->SAV<bool>::futures) { (void)(!result.size()); this->~IsPrefixFreeActorState(); static_cast<IsPrefixFreeActor*>(this)->destroy(); return 0; }
															#line 1839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<IsPrefixFreeActor*>(this)->SAV< bool >::value()) bool(!result.size());
		this->~IsPrefixFreeActorState();
		static_cast<IsPrefixFreeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(FDBStandalone<RangeResultRef> const& result,int loopDepth) 
	{
		loopDepth = a_body1cont3(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(FDBStandalone<RangeResultRef> && result,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IsPrefixFreeActor*>(this)->actor_wait_state > 0) static_cast<IsPrefixFreeActor*>(this)->actor_wait_state = 0;
		static_cast<IsPrefixFreeActor*>(this)->ActorCallback< IsPrefixFreeActor, 1, FDBStandalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< IsPrefixFreeActor, 1, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("isPrefixFree", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsPrefixFreeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isPrefixFree", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IsPrefixFreeActor, 1, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("isPrefixFree", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsPrefixFreeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isPrefixFree", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IsPrefixFreeActor, 1, FDBStandalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("isPrefixFree", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsPrefixFreeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isPrefixFree", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<DirectoryLayer> dirLayer;
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<Transaction> tr;
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Standalone<StringRef> prefix;
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	bool snapshot;
															#line 1930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via isPrefixFree()
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class IsPrefixFreeActor final : public Actor<bool>, public ActorCallback< IsPrefixFreeActor, 0, Optional<Subspace> >, public ActorCallback< IsPrefixFreeActor, 1, FDBStandalone<RangeResultRef> >, public FastAllocated<IsPrefixFreeActor>, public IsPrefixFreeActorState<IsPrefixFreeActor> {
															#line 1935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
	using FastAllocated<IsPrefixFreeActor>::operator new;
	using FastAllocated<IsPrefixFreeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12152184754067410432UL, 1698525908133384192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IsPrefixFreeActor, 0, Optional<Subspace> >;
friend struct ActorCallback< IsPrefixFreeActor, 1, FDBStandalone<RangeResultRef> >;
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	IsPrefixFreeActor(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,Standalone<StringRef> const& prefix,bool const& snapshot) 
															#line 1953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   IsPrefixFreeActorState<IsPrefixFreeActor>(dirLayer, tr, prefix, snapshot),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("isPrefixFree", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8654416811802607104UL, 15610839224903044352UL);
		ActorExecutionContextHelper __helper(static_cast<IsPrefixFreeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("isPrefixFree");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("isPrefixFree", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IsPrefixFreeActor, 0, Optional<Subspace> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IsPrefixFreeActor, 1, FDBStandalone<RangeResultRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
[[nodiscard]] Future<bool> isPrefixFree( Reference<DirectoryLayer> const& dirLayer, Reference<Transaction> const& tr, Standalone<StringRef> const& prefix, bool const& snapshot ) {
															#line 199 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	return Future<bool>(new IsPrefixFreeActor(dirLayer, tr, prefix, snapshot));
															#line 1986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
}

#line 216 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"

															#line 1991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
// This generated class is to be used only via getParentNode()
															#line 217 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
template <class GetParentNodeActor>
															#line 217 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class GetParentNodeActorState {
															#line 1997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
															#line 217 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	GetParentNodeActorState(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path) 
															#line 217 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
															#line 217 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		 : dirLayer(dirLayer),
															#line 217 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   tr(tr),
															#line 217 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   path(path)
															#line 2008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getParentNode", reinterpret_cast<unsigned long>(this));

	}
	~GetParentNodeActorState() 
	{
		fdb_probe_actor_destroy("getParentNode", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 220 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (path.size() > 1)
															#line 2023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 221 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				StrictFuture<Reference<DirectorySubspace>> __when_expr_0 = dirLayer->createOrOpenInternal(tr, IDirectory::Path(path.begin(), path.end() - 1), StringRef(), Optional<Standalone<StringRef>>(), true, true);
															#line 221 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				if (static_cast<GetParentNodeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2029 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetParentNodeActor*>(this)->actor_wait_state = 1;
															#line 221 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetParentNodeActor, 0, Reference<DirectorySubspace> >*>(static_cast<GetParentNodeActor*>(this)));
															#line 2034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 230 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				if (!static_cast<GetParentNodeActor*>(this)->SAV<Subspace>::futures) { (void)(dirLayer->rootNode); this->~GetParentNodeActorState(); static_cast<GetParentNodeActor*>(this)->destroy(); return 0; }
															#line 2041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				new (&static_cast<GetParentNodeActor*>(this)->SAV< Subspace >::value()) Subspace(dirLayer->rootNode);
				this->~GetParentNodeActorState();
				static_cast<GetParentNodeActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetParentNodeActorState();
		static_cast<GetParentNodeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<DirectorySubspace> const& parent,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<GetParentNodeActor*>(this)->SAV<Subspace>::futures) { (void)(dirLayer->nodeWithPrefix(parent->key())); this->~GetParentNodeActorState(); static_cast<GetParentNodeActor*>(this)->destroy(); return 0; }
															#line 2068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<GetParentNodeActor*>(this)->SAV< Subspace >::value()) Subspace(dirLayer->nodeWithPrefix(parent->key()));
		this->~GetParentNodeActorState();
		static_cast<GetParentNodeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<DirectorySubspace> && parent,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<GetParentNodeActor*>(this)->SAV<Subspace>::futures) { (void)(dirLayer->nodeWithPrefix(parent->key())); this->~GetParentNodeActorState(); static_cast<GetParentNodeActor*>(this)->destroy(); return 0; }
															#line 2080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<GetParentNodeActor*>(this)->SAV< Subspace >::value()) Subspace(dirLayer->nodeWithPrefix(parent->key()));
		this->~GetParentNodeActorState();
		static_cast<GetParentNodeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<DirectorySubspace> const& parent,int loopDepth) 
	{
		loopDepth = a_body1cont2(parent, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<DirectorySubspace> && parent,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(parent), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetParentNodeActor*>(this)->actor_wait_state > 0) static_cast<GetParentNodeActor*>(this)->actor_wait_state = 0;
		static_cast<GetParentNodeActor*>(this)->ActorCallback< GetParentNodeActor, 0, Reference<DirectorySubspace> >::remove();

	}
	void a_callback_fire(ActorCallback< GetParentNodeActor, 0, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> const& value) 
	{
		fdb_probe_actor_enter("getParentNode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetParentNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getParentNode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetParentNodeActor, 0, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> && value) 
	{
		fdb_probe_actor_enter("getParentNode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetParentNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getParentNode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetParentNodeActor, 0, Reference<DirectorySubspace> >*,Error err) 
	{
		fdb_probe_actor_enter("getParentNode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetParentNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getParentNode", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 217 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<DirectoryLayer> dirLayer;
															#line 217 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<Transaction> tr;
															#line 217 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	IDirectory::Path path;
															#line 2169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getParentNode()
															#line 217 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class GetParentNodeActor final : public Actor<Subspace>, public ActorCallback< GetParentNodeActor, 0, Reference<DirectorySubspace> >, public FastAllocated<GetParentNodeActor>, public GetParentNodeActorState<GetParentNodeActor> {
															#line 2174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetParentNodeActor>::operator new;
	using FastAllocated<GetParentNodeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6857062717222990848UL, 2598397458465722112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Subspace>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetParentNodeActor, 0, Reference<DirectorySubspace> >;
															#line 217 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	GetParentNodeActor(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path) 
															#line 2191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		 : Actor<Subspace>(),
		   GetParentNodeActorState<GetParentNodeActor>(dirLayer, tr, path),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getParentNode", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10371257602221300224UL, 13713442875705849088UL);
		ActorExecutionContextHelper __helper(static_cast<GetParentNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getParentNode");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getParentNode", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetParentNodeActor, 0, Reference<DirectorySubspace> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 217 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
[[nodiscard]] Future<Subspace> getParentNode( Reference<DirectoryLayer> const& dirLayer, Reference<Transaction> const& tr, IDirectory::Path const& path ) {
															#line 217 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	return Future<Subspace>(new GetParentNodeActor(dirLayer, tr, path));
															#line 2223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
}

#line 233 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"

															#line 2228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
// This generated class is to be used only via createInternal()
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
template <class CreateInternalActor>
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class CreateInternalActorState {
															#line 2234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	CreateInternalActorState(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path,Standalone<StringRef> const& layer,Optional<Standalone<StringRef>> const& prefix,bool const& allowCreate) 
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		 : dirLayer(dirLayer),
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   tr(tr),
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   path(path),
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   layer(layer),
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   prefix(prefix),
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   allowCreate(allowCreate)
															#line 2251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("createInternal", reinterpret_cast<unsigned long>(this));

	}
	~CreateInternalActorState() 
	{
		fdb_probe_actor_destroy("createInternal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 240 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!allowCreate)
															#line 2266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 241 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				return a_body1Catch1(directory_does_not_exist(), loopDepth);
															#line 2270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
															#line 244 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = dirLayer->checkVersion(tr, true);
															#line 244 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<CreateInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateInternalActor*>(this)->actor_wait_state = 1;
															#line 244 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateInternalActor, 0, Void >*>(static_cast<CreateInternalActor*>(this)));
															#line 2281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateInternalActorState();
		static_cast<CreateInternalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 246 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = getPrefix(dirLayer, tr, prefix);
															#line 246 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<CreateInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateInternalActor*>(this)->actor_wait_state = 2;
															#line 246 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateInternalActor, 1, Standalone<StringRef> >*>(static_cast<CreateInternalActor*>(this)));
															#line 2311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 246 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = getPrefix(dirLayer, tr, prefix);
															#line 246 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<CreateInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateInternalActor*>(this)->actor_wait_state = 2;
															#line 246 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateInternalActor, 1, Standalone<StringRef> >*>(static_cast<CreateInternalActor*>(this)));
															#line 2327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateInternalActor*>(this)->actor_wait_state > 0) static_cast<CreateInternalActor*>(this)->actor_wait_state = 0;
		static_cast<CreateInternalActor*>(this)->ActorCallback< CreateInternalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateInternalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateInternalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateInternalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 247 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<bool> __when_expr_2 = isPrefixFree(dirLayer, tr, newPrefix, !prefix.present());
															#line 247 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<CreateInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateInternalActor*>(this)->actor_wait_state = 3;
															#line 247 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateInternalActor, 2, bool >*>(static_cast<CreateInternalActor*>(this)));
															#line 2418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> const& __newPrefix,int loopDepth) 
	{
															#line 246 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		newPrefix = __newPrefix;
															#line 2427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> && __newPrefix,int loopDepth) 
	{
		newPrefix = std::move(__newPrefix);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateInternalActor*>(this)->actor_wait_state > 0) static_cast<CreateInternalActor*>(this)->actor_wait_state = 0;
		static_cast<CreateInternalActor*>(this)->ActorCallback< CreateInternalActor, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateInternalActor, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("createInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateInternalActor, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("createInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateInternalActor, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("createInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(bool const& isFree,int loopDepth) 
	{
															#line 249 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!isFree)
															#line 2506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 250 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			return a_body1Catch1(directory_prefix_in_use(), loopDepth);
															#line 2510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 253 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<Subspace> __when_expr_3 = getParentNode(dirLayer, tr, path);
															#line 253 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<CreateInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateInternalActor*>(this)->actor_wait_state = 4;
															#line 253 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateInternalActor, 3, Subspace >*>(static_cast<CreateInternalActor*>(this)));
															#line 2521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(bool && isFree,int loopDepth) 
	{
															#line 249 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!isFree)
															#line 2530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 250 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			return a_body1Catch1(directory_prefix_in_use(), loopDepth);
															#line 2534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 253 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<Subspace> __when_expr_3 = getParentNode(dirLayer, tr, path);
															#line 253 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<CreateInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateInternalActor*>(this)->actor_wait_state = 4;
															#line 253 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateInternalActor, 3, Subspace >*>(static_cast<CreateInternalActor*>(this)));
															#line 2545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(bool const& isFree,int loopDepth) 
	{
		loopDepth = a_body1cont4(isFree, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(bool && isFree,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(isFree), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateInternalActor*>(this)->actor_wait_state > 0) static_cast<CreateInternalActor*>(this)->actor_wait_state = 0;
		static_cast<CreateInternalActor*>(this)->ActorCallback< CreateInternalActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CreateInternalActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("createInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateInternalActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("createInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateInternalActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("createInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Subspace const& parentNode,int loopDepth) 
	{
															#line 254 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		Subspace node = dirLayer->nodeWithPrefix(newPrefix);
															#line 256 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		tr->set(parentNode.get(DirectoryLayer::SUB_DIR_KEY).get(path.back(), true).key(), newPrefix);
															#line 257 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		tr->set(node.get(DirectoryLayer::LAYER_KEY).key(), layer);
															#line 258 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<CreateInternalActor*>(this)->SAV<Reference<DirectorySubspace>>::futures) { (void)(dirLayer->contentsOfNode(node, path, layer)); this->~CreateInternalActorState(); static_cast<CreateInternalActor*>(this)->destroy(); return 0; }
															#line 2635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<CreateInternalActor*>(this)->SAV< Reference<DirectorySubspace> >::value()) Reference<DirectorySubspace>(dirLayer->contentsOfNode(node, path, layer));
		this->~CreateInternalActorState();
		static_cast<CreateInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Subspace && parentNode,int loopDepth) 
	{
															#line 254 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		Subspace node = dirLayer->nodeWithPrefix(newPrefix);
															#line 256 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		tr->set(parentNode.get(DirectoryLayer::SUB_DIR_KEY).get(path.back(), true).key(), newPrefix);
															#line 257 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		tr->set(node.get(DirectoryLayer::LAYER_KEY).key(), layer);
															#line 258 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<CreateInternalActor*>(this)->SAV<Reference<DirectorySubspace>>::futures) { (void)(dirLayer->contentsOfNode(node, path, layer)); this->~CreateInternalActorState(); static_cast<CreateInternalActor*>(this)->destroy(); return 0; }
															#line 2653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<CreateInternalActor*>(this)->SAV< Reference<DirectorySubspace> >::value()) Reference<DirectorySubspace>(dirLayer->contentsOfNode(node, path, layer));
		this->~CreateInternalActorState();
		static_cast<CreateInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Subspace const& parentNode,int loopDepth) 
	{
		loopDepth = a_body1cont5(parentNode, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Subspace && parentNode,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(parentNode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CreateInternalActor*>(this)->actor_wait_state > 0) static_cast<CreateInternalActor*>(this)->actor_wait_state = 0;
		static_cast<CreateInternalActor*>(this)->ActorCallback< CreateInternalActor, 3, Subspace >::remove();

	}
	void a_callback_fire(ActorCallback< CreateInternalActor, 3, Subspace >*,Subspace const& value) 
	{
		fdb_probe_actor_enter("createInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CreateInternalActor, 3, Subspace >*,Subspace && value) 
	{
		fdb_probe_actor_enter("createInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CreateInternalActor, 3, Subspace >*,Error err) 
	{
		fdb_probe_actor_enter("createInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createInternal", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<DirectoryLayer> dirLayer;
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<Transaction> tr;
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	IDirectory::Path path;
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Standalone<StringRef> layer;
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Optional<Standalone<StringRef>> prefix;
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	bool allowCreate;
															#line 246 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Standalone<StringRef> newPrefix;
															#line 2750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via createInternal()
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class CreateInternalActor final : public Actor<Reference<DirectorySubspace>>, public ActorCallback< CreateInternalActor, 0, Void >, public ActorCallback< CreateInternalActor, 1, Standalone<StringRef> >, public ActorCallback< CreateInternalActor, 2, bool >, public ActorCallback< CreateInternalActor, 3, Subspace >, public FastAllocated<CreateInternalActor>, public CreateInternalActorState<CreateInternalActor> {
															#line 2755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CreateInternalActor>::operator new;
	using FastAllocated<CreateInternalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9454200790361633792UL, 3824904174465200640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<DirectorySubspace>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateInternalActor, 0, Void >;
friend struct ActorCallback< CreateInternalActor, 1, Standalone<StringRef> >;
friend struct ActorCallback< CreateInternalActor, 2, bool >;
friend struct ActorCallback< CreateInternalActor, 3, Subspace >;
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	CreateInternalActor(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path,Standalone<StringRef> const& layer,Optional<Standalone<StringRef>> const& prefix,bool const& allowCreate) 
															#line 2775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		 : Actor<Reference<DirectorySubspace>>(),
		   CreateInternalActorState<CreateInternalActor>(dirLayer, tr, path, layer, prefix, allowCreate),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createInternal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5164065128510914560UL, 12483865062726170112UL);
		ActorExecutionContextHelper __helper(static_cast<CreateInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createInternal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createInternal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateInternalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateInternalActor, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateInternalActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CreateInternalActor, 3, Subspace >*)0, actor_cancelled()); break;
		}

	}
};
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
[[nodiscard]] Future<Reference<DirectorySubspace>> createInternal( Reference<DirectoryLayer> const& dirLayer, Reference<Transaction> const& tr, IDirectory::Path const& path, Standalone<StringRef> const& layer, Optional<Standalone<StringRef>> const& prefix, bool const& allowCreate ) {
															#line 234 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	return Future<Reference<DirectorySubspace>>(new CreateInternalActor(dirLayer, tr, path, layer, prefix, allowCreate));
															#line 2810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
}

#line 260 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"

															#line 2815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
// This generated class is to be used only via _createOrOpenInternal()
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
template <class _createOrOpenInternalActor>
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class _createOrOpenInternalActorState {
															#line 2821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	_createOrOpenInternalActorState(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path,Standalone<StringRef> const& layer,Optional<Standalone<StringRef>> const& prefix,bool const& allowCreate,bool const& allowOpen) 
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		 : dirLayer(dirLayer),
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   tr(tr),
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   path(path),
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   layer(layer),
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   prefix(prefix),
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   allowCreate(allowCreate),
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   allowOpen(allowOpen)
															#line 2840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_createOrOpenInternal", reinterpret_cast<unsigned long>(this));

	}
	~_createOrOpenInternalActorState() 
	{
		fdb_probe_actor_destroy("_createOrOpenInternal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 268 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			ASSERT(!prefix.present() || allowCreate);
															#line 269 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = dirLayer->checkVersion(tr, false);
															#line 269 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state = 1;
															#line 269 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _createOrOpenInternalActor, 0, Void >*>(static_cast<_createOrOpenInternalActor*>(this)));
															#line 2864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_createOrOpenInternalActorState();
		static_cast<_createOrOpenInternalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 271 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (prefix.present() && !dirLayer->allowManualPrefixes)
															#line 2887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 272 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!dirLayer->getPath().size())
															#line 2891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 273 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				return a_body1Catch1(manual_prefixes_not_enabled(), loopDepth);
															#line 2895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 275 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				return a_body1Catch1(prefix_in_partition(), loopDepth);
															#line 2901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
		}
															#line 279 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!path.size())
															#line 2906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 280 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			return a_body1Catch1(cannot_open_root_directory(), loopDepth);
															#line 2910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 283 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<DirectoryLayer::Node> __when_expr_1 = find(dirLayer, tr, path);
															#line 283 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state = 2;
															#line 283 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _createOrOpenInternalActor, 1, DirectoryLayer::Node >*>(static_cast<_createOrOpenInternalActor*>(this)));
															#line 2921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 271 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (prefix.present() && !dirLayer->allowManualPrefixes)
															#line 2930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 272 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!dirLayer->getPath().size())
															#line 2934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 273 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				return a_body1Catch1(manual_prefixes_not_enabled(), loopDepth);
															#line 2938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 275 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				return a_body1Catch1(prefix_in_partition(), loopDepth);
															#line 2944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
		}
															#line 279 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!path.size())
															#line 2949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 280 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			return a_body1Catch1(cannot_open_root_directory(), loopDepth);
															#line 2953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 283 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<DirectoryLayer::Node> __when_expr_1 = find(dirLayer, tr, path);
															#line 283 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state = 2;
															#line 283 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _createOrOpenInternalActor, 1, DirectoryLayer::Node >*>(static_cast<_createOrOpenInternalActor*>(this)));
															#line 2964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state > 0) static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state = 0;
		static_cast<_createOrOpenInternalActor*>(this)->ActorCallback< _createOrOpenInternalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _createOrOpenInternalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createOrOpenInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _createOrOpenInternalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createOrOpenInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _createOrOpenInternalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createOrOpenInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 284 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (existingNode.exists())
															#line 3048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 285 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (existingNode.isInPartition())
															#line 3052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 286 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				IDirectory::Path subpath = existingNode.getPartitionSubpath();
															#line 287 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				StrictFuture<Reference<DirectorySubspace>> __when_expr_2 = existingNode.getContents()->getDirectoryLayer()->createOrOpenInternal( tr, subpath, layer, prefix, allowCreate, allowOpen);
															#line 287 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				if (static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
				static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state = 3;
															#line 287 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _createOrOpenInternalActor, 2, Reference<DirectorySubspace> >*>(static_cast<_createOrOpenInternalActor*>(this)));
															#line 3065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont8(loopDepth);
			}
		}
		else
		{
															#line 294 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<Reference<DirectorySubspace>> __when_expr_3 = createInternal(dirLayer, tr, path, layer, prefix, allowCreate);
															#line 294 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3079 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when2(__when_expr_3.get(), loopDepth); };
			static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state = 4;
															#line 294 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _createOrOpenInternalActor, 3, Reference<DirectorySubspace> >*>(static_cast<_createOrOpenInternalActor*>(this)));
															#line 3084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1when1(DirectoryLayer::Node const& __existingNode,int loopDepth) 
	{
															#line 283 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		existingNode = __existingNode;
															#line 3094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(DirectoryLayer::Node && __existingNode,int loopDepth) 
	{
		existingNode = std::move(__existingNode);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state > 0) static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state = 0;
		static_cast<_createOrOpenInternalActor*>(this)->ActorCallback< _createOrOpenInternalActor, 1, DirectoryLayer::Node >::remove();

	}
	void a_callback_fire(ActorCallback< _createOrOpenInternalActor, 1, DirectoryLayer::Node >*,DirectoryLayer::Node const& value) 
	{
		fdb_probe_actor_enter("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createOrOpenInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _createOrOpenInternalActor, 1, DirectoryLayer::Node >*,DirectoryLayer::Node && value) 
	{
		fdb_probe_actor_enter("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createOrOpenInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _createOrOpenInternalActor, 1, DirectoryLayer::Node >*,Error err) 
	{
		fdb_probe_actor_enter("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createOrOpenInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 292 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<_createOrOpenInternalActor*>(this)->SAV<Reference<DirectorySubspace>>::futures) { (void)(dirLayer->openInternal(layer, existingNode, allowOpen)); this->~_createOrOpenInternalActorState(); static_cast<_createOrOpenInternalActor*>(this)->destroy(); return 0; }
															#line 3173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<_createOrOpenInternalActor*>(this)->SAV< Reference<DirectorySubspace> >::value()) Reference<DirectorySubspace>(dirLayer->openInternal(layer, existingNode, allowOpen));
		this->~_createOrOpenInternalActorState();
		static_cast<_createOrOpenInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Reference<DirectorySubspace> const& dirSpace,int loopDepth) 
	{
															#line 290 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<_createOrOpenInternalActor*>(this)->SAV<Reference<DirectorySubspace>>::futures) { (void)(dirSpace); this->~_createOrOpenInternalActorState(); static_cast<_createOrOpenInternalActor*>(this)->destroy(); return 0; }
															#line 3185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<_createOrOpenInternalActor*>(this)->SAV< Reference<DirectorySubspace> >::value()) Reference<DirectorySubspace>(dirSpace);
		this->~_createOrOpenInternalActorState();
		static_cast<_createOrOpenInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Reference<DirectorySubspace> && dirSpace,int loopDepth) 
	{
															#line 290 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<_createOrOpenInternalActor*>(this)->SAV<Reference<DirectorySubspace>>::futures) { (void)(dirSpace); this->~_createOrOpenInternalActorState(); static_cast<_createOrOpenInternalActor*>(this)->destroy(); return 0; }
															#line 3197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<_createOrOpenInternalActor*>(this)->SAV< Reference<DirectorySubspace> >::value()) Reference<DirectorySubspace>(dirSpace);
		this->~_createOrOpenInternalActorState();
		static_cast<_createOrOpenInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Reference<DirectorySubspace> const& dirSpace,int loopDepth) 
	{
		loopDepth = a_body1cont9(dirSpace, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Reference<DirectorySubspace> && dirSpace,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(dirSpace), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state > 0) static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state = 0;
		static_cast<_createOrOpenInternalActor*>(this)->ActorCallback< _createOrOpenInternalActor, 2, Reference<DirectorySubspace> >::remove();

	}
	void a_callback_fire(ActorCallback< _createOrOpenInternalActor, 2, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> const& value) 
	{
		fdb_probe_actor_enter("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createOrOpenInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _createOrOpenInternalActor, 2, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> && value) 
	{
		fdb_probe_actor_enter("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createOrOpenInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _createOrOpenInternalActor, 2, Reference<DirectorySubspace> >*,Error err) 
	{
		fdb_probe_actor_enter("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createOrOpenInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12(Reference<DirectorySubspace> const& dirSpace,int loopDepth) 
	{
															#line 295 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<_createOrOpenInternalActor*>(this)->SAV<Reference<DirectorySubspace>>::futures) { (void)(dirSpace); this->~_createOrOpenInternalActorState(); static_cast<_createOrOpenInternalActor*>(this)->destroy(); return 0; }
															#line 3284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<_createOrOpenInternalActor*>(this)->SAV< Reference<DirectorySubspace> >::value()) Reference<DirectorySubspace>(dirSpace);
		this->~_createOrOpenInternalActorState();
		static_cast<_createOrOpenInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12(Reference<DirectorySubspace> && dirSpace,int loopDepth) 
	{
															#line 295 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<_createOrOpenInternalActor*>(this)->SAV<Reference<DirectorySubspace>>::futures) { (void)(dirSpace); this->~_createOrOpenInternalActorState(); static_cast<_createOrOpenInternalActor*>(this)->destroy(); return 0; }
															#line 3296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<_createOrOpenInternalActor*>(this)->SAV< Reference<DirectorySubspace> >::value()) Reference<DirectorySubspace>(dirSpace);
		this->~_createOrOpenInternalActorState();
		static_cast<_createOrOpenInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when2(Reference<DirectorySubspace> const& dirSpace,int loopDepth) 
	{
		loopDepth = a_body1cont12(dirSpace, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(Reference<DirectorySubspace> && dirSpace,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(dirSpace), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state > 0) static_cast<_createOrOpenInternalActor*>(this)->actor_wait_state = 0;
		static_cast<_createOrOpenInternalActor*>(this)->ActorCallback< _createOrOpenInternalActor, 3, Reference<DirectorySubspace> >::remove();

	}
	void a_callback_fire(ActorCallback< _createOrOpenInternalActor, 3, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> const& value) 
	{
		fdb_probe_actor_enter("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createOrOpenInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _createOrOpenInternalActor, 3, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> && value) 
	{
		fdb_probe_actor_enter("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createOrOpenInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _createOrOpenInternalActor, 3, Reference<DirectorySubspace> >*,Error err) 
	{
		fdb_probe_actor_enter("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createOrOpenInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<DirectoryLayer> dirLayer;
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<Transaction> tr;
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	IDirectory::Path path;
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Standalone<StringRef> layer;
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Optional<Standalone<StringRef>> prefix;
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	bool allowCreate;
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	bool allowOpen;
															#line 283 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	DirectoryLayer::Node existingNode;
															#line 3395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _createOrOpenInternal()
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class _createOrOpenInternalActor final : public Actor<Reference<DirectorySubspace>>, public ActorCallback< _createOrOpenInternalActor, 0, Void >, public ActorCallback< _createOrOpenInternalActor, 1, DirectoryLayer::Node >, public ActorCallback< _createOrOpenInternalActor, 2, Reference<DirectorySubspace> >, public ActorCallback< _createOrOpenInternalActor, 3, Reference<DirectorySubspace> >, public FastAllocated<_createOrOpenInternalActor>, public _createOrOpenInternalActorState<_createOrOpenInternalActor> {
															#line 3400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
	using FastAllocated<_createOrOpenInternalActor>::operator new;
	using FastAllocated<_createOrOpenInternalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13675550346059410176UL, 9374082647032435200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<DirectorySubspace>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _createOrOpenInternalActor, 0, Void >;
friend struct ActorCallback< _createOrOpenInternalActor, 1, DirectoryLayer::Node >;
friend struct ActorCallback< _createOrOpenInternalActor, 2, Reference<DirectorySubspace> >;
friend struct ActorCallback< _createOrOpenInternalActor, 3, Reference<DirectorySubspace> >;
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	_createOrOpenInternalActor(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path,Standalone<StringRef> const& layer,Optional<Standalone<StringRef>> const& prefix,bool const& allowCreate,bool const& allowOpen) 
															#line 3420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		 : Actor<Reference<DirectorySubspace>>(),
		   _createOrOpenInternalActorState<_createOrOpenInternalActor>(dirLayer, tr, path, layer, prefix, allowCreate, allowOpen),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14955514211397415936UL, 13395901210094768640UL);
		ActorExecutionContextHelper __helper(static_cast<_createOrOpenInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_createOrOpenInternal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_createOrOpenInternal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _createOrOpenInternalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _createOrOpenInternalActor, 1, DirectoryLayer::Node >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _createOrOpenInternalActor, 2, Reference<DirectorySubspace> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _createOrOpenInternalActor, 3, Reference<DirectorySubspace> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
[[nodiscard]] Future<Reference<DirectorySubspace>> _createOrOpenInternal( Reference<DirectoryLayer> const& dirLayer, Reference<Transaction> const& tr, IDirectory::Path const& path, Standalone<StringRef> const& layer, Optional<Standalone<StringRef>> const& prefix, bool const& allowCreate, bool const& allowOpen ) {
															#line 261 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	return Future<Reference<DirectorySubspace>>(new _createOrOpenInternalActor(dirLayer, tr, path, layer, prefix, allowCreate, allowOpen));
															#line 3455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
}

#line 298 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"

Future<Reference<DirectorySubspace>> DirectoryLayer::createOrOpenInternal(Reference<Transaction> const& tr,
                                                                          Path const& path,
                                                                          Standalone<StringRef> const& layer,
                                                                          Optional<Standalone<StringRef>> const& prefix,
                                                                          bool allowCreate,
                                                                          bool allowOpen) {
	return _createOrOpenInternal(
	    Reference<DirectoryLayer>::addRef(this), tr, path, layer, prefix, allowCreate, allowOpen);
}

Future<Reference<DirectorySubspace>> DirectoryLayer::create(Reference<Transaction> const& tr,
                                                            Path const& path,
                                                            Standalone<StringRef> const& layer,
                                                            Optional<Standalone<StringRef>> const& prefix) {
	return createOrOpenInternal(tr, path, layer, prefix, true, false);
}

Future<Reference<DirectorySubspace>> DirectoryLayer::createOrOpen(Reference<Transaction> const& tr,
                                                                  Path const& path,
                                                                  Standalone<StringRef> const& layer) {
	return createOrOpenInternal(tr, path, layer, Optional<Standalone<StringRef>>(), true, true);
}

															#line 3483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
// This generated class is to be used only via listInternal()
															#line 322 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
template <class ListInternalActor>
															#line 322 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class ListInternalActorState {
															#line 3489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
															#line 322 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	ListInternalActorState(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path) 
															#line 322 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
															#line 322 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		 : dirLayer(dirLayer),
															#line 322 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   tr(tr),
															#line 322 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   path(path)
															#line 3500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("listInternal", reinterpret_cast<unsigned long>(this));

	}
	~ListInternalActorState() 
	{
		fdb_probe_actor_destroy("listInternal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 325 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = dirLayer->checkVersion(tr, false);
															#line 325 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<ListInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListInternalActor*>(this)->actor_wait_state = 1;
															#line 325 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListInternalActor, 0, Void >*>(static_cast<ListInternalActor*>(this)));
															#line 3522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListInternalActorState();
		static_cast<ListInternalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 327 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<DirectoryLayer::Node> __when_expr_1 = find(dirLayer, tr, path);
															#line 327 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<ListInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListInternalActor*>(this)->actor_wait_state = 2;
															#line 327 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListInternalActor, 1, DirectoryLayer::Node >*>(static_cast<ListInternalActor*>(this)));
															#line 3552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 327 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<DirectoryLayer::Node> __when_expr_1 = find(dirLayer, tr, path);
															#line 327 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<ListInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListInternalActor*>(this)->actor_wait_state = 2;
															#line 327 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListInternalActor, 1, DirectoryLayer::Node >*>(static_cast<ListInternalActor*>(this)));
															#line 3568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListInternalActor*>(this)->actor_wait_state > 0) static_cast<ListInternalActor*>(this)->actor_wait_state = 0;
		static_cast<ListInternalActor*>(this)->ActorCallback< ListInternalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListInternalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListInternalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListInternalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 329 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!node.exists())
															#line 3652 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 330 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			return a_body1Catch1(directory_does_not_exist(), loopDepth);
															#line 3656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 332 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (node.isInPartition(true))
															#line 3660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 333 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<Standalone<VectorRef<StringRef>>> __when_expr_2 = node.getContents()->getDirectoryLayer()->list(tr, node.getPartitionSubpath());
															#line 333 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<ListInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<ListInternalActor*>(this)->actor_wait_state = 3;
															#line 333 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ListInternalActor, 2, Standalone<VectorRef<StringRef>> >*>(static_cast<ListInternalActor*>(this)));
															#line 3671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(DirectoryLayer::Node const& __node,int loopDepth) 
	{
															#line 327 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		node = __node;
															#line 3685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(DirectoryLayer::Node && __node,int loopDepth) 
	{
		node = std::move(__node);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListInternalActor*>(this)->actor_wait_state > 0) static_cast<ListInternalActor*>(this)->actor_wait_state = 0;
		static_cast<ListInternalActor*>(this)->ActorCallback< ListInternalActor, 1, DirectoryLayer::Node >::remove();

	}
	void a_callback_fire(ActorCallback< ListInternalActor, 1, DirectoryLayer::Node >*,DirectoryLayer::Node const& value) 
	{
		fdb_probe_actor_enter("listInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListInternalActor, 1, DirectoryLayer::Node >*,DirectoryLayer::Node && value) 
	{
		fdb_probe_actor_enter("listInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListInternalActor, 1, DirectoryLayer::Node >*,Error err) 
	{
		fdb_probe_actor_enter("listInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 338 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		subdir = node.subspace.get().get(DirectoryLayer::SUB_DIR_KEY);
															#line 339 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		begin = subdir.range().begin;
															#line 340 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		subdirectories = Standalone<VectorRef<StringRef>>();
															#line 342 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		;
															#line 3770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Standalone<VectorRef<StringRef>> const& partitionList,int loopDepth) 
	{
															#line 335 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<ListInternalActor*>(this)->SAV<Standalone<VectorRef<StringRef>>>::futures) { (void)(partitionList); this->~ListInternalActorState(); static_cast<ListInternalActor*>(this)->destroy(); return 0; }
															#line 3779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<ListInternalActor*>(this)->SAV< Standalone<VectorRef<StringRef>> >::value()) Standalone<VectorRef<StringRef>>(partitionList);
		this->~ListInternalActorState();
		static_cast<ListInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Standalone<VectorRef<StringRef>> && partitionList,int loopDepth) 
	{
															#line 335 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<ListInternalActor*>(this)->SAV<Standalone<VectorRef<StringRef>>>::futures) { (void)(partitionList); this->~ListInternalActorState(); static_cast<ListInternalActor*>(this)->destroy(); return 0; }
															#line 3791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<ListInternalActor*>(this)->SAV< Standalone<VectorRef<StringRef>> >::value()) Standalone<VectorRef<StringRef>>(partitionList);
		this->~ListInternalActorState();
		static_cast<ListInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Standalone<VectorRef<StringRef>> const& partitionList,int loopDepth) 
	{
		loopDepth = a_body1cont5(partitionList, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Standalone<VectorRef<StringRef>> && partitionList,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(partitionList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ListInternalActor*>(this)->actor_wait_state > 0) static_cast<ListInternalActor*>(this)->actor_wait_state = 0;
		static_cast<ListInternalActor*>(this)->ActorCallback< ListInternalActor, 2, Standalone<VectorRef<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ListInternalActor, 2, Standalone<VectorRef<StringRef>> >*,Standalone<VectorRef<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("listInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ListInternalActor, 2, Standalone<VectorRef<StringRef>> >*,Standalone<VectorRef<StringRef>> && value) 
	{
		fdb_probe_actor_enter("listInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ListInternalActor, 2, Standalone<VectorRef<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("listInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 343 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_3 = tr->getRange(KeyRangeRef(begin, subdir.range().end));
															#line 343 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<ListInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<ListInternalActor*>(this)->actor_wait_state = 4;
															#line 343 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ListInternalActor, 3, FDBStandalone<RangeResultRef> >*>(static_cast<ListInternalActor*>(this)));
															#line 3892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(FDBStandalone<RangeResultRef> const& subdirRange,int loopDepth) 
	{
															#line 345 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		for(int i = 0;i < subdirRange.size();++i) {
															#line 346 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			subdirectories.push_back_deep(subdirectories.arena(), subdir.unpack(subdirRange[i].key).getString(0));
															#line 3903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 349 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!subdirRange.more)
															#line 3907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 350 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!static_cast<ListInternalActor*>(this)->SAV<Standalone<VectorRef<StringRef>>>::futures) { (void)(subdirectories); this->~ListInternalActorState(); static_cast<ListInternalActor*>(this)->destroy(); return 0; }
															#line 3911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			new (&static_cast<ListInternalActor*>(this)->SAV< Standalone<VectorRef<StringRef>> >::value()) Standalone<VectorRef<StringRef>>(std::move(subdirectories)); // state_var_RVO
			this->~ListInternalActorState();
			static_cast<ListInternalActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 353 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		begin = keyAfter(subdirRange.back().key);
															#line 3919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(FDBStandalone<RangeResultRef> && subdirRange,int loopDepth) 
	{
															#line 345 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		for(int i = 0;i < subdirRange.size();++i) {
															#line 346 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			subdirectories.push_back_deep(subdirectories.arena(), subdir.unpack(subdirRange[i].key).getString(0));
															#line 3930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 349 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!subdirRange.more)
															#line 3934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 350 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!static_cast<ListInternalActor*>(this)->SAV<Standalone<VectorRef<StringRef>>>::futures) { (void)(subdirectories); this->~ListInternalActorState(); static_cast<ListInternalActor*>(this)->destroy(); return 0; }
															#line 3938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			new (&static_cast<ListInternalActor*>(this)->SAV< Standalone<VectorRef<StringRef>> >::value()) Standalone<VectorRef<StringRef>>(std::move(subdirectories)); // state_var_RVO
			this->~ListInternalActorState();
			static_cast<ListInternalActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 353 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		begin = keyAfter(subdirRange.back().key);
															#line 3946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(FDBStandalone<RangeResultRef> const& subdirRange,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(subdirRange, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(FDBStandalone<RangeResultRef> && subdirRange,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(subdirRange), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ListInternalActor*>(this)->actor_wait_state > 0) static_cast<ListInternalActor*>(this)->actor_wait_state = 0;
		static_cast<ListInternalActor*>(this)->ActorCallback< ListInternalActor, 3, FDBStandalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< ListInternalActor, 3, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("listInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ListInternalActor, 3, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("listInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ListInternalActor, 3, FDBStandalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("listInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listInternal", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 322 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<DirectoryLayer> dirLayer;
															#line 322 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<Transaction> tr;
															#line 322 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	IDirectory::Path path;
															#line 327 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	DirectoryLayer::Node node;
															#line 338 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Subspace subdir;
															#line 339 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Key begin;
															#line 340 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Standalone<VectorRef<StringRef>> subdirectories;
															#line 4040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via listInternal()
															#line 322 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class ListInternalActor final : public Actor<Standalone<VectorRef<StringRef>>>, public ActorCallback< ListInternalActor, 0, Void >, public ActorCallback< ListInternalActor, 1, DirectoryLayer::Node >, public ActorCallback< ListInternalActor, 2, Standalone<VectorRef<StringRef>> >, public ActorCallback< ListInternalActor, 3, FDBStandalone<RangeResultRef> >, public FastAllocated<ListInternalActor>, public ListInternalActorState<ListInternalActor> {
															#line 4045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ListInternalActor>::operator new;
	using FastAllocated<ListInternalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(225178569413076992UL, 635557278857263104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<StringRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListInternalActor, 0, Void >;
friend struct ActorCallback< ListInternalActor, 1, DirectoryLayer::Node >;
friend struct ActorCallback< ListInternalActor, 2, Standalone<VectorRef<StringRef>> >;
friend struct ActorCallback< ListInternalActor, 3, FDBStandalone<RangeResultRef> >;
															#line 322 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	ListInternalActor(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path) 
															#line 4065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<StringRef>>>(),
		   ListInternalActorState<ListInternalActor>(dirLayer, tr, path),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listInternal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(316743578443642368UL, 17219256622310786560UL);
		ActorExecutionContextHelper __helper(static_cast<ListInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listInternal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listInternal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListInternalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListInternalActor, 1, DirectoryLayer::Node >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ListInternalActor, 2, Standalone<VectorRef<StringRef>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ListInternalActor, 3, FDBStandalone<RangeResultRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 322 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<StringRef>>> listInternal( Reference<DirectoryLayer> const& dirLayer, Reference<Transaction> const& tr, IDirectory::Path const& path ) {
															#line 322 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	return Future<Standalone<VectorRef<StringRef>>>(new ListInternalActor(dirLayer, tr, path));
															#line 4100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
}

#line 356 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"

Future<Standalone<VectorRef<StringRef>>> DirectoryLayer::list(Reference<Transaction> const& tr, Path const& path) {
	return listInternal(Reference<DirectoryLayer>::addRef(this), tr, path);
}

bool pathsEqual(IDirectory::Path const& path1,
                IDirectory::Path const& path2,
                size_t maxElementsToCheck = std::numeric_limits<size_t>::max()) {
	if (std::min(path1.size(), maxElementsToCheck) != std::min(path2.size(), maxElementsToCheck)) {
		return false;
	}
	for (int i = 0; i < path1.size() && i < maxElementsToCheck; ++i) {
		if (path1[i] != path2[i]) {
			return false;
		}
	}

	return true;
}

															#line 4124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
// This generated class is to be used only via removeFromParent()
															#line 376 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
template <class RemoveFromParentActor>
															#line 376 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class RemoveFromParentActorState {
															#line 4130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
															#line 376 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	RemoveFromParentActorState(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path) 
															#line 376 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
															#line 376 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		 : dirLayer(dirLayer),
															#line 376 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   tr(tr),
															#line 376 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   path(path)
															#line 4141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("removeFromParent", reinterpret_cast<unsigned long>(this));

	}
	~RemoveFromParentActorState() 
	{
		fdb_probe_actor_destroy("removeFromParent", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 379 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			ASSERT(path.size() >= 1);
															#line 380 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<DirectoryLayer::Node> __when_expr_0 = find(dirLayer, tr, IDirectory::Path(path.begin(), path.end() - 1));
															#line 380 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<RemoveFromParentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RemoveFromParentActor*>(this)->actor_wait_state = 1;
															#line 380 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RemoveFromParentActor, 0, DirectoryLayer::Node >*>(static_cast<RemoveFromParentActor*>(this)));
															#line 4165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RemoveFromParentActorState();
		static_cast<RemoveFromParentActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(DirectoryLayer::Node const& parentNode,int loopDepth) 
	{
															#line 381 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (parentNode.subspace.present())
															#line 4188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 382 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			tr->clear(parentNode.subspace.get().get(DirectoryLayer::SUB_DIR_KEY).get(path.back(), true).key());
															#line 4192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 385 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<RemoveFromParentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveFromParentActorState(); static_cast<RemoveFromParentActor*>(this)->destroy(); return 0; }
															#line 4196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<RemoveFromParentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveFromParentActorState();
		static_cast<RemoveFromParentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(DirectoryLayer::Node && parentNode,int loopDepth) 
	{
															#line 381 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (parentNode.subspace.present())
															#line 4208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 382 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			tr->clear(parentNode.subspace.get().get(DirectoryLayer::SUB_DIR_KEY).get(path.back(), true).key());
															#line 4212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 385 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<RemoveFromParentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveFromParentActorState(); static_cast<RemoveFromParentActor*>(this)->destroy(); return 0; }
															#line 4216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<RemoveFromParentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveFromParentActorState();
		static_cast<RemoveFromParentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(DirectoryLayer::Node const& parentNode,int loopDepth) 
	{
		loopDepth = a_body1cont1(parentNode, loopDepth);

		return loopDepth;
	}
	int a_body1when1(DirectoryLayer::Node && parentNode,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(parentNode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RemoveFromParentActor*>(this)->actor_wait_state > 0) static_cast<RemoveFromParentActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveFromParentActor*>(this)->ActorCallback< RemoveFromParentActor, 0, DirectoryLayer::Node >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveFromParentActor, 0, DirectoryLayer::Node >*,DirectoryLayer::Node const& value) 
	{
		fdb_probe_actor_enter("removeFromParent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveFromParentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeFromParent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoveFromParentActor, 0, DirectoryLayer::Node >*,DirectoryLayer::Node && value) 
	{
		fdb_probe_actor_enter("removeFromParent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveFromParentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeFromParent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RemoveFromParentActor, 0, DirectoryLayer::Node >*,Error err) 
	{
		fdb_probe_actor_enter("removeFromParent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveFromParentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeFromParent", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 376 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<DirectoryLayer> dirLayer;
															#line 376 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<Transaction> tr;
															#line 376 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	IDirectory::Path path;
															#line 4305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via removeFromParent()
															#line 376 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class RemoveFromParentActor final : public Actor<Void>, public ActorCallback< RemoveFromParentActor, 0, DirectoryLayer::Node >, public FastAllocated<RemoveFromParentActor>, public RemoveFromParentActorState<RemoveFromParentActor> {
															#line 4310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
	using FastAllocated<RemoveFromParentActor>::operator new;
	using FastAllocated<RemoveFromParentActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15840780592987121408UL, 14651283771036776448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RemoveFromParentActor, 0, DirectoryLayer::Node >;
															#line 376 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	RemoveFromParentActor(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path) 
															#line 4327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RemoveFromParentActorState<RemoveFromParentActor>(dirLayer, tr, path),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("removeFromParent", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7318920243667857152UL, 7867835490789166592UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveFromParentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("removeFromParent");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("removeFromParent", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RemoveFromParentActor, 0, DirectoryLayer::Node >*)0, actor_cancelled()); break;
		}

	}
};
															#line 376 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
[[nodiscard]] Future<Void> removeFromParent( Reference<DirectoryLayer> const& dirLayer, Reference<Transaction> const& tr, IDirectory::Path const& path ) {
															#line 376 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	return Future<Void>(new RemoveFromParentActor(dirLayer, tr, path));
															#line 4359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
}

#line 387 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"

															#line 4364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
// This generated class is to be used only via moveInternal()
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
template <class MoveInternalActor>
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class MoveInternalActorState {
															#line 4370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	MoveInternalActorState(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& oldPath,IDirectory::Path const& newPath) 
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		 : dirLayer(dirLayer),
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   tr(tr),
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   oldPath(oldPath),
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   newPath(newPath)
															#line 4383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("moveInternal", reinterpret_cast<unsigned long>(this));

	}
	~MoveInternalActorState() 
	{
		fdb_probe_actor_destroy("moveInternal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 392 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = dirLayer->checkVersion(tr, true);
															#line 392 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<MoveInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MoveInternalActor*>(this)->actor_wait_state = 1;
															#line 392 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MoveInternalActor, 0, Void >*>(static_cast<MoveInternalActor*>(this)));
															#line 4405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MoveInternalActorState();
		static_cast<MoveInternalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 394 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (oldPath.size() <= newPath.size())
															#line 4428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 395 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (pathsEqual(oldPath, newPath, oldPath.size()))
															#line 4432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 396 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				return a_body1Catch1(invalid_destination_directory(), loopDepth);
															#line 4436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
		}
															#line 400 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		std::vector<Future<DirectoryLayer::Node>> futures;
															#line 401 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		futures.push_back(find(dirLayer, tr, oldPath));
															#line 402 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		futures.push_back(find(dirLayer, tr, newPath));
															#line 404 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<std::vector<DirectoryLayer::Node>> __when_expr_1 = getAll(futures);
															#line 404 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<MoveInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MoveInternalActor*>(this)->actor_wait_state = 2;
															#line 404 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MoveInternalActor, 1, std::vector<DirectoryLayer::Node> >*>(static_cast<MoveInternalActor*>(this)));
															#line 4454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 394 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (oldPath.size() <= newPath.size())
															#line 4463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 395 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (pathsEqual(oldPath, newPath, oldPath.size()))
															#line 4467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 396 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				return a_body1Catch1(invalid_destination_directory(), loopDepth);
															#line 4471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
		}
															#line 400 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		std::vector<Future<DirectoryLayer::Node>> futures;
															#line 401 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		futures.push_back(find(dirLayer, tr, oldPath));
															#line 402 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		futures.push_back(find(dirLayer, tr, newPath));
															#line 404 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<std::vector<DirectoryLayer::Node>> __when_expr_1 = getAll(futures);
															#line 404 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<MoveInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MoveInternalActor*>(this)->actor_wait_state = 2;
															#line 404 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MoveInternalActor, 1, std::vector<DirectoryLayer::Node> >*>(static_cast<MoveInternalActor*>(this)));
															#line 4489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MoveInternalActor*>(this)->actor_wait_state > 0) static_cast<MoveInternalActor*>(this)->actor_wait_state = 0;
		static_cast<MoveInternalActor*>(this)->ActorCallback< MoveInternalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveInternalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MoveInternalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MoveInternalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::vector<DirectoryLayer::Node> const& nodes,int loopDepth) 
	{
															#line 406 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		oldNode = nodes[0];
															#line 407 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		newNode = nodes[1];
															#line 409 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!oldNode.exists())
															#line 4577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 410 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			return a_body1Catch1(directory_does_not_exist(), loopDepth);
															#line 4581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 413 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (oldNode.isInPartition() || newNode.isInPartition())
															#line 4585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 414 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!oldNode.isInPartition() || !newNode.isInPartition() || !pathsEqual(oldNode.path, newNode.path))
															#line 4589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 415 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				return a_body1Catch1(cannot_move_directory_between_partitions(), loopDepth);
															#line 4593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
															#line 418 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<Reference<DirectorySubspace>> __when_expr_2 = newNode.getContents()->move(tr, oldNode.getPartitionSubpath(), newNode.getPartitionSubpath());
															#line 418 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<MoveInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<MoveInternalActor*>(this)->actor_wait_state = 3;
															#line 418 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MoveInternalActor, 2, Reference<DirectorySubspace> >*>(static_cast<MoveInternalActor*>(this)));
															#line 4604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::vector<DirectoryLayer::Node> && nodes,int loopDepth) 
	{
															#line 406 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		oldNode = nodes[0];
															#line 407 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		newNode = nodes[1];
															#line 409 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!oldNode.exists())
															#line 4622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 410 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			return a_body1Catch1(directory_does_not_exist(), loopDepth);
															#line 4626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 413 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (oldNode.isInPartition() || newNode.isInPartition())
															#line 4630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 414 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!oldNode.isInPartition() || !newNode.isInPartition() || !pathsEqual(oldNode.path, newNode.path))
															#line 4634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 415 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				return a_body1Catch1(cannot_move_directory_between_partitions(), loopDepth);
															#line 4638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
															#line 418 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<Reference<DirectorySubspace>> __when_expr_2 = newNode.getContents()->move(tr, oldNode.getPartitionSubpath(), newNode.getPartitionSubpath());
															#line 418 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<MoveInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4644 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<MoveInternalActor*>(this)->actor_wait_state = 3;
															#line 418 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MoveInternalActor, 2, Reference<DirectorySubspace> >*>(static_cast<MoveInternalActor*>(this)));
															#line 4649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<DirectoryLayer::Node> const& nodes,int loopDepth) 
	{
		loopDepth = a_body1cont2(nodes, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<DirectoryLayer::Node> && nodes,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(nodes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MoveInternalActor*>(this)->actor_wait_state > 0) static_cast<MoveInternalActor*>(this)->actor_wait_state = 0;
		static_cast<MoveInternalActor*>(this)->ActorCallback< MoveInternalActor, 1, std::vector<DirectoryLayer::Node> >::remove();

	}
	void a_callback_fire(ActorCallback< MoveInternalActor, 1, std::vector<DirectoryLayer::Node> >*,std::vector<DirectoryLayer::Node> const& value) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MoveInternalActor, 1, std::vector<DirectoryLayer::Node> >*,std::vector<DirectoryLayer::Node> && value) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MoveInternalActor, 1, std::vector<DirectoryLayer::Node> >*,Error err) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 423 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (newNode.exists() || newPath.empty())
															#line 4738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 424 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			return a_body1Catch1(directory_already_exists(), loopDepth);
															#line 4742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 427 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<DirectoryLayer::Node> __when_expr_3 = find(dirLayer, tr, IDirectory::Path(newPath.begin(), newPath.end() - 1));
															#line 427 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<MoveInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<MoveInternalActor*>(this)->actor_wait_state = 4;
															#line 427 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MoveInternalActor, 3, DirectoryLayer::Node >*>(static_cast<MoveInternalActor*>(this)));
															#line 4753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Reference<DirectorySubspace> const& partitionMove,int loopDepth) 
	{
															#line 420 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<MoveInternalActor*>(this)->SAV<Reference<DirectorySubspace>>::futures) { (void)(partitionMove); this->~MoveInternalActorState(); static_cast<MoveInternalActor*>(this)->destroy(); return 0; }
															#line 4762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<MoveInternalActor*>(this)->SAV< Reference<DirectorySubspace> >::value()) Reference<DirectorySubspace>(partitionMove);
		this->~MoveInternalActorState();
		static_cast<MoveInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Reference<DirectorySubspace> && partitionMove,int loopDepth) 
	{
															#line 420 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<MoveInternalActor*>(this)->SAV<Reference<DirectorySubspace>>::futures) { (void)(partitionMove); this->~MoveInternalActorState(); static_cast<MoveInternalActor*>(this)->destroy(); return 0; }
															#line 4774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<MoveInternalActor*>(this)->SAV< Reference<DirectorySubspace> >::value()) Reference<DirectorySubspace>(partitionMove);
		this->~MoveInternalActorState();
		static_cast<MoveInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Reference<DirectorySubspace> const& partitionMove,int loopDepth) 
	{
		loopDepth = a_body1cont7(partitionMove, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Reference<DirectorySubspace> && partitionMove,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(partitionMove), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MoveInternalActor*>(this)->actor_wait_state > 0) static_cast<MoveInternalActor*>(this)->actor_wait_state = 0;
		static_cast<MoveInternalActor*>(this)->ActorCallback< MoveInternalActor, 2, Reference<DirectorySubspace> >::remove();

	}
	void a_callback_fire(ActorCallback< MoveInternalActor, 2, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> const& value) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MoveInternalActor, 2, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> && value) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MoveInternalActor, 2, Reference<DirectorySubspace> >*,Error err) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10(DirectoryLayer::Node const& parentNode,int loopDepth) 
	{
															#line 428 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!parentNode.exists())
															#line 4861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 429 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			return a_body1Catch1(parent_directory_does_not_exist(), loopDepth);
															#line 4865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 432 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		tr->set(parentNode.subspace.get().get(DirectoryLayer::SUB_DIR_KEY).get(newPath.back(), true).key(), dirLayer->nodeSubspace.unpack(oldNode.subspace.get().key()).getString(0));
															#line 434 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = removeFromParent(dirLayer, tr, oldPath);
															#line 434 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<MoveInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
		static_cast<MoveInternalActor*>(this)->actor_wait_state = 5;
															#line 434 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MoveInternalActor, 4, Void >*>(static_cast<MoveInternalActor*>(this)));
															#line 4878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(DirectoryLayer::Node && parentNode,int loopDepth) 
	{
															#line 428 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!parentNode.exists())
															#line 4887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 429 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			return a_body1Catch1(parent_directory_does_not_exist(), loopDepth);
															#line 4891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 432 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		tr->set(parentNode.subspace.get().get(DirectoryLayer::SUB_DIR_KEY).get(newPath.back(), true).key(), dirLayer->nodeSubspace.unpack(oldNode.subspace.get().key()).getString(0));
															#line 434 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = removeFromParent(dirLayer, tr, oldPath);
															#line 434 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<MoveInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
		static_cast<MoveInternalActor*>(this)->actor_wait_state = 5;
															#line 434 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MoveInternalActor, 4, Void >*>(static_cast<MoveInternalActor*>(this)));
															#line 4904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(DirectoryLayer::Node const& parentNode,int loopDepth) 
	{
		loopDepth = a_body1cont10(parentNode, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(DirectoryLayer::Node && parentNode,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(parentNode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MoveInternalActor*>(this)->actor_wait_state > 0) static_cast<MoveInternalActor*>(this)->actor_wait_state = 0;
		static_cast<MoveInternalActor*>(this)->ActorCallback< MoveInternalActor, 3, DirectoryLayer::Node >::remove();

	}
	void a_callback_fire(ActorCallback< MoveInternalActor, 3, DirectoryLayer::Node >*,DirectoryLayer::Node const& value) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MoveInternalActor, 3, DirectoryLayer::Node >*,DirectoryLayer::Node && value) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MoveInternalActor, 3, DirectoryLayer::Node >*,Error err) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 436 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<MoveInternalActor*>(this)->SAV<Reference<DirectorySubspace>>::futures) { (void)(dirLayer->contentsOfNode(oldNode.subspace.get(), newPath, oldNode.layer)); this->~MoveInternalActorState(); static_cast<MoveInternalActor*>(this)->destroy(); return 0; }
															#line 4988 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<MoveInternalActor*>(this)->SAV< Reference<DirectorySubspace> >::value()) Reference<DirectorySubspace>(dirLayer->contentsOfNode(oldNode.subspace.get(), newPath, oldNode.layer));
		this->~MoveInternalActorState();
		static_cast<MoveInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 436 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<MoveInternalActor*>(this)->SAV<Reference<DirectorySubspace>>::futures) { (void)(dirLayer->contentsOfNode(oldNode.subspace.get(), newPath, oldNode.layer)); this->~MoveInternalActorState(); static_cast<MoveInternalActor*>(this)->destroy(); return 0; }
															#line 5000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<MoveInternalActor*>(this)->SAV< Reference<DirectorySubspace> >::value()) Reference<DirectorySubspace>(dirLayer->contentsOfNode(oldNode.subspace.get(), newPath, oldNode.layer));
		this->~MoveInternalActorState();
		static_cast<MoveInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MoveInternalActor*>(this)->actor_wait_state > 0) static_cast<MoveInternalActor*>(this)->actor_wait_state = 0;
		static_cast<MoveInternalActor*>(this)->ActorCallback< MoveInternalActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveInternalActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MoveInternalActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MoveInternalActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<DirectoryLayer> dirLayer;
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<Transaction> tr;
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	IDirectory::Path oldPath;
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	IDirectory::Path newPath;
															#line 406 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	DirectoryLayer::Node oldNode;
															#line 407 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	DirectoryLayer::Node newNode;
															#line 5095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via moveInternal()
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class MoveInternalActor final : public Actor<Reference<DirectorySubspace>>, public ActorCallback< MoveInternalActor, 0, Void >, public ActorCallback< MoveInternalActor, 1, std::vector<DirectoryLayer::Node> >, public ActorCallback< MoveInternalActor, 2, Reference<DirectorySubspace> >, public ActorCallback< MoveInternalActor, 3, DirectoryLayer::Node >, public ActorCallback< MoveInternalActor, 4, Void >, public FastAllocated<MoveInternalActor>, public MoveInternalActorState<MoveInternalActor> {
															#line 5100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
	using FastAllocated<MoveInternalActor>::operator new;
	using FastAllocated<MoveInternalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18432175434768277248UL, 11451890666506378240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<DirectorySubspace>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MoveInternalActor, 0, Void >;
friend struct ActorCallback< MoveInternalActor, 1, std::vector<DirectoryLayer::Node> >;
friend struct ActorCallback< MoveInternalActor, 2, Reference<DirectorySubspace> >;
friend struct ActorCallback< MoveInternalActor, 3, DirectoryLayer::Node >;
friend struct ActorCallback< MoveInternalActor, 4, Void >;
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	MoveInternalActor(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& oldPath,IDirectory::Path const& newPath) 
															#line 5121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		 : Actor<Reference<DirectorySubspace>>(),
		   MoveInternalActorState<MoveInternalActor>(dirLayer, tr, oldPath, newPath),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("moveInternal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4113662987052645376UL, 11265835399443327232UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("moveInternal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("moveInternal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MoveInternalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MoveInternalActor, 1, std::vector<DirectoryLayer::Node> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MoveInternalActor, 2, Reference<DirectorySubspace> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MoveInternalActor, 3, DirectoryLayer::Node >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MoveInternalActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
[[nodiscard]] Future<Reference<DirectorySubspace>> moveInternal( Reference<DirectoryLayer> const& dirLayer, Reference<Transaction> const& tr, IDirectory::Path const& oldPath, IDirectory::Path const& newPath ) {
															#line 388 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	return Future<Reference<DirectorySubspace>>(new MoveInternalActor(dirLayer, tr, oldPath, newPath));
															#line 5157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
}

#line 438 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"

Future<Reference<DirectorySubspace>> DirectoryLayer::move(Reference<Transaction> const& tr,
                                                          Path const& oldPath,
                                                          Path const& newPath) {
	return moveInternal(Reference<DirectoryLayer>::addRef(this), tr, oldPath, newPath);
}

Future<Reference<DirectorySubspace>> DirectoryLayer::moveTo(Reference<Transaction> const& tr,
                                                            Path const& newAbsolutePath) {
	throw cannot_modify_root_directory();
}

Future<Void> removeRecursive(Reference<DirectoryLayer> const&, Reference<Transaction> const&, Subspace const&);
															#line 5174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
// This generated class is to be used only via removeRecursive()
															#line 451 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
template <class RemoveRecursiveActor>
															#line 451 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class RemoveRecursiveActorState {
															#line 5180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
															#line 451 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	RemoveRecursiveActorState(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,Subspace const& nodeSub) 
															#line 451 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
															#line 451 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		 : dirLayer(dirLayer),
															#line 451 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   tr(tr),
															#line 451 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   nodeSub(nodeSub),
															#line 452 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   subdir(nodeSub.get(DirectoryLayer::SUB_DIR_KEY)),
															#line 453 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   begin(subdir.range().begin),
															#line 454 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   futures()
															#line 5197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("removeRecursive", reinterpret_cast<unsigned long>(this));

	}
	~RemoveRecursiveActorState() 
	{
		fdb_probe_actor_destroy("removeRecursive", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 456 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			;
															#line 5212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RemoveRecursiveActorState();
		static_cast<RemoveRecursiveActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 471 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(futures);
															#line 471 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<RemoveRecursiveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RemoveRecursiveActor*>(this)->actor_wait_state = 2;
															#line 471 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RemoveRecursiveActor, 1, Void >*>(static_cast<RemoveRecursiveActor*>(this)));
															#line 5242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 457 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_0 = tr->getRange(KeyRangeRef(begin, subdir.range().end));
															#line 457 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<RemoveRecursiveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RemoveRecursiveActor*>(this)->actor_wait_state = 1;
															#line 457 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RemoveRecursiveActor, 0, FDBStandalone<RangeResultRef> >*>(static_cast<RemoveRecursiveActor*>(this)));
															#line 5265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(FDBStandalone<RangeResultRef> const& range,int loopDepth) 
	{
															#line 458 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		for(int i = 0;i < range.size();++i) {
															#line 459 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			Subspace subNode = dirLayer->nodeWithPrefix(range[i].value);
															#line 460 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			futures.push_back(removeRecursive(dirLayer, tr, subNode));
															#line 5291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 463 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!range.more)
															#line 5295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 467 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		begin = keyAfter(range.back().key);
															#line 5301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(FDBStandalone<RangeResultRef> && range,int loopDepth) 
	{
															#line 458 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		for(int i = 0;i < range.size();++i) {
															#line 459 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			Subspace subNode = dirLayer->nodeWithPrefix(range[i].value);
															#line 460 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			futures.push_back(removeRecursive(dirLayer, tr, subNode));
															#line 5314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 463 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!range.more)
															#line 5318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 467 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		begin = keyAfter(range.back().key);
															#line 5324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(FDBStandalone<RangeResultRef> const& range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(range, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(FDBStandalone<RangeResultRef> && range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RemoveRecursiveActor*>(this)->actor_wait_state > 0) static_cast<RemoveRecursiveActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveRecursiveActor*>(this)->ActorCallback< RemoveRecursiveActor, 0, FDBStandalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveRecursiveActor, 0, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("removeRecursive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveRecursiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeRecursive", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoveRecursiveActor, 0, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("removeRecursive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveRecursiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeRecursive", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RemoveRecursiveActor, 0, FDBStandalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("removeRecursive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveRecursiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeRecursive", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 473 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		Standalone<StringRef> nodePrefix = dirLayer->nodeSubspace.unpack(nodeSub.key()).getString(0);
															#line 475 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		tr->clear(KeyRangeRef(nodePrefix, strinc(nodePrefix)));
															#line 476 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		tr->clear(nodeSub.range());
															#line 478 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<RemoveRecursiveActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveRecursiveActorState(); static_cast<RemoveRecursiveActor*>(this)->destroy(); return 0; }
															#line 5414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<RemoveRecursiveActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveRecursiveActorState();
		static_cast<RemoveRecursiveActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 473 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		Standalone<StringRef> nodePrefix = dirLayer->nodeSubspace.unpack(nodeSub.key()).getString(0);
															#line 475 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		tr->clear(KeyRangeRef(nodePrefix, strinc(nodePrefix)));
															#line 476 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		tr->clear(nodeSub.range());
															#line 478 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<RemoveRecursiveActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveRecursiveActorState(); static_cast<RemoveRecursiveActor*>(this)->destroy(); return 0; }
															#line 5432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<RemoveRecursiveActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveRecursiveActorState();
		static_cast<RemoveRecursiveActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RemoveRecursiveActor*>(this)->actor_wait_state > 0) static_cast<RemoveRecursiveActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveRecursiveActor*>(this)->ActorCallback< RemoveRecursiveActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveRecursiveActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeRecursive", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveRecursiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeRecursive", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RemoveRecursiveActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeRecursive", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveRecursiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeRecursive", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RemoveRecursiveActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeRecursive", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveRecursiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeRecursive", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 451 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<DirectoryLayer> dirLayer;
															#line 451 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<Transaction> tr;
															#line 451 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Subspace nodeSub;
															#line 452 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Subspace subdir;
															#line 453 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Key begin;
															#line 454 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	std::vector<Future<Void>> futures;
															#line 5527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via removeRecursive()
															#line 451 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class RemoveRecursiveActor final : public Actor<Void>, public ActorCallback< RemoveRecursiveActor, 0, FDBStandalone<RangeResultRef> >, public ActorCallback< RemoveRecursiveActor, 1, Void >, public FastAllocated<RemoveRecursiveActor>, public RemoveRecursiveActorState<RemoveRecursiveActor> {
															#line 5532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
	using FastAllocated<RemoveRecursiveActor>::operator new;
	using FastAllocated<RemoveRecursiveActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8515331088799965440UL, 10982145154217631232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RemoveRecursiveActor, 0, FDBStandalone<RangeResultRef> >;
friend struct ActorCallback< RemoveRecursiveActor, 1, Void >;
															#line 451 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	RemoveRecursiveActor(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,Subspace const& nodeSub) 
															#line 5550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RemoveRecursiveActorState<RemoveRecursiveActor>(dirLayer, tr, nodeSub),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("removeRecursive", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5658360096458586880UL, 16451011458298700288UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveRecursiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("removeRecursive");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("removeRecursive", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RemoveRecursiveActor, 0, FDBStandalone<RangeResultRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RemoveRecursiveActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 451 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
[[nodiscard]] Future<Void> removeRecursive( Reference<DirectoryLayer> const& dirLayer, Reference<Transaction> const& tr, Subspace const& nodeSub ) {
															#line 451 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	return Future<Void>(new RemoveRecursiveActor(dirLayer, tr, nodeSub));
															#line 5583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
}

#line 480 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"

Future<bool> removeInternal(Reference<DirectoryLayer> const&,
                            Reference<Transaction> const&,
                            IDirectory::Path const&,
                            bool const&);
															#line 5592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
// This generated class is to be used only via removeInternal()
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
template <class RemoveInternalActor>
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class RemoveInternalActorState {
															#line 5598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	RemoveInternalActorState(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path,bool const& failOnNonexistent) 
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		 : dirLayer(dirLayer),
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   tr(tr),
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   path(path),
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   failOnNonexistent(failOnNonexistent)
															#line 5611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("removeInternal", reinterpret_cast<unsigned long>(this));

	}
	~RemoveInternalActorState() 
	{
		fdb_probe_actor_destroy("removeInternal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 489 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = dirLayer->checkVersion(tr, true);
															#line 489 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<RemoveInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RemoveInternalActor*>(this)->actor_wait_state = 1;
															#line 489 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RemoveInternalActor, 0, Void >*>(static_cast<RemoveInternalActor*>(this)));
															#line 5633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RemoveInternalActorState();
		static_cast<RemoveInternalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 491 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (path.empty())
															#line 5656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 492 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			return a_body1Catch1(cannot_modify_root_directory(), loopDepth);
															#line 5660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 495 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<DirectoryLayer::Node> __when_expr_1 = find(dirLayer, tr, path);
															#line 495 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<RemoveInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RemoveInternalActor*>(this)->actor_wait_state = 2;
															#line 495 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RemoveInternalActor, 1, DirectoryLayer::Node >*>(static_cast<RemoveInternalActor*>(this)));
															#line 5671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 491 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (path.empty())
															#line 5680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 492 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			return a_body1Catch1(cannot_modify_root_directory(), loopDepth);
															#line 5684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		}
															#line 495 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<DirectoryLayer::Node> __when_expr_1 = find(dirLayer, tr, path);
															#line 495 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<RemoveInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RemoveInternalActor*>(this)->actor_wait_state = 2;
															#line 495 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RemoveInternalActor, 1, DirectoryLayer::Node >*>(static_cast<RemoveInternalActor*>(this)));
															#line 5695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RemoveInternalActor*>(this)->actor_wait_state > 0) static_cast<RemoveInternalActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveInternalActor*>(this)->ActorCallback< RemoveInternalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveInternalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoveInternalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RemoveInternalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 497 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!node.exists())
															#line 5779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 498 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (failOnNonexistent)
															#line 5783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			{
															#line 499 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				return a_body1Catch1(directory_does_not_exist(), loopDepth);
															#line 5787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 501 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
				if (!static_cast<RemoveInternalActor*>(this)->SAV<bool>::futures) { (void)(false); this->~RemoveInternalActorState(); static_cast<RemoveInternalActor*>(this)->destroy(); return 0; }
															#line 5793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
				new (&static_cast<RemoveInternalActor*>(this)->SAV< bool >::value()) bool(false);
				this->~RemoveInternalActorState();
				static_cast<RemoveInternalActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 505 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (node.isInPartition())
															#line 5802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 506 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<bool> __when_expr_2 = removeInternal(node.getContents()->getDirectoryLayer(), tr, node.getPartitionSubpath(), failOnNonexistent);
															#line 506 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<RemoveInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<RemoveInternalActor*>(this)->actor_wait_state = 3;
															#line 506 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RemoveInternalActor, 2, bool >*>(static_cast<RemoveInternalActor*>(this)));
															#line 5813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(DirectoryLayer::Node const& __node,int loopDepth) 
	{
															#line 495 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		node = __node;
															#line 5827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(DirectoryLayer::Node && __node,int loopDepth) 
	{
		node = std::move(__node);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RemoveInternalActor*>(this)->actor_wait_state > 0) static_cast<RemoveInternalActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveInternalActor*>(this)->ActorCallback< RemoveInternalActor, 1, DirectoryLayer::Node >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveInternalActor, 1, DirectoryLayer::Node >*,DirectoryLayer::Node const& value) 
	{
		fdb_probe_actor_enter("removeInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RemoveInternalActor, 1, DirectoryLayer::Node >*,DirectoryLayer::Node && value) 
	{
		fdb_probe_actor_enter("removeInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RemoveInternalActor, 1, DirectoryLayer::Node >*,Error err) 
	{
		fdb_probe_actor_enter("removeInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 511 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		futures = std::vector<Future<Void>>();
															#line 512 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		futures.push_back(removeRecursive(dirLayer, tr, node.subspace.get()));
															#line 513 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		futures.push_back(removeFromParent(dirLayer, tr, path));
															#line 515 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(futures);
															#line 515 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<RemoveInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<RemoveInternalActor*>(this)->actor_wait_state = 4;
															#line 515 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RemoveInternalActor, 3, Void >*>(static_cast<RemoveInternalActor*>(this)));
															#line 5919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(bool const& recurse,int loopDepth) 
	{
															#line 508 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<RemoveInternalActor*>(this)->SAV<bool>::futures) { (void)(recurse); this->~RemoveInternalActorState(); static_cast<RemoveInternalActor*>(this)->destroy(); return 0; }
															#line 5928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<RemoveInternalActor*>(this)->SAV< bool >::value()) bool(recurse);
		this->~RemoveInternalActorState();
		static_cast<RemoveInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(bool && recurse,int loopDepth) 
	{
															#line 508 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<RemoveInternalActor*>(this)->SAV<bool>::futures) { (void)(recurse); this->~RemoveInternalActorState(); static_cast<RemoveInternalActor*>(this)->destroy(); return 0; }
															#line 5940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<RemoveInternalActor*>(this)->SAV< bool >::value()) bool(recurse);
		this->~RemoveInternalActorState();
		static_cast<RemoveInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(bool const& recurse,int loopDepth) 
	{
		loopDepth = a_body1cont8(recurse, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(bool && recurse,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(recurse), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RemoveInternalActor*>(this)->actor_wait_state > 0) static_cast<RemoveInternalActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveInternalActor*>(this)->ActorCallback< RemoveInternalActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveInternalActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("removeInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RemoveInternalActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("removeInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RemoveInternalActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("removeInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 517 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<RemoveInternalActor*>(this)->SAV<bool>::futures) { (void)(true); this->~RemoveInternalActorState(); static_cast<RemoveInternalActor*>(this)->destroy(); return 0; }
															#line 6027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<RemoveInternalActor*>(this)->SAV< bool >::value()) bool(true);
		this->~RemoveInternalActorState();
		static_cast<RemoveInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 517 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<RemoveInternalActor*>(this)->SAV<bool>::futures) { (void)(true); this->~RemoveInternalActorState(); static_cast<RemoveInternalActor*>(this)->destroy(); return 0; }
															#line 6039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<RemoveInternalActor*>(this)->SAV< bool >::value()) bool(true);
		this->~RemoveInternalActorState();
		static_cast<RemoveInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RemoveInternalActor*>(this)->actor_wait_state > 0) static_cast<RemoveInternalActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveInternalActor*>(this)->ActorCallback< RemoveInternalActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveInternalActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RemoveInternalActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RemoveInternalActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeInternal", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<DirectoryLayer> dirLayer;
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<Transaction> tr;
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	IDirectory::Path path;
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	bool failOnNonexistent;
															#line 495 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	DirectoryLayer::Node node;
															#line 511 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	std::vector<Future<Void>> futures;
															#line 6134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via removeInternal()
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class RemoveInternalActor final : public Actor<bool>, public ActorCallback< RemoveInternalActor, 0, Void >, public ActorCallback< RemoveInternalActor, 1, DirectoryLayer::Node >, public ActorCallback< RemoveInternalActor, 2, bool >, public ActorCallback< RemoveInternalActor, 3, Void >, public FastAllocated<RemoveInternalActor>, public RemoveInternalActorState<RemoveInternalActor> {
															#line 6139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
	using FastAllocated<RemoveInternalActor>::operator new;
	using FastAllocated<RemoveInternalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13601148587460677632UL, 11837855270041414400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RemoveInternalActor, 0, Void >;
friend struct ActorCallback< RemoveInternalActor, 1, DirectoryLayer::Node >;
friend struct ActorCallback< RemoveInternalActor, 2, bool >;
friend struct ActorCallback< RemoveInternalActor, 3, Void >;
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	RemoveInternalActor(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path,bool const& failOnNonexistent) 
															#line 6159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   RemoveInternalActorState<RemoveInternalActor>(dirLayer, tr, path, failOnNonexistent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("removeInternal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(879484265316086016UL, 14704046601444673792UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("removeInternal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("removeInternal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RemoveInternalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RemoveInternalActor, 1, DirectoryLayer::Node >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RemoveInternalActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RemoveInternalActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
[[nodiscard]] Future<bool> removeInternal( Reference<DirectoryLayer> const& dirLayer, Reference<Transaction> const& tr, IDirectory::Path const& path, bool const& failOnNonexistent ) {
															#line 485 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	return Future<bool>(new RemoveInternalActor(dirLayer, tr, path, failOnNonexistent));
															#line 6194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
}

#line 519 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"

Future<Void> DirectoryLayer::remove(Reference<Transaction> const& tr, Path const& path) {
	return success(removeInternal(Reference<DirectoryLayer>::addRef(this), tr, path, true));
}

Future<bool> DirectoryLayer::removeIfExists(Reference<Transaction> const& tr, Path const& path) {
	return removeInternal(Reference<DirectoryLayer>::addRef(this), tr, path, false);
}

															#line 6207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
// This generated class is to be used only via existsInternal()
															#line 528 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
template <class ExistsInternalActor>
															#line 528 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class ExistsInternalActorState {
															#line 6213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
															#line 528 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	ExistsInternalActorState(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path) 
															#line 528 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
															#line 528 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		 : dirLayer(dirLayer),
															#line 528 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   tr(tr),
															#line 528 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		   path(path)
															#line 6224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("existsInternal", reinterpret_cast<unsigned long>(this));

	}
	~ExistsInternalActorState() 
	{
		fdb_probe_actor_destroy("existsInternal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 531 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = dirLayer->checkVersion(tr, false);
															#line 531 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<ExistsInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ExistsInternalActor*>(this)->actor_wait_state = 1;
															#line 531 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExistsInternalActor, 0, Void >*>(static_cast<ExistsInternalActor*>(this)));
															#line 6246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExistsInternalActorState();
		static_cast<ExistsInternalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 533 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<DirectoryLayer::Node> __when_expr_1 = find(dirLayer, tr, path);
															#line 533 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<ExistsInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExistsInternalActor*>(this)->actor_wait_state = 2;
															#line 533 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExistsInternalActor, 1, DirectoryLayer::Node >*>(static_cast<ExistsInternalActor*>(this)));
															#line 6276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 533 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		StrictFuture<DirectoryLayer::Node> __when_expr_1 = find(dirLayer, tr, path);
															#line 533 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (static_cast<ExistsInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExistsInternalActor*>(this)->actor_wait_state = 2;
															#line 533 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExistsInternalActor, 1, DirectoryLayer::Node >*>(static_cast<ExistsInternalActor*>(this)));
															#line 6292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExistsInternalActor*>(this)->actor_wait_state > 0) static_cast<ExistsInternalActor*>(this)->actor_wait_state = 0;
		static_cast<ExistsInternalActor*>(this)->ActorCallback< ExistsInternalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExistsInternalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("existsInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExistsInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("existsInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExistsInternalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("existsInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExistsInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("existsInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExistsInternalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("existsInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExistsInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("existsInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(DirectoryLayer::Node const& node,int loopDepth) 
	{
															#line 535 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!node.exists())
															#line 6376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 536 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!static_cast<ExistsInternalActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ExistsInternalActorState(); static_cast<ExistsInternalActor*>(this)->destroy(); return 0; }
															#line 6380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			new (&static_cast<ExistsInternalActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ExistsInternalActorState();
			static_cast<ExistsInternalActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 539 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (node.isInPartition())
															#line 6388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 540 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<bool> __when_expr_2 = node.getContents()->getDirectoryLayer()->exists(tr, node.getPartitionSubpath());
															#line 540 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<ExistsInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<ExistsInternalActor*>(this)->actor_wait_state = 3;
															#line 540 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExistsInternalActor, 2, bool >*>(static_cast<ExistsInternalActor*>(this)));
															#line 6399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(DirectoryLayer::Node && node,int loopDepth) 
	{
															#line 535 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!node.exists())
															#line 6413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 536 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (!static_cast<ExistsInternalActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ExistsInternalActorState(); static_cast<ExistsInternalActor*>(this)->destroy(); return 0; }
															#line 6417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			new (&static_cast<ExistsInternalActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ExistsInternalActorState();
			static_cast<ExistsInternalActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 539 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (node.isInPartition())
															#line 6425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		{
															#line 540 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			StrictFuture<bool> __when_expr_2 = node.getContents()->getDirectoryLayer()->exists(tr, node.getPartitionSubpath());
															#line 540 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			if (static_cast<ExistsInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<ExistsInternalActor*>(this)->actor_wait_state = 3;
															#line 540 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExistsInternalActor, 2, bool >*>(static_cast<ExistsInternalActor*>(this)));
															#line 6436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(DirectoryLayer::Node const& node,int loopDepth) 
	{
		loopDepth = a_body1cont2(node, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(DirectoryLayer::Node && node,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(node), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExistsInternalActor*>(this)->actor_wait_state > 0) static_cast<ExistsInternalActor*>(this)->actor_wait_state = 0;
		static_cast<ExistsInternalActor*>(this)->ActorCallback< ExistsInternalActor, 1, DirectoryLayer::Node >::remove();

	}
	void a_callback_fire(ActorCallback< ExistsInternalActor, 1, DirectoryLayer::Node >*,DirectoryLayer::Node const& value) 
	{
		fdb_probe_actor_enter("existsInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExistsInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("existsInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExistsInternalActor, 1, DirectoryLayer::Node >*,DirectoryLayer::Node && value) 
	{
		fdb_probe_actor_enter("existsInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExistsInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("existsInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExistsInternalActor, 1, DirectoryLayer::Node >*,Error err) 
	{
		fdb_probe_actor_enter("existsInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExistsInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("existsInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 544 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<ExistsInternalActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ExistsInternalActorState(); static_cast<ExistsInternalActor*>(this)->destroy(); return 0; }
															#line 6525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<ExistsInternalActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ExistsInternalActorState();
		static_cast<ExistsInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(bool const& exists,int loopDepth) 
	{
															#line 541 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<ExistsInternalActor*>(this)->SAV<bool>::futures) { (void)(exists); this->~ExistsInternalActorState(); static_cast<ExistsInternalActor*>(this)->destroy(); return 0; }
															#line 6537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<ExistsInternalActor*>(this)->SAV< bool >::value()) bool(exists);
		this->~ExistsInternalActorState();
		static_cast<ExistsInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(bool && exists,int loopDepth) 
	{
															#line 541 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
		if (!static_cast<ExistsInternalActor*>(this)->SAV<bool>::futures) { (void)(exists); this->~ExistsInternalActorState(); static_cast<ExistsInternalActor*>(this)->destroy(); return 0; }
															#line 6549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		new (&static_cast<ExistsInternalActor*>(this)->SAV< bool >::value()) bool(exists);
		this->~ExistsInternalActorState();
		static_cast<ExistsInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(bool const& exists,int loopDepth) 
	{
		loopDepth = a_body1cont5(exists, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(bool && exists,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(exists), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ExistsInternalActor*>(this)->actor_wait_state > 0) static_cast<ExistsInternalActor*>(this)->actor_wait_state = 0;
		static_cast<ExistsInternalActor*>(this)->ActorCallback< ExistsInternalActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ExistsInternalActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("existsInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExistsInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("existsInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExistsInternalActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("existsInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExistsInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("existsInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ExistsInternalActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("existsInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExistsInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("existsInternal", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 528 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<DirectoryLayer> dirLayer;
															#line 528 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	Reference<Transaction> tr;
															#line 528 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	IDirectory::Path path;
															#line 6638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via existsInternal()
															#line 528 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
class ExistsInternalActor final : public Actor<bool>, public ActorCallback< ExistsInternalActor, 0, Void >, public ActorCallback< ExistsInternalActor, 1, DirectoryLayer::Node >, public ActorCallback< ExistsInternalActor, 2, bool >, public FastAllocated<ExistsInternalActor>, public ExistsInternalActorState<ExistsInternalActor> {
															#line 6643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ExistsInternalActor>::operator new;
	using FastAllocated<ExistsInternalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17093176092596754688UL, 16590621109007780352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExistsInternalActor, 0, Void >;
friend struct ActorCallback< ExistsInternalActor, 1, DirectoryLayer::Node >;
friend struct ActorCallback< ExistsInternalActor, 2, bool >;
															#line 528 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	ExistsInternalActor(Reference<DirectoryLayer> const& dirLayer,Reference<Transaction> const& tr,IDirectory::Path const& path) 
															#line 6662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   ExistsInternalActorState<ExistsInternalActor>(dirLayer, tr, path),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("existsInternal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14594172515342123264UL, 14741898299127066880UL);
		ActorExecutionContextHelper __helper(static_cast<ExistsInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("existsInternal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("existsInternal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExistsInternalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExistsInternalActor, 1, DirectoryLayer::Node >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ExistsInternalActor, 2, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 528 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
[[nodiscard]] Future<bool> existsInternal( Reference<DirectoryLayer> const& dirLayer, Reference<Transaction> const& tr, IDirectory::Path const& path ) {
															#line 528 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"
	return Future<bool>(new ExistsInternalActor(dirLayer, tr, path));
															#line 6696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/bindings/flow/DirectoryLayer.actor.g.cpp.py_gen"
}

#line 546 "/Users/ec2-user/foundationdb/bindings/flow/DirectoryLayer.actor.cpp"

Future<bool> DirectoryLayer::exists(Reference<Transaction> const& tr, Path const& path) {
	return existsInternal(Reference<DirectoryLayer>::addRef(this), tr, path);
}

Reference<DirectoryLayer> DirectoryLayer::getDirectoryLayer() {
	return Reference<DirectoryLayer>::addRef(this);
}

const Standalone<StringRef> DirectoryLayer::getLayer() const {
	return StringRef();
}

const IDirectory::Path DirectoryLayer::getPath() const {
	return path;
}
} // namespace FDB
