#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
/*
 * SaveAndKill.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbrpc/simulator.h"
#include "flow/Knobs.h"

#include "boost/algorithm/string/predicate.hpp"
#include "flow/IConnection.h"
#include "fdbrpc/SimulatorProcessInfo.h"

#undef state
#include "fdbclient/SimpleIni.h"
#define state
#undef max
#undef min
#include "flow/actorcompiler.h" // This must be the last #include.

struct SaveAndKillWorkload : TestWorkload {
	static constexpr auto NAME = "SaveAndKill";

	std::string restartInfo;
	double testDuration;
	int isRestoring;

	SaveAndKillWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		restartInfo = getOption(options, "restartInfoLocation"_sr, "simfdb/restartInfo.ini"_sr).toString();
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		isRestoring = getOption(options, "isRestoring"_sr, 0);
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.insert("all"); }
	Future<Void> setup(Database const& cx) override {
		g_simulator->disableSwapsToAll();
		return Void();
	}
	Future<Void> start(Database const& cx) override { return _start(this, cx); }

																#line 63 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
template <class _startActor>
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
class _startActorState {
															#line 69 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
public:
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
	_startActorState(SaveAndKillWorkload* const& self,Database const& cx) 
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		 : self(self),
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		   cx(cx),
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		   i()
															#line 80 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(deterministicRandom()->random01() * self->testDuration);
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 97 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		StrictFuture<DatabaseConfiguration> __when_expr_1 = getDatabaseConfiguration(cx);
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, DatabaseConfiguration >*>(static_cast<_startActor*>(this)));
															#line 132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		StrictFuture<DatabaseConfiguration> __when_expr_1 = getDatabaseConfiguration(cx);
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, DatabaseConfiguration >*>(static_cast<_startActor*>(this)));
															#line 148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(DatabaseConfiguration const& config,int loopDepth) 
	{
															#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		CSimpleIni ini;
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetUnicode();
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.LoadFile(self->restartInfo.c_str());
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("RESTORE", "isRestoring", format("%d", self->isRestoring).c_str());
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "processesPerMachine", format("%d", g_simulator->processesPerMachine).c_str());
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "listenersPerProcess", format("%d", g_simulator->listenersPerProcess).c_str());
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "desiredCoordinators", format("%d", g_simulator->desiredCoordinators).c_str());
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "connectionString", g_simulator->connectionString.c_str());
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "testerCount", format("%d", g_simulator->testerCount).c_str());
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "tssMode", format("%d", g_simulator->tssMode).c_str());
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "mockDNS", INetworkConnections::net()->convertMockDNSToString().c_str());
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "tenantMode", config.tenantMode.toString().c_str());
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		if (cx->defaultTenant.present())
															#line 256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		{
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			ini.SetValue("META", "defaultTenant", cx->defaultTenant.get().toString().c_str());
															#line 260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		}
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetBoolValue("META", "enableShardEncodeLocationMetadata", SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetBoolValue("META", "encryptHeaderAuthTokenEnabled", FLOW_KNOBS->ENCRYPT_HEADER_AUTH_TOKEN_ENABLED);
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetLongValue("META", "encryptHeaderAuthTokenAlgo", FLOW_KNOBS->ENCRYPT_HEADER_AUTH_TOKEN_ALGO);
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		std::vector<ISimulator::ProcessInfo*> processes = g_simulator->getAllProcesses();
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		std::map<NetworkAddress, ISimulator::ProcessInfo*> rebootingProcesses = g_simulator->currentlyRebootingProcesses;
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		std::map<std::string, ISimulator::ProcessInfo*> allProcessesMap;
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		for( const auto& [_, process] : rebootingProcesses ) {
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			if (allProcessesMap.find(process->dataFolder) == allProcessesMap.end() && !process->isSpawnedKVProcess())
															#line 278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
			{
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
				allProcessesMap[process->dataFolder] = process;
															#line 282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
			}
		}
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		for( const auto& process : processes ) {
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			if (allProcessesMap.find(process->dataFolder) == allProcessesMap.end() && !process->isSpawnedKVProcess())
															#line 289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
			{
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
				allProcessesMap[process->dataFolder] = process;
															#line 293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
			}
		}
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "processCount", format("%d", allProcessesMap.size() - 1).c_str());
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		std::map<std::string, int> machines;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		int j = 0;
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		for( const auto& [_, process] : allProcessesMap ) {
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			std::string machineId = printable(process->locality.machineId());
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			const char* machineIdString = machineId.c_str();
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			if (!process->excludeFromRestarts)
															#line 310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
			{
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
				if (machines.find(machineId) == machines.end())
															#line 314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
				{
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					machines.insert(std::pair<std::string, int>(machineId, 1));
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue("META", format("%d", j).c_str(), machineIdString);
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue( machineIdString, "dcUID", (process->locality.dcId().present()) ? process->locality.dcId().get().printable().c_str() : "");
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue(machineIdString, "zoneId", (process->locality.zoneId().present()) ? process->locality.zoneId().get().printable().c_str() : "");
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue(machineIdString, "mClass", format("%d", process->startingClass.classType()).c_str());
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue(machineIdString, format("ipAddr%d", process->address.port - 1).c_str(), process->address.ip.toString().c_str());
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue( machineIdString, format("%d", process->address.port - 1).c_str(), process->dataFolder.c_str());
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue(machineIdString, format("c%d", process->address.port - 1).c_str(), process->coordinationFolder.c_str());
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					j++;
															#line 334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
				}
				else
				{
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue(machineIdString, format("ipAddr%d", process->address.port - 1).c_str(), process->address.ip.toString().c_str());
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					int oldValue = machines.find(machineId)->second;
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue( machineIdString, format("%d", process->address.port - 1).c_str(), process->dataFolder.c_str());
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue(machineIdString, format("c%d", process->address.port - 1).c_str(), process->coordinationFolder.c_str());
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					machines.erase(machines.find(machineId));
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					machines.insert(std::pair<std::string, int>(machineId, oldValue + 1));
															#line 350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
				}
			}
		}
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		for(auto entry = machines.begin();entry != machines.end();entry++) {
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			ini.SetValue((*entry).first.c_str(), "processes", format("%d", (*entry).second).c_str());
															#line 358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		}
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "machineCount", format("%d", machines.size()).c_str());
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SaveFile(self->restartInfo.c_str());
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		for(auto process = allProcessesMap.begin();process != allProcessesMap.end();process++) {
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			g_simulator->killProcess(process->second, ISimulator::KillType::Reboot);
															#line 368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		}
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		i = 0;
															#line 372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(DatabaseConfiguration && config,int loopDepth) 
	{
															#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		CSimpleIni ini;
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetUnicode();
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.LoadFile(self->restartInfo.c_str());
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("RESTORE", "isRestoring", format("%d", self->isRestoring).c_str());
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "processesPerMachine", format("%d", g_simulator->processesPerMachine).c_str());
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "listenersPerProcess", format("%d", g_simulator->listenersPerProcess).c_str());
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "desiredCoordinators", format("%d", g_simulator->desiredCoordinators).c_str());
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "connectionString", g_simulator->connectionString.c_str());
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "testerCount", format("%d", g_simulator->testerCount).c_str());
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "tssMode", format("%d", g_simulator->tssMode).c_str());
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "mockDNS", INetworkConnections::net()->convertMockDNSToString().c_str());
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "tenantMode", config.tenantMode.toString().c_str());
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		if (cx->defaultTenant.present())
															#line 405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		{
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			ini.SetValue("META", "defaultTenant", cx->defaultTenant.get().toString().c_str());
															#line 409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		}
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetBoolValue("META", "enableShardEncodeLocationMetadata", SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetBoolValue("META", "encryptHeaderAuthTokenEnabled", FLOW_KNOBS->ENCRYPT_HEADER_AUTH_TOKEN_ENABLED);
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetLongValue("META", "encryptHeaderAuthTokenAlgo", FLOW_KNOBS->ENCRYPT_HEADER_AUTH_TOKEN_ALGO);
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		std::vector<ISimulator::ProcessInfo*> processes = g_simulator->getAllProcesses();
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		std::map<NetworkAddress, ISimulator::ProcessInfo*> rebootingProcesses = g_simulator->currentlyRebootingProcesses;
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		std::map<std::string, ISimulator::ProcessInfo*> allProcessesMap;
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		for( const auto& [_, process] : rebootingProcesses ) {
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			if (allProcessesMap.find(process->dataFolder) == allProcessesMap.end() && !process->isSpawnedKVProcess())
															#line 427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
			{
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
				allProcessesMap[process->dataFolder] = process;
															#line 431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
			}
		}
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		for( const auto& process : processes ) {
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			if (allProcessesMap.find(process->dataFolder) == allProcessesMap.end() && !process->isSpawnedKVProcess())
															#line 438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
			{
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
				allProcessesMap[process->dataFolder] = process;
															#line 442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
			}
		}
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "processCount", format("%d", allProcessesMap.size() - 1).c_str());
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		std::map<std::string, int> machines;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		int j = 0;
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		for( const auto& [_, process] : allProcessesMap ) {
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			std::string machineId = printable(process->locality.machineId());
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			const char* machineIdString = machineId.c_str();
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			if (!process->excludeFromRestarts)
															#line 459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
			{
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
				if (machines.find(machineId) == machines.end())
															#line 463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
				{
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					machines.insert(std::pair<std::string, int>(machineId, 1));
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue("META", format("%d", j).c_str(), machineIdString);
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue( machineIdString, "dcUID", (process->locality.dcId().present()) ? process->locality.dcId().get().printable().c_str() : "");
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue(machineIdString, "zoneId", (process->locality.zoneId().present()) ? process->locality.zoneId().get().printable().c_str() : "");
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue(machineIdString, "mClass", format("%d", process->startingClass.classType()).c_str());
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue(machineIdString, format("ipAddr%d", process->address.port - 1).c_str(), process->address.ip.toString().c_str());
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue( machineIdString, format("%d", process->address.port - 1).c_str(), process->dataFolder.c_str());
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue(machineIdString, format("c%d", process->address.port - 1).c_str(), process->coordinationFolder.c_str());
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					j++;
															#line 483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
				}
				else
				{
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue(machineIdString, format("ipAddr%d", process->address.port - 1).c_str(), process->address.ip.toString().c_str());
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					int oldValue = machines.find(machineId)->second;
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue( machineIdString, format("%d", process->address.port - 1).c_str(), process->dataFolder.c_str());
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					ini.SetValue(machineIdString, format("c%d", process->address.port - 1).c_str(), process->coordinationFolder.c_str());
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					machines.erase(machines.find(machineId));
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
					machines.insert(std::pair<std::string, int>(machineId, oldValue + 1));
															#line 499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
				}
			}
		}
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		for(auto entry = machines.begin();entry != machines.end();entry++) {
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			ini.SetValue((*entry).first.c_str(), "processes", format("%d", (*entry).second).c_str());
															#line 507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		}
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SetValue("META", "machineCount", format("%d", machines.size()).c_str());
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		ini.SaveFile(self->restartInfo.c_str());
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		for(auto process = allProcessesMap.begin();process != allProcessesMap.end();process++) {
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
			g_simulator->killProcess(process->second, ISimulator::KillType::Reboot);
															#line 517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		}
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		i = 0;
															#line 521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(DatabaseConfiguration const& config,int loopDepth) 
	{
		loopDepth = a_body1cont2(config, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(DatabaseConfiguration && config,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(config), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		g_simulator->stop();
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		if (!(i < 100))
															#line 626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0.0);
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		i++;
															#line 661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
		i++;
															#line 670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
	SaveAndKillWorkload* self;
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
	Database cx;
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
	int i;
															#line 756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, DatabaseConfiguration >, public ActorCallback< _startActor, 2, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16421891235034190080UL, 5290812577648194816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, DatabaseConfiguration >;
friend struct ActorCallback< _startActor, 2, Void >;
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
	_startActor(SaveAndKillWorkload* const& self,Database const& cx) 
															#line 780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
[[nodiscard]] Future<Void> _start( SaveAndKillWorkload* const& self, Database const& cx ) {
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SaveAndKill.actor.g.cpp"
}

#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/SaveAndKill.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>&) override {}
};

WorkloadFactory<SaveAndKillWorkload> SaveAndKillWorkloadFactory;
