#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
/*
 * ConsistencyCheck.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <math.h>
#include "boost/lexical_cast.hpp"

#include "flow/IRandom.h"
#include "flow/ProcessEvents.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/FDBTypes.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/IRateControl.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/StorageMetrics.actor.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/TSSMappingUtil.actor.h"
#include "flow/DeterministicRandom.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/StorageServerInterface.h"
#include "flow/network.h"
#include "fdbrpc/SimulatorProcessInfo.h"

#include "flow/actorcompiler.h" // This must be the last #include.

// #define SevCCheckInfo SevVerbose
#define SevCCheckInfo SevInfo

struct ConsistencyCheckWorkload : TestWorkload {
	struct OnTimeout {
		ConsistencyCheckWorkload& self;
		explicit OnTimeout(ConsistencyCheckWorkload& self) : self(self) {}
		void operator()(StringRef name, std::any const& msg, Error const& e) {
			TraceEvent(SevError, "ConsistencyCheckFailure")
			    .error(e)
			    .detail("EventName", name)
			    .detail("EventMessage", std::any_cast<StringRef>(msg))
			    .log();
		}
	};

	static constexpr auto NAME = "ConsistencyCheck";
	// Whether or not we should perform checks that will only pass if the database is in a quiescent state
	bool performQuiescentChecks;

	// Whether or not perform consistency check between storage cache servers and storage servers
	bool performCacheCheck;

	// Whether or not to perform consistency check between storage servers and pair TSS
	bool performTSSCheck;

	// How long to wait for the database to go quiet before failing (if doing quiescent checks)
	double quiescentWaitTimeout;

	// If true, then perform all checks on this client.  The first client is the only one to perform all of the fast
	// checks All other clients will perform slow checks if this test is distributed
	bool firstClient;

	// If true, then the expensive checks will be distributed to multiple clients
	bool distributed;

	// Determines how many shards are checked for consistency: out of every <shardSampleFactor> shards, 1 will be
	// checked
	int shardSampleFactor;

	// The previous data distribution mode
	int oldDataDistributionMode;

	// If true, then any failure of the consistency check will be logged as SevError.  Otherwise, it will be logged as
	// SevWarn
	bool failureIsError;

	// Max number of bytes per second to read from each storage server
	int rateLimitMax;

	// DataSet Size
	int64_t bytesReadInPreviousRound;

	// Randomize shard order with each iteration if true
	bool shuffleShards;

	bool success;

	// Number of times this client has run its portion of the consistency check
	int64_t repetitions;

	// Whether to continuously perform the consistency check
	bool indefinite;

	// Whether to suspendConsistencyCheck
	AsyncVar<bool> suspendConsistencyCheck;

	Future<Void> monitorConsistencyCheckSettingsActor;

	OnTimeout onTimeout;
	ProcessEvents::Event onTimeoutEvent;

	ConsistencyCheckWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), onTimeout(*this), onTimeoutEvent({ "Timeout"_sr, "TracedTooManyLines"_sr }, onTimeout) {
		performQuiescentChecks = getOption(options, "performQuiescentChecks"_sr, false);
		performCacheCheck = getOption(options, "performCacheCheck"_sr, false);
		performTSSCheck = getOption(options, "performTSSCheck"_sr, true);
		quiescentWaitTimeout = getOption(options, "quiescentWaitTimeout"_sr, 600.0);
		distributed = getOption(options, "distributed"_sr, true);
		shardSampleFactor = std::max(getOption(options, "shardSampleFactor"_sr, 1), 1);
		failureIsError = getOption(options, "failureIsError"_sr, false);
		rateLimitMax = getOption(options, "rateLimitMax"_sr, 0);
		shuffleShards = getOption(options, "shuffleShards"_sr, false);
		indefinite = getOption(options, "indefinite"_sr, false);
		suspendConsistencyCheck.set(true);

		success = true;

		firstClient = clientId == 0;

		repetitions = 0;
		bytesReadInPreviousRound = 0;
	}

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }

																#line 143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class _setupActor>
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class _setupActorState {
															#line 149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	_setupActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (self->firstClient && self->performQuiescentChecks)
															#line 173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (g_network->isSimulated())
															#line 177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					StrictFuture<Void> __when_expr_0 = timeKeeperSetDisable(cx);
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		self->monitorConsistencyCheckSettingsActor = self->monitorConsistencyCheckSettings(cx, self);
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		try {
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeoutError(quietDatabase(cx, self->dbInfo, "ConsistencyCheckStart", 0, 1e5, 0, 0), self->quiescentWaitTimeout);
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_QuietDatabaseError").error(e);
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Unable to achieve a quiet database");
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->performQuiescentChecks = false;
															#line 356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (g_network->isSimulated())
															#line 371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			g_simulator->quiesced = true;
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheckQuiesced").detail("Quiesced", g_simulator->quiesced);
															#line 377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (g_network->isSimulated())
															#line 387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			g_simulator->quiesced = true;
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheckQuiesced").detail("Quiesced", g_simulator->quiesced);
															#line 393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17369431125934751488UL, 12620981476070585600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	_setupActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	Future<Void> start(Database const& cx) override {
		TraceEvent("ConsistencyCheck").log();
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return success; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	void testFailure(std::string message, bool isError = false) {
		success = false;

		TraceEvent failEvent((failureIsError || isError) ? SevError : SevWarn, "TestFailure");
		if (performQuiescentChecks)
			failEvent.detail("Workload", "QuiescentCheck");
		else
			failEvent.detail("Workload", "ConsistencyCheck");

		failEvent.detail("Reason", "Consistency check: " + message);
	}

																#line 573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via monitorConsistencyCheckSettings()
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class MonitorConsistencyCheckSettingsActor>
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class MonitorConsistencyCheckSettingsActorState {
															#line 579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	MonitorConsistencyCheckSettingsActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this));

	}
	~MonitorConsistencyCheckSettingsActorState() 
	{
		fdb_probe_actor_destroy("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorConsistencyCheckSettingsActorState();
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		try {
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(fdbShouldConsistencyCheckBeSuspended);
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 1;
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 4;
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		bool ccSuspend = ccSuspendVal.present() ? BinaryReader::fromStringRef<bool>(ccSuspendVal.get(), Unversioned()) : false;
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		self->suspendConsistencyCheck.set(ccSuspend);
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		watchCCSuspendFuture = tr.watch(fdbShouldConsistencyCheckBeSuspended);
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 2;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __ccSuspendVal,int loopDepth) 
	{
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ccSuspendVal = __ccSuspendVal;
															#line 716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __ccSuspendVal,int loopDepth) 
	{
		ccSuspendVal = std::move(__ccSuspendVal);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchCCSuspendFuture;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 3;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchCCSuspendFuture;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 3;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Optional<Value> ccSuspendVal;
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Future<Void> watchCCSuspendFuture;
															#line 1095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via monitorConsistencyCheckSettings()
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class MonitorConsistencyCheckSettingsActor final : public Actor<Void>, public ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >, public ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >, public ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >, public ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >, public FastAllocated<MonitorConsistencyCheckSettingsActor>, public MonitorConsistencyCheckSettingsActorState<MonitorConsistencyCheckSettingsActor> {
															#line 1100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<MonitorConsistencyCheckSettingsActor>::operator new;
	using FastAllocated<MonitorConsistencyCheckSettingsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14340083961120975616UL, 2779835961862980608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >;
friend struct ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >;
friend struct ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	MonitorConsistencyCheckSettingsActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 1120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorConsistencyCheckSettingsActorState<MonitorConsistencyCheckSettingsActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16598048751331225600UL, 3236326283404452096UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorConsistencyCheckSettings");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<Void> monitorConsistencyCheckSettings( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<Void>(new MonitorConsistencyCheckSettingsActor(cx, self));
															#line 1155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

																#line 1160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class _startActor>
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class _startActorState {
															#line 1166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	_startActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 1175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 1190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (self->firstClient && g_network->isSimulated() && self->performQuiescentChecks)
															#line 1213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			g_simulator->quiesced = false;
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheckQuiescedEnd").detail("Quiesced", g_simulator->quiesced);
															#line 1219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		;
															#line 1242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("ConsistencyCheck_StartingOrResuming").log();
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->runCheck(cx, self);
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->suspendConsistencyCheck.onChange();
															#line 1272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(self->suspendConsistencyCheck.get()))
															#line 1295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("ConsistencyCheck_Suspended").log();
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->suspendConsistencyCheck.onChange();
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!self->indefinite)
															#line 1425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		self->repetitions++;
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(5.0);
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!self->indefinite)
															#line 1449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		self->repetitions++;
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(5.0);
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	int a_body1loopBody1cont1when1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 1693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 2, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11516016626535419392UL, 6016995631603916800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	_startActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 1718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

																#line 1757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via runCheck()
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class RunCheckActor>
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class RunCheckActorState {
															#line 1763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	RunCheckActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 1772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("runCheck", reinterpret_cast<unsigned long>(this));

	}
	~RunCheckActorState() 
	{
		fdb_probe_actor_destroy("runCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			CODE_PROBE(self->performQuiescentChecks, "Quiescent consistency check");
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			CODE_PROBE(!self->performQuiescentChecks, "Non-quiescent consistency check");
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			consistenyCheckerBeginTime = now();
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (self->firstClient || self->distributed)
															#line 1793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
				try {
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					configuration = DatabaseConfiguration();
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					tssMapping = std::map<UID, StorageServerInterface>();
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					tr = Transaction(cx);
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					;
															#line 1806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					loopDepth = a_body1loopHead1(loopDepth);
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunCheckActorState();
		static_cast<RunCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("ConsistencyCheck_FinishedCheck") .detail("Repetitions", self->repetitions) .detail("TimeSpan", now() - consistenyCheckerBeginTime);
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<RunCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCheckActorState(); static_cast<RunCheckActor*>(this)->destroy(); return 0; }
															#line 1842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<RunCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunCheckActorState();
		static_cast<RunCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (e.code() == error_code_transaction_too_old || e.code() == error_code_future_version || e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed || e.code() == error_code_process_behind || e.code() == error_code_actor_cancelled)
															#line 1861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_Retry") .error(e);
															#line 1865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
			else
			{
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				self->testFailure(format("Error %d - %s", e.code(), e.name()));
															#line 1871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (self->firstClient && self->performQuiescentChecks)
															#line 1887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<bool> __when_expr_3 = self->checkForUndesirableServers(cx, configuration, self);
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 4;
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 3, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 1898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (self->performTSSCheck)
															#line 1920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				tssMapping.clear();
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				StrictFuture<Void> __when_expr_0 = readTSSMapping(&tr, &tssMapping);
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunCheckActor*>(this)->actor_wait_state = 1;
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 0, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 1933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 3;
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 2, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 1980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(configKeys, 1000);
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 2;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 1, RangeResult >*>(static_cast<RunCheckActor*>(this)));
															#line 2002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(RangeResult const& res,int loopDepth) 
	{
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (res.size() == 1000)
															#line 2098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_TooManyConfigOptions").log();
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Read too many configuration options");
															#line 2104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < res.size();i++) {
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			configuration.set(res[i].key, res[i].value);
															#line 2110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(RangeResult && res,int loopDepth) 
	{
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (res.size() == 1000)
															#line 2120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_TooManyConfigOptions").log();
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Read too many configuration options");
															#line 2126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < res.size();i++) {
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			configuration.set(res[i].key, res[i].value);
															#line 2132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		keyServerPromise = Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>>();
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_16 = getKeyServers(cx, keyServerPromise, keyServersKeys, self->performQuiescentChecks, self->failureIsError, &self->success);
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch2(__when_expr_16.getError(), loopDepth); else return a_body1cont4when1(__when_expr_16.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 17;
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 16, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 2313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<int64_t> __when_expr_4 = getDataDistributionQueueSize(cx, self->dbInfo, true);
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 5;
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 4, int64_t >*>(static_cast<RunCheckActor*>(this)));
															#line 2329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(bool const& __hasUndesirableServers,int loopDepth) 
	{
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		hasUndesirableServers = __hasUndesirableServers;
															#line 2338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(bool && __hasUndesirableServers,int loopDepth) 
	{
		hasUndesirableServers = std::move(__hasUndesirableServers);
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(int64_t const& inDataDistributionQueue,int loopDepth) 
	{
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (inDataDistributionQueue > 0)
															#line 2417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NonZeroDataDistributionQueue") .detail("QueueSize", inDataDistributionQueue);
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Non-zero data distribution queue/in-flight size");
															#line 2423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_5 = getTeamCollectionValid(cx, self->dbInfo);
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 6;
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 5, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 2434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(int64_t && inDataDistributionQueue,int loopDepth) 
	{
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (inDataDistributionQueue > 0)
															#line 2443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NonZeroDataDistributionQueue") .detail("QueueSize", inDataDistributionQueue);
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Non-zero data distribution queue/in-flight size");
															#line 2449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_5 = getTeamCollectionValid(cx, self->dbInfo);
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 6;
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 5, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 2460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(int64_t const& inDataDistributionQueue,int loopDepth) 
	{
		loopDepth = a_body1cont6(inDataDistributionQueue, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(int64_t && inDataDistributionQueue,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(inDataDistributionQueue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 4, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 4, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 4, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 4, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(bool const& teamCollectionValid,int loopDepth) 
	{
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!teamCollectionValid)
															#line 2544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevError, "ConsistencyCheck_TooManyTeams").log();
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("The number of process or machine teams is larger than the allowed maximum " "number of teams");
															#line 2550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::pair<int64_t, int64_t>> __when_expr_6 = getTLogQueueInfo(cx, self->dbInfo);
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 7;
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*>(static_cast<RunCheckActor*>(this)));
															#line 2561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(bool && teamCollectionValid,int loopDepth) 
	{
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!teamCollectionValid)
															#line 2570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevError, "ConsistencyCheck_TooManyTeams").log();
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("The number of process or machine teams is larger than the allowed maximum " "number of teams");
															#line 2576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::pair<int64_t, int64_t>> __when_expr_6 = getTLogQueueInfo(cx, self->dbInfo);
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 7;
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*>(static_cast<RunCheckActor*>(this)));
															#line 2587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(bool const& teamCollectionValid,int loopDepth) 
	{
		loopDepth = a_body1cont7(teamCollectionValid, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(bool && teamCollectionValid,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(teamCollectionValid), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(std::pair<int64_t, int64_t> const& maxTLogQueueInfo,int loopDepth) 
	{
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxTLogQueueInfo.first > 1e5)
															#line 2671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NonZeroTLogQueue").detail("MaxQueueSize", maxTLogQueueInfo.first);
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Non-zero tlog queue size");
															#line 2677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxTLogQueueInfo.second > 30e6)
															#line 2681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_PoppedVersionLag") .detail("PoppedVersionLag", maxTLogQueueInfo.second);
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("large popped version lag");
															#line 2687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		try {
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<int64_t> __when_expr_7 = getMaxStorageServerQueueSize(cx, self->dbInfo, invalidVersion);
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1cont9Catch1(actor_cancelled(), loopDepth);
															#line 2694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont9Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 8;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 7, int64_t >*>(static_cast<RunCheckActor*>(this)));
															#line 2699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(std::pair<int64_t, int64_t> && maxTLogQueueInfo,int loopDepth) 
	{
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxTLogQueueInfo.first > 1e5)
															#line 2714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NonZeroTLogQueue").detail("MaxQueueSize", maxTLogQueueInfo.first);
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Non-zero tlog queue size");
															#line 2720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxTLogQueueInfo.second > 30e6)
															#line 2724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_PoppedVersionLag") .detail("PoppedVersionLag", maxTLogQueueInfo.second);
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("large popped version lag");
															#line 2730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		try {
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<int64_t> __when_expr_7 = getMaxStorageServerQueueSize(cx, self->dbInfo, invalidVersion);
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1cont9Catch1(actor_cancelled(), loopDepth);
															#line 2737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont9Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 8;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 7, int64_t >*>(static_cast<RunCheckActor*>(this)));
															#line 2742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7when1(std::pair<int64_t, int64_t> const& maxTLogQueueInfo,int loopDepth) 
	{
		loopDepth = a_body1cont9(maxTLogQueueInfo, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(std::pair<int64_t, int64_t> && maxTLogQueueInfo,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(maxTLogQueueInfo), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*,std::pair<int64_t, int64_t> const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*,std::pair<int64_t, int64_t> && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_8 = ::success(self->checkForStorage(cx, configuration, tssMapping, self));
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2834 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch2(__when_expr_8.getError(), loopDepth); else return a_body1cont11when1(__when_expr_8.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 9;
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 8, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 2839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (e.code() == error_code_attribute_not_found)
															#line 2849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_StorageQueueSizeError") .error(e) .detail("Reason", "Could not read queue size");
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!hasUndesirableServers)
															#line 2855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					self->testFailure("Could not read storage queue size");
															#line 2859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
			else
			{
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				return a_body1Catch2(e, loopDepth);
															#line 2866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14(int64_t const& maxStorageServerQueueSize,int loopDepth) 
	{
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxStorageServerQueueSize > 0)
															#line 2882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ExceedStorageServerQueueLimit") .detail("MaxQueueSize", maxStorageServerQueueSize);
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Storage server queue size exceeds limit");
															#line 2888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont14cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(int64_t && maxStorageServerQueueSize,int loopDepth) 
	{
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxStorageServerQueueSize > 0)
															#line 2898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ExceedStorageServerQueueLimit") .detail("MaxQueueSize", maxStorageServerQueueSize);
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Storage server queue size exceeds limit");
															#line 2904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont14cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(int64_t const& maxStorageServerQueueSize,int loopDepth) 
	{
		loopDepth = a_body1cont14(maxStorageServerQueueSize, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(int64_t && maxStorageServerQueueSize,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(maxStorageServerQueueSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 7, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 7, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 7, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 7, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont14cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1(Void const& _,int loopDepth) 
	{
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_9 = ::success(self->checkForExtraDataStores(cx, self));
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 10;
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 9, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1(Void && _,int loopDepth) 
	{
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_9 = ::success(self->checkForExtraDataStores(cx, self));
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 10;
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 9, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11cont2(Void const& _,int loopDepth) 
	{
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_10 = ::success(self->checkStorageMetadata(cx, self));
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch2(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_10.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 11;
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 10, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont2(Void && _,int loopDepth) 
	{
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_10 = ::success(self->checkStorageMetadata(cx, self));
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch2(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_10.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 11;
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 10, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont11cont3(Void const& _,int loopDepth) 
	{
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (configuration.blobGranulesEnabled)
															#line 3216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<bool> __when_expr_11 = self->checkBlobWorkers(cx, configuration, self);
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch2(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_11.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 12;
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 11, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont3(Void && _,int loopDepth) 
	{
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (configuration.blobGranulesEnabled)
															#line 3241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<bool> __when_expr_11 = self->checkBlobWorkers(cx, configuration, self);
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch2(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_11.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 12;
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 11, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont4(int loopDepth) 
	{
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_12 = self->checkUsingDesiredClasses(cx, self);
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch2(__when_expr_12.getError(), loopDepth); else return a_body1cont11cont4when1(__when_expr_12.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 13;
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 12, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont5(bool const& blobWorkersCorrect,int loopDepth) 
	{
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!blobWorkersCorrect)
															#line 3357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Blob workers incorrect");
															#line 3361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont5(bool && blobWorkersCorrect,int loopDepth) 
	{
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!blobWorkersCorrect)
															#line 3371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Blob workers incorrect");
															#line 3375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3when1(bool const& blobWorkersCorrect,int loopDepth) 
	{
		loopDepth = a_body1cont11cont5(blobWorkersCorrect, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3when1(bool && blobWorkersCorrect,int loopDepth) 
	{
		loopDepth = a_body1cont11cont5(std::move(blobWorkersCorrect), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 11, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 11, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 11, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 11, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont11cont8(bool const& usingDesiredClasses,int loopDepth) 
	{
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!usingDesiredClasses)
															#line 3460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Cluster has machine(s) not using requested classes");
															#line 3464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_13 = self->checkWorkerList(cx, self);
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch2(__when_expr_13.getError(), loopDepth); else return a_body1cont11cont8when1(__when_expr_13.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 14;
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 13, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont8(bool && usingDesiredClasses,int loopDepth) 
	{
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!usingDesiredClasses)
															#line 3484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Cluster has machine(s) not using requested classes");
															#line 3488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_13 = self->checkWorkerList(cx, self);
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch2(__when_expr_13.getError(), loopDepth); else return a_body1cont11cont8when1(__when_expr_13.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 14;
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 13, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4when1(bool const& usingDesiredClasses,int loopDepth) 
	{
		loopDepth = a_body1cont11cont8(usingDesiredClasses, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4when1(bool && usingDesiredClasses,int loopDepth) 
	{
		loopDepth = a_body1cont11cont8(std::move(usingDesiredClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 12, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 12, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 12, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 12, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont11cont9(bool const& workerListCorrect,int loopDepth) 
	{
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!workerListCorrect)
															#line 3583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Worker list incorrect");
															#line 3587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_14 = self->checkCoordinators(cx);
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch2(__when_expr_14.getError(), loopDepth); else return a_body1cont11cont9when1(__when_expr_14.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 15;
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 14, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont9(bool && workerListCorrect,int loopDepth) 
	{
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!workerListCorrect)
															#line 3607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Worker list incorrect");
															#line 3611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_14 = self->checkCoordinators(cx);
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch2(__when_expr_14.getError(), loopDepth); else return a_body1cont11cont9when1(__when_expr_14.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 15;
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 14, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont8when1(bool const& workerListCorrect,int loopDepth) 
	{
		loopDepth = a_body1cont11cont9(workerListCorrect, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont8when1(bool && workerListCorrect,int loopDepth) 
	{
		loopDepth = a_body1cont11cont9(std::move(workerListCorrect), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 13, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 13, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 13, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 13, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont11cont11(bool const& coordinatorsCorrect,int loopDepth) 
	{
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!coordinatorsCorrect)
															#line 3706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Coordinators incorrect");
															#line 3710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_15 = self->checkConsistencyScan(cx);
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch2(__when_expr_15.getError(), loopDepth); else return a_body1cont11cont11when1(__when_expr_15.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 16;
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 15, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11(bool && coordinatorsCorrect,int loopDepth) 
	{
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!coordinatorsCorrect)
															#line 3730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Coordinators incorrect");
															#line 3734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_15 = self->checkConsistencyScan(cx);
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch2(__when_expr_15.getError(), loopDepth); else return a_body1cont11cont11when1(__when_expr_15.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 16;
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 15, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont9when1(bool const& coordinatorsCorrect,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11(coordinatorsCorrect, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont9when1(bool && coordinatorsCorrect,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11(std::move(coordinatorsCorrect), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 14, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 14, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 14, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 14, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont11cont11cont1(bool const& consistencyScanStopped,int loopDepth) 
	{
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!consistencyScanStopped)
															#line 3829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Consistency scan active");
															#line 3833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont1(bool && consistencyScanStopped,int loopDepth) 
	{
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!consistencyScanStopped)
															#line 3843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Consistency scan active");
															#line 3847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11when1(bool const& consistencyScanStopped,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont1(consistencyScanStopped, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11when1(bool && consistencyScanStopped,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont1(std::move(consistencyScanStopped), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 15, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 15, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 15, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 15, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont15(bool const& keyServerResult,int loopDepth) 
	{
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (keyServerResult)
															#line 3932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyServers = keyServerPromise.getFuture().get();
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyLocationPromise = Promise<Standalone<VectorRef<KeyValueRef>>>();
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<bool> __when_expr_17 = getKeyLocations( cx, keyServers, keyLocationPromise, self->performQuiescentChecks, &self->success);
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch2(__when_expr_17.getError(), loopDepth); else return a_body1cont15when1(__when_expr_17.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 18;
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 17, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15(bool && keyServerResult,int loopDepth) 
	{
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (keyServerResult)
															#line 3961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyServers = keyServerPromise.getFuture().get();
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyLocationPromise = Promise<Standalone<VectorRef<KeyValueRef>>>();
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<bool> __when_expr_17 = getKeyLocations( cx, keyServers, keyLocationPromise, self->performQuiescentChecks, &self->success);
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch2(__when_expr_17.getError(), loopDepth); else return a_body1cont15when1(__when_expr_17.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 18;
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 17, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4when1(bool const& keyServerResult,int loopDepth) 
	{
		loopDepth = a_body1cont15(keyServerResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(bool && keyServerResult,int loopDepth) 
	{
		loopDepth = a_body1cont15(std::move(keyServerResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 16, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 16, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 16, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 16, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont15cont1(int loopDepth) 
	{
		loopDepth = a_body1cont15cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2(bool const& keyLocationResult,int loopDepth) 
	{
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (keyLocationResult)
															#line 4071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyLocations = keyLocationPromise.getFuture().get();
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_18 = checkDataConsistency(cx, keyLocations, configuration, tssMapping, self->performQuiescentChecks, self->performTSSCheck, self->firstClient, self->failureIsError, self->clientId, self->clientCount, self->distributed, self->shuffleShards, self->shardSampleFactor, self->sharedRandomNumber, self->repetitions, &(self->bytesReadInPreviousRound), true, self->rateLimitMax, CLIENT_KNOBS->CONSISTENCY_CHECK_ONE_ROUND_TARGET_COMPLETION_TIME, &self->success);
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4079 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch2(__when_expr_18.getError(), loopDepth); else return a_body1cont15cont2when1(__when_expr_18.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 19;
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 18, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 4084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15cont2(bool && keyLocationResult,int loopDepth) 
	{
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (keyLocationResult)
															#line 4098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyLocations = keyLocationPromise.getFuture().get();
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_18 = checkDataConsistency(cx, keyLocations, configuration, tssMapping, self->performQuiescentChecks, self->performTSSCheck, self->firstClient, self->failureIsError, self->clientId, self->clientCount, self->distributed, self->shuffleShards, self->shardSampleFactor, self->sharedRandomNumber, self->repetitions, &(self->bytesReadInPreviousRound), true, self->rateLimitMax, CLIENT_KNOBS->CONSISTENCY_CHECK_ONE_ROUND_TARGET_COMPLETION_TIME, &self->success);
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch2(__when_expr_18.getError(), loopDepth); else return a_body1cont15cont2when1(__when_expr_18.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 19;
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 18, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 4111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15when1(bool const& keyLocationResult,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(keyLocationResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont15when1(bool && keyLocationResult,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(std::move(keyLocationResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 17, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 17, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont15when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 17, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont15when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 17, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont15cont3(int loopDepth) 
	{
		loopDepth = a_body1cont15cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont4(Void const& _,int loopDepth) 
	{
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (self->performCacheCheck)
															#line 4206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_19 = self->checkCacheConsistency(cx, keyLocations, self);
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch2(__when_expr_19.getError(), loopDepth); else return a_body1cont15cont4when1(__when_expr_19.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 20;
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 19, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 4217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15cont4(Void && _,int loopDepth) 
	{
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (self->performCacheCheck)
															#line 4231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_19 = self->checkCacheConsistency(cx, keyLocations, self);
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch2(__when_expr_19.getError(), loopDepth); else return a_body1cont15cont4when1(__when_expr_19.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 20;
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 19, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 4242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 18, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 18, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont15cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 18, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont15cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 18, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont15cont5(int loopDepth) 
	{
		loopDepth = a_body1cont15cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 19, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 19, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont15cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 19, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont15cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 19, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont15cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	double consistenyCheckerBeginTime;
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	DatabaseConfiguration configuration;
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Transaction tr;
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	bool hasUndesirableServers;
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> keyServerPromise;
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> keyServers;
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> keyLocationPromise;
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> keyLocations;
															#line 4455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via runCheck()
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class RunCheckActor final : public Actor<Void>, public ActorCallback< RunCheckActor, 0, Void >, public ActorCallback< RunCheckActor, 1, RangeResult >, public ActorCallback< RunCheckActor, 2, Void >, public ActorCallback< RunCheckActor, 3, bool >, public ActorCallback< RunCheckActor, 4, int64_t >, public ActorCallback< RunCheckActor, 5, bool >, public ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >, public ActorCallback< RunCheckActor, 7, int64_t >, public ActorCallback< RunCheckActor, 8, Void >, public ActorCallback< RunCheckActor, 9, Void >, public ActorCallback< RunCheckActor, 10, Void >, public ActorCallback< RunCheckActor, 11, bool >, public ActorCallback< RunCheckActor, 12, bool >, public ActorCallback< RunCheckActor, 13, bool >, public ActorCallback< RunCheckActor, 14, bool >, public ActorCallback< RunCheckActor, 15, bool >, public ActorCallback< RunCheckActor, 16, bool >, public ActorCallback< RunCheckActor, 17, bool >, public ActorCallback< RunCheckActor, 18, Void >, public ActorCallback< RunCheckActor, 19, Void >, public FastAllocated<RunCheckActor>, public RunCheckActorState<RunCheckActor> {
															#line 4460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<RunCheckActor>::operator new;
	using FastAllocated<RunCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16002392335973500416UL, 18036042505177360896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunCheckActor, 0, Void >;
friend struct ActorCallback< RunCheckActor, 1, RangeResult >;
friend struct ActorCallback< RunCheckActor, 2, Void >;
friend struct ActorCallback< RunCheckActor, 3, bool >;
friend struct ActorCallback< RunCheckActor, 4, int64_t >;
friend struct ActorCallback< RunCheckActor, 5, bool >;
friend struct ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >;
friend struct ActorCallback< RunCheckActor, 7, int64_t >;
friend struct ActorCallback< RunCheckActor, 8, Void >;
friend struct ActorCallback< RunCheckActor, 9, Void >;
friend struct ActorCallback< RunCheckActor, 10, Void >;
friend struct ActorCallback< RunCheckActor, 11, bool >;
friend struct ActorCallback< RunCheckActor, 12, bool >;
friend struct ActorCallback< RunCheckActor, 13, bool >;
friend struct ActorCallback< RunCheckActor, 14, bool >;
friend struct ActorCallback< RunCheckActor, 15, bool >;
friend struct ActorCallback< RunCheckActor, 16, bool >;
friend struct ActorCallback< RunCheckActor, 17, bool >;
friend struct ActorCallback< RunCheckActor, 18, Void >;
friend struct ActorCallback< RunCheckActor, 19, Void >;
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	RunCheckActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 4496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<Void>(),
		   RunCheckActorState<RunCheckActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15195670578295965440UL, 8790465732451613440UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunCheckActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunCheckActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunCheckActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunCheckActor, 3, bool >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunCheckActor, 4, int64_t >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunCheckActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< RunCheckActor, 7, int64_t >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< RunCheckActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< RunCheckActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< RunCheckActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< RunCheckActor, 11, bool >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< RunCheckActor, 12, bool >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< RunCheckActor, 13, bool >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< RunCheckActor, 14, bool >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< RunCheckActor, 15, bool >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< RunCheckActor, 16, bool >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< RunCheckActor, 17, bool >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< RunCheckActor, 18, Void >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< RunCheckActor, 19, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<Void> runCheck( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<Void>(new RunCheckActor(cx, self));
															#line 4547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Check the data consistency between storage cache servers and storage servers
	// keyLocations: all key/value pairs persisted in the database, reused from previous consistency check on all
	// storage servers
																#line 4555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkCacheConsistency()
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckCacheConsistencyActor>
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckCacheConsistencyActorState {
															#line 4561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckCacheConsistencyActorState(Database const& cx,VectorRef<KeyValueRef> const& keyLocations,ConsistencyCheckWorkload* const& self) 
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   keyLocations(keyLocations),
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self),
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   cacheKeyPromise(),
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   cacheServerKeyPromise(),
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   serverListKeyPromise(),
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   serverTagKeyPromise(),
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   cacheKey(),
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   cacheServer(),
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   serverList(),
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   serverTag()
															#line 4588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkCacheConsistency", reinterpret_cast<unsigned long>(this));

	}
	~CheckCacheConsistencyActorState() 
	{
		fdb_probe_actor_destroy("checkCacheConsistency", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<Future<bool>> cacheResultsPromise;
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheResultsPromise.push_back(self->fetchKeyValuesFromSS(cx, self, storageCacheKeys, cacheKeyPromise, true));
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheResultsPromise.push_back( self->fetchKeyValuesFromSS(cx, self, storageCacheServerKeys, cacheServerKeyPromise, false));
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheResultsPromise.push_back( self->fetchKeyValuesFromSS(cx, self, serverListKeys, serverListKeyPromise, false));
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheResultsPromise.push_back(self->fetchKeyValuesFromSS(cx, self, serverTagKeys, serverTagKeyPromise, false));
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<bool>> __when_expr_0 = getAll(cacheResultsPromise);
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 1;
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >*>(static_cast<CheckCacheConsistencyActor*>(this)));
															#line 4620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckCacheConsistencyActorState();
		static_cast<CheckCacheConsistencyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<bool> const& cacheResults,int loopDepth) 
	{
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (std::all_of(cacheResults.begin(), cacheResults.end(), [](bool success) { return success; }))
															#line 4643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheKey = cacheKeyPromise.getFuture().get();
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheServer = cacheServerKeyPromise.getFuture().get();
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			serverList = serverListKeyPromise.getFuture().get();
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			serverTag = serverTagKeyPromise.getFuture().get();
															#line 4653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevDebug, "CheckCacheConsistencyFailed") .detail("CacheKey", boost::lexical_cast<std::string>(cacheResults[0])) .detail("CacheServerKey", boost::lexical_cast<std::string>(cacheResults[1])) .detail("ServerListKey", boost::lexical_cast<std::string>(cacheResults[2])) .detail("ServerTagKey", boost::lexical_cast<std::string>(cacheResults[3]));
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->success = false;
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckCacheConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckCacheConsistencyActorState(); static_cast<CheckCacheConsistencyActor*>(this)->destroy(); return 0; }
															#line 4663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckCacheConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckCacheConsistencyActorState();
			static_cast<CheckCacheConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		rateLimitForThisRound = self->bytesReadInPreviousRound == 0 ? self->rateLimitMax : std::min( self->rateLimitMax, static_cast<int>(ceil(self->bytesReadInPreviousRound / (float)CLIENT_KNOBS->CONSISTENCY_CHECK_ONE_ROUND_TARGET_COMPLETION_TIME)));
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(rateLimitForThisRound >= 0 && rateLimitForThisRound <= self->rateLimitMax);
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("CacheConsistencyCheck_RateLimitForThisRound").detail("RateLimit", rateLimitForThisRound);
															#line 472 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		rateLimiter = Reference<IRateControl>(new SpeedLimit(rateLimitForThisRound, 1));
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		rateLimiterStartTime = now();
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		bytesReadInRange = 0;
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		cacheServerInterfaces = std::vector<StorageServerInterface>();
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : cacheServer ) {
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StorageServerInterface cacheServer = decodeServerListValue(kv.value);
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(std::find(cacheServerInterfaces.begin(), cacheServerInterfaces.end(), cacheServer) == cacheServerInterfaces.end());
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheServerInterfaces.push_back(cacheServer);
															#line 4691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent(SevDebug, "CheckCacheConsistencyCacheServers") .detail("CacheSSInterfaces", describe(cacheServerInterfaces));
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		cachedKeysLocationMap = KeyRangeMap<std::vector<StorageServerInterface>>();
															#line 494 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int k = 0;k < cacheKey.size();k++) {
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<uint16_t> serverIndices;
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			decodeStorageCacheValue(cacheKey[k].value, serverIndices);
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (serverIndices.size())
															#line 4705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				KeyRangeRef range(cacheKey[k].key, (k < cacheKey.size() - 1) ? cacheKey[k + 1].key : allKeys.end);
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cachedKeysLocationMap.insert(range, cacheServerInterfaces);
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent(SevDebug, "CheckCacheConsistency").detail("CachedRange", range).detail("Index", k);
															#line 4713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		UIDtoSSMap = std::map<UID, StorageServerInterface>();
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : serverList ) {
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			UID serverId = decodeServerListKey(kv.key);
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			UIDtoSSMap[serverId] = decodeServerListValue(kv.value);
															#line 510 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevDebug, "CheckCacheConsistencyStorageServer").detail("UID", serverId);
															#line 4726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int k = 0;k < keyLocations.size() - 1;k++) {
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			KeyRangeRef range(keyLocations[k].key, keyLocations[k + 1].key);
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<UID> sourceStorageServers;
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<UID> destStorageServers;
															#line 518 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			decodeKeyServersValue(RangeResultRef(serverTag, false), keyLocations[k].value, sourceStorageServers, destStorageServers, false);
															#line 523 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			bool isRelocating = destStorageServers.size() > 0;
															#line 524 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<UID> storageServers = (isRelocating) ? destStorageServers : sourceStorageServers;
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<StorageServerInterface> storageServerInterfaces;
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			for( const auto& UID : storageServers ) {
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				storageServerInterfaces.push_back(UIDtoSSMap[UID]);
															#line 4748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<StorageServerInterface> allSS(cacheServerInterfaces);
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			allSS.insert(allSS.end(), storageServerInterfaces.begin(), storageServerInterfaces.end());
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			auto begin_iter = cachedKeysLocationMap.rangeContaining(range.begin);
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(begin_iter->begin() == range.begin);
															#line 540 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			auto end_iter = cachedKeysLocationMap.rangeContaining(range.end);
															#line 541 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (end_iter->begin() != range.end)
															#line 4762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cachedKeysLocationMap.insert(KeyRangeRef(end_iter->begin(), range.end), end_iter->value());
															#line 4766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			for(auto iter = cachedKeysLocationMap.rangeContaining(range.begin);iter != cachedKeysLocationMap.rangeContaining(range.end);++iter) {
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (iter->value().size())
															#line 4772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					iter->value().push_back(deterministicRandom()->randomChoice(storageServerInterfaces));
															#line 4776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
		}
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		iter_ranges = cachedKeysLocationMap.containedRanges(allKeys);
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		iter = iter_ranges.begin();
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		iter_ss = std::vector<StorageServerInterface>();
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		effectiveClientCount = (self->distributed) ? self->clientCount : 1;
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		increment = self->distributed ? effectiveClientCount * self->shardSampleFactor : 1;
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		shard = 0;
															#line 563 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(;shard < self->clientId * self->shardSampleFactor && iter != iter_ranges.end();) {
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (iter->value().empty())
															#line 4796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				++iter;
															#line 4800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				continue;
			}
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			++iter;
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			++shard;
															#line 4807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		;
															#line 4811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(std::vector<bool> && cacheResults,int loopDepth) 
	{
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (std::all_of(cacheResults.begin(), cacheResults.end(), [](bool success) { return success; }))
															#line 4820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheKey = cacheKeyPromise.getFuture().get();
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheServer = cacheServerKeyPromise.getFuture().get();
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			serverList = serverListKeyPromise.getFuture().get();
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			serverTag = serverTagKeyPromise.getFuture().get();
															#line 4830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevDebug, "CheckCacheConsistencyFailed") .detail("CacheKey", boost::lexical_cast<std::string>(cacheResults[0])) .detail("CacheServerKey", boost::lexical_cast<std::string>(cacheResults[1])) .detail("ServerListKey", boost::lexical_cast<std::string>(cacheResults[2])) .detail("ServerTagKey", boost::lexical_cast<std::string>(cacheResults[3]));
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->success = false;
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckCacheConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckCacheConsistencyActorState(); static_cast<CheckCacheConsistencyActor*>(this)->destroy(); return 0; }
															#line 4840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckCacheConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckCacheConsistencyActorState();
			static_cast<CheckCacheConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		rateLimitForThisRound = self->bytesReadInPreviousRound == 0 ? self->rateLimitMax : std::min( self->rateLimitMax, static_cast<int>(ceil(self->bytesReadInPreviousRound / (float)CLIENT_KNOBS->CONSISTENCY_CHECK_ONE_ROUND_TARGET_COMPLETION_TIME)));
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(rateLimitForThisRound >= 0 && rateLimitForThisRound <= self->rateLimitMax);
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("CacheConsistencyCheck_RateLimitForThisRound").detail("RateLimit", rateLimitForThisRound);
															#line 472 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		rateLimiter = Reference<IRateControl>(new SpeedLimit(rateLimitForThisRound, 1));
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		rateLimiterStartTime = now();
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		bytesReadInRange = 0;
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		cacheServerInterfaces = std::vector<StorageServerInterface>();
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : cacheServer ) {
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StorageServerInterface cacheServer = decodeServerListValue(kv.value);
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(std::find(cacheServerInterfaces.begin(), cacheServerInterfaces.end(), cacheServer) == cacheServerInterfaces.end());
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheServerInterfaces.push_back(cacheServer);
															#line 4868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent(SevDebug, "CheckCacheConsistencyCacheServers") .detail("CacheSSInterfaces", describe(cacheServerInterfaces));
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		cachedKeysLocationMap = KeyRangeMap<std::vector<StorageServerInterface>>();
															#line 494 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int k = 0;k < cacheKey.size();k++) {
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<uint16_t> serverIndices;
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			decodeStorageCacheValue(cacheKey[k].value, serverIndices);
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (serverIndices.size())
															#line 4882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				KeyRangeRef range(cacheKey[k].key, (k < cacheKey.size() - 1) ? cacheKey[k + 1].key : allKeys.end);
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cachedKeysLocationMap.insert(range, cacheServerInterfaces);
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent(SevDebug, "CheckCacheConsistency").detail("CachedRange", range).detail("Index", k);
															#line 4890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		UIDtoSSMap = std::map<UID, StorageServerInterface>();
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : serverList ) {
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			UID serverId = decodeServerListKey(kv.key);
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			UIDtoSSMap[serverId] = decodeServerListValue(kv.value);
															#line 510 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevDebug, "CheckCacheConsistencyStorageServer").detail("UID", serverId);
															#line 4903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int k = 0;k < keyLocations.size() - 1;k++) {
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			KeyRangeRef range(keyLocations[k].key, keyLocations[k + 1].key);
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<UID> sourceStorageServers;
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<UID> destStorageServers;
															#line 518 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			decodeKeyServersValue(RangeResultRef(serverTag, false), keyLocations[k].value, sourceStorageServers, destStorageServers, false);
															#line 523 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			bool isRelocating = destStorageServers.size() > 0;
															#line 524 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<UID> storageServers = (isRelocating) ? destStorageServers : sourceStorageServers;
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<StorageServerInterface> storageServerInterfaces;
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			for( const auto& UID : storageServers ) {
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				storageServerInterfaces.push_back(UIDtoSSMap[UID]);
															#line 4925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<StorageServerInterface> allSS(cacheServerInterfaces);
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			allSS.insert(allSS.end(), storageServerInterfaces.begin(), storageServerInterfaces.end());
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			auto begin_iter = cachedKeysLocationMap.rangeContaining(range.begin);
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(begin_iter->begin() == range.begin);
															#line 540 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			auto end_iter = cachedKeysLocationMap.rangeContaining(range.end);
															#line 541 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (end_iter->begin() != range.end)
															#line 4939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cachedKeysLocationMap.insert(KeyRangeRef(end_iter->begin(), range.end), end_iter->value());
															#line 4943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			for(auto iter = cachedKeysLocationMap.rangeContaining(range.begin);iter != cachedKeysLocationMap.rangeContaining(range.end);++iter) {
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (iter->value().size())
															#line 4949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					iter->value().push_back(deterministicRandom()->randomChoice(storageServerInterfaces));
															#line 4953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
		}
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		iter_ranges = cachedKeysLocationMap.containedRanges(allKeys);
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		iter = iter_ranges.begin();
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		iter_ss = std::vector<StorageServerInterface>();
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		effectiveClientCount = (self->distributed) ? self->clientCount : 1;
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		increment = self->distributed ? effectiveClientCount * self->shardSampleFactor : 1;
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		shard = 0;
															#line 563 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(;shard < self->clientId * self->shardSampleFactor && iter != iter_ranges.end();) {
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (iter->value().empty())
															#line 4973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				++iter;
															#line 4977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				continue;
			}
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			++iter;
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			++shard;
															#line 4984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		;
															#line 4988 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<bool> const& cacheResults,int loopDepth) 
	{
		loopDepth = a_body1cont1(cacheResults, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<bool> && cacheResults,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cacheResults), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCacheConsistencyActor*>(this)->ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >*,std::vector<bool> const& value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >*,std::vector<bool> && value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >*,Error err) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 802 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckCacheConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckCacheConsistencyActorState(); static_cast<CheckCacheConsistencyActor*>(this)->destroy(); return 0; }
															#line 5072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckCacheConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckCacheConsistencyActorState();
		static_cast<CheckCacheConsistencyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(iter != iter_ranges.end()))
															#line 5091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		iter_ss = iter->value();
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (iter_ss.empty())
															#line 5099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1cont1continue1(loopDepth); // continue
		}
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (shard % increment != (self->clientId * self->shardSampleFactor) % increment)
															#line 5105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			++shard;
															#line 5109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			return a_body1cont1continue1(loopDepth); // continue
		}
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		lastSampleKey = Key();
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		lastStartSampleKey = Key();
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		totalReadAmount = 0;
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		begin = firstGreaterOrEqual(iter->begin());
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		onErrorTr = Transaction(cx);
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		;
															#line 5124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1continue1(int loopDepth) 
	{
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		++iter;
															#line 5146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (bytesReadInRange > 0)
															#line 5155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 796 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("CacheConsistencyCheck_ReadRange") .suppressFor(1.0) .detail("Range", iter->range()) .detail("BytesRead", bytesReadInRange);
															#line 5159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		++iter;
															#line 5163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			lastSampleKey = lastStartSampleKey;
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Version> __when_expr_1 = getVersion(cx);
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 2;
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckCacheConsistencyActor, 1, Version >*>(static_cast<CheckCacheConsistencyActor*>(this)));
															#line 5189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			err = e;
															#line 790 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_4 = onErrorTr.onError(err);
															#line 790 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 5;
															#line 790 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckCacheConsistencyActor, 4, Void >*>(static_cast<CheckCacheConsistencyActor*>(this)));
															#line 5233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Version const& version,int loopDepth) 
	{
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req = GetKeyValuesRequest();
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.begin = begin;
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.end = firstGreaterOrEqual(iter->end());
															#line 599 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limit = 1e4;
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.version = version;
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.tags = TagSet();
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.options = ReadOptions(debugRandom()->randomUniqueID());
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		DisabledTraceEvent("CCD", req.options.get().debugID.get()).detail("Version", version);
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		j = 0;
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(j = 0;j < iter_ss.size();j++) {
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			resetReply(req);
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 5274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cx->getLatestCommitVersion(iter_ss[j], req.version, req.ssLatestCommitVersions);
															#line 5278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyValueFutures.push_back(iter_ss[j].getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 5282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(keyValueFutures);
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 3;
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckCacheConsistencyActor, 2, Void >*>(static_cast<CheckCacheConsistencyActor*>(this)));
															#line 5293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Version && version,int loopDepth) 
	{
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req = GetKeyValuesRequest();
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.begin = begin;
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.end = firstGreaterOrEqual(iter->end());
															#line 599 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limit = 1e4;
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.version = version;
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.tags = TagSet();
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.options = ReadOptions(debugRandom()->randomUniqueID());
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		DisabledTraceEvent("CCD", req.options.get().debugID.get()).detail("Version", version);
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		j = 0;
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(j = 0;j < iter_ss.size();j++) {
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			resetReply(req);
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 5328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cx->getLatestCommitVersion(iter_ss[j], req.version, req.ssLatestCommitVersions);
															#line 5332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyValueFutures.push_back(iter_ss[j].getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 5336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(keyValueFutures);
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 3;
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckCacheConsistencyActor, 2, Void >*>(static_cast<CheckCacheConsistencyActor*>(this)));
															#line 5347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCacheConsistencyActor*>(this)->ActorCallback< CheckCacheConsistencyActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckCacheConsistencyActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 618 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent(SevDebug, "CheckCacheConsistencyComparison") .detail("Begin", req.begin) .detail("End", req.end) .detail("SSInterfaces", describe(iter_ss));
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		firstValidServer = -1;
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		totalReadAmount = 0;
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(j = 0;j < keyValueFutures.size();j++) {
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[j].get();
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (rangeResult.present() && !rangeResult.get().error.present())
															#line 5441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				current = rangeResult.get();
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				totalReadAmount += current.data.expectedSize();
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent(SevDebug, "CheckCacheConsistencyResult") .detail("SSInterface", iter_ss[j].uniqueID);
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (firstValidServer == -1)
															#line 5451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					firstValidServer = j;
															#line 5455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
				else
				{
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					GetKeyValuesReply reference = keyValueFutures[firstValidServer].get().get();
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (current.data != reference.data || current.more != reference.more)
															#line 5463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (g_network->isSimulated())
															#line 5467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						{
															#line 650 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							int invalidIndex = -1;
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							printf("\nSERVER %d (%s); shard = %s - %s:\n", j, iter_ss[j].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 656 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							for(int k = 0;k < current.data.size();k++) {
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								printf("%d. %s => %s\n", k, printable(current.data[k].key).c_str(), printable(current.data[k].value).c_str());
															#line 661 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								if (invalidIndex < 0 && (k >= reference.data.size() || current.data[k].key != reference.data[k].key || current.data[k].value != reference.data[k].value))
															#line 5479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								{
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									invalidIndex = k;
															#line 5483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								}
							}
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							printf("\nSERVER %d (%s); shard = %s - %s:\n", firstValidServer, iter_ss[firstValidServer].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							for(int k = 0;k < reference.data.size();k++) {
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								printf("%d. %s => %s\n", k, printable(reference.data[k].key).c_str(), printable(reference.data[k].value).c_str());
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								if (invalidIndex < 0 && (k >= current.data.size() || reference.data[k].key != current.data[k].key || reference.data[k].value != current.data[k].value))
															#line 5494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								{
															#line 680 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									invalidIndex = k;
															#line 5498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								}
							}
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							printf("\nMISMATCH AT %d\n\n", invalidIndex);
															#line 5503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						}
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int currentUniques = 0;
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int referenceUniques = 0;
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int valueMismatches = 0;
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int matchingKVPairs = 0;
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						KeyRef currentUniqueKey;
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						KeyRef referenceUniqueKey;
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						KeyRef valueMismatchKey;
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int currentI = 0;
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int referenceI = 0;
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						for(;currentI < current.data.size() || referenceI < reference.data.size();) {
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							if (currentI >= current.data.size())
															#line 5527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
							{
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								referenceUniqueKey = reference.data[referenceI].key;
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								referenceUniques++;
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								referenceI++;
															#line 5535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
							}
							else
							{
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								if (referenceI >= reference.data.size())
															#line 5541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								{
															#line 711 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									currentUniqueKey = current.data[currentI].key;
															#line 712 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									currentUniques++;
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									currentI++;
															#line 5549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								}
								else
								{
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									KeyValueRef currentKV = current.data[currentI];
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									KeyValueRef referenceKV = reference.data[referenceI];
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									if (currentKV.key == referenceKV.key)
															#line 5559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
									{
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										if (currentKV.value == referenceKV.value)
															#line 5563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										{
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											matchingKVPairs++;
															#line 5567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
										else
										{
															#line 722 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											valueMismatchKey = currentKV.key;
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											valueMismatches++;
															#line 5575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
															#line 726 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										currentI++;
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										referenceI++;
															#line 5581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
									}
									else
									{
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										if (currentKV.key < referenceKV.key)
															#line 5587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										{
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											currentUniqueKey = currentKV.key;
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											currentUniques++;
															#line 731 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											currentI++;
															#line 5595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
										else
										{
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											referenceUniqueKey = referenceKV.key;
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											referenceUniques++;
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											referenceI++;
															#line 5605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
									}
								}
							}
						}
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("CacheConsistencyCheck_DataInconsistent") .detail(format("StorageServer%d", j).c_str(), iter_ss[j].toString()) .detail(format("StorageServer%d", firstValidServer).c_str(), iter_ss[firstValidServer].toString()) .detail("ShardBegin", req.begin.getKey()) .detail("ShardEnd", req.end.getKey()) .detail("VersionNumber", req.version) .detail(format("Server%dUniques", j).c_str(), currentUniques) .detail(format("Server%dUniqueKey", j).c_str(), currentUniqueKey) .detail(format("Server%dUniques", firstValidServer).c_str(), referenceUniques) .detail(format("Server%dUniqueKey", firstValidServer).c_str(), referenceUniqueKey) .detail("ValueMismatches", valueMismatches) .detail("ValueMismatchKey", valueMismatchKey) .detail("MatchingKVPairs", matchingKVPairs);
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Data inconsistent", true);
															#line 5615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					}
				}
			}
		}
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (rateLimitForThisRound > 0)
															#line 5622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_3 = rateLimiter->getAllowance(totalReadAmount);
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 4;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckCacheConsistencyActor, 3, Void >*>(static_cast<CheckCacheConsistencyActor*>(this)));
															#line 5633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 618 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent(SevDebug, "CheckCacheConsistencyComparison") .detail("Begin", req.begin) .detail("End", req.end) .detail("SSInterfaces", describe(iter_ss));
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		firstValidServer = -1;
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		totalReadAmount = 0;
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(j = 0;j < keyValueFutures.size();j++) {
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[j].get();
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (rangeResult.present() && !rangeResult.get().error.present())
															#line 5657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				current = rangeResult.get();
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				totalReadAmount += current.data.expectedSize();
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent(SevDebug, "CheckCacheConsistencyResult") .detail("SSInterface", iter_ss[j].uniqueID);
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (firstValidServer == -1)
															#line 5667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					firstValidServer = j;
															#line 5671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
				else
				{
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					GetKeyValuesReply reference = keyValueFutures[firstValidServer].get().get();
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (current.data != reference.data || current.more != reference.more)
															#line 5679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (g_network->isSimulated())
															#line 5683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						{
															#line 650 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							int invalidIndex = -1;
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							printf("\nSERVER %d (%s); shard = %s - %s:\n", j, iter_ss[j].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 656 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							for(int k = 0;k < current.data.size();k++) {
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								printf("%d. %s => %s\n", k, printable(current.data[k].key).c_str(), printable(current.data[k].value).c_str());
															#line 661 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								if (invalidIndex < 0 && (k >= reference.data.size() || current.data[k].key != reference.data[k].key || current.data[k].value != reference.data[k].value))
															#line 5695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								{
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									invalidIndex = k;
															#line 5699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								}
							}
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							printf("\nSERVER %d (%s); shard = %s - %s:\n", firstValidServer, iter_ss[firstValidServer].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							for(int k = 0;k < reference.data.size();k++) {
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								printf("%d. %s => %s\n", k, printable(reference.data[k].key).c_str(), printable(reference.data[k].value).c_str());
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								if (invalidIndex < 0 && (k >= current.data.size() || reference.data[k].key != current.data[k].key || reference.data[k].value != current.data[k].value))
															#line 5710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								{
															#line 680 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									invalidIndex = k;
															#line 5714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								}
							}
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							printf("\nMISMATCH AT %d\n\n", invalidIndex);
															#line 5719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						}
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int currentUniques = 0;
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int referenceUniques = 0;
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int valueMismatches = 0;
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int matchingKVPairs = 0;
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						KeyRef currentUniqueKey;
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						KeyRef referenceUniqueKey;
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						KeyRef valueMismatchKey;
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int currentI = 0;
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int referenceI = 0;
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						for(;currentI < current.data.size() || referenceI < reference.data.size();) {
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							if (currentI >= current.data.size())
															#line 5743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
							{
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								referenceUniqueKey = reference.data[referenceI].key;
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								referenceUniques++;
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								referenceI++;
															#line 5751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
							}
							else
							{
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								if (referenceI >= reference.data.size())
															#line 5757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								{
															#line 711 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									currentUniqueKey = current.data[currentI].key;
															#line 712 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									currentUniques++;
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									currentI++;
															#line 5765 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								}
								else
								{
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									KeyValueRef currentKV = current.data[currentI];
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									KeyValueRef referenceKV = reference.data[referenceI];
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									if (currentKV.key == referenceKV.key)
															#line 5775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
									{
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										if (currentKV.value == referenceKV.value)
															#line 5779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										{
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											matchingKVPairs++;
															#line 5783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
										else
										{
															#line 722 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											valueMismatchKey = currentKV.key;
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											valueMismatches++;
															#line 5791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
															#line 726 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										currentI++;
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										referenceI++;
															#line 5797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
									}
									else
									{
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										if (currentKV.key < referenceKV.key)
															#line 5803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										{
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											currentUniqueKey = currentKV.key;
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											currentUniques++;
															#line 731 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											currentI++;
															#line 5811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
										else
										{
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											referenceUniqueKey = referenceKV.key;
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											referenceUniques++;
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											referenceI++;
															#line 5821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
									}
								}
							}
						}
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("CacheConsistencyCheck_DataInconsistent") .detail(format("StorageServer%d", j).c_str(), iter_ss[j].toString()) .detail(format("StorageServer%d", firstValidServer).c_str(), iter_ss[firstValidServer].toString()) .detail("ShardBegin", req.begin.getKey()) .detail("ShardEnd", req.end.getKey()) .detail("VersionNumber", req.version) .detail(format("Server%dUniques", j).c_str(), currentUniques) .detail(format("Server%dUniqueKey", j).c_str(), currentUniqueKey) .detail(format("Server%dUniques", firstValidServer).c_str(), referenceUniques) .detail(format("Server%dUniqueKey", firstValidServer).c_str(), referenceUniqueKey) .detail("ValueMismatches", valueMismatches) .detail("ValueMismatchKey", valueMismatchKey) .detail("MatchingKVPairs", matchingKVPairs);
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Data inconsistent", true);
															#line 5831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					}
				}
			}
		}
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (rateLimitForThisRound > 0)
															#line 5838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_3 = rateLimiter->getAllowance(totalReadAmount);
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 4;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckCacheConsistencyActor, 3, Void >*>(static_cast<CheckCacheConsistencyActor*>(this)));
															#line 5849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCacheConsistencyActor*>(this)->ActorCallback< CheckCacheConsistencyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckCacheConsistencyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1cont6(int loopDepth) 
	{
															#line 776 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		bytesReadInRange += totalReadAmount;
															#line 779 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (firstValidServer >= 0 && keyValueFutures[firstValidServer].get().get().more)
															#line 5940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 780 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			VectorRef<KeyValueRef> result = keyValueFutures[firstValidServer].get().get().data;
															#line 781 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(result.size() > 0);
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			begin = firstGreaterThan(result[result.size() - 1].key);
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(begin.getKey() != allKeys.end);
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			lastStartSampleKey = lastSampleKey;
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevDebug, "CacheConsistencyCheckNextBeginKey").detail("Key", begin);
															#line 5954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont32(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont28(Void const& _,int loopDepth) 
	{
															#line 766 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (now() - rateLimiterStartTime > 1.1 * CLIENT_KNOBS->CONSISTENCY_CHECK_ONE_ROUND_TARGET_COMPLETION_TIME && rateLimitForThisRound != self->rateLimitMax)
															#line 5968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 769 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			rateLimitForThisRound = self->rateLimitMax;
															#line 770 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			rateLimiter = Reference<IRateControl>(new SpeedLimit(rateLimitForThisRound, 1));
															#line 771 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			rateLimiterStartTime = now();
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevInfo, "CacheConsistencyCheck_RateLimitSetMaxForThisRound") .detail("RateLimit", rateLimitForThisRound);
															#line 5978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont28(Void && _,int loopDepth) 
	{
															#line 766 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (now() - rateLimiterStartTime > 1.1 * CLIENT_KNOBS->CONSISTENCY_CHECK_ONE_ROUND_TARGET_COMPLETION_TIME && rateLimitForThisRound != self->rateLimitMax)
															#line 5988 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 769 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			rateLimitForThisRound = self->rateLimitMax;
															#line 770 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			rateLimiter = Reference<IRateControl>(new SpeedLimit(rateLimitForThisRound, 1));
															#line 771 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			rateLimiterStartTime = now();
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevInfo, "CacheConsistencyCheck_RateLimitSetMaxForThisRound") .detail("RateLimit", rateLimitForThisRound);
															#line 5998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont28(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont28(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCacheConsistencyActor*>(this)->ActorCallback< CheckCacheConsistencyActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckCacheConsistencyActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1loopBody1cont32(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("CacheConsistencyCheck_RetryDataConsistency").error(err);
															#line 6096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("CacheConsistencyCheck_RetryDataConsistency").error(err);
															#line 6105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCacheConsistencyActor*>(this)->ActorCallback< CheckCacheConsistencyActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckCacheConsistencyActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	VectorRef<KeyValueRef> keyLocations;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> cacheKeyPromise;
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> cacheServerKeyPromise;
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> serverListKeyPromise;
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> serverTagKeyPromise;
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> cacheKey;
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> cacheServer;
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> serverList;
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> serverTag;
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int rateLimitForThisRound;
															#line 472 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Reference<IRateControl> rateLimiter;
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	double rateLimiterStartTime;
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int bytesReadInRange;
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> cacheServerInterfaces;
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	KeyRangeMap<std::vector<StorageServerInterface>> cachedKeysLocationMap;
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::map<UID, StorageServerInterface> UIDtoSSMap;
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	RangeMap<Key, std::vector<StorageServerInterface>, KeyRangeRef>::Ranges iter_ranges;
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	RangeMap<Key, std::vector<StorageServerInterface>, KeyRangeRef>::iterator iter;
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> iter_ss;
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int effectiveClientCount;
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int increment;
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int shard;
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Key lastSampleKey;
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Key lastStartSampleKey;
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int64_t totalReadAmount;
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	KeySelector begin;
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Transaction onErrorTr;
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	GetKeyValuesRequest req;
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyValuesReply>>> keyValueFutures;
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int j;
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int firstValidServer;
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	GetKeyValuesReply current;
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Error err;
															#line 6255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkCacheConsistency()
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckCacheConsistencyActor final : public Actor<Void>, public ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >, public ActorCallback< CheckCacheConsistencyActor, 1, Version >, public ActorCallback< CheckCacheConsistencyActor, 2, Void >, public ActorCallback< CheckCacheConsistencyActor, 3, Void >, public ActorCallback< CheckCacheConsistencyActor, 4, Void >, public FastAllocated<CheckCacheConsistencyActor>, public CheckCacheConsistencyActorState<CheckCacheConsistencyActor> {
															#line 6260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckCacheConsistencyActor>::operator new;
	using FastAllocated<CheckCacheConsistencyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13063141704331471616UL, 9109830859354509312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >;
friend struct ActorCallback< CheckCacheConsistencyActor, 1, Version >;
friend struct ActorCallback< CheckCacheConsistencyActor, 2, Void >;
friend struct ActorCallback< CheckCacheConsistencyActor, 3, Void >;
friend struct ActorCallback< CheckCacheConsistencyActor, 4, Void >;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckCacheConsistencyActor(Database const& cx,VectorRef<KeyValueRef> const& keyLocations,ConsistencyCheckWorkload* const& self) 
															#line 6281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<Void>(),
		   CheckCacheConsistencyActorState<CheckCacheConsistencyActor>(cx, keyLocations, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9430085582066714624UL, 7832144406646334976UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkCacheConsistency");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckCacheConsistencyActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckCacheConsistencyActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckCacheConsistencyActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckCacheConsistencyActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<Void> checkCacheConsistency( Database const& cx, VectorRef<KeyValueRef> const& keyLocations, ConsistencyCheckWorkload* const& self ) {
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<Void>(new CheckCacheConsistencyActor(cx, keyLocations, self));
															#line 6317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 804 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Directly fetch key/values from storage servers through GetKeyValuesRequest
	// In particular, avoid transaction-based read which may read data from storage cache servers
	// range: all key/values in the range will be fetched
	// removePrefix: if true, remove the prefix of the range, e.g. \xff/storageCacheServer/
																#line 6326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via fetchKeyValuesFromSS()
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class FetchKeyValuesFromSSActor>
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class FetchKeyValuesFromSSActorState {
															#line 6332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	FetchKeyValuesFromSSActorState(Database const& cx,ConsistencyCheckWorkload* const& self,KeyRangeRef const& range,Promise<Standalone<VectorRef<KeyValueRef>>> const& resultPromise,bool const& removePrefix) 
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self),
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   range(range),
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   resultPromise(resultPromise),
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   removePrefix(removePrefix),
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   keyServerPromise()
															#line 6349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this));

	}
	~FetchKeyValuesFromSSActorState() 
	{
		fdb_probe_actor_destroy("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 816 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<bool> __when_expr_0 = getKeyServers( cx, keyServerPromise, range, self->performQuiescentChecks, self->failureIsError, &self->success);
															#line 816 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 1;
															#line 816 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchKeyValuesFromSSActor, 0, bool >*>(static_cast<FetchKeyValuesFromSSActor*>(this)));
															#line 6371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchKeyValuesFromSSActorState();
		static_cast<FetchKeyValuesFromSSActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& keyServerResult,int loopDepth) 
	{
															#line 818 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!keyServerResult)
															#line 6394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<FetchKeyValuesFromSSActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FetchKeyValuesFromSSActorState(); static_cast<FetchKeyValuesFromSSActor*>(this)->destroy(); return 0; }
															#line 6398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<FetchKeyValuesFromSSActor*>(this)->SAV< bool >::value()) bool(false);
			this->~FetchKeyValuesFromSSActorState();
			static_cast<FetchKeyValuesFromSSActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		shards = keyServerPromise.getFuture().get();
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		result = Standalone<VectorRef<KeyValueRef>>();
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		beginKey = allKeys.begin.withPrefix(range.begin);
															#line 826 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		endKey = allKeys.end.withPrefix(range.begin);
															#line 827 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i = int();
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		onErrorTr = Transaction(cx);
															#line 832 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i = 0;
															#line 6418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(bool && keyServerResult,int loopDepth) 
	{
															#line 818 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!keyServerResult)
															#line 6427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<FetchKeyValuesFromSSActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FetchKeyValuesFromSSActorState(); static_cast<FetchKeyValuesFromSSActor*>(this)->destroy(); return 0; }
															#line 6431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<FetchKeyValuesFromSSActor*>(this)->SAV< bool >::value()) bool(false);
			this->~FetchKeyValuesFromSSActorState();
			static_cast<FetchKeyValuesFromSSActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		shards = keyServerPromise.getFuture().get();
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		result = Standalone<VectorRef<KeyValueRef>>();
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		beginKey = allKeys.begin.withPrefix(range.begin);
															#line 826 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		endKey = allKeys.end.withPrefix(range.begin);
															#line 827 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i = int();
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		onErrorTr = Transaction(cx);
															#line 832 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i = 0;
															#line 6451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool const& keyServerResult,int loopDepth) 
	{
		loopDepth = a_body1cont1(keyServerResult, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && keyServerResult,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(keyServerResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state > 0) static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 0;
		static_cast<FetchKeyValuesFromSSActor*>(this)->ActorCallback< FetchKeyValuesFromSSActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchKeyValuesFromSSActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		resultPromise.send(result);
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<FetchKeyValuesFromSSActor*>(this)->SAV<bool>::futures) { (void)(true); this->~FetchKeyValuesFromSSActorState(); static_cast<FetchKeyValuesFromSSActor*>(this)->destroy(); return 0; }
															#line 6537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<FetchKeyValuesFromSSActor*>(this)->SAV< bool >::value()) bool(true);
		this->~FetchKeyValuesFromSSActorState();
		static_cast<FetchKeyValuesFromSSActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 832 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(i < shards.size()))
															#line 6556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 833 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		;
															#line 6562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 832 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i++;
															#line 6584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 833 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(beginKey < std::min<KeyRef>(shards[i].first.end, endKey)))
															#line 6600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Version> __when_expr_1 = getVersion(cx);
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 2;
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchKeyValuesFromSSActor, 1, Version >*>(static_cast<FetchKeyValuesFromSSActor*>(this)));
															#line 6614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 911 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			err = e;
															#line 912 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_3 = onErrorTr.onError(err);
															#line 912 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 4;
															#line 912 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FetchKeyValuesFromSSActor, 3, Void >*>(static_cast<FetchKeyValuesFromSSActor*>(this)));
															#line 6658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(Version const& version,int loopDepth) 
	{
															#line 837 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		GetKeyValuesRequest req;
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.begin = firstGreaterOrEqual(beginKey);
															#line 839 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.end = firstGreaterOrEqual(std::min<KeyRef>(shards[i].first.end, endKey));
															#line 840 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limit = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT;
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limitBytes = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES;
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.version = version;
															#line 843 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.tags = TagSet();
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : shards[i].second ) {
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			resetReply(req);
															#line 851 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 6693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cx->getLatestCommitVersion(kv, req.version, req.ssLatestCommitVersions);
															#line 6697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 854 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyValueFutures.push_back(kv.getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 6701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(keyValueFutures);
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 3;
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FetchKeyValuesFromSSActor, 2, Void >*>(static_cast<FetchKeyValuesFromSSActor*>(this)));
															#line 6712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(Version && version,int loopDepth) 
	{
															#line 837 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		GetKeyValuesRequest req;
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.begin = firstGreaterOrEqual(beginKey);
															#line 839 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.end = firstGreaterOrEqual(std::min<KeyRef>(shards[i].first.end, endKey));
															#line 840 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limit = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT;
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limitBytes = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES;
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.version = version;
															#line 843 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.tags = TagSet();
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : shards[i].second ) {
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			resetReply(req);
															#line 851 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 6741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cx->getLatestCommitVersion(kv, req.version, req.ssLatestCommitVersions);
															#line 6745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 854 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyValueFutures.push_back(kv.getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 6749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(keyValueFutures);
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 3;
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FetchKeyValuesFromSSActor, 2, Void >*>(static_cast<FetchKeyValuesFromSSActor*>(this)));
															#line 6760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(version, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state > 0) static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 0;
		static_cast<FetchKeyValuesFromSSActor*>(this)->ActorCallback< FetchKeyValuesFromSSActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchKeyValuesFromSSActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 859 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		int firstValidStorageServer = -1;
															#line 862 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int j = 0;j < keyValueFutures.size();j++) {
															#line 863 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ErrorOr<GetKeyValuesReply> reply = keyValueFutures[j].get();
															#line 865 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!reply.present() || reply.get().error.present())
															#line 6850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (self->performQuiescentChecks)
															#line 6854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("CacheConsistencyCheck_KeyServerUnavailable") .detail("StorageServer", shards[i].second[j].id().toString().c_str());
															#line 870 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					self->testFailure("Key server unavailable");
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<FetchKeyValuesFromSSActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FetchKeyValuesFromSSActorState(); static_cast<FetchKeyValuesFromSSActor*>(this)->destroy(); return 0; }
															#line 6862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<FetchKeyValuesFromSSActor*>(this)->SAV< bool >::value()) bool(false);
					this->~FetchKeyValuesFromSSActorState();
					static_cast<FetchKeyValuesFromSSActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 875 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (firstValidStorageServer < 0 && j == keyValueFutures.size() - 1)
															#line 6872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						return a_body1cont1loopBody1loopBody1Catch1(all_alternatives_failed(), loopDepth);
															#line 6876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					}
				}
			}
			else
			{
															#line 880 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (firstValidStorageServer < 0)
															#line 6884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					firstValidStorageServer = j;
															#line 6888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
				else
				{
															#line 885 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (reply.get().data != keyValueFutures[firstValidStorageServer].get().get().data || reply.get().more != keyValueFutures[firstValidStorageServer].get().get().more)
															#line 6894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 887 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("CacheConsistencyCheck_InconsistentKeyServers") .detail("StorageServer1", shards[i].second[firstValidStorageServer].id()) .detail("StorageServer2", shards[i].second[j].id());
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Key servers inconsistent", true);
															#line 891 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<FetchKeyValuesFromSSActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FetchKeyValuesFromSSActorState(); static_cast<FetchKeyValuesFromSSActor*>(this)->destroy(); return 0; }
															#line 6902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<FetchKeyValuesFromSSActor*>(this)->SAV< bool >::value()) bool(false);
						this->~FetchKeyValuesFromSSActorState();
						static_cast<FetchKeyValuesFromSSActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
															#line 895 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		auto keyValueResponse = keyValueFutures[firstValidStorageServer].get().get();
															#line 897 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : keyValueResponse.data ) {
															#line 898 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			result.push_back_deep( result.arena(), KeyValueRef(removePrefix ? kv.key.removePrefix(range.begin) : kv.key, kv.value));
															#line 6917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 904 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(result.size() >= 1);
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!keyValueResponse.more)
															#line 6923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			beginKey = shards[i].first.end;
															#line 6927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			beginKey = keyAfter(keyValueResponse.data.end()[-1].key);
															#line 6933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 859 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		int firstValidStorageServer = -1;
															#line 862 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int j = 0;j < keyValueFutures.size();j++) {
															#line 863 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ErrorOr<GetKeyValuesReply> reply = keyValueFutures[j].get();
															#line 865 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!reply.present() || reply.get().error.present())
															#line 6949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (self->performQuiescentChecks)
															#line 6953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("CacheConsistencyCheck_KeyServerUnavailable") .detail("StorageServer", shards[i].second[j].id().toString().c_str());
															#line 870 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					self->testFailure("Key server unavailable");
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<FetchKeyValuesFromSSActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FetchKeyValuesFromSSActorState(); static_cast<FetchKeyValuesFromSSActor*>(this)->destroy(); return 0; }
															#line 6961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<FetchKeyValuesFromSSActor*>(this)->SAV< bool >::value()) bool(false);
					this->~FetchKeyValuesFromSSActorState();
					static_cast<FetchKeyValuesFromSSActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 875 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (firstValidStorageServer < 0 && j == keyValueFutures.size() - 1)
															#line 6971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						return a_body1cont1loopBody1loopBody1Catch1(all_alternatives_failed(), loopDepth);
															#line 6975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					}
				}
			}
			else
			{
															#line 880 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (firstValidStorageServer < 0)
															#line 6983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					firstValidStorageServer = j;
															#line 6987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
				else
				{
															#line 885 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (reply.get().data != keyValueFutures[firstValidStorageServer].get().get().data || reply.get().more != keyValueFutures[firstValidStorageServer].get().get().more)
															#line 6993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 887 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("CacheConsistencyCheck_InconsistentKeyServers") .detail("StorageServer1", shards[i].second[firstValidStorageServer].id()) .detail("StorageServer2", shards[i].second[j].id());
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Key servers inconsistent", true);
															#line 891 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<FetchKeyValuesFromSSActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FetchKeyValuesFromSSActorState(); static_cast<FetchKeyValuesFromSSActor*>(this)->destroy(); return 0; }
															#line 7001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<FetchKeyValuesFromSSActor*>(this)->SAV< bool >::value()) bool(false);
						this->~FetchKeyValuesFromSSActorState();
						static_cast<FetchKeyValuesFromSSActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
															#line 895 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		auto keyValueResponse = keyValueFutures[firstValidStorageServer].get().get();
															#line 897 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : keyValueResponse.data ) {
															#line 898 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			result.push_back_deep( result.arena(), KeyValueRef(removePrefix ? kv.key.removePrefix(range.begin) : kv.key, kv.value));
															#line 7016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 904 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(result.size() >= 1);
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!keyValueResponse.more)
															#line 7022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			beginKey = shards[i].first.end;
															#line 7026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			beginKey = keyAfter(keyValueResponse.data.end()[-1].key);
															#line 7032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state > 0) static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 0;
		static_cast<FetchKeyValuesFromSSActor*>(this)->ActorCallback< FetchKeyValuesFromSSActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FetchKeyValuesFromSSActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1cont20(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("CacheConsistencyCheck_RetryGetKeyLocations").error(err);
															#line 7130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("CacheConsistencyCheck_RetryGetKeyLocations").error(err);
															#line 7139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state > 0) static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 0;
		static_cast<FetchKeyValuesFromSSActor*>(this)->ActorCallback< FetchKeyValuesFromSSActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FetchKeyValuesFromSSActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	KeyRangeRef range;
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> resultPromise;
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	bool removePrefix;
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> keyServerPromise;
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> shards;
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> result;
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Key beginKey;
															#line 826 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Key endKey;
															#line 827 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int i;
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Transaction onErrorTr;
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyValuesReply>>> keyValueFutures;
															#line 911 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Error err;
															#line 7247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via fetchKeyValuesFromSS()
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class FetchKeyValuesFromSSActor final : public Actor<bool>, public ActorCallback< FetchKeyValuesFromSSActor, 0, bool >, public ActorCallback< FetchKeyValuesFromSSActor, 1, Version >, public ActorCallback< FetchKeyValuesFromSSActor, 2, Void >, public ActorCallback< FetchKeyValuesFromSSActor, 3, Void >, public FastAllocated<FetchKeyValuesFromSSActor>, public FetchKeyValuesFromSSActorState<FetchKeyValuesFromSSActor> {
															#line 7252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<FetchKeyValuesFromSSActor>::operator new;
	using FastAllocated<FetchKeyValuesFromSSActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9104147645244701696UL, 17209396624433031168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchKeyValuesFromSSActor, 0, bool >;
friend struct ActorCallback< FetchKeyValuesFromSSActor, 1, Version >;
friend struct ActorCallback< FetchKeyValuesFromSSActor, 2, Void >;
friend struct ActorCallback< FetchKeyValuesFromSSActor, 3, Void >;
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	FetchKeyValuesFromSSActor(Database const& cx,ConsistencyCheckWorkload* const& self,KeyRangeRef const& range,Promise<Standalone<VectorRef<KeyValueRef>>> const& resultPromise,bool const& removePrefix) 
															#line 7272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   FetchKeyValuesFromSSActorState<FetchKeyValuesFromSSActor>(cx, self, range, resultPromise, removePrefix),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1813994210122685440UL, 2419768122244924160UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchKeyValuesFromSS");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchKeyValuesFromSSActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchKeyValuesFromSSActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FetchKeyValuesFromSSActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FetchKeyValuesFromSSActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> fetchKeyValuesFromSS( Database const& cx, ConsistencyCheckWorkload* const& self, KeyRangeRef const& range, Promise<Standalone<VectorRef<KeyValueRef>>> const& resultPromise, bool const& removePrefix ) {
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new FetchKeyValuesFromSSActor(cx, self, range, resultPromise, removePrefix));
															#line 7307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 921 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Comparison function used to compare map elements by value
	template <class K, class T>
	static bool compareByValue(std::pair<K, T> a, std::pair<K, T> b) {
		return a.second < b.second;
	}

	// Returns true if any storage servers have the exact same network address or are not using the correct key value
	// store type
																#line 7320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkForUndesirableServers()
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckForUndesirableServersActor>
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForUndesirableServersActorState {
															#line 7326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForUndesirableServersActorState(Database const& cx,DatabaseConfiguration const& configuration,ConsistencyCheckWorkload* const& self) 
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   configuration(configuration),
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self),
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   i(),
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   j()
															#line 7341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkForUndesirableServers", reinterpret_cast<unsigned long>(this));

	}
	~CheckForUndesirableServersActorState() 
	{
		fdb_probe_actor_destroy("checkForUndesirableServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<StorageServerInterface>> __when_expr_0 = getStorageServers(cx);
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state = 1;
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*>(static_cast<CheckForUndesirableServersActor*>(this)));
															#line 7363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckForUndesirableServersActorState();
		static_cast<CheckForUndesirableServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		wiggleLocalityKeyValue = configuration.perpetualStorageWiggleLocality;
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		wiggleLocalityKeyValues = ParsePerpetualStorageWiggleLocality(configuration.perpetualStorageWiggleLocality);
															#line 941 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i = 0;
															#line 7390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> const& __storageServers,int loopDepth) 
	{
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		storageServers = __storageServers;
															#line 7399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> && __storageServers,int loopDepth) 
	{
		storageServers = std::move(__storageServers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state > 0) static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForUndesirableServersActor*>(this)->ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1004 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(false);
		this->~CheckForUndesirableServersActorState();
		static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 941 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(i < storageServers.size()))
															#line 7497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ReplyPromise<KeyValueStoreType> typeReply;
															#line 944 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<ErrorOr<KeyValueStoreType>> __when_expr_1 = storageServers[i].getKeyValueStoreType.getReplyUnlessFailedFor(typeReply, 2, 0);
															#line 944 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state = 2;
															#line 944 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*>(static_cast<CheckForUndesirableServersActor*>(this)));
															#line 7512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(ErrorOr<KeyValueStoreType> const& keyValueStoreType,int loopDepth) 
	{
															#line 947 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!keyValueStoreType.present())
															#line 7534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ServerUnavailable").detail("ServerID", storageServers[i].id());
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Storage server unavailable");
															#line 7540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (configuration.perpetualStoreType.isValid())
															#line 7546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (wiggleLocalityKeyValue == "0" || localityMatchInList(wiggleLocalityKeyValues, storageServers[i].locality))
															#line 7550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (keyValueStoreType.get() != configuration.perpetualStoreType)
															#line 7554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 956 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.perpetualStoreType.toString()) .detail("IsPerpetualStoreType", true);
															#line 961 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Storage server has wrong key-value store type");
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
						this->~CheckForUndesirableServersActorState();
						static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
				else
				{
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if ((!storageServers[i].isTss() && keyValueStoreType.get() != configuration.storageServerStoreType) || (storageServers[i].isTss() && keyValueStoreType.get() != configuration.testingStorageServerStoreType))
															#line 7573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.perpetualStoreType.toString()) .detail("IsPerpetualStoreType", false);
															#line 973 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Storage server has wrong key-value store type");
															#line 974 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
						this->~CheckForUndesirableServersActorState();
						static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
			else
			{
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (((!storageServers[i].isTss() && keyValueStoreType.get() != configuration.storageServerStoreType) || (storageServers[i].isTss() && keyValueStoreType.get() != configuration.testingStorageServerStoreType)) && (wiggleLocalityKeyValue == "0" || localityMatchInList(wiggleLocalityKeyValues, storageServers[i].locality)))
															#line 7593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 982 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.storageServerStoreType.toString()) .detail("IsPerpetualStoreType", false);
															#line 987 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					self->testFailure("Storage server has wrong key-value store type");
															#line 988 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
					this->~CheckForUndesirableServersActorState();
					static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 992 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(j = i + 1;j < storageServers.size();j++) {
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (storageServers[i].address() == storageServers[j].address())
															#line 7613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 994 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_UndesirableServer") .detail("StorageServer1", storageServers[i].id()) .detail("StorageServer2", storageServers[j].id()) .detail("Address", storageServers[i].address());
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				self->testFailure("Multiple storage servers have the same address");
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7621 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
				this->~CheckForUndesirableServersActorState();
				static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 941 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i++;
															#line 7630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(ErrorOr<KeyValueStoreType> && keyValueStoreType,int loopDepth) 
	{
															#line 947 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!keyValueStoreType.present())
															#line 7639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ServerUnavailable").detail("ServerID", storageServers[i].id());
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Storage server unavailable");
															#line 7645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (configuration.perpetualStoreType.isValid())
															#line 7651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (wiggleLocalityKeyValue == "0" || localityMatchInList(wiggleLocalityKeyValues, storageServers[i].locality))
															#line 7655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (keyValueStoreType.get() != configuration.perpetualStoreType)
															#line 7659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 956 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.perpetualStoreType.toString()) .detail("IsPerpetualStoreType", true);
															#line 961 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Storage server has wrong key-value store type");
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
						this->~CheckForUndesirableServersActorState();
						static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
				else
				{
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if ((!storageServers[i].isTss() && keyValueStoreType.get() != configuration.storageServerStoreType) || (storageServers[i].isTss() && keyValueStoreType.get() != configuration.testingStorageServerStoreType))
															#line 7678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.perpetualStoreType.toString()) .detail("IsPerpetualStoreType", false);
															#line 973 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Storage server has wrong key-value store type");
															#line 974 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
						this->~CheckForUndesirableServersActorState();
						static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
			else
			{
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (((!storageServers[i].isTss() && keyValueStoreType.get() != configuration.storageServerStoreType) || (storageServers[i].isTss() && keyValueStoreType.get() != configuration.testingStorageServerStoreType)) && (wiggleLocalityKeyValue == "0" || localityMatchInList(wiggleLocalityKeyValues, storageServers[i].locality)))
															#line 7698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 982 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.storageServerStoreType.toString()) .detail("IsPerpetualStoreType", false);
															#line 987 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					self->testFailure("Storage server has wrong key-value store type");
															#line 988 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
					this->~CheckForUndesirableServersActorState();
					static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 992 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(j = i + 1;j < storageServers.size();j++) {
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (storageServers[i].address() == storageServers[j].address())
															#line 7718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 994 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_UndesirableServer") .detail("StorageServer1", storageServers[i].id()) .detail("StorageServer2", storageServers[j].id()) .detail("Address", storageServers[i].address());
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				self->testFailure("Multiple storage servers have the same address");
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
				this->~CheckForUndesirableServersActorState();
				static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 941 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i++;
															#line 7735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ErrorOr<KeyValueStoreType> const& keyValueStoreType,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(keyValueStoreType, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ErrorOr<KeyValueStoreType> && keyValueStoreType,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(keyValueStoreType), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state > 0) static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForUndesirableServersActor*>(this)->ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*,ErrorOr<KeyValueStoreType> const& value) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*,ErrorOr<KeyValueStoreType> && value) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	DatabaseConfiguration configuration;
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int i;
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int j;
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> storageServers;
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::string wiggleLocalityKeyValue;
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<std::pair<Optional<Value>, Optional<Value>>> wiggleLocalityKeyValues;
															#line 7831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkForUndesirableServers()
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForUndesirableServersActor final : public Actor<bool>, public ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >, public ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >, public FastAllocated<CheckForUndesirableServersActor>, public CheckForUndesirableServersActorState<CheckForUndesirableServersActor> {
															#line 7836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckForUndesirableServersActor>::operator new;
	using FastAllocated<CheckForUndesirableServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8920656917757853696UL, 5712002594221243648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >;
friend struct ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >;
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForUndesirableServersActor(Database const& cx,DatabaseConfiguration const& configuration,ConsistencyCheckWorkload* const& self) 
															#line 7854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckForUndesirableServersActorState<CheckForUndesirableServersActor>(cx, configuration, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11876187790522090240UL, 13735064405301590272UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkForUndesirableServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkForUndesirableServers( Database const& cx, DatabaseConfiguration const& configuration, ConsistencyCheckWorkload* const& self ) {
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckForUndesirableServersActor(cx, configuration, self));
															#line 7887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1006 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Every storage server should have it metadata populated and no metadata leak when the database reach the quiescent
	// state
																#line 7894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkStorageMetadata()
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckStorageMetadataActor>
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckStorageMetadataActorState {
															#line 7900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckStorageMetadataActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self),
															#line 1010 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   metadataMap(serverMetadataKeys.begin, IncludeVersion()),
															#line 1012 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   servers(),
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   id_ssi(),
															#line 1014 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   tr(cx)
															#line 7917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	~CheckStorageMetadataActorState() 
	{
		fdb_probe_actor_destroy("checkStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 7932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckStorageMetadataActorState();
		static_cast<CheckStorageMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1037 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( auto& ssi : servers ) {
															#line 1038 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(id_ssi.contains(ssi.id()));
															#line 7957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1040 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckStorageMetadataActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckStorageMetadataActorState(); static_cast<CheckStorageMetadataActor*>(this)->destroy(); return 0; }
															#line 7961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckStorageMetadataActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckStorageMetadataActorState();
		static_cast<CheckStorageMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1016 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		servers.clear();
															#line 1017 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		id_ssi.clear();
															#line 1018 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1019 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 7986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		try {
															#line 1021 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<KeyBackedRangeResult<std::pair<UID, StorageMetadataType>>> __when_expr_0 = metadataMap.getRange(&tr, {}, {}, CLIENT_KNOBS->TOO_MANY);
															#line 1021 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 1;
															#line 1021 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*>(static_cast<CheckStorageMetadataActor*>(this)));
															#line 7997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1033 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 1033 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 3;
															#line 1033 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckStorageMetadataActor, 2, Void >*>(static_cast<CheckStorageMetadataActor*>(this)));
															#line 8039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1023 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(!metadata.more && metadata.results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1024 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1024 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 2;
															#line 1024 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*>(static_cast<CheckStorageMetadataActor*>(this)));
															#line 8063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> const& __metadata,int loopDepth) 
	{
															#line 1021 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		metadata = __metadata;
															#line 8072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> && __metadata,int loopDepth) 
	{
		metadata = std::move(__metadata);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckStorageMetadataActor*>(this)->ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*,KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> const& value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*,KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> && value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& serverList,int loopDepth) 
	{
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1026 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT_EQ(metadata.results.size(), serverList.size());
															#line 1027 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		id_ssi = std::unordered_map<UID, StorageMetadataType>(metadata.results.begin(), metadata.results.end());
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		servers.reserve(serverList.size());
															#line 1029 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 1030 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			servers.push_back(decodeServerListValue(serverList[i].value));
															#line 8161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && serverList,int loopDepth) 
	{
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1026 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT_EQ(metadata.results.size(), serverList.size());
															#line 1027 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		id_ssi = std::unordered_map<UID, StorageMetadataType>(metadata.results.begin(), metadata.results.end());
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		servers.reserve(serverList.size());
															#line 1029 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 1030 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			servers.push_back(decodeServerListValue(serverList[i].value));
															#line 8181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(serverList, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(serverList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckStorageMetadataActor*>(this)->ActorCallback< CheckStorageMetadataActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckStorageMetadataActor*>(this)->ActorCallback< CheckStorageMetadataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckStorageMetadataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 1010 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	KeyBackedObjectMap<UID, StorageMetadataType, decltype(IncludeVersion())> metadataMap;
															#line 1012 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> servers;
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::unordered_map<UID, StorageMetadataType> id_ssi;
															#line 1014 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Transaction tr;
															#line 1021 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> metadata;
															#line 8363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkStorageMetadata()
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckStorageMetadataActor final : public Actor<bool>, public ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >, public ActorCallback< CheckStorageMetadataActor, 1, RangeResult >, public ActorCallback< CheckStorageMetadataActor, 2, Void >, public FastAllocated<CheckStorageMetadataActor>, public CheckStorageMetadataActorState<CheckStorageMetadataActor> {
															#line 8368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckStorageMetadataActor>::operator new;
	using FastAllocated<CheckStorageMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15437891508808641792UL, 4786594699390492160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >;
friend struct ActorCallback< CheckStorageMetadataActor, 1, RangeResult >;
friend struct ActorCallback< CheckStorageMetadataActor, 2, Void >;
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckStorageMetadataActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 8387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckStorageMetadataActorState<CheckStorageMetadataActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14773869242612564736UL, 6352906758137099520UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkStorageMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckStorageMetadataActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkStorageMetadata( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckStorageMetadataActor(cx, self));
															#line 8421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1042 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Returns false if any worker that should have a storage server does not have one
																#line 8427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkForStorage()
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckForStorageActor>
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForStorageActorState {
															#line 8433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForStorageActorState(Database const& cx,DatabaseConfiguration const& configuration,std::map<UID, StorageServerInterface> const& tssMapping,ConsistencyCheckWorkload* const& self) 
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   configuration(configuration),
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   tssMapping(tssMapping),
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 8446 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkForStorage", reinterpret_cast<unsigned long>(this));

	}
	~CheckForStorageActorState() 
	{
		fdb_probe_actor_destroy("checkForStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckForStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckForStorageActor*>(this)->actor_wait_state = 1;
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*>(static_cast<CheckForStorageActor*>(this)));
															#line 8468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckForStorageActorState();
		static_cast<CheckForStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckForStorageActor*>(this)->actor_wait_state = 2;
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*>(static_cast<CheckForStorageActor*>(this)));
															#line 8498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		workers = __workers;
															#line 8507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckForStorageActor*>(this)->actor_wait_state > 0) static_cast<CheckForStorageActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForStorageActor*>(this)->ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1050 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::vector<Optional<Key>> missingStorage;
															#line 1052 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 1053 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			NetworkAddress addr = workers[i].interf.stableAddress();
															#line 1054 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!configuration.isExcludedServer(workers[i].interf.addresses(), workers[i].interf.locality) && (workers[i].processClass == ProcessClass::StorageClass || workers[i].processClass == ProcessClass::UnsetClass))
															#line 8592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1057 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				bool found = false;
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				for(int j = 0;j < storageServers.size();j++) {
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (storageServers[j].stableAddress() == addr)
															#line 8600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						found = true;
															#line 8604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						break;
					}
				}
															#line 1064 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!found)
															#line 8610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1065 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_NoStorage") .detail("Address", addr) .detail("ProcessId", workers[i].interf.locality.processId()) .detail("ProcessClassEqualToStorageClass", (int)(workers[i].processClass == ProcessClass::StorageClass));
															#line 1070 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					missingStorage.push_back(workers[i].interf.locality.dcId());
															#line 8616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
		}
															#line 1075 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		int missingDc0 = configuration.regions.size() == 0 ? 0 : std::count(missingStorage.begin(), missingStorage.end(), configuration.regions[0].dcId);
															#line 1078 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		int missingDc1 = configuration.regions.size() < 2 ? 0 : std::count(missingStorage.begin(), missingStorage.end(), configuration.regions[1].dcId);
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if ((configuration.regions.size() == 0 && missingStorage.size()) || (configuration.regions.size() == 1 && missingDc0) || (configuration.regions.size() == 2 && configuration.usableRegions == 1 && missingDc0 && missingDc1) || (configuration.regions.size() == 2 && configuration.usableRegions > 1 && (missingDc0 || missingDc1)))
															#line 8626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1088 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			bool couldExpectMissingTss = (configuration.desiredTSSCount - tssMapping.size()) > 0;
															#line 1090 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			int countMissing = missingStorage.size();
															#line 1091 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			int acceptableTssMissing = 1;
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (configuration.regions.size() == 1)
															#line 8636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1093 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				countMissing = missingDc0;
															#line 8640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
			else
			{
															#line 1094 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (configuration.regions.size() == 2)
															#line 8646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1095 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (configuration.usableRegions == 1)
															#line 8650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						countMissing = std::min(missingDc0, missingDc1);
															#line 8654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					}
					else
					{
															#line 1098 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (configuration.usableRegions == 2)
															#line 8660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						{
															#line 1099 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							countMissing = missingDc0 + missingDc1;
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							acceptableTssMissing = 2;
															#line 8666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						}
						else
						{
															#line 1102 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							ASSERT(false);
															#line 8672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						}
					}
				}
			}
															#line 1106 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!couldExpectMissingTss || countMissing > acceptableTssMissing)
															#line 8679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1107 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				self->testFailure("No storage server on worker");
															#line 1108 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckForStorageActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForStorageActorState(); static_cast<CheckForStorageActor*>(this)->destroy(); return 0; }
															#line 8685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckForStorageActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckForStorageActorState();
				static_cast<CheckForStorageActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 1110 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent(SevWarn, "ConsistencyCheck_TSSMissing").log();
															#line 8695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 1114 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckForStorageActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForStorageActorState(); static_cast<CheckForStorageActor*>(this)->destroy(); return 0; }
															#line 8700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckForStorageActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckForStorageActorState();
		static_cast<CheckForStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<StorageServerInterface> const& __storageServers,int loopDepth) 
	{
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		storageServers = __storageServers;
															#line 8712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<StorageServerInterface> && __storageServers,int loopDepth) 
	{
		storageServers = std::move(__storageServers);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckForStorageActor*>(this)->actor_wait_state > 0) static_cast<CheckForStorageActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForStorageActor*>(this)->ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	DatabaseConfiguration configuration;
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> storageServers;
															#line 8799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkForStorage()
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForStorageActor final : public Actor<bool>, public ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >, public ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >, public FastAllocated<CheckForStorageActor>, public CheckForStorageActorState<CheckForStorageActor> {
															#line 8804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckForStorageActor>::operator new;
	using FastAllocated<CheckForStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14753832274112897536UL, 170390277957436672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >;
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForStorageActor(Database const& cx,DatabaseConfiguration const& configuration,std::map<UID, StorageServerInterface> const& tssMapping,ConsistencyCheckWorkload* const& self) 
															#line 8822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckForStorageActorState<CheckForStorageActor>(cx, configuration, tssMapping, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8398300410677844736UL, 6230040935244071680UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkForStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkForStorage( Database const& cx, DatabaseConfiguration const& configuration, std::map<UID, StorageServerInterface> const& tssMapping, ConsistencyCheckWorkload* const& self ) {
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckForStorageActor(cx, configuration, tssMapping, self));
															#line 8855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1116 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

																#line 8860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkForExtraDataStores()
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckForExtraDataStoresActor>
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForExtraDataStoresActorState {
															#line 8866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForExtraDataStoresActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 8875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkForExtraDataStores", reinterpret_cast<unsigned long>(this));

	}
	~CheckForExtraDataStoresActorState() 
	{
		fdb_probe_actor_destroy("checkForExtraDataStores", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 1;
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*>(static_cast<CheckForExtraDataStoresActor*>(this)));
															#line 8897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckForExtraDataStoresActorState();
		static_cast<CheckForExtraDataStoresActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1119 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 1119 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 2;
															#line 1119 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*>(static_cast<CheckForExtraDataStoresActor*>(this)));
															#line 8927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		workers = __workers;
															#line 8936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state > 0) static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExtraDataStoresActor*>(this)->ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<WorkerInterface>> __when_expr_2 = getCoordWorkers(cx, self->dbInfo);
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 3;
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*>(static_cast<CheckForExtraDataStoresActor*>(this)));
															#line 9022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<StorageServerInterface> const& __storageServers,int loopDepth) 
	{
															#line 1119 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		storageServers = __storageServers;
															#line 9031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<StorageServerInterface> && __storageServers,int loopDepth) 
	{
		storageServers = std::move(__storageServers);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state > 0) static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExtraDataStoresActor*>(this)->ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1121 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		auto& db = self->dbInfo->get();
															#line 1122 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		logs = db.logSystemConfig.allPresentLogs();
															#line 1124 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		itr = std::vector<WorkerDetails>::iterator();
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		foundExtraDataStore = false;
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		protectedProcessesToKill = std::vector<struct ProcessInfo*>();
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		statefulProcesses = std::map<NetworkAddress, std::set<UID>>();
															#line 1129 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& ss : storageServers ) {
															#line 1130 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			statefulProcesses[ss.address()].insert(ss.id());
															#line 1132 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (ss.secondaryAddress().present())
															#line 9126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1133 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				statefulProcesses[ss.secondaryAddress().get()].insert(ss.id());
															#line 9130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 1135 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevCCheckInfo, "StatefulProcess") .detail("StorageServer", ss.id()) .detail("PrimaryAddress", ss.address().toString()) .detail("SecondaryAddress", ss.secondaryAddress().present() ? ss.secondaryAddress().get().toString() : "Unset");
															#line 9134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& log : logs ) {
															#line 1142 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			statefulProcesses[log.address()].insert(log.id());
															#line 1143 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (log.secondaryAddress().present())
															#line 9142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1144 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				statefulProcesses[log.secondaryAddress().get()].insert(log.id());
															#line 9146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 1146 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevCCheckInfo, "StatefulProcess") .detail("Log", log.id()) .detail("PrimaryAddress", log.address().toString()) .detail("SecondaryAddress", log.secondaryAddress().present() ? log.secondaryAddress().get().toString() : "Unset");
															#line 9150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1153 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& cWorker : coordWorkers ) {
															#line 1154 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			statefulProcesses[cWorker.address()].insert(cWorker.id());
															#line 1155 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (cWorker.secondaryAddress().present())
															#line 9158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1156 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				statefulProcesses[cWorker.secondaryAddress().get()].insert(cWorker.id());
															#line 9162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 1158 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevCCheckInfo, "StatefulProcess") .detail("Coordinator", cWorker.id()) .detail("PrimaryAddress", cWorker.address().toString()) .detail("SecondaryAddress", cWorker.secondaryAddress().present() ? cWorker.secondaryAddress().get().toString() : "Unset");
															#line 9166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		itr = workers.begin();
															#line 9170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<WorkerInterface> const& __coordWorkers,int loopDepth) 
	{
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		coordWorkers = __coordWorkers;
															#line 9179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<WorkerInterface> && __coordWorkers,int loopDepth) 
	{
		coordWorkers = std::move(__coordWorkers);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state > 0) static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExtraDataStoresActor*>(this)->ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*,std::vector<WorkerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*,std::vector<WorkerInterface> && value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (foundExtraDataStore)
															#line 9258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1219 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Extra data stores present on workers");
															#line 1220 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckForExtraDataStoresActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForExtraDataStoresActorState(); static_cast<CheckForExtraDataStoresActor*>(this)->destroy(); return 0; }
															#line 9264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckForExtraDataStoresActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckForExtraDataStoresActorState();
			static_cast<CheckForExtraDataStoresActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1223 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckForExtraDataStoresActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForExtraDataStoresActorState(); static_cast<CheckForExtraDataStoresActor*>(this)->destroy(); return 0; }
															#line 9272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckForExtraDataStoresActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckForExtraDataStoresActorState();
		static_cast<CheckForExtraDataStoresActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(itr != workers.end()))
															#line 9291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1166 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<ErrorOr<Standalone<VectorRef<UID>>>> __when_expr_3 = itr->interf.diskStoreRequest.getReplyUnlessFailedFor(DiskStoreRequest(false), 2, 0);
															#line 1166 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 4;
															#line 1166 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*>(static_cast<CheckForExtraDataStoresActor*>(this)));
															#line 9304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(ErrorOr<Standalone<VectorRef<UID>>> const& stores,int loopDepth) 
	{
															#line 1168 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (stores.isError())
															#line 9326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1169 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_GetDataStoreFailure") .error(stores.getError()) .detail("Address", itr->interf.address());
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Failed to get data stores");
															#line 1173 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckForExtraDataStoresActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForExtraDataStoresActorState(); static_cast<CheckForExtraDataStoresActor*>(this)->destroy(); return 0; }
															#line 9334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckForExtraDataStoresActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckForExtraDataStoresActorState();
			static_cast<CheckForExtraDataStoresActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1176 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent(SevCCheckInfo, "ConsistencyCheck_ExtraDataStore") .detail("Worker", itr->interf.id().toString()) .detail("PrimaryAddress", itr->interf.address().toString()) .detail("SecondaryAddress", itr->interf.secondaryAddress().present() ? itr->interf.secondaryAddress().get().toString() : "Unset");
															#line 1182 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& id : stores.get() ) {
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (statefulProcesses[itr->interf.address()].contains(id))
															#line 9346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
				continue;
			}
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ExtraDataStore") .detail("Address", itr->interf.address()) .detail("DataStoreID", id);
															#line 1190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (g_network->isSimulated())
															#line 9354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				ISimulator::ProcessInfo* p = g_simulator->getProcessByAddress(itr->interf.address());
															#line 1197 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_RebootProcess") .detail("Address", itr->interf.address()) .detail("ProcessPrimaryAddress", p->address) .detail("ProcessAddresses", p->addresses.toString()) .detail("DataStoreID", id) .detail("Protected", g_simulator->protectedAddresses.contains(itr->interf.address())) .detail("Reliable", p->isReliable()) .detail("ReliableInfo", p->getReliableInfo()) .detail("KillOrRebootProcess", p->address);
															#line 1207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (p->isReliable())
															#line 9362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					g_simulator->rebootProcess(p, ISimulator::KillType::RebootProcess);
															#line 9366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
				else
				{
															#line 1210 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					g_simulator->killProcess(p, ISimulator::KillType::KillInstantly);
															#line 9372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			foundExtraDataStore = true;
															#line 9377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		++itr;
															#line 9381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(ErrorOr<Standalone<VectorRef<UID>>> && stores,int loopDepth) 
	{
															#line 1168 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (stores.isError())
															#line 9390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1169 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_GetDataStoreFailure") .error(stores.getError()) .detail("Address", itr->interf.address());
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Failed to get data stores");
															#line 1173 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckForExtraDataStoresActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForExtraDataStoresActorState(); static_cast<CheckForExtraDataStoresActor*>(this)->destroy(); return 0; }
															#line 9398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckForExtraDataStoresActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckForExtraDataStoresActorState();
			static_cast<CheckForExtraDataStoresActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1176 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent(SevCCheckInfo, "ConsistencyCheck_ExtraDataStore") .detail("Worker", itr->interf.id().toString()) .detail("PrimaryAddress", itr->interf.address().toString()) .detail("SecondaryAddress", itr->interf.secondaryAddress().present() ? itr->interf.secondaryAddress().get().toString() : "Unset");
															#line 1182 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& id : stores.get() ) {
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (statefulProcesses[itr->interf.address()].contains(id))
															#line 9410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
				continue;
			}
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ExtraDataStore") .detail("Address", itr->interf.address()) .detail("DataStoreID", id);
															#line 1190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (g_network->isSimulated())
															#line 9418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1194 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				ISimulator::ProcessInfo* p = g_simulator->getProcessByAddress(itr->interf.address());
															#line 1197 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_RebootProcess") .detail("Address", itr->interf.address()) .detail("ProcessPrimaryAddress", p->address) .detail("ProcessAddresses", p->addresses.toString()) .detail("DataStoreID", id) .detail("Protected", g_simulator->protectedAddresses.contains(itr->interf.address())) .detail("Reliable", p->isReliable()) .detail("ReliableInfo", p->getReliableInfo()) .detail("KillOrRebootProcess", p->address);
															#line 1207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (p->isReliable())
															#line 9426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					g_simulator->rebootProcess(p, ISimulator::KillType::RebootProcess);
															#line 9430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
				else
				{
															#line 1210 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					g_simulator->killProcess(p, ISimulator::KillType::KillInstantly);
															#line 9436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			foundExtraDataStore = true;
															#line 9441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		++itr;
															#line 9445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(ErrorOr<Standalone<VectorRef<UID>>> const& stores,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(stores, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(ErrorOr<Standalone<VectorRef<UID>>> && stores,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(stores), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state > 0) static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExtraDataStoresActor*>(this)->ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*,ErrorOr<Standalone<VectorRef<UID>>> const& value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*,ErrorOr<Standalone<VectorRef<UID>>> && value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 1119 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> storageServers;
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerInterface> coordWorkers;
															#line 1122 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<TLogInterface> logs;
															#line 1124 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails>::iterator itr;
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	bool foundExtraDataStore;
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<struct ProcessInfo*> protectedProcessesToKill;
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::map<NetworkAddress, std::set<UID>> statefulProcesses;
															#line 9545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkForExtraDataStores()
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForExtraDataStoresActor final : public Actor<bool>, public ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >, public ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >, public ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >, public ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >, public FastAllocated<CheckForExtraDataStoresActor>, public CheckForExtraDataStoresActorState<CheckForExtraDataStoresActor> {
															#line 9550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckForExtraDataStoresActor>::operator new;
	using FastAllocated<CheckForExtraDataStoresActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14624937155574882816UL, 13782748730234707712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >;
friend struct ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >;
friend struct ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >;
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForExtraDataStoresActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 9570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckForExtraDataStoresActorState<CheckForExtraDataStoresActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(427473886050604288UL, 3872966658194644992UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkForExtraDataStores");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkForExtraDataStores( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckForExtraDataStoresActor(cx, self));
															#line 9605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1225 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Checks if the blob workers are "correct".
	// Returns false if ANY of the following
	// - any blob worker is on a diff DC than the blob manager/CC, or
	// - any worker that should have a blob worker does not have exactly one, or
	// - any worker that should NOT have a blob worker does indeed have one
																#line 9615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkBlobWorkers()
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckBlobWorkersActor>
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckBlobWorkersActorState {
															#line 9621 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckBlobWorkersActorState(Database const& cx,DatabaseConfiguration const& configuration,ConsistencyCheckWorkload* const& self) 
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   configuration(configuration),
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 9632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkBlobWorkers", reinterpret_cast<unsigned long>(this));

	}
	~CheckBlobWorkersActorState() 
	{
		fdb_probe_actor_destroy("checkBlobWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<BlobWorkerInterface>> __when_expr_0 = getBlobWorkers(cx, true);
															#line 1234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckBlobWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckBlobWorkersActor*>(this)->actor_wait_state = 1;
															#line 1234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckBlobWorkersActor, 0, std::vector<BlobWorkerInterface> >*>(static_cast<CheckBlobWorkersActor*>(this)));
															#line 9654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckBlobWorkersActorState();
		static_cast<CheckBlobWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1235 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_1 = getWorkers(self->dbInfo);
															#line 1235 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckBlobWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckBlobWorkersActor*>(this)->actor_wait_state = 2;
															#line 1235 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckBlobWorkersActor, 1, std::vector<WorkerDetails> >*>(static_cast<CheckBlobWorkersActor*>(this)));
															#line 9684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<BlobWorkerInterface> const& __blobWorkers,int loopDepth) 
	{
															#line 1234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		blobWorkers = __blobWorkers;
															#line 9693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<BlobWorkerInterface> && __blobWorkers,int loopDepth) 
	{
		blobWorkers = std::move(__blobWorkers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckBlobWorkersActor*>(this)->actor_wait_state > 0) static_cast<CheckBlobWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<CheckBlobWorkersActor*>(this)->ActorCallback< CheckBlobWorkersActor, 0, std::vector<BlobWorkerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckBlobWorkersActor, 0, std::vector<BlobWorkerInterface> >*,std::vector<BlobWorkerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkBlobWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBlobWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckBlobWorkersActor, 0, std::vector<BlobWorkerInterface> >*,std::vector<BlobWorkerInterface> && value) 
	{
		fdb_probe_actor_enter("checkBlobWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBlobWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckBlobWorkersActor, 0, std::vector<BlobWorkerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkBlobWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBlobWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1238 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		blobWorkersByAddr = std::unordered_map<NetworkAddress, int>();
															#line 1239 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		Optional<Key> ccDcId;
															#line 1240 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		NetworkAddress ccAddr = self->dbInfo->get().clusterInterface.clientInterface.address();
															#line 1243 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& worker : workers ) {
															#line 1244 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (ccAddr == worker.interf.address())
															#line 9780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1245 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				ccDcId = worker.interf.locality.dcId();
															#line 9784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				break;
			}
		}
															#line 1250 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!ccDcId.present())
															#line 9790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1251 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_DidNotFindCC");
															#line 1252 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckBlobWorkersActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckBlobWorkersActorState(); static_cast<CheckBlobWorkersActor*>(this)->destroy(); return 0; }
															#line 9796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckBlobWorkersActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckBlobWorkersActorState();
			static_cast<CheckBlobWorkersActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1255 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& bwi : blobWorkers ) {
															#line 1256 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (bwi.locality.dcId() != ccDcId)
															#line 9806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1257 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_BWOnDiffDcThanCC") .detail("BWID", bwi.id()) .detail("BwDcId", bwi.locality.dcId()) .detail("CcDcId", ccDcId);
															#line 1261 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckBlobWorkersActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckBlobWorkersActorState(); static_cast<CheckBlobWorkersActor*>(this)->destroy(); return 0; }
															#line 9812 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckBlobWorkersActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckBlobWorkersActorState();
				static_cast<CheckBlobWorkersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1263 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			blobWorkersByAddr[bwi.stableAddress()]++;
															#line 9820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1266 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		int numBlobWorkerProcesses = 0;
															#line 1267 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& worker : workers ) {
															#line 1268 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			NetworkAddress addr = worker.interf.stableAddress();
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			bool inCCDc = worker.interf.locality.dcId() == ccDcId;
															#line 1270 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!configuration.isExcludedServer(worker.interf.addresses(), worker.interf.locality))
															#line 9832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1271 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (worker.processClass == ProcessClass::BlobWorkerClass)
															#line 9836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1272 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					numBlobWorkerProcesses++;
															#line 1276 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					int desiredBlobWorkersOnAddr = inCCDc ? 1 : 0;
															#line 1278 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (blobWorkersByAddr[addr] != desiredBlobWorkersOnAddr)
															#line 9844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 1279 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("ConsistencyCheck_WrongBWCountOnBWClass") .detail("Address", addr) .detail("NumBlobWorkersOnAddr", blobWorkersByAddr[addr]) .detail("DesiredBlobWorkersOnAddr", desiredBlobWorkersOnAddr) .detail("BwDcId", worker.interf.locality.dcId()) .detail("CcDcId", ccDcId);
															#line 1285 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<CheckBlobWorkersActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckBlobWorkersActorState(); static_cast<CheckBlobWorkersActor*>(this)->destroy(); return 0; }
															#line 9850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<CheckBlobWorkersActor*>(this)->SAV< bool >::value()) bool(false);
						this->~CheckBlobWorkersActorState();
						static_cast<CheckBlobWorkersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
				else
				{
															#line 1289 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (blobWorkersByAddr[addr] > 0)
															#line 9861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 1290 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("ConsistencyCheck_BWOnNonBWClass").detail("Address", addr);
															#line 1291 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<CheckBlobWorkersActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckBlobWorkersActorState(); static_cast<CheckBlobWorkersActor*>(this)->destroy(); return 0; }
															#line 9867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<CheckBlobWorkersActor*>(this)->SAV< bool >::value()) bool(false);
						this->~CheckBlobWorkersActorState();
						static_cast<CheckBlobWorkersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
			else
			{
															#line 1294 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (blobWorkersByAddr[addr] > 0)
															#line 9879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1295 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_BWOnExcludedAddr").detail("Address", addr);
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckBlobWorkersActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckBlobWorkersActorState(); static_cast<CheckBlobWorkersActor*>(this)->destroy(); return 0; }
															#line 9885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckBlobWorkersActor*>(this)->SAV< bool >::value()) bool(false);
					this->~CheckBlobWorkersActorState();
					static_cast<CheckBlobWorkersActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 1299 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckBlobWorkersActor*>(this)->SAV<bool>::futures) { (void)(numBlobWorkerProcesses > 0); this->~CheckBlobWorkersActorState(); static_cast<CheckBlobWorkersActor*>(this)->destroy(); return 0; }
															#line 9895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckBlobWorkersActor*>(this)->SAV< bool >::value()) bool(numBlobWorkerProcesses > 0);
		this->~CheckBlobWorkersActorState();
		static_cast<CheckBlobWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 1235 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		workers = __workers;
															#line 9907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckBlobWorkersActor*>(this)->actor_wait_state > 0) static_cast<CheckBlobWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<CheckBlobWorkersActor*>(this)->ActorCallback< CheckBlobWorkersActor, 1, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckBlobWorkersActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkBlobWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBlobWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckBlobWorkersActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkBlobWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBlobWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckBlobWorkersActor, 1, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkBlobWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBlobWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	DatabaseConfiguration configuration;
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 1234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<BlobWorkerInterface> blobWorkers;
															#line 1235 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 1238 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::unordered_map<NetworkAddress, int> blobWorkersByAddr;
															#line 9994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkBlobWorkers()
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckBlobWorkersActor final : public Actor<bool>, public ActorCallback< CheckBlobWorkersActor, 0, std::vector<BlobWorkerInterface> >, public ActorCallback< CheckBlobWorkersActor, 1, std::vector<WorkerDetails> >, public FastAllocated<CheckBlobWorkersActor>, public CheckBlobWorkersActorState<CheckBlobWorkersActor> {
															#line 9999 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckBlobWorkersActor>::operator new;
	using FastAllocated<CheckBlobWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(964607620288130048UL, 1759662490700294400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckBlobWorkersActor, 0, std::vector<BlobWorkerInterface> >;
friend struct ActorCallback< CheckBlobWorkersActor, 1, std::vector<WorkerDetails> >;
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckBlobWorkersActor(Database const& cx,DatabaseConfiguration const& configuration,ConsistencyCheckWorkload* const& self) 
															#line 10017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckBlobWorkersActorState<CheckBlobWorkersActor>(cx, configuration, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkBlobWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13858536736549232128UL, 9430917473220222976UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkBlobWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkBlobWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckBlobWorkersActor, 0, std::vector<BlobWorkerInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckBlobWorkersActor, 1, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkBlobWorkers( Database const& cx, DatabaseConfiguration const& configuration, ConsistencyCheckWorkload* const& self ) {
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckBlobWorkersActor(cx, configuration, self));
															#line 10050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1301 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

																#line 10055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkWorkerList()
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckWorkerListActor>
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckWorkerListActorState {
															#line 10061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckWorkerListActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 10070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkWorkerList", reinterpret_cast<unsigned long>(this));

	}
	~CheckWorkerListActorState() 
	{
		fdb_probe_actor_destroy("checkWorkerList", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1303 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!g_simulator->extraDatabases.empty())
															#line 10085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1304 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 10089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(true);
				this->~CheckWorkerListActorState();
				static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1307 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 1307 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckWorkerListActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckWorkerListActor*>(this)->actor_wait_state = 1;
															#line 1307 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*>(static_cast<CheckWorkerListActor*>(this)));
															#line 10104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckWorkerListActorState();
		static_cast<CheckWorkerListActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
															#line 1308 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::set<NetworkAddress> workerAddresses;
															#line 1310 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& it : workers ) {
															#line 1311 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			NetworkAddress addr = it.interf.tLog.getEndpoint().addresses.getTLSAddress();
															#line 1312 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ISimulator::ProcessInfo* info = g_simulator->getProcessByAddress(addr);
															#line 1313 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!info || info->failed)
															#line 10135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_FailedWorkerInList").detail("Addr", it.interf.address());
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 10141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckWorkerListActorState();
				static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1317 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			workerAddresses.insert(NetworkAddress(addr.ip, addr.port, true, addr.isTLS()));
															#line 10149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1320 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::vector<ISimulator::ProcessInfo*> all = g_simulator->getAllProcesses();
															#line 1321 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < all.size();i++) {
															#line 1322 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (all[i]->isReliable() && all[i]->name == std::string("Server") && all[i]->startingClass != ProcessClass::TesterClass && all[i]->startingClass != ProcessClass::SimHTTPServerClass && all[i]->protocolVersion == g_network->protocolVersion())
															#line 10157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1326 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!workerAddresses.contains(all[i]->address))
															#line 10161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1327 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_WorkerMissingFromList").detail("Addr", all[i]->address);
															#line 1328 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 10167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(false);
					this->~CheckWorkerListActorState();
					static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 1333 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 10177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckWorkerListActorState();
		static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
															#line 1308 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::set<NetworkAddress> workerAddresses;
															#line 1310 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& it : workers ) {
															#line 1311 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			NetworkAddress addr = it.interf.tLog.getEndpoint().addresses.getTLSAddress();
															#line 1312 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ISimulator::ProcessInfo* info = g_simulator->getProcessByAddress(addr);
															#line 1313 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!info || info->failed)
															#line 10197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_FailedWorkerInList").detail("Addr", it.interf.address());
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 10203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckWorkerListActorState();
				static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1317 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			workerAddresses.insert(NetworkAddress(addr.ip, addr.port, true, addr.isTLS()));
															#line 10211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1320 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::vector<ISimulator::ProcessInfo*> all = g_simulator->getAllProcesses();
															#line 1321 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < all.size();i++) {
															#line 1322 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (all[i]->isReliable() && all[i]->name == std::string("Server") && all[i]->startingClass != ProcessClass::TesterClass && all[i]->startingClass != ProcessClass::SimHTTPServerClass && all[i]->protocolVersion == g_network->protocolVersion())
															#line 10219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1326 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!workerAddresses.contains(all[i]->address))
															#line 10223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1327 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_WorkerMissingFromList").detail("Addr", all[i]->address);
															#line 1328 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 10229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(false);
					this->~CheckWorkerListActorState();
					static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 1333 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 10239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckWorkerListActorState();
		static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(workers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckWorkerListActor*>(this)->actor_wait_state > 0) static_cast<CheckWorkerListActor*>(this)->actor_wait_state = 0;
		static_cast<CheckWorkerListActor*>(this)->ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckWorkerListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckWorkerListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckWorkerListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 10326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkWorkerList()
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckWorkerListActor final : public Actor<bool>, public ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >, public FastAllocated<CheckWorkerListActor>, public CheckWorkerListActorState<CheckWorkerListActor> {
															#line 10331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckWorkerListActor>::operator new;
	using FastAllocated<CheckWorkerListActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16954457751511970560UL, 1816146222773962752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >;
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckWorkerListActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 10348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckWorkerListActorState<CheckWorkerListActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkWorkerList", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13452236408503872000UL, 17501392737149118464UL);
		ActorExecutionContextHelper __helper(static_cast<CheckWorkerListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkWorkerList");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkWorkerList", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkWorkerList( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckWorkerListActor(cx, self));
															#line 10380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1335 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	static ProcessClass::Fitness getBestAvailableFitness(
	    const std::vector<ProcessClass::ClassType>& availableClassTypes,
	    ProcessClass::ClusterRole role) {
		ProcessClass::Fitness bestAvailableFitness = ProcessClass::NeverAssign;
		for (auto classType : availableClassTypes) {
			bestAvailableFitness = std::min(
			    bestAvailableFitness, ProcessClass(classType, ProcessClass::InvalidSource).machineClassFitness(role));
		}

		return bestAvailableFitness;
	}

	template <class T>
	static std::string getOptionalString(Optional<T> opt) {
		if (opt.present())
			return opt.get().toString();
		return "NotSet";
	}

																#line 10404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkCoordinators()
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckCoordinatorsActor>
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckCoordinatorsActorState {
															#line 10410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckCoordinatorsActorState(Database const& cx) 
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 1356 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   tr(cx)
															#line 10419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkCoordinators", reinterpret_cast<unsigned long>(this));

	}
	~CheckCoordinatorsActorState() 
	{
		fdb_probe_actor_destroy("checkCoordinators", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1357 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 10434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckCoordinatorsActorState();
		static_cast<CheckCoordinatorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1359 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1360 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(coordinatorsKey);
															#line 1360 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 1;
															#line 1360 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 10474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1393 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 1393 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 4;
															#line 1393 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 3, Void >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 10503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& currentKey,int loopDepth) 
	{
															#line 1362 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!currentKey.present())
															#line 10518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NoCoordinatorKey").log();
															#line 1364 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 10524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckCoordinatorsActorState();
			static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1367 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ClusterConnectionString old(currentKey.get().toString());
															#line 1368 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_1 = old.tryResolveHostnames();
															#line 1368 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 1368 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 10541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && currentKey,int loopDepth) 
	{
															#line 1362 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!currentKey.present())
															#line 10550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NoCoordinatorKey").log();
															#line 1364 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 10556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckCoordinatorsActorState();
			static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1367 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ClusterConnectionString old(currentKey.get().toString());
															#line 1368 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_1 = old.tryResolveHostnames();
															#line 1368 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 1368 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 10573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& currentKey,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(currentKey, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && currentKey,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(currentKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCoordinatorsActor*>(this)->ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1370 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<ProcessData>> __when_expr_2 = ::getWorkers(&tr);
															#line 1370 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 3;
															#line 1370 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 10664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<NetworkAddress> const& __oldCoordinators,int loopDepth) 
	{
															#line 1368 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		oldCoordinators = __oldCoordinators;
															#line 10673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<NetworkAddress> && __oldCoordinators,int loopDepth) 
	{
		oldCoordinators = std::move(__oldCoordinators);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCoordinatorsActor*>(this)->ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(std::vector<ProcessData> const& workers,int loopDepth) 
	{
															#line 1372 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<NetworkAddress, LocalityData> addr_locality;
															#line 1373 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( auto w : workers ) {
															#line 1374 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			addr_locality[w.address] = w.locality;
															#line 10756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1377 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::set<Optional<Standalone<StringRef>>> checkDuplicates;
															#line 1378 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& addr : oldCoordinators ) {
															#line 1379 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			auto findResult = addr_locality.find(addr);
															#line 1380 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (findResult != addr_locality.end())
															#line 10766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (checkDuplicates.contains(findResult->second.zoneId()))
															#line 10770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1382 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_BadCoordinator") .detail("Addr", addr) .detail("NotFound", findResult == addr_locality.end());
															#line 1385 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 10776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(false);
					this->~CheckCoordinatorsActorState();
					static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1387 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				checkDuplicates.insert(findResult->second.zoneId());
															#line 10784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 1391 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 10789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckCoordinatorsActorState();
		static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(std::vector<ProcessData> && workers,int loopDepth) 
	{
															#line 1372 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<NetworkAddress, LocalityData> addr_locality;
															#line 1373 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( auto w : workers ) {
															#line 1374 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			addr_locality[w.address] = w.locality;
															#line 10805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1377 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::set<Optional<Standalone<StringRef>>> checkDuplicates;
															#line 1378 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& addr : oldCoordinators ) {
															#line 1379 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			auto findResult = addr_locality.find(addr);
															#line 1380 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (findResult != addr_locality.end())
															#line 10815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (checkDuplicates.contains(findResult->second.zoneId()))
															#line 10819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1382 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_BadCoordinator") .detail("Addr", addr) .detail("NotFound", findResult == addr_locality.end());
															#line 1385 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 10825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(false);
					this->~CheckCoordinatorsActorState();
					static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1387 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				checkDuplicates.insert(findResult->second.zoneId());
															#line 10833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 1391 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 10838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckCoordinatorsActorState();
		static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(workers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(std::vector<ProcessData> && workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCoordinatorsActor*>(this)->ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCoordinatorsActor*>(this)->ActorCallback< CheckCoordinatorsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckCoordinatorsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1356 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Transaction tr;
															#line 1368 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<NetworkAddress> oldCoordinators;
															#line 11014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkCoordinators()
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckCoordinatorsActor final : public Actor<bool>, public ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >, public ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >, public ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >, public ActorCallback< CheckCoordinatorsActor, 3, Void >, public FastAllocated<CheckCoordinatorsActor>, public CheckCoordinatorsActorState<CheckCoordinatorsActor> {
															#line 11019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckCoordinatorsActor>::operator new;
	using FastAllocated<CheckCoordinatorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5650612985455536128UL, 13369266797134458368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >;
friend struct ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >;
friend struct ActorCallback< CheckCoordinatorsActor, 3, Void >;
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckCoordinatorsActor(Database const& cx) 
															#line 11039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckCoordinatorsActorState<CheckCoordinatorsActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4936341211804007168UL, 10483879935152264448UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkCoordinators");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckCoordinatorsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkCoordinators( Database const& cx ) {
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckCoordinatorsActor(cx));
															#line 11074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1397 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Returns true if all machines in the cluster that specified a desired class are operating in that class
																#line 11080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkUsingDesiredClasses()
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckUsingDesiredClassesActor>
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckUsingDesiredClassesActorState {
															#line 11086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckUsingDesiredClassesActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self),
															#line 1400 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   expectedPrimaryDcId(),
															#line 1401 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   expectedRemoteDcId()
															#line 11099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this));

	}
	~CheckUsingDesiredClassesActorState() 
	{
		fdb_probe_actor_destroy("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1402 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 1402 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 1;
															#line 1402 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*>(static_cast<CheckUsingDesiredClassesActor*>(this)));
															#line 11121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckUsingDesiredClassesActorState();
		static_cast<CheckUsingDesiredClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1403 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_1 = getWorkers(self->dbInfo);
															#line 1403 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 2;
															#line 1403 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*>(static_cast<CheckUsingDesiredClassesActor*>(this)));
															#line 11151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 1402 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		config = __config;
															#line 11160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state > 0) static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckUsingDesiredClassesActor*>(this)->ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1404 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_2 = getWorkers(self->dbInfo, GetWorkersRequest::NON_EXCLUDED_PROCESSES_ONLY);
															#line 1404 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 3;
															#line 1404 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*>(static_cast<CheckUsingDesiredClassesActor*>(this)));
															#line 11246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> const& __allWorkers,int loopDepth) 
	{
															#line 1403 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		allWorkers = __allWorkers;
															#line 11255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> && __allWorkers,int loopDepth) 
	{
		allWorkers = std::move(__allWorkers);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state > 0) static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckUsingDesiredClassesActor*>(this)->ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1406 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		auto& db = self->dbInfo->get();
															#line 1408 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<NetworkAddress, WorkerDetails> allWorkerProcessMap;
															#line 1409 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<Optional<Key>, std::vector<ProcessClass::ClassType>> dcToAllClassTypes;
															#line 1410 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& worker : allWorkers ) {
															#line 1411 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			allWorkerProcessMap[worker.interf.address()] = worker;
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			Optional<Key> dc = worker.interf.locality.dcId();
															#line 1413 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!dcToAllClassTypes.contains(dc))
															#line 11346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				dcToAllClassTypes.insert({});
															#line 11350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 1415 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			dcToAllClassTypes[dc].push_back(worker.processClass.classType());
															#line 11354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<NetworkAddress, WorkerDetails> nonExcludedWorkerProcessMap;
															#line 1419 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<Optional<Key>, std::vector<ProcessClass::ClassType>> dcToNonExcludedClassTypes;
															#line 1420 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& worker : nonExcludedWorkers ) {
															#line 1421 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			nonExcludedWorkerProcessMap[worker.interf.address()] = worker;
															#line 1422 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			Optional<Key> dc = worker.interf.locality.dcId();
															#line 1423 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!dcToNonExcludedClassTypes.contains(dc))
															#line 11368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1424 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				dcToNonExcludedClassTypes.insert({});
															#line 11372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 1425 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			dcToNonExcludedClassTypes[dc].push_back(worker.processClass.classType());
															#line 11376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1428 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!allWorkerProcessMap.contains(db.clusterInterface.clientInterface.address()))
															#line 11380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1429 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_CCNotInWorkerList") .detail("CCAddress", db.clusterInterface.clientInterface.address().toString());
															#line 1431 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1433 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!allWorkerProcessMap.contains(db.master.address()))
															#line 11394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1434 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_MasterNotInWorkerList") .detail("MasterAddress", db.master.address().toString());
															#line 1436 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1439 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		Optional<Key> ccDcId = allWorkerProcessMap[db.clusterInterface.clientInterface.address()].interf.locality.dcId();
															#line 1441 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		Optional<Key> masterDcId = allWorkerProcessMap[db.master.address()].interf.locality.dcId();
															#line 1443 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (ccDcId != masterDcId)
															#line 11412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1444 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_CCAndMasterNotInSameDC") .detail("ClusterControllerDcId", getOptionalString(ccDcId)) .detail("MasterDcId", getOptionalString(masterDcId));
															#line 1447 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1452 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (g_network->isSimulated() && config.usableRegions > 1 && g_simulator->primaryDcId.present() && !g_simulator->datacenterDead(g_simulator->primaryDcId) && !g_simulator->datacenterDead(g_simulator->remoteDcId))
															#line 11426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1455 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			expectedPrimaryDcId = config.regions[0].dcId;
															#line 1456 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			expectedRemoteDcId = config.regions[1].dcId;
															#line 1458 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (config.regions[0].priority == config.regions[1].priority)
															#line 11434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1459 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				expectedPrimaryDcId = masterDcId;
															#line 1460 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				expectedRemoteDcId = config.regions[0].dcId == expectedPrimaryDcId.get() ? config.regions[1].dcId : config.regions[0].dcId;
															#line 11440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 1464 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (ccDcId != expectedPrimaryDcId)
															#line 11444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1465 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_ClusterControllerDcNotBest") .detail("PreferredDcId", getOptionalString(expectedPrimaryDcId)) .detail("ExistingDcId", getOptionalString(ccDcId));
															#line 1468 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1470 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (masterDcId != expectedPrimaryDcId)
															#line 11458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1471 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_MasterDcNotBest") .detail("PreferredDcId", getOptionalString(expectedPrimaryDcId)) .detail("ExistingDcId", getOptionalString(masterDcId));
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 1479 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestClusterControllerFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[ccDcId], ProcessClass::ClusterController);
															#line 1481 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!nonExcludedWorkerProcessMap.contains(db.clusterInterface.clientInterface.address()) || nonExcludedWorkerProcessMap[db.clusterInterface.clientInterface.address()].processClass.machineClassFitness( ProcessClass::ClusterController) != bestClusterControllerFitness)
															#line 11475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ClusterControllerNotBest") .detail("BestClusterControllerFitness", bestClusterControllerFitness) .detail("ExistingClusterControllerFit", nonExcludedWorkerProcessMap.contains(db.clusterInterface.clientInterface.address()) ? nonExcludedWorkerProcessMap[db.clusterInterface.clientInterface.address()] .processClass.machineClassFitness(ProcessClass::ClusterController) : -1);
															#line 1491 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1495 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestMasterFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[masterDcId], ProcessClass::Master);
															#line 1497 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (bestMasterFitness == ProcessClass::NeverAssign)
															#line 11491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1498 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			bestMasterFitness = getBestAvailableFitness(dcToAllClassTypes[masterDcId], ProcessClass::Master);
															#line 1499 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (bestMasterFitness != ProcessClass::NeverAssign)
															#line 11497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1500 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				bestMasterFitness = ProcessClass::ExcludeFit;
															#line 11501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if ((!nonExcludedWorkerProcessMap.contains(db.master.address()) && bestMasterFitness != ProcessClass::ExcludeFit) || nonExcludedWorkerProcessMap[db.master.address()].processClass.machineClassFitness(ProcessClass::Master) != bestMasterFitness)
															#line 11506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1508 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_MasterNotBest") .detail("BestMasterFitness", bestMasterFitness) .detail("ExistingMasterFit", nonExcludedWorkerProcessMap.contains(db.master.address()) ? nonExcludedWorkerProcessMap[db.master.address()].processClass.machineClassFitness( ProcessClass::Master) : -1);
															#line 1515 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1519 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestCommitProxyFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[masterDcId], ProcessClass::CommitProxy);
															#line 1521 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& commitProxy : db.client.commitProxies ) {
															#line 1522 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!nonExcludedWorkerProcessMap.contains(commitProxy.address()) || nonExcludedWorkerProcessMap[commitProxy.address()].processClass.machineClassFitness( ProcessClass::CommitProxy) != bestCommitProxyFitness)
															#line 11524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1525 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_CommitProxyNotBest") .detail("BestCommitProxyFitness", bestCommitProxyFitness) .detail("ExistingCommitProxyFitness", nonExcludedWorkerProcessMap.contains(commitProxy.address()) ? nonExcludedWorkerProcessMap[commitProxy.address()].processClass.machineClassFitness( ProcessClass::CommitProxy) : -1);
															#line 1532 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 1537 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestGrvProxyFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[masterDcId], ProcessClass::GrvProxy);
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& grvProxy : db.client.grvProxies ) {
															#line 1540 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!nonExcludedWorkerProcessMap.contains(grvProxy.address()) || nonExcludedWorkerProcessMap[grvProxy.address()].processClass.machineClassFitness( ProcessClass::GrvProxy) != bestGrvProxyFitness)
															#line 11543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1543 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_GrvProxyNotBest") .detail("BestGrvProxyFitness", bestGrvProxyFitness) .detail("ExistingGrvProxyFitness", nonExcludedWorkerProcessMap.contains(grvProxy.address()) ? nonExcludedWorkerProcessMap[grvProxy.address()].processClass.machineClassFitness( ProcessClass::GrvProxy) : -1);
															#line 1550 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 1555 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestResolverFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[masterDcId], ProcessClass::Resolver);
															#line 1557 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& resolver : db.resolvers ) {
															#line 1558 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!nonExcludedWorkerProcessMap.contains(resolver.address()) || nonExcludedWorkerProcessMap[resolver.address()].processClass.machineClassFitness( ProcessClass::Resolver) != bestResolverFitness)
															#line 11562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_ResolverNotBest") .detail("BestResolverFitness", bestResolverFitness) .detail("ExistingResolverFitness", nonExcludedWorkerProcessMap.contains(resolver.address()) ? nonExcludedWorkerProcessMap[resolver.address()].processClass.machineClassFitness( ProcessClass::Resolver) : -1);
															#line 1568 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 1573 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (g_network->isSimulated() && config.usableRegions > 1 && g_simulator->primaryDcId.present() && !g_simulator->datacenterDead(g_simulator->primaryDcId) && !g_simulator->datacenterDead(g_simulator->remoteDcId))
															#line 11577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1576 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			for( auto& tlogSet : db.logSystemConfig.tLogs ) {
															#line 1577 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!tlogSet.isLocal && tlogSet.logRouters.size())
															#line 11583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1578 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					for( auto& logRouter : tlogSet.logRouters ) {
															#line 1579 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!nonExcludedWorkerProcessMap.contains(logRouter.interf().address()))
															#line 11589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						{
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							TraceEvent("ConsistencyCheck_LogRouterNotInNonExcludedWorkers") .detail("Id", logRouter.id());
															#line 1582 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
							new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckUsingDesiredClassesActorState();
							static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 1584 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (logRouter.interf().filteredLocality.dcId() != expectedRemoteDcId)
															#line 11603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						{
															#line 1585 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							TraceEvent("ConsistencyCheck_LogRouterNotBestDC") .detail("expectedDC", getOptionalString(expectedRemoteDcId)) .detail("ActualDC", getOptionalString(logRouter.interf().filteredLocality.dcId()));
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
							new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckUsingDesiredClassesActorState();
							static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
				}
			}
		}
															#line 1596 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness fitnessLowerBound = allWorkerProcessMap[db.master.address()].processClass.machineClassFitness(ProcessClass::DataDistributor);
															#line 1598 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (db.distributor.present() && (!nonExcludedWorkerProcessMap.contains(db.distributor.get().address()) || nonExcludedWorkerProcessMap[db.distributor.get().address()].processClass.machineClassFitness( ProcessClass::DataDistributor) > fitnessLowerBound))
															#line 11623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1602 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_DistributorNotBest") .detail("DataDistributorFitnessLowerBound", fitnessLowerBound) .detail( "ExistingDistributorFitness", nonExcludedWorkerProcessMap.contains(db.distributor.get().address()) ? nonExcludedWorkerProcessMap[db.distributor.get().address()].processClass.machineClassFitness( ProcessClass::DataDistributor) : -1);
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1614 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (db.ratekeeper.present() && (!nonExcludedWorkerProcessMap.contains(db.ratekeeper.get().address()) || nonExcludedWorkerProcessMap[db.ratekeeper.get().address()].processClass.machineClassFitness( ProcessClass::Ratekeeper) > fitnessLowerBound))
															#line 11637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1618 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_RatekeeperNotBest") .detail("BestRatekeeperFitness", fitnessLowerBound) .detail( "ExistingRatekeeperFitness", nonExcludedWorkerProcessMap.contains(db.ratekeeper.get().address()) ? nonExcludedWorkerProcessMap[db.ratekeeper.get().address()].processClass.machineClassFitness( ProcessClass::Ratekeeper) : -1);
															#line 1626 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1630 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (config.blobGranulesEnabled && db.blobManager.present() && (!nonExcludedWorkerProcessMap.contains(db.blobManager.get().address()) || nonExcludedWorkerProcessMap[db.blobManager.get().address()].processClass.machineClassFitness( ProcessClass::BlobManager) > fitnessLowerBound))
															#line 11651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1634 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_BlobManagerNotBest") .detail("BestBlobManagerFitness", fitnessLowerBound) .detail( "ExistingBlobManagerFitness", nonExcludedWorkerProcessMap.contains(db.blobManager.get().address()) ? nonExcludedWorkerProcessMap[db.blobManager.get().address()].processClass.machineClassFitness( ProcessClass::BlobManager) : -1);
															#line 1642 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1646 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (config.blobGranulesEnabled && db.blobMigrator.present() && (!nonExcludedWorkerProcessMap.contains(db.blobMigrator.get().address()) || nonExcludedWorkerProcessMap[db.blobMigrator.get().address()].processClass.machineClassFitness( ProcessClass::BlobMigrator) > fitnessLowerBound))
															#line 11665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_BlobMigratorNotBest") .detail("BestBlobMigratorFitness", fitnessLowerBound) .detail( "ExistingBlobMigratorFitness", nonExcludedWorkerProcessMap.contains(db.blobMigrator.get().address()) ? nonExcludedWorkerProcessMap[db.blobMigrator.get().address()].processClass.machineClassFitness( ProcessClass::BlobMigrator) : -1);
															#line 1658 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1662 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (config.encryptionAtRestMode.isEncryptionEnabled() && db.client.encryptKeyProxy.present() && (!nonExcludedWorkerProcessMap.contains(db.client.encryptKeyProxy.get().address()) || nonExcludedWorkerProcessMap[db.client.encryptKeyProxy.get().address()].processClass.machineClassFitness( ProcessClass::EncryptKeyProxy) > fitnessLowerBound))
															#line 11679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1666 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_EncryptKeyProxyNotBest") .detail("BestEncryptKeyProxyFitness", fitnessLowerBound) .detail("ExistingEncryptKeyProxyFitness", nonExcludedWorkerProcessMap.contains(db.client.encryptKeyProxy.get().address()) ? nonExcludedWorkerProcessMap[db.client.encryptKeyProxy.get().address()] .processClass.machineClassFitness(ProcessClass::EncryptKeyProxy) : -1);
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1677 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (db.consistencyScan.present() && (!nonExcludedWorkerProcessMap.contains(db.consistencyScan.get().address()) || nonExcludedWorkerProcessMap[db.consistencyScan.get().address()].processClass.machineClassFitness( ProcessClass::ConsistencyScan) > fitnessLowerBound))
															#line 11693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ConsistencyScanNotBest") .detail("BestConsistencyScanFitness", fitnessLowerBound) .detail("ExistingConsistencyScanFitness", nonExcludedWorkerProcessMap.contains(db.consistencyScan.get().address()) ? nonExcludedWorkerProcessMap[db.consistencyScan.get().address()] .processClass.machineClassFitness(ProcessClass::ConsistencyScan) : -1);
															#line 1688 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1693 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckUsingDesiredClassesActorState();
		static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<WorkerDetails> const& __nonExcludedWorkers,int loopDepth) 
	{
															#line 1404 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		nonExcludedWorkers = __nonExcludedWorkers;
															#line 11719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<WorkerDetails> && __nonExcludedWorkers,int loopDepth) 
	{
		nonExcludedWorkers = std::move(__nonExcludedWorkers);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state > 0) static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckUsingDesiredClassesActor*>(this)->ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 1400 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Optional<Key> expectedPrimaryDcId;
															#line 1401 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Optional<Key> expectedRemoteDcId;
															#line 1402 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	DatabaseConfiguration config;
															#line 1403 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails> allWorkers;
															#line 1404 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails> nonExcludedWorkers;
															#line 11808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkUsingDesiredClasses()
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckUsingDesiredClassesActor final : public Actor<bool>, public ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >, public ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >, public ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >, public FastAllocated<CheckUsingDesiredClassesActor>, public CheckUsingDesiredClassesActorState<CheckUsingDesiredClassesActor> {
															#line 11813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckUsingDesiredClassesActor>::operator new;
	using FastAllocated<CheckUsingDesiredClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5719938316511765248UL, 17491107319121709568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >;
friend struct ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >;
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckUsingDesiredClassesActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 11832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckUsingDesiredClassesActorState<CheckUsingDesiredClassesActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16621575950694749952UL, 13688324977771477760UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkUsingDesiredClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkUsingDesiredClasses( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckUsingDesiredClassesActor(cx, self));
															#line 11866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1695 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// returns true if stopped, false otherwise
																#line 11872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkConsistencyScan()
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckConsistencyScanActor>
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckConsistencyScanActorState {
															#line 11878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckConsistencyScanActorState(Database const& cx) 
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx)
															#line 11885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkConsistencyScan", reinterpret_cast<unsigned long>(this));

	}
	~CheckConsistencyScanActorState() 
	{
		fdb_probe_actor_destroy("checkConsistencyScan", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1698 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!g_network->isSimulated())
															#line 11900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1699 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckConsistencyScanActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckConsistencyScanActorState(); static_cast<CheckConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 11904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckConsistencyScanActor*>(this)->SAV< bool >::value()) bool(true);
				this->~CheckConsistencyScanActorState();
				static_cast<CheckConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1701 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 1702 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cs = ConsistencyScanState();
															#line 1703 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 11916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckConsistencyScanActorState();
		static_cast<CheckConsistencyScanActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1705 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			SystemDBWriteLockedNow(cx.getReference())->setOptions(tr);
															#line 1706 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<ConsistencyScanState::Config> __when_expr_0 = cs.config().getD(tr);
															#line 1706 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state = 1;
															#line 1706 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*>(static_cast<CheckConsistencyScanActor*>(this)));
															#line 11956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1709 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 1709 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state = 2;
															#line 1709 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyScanActor, 1, Void >*>(static_cast<CheckConsistencyScanActor*>(this)));
															#line 11985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(ConsistencyScanState::Config const& config,int loopDepth) 
	{
															#line 1707 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckConsistencyScanActor*>(this)->SAV<bool>::futures) { (void)(!config.enabled); this->~CheckConsistencyScanActorState(); static_cast<CheckConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 12000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckConsistencyScanActor*>(this)->SAV< bool >::value()) bool(!config.enabled);
		this->~CheckConsistencyScanActorState();
		static_cast<CheckConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(ConsistencyScanState::Config && config,int loopDepth) 
	{
															#line 1707 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckConsistencyScanActor*>(this)->SAV<bool>::futures) { (void)(!config.enabled); this->~CheckConsistencyScanActorState(); static_cast<CheckConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 12012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckConsistencyScanActor*>(this)->SAV< bool >::value()) bool(!config.enabled);
		this->~CheckConsistencyScanActorState();
		static_cast<CheckConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ConsistencyScanState::Config const& config,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(config, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ConsistencyScanState::Config && config,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(config), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<CheckConsistencyScanActor*>(this)->ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >::remove();

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*,ConsistencyScanState::Config const& value) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*,ConsistencyScanState::Config && value) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*,Error err) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<CheckConsistencyScanActor*>(this)->ActorCallback< CheckConsistencyScanActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckConsistencyScanActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1701 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1702 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyScanState cs;
															#line 12188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkConsistencyScan()
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckConsistencyScanActor final : public Actor<bool>, public ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >, public ActorCallback< CheckConsistencyScanActor, 1, Void >, public FastAllocated<CheckConsistencyScanActor>, public CheckConsistencyScanActorState<CheckConsistencyScanActor> {
															#line 12193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckConsistencyScanActor>::operator new;
	using FastAllocated<CheckConsistencyScanActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2619159508533862912UL, 12216203866604879616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >;
friend struct ActorCallback< CheckConsistencyScanActor, 1, Void >;
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckConsistencyScanActor(Database const& cx) 
															#line 12211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckConsistencyScanActorState<CheckConsistencyScanActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13688259443744744960UL, 983808638632960256UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkConsistencyScan");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckConsistencyScanActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkConsistencyScan( Database const& cx ) {
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckConsistencyScanActor(cx));
															#line 12244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1713 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	bool checkSingleSingleton(std::vector<ISimulator::ProcessInfo*> const& allProcesses,
	                          TraceEvent& ev,
	                          std::string const& role,
	                          int expectedCount) {
		// FIXME: this doesn't actually check that there aren't multiple of the same role running on the same process
		// either
		int count = 0;
		for (int i = 0; i < allProcesses.size(); i++) {
			if (g_simulator->hasRole(allProcesses[i]->address, role)) {
				count++;
				ev.detail(role + std::to_string(count), allProcesses[i]->address.toString());
			}
		}
		ev.detail(role + "Count", count).detail(role + "ExpectedCount", expectedCount);
		if (count != expectedCount) {
			fmt::print("ConsistencyCheck failure: incorrect number {0} of singleton {1} running (expected {2})\n",
			           count,
			           role,
			           expectedCount);
		}
		return count == expectedCount;
	}

	// checks that there is only one instance of each singleton running in the cluster in simulation
	bool checkSingleSingletons(ConsistencyCheckWorkload* self, DatabaseConfiguration config) {
		if (!g_network->isSimulated()) {
			return true;
		}

		CODE_PROBE(self->performQuiescentChecks, "Checking for single singletons");

		std::vector<ISimulator::ProcessInfo*> allProcesses = g_simulator->getAllProcesses();

		bool success = true;
		TraceEvent ev("CheckSingletons");

		success &= self->checkSingleSingleton(allProcesses, ev, "Ratekeeper", 1);
		success &= self->checkSingleSingleton(allProcesses, ev, "DataDistributor", 1);
		success &= self->checkSingleSingleton(allProcesses, ev, "ConsistencyScan", 1);
		success &= self->checkSingleSingleton(allProcesses, ev, "BlobManager", config.blobGranulesEnabled ? 1 : 0);

		// FIXME: add blob migrator once it's always on
		// success &= self->checkSingleSingleton(allProcesses, ev, "BlobMigrator", TODO ? 1 : 0);

		success &= self->checkSingleSingleton(
		    allProcesses,
		    ev,
		    "EncryptKeyProxy",
		    config.encryptionAtRestMode.isEncryptionEnabled() || SERVER_KNOBS->ENABLE_REST_KMS_COMMUNICATION ? 1 : 0);

		if (!success) {
			// TODO REMOVE
			fmt::print("ConsistencyCheck singletons: roles map:\n");
			for (int i = 0; i < allProcesses.size(); i++) {
				fmt::print(
				    "{0}: {1}\n", allProcesses[i]->address.toString(), g_simulator->getRoles(allProcesses[i]->address));
			}
		}

		return success;
	}
};

WorkloadFactory<ConsistencyCheckWorkload> ConsistencyCheckWorkloadFactory;
