#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
/*
 * BlobGranuleVerifier.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <map>
#include <utility>
#include <vector>

#include "fmt/format.h"
#include "fdbclient/BlobGranuleReader.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/BlobGranuleValidation.actor.h"
#include "fdbserver/BlobGranuleServerCommon.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

#define BGV_DEBUG true

/*
 * This workload is designed to verify the correctness of the blob data produced by the blob workers.
 * As a read-only validation workload, it can piggyback off of other write or read/write workloads.
 * To verify the data outside FDB's 5 second MVCC window, it tests time travel reads by doing an initial comparison at
 * the latest read version, and then waiting a period of time to re-read the data from blob.
 * To catch availability issues with the blob worker, it does a request to each granule at the end of the test.
 */
struct BlobGranuleVerifierWorkload : TestWorkload {
	static constexpr auto NAME = "BlobGranuleVerifier";
	bool doSetup;
	double testDuration;
	double timeTravelLimit;
	uint64_t timeTravelBufferSize;
	int threads;
	int64_t errors = 0;
	int64_t mismatches = 0;
	int64_t initialReads = 0;
	int64_t timeTravelReads = 0;
	int64_t timeTravelTooOld = 0;
	int64_t rowsRead = 0;
	int64_t bytesRead = 0;
	int64_t purges = 0;
	std::vector<Future<Void>> clients;
	bool enablePurging;
	bool initAtEnd;
	bool strictPurgeChecking;
	bool doForcePurge;
	bool purgeAtLatest;
	bool clearAndMergeCheck;
	bool granuleSizeCheck;
	bool doForceFlushing;

	DatabaseConfiguration config;

	Reference<BlobConnectionProvider> bstore;
	AsyncVar<Standalone<VectorRef<KeyRangeRef>>> granuleRanges;

	bool startedForcePurge;
	Optional<Key> forcePurgeKey;
	Version forcePurgeVersion;

	std::vector<std::tuple<KeyRange, Version, UID, Future<GranuleFiles>>> purgedDataToCheck;

	Future<Void> summaryClient;
	Future<Void> forceFlushingClient;
	Promise<Void> triggerSummaryComplete;

	BlobGranuleVerifierWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		doSetup = !clientId; // only do this on the "first" client
		testDuration = getOption(options, "testDuration"_sr, 120.0);
		timeTravelLimit = getOption(options, "timeTravelLimit"_sr, testDuration);
		timeTravelBufferSize = getOption(options, "timeTravelBufferSize"_sr, 100000000);
		threads = getOption(options, "threads"_sr, 1);

		enablePurging = getOption(options, "enablePurging"_sr, sharedRandomNumber % 3 == 0);
		sharedRandomNumber /= 3;
		// FIXME: re-enable this! There exist several bugs with purging active granules where a small amount of state
		// won't be cleaned up.
		strictPurgeChecking = getOption(options, "strictPurgeChecking"_sr, false /*sharedRandomNumber % 2 == 0*/);
		sharedRandomNumber /= 2;

		doForcePurge = getOption(options, "doForcePurge"_sr, sharedRandomNumber % 3 == 0);
		sharedRandomNumber /= 3;

		purgeAtLatest = getOption(options, "purgeAtLatest"_sr, sharedRandomNumber % 3 == 0);
		sharedRandomNumber /= 3;

		// randomly some tests write data first and then turn on blob granules later, to test conversion of existing DB
		initAtEnd = getOption(options, "initAtEnd"_sr, sharedRandomNumber % 10 == 0);
		sharedRandomNumber /= 10;
		// FIXME: enable and fix bugs!
		// granuleSizeCheck = initAtEnd;
		granuleSizeCheck = false;

		clearAndMergeCheck = getOption(options, "clearAndMergeCheck"_sr, sharedRandomNumber % 10 == 0);
		sharedRandomNumber /= 10;

		doForceFlushing = getOption(options, "doForceFlushing"_sr, sharedRandomNumber % 4 == 0);
		sharedRandomNumber /= 4;

		// don't do strictPurgeChecking or forcePurge if !enablePurging
		if (!enablePurging) {
			strictPurgeChecking = false;
			doForcePurge = false;
			purgeAtLatest = false;
		} else {
			// don't do force flushing if purging enabled
			doForceFlushing = false;
		}

		if (initAtEnd) {
			doForceFlushing = false;
		}

		if (doForcePurge) {
			purgeAtLatest = false;
		}

		if (purgeAtLatest) {
			strictPurgeChecking = false;
		}

		startedForcePurge = false;

		if (doSetup && BGV_DEBUG) {
			fmt::print("BlobGranuleVerifier starting\n");
			fmt::print("  enablePurging={0}\n", enablePurging);
			fmt::print("  purgeAtLatest={0}\n", purgeAtLatest);
			fmt::print("  strictPurgeChecking={0}\n", strictPurgeChecking);
			fmt::print("  doForcePurge={0}\n", doForcePurge);
			fmt::print("  initAtEnd={0}\n", initAtEnd);
			fmt::print("  clearAndMergeCheck={0}\n", clearAndMergeCheck);
		}

		ASSERT(threads >= 1);
		try {
			bstore = BlobConnectionProvider::newBlobConnectionProvider(SERVER_KNOBS->BG_URL);
		} catch (Error& e) {
			if (BGV_DEBUG) {
				printf("Blob Granule Verifier got backup container init error %s\n", e.name());
			}
			throw e;
		}
	}

	// Sets the whole user keyspace to be blobified
																#line 174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via setUpBlobRange()
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class SetUpBlobRangeActor>
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class SetUpBlobRangeActorState {
															#line 180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	SetUpBlobRangeActorState(Database const& cx) 
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx)
															#line 187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("setUpBlobRange", reinterpret_cast<unsigned long>(this));

	}
	~SetUpBlobRangeActorState() 
	{
		fdb_probe_actor_destroy("setUpBlobRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<bool> __when_expr_0 = cx->blobbifyRange(normalKeys);
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<SetUpBlobRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetUpBlobRangeActor*>(this)->actor_wait_state = 1;
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetUpBlobRangeActor, 0, bool >*>(static_cast<SetUpBlobRangeActor*>(this)));
															#line 209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetUpBlobRangeActorState();
		static_cast<SetUpBlobRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& success,int loopDepth) 
	{
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(success);
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<SetUpBlobRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetUpBlobRangeActorState(); static_cast<SetUpBlobRangeActor*>(this)->destroy(); return 0; }
															#line 234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<SetUpBlobRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetUpBlobRangeActorState();
		static_cast<SetUpBlobRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(bool && success,int loopDepth) 
	{
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(success);
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<SetUpBlobRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetUpBlobRangeActorState(); static_cast<SetUpBlobRangeActor*>(this)->destroy(); return 0; }
															#line 248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<SetUpBlobRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetUpBlobRangeActorState();
		static_cast<SetUpBlobRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont1(success, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetUpBlobRangeActor*>(this)->actor_wait_state > 0) static_cast<SetUpBlobRangeActor*>(this)->actor_wait_state = 0;
		static_cast<SetUpBlobRangeActor*>(this)->ActorCallback< SetUpBlobRangeActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< SetUpBlobRangeActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetUpBlobRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetUpBlobRangeActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetUpBlobRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetUpBlobRangeActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetUpBlobRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via setUpBlobRange()
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class SetUpBlobRangeActor final : public Actor<Void>, public ActorCallback< SetUpBlobRangeActor, 0, bool >, public FastAllocated<SetUpBlobRangeActor>, public SetUpBlobRangeActorState<SetUpBlobRangeActor> {
															#line 338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<SetUpBlobRangeActor>::operator new;
	using FastAllocated<SetUpBlobRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5944160692024733440UL, 4714529489455531776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetUpBlobRangeActor, 0, bool >;
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	SetUpBlobRangeActor(Database const& cx) 
															#line 355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Void>(),
		   SetUpBlobRangeActorState<SetUpBlobRangeActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setUpBlobRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4237211082324110336UL, 6312788034730357504UL);
		ActorExecutionContextHelper __helper(static_cast<SetUpBlobRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setUpBlobRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setUpBlobRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetUpBlobRangeActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Void> setUpBlobRange( Database const& cx ) {
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Void>(new SetUpBlobRangeActor(cx));
															#line 387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.emplace("Attrition"); }

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }

																#line 396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class _setupActor>
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class _setupActorState {
															#line 402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	_setupActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self)
															#line 411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!self->doSetup)
															#line 426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(0);
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(ManagementAPI::changeConfig(cx.getReference(), "blob_granules_enabled=1", true));
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!self->initAtEnd)
															#line 580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->setUpBlobRange(cx);
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!self->initAtEnd)
															#line 605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->setUpBlobRange(cx);
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public ActorCallback< _setupActor, 2, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12384349997939026688UL, 16681873249661843712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
friend struct ActorCallback< _setupActor, 2, Void >;
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	_setupActor(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, BlobGranuleVerifierWorkload* const& self ) {
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

																#line 867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via findGranules()
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class FindGranulesActor>
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class FindGranulesActorState {
															#line 873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	FindGranulesActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self)
															#line 882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("findGranules", reinterpret_cast<unsigned long>(this));

	}
	~FindGranulesActorState() 
	{
		fdb_probe_actor_destroy("findGranules", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			;
															#line 897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FindGranulesActorState();
		static_cast<FindGranulesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr = Transaction(cx);
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(deterministicRandom()->random01() * 10.0);
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<FindGranulesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<FindGranulesActor*>(this)->actor_wait_state = 3;
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FindGranulesActor, 2, Void >*>(static_cast<FindGranulesActor*>(this)));
															#line 945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_0 = tr.getBlobGranuleRanges(normalKeys, 1000000);
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<FindGranulesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FindGranulesActor*>(this)->actor_wait_state = 1;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<FindGranulesActor*>(this)));
															#line 969 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<FindGranulesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FindGranulesActor*>(this)->actor_wait_state = 2;
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FindGranulesActor, 1, Void >*>(static_cast<FindGranulesActor*>(this)));
															#line 1011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> const& allGranules,int loopDepth) 
	{
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->granuleRanges.set(allGranules);
															#line 1026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> && allGranules,int loopDepth) 
	{
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->granuleRanges.set(allGranules);
															#line 1035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<VectorRef<KeyRangeRef>> const& allGranules,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(allGranules, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<VectorRef<KeyRangeRef>> && allGranules,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(allGranules), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FindGranulesActor*>(this)->actor_wait_state > 0) static_cast<FindGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<FindGranulesActor*>(this)->ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FindGranulesActor*>(this)->actor_wait_state > 0) static_cast<FindGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<FindGranulesActor*>(this)->ActorCallback< FindGranulesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FindGranulesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FindGranulesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FindGranulesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FindGranulesActor*>(this)->actor_wait_state > 0) static_cast<FindGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<FindGranulesActor*>(this)->ActorCallback< FindGranulesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FindGranulesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FindGranulesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FindGranulesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction tr;
															#line 1295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via findGranules()
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class FindGranulesActor final : public Actor<Void>, public ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< FindGranulesActor, 1, Void >, public ActorCallback< FindGranulesActor, 2, Void >, public FastAllocated<FindGranulesActor>, public FindGranulesActorState<FindGranulesActor> {
															#line 1300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<FindGranulesActor>::operator new;
	using FastAllocated<FindGranulesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1432861685527664896UL, 7315594269049042944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< FindGranulesActor, 1, Void >;
friend struct ActorCallback< FindGranulesActor, 2, Void >;
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	FindGranulesActor(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 1319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Void>(),
		   FindGranulesActorState<FindGranulesActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8443776748849721088UL, 6603109939541344768UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("findGranules");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FindGranulesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FindGranulesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Void> findGranules( Database const& cx, BlobGranuleVerifierWorkload* const& self ) {
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Void>(new FindGranulesActor(cx, self));
															#line 1353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

	struct OldRead {
		KeyRange range;
		Version v;
		RangeResult oldResult;

		OldRead() {}
		OldRead(KeyRange range, Version v, RangeResult oldResult) : range(range), v(v), oldResult(oldResult) {}
	};

	// TODO refactor more generally
																#line 1368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via loadGranuleMetadataBeforeForcePurge()
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class LoadGranuleMetadataBeforeForcePurgeActor>
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class LoadGranuleMetadataBeforeForcePurgeActorState {
															#line 1374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	LoadGranuleMetadataBeforeForcePurgeActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self),
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   cur(blobGranuleHistoryKeys),
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   tr(cx)
															#line 1387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this));

	}
	~LoadGranuleMetadataBeforeForcePurgeActorState() 
	{
		fdb_probe_actor_destroy("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			;
															#line 1402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadGranuleMetadataBeforeForcePurgeActorState();
		static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i = int();
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i = 0;
															#line 1427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(cur, 100);
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1446 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state = 1;
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >*>(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)));
															#line 1451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state = 2;
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >*>(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)));
															#line 1493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& history,int loopDepth) 
	{
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : history ) {
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			KeyRange keyRange;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Version version;
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			std::tie(keyRange, version) = decodeBlobGranuleHistoryKey(it.key);
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Standalone<BlobGranuleHistoryValue> historyValue = decodeBlobGranuleHistoryValue(it.value);
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Future<GranuleFiles> fileFuture = loadHistoryFiles(cx, historyValue.granuleID);
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->purgedDataToCheck.push_back({ keyRange, version, historyValue.granuleID, fileFuture });
															#line 1520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!history.empty() && history.more)
															#line 1524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			cur = KeyRangeRef(keyAfter(history.back().key), cur.end);
															#line 1528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && history,int loopDepth) 
	{
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : history ) {
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			KeyRange keyRange;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Version version;
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			std::tie(keyRange, version) = decodeBlobGranuleHistoryKey(it.key);
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Standalone<BlobGranuleHistoryValue> historyValue = decodeBlobGranuleHistoryValue(it.value);
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Future<GranuleFiles> fileFuture = loadHistoryFiles(cx, historyValue.granuleID);
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->purgedDataToCheck.push_back({ keyRange, version, historyValue.granuleID, fileFuture });
															#line 1554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!history.empty() && history.more)
															#line 1558 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			cur = KeyRangeRef(keyAfter(history.back().key), cur.end);
															#line 1562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& history,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(history, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && history,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(history), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 1751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV loaded {0} granules metadata before force purge\n", self->purgedDataToCheck.size());
															#line 1755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!self->purgedDataToCheck.empty());
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadGranuleMetadataBeforeForcePurgeActorState(); static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->destroy(); return 0; }
															#line 1761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadGranuleMetadataBeforeForcePurgeActorState();
		static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!(i < self->purgedDataToCheck.size()))
															#line 1780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_2 = success(std::get<3>(self->purgedDataToCheck[i]));
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state = 3;
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >*>(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)));
															#line 1793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i++;
															#line 1815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i++;
															#line 1824 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange cur;
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction tr;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int i;
															#line 1914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via loadGranuleMetadataBeforeForcePurge()
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class LoadGranuleMetadataBeforeForcePurgeActor final : public Actor<Void>, public ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >, public ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >, public ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >, public FastAllocated<LoadGranuleMetadataBeforeForcePurgeActor>, public LoadGranuleMetadataBeforeForcePurgeActorState<LoadGranuleMetadataBeforeForcePurgeActor> {
															#line 1919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<LoadGranuleMetadataBeforeForcePurgeActor>::operator new;
	using FastAllocated<LoadGranuleMetadataBeforeForcePurgeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12725140044907869952UL, 7405666171982745088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >;
friend struct ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >;
friend struct ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >;
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	LoadGranuleMetadataBeforeForcePurgeActor(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 1938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Void>(),
		   LoadGranuleMetadataBeforeForcePurgeActorState<LoadGranuleMetadataBeforeForcePurgeActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2433885181323424512UL, 17814556441535885312UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadGranuleMetadataBeforeForcePurge");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Void> loadGranuleMetadataBeforeForcePurge( Database const& cx, BlobGranuleVerifierWorkload* const& self ) {
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Void>(new LoadGranuleMetadataBeforeForcePurgeActor(cx, self));
															#line 1972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

																#line 1977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via verifyGranules()
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class VerifyGranulesActor>
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class VerifyGranulesActorState {
															#line 1983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	VerifyGranulesActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self,bool const& allowPurging) 
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self),
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   allowPurging(allowPurging),
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   last(now()),
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   endTime(last + self->testDuration),
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   timeTravelChecks(),
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   timeTravelChecksMemory(0),
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   prevPurgeVersion(-1),
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   newPurgeVersion(0),
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   pickGranuleUniform(deterministicRandom()->random01() < 0.1)
															#line 2008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("verifyGranules", reinterpret_cast<unsigned long>(this));

	}
	~VerifyGranulesActorState() 
	{
		fdb_probe_actor_destroy("verifyGranules", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			TraceEvent("BlobGranuleVerifierStart");
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 2025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV {0}) thread starting\n", self->clientId);
															#line 2029 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->granuleRanges.onChange();
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 1;
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 0, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VerifyGranulesActorState();
		static_cast<VerifyGranulesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 2063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) got ranges\n", self->clientId);
															#line 2067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 2071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 2080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) got ranges\n", self->clientId);
															#line 2084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 2088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			currentTime = now();
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			timeTravelIt = timeTravelChecks.begin();
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			newPurgeVersion = 0;
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			;
															#line 2186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_12 = poisson(&last, 0.1);
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_12.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 13;
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 12, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 2218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 482 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() != error_code_blob_granule_transaction_too_old && BGV_DEBUG)
															#line 2226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGVerifier {0} got unexpected error {1}\n", self->clientId, e.name());
															#line 2230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->errors++;
															#line 2234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		size_t granuleCount = self->granuleRanges.get().size();
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		size_t rIndex;
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (pickGranuleUniform)
															#line 2253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			rIndex = deterministicRandom()->randomInt(0, granuleCount);
															#line 2257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			rIndex = deterministicRandom()->randomSkewedUInt32(0, granuleCount);
															#line 2263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		range = self->granuleRanges.get()[rIndex];
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<std::pair<RangeResult, Version>> __when_expr_8 = readFromFDB(cx, range);
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 9;
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!(timeTravelIt != timeTravelChecks.end() && currentTime >= timeTravelIt->first))
															#line 2292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		oldRead = timeTravelIt->second;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		timeTravelChecksMemory -= oldRead.oldResult.expectedSize();
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		timeTravelIt = timeTravelChecks.erase(timeTravelIt);
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (prevPurgeVersion == -1)
															#line 2304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			prevPurgeVersion = oldRead.v;
															#line 2308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		doPurging = allowPurging && !self->purgeAtLatest && deterministicRandom()->random01() < 0.5;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		forcePurge = doPurging && self->doForcePurge && deterministicRandom()->random01() < 0.25;
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (doPurging)
															#line 2316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			CODE_PROBE(true, "BGV considering purge", probe::decoration::rare);
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Version maxPurgeVersion = oldRead.v;
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			for( auto& it : timeTravelChecks ) {
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				maxPurgeVersion = std::min(it.second.v, maxPurgeVersion);
															#line 2326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (prevPurgeVersion < maxPurgeVersion)
															#line 2330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				CODE_PROBE(true, "BGV doing purge", probe::decoration::rare);
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				newPurgeVersion = deterministicRandom()->randomInt64(prevPurgeVersion, maxPurgeVersion);
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				prevPurgeVersion = std::max(prevPurgeVersion, newPurgeVersion);
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (BGV_DEBUG)
															#line 2340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print("BGV Purging @ {0}{1}\n", newPurgeVersion, forcePurge ? " (force)" : "");
															#line 2344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
				try {
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					if (forcePurge)
															#line 2349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					{
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						StrictFuture<Void> __when_expr_1 = self->loadGranuleMetadataBeforeForcePurge(cx, self);
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
						static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 2;
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 1, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont1loopBody1loopBody1cont8(loopDepth);
					}
				}
				catch (Error& error) {
					loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				doPurging = false;
															#line 2378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = a_body1cont1loopBody1loopBody1cont4(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		try {
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>> __when_expr_4 = readFromBlob(cx, self->bstore, oldRead.range, 0, oldRead.v);
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 5;
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont6(int loopDepth) 
	{
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		CODE_PROBE(true, "BGV purge complete", probe::decoration::rare);
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 2437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV Purge complete @ {0}\n", newPurgeVersion);
															#line 2441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->purges++;
															#line 2445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 2455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1cont1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 2459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 2463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("Unexpected error {0} purging @ {1}!\n", e.name(), newPurgeVersion);
															#line 2467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(false);
															#line 2471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont8(int loopDepth) 
	{
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_2 = cx->purgeBlobGranules(normalKeys, newPurgeVersion, {}, forcePurge);
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont8when1(__when_expr_2.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 3;
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 2, Key >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->startedForcePurge = true;
															#line 2502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->startedForcePurge = true;
															#line 2511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont11(Key const& purgeKey,int loopDepth) 
	{
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (forcePurge)
															#line 2595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->forcePurgeKey = purgeKey;
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->forcePurgeVersion = newPurgeVersion;
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 2603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV Force purge registered, stopping\n");
															#line 2607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<VerifyGranulesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~VerifyGranulesActorState(); static_cast<VerifyGranulesActor*>(this)->destroy(); return 0; }
															#line 2611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<VerifyGranulesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~VerifyGranulesActorState();
			static_cast<VerifyGranulesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 2619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV Purged @ {0}, waiting\n", newPurgeVersion);
															#line 2623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont11when1(__when_expr_3.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 4;
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 3, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11(Key && purgeKey,int loopDepth) 
	{
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (forcePurge)
															#line 2643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->forcePurgeKey = purgeKey;
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->forcePurgeVersion = newPurgeVersion;
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 2651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV Force purge registered, stopping\n");
															#line 2655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<VerifyGranulesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~VerifyGranulesActorState(); static_cast<VerifyGranulesActor*>(this)->destroy(); return 0; }
															#line 2659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<VerifyGranulesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~VerifyGranulesActorState();
			static_cast<VerifyGranulesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 2667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV Purged @ {0}, waiting\n", newPurgeVersion);
															#line 2671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont11when1(__when_expr_3.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 4;
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 3, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont8when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont8when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 2, Key >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 2, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 2, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 2, Key >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1cont11cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1loopBody1cont11cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15(int loopDepth) 
	{
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (doPurging)
															#line 2866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (self->strictPurgeChecking)
															#line 2870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Void> __when_expr_5 = killBlobWorkers(cx);
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1cont15when1(__when_expr_5.get(), loopDepth); };
				static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 6;
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 5, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1loopBody1cont15cont2(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont15cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1cont1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 2905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("Error TT: {0}\n", e.name());
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_blob_granule_transaction_too_old)
															#line 2911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				self->timeTravelTooOld++;
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV ERROR: TTO [{0} - {1}) @ {2}\n", oldRead.range.begin.printable(), oldRead.range.end.printable(), oldRead.v);
															#line 2917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
			loopDepth = a_body1cont1loopBody1loopBody1cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont16(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& reReadResult,int loopDepth) 
	{
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!compareFDBAndBlob(oldRead.oldResult, reReadResult, oldRead.range, oldRead.v, BGV_DEBUG))
															#line 2933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->mismatches++;
															#line 2937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->timeTravelReads++;
															#line 2941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont16cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont16(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && reReadResult,int loopDepth) 
	{
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!compareFDBAndBlob(oldRead.oldResult, reReadResult, oldRead.range, oldRead.v, BGV_DEBUG))
															#line 2950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->mismatches++;
															#line 2954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->timeTravelReads++;
															#line 2958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont16cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& reReadResult,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont16(reReadResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && reReadResult,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont16(std::move(reReadResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1loopBody1cont16cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1loopBody1cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont2(int loopDepth) 
	{
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>> __when_expr_6 = readFromBlob(cx, self->bstore, oldRead.range, 0, prevPurgeVersion);
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1cont15cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 7;
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 3068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont3(Void const& _,int loopDepth) 
	{
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV Reading post-purge [{0} - {1}) @ {2}\n", oldRead.range.begin.printable(), oldRead.range.end.printable(), prevPurgeVersion);
															#line 3081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont3(Void && _,int loopDepth) 
	{
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV Reading post-purge [{0} - {1}) @ {2}\n", oldRead.range.begin.printable(), oldRead.range.end.printable(), prevPurgeVersion);
															#line 3095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont15when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont15when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1loopBody1cont15cont6(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& versionRead1,int loopDepth) 
	{
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV Post-purge first read:\n");
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			printGranuleChunks(versionRead1.second);
															#line 3186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->strictPurgeChecking)
															#line 3190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			try {
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				Version minSnapshotVersion = newPurgeVersion;
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				for( auto& it : versionRead1.second ) {
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					minSnapshotVersion = std::min(minSnapshotVersion, it.snapshotVersion);
															#line 3199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (BGV_DEBUG)
															#line 3203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print("BGV Reading post-purge again [{0} - {1}) @ {2}\n", oldRead.range.begin.printable(), oldRead.range.end.printable(), minSnapshotVersion - 1);
															#line 3207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>> __when_expr_7 = readFromBlob(cx, self->bstore, oldRead.range, 0, minSnapshotVersion - 1);
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1cont15cont6Catch1(actor_cancelled(), loopDepth);
															#line 3213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1loopBody1cont15cont6Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont15cont6when1(__when_expr_7.get(), loopDepth); };
				static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 8;
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 3218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1loopBody1cont15cont6Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1loopBody1cont15cont6Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont15cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont6(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && versionRead1,int loopDepth) 
	{
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV Post-purge first read:\n");
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			printGranuleChunks(versionRead1.second);
															#line 3244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->strictPurgeChecking)
															#line 3248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			try {
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				Version minSnapshotVersion = newPurgeVersion;
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				for( auto& it : versionRead1.second ) {
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					minSnapshotVersion = std::min(minSnapshotVersion, it.snapshotVersion);
															#line 3257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (BGV_DEBUG)
															#line 3261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print("BGV Reading post-purge again [{0} - {1}) @ {2}\n", oldRead.range.begin.printable(), oldRead.range.end.printable(), minSnapshotVersion - 1);
															#line 3265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>> __when_expr_7 = readFromBlob(cx, self->bstore, oldRead.range, 0, minSnapshotVersion - 1);
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1cont15cont6Catch1(actor_cancelled(), loopDepth);
															#line 3271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1loopBody1cont15cont6Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont15cont6when1(__when_expr_7.get(), loopDepth); };
				static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 8;
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 3276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1loopBody1cont15cont6Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1loopBody1cont15cont6Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont15cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont2when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& versionRead1,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont6(versionRead1, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont2when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && versionRead1,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont6(std::move(versionRead1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont15cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont15cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1loopBody1cont15cont7(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont9(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont6Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1cont1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 3388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(e.code() == error_code_blob_granule_transaction_too_old);
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			CODE_PROBE(true, "BGV verified too old after purge", probe::decoration::rare);
															#line 3394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopBody1cont15cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont10(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& versionRead2,int loopDepth) 
	{
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV ERROR: data not purged! Read successful!!\n");
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			printGranuleChunks(versionRead2.second);
															#line 3415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(false);
															#line 3419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont10(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && versionRead2,int loopDepth) 
	{
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV ERROR: data not purged! Read successful!!\n");
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			printGranuleChunks(versionRead2.second);
															#line 3434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(false);
															#line 3438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont6when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& versionRead2,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont10(versionRead2, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont6when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && versionRead2,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont10(std::move(versionRead2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1cont15cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont15cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont15cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1cont15cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont15cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont15cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1cont15cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont15cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont15cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1loopBody1cont15cont10cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1loopBody1cont15cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>> __when_expr_9 = readFromBlob(cx, self->bstore, range, 0, fdb.second);
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_9.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 10;
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 3542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(std::pair<RangeResult, Version> const& __fdb,int loopDepth) 
	{
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fdb = __fdb;
															#line 3551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(std::pair<RangeResult, Version> && __fdb,int loopDepth) 
	{
		fdb = std::move(__fdb);
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >*,std::pair<RangeResult, Version> const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >*,std::pair<RangeResult, Version> && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->purgeAtLatest && timeTravelChecks.empty() && deterministicRandom()->random01() < 0.25)
															#line 3630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			try {
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Key> __when_expr_10 = cx->purgeBlobGranules(normalKeys, fdb.second, {}, false);
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont6Catch1(actor_cancelled(), loopDepth);
															#line 3637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1cont6Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1loopBody1cont6when1(__when_expr_10.get(), loopDepth); };
				static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 11;
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 10, Key >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 3642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1cont6Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1cont6Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& __blob,int loopDepth) 
	{
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		blob = __blob;
															#line 3662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && __blob,int loopDepth) 
	{
		blob = std::move(__blob);
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont1loopBody1cont7(int loopDepth) 
	{
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (compareFDBAndBlob(fdb.first, blob, range, fdb.second, BGV_DEBUG))
															#line 3741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 461 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			bool rereadImmediately = self->purgeAtLatest || deterministicRandom()->random01() < 0.25;
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			double reReadTime = currentTime + (rereadImmediately ? 0.0 : deterministicRandom()->random01() * self->timeTravelLimit);
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			int memory = fdb.first.expectedSize();
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (reReadTime <= endTime && timeTravelChecksMemory + memory <= (self->timeTravelBufferSize / self->threads))
															#line 3751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 468 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				timeTravelChecks[reReadTime] = OldRead(range, fdb.second, fdb.first);
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				timeTravelChecksMemory += memory;
															#line 3757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
		}
		else
		{
															#line 472 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->mismatches++;
															#line 3764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->rowsRead += fdb.first.size();
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->bytesRead += fdb.first.expectedSize();
															#line 476 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->initialReads++;
															#line 3772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->purges++;
															#line 3781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 3791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1cont1loopBody1Catch1(e, loopDepth);
															#line 3795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 3799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("Unexpected error {0} purging latest @ {1}!\n", e.name(), newPurgeVersion);
															#line 3803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(false);
															#line 3807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(Key const& purgeKey,int loopDepth) 
	{
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest @ {1}, waiting\n", self->clientId, fdb.second);
															#line 3826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_11 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont6Catch1(actor_cancelled(), loopDepth);
															#line 3832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1cont6Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont1loopBody1cont9when1(__when_expr_11.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 12;
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 11, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 3837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(Key && purgeKey,int loopDepth) 
	{
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest @ {1}, waiting\n", self->clientId, fdb.second);
															#line 3850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_11 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont6Catch1(actor_cancelled(), loopDepth);
															#line 3856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1cont6Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont1loopBody1cont9when1(__when_expr_11.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 12;
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 11, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 3861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 10, Key >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 10, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 10, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 10, Key >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont1loopBody1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont1loopBody1cont10cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont17(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont18(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont18(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 12);

	}
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool allowPurging;
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	double last;
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	double endTime;
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	std::map<double, OldRead> timeTravelChecks;
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int64_t timeTravelChecksMemory;
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Version prevPurgeVersion;
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Version newPurgeVersion;
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool pickGranuleUniform;
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	double currentTime;
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	std::map<double, OldRead>::iterator timeTravelIt;
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	OldRead oldRead;
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool doPurging;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool forcePurge;
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange range;
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	std::pair<RangeResult, Version> fdb;
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> blob;
															#line 4177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via verifyGranules()
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class VerifyGranulesActor final : public Actor<Void>, public ActorCallback< VerifyGranulesActor, 0, Void >, public ActorCallback< VerifyGranulesActor, 1, Void >, public ActorCallback< VerifyGranulesActor, 2, Key >, public ActorCallback< VerifyGranulesActor, 3, Void >, public ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >, public ActorCallback< VerifyGranulesActor, 5, Void >, public ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >, public ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >, public ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >, public ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >, public ActorCallback< VerifyGranulesActor, 10, Key >, public ActorCallback< VerifyGranulesActor, 11, Void >, public ActorCallback< VerifyGranulesActor, 12, Void >, public FastAllocated<VerifyGranulesActor>, public VerifyGranulesActorState<VerifyGranulesActor> {
															#line 4182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<VerifyGranulesActor>::operator new;
	using FastAllocated<VerifyGranulesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10860870923262514944UL, 736618623573002496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VerifyGranulesActor, 0, Void >;
friend struct ActorCallback< VerifyGranulesActor, 1, Void >;
friend struct ActorCallback< VerifyGranulesActor, 2, Key >;
friend struct ActorCallback< VerifyGranulesActor, 3, Void >;
friend struct ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >;
friend struct ActorCallback< VerifyGranulesActor, 5, Void >;
friend struct ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >;
friend struct ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >;
friend struct ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >;
friend struct ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >;
friend struct ActorCallback< VerifyGranulesActor, 10, Key >;
friend struct ActorCallback< VerifyGranulesActor, 11, Void >;
friend struct ActorCallback< VerifyGranulesActor, 12, Void >;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	VerifyGranulesActor(Database const& cx,BlobGranuleVerifierWorkload* const& self,bool const& allowPurging) 
															#line 4211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Void>(),
		   VerifyGranulesActorState<VerifyGranulesActor>(cx, self, allowPurging),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4757613148507417856UL, 12548808069170726912UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("verifyGranules");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VerifyGranulesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< VerifyGranulesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< VerifyGranulesActor, 2, Key >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< VerifyGranulesActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< VerifyGranulesActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< VerifyGranulesActor, 10, Key >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< VerifyGranulesActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< VerifyGranulesActor, 12, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Void> verifyGranules( Database const& cx, BlobGranuleVerifierWorkload* const& self, bool const& allowPurging ) {
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Void>(new VerifyGranulesActor(cx, self, allowPurging));
															#line 4255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

	Future<Void> start(Database const& cx) override {
		clients.reserve(threads + 1);
		clients.push_back(timeout(findGranules(cx, this), testDuration, Void()));
		if (enablePurging && clientId == 0) {
			clients.push_back(
			    timeout(reportErrors(verifyGranules(cx, this, true), "BlobGranuleVerifier"), testDuration, Void()));
		} else if (!enablePurging) {
			for (int i = 0; i < threads; i++) {
				clients.push_back(timeout(
				    reportErrors(verifyGranules(cx, this, false), "BlobGranuleVerifier"), testDuration, Void()));
			}
		}
		if (!enablePurging) {
			summaryClient = validateGranuleSummaries(cx, normalKeys, {}, triggerSummaryComplete);
		} else {
			summaryClient = Future<Void>(Void());
		}
		if (doForceFlushing) {
			forceFlushingClient = validateForceFlushing(cx, normalKeys, testDuration, triggerSummaryComplete);
		} else {
			forceFlushingClient = Future<Void>(Void());
		}
		return delay(testDuration);
	}

	// handle retries + errors
	// It's ok to reset the transaction here because its read version is only used for reading the granule mapping from
	// the system keyspace
																#line 4288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via doGrv()
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class DoGrvActor>
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class DoGrvActorState {
															#line 4294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	DoGrvActorState(Transaction* const& tr) 
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : tr(tr)
															#line 4301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("doGrv", reinterpret_cast<unsigned long>(this));

	}
	~DoGrvActorState() 
	{
		fdb_probe_actor_destroy("doGrv", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 520 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			;
															#line 4316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoGrvActorState();
		static_cast<DoGrvActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr->getReadVersion();
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<DoGrvActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoGrvActor*>(this)->actor_wait_state = 1;
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoGrvActor, 0, Version >*>(static_cast<DoGrvActor*>(this)));
															#line 4354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<DoGrvActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoGrvActor*>(this)->actor_wait_state = 2;
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoGrvActor, 1, Void >*>(static_cast<DoGrvActor*>(this)));
															#line 4383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& readVersion,int loopDepth) 
	{
															#line 523 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<DoGrvActor*>(this)->SAV<Version>::futures) { (void)(readVersion); this->~DoGrvActorState(); static_cast<DoGrvActor*>(this)->destroy(); return 0; }
															#line 4398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<DoGrvActor*>(this)->SAV< Version >::value()) Version(readVersion);
		this->~DoGrvActorState();
		static_cast<DoGrvActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && readVersion,int loopDepth) 
	{
															#line 523 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<DoGrvActor*>(this)->SAV<Version>::futures) { (void)(readVersion); this->~DoGrvActorState(); static_cast<DoGrvActor*>(this)->destroy(); return 0; }
															#line 4410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<DoGrvActor*>(this)->SAV< Version >::value()) Version(readVersion);
		this->~DoGrvActorState();
		static_cast<DoGrvActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& readVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(readVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && readVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(readVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoGrvActor*>(this)->actor_wait_state > 0) static_cast<DoGrvActor*>(this)->actor_wait_state = 0;
		static_cast<DoGrvActor*>(this)->ActorCallback< DoGrvActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< DoGrvActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("doGrv", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrv", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoGrvActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("doGrv", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrv", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoGrvActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("doGrv", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrv", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoGrvActor*>(this)->actor_wait_state > 0) static_cast<DoGrvActor*>(this)->actor_wait_state = 0;
		static_cast<DoGrvActor*>(this)->ActorCallback< DoGrvActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoGrvActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doGrv", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrv", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoGrvActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doGrv", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrv", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoGrvActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doGrv", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrv", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction* tr;
															#line 4582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via doGrv()
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class DoGrvActor final : public Actor<Version>, public ActorCallback< DoGrvActor, 0, Version >, public ActorCallback< DoGrvActor, 1, Void >, public FastAllocated<DoGrvActor>, public DoGrvActorState<DoGrvActor> {
															#line 4587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<DoGrvActor>::operator new;
	using FastAllocated<DoGrvActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5979724362997116416UL, 16981497925593254912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoGrvActor, 0, Version >;
friend struct ActorCallback< DoGrvActor, 1, Void >;
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	DoGrvActor(Transaction* const& tr) 
															#line 4605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Version>(),
		   DoGrvActorState<DoGrvActor>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doGrv", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1994116863933768704UL, 13279750342320377088UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doGrv");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doGrv", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoGrvActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoGrvActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Version> doGrv( Transaction* const& tr ) {
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Version>(new DoGrvActor(tr));
															#line 4638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

																#line 4643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via checkGranuleMetadataPurged()
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class CheckGranuleMetadataPurgedActor>
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckGranuleMetadataPurgedActorState {
															#line 4649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckGranuleMetadataPurgedActorState(Transaction* const& tr,KeyRange const& granuleRange,Version const& historyVersion,UID const& granuleId,bool const& strictMetadataCheck,bool const& possiblyInFlight) 
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : tr(tr),
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   granuleRange(granuleRange),
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   historyVersion(historyVersion),
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   granuleId(granuleId),
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   strictMetadataCheck(strictMetadataCheck),
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   possiblyInFlight(possiblyInFlight)
															#line 4666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this));

	}
	~CheckGranuleMetadataPurgedActorState() 
	{
		fdb_probe_actor_destroy("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(granuleIDToCFKey(granuleId).withPrefix(changeFeedPrefix));
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 1;
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 4688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckGranuleMetadataPurgedActorState();
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& changeFeed,int loopDepth) 
	{
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && changeFeed.present())
															#line 4711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("WARN: Change Feed for [{0} - {1}): {2} not purged, retrying\n", granuleRange.begin.printable(), granuleRange.end.printable(), granuleId.toString().substr(0, 6));
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 4717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!changeFeed.present());
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(blobGranuleFileKeyRangeFor(granuleId), 1);
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 2;
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 4734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && changeFeed,int loopDepth) 
	{
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && changeFeed.present())
															#line 4743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("WARN: Change Feed for [{0} - {1}): {2} not purged, retrying\n", granuleRange.begin.printable(), granuleRange.end.printable(), granuleId.toString().substr(0, 6));
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 4749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!changeFeed.present());
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(blobGranuleFileKeyRangeFor(granuleId), 1);
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 2;
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 4766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& changeFeed,int loopDepth) 
	{
		loopDepth = a_body1cont1(changeFeed, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && changeFeed,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(changeFeed), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(RangeResult const& fileMetadata,int loopDepth) 
	{
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && !fileMetadata.empty())
															#line 4850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("WARN: File metadata for [{0} - {1}): {2} not purged, retrying\n", granuleRange.begin.printable(), granuleRange.end.printable(), granuleId.toString().substr(0, 6));
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 4856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(fileMetadata.empty());
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (strictMetadataCheck)
															#line 4866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_2 = tr->get(blobGranuleLockKeyFor(granuleRange));
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 3;
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 4877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(RangeResult && fileMetadata,int loopDepth) 
	{
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && !fileMetadata.empty())
															#line 4891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("WARN: File metadata for [{0} - {1}): {2} not purged, retrying\n", granuleRange.begin.printable(), granuleRange.end.printable(), granuleId.toString().substr(0, 6));
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 4897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(fileMetadata.empty());
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (strictMetadataCheck)
															#line 4907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_2 = tr->get(blobGranuleLockKeyFor(granuleRange));
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 3;
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 4918 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& fileMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont2(fileMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && fileMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(fileMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckGranuleMetadataPurgedActorState();
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Optional<Value> const& lock,int loopDepth) 
	{
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && lock.present())
															#line 5019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!lock.present());
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr->get(blobGranuleHistoryKeyFor(granuleRange, historyVersion));
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 4;
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 5040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Optional<Value> && lock,int loopDepth) 
	{
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && lock.present())
															#line 5049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!lock.present());
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr->get(blobGranuleHistoryKeyFor(granuleRange, historyVersion));
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 4;
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 5070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> const& lock,int loopDepth) 
	{
		loopDepth = a_body1cont6(lock, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> && lock,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(lock), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Optional<Value> const& history,int loopDepth) 
	{
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && history.present())
															#line 5154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!history.present());
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = tr->getRange(blobGranuleSplitKeyRangeFor(granuleId), 1);
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 5;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 5175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Optional<Value> && history,int loopDepth) 
	{
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && history.present())
															#line 5184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!history.present());
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = tr->getRange(blobGranuleSplitKeyRangeFor(granuleId), 1);
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 5;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 5205 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Optional<Value> const& history,int loopDepth) 
	{
		loopDepth = a_body1cont7(history, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Optional<Value> && history,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(history), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(RangeResult const& splitData,int loopDepth) 
	{
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && !splitData.empty())
															#line 5289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(splitData.empty());
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr->get(blobGranuleMergeKeyFor(granuleId));
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 6;
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 5310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(RangeResult && splitData,int loopDepth) 
	{
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && !splitData.empty())
															#line 5319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(splitData.empty());
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr->get(blobGranuleMergeKeyFor(granuleId));
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 6;
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 5340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(RangeResult const& splitData,int loopDepth) 
	{
		loopDepth = a_body1cont9(splitData, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(RangeResult && splitData,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(splitData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11(Optional<Value> const& merge,int loopDepth) 
	{
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && merge.present())
															#line 5424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!merge.present());
															#line 5436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Optional<Value> && merge,int loopDepth) 
	{
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && merge.present())
															#line 5445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!merge.present());
															#line 5457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Optional<Value> const& merge,int loopDepth) 
	{
		loopDepth = a_body1cont11(merge, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Optional<Value> && merge,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(merge), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction* tr;
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange granuleRange;
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Version historyVersion;
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	UID granuleId;
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool strictMetadataCheck;
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool possiblyInFlight;
															#line 5549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via checkGranuleMetadataPurged()
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckGranuleMetadataPurgedActor final : public Actor<bool>, public ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >, public ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >, public ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >, public ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >, public ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >, public ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >, public FastAllocated<CheckGranuleMetadataPurgedActor>, public CheckGranuleMetadataPurgedActorState<CheckGranuleMetadataPurgedActor> {
															#line 5554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<CheckGranuleMetadataPurgedActor>::operator new;
	using FastAllocated<CheckGranuleMetadataPurgedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7110916361503165696UL, 5398721805023734016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >;
friend struct ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >;
friend struct ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >;
friend struct ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >;
friend struct ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >;
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckGranuleMetadataPurgedActor(Transaction* const& tr,KeyRange const& granuleRange,Version const& historyVersion,UID const& granuleId,bool const& strictMetadataCheck,bool const& possiblyInFlight) 
															#line 5576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<bool>(),
		   CheckGranuleMetadataPurgedActorState<CheckGranuleMetadataPurgedActor>(tr, granuleRange, historyVersion, granuleId, strictMetadataCheck, possiblyInFlight),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10941498556622655488UL, 7318377067046864640UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkGranuleMetadataPurged");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<bool> checkGranuleMetadataPurged( Transaction* const& tr, KeyRange const& granuleRange, Version const& historyVersion, UID const& granuleId, bool const& strictMetadataCheck, bool const& possiblyInFlight ) {
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<bool>(new CheckGranuleMetadataPurgedActor(tr, granuleRange, historyVersion, granuleId, strictMetadataCheck, possiblyInFlight));
															#line 5613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

																#line 5618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via checkPurgedHistoryEntries()
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class CheckPurgedHistoryEntriesActor>
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckPurgedHistoryEntriesActorState {
															#line 5624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckPurgedHistoryEntriesActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self,KeyRange const& purgeRange,bool const& strictMetadataCheck) 
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self),
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   purgeRange(purgeRange),
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   strictMetadataCheck(strictMetadataCheck),
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   tr(cx),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   cur(blobGranuleHistoryKeys),
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   granulesToCheck()
															#line 5643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this));

	}
	~CheckPurgedHistoryEntriesActorState() 
	{
		fdb_probe_actor_destroy("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 606 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			;
															#line 5658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckPurgedHistoryEntriesActorState();
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.reset();
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i = int();
															#line 644 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG && !granulesToCheck.empty())
															#line 5685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("Checking metadata for {0} non-purged ranges\n", granulesToCheck.size());
															#line 5689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i = 0;
															#line 5693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 5709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		try {
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(cur, 1000);
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 1;
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >*>(static_cast<CheckPurgedHistoryEntriesActor*>(this)));
															#line 5720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 2;
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >*>(static_cast<CheckPurgedHistoryEntriesActor*>(this)));
															#line 5762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& history,int loopDepth) 
	{
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : history ) {
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			KeyRange keyRange;
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Version version;
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			std::tie(keyRange, version) = decodeBlobGranuleHistoryKey(it.key);
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (purgeRange.intersects(keyRange))
															#line 5785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 615 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (BGV_DEBUG)
															#line 5789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print("Found range [{0} - {1}) @ {2} that avoided force purge [{3} - {4}) @ {5}!!\n", keyRange.begin.printable(), keyRange.end.printable(), version, purgeRange.begin.printable(), purgeRange.end.printable(), self->forcePurgeVersion);
															#line 5793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (strictMetadataCheck)
															#line 5797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					ASSERT(!purgeRange.intersects(keyRange));
															#line 5801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
				else
				{
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					Standalone<BlobGranuleHistoryValue> historyValue = decodeBlobGranuleHistoryValue(it.value);
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					granulesToCheck.emplace_back(keyRange, version, historyValue.granuleID);
															#line 5809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
			}
		}
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!history.empty() && history.more)
															#line 5815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			cur = KeyRangeRef(keyAfter(history.back().key), cur.end);
															#line 5819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && history,int loopDepth) 
	{
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : history ) {
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			KeyRange keyRange;
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Version version;
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			std::tie(keyRange, version) = decodeBlobGranuleHistoryKey(it.key);
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (purgeRange.intersects(keyRange))
															#line 5841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 615 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (BGV_DEBUG)
															#line 5845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print("Found range [{0} - {1}) @ {2} that avoided force purge [{3} - {4}) @ {5}!!\n", keyRange.begin.printable(), keyRange.end.printable(), version, purgeRange.begin.printable(), purgeRange.end.printable(), self->forcePurgeVersion);
															#line 5849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (strictMetadataCheck)
															#line 5853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					ASSERT(!purgeRange.intersects(keyRange));
															#line 5857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
				else
				{
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					Standalone<BlobGranuleHistoryValue> historyValue = decodeBlobGranuleHistoryValue(it.value);
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					granulesToCheck.emplace_back(keyRange, version, historyValue.granuleID);
															#line 5865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
			}
		}
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!history.empty() && history.more)
															#line 5871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			cur = KeyRangeRef(keyAfter(history.back().key), cur.end);
															#line 5875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& history,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(history, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && history,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(history), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state > 0) static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state > 0) static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<CheckPurgedHistoryEntriesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckPurgedHistoryEntriesActorState(); static_cast<CheckPurgedHistoryEntriesActor*>(this)->destroy(); return 0; }
															#line 6064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<CheckPurgedHistoryEntriesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckPurgedHistoryEntriesActorState();
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!(i < granulesToCheck.size()))
															#line 6083 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 6089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i++;
															#line 6111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 6127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		try {
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<bool> __when_expr_2 = self->checkGranuleMetadataPurged(&tr, std::get<0>(granulesToCheck[i]), std::get<1>(granulesToCheck[i]), std::get<2>(granulesToCheck[i]), strictMetadataCheck, true);
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 3;
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >*>(static_cast<CheckPurgedHistoryEntriesActor*>(this)));
															#line 6138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 5;
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >*>(static_cast<CheckPurgedHistoryEntriesActor*>(this)));
															#line 6180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(bool const& success,int loopDepth) 
	{
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (success)
															#line 6195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(5.0);
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 4;
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >*>(static_cast<CheckPurgedHistoryEntriesActor*>(this)));
															#line 6208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(bool && success,int loopDepth) 
	{
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (success)
															#line 6217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(5.0);
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 4;
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >*>(static_cast<CheckPurgedHistoryEntriesActor*>(this)));
															#line 6230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state > 0) static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state > 0) static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state > 0) static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange purgeRange;
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool strictMetadataCheck;
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction tr;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange cur;
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	std::vector<std::tuple<KeyRange, Version, UID>> granulesToCheck;
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int i;
															#line 6513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via checkPurgedHistoryEntries()
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckPurgedHistoryEntriesActor final : public Actor<Void>, public ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >, public ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >, public ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >, public ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >, public ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >, public FastAllocated<CheckPurgedHistoryEntriesActor>, public CheckPurgedHistoryEntriesActorState<CheckPurgedHistoryEntriesActor> {
															#line 6518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<CheckPurgedHistoryEntriesActor>::operator new;
	using FastAllocated<CheckPurgedHistoryEntriesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15862250762068524800UL, 13915850370221873408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >;
friend struct ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >;
friend struct ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >;
friend struct ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >;
friend struct ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >;
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckPurgedHistoryEntriesActor(Database const& cx,BlobGranuleVerifierWorkload* const& self,KeyRange const& purgeRange,bool const& strictMetadataCheck) 
															#line 6539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Void>(),
		   CheckPurgedHistoryEntriesActorState<CheckPurgedHistoryEntriesActor>(cx, self, purgeRange, strictMetadataCheck),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9442908700208833792UL, 8625101335363735296UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkPurgedHistoryEntries");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Void> checkPurgedHistoryEntries( Database const& cx, BlobGranuleVerifierWorkload* const& self, KeyRange const& purgeRange, bool const& strictMetadataCheck ) {
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Void>(new CheckPurgedHistoryEntriesActor(cx, self, purgeRange, strictMetadataCheck));
															#line 6575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 669 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

																#line 6580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via checkPurgedChangeFeeds()
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class CheckPurgedChangeFeedsActor>
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckPurgedChangeFeedsActorState {
															#line 6586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckPurgedChangeFeedsActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self,KeyRange const& purgeRange) 
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self),
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   purgeRange(purgeRange),
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   tr(cx),
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   cur(changeFeedKeys)
															#line 6601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this));

	}
	~CheckPurgedChangeFeedsActorState() 
	{
		fdb_probe_actor_destroy("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			;
															#line 6616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckPurgedChangeFeedsActorState();
		static_cast<CheckPurgedChangeFeedsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<CheckPurgedChangeFeedsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckPurgedChangeFeedsActorState(); static_cast<CheckPurgedChangeFeedsActor*>(this)->destroy(); return 0; }
															#line 6639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<CheckPurgedChangeFeedsActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckPurgedChangeFeedsActorState();
		static_cast<CheckPurgedChangeFeedsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 6658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		try {
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(cur, 1000);
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state = 1;
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >*>(static_cast<CheckPurgedChangeFeedsActor*>(this)));
															#line 6669 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state = 2;
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >*>(static_cast<CheckPurgedChangeFeedsActor*>(this)));
															#line 6711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& feeds,int loopDepth) 
	{
															#line 678 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : feeds ) {
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			KeyRange keyRange;
															#line 680 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Version version;
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ChangeFeedStatus status;
															#line 682 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			std::tie(keyRange, version, status) = decodeChangeFeedValue(it.value);
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (purgeRange.intersects(keyRange))
															#line 6736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 684 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				Key feedId = it.key.removePrefix(changeFeedKeys.begin);
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (BGV_DEBUG)
															#line 6742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print( "Found Change Feed {0}: [{1} - {2}) that avoided force purge [{3} - {4}) @ {5}!!\n", feedId.printable(), keyRange.begin.printable(), keyRange.end.printable(), purgeRange.begin.printable(), purgeRange.end.printable(), self->forcePurgeVersion);
															#line 6746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				bool foundAnyHistoryForRange = false;
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				for( auto& purgedData : self->purgedDataToCheck ) {
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					KeyRange granuleRange = std::get<0>(purgedData);
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					if (granuleRange.intersects(keyRange))
															#line 6756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						foundAnyHistoryForRange = true;
															#line 6760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
						break;
					}
				}
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (!foundAnyHistoryForRange)
															#line 6766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 711 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					CODE_PROBE( true, "not failing test for leaked feed with no history", probe::decoration::rare);
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print("Not failing test b/c feed never had history!\n");
															#line 6772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (!static_cast<CheckPurgedChangeFeedsActor*>(this)->SAV<bool>::futures) { (void)(!foundAnyHistoryForRange); this->~CheckPurgedChangeFeedsActorState(); static_cast<CheckPurgedChangeFeedsActor*>(this)->destroy(); return 0; }
															#line 6776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				new (&static_cast<CheckPurgedChangeFeedsActor*>(this)->SAV< bool >::value()) bool(!foundAnyHistoryForRange);
				this->~CheckPurgedChangeFeedsActorState();
				static_cast<CheckPurgedChangeFeedsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!feeds.empty() && feeds.more)
															#line 6785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			cur = KeyRangeRef(keyAfter(feeds.back().key), cur.end);
															#line 6789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && feeds,int loopDepth) 
	{
															#line 678 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : feeds ) {
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			KeyRange keyRange;
															#line 680 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Version version;
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ChangeFeedStatus status;
															#line 682 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			std::tie(keyRange, version, status) = decodeChangeFeedValue(it.value);
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (purgeRange.intersects(keyRange))
															#line 6813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 684 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				Key feedId = it.key.removePrefix(changeFeedKeys.begin);
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (BGV_DEBUG)
															#line 6819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print( "Found Change Feed {0}: [{1} - {2}) that avoided force purge [{3} - {4}) @ {5}!!\n", feedId.printable(), keyRange.begin.printable(), keyRange.end.printable(), purgeRange.begin.printable(), purgeRange.end.printable(), self->forcePurgeVersion);
															#line 6823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				bool foundAnyHistoryForRange = false;
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				for( auto& purgedData : self->purgedDataToCheck ) {
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					KeyRange granuleRange = std::get<0>(purgedData);
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					if (granuleRange.intersects(keyRange))
															#line 6833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						foundAnyHistoryForRange = true;
															#line 6837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
						break;
					}
				}
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (!foundAnyHistoryForRange)
															#line 6843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 711 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					CODE_PROBE( true, "not failing test for leaked feed with no history", probe::decoration::rare);
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print("Not failing test b/c feed never had history!\n");
															#line 6849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (!static_cast<CheckPurgedChangeFeedsActor*>(this)->SAV<bool>::futures) { (void)(!foundAnyHistoryForRange); this->~CheckPurgedChangeFeedsActorState(); static_cast<CheckPurgedChangeFeedsActor*>(this)->destroy(); return 0; }
															#line 6853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				new (&static_cast<CheckPurgedChangeFeedsActor*>(this)->SAV< bool >::value()) bool(!foundAnyHistoryForRange);
				this->~CheckPurgedChangeFeedsActorState();
				static_cast<CheckPurgedChangeFeedsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!feeds.empty() && feeds.more)
															#line 6862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			cur = KeyRangeRef(keyAfter(feeds.back().key), cur.end);
															#line 6866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& feeds,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(feeds, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && feeds,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(feeds), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state > 0) static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPurgedChangeFeedsActor*>(this)->ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedChangeFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedChangeFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedChangeFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state > 0) static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPurgedChangeFeedsActor*>(this)->ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedChangeFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedChangeFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedChangeFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange purgeRange;
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction tr;
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange cur;
															#line 7061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via checkPurgedChangeFeeds()
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckPurgedChangeFeedsActor final : public Actor<bool>, public ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >, public ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >, public FastAllocated<CheckPurgedChangeFeedsActor>, public CheckPurgedChangeFeedsActorState<CheckPurgedChangeFeedsActor> {
															#line 7066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<CheckPurgedChangeFeedsActor>::operator new;
	using FastAllocated<CheckPurgedChangeFeedsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14073249354076901632UL, 8306104795599043584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >;
friend struct ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckPurgedChangeFeedsActor(Database const& cx,BlobGranuleVerifierWorkload* const& self,KeyRange const& purgeRange) 
															#line 7084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<bool>(),
		   CheckPurgedChangeFeedsActorState<CheckPurgedChangeFeedsActor>(cx, self, purgeRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14245640899879966208UL, 14868150293114112768UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedChangeFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkPurgedChangeFeeds");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<bool> checkPurgedChangeFeeds( Database const& cx, BlobGranuleVerifierWorkload* const& self, KeyRange const& purgeRange ) {
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<bool>(new CheckPurgedChangeFeedsActor(cx, self, purgeRange));
															#line 7117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 731 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

																#line 7122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via validateForcePurge()
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class ValidateForcePurgeActor>
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class ValidateForcePurgeActorState {
															#line 7128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	ValidateForcePurgeActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self,KeyRange const& purgeRange) 
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self),
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   purgeRange(purgeRange),
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   strictMetadataCheck(false)
															#line 7141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("validateForcePurge", reinterpret_cast<unsigned long>(this));

	}
	~ValidateForcePurgeActorState() 
	{
		fdb_probe_actor_destroy("validateForcePurge", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 736 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 7156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV waiting for force purge to complete\n");
															#line 7160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cx->waitPurgeGranulesComplete(self->forcePurgeKey.get());
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 1;
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 0, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateForcePurgeActorState();
		static_cast<ValidateForcePurgeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 7194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge completed, checking\n");
															#line 7198 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 744 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr = Transaction(cx);
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 7204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 7213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge completed, checking\n");
															#line 7217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 744 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr = Transaction(cx);
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 7223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 7307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 759 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge checked state\n");
															#line 7311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.reset();
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 7317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 748 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 7333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		try {
															#line 750 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<ForcedPurgeState> __when_expr_1 = getForcePurgedState(&tr, purgeRange);
															#line 750 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 2;
															#line 750 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 3;
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 2, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(ForcedPurgeState const& forcePurgedState,int loopDepth) 
	{
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(forcePurgedState == ForcedPurgeState::AllPurged);
															#line 7401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(ForcedPurgeState && forcePurgedState,int loopDepth) 
	{
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(forcePurgedState == ForcedPurgeState::AllPurged);
															#line 7410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ForcedPurgeState const& forcePurgedState,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(forcePurgedState, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ForcedPurgeState && forcePurgedState,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(forcePurgedState), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >*,ForcedPurgeState const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >*,ForcedPurgeState && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 778 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 7581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 779 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge checked read\n");
															#line 7585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 7589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV checking metadata deleted\n");
															#line 7593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i = int();
															#line 787 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		filesChecked = 0;
															#line 788 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i = 0;
															#line 7601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
		try {
															#line 766 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Version> __when_expr_3 = self->doGrv(&tr);
															#line 766 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont3loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 4;
															#line 766 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 3, Version >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 770 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 7660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 771 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 773 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(e.code() == error_code_blob_granule_transaction_too_old);
															#line 7668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Version const& readVersion,int loopDepth) 
	{
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(readFromBlob(cx, self->bstore, purgeRange, 0, readVersion));
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont3loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 5;
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 4, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Version && readVersion,int loopDepth) 
	{
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(readFromBlob(cx, self->bstore, purgeRange, 0, readVersion));
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont3loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 5;
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 4, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Version const& readVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(readVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Version && readVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(std::move(readVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 3, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 3, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 3, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 3, Version >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(false);
															#line 7790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(false);
															#line 7799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 7896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge checked {0} old granules and {1} old files cleaned up\n", self->purgedDataToCheck.size(), filesChecked);
															#line 7900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_9 = self->checkPurgedHistoryEntries(cx, self, purgeRange, strictMetadataCheck);
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont7when1(__when_expr_9.get(), loopDepth); };
		static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 10;
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 9, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1(int loopDepth) 
	{
															#line 788 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!(i < self->purgedDataToCheck.size()))
															#line 7927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		granuleRange = std::get<0>(self->purgedDataToCheck[i]);
															#line 790 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		historyVersion = std::get<1>(self->purgedDataToCheck[i]);
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		granuleId = std::get<2>(self->purgedDataToCheck[i]);
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<GranuleFiles> __when_expr_5 = std::get<3>(self->purgedDataToCheck[i]);
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1when1(__when_expr_5.get(), loopDepth); };
		static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 6;
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1(int loopDepth) 
	{
															#line 793 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  Checking [{0} - {1}): {2}\n", granuleRange.begin.printable(), granuleRange.end.printable(), granuleId.toString().substr(0, 6));
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 7970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont5loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(GranuleFiles const& __oldFiles,int loopDepth) 
	{
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		oldFiles = __oldFiles;
															#line 7979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(GranuleFiles && __oldFiles,int loopDepth) 
	{
		oldFiles = std::move(__oldFiles);
		loopDepth = a_body1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >*,GranuleFiles const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >*,GranuleFiles && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont5loopBody1cont3(int loopDepth) 
	{
															#line 810 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fileIdx = int();
															#line 811 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fileIdx = 0;
															#line 8060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont5loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 8076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		try {
															#line 800 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<bool> __when_expr_6 = self->checkGranuleMetadataPurged( &tr, granuleRange, historyVersion, granuleId, strictMetadataCheck, false);
															#line 800 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1cont5loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont5loopBody1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont5loopBody1cont1loopBody1when1(__when_expr_6.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 7;
															#line 800 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 6, bool >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 8087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont5loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont5loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont5loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont5loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 805 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr.onError(e);
															#line 805 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1cont5loopBody1cont1loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 8;
															#line 805 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 7, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 8129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1cont2(bool const& success,int loopDepth) 
	{
															#line 802 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(success);
															#line 8144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		return a_body1cont5loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1cont2(bool && success,int loopDepth) 
	{
															#line 802 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(success);
															#line 8153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		return a_body1cont5loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1loopBody1cont2(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1loopBody1cont2(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 6, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 6, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont5loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 6, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont5loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 6, bool >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont5loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont5loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont5loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont5loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont5loopBody1cont4(int loopDepth) 
	{
															#line 788 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i++;
															#line 8324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 811 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!(fileIdx < oldFiles.snapshotFiles.size() + oldFiles.deltaFiles.size()))
															#line 8340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont5loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 812 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		std::string fname = (fileIdx >= oldFiles.snapshotFiles.size()) ? oldFiles.deltaFiles[fileIdx - oldFiles.snapshotFiles.size()].filename : oldFiles.snapshotFiles[fileIdx].filename;
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		bstore = self->bstore->getForRead(fname);
															#line 8348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		try {
															#line 817 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_8 = success(bstore->readFile(fname));
															#line 817 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1cont5loopBody1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont5loopBody1cont3loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont5loopBody1cont3loopBody1when1(__when_expr_8.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 9;
															#line 817 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 8, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 8359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont5loopBody1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont5loopBody1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont5loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopBody1cont1(int loopDepth) 
	{
															#line 811 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fileIdx++;
															#line 8387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont5loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 8397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 821 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 8401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 823 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(e.code() == error_code_file_not_found);
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			filesChecked++;
															#line 8407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1cont5loopBody1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 818 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(false);
															#line 8422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont5loopBody1cont3loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 818 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(false);
															#line 8431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont5loopBody1cont3loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont5loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont5loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont5loopBody1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont5loopBody1cont3loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5loopBody1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 837 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 8528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge checked for new granule history entries\n");
															#line 8532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 8536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont10loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 837 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 8545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge checked for new granule history entries\n");
															#line 8549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 8553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont10loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 8637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge checked for leaked change feeds\n");
															#line 8641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 8645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1(int loopDepth) 
	{
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<bool> __when_expr_10 = self->checkPurgedChangeFeeds(cx, self, purgeRange);
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1when1(__when_expr_10.get(), loopDepth); };
		static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 11;
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 10, bool >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 8668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1(bool const& success,int loopDepth) 
	{
															#line 843 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (success)
															#line 8690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont10break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont10loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1(bool && success,int loopDepth) 
	{
															#line 843 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (success)
															#line 8702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont10break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont10loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10loopBody1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont1(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont1(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 10, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 10, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 10, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 10, bool >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10cont3(int loopDepth) 
	{
															#line 897 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 8789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 898 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge check complete\n");
															#line 8793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 901 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<ValidateForcePurgeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateForcePurgeActorState(); static_cast<ValidateForcePurgeActor*>(this)->destroy(); return 0; }
															#line 8797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<ValidateForcePurgeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateForcePurgeActorState();
		static_cast<ValidateForcePurgeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1(int loopDepth) 
	{
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		anyRangesLeft = false;
															#line 858 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<std::vector<BlobWorkerInterface>> __when_expr_11 = getBlobWorkers(cx);
															#line 858 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1when1(__when_expr_11.get(), loopDepth); };
		static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 12;
															#line 858 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 8825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1(int loopDepth) 
	{
															#line 860 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 8847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge checking {0} blob worker mappings\n", blobWorkers.size());
															#line 8851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 864 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i = 0;
															#line 8855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1when1(std::vector<BlobWorkerInterface> const& __blobWorkers,int loopDepth) 
	{
															#line 858 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		blobWorkers = __blobWorkers;
															#line 8864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1when1(std::vector<BlobWorkerInterface> && __blobWorkers,int loopDepth) 
	{
		blobWorkers = std::move(__blobWorkers);
		loopDepth = a_body1cont10cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >*,std::vector<BlobWorkerInterface> const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >*,std::vector<BlobWorkerInterface> && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10cont1loopBody1cont2(int loopDepth) 
	{
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (anyRangesLeft)
															#line 8943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 891 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_13 = delay(10.0);
															#line 891 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont2when1(__when_expr_13.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 14;
															#line 891 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 13, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 8954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			return a_body1cont10cont1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 864 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!(i < blobWorkers.size()))
															#line 8975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont10cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 865 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		GetGranuleAssignmentsRequest req;
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		req.managerEpoch = -1;
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Optional<GetGranuleAssignmentsReply>> __when_expr_12 = timeout(brokenPromiseToNever(blobWorkers[i].granuleAssignmentsRequest.getReply(req)), SERVER_KNOBS->BLOB_WORKER_TIMEOUT);
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 2)); else return a_body1cont10cont1loopBody1cont1loopBody1when1(__when_expr_12.get(), loopDepth); };
		static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 13;
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 8992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1loopBody1cont1(Optional<GetGranuleAssignmentsReply> const& assignments,int loopDepth) 
	{
															#line 870 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (assignments.present())
															#line 9014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			for( auto& it : assignments.get().assignments ) {
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (purgeRange.intersects(it.range))
															#line 9020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 873 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					if (BGV_DEBUG)
															#line 9024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					{
															#line 874 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						fmt::print("BW {0} still has range [{1} - {2})\n", blobWorkers[i].id().toString(), it.range.begin.printable(), it.range.end.printable());
															#line 9028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					}
															#line 879 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					anyRangesLeft = true;
															#line 9032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 883 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 9040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV mapping check failed to reach BW {0}\n", blobWorkers[i].id().toString());
															#line 9044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 887 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			anyRangesLeft = true;
															#line 9048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 864 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i++;
															#line 9052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont10cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1loopBody1cont1(Optional<GetGranuleAssignmentsReply> && assignments,int loopDepth) 
	{
															#line 870 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (assignments.present())
															#line 9061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			for( auto& it : assignments.get().assignments ) {
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (purgeRange.intersects(it.range))
															#line 9067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 873 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					if (BGV_DEBUG)
															#line 9071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					{
															#line 874 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						fmt::print("BW {0} still has range [{1} - {2})\n", blobWorkers[i].id().toString(), it.range.begin.printable(), it.range.end.printable());
															#line 9075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					}
															#line 879 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					anyRangesLeft = true;
															#line 9079 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 883 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 9087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV mapping check failed to reach BW {0}\n", blobWorkers[i].id().toString());
															#line 9091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 887 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			anyRangesLeft = true;
															#line 9095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 864 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i++;
															#line 9099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont10cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1loopBody1when1(Optional<GetGranuleAssignmentsReply> const& assignments,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont1loopBody1cont1(assignments, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1loopBody1when1(Optional<GetGranuleAssignmentsReply> && assignments,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont1loopBody1cont1(std::move(assignments), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >*,Optional<GetGranuleAssignmentsReply> const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >*,Optional<GetGranuleAssignmentsReply> && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10cont1loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont10cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 13);

	}
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange purgeRange;
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool strictMetadataCheck;
															#line 744 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction tr;
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int i;
															#line 787 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int64_t filesChecked;
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange granuleRange;
															#line 790 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Version historyVersion;
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	UID granuleId;
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	GranuleFiles oldFiles;
															#line 810 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int fileIdx;
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Reference<BackupContainerFileSystem> bstore;
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool anyRangesLeft;
															#line 858 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	std::vector<BlobWorkerInterface> blobWorkers;
															#line 9302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via validateForcePurge()
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class ValidateForcePurgeActor final : public Actor<Void>, public ActorCallback< ValidateForcePurgeActor, 0, Void >, public ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >, public ActorCallback< ValidateForcePurgeActor, 2, Void >, public ActorCallback< ValidateForcePurgeActor, 3, Version >, public ActorCallback< ValidateForcePurgeActor, 4, Void >, public ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >, public ActorCallback< ValidateForcePurgeActor, 6, bool >, public ActorCallback< ValidateForcePurgeActor, 7, Void >, public ActorCallback< ValidateForcePurgeActor, 8, Void >, public ActorCallback< ValidateForcePurgeActor, 9, Void >, public ActorCallback< ValidateForcePurgeActor, 10, bool >, public ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >, public ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >, public ActorCallback< ValidateForcePurgeActor, 13, Void >, public FastAllocated<ValidateForcePurgeActor>, public ValidateForcePurgeActorState<ValidateForcePurgeActor> {
															#line 9307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<ValidateForcePurgeActor>::operator new;
	using FastAllocated<ValidateForcePurgeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15152098640370289664UL, 17347635797956604160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateForcePurgeActor, 0, Void >;
friend struct ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >;
friend struct ActorCallback< ValidateForcePurgeActor, 2, Void >;
friend struct ActorCallback< ValidateForcePurgeActor, 3, Version >;
friend struct ActorCallback< ValidateForcePurgeActor, 4, Void >;
friend struct ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >;
friend struct ActorCallback< ValidateForcePurgeActor, 6, bool >;
friend struct ActorCallback< ValidateForcePurgeActor, 7, Void >;
friend struct ActorCallback< ValidateForcePurgeActor, 8, Void >;
friend struct ActorCallback< ValidateForcePurgeActor, 9, Void >;
friend struct ActorCallback< ValidateForcePurgeActor, 10, bool >;
friend struct ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >;
friend struct ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >;
friend struct ActorCallback< ValidateForcePurgeActor, 13, Void >;
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	ValidateForcePurgeActor(Database const& cx,BlobGranuleVerifierWorkload* const& self,KeyRange const& purgeRange) 
															#line 9337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Void>(),
		   ValidateForcePurgeActorState<ValidateForcePurgeActor>(cx, self, purgeRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12524115166371418368UL, 16492883785153674240UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateForcePurge");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 3, Version >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 6, bool >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 10, bool >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 13, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Void> validateForcePurge( Database const& cx, BlobGranuleVerifierWorkload* const& self, KeyRange const& purgeRange ) {
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Void>(new ValidateForcePurgeActor(cx, self, purgeRange));
															#line 9382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 903 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

	// Check database against blob granules. This is especially important because during chaos phase this can error, and
	// initAtEnd doesn't get data checked otherwise
																#line 9389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via checkAllData()
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class CheckAllDataActor>
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckAllDataActorState {
															#line 9395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckAllDataActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self),
															#line 907 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   tr(cx),
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   keyRange(normalKeys),
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   gotEOS(false),
															#line 910 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   totalRows(0)
															#line 9412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("checkAllData", reinterpret_cast<unsigned long>(this));

	}
	~CheckAllDataActorState() 
	{
		fdb_probe_actor_destroy("checkAllData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 911 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			;
															#line 9427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckAllDataActorState();
		static_cast<CheckAllDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 969 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 9450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 970 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Final data check complete, checked {1} rows\n", self->clientId, totalRows);
															#line 9454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 973 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<CheckAllDataActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckAllDataActorState(); static_cast<CheckAllDataActor*>(this)->destroy(); return 0; }
															#line 9458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<CheckAllDataActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckAllDataActorState();
		static_cast<CheckAllDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 912 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		output = RangeResult();
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		readVersion = invalidVersion;
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		bufferedBytes = 0;
															#line 9481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		try {
															#line 916 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 916 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckAllDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckAllDataActor*>(this)->actor_wait_state = 1;
															#line 916 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckAllDataActor, 0, Version >*>(static_cast<CheckAllDataActor*>(this)));
															#line 9492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!output.empty())
															#line 9520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 944 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			rangeToCheck = KeyRangeRef(keyRange.begin, keyAfter(output.back().key));
															#line 9524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			try {
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>> __when_expr_3 = readFromBlob(cx, self->bstore, rangeToCheck, 0, readVersion);
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<CheckAllDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 9530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
				static_cast<CheckAllDataActor*>(this)->actor_wait_state = 4;
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*>(static_cast<CheckAllDataActor*>(this)));
															#line 9535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 9556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 9564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				gotEOS = true;
															#line 9568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
			else
			{
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<CheckAllDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<CheckAllDataActor*>(this)->actor_wait_state = 3;
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckAllDataActor, 2, Void >*>(static_cast<CheckAllDataActor*>(this)));
															#line 9582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& ver,int loopDepth) 
	{
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		readVersion = ver;
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		results = PromiseStream<Standalone<RangeResultRef>>();
															#line 920 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		stream = tr.getRangeStream(results, keyRange, GetRangeLimits());
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 9604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && ver,int loopDepth) 
	{
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		readVersion = ver;
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		results = PromiseStream<Standalone<RangeResultRef>>();
															#line 920 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		stream = tr.getRangeStream(results, keyRange, GetRangeLimits());
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 9619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& ver,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ver, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && ver,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ver), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckAllDataActor*>(this)->actor_wait_state > 0) static_cast<CheckAllDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAllDataActor*>(this)->ActorCallback< CheckAllDataActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAllDataActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckAllDataActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckAllDataActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 923 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		FutureStream<Standalone<RangeResultRef>> __when_expr_1 = results.getFuture();
															#line 923 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckAllDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<CheckAllDataActor*>(this)->actor_wait_state = 2;
															#line 923 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >*>(static_cast<CheckAllDataActor*>(this)));
															#line 9723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Standalone<RangeResultRef> const& res,int loopDepth) 
	{
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		output.arena().dependsOn(res.arena());
															#line 925 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		output.append(output.arena(), res.begin(), res.size());
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		bufferedBytes += res.expectedSize();
															#line 928 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (bufferedBytes >= 10 * SERVER_KNOBS->BG_SNAPSHOT_FILE_TARGET_BYTES)
															#line 9751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Standalone<RangeResultRef> && res,int loopDepth) 
	{
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		output.arena().dependsOn(res.arena());
															#line 925 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		output.append(output.arena(), res.begin(), res.size());
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		bufferedBytes += res.expectedSize();
															#line 928 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (bufferedBytes >= 10 * SERVER_KNOBS->BG_SNAPSHOT_FILE_TARGET_BYTES)
															#line 9769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Standalone<RangeResultRef> const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Standalone<RangeResultRef> && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckAllDataActor*>(this)->actor_wait_state > 0) static_cast<CheckAllDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAllDataActor*>(this)->ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckAllDataActor*>(this)->actor_wait_state > 0) static_cast<CheckAllDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAllDataActor*>(this)->ActorCallback< CheckAllDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAllDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckAllDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckAllDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (gotEOS)
															#line 9962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 961 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		totalRows += output.size();
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		keyRange = KeyRangeRef(rangeToCheck.end, keyRange.end);
															#line 9976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 952 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG && e.code() == error_code_blob_granule_transaction_too_old)
															#line 9986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("CheckAllData got BG_TTO for [{0} - {1}) @ {2}\n", rangeToCheck.begin.printable(), rangeToCheck.end.printable(), readVersion);
															#line 9990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 958 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(e.code() != error_code_blob_granule_transaction_too_old);
															#line 959 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& blob,int loopDepth) 
	{
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!compareFDBAndBlob(output, blob, rangeToCheck, readVersion, BGV_DEBUG))
															#line 10010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckAllDataActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckAllDataActorState(); static_cast<CheckAllDataActor*>(this)->destroy(); return 0; }
															#line 10014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckAllDataActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckAllDataActorState();
			static_cast<CheckAllDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && blob,int loopDepth) 
	{
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!compareFDBAndBlob(output, blob, rangeToCheck, readVersion, BGV_DEBUG))
															#line 10028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckAllDataActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckAllDataActorState(); static_cast<CheckAllDataActor*>(this)->destroy(); return 0; }
															#line 10032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckAllDataActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckAllDataActorState();
			static_cast<CheckAllDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& blob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(blob, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && blob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(blob), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckAllDataActor*>(this)->actor_wait_state > 0) static_cast<CheckAllDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAllDataActor*>(this)->ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 907 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction tr;
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange keyRange;
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool gotEOS;
															#line 910 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int64_t totalRows;
															#line 912 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	RangeResult output;
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Version readVersion;
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int64_t bufferedBytes;
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	PromiseStream<Standalone<RangeResultRef>> results;
															#line 920 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Future<Void> stream;
															#line 944 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange rangeToCheck;
															#line 10154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via checkAllData()
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckAllDataActor final : public Actor<bool>, public ActorCallback< CheckAllDataActor, 0, Version >, public ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >, public ActorCallback< CheckAllDataActor, 2, Void >, public ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >, public FastAllocated<CheckAllDataActor>, public CheckAllDataActorState<CheckAllDataActor> {
															#line 10159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<CheckAllDataActor>::operator new;
	using FastAllocated<CheckAllDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4765878593172468224UL, 8162630713699464704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckAllDataActor, 0, Version >;
friend struct ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >;
friend struct ActorCallback< CheckAllDataActor, 2, Void >;
friend struct ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >;
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckAllDataActor(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 10179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<bool>(),
		   CheckAllDataActorState<CheckAllDataActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18384931372181308416UL, 10676451418926174208UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkAllData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckAllDataActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckAllDataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<bool> checkAllData( Database const& cx, BlobGranuleVerifierWorkload* const& self ) {
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<bool>(new CheckAllDataActor(cx, self));
															#line 10214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 975 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

																#line 10219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class _checkActor>
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class _checkActorState {
															#line 10225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	_checkActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self)
															#line 10234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 977 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (self->triggerSummaryComplete.canBeSet())
															#line 10249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 978 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				self->triggerSummaryComplete.send(Void());
															#line 10253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			tr = Transaction(cx);
															#line 981 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (self->doForcePurge)
															#line 10259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 982 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (self->startedForcePurge)
															#line 10263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 983 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					if (self->forcePurgeKey.present())
															#line 10267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					{
															#line 984 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						StrictFuture<Void> __when_expr_0 = self->validateForcePurge(cx, self, normalKeys);
															#line 984 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
						if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
						static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 984 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 10278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont4(loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1cont3(loopDepth);
				}
			}
			else
			{
															#line 990 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (self->enablePurging && self->purgeAtLatest && deterministicRandom()->coinflip())
															#line 10295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					StrictFuture<Version> __when_expr_1 = self->doGrv(&tr);
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Version >*>(static_cast<_checkActor*>(this)));
															#line 10306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont7(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1007 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->doSetup && self->initAtEnd)
															#line 10335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1008 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->setUpBlobRange(cx);
															#line 1008 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 5;
															#line 1008 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 4, Void >*>(static_cast<_checkActor*>(this)));
															#line 10346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 988 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 10366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Version const& latestPurgeVersion,int loopDepth) 
	{
															#line 992 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 10471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purging Latest @ {1} before final availability check\n", self->clientId, latestPurgeVersion);
															#line 10475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_2 = cx->purgeBlobGranules(normalKeys, latestPurgeVersion, {}, false);
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont8when1(__when_expr_2.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Key >*>(static_cast<_checkActor*>(this)));
															#line 10486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Version && latestPurgeVersion,int loopDepth) 
	{
															#line 992 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 10495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purging Latest @ {1} before final availability check\n", self->clientId, latestPurgeVersion);
															#line 10499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_2 = cx->purgeBlobGranules(normalKeys, latestPurgeVersion, {}, false);
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont8when1(__when_expr_2.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Key >*>(static_cast<_checkActor*>(this)));
															#line 10510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when2(Version const& latestPurgeVersion,int loopDepth) 
	{
		loopDepth = a_body1cont8(latestPurgeVersion, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Version && latestPurgeVersion,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(latestPurgeVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont9(Key const& purgeKey,int loopDepth) 
	{
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 4;
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 3, Void >*>(static_cast<_checkActor*>(this)));
															#line 10601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Key && purgeKey,int loopDepth) 
	{
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 4;
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 3, Void >*>(static_cast<_checkActor*>(this)));
															#line 10617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont9(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 2, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _checkActor, 2, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 10701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1000 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest before final availability check complete\n", self->clientId);
															#line 10705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1002 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->purges++;
															#line 10709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 10718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1000 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest before final availability check complete\n", self->clientId);
															#line 10722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1002 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->purges++;
															#line 10726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _checkActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont12(int loopDepth) 
	{
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Version> __when_expr_5 = self->doGrv(&tr);
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10812 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 6;
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 5, Version >*>(static_cast<_checkActor*>(this)));
															#line 10817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _checkActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
															#line 1012 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		startReadVersion = readVersion;
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		checks = 0;
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		last = KeyRange();
															#line 1016 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		availabilityPassed = true;
															#line 1018 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		allRanges = Standalone<VectorRef<KeyRangeRef>>();
															#line 1020 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		rangeFetcher = self->findGranules(cx, self);
															#line 1021 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 10925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont12cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Version const& __readVersion,int loopDepth) 
	{
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		readVersion = __readVersion;
															#line 10934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Version && __readVersion,int loopDepth) 
	{
		readVersion = std::move(__readVersion);
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 5, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _checkActor, 5, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont2(int loopDepth) 
	{
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		rangeFetcher.cancel();
															#line 1046 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		allRanges = self->granuleRanges.get();
															#line 1047 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		totalSnapshotSizes = 0;
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		totalChunks = 0;
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		RangeForbody1cont12cont2Iterator0 = std::begin(allRanges);
															#line 11021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont12cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1(int loopDepth) 
	{
															#line 1023 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!self->granuleRanges.get().empty())
															#line 11037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1024 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			bool haveAll = true;
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (self->granuleRanges.get().front().begin != normalKeys.begin || self->granuleRanges.get().back().end != normalKeys.end)
															#line 11043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1027 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				haveAll = false;
															#line 11047 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 1029 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			for(int i = 0;haveAll && i < self->granuleRanges.get().size() - 1;i++) {
															#line 1030 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (self->granuleRanges.get()[i].end != self->granuleRanges.get()[i + 1].begin)
															#line 11053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 1031 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					haveAll = false;
															#line 11057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
			}
															#line 1034 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (haveAll)
															#line 11062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
				return a_body1cont12cont1break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
															#line 1038 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 11069 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1039 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("Waiting to get granule ranges for check\n");
															#line 11073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1041 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->granuleRanges.onChange();
															#line 1041 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11079 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 7;
															#line 1041 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 6, Void >*>(static_cast<_checkActor*>(this)));
															#line 11084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _checkActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont12cont3(int loopDepth) 
	{
															#line 1113 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->granuleSizeCheck && totalSnapshotSizes >= 1000000 && totalChunks > 4)
															#line 11193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1114 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			double ratio = (1.0 * totalSnapshotSizes) / (totalChunks * SERVER_KNOBS->BG_SNAPSHOT_FILE_TARGET_BYTES);
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (0.5 > ratio || ratio > 1.5)
															#line 11199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1116 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("ERROR: Incorrect snapshot file size:\n  Chunks: {0}\n  Ratio: {1}\n  Avg File Size: " "{2}\n  Expected Size: {3}\n", totalChunks, ratio, totalSnapshotSizes / totalChunks, SERVER_KNOBS->BG_SNAPSHOT_FILE_TARGET_BYTES);
															#line 11203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 1123 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(0.5 <= ratio && ratio <= 1.5);
															#line 11207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG && startReadVersion != readVersion)
															#line 11211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1127 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("Availability check updated read version from {0} to {1}\n", startReadVersion, readVersion);
															#line 11215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		checkFeedCleanupFuture = Future<Void>();
															#line 1132 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->clientId == 0)
															#line 11221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1133 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			checkFeedCleanupFuture = checkFeedCleanup(cx, BGV_DEBUG);
															#line 11225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
															#line 1135 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			checkFeedCleanupFuture = Future<Void>(Void());
															#line 11231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<bool> __when_expr_11 = self->checkAllData(cx, self);
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont12cont3when1(__when_expr_11.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 12;
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 11, bool >*>(static_cast<_checkActor*>(this)));
															#line 11242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1(int loopDepth) 
	{
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!(RangeForbody1cont12cont2Iterator0 != std::end(allRanges)))
															#line 11258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont12cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		auto& range = *RangeForbody1cont12cont2Iterator0;
															#line 11264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1050 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			r = range;
															#line 1051 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 11270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1052 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV {0}) Final availability check [{1} - {2}) @ {3}\n", self->clientId, r.begin.printable(), r.end.printable(), readVersion);
															#line 11274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
			try {
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				;
															#line 11279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = a_body1cont12cont2loopBody1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont12cont2loopBody1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont12cont2loopBody1Catch1(unknown_error(), loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont12cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont1(int loopDepth) 
	{
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		++RangeForbody1cont12cont2Iterator0;
															#line 11308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont12cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1090 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 11324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1091 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 11328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 1093 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 11332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
				return a_body1cont12cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 1096 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 11338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BG Verifier failed final availability check for [{0} - {1}) @ {2} with error {3}. Last " "Success=[{4} - {5})\n", r.begin.printable(), r.end.printable(), readVersion, e.name(), last.begin.printable(), last.end.printable());
															#line 11342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 1106 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			availabilityPassed = false;
															#line 11346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			return a_body1cont12cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont2loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1062 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Standalone<VectorRef<BlobGranuleChunkRef>>> __when_expr_7 = tr.readBlobGranules(r, 0, readVersion);
															#line 1062 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont12cont2loopBody1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont12cont2loopBody1loopBody1when1(__when_expr_7.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 8;
															#line 1062 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >*>(static_cast<_checkActor*>(this)));
															#line 11382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont2loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont2loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1079 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_blob_granule_transaction_too_old)
															#line 11417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1080 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Void> __when_expr_8 = delay(1.0);
															#line 1080 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont12cont2loopBody1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont2loopBody1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 9;
															#line 1080 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 8, Void >*>(static_cast<_checkActor*>(this)));
															#line 11428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1085 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Void> __when_expr_10 = tr.onError(e);
															#line 1085 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont12cont2loopBody1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont2loopBody1loopBody1Catch1when2(__when_expr_10.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 11;
															#line 1085 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 10, Void >*>(static_cast<_checkActor*>(this)));
															#line 11442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont2loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont12cont2loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1cont2(Standalone<VectorRef<BlobGranuleChunkRef>> const& chunks,int loopDepth) 
	{
															#line 1064 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(chunks.size() > 0);
															#line 1065 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		last = chunks.back().keyRange;
															#line 1066 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		checks += chunks.size();
															#line 1068 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		totalChunks += chunks.size();
															#line 1069 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : chunks ) {
															#line 1070 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(it.snapshotFile.present());
															#line 1071 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			totalSnapshotSizes += it.snapshotFile.get().length;
															#line 11470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		return a_body1cont12cont2loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1cont2(Standalone<VectorRef<BlobGranuleChunkRef>> && chunks,int loopDepth) 
	{
															#line 1064 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(chunks.size() > 0);
															#line 1065 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		last = chunks.back().keyRange;
															#line 1066 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		checks += chunks.size();
															#line 1068 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		totalChunks += chunks.size();
															#line 1069 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : chunks ) {
															#line 1070 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(it.snapshotFile.present());
															#line 1071 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			totalSnapshotSizes += it.snapshotFile.get().length;
															#line 11492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		return a_body1cont12cont2loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1when1(Standalone<VectorRef<BlobGranuleChunkRef>> const& chunks,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1cont2(chunks, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1when1(Standalone<VectorRef<BlobGranuleChunkRef>> && chunks,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1cont2(std::move(chunks), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Standalone<VectorRef<BlobGranuleChunkRef>> const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont2loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Standalone<VectorRef<BlobGranuleChunkRef>> && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont2loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont2loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.reset();
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Version> __when_expr_9 = self->doGrv(&tr);
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont12cont2loopBody1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont2loopBody1loopBody1Catch1cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 10;
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 9, Version >*>(static_cast<_checkActor*>(this)));
															#line 11592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.reset();
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Version> __when_expr_9 = self->doGrv(&tr);
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont12cont2loopBody1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont2loopBody1loopBody1Catch1cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 10;
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 9, Version >*>(static_cast<_checkActor*>(this)));
															#line 11610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont2loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _checkActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont2loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _checkActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont3(Version const& rv,int loopDepth) 
	{
															#line 1083 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		readVersion = rv;
															#line 11694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont3(Version && rv,int loopDepth) 
	{
															#line 1083 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		readVersion = rv;
															#line 11703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont2when1(Version const& rv,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont3(rv, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont2when1(Version && rv,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont3(std::move(rv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 9, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 9, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont2loopBody1loopBody1Catch1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _checkActor, 9, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont2loopBody1loopBody1Catch1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _checkActor, 9, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12cont2loopBody1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _checkActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12cont2loopBody1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _checkActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont12cont2loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12cont2loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont4(int loopDepth) 
	{
															#line 1139 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_12 = checkFeedCleanupFuture;
															#line 1139 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont12cont4when1(__when_expr_12.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 13;
															#line 1139 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 12, Void >*>(static_cast<_checkActor*>(this)));
															#line 11894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont3when1(bool const& __dataPassed,int loopDepth) 
	{
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		dataPassed = __dataPassed;
															#line 11903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(bool && __dataPassed,int loopDepth) 
	{
		dataPassed = std::move(__dataPassed);
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 11, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 11, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _checkActor, 11, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _checkActor, 11, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont12cont10(Void const& _,int loopDepth) 
	{
															#line 1141 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		result = availabilityPassed && dataPassed && self->mismatches == 0 && (checks > 0) && (self->timeTravelTooOld == 0);
															#line 1143 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("Blob Granule Verifier {0} {1}:\n", self->clientId, result ? "passed" : "failed");
															#line 1144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} successful final granule checks\n", checks);
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} failed final granule checks\n", availabilityPassed ? 0 : 1);
															#line 1146 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} mismatches\n", self->mismatches);
															#line 1147 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} time travel too old\n", self->timeTravelTooOld);
															#line 1148 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} errors\n", self->errors);
															#line 1149 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} initial reads\n", self->initialReads);
															#line 1150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} time travel reads\n", self->timeTravelReads);
															#line 1151 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} rows\n", self->rowsRead);
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} bytes\n", self->bytesRead);
															#line 1153 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} purges\n", self->purges);
															#line 1154 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} final data check\n", dataPassed ? "passed" : "failed");
															#line 1157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		TraceEvent("BlobGranuleVerifierChecked").detail("Result", result);
															#line 1160 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(result);
															#line 1162 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->doForcePurge)
															#line 12012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(!self->startedForcePurge);
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Version> __when_expr_13 = self->doGrv(&tr);
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont12cont10when1(__when_expr_13.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 14;
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 13, Version >*>(static_cast<_checkActor*>(this)));
															#line 12025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (self->enablePurging && self->purgeAtLatest && deterministicRandom()->coinflip())
															#line 12032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1175 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Version> __when_expr_17 = self->doGrv(&tr);
															#line 1175 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont12cont10when2(__when_expr_17.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 18;
															#line 1175 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 17, Version >*>(static_cast<_checkActor*>(this)));
															#line 12043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont12cont10cont7(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont12cont10(Void && _,int loopDepth) 
	{
															#line 1141 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		result = availabilityPassed && dataPassed && self->mismatches == 0 && (checks > 0) && (self->timeTravelTooOld == 0);
															#line 1143 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("Blob Granule Verifier {0} {1}:\n", self->clientId, result ? "passed" : "failed");
															#line 1144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} successful final granule checks\n", checks);
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} failed final granule checks\n", availabilityPassed ? 0 : 1);
															#line 1146 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} mismatches\n", self->mismatches);
															#line 1147 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} time travel too old\n", self->timeTravelTooOld);
															#line 1148 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} errors\n", self->errors);
															#line 1149 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} initial reads\n", self->initialReads);
															#line 1150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} time travel reads\n", self->timeTravelReads);
															#line 1151 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} rows\n", self->rowsRead);
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} bytes\n", self->bytesRead);
															#line 1153 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} purges\n", self->purges);
															#line 1154 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} final data check\n", dataPassed ? "passed" : "failed");
															#line 1157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		TraceEvent("BlobGranuleVerifierChecked").detail("Result", result);
															#line 1160 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(result);
															#line 1162 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->doForcePurge)
															#line 12088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1164 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(!self->startedForcePurge);
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Version> __when_expr_13 = self->doGrv(&tr);
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont12cont10when1(__when_expr_13.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 14;
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 13, Version >*>(static_cast<_checkActor*>(this)));
															#line 12101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (self->enablePurging && self->purgeAtLatest && deterministicRandom()->coinflip())
															#line 12108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1175 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Version> __when_expr_17 = self->doGrv(&tr);
															#line 1175 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont12cont10when2(__when_expr_17.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 18;
															#line 1175 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 17, Version >*>(static_cast<_checkActor*>(this)));
															#line 12119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont12cont10cont7(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont12cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont12cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _checkActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont12cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _checkActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont12cont10cont1(int loopDepth) 
	{
															#line 1188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->clientId == 0 && SERVER_KNOBS->BG_ENABLE_MERGING && self->clearAndMergeCheck)
															#line 12209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1189 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			CODE_PROBE(true, "BGV clearing database and awaiting merge", probe::decoration::rare);
															#line 1190 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_20 = clearAndAwaitMerge(cx, normalKeys);
															#line 1190 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont12cont10cont1when1(__when_expr_20.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 21;
															#line 1190 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 20, Void >*>(static_cast<_checkActor*>(this)));
															#line 12222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont10cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont10cont2(Version const& rv,int loopDepth) 
	{
															#line 1166 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->forcePurgeVersion = rv;
															#line 1167 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->purgedDataToCheck.clear();
															#line 1168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_14 = self->loadGranuleMetadataBeforeForcePurge(cx, self);
															#line 1168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont12cont10cont2when1(__when_expr_14.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 15;
															#line 1168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 14, Void >*>(static_cast<_checkActor*>(this)));
															#line 12247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont2(Version && rv,int loopDepth) 
	{
															#line 1166 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->forcePurgeVersion = rv;
															#line 1167 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->purgedDataToCheck.clear();
															#line 1168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_14 = self->loadGranuleMetadataBeforeForcePurge(cx, self);
															#line 1168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont12cont10cont2when1(__when_expr_14.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 15;
															#line 1168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 14, Void >*>(static_cast<_checkActor*>(this)));
															#line 12267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10when1(Version const& rv,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont2(rv, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10when1(Version && rv,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont2(std::move(rv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 13, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 13, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont12cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _checkActor, 13, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont12cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _checkActor, 13, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont12cont10cont3(Void const& _,int loopDepth) 
	{
															#line 1169 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_15 = cx->purgeBlobGranules(normalKeys, self->forcePurgeVersion, {}, true);
															#line 1169 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont12cont10cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 16;
															#line 1169 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 15, Key >*>(static_cast<_checkActor*>(this)));
															#line 12358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont3(Void && _,int loopDepth) 
	{
															#line 1169 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_15 = cx->purgeBlobGranules(normalKeys, self->forcePurgeVersion, {}, true);
															#line 1169 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont12cont10cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 16;
															#line 1169 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 15, Key >*>(static_cast<_checkActor*>(this)));
															#line 12374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont12cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _checkActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont12cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _checkActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont12cont10cont4(Key const& purgeKey,int loopDepth) 
	{
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->forcePurgeKey = purgeKey;
															#line 1171 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_16 = self->validateForcePurge(cx, self, normalKeys);
															#line 1171 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont12cont10cont4when1(__when_expr_16.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 17;
															#line 1171 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 16, Void >*>(static_cast<_checkActor*>(this)));
															#line 12467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont4(Key && purgeKey,int loopDepth) 
	{
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->forcePurgeKey = purgeKey;
															#line 1171 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_16 = self->validateForcePurge(cx, self, normalKeys);
															#line 1171 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont12cont10cont4when1(__when_expr_16.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 17;
															#line 1171 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 16, Void >*>(static_cast<_checkActor*>(this)));
															#line 12485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont3when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont4(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont3when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont4(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 15, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 15, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont12cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< _checkActor, 15, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont12cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< _checkActor, 15, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont12cont10cont5(Void const& _,int loopDepth) 
	{
															#line 1173 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 12569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont5(Void && _,int loopDepth) 
	{
															#line 1173 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 12581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont12cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< _checkActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont12cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< _checkActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont12cont10cont7(int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont8(Version const& latestPurgeVersion,int loopDepth) 
	{
															#line 1176 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 12674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1177 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purging Latest @ {1} after final availability check, waiting\n", self->clientId, latestPurgeVersion);
															#line 12678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1181 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_18 = cx->purgeBlobGranules(normalKeys, latestPurgeVersion, {}, false);
															#line 1181 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont12cont10cont8when1(__when_expr_18.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 19;
															#line 1181 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 18, Key >*>(static_cast<_checkActor*>(this)));
															#line 12689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont8(Version && latestPurgeVersion,int loopDepth) 
	{
															#line 1176 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 12698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1177 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purging Latest @ {1} after final availability check, waiting\n", self->clientId, latestPurgeVersion);
															#line 12702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1181 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_18 = cx->purgeBlobGranules(normalKeys, latestPurgeVersion, {}, false);
															#line 1181 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont12cont10cont8when1(__when_expr_18.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 19;
															#line 1181 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 18, Key >*>(static_cast<_checkActor*>(this)));
															#line 12713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10when2(Version const& latestPurgeVersion,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont8(latestPurgeVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10when2(Version && latestPurgeVersion,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont8(std::move(latestPurgeVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 17, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 17, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont12cont10when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< _checkActor, 17, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont12cont10when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< _checkActor, 17, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont12cont10cont9(Key const& purgeKey,int loopDepth) 
	{
															#line 1182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_19 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 1182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont12cont10cont9when1(__when_expr_19.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 20;
															#line 1182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 19, Void >*>(static_cast<_checkActor*>(this)));
															#line 12804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont9(Key && purgeKey,int loopDepth) 
	{
															#line 1182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_19 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 1182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont12cont10cont9when1(__when_expr_19.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 20;
															#line 1182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 19, Void >*>(static_cast<_checkActor*>(this)));
															#line 12820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont8when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont9(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont8when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont9(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 18, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 18, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont12cont10cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< _checkActor, 18, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont12cont10cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< _checkActor, 18, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont12cont10cont11(Void const& _,int loopDepth) 
	{
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 12904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1184 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest after final availability check complete\n", self->clientId);
															#line 12908 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont11(Void && _,int loopDepth) 
	{
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 12918 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1184 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest after final availability check complete\n", self->clientId);
															#line 12922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 19, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 19, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont12cont10cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< _checkActor, 19, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont12cont10cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< _checkActor, 19, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont12cont10cont12(int loopDepth) 
	{
															#line 1219 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1220 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) check waiting on summarizer to complete\n", self->clientId);
															#line 13011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1224 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_25 = self->summaryClient && self->forceFlushingClient;
															#line 1224 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1Catch1(__when_expr_25.getError(), loopDepth); else return a_body1cont12cont10cont12when1(__when_expr_25.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 26;
															#line 1224 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 25, Void >*>(static_cast<_checkActor*>(this)));
															#line 13022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont13(Void const& _,int loopDepth) 
	{
															#line 1192 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->enablePurging && self->purgeAtLatest && deterministicRandom()->coinflip())
															#line 13031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1193 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Version> __when_expr_21 = self->doGrv(&tr);
															#line 1193 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1Catch1(__when_expr_21.getError(), loopDepth); else return a_body1cont12cont10cont13when1(__when_expr_21.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 22;
															#line 1193 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 21, Version >*>(static_cast<_checkActor*>(this)));
															#line 13042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont10cont13cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont10cont13(Void && _,int loopDepth) 
	{
															#line 1192 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->enablePurging && self->purgeAtLatest && deterministicRandom()->coinflip())
															#line 13056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1193 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Version> __when_expr_21 = self->doGrv(&tr);
															#line 1193 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1Catch1(__when_expr_21.getError(), loopDepth); else return a_body1cont12cont10cont13when1(__when_expr_21.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 22;
															#line 1193 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 21, Version >*>(static_cast<_checkActor*>(this)));
															#line 13067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont10cont13cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 20, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 20, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont12cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< _checkActor, 20, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont12cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< _checkActor, 20, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont12cont10cont13cont1(int loopDepth) 
	{
															#line 1206 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1207 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Checking data after merge\n", self->clientId);
															#line 13160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1211 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<bool> __when_expr_24 = self->checkAllData(cx, self);
															#line 1211 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1Catch1(__when_expr_24.getError(), loopDepth); else return a_body1cont12cont10cont13cont1when1(__when_expr_24.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 25;
															#line 1211 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 24, bool >*>(static_cast<_checkActor*>(this)));
															#line 13171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont2(Version const& latestPurgeVersion,int loopDepth) 
	{
															#line 1194 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purging Latest @ {1} after clearAndAwaitMerge, waiting\n", self->clientId, latestPurgeVersion);
															#line 13184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1199 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_22 = cx->purgeBlobGranules(normalKeys, latestPurgeVersion, {}, false);
															#line 1199 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont12cont10cont13cont2when1(__when_expr_22.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 23;
															#line 1199 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 22, Key >*>(static_cast<_checkActor*>(this)));
															#line 13195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont2(Version && latestPurgeVersion,int loopDepth) 
	{
															#line 1194 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purging Latest @ {1} after clearAndAwaitMerge, waiting\n", self->clientId, latestPurgeVersion);
															#line 13208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1199 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_22 = cx->purgeBlobGranules(normalKeys, latestPurgeVersion, {}, false);
															#line 1199 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont12cont10cont13cont2when1(__when_expr_22.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 23;
															#line 1199 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 22, Key >*>(static_cast<_checkActor*>(this)));
															#line 13219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont13when1(Version const& latestPurgeVersion,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont2(latestPurgeVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13when1(Version && latestPurgeVersion,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont2(std::move(latestPurgeVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose22() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 21, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 21, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont12cont10cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorCallback< _checkActor, 21, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont12cont10cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorCallback< _checkActor, 21, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 21);

	}
	int a_body1cont12cont10cont13cont3(Key const& purgeKey,int loopDepth) 
	{
															#line 1200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_23 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 1200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1Catch1(__when_expr_23.getError(), loopDepth); else return a_body1cont12cont10cont13cont3when1(__when_expr_23.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 24;
															#line 1200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 23, Void >*>(static_cast<_checkActor*>(this)));
															#line 13310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont3(Key && purgeKey,int loopDepth) 
	{
															#line 1200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_23 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 1200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1Catch1(__when_expr_23.getError(), loopDepth); else return a_body1cont12cont10cont13cont3when1(__when_expr_23.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 24;
															#line 1200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 23, Void >*>(static_cast<_checkActor*>(this)));
															#line 13326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont2when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont3(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont2when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont3(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose23() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 22, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 22, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont12cont10cont13cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< _checkActor, 22, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont12cont10cont13cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorCallback< _checkActor, 22, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 22);

	}
	int a_body1cont12cont10cont13cont5(Void const& _,int loopDepth) 
	{
															#line 1201 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1202 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest after clearAndAwaitMerge complete\n", self->clientId);
															#line 13414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont10cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont5(Void && _,int loopDepth) 
	{
															#line 1201 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1202 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest after clearAndAwaitMerge complete\n", self->clientId);
															#line 13428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont10cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose24() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 23, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 23, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont12cont10cont13cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< _checkActor, 23, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont12cont10cont13cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorCallback< _checkActor, 23, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 23);

	}
	int a_body1cont12cont10cont13cont8(bool const& dataCheckAfterMerge,int loopDepth) 
	{
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(dataCheckAfterMerge);
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1215 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Checked data after merge\n", self->clientId);
															#line 13519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont10cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont8(bool && dataCheckAfterMerge,int loopDepth) 
	{
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(dataCheckAfterMerge);
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1215 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Checked data after merge\n", self->clientId);
															#line 13535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont10cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont1when1(bool const& dataCheckAfterMerge,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont8(dataCheckAfterMerge, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont1when1(bool && dataCheckAfterMerge,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont8(std::move(dataCheckAfterMerge), loopDepth);

		return loopDepth;
	}
	void a_exitChoose25() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 24, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 24, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont12cont10cont13cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< _checkActor, 24, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont12cont10cont13cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorCallback< _checkActor, 24, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 24);

	}
	int a_body1cont12cont10cont12cont1(Void const& _,int loopDepth) 
	{
															#line 1226 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1227 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) check done\n", self->clientId);
															#line 13624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1230 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(result); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 13628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(std::move(result)); // state_var_RVO
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont12cont1(Void && _,int loopDepth) 
	{
															#line 1226 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1227 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) check done\n", self->clientId);
															#line 13644 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1230 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(result); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 13648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(std::move(result)); // state_var_RVO
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose26() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 25, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 25, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont12cont10cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< _checkActor, 25, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont12cont10cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< _checkActor, 25, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 25);

	}
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction tr;
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Version readVersion;
															#line 1012 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Version startReadVersion;
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int checks;
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange last;
															#line 1016 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool availabilityPassed;
															#line 1018 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> allRanges;
															#line 1020 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Future<Void> rangeFetcher;
															#line 1047 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int64_t totalSnapshotSizes;
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int64_t totalChunks;
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	decltype(std::begin(std::declval<Standalone<VectorRef<KeyRangeRef>>>())) RangeForbody1cont12cont2Iterator0;
															#line 1050 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange r;
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Future<Void> checkFeedCleanupFuture;
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool dataPassed;
															#line 1141 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool result;
															#line 13765 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public ActorCallback< _checkActor, 1, Version >, public ActorCallback< _checkActor, 2, Key >, public ActorCallback< _checkActor, 3, Void >, public ActorCallback< _checkActor, 4, Void >, public ActorCallback< _checkActor, 5, Version >, public ActorCallback< _checkActor, 6, Void >, public ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >, public ActorCallback< _checkActor, 8, Void >, public ActorCallback< _checkActor, 9, Version >, public ActorCallback< _checkActor, 10, Void >, public ActorCallback< _checkActor, 11, bool >, public ActorCallback< _checkActor, 12, Void >, public ActorCallback< _checkActor, 13, Version >, public ActorCallback< _checkActor, 14, Void >, public ActorCallback< _checkActor, 15, Key >, public ActorCallback< _checkActor, 16, Void >, public ActorCallback< _checkActor, 17, Version >, public ActorCallback< _checkActor, 18, Key >, public ActorCallback< _checkActor, 19, Void >, public ActorCallback< _checkActor, 20, Void >, public ActorCallback< _checkActor, 21, Version >, public ActorCallback< _checkActor, 22, Key >, public ActorCallback< _checkActor, 23, Void >, public ActorCallback< _checkActor, 24, bool >, public ActorCallback< _checkActor, 25, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 13770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17833994868132432128UL, 9948708499966706176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
friend struct ActorCallback< _checkActor, 1, Version >;
friend struct ActorCallback< _checkActor, 2, Key >;
friend struct ActorCallback< _checkActor, 3, Void >;
friend struct ActorCallback< _checkActor, 4, Void >;
friend struct ActorCallback< _checkActor, 5, Version >;
friend struct ActorCallback< _checkActor, 6, Void >;
friend struct ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >;
friend struct ActorCallback< _checkActor, 8, Void >;
friend struct ActorCallback< _checkActor, 9, Version >;
friend struct ActorCallback< _checkActor, 10, Void >;
friend struct ActorCallback< _checkActor, 11, bool >;
friend struct ActorCallback< _checkActor, 12, Void >;
friend struct ActorCallback< _checkActor, 13, Version >;
friend struct ActorCallback< _checkActor, 14, Void >;
friend struct ActorCallback< _checkActor, 15, Key >;
friend struct ActorCallback< _checkActor, 16, Void >;
friend struct ActorCallback< _checkActor, 17, Version >;
friend struct ActorCallback< _checkActor, 18, Key >;
friend struct ActorCallback< _checkActor, 19, Void >;
friend struct ActorCallback< _checkActor, 20, Void >;
friend struct ActorCallback< _checkActor, 21, Version >;
friend struct ActorCallback< _checkActor, 22, Key >;
friend struct ActorCallback< _checkActor, 23, Void >;
friend struct ActorCallback< _checkActor, 24, bool >;
friend struct ActorCallback< _checkActor, 25, Void >;
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	_checkActor(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 13812 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _checkActor, 2, Key >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _checkActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _checkActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _checkActor, 5, Version >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _checkActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _checkActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _checkActor, 9, Version >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _checkActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _checkActor, 11, bool >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _checkActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _checkActor, 13, Version >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _checkActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< _checkActor, 15, Key >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< _checkActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< _checkActor, 17, Version >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< _checkActor, 18, Key >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< _checkActor, 19, Void >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< _checkActor, 20, Void >*)0, actor_cancelled()); break;
		case 22: this->a_callback_error((ActorCallback< _checkActor, 21, Version >*)0, actor_cancelled()); break;
		case 23: this->a_callback_error((ActorCallback< _checkActor, 22, Key >*)0, actor_cancelled()); break;
		case 24: this->a_callback_error((ActorCallback< _checkActor, 23, Void >*)0, actor_cancelled()); break;
		case 25: this->a_callback_error((ActorCallback< _checkActor, 24, bool >*)0, actor_cancelled()); break;
		case 26: this->a_callback_error((ActorCallback< _checkActor, 25, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<bool> _check( Database const& cx, BlobGranuleVerifierWorkload* const& self ) {
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 13869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 1232 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

	Future<bool> check(Database const& cx) override {
		if (clientId == 0 || (!doForcePurge && !purgeAtLatest)) {
			return _check(cx, this);
		}
		return true;
	}
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<BlobGranuleVerifierWorkload> BlobGranuleVerifierWorkloadFactory;
