#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
/*
 * BlobGranuleRangesWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/Arena.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/Util.h"
#include "flow/serialize.h"
#include <cstring>
#include <limits>

#include "flow/actorcompiler.h" // This must be the last #include.

#define BGRW_DEBUG true

// FIXME: need to do multiple changes per commit to properly exercise future change feed logic
// A workload specifically designed to stress the blob range management of the blob manager + blob worker, and test the
// blob database api functions
struct BlobGranuleRangesWorkload : TestWorkload {
	static constexpr auto NAME = "BlobGranuleRanges";
	// test settings
	double testDuration;
	int operationsPerSecond;
	int targetRanges;
	bool sequential;
	int sequentialGap;

	Future<Void> client;
	Future<Void> unitClient;
	bool stopUnitClient;
	Optional<TenantName> tenantName;
	Optional<Reference<Tenant>> tenant;

	int32_t nextKey;

	std::vector<KeyRange> inactiveRanges;
	std::vector<KeyRange> activeRanges;

	BlobGranuleRangesWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 30.0);
		operationsPerSecond = getOption(options, "opsPerSecond"_sr, deterministicRandom()->randomInt(1, 100));
		operationsPerSecond /= clientCount;
		if (operationsPerSecond <= 0) {
			operationsPerSecond = 1;
		}

		int64_t rand = wcx.sharedRandomNumber;
		targetRanges = deterministicRandom()->randomExp(1, 1 + rand % 10);
		targetRanges *= (0.8 + (deterministicRandom()->random01() * 0.4));
		targetRanges /= clientCount;
		if (targetRanges <= 0) {
			targetRanges = 1;
		}
		rand /= 10;

		sequential = rand % 2;
		rand /= 2;

		sequentialGap = 1 + rand % 2;
		rand /= 2;

		nextKey = 10000000 * clientId;

		stopUnitClient = false;
		tenantName = StringRef("bgrwTenant" + std::to_string(clientId));

		TraceEvent("BlobGranuleRangesWorkloadInit").detail("TargetRanges", targetRanges);
	}

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }

	std::string newKey() {
		if (sequential) {
			nextKey += sequentialGap;
			return format("%08x", nextKey);
		} else {
			return deterministicRandom()->randomUniqueID().toString();
		}
	}

																#line 109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via registerNewRange()
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class RegisterNewRangeActor>
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class RegisterNewRangeActorState {
															#line 115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	RegisterNewRangeActorState(Database const& cx,BlobGranuleRangesWorkload* const& self,Optional<Reference<Tenant>> const& alternateTenant) 
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self),
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   alternateTenant(alternateTenant)
															#line 126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("registerNewRange", reinterpret_cast<unsigned long>(this));

	}
	~RegisterNewRangeActorState() 
	{
		fdb_probe_actor_destroy("registerNewRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			std::string nextRangeKey = "R_" + self->newKey();
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			range = KeyRange(KeyRangeRef(StringRef(nextRangeKey), strinc(StringRef(nextRangeKey))));
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (BGRW_DEBUG)
															#line 145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				fmt::print("Registering new range [{0} - {1})\n", range.begin.printable(), range.end.printable());
															#line 149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_0 = cx->blobbifyRange(range, alternateTenant.present() ? alternateTenant : self->tenant);
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<RegisterNewRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegisterNewRangeActor*>(this)->actor_wait_state = 1;
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterNewRangeActor, 0, bool >*>(static_cast<RegisterNewRangeActor*>(this)));
															#line 160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterNewRangeActorState();
		static_cast<RegisterNewRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& success,int loopDepth) 
	{
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(success);
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (BGRW_DEBUG)
															#line 185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			fmt::print("Registered new range [{0} - {1})\n", range.begin.printable(), range.end.printable());
															#line 189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		self->activeRanges.push_back(range);
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<RegisterNewRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterNewRangeActorState(); static_cast<RegisterNewRangeActor*>(this)->destroy(); return 0; }
															#line 195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<RegisterNewRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterNewRangeActorState();
		static_cast<RegisterNewRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(bool && success,int loopDepth) 
	{
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(success);
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (BGRW_DEBUG)
															#line 209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			fmt::print("Registered new range [{0} - {1})\n", range.begin.printable(), range.end.printable());
															#line 213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		self->activeRanges.push_back(range);
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<RegisterNewRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterNewRangeActorState(); static_cast<RegisterNewRangeActor*>(this)->destroy(); return 0; }
															#line 219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<RegisterNewRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterNewRangeActorState();
		static_cast<RegisterNewRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont1(success, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterNewRangeActor*>(this)->actor_wait_state > 0) static_cast<RegisterNewRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterNewRangeActor*>(this)->ActorCallback< RegisterNewRangeActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterNewRangeActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("registerNewRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterNewRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerNewRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterNewRangeActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("registerNewRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterNewRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerNewRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterNewRangeActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("registerNewRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterNewRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerNewRange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Optional<Reference<Tenant>> alternateTenant;
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via registerNewRange()
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class RegisterNewRangeActor final : public Actor<Void>, public ActorCallback< RegisterNewRangeActor, 0, bool >, public FastAllocated<RegisterNewRangeActor>, public RegisterNewRangeActorState<RegisterNewRangeActor> {
															#line 315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<RegisterNewRangeActor>::operator new;
	using FastAllocated<RegisterNewRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12533081986190327040UL, 104846648296907264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterNewRangeActor, 0, bool >;
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	RegisterNewRangeActor(Database const& cx,BlobGranuleRangesWorkload* const& self,Optional<Reference<Tenant>> const& alternateTenant) 
															#line 332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RegisterNewRangeActorState<RegisterNewRangeActor>(cx, self, alternateTenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerNewRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18295972294678452736UL, 3219298324135330560UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterNewRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerNewRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerNewRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterNewRangeActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> registerNewRange( Database const& cx, BlobGranuleRangesWorkload* const& self, Optional<Reference<Tenant>> const& alternateTenant ) {
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new RegisterNewRangeActor(cx, self, alternateTenant));
															#line 364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via versionedForcePurge()
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class VersionedForcePurgeActor>
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class VersionedForcePurgeActorState {
															#line 375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	VersionedForcePurgeActorState(Database const& cx,KeyRange const& range,Optional<Reference<Tenant>> const& tenant) 
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   range(range),
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   tenant(tenant)
															#line 386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("versionedForcePurge", reinterpret_cast<unsigned long>(this));

	}
	~VersionedForcePurgeActorState() 
	{
		fdb_probe_actor_destroy("versionedForcePurge", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			Version rv = deterministicRandom()->coinflip() ? latestVersion : 1;
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Key> __when_expr_0 = cx->purgeBlobGranules(range, rv, tenant, true);
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<VersionedForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<VersionedForcePurgeActor*>(this)->actor_wait_state = 1;
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VersionedForcePurgeActor, 0, Key >*>(static_cast<VersionedForcePurgeActor*>(this)));
															#line 410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VersionedForcePurgeActorState();
		static_cast<VersionedForcePurgeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& purgeKey,int loopDepth) 
	{
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<VersionedForcePurgeActor*>(this)->SAV<Key>::futures) { (void)(purgeKey); this->~VersionedForcePurgeActorState(); static_cast<VersionedForcePurgeActor*>(this)->destroy(); return 0; }
															#line 433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<VersionedForcePurgeActor*>(this)->SAV< Key >::value()) Key(purgeKey);
		this->~VersionedForcePurgeActorState();
		static_cast<VersionedForcePurgeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Key && purgeKey,int loopDepth) 
	{
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<VersionedForcePurgeActor*>(this)->SAV<Key>::futures) { (void)(purgeKey); this->~VersionedForcePurgeActorState(); static_cast<VersionedForcePurgeActor*>(this)->destroy(); return 0; }
															#line 445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<VersionedForcePurgeActor*>(this)->SAV< Key >::value()) Key(purgeKey);
		this->~VersionedForcePurgeActorState();
		static_cast<VersionedForcePurgeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VersionedForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<VersionedForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<VersionedForcePurgeActor*>(this)->ActorCallback< VersionedForcePurgeActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< VersionedForcePurgeActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("versionedForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionedForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionedForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VersionedForcePurgeActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("versionedForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionedForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionedForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VersionedForcePurgeActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("versionedForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionedForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionedForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Optional<Reference<Tenant>> tenant;
															#line 534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via versionedForcePurge()
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class VersionedForcePurgeActor final : public Actor<Key>, public ActorCallback< VersionedForcePurgeActor, 0, Key >, public FastAllocated<VersionedForcePurgeActor>, public VersionedForcePurgeActorState<VersionedForcePurgeActor> {
															#line 539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<VersionedForcePurgeActor>::operator new;
	using FastAllocated<VersionedForcePurgeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13125210865288107520UL, 10272810765324174080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VersionedForcePurgeActor, 0, Key >;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	VersionedForcePurgeActor(Database const& cx,KeyRange const& range,Optional<Reference<Tenant>> const& tenant) 
															#line 556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Key>(),
		   VersionedForcePurgeActorState<VersionedForcePurgeActor>(cx, range, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("versionedForcePurge", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4696137240061824000UL, 5344973450194574336UL);
		ActorExecutionContextHelper __helper(static_cast<VersionedForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("versionedForcePurge");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("versionedForcePurge", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VersionedForcePurgeActor, 0, Key >*)0, actor_cancelled()); break;
		}

	}
};
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Key> versionedForcePurge( Database const& cx, KeyRange const& range, Optional<Reference<Tenant>> const& tenant ) {
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Key>(new VersionedForcePurgeActor(cx, range, tenant));
															#line 588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via unregisterRandomRange()
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class UnregisterRandomRangeActor>
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class UnregisterRandomRangeActorState {
															#line 599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	UnregisterRandomRangeActorState(Database const& cx,BlobGranuleRangesWorkload* const& self) 
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self)
															#line 608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("unregisterRandomRange", reinterpret_cast<unsigned long>(this));

	}
	~UnregisterRandomRangeActorState() 
	{
		fdb_probe_actor_destroy("unregisterRandomRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			int randomRangeIdx = deterministicRandom()->randomInt(0, self->activeRanges.size());
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			range = self->activeRanges[randomRangeIdx];
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			swapAndPop(&self->activeRanges, randomRangeIdx);
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (BGRW_DEBUG)
															#line 629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				fmt::print("Unregistering new range [{0} - {1})\n", range.begin.printable(), range.end.printable());
															#line 633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				if (BGRW_DEBUG)
															#line 641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				{
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					fmt::print("Force purging range before un-registering: [{0} - {1})\n", range.begin.printable(), range.end.printable());
															#line 645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				}
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				StrictFuture<Key> __when_expr_0 = self->versionedForcePurge(cx, range, self->tenant);
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				if (static_cast<UnregisterRandomRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UnregisterRandomRangeActor*>(this)->actor_wait_state = 1;
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UnregisterRandomRangeActor, 0, Key >*>(static_cast<UnregisterRandomRangeActor*>(this)));
															#line 656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UnregisterRandomRangeActorState();
		static_cast<UnregisterRandomRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_2 = cx->unblobbifyRange(range, self->tenant);
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<UnregisterRandomRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UnregisterRandomRangeActor*>(this)->actor_wait_state = 3;
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UnregisterRandomRangeActor, 2, bool >*>(static_cast<UnregisterRandomRangeActor*>(this)));
															#line 691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Key const& purgeKey,int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<UnregisterRandomRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<UnregisterRandomRangeActor*>(this)->actor_wait_state = 2;
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UnregisterRandomRangeActor, 1, Void >*>(static_cast<UnregisterRandomRangeActor*>(this)));
															#line 707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Key && purgeKey,int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<UnregisterRandomRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<UnregisterRandomRangeActor*>(this)->actor_wait_state = 2;
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UnregisterRandomRangeActor, 1, Void >*>(static_cast<UnregisterRandomRangeActor*>(this)));
															#line 723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont3(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UnregisterRandomRangeActor*>(this)->actor_wait_state > 0) static_cast<UnregisterRandomRangeActor*>(this)->actor_wait_state = 0;
		static_cast<UnregisterRandomRangeActor*>(this)->ActorCallback< UnregisterRandomRangeActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< UnregisterRandomRangeActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnregisterRandomRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UnregisterRandomRangeActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnregisterRandomRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UnregisterRandomRangeActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnregisterRandomRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UnregisterRandomRangeActor*>(this)->actor_wait_state > 0) static_cast<UnregisterRandomRangeActor*>(this)->actor_wait_state = 0;
		static_cast<UnregisterRandomRangeActor*>(this)->ActorCallback< UnregisterRandomRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnregisterRandomRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnregisterRandomRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UnregisterRandomRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnregisterRandomRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UnregisterRandomRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnregisterRandomRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(bool const& success,int loopDepth) 
	{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(success);
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (BGRW_DEBUG)
															#line 896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			fmt::print("Unregistered new range [{0} - {1})\n", range.begin.printable(), range.end.printable());
															#line 900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		self->inactiveRanges.push_back(range);
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<UnregisterRandomRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnregisterRandomRangeActorState(); static_cast<UnregisterRandomRangeActor*>(this)->destroy(); return 0; }
															#line 906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<UnregisterRandomRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnregisterRandomRangeActorState();
		static_cast<UnregisterRandomRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(bool && success,int loopDepth) 
	{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(success);
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (BGRW_DEBUG)
															#line 920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			fmt::print("Unregistered new range [{0} - {1})\n", range.begin.printable(), range.end.printable());
															#line 924 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		self->inactiveRanges.push_back(range);
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<UnregisterRandomRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnregisterRandomRangeActorState(); static_cast<UnregisterRandomRangeActor*>(this)->destroy(); return 0; }
															#line 930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<UnregisterRandomRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnregisterRandomRangeActorState();
		static_cast<UnregisterRandomRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont6(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UnregisterRandomRangeActor*>(this)->actor_wait_state > 0) static_cast<UnregisterRandomRangeActor*>(this)->actor_wait_state = 0;
		static_cast<UnregisterRandomRangeActor*>(this)->ActorCallback< UnregisterRandomRangeActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< UnregisterRandomRangeActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnregisterRandomRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UnregisterRandomRangeActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnregisterRandomRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UnregisterRandomRangeActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnregisterRandomRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unregisterRandomRange", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 1019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via unregisterRandomRange()
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class UnregisterRandomRangeActor final : public Actor<Void>, public ActorCallback< UnregisterRandomRangeActor, 0, Key >, public ActorCallback< UnregisterRandomRangeActor, 1, Void >, public ActorCallback< UnregisterRandomRangeActor, 2, bool >, public FastAllocated<UnregisterRandomRangeActor>, public UnregisterRandomRangeActorState<UnregisterRandomRangeActor> {
															#line 1024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<UnregisterRandomRangeActor>::operator new;
	using FastAllocated<UnregisterRandomRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17940539208051366144UL, 12878191701233970176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UnregisterRandomRangeActor, 0, Key >;
friend struct ActorCallback< UnregisterRandomRangeActor, 1, Void >;
friend struct ActorCallback< UnregisterRandomRangeActor, 2, bool >;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	UnregisterRandomRangeActor(Database const& cx,BlobGranuleRangesWorkload* const& self) 
															#line 1043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   UnregisterRandomRangeActorState<UnregisterRandomRangeActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("unregisterRandomRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11729054212964559616UL, 14696839710035906304UL);
		ActorExecutionContextHelper __helper(static_cast<UnregisterRandomRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("unregisterRandomRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("unregisterRandomRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UnregisterRandomRangeActor, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UnregisterRandomRangeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UnregisterRandomRangeActor, 2, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> unregisterRandomRange( Database const& cx, BlobGranuleRangesWorkload* const& self ) {
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new UnregisterRandomRangeActor(cx, self));
															#line 1077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 1082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via setupTenant()
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class SetupTenantActor>
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class SetupTenantActorState {
															#line 1088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	SetupTenantActorState(Database const& cx,TenantName const& name) 
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   name(name)
															#line 1097 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("setupTenant", reinterpret_cast<unsigned long>(this));

	}
	~SetupTenantActorState() 
	{
		fdb_probe_actor_destroy("setupTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (BGRW_DEBUG)
															#line 1112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				fmt::print("Creating tenant: {0}\n", name.printable());
															#line 1116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Optional<TenantMapEntry>> __when_expr_0 = TenantAPI::createTenant(cx.getReference(), name);
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<SetupTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupTenantActor*>(this)->actor_wait_state = 1;
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupTenantActor, 0, Optional<TenantMapEntry> >*>(static_cast<SetupTenantActor*>(this)));
															#line 1127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupTenantActorState();
		static_cast<SetupTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (BGRW_DEBUG)
															#line 1152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			fmt::print("Created tenant {0}: {1}\n", name.printable(), entry.get().prefix.printable());
															#line 1156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<SetupTenantActor*>(this)->SAV<TenantMapEntry>::futures) { (void)(entry.get()); this->~SetupTenantActorState(); static_cast<SetupTenantActor*>(this)->destroy(); return 0; }
															#line 1160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<SetupTenantActor*>(this)->SAV< TenantMapEntry >::value()) TenantMapEntry(entry.get());
		this->~SetupTenantActorState();
		static_cast<SetupTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (BGRW_DEBUG)
															#line 1174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			fmt::print("Created tenant {0}: {1}\n", name.printable(), entry.get().prefix.printable());
															#line 1178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<SetupTenantActor*>(this)->SAV<TenantMapEntry>::futures) { (void)(entry.get()); this->~SetupTenantActorState(); static_cast<SetupTenantActor*>(this)->destroy(); return 0; }
															#line 1182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<SetupTenantActor*>(this)->SAV< TenantMapEntry >::value()) TenantMapEntry(entry.get());
		this->~SetupTenantActorState();
		static_cast<SetupTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont1(entry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupTenantActor*>(this)->actor_wait_state > 0) static_cast<SetupTenantActor*>(this)->actor_wait_state = 0;
		static_cast<SetupTenantActor*>(this)->ActorCallback< SetupTenantActor, 0, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< SetupTenantActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("setupTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupTenantActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("setupTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupTenantActor, 0, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("setupTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	TenantName name;
															#line 1269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via setupTenant()
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class SetupTenantActor final : public Actor<TenantMapEntry>, public ActorCallback< SetupTenantActor, 0, Optional<TenantMapEntry> >, public FastAllocated<SetupTenantActor>, public SetupTenantActorState<SetupTenantActor> {
															#line 1274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<SetupTenantActor>::operator new;
	using FastAllocated<SetupTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16665734084579659520UL, 14687966075099374848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TenantMapEntry>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupTenantActor, 0, Optional<TenantMapEntry> >;
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	SetupTenantActor(Database const& cx,TenantName const& name) 
															#line 1291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<TenantMapEntry>(),
		   SetupTenantActorState<SetupTenantActor>(cx, name),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setupTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17905612009292099328UL, 16984217303405686784UL);
		ActorExecutionContextHelper __helper(static_cast<SetupTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setupTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setupTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupTenantActor, 0, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<TenantMapEntry> setupTenant( Database const& cx, TenantName const& name ) {
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<TenantMapEntry>(new SetupTenantActor(cx, name));
															#line 1323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 1328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class _setupActor>
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class _setupActorState {
															#line 1334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	_setupActorState(Database const& cx,BlobGranuleRangesWorkload* const& self) 
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self)
															#line 1343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			TraceEvent("BlobGranuleRangesSetup").detail("InitialRanges", self->targetRanges).log();
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(ManagementAPI::changeConfig(cx.getReference(), "blob_granules_enabled=1", true));
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 1367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (cx->clientInfo->get().tenantMode != TenantMode::REQUIRED && deterministicRandom()->coinflip())
															#line 1390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			self->tenantName.reset();
															#line 1394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (self->tenantName.present())
															#line 1398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(self->setupTenant(cx, self->tenantName.get()));
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 1409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (cx->clientInfo->get().tenantMode != TenantMode::REQUIRED && deterministicRandom()->coinflip())
															#line 1423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			self->tenantName.reset();
															#line 1427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (self->tenantName.present())
															#line 1431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(self->setupTenant(cx, self->tenantName.get()));
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 1442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		i = int();
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		std::vector<Future<Void>> createInitialRanges;
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		i = 0;
															#line 1535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		self->tenant = makeReference<Tenant>(cx, self->tenantName.get());
															#line 1544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		try {
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->registerNewRange(cx, self, makeReference<Tenant>(cx, "BogusTenant"_sr));
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1cont4Catch1(actor_cancelled(), loopDepth);
															#line 1550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont4Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 1555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		self->tenant = makeReference<Tenant>(cx, self->tenantName.get());
															#line 1570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		try {
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->registerNewRange(cx, self, makeReference<Tenant>(cx, "BogusTenant"_sr));
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1cont4Catch1(actor_cancelled(), loopDepth);
															#line 1576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont4Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 1581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (e.code() != error_code_tenant_not_found)
															#line 1678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(false);
															#line 1698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(false);
															#line 1707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		TraceEvent("BlobGranuleRangesSetupComplete");
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 1806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!(i < self->targetRanges))
															#line 1825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->registerNewRange(cx, self, {});
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 4;
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 3, Void >*>(static_cast<_setupActor*>(this)));
															#line 1838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		i++;
															#line 1860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		i++;
															#line 1869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _setupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _setupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	int i;
															#line 1955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public ActorCallback< _setupActor, 2, Void >, public ActorCallback< _setupActor, 3, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 1960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10014545921875777024UL, 1471859375524062976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
friend struct ActorCallback< _setupActor, 2, Void >;
friend struct ActorCallback< _setupActor, 3, Void >;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	_setupActor(Database const& cx,BlobGranuleRangesWorkload* const& self) 
															#line 1980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _setupActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, BlobGranuleRangesWorkload* const& self ) {
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 2015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

	Future<Void> start(Database const& cx) override {
		client = blobGranuleRangesClient(cx->clone(), this);
		if (clientId == 0) {
			unitClient = blobGranuleRangesUnitTests(cx->clone(), this);
		} else {
			unitClient = Future<Void>(Void());
		}
		return delay(testDuration);
	}

	Future<bool> check(Database const& cx) override {
		client = Future<Void>();
		stopUnitClient = true;
		return _check(cx, this);
	}

																#line 2036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via isRangeActive()
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class IsRangeActiveActor>
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class IsRangeActiveActorState {
															#line 2042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	IsRangeActiveActorState(Database const& cx,KeyRange const& range,Optional<Reference<Tenant>> const& tenant) 
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   range(range),
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   tenant(tenant)
															#line 2053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("isRangeActive", reinterpret_cast<unsigned long>(this));

	}
	~IsRangeActiveActorState() 
	{
		fdb_probe_actor_destroy("isRangeActive", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			Optional<Version> rv;
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 2070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				rv = latestVersion;
															#line 2074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Version> __when_expr_0 = cx->verifyBlobRange(range, rv, tenant);
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<IsRangeActiveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IsRangeActiveActor*>(this)->actor_wait_state = 1;
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IsRangeActiveActor, 0, Version >*>(static_cast<IsRangeActiveActor*>(this)));
															#line 2085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IsRangeActiveActorState();
		static_cast<IsRangeActiveActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<IsRangeActiveActor*>(this)->SAV<bool>::futures) { (void)(v != invalidVersion); this->~IsRangeActiveActorState(); static_cast<IsRangeActiveActor*>(this)->destroy(); return 0; }
															#line 2108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<IsRangeActiveActor*>(this)->SAV< bool >::value()) bool(v != invalidVersion);
		this->~IsRangeActiveActorState();
		static_cast<IsRangeActiveActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Version const& __v,int loopDepth) 
	{
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		v = __v;
															#line 2120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __v,int loopDepth) 
	{
		v = std::move(__v);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IsRangeActiveActor*>(this)->actor_wait_state > 0) static_cast<IsRangeActiveActor*>(this)->actor_wait_state = 0;
		static_cast<IsRangeActiveActor*>(this)->ActorCallback< IsRangeActiveActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< IsRangeActiveActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("isRangeActive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsRangeActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isRangeActive", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IsRangeActiveActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("isRangeActive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsRangeActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isRangeActive", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IsRangeActiveActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("isRangeActive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsRangeActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isRangeActive", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Optional<Reference<Tenant>> tenant;
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Version v;
															#line 2203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via isRangeActive()
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class IsRangeActiveActor final : public Actor<bool>, public ActorCallback< IsRangeActiveActor, 0, Version >, public FastAllocated<IsRangeActiveActor>, public IsRangeActiveActorState<IsRangeActiveActor> {
															#line 2208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<IsRangeActiveActor>::operator new;
	using FastAllocated<IsRangeActiveActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10724002763879636224UL, 9601614546034407424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IsRangeActiveActor, 0, Version >;
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	IsRangeActiveActor(Database const& cx,KeyRange const& range,Optional<Reference<Tenant>> const& tenant) 
															#line 2225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   IsRangeActiveActorState<IsRangeActiveActor>(cx, range, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("isRangeActive", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10750763488019468032UL, 2866590040471279104UL);
		ActorExecutionContextHelper __helper(static_cast<IsRangeActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("isRangeActive");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("isRangeActive", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IsRangeActiveActor, 0, Version >*)0, actor_cancelled()); break;
		}

	}
};
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<bool> isRangeActive( Database const& cx, KeyRange const& range, Optional<Reference<Tenant>> const& tenant ) {
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<bool>(new IsRangeActiveActor(cx, range, tenant));
															#line 2257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 2262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via checkRange()
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class CheckRangeActor>
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class CheckRangeActorState {
															#line 2268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	CheckRangeActorState(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range,bool const& isActive,bool const& strict) 
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self),
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   range(range),
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   isActive(isActive),
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   strict(strict)
															#line 2283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("checkRange", reinterpret_cast<unsigned long>(this));

	}
	~CheckRangeActorState() 
	{
		fdb_probe_actor_destroy("checkRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			;
															#line 2298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckRangeActorState();
		static_cast<CheckRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_2 = cx->listBlobbifiedRanges(range, 1000000, self->tenant);
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<CheckRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckRangeActor*>(this)->actor_wait_state = 3;
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckRangeActor, 2, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<CheckRangeActor*>(this)));
															#line 2328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_0 = self->isRangeActive(cx, range, self->tenant);
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<CheckRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckRangeActor*>(this)->actor_wait_state = 1;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckRangeActor, 0, bool >*>(static_cast<CheckRangeActor*>(this)));
															#line 2351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& completed,int loopDepth) 
	{
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (completed == isActive)
															#line 2373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (BGRW_DEBUG)
															#line 2379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			fmt::print("CHECK: {0} range [{1} - {2}) failed!\n", isActive ? "Active" : "Inactive", range.begin.printable(), range.end.printable());
															#line 2383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<CheckRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckRangeActor*>(this)->actor_wait_state = 2;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckRangeActor, 1, Void >*>(static_cast<CheckRangeActor*>(this)));
															#line 2394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && completed,int loopDepth) 
	{
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (completed == isActive)
															#line 2403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (BGRW_DEBUG)
															#line 2409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			fmt::print("CHECK: {0} range [{1} - {2}) failed!\n", isActive ? "Active" : "Inactive", range.begin.printable(), range.end.printable());
															#line 2413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<CheckRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckRangeActor*>(this)->actor_wait_state = 2;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckRangeActor, 1, Void >*>(static_cast<CheckRangeActor*>(this)));
															#line 2424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& completed,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(completed, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && completed,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(completed), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckRangeActor*>(this)->actor_wait_state > 0) static_cast<CheckRangeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRangeActor*>(this)->ActorCallback< CheckRangeActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRangeActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckRangeActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckRangeActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckRangeActor*>(this)->actor_wait_state > 0) static_cast<CheckRangeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRangeActor*>(this)->ActorCallback< CheckRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(Standalone<VectorRef<KeyRangeRef>> const& blobRanges,int loopDepth) 
	{
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (isActive)
															#line 2595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			ASSERT(blobRanges.size() == 1);
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (strict)
															#line 2601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_EQ(blobRanges[0].begin, range.begin);
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_EQ(blobRanges[0].end, range.end);
															#line 2607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
			else
			{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_LE(blobRanges[0].begin, range.begin);
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_GE(blobRanges[0].end, range.end);
															#line 2615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
		}
		else
		{
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			ASSERT(blobRanges.empty());
															#line 2622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		tr = Transaction(cx, self->tenant);
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		;
															#line 2628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Standalone<VectorRef<KeyRangeRef>> && blobRanges,int loopDepth) 
	{
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (isActive)
															#line 2637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			ASSERT(blobRanges.size() == 1);
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (strict)
															#line 2643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_EQ(blobRanges[0].begin, range.begin);
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_EQ(blobRanges[0].end, range.end);
															#line 2649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
			else
			{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_LE(blobRanges[0].begin, range.begin);
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_GE(blobRanges[0].end, range.end);
															#line 2657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
		}
		else
		{
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			ASSERT(blobRanges.empty());
															#line 2664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		tr = Transaction(cx, self->tenant);
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		;
															#line 2670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<KeyRangeRef>> const& blobRanges,int loopDepth) 
	{
		loopDepth = a_body1cont2(blobRanges, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<KeyRangeRef>> && blobRanges,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(blobRanges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckRangeActor*>(this)->actor_wait_state > 0) static_cast<CheckRangeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRangeActor*>(this)->ActorCallback< CheckRangeActor, 2, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRangeActor, 2, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckRangeActor, 2, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckRangeActor, 2, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<CheckRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckRangeActorState(); static_cast<CheckRangeActor*>(this)->destroy(); return 0; }
															#line 2754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<CheckRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckRangeActorState();
		static_cast<CheckRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_3 = tr.getBlobGranuleRanges(range, 1000000);
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<CheckRangeActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckRangeActor*>(this)->actor_wait_state = 4;
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckRangeActor, 3, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<CheckRangeActor*>(this)));
															#line 2781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<CheckRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CheckRangeActor*>(this)->actor_wait_state = 5;
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckRangeActor, 4, Void >*>(static_cast<CheckRangeActor*>(this)));
															#line 2823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> const& granules,int loopDepth) 
	{
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (isActive)
															#line 2838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			ASSERT(granules.size() >= 1);
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (strict)
															#line 2844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_EQ(granules.front().begin, range.begin);
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_EQ(granules.back().end, range.end);
															#line 2850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
			else
			{
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_LE(granules.front().begin, range.begin);
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_GE(granules.back().end, range.end);
															#line 2858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			for(int i = 0;i < granules.size() - 1;i++) {
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT(granules[i].end == granules[i + 1].begin);
															#line 2864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
		}
		else
		{
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (BGRW_DEBUG)
															#line 2871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				fmt::print("Granules for [{0} - {1}) not empty! ({2}):\n", range.begin.printable(), range.end.printable(), granules.size());
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				for( auto& it : granules ) {
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					fmt::print("  [{0} - {1})\n", it.begin.printable(), it.end.printable());
															#line 2879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				}
			}
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			ASSERT(granules.empty());
															#line 2884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> && granules,int loopDepth) 
	{
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (isActive)
															#line 2894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			ASSERT(granules.size() >= 1);
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (strict)
															#line 2900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_EQ(granules.front().begin, range.begin);
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_EQ(granules.back().end, range.end);
															#line 2906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
			else
			{
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_LE(granules.front().begin, range.begin);
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT_GE(granules.back().end, range.end);
															#line 2914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			for(int i = 0;i < granules.size() - 1;i++) {
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				ASSERT(granules[i].end == granules[i + 1].begin);
															#line 2920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
		}
		else
		{
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (BGRW_DEBUG)
															#line 2927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				fmt::print("Granules for [{0} - {1}) not empty! ({2}):\n", range.begin.printable(), range.end.printable(), granules.size());
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				for( auto& it : granules ) {
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					fmt::print("  [{0} - {1})\n", it.begin.printable(), it.end.printable());
															#line 2935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				}
			}
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			ASSERT(granules.empty());
															#line 2940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Standalone<VectorRef<KeyRangeRef>> const& granules,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(granules, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Standalone<VectorRef<KeyRangeRef>> && granules,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(granules), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckRangeActor*>(this)->actor_wait_state > 0) static_cast<CheckRangeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRangeActor*>(this)->ActorCallback< CheckRangeActor, 3, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRangeActor, 3, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckRangeActor, 3, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckRangeActor, 3, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckRangeActor*>(this)->actor_wait_state > 0) static_cast<CheckRangeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRangeActor*>(this)->ActorCallback< CheckRangeActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRangeActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckRangeActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckRangeActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	bool isActive;
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	bool strict;
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Transaction tr;
															#line 3120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via checkRange()
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class CheckRangeActor final : public Actor<Void>, public ActorCallback< CheckRangeActor, 0, bool >, public ActorCallback< CheckRangeActor, 1, Void >, public ActorCallback< CheckRangeActor, 2, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< CheckRangeActor, 3, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< CheckRangeActor, 4, Void >, public FastAllocated<CheckRangeActor>, public CheckRangeActorState<CheckRangeActor> {
															#line 3125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<CheckRangeActor>::operator new;
	using FastAllocated<CheckRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1327231785486820864UL, 16163096601019742464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckRangeActor, 0, bool >;
friend struct ActorCallback< CheckRangeActor, 1, Void >;
friend struct ActorCallback< CheckRangeActor, 2, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< CheckRangeActor, 3, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< CheckRangeActor, 4, Void >;
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	CheckRangeActor(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range,bool const& isActive,bool const& strict) 
															#line 3146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   CheckRangeActorState<CheckRangeActor>(cx, self, range, isActive, strict),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11880946910912398592UL, 16005037127868762624UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckRangeActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckRangeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckRangeActor, 2, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckRangeActor, 3, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckRangeActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> checkRange( Database const& cx, BlobGranuleRangesWorkload* const& self, KeyRange const& range, bool const& isActive, bool const& strict ) {
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new CheckRangeActor(cx, self, range, isActive, strict));
															#line 3182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 316 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 3187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class _checkActor>
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class _checkActorState {
															#line 3193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	_checkActorState(Database const& cx,BlobGranuleRangesWorkload* const& self) 
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self)
															#line 3202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 3217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				cx->internal = IsInternal::False;
															#line 3221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			TraceEvent("BlobGranuleRangesCheck") .detail("ActiveRanges", self->activeRanges.size()) .detail("InactiveRanges", self->inactiveRanges.size()) .log();
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (BGRW_DEBUG)
															#line 3227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				fmt::print("Checking {0} active and {1} inactive ranges\n", self->activeRanges.size(), self->inactiveRanges.size());
															#line 3231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			checks = std::vector<Future<Void>>();
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			for(int i = 0;i < self->activeRanges.size();i++) {
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				checks.push_back(self->checkRange(cx, self, self->activeRanges[i], true, true));
															#line 3239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(checks);
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 3250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->unitClient;
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 3280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->unitClient;
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 3296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		TraceEvent("BlobGranuleRangesCheckComplete");
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 3382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		TraceEvent("BlobGranuleRangesCheckComplete");
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 3396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	std::vector<Future<Void>> checks;
															#line 3485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public ActorCallback< _checkActor, 1, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 3490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12094457575751011072UL, 2418548333247258880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
friend struct ActorCallback< _checkActor, 1, Void >;
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	_checkActor(Database const& cx,BlobGranuleRangesWorkload* const& self) 
															#line 3508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<bool> _check( Database const& cx, BlobGranuleRangesWorkload* const& self ) {
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 3541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 3548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via blobGranuleRangesClient()
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class BlobGranuleRangesClientActor>
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class BlobGranuleRangesClientActorState {
															#line 3554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesClientActorState(Database const& cx,BlobGranuleRangesWorkload* const& self) 
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self)
															#line 3563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this));

	}
	~BlobGranuleRangesClientActorState() 
	{
		fdb_probe_actor_destroy("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 3578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				cx->internal = IsInternal::False;
															#line 3582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			last = now();
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			;
															#line 3588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobGranuleRangesClientActorState();
		static_cast<BlobGranuleRangesClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		waitNextOp = poisson(&last, 1.0 / self->operationsPerSecond);
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (self->activeRanges.empty() || deterministicRandom()->coinflip())
															#line 3620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->registerNewRange(cx, self, {});
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<BlobGranuleRangesClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BlobGranuleRangesClientActor*>(this)->actor_wait_state = 1;
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobGranuleRangesClientActor, 0, Void >*>(static_cast<BlobGranuleRangesClientActor*>(this)));
															#line 3631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->unregisterRandomRange(cx, self);
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<BlobGranuleRangesClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<BlobGranuleRangesClientActor*>(this)->actor_wait_state = 2;
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobGranuleRangesClientActor, 1, Void >*>(static_cast<BlobGranuleRangesClientActor*>(this)));
															#line 3645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitNextOp;
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobGranuleRangesClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<BlobGranuleRangesClientActor*>(this)->actor_wait_state = 3;
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobGranuleRangesClientActor, 2, Void >*>(static_cast<BlobGranuleRangesClientActor*>(this)));
															#line 3662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobGranuleRangesClientActor*>(this)->actor_wait_state > 0) static_cast<BlobGranuleRangesClientActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranuleRangesClientActor*>(this)->ActorCallback< BlobGranuleRangesClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobGranuleRangesClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BlobGranuleRangesClientActor*>(this)->actor_wait_state > 0) static_cast<BlobGranuleRangesClientActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranuleRangesClientActor*>(this)->ActorCallback< BlobGranuleRangesClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BlobGranuleRangesClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BlobGranuleRangesClientActor*>(this)->actor_wait_state > 0) static_cast<BlobGranuleRangesClientActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranuleRangesClientActor*>(this)->ActorCallback< BlobGranuleRangesClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BlobGranuleRangesClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	double last;
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Future<Void> waitNextOp;
															#line 3936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via blobGranuleRangesClient()
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class BlobGranuleRangesClientActor final : public Actor<Void>, public ActorCallback< BlobGranuleRangesClientActor, 0, Void >, public ActorCallback< BlobGranuleRangesClientActor, 1, Void >, public ActorCallback< BlobGranuleRangesClientActor, 2, Void >, public FastAllocated<BlobGranuleRangesClientActor>, public BlobGranuleRangesClientActorState<BlobGranuleRangesClientActor> {
															#line 3941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<BlobGranuleRangesClientActor>::operator new;
	using FastAllocated<BlobGranuleRangesClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12711689537731117568UL, 16485479439978332416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobGranuleRangesClientActor, 0, Void >;
friend struct ActorCallback< BlobGranuleRangesClientActor, 1, Void >;
friend struct ActorCallback< BlobGranuleRangesClientActor, 2, Void >;
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesClientActor(Database const& cx,BlobGranuleRangesWorkload* const& self) 
															#line 3960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   BlobGranuleRangesClientActorState<BlobGranuleRangesClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3394608165600730368UL, 640437608970440704UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("blobGranuleRangesClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("blobGranuleRangesClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobGranuleRangesClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BlobGranuleRangesClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BlobGranuleRangesClientActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> blobGranuleRangesClient( Database const& cx, BlobGranuleRangesWorkload* const& self ) {
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new BlobGranuleRangesClientActor(cx, self));
															#line 3994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 3999 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via tearDownRangeAfterUnit()
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class TearDownRangeAfterUnitActor>
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class TearDownRangeAfterUnitActorState {
															#line 4005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	TearDownRangeAfterUnitActorState(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self),
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   range(range)
															#line 4016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this));

	}
	~TearDownRangeAfterUnitActorState() 
	{
		fdb_probe_actor_destroy("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (BGRW_DEBUG)
															#line 4031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				fmt::print("Tearing down [{0} - {1}) after unit!\n", range.begin.printable(), range.end.printable());
															#line 4035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Key> __when_expr_0 = self->versionedForcePurge(cx, range, self->tenant);
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state = 1;
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TearDownRangeAfterUnitActor, 0, Key >*>(static_cast<TearDownRangeAfterUnitActor*>(this)));
															#line 4046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TearDownRangeAfterUnitActorState();
		static_cast<TearDownRangeAfterUnitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& purgeKey,int loopDepth) 
	{
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state = 2;
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TearDownRangeAfterUnitActor, 1, Void >*>(static_cast<TearDownRangeAfterUnitActor*>(this)));
															#line 4076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key && purgeKey,int loopDepth) 
	{
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state = 2;
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TearDownRangeAfterUnitActor, 1, Void >*>(static_cast<TearDownRangeAfterUnitActor*>(this)));
															#line 4092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state > 0) static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state = 0;
		static_cast<TearDownRangeAfterUnitActor*>(this)->ActorCallback< TearDownRangeAfterUnitActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< TearDownRangeAfterUnitActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TearDownRangeAfterUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TearDownRangeAfterUnitActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TearDownRangeAfterUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TearDownRangeAfterUnitActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TearDownRangeAfterUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_2 = cx->unblobbifyRange(range, self->tenant);
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state = 3;
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TearDownRangeAfterUnitActor, 2, bool >*>(static_cast<TearDownRangeAfterUnitActor*>(this)));
															#line 4183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_2 = cx->unblobbifyRange(range, self->tenant);
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state = 3;
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TearDownRangeAfterUnitActor, 2, bool >*>(static_cast<TearDownRangeAfterUnitActor*>(this)));
															#line 4199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state > 0) static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state = 0;
		static_cast<TearDownRangeAfterUnitActor*>(this)->ActorCallback< TearDownRangeAfterUnitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TearDownRangeAfterUnitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TearDownRangeAfterUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TearDownRangeAfterUnitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TearDownRangeAfterUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TearDownRangeAfterUnitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TearDownRangeAfterUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(bool const& success,int loopDepth) 
	{
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(success);
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (BGRW_DEBUG)
															#line 4285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			fmt::print("Range [{0} - {1}) torn down.\n", range.begin.printable(), range.end.printable());
															#line 4289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<TearDownRangeAfterUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TearDownRangeAfterUnitActorState(); static_cast<TearDownRangeAfterUnitActor*>(this)->destroy(); return 0; }
															#line 4293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<TearDownRangeAfterUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TearDownRangeAfterUnitActorState();
		static_cast<TearDownRangeAfterUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(bool && success,int loopDepth) 
	{
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(success);
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (BGRW_DEBUG)
															#line 4307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			fmt::print("Range [{0} - {1}) torn down.\n", range.begin.printable(), range.end.printable());
															#line 4311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<TearDownRangeAfterUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TearDownRangeAfterUnitActorState(); static_cast<TearDownRangeAfterUnitActor*>(this)->destroy(); return 0; }
															#line 4315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<TearDownRangeAfterUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TearDownRangeAfterUnitActorState();
		static_cast<TearDownRangeAfterUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont4(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state > 0) static_cast<TearDownRangeAfterUnitActor*>(this)->actor_wait_state = 0;
		static_cast<TearDownRangeAfterUnitActor*>(this)->ActorCallback< TearDownRangeAfterUnitActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< TearDownRangeAfterUnitActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TearDownRangeAfterUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TearDownRangeAfterUnitActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TearDownRangeAfterUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TearDownRangeAfterUnitActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TearDownRangeAfterUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 4404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via tearDownRangeAfterUnit()
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class TearDownRangeAfterUnitActor final : public Actor<Void>, public ActorCallback< TearDownRangeAfterUnitActor, 0, Key >, public ActorCallback< TearDownRangeAfterUnitActor, 1, Void >, public ActorCallback< TearDownRangeAfterUnitActor, 2, bool >, public FastAllocated<TearDownRangeAfterUnitActor>, public TearDownRangeAfterUnitActorState<TearDownRangeAfterUnitActor> {
															#line 4409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<TearDownRangeAfterUnitActor>::operator new;
	using FastAllocated<TearDownRangeAfterUnitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8839205347321540096UL, 14504080545226467840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TearDownRangeAfterUnitActor, 0, Key >;
friend struct ActorCallback< TearDownRangeAfterUnitActor, 1, Void >;
friend struct ActorCallback< TearDownRangeAfterUnitActor, 2, bool >;
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	TearDownRangeAfterUnitActor(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 4428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   TearDownRangeAfterUnitActorState<TearDownRangeAfterUnitActor>(cx, self, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13784007363392416000UL, 7578917304078757376UL);
		ActorExecutionContextHelper __helper(static_cast<TearDownRangeAfterUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tearDownRangeAfterUnit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tearDownRangeAfterUnit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TearDownRangeAfterUnitActor, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TearDownRangeAfterUnitActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TearDownRangeAfterUnitActor, 2, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> tearDownRangeAfterUnit( Database const& cx, BlobGranuleRangesWorkload* const& self, KeyRange const& range ) {
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new TearDownRangeAfterUnitActor(cx, self, range));
															#line 4462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 4467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via verifyRangeUnit()
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class VerifyRangeUnitActor>
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class VerifyRangeUnitActorState {
															#line 4473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	VerifyRangeUnitActorState(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self),
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   range(range),
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   activeRange(KeyRangeRef(range.begin.withSuffix("A"_sr), range.begin.withSuffix("B"_sr))),
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   middleKey(range.begin.withSuffix("AF"_sr))
															#line 4488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("verifyRangeUnit", reinterpret_cast<unsigned long>(this));

	}
	~VerifyRangeUnitActorState() 
	{
		fdb_probe_actor_destroy("verifyRangeUnit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (BGRW_DEBUG)
															#line 4503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				fmt::print("VerifyRangeUnit: [{0} - {1})\n", range.begin.printable(), range.end.printable());
															#line 4507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_0 = cx->blobbifyRange(activeRange, self->tenant);
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 1;
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 0, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 4518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VerifyRangeUnitActorState();
		static_cast<VerifyRangeUnitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& setSuccess,int loopDepth) 
	{
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->checkRange(cx, self, activeRange, true, true);
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 2;
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 1, Void >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 4550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool && setSuccess,int loopDepth) 
	{
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->checkRange(cx, self, activeRange, true, true);
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 2;
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 1, Void >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 4568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& setSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont1(setSuccess, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && setSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(setSuccess), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeUnitActor*>(this)->ActorCallback< VerifyRangeUnitActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VerifyRangeUnitActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_2 = self->isRangeActive(cx, KeyRangeRef(activeRange.begin, middleKey), self->tenant);
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 3;
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 2, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 4659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_2 = self->isRangeActive(cx, KeyRangeRef(activeRange.begin, middleKey), self->tenant);
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 3;
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 2, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 4675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeUnitActor*>(this)->ActorCallback< VerifyRangeUnitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VerifyRangeUnitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(bool const& success1,int loopDepth) 
	{
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(success1);
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_3 = self->isRangeActive(cx, KeyRangeRef(middleKey, activeRange.end), self->tenant);
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 4;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 3, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 4768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(bool && success1,int loopDepth) 
	{
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(success1);
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_3 = self->isRangeActive(cx, KeyRangeRef(middleKey, activeRange.end), self->tenant);
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 4;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 3, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 4786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(bool const& success1,int loopDepth) 
	{
		loopDepth = a_body1cont4(success1, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(bool && success1,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(success1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeUnitActor*>(this)->ActorCallback< VerifyRangeUnitActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< VerifyRangeUnitActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(bool const& success2,int loopDepth) 
	{
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(success2);
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_4 = self->isRangeActive(cx, range, self->tenant);
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 5;
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 4, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 4879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(bool && success2,int loopDepth) 
	{
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(success2);
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_4 = self->isRangeActive(cx, range, self->tenant);
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 5;
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 4, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 4897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(bool const& success2,int loopDepth) 
	{
		loopDepth = a_body1cont5(success2, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(bool && success2,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(success2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeUnitActor*>(this)->ActorCallback< VerifyRangeUnitActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< VerifyRangeUnitActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(bool const& fail1,int loopDepth) 
	{
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail1);
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_5 = self->isRangeActive(cx, KeyRangeRef(range.begin, activeRange.begin), self->tenant);
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 6;
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 5, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 4990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(bool && fail1,int loopDepth) 
	{
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail1);
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_5 = self->isRangeActive(cx, KeyRangeRef(range.begin, activeRange.begin), self->tenant);
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 6;
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 5, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 5008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(bool const& fail1,int loopDepth) 
	{
		loopDepth = a_body1cont6(fail1, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(bool && fail1,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(fail1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeUnitActor*>(this)->ActorCallback< VerifyRangeUnitActor, 4, bool >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 4, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 4, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< VerifyRangeUnitActor, 4, bool >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(bool const& fail2,int loopDepth) 
	{
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail2);
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_6 = self->isRangeActive(cx, KeyRangeRef(activeRange.end, range.end), self->tenant);
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 7;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 6, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 5101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(bool && fail2,int loopDepth) 
	{
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail2);
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_6 = self->isRangeActive(cx, KeyRangeRef(activeRange.end, range.end), self->tenant);
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 7;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 6, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 5119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(bool const& fail2,int loopDepth) 
	{
		loopDepth = a_body1cont7(fail2, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(bool && fail2,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(fail2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeUnitActor*>(this)->ActorCallback< VerifyRangeUnitActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< VerifyRangeUnitActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(bool const& fail3,int loopDepth) 
	{
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail3);
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_7 = self->isRangeActive(cx, KeyRangeRef(range.begin, middleKey), self->tenant);
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 8;
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 7, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 5212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(bool && fail3,int loopDepth) 
	{
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail3);
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_7 = self->isRangeActive(cx, KeyRangeRef(range.begin, middleKey), self->tenant);
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 8;
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 7, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 5230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(bool const& fail3,int loopDepth) 
	{
		loopDepth = a_body1cont8(fail3, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(bool && fail3,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(fail3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeUnitActor*>(this)->ActorCallback< VerifyRangeUnitActor, 6, bool >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 6, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 6, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< VerifyRangeUnitActor, 6, bool >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont9(bool const& fail4,int loopDepth) 
	{
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail4);
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_8 = self->isRangeActive(cx, KeyRangeRef(middleKey, range.end), self->tenant);
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 9;
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 8, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 5323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(bool && fail4,int loopDepth) 
	{
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail4);
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_8 = self->isRangeActive(cx, KeyRangeRef(middleKey, range.end), self->tenant);
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 9;
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 8, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 5341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(bool const& fail4,int loopDepth) 
	{
		loopDepth = a_body1cont9(fail4, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(bool && fail4,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(fail4), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeUnitActor*>(this)->ActorCallback< VerifyRangeUnitActor, 7, bool >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 7, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 7, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< VerifyRangeUnitActor, 7, bool >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10(bool const& fail5,int loopDepth) 
	{
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail5);
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_9 = self->isRangeActive(cx, KeyRangeRef(range.begin, activeRange.end), self->tenant);
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when1(__when_expr_9.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 10;
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 9, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 5434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(bool && fail5,int loopDepth) 
	{
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail5);
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_9 = self->isRangeActive(cx, KeyRangeRef(range.begin, activeRange.end), self->tenant);
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when1(__when_expr_9.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 10;
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 9, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 5452 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(bool const& fail5,int loopDepth) 
	{
		loopDepth = a_body1cont10(fail5, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(bool && fail5,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(fail5), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeUnitActor*>(this)->ActorCallback< VerifyRangeUnitActor, 8, bool >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 8, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 8, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< VerifyRangeUnitActor, 8, bool >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont1(bool const& fail6,int loopDepth) 
	{
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail6);
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_10 = self->isRangeActive(cx, KeyRangeRef(activeRange.begin, range.end), self->tenant);
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 11;
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 10, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 5545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(bool && fail6,int loopDepth) 
	{
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail6);
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_10 = self->isRangeActive(cx, KeyRangeRef(activeRange.begin, range.end), self->tenant);
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5558 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 11;
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 10, bool >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 5563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(bool const& fail6,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(fail6, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(bool && fail6,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(fail6), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeUnitActor*>(this)->ActorCallback< VerifyRangeUnitActor, 9, bool >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 9, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 9, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< VerifyRangeUnitActor, 9, bool >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont2(bool const& fail7,int loopDepth) 
	{
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail7);
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_11 = self->tearDownRangeAfterUnit(cx, self, activeRange);
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_11.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 12;
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 11, Void >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 5656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2(bool && fail7,int loopDepth) 
	{
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail7);
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_11 = self->tearDownRangeAfterUnit(cx, self, activeRange);
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5669 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_11.get(), loopDepth); };
		static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 12;
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeUnitActor, 11, Void >*>(static_cast<VerifyRangeUnitActor*>(this)));
															#line 5674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(bool const& fail7,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(fail7, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(bool && fail7,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(fail7), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeUnitActor*>(this)->ActorCallback< VerifyRangeUnitActor, 10, bool >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 10, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 10, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< VerifyRangeUnitActor, 10, bool >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10cont3(Void const& _,int loopDepth) 
	{
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<VerifyRangeUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~VerifyRangeUnitActorState(); static_cast<VerifyRangeUnitActor*>(this)->destroy(); return 0; }
															#line 5758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<VerifyRangeUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~VerifyRangeUnitActorState();
		static_cast<VerifyRangeUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont3(Void && _,int loopDepth) 
	{
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<VerifyRangeUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~VerifyRangeUnitActorState(); static_cast<VerifyRangeUnitActor*>(this)->destroy(); return 0; }
															#line 5770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<VerifyRangeUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~VerifyRangeUnitActorState();
		static_cast<VerifyRangeUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeUnitActor*>(this)->ActorCallback< VerifyRangeUnitActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< VerifyRangeUnitActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< VerifyRangeUnitActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange activeRange;
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Key middleKey;
															#line 5863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via verifyRangeUnit()
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class VerifyRangeUnitActor final : public Actor<Void>, public ActorCallback< VerifyRangeUnitActor, 0, bool >, public ActorCallback< VerifyRangeUnitActor, 1, Void >, public ActorCallback< VerifyRangeUnitActor, 2, bool >, public ActorCallback< VerifyRangeUnitActor, 3, bool >, public ActorCallback< VerifyRangeUnitActor, 4, bool >, public ActorCallback< VerifyRangeUnitActor, 5, bool >, public ActorCallback< VerifyRangeUnitActor, 6, bool >, public ActorCallback< VerifyRangeUnitActor, 7, bool >, public ActorCallback< VerifyRangeUnitActor, 8, bool >, public ActorCallback< VerifyRangeUnitActor, 9, bool >, public ActorCallback< VerifyRangeUnitActor, 10, bool >, public ActorCallback< VerifyRangeUnitActor, 11, Void >, public FastAllocated<VerifyRangeUnitActor>, public VerifyRangeUnitActorState<VerifyRangeUnitActor> {
															#line 5868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<VerifyRangeUnitActor>::operator new;
	using FastAllocated<VerifyRangeUnitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5734275353057758976UL, 13272537119607979776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VerifyRangeUnitActor, 0, bool >;
friend struct ActorCallback< VerifyRangeUnitActor, 1, Void >;
friend struct ActorCallback< VerifyRangeUnitActor, 2, bool >;
friend struct ActorCallback< VerifyRangeUnitActor, 3, bool >;
friend struct ActorCallback< VerifyRangeUnitActor, 4, bool >;
friend struct ActorCallback< VerifyRangeUnitActor, 5, bool >;
friend struct ActorCallback< VerifyRangeUnitActor, 6, bool >;
friend struct ActorCallback< VerifyRangeUnitActor, 7, bool >;
friend struct ActorCallback< VerifyRangeUnitActor, 8, bool >;
friend struct ActorCallback< VerifyRangeUnitActor, 9, bool >;
friend struct ActorCallback< VerifyRangeUnitActor, 10, bool >;
friend struct ActorCallback< VerifyRangeUnitActor, 11, Void >;
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	VerifyRangeUnitActor(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 5896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   VerifyRangeUnitActorState<VerifyRangeUnitActor>(cx, self, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("verifyRangeUnit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12290104196531427840UL, 13245998394857095168UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("verifyRangeUnit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("verifyRangeUnit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VerifyRangeUnitActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< VerifyRangeUnitActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< VerifyRangeUnitActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< VerifyRangeUnitActor, 3, bool >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< VerifyRangeUnitActor, 4, bool >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< VerifyRangeUnitActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< VerifyRangeUnitActor, 6, bool >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< VerifyRangeUnitActor, 7, bool >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< VerifyRangeUnitActor, 8, bool >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< VerifyRangeUnitActor, 9, bool >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< VerifyRangeUnitActor, 10, bool >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< VerifyRangeUnitActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> verifyRangeUnit( Database const& cx, BlobGranuleRangesWorkload* const& self, KeyRange const& range ) {
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new VerifyRangeUnitActor(cx, self, range));
															#line 5939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 5944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via verifyRangeGapUnit()
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class VerifyRangeGapUnitActor>
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class VerifyRangeGapUnitActorState {
															#line 5950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	VerifyRangeGapUnitActorState(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self),
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   range(range),
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   boundaries()
															#line 5963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this));

	}
	~VerifyRangeGapUnitActorState() 
	{
		fdb_probe_actor_destroy("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			boundaries.push_back(range.begin);
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			rangeCount = deterministicRandom()->randomExp(3, 6) + 1;
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			for(int i = 0;i < rangeCount - 1;i++) {
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				std::string suffix = format("%04x", i);
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				boundaries.push_back(range.begin.withSuffix(suffix));
															#line 5986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			boundaries.push_back(range.end);
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			ASSERT(boundaries.size() - 1 == rangeCount);
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			rangeToNotBlobbify = deterministicRandom()->randomInt(0, rangeCount);
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			i = int();
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			i = 0;
															#line 5998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VerifyRangeGapUnitActorState();
		static_cast<VerifyRangeGapUnitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_3 = self->isRangeActive(cx, range, self->tenant);
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state = 4;
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeGapUnitActor, 3, bool >*>(static_cast<VerifyRangeGapUnitActor*>(this)));
															#line 6028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!(i < rangeCount))
															#line 6044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		subRange = KeyRange(KeyRangeRef(boundaries[i], boundaries[i + 1]));
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (i != rangeToNotBlobbify)
															#line 6052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_0 = cx->blobbifyRange(subRange, self->tenant);
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state = 1;
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeGapUnitActor, 0, bool >*>(static_cast<VerifyRangeGapUnitActor*>(this)));
															#line 6063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->checkRange(cx, self, subRange, false, false);
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_2.get(), loopDepth); };
			static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state = 3;
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeGapUnitActor, 2, Void >*>(static_cast<VerifyRangeGapUnitActor*>(this)));
															#line 6077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		i++;
															#line 6100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(bool const& setSuccess,int loopDepth) 
	{
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->checkRange(cx, self, subRange, true, true);
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state = 2;
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeGapUnitActor, 1, Void >*>(static_cast<VerifyRangeGapUnitActor*>(this)));
															#line 6118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(bool && setSuccess,int loopDepth) 
	{
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->checkRange(cx, self, subRange, true, true);
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state = 2;
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeGapUnitActor, 1, Void >*>(static_cast<VerifyRangeGapUnitActor*>(this)));
															#line 6136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& setSuccess,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(setSuccess, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && setSuccess,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(setSuccess), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeGapUnitActor*>(this)->ActorCallback< VerifyRangeGapUnitActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeGapUnitActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VerifyRangeGapUnitActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VerifyRangeGapUnitActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeGapUnitActor*>(this)->ActorCallback< VerifyRangeGapUnitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeGapUnitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VerifyRangeGapUnitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VerifyRangeGapUnitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeGapUnitActor*>(this)->ActorCallback< VerifyRangeGapUnitActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeGapUnitActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< VerifyRangeGapUnitActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< VerifyRangeGapUnitActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(bool const& success,int loopDepth) 
	{
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!success);
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (rangeToNotBlobbify != 0)
															#line 6396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->tearDownRangeAfterUnit(cx, self, KeyRangeRef(boundaries[0], boundaries[rangeToNotBlobbify]));
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3when1(__when_expr_4.get(), loopDepth); };
			static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state = 5;
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeGapUnitActor, 4, Void >*>(static_cast<VerifyRangeGapUnitActor*>(this)));
															#line 6407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(bool && success,int loopDepth) 
	{
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!success);
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (rangeToNotBlobbify != 0)
															#line 6423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->tearDownRangeAfterUnit(cx, self, KeyRangeRef(boundaries[0], boundaries[rangeToNotBlobbify]));
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3when1(__when_expr_4.get(), loopDepth); };
			static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state = 5;
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeGapUnitActor, 4, Void >*>(static_cast<VerifyRangeGapUnitActor*>(this)));
															#line 6434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont3(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeGapUnitActor*>(this)->ActorCallback< VerifyRangeGapUnitActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeGapUnitActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< VerifyRangeGapUnitActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< VerifyRangeGapUnitActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (rangeToNotBlobbify != rangeCount - 1)
															#line 6523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_5 = self->tearDownRangeAfterUnit( cx, self, KeyRangeRef(boundaries[rangeToNotBlobbify + 1], boundaries.back()));
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont4when1(__when_expr_5.get(), loopDepth); };
			static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state = 6;
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< VerifyRangeGapUnitActor, 5, Void >*>(static_cast<VerifyRangeGapUnitActor*>(this)));
															#line 6534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeGapUnitActor*>(this)->ActorCallback< VerifyRangeGapUnitActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeGapUnitActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< VerifyRangeGapUnitActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< VerifyRangeGapUnitActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<VerifyRangeGapUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~VerifyRangeGapUnitActorState(); static_cast<VerifyRangeGapUnitActor*>(this)->destroy(); return 0; }
															#line 6635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<VerifyRangeGapUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~VerifyRangeGapUnitActorState();
		static_cast<VerifyRangeGapUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state > 0) static_cast<VerifyRangeGapUnitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyRangeGapUnitActor*>(this)->ActorCallback< VerifyRangeGapUnitActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyRangeGapUnitActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< VerifyRangeGapUnitActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< VerifyRangeGapUnitActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	std::vector<Key> boundaries;
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	int rangeCount;
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	int rangeToNotBlobbify;
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	int i;
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange subRange;
															#line 6746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via verifyRangeGapUnit()
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class VerifyRangeGapUnitActor final : public Actor<Void>, public ActorCallback< VerifyRangeGapUnitActor, 0, bool >, public ActorCallback< VerifyRangeGapUnitActor, 1, Void >, public ActorCallback< VerifyRangeGapUnitActor, 2, Void >, public ActorCallback< VerifyRangeGapUnitActor, 3, bool >, public ActorCallback< VerifyRangeGapUnitActor, 4, Void >, public ActorCallback< VerifyRangeGapUnitActor, 5, Void >, public FastAllocated<VerifyRangeGapUnitActor>, public VerifyRangeGapUnitActorState<VerifyRangeGapUnitActor> {
															#line 6751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<VerifyRangeGapUnitActor>::operator new;
	using FastAllocated<VerifyRangeGapUnitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17300821409914275328UL, 17285152133238369024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VerifyRangeGapUnitActor, 0, bool >;
friend struct ActorCallback< VerifyRangeGapUnitActor, 1, Void >;
friend struct ActorCallback< VerifyRangeGapUnitActor, 2, Void >;
friend struct ActorCallback< VerifyRangeGapUnitActor, 3, bool >;
friend struct ActorCallback< VerifyRangeGapUnitActor, 4, Void >;
friend struct ActorCallback< VerifyRangeGapUnitActor, 5, Void >;
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	VerifyRangeGapUnitActor(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 6773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   VerifyRangeGapUnitActorState<VerifyRangeGapUnitActor>(cx, self, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12961164038039710720UL, 9572253876873064704UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyRangeGapUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("verifyRangeGapUnit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("verifyRangeGapUnit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VerifyRangeGapUnitActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< VerifyRangeGapUnitActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< VerifyRangeGapUnitActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< VerifyRangeGapUnitActor, 3, bool >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< VerifyRangeGapUnitActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< VerifyRangeGapUnitActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> verifyRangeGapUnit( Database const& cx, BlobGranuleRangesWorkload* const& self, KeyRange const& range ) {
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new VerifyRangeGapUnitActor(cx, self, range));
															#line 6810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 465 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 6815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via checkRangesMisaligned()
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class CheckRangesMisalignedActor>
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class CheckRangesMisalignedActorState {
															#line 6821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	CheckRangesMisalignedActorState(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& expectedRange,KeyRange const& queryRange) 
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self),
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   expectedRange(expectedRange),
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   queryRange(queryRange)
															#line 6834 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("checkRangesMisaligned", reinterpret_cast<unsigned long>(this));

	}
	~CheckRangesMisalignedActorState() 
	{
		fdb_probe_actor_destroy("checkRangesMisaligned", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_0 = cx->listBlobbifiedRanges(queryRange, 1000000, self->tenant);
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<CheckRangesMisalignedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckRangesMisalignedActor*>(this)->actor_wait_state = 1;
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckRangesMisalignedActor, 0, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<CheckRangesMisalignedActor*>(this)));
															#line 6856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckRangesMisalignedActorState();
		static_cast<CheckRangesMisalignedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<VectorRef<KeyRangeRef>> const& blobRanges,int loopDepth) 
	{
															#line 472 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(blobRanges.size() == 1);
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(blobRanges[0] == expectedRange);
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		tr = Transaction(cx, self->tenant);
															#line 476 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		;
															#line 6885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Standalone<VectorRef<KeyRangeRef>> && blobRanges,int loopDepth) 
	{
															#line 472 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(blobRanges.size() == 1);
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(blobRanges[0] == expectedRange);
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		tr = Transaction(cx, self->tenant);
															#line 476 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		;
															#line 6900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRangeRef>> const& blobRanges,int loopDepth) 
	{
		loopDepth = a_body1cont1(blobRanges, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRangeRef>> && blobRanges,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(blobRanges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckRangesMisalignedActor*>(this)->actor_wait_state > 0) static_cast<CheckRangesMisalignedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRangesMisalignedActor*>(this)->ActorCallback< CheckRangesMisalignedActor, 0, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRangesMisalignedActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangesMisalignedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckRangesMisalignedActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangesMisalignedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckRangesMisalignedActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangesMisalignedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<CheckRangesMisalignedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckRangesMisalignedActorState(); static_cast<CheckRangesMisalignedActor*>(this)->destroy(); return 0; }
															#line 6984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<CheckRangesMisalignedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckRangesMisalignedActorState();
		static_cast<CheckRangesMisalignedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_1 = tr.getBlobGranuleRanges(queryRange, 1000000);
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<CheckRangesMisalignedActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckRangesMisalignedActor*>(this)->actor_wait_state = 2;
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckRangesMisalignedActor, 1, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<CheckRangesMisalignedActor*>(this)));
															#line 7011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<CheckRangesMisalignedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckRangesMisalignedActor*>(this)->actor_wait_state = 3;
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckRangesMisalignedActor, 2, Void >*>(static_cast<CheckRangesMisalignedActor*>(this)));
															#line 7053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> const& granules,int loopDepth) 
	{
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(granules.size() == 1);
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(granules[0] == expectedRange);
															#line 7070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> && granules,int loopDepth) 
	{
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(granules.size() == 1);
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(granules[0] == expectedRange);
															#line 7081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Standalone<VectorRef<KeyRangeRef>> const& granules,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(granules, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Standalone<VectorRef<KeyRangeRef>> && granules,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(granules), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckRangesMisalignedActor*>(this)->actor_wait_state > 0) static_cast<CheckRangesMisalignedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRangesMisalignedActor*>(this)->ActorCallback< CheckRangesMisalignedActor, 1, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRangesMisalignedActor, 1, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangesMisalignedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckRangesMisalignedActor, 1, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangesMisalignedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckRangesMisalignedActor, 1, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangesMisalignedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckRangesMisalignedActor*>(this)->actor_wait_state > 0) static_cast<CheckRangesMisalignedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRangesMisalignedActor*>(this)->ActorCallback< CheckRangesMisalignedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRangesMisalignedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangesMisalignedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckRangesMisalignedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangesMisalignedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckRangesMisalignedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangesMisalignedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange expectedRange;
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange queryRange;
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Transaction tr;
															#line 7258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via checkRangesMisaligned()
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class CheckRangesMisalignedActor final : public Actor<Void>, public ActorCallback< CheckRangesMisalignedActor, 0, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< CheckRangesMisalignedActor, 1, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< CheckRangesMisalignedActor, 2, Void >, public FastAllocated<CheckRangesMisalignedActor>, public CheckRangesMisalignedActorState<CheckRangesMisalignedActor> {
															#line 7263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<CheckRangesMisalignedActor>::operator new;
	using FastAllocated<CheckRangesMisalignedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6268968163470148352UL, 13136899000172102144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckRangesMisalignedActor, 0, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< CheckRangesMisalignedActor, 1, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< CheckRangesMisalignedActor, 2, Void >;
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	CheckRangesMisalignedActor(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& expectedRange,KeyRange const& queryRange) 
															#line 7282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   CheckRangesMisalignedActorState<CheckRangesMisalignedActor>(cx, self, expectedRange, queryRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17730754009316205824UL, 17279012147605755648UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangesMisalignedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkRangesMisaligned");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkRangesMisaligned", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckRangesMisalignedActor, 0, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckRangesMisalignedActor, 1, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckRangesMisalignedActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> checkRangesMisaligned( Database const& cx, BlobGranuleRangesWorkload* const& self, KeyRange const& expectedRange, KeyRange const& queryRange ) {
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new CheckRangesMisalignedActor(cx, self, expectedRange, queryRange));
															#line 7316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 7321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via rangesMisalignedUnit()
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class RangesMisalignedUnitActor>
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class RangesMisalignedUnitActorState {
															#line 7327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	RangesMisalignedUnitActorState(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self),
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   range(range)
															#line 7338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this));

	}
	~RangesMisalignedUnitActorState() 
	{
		fdb_probe_actor_destroy("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_0 = cx->blobbifyRange(range, self->tenant);
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 1;
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 0, bool >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 7360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RangesMisalignedUnitActorState();
		static_cast<RangesMisalignedUnitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& setSuccess,int loopDepth) 
	{
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 493 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		subRange = KeyRange(KeyRangeRef(range.begin.withSuffix("A"_sr), range.begin.withSuffix("B"_sr)));
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->checkRange(cx, self, range, true, true);
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 2;
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 1, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 7394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool && setSuccess,int loopDepth) 
	{
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 493 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		subRange = KeyRange(KeyRangeRef(range.begin.withSuffix("A"_sr), range.begin.withSuffix("B"_sr)));
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->checkRange(cx, self, range, true, true);
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 2;
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 1, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 7414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& setSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont1(setSuccess, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && setSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(setSuccess), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state > 0) static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 0;
		static_cast<RangesMisalignedUnitActor*>(this)->ActorCallback< RangesMisalignedUnitActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RangesMisalignedUnitActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->checkRangesMisaligned(cx, self, range, range);
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 3;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 2, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 7505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->checkRangesMisaligned(cx, self, range, range);
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 3;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 2, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 7521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state > 0) static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 0;
		static_cast<RangesMisalignedUnitActor*>(this)->ActorCallback< RangesMisalignedUnitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RangesMisalignedUnitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->checkRange(cx, self, subRange, true, false);
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 4;
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 3, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 7612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->checkRange(cx, self, subRange, true, false);
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 4;
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 3, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 7628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state > 0) static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 0;
		static_cast<RangesMisalignedUnitActor*>(this)->ActorCallback< RangesMisalignedUnitActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RangesMisalignedUnitActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->checkRangesMisaligned(cx, self, range, subRange);
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 5;
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 4, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 7719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->checkRangesMisaligned(cx, self, range, subRange);
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 5;
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 4, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 7735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state > 0) static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 0;
		static_cast<RangesMisalignedUnitActor*>(this)->ActorCallback< RangesMisalignedUnitActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RangesMisalignedUnitActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->checkRangesMisaligned(cx, self, range, KeyRangeRef(range.begin, subRange.end));
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 6;
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 5, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 7826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->checkRangesMisaligned(cx, self, range, KeyRangeRef(range.begin, subRange.end));
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 6;
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 5, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 7842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state > 0) static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 0;
		static_cast<RangesMisalignedUnitActor*>(this)->ActorCallback< RangesMisalignedUnitActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RangesMisalignedUnitActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->checkRangesMisaligned(cx, self, range, KeyRangeRef(subRange.begin, range.end));
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 7;
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 6, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 7933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->checkRangesMisaligned(cx, self, range, KeyRangeRef(subRange.begin, range.end));
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 7;
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 6, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 7949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state > 0) static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 0;
		static_cast<RangesMisalignedUnitActor*>(this)->ActorCallback< RangesMisalignedUnitActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RangesMisalignedUnitActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		try {
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_7 = success(cx->purgeBlobGranules(subRange, 1, self->tenant, false));
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 8036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont7Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
			static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 8;
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 7, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 8041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		try {
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_7 = success(cx->purgeBlobGranules(subRange, 1, self->tenant, false));
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 8059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont7Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
			static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 8;
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 7, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 8064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state > 0) static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 0;
		static_cast<RangesMisalignedUnitActor*>(this)->ActorCallback< RangesMisalignedUnitActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RangesMisalignedUnitActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_8 = success(cx->purgeBlobGranules(subRange, 1, self->tenant, true));
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 8157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont8Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont8when1(__when_expr_8.get(), loopDepth); };
			static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 9;
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 8, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 8162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont8Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 8178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 510 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 8182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			ASSERT(e.code() == error_code_unsupported_operation);
															#line 8186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(false);
															#line 8201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(false);
															#line 8210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state > 0) static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 0;
		static_cast<RangesMisalignedUnitActor*>(this)->ActorCallback< RangesMisalignedUnitActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RangesMisalignedUnitActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_9 = self->checkRange(cx, self, range, true, true);
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont12when1(__when_expr_9.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 10;
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 9, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 8314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 8324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 520 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 8328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			ASSERT(e.code() == error_code_unsupported_operation);
															#line 8332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(false);
															#line 8347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont13cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(false);
															#line 8356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont13cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state > 0) static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 0;
		static_cast<RangesMisalignedUnitActor*>(this)->ActorCallback< RangesMisalignedUnitActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RangesMisalignedUnitActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont13cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont1(Void const& _,int loopDepth) 
	{
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_10 = self->checkRangesMisaligned(cx, self, range, range);
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 11;
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 10, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 8460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1(Void && _,int loopDepth) 
	{
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_10 = self->checkRangesMisaligned(cx, self, range, range);
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 11;
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 10, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 8476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state > 0) static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 0;
		static_cast<RangesMisalignedUnitActor*>(this)->ActorCallback< RangesMisalignedUnitActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RangesMisalignedUnitActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont12cont2(Void const& _,int loopDepth) 
	{
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_11 = self->tearDownRangeAfterUnit(cx, self, range);
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_11.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 12;
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 11, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 8567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2(Void && _,int loopDepth) 
	{
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_11 = self->tearDownRangeAfterUnit(cx, self, range);
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_11.get(), loopDepth); };
		static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 12;
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RangesMisalignedUnitActor, 11, Void >*>(static_cast<RangesMisalignedUnitActor*>(this)));
															#line 8583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state > 0) static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 0;
		static_cast<RangesMisalignedUnitActor*>(this)->ActorCallback< RangesMisalignedUnitActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< RangesMisalignedUnitActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont12cont3(Void const& _,int loopDepth) 
	{
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<RangesMisalignedUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RangesMisalignedUnitActorState(); static_cast<RangesMisalignedUnitActor*>(this)->destroy(); return 0; }
															#line 8667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<RangesMisalignedUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RangesMisalignedUnitActorState();
		static_cast<RangesMisalignedUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont3(Void && _,int loopDepth) 
	{
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<RangesMisalignedUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RangesMisalignedUnitActorState(); static_cast<RangesMisalignedUnitActor*>(this)->destroy(); return 0; }
															#line 8679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<RangesMisalignedUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RangesMisalignedUnitActorState();
		static_cast<RangesMisalignedUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state > 0) static_cast<RangesMisalignedUnitActor*>(this)->actor_wait_state = 0;
		static_cast<RangesMisalignedUnitActor*>(this)->ActorCallback< RangesMisalignedUnitActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RangesMisalignedUnitActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< RangesMisalignedUnitActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 493 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange subRange;
															#line 8770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via rangesMisalignedUnit()
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class RangesMisalignedUnitActor final : public Actor<Void>, public ActorCallback< RangesMisalignedUnitActor, 0, bool >, public ActorCallback< RangesMisalignedUnitActor, 1, Void >, public ActorCallback< RangesMisalignedUnitActor, 2, Void >, public ActorCallback< RangesMisalignedUnitActor, 3, Void >, public ActorCallback< RangesMisalignedUnitActor, 4, Void >, public ActorCallback< RangesMisalignedUnitActor, 5, Void >, public ActorCallback< RangesMisalignedUnitActor, 6, Void >, public ActorCallback< RangesMisalignedUnitActor, 7, Void >, public ActorCallback< RangesMisalignedUnitActor, 8, Void >, public ActorCallback< RangesMisalignedUnitActor, 9, Void >, public ActorCallback< RangesMisalignedUnitActor, 10, Void >, public ActorCallback< RangesMisalignedUnitActor, 11, Void >, public FastAllocated<RangesMisalignedUnitActor>, public RangesMisalignedUnitActorState<RangesMisalignedUnitActor> {
															#line 8775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<RangesMisalignedUnitActor>::operator new;
	using FastAllocated<RangesMisalignedUnitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9227332702867105536UL, 13619856632171353856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RangesMisalignedUnitActor, 0, bool >;
friend struct ActorCallback< RangesMisalignedUnitActor, 1, Void >;
friend struct ActorCallback< RangesMisalignedUnitActor, 2, Void >;
friend struct ActorCallback< RangesMisalignedUnitActor, 3, Void >;
friend struct ActorCallback< RangesMisalignedUnitActor, 4, Void >;
friend struct ActorCallback< RangesMisalignedUnitActor, 5, Void >;
friend struct ActorCallback< RangesMisalignedUnitActor, 6, Void >;
friend struct ActorCallback< RangesMisalignedUnitActor, 7, Void >;
friend struct ActorCallback< RangesMisalignedUnitActor, 8, Void >;
friend struct ActorCallback< RangesMisalignedUnitActor, 9, Void >;
friend struct ActorCallback< RangesMisalignedUnitActor, 10, Void >;
friend struct ActorCallback< RangesMisalignedUnitActor, 11, Void >;
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	RangesMisalignedUnitActor(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 8803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RangesMisalignedUnitActorState<RangesMisalignedUnitActor>(cx, self, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8797677788671064832UL, 12911925707884684288UL);
		ActorExecutionContextHelper __helper(static_cast<RangesMisalignedUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rangesMisalignedUnit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rangesMisalignedUnit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RangesMisalignedUnitActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RangesMisalignedUnitActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RangesMisalignedUnitActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RangesMisalignedUnitActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RangesMisalignedUnitActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RangesMisalignedUnitActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RangesMisalignedUnitActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< RangesMisalignedUnitActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< RangesMisalignedUnitActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< RangesMisalignedUnitActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< RangesMisalignedUnitActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< RangesMisalignedUnitActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> rangesMisalignedUnit( Database const& cx, BlobGranuleRangesWorkload* const& self, KeyRange const& range ) {
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new RangesMisalignedUnitActor(cx, self, range));
															#line 8846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 532 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 8851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via blobbifyIdempotentUnit()
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class BlobbifyIdempotentUnitActor>
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class BlobbifyIdempotentUnitActorState {
															#line 8857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobbifyIdempotentUnitActorState(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self),
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   range(range),
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   activeRange(KeyRangeRef(range.begin.withSuffix("A"_sr), range.begin.withSuffix("B"_sr))),
															#line 535 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   middleKey(range.begin.withSuffix("AF"_sr)),
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   middleKey2(range.begin.withSuffix("AG"_sr))
															#line 8874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this));

	}
	~BlobbifyIdempotentUnitActorState() 
	{
		fdb_probe_actor_destroy("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (BGRW_DEBUG)
															#line 8889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				fmt::print("IdempotentUnit: [{0} - {1})\n", range.begin.printable(), range.end.printable());
															#line 8893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 8897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				StrictFuture<bool> __when_expr_0 = cx->blobbifyRange(activeRange, self->tenant);
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 1;
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 0, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 8908 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobbifyIdempotentUnitActorState();
		static_cast<BlobbifyIdempotentUnitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_1 = cx->blobbifyRange(activeRange, self->tenant);
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 2;
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 1, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 8943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(bool const& unblobbifyStartSuccess,int loopDepth) 
	{
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unblobbifyStartSuccess);
															#line 8952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(bool && unblobbifyStartSuccess,int loopDepth) 
	{
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unblobbifyStartSuccess);
															#line 8961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool const& unblobbifyStartSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont3(unblobbifyStartSuccess, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && unblobbifyStartSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(unblobbifyStartSuccess), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(bool const& success,int loopDepth) 
	{
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(success);
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->checkRange(cx, self, activeRange, true, true);
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 3;
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 2, Void >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(bool && success,int loopDepth) 
	{
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(success);
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->checkRange(cx, self, activeRange, true, true);
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 3;
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 2, Void >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont5(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_3 = cx->blobbifyRange(activeRange, self->tenant);
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 4;
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 3, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_3 = cx->blobbifyRange(activeRange, self->tenant);
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 4;
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 3, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(bool const& retrySuccess,int loopDepth) 
	{
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(retrySuccess);
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->checkRange(cx, self, activeRange, true, true);
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 5;
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 4, Void >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(bool && retrySuccess,int loopDepth) 
	{
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(retrySuccess);
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->checkRange(cx, self, activeRange, true, true);
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 5;
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 4, Void >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(bool const& retrySuccess,int loopDepth) 
	{
		loopDepth = a_body1cont7(retrySuccess, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(bool && retrySuccess,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(retrySuccess), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_5 = cx->blobbifyRange(range, self->tenant);
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 6;
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 5, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_5 = cx->blobbifyRange(range, self->tenant);
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 6;
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 5, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont9(bool const& fail1,int loopDepth) 
	{
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail1);
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_6 = cx->blobbifyRange(KeyRangeRef(range.begin, activeRange.end), self->tenant);
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 7;
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 6, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(bool && fail1,int loopDepth) 
	{
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail1);
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_6 = cx->blobbifyRange(KeyRangeRef(range.begin, activeRange.end), self->tenant);
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 7;
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 6, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(bool const& fail1,int loopDepth) 
	{
		loopDepth = a_body1cont9(fail1, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(bool && fail1,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(fail1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10(bool const& fail2,int loopDepth) 
	{
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail2);
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_7 = cx->blobbifyRange(KeyRangeRef(activeRange.begin, range.end), self->tenant);
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont10when1(__when_expr_7.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 8;
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 7, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(bool && fail2,int loopDepth) 
	{
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail2);
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_7 = cx->blobbifyRange(KeyRangeRef(activeRange.begin, range.end), self->tenant);
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont10when1(__when_expr_7.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 8;
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 7, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(bool const& fail2,int loopDepth) 
	{
		loopDepth = a_body1cont10(fail2, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(bool && fail2,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(fail2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 6, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 6, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 6, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 6, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10cont1(bool const& fail3,int loopDepth) 
	{
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail3);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_8 = cx->blobbifyRange(KeyRangeRef(range.begin, middleKey), self->tenant);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 9;
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 8, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(bool && fail3,int loopDepth) 
	{
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail3);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_8 = cx->blobbifyRange(KeyRangeRef(range.begin, middleKey), self->tenant);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 9;
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 8, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(bool const& fail3,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(fail3, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(bool && fail3,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(fail3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 7, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 7, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 7, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 7, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont2(bool const& fail4,int loopDepth) 
	{
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail4);
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_9 = cx->blobbifyRange(KeyRangeRef(middleKey, range.end), self->tenant);
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 10;
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 9, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2(bool && fail4,int loopDepth) 
	{
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail4);
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_9 = cx->blobbifyRange(KeyRangeRef(middleKey, range.end), self->tenant);
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 10;
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 9, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(bool const& fail4,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(fail4, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(bool && fail4,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(fail4), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 8, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 8, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 8, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 8, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont3(bool const& fail5,int loopDepth) 
	{
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail5);
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_10 = cx->blobbifyRange(KeyRangeRef(activeRange.begin, middleKey), self->tenant);
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 11;
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 10, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3(bool && fail5,int loopDepth) 
	{
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail5);
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_10 = cx->blobbifyRange(KeyRangeRef(activeRange.begin, middleKey), self->tenant);
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 11;
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 10, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 9952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2when1(bool const& fail5,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(fail5, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(bool && fail5,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(std::move(fail5), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 9, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 9, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 9, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 9, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont4(bool const& fail6,int loopDepth) 
	{
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail6);
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_11 = cx->blobbifyRange(KeyRangeRef(middleKey, activeRange.end), self->tenant);
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_11.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 12;
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 11, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 10045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont4(bool && fail6,int loopDepth) 
	{
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail6);
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_11 = cx->blobbifyRange(KeyRangeRef(middleKey, activeRange.end), self->tenant);
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_11.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 12;
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 11, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 10063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3when1(bool const& fail6,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(fail6, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(bool && fail6,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(std::move(fail6), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 10, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 10, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 10, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 10, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10cont5(bool const& fail7,int loopDepth) 
	{
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail7);
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_12 = cx->blobbifyRange(KeyRangeRef(middleKey, middleKey2), self->tenant);
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_12.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 13;
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 12, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 10156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont5(bool && fail7,int loopDepth) 
	{
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail7);
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_12 = cx->blobbifyRange(KeyRangeRef(middleKey, middleKey2), self->tenant);
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_12.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 13;
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 12, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 10174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont4when1(bool const& fail7,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(fail7, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(bool && fail7,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(fail7), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 11, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 11, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 11, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 11, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10cont6(bool const& fail8,int loopDepth) 
	{
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail8);
															#line 10258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_13 = cx->listBlobbifiedRanges(range, 1000000, self->tenant);
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont10cont6when1(__when_expr_13.get(), loopDepth); };
			static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 14;
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 13, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 10269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont6(bool && fail8,int loopDepth) 
	{
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!fail8);
															#line 10279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_13 = cx->listBlobbifiedRanges(range, 1000000, self->tenant);
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont10cont6when1(__when_expr_13.get(), loopDepth); };
			static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 14;
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 13, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 10290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont5when1(bool const& fail8,int loopDepth) 
	{
		loopDepth = a_body1cont10cont6(fail8, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5when1(bool && fail8,int loopDepth) 
	{
		loopDepth = a_body1cont10cont6(std::move(fail8), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 12, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 12, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 12, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 12, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10cont7(int loopDepth) 
	{
		{
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_20 = cx->listBlobbifiedRanges(range, 1000000, self->tenant);
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont10cont7when1(__when_expr_20.get(), loopDepth); };
			static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 21;
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 20, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 10383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont8(Standalone<VectorRef<KeyRangeRef>> const& blobRanges,int loopDepth) 
	{
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(blobRanges.size() == 1);
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(blobRanges[0] == activeRange);
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		tr = Transaction(cx, self->tenant);
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		;
															#line 10399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont10cont8loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont8(Standalone<VectorRef<KeyRangeRef>> && blobRanges,int loopDepth) 
	{
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(blobRanges.size() == 1);
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(blobRanges[0] == activeRange);
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		tr = Transaction(cx, self->tenant);
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		;
															#line 10414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont10cont8loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont6when1(Standalone<VectorRef<KeyRangeRef>> const& blobRanges,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(blobRanges, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont6when1(Standalone<VectorRef<KeyRangeRef>> && blobRanges,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(std::move(blobRanges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 13, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 13, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 13, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 13, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont10cont9(int loopDepth) 
	{
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		purgeVersion = deterministicRandom()->coinflip() ? latestVersion : 1;
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		purgeRange = deterministicRandom()->coinflip() ? activeRange : range;
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Key> __when_expr_16 = cx->purgeBlobGranules(purgeRange, purgeVersion, self->tenant, true);
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont9when1(__when_expr_16.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 17;
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 16, Key >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 10509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont8loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont8loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont8loopBody1(int loopDepth) 
	{
		try {
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_14 = tr.getBlobGranuleRanges(range, 1000000);
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1cont10cont8loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont10cont8loopBody1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont8loopBody1when1(__when_expr_14.get(), loopDepth); };
			static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 15;
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 14, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 10533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont10cont8loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10cont8loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont8break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont8loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont10cont8loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont8loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_15 = tr.onError(e);
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont8loopBody1Catch1when1(__when_expr_15.get(), loopDepth); };
			static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 16;
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 15, Void >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 10575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont10cont8loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> const& granules,int loopDepth) 
	{
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(granules.size() == 1);
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(granules[0] == activeRange);
															#line 10592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		return a_body1cont10cont8break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont10cont8loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> && granules,int loopDepth) 
	{
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(granules.size() == 1);
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(granules[0] == activeRange);
															#line 10603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		return a_body1cont10cont8break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont10cont8loopBody1when1(Standalone<VectorRef<KeyRangeRef>> const& granules,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8loopBody1cont2(granules, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont8loopBody1when1(Standalone<VectorRef<KeyRangeRef>> && granules,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8loopBody1cont2(std::move(granules), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 14, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 14, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont8loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 14, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont8loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 14, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont8loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont10cont8loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont8loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont8loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont8loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont8loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont8loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont10cont10(Key const& purgeKey,int loopDepth) 
	{
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_17 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont10cont10when1(__when_expr_17.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 18;
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 17, Void >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 10781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont10(Key && purgeKey,int loopDepth) 
	{
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_17 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont10cont10when1(__when_expr_17.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 18;
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 17, Void >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 10797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont9when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont9when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 16, Key >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 16, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 16, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 16, Key >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont10cont10cont1(Void const& _,int loopDepth) 
	{
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 10881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Key> __when_expr_18 = cx->purgeBlobGranules(purgeRange, purgeVersion, self->tenant, true);
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont10cont10cont1when1(__when_expr_18.get(), loopDepth); };
			static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 19;
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 18, Key >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 10892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont10cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont1(Void && _,int loopDepth) 
	{
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 10906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Key> __when_expr_18 = cx->purgeBlobGranules(purgeRange, purgeVersion, self->tenant, true);
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont10cont10cont1when1(__when_expr_18.get(), loopDepth); };
			static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 19;
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 18, Key >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 10917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont10cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont10cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont10cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont10cont10cont2(int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont3(Key const& purgeKeyAgain,int loopDepth) 
	{
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_19 = cx->waitPurgeGranulesComplete(purgeKeyAgain);
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont10cont10cont3when1(__when_expr_19.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 20;
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 19, Void >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont10cont3(Key && purgeKeyAgain,int loopDepth) 
	{
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_19 = cx->waitPurgeGranulesComplete(purgeKeyAgain);
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont10cont10cont3when1(__when_expr_19.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 20;
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 19, Void >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont10cont1when1(Key const& purgeKeyAgain,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont3(purgeKeyAgain, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont1when1(Key && purgeKeyAgain,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont3(std::move(purgeKeyAgain), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 18, Key >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 18, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont10cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 18, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont10cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 18, Key >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont10cont10cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 19, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 19, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont10cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 19, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont10cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 19, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont10cont11(int loopDepth) 
	{
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<BlobbifyIdempotentUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobbifyIdempotentUnitActorState(); static_cast<BlobbifyIdempotentUnitActor*>(this)->destroy(); return 0; }
															#line 11206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<BlobbifyIdempotentUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BlobbifyIdempotentUnitActorState();
		static_cast<BlobbifyIdempotentUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont12(Standalone<VectorRef<KeyRangeRef>> const& blobRanges,int loopDepth) 
	{
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(blobRanges.size() == 1);
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(blobRanges[0] == activeRange);
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_21 = cx->unblobbifyRange(KeyRangeRef(activeRange.begin, middleKey), self->tenant);
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1Catch1(__when_expr_21.getError(), loopDepth); else return a_body1cont10cont12when1(__when_expr_21.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 22;
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 21, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12(Standalone<VectorRef<KeyRangeRef>> && blobRanges,int loopDepth) 
	{
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(blobRanges.size() == 1);
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(blobRanges[0] == activeRange);
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_21 = cx->unblobbifyRange(KeyRangeRef(activeRange.begin, middleKey), self->tenant);
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1Catch1(__when_expr_21.getError(), loopDepth); else return a_body1cont10cont12when1(__when_expr_21.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 22;
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 21, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont7when1(Standalone<VectorRef<KeyRangeRef>> const& blobRanges,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12(blobRanges, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7when1(Standalone<VectorRef<KeyRangeRef>> && blobRanges,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12(std::move(blobRanges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 20, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 20, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont10cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 20, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont10cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 20, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont10cont12cont1(bool const& unblobbifyFail1,int loopDepth) 
	{
															#line 621 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!unblobbifyFail1);
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_22 = cx->unblobbifyRange(KeyRangeRef(middleKey, activeRange.end), self->tenant);
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont10cont12cont1when1(__when_expr_22.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 23;
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 22, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont1(bool && unblobbifyFail1,int loopDepth) 
	{
															#line 621 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!unblobbifyFail1);
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_22 = cx->unblobbifyRange(KeyRangeRef(middleKey, activeRange.end), self->tenant);
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont10cont12cont1when1(__when_expr_22.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 23;
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 22, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12when1(bool const& unblobbifyFail1,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont1(unblobbifyFail1, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12when1(bool && unblobbifyFail1,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont1(std::move(unblobbifyFail1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose22() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 21, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 21, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont10cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 21, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont10cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 21, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 21);

	}
	int a_body1cont10cont12cont2(bool const& unblobbifyFail2,int loopDepth) 
	{
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!unblobbifyFail2);
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_23 = cx->unblobbifyRange(KeyRangeRef(activeRange.begin, middleKey), self->tenant);
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1Catch1(__when_expr_23.getError(), loopDepth); else return a_body1cont10cont12cont2when1(__when_expr_23.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 24;
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 23, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont2(bool && unblobbifyFail2,int loopDepth) 
	{
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!unblobbifyFail2);
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_23 = cx->unblobbifyRange(KeyRangeRef(activeRange.begin, middleKey), self->tenant);
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1Catch1(__when_expr_23.getError(), loopDepth); else return a_body1cont10cont12cont2when1(__when_expr_23.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 24;
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 23, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont1when1(bool const& unblobbifyFail2,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont2(unblobbifyFail2, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont1when1(bool && unblobbifyFail2,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont2(std::move(unblobbifyFail2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose23() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 22, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 22, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont10cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 22, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont10cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 22, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 22);

	}
	int a_body1cont10cont12cont3(bool const& unblobbifyFail3,int loopDepth) 
	{
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!unblobbifyFail3);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_24 = cx->unblobbifyRange(KeyRangeRef(middleKey, activeRange.end), self->tenant);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1Catch1(__when_expr_24.getError(), loopDepth); else return a_body1cont10cont12cont3when1(__when_expr_24.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 25;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 24, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont3(bool && unblobbifyFail3,int loopDepth) 
	{
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!unblobbifyFail3);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_24 = cx->unblobbifyRange(KeyRangeRef(middleKey, activeRange.end), self->tenant);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1Catch1(__when_expr_24.getError(), loopDepth); else return a_body1cont10cont12cont3when1(__when_expr_24.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 25;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 24, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont2when1(bool const& unblobbifyFail3,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont3(unblobbifyFail3, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont2when1(bool && unblobbifyFail3,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont3(std::move(unblobbifyFail3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose24() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 23, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 23, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont10cont12cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 23, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont10cont12cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 23, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 23);

	}
	int a_body1cont10cont12cont4(bool const& unblobbifyFail4,int loopDepth) 
	{
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!unblobbifyFail4);
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_25 = cx->unblobbifyRange(KeyRangeRef(middleKey, middleKey2), self->tenant);
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1Catch1(__when_expr_25.getError(), loopDepth); else return a_body1cont10cont12cont4when1(__when_expr_25.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 26;
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 25, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont4(bool && unblobbifyFail4,int loopDepth) 
	{
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!unblobbifyFail4);
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_25 = cx->unblobbifyRange(KeyRangeRef(middleKey, middleKey2), self->tenant);
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1Catch1(__when_expr_25.getError(), loopDepth); else return a_body1cont10cont12cont4when1(__when_expr_25.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 26;
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 25, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont3when1(bool const& unblobbifyFail4,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont4(unblobbifyFail4, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont3when1(bool && unblobbifyFail4,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont4(std::move(unblobbifyFail4), loopDepth);

		return loopDepth;
	}
	void a_exitChoose25() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 24, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 24, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont10cont12cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 24, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont10cont12cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 24, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 24);

	}
	int a_body1cont10cont12cont5(bool const& unblobbifyFail5,int loopDepth) 
	{
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!unblobbifyFail5);
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		unblobbifyMethod = deterministicRandom()->randomInt(0, 4);
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (unblobbifyMethod == 0)
															#line 11781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_26 = cx->unblobbifyRange(range, self->tenant);
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1Catch1(__when_expr_26.getError(), loopDepth); else return a_body1cont10cont12cont5when1(__when_expr_26.get(), loopDepth); };
			static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 27;
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 26, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (unblobbifyMethod == 1)
															#line 11799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				StrictFuture<bool> __when_expr_27 = cx->unblobbifyRange(KeyRangeRef(range.begin, activeRange.end), self->tenant);
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1Catch1(__when_expr_27.getError(), loopDepth); else return a_body1cont10cont12cont5when2(__when_expr_27.get(), loopDepth); };
				static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 28;
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 27, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 644 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				if (unblobbifyMethod == 2)
															#line 11817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				{
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					StrictFuture<bool> __when_expr_28 = cx->unblobbifyRange(KeyRangeRef(activeRange.begin, range.end), self->tenant);
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
					if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1Catch1(__when_expr_28.getError(), loopDepth); else return a_body1cont10cont12cont5when3(__when_expr_28.get(), loopDepth); };
					static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 29;
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 28, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					if (unblobbifyMethod == 3)
															#line 11835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
					{
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
						StrictFuture<bool> __when_expr_29 = cx->unblobbifyRange(activeRange, self->tenant);
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
						if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
						if (__when_expr_29.isReady()) { if (__when_expr_29.isError()) return a_body1Catch1(__when_expr_29.getError(), loopDepth); else return a_body1cont10cont12cont5when4(__when_expr_29.get(), loopDepth); };
						static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 30;
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
						__when_expr_29.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 29, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 652 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
						ASSERT(false);
															#line 11853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
						loopDepth = a_body1cont10cont12cont13(loopDepth);
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1cont10cont12cont5(bool && unblobbifyFail5,int loopDepth) 
	{
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(!unblobbifyFail5);
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		unblobbifyMethod = deterministicRandom()->randomInt(0, 4);
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (unblobbifyMethod == 0)
															#line 11870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_26 = cx->unblobbifyRange(range, self->tenant);
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1Catch1(__when_expr_26.getError(), loopDepth); else return a_body1cont10cont12cont5when1(__when_expr_26.get(), loopDepth); };
			static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 27;
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 26, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (unblobbifyMethod == 1)
															#line 11888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				StrictFuture<bool> __when_expr_27 = cx->unblobbifyRange(KeyRangeRef(range.begin, activeRange.end), self->tenant);
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1Catch1(__when_expr_27.getError(), loopDepth); else return a_body1cont10cont12cont5when2(__when_expr_27.get(), loopDepth); };
				static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 28;
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 27, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 644 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				if (unblobbifyMethod == 2)
															#line 11906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				{
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					StrictFuture<bool> __when_expr_28 = cx->unblobbifyRange(KeyRangeRef(activeRange.begin, range.end), self->tenant);
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
					if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1Catch1(__when_expr_28.getError(), loopDepth); else return a_body1cont10cont12cont5when3(__when_expr_28.get(), loopDepth); };
					static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 29;
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 28, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					if (unblobbifyMethod == 3)
															#line 11924 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
					{
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
						StrictFuture<bool> __when_expr_29 = cx->unblobbifyRange(activeRange, self->tenant);
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
						if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
						if (__when_expr_29.isReady()) { if (__when_expr_29.isError()) return a_body1Catch1(__when_expr_29.getError(), loopDepth); else return a_body1cont10cont12cont5when4(__when_expr_29.get(), loopDepth); };
						static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 30;
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
						__when_expr_29.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 29, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 11935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 652 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
						ASSERT(false);
															#line 11942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
						loopDepth = a_body1cont10cont12cont13(loopDepth);
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1cont10cont12cont4when1(bool const& unblobbifyFail5,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont5(unblobbifyFail5, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont4when1(bool && unblobbifyFail5,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont5(std::move(unblobbifyFail5), loopDepth);

		return loopDepth;
	}
	void a_exitChoose26() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 25, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 25, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont10cont12cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 25, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont10cont12cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 25, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 25);

	}
	int a_body1cont10cont12cont6(int loopDepth) 
	{
															#line 656 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_30 = cx->unblobbifyRange(activeRange, self->tenant);
															#line 656 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_30.isReady()) { if (__when_expr_30.isError()) return a_body1Catch1(__when_expr_30.getError(), loopDepth); else return a_body1cont10cont12cont6when1(__when_expr_30.get(), loopDepth); };
		static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 31;
															#line 656 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_30.addCallbackAndClear(static_cast<ActorCallback< BlobbifyIdempotentUnitActor, 30, bool >*>(static_cast<BlobbifyIdempotentUnitActor*>(this)));
															#line 12037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont7(bool const& unblobbifySuccess0,int loopDepth) 
	{
															#line 639 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unblobbifySuccess0);
															#line 12046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont10cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont7(bool && unblobbifySuccess0,int loopDepth) 
	{
															#line 639 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unblobbifySuccess0);
															#line 12055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont10cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont5when1(bool const& unblobbifySuccess0,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont7(unblobbifySuccess0, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont5when1(bool && unblobbifySuccess0,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont7(std::move(unblobbifySuccess0), loopDepth);

		return loopDepth;
	}
	void a_exitChoose27() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 26, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 26, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont10cont12cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 26, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont10cont12cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 26, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 26);

	}
	int a_body1cont10cont12cont9(int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont10(bool const& unblobbifySuccess1,int loopDepth) 
	{
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unblobbifySuccess1);
															#line 12145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont10cont12cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont10(bool && unblobbifySuccess1,int loopDepth) 
	{
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unblobbifySuccess1);
															#line 12154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont10cont12cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont5when2(bool const& unblobbifySuccess1,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont10(unblobbifySuccess1, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont5when2(bool && unblobbifySuccess1,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont10(std::move(unblobbifySuccess1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose28() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 27, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 27, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont10cont12cont5when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 27, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont10cont12cont5when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 27, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 27);

	}
	int a_body1cont10cont12cont11(int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont12(bool const& unblobbifySuccess2,int loopDepth) 
	{
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unblobbifySuccess2);
															#line 12244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont10cont12cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont12(bool && unblobbifySuccess2,int loopDepth) 
	{
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unblobbifySuccess2);
															#line 12253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont10cont12cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont5when3(bool const& unblobbifySuccess2,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont12(unblobbifySuccess2, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont5when3(bool && unblobbifySuccess2,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont12(std::move(unblobbifySuccess2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose29() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 28, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 28, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont10cont12cont5when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 28, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont10cont12cont5when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 28, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 28);

	}
	int a_body1cont10cont12cont13(int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont14(bool const& unblobbifySuccess3,int loopDepth) 
	{
															#line 650 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unblobbifySuccess3);
															#line 12343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont10cont12cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont14(bool && unblobbifySuccess3,int loopDepth) 
	{
															#line 650 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unblobbifySuccess3);
															#line 12352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont10cont12cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont5when4(bool const& unblobbifySuccess3,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont14(unblobbifySuccess3, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont5when4(bool && unblobbifySuccess3,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont14(std::move(unblobbifySuccess3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose30() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 29, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 29, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont10cont12cont5when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 29, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont10cont12cont5when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 29, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 29);

	}
	int a_body1cont10cont12cont16(bool const& unblobbifySuccessAgain,int loopDepth) 
	{
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unblobbifySuccessAgain);
															#line 12436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont10cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont16(bool && unblobbifySuccessAgain,int loopDepth) 
	{
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unblobbifySuccessAgain);
															#line 12445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont10cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont6when1(bool const& unblobbifySuccessAgain,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont16(unblobbifySuccessAgain, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont6when1(bool && unblobbifySuccessAgain,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont16(std::move(unblobbifySuccessAgain), loopDepth);

		return loopDepth;
	}
	void a_exitChoose31() 
	{
		if (static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyIdempotentUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyIdempotentUnitActor*>(this)->ActorCallback< BlobbifyIdempotentUnitActor, 30, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 30, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont10cont12cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_fire(ActorCallback< BlobbifyIdempotentUnitActor, 30, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont10cont12cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_error(ActorCallback< BlobbifyIdempotentUnitActor, 30, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), 30);

	}
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange activeRange;
															#line 535 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Key middleKey;
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Key middleKey2;
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Transaction tr;
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Version purgeVersion;
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRangeRef purgeRange;
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	int unblobbifyMethod;
															#line 12545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via blobbifyIdempotentUnit()
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class BlobbifyIdempotentUnitActor final : public Actor<Void>, public ActorCallback< BlobbifyIdempotentUnitActor, 0, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 1, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 2, Void >, public ActorCallback< BlobbifyIdempotentUnitActor, 3, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 4, Void >, public ActorCallback< BlobbifyIdempotentUnitActor, 5, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 6, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 7, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 8, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 9, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 10, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 11, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 12, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 13, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< BlobbifyIdempotentUnitActor, 14, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< BlobbifyIdempotentUnitActor, 15, Void >, public ActorCallback< BlobbifyIdempotentUnitActor, 16, Key >, public ActorCallback< BlobbifyIdempotentUnitActor, 17, Void >, public ActorCallback< BlobbifyIdempotentUnitActor, 18, Key >, public ActorCallback< BlobbifyIdempotentUnitActor, 19, Void >, public ActorCallback< BlobbifyIdempotentUnitActor, 20, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< BlobbifyIdempotentUnitActor, 21, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 22, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 23, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 24, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 25, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 26, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 27, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 28, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 29, bool >, public ActorCallback< BlobbifyIdempotentUnitActor, 30, bool >, public FastAllocated<BlobbifyIdempotentUnitActor>, public BlobbifyIdempotentUnitActorState<BlobbifyIdempotentUnitActor> {
															#line 12550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<BlobbifyIdempotentUnitActor>::operator new;
	using FastAllocated<BlobbifyIdempotentUnitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12186815477147422720UL, 3945768704433088768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 0, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 1, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 2, Void >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 3, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 4, Void >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 5, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 6, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 7, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 8, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 9, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 10, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 11, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 12, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 13, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 14, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 15, Void >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 16, Key >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 17, Void >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 18, Key >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 19, Void >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 20, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 21, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 22, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 23, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 24, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 25, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 26, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 27, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 28, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 29, bool >;
friend struct ActorCallback< BlobbifyIdempotentUnitActor, 30, bool >;
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobbifyIdempotentUnitActor(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 12597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   BlobbifyIdempotentUnitActorState<BlobbifyIdempotentUnitActor>(cx, self, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7220930994319817984UL, 2105097580590906880UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyIdempotentUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("blobbifyIdempotentUnit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("blobbifyIdempotentUnit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 3, bool >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 6, bool >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 7, bool >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 8, bool >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 9, bool >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 10, bool >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 11, bool >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 12, bool >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 13, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 14, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 16, Key >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 18, Key >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 19, Void >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 20, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 22: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 21, bool >*)0, actor_cancelled()); break;
		case 23: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 22, bool >*)0, actor_cancelled()); break;
		case 24: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 23, bool >*)0, actor_cancelled()); break;
		case 25: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 24, bool >*)0, actor_cancelled()); break;
		case 26: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 25, bool >*)0, actor_cancelled()); break;
		case 27: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 26, bool >*)0, actor_cancelled()); break;
		case 28: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 27, bool >*)0, actor_cancelled()); break;
		case 29: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 28, bool >*)0, actor_cancelled()); break;
		case 30: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 29, bool >*)0, actor_cancelled()); break;
		case 31: this->a_callback_error((ActorCallback< BlobbifyIdempotentUnitActor, 30, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> blobbifyIdempotentUnit( Database const& cx, BlobGranuleRangesWorkload* const& self, KeyRange const& range ) {
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new BlobbifyIdempotentUnitActor(cx, self, range));
															#line 12659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 12664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via reBlobbifyUnit()
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class ReBlobbifyUnitActor>
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class ReBlobbifyUnitActorState {
															#line 12670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	ReBlobbifyUnitActorState(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self),
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   range(range)
															#line 12681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("reBlobbifyUnit", reinterpret_cast<unsigned long>(this));

	}
	~ReBlobbifyUnitActorState() 
	{
		fdb_probe_actor_destroy("reBlobbifyUnit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_0 = cx->blobbifyRange(range, self->tenant);
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 1;
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 0, bool >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 12703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReBlobbifyUnitActorState();
		static_cast<ReBlobbifyUnitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& setSuccess,int loopDepth) 
	{
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->checkRange(cx, self, range, true, true);
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 2;
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 1, Void >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 12735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool && setSuccess,int loopDepth) 
	{
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->checkRange(cx, self, range, true, true);
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 2;
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 1, Void >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 12753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& setSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont1(setSuccess, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && setSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(setSuccess), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state > 0) static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<ReBlobbifyUnitActor*>(this)->ActorCallback< ReBlobbifyUnitActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReBlobbifyUnitActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Key> __when_expr_2 = self->versionedForcePurge(cx, range, self->tenant);
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 3;
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 2, Key >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 12844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Key> __when_expr_2 = self->versionedForcePurge(cx, range, self->tenant);
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 3;
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 2, Key >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 12860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state > 0) static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<ReBlobbifyUnitActor*>(this)->ActorCallback< ReBlobbifyUnitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReBlobbifyUnitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Key const& purgeKey,int loopDepth) 
	{
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 4;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 3, Void >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 12951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Key && purgeKey,int loopDepth) 
	{
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 4;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 3, Void >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 12967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont3(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state > 0) static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<ReBlobbifyUnitActor*>(this)->ActorCallback< ReBlobbifyUnitActor, 2, Key >::remove();

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 2, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 2, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReBlobbifyUnitActor, 2, Key >*,Error err) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->checkRange(cx, self, range, false, false);
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 5;
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 4, Void >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 13058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->checkRange(cx, self, range, false, false);
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13069 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 5;
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 4, Void >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 13074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state > 0) static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<ReBlobbifyUnitActor*>(this)->ActorCallback< ReBlobbifyUnitActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ReBlobbifyUnitActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_5 = cx->unblobbifyRange(range, self->tenant);
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 6;
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 5, bool >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 13165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_5 = cx->unblobbifyRange(range, self->tenant);
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 6;
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 5, bool >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 13181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state > 0) static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<ReBlobbifyUnitActor*>(this)->ActorCallback< ReBlobbifyUnitActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ReBlobbifyUnitActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(bool const& unsetSuccess,int loopDepth) 
	{
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unsetSuccess);
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->checkRange(cx, self, range, false, false);
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 7;
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 6, Void >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 13274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(bool && unsetSuccess,int loopDepth) 
	{
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unsetSuccess);
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->checkRange(cx, self, range, false, false);
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 7;
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 6, Void >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 13292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(bool const& unsetSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont6(unsetSuccess, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(bool && unsetSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(unsetSuccess), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state > 0) static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<ReBlobbifyUnitActor*>(this)->ActorCallback< ReBlobbifyUnitActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ReBlobbifyUnitActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_7 = cx->blobbifyRange(range, self->tenant);
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 8;
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 7, bool >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 13383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_7 = cx->blobbifyRange(range, self->tenant);
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 8;
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 7, bool >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 13399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state > 0) static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<ReBlobbifyUnitActor*>(this)->ActorCallback< ReBlobbifyUnitActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ReBlobbifyUnitActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont8(bool const& reSetSuccess,int loopDepth) 
	{
															#line 678 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(reSetSuccess);
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_8 = self->checkRange(cx, self, range, true, true);
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont8when1(__when_expr_8.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 9;
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 8, Void >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 13492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(bool && reSetSuccess,int loopDepth) 
	{
															#line 678 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(reSetSuccess);
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_8 = self->checkRange(cx, self, range, true, true);
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont8when1(__when_expr_8.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 9;
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 8, Void >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 13510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(bool const& reSetSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont8(reSetSuccess, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(bool && reSetSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(reSetSuccess), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state > 0) static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<ReBlobbifyUnitActor*>(this)->ActorCallback< ReBlobbifyUnitActor, 7, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 7, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 7, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ReBlobbifyUnitActor, 7, bool >*,Error err) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_9 = self->tearDownRangeAfterUnit(cx, self, range);
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont9when1(__when_expr_9.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 10;
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 9, Void >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 13601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_9 = self->tearDownRangeAfterUnit(cx, self, range);
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont9when1(__when_expr_9.get(), loopDepth); };
		static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 10;
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ReBlobbifyUnitActor, 9, Void >*>(static_cast<ReBlobbifyUnitActor*>(this)));
															#line 13617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state > 0) static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<ReBlobbifyUnitActor*>(this)->ActorCallback< ReBlobbifyUnitActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ReBlobbifyUnitActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<ReBlobbifyUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReBlobbifyUnitActorState(); static_cast<ReBlobbifyUnitActor*>(this)->destroy(); return 0; }
															#line 13701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<ReBlobbifyUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReBlobbifyUnitActorState();
		static_cast<ReBlobbifyUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<ReBlobbifyUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReBlobbifyUnitActorState(); static_cast<ReBlobbifyUnitActor*>(this)->destroy(); return 0; }
															#line 13713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<ReBlobbifyUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReBlobbifyUnitActorState();
		static_cast<ReBlobbifyUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state > 0) static_cast<ReBlobbifyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<ReBlobbifyUnitActor*>(this)->ActorCallback< ReBlobbifyUnitActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ReBlobbifyUnitActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ReBlobbifyUnitActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 13802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via reBlobbifyUnit()
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class ReBlobbifyUnitActor final : public Actor<Void>, public ActorCallback< ReBlobbifyUnitActor, 0, bool >, public ActorCallback< ReBlobbifyUnitActor, 1, Void >, public ActorCallback< ReBlobbifyUnitActor, 2, Key >, public ActorCallback< ReBlobbifyUnitActor, 3, Void >, public ActorCallback< ReBlobbifyUnitActor, 4, Void >, public ActorCallback< ReBlobbifyUnitActor, 5, bool >, public ActorCallback< ReBlobbifyUnitActor, 6, Void >, public ActorCallback< ReBlobbifyUnitActor, 7, bool >, public ActorCallback< ReBlobbifyUnitActor, 8, Void >, public ActorCallback< ReBlobbifyUnitActor, 9, Void >, public FastAllocated<ReBlobbifyUnitActor>, public ReBlobbifyUnitActorState<ReBlobbifyUnitActor> {
															#line 13807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<ReBlobbifyUnitActor>::operator new;
	using FastAllocated<ReBlobbifyUnitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9072807401522324480UL, 9428682756364869120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReBlobbifyUnitActor, 0, bool >;
friend struct ActorCallback< ReBlobbifyUnitActor, 1, Void >;
friend struct ActorCallback< ReBlobbifyUnitActor, 2, Key >;
friend struct ActorCallback< ReBlobbifyUnitActor, 3, Void >;
friend struct ActorCallback< ReBlobbifyUnitActor, 4, Void >;
friend struct ActorCallback< ReBlobbifyUnitActor, 5, bool >;
friend struct ActorCallback< ReBlobbifyUnitActor, 6, Void >;
friend struct ActorCallback< ReBlobbifyUnitActor, 7, bool >;
friend struct ActorCallback< ReBlobbifyUnitActor, 8, Void >;
friend struct ActorCallback< ReBlobbifyUnitActor, 9, Void >;
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	ReBlobbifyUnitActor(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 13833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ReBlobbifyUnitActorState<ReBlobbifyUnitActor>(cx, self, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8285700077393132288UL, 5178140651119665408UL);
		ActorExecutionContextHelper __helper(static_cast<ReBlobbifyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reBlobbifyUnit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reBlobbifyUnit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReBlobbifyUnitActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReBlobbifyUnitActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReBlobbifyUnitActor, 2, Key >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ReBlobbifyUnitActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ReBlobbifyUnitActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ReBlobbifyUnitActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ReBlobbifyUnitActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ReBlobbifyUnitActor, 7, bool >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ReBlobbifyUnitActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ReBlobbifyUnitActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> reBlobbifyUnit( Database const& cx, BlobGranuleRangesWorkload* const& self, KeyRange const& range ) {
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new ReBlobbifyUnitActor(cx, self, range));
															#line 13874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 685 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 13879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via adjacentPurge()
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class AdjacentPurgeActor>
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class AdjacentPurgeActorState {
															#line 13885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	AdjacentPurgeActorState(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self),
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   range(range)
															#line 13896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("adjacentPurge", reinterpret_cast<unsigned long>(this));

	}
	~AdjacentPurgeActorState() 
	{
		fdb_probe_actor_destroy("adjacentPurge", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			Key midKey = range.begin.withSuffix("mid"_sr);
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			range1 = KeyRange(KeyRangeRef(range.begin, midKey));
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			range2 = KeyRange(KeyRangeRef(midKey, range.end));
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			setSuccess = false;
															#line 693 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(setSuccess, cx->blobbifyRange(range1, self->tenant));
															#line 693 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 1;
															#line 693 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 0, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 13926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AdjacentPurgeActorState();
		static_cast<AdjacentPurgeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->checkRange(cx, self, range1, true, true);
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 2;
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 1, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 13958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->checkRange(cx, self, range1, true, true);
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 2;
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 1, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 13976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state > 0) static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 0;
		static_cast<AdjacentPurgeActor*>(this)->ActorCallback< AdjacentPurgeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AdjacentPurgeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = store(setSuccess, cx->blobbifyRange(range2, self->tenant));
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 3;
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 2, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = store(setSuccess, cx->blobbifyRange(range2, self->tenant));
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 3;
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 2, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14083 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state > 0) static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 0;
		static_cast<AdjacentPurgeActor*>(this)->ActorCallback< AdjacentPurgeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AdjacentPurgeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 697 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->checkRange(cx, self, range2, true, true);
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 4;
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 3, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 697 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->checkRange(cx, self, range2, true, true);
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 4;
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 3, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state > 0) static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 0;
		static_cast<AdjacentPurgeActor*>(this)->ActorCallback< AdjacentPurgeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AdjacentPurgeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		purgeKey = Key();
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = store(purgeKey, self->versionedForcePurge(cx, range1, self->tenant));
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 5;
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 4, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		purgeKey = Key();
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = store(purgeKey, self->versionedForcePurge(cx, range1, self->tenant));
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 5;
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 4, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state > 0) static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 0;
		static_cast<AdjacentPurgeActor*>(this)->ActorCallback< AdjacentPurgeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< AdjacentPurgeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 6;
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 5, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 6;
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 5, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state > 0) static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 0;
		static_cast<AdjacentPurgeActor*>(this)->ActorCallback< AdjacentPurgeActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< AdjacentPurgeActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = store(purgeKey, self->versionedForcePurge(cx, range2, self->tenant));
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 7;
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 6, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = store(purgeKey, self->versionedForcePurge(cx, range2, self->tenant));
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 7;
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 6, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state > 0) static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 0;
		static_cast<AdjacentPurgeActor*>(this)->ActorCallback< AdjacentPurgeActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< AdjacentPurgeActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_7 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 8;
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 7, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_7 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14621 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 8;
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 7, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state > 0) static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 0;
		static_cast<AdjacentPurgeActor*>(this)->ActorCallback< AdjacentPurgeActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< AdjacentPurgeActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_8 = cx->unblobbifyRange(range, self->tenant);
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont8when1(__when_expr_8.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 9;
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 8, bool >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_8 = cx->unblobbifyRange(range, self->tenant);
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont8when1(__when_expr_8.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 9;
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 8, bool >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state > 0) static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 0;
		static_cast<AdjacentPurgeActor*>(this)->ActorCallback< AdjacentPurgeActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< AdjacentPurgeActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont9(bool const& unsetSuccess,int loopDepth) 
	{
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unsetSuccess);
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_9 = self->tearDownRangeAfterUnit(cx, self, range);
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont9when1(__when_expr_9.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 10;
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 9, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(bool && unsetSuccess,int loopDepth) 
	{
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unsetSuccess);
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_9 = self->tearDownRangeAfterUnit(cx, self, range);
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont9when1(__when_expr_9.get(), loopDepth); };
		static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 10;
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< AdjacentPurgeActor, 9, Void >*>(static_cast<AdjacentPurgeActor*>(this)));
															#line 14844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(bool const& unsetSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont9(unsetSuccess, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(bool && unsetSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(unsetSuccess), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state > 0) static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 0;
		static_cast<AdjacentPurgeActor*>(this)->ActorCallback< AdjacentPurgeActor, 8, bool >::remove();

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 8, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 8, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< AdjacentPurgeActor, 8, bool >*,Error err) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 712 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<AdjacentPurgeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AdjacentPurgeActorState(); static_cast<AdjacentPurgeActor*>(this)->destroy(); return 0; }
															#line 14928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<AdjacentPurgeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AdjacentPurgeActorState();
		static_cast<AdjacentPurgeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 712 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<AdjacentPurgeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AdjacentPurgeActorState(); static_cast<AdjacentPurgeActor*>(this)->destroy(); return 0; }
															#line 14940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<AdjacentPurgeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AdjacentPurgeActorState();
		static_cast<AdjacentPurgeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<AdjacentPurgeActor*>(this)->actor_wait_state > 0) static_cast<AdjacentPurgeActor*>(this)->actor_wait_state = 0;
		static_cast<AdjacentPurgeActor*>(this)->ActorCallback< AdjacentPurgeActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< AdjacentPurgeActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< AdjacentPurgeActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range1;
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range2;
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	bool setSuccess;
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Key purgeKey;
															#line 15037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via adjacentPurge()
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class AdjacentPurgeActor final : public Actor<Void>, public ActorCallback< AdjacentPurgeActor, 0, Void >, public ActorCallback< AdjacentPurgeActor, 1, Void >, public ActorCallback< AdjacentPurgeActor, 2, Void >, public ActorCallback< AdjacentPurgeActor, 3, Void >, public ActorCallback< AdjacentPurgeActor, 4, Void >, public ActorCallback< AdjacentPurgeActor, 5, Void >, public ActorCallback< AdjacentPurgeActor, 6, Void >, public ActorCallback< AdjacentPurgeActor, 7, Void >, public ActorCallback< AdjacentPurgeActor, 8, bool >, public ActorCallback< AdjacentPurgeActor, 9, Void >, public FastAllocated<AdjacentPurgeActor>, public AdjacentPurgeActorState<AdjacentPurgeActor> {
															#line 15042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<AdjacentPurgeActor>::operator new;
	using FastAllocated<AdjacentPurgeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11609976149551988992UL, 16457538232466214656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AdjacentPurgeActor, 0, Void >;
friend struct ActorCallback< AdjacentPurgeActor, 1, Void >;
friend struct ActorCallback< AdjacentPurgeActor, 2, Void >;
friend struct ActorCallback< AdjacentPurgeActor, 3, Void >;
friend struct ActorCallback< AdjacentPurgeActor, 4, Void >;
friend struct ActorCallback< AdjacentPurgeActor, 5, Void >;
friend struct ActorCallback< AdjacentPurgeActor, 6, Void >;
friend struct ActorCallback< AdjacentPurgeActor, 7, Void >;
friend struct ActorCallback< AdjacentPurgeActor, 8, bool >;
friend struct ActorCallback< AdjacentPurgeActor, 9, Void >;
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	AdjacentPurgeActor(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 15068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   AdjacentPurgeActorState<AdjacentPurgeActor>(cx, self, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("adjacentPurge", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13870725524041786880UL, 1422814136756578560UL);
		ActorExecutionContextHelper __helper(static_cast<AdjacentPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("adjacentPurge");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("adjacentPurge", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AdjacentPurgeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AdjacentPurgeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AdjacentPurgeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< AdjacentPurgeActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< AdjacentPurgeActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< AdjacentPurgeActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< AdjacentPurgeActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< AdjacentPurgeActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< AdjacentPurgeActor, 8, bool >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< AdjacentPurgeActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> adjacentPurge( Database const& cx, BlobGranuleRangesWorkload* const& self, KeyRange const& range ) {
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new AdjacentPurgeActor(cx, self, range));
															#line 15109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 714 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

																#line 15114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via blobbifyBlockingUnit()
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class BlobbifyBlockingUnitActor>
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class BlobbifyBlockingUnitActorState {
															#line 15120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobbifyBlockingUnitActorState(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self),
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   range(range)
															#line 15131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this));

	}
	~BlobbifyBlockingUnitActorState() 
	{
		fdb_probe_actor_destroy("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_0 = cx->blobbifyRangeBlocking(range, self->tenant);
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<BlobbifyBlockingUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BlobbifyBlockingUnitActor*>(this)->actor_wait_state = 1;
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobbifyBlockingUnitActor, 0, bool >*>(static_cast<BlobbifyBlockingUnitActor*>(this)));
															#line 15153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobbifyBlockingUnitActorState();
		static_cast<BlobbifyBlockingUnitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& setSuccess,int loopDepth) 
	{
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_1 = self->isRangeActive(cx, range, self->tenant);
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyBlockingUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BlobbifyBlockingUnitActor*>(this)->actor_wait_state = 2;
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobbifyBlockingUnitActor, 1, bool >*>(static_cast<BlobbifyBlockingUnitActor*>(this)));
															#line 15185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool && setSuccess,int loopDepth) 
	{
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_1 = self->isRangeActive(cx, range, self->tenant);
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobbifyBlockingUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15198 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BlobbifyBlockingUnitActor*>(this)->actor_wait_state = 2;
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobbifyBlockingUnitActor, 1, bool >*>(static_cast<BlobbifyBlockingUnitActor*>(this)));
															#line 15203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& setSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont1(setSuccess, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && setSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(setSuccess), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobbifyBlockingUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyBlockingUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyBlockingUnitActor*>(this)->ActorCallback< BlobbifyBlockingUnitActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyBlockingUnitActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyBlockingUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobbifyBlockingUnitActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyBlockingUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobbifyBlockingUnitActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyBlockingUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(bool const& verifySuccess,int loopDepth) 
	{
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(verifySuccess);
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<BlobbifyBlockingUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobbifyBlockingUnitActorState(); static_cast<BlobbifyBlockingUnitActor*>(this)->destroy(); return 0; }
															#line 15289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<BlobbifyBlockingUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BlobbifyBlockingUnitActorState();
		static_cast<BlobbifyBlockingUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(bool && verifySuccess,int loopDepth) 
	{
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(verifySuccess);
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<BlobbifyBlockingUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobbifyBlockingUnitActorState(); static_cast<BlobbifyBlockingUnitActor*>(this)->destroy(); return 0; }
															#line 15303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<BlobbifyBlockingUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BlobbifyBlockingUnitActorState();
		static_cast<BlobbifyBlockingUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& verifySuccess,int loopDepth) 
	{
		loopDepth = a_body1cont2(verifySuccess, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && verifySuccess,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(verifySuccess), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BlobbifyBlockingUnitActor*>(this)->actor_wait_state > 0) static_cast<BlobbifyBlockingUnitActor*>(this)->actor_wait_state = 0;
		static_cast<BlobbifyBlockingUnitActor*>(this)->ActorCallback< BlobbifyBlockingUnitActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobbifyBlockingUnitActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyBlockingUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BlobbifyBlockingUnitActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyBlockingUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BlobbifyBlockingUnitActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyBlockingUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 15392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via blobbifyBlockingUnit()
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class BlobbifyBlockingUnitActor final : public Actor<Void>, public ActorCallback< BlobbifyBlockingUnitActor, 0, bool >, public ActorCallback< BlobbifyBlockingUnitActor, 1, bool >, public FastAllocated<BlobbifyBlockingUnitActor>, public BlobbifyBlockingUnitActorState<BlobbifyBlockingUnitActor> {
															#line 15397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<BlobbifyBlockingUnitActor>::operator new;
	using FastAllocated<BlobbifyBlockingUnitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(508940383433211648UL, 13890411616118817792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobbifyBlockingUnitActor, 0, bool >;
friend struct ActorCallback< BlobbifyBlockingUnitActor, 1, bool >;
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobbifyBlockingUnitActor(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 15415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   BlobbifyBlockingUnitActorState<BlobbifyBlockingUnitActor>(cx, self, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6551944564627990016UL, 14313041005535185920UL);
		ActorExecutionContextHelper __helper(static_cast<BlobbifyBlockingUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("blobbifyBlockingUnit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("blobbifyBlockingUnit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobbifyBlockingUnitActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BlobbifyBlockingUnitActor, 1, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> blobbifyBlockingUnit( Database const& cx, BlobGranuleRangesWorkload* const& self, KeyRange const& range ) {
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new BlobbifyBlockingUnitActor(cx, self, range));
															#line 15448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 723 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

	// create tenant, set up a blob range, force purge blob range, and then delete tenant
																#line 15454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via deleteTenantUnit()
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class DeleteTenantUnitActor>
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class DeleteTenantUnitActorState {
															#line 15460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	DeleteTenantUnitActorState(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self),
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   range(range)
															#line 15471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteTenantUnit", reinterpret_cast<unsigned long>(this));

	}
	~DeleteTenantUnitActorState() 
	{
		fdb_probe_actor_destroy("deleteTenantUnit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 726 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (!self->tenantName.present())
															#line 15486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				if (!static_cast<DeleteTenantUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantUnitActorState(); static_cast<DeleteTenantUnitActor*>(this)->destroy(); return 0; }
															#line 15490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				new (&static_cast<DeleteTenantUnitActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DeleteTenantUnitActorState();
				static_cast<DeleteTenantUnitActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			newTenantName = self->tenantName.get().withSuffix("_" + deterministicRandom()->randomUniqueID().toString());
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(self->setupTenant(cx, newTenantName));
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 1;
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantUnitActor, 0, Void >*>(static_cast<DeleteTenantUnitActor*>(this)));
															#line 15507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteTenantUnitActorState();
		static_cast<DeleteTenantUnitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		newTenant = makeReference<Tenant>(cx, newTenantName);
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = newTenant->ready();
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 2;
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantUnitActor, 1, Void >*>(static_cast<DeleteTenantUnitActor*>(this)));
															#line 15539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		newTenant = makeReference<Tenant>(cx, newTenantName);
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = newTenant->ready();
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 2;
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantUnitActor, 1, Void >*>(static_cast<DeleteTenantUnitActor*>(this)));
															#line 15557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantUnitActor*>(this)->ActorCallback< DeleteTenantUnitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantUnitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteTenantUnitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteTenantUnitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 736 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_2 = cx->blobbifyRangeBlocking(range, newTenant);
															#line 736 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 3;
															#line 736 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantUnitActor, 2, bool >*>(static_cast<DeleteTenantUnitActor*>(this)));
															#line 15648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 736 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_2 = cx->blobbifyRangeBlocking(range, newTenant);
															#line 736 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 3;
															#line 736 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantUnitActor, 2, bool >*>(static_cast<DeleteTenantUnitActor*>(this)));
															#line 15664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantUnitActor*>(this)->ActorCallback< DeleteTenantUnitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantUnitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DeleteTenantUnitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DeleteTenantUnitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(bool const& setSuccess,int loopDepth) 
	{
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Key> __when_expr_3 = cx->purgeBlobGranules(range, 1, newTenant, true);
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 4;
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantUnitActor, 3, Key >*>(static_cast<DeleteTenantUnitActor*>(this)));
															#line 15757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(bool && setSuccess,int loopDepth) 
	{
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(setSuccess);
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Key> __when_expr_3 = cx->purgeBlobGranules(range, 1, newTenant, true);
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 4;
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantUnitActor, 3, Key >*>(static_cast<DeleteTenantUnitActor*>(this)));
															#line 15775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(bool const& setSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont4(setSuccess, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(bool && setSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(setSuccess), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantUnitActor*>(this)->ActorCallback< DeleteTenantUnitActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantUnitActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DeleteTenantUnitActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DeleteTenantUnitActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Key const& purgeKey,int loopDepth) 
	{
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 5;
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantUnitActor, 4, Void >*>(static_cast<DeleteTenantUnitActor*>(this)));
															#line 15866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Key && purgeKey,int loopDepth) 
	{
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 5;
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantUnitActor, 4, Void >*>(static_cast<DeleteTenantUnitActor*>(this)));
															#line 15882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont5(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantUnitActor*>(this)->ActorCallback< DeleteTenantUnitActor, 3, Key >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantUnitActor, 3, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DeleteTenantUnitActor, 3, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DeleteTenantUnitActor, 3, Key >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_5 = cx->unblobbifyRange(range, newTenant);
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 6;
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantUnitActor, 5, bool >*>(static_cast<DeleteTenantUnitActor*>(this)));
															#line 15973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_5 = cx->unblobbifyRange(range, newTenant);
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 6;
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantUnitActor, 5, bool >*>(static_cast<DeleteTenantUnitActor*>(this)));
															#line 15989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantUnitActor*>(this)->ActorCallback< DeleteTenantUnitActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantUnitActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DeleteTenantUnitActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DeleteTenantUnitActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(bool const& unblobbifySuccess,int loopDepth) 
	{
															#line 743 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unblobbifySuccess);
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = TenantAPI::deleteTenant(cx.getReference(), newTenantName);
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 7;
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantUnitActor, 6, Void >*>(static_cast<DeleteTenantUnitActor*>(this)));
															#line 16082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(bool && unblobbifySuccess,int loopDepth) 
	{
															#line 743 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unblobbifySuccess);
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = TenantAPI::deleteTenant(cx.getReference(), newTenantName);
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 7;
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantUnitActor, 6, Void >*>(static_cast<DeleteTenantUnitActor*>(this)));
															#line 16100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(bool const& unblobbifySuccess,int loopDepth) 
	{
		loopDepth = a_body1cont7(unblobbifySuccess, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(bool && unblobbifySuccess,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(unblobbifySuccess), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantUnitActor*>(this)->ActorCallback< DeleteTenantUnitActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantUnitActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DeleteTenantUnitActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DeleteTenantUnitActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<DeleteTenantUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantUnitActorState(); static_cast<DeleteTenantUnitActor*>(this)->destroy(); return 0; }
															#line 16184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<DeleteTenantUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantUnitActorState();
		static_cast<DeleteTenantUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<DeleteTenantUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantUnitActorState(); static_cast<DeleteTenantUnitActor*>(this)->destroy(); return 0; }
															#line 16196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<DeleteTenantUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantUnitActorState();
		static_cast<DeleteTenantUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantUnitActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantUnitActor*>(this)->ActorCallback< DeleteTenantUnitActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantUnitActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DeleteTenantUnitActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DeleteTenantUnitActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Standalone<StringRef> newTenantName;
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Reference<Tenant> newTenant;
															#line 16289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via deleteTenantUnit()
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class DeleteTenantUnitActor final : public Actor<Void>, public ActorCallback< DeleteTenantUnitActor, 0, Void >, public ActorCallback< DeleteTenantUnitActor, 1, Void >, public ActorCallback< DeleteTenantUnitActor, 2, bool >, public ActorCallback< DeleteTenantUnitActor, 3, Key >, public ActorCallback< DeleteTenantUnitActor, 4, Void >, public ActorCallback< DeleteTenantUnitActor, 5, bool >, public ActorCallback< DeleteTenantUnitActor, 6, Void >, public FastAllocated<DeleteTenantUnitActor>, public DeleteTenantUnitActorState<DeleteTenantUnitActor> {
															#line 16294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<DeleteTenantUnitActor>::operator new;
	using FastAllocated<DeleteTenantUnitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2063618629544365824UL, 15955600693901123840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteTenantUnitActor, 0, Void >;
friend struct ActorCallback< DeleteTenantUnitActor, 1, Void >;
friend struct ActorCallback< DeleteTenantUnitActor, 2, bool >;
friend struct ActorCallback< DeleteTenantUnitActor, 3, Key >;
friend struct ActorCallback< DeleteTenantUnitActor, 4, Void >;
friend struct ActorCallback< DeleteTenantUnitActor, 5, bool >;
friend struct ActorCallback< DeleteTenantUnitActor, 6, Void >;
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	DeleteTenantUnitActor(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 16317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteTenantUnitActorState<DeleteTenantUnitActor>(cx, self, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteTenantUnit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5989874535764895744UL, 3190583185281109504UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteTenantUnit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteTenantUnit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteTenantUnitActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DeleteTenantUnitActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DeleteTenantUnitActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DeleteTenantUnitActor, 3, Key >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DeleteTenantUnitActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DeleteTenantUnitActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DeleteTenantUnitActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> deleteTenantUnit( Database const& cx, BlobGranuleRangesWorkload* const& self, KeyRange const& range ) {
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new DeleteTenantUnitActor(cx, self, range));
															#line 16355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 749 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

	// Simulate having many consecutive ranges within one subrange registered, and unblobbifying some prefix of them
	// (potentially the whole range)
																#line 16362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via unblobbifyManyUnit()
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class UnblobbifyManyUnitActor>
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class UnblobbifyManyUnitActorState {
															#line 16368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	UnblobbifyManyUnitActorState(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self),
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   range(range),
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   ranges(deterministicRandom()->randomInt(2, 10)),
															#line 755 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   prefixToUnblobbify(deterministicRandom()->randomInt(1, ranges + 1)),
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   i()
															#line 16385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this));

	}
	~UnblobbifyManyUnitActorState() 
	{
		fdb_probe_actor_destroy("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			i = 0;
															#line 16400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UnblobbifyManyUnitActorState();
		static_cast<UnblobbifyManyUnitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		Key startKey = range.begin;
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 16425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 769 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			startKey = startKey.withSuffix("_0"_sr);
															#line 16429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 773 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		endKey = range.end;
															#line 774 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (prefixToUnblobbify < ranges || deterministicRandom()->coinflip())
															#line 16435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			endKey = range.begin.withSuffix("_" + std::to_string(prefixToUnblobbify));
															#line 16439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 778 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		unblobbifyRange = KeyRange(KeyRangeRef(startKey, endKey));
															#line 780 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		purgeKey = Key();
															#line 781 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = store(purgeKey, self->versionedForcePurge(cx, unblobbifyRange, self->tenant));
															#line 781 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 3;
															#line 781 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UnblobbifyManyUnitActor, 2, Void >*>(static_cast<UnblobbifyManyUnitActor*>(this)));
															#line 16454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!(i < ranges))
															#line 16470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 759 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		subRange = KeyRange(KeyRangeRef(range.begin.withSuffix("_" + std::to_string(i)), range.begin.withSuffix("_" + std::to_string(i + 1))));
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_0 = cx->blobbifyRange(subRange, self->tenant);
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 1;
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UnblobbifyManyUnitActor, 0, bool >*>(static_cast<UnblobbifyManyUnitActor*>(this)));
															#line 16485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& success,int loopDepth) 
	{
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(success);
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->checkRange(cx, self, subRange, true, true);
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 2;
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UnblobbifyManyUnitActor, 1, Void >*>(static_cast<UnblobbifyManyUnitActor*>(this)));
															#line 16516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && success,int loopDepth) 
	{
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(success);
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->checkRange(cx, self, subRange, true, true);
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 2;
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UnblobbifyManyUnitActor, 1, Void >*>(static_cast<UnblobbifyManyUnitActor*>(this)));
															#line 16534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(success, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state > 0) static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<UnblobbifyManyUnitActor*>(this)->ActorCallback< UnblobbifyManyUnitActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< UnblobbifyManyUnitActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UnblobbifyManyUnitActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UnblobbifyManyUnitActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		i++;
															#line 16618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		i++;
															#line 16627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state > 0) static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<UnblobbifyManyUnitActor*>(this)->ActorCallback< UnblobbifyManyUnitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnblobbifyManyUnitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UnblobbifyManyUnitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UnblobbifyManyUnitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 4;
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UnblobbifyManyUnitActor, 3, Void >*>(static_cast<UnblobbifyManyUnitActor*>(this)));
															#line 16718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 4;
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UnblobbifyManyUnitActor, 3, Void >*>(static_cast<UnblobbifyManyUnitActor*>(this)));
															#line 16734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state > 0) static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<UnblobbifyManyUnitActor*>(this)->ActorCallback< UnblobbifyManyUnitActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnblobbifyManyUnitActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UnblobbifyManyUnitActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UnblobbifyManyUnitActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_4 = cx->unblobbifyRange(unblobbifyRange, self->tenant);
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 5;
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< UnblobbifyManyUnitActor, 4, bool >*>(static_cast<UnblobbifyManyUnitActor*>(this)));
															#line 16825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_4 = cx->unblobbifyRange(unblobbifyRange, self->tenant);
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 5;
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< UnblobbifyManyUnitActor, 4, bool >*>(static_cast<UnblobbifyManyUnitActor*>(this)));
															#line 16841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state > 0) static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<UnblobbifyManyUnitActor*>(this)->ActorCallback< UnblobbifyManyUnitActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnblobbifyManyUnitActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UnblobbifyManyUnitActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UnblobbifyManyUnitActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(bool const& unsetSuccess,int loopDepth) 
	{
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unsetSuccess);
															#line 788 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		i = prefixToUnblobbify;
															#line 16927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(bool && unsetSuccess,int loopDepth) 
	{
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		ASSERT(unsetSuccess);
															#line 788 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		i = prefixToUnblobbify;
															#line 16938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(bool const& unsetSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont6(unsetSuccess, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(bool && unsetSuccess,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(unsetSuccess), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state > 0) static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<UnblobbifyManyUnitActor*>(this)->ActorCallback< UnblobbifyManyUnitActor, 4, bool >::remove();

	}
	void a_callback_fire(ActorCallback< UnblobbifyManyUnitActor, 4, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< UnblobbifyManyUnitActor, 4, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< UnblobbifyManyUnitActor, 4, bool >*,Error err) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->tearDownRangeAfterUnit(cx, self, KeyRangeRef(endKey, range.end));
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 7;
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< UnblobbifyManyUnitActor, 6, Void >*>(static_cast<UnblobbifyManyUnitActor*>(this)));
															#line 17029 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 788 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!(i < ranges))
															#line 17045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
			return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		KeyRange checkRange(KeyRangeRef(range.begin.withSuffix("_" + std::to_string(i)), range.begin.withSuffix("_" + std::to_string(i + 1))));
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->checkRange(cx, self, checkRange, true, true);
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1when1(__when_expr_5.get(), loopDepth); };
		static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 6;
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< UnblobbifyManyUnitActor, 5, Void >*>(static_cast<UnblobbifyManyUnitActor*>(this)));
															#line 17060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 788 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		i++;
															#line 17082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 788 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		i++;
															#line 17091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state > 0) static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<UnblobbifyManyUnitActor*>(this)->ActorCallback< UnblobbifyManyUnitActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnblobbifyManyUnitActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< UnblobbifyManyUnitActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< UnblobbifyManyUnitActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<UnblobbifyManyUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnblobbifyManyUnitActorState(); static_cast<UnblobbifyManyUnitActor*>(this)->destroy(); return 0; }
															#line 17175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<UnblobbifyManyUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnblobbifyManyUnitActorState();
		static_cast<UnblobbifyManyUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (!static_cast<UnblobbifyManyUnitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnblobbifyManyUnitActorState(); static_cast<UnblobbifyManyUnitActor*>(this)->destroy(); return 0; }
															#line 17187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		new (&static_cast<UnblobbifyManyUnitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnblobbifyManyUnitActorState();
		static_cast<UnblobbifyManyUnitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state > 0) static_cast<UnblobbifyManyUnitActor*>(this)->actor_wait_state = 0;
		static_cast<UnblobbifyManyUnitActor*>(this)->ActorCallback< UnblobbifyManyUnitActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnblobbifyManyUnitActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< UnblobbifyManyUnitActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< UnblobbifyManyUnitActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	int ranges;
															#line 755 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	int prefixToUnblobbify;
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	int i;
															#line 759 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange subRange;
															#line 773 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Key endKey;
															#line 778 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange unblobbifyRange;
															#line 780 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Key purgeKey;
															#line 17290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via unblobbifyManyUnit()
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class UnblobbifyManyUnitActor final : public Actor<Void>, public ActorCallback< UnblobbifyManyUnitActor, 0, bool >, public ActorCallback< UnblobbifyManyUnitActor, 1, Void >, public ActorCallback< UnblobbifyManyUnitActor, 2, Void >, public ActorCallback< UnblobbifyManyUnitActor, 3, Void >, public ActorCallback< UnblobbifyManyUnitActor, 4, bool >, public ActorCallback< UnblobbifyManyUnitActor, 5, Void >, public ActorCallback< UnblobbifyManyUnitActor, 6, Void >, public FastAllocated<UnblobbifyManyUnitActor>, public UnblobbifyManyUnitActorState<UnblobbifyManyUnitActor> {
															#line 17295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<UnblobbifyManyUnitActor>::operator new;
	using FastAllocated<UnblobbifyManyUnitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5740386287798409216UL, 5455061516945505792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UnblobbifyManyUnitActor, 0, bool >;
friend struct ActorCallback< UnblobbifyManyUnitActor, 1, Void >;
friend struct ActorCallback< UnblobbifyManyUnitActor, 2, Void >;
friend struct ActorCallback< UnblobbifyManyUnitActor, 3, Void >;
friend struct ActorCallback< UnblobbifyManyUnitActor, 4, bool >;
friend struct ActorCallback< UnblobbifyManyUnitActor, 5, Void >;
friend struct ActorCallback< UnblobbifyManyUnitActor, 6, Void >;
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	UnblobbifyManyUnitActor(Database const& cx,BlobGranuleRangesWorkload* const& self,KeyRange const& range) 
															#line 17318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   UnblobbifyManyUnitActorState<UnblobbifyManyUnitActor>(cx, self, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3578058949644222976UL, 17661157423926560256UL);
		ActorExecutionContextHelper __helper(static_cast<UnblobbifyManyUnitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("unblobbifyManyUnit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("unblobbifyManyUnit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UnblobbifyManyUnitActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UnblobbifyManyUnitActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UnblobbifyManyUnitActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UnblobbifyManyUnitActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< UnblobbifyManyUnitActor, 4, bool >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< UnblobbifyManyUnitActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< UnblobbifyManyUnitActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> unblobbifyManyUnit( Database const& cx, BlobGranuleRangesWorkload* const& self, KeyRange const& range ) {
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new UnblobbifyManyUnitActor(cx, self, range));
															#line 17356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 799 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"

	enum UnitTestTypes {
		VERIFY_RANGE_UNIT,
		VERIFY_RANGE_GAP_UNIT,
		RANGES_MISALIGNED,
		BLOBBIFY_IDEMPOTENT,
		RE_BLOBBIFY,
		ADJACENT_PURGE,
		BLOBBIFY_BLOCKING_UNIT,
		DELETE_TENANT_UNIT,
		UNBLOBBIFY_MANY_UNIT,
		OP_COUNT = 9 /* keep this last */
	};

																#line 17374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
// This generated class is to be used only via blobGranuleRangesUnitTests()
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
template <class BlobGranuleRangesUnitTestsActor>
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class BlobGranuleRangesUnitTestsActorState {
															#line 17380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesUnitTestsActorState(Database const& cx,BlobGranuleRangesWorkload* const& self) 
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		 : cx(cx),
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		   self(self)
															#line 17389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this));

	}
	~BlobGranuleRangesUnitTestsActorState() 
	{
		fdb_probe_actor_destroy("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 17404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				cx->internal = IsInternal::False;
															#line 17408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			}
															#line 817 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			;
															#line 17412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobGranuleRangesUnitTestsActorState();
		static_cast<BlobGranuleRangesUnitTestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 818 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (self->stopUnitClient)
															#line 17442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (!static_cast<BlobGranuleRangesUnitTestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobGranuleRangesUnitTestsActorState(); static_cast<BlobGranuleRangesUnitTestsActor*>(this)->destroy(); return 0; }
															#line 17446 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			new (&static_cast<BlobGranuleRangesUnitTestsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~BlobGranuleRangesUnitTestsActorState();
			static_cast<BlobGranuleRangesUnitTestsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 821 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		std::set<UnitTestTypes> excludedTypes;
															#line 822 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		excludedTypes.insert(OP_COUNT);
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		excludedTypes.insert(RE_BLOBBIFY);
															#line 827 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		std::string nextRangeKey = "U_" + self->newKey();
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		range = KeyRange(KeyRangeRef(StringRef(nextRangeKey), strinc(StringRef(nextRangeKey))));
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		int loopTries = 1000;
															#line 831 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		int op = OP_COUNT;
															#line 832 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		for(;;) {
															#line 833 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			op = deterministicRandom()->randomInt(0, OP_COUNT);
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (!excludedTypes.contains((UnitTestTypes)op))
															#line 17472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
				break;
			}
															#line 837 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			loopTries--;
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			ASSERT(loopTries >= 0);
															#line 17480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 840 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (BGRW_DEBUG)
															#line 17484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			fmt::print( "Selected range [{0} - {1}) for unit {2}.\n", range.begin.printable(), range.end.printable(), op);
															#line 17488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		}
															#line 845 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (op == VERIFY_RANGE_UNIT)
															#line 17492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		{
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->verifyRangeUnit(cx, self, range);
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 1;
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobGranuleRangesUnitTestsActor, 0, Void >*>(static_cast<BlobGranuleRangesUnitTestsActor*>(this)));
															#line 17503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 847 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
			if (op == VERIFY_RANGE_GAP_UNIT)
															#line 17510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
			{
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_1 = self->verifyRangeGapUnit(cx, self, range);
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 2;
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobGranuleRangesUnitTestsActor, 1, Void >*>(static_cast<BlobGranuleRangesUnitTestsActor*>(this)));
															#line 17521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
				if (op == RANGES_MISALIGNED)
															#line 17528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
				{
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_2 = self->rangesMisalignedUnit(cx, self, range);
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
					static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 3;
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobGranuleRangesUnitTestsActor, 2, Void >*>(static_cast<BlobGranuleRangesUnitTestsActor*>(this)));
															#line 17539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 851 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
					if (op == BLOBBIFY_IDEMPOTENT)
															#line 17546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
					{
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_3 = self->blobbifyIdempotentUnit(cx, self, range);
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
						if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
						static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 4;
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BlobGranuleRangesUnitTestsActor, 3, Void >*>(static_cast<BlobGranuleRangesUnitTestsActor*>(this)));
															#line 17557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 853 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
						if (op == RE_BLOBBIFY)
															#line 17564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
						{
															#line 854 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
							StrictFuture<Void> __when_expr_4 = self->reBlobbifyUnit(cx, self, range);
															#line 854 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
							if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
							if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.get(), loopDepth); };
							static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 5;
															#line 854 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
							__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BlobGranuleRangesUnitTestsActor, 4, Void >*>(static_cast<BlobGranuleRangesUnitTestsActor*>(this)));
															#line 17575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 855 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
							if (op == ADJACENT_PURGE)
															#line 17582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
							{
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
								StrictFuture<Void> __when_expr_5 = self->adjacentPurge(cx, self, range);
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
								if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
								if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when6(__when_expr_5.get(), loopDepth); };
								static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 6;
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
								__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BlobGranuleRangesUnitTestsActor, 5, Void >*>(static_cast<BlobGranuleRangesUnitTestsActor*>(this)));
															#line 17593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
								loopDepth = 0;
							}
							else
							{
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
								if (op == BLOBBIFY_BLOCKING_UNIT)
															#line 17600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
								{
															#line 858 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
									StrictFuture<Void> __when_expr_6 = self->blobbifyBlockingUnit(cx, self, range);
															#line 858 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
									if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
									if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when7(__when_expr_6.get(), loopDepth); };
									static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 7;
															#line 858 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
									__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< BlobGranuleRangesUnitTestsActor, 6, Void >*>(static_cast<BlobGranuleRangesUnitTestsActor*>(this)));
															#line 17611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
									loopDepth = 0;
								}
								else
								{
															#line 859 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
									if (op == DELETE_TENANT_UNIT)
															#line 17618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
									{
															#line 860 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
										StrictFuture<Void> __when_expr_7 = self->deleteTenantUnit(cx, self, range);
															#line 860 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
										if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
										if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when8(__when_expr_7.get(), loopDepth); };
										static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 8;
															#line 860 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
										__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< BlobGranuleRangesUnitTestsActor, 7, Void >*>(static_cast<BlobGranuleRangesUnitTestsActor*>(this)));
															#line 17629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
										loopDepth = 0;
									}
									else
									{
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
										if (op == UNBLOBBIFY_MANY_UNIT)
															#line 17636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
										{
															#line 862 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
											StrictFuture<Void> __when_expr_8 = self->unblobbifyManyUnit(cx, self, range);
															#line 862 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
											if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
											if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when9(__when_expr_8.get(), loopDepth); };
											static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 9;
															#line 862 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
											__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< BlobGranuleRangesUnitTestsActor, 8, Void >*>(static_cast<BlobGranuleRangesUnitTestsActor*>(this)));
															#line 17647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
											loopDepth = 0;
										}
										else
										{
															#line 864 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
											ASSERT(false);
															#line 17654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
											loopDepth = a_body1loopBody1cont21(loopDepth);
										}
									}
								}
							}
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_9 = delay(1.0);
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 10;
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< BlobGranuleRangesUnitTestsActor, 9, Void >*>(static_cast<BlobGranuleRangesUnitTestsActor*>(this)));
															#line 17679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state > 0) static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranuleRangesUnitTestsActor*>(this)->ActorCallback< BlobGranuleRangesUnitTestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobGranuleRangesUnitTestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state > 0) static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranuleRangesUnitTestsActor*>(this)->ActorCallback< BlobGranuleRangesUnitTestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BlobGranuleRangesUnitTestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state > 0) static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranuleRangesUnitTestsActor*>(this)->ActorCallback< BlobGranuleRangesUnitTestsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BlobGranuleRangesUnitTestsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state > 0) static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranuleRangesUnitTestsActor*>(this)->ActorCallback< BlobGranuleRangesUnitTestsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BlobGranuleRangesUnitTestsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont13(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state > 0) static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranuleRangesUnitTestsActor*>(this)->ActorCallback< BlobGranuleRangesUnitTestsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BlobGranuleRangesUnitTestsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont15(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont16(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont16(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state > 0) static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranuleRangesUnitTestsActor*>(this)->ActorCallback< BlobGranuleRangesUnitTestsActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< BlobGranuleRangesUnitTestsActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont17(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont18(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont18(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state > 0) static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranuleRangesUnitTestsActor*>(this)->ActorCallback< BlobGranuleRangesUnitTestsActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< BlobGranuleRangesUnitTestsActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont19(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont20(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont20(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont20(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont20(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state > 0) static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranuleRangesUnitTestsActor*>(this)->ActorCallback< BlobGranuleRangesUnitTestsActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< BlobGranuleRangesUnitTestsActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont21(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state > 0) static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranuleRangesUnitTestsActor*>(this)->ActorCallback< BlobGranuleRangesUnitTestsActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< BlobGranuleRangesUnitTestsActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1cont24(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont24(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state > 0) static_cast<BlobGranuleRangesUnitTestsActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranuleRangesUnitTestsActor*>(this)->ActorCallback< BlobGranuleRangesUnitTestsActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< BlobGranuleRangesUnitTestsActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< BlobGranuleRangesUnitTestsActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	Database cx;
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesWorkload* self;
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	KeyRange range;
															#line 18608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
};
// This generated class is to be used only via blobGranuleRangesUnitTests()
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
class BlobGranuleRangesUnitTestsActor final : public Actor<Void>, public ActorCallback< BlobGranuleRangesUnitTestsActor, 0, Void >, public ActorCallback< BlobGranuleRangesUnitTestsActor, 1, Void >, public ActorCallback< BlobGranuleRangesUnitTestsActor, 2, Void >, public ActorCallback< BlobGranuleRangesUnitTestsActor, 3, Void >, public ActorCallback< BlobGranuleRangesUnitTestsActor, 4, Void >, public ActorCallback< BlobGranuleRangesUnitTestsActor, 5, Void >, public ActorCallback< BlobGranuleRangesUnitTestsActor, 6, Void >, public ActorCallback< BlobGranuleRangesUnitTestsActor, 7, Void >, public ActorCallback< BlobGranuleRangesUnitTestsActor, 8, Void >, public ActorCallback< BlobGranuleRangesUnitTestsActor, 9, Void >, public FastAllocated<BlobGranuleRangesUnitTestsActor>, public BlobGranuleRangesUnitTestsActorState<BlobGranuleRangesUnitTestsActor> {
															#line 18613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
public:
	using FastAllocated<BlobGranuleRangesUnitTestsActor>::operator new;
	using FastAllocated<BlobGranuleRangesUnitTestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2158580669467883520UL, 6318374958768711936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobGranuleRangesUnitTestsActor, 0, Void >;
friend struct ActorCallback< BlobGranuleRangesUnitTestsActor, 1, Void >;
friend struct ActorCallback< BlobGranuleRangesUnitTestsActor, 2, Void >;
friend struct ActorCallback< BlobGranuleRangesUnitTestsActor, 3, Void >;
friend struct ActorCallback< BlobGranuleRangesUnitTestsActor, 4, Void >;
friend struct ActorCallback< BlobGranuleRangesUnitTestsActor, 5, Void >;
friend struct ActorCallback< BlobGranuleRangesUnitTestsActor, 6, Void >;
friend struct ActorCallback< BlobGranuleRangesUnitTestsActor, 7, Void >;
friend struct ActorCallback< BlobGranuleRangesUnitTestsActor, 8, Void >;
friend struct ActorCallback< BlobGranuleRangesUnitTestsActor, 9, Void >;
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	BlobGranuleRangesUnitTestsActor(Database const& cx,BlobGranuleRangesWorkload* const& self) 
															#line 18639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   BlobGranuleRangesUnitTestsActorState<BlobGranuleRangesUnitTestsActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18402995126173252096UL, 11628805371339425792UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranuleRangesUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("blobGranuleRangesUnitTests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("blobGranuleRangesUnitTests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobGranuleRangesUnitTestsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BlobGranuleRangesUnitTestsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BlobGranuleRangesUnitTestsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BlobGranuleRangesUnitTestsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< BlobGranuleRangesUnitTestsActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< BlobGranuleRangesUnitTestsActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< BlobGranuleRangesUnitTestsActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< BlobGranuleRangesUnitTestsActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< BlobGranuleRangesUnitTestsActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< BlobGranuleRangesUnitTestsActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
[[nodiscard]] Future<Void> blobGranuleRangesUnitTests( Database const& cx, BlobGranuleRangesWorkload* const& self ) {
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
	return Future<Void>(new BlobGranuleRangesUnitTestsActor(cx, self));
															#line 18680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BlobGranuleRangesWorkload.actor.g.cpp"
}

#line 870 "/Users/ec2-user/foundationdb/fdbserver/workloads/BlobGranuleRangesWorkload.actor.cpp"
};

WorkloadFactory<BlobGranuleRangesWorkload> BlobGranuleRangesWorkloadFactory;
