#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
/*
 * WaitFailure.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/FailureMonitor.h"
#include "flow/Deque.h"
#include "fdbserver/Knobs.h"
#include "flow/actorcompiler.h" // This must be the last #include.

															#line 28 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
namespace {
// This generated class is to be used only via waitFailureServer()
															#line 26 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
template <class WaitFailureServerActor>
															#line 26 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureServerActorState {
															#line 35 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
public:
															#line 26 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureServerActorState(FutureStream<ReplyPromise<Void>> const& waitFailure) 
															#line 26 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
															#line 26 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		 : waitFailure(waitFailure),
															#line 28 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   queue()
															#line 44 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
	{
		fdb_probe_actor_create("waitFailureServer", reinterpret_cast<unsigned long>(this));

	}
	~WaitFailureServerActorState() 
	{
		fdb_probe_actor_destroy("waitFailureServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 29 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			;
															#line 59 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitFailureServerActorState();
		static_cast<WaitFailureServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 30 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		FutureStream<ReplyPromise<Void>> __when_expr_0 = waitFailure;
															#line 30 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (static_cast<WaitFailureServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 91 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<WaitFailureServerActor*>(this)->actor_wait_state = 1;
															#line 30 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >*>(static_cast<WaitFailureServerActor*>(this)));
															#line 96 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(ReplyPromise<Void> const& P,int loopDepth) 
	{
															#line 31 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		queue.push_back(P);
															#line 32 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (queue.size() > SERVER_KNOBS->MAX_OUTSTANDING_WAIT_FAILURE_REQUESTS)
															#line 107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		{
															#line 33 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			CODE_PROBE(true, "wait server queue full");
															#line 34 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			queue.front().send(Void());
															#line 35 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			queue.pop_front();
															#line 115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(ReplyPromise<Void> && P,int loopDepth) 
	{
															#line 31 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		queue.push_back(P);
															#line 32 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (queue.size() > SERVER_KNOBS->MAX_OUTSTANDING_WAIT_FAILURE_REQUESTS)
															#line 127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		{
															#line 33 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			CODE_PROBE(true, "wait server queue full");
															#line 34 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			queue.front().send(Void());
															#line 35 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			queue.pop_front();
															#line 135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ReplyPromise<Void> const& P,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(P, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ReplyPromise<Void> && P,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(P), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitFailureServerActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureServerActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureServerActor*>(this)->ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >::remove();

	}
	void a_callback_fire(ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >*,ReplyPromise<Void> const& value) 
	{
		fdb_probe_actor_enter("waitFailureServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >*,ReplyPromise<Void> && value) 
	{
		fdb_probe_actor_enter("waitFailureServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureServer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 26 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	FutureStream<ReplyPromise<Void>> waitFailure;
															#line 28 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	Deque<ReplyPromise<Void>> queue;
															#line 220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
};
// This generated class is to be used only via waitFailureServer()
															#line 26 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureServerActor final : public Actor<Void>, public ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >, public FastAllocated<WaitFailureServerActor>, public WaitFailureServerActorState<WaitFailureServerActor> {
															#line 225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
public:
	using FastAllocated<WaitFailureServerActor>::operator new;
	using FastAllocated<WaitFailureServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17549614392454571520UL, 12533165950264681472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >;
															#line 26 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureServerActor(FutureStream<ReplyPromise<Void>> const& waitFailure) 
															#line 242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		 : Actor<Void>(),
		   WaitFailureServerActorState<WaitFailureServerActor>(waitFailure),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitFailureServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7425974089644435456UL, 13829823827853307392UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitFailureServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitFailureServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 26 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
[[nodiscard]] Future<Void> waitFailureServer( FutureStream<ReplyPromise<Void>> const& waitFailure ) {
															#line 26 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	return Future<Void>(new WaitFailureServerActor(waitFailure));
															#line 275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
}

#line 39 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"

															#line 280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
namespace {
// This generated class is to be used only via waitFailureClient()
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
template <class WaitFailureClientActor>
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureClientActorState {
															#line 287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
public:
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureClientActorState(RequestStream<ReplyPromise<Void>> const& waitFailure,double const& reactionTime,double const& reactionSlope,bool const& trace,TaskPriority const& taskID) 
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		 : waitFailure(waitFailure),
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   reactionTime(reactionTime),
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   reactionSlope(reactionSlope),
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   trace(trace),
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   taskID(taskID)
															#line 302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
	{
		fdb_probe_actor_create("waitFailureClient", reinterpret_cast<unsigned long>(this));

	}
	~WaitFailureClientActorState() 
	{
		fdb_probe_actor_destroy("waitFailureClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 45 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			;
															#line 317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitFailureClientActorState();
		static_cast<WaitFailureClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			start = now();
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			StrictFuture<ErrorOr<Void>> __when_expr_0 = waitFailure.getReplyUnlessFailedFor(ReplyPromise<Void>(), reactionTime, reactionSlope, taskID);
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (static_cast<WaitFailureClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitFailureClientActor*>(this)->actor_wait_state = 1;
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >*>(static_cast<WaitFailureClientActor*>(this)));
															#line 357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			{
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			}
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			TraceEvent(SevError, "WaitFailureClientError").error(e);
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			ASSERT(false);
															#line 389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(ErrorOr<Void> const& x,int loopDepth) 
	{
															#line 50 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (!x.present())
															#line 404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		{
															#line 51 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (trace)
															#line 408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			{
															#line 52 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				TraceEvent("WaitFailureClient") .detail("FailedEndpoint", waitFailure.getEndpoint().getPrimaryAddress().toString()) .detail("Token", waitFailure.getEndpoint().token);
															#line 412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			}
															#line 56 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (!static_cast<WaitFailureClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitFailureClientActorState(); static_cast<WaitFailureClientActor*>(this)->destroy(); return 0; }
															#line 416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			new (&static_cast<WaitFailureClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitFailureClientActorState();
			static_cast<WaitFailureClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		double w = start + SERVER_KNOBS->WAIT_FAILURE_DELAY_LIMIT - now();
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (w > 0)
															#line 426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		{
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(w, taskID);
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (static_cast<WaitFailureClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitFailureClientActor*>(this)->actor_wait_state = 2;
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitFailureClientActor, 1, Void >*>(static_cast<WaitFailureClientActor*>(this)));
															#line 437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(ErrorOr<Void> && x,int loopDepth) 
	{
															#line 50 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (!x.present())
															#line 451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		{
															#line 51 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (trace)
															#line 455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			{
															#line 52 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				TraceEvent("WaitFailureClient") .detail("FailedEndpoint", waitFailure.getEndpoint().getPrimaryAddress().toString()) .detail("Token", waitFailure.getEndpoint().token);
															#line 459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			}
															#line 56 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (!static_cast<WaitFailureClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitFailureClientActorState(); static_cast<WaitFailureClientActor*>(this)->destroy(); return 0; }
															#line 463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			new (&static_cast<WaitFailureClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitFailureClientActorState();
			static_cast<WaitFailureClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		double w = start + SERVER_KNOBS->WAIT_FAILURE_DELAY_LIMIT - now();
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (w > 0)
															#line 473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		{
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(w, taskID);
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (static_cast<WaitFailureClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitFailureClientActor*>(this)->actor_wait_state = 2;
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitFailureClientActor, 1, Void >*>(static_cast<WaitFailureClientActor*>(this)));
															#line 484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Void> const& x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(x, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Void> && x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(x), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitFailureClientActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureClientActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureClientActor*>(this)->ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("waitFailureClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("waitFailureClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitFailureClientActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureClientActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureClientActor*>(this)->ActorCallback< WaitFailureClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFailureClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitFailureClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitFailureClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitFailureClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitFailureClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	RequestStream<ReplyPromise<Void>> waitFailure;
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	double reactionTime;
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	double reactionSlope;
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	bool trace;
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	TaskPriority taskID;
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	double start;
															#line 687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
};
// This generated class is to be used only via waitFailureClient()
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureClientActor final : public Actor<Void>, public ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >, public ActorCallback< WaitFailureClientActor, 1, Void >, public FastAllocated<WaitFailureClientActor>, public WaitFailureClientActorState<WaitFailureClientActor> {
															#line 692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
public:
	using FastAllocated<WaitFailureClientActor>::operator new;
	using FastAllocated<WaitFailureClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13713118325729489664UL, 11781604210461765120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >;
friend struct ActorCallback< WaitFailureClientActor, 1, Void >;
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureClientActor(RequestStream<ReplyPromise<Void>> const& waitFailure,double const& reactionTime,double const& reactionSlope,bool const& trace,TaskPriority const& taskID) 
															#line 710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		 : Actor<Void>(),
		   WaitFailureClientActorState<WaitFailureClientActor>(waitFailure, reactionTime, reactionSlope, trace, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitFailureClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16988761196834749184UL, 15110614678624696832UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitFailureClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitFailureClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitFailureClientActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
[[nodiscard]] Future<Void> waitFailureClient( RequestStream<ReplyPromise<Void>> const& waitFailure, double const& reactionTime, double const& reactionSlope, bool const& trace, TaskPriority const& taskID ) {
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	return Future<Void>(new WaitFailureClientActor(waitFailure, reactionTime, reactionSlope, trace, taskID));
															#line 744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
}

#line 69 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"

															#line 749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
namespace {
// This generated class is to be used only via waitFailureClientStrict()
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
template <class WaitFailureClientStrictActor>
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureClientStrictActorState {
															#line 756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
public:
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureClientStrictActorState(RequestStream<ReplyPromise<Void>> const& waitFailure,double const& failureReactionTime,TaskPriority const& taskID) 
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		 : waitFailure(waitFailure),
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   failureReactionTime(failureReactionTime),
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   taskID(taskID)
															#line 767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
	{
		fdb_probe_actor_create("waitFailureClientStrict", reinterpret_cast<unsigned long>(this));

	}
	~WaitFailureClientStrictActorState() 
	{
		fdb_probe_actor_destroy("waitFailureClientStrict", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			;
															#line 782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitFailureClientStrictActorState();
		static_cast<WaitFailureClientStrictActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitFailureClient(waitFailure, 0, 0, false, taskID);
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state = 1;
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitFailureClientStrictActor, 0, Void >*>(static_cast<WaitFailureClientStrictActor*>(this)));
															#line 819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(failureReactionTime, taskID) || IFailureMonitor::failureMonitor().onStateEqual(waitFailure.getEndpoint(), FailureStatus(false));
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state = 2;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitFailureClientStrictActor, 1, Void >*>(static_cast<WaitFailureClientStrictActor*>(this)));
															#line 835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(failureReactionTime, taskID) || IFailureMonitor::failureMonitor().onStateEqual(waitFailure.getEndpoint(), FailureStatus(false));
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state = 2;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitFailureClientStrictActor, 1, Void >*>(static_cast<WaitFailureClientStrictActor*>(this)));
															#line 851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureClientStrictActor*>(this)->ActorCallback< WaitFailureClientStrictActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFailureClientStrictActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientStrictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitFailureClientStrictActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientStrictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitFailureClientStrictActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientStrictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(waitFailure.getEndpoint()).isFailed())
															#line 935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		{
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (!static_cast<WaitFailureClientStrictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitFailureClientStrictActorState(); static_cast<WaitFailureClientStrictActor*>(this)->destroy(); return 0; }
															#line 939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			new (&static_cast<WaitFailureClientStrictActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitFailureClientStrictActorState();
			static_cast<WaitFailureClientStrictActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(waitFailure.getEndpoint()).isFailed())
															#line 953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		{
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (!static_cast<WaitFailureClientStrictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitFailureClientStrictActorState(); static_cast<WaitFailureClientStrictActor*>(this)->destroy(); return 0; }
															#line 957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			new (&static_cast<WaitFailureClientStrictActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitFailureClientStrictActorState();
			static_cast<WaitFailureClientStrictActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureClientStrictActor*>(this)->ActorCallback< WaitFailureClientStrictActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFailureClientStrictActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientStrictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitFailureClientStrictActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientStrictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitFailureClientStrictActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientStrictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	RequestStream<ReplyPromise<Void>> waitFailure;
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	double failureReactionTime;
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	TaskPriority taskID;
															#line 1048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
};
// This generated class is to be used only via waitFailureClientStrict()
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureClientStrictActor final : public Actor<Void>, public ActorCallback< WaitFailureClientStrictActor, 0, Void >, public ActorCallback< WaitFailureClientStrictActor, 1, Void >, public FastAllocated<WaitFailureClientStrictActor>, public WaitFailureClientStrictActorState<WaitFailureClientStrictActor> {
															#line 1053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
public:
	using FastAllocated<WaitFailureClientStrictActor>::operator new;
	using FastAllocated<WaitFailureClientStrictActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1368825543786303744UL, 8961759785646841088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitFailureClientStrictActor, 0, Void >;
friend struct ActorCallback< WaitFailureClientStrictActor, 1, Void >;
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureClientStrictActor(RequestStream<ReplyPromise<Void>> const& waitFailure,double const& failureReactionTime,TaskPriority const& taskID) 
															#line 1071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		 : Actor<Void>(),
		   WaitFailureClientStrictActorState<WaitFailureClientStrictActor>(waitFailure, failureReactionTime, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12373665344169346048UL, 6112124518788876288UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientStrictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitFailureClientStrict");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitFailureClientStrictActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitFailureClientStrictActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
[[nodiscard]] Future<Void> waitFailureClientStrict( RequestStream<ReplyPromise<Void>> const& waitFailure, double const& failureReactionTime, TaskPriority const& taskID ) {
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	return Future<Void>(new WaitFailureClientStrictActor(waitFailure, failureReactionTime, taskID));
															#line 1105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
}

#line 82 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"

															#line 1110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
namespace {
// This generated class is to be used only via waitFailureTracker()
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
template <class WaitFailureTrackerActor>
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureTrackerActorState {
															#line 1117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
public:
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureTrackerActorState(RequestStream<ReplyPromise<Void>> const& waitFailure,Reference<AsyncVar<bool>> const& failed,double const& reactionTime,double const& reactionSlope,TaskPriority const& taskID) 
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		 : waitFailure(waitFailure),
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   failed(failed),
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   reactionTime(reactionTime),
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   reactionSlope(reactionSlope),
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   taskID(taskID)
															#line 1132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
	{
		fdb_probe_actor_create("waitFailureTracker", reinterpret_cast<unsigned long>(this));

	}
	~WaitFailureTrackerActorState() 
	{
		fdb_probe_actor_destroy("waitFailureTracker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			;
															#line 1147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitFailureTrackerActorState();
		static_cast<WaitFailureTrackerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			failed->set(IFailureMonitor::failureMonitor().getState(waitFailure.getEndpoint()).isFailed());
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (failed->get())
															#line 1180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			{
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				StrictFuture<Void> __when_expr_0 = IFailureMonitor::failureMonitor().onStateChanged(waitFailure.getEndpoint());
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				if (static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state = 1;
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitFailureTrackerActor, 0, Void >*>(static_cast<WaitFailureTrackerActor*>(this)));
															#line 1191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				start = now();
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				StrictFuture<ErrorOr<Void>> __when_expr_1 = waitFailure.getReplyUnlessFailedFor(ReplyPromise<Void>(), reactionTime, reactionSlope, taskID);
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				if (static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state = 2;
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >*>(static_cast<WaitFailureTrackerActor*>(this)));
															#line 1207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			{
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			}
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			TraceEvent(SevError, "WaitFailureClientError").error(e);
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			ASSERT(false);
															#line 1240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureTrackerActor*>(this)->ActorCallback< WaitFailureTrackerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFailureTrackerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitFailureTrackerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitFailureTrackerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(ErrorOr<Void> const& x,int loopDepth) 
	{
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (x.present())
															#line 1348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		{
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			double w = start + SERVER_KNOBS->WAIT_FAILURE_DELAY_LIMIT - now();
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (w > 0)
															#line 1354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			{
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				StrictFuture<Void> __when_expr_2 = delay(w, taskID);
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				if (static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
				static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state = 3;
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitFailureTrackerActor, 2, Void >*>(static_cast<WaitFailureTrackerActor*>(this)));
															#line 1365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(ErrorOr<Void> && x,int loopDepth) 
	{
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (x.present())
															#line 1384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		{
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			double w = start + SERVER_KNOBS->WAIT_FAILURE_DELAY_LIMIT - now();
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (w > 0)
															#line 1390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
			{
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				StrictFuture<Void> __when_expr_2 = delay(w, taskID);
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				if (static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
				static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state = 3;
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitFailureTrackerActor, 2, Void >*>(static_cast<WaitFailureTrackerActor*>(this)));
															#line 1401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(ErrorOr<Void> const& x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(x, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ErrorOr<Void> && x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(x), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureTrackerActor*>(this)->ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureTrackerActor*>(this)->ActorCallback< WaitFailureTrackerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFailureTrackerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitFailureTrackerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitFailureTrackerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	RequestStream<ReplyPromise<Void>> waitFailure;
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	Reference<AsyncVar<bool>> failed;
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	double reactionTime;
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	double reactionSlope;
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	TaskPriority taskID;
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	double start;
															#line 1615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
};
// This generated class is to be used only via waitFailureTracker()
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureTrackerActor final : public Actor<Void>, public ActorCallback< WaitFailureTrackerActor, 0, Void >, public ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >, public ActorCallback< WaitFailureTrackerActor, 2, Void >, public FastAllocated<WaitFailureTrackerActor>, public WaitFailureTrackerActorState<WaitFailureTrackerActor> {
															#line 1620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
public:
	using FastAllocated<WaitFailureTrackerActor>::operator new;
	using FastAllocated<WaitFailureTrackerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13794198102897159936UL, 5111412499569353728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitFailureTrackerActor, 0, Void >;
friend struct ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >;
friend struct ActorCallback< WaitFailureTrackerActor, 2, Void >;
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureTrackerActor(RequestStream<ReplyPromise<Void>> const& waitFailure,Reference<AsyncVar<bool>> const& failed,double const& reactionTime,double const& reactionSlope,TaskPriority const& taskID) 
															#line 1639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
		 : Actor<Void>(),
		   WaitFailureTrackerActorState<WaitFailureTrackerActor>(waitFailure, failed, reactionTime, reactionSlope, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17684403957785554432UL, 7288679679853281280UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitFailureTracker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitFailureTrackerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitFailureTrackerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
[[nodiscard]] Future<Void> waitFailureTracker( RequestStream<ReplyPromise<Void>> const& waitFailure, Reference<AsyncVar<bool>> const& failed, double const& reactionTime, double const& reactionSlope, TaskPriority const& taskID ) {
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
	return Future<Void>(new WaitFailureTrackerActor(waitFailure, failed, reactionTime, reactionSlope, taskID));
															#line 1674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/WaitFailure.actor.g.cpp"
}

#line 111 "/Users/ec2-user/foundationdb/fdbserver/WaitFailure.actor.cpp"
