#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
/*
 * TestTLogServer.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/TestTLogServer.actor.h"

#include <filesystem>
#include <vector>

#include "fdbrpc/Locality.h"
#include "fdbrpc/ReplicationPolicy.h"
#include "fdbserver/TLogInterface.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/IDiskQueue.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/Knobs.h"
#include "flow/IRandom.h"
#include "flow/DebugTrace.h"

#include "flow/actorcompiler.h" // must be last include

Reference<TLogTestContext> initTLogTestContext(TestTLogOptions tLogOptions,
                                               Optional<Reference<TLogTestContext>> oldTLogTestContext) {
	Reference<TLogTestContext> context(new TLogTestContext(tLogOptions));
	context->logID = deterministicRandom()->randomUniqueID();
	context->workerID = deterministicRandom()->randomUniqueID();
	context->diskQueueBasename = tLogOptions.diskQueueBasename;
	context->numCommits = tLogOptions.numCommits;
	context->numTags = tLogOptions.numTags;
	context->numLogServers = tLogOptions.numLogServers;
	context->dcID = "test"_sr;
	context->tagLocality = context->primaryLocality;
	context->dbInfo = ServerDBInfo();
	if (oldTLogTestContext.present()) {
		OldTLogConf oldTLogConf;
		oldTLogConf.tLogs = oldTLogTestContext.get()->dbInfo.logSystemConfig.tLogs;
		for (uint32_t i = 0; i < context->numLogServers; i++) {
			oldTLogConf.tLogs[i].locality = oldTLogTestContext.get()->primaryLocality;
			oldTLogConf.tLogs[i].isLocal = true;
		}
		oldTLogConf.epochBegin = oldTLogTestContext.get()->initVersion;
		oldTLogConf.epochEnd = oldTLogTestContext.get()->numCommits;
		oldTLogConf.logRouterTags = 0;
		oldTLogConf.recoverAt = oldTLogTestContext.get()->initVersion;
		oldTLogConf.epoch = oldTLogTestContext.get()->epoch;
		context->tagLocality = oldTLogTestContext.get()->primaryLocality;
		context->epoch = oldTLogTestContext.get()->epoch + 1;
		context->dbInfo.logSystemConfig.oldTLogs.push_back(oldTLogConf);
		context->commitHistory = oldTLogTestContext.get()->commitHistory;
	}
	context->dbInfo.logSystemConfig.logSystemType = LogSystemType::tagPartitioned;
	context->dbInfo.logSystemConfig.recruitmentID = deterministicRandom()->randomUniqueID();
	context->initVersion = tLogOptions.initVersion;
	context->recover = tLogOptions.recover;
	context->dbInfoRef = makeReference<AsyncVar<ServerDBInfo>>(context->dbInfo);

	return context;
}

// Create and start a tLog. If optional parmeters are set, the tLog is a new generation of "tLogID"
// as described by initReq. Otherwise, it is a newborn generation 0 tLog.
															#line 81 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
namespace {
// This generated class is to be used only via getTLogCreateActor()
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
template <class GetTLogCreateActorActor>
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class GetTLogCreateActorActorState {
															#line 88 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
public:
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	GetTLogCreateActorActorState(Reference<TLogTestContext> const& pTLogTestContext,TestTLogOptions const& tLogOptions,uint16_t const& processID,InitializeTLogRequest* const& initReq = nullptr,UID const& tLogID = UID()) 
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		 : pTLogTestContext(pTLogTestContext),
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   tLogOptions(tLogOptions),
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   processID(processID),
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   initReq(initReq),
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   tLogID(tLogID),
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   pTLogContext(pTLogTestContext->pTLogContextList[processID])
															#line 105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
	{
		fdb_probe_actor_create("getTLogCreateActor", reinterpret_cast<unsigned long>(this));

	}
	~GetTLogCreateActorActorState() 
	{
		fdb_probe_actor_destroy("getTLogCreateActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogContext->tagProcessID = processID;
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogContext->tLogID = tLogID != UID(0, 0) ? tLogID : deterministicRandom()->randomUniqueID();
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			TraceEvent("TestTLogServerEnterGetTLogCreateActor", pTLogContext->tLogID).detail("Epoch", pTLogTestContext->epoch);
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			std::filesystem::create_directory(tLogOptions.dataFolder);
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			std::string diskQueueBasename = pTLogTestContext->diskQueueBasename + "." + pTLogContext->tLogID.toString() + "." + std::to_string(pTLogTestContext->epoch) + ".";
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			diskQueueFilename = tLogOptions.dataFolder + "/" + diskQueueBasename;
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogContext->persistentQueue = openDiskQueue(diskQueueFilename, tLogOptions.diskQueueExtension, pTLogContext->tLogID, DiskQueueVersion::V2);
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			kvStoreFilename = tLogOptions.dataFolder + "/" + tLogOptions.kvStoreFilename + "." + pTLogContext->tLogID.toString() + "." + std::to_string(pTLogTestContext->epoch) + ".";
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogContext->persistentData = keyValueStoreMemory(kvStoreFilename, pTLogContext->tLogID, tLogOptions.kvMemoryLimit, tLogOptions.kvStoreExtension, KeyValueStoreType::MEMORY_RADIXTREE);
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Standalone<StringRef> machineID = "machine"_sr;
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			LocalityData localities( Optional<Standalone<StringRef>>(), pTLogTestContext->zoneID, machineID, pTLogTestContext->dcID);
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			localities.set(StringRef("datacenter"_sr), pTLogTestContext->dcID);
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Reference<AsyncVar<bool>> isDegraded = FlowTransport::transport().getDegraded();
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Reference<AsyncVar<UID>> activeSharedTLog(new AsyncVar<UID>(pTLogContext->tLogID));
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck(new AsyncVar<bool>(false));
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			promiseStream = PromiseStream<InitializeTLogRequest>();
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Promise<Void> oldLog;
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Promise<Void> recovery;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tl = ::tLog(pTLogContext->persistentData, pTLogContext->persistentQueue, pTLogTestContext->dbInfoRef, localities, promiseStream, pTLogContext->tLogID, pTLogTestContext->workerID, false, oldLog, recovery, pTLogTestContext->diskQueueBasename, isDegraded, activeSharedTLog, enablePrimaryTxnSystemHealthCheck);
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			initTLogReq = InitializeTLogRequest();
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (initReq != nullptr)
															#line 160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			{
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				initTLogReq = *initReq;
															#line 164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			}
			else
			{
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				std::vector<Tag> tags;
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				for(uint32_t tagID = 0;tagID < pTLogTestContext->numTags;tagID++) {
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
					Tag tag(pTLogTestContext->tagLocality, tagID);
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
					tags.push_back(tag);
															#line 176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
				}
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				initTLogReq.epoch = 1;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				initTLogReq.allTags = tags;
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				initTLogReq.isPrimary = true;
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				initTLogReq.locality = pTLogTestContext->primaryLocality;
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				initTLogReq.recoveryTransactionVersion = pTLogTestContext->initVersion;
															#line 188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			}
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<TLogInterface> __when_expr_0 = promiseStream.getReply(initTLogReq);
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state = 1;
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >*>(static_cast<GetTLogCreateActorActor*>(this)));
															#line 199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTLogCreateActorActorState();
		static_cast<GetTLogCreateActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TLogInterface const& interface,int loopDepth) 
	{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->TestTLogInterface = interface;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->init = promiseStream;
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->TLogCreated.send(true);
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerInitializedTLog", pTLogContext->tLogID);
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tl;
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<bool> __when_expr_2 = pTLogContext->TestTLogServerCompleted.getFuture();
															#line 236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state = 2;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTLogCreateActorActor, 1, Void >*>(static_cast<GetTLogCreateActorActor*>(this)));
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetTLogCreateActorActor, 2, bool >*>(static_cast<GetTLogCreateActorActor*>(this)));
															#line 243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TLogInterface && interface,int loopDepth) 
	{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->TestTLogInterface = interface;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->init = promiseStream;
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->TLogCreated.send(true);
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerInitializedTLog", pTLogContext->tLogID);
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tl;
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<bool> __when_expr_2 = pTLogContext->TestTLogServerCompleted.getFuture();
															#line 266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state = 2;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTLogCreateActorActor, 1, Void >*>(static_cast<GetTLogCreateActorActor*>(this)));
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetTLogCreateActorActor, 2, bool >*>(static_cast<GetTLogCreateActorActor*>(this)));
															#line 273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(TLogInterface const& interface,int loopDepth) 
	{
		loopDepth = a_body1cont1(interface, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TLogInterface && interface,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(interface), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state > 0) static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetTLogCreateActorActor*>(this)->ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >::remove();

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >*,TLogInterface const& value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >*,TLogInterface && value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state = 3;
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetTLogCreateActorActor, 3, Void >*>(static_cast<GetTLogCreateActorActor*>(this)));
															#line 364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(bool const& testCompleted,int loopDepth) 
	{
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(testCompleted, true);
															#line 385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(bool && testCompleted,int loopDepth) 
	{
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(testCompleted, true);
															#line 394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state > 0) static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetTLogCreateActorActor*>(this)->ActorCallback< GetTLogCreateActorActor, 1, Void >::remove();
		static_cast<GetTLogCreateActorActor*>(this)->ActorCallback< GetTLogCreateActorActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTLogCreateActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetTLogCreateActorActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		deleteFile(diskQueueFilename + "0." + tLogOptions.diskQueueExtension);
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		deleteFile(diskQueueFilename + "1." + tLogOptions.diskQueueExtension);
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		deleteFile(kvStoreFilename + "0." + tLogOptions.kvStoreExtension);
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		deleteFile(kvStoreFilename + "1." + tLogOptions.kvStoreExtension);
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!static_cast<GetTLogCreateActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTLogCreateActorActorState(); static_cast<GetTLogCreateActorActor*>(this)->destroy(); return 0; }
															#line 532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		new (&static_cast<GetTLogCreateActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTLogCreateActorActorState();
		static_cast<GetTLogCreateActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		deleteFile(diskQueueFilename + "0." + tLogOptions.diskQueueExtension);
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		deleteFile(diskQueueFilename + "1." + tLogOptions.diskQueueExtension);
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		deleteFile(kvStoreFilename + "0." + tLogOptions.kvStoreExtension);
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		deleteFile(kvStoreFilename + "1." + tLogOptions.kvStoreExtension);
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!static_cast<GetTLogCreateActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTLogCreateActorActorState(); static_cast<GetTLogCreateActorActor*>(this)->destroy(); return 0; }
															#line 552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		new (&static_cast<GetTLogCreateActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTLogCreateActorActorState();
		static_cast<GetTLogCreateActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state > 0) static_cast<GetTLogCreateActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetTLogCreateActorActor*>(this)->ActorCallback< GetTLogCreateActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetTLogCreateActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetTLogCreateActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogTestContext> pTLogTestContext;
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TestTLogOptions tLogOptions;
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint16_t processID;
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	InitializeTLogRequest* initReq;
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	UID tLogID;
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogContext> pTLogContext;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	std::string diskQueueFilename;
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	std::string kvStoreFilename;
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	PromiseStream<InitializeTLogRequest> promiseStream;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Future<Void> tl;
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	InitializeTLogRequest initTLogReq;
															#line 657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
};
// This generated class is to be used only via getTLogCreateActor()
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class GetTLogCreateActorActor final : public Actor<Void>, public ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >, public ActorCallback< GetTLogCreateActorActor, 1, Void >, public ActorCallback< GetTLogCreateActorActor, 2, bool >, public ActorCallback< GetTLogCreateActorActor, 3, Void >, public FastAllocated<GetTLogCreateActorActor>, public GetTLogCreateActorActorState<GetTLogCreateActorActor> {
															#line 662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
public:
	using FastAllocated<GetTLogCreateActorActor>::operator new;
	using FastAllocated<GetTLogCreateActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15836195023508702464UL, 7941962149968386048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >;
friend struct ActorCallback< GetTLogCreateActorActor, 1, Void >;
friend struct ActorCallback< GetTLogCreateActorActor, 2, bool >;
friend struct ActorCallback< GetTLogCreateActorActor, 3, Void >;
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	GetTLogCreateActorActor(Reference<TLogTestContext> const& pTLogTestContext,TestTLogOptions const& tLogOptions,uint16_t const& processID,InitializeTLogRequest* const& initReq = nullptr,UID const& tLogID = UID()) 
															#line 682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		 : Actor<Void>(),
		   GetTLogCreateActorActorState<GetTLogCreateActorActor>(pTLogTestContext, tLogOptions, processID, initReq, tLogID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTLogCreateActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3521649769377054720UL, 8142649606987485952UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogCreateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTLogCreateActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTLogCreateActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTLogCreateActorActor, 0, TLogInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTLogCreateActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetTLogCreateActorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
[[nodiscard]] Future<Void> getTLogCreateActor( Reference<TLogTestContext> const& pTLogTestContext, TestTLogOptions const& tLogOptions, uint16_t const& processID, InitializeTLogRequest* const& initReq = nullptr, UID const& tLogID = UID() ) {
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	return Future<Void>(new GetTLogCreateActorActor(pTLogTestContext, tLogOptions, processID, initReq, tLogID));
															#line 717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
}

#line 183 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"

															#line 722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
// This generated class is to be used only via sendPushMessages()
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
template <class TLogTestContext_SendPushMessagesActor>
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class TLogTestContext_SendPushMessagesActorState {
															#line 728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
public:
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TLogTestContext_SendPushMessagesActorState(TLogTestContext* const& pTLogTestContext) 
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		 : pTLogTestContext(pTLogTestContext)
															#line 735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
	{
		fdb_probe_actor_create("sendPushMessages", reinterpret_cast<unsigned long>(this));

	}
	~TLogTestContext_SendPushMessagesActorState() 
	{
		fdb_probe_actor_destroy("sendPushMessages", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			TraceEvent("TestTLogServerEnterPush", pTLogTestContext->workerID);
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			logID = 0;
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			;
															#line 754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TLogTestContext_SendPushMessagesActorState();
		static_cast<TLogTestContext_SendPushMessagesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		i = 0;
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		prev = pTLogTestContext->initVersion - 1;
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		next = pTLogTestContext->initVersion;
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		;
															#line 783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!(logID < pTLogTestContext->numLogServers))
															#line 799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext = pTLogTestContext->pTLogContextList[logID];
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<bool> __when_expr_0 = pTLogContext->TLogStarted.getFuture();
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state = 1;
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >*>(static_cast<TLogTestContext_SendPushMessagesActor*>(this)));
															#line 814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& tLogReady,int loopDepth) 
	{
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(tLogReady, true);
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		logID++;
															#line 838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && tLogReady,int loopDepth) 
	{
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(tLogReady, true);
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		logID++;
															#line 849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& tLogReady,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(tLogReady, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && tLogReady,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(tLogReady), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogTestContext_SendPushMessagesActor*>(this)->ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("sendPushMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_SendPushMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendPushMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("sendPushMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_SendPushMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendPushMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("sendPushMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_SendPushMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendPushMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerExitPush", pTLogTestContext->workerID) .detail("NumVersions", pTLogTestContext->tLogOptions.versions.size());
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!static_cast<TLogTestContext_SendPushMessagesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogTestContext_SendPushMessagesActorState(); static_cast<TLogTestContext_SendPushMessagesActor*>(this)->destroy(); return 0; }
															#line 935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		new (&static_cast<TLogTestContext_SendPushMessagesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TLogTestContext_SendPushMessagesActorState();
		static_cast<TLogTestContext_SendPushMessagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!(i < pTLogTestContext->numCommits))
															#line 954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Standalone<StringRef> key = StringRef(format("key %d", i));
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Standalone<StringRef> val = StringRef(format("value %d", i));
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		MutationRef m(MutationRef::Type::SetValue, key, val);
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		LogPushData toCommit(pTLogTestContext->ls, pTLogTestContext->numLogServers);
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		toCommit.addTransactionInfo(SpanContext());
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		std::unordered_map<uint16_t, Version> tpcvMap;
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		uint32_t replicaCount = pTLogTestContext->tLogOptions.replicaCount;
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		uint32_t startLogServer = 0;
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		uint32_t teamSize = pTLogTestContext->numLogServers / replicaCount;
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		for(uint32_t tagID = 0;tagID < pTLogTestContext->numTags;tagID++, startLogServer++) {
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			for(uint32_t logServer = startLogServer;logServer < pTLogTestContext->numLogServers;logServer += teamSize) {
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				Tag tag(pTLogTestContext->tagLocality, tagID);
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				std::vector<Tag> tags = { tag };
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				toCommit.addTags(tags);
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				toCommit.writeTypedMessage(m, false, true);
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				tpcvMap[logServer] = prev;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				pTLogTestContext->commitHistory[std::tuple(tagID, logServer)].push_back(next);
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				TraceEvent("AddTags").detail("C", i).detail("T", tag).detail("L", logServer).detail("N", next);
															#line 994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			}
		}
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (toCommit.getMutationCount())
															#line 999 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			const auto versionSet = ILogSystem::PushVersionSet{ prev, next, prev, prev };
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Future<Version> loggingComplete = pTLogTestContext->ls->push(versionSet, toCommit, SpanContext(), UID(), tpcvMap);
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<Version> __when_expr_1 = loggingComplete;
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state = 2;
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >*>(static_cast<TLogTestContext_SendPushMessagesActor*>(this)));
															#line 1014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		prev = next;
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogTestContext->tLogOptions.versions.push_back(next);
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		next += SERVER_KNOBS->VERSIONS_PER_SECOND + deterministicRandom()->randomInt(0, 20);
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		i++;
															#line 1047 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Version const& ver,int loopDepth) 
	{
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_LE(ver, next);
															#line 1056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Version && ver,int loopDepth) 
	{
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_LE(ver, next);
															#line 1065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version const& ver,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(ver, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version && ver,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(ver), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogTestContext_SendPushMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogTestContext_SendPushMessagesActor*>(this)->ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("sendPushMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_SendPushMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendPushMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("sendPushMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_SendPushMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendPushMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("sendPushMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_SendPushMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendPushMessages", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TLogTestContext* pTLogTestContext;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint16_t logID;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogContext> pTLogContext;
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint32_t i;
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Version prev;
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Version next;
															#line 1157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
};
// This generated class is to be used only via sendPushMessages()
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class TLogTestContext_SendPushMessagesActor final : public Actor<Void>, public ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >, public ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >, public FastAllocated<TLogTestContext_SendPushMessagesActor>, public TLogTestContext_SendPushMessagesActorState<TLogTestContext_SendPushMessagesActor> {
															#line 1162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
public:
	using FastAllocated<TLogTestContext_SendPushMessagesActor>::operator new;
	using FastAllocated<TLogTestContext_SendPushMessagesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8857678533873648384UL, 5550841555875901184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >;
friend struct ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >;
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TLogTestContext_SendPushMessagesActor(TLogTestContext* const& pTLogTestContext) 
															#line 1180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		 : Actor<Void>(),
		   TLogTestContext_SendPushMessagesActorState<TLogTestContext_SendPushMessagesActor>(pTLogTestContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sendPushMessages", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4548844552927987968UL, 794732782488230400UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_SendPushMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sendPushMessages");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sendPushMessages", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TLogTestContext_SendPushMessagesActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TLogTestContext_SendPushMessagesActor, 1, Version >*)0, actor_cancelled()); break;
		}

	}
};
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
[[nodiscard]] Future<Void> TLogTestContext::sendPushMessages( TLogTestContext* const& pTLogTestContext ) {
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	return Future<Void>(new TLogTestContext_SendPushMessagesActor(pTLogTestContext));
															#line 1213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
}

#line 247 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"

// send peek/pop through a given TLog interface and tag
															#line 1219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
// This generated class is to be used only via peekCommitMessages()
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
template <class TLogTestContext_PeekCommitMessagesActor>
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class TLogTestContext_PeekCommitMessagesActorState {
															#line 1225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
public:
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TLogTestContext_PeekCommitMessagesActorState(TLogTestContext* const& pTLogTestContext,uint16_t const& tagID,uint32_t const& logID) 
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		 : pTLogTestContext(pTLogTestContext),
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   tagID(tagID),
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   logID(logID),
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   pTLogContext(pTLogTestContext->pTLogContextList[logID])
															#line 1238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
	{
		fdb_probe_actor_create("peekCommitMessages", reinterpret_cast<unsigned long>(this));

	}
	~TLogTestContext_PeekCommitMessagesActorState() 
	{
		fdb_probe_actor_destroy("peekCommitMessages", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<bool> __when_expr_0 = pTLogContext->TLogStarted.getFuture();
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state = 1;
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >*>(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)));
															#line 1260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TLogTestContext_PeekCommitMessagesActorState();
		static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& tLogReady,int loopDepth) 
	{
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(tLogReady, true);
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tag = Tag(pTLogTestContext->tagLocality, tagID);
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerEnterPeek", pTLogTestContext->workerID).detail("LogID", logID).detail("Tag", tag);
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		i = 0;
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		versions = pTLogTestContext->commitHistory[std::tuple(tagID, logID)];
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(versions);
															#line 1293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(bool && tLogReady,int loopDepth) 
	{
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(tLogReady, true);
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tag = Tag(pTLogTestContext->tagLocality, tagID);
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerEnterPeek", pTLogTestContext->workerID).detail("LogID", logID).detail("Tag", tag);
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		i = 0;
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		versions = pTLogTestContext->commitHistory[std::tuple(tagID, logID)];
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(versions);
															#line 1312 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool const& tLogReady,int loopDepth) 
	{
		loopDepth = a_body1cont1(tLogReady, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && tLogReady,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tLogReady), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerExitPeek", pTLogTestContext->workerID).detail("LogID", logID).detail("TagID", tag);
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TLogTestContext_PeekCommitMessagesActorState(); static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->destroy(); return 0; }
															#line 1398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		new (&static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TLogTestContext_PeekCommitMessagesActorState();
		static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!(RangeForbody1cont1Iterator0 != std::end(versions)))
															#line 1417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Version v = *RangeForbody1cont1Iterator0;
															#line 1423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			begin = v;
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			::TLogPeekRequest request(begin, tag, false, false);
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<::TLogPeekReply> __when_expr_1 = pTLogContext->TestTLogInterface.peekMessages.getReply(request);
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state = 2;
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >*>(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)));
															#line 1438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		++RangeForbody1cont1Iterator0;
															#line 1461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(::TLogPeekReply const& reply,int loopDepth) 
	{
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerTryValidateDataOnPeek", pTLogTestContext->workerID) .detail("R", begin) .detail("B", reply.begin.present() ? reply.begin.get() : -1) .detail("P", reply.popped) .detail("To", pTLogContext->TestTLogInterface.toString());
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (reply.popped.present() && reply.popped.get() > begin)
															#line 1472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_GE(reply.maxKnownVersion, i);
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ArenaReader rd = ArenaReader(reply.arena, reply.messages, AssumeVersion(g_network->protocolVersion()));
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(*(int32_t*)rd.peekBytes(4), VERSION_HEADER);
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		int32_t dummy;
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Version ver;
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		rd >> dummy >> ver;
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		int32_t messageLength;
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		uint16_t tagCount;
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		uint32_t sub = 1;
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (FLOW_KNOBS->WRITE_TRACING_ENABLED)
															#line 1496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd >> messageLength >> sub >> tagCount;
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd.readBytes(tagCount * sizeof(Tag));
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (sub == 1)
															#line 1504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			{
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				SpanContextMessage contextMessage;
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				rd >> contextMessage;
															#line 1510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			}
		}
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (sub == 1)
															#line 1515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd >> messageLength >> sub >> tagCount;
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd.readBytes(tagCount * sizeof(Tag));
															#line 1521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		}
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		MutationRef m;
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		rd >> m;
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Standalone<StringRef> expectedKey = StringRef(format("key %d", i));
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Standalone<StringRef> expectedVal = StringRef(format("value %d", i));
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_WE_THINK(m.param1 == expectedKey);
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_WE_THINK(m.param2 == expectedVal);
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerValidatedDataOnPeek", pTLogTestContext->workerID) .detail("CommitCount", i) .detail("LogID", logID) .detail("TagID", tag);
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		::TLogPopRequest requestPop(begin, begin, tag);
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = pTLogContext->TestTLogInterface.popMessages.getReply(requestPop);
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state = 3;
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >*>(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)));
															#line 1548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(::TLogPeekReply && reply,int loopDepth) 
	{
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerTryValidateDataOnPeek", pTLogTestContext->workerID) .detail("R", begin) .detail("B", reply.begin.present() ? reply.begin.get() : -1) .detail("P", reply.popped) .detail("To", pTLogContext->TestTLogInterface.toString());
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (reply.popped.present() && reply.popped.get() > begin)
															#line 1559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_GE(reply.maxKnownVersion, i);
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ArenaReader rd = ArenaReader(reply.arena, reply.messages, AssumeVersion(g_network->protocolVersion()));
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(*(int32_t*)rd.peekBytes(4), VERSION_HEADER);
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		int32_t dummy;
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Version ver;
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		rd >> dummy >> ver;
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		int32_t messageLength;
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		uint16_t tagCount;
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		uint32_t sub = 1;
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (FLOW_KNOBS->WRITE_TRACING_ENABLED)
															#line 1583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd >> messageLength >> sub >> tagCount;
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd.readBytes(tagCount * sizeof(Tag));
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (sub == 1)
															#line 1591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			{
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				SpanContextMessage contextMessage;
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				rd >> contextMessage;
															#line 1597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			}
		}
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (sub == 1)
															#line 1602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd >> messageLength >> sub >> tagCount;
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			rd.readBytes(tagCount * sizeof(Tag));
															#line 1608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		}
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		MutationRef m;
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		rd >> m;
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Standalone<StringRef> expectedKey = StringRef(format("key %d", i));
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Standalone<StringRef> expectedVal = StringRef(format("value %d", i));
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_WE_THINK(m.param1 == expectedKey);
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_WE_THINK(m.param2 == expectedVal);
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerValidatedDataOnPeek", pTLogTestContext->workerID) .detail("CommitCount", i) .detail("LogID", logID) .detail("TagID", tag);
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		::TLogPopRequest requestPop(begin, begin, tag);
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = pTLogContext->TestTLogInterface.popMessages.getReply(requestPop);
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state = 3;
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >*>(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)));
															#line 1635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(::TLogPeekReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(reply, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(::TLogPeekReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >::remove();

	}
	void a_callback_fire(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >*,::TLogPeekReply const& value) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >*,::TLogPeekReply && value) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >*,Error err) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		i++;
															#line 1719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		i++;
															#line 1728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state > 0) static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TLogTestContext* pTLogTestContext;
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint16_t tagID;
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint32_t logID;
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogContext> pTLogContext;
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Tag tag;
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint32_t i;
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	std::vector<Version> versions;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	decltype(std::begin(std::declval<std::vector<Version>>())) RangeForbody1cont1Iterator0;
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Version begin;
															#line 1826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
};
// This generated class is to be used only via peekCommitMessages()
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class TLogTestContext_PeekCommitMessagesActor final : public Actor<Void>, public ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >, public ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >, public ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >, public FastAllocated<TLogTestContext_PeekCommitMessagesActor>, public TLogTestContext_PeekCommitMessagesActorState<TLogTestContext_PeekCommitMessagesActor> {
															#line 1831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
public:
	using FastAllocated<TLogTestContext_PeekCommitMessagesActor>::operator new;
	using FastAllocated<TLogTestContext_PeekCommitMessagesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12654826845187269888UL, 7502027006891258624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >;
friend struct ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >;
friend struct ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >;
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TLogTestContext_PeekCommitMessagesActor(TLogTestContext* const& pTLogTestContext,uint16_t const& tagID,uint32_t const& logID) 
															#line 1850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		 : Actor<Void>(),
		   TLogTestContext_PeekCommitMessagesActorState<TLogTestContext_PeekCommitMessagesActor>(pTLogTestContext, tagID, logID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("peekCommitMessages", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8229782662284358144UL, 11780833728886292736UL);
		ActorExecutionContextHelper __helper(static_cast<TLogTestContext_PeekCommitMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("peekCommitMessages");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("peekCommitMessages", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TLogTestContext_PeekCommitMessagesActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TLogTestContext_PeekCommitMessagesActor, 1, ::TLogPeekReply >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TLogTestContext_PeekCommitMessagesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
[[nodiscard]] Future<Void> TLogTestContext::peekCommitMessages( TLogTestContext* const& pTLogTestContext, uint16_t const& tagID, uint32_t const& logID ) {
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	return Future<Void>(new TLogTestContext_PeekCommitMessagesActor(pTLogTestContext, tagID, logID));
															#line 1884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
}

#line 332 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"

															#line 1889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
namespace {
// This generated class is to be used only via buildTLogSet()
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
template <class BuildTLogSetActor>
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class BuildTLogSetActorState {
															#line 1896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
public:
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	BuildTLogSetActorState(Reference<TLogTestContext> const& pTLogTestContext) 
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		 : pTLogTestContext(pTLogTestContext),
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   tLogSet(),
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   processID(0)
															#line 1907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
	{
		fdb_probe_actor_create("buildTLogSet", reinterpret_cast<unsigned long>(this));

	}
	~BuildTLogSetActorState() 
	{
		fdb_probe_actor_destroy("buildTLogSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogSet.tLogLocalities.push_back(LocalityData());
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogSet.tLogPolicy = Reference<IReplicationPolicy>(new PolicyOne());
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogSet.locality = pTLogTestContext->primaryLocality;
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogSet.isLocal = true;
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogSet.tLogVersion = TLogVersion::V6;
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogSet.tLogReplicationFactor = 1;
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			;
															#line 1934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BuildTLogSetActorState();
		static_cast<BuildTLogSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogTestContext->dbInfo.logSystemConfig.tLogs.push_back(tLogSet);
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		for(processID = 0;processID < pTLogTestContext->numLogServers;processID++) {
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			Reference<TLogContext> pTLogContext = pTLogTestContext->pTLogContextList[processID];
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogContext->TLogStarted.send(true);
															#line 1963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		}
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!static_cast<BuildTLogSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BuildTLogSetActorState(); static_cast<BuildTLogSetActor*>(this)->destroy(); return 0; }
															#line 1967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		new (&static_cast<BuildTLogSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BuildTLogSetActorState();
		static_cast<BuildTLogSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!(processID < pTLogTestContext->numLogServers))
															#line 1986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext = pTLogTestContext->pTLogContextList[processID];
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<bool> __when_expr_0 = pTLogContext->TLogCreated.getFuture();
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<BuildTLogSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<BuildTLogSetActor*>(this)->actor_wait_state = 1;
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BuildTLogSetActor, 0, bool >*>(static_cast<BuildTLogSetActor*>(this)));
															#line 2001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& isCreated,int loopDepth) 
	{
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(isCreated, true);
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tLogSet.tLogs.push_back(OptionalInterface<TLogInterface>(pTLogContext->TestTLogInterface));
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		processID++;
															#line 2027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && isCreated,int loopDepth) 
	{
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(isCreated, true);
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tLogSet.tLogs.push_back(OptionalInterface<TLogInterface>(pTLogContext->TestTLogInterface));
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		processID++;
															#line 2040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& isCreated,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(isCreated, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && isCreated,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(isCreated), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BuildTLogSetActor*>(this)->actor_wait_state > 0) static_cast<BuildTLogSetActor*>(this)->actor_wait_state = 0;
		static_cast<BuildTLogSetActor*>(this)->ActorCallback< BuildTLogSetActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BuildTLogSetActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("buildTLogSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTLogSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTLogSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BuildTLogSetActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("buildTLogSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTLogSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTLogSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BuildTLogSetActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("buildTLogSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTLogSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTLogSet", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogTestContext> pTLogTestContext;
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TLogSet tLogSet;
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint16_t processID;
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogContext> pTLogContext;
															#line 2128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
};
// This generated class is to be used only via buildTLogSet()
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class BuildTLogSetActor final : public Actor<Void>, public ActorCallback< BuildTLogSetActor, 0, bool >, public FastAllocated<BuildTLogSetActor>, public BuildTLogSetActorState<BuildTLogSetActor> {
															#line 2133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
public:
	using FastAllocated<BuildTLogSetActor>::operator new;
	using FastAllocated<BuildTLogSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1990876750690954496UL, 1556400540992361472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BuildTLogSetActor, 0, bool >;
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	BuildTLogSetActor(Reference<TLogTestContext> const& pTLogTestContext) 
															#line 2150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		 : Actor<Void>(),
		   BuildTLogSetActorState<BuildTLogSetActor>(pTLogTestContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("buildTLogSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14320124991897615872UL, 5530170740630234112UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTLogSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("buildTLogSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("buildTLogSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BuildTLogSetActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
[[nodiscard]] Future<Void> buildTLogSet( Reference<TLogTestContext> const& pTLogTestContext ) {
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	return Future<Void>(new BuildTLogSetActor(pTLogTestContext));
															#line 2183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
}

#line 358 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"

// This test creates a tLog and pushes data to it. the If the recovery
// test switch is on, a new "generation" of tLogs is then created. These enter recover mode
// and pull data from the old generation. The data is peeked from either the old or new generation
// depending on the recovery switch, validated, and popped.

															#line 2193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
namespace {
// This generated class is to be used only via startTestsTLogRecoveryActors()
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
template <class StartTestsTLogRecoveryActorsActor>
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class StartTestsTLogRecoveryActorsActorState {
															#line 2200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
public:
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	StartTestsTLogRecoveryActorsActorState(TestTLogOptions const& params) 
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		 : params(params),
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   tLogActors(),
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		   pTLogTestContextEpochOne(initTLogTestContext(params, Optional<Reference<TLogTestContext>>()))
															#line 2211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
	{
		fdb_probe_actor_create("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this));

	}
	~StartTestsTLogRecoveryActorsActorState() 
	{
		fdb_probe_actor_destroy("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			FlowTransport::createInstance(false, 1, WLTOKEN_RESERVED_COUNT);
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogIdx = 0;
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			TraceEvent("TestTLogServerEnterRecoveryTest");
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			for(tLogIdx = 0;tLogIdx < pTLogTestContextEpochOne->numLogServers;tLogIdx++) {
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				Reference<TLogContext> pTLogContext(new TLogContext(tLogIdx));
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				pTLogTestContextEpochOne->pTLogContextList.push_back(pTLogContext);
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
				tLogActors.emplace_back( getTLogCreateActor(pTLogTestContextEpochOne, pTLogTestContextEpochOne->tLogOptions, tLogIdx));
															#line 2238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			}
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = buildTLogSet(pTLogTestContextEpochOne);
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 1;
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartTestsTLogRecoveryActorsActorState();
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		PromiseStream<Future<Void>> promises;
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogTestContextEpochOne->ls = ILogSystem::fromServerDBInfo( pTLogTestContextEpochOne->logID, pTLogTestContextEpochOne->dbInfo, false, promises);
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = pTLogTestContextEpochOne->sendPushMessages();
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 2;
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		PromiseStream<Future<Void>> promises;
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogTestContextEpochOne->ls = ILogSystem::fromServerDBInfo( pTLogTestContextEpochOne->logID, pTLogTestContextEpochOne->dbInfo, false, promises);
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = pTLogTestContextEpochOne->sendPushMessages();
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 2;
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tagID = 0;
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		commitHistory = std::map<std::tuple<uint32_t, uint32_t>, std::vector<Version>>();
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!pTLogTestContextEpochOne->recover)
															#line 2391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			commitHistory = pTLogTestContextEpochOne->commitHistory;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			RangeForbody1cont3Iterator0 = std::begin(commitHistory);
															#line 2397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = a_body1cont3loopHead1(loopDepth);
		}
		else
		{
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochTwo = initTLogTestContext(TestTLogOptions(params), pTLogTestContextEpochOne);
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochTwo->tLogOptions.versions = pTLogTestContextEpochOne->tLogOptions.versions;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			commitHistory = pTLogTestContextEpochTwo->commitHistory;
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochTwo->pTLogContextList.resize(commitHistory.size());
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			RangeForbody1cont3Iterator1 = std::begin(commitHistory);
															#line 2412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = a_body1cont3loopHead2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tagID = 0;
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		commitHistory = std::map<std::tuple<uint32_t, uint32_t>, std::vector<Version>>();
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!pTLogTestContextEpochOne->recover)
															#line 2426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			commitHistory = pTLogTestContextEpochOne->commitHistory;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			RangeForbody1cont3Iterator0 = std::begin(commitHistory);
															#line 2432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = a_body1cont3loopHead1(loopDepth);
		}
		else
		{
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochTwo = initTLogTestContext(TestTLogOptions(params), pTLogTestContextEpochOne);
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochTwo->tLogOptions.versions = pTLogTestContextEpochOne->tLogOptions.versions;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			commitHistory = pTLogTestContextEpochTwo->commitHistory;
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochTwo->pTLogContextList.resize(commitHistory.size());
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			RangeForbody1cont3Iterator1 = std::begin(commitHistory);
															#line 2447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = a_body1cont3loopHead2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 464 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		for(tLogIdx = 0;tLogIdx < pTLogTestContextEpochOne->numLogServers;tLogIdx++) {
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochOne->pTLogContextList[tLogIdx]->TestTLogServerCompleted.send(true);
															#line 2534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		}
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<Void> __when_expr_6 = waitForAll(tLogActors);
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont4when1(__when_expr_6.get(), loopDepth); };
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 7;
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!(RangeForbody1cont3Iterator0 != std::end(commitHistory)))
															#line 2567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		const auto& [loc, ver] = *RangeForbody1cont3Iterator0;
															#line 2573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = pTLogTestContextEpochOne->peekCommitMessages(std::get<0>(loc), std::get<1>(loc));
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 3;
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		++RangeForbody1cont3Iterator0;
															#line 2607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		RangeForbody1cont6Iterator0 = std::begin(commitHistory);
															#line 2703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead2(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody2(int loopDepth) 
	{
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!(RangeForbody1cont3Iterator1 != std::end(commitHistory)))
															#line 2719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1cont3break2(loopDepth==0?0:loopDepth-1); // break
		}
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		const auto& [loc, ver] = *RangeForbody1cont3Iterator1;
															#line 2725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tLogIdx = std::get<1>(loc);
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			tagID = std::get<0>(loc);
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<TLogLockResult> __when_expr_3 = pTLogTestContextEpochOne->pTLogContextList[tLogIdx] ->TestTLogInterface.lock.template getReply<TLogLockResult>();
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody2when1(__when_expr_3.get(), loopDepth); };
			static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 4;
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3break2(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody2cont1(int loopDepth) 
	{
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		++RangeForbody1cont3Iterator1;
															#line 2763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead2(0);

		return loopDepth;
	}
	int a_body1cont3loopBody2cont3(TLogLockResult const& data,int loopDepth) 
	{
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerLockResult") .detail("KCV", data.knownCommittedVersion) .detail("T", tagID) .detail("L", tLogIdx);
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Reference<TLogContext> pNewTLogContext(new TLogContext(tLogIdx));
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogTestContextEpochTwo->pTLogContextList[tLogIdx] = pNewTLogContext;
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req = InitializeTLogRequest();
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recruitmentID = pTLogTestContextEpochTwo->dbInfo.logSystemConfig.recruitmentID;
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverAt = pTLogTestContextEpochOne->tLogOptions.versions.back();
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.startVersion = pTLogTestContextEpochOne->initVersion + 1;
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoveryTransactionVersion = pTLogTestContextEpochOne->initVersion;
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.knownCommittedVersion = 0;
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.epoch = pTLogTestContextEpochTwo->epoch;
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.logVersion = TLogVersion::V6;
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.locality = pTLogTestContextEpochTwo->primaryLocality;
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.isPrimary = true;
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.logRouterTags = 0;
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverTags = { Tag(pTLogTestContextEpochTwo->primaryLocality, tagID) };
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverFrom = pTLogTestContextEpochOne->dbInfo.logSystemConfig;
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverFrom.logRouterTags = 0;
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		const TestTLogOptions& tLogOptions = pTLogTestContextEpochTwo->tLogOptions;
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tLogActors.emplace_back(getTLogCreateActor(pTLogTestContextEpochTwo, tLogOptions, tLogIdx, &req, pTLogTestContextEpochOne->pTLogContextList[tLogIdx]->tLogID));
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext = pTLogTestContextEpochTwo->pTLogContextList[tLogIdx];
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<bool> __when_expr_4 = pTLogContext->TLogCreated.getFuture();
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody2cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 5;
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody2cont3(TLogLockResult && data,int loopDepth) 
	{
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerLockResult") .detail("KCV", data.knownCommittedVersion) .detail("T", tagID) .detail("L", tLogIdx);
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		Reference<TLogContext> pNewTLogContext(new TLogContext(tLogIdx));
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogTestContextEpochTwo->pTLogContextList[tLogIdx] = pNewTLogContext;
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req = InitializeTLogRequest();
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recruitmentID = pTLogTestContextEpochTwo->dbInfo.logSystemConfig.recruitmentID;
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverAt = pTLogTestContextEpochOne->tLogOptions.versions.back();
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.startVersion = pTLogTestContextEpochOne->initVersion + 1;
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoveryTransactionVersion = pTLogTestContextEpochOne->initVersion;
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.knownCommittedVersion = 0;
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.epoch = pTLogTestContextEpochTwo->epoch;
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.logVersion = TLogVersion::V6;
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.locality = pTLogTestContextEpochTwo->primaryLocality;
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.isPrimary = true;
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.logRouterTags = 0;
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverTags = { Tag(pTLogTestContextEpochTwo->primaryLocality, tagID) };
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverFrom = pTLogTestContextEpochOne->dbInfo.logSystemConfig;
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		req.recoverFrom.logRouterTags = 0;
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		const TestTLogOptions& tLogOptions = pTLogTestContextEpochTwo->tLogOptions;
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		tLogActors.emplace_back(getTLogCreateActor(pTLogTestContextEpochTwo, tLogOptions, tLogIdx, &req, pTLogTestContextEpochOne->pTLogContextList[tLogIdx]->tLogID));
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext = pTLogTestContextEpochTwo->pTLogContextList[tLogIdx];
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		StrictFuture<bool> __when_expr_4 = pTLogContext->TLogCreated.getFuture();
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody2cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 5;
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 2875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody2when1(TLogLockResult const& data,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody2cont3(data, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody2when1(TLogLockResult && data,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody2cont3(std::move(data), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >*,TLogLockResult const& value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >*,TLogLockResult && value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >*,Error err) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3loopBody2cont4(bool const& isCreated,int loopDepth) 
	{
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(isCreated, true);
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->TLogStarted.send(true);
															#line 2961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont3loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody2cont4(bool && isCreated,int loopDepth) 
	{
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		ASSERT_EQ(isCreated, true);
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		pTLogContext->TLogStarted.send(true);
															#line 2972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		loopDepth = a_body1cont3loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody2cont3when1(bool const& isCreated,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody2cont4(isCreated, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody2cont3when1(bool && isCreated,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody2cont4(std::move(isCreated), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody2cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody2cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >*,Error err) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		for(tLogIdx = 0;tLogIdx < pTLogTestContextEpochOne->numLogServers;tLogIdx++) {
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			pTLogTestContextEpochTwo->pTLogContextList[tLogIdx]->TestTLogServerCompleted.send(true);
															#line 3058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!(RangeForbody1cont6Iterator0 != std::end(commitHistory)))
															#line 3075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
			return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		const auto& [loc, ver] = *RangeForbody1cont6Iterator0;
															#line 3081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		{
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			StrictFuture<Void> __when_expr_5 = pTLogTestContextEpochTwo->peekCommitMessages(std::get<0>(loc), std::get<1>(loc));
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 6;
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >*>(static_cast<StartTestsTLogRecoveryActorsActor*>(this)));
															#line 3092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(int loopDepth) 
	{
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		++RangeForbody1cont6Iterator0;
															#line 3115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerExitRecoveryTest");
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!static_cast<StartTestsTLogRecoveryActorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartTestsTLogRecoveryActorsActorState(); static_cast<StartTestsTLogRecoveryActorsActor*>(this)->destroy(); return 0; }
															#line 3213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		new (&static_cast<StartTestsTLogRecoveryActorsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartTestsTLogRecoveryActorsActorState();
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		TraceEvent("TestTLogServerExitRecoveryTest");
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
		if (!static_cast<StartTestsTLogRecoveryActorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartTestsTLogRecoveryActorsActorState(); static_cast<StartTestsTLogRecoveryActorsActor*>(this)->destroy(); return 0; }
															#line 3227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		new (&static_cast<StartTestsTLogRecoveryActorsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartTestsTLogRecoveryActorsActorState();
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state > 0) static_cast<StartTestsTLogRecoveryActorsActor*>(this)->actor_wait_state = 0;
		static_cast<StartTestsTLogRecoveryActorsActor*>(this)->ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	TestTLogOptions params;
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	std::vector<Future<Void>> tLogActors;
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogTestContext> pTLogTestContextEpochOne;
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint16_t tLogIdx;
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	uint32_t tagID;
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	std::map<std::tuple<uint32_t, uint32_t>, std::vector<Version>> commitHistory;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	decltype(std::begin(std::declval<std::map<std::tuple<uint32_t, uint32_t>, std::vector<Version>>>())) RangeForbody1cont3Iterator0;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogTestContext> pTLogTestContextEpochTwo;
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	decltype(std::begin(std::declval<std::map<std::tuple<uint32_t, uint32_t>, std::vector<Version>>>())) RangeForbody1cont3Iterator1;
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	InitializeTLogRequest req;
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	Reference<TLogContext> pTLogContext;
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	decltype(std::begin(std::declval<std::map<std::tuple<uint32_t, uint32_t>, std::vector<Version>>>())) RangeForbody1cont6Iterator0;
															#line 3334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
};
// This generated class is to be used only via startTestsTLogRecoveryActors()
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
class StartTestsTLogRecoveryActorsActor final : public Actor<Void>, public ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >, public ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >, public ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >, public ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >, public ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >, public ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >, public ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >, public FastAllocated<StartTestsTLogRecoveryActorsActor>, public StartTestsTLogRecoveryActorsActorState<StartTestsTLogRecoveryActorsActor> {
															#line 3339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
public:
	using FastAllocated<StartTestsTLogRecoveryActorsActor>::operator new;
	using FastAllocated<StartTestsTLogRecoveryActorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2126379844916439552UL, 3212309813719864576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >;
friend struct ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >;
friend struct ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >;
friend struct ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >;
friend struct ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >;
friend struct ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >;
friend struct ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >;
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	StartTestsTLogRecoveryActorsActor(TestTLogOptions const& params) 
															#line 3362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
		 : Actor<Void>(),
		   StartTestsTLogRecoveryActorsActorState<StartTestsTLogRecoveryActorsActor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5529212507314564864UL, 18021143452755378688UL);
		ActorExecutionContextHelper __helper(static_cast<StartTestsTLogRecoveryActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startTestsTLogRecoveryActors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startTestsTLogRecoveryActors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartTestsTLogRecoveryActorsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartTestsTLogRecoveryActorsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartTestsTLogRecoveryActorsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StartTestsTLogRecoveryActorsActor, 3, TLogLockResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< StartTestsTLogRecoveryActorsActor, 4, bool >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< StartTestsTLogRecoveryActorsActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< StartTestsTLogRecoveryActorsActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
[[nodiscard]] Future<Void> startTestsTLogRecoveryActors( TestTLogOptions const& params ) {
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"
	return Future<Void>(new StartTestsTLogRecoveryActorsActor(params));
															#line 3401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TestTLogServer.actor.g.cpp"
}

#line 475 "/Users/ec2-user/foundationdb/fdbserver/TestTLogServer.actor.cpp"

// TEST_CASE("/fdbserver/test/TestTLogCommits") {
// 	params.set("recover", static_cast<int64_t>(0));
// 	TestTLogOptions testTLogOptions(params);
// 	wait(startTestsTLogRecoveryActors(testTLogOptions));
// 	return Void();
// }

// // Two tlogs, one tag. Write 10 commits up to version V. Start recovery with RV set to V+10.
// TEST_CASE("/fdbserver/test/TestTLogRecovery1") {
// 	TestTLogOptions testTLogOptions(params);
// 	wait(startTestsTLogRecoveryActors(testTLogOptions));
// 	return Void();
// }

// // Four tlogs, two tags.
// TEST_CASE("/fdbserver/test/TestTLogRecovery2") {
// 	params.set("numLogServers", static_cast<int64_t>(4));
// 	params.set("numTags", static_cast<int64_t>(2));

// 	TestTLogOptions testTLogOptions(params);
// 	wait(startTestsTLogRecoveryActors(testTLogOptions));
// 	return Void();
// }
