#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
/*
 * Status.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cinttypes>
#include "fdbclient/BlobGranuleCommon.h"
#include "fdbclient/EncryptKeyProxyInterface.h"
#include "fdbclient/json_spirit/json_spirit_value.h"
#include "fdbserver/BlobGranuleServerCommon.actor.h"
#include "fdbserver/BlobManagerInterface.h"
#include "flow/genericactors.actor.h"
#include "fmt/format.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BlobWorkerInterface.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/BlobRestoreCommon.h"
#include "fdbserver/Status.actor.h"
#include "flow/ITrace.h"
#include "flow/ProtocolVersion.h"
#include "flow/Trace.h"
#include "fdbclient/MetaclusterRegistration.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/WorkerInterface.actor.h"
#include <time.h>
#include "fdbserver/ClusterRecovery.actor.h"
#include "fdbserver/CoordinationInterface.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbclient/ConsistencyScanInterface.actor.h"
#include "flow/UnitTest.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/RecoveryState.h"
#include "fdbserver/Knobs.h"
#include "fdbclient/JsonBuilder.h"
#include "fdbclient/StorageWiggleMetrics.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

const char* RecoveryStatus::names[] = { "reading_coordinated_state",
	                                    "locking_coordinated_state",
	                                    "locking_old_transaction_servers",
	                                    "reading_transaction_system_state",
	                                    "configuration_missing",
	                                    "configuration_never_created",
	                                    "configuration_invalid",
	                                    "recruiting_transaction_servers",
	                                    "initializing_transaction_servers",
	                                    "recovery_transaction",
	                                    "writing_coordinated_state",
	                                    "accepting_commits",
	                                    "all_logs_recruited",
	                                    "storage_recovered",
	                                    "fully_recovered" };
static_assert(sizeof(RecoveryStatus::names) == sizeof(RecoveryStatus::names[0]) * RecoveryStatus::END,
              "RecoveryStatus::names[] size");
const char* RecoveryStatus::descriptions[] = {
	// reading_coordinated_state
	"Requesting information from coordination servers. Verify that a majority of coordination server processes are "
	"active.",
	// locking_coordinated_state
	"Locking coordination state. Verify that a majority of coordination server processes are active.",
	// locking_old_transaction_servers
	"Locking old transaction servers. Verify that at least one transaction server from the previous generation is "
	"running.",
	// reading_transaction_system_state
	"Recovering transaction server state. Verify that the transaction server processes are active.",
	// configuration_missing
	"There appears to be a database, but its configuration does not appear to be initialized.",
	// configuration_never_created
	"The coordinator(s) have no record of this database. Either the coordinator addresses are incorrect, the "
	"coordination state on those machines is missing, or no database has been created.",
	// configuration_invalid
	"The database configuration is invalid. Set a new, valid configuration to recover the database.",
	// recruiting_transaction_servers
	"Recruiting new transaction servers.",
	// initializing_transaction_servers
	"Initializing new transaction servers and recovering transaction logs.",
	// recovery_transaction
	"Performing recovery transaction.",
	// writing_coordinated_state
	"Writing coordinated state. Verify that a majority of coordination server processes are active.",
	// accepting_commits
	"Accepting commits.",
	// all_logs_recruited
	"Accepting commits. All logs recruited.",
	// storage_recovered
	"Accepting commits. All storage servers are reading from the new logs.",
	// fully_recovered
	"Recovery complete."
};
static_assert(sizeof(RecoveryStatus::descriptions) == sizeof(RecoveryStatus::descriptions[0]) * RecoveryStatus::END,
              "RecoveryStatus::descriptions[] size");

// From Ratekeeper.actor.cpp
extern int limitReasonEnd;
extern const char* limitReasonName[];
extern const char* limitReasonDesc[];

typedef std::map<std::string, TraceEventFields> EventMap;

struct StorageServerStatusInfo : public StorageServerMetaInfo {
	EventMap eventMap;
	StorageServerStatusInfo(const StorageServerMetaInfo& info) : StorageServerMetaInfo(info, info.metadata) {}
};

															#line 124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via latestEventOnWorker()
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class LatestEventOnWorkerActor>
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class LatestEventOnWorkerActorState {
															#line 131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	LatestEventOnWorkerActorState(WorkerInterface const& worker,std::string const& eventName) 
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : worker(worker),
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   eventName(eventName)
															#line 140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("latestEventOnWorker", reinterpret_cast<unsigned long>(this));

	}
	~LatestEventOnWorkerActorState() 
	{
		fdb_probe_actor_destroy("latestEventOnWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				EventLogRequest req = eventName.size() > 0 ? EventLogRequest(Standalone<StringRef>(eventName)) : EventLogRequest();
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<ErrorOr<TraceEventFields>> __when_expr_0 = errorOr(timeoutError(worker.eventLogRequest.getReply(req), 2.0));
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<LatestEventOnWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<LatestEventOnWorkerActor*>(this)->actor_wait_state = 1;
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*>(static_cast<LatestEventOnWorkerActor*>(this)));
															#line 165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LatestEventOnWorkerActorState();
		static_cast<LatestEventOnWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(Optional<TraceEventFields>()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(Optional<TraceEventFields>());
			this->~LatestEventOnWorkerActorState();
			static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(ErrorOr<TraceEventFields> const& eventTrace,int loopDepth) 
	{
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (eventTrace.isError())
															#line 221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(Optional<TraceEventFields>()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(Optional<TraceEventFields>());
			this->~LatestEventOnWorkerActorState();
			static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(eventTrace.get()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(eventTrace.get());
		this->~LatestEventOnWorkerActorState();
		static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(ErrorOr<TraceEventFields> && eventTrace,int loopDepth) 
	{
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (eventTrace.isError())
															#line 245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(Optional<TraceEventFields>()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(Optional<TraceEventFields>());
			this->~LatestEventOnWorkerActorState();
			static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(eventTrace.get()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(eventTrace.get());
		this->~LatestEventOnWorkerActorState();
		static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<TraceEventFields> const& eventTrace,int loopDepth) 
	{
		loopDepth = a_body1cont2(eventTrace, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<TraceEventFields> && eventTrace,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(eventTrace), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LatestEventOnWorkerActor*>(this)->actor_wait_state > 0) static_cast<LatestEventOnWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<LatestEventOnWorkerActor*>(this)->ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*,ErrorOr<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*,ErrorOr<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerInterface worker;
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::string eventName;
															#line 344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via latestEventOnWorker()
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class LatestEventOnWorkerActor final : public Actor<Optional<TraceEventFields>>, public ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >, public FastAllocated<LatestEventOnWorkerActor>, public LatestEventOnWorkerActorState<LatestEventOnWorkerActor> {
															#line 349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<LatestEventOnWorkerActor>::operator new;
	using FastAllocated<LatestEventOnWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13610616713910680064UL, 12966357504470396928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<TraceEventFields>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >;
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	LatestEventOnWorkerActor(WorkerInterface const& worker,std::string const& eventName) 
															#line 366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<Optional<TraceEventFields>>(),
		   LatestEventOnWorkerActorState<LatestEventOnWorkerActor>(worker, eventName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("latestEventOnWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7106470683888923648UL, 11063323833140639488UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("latestEventOnWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("latestEventOnWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<Optional<TraceEventFields>> latestEventOnWorker( WorkerInterface const& worker, std::string const& eventName ) {
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Optional<TraceEventFields>>(new LatestEventOnWorkerActor(worker, eventName));
															#line 399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 138 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via latestEventOnWorkers()
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class LatestEventOnWorkersActor>
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class LatestEventOnWorkersActorState {
															#line 411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	LatestEventOnWorkersActorState(std::vector<WorkerDetails> const& workers,std::string const& eventName) 
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : workers(workers),
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   eventName(eventName)
															#line 420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("latestEventOnWorkers", reinterpret_cast<unsigned long>(this));

	}
	~LatestEventOnWorkersActorState() 
	{
		fdb_probe_actor_destroy("latestEventOnWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				eventTraces = std::vector<Future<ErrorOr<TraceEventFields>>>();
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				for(int c = 0;c < workers.size();c++) {
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					EventLogRequest req = eventName.size() > 0 ? EventLogRequest(Standalone<StringRef>(eventName)) : EventLogRequest();
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					eventTraces.push_back(errorOr(timeoutError(workers[c].interf.eventLogRequest.getReply(req), 2.0)));
															#line 442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(eventTraces);
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state = 1;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LatestEventOnWorkersActor, 0, Void >*>(static_cast<LatestEventOnWorkersActor*>(this)));
															#line 453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LatestEventOnWorkersActorState();
		static_cast<LatestEventOnWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(e.code() == error_code_actor_cancelled);
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		std::set<std::string> failed;
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		WorkerEvents results;
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < eventTraces.size();i++) {
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			const ErrorOr<TraceEventFields>& v = eventTraces[i].get();
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (v.isError())
															#line 507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				failed.insert(workers[i].interf.address().toString());
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				results[workers[i].interf.address()] = TraceEventFields();
															#line 513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				results[workers[i].interf.address()] = v.get();
															#line 519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		std::pair<WorkerEvents, std::set<std::string>> val;
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		val.first = results;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		val.second = failed;
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatestEventOnWorkersActor*>(this)->SAV<Optional<std::pair<WorkerEvents, std::set<std::string>>>>::futures) { (void)(val); this->~LatestEventOnWorkersActorState(); static_cast<LatestEventOnWorkersActor*>(this)->destroy(); return 0; }
															#line 530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LatestEventOnWorkersActor*>(this)->SAV< Optional<std::pair<WorkerEvents, std::set<std::string>>> >::value()) Optional<std::pair<WorkerEvents, std::set<std::string>>>(val);
		this->~LatestEventOnWorkersActorState();
		static_cast<LatestEventOnWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		std::set<std::string> failed;
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		WorkerEvents results;
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < eventTraces.size();i++) {
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			const ErrorOr<TraceEventFields>& v = eventTraces[i].get();
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (v.isError())
															#line 550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				failed.insert(workers[i].interf.address().toString());
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				results[workers[i].interf.address()] = TraceEventFields();
															#line 556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				results[workers[i].interf.address()] = v.get();
															#line 562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		std::pair<WorkerEvents, std::set<std::string>> val;
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		val.first = results;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		val.second = failed;
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatestEventOnWorkersActor*>(this)->SAV<Optional<std::pair<WorkerEvents, std::set<std::string>>>>::futures) { (void)(val); this->~LatestEventOnWorkersActorState(); static_cast<LatestEventOnWorkersActor*>(this)->destroy(); return 0; }
															#line 573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LatestEventOnWorkersActor*>(this)->SAV< Optional<std::pair<WorkerEvents, std::set<std::string>>> >::value()) Optional<std::pair<WorkerEvents, std::set<std::string>>>(val);
		this->~LatestEventOnWorkersActorState();
		static_cast<LatestEventOnWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state > 0) static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<LatestEventOnWorkersActor*>(this)->ActorCallback< LatestEventOnWorkersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LatestEventOnWorkersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LatestEventOnWorkersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LatestEventOnWorkersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::string eventName;
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<ErrorOr<TraceEventFields>>> eventTraces;
															#line 662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via latestEventOnWorkers()
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class LatestEventOnWorkersActor final : public Actor<Optional<std::pair<WorkerEvents, std::set<std::string>>>>, public ActorCallback< LatestEventOnWorkersActor, 0, Void >, public FastAllocated<LatestEventOnWorkersActor>, public LatestEventOnWorkersActorState<LatestEventOnWorkersActor> {
															#line 667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<LatestEventOnWorkersActor>::operator new;
	using FastAllocated<LatestEventOnWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10988564488041342720UL, 1485744383741590528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::pair<WorkerEvents, std::set<std::string>>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LatestEventOnWorkersActor, 0, Void >;
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	LatestEventOnWorkersActor(std::vector<WorkerDetails> const& workers,std::string const& eventName) 
															#line 684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<Optional<std::pair<WorkerEvents, std::set<std::string>>>>(),
		   LatestEventOnWorkersActorState<LatestEventOnWorkersActor>(workers, eventName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17131304875114139904UL, 5790865631530653952UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("latestEventOnWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LatestEventOnWorkersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<Optional<std::pair<WorkerEvents, std::set<std::string>>>> latestEventOnWorkers( std::vector<WorkerDetails> const& workers, std::string const& eventName ) {
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Optional<std::pair<WorkerEvents, std::set<std::string>>>>(new LatestEventOnWorkersActor(workers, eventName));
															#line 717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 176 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
static Future<Optional<std::pair<WorkerEvents, std::set<std::string>>>> latestErrorOnWorkers(
    std::vector<WorkerDetails> workers) {
	return latestEventOnWorkers(workers, "");
}

static Optional<WorkerDetails> getWorker(std::vector<WorkerDetails> const& workers, NetworkAddress const& address) {
	try {
		for (int c = 0; c < workers.size(); c++)
			if (address == workers[c].interf.address())
				return workers[c];
		return Optional<WorkerDetails>();
	} catch (Error&) {
		return Optional<WorkerDetails>();
	}
}

static Optional<WorkerDetails> getWorker(std::map<NetworkAddress, WorkerDetails> const& workersMap,
                                         NetworkAddress const& address) {
	auto itr = workersMap.find(address);
	if (itr == workersMap.end()) {
		return Optional<WorkerDetails>();
	}

	return itr->second;
}

class StatusCounter {
public:
	StatusCounter() : hz(0), roughness(0), counter(0) {}
	StatusCounter(double hz, double roughness, int64_t counter) : hz(hz), roughness(roughness), counter(counter) {}
	StatusCounter(const std::string& parsableText) { parseText(parsableText); }

	StatusCounter& parseText(const std::string& parsableText) {
		sscanf(parsableText.c_str(), "%lf %lf %" SCNd64 "", &hz, &roughness, &counter);
		return *this;
	}

	StatusCounter& updateValues(const StatusCounter& statusCounter) {
		double hzNew = hz + statusCounter.hz;
		double roughnessNew = (hz + statusCounter.hz) ? (roughness * hz + statusCounter.roughness * statusCounter.hz) /
		                                                    (hz + statusCounter.hz)
		                                              : 0.0;
		int64_t counterNew = counter + statusCounter.counter;
		hz = hzNew;
		roughness = roughnessNew;
		counter = counterNew;
		return *this;
	}

	JsonBuilderObject getStatus() const {
		JsonBuilderObject statusObject;
		statusObject["hz"] = hz;
		statusObject["roughness"] = roughness;
		statusObject["counter"] = counter;
		return statusObject;
	}

	double getHz() { return hz; }

	double getRoughness() { return roughness; }

	int64_t getCounter() { return counter; }

protected:
	double hz;
	double roughness;
	int64_t counter;
};

static JsonBuilderObject getError(const TraceEventFields& errorFields) {
	JsonBuilderObject statusObj;
	try {
		if (errorFields.size()) {
			double time = atof(errorFields.getValue("Time").c_str());
			statusObj["time"] = time;

			statusObj["raw_log_message"] = errorFields.toString();

			std::string type = errorFields.getValue("Type");
			statusObj["type"] = type;

			std::string description = type;
			std::string errorName;
			if (errorFields.tryGetValue("Error", errorName)) {
				statusObj["name"] = errorName;
				description += ": " + errorName;
			} else
				statusObj["name"] = "process_error";

			struct tm* timeinfo;
			time_t t = (time_t)time;
			timeinfo = localtime(&t);
			char buffer[128];
			strftime(buffer, 128, "%c", timeinfo);
			description += " at " + std::string(buffer);

			statusObj["description"] = description;
		}
	} catch (Error& e) {
		TraceEvent(SevError, "StatusGetErrorError").error(e).detail("RawError", errorFields.toString());
	}
	return statusObj;
}

namespace {

void reportCgroupCpuStat(JsonBuilderObject& object, const TraceEventFields& eventFields) {
	JsonBuilderObject cgroupCpuStatObj;
	std::string val;
	if (eventFields.tryGetValue("NrPeriods", val)) {
		cgroupCpuStatObj.setKeyRawNumber("nr_periods", val);
	}
	if (eventFields.tryGetValue("NrThrottled", val)) {
		cgroupCpuStatObj.setKeyRawNumber("nr_throttled", val);
	}
	if (eventFields.tryGetValue("ThrottledTime", val)) {
		cgroupCpuStatObj.setKeyRawNumber("throttled_time", val);
	}
	if (!cgroupCpuStatObj.empty()) {
		object["cgroup_cpu_stat"] = cgroupCpuStatObj;
	}
}

JsonBuilderObject machineStatusFetcher(WorkerEvents mMetrics,
                                       std::vector<WorkerDetails> workers,
                                       Optional<DatabaseConfiguration> configuration,
                                       std::set<std::string>* incomplete_reasons) {
	JsonBuilderObject machineMap;
	double metric;
	int failed = 0;

	// map from machine networkAddress to datacenter ID
	std::map<NetworkAddress, std::string> dcIds;
	std::map<NetworkAddress, LocalityData> locality;
	std::map<std::string, bool> excludedMap;
	std::map<std::string, int32_t> workerContribMap;
	std::map<std::string, JsonBuilderObject> machineJsonMap;

	for (auto const& worker : workers) {
		locality[worker.interf.address()] = worker.interf.locality;
		if (worker.interf.locality.dcId().present())
			dcIds[worker.interf.address()] = worker.interf.locality.dcId().get().printable();
	}

	for (auto it = mMetrics.begin(); it != mMetrics.end(); it++) {

		if (!it->second.size()) {
			continue;
		}

		JsonBuilderObject statusObj; // Represents the status for a machine
		const TraceEventFields& event = it->second;

		try {
			std::string address = it->first.ip.toString();
			// We will use the "physical" calculated machine ID here to limit exposure to machineID repurposing
			std::string machineId = event.getValue("MachineID");

			// If this machine ID does not already exist in the machineMap, add it
			if (!machineJsonMap.contains(machineId)) {
				statusObj["machine_id"] = machineId;

				if (dcIds.contains(it->first)) {
					statusObj["datacenter_id"] = dcIds[it->first];
				}

				if (locality.contains(it->first)) {
					statusObj["locality"] = locality[it->first].toJSON<JsonBuilderObject>();
				}

				statusObj["address"] = address;

				JsonBuilderObject memoryObj;
				memoryObj.setKeyRawNumber("total_bytes", event.getValue("TotalMemory"));
				memoryObj.setKeyRawNumber("committed_bytes", event.getValue("CommittedMemory"));
				memoryObj.setKeyRawNumber("free_bytes", event.getValue("AvailableMemory"));
				statusObj["memory"] = memoryObj;

#ifdef __linux__
				reportCgroupCpuStat(statusObj, event);
#endif // __linux__

				JsonBuilderObject cpuObj;
				double cpuSeconds = event.getDouble("CPUSeconds");
				double elapsed = event.getDouble("Elapsed");
				if (elapsed > 0) {
					cpuObj["logical_core_utilization"] = std::max(0.0, std::min(cpuSeconds / elapsed, 1.0));
				}
				statusObj["cpu"] = cpuObj;

				JsonBuilderObject networkObj;
				networkObj["megabits_sent"] = JsonBuilderObject().setKeyRawNumber("hz", event.getValue("MbpsSent"));
				networkObj["megabits_received"] =
				    JsonBuilderObject().setKeyRawNumber("hz", event.getValue("MbpsReceived"));

				metric = event.getDouble("RetransSegs");
				JsonBuilderObject retransSegsObj;
				if (elapsed > 0) {
					retransSegsObj["hz"] = metric / elapsed;
				}
				networkObj["tcp_segments_retransmitted"] = retransSegsObj;
				statusObj["network"] = networkObj;

				if (configuration.present()) {
					excludedMap[machineId] =
					    true; // Will be set to false below if this or any later process is not excluded
				}

				workerContribMap[machineId] = 0;
				machineJsonMap[machineId] = statusObj;
			}

			bool excludedServer = true;
			// If the machine is already marked as not excluded, because at least one process was found to not be
			// excluded, we can stop checking further servers on this machine.
			if (configuration.present() && excludedMap[machineId]) {
				NetworkAddressList tempList;
				tempList.address = it->first;
				// Check if the locality data is present and if so, make use of it.
				auto localityData = LocalityData();
				if (locality.contains(it->first)) {
					localityData = locality[it->first];
				}

				// The isExcludedServer method already contains a check for the excluded localities.
				excludedServer = configuration.get().isExcludedServer(tempList, localityData);
			}

			// If any server is not excluded, set the overall exclusion status of the machine to false.
			if (!excludedServer) {
				excludedMap[machineId] = false;
			}
			workerContribMap[machineId]++;
		} catch (Error&) {
			++failed;
		}
	}

	// Add the status json for each machine with tracked values
	for (auto& mapPair : machineJsonMap) {
		auto& machineId = mapPair.first;
		auto& jsonItem = machineJsonMap[machineId];
		jsonItem["excluded"] = excludedMap[machineId];
		jsonItem["contributing_workers"] = workerContribMap[machineId];
		machineMap[machineId] = jsonItem;
	}

	if (failed > 0)
		incomplete_reasons->insert("Cannot retrieve all machine status information.");

	return machineMap;
}

} // anonymous namespace

JsonBuilderObject getLagObject(int64_t versions) {
	JsonBuilderObject lag;
	lag["versions"] = versions;
	lag["seconds"] = versions / (double)SERVER_KNOBS->VERSIONS_PER_SECOND;
	return lag;
}

static JsonBuilderObject getBounceImpactInfo(int recoveryStatusCode) {
	JsonBuilderObject bounceImpact;

	if (recoveryStatusCode == RecoveryStatus::fully_recovered) {
		bounceImpact["can_clean_bounce"] = true;
	} else {
		bounceImpact["can_clean_bounce"] = false;
		bounceImpact["reason"] = "cluster hasn't fully recovered yet";
	}

	return bounceImpact;
}

struct MachineMemoryInfo {
	double memoryUsage; // virtual memory usage
	double rssUsage; // RSS memory usage
	double aggregateLimit;

	MachineMemoryInfo() : memoryUsage(0), rssUsage(0), aggregateLimit(0) {}

	bool valid() { return memoryUsage >= 0; }
	void invalidate() { memoryUsage = -1; }
};

struct RolesInfo {
	std::multimap<NetworkAddress, JsonBuilderObject> roles;

	JsonBuilderObject addLatencyStatistics(TraceEventFields const& metrics) {
		JsonBuilderObject latencyStats;
		latencyStats.setKeyRawNumber("count", metrics.getValue("Count"));
		latencyStats.setKeyRawNumber("min", metrics.getValue("Min"));
		latencyStats.setKeyRawNumber("max", metrics.getValue("Max"));
		latencyStats.setKeyRawNumber("median", metrics.getValue("Median"));
		latencyStats.setKeyRawNumber("mean", metrics.getValue("Mean"));
		latencyStats.setKeyRawNumber("p25", metrics.getValue("P25"));
		latencyStats.setKeyRawNumber("p90", metrics.getValue("P90"));
		latencyStats.setKeyRawNumber("p95", metrics.getValue("P95"));
		latencyStats.setKeyRawNumber("p99", metrics.getValue("P99"));
		latencyStats.setKeyRawNumber("p99.9", metrics.getValue("P99.9"));

		return latencyStats;
	}

	JsonBuilderObject addLatencyBandInfo(TraceEventFields const& metrics) {
		JsonBuilderObject latencyBands;
		std::map<std::string, JsonBuilderObject> bands;

		for (auto itr = metrics.begin(); itr != metrics.end(); ++itr) {
			std::string band;
			if (itr->first.substr(0, 4) == "Band") {
				band = itr->first.substr(4);
			} else if (itr->first == "Filtered") {
				band = "filtered";
			} else {
				continue;
			}

			latencyBands[band] = StatusCounter(itr->second).getCounter();
		}

		return latencyBands;
	}

	JsonBuilderObject& addRole(NetworkAddress address, std::string const& role, UID id) {
		JsonBuilderObject obj;
		obj["id"] = id.shortString();
		obj["role"] = role;
		return roles.insert(std::make_pair(address, obj))->second;
	}

	JsonBuilderObject& addRole(std::string const& role,
	                           StorageServerStatusInfo& iface,
	                           Version maxTLogVersion,
	                           double* pDataLagSeconds) {
		JsonBuilderObject obj;
		EventMap const& metrics = iface.eventMap;
		double dataLagSeconds = -1.0;
		obj["id"] = iface.id().shortString();
		obj["role"] = role;
		obj["tss"] = iface.isTss();
		if (iface.metadata.present()) {
			obj["storage_metadata"] = iface.metadata.get().toJSON();
			// printf("%s\n", metadataObj.getJson().c_str());
		}

		try {
			TraceEventFields const& storageMetrics = metrics.at("StorageMetrics");

			obj.setKeyRawNumber("stored_bytes", storageMetrics.getValue("BytesStored"));
			obj.setKeyRawNumber("kvstore_used_bytes", storageMetrics.getValue("KvstoreBytesUsed"));
			obj.setKeyRawNumber("kvstore_free_bytes", storageMetrics.getValue("KvstoreBytesFree"));
			obj.setKeyRawNumber("kvstore_available_bytes", storageMetrics.getValue("KvstoreBytesAvailable"));
			obj.setKeyRawNumber("kvstore_total_bytes", storageMetrics.getValue("KvstoreBytesTotal"));
			obj.setKeyRawNumber("kvstore_total_size", storageMetrics.getValue("KvstoreSizeTotal"));
			obj.setKeyRawNumber("kvstore_total_nodes", storageMetrics.getValue("KvstoreNodeTotal"));
			obj.setKeyRawNumber("kvstore_inline_keys", storageMetrics.getValue("KvstoreInlineKey"));
			obj["input_bytes"] = StatusCounter(storageMetrics.getValue("BytesInput")).getStatus();
			obj["durable_bytes"] = StatusCounter(storageMetrics.getValue("BytesDurable")).getStatus();
			obj.setKeyRawNumber("query_queue_max", storageMetrics.getValue("QueryQueueMax"));
			obj["total_queries"] = StatusCounter(storageMetrics.getValue("QueryQueue")).getStatus();
			obj["finished_queries"] = StatusCounter(storageMetrics.getValue("FinishedQueries")).getStatus();
			obj["low_priority_queries"] = StatusCounter(storageMetrics.getValue("LowPriorityQueries")).getStatus();
			obj["bytes_queried"] = StatusCounter(storageMetrics.getValue("BytesQueried")).getStatus();
			obj["keys_queried"] = StatusCounter(storageMetrics.getValue("RowsQueried")).getStatus();
			obj["mutation_bytes"] = StatusCounter(storageMetrics.getValue("MutationBytes")).getStatus();
			obj["mutations"] = StatusCounter(storageMetrics.getValue("Mutations")).getStatus();
			obj.setKeyRawNumber("local_rate", storageMetrics.getValue("LocalRate"));
			obj["fetched_versions"] = StatusCounter(storageMetrics.getValue("FetchedVersions")).getStatus();
			obj["fetches_from_logs"] = StatusCounter(storageMetrics.getValue("FetchesFromLogs")).getStatus();
			obj["rocksdb_version"] = storageMetrics.getValue("RocksDBVersion");

			Version version = storageMetrics.getInt64("Version");
			Version durableVersion = storageMetrics.getInt64("DurableVersion");

			obj["data_version"] = version;
			obj["durable_version"] = durableVersion;

			int64_t versionLag = storageMetrics.getInt64("VersionLag");
			if (maxTLogVersion > 0) {
				// It's possible that the storage server hasn't talked to the logs recently, in which case it may not be
				// aware of how far behind it is. To account for that, we also compute the version difference between
				// each storage server and the tlog with the largest version.
				//
				// Because this data is only logged periodically, this difference will likely be an overestimate for the
				// lag. We subtract off the logging interval in order to make this estimate a bounded underestimate
				// instead.
				versionLag = std::max<int64_t>(
				    versionLag,
				    maxTLogVersion - version - SERVER_KNOBS->STORAGE_LOGGING_DELAY * SERVER_KNOBS->VERSIONS_PER_SECOND);
			}

			TraceEventFields const& readLatencyMetrics = metrics.at("ReadLatencyMetrics");
			if (readLatencyMetrics.size()) {
				obj["read_latency_statistics"] = addLatencyStatistics(readLatencyMetrics);
			}

			TraceEventFields const& readLatencyBands = metrics.at("ReadLatencyBands");
			if (readLatencyBands.size()) {
				obj["read_latency_bands"] = addLatencyBandInfo(readLatencyBands);
			}

			obj["data_lag"] = getLagObject(versionLag);
			obj["durability_lag"] = getLagObject(version - durableVersion);
			dataLagSeconds = versionLag / (double)SERVER_KNOBS->VERSIONS_PER_SECOND;

			TraceEventFields const& busiestReadTag = metrics.at("BusiestReadTag");
			if (busiestReadTag.size()) {
				int64_t tagCost = busiestReadTag.getInt64("TagCost");
				if (tagCost > 0) {
					JsonBuilderObject busiestReadTagObj;
					busiestReadTagObj["tag"] = busiestReadTag.getValue("Tag");
					busiestReadTagObj["cost"] = tagCost;
					busiestReadTagObj["fractional_cost"] = busiestReadTag.getValue("FractionalBusyness");
					obj["busiest_read_tag"] = busiestReadTagObj;
				}
			}

			TraceEventFields const& busiestWriteTag = metrics.at("BusiestWriteTag");
			if (busiestWriteTag.size()) {
				int64_t tagCost = busiestWriteTag.getInt64("TagCost");

				if (tagCost > 0) {
					JsonBuilderObject busiestWriteTagObj;

					int64_t totalCost = busiestWriteTag.getInt64("TotalCost");
					ASSERT(totalCost > 0);

					busiestWriteTagObj["tag"] = busiestWriteTag.getValue("Tag");
					busiestWriteTagObj["fractional_cost"] = (double)tagCost / totalCost;

					double elapsed = busiestWriteTag.getDouble("Elapsed");
					if (elapsed > 0) {
						JsonBuilderObject estimatedCostObj;
						estimatedCostObj["hz"] = tagCost / elapsed;
						busiestWriteTagObj["estimated_cost"] = estimatedCostObj;
					}

					obj["busiest_write_tag"] = busiestWriteTagObj;
				}
			}

			TraceEventFields const& rocksdbMetrics = metrics.at("RocksDBMetrics");
			if (rocksdbMetrics.size()) {
				JsonBuilderObject rocksdbMetricsObj;
				rocksdbMetricsObj.setKeyRawNumber("block_cache_hits", rocksdbMetrics.getValue("BlockCacheHits"));
				rocksdbMetricsObj.setKeyRawNumber("block_cache_misses", rocksdbMetrics.getValue("BlockCacheMisses"));
				rocksdbMetricsObj.setKeyRawNumber("pending_compaction_bytes",
				                                  rocksdbMetrics.getValue("EstPendCompactBytes"));
				rocksdbMetricsObj.setKeyRawNumber("memtable_bytes", rocksdbMetrics.getValue("AllMemtablesBytes"));
				rocksdbMetricsObj.setKeyRawNumber("sst_reader_bytes",
				                                  rocksdbMetrics.getValue("EstimateSstReaderBytes"));
				rocksdbMetricsObj.setKeyRawNumber("block_cache_usage", rocksdbMetrics.getValue("BlockCacheUsage"));
				rocksdbMetricsObj.setKeyRawNumber("block_cache_limit", rocksdbMetrics.getValue("BlockCacheSize"));
				rocksdbMetricsObj.setKeyRawNumber("throttled_commits", rocksdbMetrics.getValue("CommitDelayed"));
				rocksdbMetricsObj.setKeyRawNumber("write_stall_microseconds", rocksdbMetrics.getValue("StallMicros"));

				obj["rocksdb_metrics"] = std::move(rocksdbMetricsObj);
			}

		} catch (AttributeNotFoundError& e) {
			TraceEvent(SevWarnAlways, "StorageServerStatusJson")
			    .suppressFor(5.0)
			    .detail("MissingAttribute", e.getMissingAttribute());
		}
		if (pDataLagSeconds) {
			*pDataLagSeconds = dataLagSeconds;
		}

		return roles.insert(std::make_pair(iface.address(), obj))->second;
	}
	JsonBuilderObject& addRole(std::string const& role,
	                           TLogInterface& iface,
	                           EventMap const& metrics,
	                           Version* pMetricVersion) {
		JsonBuilderObject obj;
		Version metricVersion = 0;
		obj["id"] = iface.id().shortString();
		obj["role"] = role;
		try {
			TraceEventFields const& tlogMetrics = metrics.at("TLogMetrics");

			obj.setKeyRawNumber("kvstore_used_bytes", tlogMetrics.getValue("KvstoreBytesUsed"));
			obj.setKeyRawNumber("kvstore_free_bytes", tlogMetrics.getValue("KvstoreBytesFree"));
			obj.setKeyRawNumber("kvstore_available_bytes", tlogMetrics.getValue("KvstoreBytesAvailable"));
			obj.setKeyRawNumber("kvstore_total_bytes", tlogMetrics.getValue("KvstoreBytesTotal"));
			obj.setKeyRawNumber("queue_disk_used_bytes", tlogMetrics.getValue("QueueDiskBytesUsed"));
			obj.setKeyRawNumber("queue_disk_free_bytes", tlogMetrics.getValue("QueueDiskBytesFree"));
			obj.setKeyRawNumber("queue_disk_available_bytes", tlogMetrics.getValue("QueueDiskBytesAvailable"));
			obj.setKeyRawNumber("queue_disk_total_bytes", tlogMetrics.getValue("QueueDiskBytesTotal"));
			obj["input_bytes"] = StatusCounter(tlogMetrics.getValue("BytesInput")).getStatus();
			obj["durable_bytes"] = StatusCounter(tlogMetrics.getValue("BytesDurable")).getStatus();
			metricVersion = tlogMetrics.getInt64("Version");
			obj["data_version"] = metricVersion;
		} catch (Error& e) {
			if (e.code() != error_code_attribute_not_found)
				throw e;
		}
		if (pMetricVersion)
			*pMetricVersion = metricVersion;
		return roles.insert(std::make_pair(iface.address(), obj))->second;
	}
	JsonBuilderObject& addRole(std::string const& role, CommitProxyInterface& iface, EventMap const& metrics) {
		JsonBuilderObject obj;
		obj["id"] = iface.id().shortString();
		obj["role"] = role;
		try {
			TraceEventFields const& commitLatencyMetrics = metrics.at("CommitLatencyMetrics");
			if (commitLatencyMetrics.size()) {
				obj["commit_latency_statistics"] = addLatencyStatistics(commitLatencyMetrics);
			}

			TraceEventFields const& commitLatencyBands = metrics.at("CommitLatencyBands");
			if (commitLatencyBands.size()) {
				obj["commit_latency_bands"] = addLatencyBandInfo(commitLatencyBands);
			}

			TraceEventFields const& commitBatchingWindowSize = metrics.at("CommitBatchingWindowSize");
			if (commitBatchingWindowSize.size()) {
				obj["commit_batching_window_size"] = addLatencyStatistics(commitBatchingWindowSize);
			}
		} catch (Error& e) {
			if (e.code() != error_code_attribute_not_found) {
				throw e;
			}
		}

		return roles.insert(std::make_pair(iface.address(), obj))->second;
	}

	// Returns a json object encoding a snapshot of grv proxy statistics
	JsonBuilderObject& addRole(std::string const& role, GrvProxyInterface& iface, EventMap const& metrics) {
		JsonBuilderObject obj;
		obj["id"] = iface.id().shortString();
		obj["role"] = role;
		try {
			JsonBuilderObject priorityStats;

			// GRV Latency metrics are grouped according to priority (currently batch or default).
			// Other priorities can be added in the future.
			TraceEventFields const& grvLatencyMetrics = metrics.at("GRVLatencyMetrics");
			if (grvLatencyMetrics.size()) {
				priorityStats["default"] = addLatencyStatistics(grvLatencyMetrics);
			}

			TraceEventFields const& grvBatchMetrics = metrics.at("GRVBatchLatencyMetrics");
			if (grvBatchMetrics.size()) {
				priorityStats["batch"] = addLatencyStatistics(grvBatchMetrics);
			}

			// Add GRV Latency metrics (for all priorities) to parent node.
			if (priorityStats.size()) {
				obj["grv_latency_statistics"] = priorityStats;
			}

			TraceEventFields const& grvLatencyBands = metrics.at("GRVLatencyBands");
			if (grvLatencyBands.size()) {
				obj["grv_latency_bands"] = addLatencyBandInfo(grvLatencyBands);
			}
		} catch (Error& e) {
			if (e.code() != error_code_attribute_not_found) {
				throw e;
			}
		}

		return roles.insert(std::make_pair(iface.address(), obj))->second;
	}
	template <class InterfaceType>
	JsonBuilderObject& addRole(std::string const& role, InterfaceType& iface) {
		return addRole(iface.address(), role, iface.id());
	}
	JsonBuilderObject& addCoordinatorRole(NetworkAddress addr) {
		JsonBuilderObject obj;
		obj["role"] = "coordinator";
		return roles.insert(std::make_pair(addr, obj))->second;
	}
	JsonBuilderArray getStatusForAddress(NetworkAddress a) {
		JsonBuilderArray v;
		auto it = roles.lower_bound(a);
		while (it != roles.end() && it->first == a) {
			v.push_back(it->second);
			++it;
		}
		return v;
	}
};

															#line 1309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via processStatusFetcher()
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class ProcessStatusFetcherActor>
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class ProcessStatusFetcherActorState {
															#line 1316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	ProcessStatusFetcherActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::vector<WorkerDetails> const& workers,WorkerEvents const& pMetrics,WorkerEvents const& mMetrics,WorkerEvents const& nMetrics,WorkerEvents const& errors,WorkerEvents const& traceFileOpenErrors,WorkerEvents const& programStarts,std::map<std::string, std::vector<JsonBuilderObject>> const& processIssues,std::vector<StorageServerStatusInfo> const& storageServers,std::vector<std::pair<TLogInterface, EventMap>> const& tLogs,std::vector<std::pair<CommitProxyInterface, EventMap>> const& commitProxies,std::vector<std::pair<GrvProxyInterface, EventMap>> const& grvProxies,std::vector<BlobWorkerInterface> const& blobWorkers,ServerCoordinators const& coordinators,std::vector<NetworkAddress> const& coordinatorAddresses,Database const& cx,Optional<DatabaseConfiguration> const& configuration,Optional<Key> const& healthyZone,std::set<std::string>* const& incomplete_reasons) 
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   workers(workers),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   pMetrics(pMetrics),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   mMetrics(mMetrics),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   nMetrics(nMetrics),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   errors(errors),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   traceFileOpenErrors(traceFileOpenErrors),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   programStarts(programStarts),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   processIssues(processIssues),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   storageServers(storageServers),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   tLogs(tLogs),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   commitProxies(commitProxies),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   grvProxies(grvProxies),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   blobWorkers(blobWorkers),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   coordinators(coordinators),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   coordinatorAddresses(coordinatorAddresses),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   cx(cx),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   configuration(configuration),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   healthyZone(healthyZone),
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   processMap(),
															#line 790 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   tracefileOpenErrorMap(),
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   traceFileErrorsItr()
															#line 1367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("processStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~ProcessStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("processStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			traceFileErrorsItr = traceFileOpenErrors.begin();
															#line 1382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessStatusFetcherActorState();
		static_cast<ProcessStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 817 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		machineMemoryUsage = std::map<Optional<Standalone<StringRef>>, MachineMemoryInfo>();
															#line 818 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		workerItr = std::vector<WorkerDetails>::iterator();
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		workerItr = workers.begin();
															#line 1409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!(traceFileErrorsItr != traceFileOpenErrors.end()))
															#line 1425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 0, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 1438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (traceFileErrorsItr->second.size())
															#line 1460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			try {
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				const TraceEventFields& event = traceFileErrorsItr->second;
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				std::string fileName = event.getValue("Filename");
															#line 800 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject msgObj = JsonString::makeMessage( "file_open_error", format("Could not open file '%s' (%s).", fileName.c_str(), event.getValue("Error").c_str()) .c_str());
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				msgObj["file_name"] = fileName;
															#line 807 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				tracefileOpenErrorMap[traceFileErrorsItr->first.toString()] = msgObj;
															#line 1473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (traceFileErrorsItr->second.size())
															#line 1493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			try {
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				const TraceEventFields& event = traceFileErrorsItr->second;
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				std::string fileName = event.getValue("Filename");
															#line 800 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject msgObj = JsonString::makeMessage( "file_open_error", format("Could not open file '%s' (%s).", fileName.c_str(), event.getValue("Error").c_str()) .c_str());
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				msgObj["file_name"] = fileName;
															#line 807 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				tracefileOpenErrorMap[traceFileErrorsItr->first.toString()] = msgObj;
															#line 1506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++traceFileErrorsItr;
															#line 1601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1621 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 812 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("file_open_error details could not be retrieved");
															#line 1625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		roles = RolesInfo();
															#line 844 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("master", db->get().master);
															#line 845 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("cluster_controller", db->get().clusterInterface.clientInterface);
															#line 847 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().distributor.present())
															#line 1659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("data_distributor", db->get().distributor.get());
															#line 1663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 851 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 1667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("ratekeeper", db->get().ratekeeper.get());
															#line 1671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 855 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (configuration.present() && configuration.get().blobGranulesEnabled && db->get().blobManager.present())
															#line 1675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("blob_manager", db->get().blobManager.get());
															#line 1679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 859 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (configuration.present() && configuration.get().blobGranulesEnabled && db->get().blobMigrator.present())
															#line 1683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 860 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("blob_migrator", db->get().blobMigrator.get());
															#line 1687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 863 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().consistencyScan.present())
															#line 1691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 864 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("consistency_scan", db->get().consistencyScan.get());
															#line 1695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().client.encryptKeyProxy.present())
															#line 1699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("encrypt_key_proxy", db->get().client.encryptKeyProxy.get());
															#line 1703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& tLogSet : db->get().logSystemConfig.tLogs ) {
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			for( auto& it : tLogSet.logRouters ) {
															#line 873 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (it.present())
															#line 1711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 874 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					roles.addRole("router", it.interf());
															#line 1715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
		}
															#line 879 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		oldTLogIter = std::vector<OldTLogConf>::const_iterator();
															#line 880 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		oldTLogs = db->get().logSystemConfig.oldTLogs;
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		oldTLogIter = oldTLogs.begin();
															#line 1725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!(workerItr != workers.end()))
															#line 1741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 1, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 1754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 821 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		memInfo = machineMemoryUsage.insert(std::make_pair(workerItr->interf.locality.machineId(), MachineMemoryInfo())) .first;
															#line 1776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		try {
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(pMetrics.contains(workerItr->interf.address()));
															#line 826 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& processMetrics = pMetrics[workerItr->interf.address()];
															#line 827 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& programStart = programStarts[workerItr->interf.address()];
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (memInfo->second.valid())
															#line 1786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (processMetrics.size() > 0 && programStart.size() > 0)
															#line 1790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 831 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.memoryUsage += processMetrics.getDouble("Memory");
															#line 832 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.rssUsage += processMetrics.getDouble("ResidentMemory");
															#line 833 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.aggregateLimit += programStart.getDouble("MemoryLimit");
															#line 1798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
				else
				{
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.invalidate();
															#line 1804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
			loopDepth = a_body1cont1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 821 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		memInfo = machineMemoryUsage.insert(std::make_pair(workerItr->interf.locality.machineId(), MachineMemoryInfo())) .first;
															#line 1821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		try {
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(pMetrics.contains(workerItr->interf.address()));
															#line 826 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& processMetrics = pMetrics[workerItr->interf.address()];
															#line 827 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& programStart = programStarts[workerItr->interf.address()];
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (memInfo->second.valid())
															#line 1831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (processMetrics.size() > 0 && programStart.size() > 0)
															#line 1835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 831 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.memoryUsage += processMetrics.getDouble("Memory");
															#line 832 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.rssUsage += processMetrics.getDouble("ResidentMemory");
															#line 833 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.aggregateLimit += programStart.getDouble("MemoryLimit");
															#line 1843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
				else
				{
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.invalidate();
															#line 1849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
			loopDepth = a_body1cont1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++workerItr;
															#line 1941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			memInfo->second.invalidate();
															#line 1951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 897 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( const auto& coordinator : coordinatorAddresses ) {
															#line 898 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			roles.addCoordinatorRole(coordinator);
															#line 1981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 901 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		commit_proxy = std::vector<std::pair<CommitProxyInterface, EventMap>>::iterator();
															#line 902 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		commit_proxy = commitProxies.begin();
															#line 1987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!(oldTLogIter != oldTLogs.end()))
															#line 2003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 882 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& tLogSet : oldTLogIter->tLogs ) {
															#line 883 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			for( auto& it : tLogSet.tLogs ) {
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (it.present())
															#line 2013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 885 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					roles.addRole("log", it.interf());
															#line 2017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 888 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			for( auto& it : tLogSet.logRouters ) {
															#line 889 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (it.present())
															#line 2024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					roles.addRole("router", it.interf());
															#line 2028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
		}
															#line 894 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_2 = yield();
															#line 894 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 894 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 2, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++oldTLogIter;
															#line 2063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++oldTLogIter;
															#line 2072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont13(int loopDepth) 
	{
															#line 907 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		grvProxy = std::vector<std::pair<GrvProxyInterface, EventMap>>::iterator();
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		grvProxy = grvProxies.begin();
															#line 2158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont13loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 902 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!(commit_proxy != commitProxies.end()))
															#line 2174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 903 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("commit_proxy", commit_proxy->first, commit_proxy->second);
															#line 904 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 904 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 904 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 3, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 902 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++commit_proxy;
															#line 2211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 902 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++commit_proxy;
															#line 2220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont13cont1(int loopDepth) 
	{
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		log = std::vector<std::pair<TLogInterface, EventMap>>::iterator();
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		maxTLogVersion = 0;
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		log = tLogs.begin();
															#line 2308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont13cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont13loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13loopBody1(int loopDepth) 
	{
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!(grvProxy != grvProxies.end()))
															#line 2324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont13break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("grv_proxy", grvProxy->first, grvProxy->second);
															#line 910 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_4 = yield();
															#line 910 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont13loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 5;
															#line 910 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 4, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13break1(int loopDepth) 
	{
		try {
			return a_body1cont13cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++grvProxy;
															#line 2361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++grvProxy;
															#line 2370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont13loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont13loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont13cont2(int loopDepth) 
	{
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		ss = std::vector<StorageServerStatusInfo>::iterator();
															#line 925 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		ssLag = std::map<NetworkAddress, double>();
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		lagSeconds = double();
															#line 927 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		ss = storageServers.begin();
															#line 2460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont13cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont13cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1(int loopDepth) 
	{
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!(log != tLogs.end()))
															#line 2476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont13cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		Version tLogVersion = 0;
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("log", log->first, log->second, &tLogVersion);
															#line 920 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		maxTLogVersion = std::max(maxTLogVersion, tLogVersion);
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_5 = yield();
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont13cont1loopBody1when1(__when_expr_5.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 6;
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 5, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont13cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++log;
															#line 2517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++log;
															#line 2526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont13cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont13cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont13cont3(int loopDepth) 
	{
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		res = std::vector<ResolverInterface>::const_iterator();
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		resolvers = db->get().resolvers;
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		res = resolvers.begin();
															#line 2614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont13cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont13cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont2loopBody1(int loopDepth) 
	{
															#line 927 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!(ss != storageServers.end()))
															#line 2630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont13cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 928 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("storage", *ss, maxTLogVersion, &lagSeconds);
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (lagSeconds != -1.0)
															#line 2638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			ssLag[ss->address()] = lagSeconds;
															#line 2642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 932 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_6 = yield();
															#line 932 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont13cont2loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 7;
															#line 932 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 6, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont13cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 927 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++ss;
															#line 2675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 927 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++ss;
															#line 2684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont13cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont13cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont13cont4(int loopDepth) 
	{
															#line 942 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (configuration.present() && configuration.get().blobGranulesEnabled)
															#line 2768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			RangeForbody1cont13cont4Iterator0 = std::begin(blobWorkers);
															#line 2772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont13cont4loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont13cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont13cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont3loopBody1(int loopDepth) 
	{
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!(res != resolvers.end()))
															#line 2793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont13cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 938 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("resolver", *res);
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_7 = yield();
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont13cont3loopBody1when1(__when_expr_7.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 8;
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 7, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont13cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++res;
															#line 2830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++res;
															#line 2839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont13cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont13cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont13cont5(int loopDepth) 
	{
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		workerItr = workers.begin();
															#line 2923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont13cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont6(int loopDepth) 
	{
		loopDepth = a_body1cont13cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont13cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont4loopBody1(int loopDepth) 
	{
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!(RangeForbody1cont13cont4Iterator0 != std::end(blobWorkers)))
															#line 2945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont13cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		auto blobWorker = *RangeForbody1cont13cont4Iterator0;
															#line 2951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 944 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("blob_worker", blobWorker);
															#line 945 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_8 = yield();
															#line 945 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont13cont4loopBody1when1(__when_expr_8.get(), loopDepth); };
			static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 9;
															#line 945 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 8, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont13cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont13cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont4loopBody1cont1(int loopDepth) 
	{
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++RangeForbody1cont13cont4Iterator0;
															#line 2987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont4loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont4loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont4loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont4loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont13cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont13cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont13cont7(int loopDepth) 
	{
															#line 1144 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ProcessStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(processMap); this->~ProcessStatusFetcherActorState(); static_cast<ProcessStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 3083 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<ProcessStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(processMap)); // state_var_RVO
		this->~ProcessStatusFetcherActorState();
		static_cast<ProcessStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont13cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont13cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1(int loopDepth) 
	{
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!(workerItr != workers.end()))
															#line 3102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont13cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_9 = yield();
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont13cont5loopBody1when1(__when_expr_9.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 10;
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 9, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 3115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13cont5break1(int loopDepth) 
	{
		try {
			return a_body1cont13cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 951 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj = JsonBuilderObject();
															#line 3137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		try {
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(pMetrics.contains(workerItr->interf.address()));
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			NetworkAddress address = workerItr->interf.address();
															#line 956 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& processMetrics = pMetrics[workerItr->interf.address()];
															#line 957 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["address"] = address.toString();
															#line 958 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject memoryObj;
															#line 960 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics.size() > 0)
															#line 3151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 961 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				std::string zoneID = processMetrics.getValue("ZoneID");
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["fault_domain"] = zoneID;
															#line 963 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (healthyZone.present() && healthyZone == workerItr->interf.locality.zoneId())
															#line 3159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["under_maintenance"] = true;
															#line 3163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
															#line 967 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				std::string MachineID = processMetrics.getValue("MachineID");
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["machine_id"] = MachineID;
															#line 970 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["locality"] = workerItr->interf.locality.toJSON<JsonBuilderObject>();
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj.setKeyRawNumber("uptime_seconds", processMetrics.getValue("UptimeSeconds"));
															#line 975 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double processMetricsElapsed = processMetrics.getDouble("Elapsed");
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double cpuSeconds = processMetrics.getDouble("CPUSeconds");
															#line 977 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double diskIdleSeconds = processMetrics.getDouble("DiskIdleSeconds");
															#line 978 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double diskReads = processMetrics.getDouble("DiskReads");
															#line 979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double diskWrites = processMetrics.getDouble("DiskWrites");
															#line 981 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject diskObj;
															#line 982 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (processMetricsElapsed > 0)
															#line 3187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 983 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject cpuObj;
															#line 984 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					cpuObj["usage_cores"] = std::max(0.0, cpuSeconds / processMetricsElapsed);
															#line 985 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["cpu"] = cpuObj;
															#line 987 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["busy"] = std::max(0.0, std::min((processMetricsElapsed - diskIdleSeconds) / processMetricsElapsed, 1.0));
															#line 990 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject readsObj;
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					readsObj.setKeyRawNumber("counter", processMetrics.getValue("DiskReadsCount"));
															#line 992 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					if (processMetricsElapsed > 0)
															#line 3203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					{
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						readsObj["hz"] = diskReads / processMetricsElapsed;
															#line 3207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					}
															#line 994 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					readsObj.setKeyRawNumber("sectors", processMetrics.getValue("DiskReadSectors"));
															#line 996 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject writesObj;
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					writesObj.setKeyRawNumber("counter", processMetrics.getValue("DiskWritesCount"));
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					if (processMetricsElapsed > 0)
															#line 3217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					{
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						writesObj["hz"] = diskWrites / processMetricsElapsed;
															#line 3221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					}
															#line 1000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					writesObj.setKeyRawNumber("sectors", processMetrics.getValue("DiskWriteSectors"));
															#line 1002 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["reads"] = readsObj;
															#line 1003 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["writes"] = writesObj;
															#line 3229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				diskObj.setKeyRawNumber("total_bytes", processMetrics.getValue("DiskTotalBytes"));
															#line 1007 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				diskObj.setKeyRawNumber("free_bytes", processMetrics.getValue("DiskFreeBytes"));
															#line 1008 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["disk"] = diskObj;
															#line 1010 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject networkObj;
															#line 1012 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				networkObj.setKeyRawNumber("current_connections", processMetrics.getValue("CurrentConnections"));
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connections_established;
															#line 1014 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				connections_established.setKeyRawNumber("hz", processMetrics.getValue("ConnectionsEstablished"));
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connections_established"] = connections_established;
															#line 1016 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connections_closed;
															#line 1017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				connections_closed.setKeyRawNumber("hz", processMetrics.getValue("ConnectionsClosed"));
															#line 1018 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connections_closed"] = connections_closed;
															#line 1019 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connection_errors;
															#line 1020 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				connection_errors.setKeyRawNumber("hz", processMetrics.getValue("ConnectionErrors"));
															#line 1021 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connection_errors"] = connection_errors;
															#line 1023 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject megabits_sent;
															#line 1024 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				megabits_sent.setKeyRawNumber("hz", processMetrics.getValue("MbpsSent"));
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["megabits_sent"] = megabits_sent;
															#line 1027 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject megabits_received;
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				megabits_received.setKeyRawNumber("hz", processMetrics.getValue("MbpsReceived"));
															#line 1029 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["megabits_received"] = megabits_received;
															#line 1031 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject tls_policy_failures;
															#line 1032 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				tls_policy_failures.setKeyRawNumber("hz", processMetrics.getValue("TLSPolicyFailures"));
															#line 1033 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["tls_policy_failures"] = tls_policy_failures;
															#line 1035 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["network"] = networkObj;
															#line 1037 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("used_bytes", processMetrics.getValue("Memory"));
															#line 1038 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("rss_bytes", processMetrics.getValue("ResidentMemory"));
															#line 1039 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("unused_allocated_memory", processMetrics.getValue("UnusedAllocatedMemory"));
															#line 3285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1042 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int64_t memoryLimit = 0;
															#line 1043 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (programStarts.contains(address))
															#line 3291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				auto const& programStartEvent = programStarts.at(address);
															#line 1046 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (programStartEvent.size() > 0)
															#line 3297 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1047 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					memoryLimit = programStartEvent.getInt64("MemoryLimit");
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					memoryObj.setKey("limit_bytes", memoryLimit);
															#line 1050 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					std::string version;
															#line 1051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					if (programStartEvent.tryGetValue("Version", version))
															#line 3307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					{
															#line 1052 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						statusObj["version"] = version;
															#line 3311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					}
															#line 1055 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					std::string commandLine;
															#line 1056 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					if (programStartEvent.tryGetValue("CommandLine", commandLine))
															#line 3317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					{
															#line 1057 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						statusObj["command_line"] = commandLine;
															#line 3321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					}
				}
			}
															#line 1063 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (mMetrics.contains(address) && mMetrics[address].size())
															#line 3327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1064 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double availableMemory;
															#line 1065 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				availableMemory = mMetrics[address].getDouble("AvailableMemory");
															#line 1067 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				auto machineMemInfo = machineMemoryUsage[workerItr->interf.locality.machineId()];
															#line 1068 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (machineMemInfo.valid() && memoryLimit > 0)
															#line 3337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1069 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					ASSERT(machineMemInfo.aggregateLimit > 0);
															#line 1070 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					int64_t memory = (availableMemory + machineMemInfo.rssUsage) * memoryLimit / machineMemInfo.aggregateLimit;
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					memoryObj["available_bytes"] = std::min<int64_t>(std::max<int64_t>(memory, 0), memoryLimit);
															#line 3345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 1076 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["memory"] = memoryObj;
															#line 1078 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderArray messages;
															#line 1080 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (errors.contains(address) && errors[address].size())
															#line 3354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(getError(errors.at(address)));
															#line 3358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1086 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			std::string strAddress = address.toString();
															#line 1089 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			for( auto issue : processIssues[strAddress] ) {
															#line 1090 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(issue);
															#line 3366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1094 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (tracefileOpenErrorMap.contains(strAddress))
															#line 3370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1095 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(tracefileOpenErrorMap[strAddress]);
															#line 3374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1098 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (ssLag[address] >= 60)
															#line 3378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1099 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(JsonString::makeMessage( "storage_server_lagging", format("Storage server lagging by %lld seconds.", (int64_t)ssLag[address]).c_str()));
															#line 3382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1105 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["messages"] = messages;
															#line 1108 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["roles"] = roles.getStatusForAddress(address);
															#line 1110 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (configuration.present())
															#line 3390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1111 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["excluded"] = configuration.get().isExcludedServer(workerItr->interf.addresses(), workerItr->interf.locality);
															#line 3394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["class_type"] = workerItr->processClass.toString();
															#line 1116 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["class_source"] = workerItr->processClass.sourceString();
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (workerItr->degraded)
															#line 3402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["degraded"] = true;
															#line 3406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1121 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& networkMetrics = nMetrics[workerItr->interf.address()];
															#line 1122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			double networkMetricsElapsed = networkMetrics.getDouble("Elapsed");
															#line 3412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			try {
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double runLoopBusy = networkMetrics.getDouble("PriorityStarvedBelow1");
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["run_loop_busy"] = runLoopBusy / networkMetricsElapsed;
															#line 3418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1cont13cont5loopBody1cont23(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont13cont5loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont13cont5loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 951 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj = JsonBuilderObject();
															#line 3439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		try {
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(pMetrics.contains(workerItr->interf.address()));
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			NetworkAddress address = workerItr->interf.address();
															#line 956 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& processMetrics = pMetrics[workerItr->interf.address()];
															#line 957 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["address"] = address.toString();
															#line 958 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject memoryObj;
															#line 960 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics.size() > 0)
															#line 3453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 961 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				std::string zoneID = processMetrics.getValue("ZoneID");
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["fault_domain"] = zoneID;
															#line 963 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (healthyZone.present() && healthyZone == workerItr->interf.locality.zoneId())
															#line 3461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["under_maintenance"] = true;
															#line 3465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
															#line 967 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				std::string MachineID = processMetrics.getValue("MachineID");
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["machine_id"] = MachineID;
															#line 970 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["locality"] = workerItr->interf.locality.toJSON<JsonBuilderObject>();
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj.setKeyRawNumber("uptime_seconds", processMetrics.getValue("UptimeSeconds"));
															#line 975 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double processMetricsElapsed = processMetrics.getDouble("Elapsed");
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double cpuSeconds = processMetrics.getDouble("CPUSeconds");
															#line 977 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double diskIdleSeconds = processMetrics.getDouble("DiskIdleSeconds");
															#line 978 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double diskReads = processMetrics.getDouble("DiskReads");
															#line 979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double diskWrites = processMetrics.getDouble("DiskWrites");
															#line 981 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject diskObj;
															#line 982 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (processMetricsElapsed > 0)
															#line 3489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 983 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject cpuObj;
															#line 984 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					cpuObj["usage_cores"] = std::max(0.0, cpuSeconds / processMetricsElapsed);
															#line 985 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["cpu"] = cpuObj;
															#line 987 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["busy"] = std::max(0.0, std::min((processMetricsElapsed - diskIdleSeconds) / processMetricsElapsed, 1.0));
															#line 990 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject readsObj;
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					readsObj.setKeyRawNumber("counter", processMetrics.getValue("DiskReadsCount"));
															#line 992 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					if (processMetricsElapsed > 0)
															#line 3505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					{
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						readsObj["hz"] = diskReads / processMetricsElapsed;
															#line 3509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					}
															#line 994 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					readsObj.setKeyRawNumber("sectors", processMetrics.getValue("DiskReadSectors"));
															#line 996 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject writesObj;
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					writesObj.setKeyRawNumber("counter", processMetrics.getValue("DiskWritesCount"));
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					if (processMetricsElapsed > 0)
															#line 3519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					{
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						writesObj["hz"] = diskWrites / processMetricsElapsed;
															#line 3523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					}
															#line 1000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					writesObj.setKeyRawNumber("sectors", processMetrics.getValue("DiskWriteSectors"));
															#line 1002 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["reads"] = readsObj;
															#line 1003 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["writes"] = writesObj;
															#line 3531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				diskObj.setKeyRawNumber("total_bytes", processMetrics.getValue("DiskTotalBytes"));
															#line 1007 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				diskObj.setKeyRawNumber("free_bytes", processMetrics.getValue("DiskFreeBytes"));
															#line 1008 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["disk"] = diskObj;
															#line 1010 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject networkObj;
															#line 1012 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				networkObj.setKeyRawNumber("current_connections", processMetrics.getValue("CurrentConnections"));
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connections_established;
															#line 1014 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				connections_established.setKeyRawNumber("hz", processMetrics.getValue("ConnectionsEstablished"));
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connections_established"] = connections_established;
															#line 1016 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connections_closed;
															#line 1017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				connections_closed.setKeyRawNumber("hz", processMetrics.getValue("ConnectionsClosed"));
															#line 1018 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connections_closed"] = connections_closed;
															#line 1019 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connection_errors;
															#line 1020 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				connection_errors.setKeyRawNumber("hz", processMetrics.getValue("ConnectionErrors"));
															#line 1021 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connection_errors"] = connection_errors;
															#line 1023 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject megabits_sent;
															#line 1024 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				megabits_sent.setKeyRawNumber("hz", processMetrics.getValue("MbpsSent"));
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["megabits_sent"] = megabits_sent;
															#line 1027 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject megabits_received;
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				megabits_received.setKeyRawNumber("hz", processMetrics.getValue("MbpsReceived"));
															#line 1029 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["megabits_received"] = megabits_received;
															#line 1031 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject tls_policy_failures;
															#line 1032 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				tls_policy_failures.setKeyRawNumber("hz", processMetrics.getValue("TLSPolicyFailures"));
															#line 1033 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["tls_policy_failures"] = tls_policy_failures;
															#line 1035 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["network"] = networkObj;
															#line 1037 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("used_bytes", processMetrics.getValue("Memory"));
															#line 1038 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("rss_bytes", processMetrics.getValue("ResidentMemory"));
															#line 1039 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("unused_allocated_memory", processMetrics.getValue("UnusedAllocatedMemory"));
															#line 3587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1042 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int64_t memoryLimit = 0;
															#line 1043 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (programStarts.contains(address))
															#line 3593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				auto const& programStartEvent = programStarts.at(address);
															#line 1046 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (programStartEvent.size() > 0)
															#line 3599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1047 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					memoryLimit = programStartEvent.getInt64("MemoryLimit");
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					memoryObj.setKey("limit_bytes", memoryLimit);
															#line 1050 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					std::string version;
															#line 1051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					if (programStartEvent.tryGetValue("Version", version))
															#line 3609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					{
															#line 1052 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						statusObj["version"] = version;
															#line 3613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					}
															#line 1055 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					std::string commandLine;
															#line 1056 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					if (programStartEvent.tryGetValue("CommandLine", commandLine))
															#line 3619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					{
															#line 1057 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						statusObj["command_line"] = commandLine;
															#line 3623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					}
				}
			}
															#line 1063 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (mMetrics.contains(address) && mMetrics[address].size())
															#line 3629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1064 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double availableMemory;
															#line 1065 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				availableMemory = mMetrics[address].getDouble("AvailableMemory");
															#line 1067 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				auto machineMemInfo = machineMemoryUsage[workerItr->interf.locality.machineId()];
															#line 1068 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (machineMemInfo.valid() && memoryLimit > 0)
															#line 3639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1069 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					ASSERT(machineMemInfo.aggregateLimit > 0);
															#line 1070 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					int64_t memory = (availableMemory + machineMemInfo.rssUsage) * memoryLimit / machineMemInfo.aggregateLimit;
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					memoryObj["available_bytes"] = std::min<int64_t>(std::max<int64_t>(memory, 0), memoryLimit);
															#line 3647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 1076 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["memory"] = memoryObj;
															#line 1078 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderArray messages;
															#line 1080 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (errors.contains(address) && errors[address].size())
															#line 3656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(getError(errors.at(address)));
															#line 3660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1086 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			std::string strAddress = address.toString();
															#line 1089 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			for( auto issue : processIssues[strAddress] ) {
															#line 1090 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(issue);
															#line 3668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1094 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (tracefileOpenErrorMap.contains(strAddress))
															#line 3672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1095 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(tracefileOpenErrorMap[strAddress]);
															#line 3676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1098 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (ssLag[address] >= 60)
															#line 3680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1099 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(JsonString::makeMessage( "storage_server_lagging", format("Storage server lagging by %lld seconds.", (int64_t)ssLag[address]).c_str()));
															#line 3684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1105 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["messages"] = messages;
															#line 1108 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["roles"] = roles.getStatusForAddress(address);
															#line 1110 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (configuration.present())
															#line 3692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1111 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["excluded"] = configuration.get().isExcludedServer(workerItr->interf.addresses(), workerItr->interf.locality);
															#line 3696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["class_type"] = workerItr->processClass.toString();
															#line 1116 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["class_source"] = workerItr->processClass.sourceString();
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (workerItr->degraded)
															#line 3704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["degraded"] = true;
															#line 3708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1121 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& networkMetrics = nMetrics[workerItr->interf.address()];
															#line 1122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			double networkMetricsElapsed = networkMetrics.getDouble("Elapsed");
															#line 3714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			try {
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double runLoopBusy = networkMetrics.getDouble("PriorityStarvedBelow1");
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["run_loop_busy"] = runLoopBusy / networkMetricsElapsed;
															#line 3720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1cont13cont5loopBody1cont23(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont13cont5loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont13cont5loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont5loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont5loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont13cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont13cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont13cont5loopBody1cont3(int loopDepth) 
	{
															#line 1142 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		processMap[printable(workerItr->interf.locality.processId())] = statusObj;
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++workerItr;
															#line 3818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1134 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1135 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1139 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Cannot retrieve all process status information.");
															#line 3836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont13cont5loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont13cont5loopBody1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1cont1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1130 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Cannot retrieve run loop busyness.");
															#line 3858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont13cont5loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1cont23(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont13cont5loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1cont24(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont13cont5loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents pMetrics;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents mMetrics;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents nMetrics;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents errors;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents traceFileOpenErrors;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents programStarts;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::map<std::string, std::vector<JsonBuilderObject>> processIssues;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<StorageServerStatusInfo> storageServers;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<TLogInterface, EventMap>> tLogs;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<CommitProxyInterface, EventMap>> commitProxies;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<GrvProxyInterface, EventMap>> grvProxies;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<BlobWorkerInterface> blobWorkers;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	ServerCoordinators coordinators;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<NetworkAddress> coordinatorAddresses;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Optional<DatabaseConfiguration> configuration;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Optional<Key> healthyZone;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject processMap;
															#line 790 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::map<std::string, JsonBuilderObject> tracefileOpenErrorMap;
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents::iterator traceFileErrorsItr;
															#line 817 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::map<Optional<Standalone<StringRef>>, MachineMemoryInfo> machineMemoryUsage;
															#line 818 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<WorkerDetails>::iterator workerItr;
															#line 821 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::map<Optional<Standalone<StringRef>>, MachineMemoryInfo>::iterator memInfo;
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	RolesInfo roles;
															#line 879 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<OldTLogConf>::const_iterator oldTLogIter;
															#line 880 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<OldTLogConf> oldTLogs;
															#line 901 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<CommitProxyInterface, EventMap>>::iterator commit_proxy;
															#line 907 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<GrvProxyInterface, EventMap>>::iterator grvProxy;
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<TLogInterface, EventMap>>::iterator log;
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Version maxTLogVersion;
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<StorageServerStatusInfo>::iterator ss;
															#line 925 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::map<NetworkAddress, double> ssLag;
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	double lagSeconds;
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<ResolverInterface>::const_iterator res;
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<ResolverInterface> resolvers;
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	decltype(std::begin(std::declval<std::vector<BlobWorkerInterface>>())) RangeForbody1cont13cont4Iterator0;
															#line 951 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 3975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via processStatusFetcher()
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class ProcessStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< ProcessStatusFetcherActor, 0, Void >, public ActorCallback< ProcessStatusFetcherActor, 1, Void >, public ActorCallback< ProcessStatusFetcherActor, 2, Void >, public ActorCallback< ProcessStatusFetcherActor, 3, Void >, public ActorCallback< ProcessStatusFetcherActor, 4, Void >, public ActorCallback< ProcessStatusFetcherActor, 5, Void >, public ActorCallback< ProcessStatusFetcherActor, 6, Void >, public ActorCallback< ProcessStatusFetcherActor, 7, Void >, public ActorCallback< ProcessStatusFetcherActor, 8, Void >, public ActorCallback< ProcessStatusFetcherActor, 9, Void >, public FastAllocated<ProcessStatusFetcherActor>, public ProcessStatusFetcherActorState<ProcessStatusFetcherActor> {
															#line 3980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<ProcessStatusFetcherActor>::operator new;
	using FastAllocated<ProcessStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10614212607295965184UL, 17558427172800904448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessStatusFetcherActor, 0, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 1, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 2, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 3, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 4, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 5, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 6, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 7, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 8, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 9, Void >;
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	ProcessStatusFetcherActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::vector<WorkerDetails> const& workers,WorkerEvents const& pMetrics,WorkerEvents const& mMetrics,WorkerEvents const& nMetrics,WorkerEvents const& errors,WorkerEvents const& traceFileOpenErrors,WorkerEvents const& programStarts,std::map<std::string, std::vector<JsonBuilderObject>> const& processIssues,std::vector<StorageServerStatusInfo> const& storageServers,std::vector<std::pair<TLogInterface, EventMap>> const& tLogs,std::vector<std::pair<CommitProxyInterface, EventMap>> const& commitProxies,std::vector<std::pair<GrvProxyInterface, EventMap>> const& grvProxies,std::vector<BlobWorkerInterface> const& blobWorkers,ServerCoordinators const& coordinators,std::vector<NetworkAddress> const& coordinatorAddresses,Database const& cx,Optional<DatabaseConfiguration> const& configuration,Optional<Key> const& healthyZone,std::set<std::string>* const& incomplete_reasons) 
															#line 4006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   ProcessStatusFetcherActorState<ProcessStatusFetcherActor>(db, workers, pMetrics, mMetrics, nMetrics, errors, traceFileOpenErrors, programStarts, processIssues, storageServers, tLogs, commitProxies, grvProxies, blobWorkers, coordinators, coordinatorAddresses, cx, configuration, healthyZone, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16236183218422400512UL, 108313917293822208UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> processStatusFetcher( Reference<AsyncVar<ServerDBInfo>> const& db, std::vector<WorkerDetails> const& workers, WorkerEvents const& pMetrics, WorkerEvents const& mMetrics, WorkerEvents const& nMetrics, WorkerEvents const& errors, WorkerEvents const& traceFileOpenErrors, WorkerEvents const& programStarts, std::map<std::string, std::vector<JsonBuilderObject>> const& processIssues, std::vector<StorageServerStatusInfo> const& storageServers, std::vector<std::pair<TLogInterface, EventMap>> const& tLogs, std::vector<std::pair<CommitProxyInterface, EventMap>> const& commitProxies, std::vector<std::pair<GrvProxyInterface, EventMap>> const& grvProxies, std::vector<BlobWorkerInterface> const& blobWorkers, ServerCoordinators const& coordinators, std::vector<NetworkAddress> const& coordinatorAddresses, Database const& cx, Optional<DatabaseConfiguration> const& configuration, Optional<Key> const& healthyZone, std::set<std::string>* const& incomplete_reasons ) {
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new ProcessStatusFetcherActor(db, workers, pMetrics, mMetrics, nMetrics, errors, traceFileOpenErrors, programStarts, processIssues, storageServers, tLogs, commitProxies, grvProxies, blobWorkers, coordinators, coordinatorAddresses, cx, configuration, healthyZone, incomplete_reasons));
															#line 4048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 1146 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

static JsonBuilderObject grayFailureStatus(const std::unordered_map<NetworkAddress, double>& excludedDegradedServers) {
	JsonBuilderObject status;
	JsonBuilderArray excludedServers;
	for (const auto& [excludedServer, time] : excludedDegradedServers) {
		JsonBuilderObject server;
		server["address"] = excludedServer.toString();
		server["time"] = time;
		excludedServers.push_back(server);
	}
	status["excluded_servers"] = excludedServers;
	return status;
}

static JsonBuilderObject clientStatusFetcher(
    std::map<NetworkAddress, std::pair<double, OpenDatabaseRequest>>* clientStatusMap) {
	JsonBuilderObject clientStatus;

	int64_t clientCount = 0;
	// Here we handle versions and maxSupportedProtocols, the issues will be handled in getClientIssuesAsMessages
	std::map<Standalone<ClientVersionRef>, OpenDatabaseRequest::Samples> supportedVersions;
	std::map<Key, OpenDatabaseRequest::Samples> maxSupportedProtocol;

	for (auto iter = clientStatusMap->begin(); iter != clientStatusMap->end();) {
		if (now() - iter->second.first >= 2 * SERVER_KNOBS->COORDINATOR_REGISTER_INTERVAL) {
			iter = clientStatusMap->erase(iter);
			continue;
		}

		clientCount += iter->second.second.clientCount;
		for (const auto& [version, samples] : iter->second.second.supportedVersions) {
			supportedVersions[version] += samples;
		}
		for (const auto& [protocol, samples] : iter->second.second.maxProtocolSupported) {
			maxSupportedProtocol[protocol] += samples;
		}
		++iter;
	}

	clientStatus["count"] = clientCount;

	JsonBuilderArray versionsArray = JsonBuilderArray();
	for (const auto& [clientVersionRef, samples] : supportedVersions) {
		JsonBuilderObject ver;
		ver["count"] = (int64_t)samples.count;
		ver["client_version"] = clientVersionRef.clientVersion.toString();
		ver["protocol_version"] = clientVersionRef.protocolVersion.toString();
		ver["source_version"] = clientVersionRef.sourceVersion.toString();

		JsonBuilderArray clients = JsonBuilderArray();
		for (const auto& [networkAddress, trackLogGroup] : samples.samples) {
			JsonBuilderObject cli;
			cli["address"] = networkAddress.toString();
			cli["log_group"] = trackLogGroup.toString();
			clients.push_back(cli);
		}

		auto iter = maxSupportedProtocol.find(clientVersionRef.protocolVersion);
		if (iter != std::end(maxSupportedProtocol)) {
			JsonBuilderArray maxClients = JsonBuilderArray();
			for (const auto& [networkAddress, trackLogGroup] : iter->second.samples) {
				JsonBuilderObject cli;
				cli["address"] = networkAddress.toString();
				cli["log_group"] = trackLogGroup.toString();
				maxClients.push_back(cli);
			}
			ver["max_protocol_count"] = iter->second.count;
			ver["max_protocol_clients"] = maxClients;
			maxSupportedProtocol.erase(clientVersionRef.protocolVersion);
		}

		ver["connected_clients"] = clients;
		versionsArray.push_back(ver);
	}

	if (versionsArray.size() > 0) {
		clientStatus["supported_versions"] = versionsArray;
	}

	return clientStatus;
}

															#line 4134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via recoveryStateStatusFetcher()
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class RecoveryStateStatusFetcherActor>
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class RecoveryStateStatusFetcherActorState {
															#line 4141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	RecoveryStateStatusFetcherActorState(Database const& cx,WorkerDetails const& ccWorker,WorkerDetails const& mWorker,int const& workerCount,std::set<std::string>* const& incomplete_reasons,int* const& statusCode) 
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   ccWorker(ccWorker),
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   mWorker(mWorker),
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   workerCount(workerCount),
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   statusCode(statusCode),
															#line 1234 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   message(),
															#line 1235 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   tr(cx)
															#line 4162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~RecoveryStateStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1237 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				mdActiveGensF = timeoutError(ccWorker.interf.eventLogRequest.getReply(EventLogRequest(StringRef( getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_GENERATION_EVENT_NAME)))), 1.0);
															#line 1241 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				mdF = timeoutError(ccWorker.interf.eventLogRequest.getReply(EventLogRequest(StringRef( getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME)))), 1.0);
															#line 1245 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				mDBAvailableF = timeoutError(ccWorker.interf.eventLogRequest.getReply(EventLogRequest(StringRef( getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_AVAILABLE_EVENT_NAME)))), 1.0);
															#line 1249 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1250 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				rvF = errorOr(timeoutError(tr.getReadVersion(), 1.0));
															#line 1252 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_0 = success(mdActiveGensF) && success(mdF) && success(rvF) && success(mDBAvailableF);
															#line 1252 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<RecoveryStateStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RecoveryStateStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 1252 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*>(static_cast<RecoveryStateStatusFetcherActor*>(this)));
															#line 4195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecoveryStateStatusFetcherActorState();
		static_cast<RecoveryStateStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1308 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (message.empty())
															#line 4224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1309 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Recovery Status unavailable.");
															#line 4228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1312 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<RecoveryStateStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(message); this->~RecoveryStateStatusFetcherActorState(); static_cast<RecoveryStateStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 4232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<RecoveryStateStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(message)); // state_var_RVO
		this->~RecoveryStateStatusFetcherActorState();
		static_cast<RecoveryStateStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1303 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 4245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1304 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 4249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1254 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& md = mdF.get();
															#line 1255 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int mStatusCode = md.getInt("StatusCode");
															#line 1256 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (mStatusCode < 0 || mStatusCode >= RecoveryStatus::END)
															#line 4269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1257 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(attribute_not_found(), loopDepth);
															#line 4273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1259 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		message = JsonString::makeMessage(RecoveryStatus::names[mStatusCode], RecoveryStatus::descriptions[mStatusCode]);
															#line 1261 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		*statusCode = mStatusCode;
															#line 1263 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		ErrorOr<Version> rv = rvF.get();
															#line 1264 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& dbAvailableMsg = mDBAvailableF.get();
															#line 1265 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (dbAvailableMsg.size() > 0)
															#line 4285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1266 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int64_t availableAtVersion = dbAvailableMsg.getInt64("AvailableAtVersion");
															#line 1267 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!rv.isError())
															#line 4291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1268 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double lastRecoveredSecondsAgo = std::max((int64_t)0, (int64_t)(rv.get() - availableAtVersion)) / (double)SERVER_KNOBS->VERSIONS_PER_SECOND;
															#line 1270 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				message["seconds_since_last_recovered"] = lastRecoveredSecondsAgo;
															#line 4297 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
		else
		{
															#line 1273 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			message["seconds_since_last_recovered"] = -1;
															#line 4304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1277 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (mStatusCode == RecoveryStatus::recruiting_transaction_servers)
															#line 4308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1278 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int requiredLogs = atoi(md.getValue("RequiredTLogs").c_str());
															#line 1279 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int requiredCommitProxies = atoi(md.getValue("RequiredCommitProxies").c_str());
															#line 1280 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int requiredGrvProxies = atoi(md.getValue("RequiredGrvProxies").c_str());
															#line 1281 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int requiredResolvers = atoi(md.getValue("RequiredResolvers").c_str());
															#line 1285 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			message["required_logs"] = requiredLogs;
															#line 1286 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			message["required_commit_proxies"] = requiredCommitProxies;
															#line 1287 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			message["required_grv_proxies"] = requiredGrvProxies;
															#line 1288 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			message["required_resolvers"] = requiredResolvers;
															#line 4326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1289 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (mStatusCode == RecoveryStatus::locking_old_transaction_servers)
															#line 4332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1290 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				message["missing_logs"] = md.getValue("MissingIDs").c_str();
															#line 4336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& mdActiveGens = mdActiveGensF.get();
															#line 1297 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (mdActiveGens.size())
															#line 4343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1298 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int activeGenerations = mdActiveGens.getInt("ActiveGenerations");
															#line 1299 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			message["active_generations"] = activeGenerations;
															#line 4349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1254 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& md = mdF.get();
															#line 1255 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int mStatusCode = md.getInt("StatusCode");
															#line 1256 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (mStatusCode < 0 || mStatusCode >= RecoveryStatus::END)
															#line 4363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1257 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(attribute_not_found(), loopDepth);
															#line 4367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1259 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		message = JsonString::makeMessage(RecoveryStatus::names[mStatusCode], RecoveryStatus::descriptions[mStatusCode]);
															#line 1261 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		*statusCode = mStatusCode;
															#line 1263 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		ErrorOr<Version> rv = rvF.get();
															#line 1264 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& dbAvailableMsg = mDBAvailableF.get();
															#line 1265 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (dbAvailableMsg.size() > 0)
															#line 4379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1266 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int64_t availableAtVersion = dbAvailableMsg.getInt64("AvailableAtVersion");
															#line 1267 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!rv.isError())
															#line 4385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1268 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double lastRecoveredSecondsAgo = std::max((int64_t)0, (int64_t)(rv.get() - availableAtVersion)) / (double)SERVER_KNOBS->VERSIONS_PER_SECOND;
															#line 1270 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				message["seconds_since_last_recovered"] = lastRecoveredSecondsAgo;
															#line 4391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
		else
		{
															#line 1273 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			message["seconds_since_last_recovered"] = -1;
															#line 4398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1277 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (mStatusCode == RecoveryStatus::recruiting_transaction_servers)
															#line 4402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1278 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int requiredLogs = atoi(md.getValue("RequiredTLogs").c_str());
															#line 1279 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int requiredCommitProxies = atoi(md.getValue("RequiredCommitProxies").c_str());
															#line 1280 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int requiredGrvProxies = atoi(md.getValue("RequiredGrvProxies").c_str());
															#line 1281 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int requiredResolvers = atoi(md.getValue("RequiredResolvers").c_str());
															#line 1285 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			message["required_logs"] = requiredLogs;
															#line 1286 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			message["required_commit_proxies"] = requiredCommitProxies;
															#line 1287 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			message["required_grv_proxies"] = requiredGrvProxies;
															#line 1288 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			message["required_resolvers"] = requiredResolvers;
															#line 4420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1289 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (mStatusCode == RecoveryStatus::locking_old_transaction_servers)
															#line 4426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1290 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				message["missing_logs"] = md.getValue("MissingIDs").c_str();
															#line 4430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& mdActiveGens = mdActiveGensF.get();
															#line 1297 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (mdActiveGens.size())
															#line 4437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1298 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int activeGenerations = mdActiveGens.getInt("ActiveGenerations");
															#line 1299 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			message["active_generations"] = activeGenerations;
															#line 4443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecoveryStateStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<RecoveryStateStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<RecoveryStateStatusFetcherActor*>(this)->ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryStateStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryStateStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryStateStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails ccWorker;
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails mWorker;
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	int workerCount;
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	int* statusCode;
															#line 1234 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject message;
															#line 1235 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 1237 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> mdActiveGensF;
															#line 1241 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> mdF;
															#line 1245 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> mDBAvailableF;
															#line 1250 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<ErrorOr<Version>> rvF;
															#line 4561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via recoveryStateStatusFetcher()
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class RecoveryStateStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >, public FastAllocated<RecoveryStateStatusFetcherActor>, public RecoveryStateStatusFetcherActorState<RecoveryStateStatusFetcherActor> {
															#line 4566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<RecoveryStateStatusFetcherActor>::operator new;
	using FastAllocated<RecoveryStateStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12375895937215935232UL, 4310309105307102976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >;
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	RecoveryStateStatusFetcherActor(Database const& cx,WorkerDetails const& ccWorker,WorkerDetails const& mWorker,int const& workerCount,std::set<std::string>* const& incomplete_reasons,int* const& statusCode) 
															#line 4583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   RecoveryStateStatusFetcherActorState<RecoveryStateStatusFetcherActor>(cx, ccWorker, mWorker, workerCount, incomplete_reasons, statusCode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2143522345445455872UL, 12399124894024078592UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryStateStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recoveryStateStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> recoveryStateStatusFetcher( Database const& cx, WorkerDetails const& ccWorker, WorkerDetails const& mWorker, int const& workerCount, std::set<std::string>* const& incomplete_reasons, int* const& statusCode ) {
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new RecoveryStateStatusFetcherActor(cx, ccWorker, mWorker, workerCount, incomplete_reasons, statusCode));
															#line 4616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 1314 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 4621 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via doGrvProbe()
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class DoGrvProbeActor>
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class DoGrvProbeActorState {
															#line 4628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	DoGrvProbeActorState(Transaction* const& tr,Optional<FDBTransactionOptions::Option> const& priority = Optional<FDBTransactionOptions::Option>()) 
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : tr(tr),
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   priority(priority),
															#line 1318 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   start(g_network->timer_monotonic())
															#line 4639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("doGrvProbe", reinterpret_cast<unsigned long>(this));

	}
	~DoGrvProbeActorState() 
	{
		fdb_probe_actor_destroy("doGrvProbe", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1320 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 4654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoGrvProbeActorState();
		static_cast<DoGrvProbeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1322 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1323 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (priority.present())
															#line 4687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1324 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				tr->setOption(priority.get());
															#line 4691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1327 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(tr->getReadVersion());
															#line 1327 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoGrvProbeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoGrvProbeActor*>(this)->actor_wait_state = 1;
															#line 1327 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoGrvProbeActor, 0, Void >*>(static_cast<DoGrvProbeActor*>(this)));
															#line 4702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1330 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 1330 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoGrvProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoGrvProbeActor*>(this)->actor_wait_state = 2;
															#line 1330 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoGrvProbeActor, 1, Void >*>(static_cast<DoGrvProbeActor*>(this)));
															#line 4731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1328 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoGrvProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoGrvProbeActorState(); static_cast<DoGrvProbeActor*>(this)->destroy(); return 0; }
															#line 4746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DoGrvProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoGrvProbeActorState();
		static_cast<DoGrvProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1328 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoGrvProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoGrvProbeActorState(); static_cast<DoGrvProbeActor*>(this)->destroy(); return 0; }
															#line 4758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DoGrvProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoGrvProbeActorState();
		static_cast<DoGrvProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoGrvProbeActor*>(this)->actor_wait_state > 0) static_cast<DoGrvProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoGrvProbeActor*>(this)->ActorCallback< DoGrvProbeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoGrvProbeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoGrvProbeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoGrvProbeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoGrvProbeActor*>(this)->actor_wait_state > 0) static_cast<DoGrvProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoGrvProbeActor*>(this)->ActorCallback< DoGrvProbeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoGrvProbeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoGrvProbeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoGrvProbeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction* tr;
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Optional<FDBTransactionOptions::Option> priority;
															#line 1318 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	double start;
															#line 4934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via doGrvProbe()
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class DoGrvProbeActor final : public Actor<double>, public ActorCallback< DoGrvProbeActor, 0, Void >, public ActorCallback< DoGrvProbeActor, 1, Void >, public FastAllocated<DoGrvProbeActor>, public DoGrvProbeActorState<DoGrvProbeActor> {
															#line 4939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<DoGrvProbeActor>::operator new;
	using FastAllocated<DoGrvProbeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11301397573739746560UL, 16849012285216195840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<double>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoGrvProbeActor, 0, Void >;
friend struct ActorCallback< DoGrvProbeActor, 1, Void >;
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	DoGrvProbeActor(Transaction* const& tr,Optional<FDBTransactionOptions::Option> const& priority = Optional<FDBTransactionOptions::Option>()) 
															#line 4957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<double>(),
		   DoGrvProbeActorState<DoGrvProbeActor>(tr, priority),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12695868933801491712UL, 15656792167232969216UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doGrvProbe");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoGrvProbeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoGrvProbeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<double> doGrvProbe( Transaction* const& tr, Optional<FDBTransactionOptions::Option> const& priority = Optional<FDBTransactionOptions::Option>() ) {
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<double>(new DoGrvProbeActor(tr, priority));
															#line 4991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 1334 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 4996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via doReadProbe()
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class DoReadProbeActor>
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class DoReadProbeActorState {
															#line 5003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	DoReadProbeActorState(Future<double> const& grvProbe,Transaction* const& tr) 
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : grvProbe(grvProbe),
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   tr(tr)
															#line 5012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("doReadProbe", reinterpret_cast<unsigned long>(this));

	}
	~DoReadProbeActorState() 
	{
		fdb_probe_actor_destroy("doReadProbe", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1336 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<ErrorOr<double>> __when_expr_0 = errorOr(grvProbe);
															#line 1336 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoReadProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5029 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoReadProbeActor*>(this)->actor_wait_state = 1;
															#line 1336 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*>(static_cast<DoReadProbeActor*>(this)));
															#line 5034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoReadProbeActorState();
		static_cast<DoReadProbeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<double> const& grv,int loopDepth) 
	{
															#line 1337 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (grv.isError())
															#line 5057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1338 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(grv.getError(), loopDepth);
															#line 5061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1341 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		start = g_network->timer_monotonic();
															#line 1343 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		;
															#line 5067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<double> && grv,int loopDepth) 
	{
															#line 1337 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (grv.isError())
															#line 5076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1338 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(grv.getError(), loopDepth);
															#line 5080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1341 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		start = g_network->timer_monotonic();
															#line 1343 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		;
															#line 5086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> const& grv,int loopDepth) 
	{
		loopDepth = a_body1cont1(grv, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> && grv,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(grv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoReadProbeActor*>(this)->actor_wait_state > 0) static_cast<DoReadProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadProbeActor*>(this)->ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> const& value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> && value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*,Error err) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1344 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 5177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		try {
															#line 1346 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Optional<Standalone<StringRef>>> __when_expr_1 = tr->get("\xff/StatusJsonTestKey62793"_sr);
															#line 1346 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoReadProbeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoReadProbeActor*>(this)->actor_wait_state = 2;
															#line 1346 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*>(static_cast<DoReadProbeActor*>(this)));
															#line 5188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1349 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 1349 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoReadProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoReadProbeActor*>(this)->actor_wait_state = 3;
															#line 1349 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoReadProbeActor, 2, Void >*>(static_cast<DoReadProbeActor*>(this)));
															#line 5217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Standalone<StringRef>> const& _,int loopDepth) 
	{
															#line 1347 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoReadProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoReadProbeActorState(); static_cast<DoReadProbeActor*>(this)->destroy(); return 0; }
															#line 5232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DoReadProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoReadProbeActorState();
		static_cast<DoReadProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Standalone<StringRef>> && _,int loopDepth) 
	{
															#line 1347 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoReadProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoReadProbeActorState(); static_cast<DoReadProbeActor*>(this)->destroy(); return 0; }
															#line 5244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DoReadProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoReadProbeActorState();
		static_cast<DoReadProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Standalone<StringRef>> const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Standalone<StringRef>> && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoReadProbeActor*>(this)->actor_wait_state > 0) static_cast<DoReadProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadProbeActor*>(this)->ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 1350 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 5331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 1350 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 5340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoReadProbeActor*>(this)->actor_wait_state > 0) static_cast<DoReadProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadProbeActor*>(this)->ActorCallback< DoReadProbeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoReadProbeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<double> grvProbe;
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction* tr;
															#line 1341 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	double start;
															#line 5426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via doReadProbe()
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class DoReadProbeActor final : public Actor<double>, public ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >, public ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >, public ActorCallback< DoReadProbeActor, 2, Void >, public FastAllocated<DoReadProbeActor>, public DoReadProbeActorState<DoReadProbeActor> {
															#line 5431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<DoReadProbeActor>::operator new;
	using FastAllocated<DoReadProbeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1304488289633692672UL, 2114971474370900736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<double>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >;
friend struct ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< DoReadProbeActor, 2, Void >;
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	DoReadProbeActor(Future<double> const& grvProbe,Transaction* const& tr) 
															#line 5450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<double>(),
		   DoReadProbeActorState<DoReadProbeActor>(grvProbe, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18395811845136080640UL, 11329582461020487936UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doReadProbe");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoReadProbeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<double> doReadProbe( Future<double> const& grvProbe, Transaction* const& tr ) {
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<double>(new DoReadProbeActor(grvProbe, tr));
															#line 5485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 1354 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 5490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via doCommitProbe()
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class DoCommitProbeActor>
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class DoCommitProbeActorState {
															#line 5497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	DoCommitProbeActorState(Future<double> const& grvProbe,Transaction* const& sourceTr,Transaction* const& tr) 
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : grvProbe(grvProbe),
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   sourceTr(sourceTr),
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   tr(tr)
															#line 5508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("doCommitProbe", reinterpret_cast<unsigned long>(this));

	}
	~DoCommitProbeActorState() 
	{
		fdb_probe_actor_destroy("doCommitProbe", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1356 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<ErrorOr<double>> __when_expr_0 = errorOr(grvProbe);
															#line 1356 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 1;
															#line 1356 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*>(static_cast<DoCommitProbeActor*>(this)));
															#line 5530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCommitProbeActorState();
		static_cast<DoCommitProbeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<double> const& grv,int loopDepth) 
	{
															#line 1357 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (grv.isError())
															#line 5553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1358 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(grv.getError(), loopDepth);
															#line 5557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1361 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		ASSERT(sourceTr->getReadVersion().isReady());
															#line 1362 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tr->setVersion(sourceTr->getReadVersion().get());
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tr->getDatabase()->ssVersionVectorCache = sourceTr->getDatabase()->ssVersionVectorCache;
															#line 1364 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tr->trState->readVersionObtainedFromGrvProxy = sourceTr->trState->readVersionObtainedFromGrvProxy;
															#line 1366 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		start = g_network->timer_monotonic();
															#line 1368 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		;
															#line 5571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<double> && grv,int loopDepth) 
	{
															#line 1357 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (grv.isError())
															#line 5580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1358 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(grv.getError(), loopDepth);
															#line 5584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1361 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		ASSERT(sourceTr->getReadVersion().isReady());
															#line 1362 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tr->setVersion(sourceTr->getReadVersion().get());
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tr->getDatabase()->ssVersionVectorCache = sourceTr->getDatabase()->ssVersionVectorCache;
															#line 1364 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tr->trState->readVersionObtainedFromGrvProxy = sourceTr->trState->readVersionObtainedFromGrvProxy;
															#line 1366 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		start = g_network->timer_monotonic();
															#line 1368 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		;
															#line 5598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> const& grv,int loopDepth) 
	{
		loopDepth = a_body1cont1(grv, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> && grv,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(grv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state > 0) static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoCommitProbeActor*>(this)->ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >::remove();

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> const& value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> && value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*,Error err) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1370 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1371 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1372 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr->makeSelfConflicting();
															#line 1373 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 1373 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 2;
															#line 1373 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCommitProbeActor, 1, Void >*>(static_cast<DoCommitProbeActor*>(this)));
															#line 5703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1376 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 1376 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 3;
															#line 1376 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoCommitProbeActor, 2, Void >*>(static_cast<DoCommitProbeActor*>(this)));
															#line 5732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1374 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoCommitProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoCommitProbeActorState(); static_cast<DoCommitProbeActor*>(this)->destroy(); return 0; }
															#line 5747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DoCommitProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoCommitProbeActorState();
		static_cast<DoCommitProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1374 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoCommitProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoCommitProbeActorState(); static_cast<DoCommitProbeActor*>(this)->destroy(); return 0; }
															#line 5759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DoCommitProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoCommitProbeActorState();
		static_cast<DoCommitProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state > 0) static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoCommitProbeActor*>(this)->ActorCallback< DoCommitProbeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCommitProbeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state > 0) static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoCommitProbeActor*>(this)->ActorCallback< DoCommitProbeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoCommitProbeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<double> grvProbe;
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction* sourceTr;
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction* tr;
															#line 1366 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	double start;
															#line 5937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via doCommitProbe()
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class DoCommitProbeActor final : public Actor<double>, public ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >, public ActorCallback< DoCommitProbeActor, 1, Void >, public ActorCallback< DoCommitProbeActor, 2, Void >, public FastAllocated<DoCommitProbeActor>, public DoCommitProbeActorState<DoCommitProbeActor> {
															#line 5942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<DoCommitProbeActor>::operator new;
	using FastAllocated<DoCommitProbeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18394006624119050496UL, 863410475519907072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<double>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >;
friend struct ActorCallback< DoCommitProbeActor, 1, Void >;
friend struct ActorCallback< DoCommitProbeActor, 2, Void >;
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	DoCommitProbeActor(Future<double> const& grvProbe,Transaction* const& sourceTr,Transaction* const& tr) 
															#line 5961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<double>(),
		   DoCommitProbeActorState<DoCommitProbeActor>(grvProbe, sourceTr, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12181102828360946944UL, 14510411821951618048UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doCommitProbe");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoCommitProbeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoCommitProbeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<double> doCommitProbe( Future<double> const& grvProbe, Transaction* const& sourceTr, Transaction* const& tr ) {
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<double>(new DoCommitProbeActor(grvProbe, sourceTr, tr));
															#line 5996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 1380 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 6001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via doProbe()
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class DoProbeActor>
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class DoProbeActorState {
															#line 6008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	DoProbeActorState(Future<double> const& probe,int const& timeoutSeconds,const char* const& prefix,const char* const& description,JsonBuilderObject* const& probeObj,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons,bool* const& isAvailable = nullptr) 
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : probe(probe),
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   timeoutSeconds(timeoutSeconds),
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   prefix(prefix),
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   description(description),
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   probeObj(probeObj),
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   isAvailable(isAvailable)
															#line 6029 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("doProbe", reinterpret_cast<unsigned long>(this));

	}
	~DoProbeActorState() 
	{
		fdb_probe_actor_destroy("doProbe", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1390 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<ErrorOr<double>> __when_expr_0 = errorOr(probe);
															#line 1389 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1401 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(timeoutSeconds);
															#line 6050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<DoProbeActor*>(this)->actor_wait_state = 1;
															#line 1390 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoProbeActor, 0, ErrorOr<double> >*>(static_cast<DoProbeActor*>(this)));
															#line 1401 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoProbeActor, 1, Void >*>(static_cast<DoProbeActor*>(this)));
															#line 6057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoProbeActorState();
		static_cast<DoProbeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1411 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoProbeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoProbeActorState(); static_cast<DoProbeActor*>(this)->destroy(); return 0; }
															#line 6080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DoProbeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoProbeActorState();
		static_cast<DoProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> const& result,int loopDepth) 
	{
															#line 1391 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (result.isError())
															#line 6092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1392 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (isAvailable != nullptr)
															#line 6096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1393 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				*isAvailable = false;
															#line 6100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1395 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format( "Unable to retrieve latency probe information (%s: %s).", description, result.getError().what()));
															#line 6104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1398 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*probeObj)[format("%s_seconds", prefix).c_str()] = result.get();
															#line 6110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> && result,int loopDepth) 
	{
															#line 1391 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (result.isError())
															#line 6120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1392 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (isAvailable != nullptr)
															#line 6124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1393 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				*isAvailable = false;
															#line 6128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1395 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format( "Unable to retrieve latency probe information (%s: %s).", description, result.getError().what()));
															#line 6132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1398 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*probeObj)[format("%s_seconds", prefix).c_str()] = result.get();
															#line 6138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 1402 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (isAvailable != nullptr)
															#line 6148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1403 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			*isAvailable = false;
															#line 6152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1405 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		messages->push_back( JsonString::makeMessage(format("%s_probe_timeout", prefix).c_str(), format("Unable to %s after %d seconds.", description, timeoutSeconds).c_str()));
															#line 6156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 1402 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (isAvailable != nullptr)
															#line 6165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1403 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			*isAvailable = false;
															#line 6169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1405 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		messages->push_back( JsonString::makeMessage(format("%s_probe_timeout", prefix).c_str(), format("Unable to %s after %d seconds.", description, timeoutSeconds).c_str()));
															#line 6173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoProbeActor*>(this)->actor_wait_state > 0) static_cast<DoProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoProbeActor*>(this)->ActorCallback< DoProbeActor, 0, ErrorOr<double> >::remove();
		static_cast<DoProbeActor*>(this)->ActorCallback< DoProbeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> const& value) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> && value) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoProbeActor, 0, ErrorOr<double> >*,Error err) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoProbeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoProbeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoProbeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<double> probe;
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	int timeoutSeconds;
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	const char* prefix;
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	const char* description;
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject* probeObj;
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	bool* isAvailable;
															#line 6315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via doProbe()
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class DoProbeActor final : public Actor<Void>, public ActorCallback< DoProbeActor, 0, ErrorOr<double> >, public ActorCallback< DoProbeActor, 1, Void >, public FastAllocated<DoProbeActor>, public DoProbeActorState<DoProbeActor> {
															#line 6320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<DoProbeActor>::operator new;
	using FastAllocated<DoProbeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4153939056735859200UL, 1180165740342189824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoProbeActor, 0, ErrorOr<double> >;
friend struct ActorCallback< DoProbeActor, 1, Void >;
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	DoProbeActor(Future<double> const& probe,int const& timeoutSeconds,const char* const& prefix,const char* const& description,JsonBuilderObject* const& probeObj,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons,bool* const& isAvailable = nullptr) 
															#line 6338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<Void>(),
		   DoProbeActorState<DoProbeActor>(probe, timeoutSeconds, prefix, description, probeObj, messages, incomplete_reasons, isAvailable),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15729666029307177216UL, 15210686459627708928UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doProbe");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoProbeActor, 0, ErrorOr<double> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<Void> doProbe( Future<double> const& probe, int const& timeoutSeconds, const char* const& prefix, const char* const& description, JsonBuilderObject* const& probeObj, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons, bool* const& isAvailable = nullptr ) {
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Void>(new DoProbeActor(probe, timeoutSeconds, prefix, description, probeObj, messages, incomplete_reasons, isAvailable));
															#line 6371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 1413 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 6376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via latencyProbeFetcher()
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class LatencyProbeFetcherActor>
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class LatencyProbeFetcherActorState {
															#line 6383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	LatencyProbeFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons,bool* const& isAvailable) 
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   isAvailable(isAvailable),
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   trImmediate(cx),
															#line 1419 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   trDefault(cx),
															#line 1420 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   trBatch(cx),
															#line 1421 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   trWrite(cx),
															#line 1423 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj()
															#line 6406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("latencyProbeFetcher", reinterpret_cast<unsigned long>(this));

	}
	~LatencyProbeFetcherActorState() 
	{
		fdb_probe_actor_destroy("latencyProbeFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> immediateGrvProbe = doGrvProbe(&trImmediate, FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1427 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> defaultGrvProbe = doGrvProbe(&trDefault);
															#line 1428 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> batchGrvProbe = doGrvProbe(&trBatch, FDBTransactionOptions::PRIORITY_BATCH);
															#line 1430 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> readProbe = doReadProbe(immediateGrvProbe, &trImmediate);
															#line 1431 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> commitProbe = doCommitProbe(immediateGrvProbe, &trImmediate, &trWrite);
															#line 1433 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				int timeoutSeconds = 5;
															#line 1435 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				std::vector<Future<Void>> probes;
															#line 1436 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back(doProbe(immediateGrvProbe, timeoutSeconds, "immediate_priority_transaction_start", "start immediate priority transaction", &statusObj, messages, incomplete_reasons, isAvailable));
															#line 1444 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back(doProbe(defaultGrvProbe, timeoutSeconds, "transaction_start", "start default priority transaction", &statusObj, messages, incomplete_reasons));
															#line 1451 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back(doProbe(batchGrvProbe, timeoutSeconds, "batch_priority_transaction_start", "start batch priority transaction", &statusObj, messages, incomplete_reasons));
															#line 1458 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back( doProbe(readProbe, timeoutSeconds, "read", "read", &statusObj, messages, incomplete_reasons, isAvailable));
															#line 1460 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back(doProbe( commitProbe, timeoutSeconds, "commit", "commit", &statusObj, messages, incomplete_reasons, isAvailable));
															#line 1463 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(probes);
															#line 1463 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<LatencyProbeFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<LatencyProbeFetcherActor*>(this)->actor_wait_state = 1;
															#line 1463 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LatencyProbeFetcherActor, 0, Void >*>(static_cast<LatencyProbeFetcherActor*>(this)));
															#line 6453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LatencyProbeFetcherActorState();
		static_cast<LatencyProbeFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1471 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatencyProbeFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~LatencyProbeFetcherActorState(); static_cast<LatencyProbeFetcherActor*>(this)->destroy(); return 0; }
															#line 6482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LatencyProbeFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~LatencyProbeFetcherActorState();
		static_cast<LatencyProbeFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1465 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 6495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1466 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 6499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1468 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve latency probe information (%s).", e.what()));
															#line 6503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LatencyProbeFetcherActor*>(this)->actor_wait_state > 0) static_cast<LatencyProbeFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LatencyProbeFetcherActor*>(this)->ActorCallback< LatencyProbeFetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LatencyProbeFetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyProbeFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LatencyProbeFetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyProbeFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LatencyProbeFetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyProbeFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	bool* isAvailable;
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction trImmediate;
															#line 1419 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction trDefault;
															#line 1420 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction trBatch;
															#line 1421 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction trWrite;
															#line 1423 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 6632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via latencyProbeFetcher()
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class LatencyProbeFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< LatencyProbeFetcherActor, 0, Void >, public FastAllocated<LatencyProbeFetcherActor>, public LatencyProbeFetcherActorState<LatencyProbeFetcherActor> {
															#line 6637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<LatencyProbeFetcherActor>::operator new;
	using FastAllocated<LatencyProbeFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9234251066248126720UL, 17259575150703738112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LatencyProbeFetcherActor, 0, Void >;
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	LatencyProbeFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons,bool* const& isAvailable) 
															#line 6654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   LatencyProbeFetcherActorState<LatencyProbeFetcherActor>(cx, messages, incomplete_reasons, isAvailable),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11104724659914187008UL, 14391616900010405120UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyProbeFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("latencyProbeFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LatencyProbeFetcherActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> latencyProbeFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons, bool* const& isAvailable ) {
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new LatencyProbeFetcherActor(cx, messages, incomplete_reasons, isAvailable));
															#line 6687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 1473 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 6692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via versionEpochStatusFetcher()
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class VersionEpochStatusFetcherActor>
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class VersionEpochStatusFetcherActorState {
															#line 6699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	VersionEpochStatusFetcherActorState(Database const& cx,std::set<std::string>* const& incomplete_reasons) 
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 1476 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   message()
															#line 6710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~VersionEpochStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1478 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				tr = Transaction(cx);
															#line 1479 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				;
															#line 6728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VersionEpochStatusFetcherActorState();
		static_cast<VersionEpochStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1502 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<VersionEpochStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(message); this->~VersionEpochStatusFetcherActorState(); static_cast<VersionEpochStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 6757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<VersionEpochStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(message)); // state_var_RVO
		this->~VersionEpochStatusFetcherActorState();
		static_cast<VersionEpochStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1497 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 6770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1498 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 6774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1500 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve version epoch information (%s).", e.what()));
															#line 6778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1481 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1482 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1483 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = timeoutError(BUGGIFY ? Never() : tr.get(versionEpochKey), 5.0);
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*>(static_cast<VersionEpochStatusFetcherActor*>(this)));
															#line 6820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1493 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1493 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 1493 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*>(static_cast<VersionEpochStatusFetcherActor*>(this)));
															#line 6862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& versionEpochVal,int loopDepth) 
	{
															#line 1485 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		message["enabled"] = versionEpochVal.present();
															#line 1486 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!versionEpochVal.present())
															#line 6879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1489 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochVal.get(), Unversioned());
															#line 1490 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		message["epoch"] = std::to_string(versionEpoch);
															#line 6887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && versionEpochVal,int loopDepth) 
	{
															#line 1485 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		message["enabled"] = versionEpochVal.present();
															#line 1486 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!versionEpochVal.present())
															#line 6898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1489 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochVal.get(), Unversioned());
															#line 1490 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		message["epoch"] = std::to_string(versionEpoch);
															#line 6906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& versionEpochVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(versionEpochVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && versionEpochVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(versionEpochVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochStatusFetcherActor*>(this)->ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochStatusFetcherActor*>(this)->ActorCallback< VersionEpochStatusFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1476 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject message;
															#line 1478 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 7094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via versionEpochStatusFetcher()
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class VersionEpochStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >, public ActorCallback< VersionEpochStatusFetcherActor, 1, Void >, public FastAllocated<VersionEpochStatusFetcherActor>, public VersionEpochStatusFetcherActorState<VersionEpochStatusFetcherActor> {
															#line 7099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<VersionEpochStatusFetcherActor>::operator new;
	using FastAllocated<VersionEpochStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16778854936303633664UL, 12276290307217759232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >;
friend struct ActorCallback< VersionEpochStatusFetcherActor, 1, Void >;
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	VersionEpochStatusFetcherActor(Database const& cx,std::set<std::string>* const& incomplete_reasons) 
															#line 7117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   VersionEpochStatusFetcherActorState<VersionEpochStatusFetcherActor>(cx, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5224719475858352128UL, 5273280573928800768UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("versionEpochStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> versionEpochStatusFetcher( Database const& cx, std::set<std::string>* const& incomplete_reasons ) {
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new VersionEpochStatusFetcherActor(cx, incomplete_reasons));
															#line 7151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 1504 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 7156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via consistencyCheckStatusFetcher()
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class ConsistencyCheckStatusFetcherActor>
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class ConsistencyCheckStatusFetcherActorState {
															#line 7163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	ConsistencyCheckStatusFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons)
															#line 7174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~ConsistencyCheckStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1509 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				tr = Transaction(cx);
															#line 1510 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				;
															#line 7192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsistencyCheckStatusFetcherActorState();
		static_cast<ConsistencyCheckStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1543 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ConsistencyCheckStatusFetcherActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConsistencyCheckStatusFetcherActorState(); static_cast<ConsistencyCheckStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 7221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<ConsistencyCheckStatusFetcherActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConsistencyCheckStatusFetcherActorState();
		static_cast<ConsistencyCheckStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 7234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 7238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1541 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve consistency check settings (%s).", e.what()));
															#line 7242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1512 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1513 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1514 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1515 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = timeoutError(BUGGIFY ? Never() : tr.get(fdbShouldConsistencyCheckBeSuspended), 5.0);
															#line 1515 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 1515 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*>(static_cast<ConsistencyCheckStatusFetcherActor*>(this)));
															#line 7284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1526 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 7319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1527 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				messages->push_back( JsonString::makeMessage("consistencycheck_suspendkey_fetch_timeout", format("Timed out trying to fetch `%s` from the database.", printable(fdbShouldConsistencyCheckBeSuspended).c_str()) .c_str()));
															#line 7323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 1534 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1534 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 1534 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*>(static_cast<ConsistencyCheckStatusFetcherActor*>(this)));
															#line 7335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& ccSuspendVal,int loopDepth) 
	{
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		bool ccSuspend = ccSuspendVal.present() ? BinaryReader::fromStringRef<bool>(ccSuspendVal.get(), Unversioned()) : false;
															#line 1520 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (ccSuspend)
															#line 7352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1521 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("consistencycheck_disabled", "Consistency checker is disabled."));
															#line 7356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && ccSuspendVal,int loopDepth) 
	{
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		bool ccSuspend = ccSuspendVal.present() ? BinaryReader::fromStringRef<bool>(ccSuspendVal.get(), Unversioned()) : false;
															#line 1520 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (ccSuspend)
															#line 7368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1521 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("consistencycheck_disabled", "Consistency checker is disabled."));
															#line 7372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& ccSuspendVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ccSuspendVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && ccSuspendVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ccSuspendVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyCheckStatusFetcherActor*>(this)->ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyCheckStatusFetcherActor*>(this)->ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1509 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 7561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via consistencyCheckStatusFetcher()
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class ConsistencyCheckStatusFetcherActor final : public Actor<Void>, public ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >, public ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >, public FastAllocated<ConsistencyCheckStatusFetcherActor>, public ConsistencyCheckStatusFetcherActorState<ConsistencyCheckStatusFetcherActor> {
															#line 7566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<ConsistencyCheckStatusFetcherActor>::operator new;
	using FastAllocated<ConsistencyCheckStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11195258431082477056UL, 5457521297666168576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >;
friend struct ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >;
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	ConsistencyCheckStatusFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 7584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<Void>(),
		   ConsistencyCheckStatusFetcherActorState<ConsistencyCheckStatusFetcherActor>(cx, messages, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4551706905108231424UL, 2658363125606068224UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consistencyCheckStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<Void> consistencyCheckStatusFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons ) {
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Void>(new ConsistencyCheckStatusFetcherActor(cx, messages, incomplete_reasons));
															#line 7618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 1545 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

struct LogRangeAndUID {
	KeyRange range;
	UID destID;

	LogRangeAndUID(KeyRange const& range, UID const& destID) : range(range), destID(destID) {}

	bool operator<(LogRangeAndUID const& r) const {
		if (range.begin != r.range.begin)
			return range.begin < r.range.begin;
		if (range.end != r.range.end)
			return range.end < r.range.end;
		return destID < r.destID;
	}
};

															#line 7638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via logRangeWarningFetcher()
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class LogRangeWarningFetcherActor>
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class LogRangeWarningFetcherActorState {
															#line 7645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	LogRangeWarningFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons)
															#line 7656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this));

	}
	~LogRangeWarningFetcherActorState() 
	{
		fdb_probe_actor_destroy("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1565 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				tr = Transaction(cx);
															#line 1566 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				timeoutFuture = timeoutError(Future<Void>(Never()), 5.0);
															#line 1567 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				;
															#line 7676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogRangeWarningFetcherActorState();
		static_cast<LogRangeWarningFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1630 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LogRangeWarningFetcherActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogRangeWarningFetcherActorState(); static_cast<LogRangeWarningFetcherActor*>(this)->destroy(); return 0; }
															#line 7705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LogRangeWarningFetcherActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogRangeWarningFetcherActorState();
		static_cast<LogRangeWarningFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1625 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 7718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1626 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 7722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1628 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve log ranges (%s).", e.what()));
															#line 7726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1569 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1570 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1571 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1573 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			existingDestUidValues = tr.getRange(KeyRangeRef(destUidLookupPrefix, strinc(destUidLookupPrefix)), CLIENT_KNOBS->TOO_MANY);
															#line 1575 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			existingLogRanges = tr.getRange(logRangesRange, CLIENT_KNOBS->TOO_MANY);
															#line 1576 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = (success(existingDestUidValues) && success(existingLogRanges)) || timeoutFuture;
															#line 1576 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 1;
															#line 1576 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogRangeWarningFetcherActor, 0, Void >*>(static_cast<LogRangeWarningFetcherActor*>(this)));
															#line 7772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1613 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 7807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1614 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				messages->push_back( JsonString::makeMessage("duplicate_mutation_fetch_timeout", format("Timed out trying to fetch `%s` from the database.", printable(destUidLookupPrefix).c_str()) .c_str()));
															#line 7811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 1621 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 1621 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 3;
															#line 1621 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LogRangeWarningFetcherActor, 2, Void >*>(static_cast<LogRangeWarningFetcherActor*>(this)));
															#line 7823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1578 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		std::set<LogRangeAndUID> loggingRanges;
															#line 1579 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& it : existingLogRanges.get() ) {
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			Key logDestination;
															#line 1581 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			UID logUid;
															#line 1582 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			KeyRef logRangeBegin = logRangesDecodeKey(it.key, &logUid);
															#line 1583 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			Key logRangeEnd = logRangesDecodeValue(it.value, &logDestination);
															#line 1584 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			loggingRanges.insert(LogRangeAndUID(KeyRangeRef(logRangeBegin, logRangeEnd), logUid));
															#line 7850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		std::set<std::pair<Key, Key>> existingRanges;
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& it : existingDestUidValues.get() ) {
															#line 1589 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			KeyRange range = BinaryReader::fromStringRef<KeyRange>(it.key.removePrefix(destUidLookupPrefix), IncludeVersion());
															#line 1591 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			UID logUid = BinaryReader::fromStringRef<UID>(it.value, Unversioned());
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (loggingRanges.contains(LogRangeAndUID(range, logUid)))
															#line 7862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1593 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				std::pair<Key, Key> rangePair = std::make_pair(range.begin, range.end);
															#line 1594 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (existingRanges.contains(rangePair))
															#line 7868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1595 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					std::string rangeDescription = (range == getDefaultBackupSharedRange()) ? "the default backup set" : format("`%s` - `%s`", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 1600 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					messages->push_back(JsonString::makeMessage( "duplicate_mutation_streams", format("Backup and DR are not sharing the same stream of mutations for %s", rangeDescription.c_str()) .c_str()));
															#line 7874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					break;
				}
															#line 1607 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				existingRanges.insert(rangePair);
															#line 7879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit() || timeoutFuture;
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 2;
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LogRangeWarningFetcherActor, 1, Void >*>(static_cast<LogRangeWarningFetcherActor*>(this)));
															#line 7891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1578 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		std::set<LogRangeAndUID> loggingRanges;
															#line 1579 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& it : existingLogRanges.get() ) {
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			Key logDestination;
															#line 1581 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			UID logUid;
															#line 1582 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			KeyRef logRangeBegin = logRangesDecodeKey(it.key, &logUid);
															#line 1583 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			Key logRangeEnd = logRangesDecodeValue(it.value, &logDestination);
															#line 1584 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			loggingRanges.insert(LogRangeAndUID(KeyRangeRef(logRangeBegin, logRangeEnd), logUid));
															#line 7912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		std::set<std::pair<Key, Key>> existingRanges;
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& it : existingDestUidValues.get() ) {
															#line 1589 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			KeyRange range = BinaryReader::fromStringRef<KeyRange>(it.key.removePrefix(destUidLookupPrefix), IncludeVersion());
															#line 1591 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			UID logUid = BinaryReader::fromStringRef<UID>(it.value, Unversioned());
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (loggingRanges.contains(LogRangeAndUID(range, logUid)))
															#line 7924 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1593 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				std::pair<Key, Key> rangePair = std::make_pair(range.begin, range.end);
															#line 1594 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (existingRanges.contains(rangePair))
															#line 7930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1595 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					std::string rangeDescription = (range == getDefaultBackupSharedRange()) ? "the default backup set" : format("`%s` - `%s`", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 1600 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					messages->push_back(JsonString::makeMessage( "duplicate_mutation_streams", format("Backup and DR are not sharing the same stream of mutations for %s", rangeDescription.c_str()) .c_str()));
															#line 7936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					break;
				}
															#line 1607 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				existingRanges.insert(rangePair);
															#line 7941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit() || timeoutFuture;
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 2;
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LogRangeWarningFetcherActor, 1, Void >*>(static_cast<LogRangeWarningFetcherActor*>(this)));
															#line 7953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state > 0) static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LogRangeWarningFetcherActor*>(this)->ActorCallback< LogRangeWarningFetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogRangeWarningFetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state > 0) static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LogRangeWarningFetcherActor*>(this)->ActorCallback< LogRangeWarningFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LogRangeWarningFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state > 0) static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LogRangeWarningFetcherActor*>(this)->ActorCallback< LogRangeWarningFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LogRangeWarningFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1565 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 1566 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<Void> timeoutFuture;
															#line 1573 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<RangeResult> existingDestUidValues;
															#line 1575 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<RangeResult> existingLogRanges;
															#line 8234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via logRangeWarningFetcher()
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class LogRangeWarningFetcherActor final : public Actor<Void>, public ActorCallback< LogRangeWarningFetcherActor, 0, Void >, public ActorCallback< LogRangeWarningFetcherActor, 1, Void >, public ActorCallback< LogRangeWarningFetcherActor, 2, Void >, public FastAllocated<LogRangeWarningFetcherActor>, public LogRangeWarningFetcherActorState<LogRangeWarningFetcherActor> {
															#line 8239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<LogRangeWarningFetcherActor>::operator new;
	using FastAllocated<LogRangeWarningFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4796645066021768448UL, 938450499709427712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogRangeWarningFetcherActor, 0, Void >;
friend struct ActorCallback< LogRangeWarningFetcherActor, 1, Void >;
friend struct ActorCallback< LogRangeWarningFetcherActor, 2, Void >;
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	LogRangeWarningFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 8258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<Void>(),
		   LogRangeWarningFetcherActorState<LogRangeWarningFetcherActor>(cx, messages, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16741679886096178432UL, 1377216152642019584UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logRangeWarningFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogRangeWarningFetcherActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LogRangeWarningFetcherActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LogRangeWarningFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<Void> logRangeWarningFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons ) {
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Void>(new LogRangeWarningFetcherActor(cx, messages, incomplete_reasons));
															#line 8293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 1632 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

struct ProtocolVersionData {
	ProtocolVersion runningProtocolVersion;
	ProtocolVersion newestProtocolVersion;
	ProtocolVersion lowestCompatibleProtocolVersion;
	ProtocolVersionData() : runningProtocolVersion(currentProtocolVersion()) {}

	ProtocolVersionData(uint64_t newestProtocolVersionValue, uint64_t lowestCompatibleProtocolVersionValue)
	  : runningProtocolVersion(currentProtocolVersion()), newestProtocolVersion(newestProtocolVersionValue),
	    lowestCompatibleProtocolVersion(lowestCompatibleProtocolVersionValue) {}
};

															#line 8309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getNewestProtocolVersion()
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class GetNewestProtocolVersionActor>
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetNewestProtocolVersionActorState {
															#line 8316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetNewestProtocolVersionActorState(Database const& cx,WorkerDetails const& ccWorker) 
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   ccWorker(ccWorker)
															#line 8325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetNewestProtocolVersionActorState() 
	{
		fdb_probe_actor_destroy("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1647 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				swVersionF = timeoutError( ccWorker.interf.eventLogRequest.getReply(EventLogRequest("SWVersionCompatibilityChecked"_sr)), 1.0);
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_0 = success(swVersionF);
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<GetNewestProtocolVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetNewestProtocolVersionActor*>(this)->actor_wait_state = 1;
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetNewestProtocolVersionActor, 0, Void >*>(static_cast<GetNewestProtocolVersionActor*>(this)));
															#line 8350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetNewestProtocolVersionActorState();
		static_cast<GetNewestProtocolVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1659 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 8380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1660 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 8384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 1662 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			TraceEvent(SevWarnAlways, "SWVersionStatusFailed").error(e);
															#line 1664 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<GetNewestProtocolVersionActor*>(this)->SAV<ProtocolVersionData>::futures) { (void)(ProtocolVersionData()); this->~GetNewestProtocolVersionActorState(); static_cast<GetNewestProtocolVersionActor*>(this)->destroy(); return 0; }
															#line 8390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			new (&static_cast<GetNewestProtocolVersionActor*>(this)->SAV< ProtocolVersionData >::value()) ProtocolVersionData(ProtocolVersionData());
			this->~GetNewestProtocolVersionActorState();
			static_cast<GetNewestProtocolVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1651 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& swVersionTrace = swVersionF.get();
															#line 1652 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int64_t newestProtocolVersionValue = std::stoull(swVersionTrace.getValue("NewestProtocolVersion").c_str(), nullptr, 16);
															#line 1654 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int64_t lowestCompatibleProtocolVersionValue = std::stoull(swVersionTrace.getValue("LowestCompatibleProtocolVersion").c_str(), nullptr, 16);
															#line 1657 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetNewestProtocolVersionActor*>(this)->SAV<ProtocolVersionData>::futures) { (void)(ProtocolVersionData(newestProtocolVersionValue, lowestCompatibleProtocolVersionValue)); this->~GetNewestProtocolVersionActorState(); static_cast<GetNewestProtocolVersionActor*>(this)->destroy(); return 0; }
															#line 8414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetNewestProtocolVersionActor*>(this)->SAV< ProtocolVersionData >::value()) ProtocolVersionData(ProtocolVersionData(newestProtocolVersionValue, lowestCompatibleProtocolVersionValue));
		this->~GetNewestProtocolVersionActorState();
		static_cast<GetNewestProtocolVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1651 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& swVersionTrace = swVersionF.get();
															#line 1652 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int64_t newestProtocolVersionValue = std::stoull(swVersionTrace.getValue("NewestProtocolVersion").c_str(), nullptr, 16);
															#line 1654 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int64_t lowestCompatibleProtocolVersionValue = std::stoull(swVersionTrace.getValue("LowestCompatibleProtocolVersion").c_str(), nullptr, 16);
															#line 1657 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetNewestProtocolVersionActor*>(this)->SAV<ProtocolVersionData>::futures) { (void)(ProtocolVersionData(newestProtocolVersionValue, lowestCompatibleProtocolVersionValue)); this->~GetNewestProtocolVersionActorState(); static_cast<GetNewestProtocolVersionActor*>(this)->destroy(); return 0; }
															#line 8432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetNewestProtocolVersionActor*>(this)->SAV< ProtocolVersionData >::value()) ProtocolVersionData(ProtocolVersionData(newestProtocolVersionValue, lowestCompatibleProtocolVersionValue));
		this->~GetNewestProtocolVersionActorState();
		static_cast<GetNewestProtocolVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetNewestProtocolVersionActor*>(this)->actor_wait_state > 0) static_cast<GetNewestProtocolVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetNewestProtocolVersionActor*>(this)->ActorCallback< GetNewestProtocolVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetNewestProtocolVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewestProtocolVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetNewestProtocolVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewestProtocolVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetNewestProtocolVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewestProtocolVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails ccWorker;
															#line 1647 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> swVersionF;
															#line 8521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getNewestProtocolVersion()
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetNewestProtocolVersionActor final : public Actor<ProtocolVersionData>, public ActorCallback< GetNewestProtocolVersionActor, 0, Void >, public FastAllocated<GetNewestProtocolVersionActor>, public GetNewestProtocolVersionActorState<GetNewestProtocolVersionActor> {
															#line 8526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetNewestProtocolVersionActor>::operator new;
	using FastAllocated<GetNewestProtocolVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4215305452499888128UL, 4598153642078500096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ProtocolVersionData>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetNewestProtocolVersionActor, 0, Void >;
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetNewestProtocolVersionActor(Database const& cx,WorkerDetails const& ccWorker) 
															#line 8543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<ProtocolVersionData>(),
		   GetNewestProtocolVersionActorState<GetNewestProtocolVersionActor>(cx, ccWorker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10890173716684436736UL, 2976883552386424576UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewestProtocolVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNewestProtocolVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetNewestProtocolVersionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<ProtocolVersionData> getNewestProtocolVersion( Database const& cx, WorkerDetails const& ccWorker ) {
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<ProtocolVersionData>(new GetNewestProtocolVersionActor(cx, ccWorker));
															#line 8576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 1667 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

struct LoadConfigurationResult {
	bool fullReplication;
	Optional<Key> healthyZone;
	double healthyZoneSeconds;
	bool rebalanceDDIgnored;
	// FIXME: possible convert it to int if upgrade value can be resolved?
	std::string rebalanceDDIgnoreHex; // any or combination of 0, 1, 2, see DDIgnore;
	bool dataDistributionDisabled;

	LoadConfigurationResult()
	  : fullReplication(true), healthyZoneSeconds(0), rebalanceDDIgnored(false), dataDistributionDisabled(false) {}
};

															#line 8594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via loadConfiguration()
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class LoadConfigurationActor>
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class LoadConfigurationActorState {
															#line 8601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	LoadConfigurationActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& status_incomplete_reasons) 
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   status_incomplete_reasons(status_incomplete_reasons),
															#line 1683 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   result(),
															#line 1684 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   loadResult(),
															#line 1685 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   tr(cx),
															#line 1686 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   getConfTimeout(delay(5.0))
															#line 8620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("loadConfiguration", reinterpret_cast<unsigned long>(this));

	}
	~LoadConfigurationActorState() 
	{
		fdb_probe_actor_destroy("loadConfiguration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1688 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 8635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadConfigurationActorState();
		static_cast<LoadConfigurationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1772 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LoadConfigurationActor*>(this)->SAV<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>::futures) { (void)(std::make_pair(result, loadResult)); this->~LoadConfigurationActorState(); static_cast<LoadConfigurationActor*>(this)->destroy(); return 0; }
															#line 8658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LoadConfigurationActor*>(this)->SAV< std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >::value()) std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>(std::make_pair(result, loadResult));
		this->~LoadConfigurationActorState();
		static_cast<LoadConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1689 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1690 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::CAUSAL_READ_RISKY);
															#line 8679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		try {
															#line 1693 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(configKeys, SERVER_KNOBS->CONFIGURATION_ROWS_TO_FETCH);
															#line 1692 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1703 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = getConfTimeout;
															#line 8689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 1;
															#line 1693 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 0, RangeResult >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 1703 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 1, Void >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 8696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1769 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 1769 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 3;
															#line 1769 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 4, Void >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 8738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1715 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		ASSERT(result.present());
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		replicasFutures = std::vector<Future<Optional<Value>>>();
															#line 1717 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& region : result.get().regions ) {
															#line 1718 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			replicasFutures.push_back(tr.get(datacenterReplicasKeyFor(region.dcId)));
															#line 8759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1720 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		healthyZoneValue = tr.get(healthyZoneKey);
															#line 1721 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		rebalanceDDIgnored = tr.get(rebalanceDDIgnoreKey);
															#line 1722 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		ddModeKey = tr.get(dataDistributionModeKey);
															#line 1725 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(replicasFutures) && success(healthyZoneValue) && success(rebalanceDDIgnored) && success(ddModeKey);
															#line 1724 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8771 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
															#line 1762 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_3 = getConfTimeout;
															#line 8775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
		static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 2;
															#line 1725 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 2, Void >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 1762 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 3, Void >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 8782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
															#line 1694 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		DatabaseConfiguration configuration;
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (res.size() == SERVER_KNOBS->CONFIGURATION_ROWS_TO_FETCH)
															#line 8793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1696 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			status_incomplete_reasons->insert("Too many configuration parameters set.");
															#line 8797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1698 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			configuration.fromKeyValues((VectorRef<KeyValueRef>)res);
															#line 8803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1701 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		result = configuration;
															#line 8807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
															#line 1694 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		DatabaseConfiguration configuration;
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (res.size() == SERVER_KNOBS->CONFIGURATION_ROWS_TO_FETCH)
															#line 8818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1696 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			status_incomplete_reasons->insert("Too many configuration parameters set.");
															#line 8822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1698 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			configuration.fromKeyValues((VectorRef<KeyValueRef>)res);
															#line 8828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1701 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		result = configuration;
															#line 8832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1704 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!result.present())
															#line 8841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1705 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back(JsonString::makeMessage("unreadable_configuration", "Unable to read database configuration."));
															#line 8845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1708 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("full_replication_timeout", "Unable to read datacenter replicas."));
															#line 8851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1704 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!result.present())
															#line 8861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1705 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back(JsonString::makeMessage("unreadable_configuration", "Unable to read database configuration."));
															#line 8865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1708 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("full_replication_timeout", "Unable to read datacenter replicas."));
															#line 8871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state > 0) static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 0, RangeResult >::remove();
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
															#line 1727 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int unreplicated = 0;
															#line 1728 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < result.get().regions.size();i++) {
															#line 1729 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!replicasFutures[i].get().present() || decodeDatacenterReplicasValue(replicasFutures[i].get().get()) < result.get().storageTeamSize)
															#line 9012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1732 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				unreplicated++;
															#line 9016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1735 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		LoadConfigurationResult res;
															#line 1736 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		res.fullReplication = (!unreplicated || (result.get().usableRegions == 1 && unreplicated < result.get().regions.size()));
															#line 1738 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (healthyZoneValue.get().present())
															#line 9025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto healthyZone = decodeHealthyZoneValue(healthyZoneValue.get().get());
															#line 1740 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (healthyZone.first == ignoreSSFailuresZoneString)
															#line 9031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1741 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				res.healthyZone = healthyZone.first;
															#line 9035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1742 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (healthyZone.second > tr.getReadVersion().get())
															#line 9041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1743 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					res.healthyZone = healthyZone.first;
															#line 1744 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					res.healthyZoneSeconds = (healthyZone.second - tr.getReadVersion().get()) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 9047 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
		}
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		res.rebalanceDDIgnored = rebalanceDDIgnored.get().present();
															#line 1749 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (res.rebalanceDDIgnored)
															#line 9055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1750 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			res.rebalanceDDIgnoreHex = rebalanceDDIgnored.get().get().toHexString();
															#line 9059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1752 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (ddModeKey.get().present())
															#line 9063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1753 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			BinaryReader rd(ddModeKey.get().get(), Unversioned());
															#line 1754 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int currentMode;
															#line 1755 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			rd >> currentMode;
															#line 1756 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (currentMode == 0)
															#line 9073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1757 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				res.dataDistributionDisabled = true;
															#line 9077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1760 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		loadResult = res;
															#line 9082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
															#line 1727 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int unreplicated = 0;
															#line 1728 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < result.get().regions.size();i++) {
															#line 1729 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!replicasFutures[i].get().present() || decodeDatacenterReplicasValue(replicasFutures[i].get().get()) < result.get().storageTeamSize)
															#line 9095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1732 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				unreplicated++;
															#line 9099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1735 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		LoadConfigurationResult res;
															#line 1736 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		res.fullReplication = (!unreplicated || (result.get().usableRegions == 1 && unreplicated < result.get().regions.size()));
															#line 1738 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (healthyZoneValue.get().present())
															#line 9108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto healthyZone = decodeHealthyZoneValue(healthyZoneValue.get().get());
															#line 1740 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (healthyZone.first == ignoreSSFailuresZoneString)
															#line 9114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1741 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				res.healthyZone = healthyZone.first;
															#line 9118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1742 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (healthyZone.second > tr.getReadVersion().get())
															#line 9124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1743 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					res.healthyZone = healthyZone.first;
															#line 1744 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					res.healthyZoneSeconds = (healthyZone.second - tr.getReadVersion().get()) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 9130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
		}
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		res.rebalanceDDIgnored = rebalanceDDIgnored.get().present();
															#line 1749 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (res.rebalanceDDIgnored)
															#line 9138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1750 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			res.rebalanceDDIgnoreHex = rebalanceDDIgnored.get().get().toHexString();
															#line 9142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1752 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (ddModeKey.get().present())
															#line 9146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1753 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			BinaryReader rd(ddModeKey.get().get(), Unversioned());
															#line 1754 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int currentMode;
															#line 1755 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			rd >> currentMode;
															#line 1756 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (currentMode == 0)
															#line 9156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1757 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				res.dataDistributionDisabled = true;
															#line 9160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1760 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		loadResult = res;
															#line 9165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void const& _,int loopDepth) 
	{
															#line 1763 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		messages->push_back( JsonString::makeMessage("full_replication_timeout", "Unable to read datacenter replicas."));
															#line 9174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void && _,int loopDepth) 
	{
															#line 1763 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		messages->push_back( JsonString::makeMessage("full_replication_timeout", "Unable to read datacenter replicas."));
															#line 9183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state > 0) static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 2, Void >::remove();
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state > 0) static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* status_incomplete_reasons;
															#line 1683 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Optional<DatabaseConfiguration> result;
															#line 1684 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Optional<LoadConfigurationResult> loadResult;
															#line 1685 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 1686 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<Void> getConfTimeout;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<Optional<Value>>> replicasFutures;
															#line 1720 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<Optional<Value>> healthyZoneValue;
															#line 1721 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<Optional<Value>> rebalanceDDIgnored;
															#line 1722 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<Optional<Value>> ddModeKey;
															#line 9418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via loadConfiguration()
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class LoadConfigurationActor final : public Actor<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>, public ActorCallback< LoadConfigurationActor, 0, RangeResult >, public ActorCallback< LoadConfigurationActor, 1, Void >, public ActorCallback< LoadConfigurationActor, 2, Void >, public ActorCallback< LoadConfigurationActor, 3, Void >, public ActorCallback< LoadConfigurationActor, 4, Void >, public FastAllocated<LoadConfigurationActor>, public LoadConfigurationActorState<LoadConfigurationActor> {
															#line 9423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<LoadConfigurationActor>::operator new;
	using FastAllocated<LoadConfigurationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14264281091465995008UL, 909116293398741504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadConfigurationActor, 0, RangeResult >;
friend struct ActorCallback< LoadConfigurationActor, 1, Void >;
friend struct ActorCallback< LoadConfigurationActor, 2, Void >;
friend struct ActorCallback< LoadConfigurationActor, 3, Void >;
friend struct ActorCallback< LoadConfigurationActor, 4, Void >;
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	LoadConfigurationActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& status_incomplete_reasons) 
															#line 9444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>(),
		   LoadConfigurationActorState<LoadConfigurationActor>(cx, messages, status_incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(440137498882600448UL, 6960115472849028608UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadConfiguration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadConfigurationActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadConfigurationActor, 2, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadConfigurationActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>> loadConfiguration( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& status_incomplete_reasons ) {
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>(new LoadConfigurationActor(cx, messages, status_incomplete_reasons));
															#line 9479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 1774 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

static JsonBuilderObject configurationFetcher(Optional<DatabaseConfiguration> conf,
                                              ServerCoordinators coordinators,
                                              std::set<std::string>* incomplete_reasons) {
	JsonBuilderObject statusObj;
	try {
		if (conf.present()) {
			DatabaseConfiguration configuration = conf.get();
			statusObj.addContents(configuration.toJSON());

			JsonBuilderArray excludedServersArr;
			std::set<AddressExclusion> excludedServers = configuration.getExcludedServers();
			for (std::set<AddressExclusion>::iterator it = excludedServers.begin(); it != excludedServers.end(); it++) {
				JsonBuilderObject statusObj;
				statusObj["address"] = it->toString();
				excludedServersArr.push_back(statusObj);
			}
			std::set<std::string> excludedLocalities = configuration.getExcludedLocalities();
			for (const auto& it : excludedLocalities) {
				JsonBuilderObject statusObj;
				statusObj["locality"] = it;
				excludedServersArr.push_back(statusObj);
			}
			statusObj["excluded_servers"] = excludedServersArr;
		}
		int count = coordinators.clientLeaderServers.size();
		statusObj["coordinators_count"] = count;
	} catch (Error& e) {
		if (e.code() == error_code_actor_cancelled) {
			throw;
		}
		incomplete_reasons->insert("Could not retrieve all configuration status information.");
	}
	return statusObj;
}

															#line 9519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via dataStatusFetcher()
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class DataStatusFetcherActor>
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class DataStatusFetcherActorState {
															#line 9526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	DataStatusFetcherActorState(WorkerDetails const& ddWorker,DatabaseConfiguration const& configuration,int* const& minStorageReplicasRemaining) 
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : ddWorker(ddWorker),
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   configuration(configuration),
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   minStorageReplicasRemaining(minStorageReplicasRemaining),
															#line 1813 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   statusObjData()
															#line 9539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("dataStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~DataStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("dataStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1816 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				std::vector<Future<TraceEventFields>> futures;
															#line 1819 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("DDTrackerStarting"_sr)), 1.0));
															#line 1821 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("DDTrackerStats"_sr)), 1.0));
															#line 1823 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("MovingData"_sr)), 1.0));
															#line 1825 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("TotalDataInFlight"_sr)), 1.0));
															#line 1827 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("TotalDataInFlightRemote"_sr)), 1.0));
															#line 1830 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<std::vector<TraceEventFields>> __when_expr_0 = getAll(futures);
															#line 1830 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<DataStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DataStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 1830 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*>(static_cast<DataStatusFetcherActor*>(this)));
															#line 9574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DataStatusFetcherActorState();
		static_cast<DataStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1976 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DataStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObjData); this->~DataStatusFetcherActorState(); static_cast<DataStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 9603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DataStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObjData)); // state_var_RVO
		this->~DataStatusFetcherActorState();
		static_cast<DataStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1970 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 9616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1971 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 9620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::vector<TraceEventFields> const& dataInfo,int loopDepth) 
	{
															#line 1832 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields startingStats = dataInfo[0];
															#line 1833 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields dataStats = dataInfo[1];
															#line 1835 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (startingStats.size() && startingStats.getValue("State") != "Active")
															#line 9640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1836 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject stateSectionObj;
															#line 1837 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["name"] = "initializing";
															#line 1838 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["description"] = "(Re)initializing automatic data distribution";
															#line 1839 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData["state"] = stateSectionObj;
															#line 1840 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<DataStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObjData); this->~DataStatusFetcherActorState(); static_cast<DataStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 9652 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			new (&static_cast<DataStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObjData)); // state_var_RVO
			this->~DataStatusFetcherActorState();
			static_cast<DataStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1843 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields md = dataInfo[2];
															#line 1846 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int64_t partitionsInFlight = 0;
															#line 1847 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int movingHighestPriority = 1000;
															#line 1848 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (md.size())
															#line 9666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1849 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int64_t partitionsInQueue = md.getInt64("InQueue");
															#line 1850 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int64_t averagePartitionSize = md.getInt64("AverageShardSize");
															#line 1851 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			partitionsInFlight = md.getInt64("InFlight");
															#line 1852 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			movingHighestPriority = md.getInt("HighestPriority");
															#line 1854 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (averagePartitionSize >= 0)
															#line 9678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject moving_data;
															#line 1856 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["in_queue_bytes"] = partitionsInQueue * averagePartitionSize;
															#line 1857 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["in_flight_bytes"] = partitionsInFlight * averagePartitionSize;
															#line 1858 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				moving_data.setKeyRawNumber("total_written_bytes", md.getValue("BytesWritten"));
															#line 1859 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["highest_priority"] = movingHighestPriority;
															#line 1862 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObjData["moving_data"] = moving_data;
															#line 1863 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObjData["average_partition_size_bytes"] = averagePartitionSize;
															#line 9694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1867 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (dataStats.size())
															#line 9699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1868 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("total_kv_size_bytes", dataStats.getValue("TotalSizeBytes"));
															#line 1869 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("system_kv_size_bytes", dataStats.getValue("SystemSizeBytes"));
															#line 1870 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("partitions_count", dataStats.getValue("Shards"));
															#line 9707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1873 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderArray teamTrackers;
															#line 1874 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 3;i < 5;i++) {
															#line 1875 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& inFlight = dataInfo[i];
															#line 1876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (inFlight.size() == 0)
															#line 9717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
				continue;
			}
															#line 1880 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int replicas = configuration.storageTeamSize;
															#line 1881 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			bool primary = inFlight.getInt("Primary");
															#line 1882 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int highestPriority = inFlight.getInt("HighestPriority");
															#line 1884 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (movingHighestPriority < SERVER_KNOBS->PRIORITY_TEAM_REDUNDANT)
															#line 9729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1885 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				highestPriority = movingHighestPriority;
															#line 9733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1886 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (partitionsInFlight > 0)
															#line 9739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1887 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					highestPriority = std::max<int>(highestPriority, SERVER_KNOBS->PRIORITY_MERGE_SHARD);
															#line 9743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 1890 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject team_tracker;
															#line 1891 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker["primary"] = primary;
															#line 1892 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker.setKeyRawNumber("in_flight_bytes", inFlight.getValue("TotalBytes"));
															#line 1893 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker.setKeyRawNumber("unhealthy_servers", inFlight.getValue("UnhealthyServers"));
															#line 1895 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject stateSectionObj;
															#line 1896 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_0_LEFT)
															#line 9758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1897 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["healthy"] = false;
															#line 1898 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["name"] = "missing_data";
															#line 1899 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["description"] = "No replicas remain of some data";
															#line 1900 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				replicas = 0;
															#line 9768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_1_LEFT)
															#line 9774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1902 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["healthy"] = false;
															#line 1903 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["name"] = "healing";
															#line 1904 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["description"] = "Only one replica remains of some data";
															#line 1905 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					replicas = 1;
															#line 9784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
				else
				{
															#line 1906 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_2_LEFT)
															#line 9790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					{
															#line 1907 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["healthy"] = false;
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["name"] = "healing";
															#line 1909 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["description"] = "Only two replicas remain of some data";
															#line 1910 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						replicas = 2;
															#line 9800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					}
					else
					{
															#line 1911 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_UNHEALTHY)
															#line 9806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
						{
															#line 1912 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["healthy"] = false;
															#line 1913 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["name"] = "healing";
															#line 1914 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["description"] = "Restoring replication factor";
															#line 9814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
						}
						else
						{
															#line 1915 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
							if (highestPriority >= SERVER_KNOBS->PRIORITY_POPULATE_REGION)
															#line 9820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
							{
															#line 1916 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["healthy"] = true;
															#line 1917 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["name"] = "healthy_populating_region";
															#line 1918 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["description"] = "Populating remote region";
															#line 9828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
							}
							else
							{
															#line 1919 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
								if (highestPriority >= SERVER_KNOBS->PRIORITY_MERGE_SHARD)
															#line 9834 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
								{
															#line 1920 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["healthy"] = true;
															#line 1921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["name"] = "healthy_repartitioning";
															#line 1922 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["description"] = "Repartitioning";
															#line 9842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
								}
								else
								{
															#line 1923 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
									if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_REDUNDANT)
															#line 9848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
									{
															#line 1924 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["healthy"] = true;
															#line 1925 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["name"] = "optimizing_team_collections";
															#line 1926 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["description"] = "Optimizing team collections";
															#line 9856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
									}
									else
									{
															#line 1927 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
										if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_CONTAINS_UNDESIRED_SERVER)
															#line 9862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
										{
															#line 1928 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["healthy"] = true;
															#line 1929 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["name"] = "healthy_removing_server";
															#line 1930 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["description"] = "Removing storage server";
															#line 9870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
										}
										else
										{
															#line 1931 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
											if (highestPriority == SERVER_KNOBS->PRIORITY_TEAM_HEALTHY)
															#line 9876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
											{
															#line 1932 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
												stateSectionObj["healthy"] = true;
															#line 1933 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
												stateSectionObj["name"] = "healthy";
															#line 9882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
											}
											else
											{
															#line 1934 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
												if (highestPriority == SERVER_KNOBS->PRIORITY_PERPETUAL_STORAGE_WIGGLE)
															#line 9888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
												{
															#line 1935 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["healthy"] = true;
															#line 1936 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["name"] = "healthy_perpetual_wiggle";
															#line 1937 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["description"] = "Wiggling storage server";
															#line 9896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
												}
												else
												{
															#line 1938 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
													if (highestPriority >= SERVER_KNOBS->PRIORITY_RECOVER_MOVE)
															#line 9902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
													{
															#line 1939 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["healthy"] = true;
															#line 1940 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["name"] = "healthy_rebalancing";
															#line 1941 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["description"] = "Rebalancing";
															#line 9910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
													}
													else
													{
															#line 1942 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
														if (highestPriority >= 0)
															#line 9916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
														{
															#line 1943 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															stateSectionObj["healthy"] = true;
															#line 1944 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															stateSectionObj["name"] = "healthy";
															#line 9922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
															#line 1949 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["min_replicas_remaining"] = replicas;
															#line 1951 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!stateSectionObj.empty())
															#line 9939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1952 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				team_tracker["state"] = stateSectionObj;
															#line 1953 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				teamTrackers.push_back(team_tracker);
															#line 1954 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (primary)
															#line 9947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					statusObjData["state"] = stateSectionObj;
															#line 9951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 1962 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (primary)
															#line 9956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1963 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				*minStorageReplicasRemaining = std::max(*minStorageReplicasRemaining, 0) + replicas;
															#line 9960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1964 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (replicas > 0)
															#line 9966 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1965 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					*minStorageReplicasRemaining = std::max(*minStorageReplicasRemaining, 0) + 1;
															#line 9970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
		}
															#line 1968 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObjData["team_trackers"] = teamTrackers;
															#line 9976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont41(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::vector<TraceEventFields> && dataInfo,int loopDepth) 
	{
															#line 1832 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields startingStats = dataInfo[0];
															#line 1833 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields dataStats = dataInfo[1];
															#line 1835 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (startingStats.size() && startingStats.getValue("State") != "Active")
															#line 9989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1836 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject stateSectionObj;
															#line 1837 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["name"] = "initializing";
															#line 1838 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["description"] = "(Re)initializing automatic data distribution";
															#line 1839 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData["state"] = stateSectionObj;
															#line 1840 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<DataStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObjData); this->~DataStatusFetcherActorState(); static_cast<DataStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 10001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			new (&static_cast<DataStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObjData)); // state_var_RVO
			this->~DataStatusFetcherActorState();
			static_cast<DataStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1843 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields md = dataInfo[2];
															#line 1846 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int64_t partitionsInFlight = 0;
															#line 1847 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int movingHighestPriority = 1000;
															#line 1848 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (md.size())
															#line 10015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1849 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int64_t partitionsInQueue = md.getInt64("InQueue");
															#line 1850 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int64_t averagePartitionSize = md.getInt64("AverageShardSize");
															#line 1851 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			partitionsInFlight = md.getInt64("InFlight");
															#line 1852 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			movingHighestPriority = md.getInt("HighestPriority");
															#line 1854 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (averagePartitionSize >= 0)
															#line 10027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject moving_data;
															#line 1856 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["in_queue_bytes"] = partitionsInQueue * averagePartitionSize;
															#line 1857 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["in_flight_bytes"] = partitionsInFlight * averagePartitionSize;
															#line 1858 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				moving_data.setKeyRawNumber("total_written_bytes", md.getValue("BytesWritten"));
															#line 1859 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["highest_priority"] = movingHighestPriority;
															#line 1862 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObjData["moving_data"] = moving_data;
															#line 1863 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObjData["average_partition_size_bytes"] = averagePartitionSize;
															#line 10043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1867 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (dataStats.size())
															#line 10048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 1868 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("total_kv_size_bytes", dataStats.getValue("TotalSizeBytes"));
															#line 1869 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("system_kv_size_bytes", dataStats.getValue("SystemSizeBytes"));
															#line 1870 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("partitions_count", dataStats.getValue("Shards"));
															#line 10056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 1873 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderArray teamTrackers;
															#line 1874 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 3;i < 5;i++) {
															#line 1875 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& inFlight = dataInfo[i];
															#line 1876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (inFlight.size() == 0)
															#line 10066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
				continue;
			}
															#line 1880 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int replicas = configuration.storageTeamSize;
															#line 1881 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			bool primary = inFlight.getInt("Primary");
															#line 1882 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int highestPriority = inFlight.getInt("HighestPriority");
															#line 1884 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (movingHighestPriority < SERVER_KNOBS->PRIORITY_TEAM_REDUNDANT)
															#line 10078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1885 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				highestPriority = movingHighestPriority;
															#line 10082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1886 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (partitionsInFlight > 0)
															#line 10088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1887 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					highestPriority = std::max<int>(highestPriority, SERVER_KNOBS->PRIORITY_MERGE_SHARD);
															#line 10092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 1890 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject team_tracker;
															#line 1891 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker["primary"] = primary;
															#line 1892 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker.setKeyRawNumber("in_flight_bytes", inFlight.getValue("TotalBytes"));
															#line 1893 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker.setKeyRawNumber("unhealthy_servers", inFlight.getValue("UnhealthyServers"));
															#line 1895 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject stateSectionObj;
															#line 1896 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_0_LEFT)
															#line 10107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1897 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["healthy"] = false;
															#line 1898 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["name"] = "missing_data";
															#line 1899 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["description"] = "No replicas remain of some data";
															#line 1900 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				replicas = 0;
															#line 10117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_1_LEFT)
															#line 10123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1902 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["healthy"] = false;
															#line 1903 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["name"] = "healing";
															#line 1904 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["description"] = "Only one replica remains of some data";
															#line 1905 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					replicas = 1;
															#line 10133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
				else
				{
															#line 1906 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_2_LEFT)
															#line 10139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					{
															#line 1907 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["healthy"] = false;
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["name"] = "healing";
															#line 1909 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["description"] = "Only two replicas remain of some data";
															#line 1910 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						replicas = 2;
															#line 10149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					}
					else
					{
															#line 1911 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_UNHEALTHY)
															#line 10155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
						{
															#line 1912 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["healthy"] = false;
															#line 1913 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["name"] = "healing";
															#line 1914 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["description"] = "Restoring replication factor";
															#line 10163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
						}
						else
						{
															#line 1915 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
							if (highestPriority >= SERVER_KNOBS->PRIORITY_POPULATE_REGION)
															#line 10169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
							{
															#line 1916 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["healthy"] = true;
															#line 1917 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["name"] = "healthy_populating_region";
															#line 1918 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["description"] = "Populating remote region";
															#line 10177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
							}
							else
							{
															#line 1919 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
								if (highestPriority >= SERVER_KNOBS->PRIORITY_MERGE_SHARD)
															#line 10183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
								{
															#line 1920 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["healthy"] = true;
															#line 1921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["name"] = "healthy_repartitioning";
															#line 1922 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["description"] = "Repartitioning";
															#line 10191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
								}
								else
								{
															#line 1923 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
									if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_REDUNDANT)
															#line 10197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
									{
															#line 1924 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["healthy"] = true;
															#line 1925 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["name"] = "optimizing_team_collections";
															#line 1926 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["description"] = "Optimizing team collections";
															#line 10205 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
									}
									else
									{
															#line 1927 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
										if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_CONTAINS_UNDESIRED_SERVER)
															#line 10211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
										{
															#line 1928 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["healthy"] = true;
															#line 1929 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["name"] = "healthy_removing_server";
															#line 1930 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["description"] = "Removing storage server";
															#line 10219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
										}
										else
										{
															#line 1931 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
											if (highestPriority == SERVER_KNOBS->PRIORITY_TEAM_HEALTHY)
															#line 10225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
											{
															#line 1932 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
												stateSectionObj["healthy"] = true;
															#line 1933 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
												stateSectionObj["name"] = "healthy";
															#line 10231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
											}
											else
											{
															#line 1934 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
												if (highestPriority == SERVER_KNOBS->PRIORITY_PERPETUAL_STORAGE_WIGGLE)
															#line 10237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
												{
															#line 1935 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["healthy"] = true;
															#line 1936 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["name"] = "healthy_perpetual_wiggle";
															#line 1937 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["description"] = "Wiggling storage server";
															#line 10245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
												}
												else
												{
															#line 1938 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
													if (highestPriority >= SERVER_KNOBS->PRIORITY_RECOVER_MOVE)
															#line 10251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
													{
															#line 1939 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["healthy"] = true;
															#line 1940 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["name"] = "healthy_rebalancing";
															#line 1941 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["description"] = "Rebalancing";
															#line 10259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
													}
													else
													{
															#line 1942 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
														if (highestPriority >= 0)
															#line 10265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
														{
															#line 1943 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															stateSectionObj["healthy"] = true;
															#line 1944 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															stateSectionObj["name"] = "healthy";
															#line 10271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
															#line 1949 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["min_replicas_remaining"] = replicas;
															#line 1951 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!stateSectionObj.empty())
															#line 10288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1952 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				team_tracker["state"] = stateSectionObj;
															#line 1953 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				teamTrackers.push_back(team_tracker);
															#line 1954 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (primary)
															#line 10296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					statusObjData["state"] = stateSectionObj;
															#line 10300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 1962 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (primary)
															#line 10305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 1963 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				*minStorageReplicasRemaining = std::max(*minStorageReplicasRemaining, 0) + replicas;
															#line 10309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1964 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (replicas > 0)
															#line 10315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 1965 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					*minStorageReplicasRemaining = std::max(*minStorageReplicasRemaining, 0) + 1;
															#line 10319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
		}
															#line 1968 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObjData["team_trackers"] = teamTrackers;
															#line 10325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont41(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<TraceEventFields> const& dataInfo,int loopDepth) 
	{
		loopDepth = a_body1cont2(dataInfo, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<TraceEventFields> && dataInfo,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(dataInfo), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DataStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<DataStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<DataStatusFetcherActor*>(this)->ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont41(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails ddWorker;
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	DatabaseConfiguration configuration;
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	int* minStorageReplicasRemaining;
															#line 1813 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObjData;
															#line 10426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via dataStatusFetcher()
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class DataStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >, public FastAllocated<DataStatusFetcherActor>, public DataStatusFetcherActorState<DataStatusFetcherActor> {
															#line 10431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<DataStatusFetcherActor>::operator new;
	using FastAllocated<DataStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1352172446802010112UL, 1790622952771228928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >;
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	DataStatusFetcherActor(WorkerDetails const& ddWorker,DatabaseConfiguration const& configuration,int* const& minStorageReplicasRemaining) 
															#line 10448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   DataStatusFetcherActorState<DataStatusFetcherActor>(ddWorker, configuration, minStorageReplicasRemaining),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dataStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14405987564440952576UL, 17712536245104413440UL);
		ActorExecutionContextHelper __helper(static_cast<DataStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dataStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dataStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> dataStatusFetcher( WorkerDetails const& ddWorker, DatabaseConfiguration const& configuration, int* const& minStorageReplicasRemaining ) {
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new DataStatusFetcherActor(ddWorker, configuration, minStorageReplicasRemaining));
															#line 10481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 1978 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 10486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getServerMetrics()
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class iface, class GetServerMetricsActor>
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetServerMetricsActorState {
															#line 10493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetServerMetricsActorState(std::vector<iface> const& servers,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers,std::vector<std::string> const& eventNames) 
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : servers(servers),
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers),
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   eventNames(eventNames),
															#line 1984 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   futures()
															#line 10506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getServerMetrics", reinterpret_cast<unsigned long>(this));

	}
	~GetServerMetricsActorState() 
	{
		fdb_probe_actor_destroy("getServerMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1985 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			for( auto s : servers ) {
															#line 1986 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				for( auto name : eventNames ) {
															#line 1987 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					futures.push_back(latestEventOnWorker(address_workers[s.address()], s.id().toString() + "/" + name));
															#line 10525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 1991 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(futures);
															#line 1991 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetServerMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetServerMetricsActor*>(this)->actor_wait_state = 1;
															#line 1991 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetServerMetricsActor, 0, Void >*>(static_cast<GetServerMetricsActor*>(this)));
															#line 10537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetServerMetricsActorState();
		static_cast<GetServerMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1993 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		std::vector<std::pair<iface, EventMap>> results;
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		auto futureItr = futures.begin();
															#line 1996 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < servers.size();i++) {
															#line 1997 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			EventMap serverResults;
															#line 1998 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			for( auto name : eventNames ) {
															#line 1999 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				ASSERT(futureItr != futures.end());
															#line 2000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				serverResults[name] = futureItr->get().present() ? futureItr->get().get() : TraceEventFields();
															#line 2001 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				++futureItr;
															#line 10574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 2004 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			results.emplace_back(servers[i], serverResults);
															#line 10578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2007 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetServerMetricsActor*>(this)->SAV<std::vector<std::pair<iface, EventMap>>>::futures) { (void)(results); this->~GetServerMetricsActorState(); static_cast<GetServerMetricsActor*>(this)->destroy(); return 0; }
															#line 10582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetServerMetricsActor*>(this)->SAV< std::vector<std::pair<iface, EventMap>> >::value()) std::vector<std::pair<iface, EventMap>>(results);
		this->~GetServerMetricsActorState();
		static_cast<GetServerMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1993 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		std::vector<std::pair<iface, EventMap>> results;
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		auto futureItr = futures.begin();
															#line 1996 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < servers.size();i++) {
															#line 1997 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			EventMap serverResults;
															#line 1998 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			for( auto name : eventNames ) {
															#line 1999 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				ASSERT(futureItr != futures.end());
															#line 2000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				serverResults[name] = futureItr->get().present() ? futureItr->get().get() : TraceEventFields();
															#line 2001 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				++futureItr;
															#line 10608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 2004 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			results.emplace_back(servers[i], serverResults);
															#line 10612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2007 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetServerMetricsActor*>(this)->SAV<std::vector<std::pair<iface, EventMap>>>::futures) { (void)(results); this->~GetServerMetricsActorState(); static_cast<GetServerMetricsActor*>(this)->destroy(); return 0; }
															#line 10616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetServerMetricsActor*>(this)->SAV< std::vector<std::pair<iface, EventMap>> >::value()) std::vector<std::pair<iface, EventMap>>(results);
		this->~GetServerMetricsActorState();
		static_cast<GetServerMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetServerMetricsActor*>(this)->actor_wait_state > 0) static_cast<GetServerMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<GetServerMetricsActor*>(this)->ActorCallback< GetServerMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetServerMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetServerMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetServerMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<iface> servers;
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::string> eventNames;
															#line 1984 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<Optional<TraceEventFields>>> futures;
															#line 10707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getServerMetrics()
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class iface>
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetServerMetricsActor final : public Actor<std::vector<std::pair<iface, EventMap>>>, public ActorCallback< GetServerMetricsActor<iface>, 0, Void >, public FastAllocated<GetServerMetricsActor<iface>>, public GetServerMetricsActorState<iface, GetServerMetricsActor<iface>> {
															#line 10714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetServerMetricsActor<iface>>::operator new;
	using FastAllocated<GetServerMetricsActor<iface>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(759426115184298496UL, 13437919429923958272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<iface, EventMap>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetServerMetricsActor<iface>, 0, Void >;
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetServerMetricsActor(std::vector<iface> const& servers,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers,std::vector<std::string> const& eventNames) 
															#line 10731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<std::vector<std::pair<iface, EventMap>>>(),
		   GetServerMetricsActorState<iface, GetServerMetricsActor<iface>>(servers, address_workers, eventNames),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getServerMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10378310344083509504UL, 12687082714580923648UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getServerMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getServerMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetServerMetricsActor<iface>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class iface>
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<iface, EventMap>>> getServerMetrics( std::vector<iface> const& servers, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers, std::vector<std::string> const& eventNames ) {
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<std::pair<iface, EventMap>>>(new GetServerMetricsActor<iface>(servers, address_workers, eventNames));
															#line 10766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 2009 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

namespace {

const std::vector<std::string> STORAGE_SERVER_METRICS_LIST{ "StorageMetrics", "ReadLatencyMetrics", "ReadLatencyBands",
	                                                        "BusiestReadTag", "BusiestWriteTag",    "RocksDBMetrics" };

} // namespace

															#line 10778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getStorageServerStatusInfos()
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class GetStorageServerStatusInfosActor>
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetStorageServerStatusInfosActorState {
															#line 10785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetStorageServerStatusInfosActorState(std::vector<StorageServerMetaInfo> const& storageMetadatas,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers,WorkerDetails const& rkWorker) 
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : storageMetadatas(storageMetadatas),
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers),
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   rkWorker(rkWorker),
															#line 2021 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   servers()
															#line 10798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServerStatusInfosActorState() 
	{
		fdb_probe_actor_destroy("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2022 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			servers.reserve(storageMetadatas.size());
															#line 2023 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			for( const auto& meta : storageMetadatas ) {
															#line 2024 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				servers.push_back(StorageServerStatusInfo(meta));
															#line 10817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			results = std::vector<std::pair<StorageServerStatusInfo, EventMap>>();
															#line 2027 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(results, getServerMetrics(servers, address_workers, STORAGE_SERVER_METRICS_LIST));
															#line 2027 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetStorageServerStatusInfosActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetStorageServerStatusInfosActor*>(this)->actor_wait_state = 1;
															#line 2027 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*>(static_cast<GetStorageServerStatusInfosActor*>(this)));
															#line 10830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServerStatusInfosActorState();
		static_cast<GetStorageServerStatusInfosActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2028 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < results.size();++i) {
															#line 2029 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			servers[i].eventMap = std::move(results[i].second);
															#line 10855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2031 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetStorageServerStatusInfosActor*>(this)->SAV<std::vector<StorageServerStatusInfo>>::futures) { (void)(servers); this->~GetStorageServerStatusInfosActorState(); static_cast<GetStorageServerStatusInfosActor*>(this)->destroy(); return 0; }
															#line 10859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetStorageServerStatusInfosActor*>(this)->SAV< std::vector<StorageServerStatusInfo> >::value()) std::vector<StorageServerStatusInfo>(std::move(servers)); // state_var_RVO
		this->~GetStorageServerStatusInfosActorState();
		static_cast<GetStorageServerStatusInfosActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2028 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < results.size();++i) {
															#line 2029 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			servers[i].eventMap = std::move(results[i].second);
															#line 10873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2031 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetStorageServerStatusInfosActor*>(this)->SAV<std::vector<StorageServerStatusInfo>>::futures) { (void)(servers); this->~GetStorageServerStatusInfosActorState(); static_cast<GetStorageServerStatusInfosActor*>(this)->destroy(); return 0; }
															#line 10877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetStorageServerStatusInfosActor*>(this)->SAV< std::vector<StorageServerStatusInfo> >::value()) std::vector<StorageServerStatusInfo>(std::move(servers)); // state_var_RVO
		this->~GetStorageServerStatusInfosActorState();
		static_cast<GetStorageServerStatusInfosActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServerStatusInfosActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServerStatusInfosActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServerStatusInfosActor*>(this)->ActorCallback< GetStorageServerStatusInfosActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerStatusInfosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerStatusInfosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerStatusInfosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<StorageServerMetaInfo> storageMetadatas;
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails rkWorker;
															#line 2021 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<StorageServerStatusInfo> servers;
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<StorageServerStatusInfo, EventMap>> results;
															#line 10970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getStorageServerStatusInfos()
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetStorageServerStatusInfosActor final : public Actor<std::vector<StorageServerStatusInfo>>, public ActorCallback< GetStorageServerStatusInfosActor, 0, Void >, public FastAllocated<GetStorageServerStatusInfosActor>, public GetStorageServerStatusInfosActorState<GetStorageServerStatusInfosActor> {
															#line 10975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetStorageServerStatusInfosActor>::operator new;
	using FastAllocated<GetStorageServerStatusInfosActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(461132477210208256UL, 3572292455999375104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<StorageServerStatusInfo>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServerStatusInfosActor, 0, Void >;
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetStorageServerStatusInfosActor(std::vector<StorageServerMetaInfo> const& storageMetadatas,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers,WorkerDetails const& rkWorker) 
															#line 10992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<std::vector<StorageServerStatusInfo>>(),
		   GetStorageServerStatusInfosActorState<GetStorageServerStatusInfosActor>(storageMetadatas, address_workers, rkWorker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14011788060670041344UL, 4151862449577500672UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerStatusInfosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServerStatusInfos");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<StorageServerStatusInfo>> getStorageServerStatusInfos( std::vector<StorageServerMetaInfo> const& storageMetadatas, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers, WorkerDetails const& rkWorker ) {
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<StorageServerStatusInfo>>(new GetStorageServerStatusInfosActor(storageMetadatas, address_workers, rkWorker));
															#line 11025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 2033 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 11030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getTLogsAndMetrics()
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class GetTLogsAndMetricsActor>
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetTLogsAndMetricsActorState {
															#line 11037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetTLogsAndMetricsActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers)
															#line 11046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	~GetTLogsAndMetricsActorState() 
	{
		fdb_probe_actor_destroy("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2037 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			std::vector<TLogInterface> servers = db->get().logSystemConfig.allPresentLogs();
															#line 2038 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::vector<std::pair<TLogInterface, EventMap>>> __when_expr_0 = getServerMetrics(servers, address_workers, std::vector<std::string>{ "TLogMetrics" });
															#line 2038 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetTLogsAndMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTLogsAndMetricsActor*>(this)->actor_wait_state = 1;
															#line 2038 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*>(static_cast<GetTLogsAndMetricsActor*>(this)));
															#line 11070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTLogsAndMetricsActorState();
		static_cast<GetTLogsAndMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<TLogInterface, EventMap>> const& results,int loopDepth) 
	{
															#line 2041 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetTLogsAndMetricsActor*>(this)->SAV<std::vector<std::pair<TLogInterface, EventMap>>>::futures) { (void)(results); this->~GetTLogsAndMetricsActorState(); static_cast<GetTLogsAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetTLogsAndMetricsActor*>(this)->SAV< std::vector<std::pair<TLogInterface, EventMap>> >::value()) std::vector<std::pair<TLogInterface, EventMap>>(results);
		this->~GetTLogsAndMetricsActorState();
		static_cast<GetTLogsAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<TLogInterface, EventMap>> && results,int loopDepth) 
	{
															#line 2041 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetTLogsAndMetricsActor*>(this)->SAV<std::vector<std::pair<TLogInterface, EventMap>>>::futures) { (void)(results); this->~GetTLogsAndMetricsActorState(); static_cast<GetTLogsAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetTLogsAndMetricsActor*>(this)->SAV< std::vector<std::pair<TLogInterface, EventMap>> >::value()) std::vector<std::pair<TLogInterface, EventMap>>(results);
		this->~GetTLogsAndMetricsActorState();
		static_cast<GetTLogsAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<TLogInterface, EventMap>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<TLogInterface, EventMap>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTLogsAndMetricsActor*>(this)->actor_wait_state > 0) static_cast<GetTLogsAndMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<GetTLogsAndMetricsActor*>(this)->ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*,std::vector<std::pair<TLogInterface, EventMap>> const& value) 
	{
		fdb_probe_actor_enter("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogsAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*,std::vector<std::pair<TLogInterface, EventMap>> && value) 
	{
		fdb_probe_actor_enter("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogsAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogsAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 11192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getTLogsAndMetrics()
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetTLogsAndMetricsActor final : public Actor<std::vector<std::pair<TLogInterface, EventMap>>>, public ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >, public FastAllocated<GetTLogsAndMetricsActor>, public GetTLogsAndMetricsActorState<GetTLogsAndMetricsActor> {
															#line 11197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetTLogsAndMetricsActor>::operator new;
	using FastAllocated<GetTLogsAndMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4974947129958441472UL, 4907533099788857344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<TLogInterface, EventMap>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >;
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetTLogsAndMetricsActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 11214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<std::vector<std::pair<TLogInterface, EventMap>>>(),
		   GetTLogsAndMetricsActorState<GetTLogsAndMetricsActor>(db, address_workers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7806185236702080000UL, 16667331025509920768UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogsAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTLogsAndMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<TLogInterface, EventMap>>> getTLogsAndMetrics( Reference<AsyncVar<ServerDBInfo>> const& db, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers ) {
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<std::pair<TLogInterface, EventMap>>>(new GetTLogsAndMetricsActor(db, address_workers));
															#line 11247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 2043 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

// Returns list of tuples of grv proxy interfaces and their latency metrics
															#line 11253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getCommitProxiesAndMetrics()
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class GetCommitProxiesAndMetricsActor>
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetCommitProxiesAndMetricsActorState {
															#line 11260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetCommitProxiesAndMetricsActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers)
															#line 11269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	~GetCommitProxiesAndMetricsActorState() 
	{
		fdb_probe_actor_destroy("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2048 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::vector<std::pair<CommitProxyInterface, EventMap>>> __when_expr_0 = getServerMetrics( db->get().client.commitProxies, address_workers, std::vector<std::string>{ "CommitLatencyMetrics", "CommitLatencyBands", "CommitBatchingWindowSize" });
															#line 2048 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetCommitProxiesAndMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCommitProxiesAndMetricsActor*>(this)->actor_wait_state = 1;
															#line 2048 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*>(static_cast<GetCommitProxiesAndMetricsActor*>(this)));
															#line 11291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCommitProxiesAndMetricsActorState();
		static_cast<GetCommitProxiesAndMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<CommitProxyInterface, EventMap>> const& results,int loopDepth) 
	{
															#line 2053 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetCommitProxiesAndMetricsActor*>(this)->SAV<std::vector<std::pair<CommitProxyInterface, EventMap>>>::futures) { (void)(results); this->~GetCommitProxiesAndMetricsActorState(); static_cast<GetCommitProxiesAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetCommitProxiesAndMetricsActor*>(this)->SAV< std::vector<std::pair<CommitProxyInterface, EventMap>> >::value()) std::vector<std::pair<CommitProxyInterface, EventMap>>(results);
		this->~GetCommitProxiesAndMetricsActorState();
		static_cast<GetCommitProxiesAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<CommitProxyInterface, EventMap>> && results,int loopDepth) 
	{
															#line 2053 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetCommitProxiesAndMetricsActor*>(this)->SAV<std::vector<std::pair<CommitProxyInterface, EventMap>>>::futures) { (void)(results); this->~GetCommitProxiesAndMetricsActorState(); static_cast<GetCommitProxiesAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetCommitProxiesAndMetricsActor*>(this)->SAV< std::vector<std::pair<CommitProxyInterface, EventMap>> >::value()) std::vector<std::pair<CommitProxyInterface, EventMap>>(results);
		this->~GetCommitProxiesAndMetricsActorState();
		static_cast<GetCommitProxiesAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<CommitProxyInterface, EventMap>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<CommitProxyInterface, EventMap>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCommitProxiesAndMetricsActor*>(this)->actor_wait_state > 0) static_cast<GetCommitProxiesAndMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommitProxiesAndMetricsActor*>(this)->ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*,std::vector<std::pair<CommitProxyInterface, EventMap>> const& value) 
	{
		fdb_probe_actor_enter("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*,std::vector<std::pair<CommitProxyInterface, EventMap>> && value) 
	{
		fdb_probe_actor_enter("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*,Error err) 
	{
		fdb_probe_actor_enter("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 11413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getCommitProxiesAndMetrics()
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetCommitProxiesAndMetricsActor final : public Actor<std::vector<std::pair<CommitProxyInterface, EventMap>>>, public ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >, public FastAllocated<GetCommitProxiesAndMetricsActor>, public GetCommitProxiesAndMetricsActorState<GetCommitProxiesAndMetricsActor> {
															#line 11418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetCommitProxiesAndMetricsActor>::operator new;
	using FastAllocated<GetCommitProxiesAndMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15183076659736050688UL, 15099543807479390976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<CommitProxyInterface, EventMap>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >;
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetCommitProxiesAndMetricsActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 11435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<std::vector<std::pair<CommitProxyInterface, EventMap>>>(),
		   GetCommitProxiesAndMetricsActorState<GetCommitProxiesAndMetricsActor>(db, address_workers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1575106491018932224UL, 2149067258200158208UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCommitProxiesAndMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<CommitProxyInterface, EventMap>>> getCommitProxiesAndMetrics( Reference<AsyncVar<ServerDBInfo>> const& db, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers ) {
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<std::pair<CommitProxyInterface, EventMap>>>(new GetCommitProxiesAndMetricsActor(db, address_workers));
															#line 11468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 2055 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 11473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getGrvProxiesAndMetrics()
															#line 2056 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class GetGrvProxiesAndMetricsActor>
															#line 2056 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetGrvProxiesAndMetricsActorState {
															#line 11480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 2056 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetGrvProxiesAndMetricsActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 2056 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 2056 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2056 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers)
															#line 11489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	~GetGrvProxiesAndMetricsActorState() 
	{
		fdb_probe_actor_destroy("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2059 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::vector<std::pair<GrvProxyInterface, EventMap>>> __when_expr_0 = getServerMetrics(db->get().client.grvProxies, address_workers, std::vector<std::string>{ "GRVLatencyMetrics", "GRVLatencyBands", "GRVBatchLatencyMetrics" });
															#line 2059 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetGrvProxiesAndMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetGrvProxiesAndMetricsActor*>(this)->actor_wait_state = 1;
															#line 2059 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*>(static_cast<GetGrvProxiesAndMetricsActor*>(this)));
															#line 11511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetGrvProxiesAndMetricsActorState();
		static_cast<GetGrvProxiesAndMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<GrvProxyInterface, EventMap>> const& results,int loopDepth) 
	{
															#line 2063 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetGrvProxiesAndMetricsActor*>(this)->SAV<std::vector<std::pair<GrvProxyInterface, EventMap>>>::futures) { (void)(results); this->~GetGrvProxiesAndMetricsActorState(); static_cast<GetGrvProxiesAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetGrvProxiesAndMetricsActor*>(this)->SAV< std::vector<std::pair<GrvProxyInterface, EventMap>> >::value()) std::vector<std::pair<GrvProxyInterface, EventMap>>(results);
		this->~GetGrvProxiesAndMetricsActorState();
		static_cast<GetGrvProxiesAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<GrvProxyInterface, EventMap>> && results,int loopDepth) 
	{
															#line 2063 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetGrvProxiesAndMetricsActor*>(this)->SAV<std::vector<std::pair<GrvProxyInterface, EventMap>>>::futures) { (void)(results); this->~GetGrvProxiesAndMetricsActorState(); static_cast<GetGrvProxiesAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetGrvProxiesAndMetricsActor*>(this)->SAV< std::vector<std::pair<GrvProxyInterface, EventMap>> >::value()) std::vector<std::pair<GrvProxyInterface, EventMap>>(results);
		this->~GetGrvProxiesAndMetricsActorState();
		static_cast<GetGrvProxiesAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<GrvProxyInterface, EventMap>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<GrvProxyInterface, EventMap>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetGrvProxiesAndMetricsActor*>(this)->actor_wait_state > 0) static_cast<GetGrvProxiesAndMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<GetGrvProxiesAndMetricsActor*>(this)->ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*,std::vector<std::pair<GrvProxyInterface, EventMap>> const& value) 
	{
		fdb_probe_actor_enter("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGrvProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*,std::vector<std::pair<GrvProxyInterface, EventMap>> && value) 
	{
		fdb_probe_actor_enter("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGrvProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*,Error err) 
	{
		fdb_probe_actor_enter("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetGrvProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2056 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 2056 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 11633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getGrvProxiesAndMetrics()
															#line 2056 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetGrvProxiesAndMetricsActor final : public Actor<std::vector<std::pair<GrvProxyInterface, EventMap>>>, public ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >, public FastAllocated<GetGrvProxiesAndMetricsActor>, public GetGrvProxiesAndMetricsActorState<GetGrvProxiesAndMetricsActor> {
															#line 11638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetGrvProxiesAndMetricsActor>::operator new;
	using FastAllocated<GetGrvProxiesAndMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12209008016215860992UL, 1744583410633730304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<GrvProxyInterface, EventMap>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >;
															#line 2056 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetGrvProxiesAndMetricsActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 11655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<std::vector<std::pair<GrvProxyInterface, EventMap>>>(),
		   GetGrvProxiesAndMetricsActorState<GetGrvProxiesAndMetricsActor>(db, address_workers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16916602236672483840UL, 15447554200206271744UL);
		ActorExecutionContextHelper __helper(static_cast<GetGrvProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getGrvProxiesAndMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2056 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<GrvProxyInterface, EventMap>>> getGrvProxiesAndMetrics( Reference<AsyncVar<ServerDBInfo>> const& db, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers ) {
															#line 2056 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<std::pair<GrvProxyInterface, EventMap>>>(new GetGrvProxiesAndMetricsActor(db, address_workers));
															#line 11688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 2065 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

// Returns the number of zones eligible for recruiting new tLogs after zone failures, to maintain the current
// replication factor.
static int getExtraTLogEligibleZones(const std::vector<WorkerDetails>& workers,
                                     const DatabaseConfiguration& configuration) {
	std::set<StringRef> allZones;
	std::map<Key, std::set<StringRef>> dcId_zone;
	for (auto const& worker : workers) {
		if (worker.processClass.machineClassFitness(ProcessClass::TLog) < ProcessClass::NeverAssign &&
		    !configuration.isExcludedServer(worker.interf.addresses(), worker.interf.locality)) {
			allZones.insert(worker.interf.locality.zoneId().get());
			if (worker.interf.locality.dcId().present()) {
				dcId_zone[worker.interf.locality.dcId().get()].insert(worker.interf.locality.zoneId().get());
			}
		}
	}

	if (configuration.regions.size() == 0) {
		return allZones.size() - std::max(configuration.tLogReplicationFactor, configuration.storageTeamSize);
	}

	int extraTlogEligibleZones = 0;
	int regionsWithNonNegativePriority = 0;
	int maxRequiredReplicationFactor =
	    std::max(configuration.remoteTLogReplicationFactor,
	             std::max(configuration.tLogReplicationFactor, configuration.storageTeamSize));
	for (const auto& region : configuration.regions) {
		if (region.priority >= 0) {
			int eligible = dcId_zone[region.dcId].size() - maxRequiredReplicationFactor;

			// FIXME: does not take into account fallback satellite policies
			if (region.satelliteTLogReplicationFactor > 0 && configuration.usableRegions > 1) {
				int totalSatelliteEligible = 0;
				for (const auto& sat : region.satellites) {
					totalSatelliteEligible += dcId_zone[sat.dcId].size();
				}
				eligible = std::min<int>(eligible, totalSatelliteEligible - region.satelliteTLogReplicationFactor);
			}
			if (eligible >= 0) {
				regionsWithNonNegativePriority++;
			}
			extraTlogEligibleZones = std::max(extraTlogEligibleZones, eligible);
		}
	}
	if (regionsWithNonNegativePriority > 1) {
		// If the database is replicated across multiple regions, we can afford to lose one entire region without
		// losing data.
		extraTlogEligibleZones++;
	}
	return extraTlogEligibleZones;
}

JsonBuilderObject getPerfLimit(TraceEventFields const& ratekeeper, double transPerSec, double tpsLimit) {
	int reason = ratekeeper.getInt("Reason");
	JsonBuilderObject perfLimit;

	if (transPerSec > tpsLimit * 0.8) {
		// If reason is known, set qos.performance_limited_by, otherwise omit
		if (reason >= 0 && reason < limitReasonEnd) {
			perfLimit = JsonString::makeMessage(limitReasonName[reason], limitReasonDesc[reason]);
			std::string reason_server_id = ratekeeper.getValue("ReasonServerID");
			if (!reason_server_id.empty())
				perfLimit["reason_server_id"] = reason_server_id;
		}
	} else {
		perfLimit = JsonString::makeMessage("workload", "The database is not being saturated by the workload.");
	}

	if (!perfLimit.empty()) {
		perfLimit["reason_id"] = reason;
	}

	return perfLimit;
}

															#line 11767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via workloadStatusFetcher()
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class WorkloadStatusFetcherActor>
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class WorkloadStatusFetcherActorState {
															#line 11774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkloadStatusFetcherActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::vector<WorkerDetails> const& workers,WorkerDetails const& mWorker,WorkerDetails const& rkWorker,JsonBuilderObject* const& qos,JsonBuilderObject* const& data_overlay,JsonBuilderObject* const& tenants,std::set<std::string>* const& incomplete_reasons,Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture) 
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   workers(workers),
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   mWorker(mWorker),
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   rkWorker(rkWorker),
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   qos(qos),
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   data_overlay(data_overlay),
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   tenants(tenants),
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   storageServerFuture(storageServerFuture),
															#line 2150 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj(),
															#line 2151 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   operationsObj(),
															#line 2152 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   bytesObj(),
															#line 2153 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   keysObj()
															#line 11805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("workloadStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~WorkloadStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("workloadStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2157 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				commitProxyStatFutures = std::vector<Future<TraceEventFields>>();
															#line 2158 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				grvProxyStatFutures = std::vector<Future<TraceEventFields>>();
															#line 2159 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				std::map<NetworkAddress, WorkerDetails> workersMap;
															#line 2160 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				for( auto const& w : workers ) {
															#line 2161 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					workersMap[w.interf.address()] = w;
															#line 11829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
															#line 2163 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				for( auto& p : db->get().client.commitProxies ) {
															#line 2164 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					auto worker = getWorker(workersMap, p.address());
															#line 2165 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					if (worker.present())
															#line 11837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					{
															#line 2166 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						commitProxyStatFutures.push_back(timeoutError( worker.get().interf.eventLogRequest.getReply(EventLogRequest("ProxyMetrics"_sr)), 1.0));
															#line 11841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					}
					else
					{
															#line 2169 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						return a_body1Catch2(all_alternatives_failed(), loopDepth);
															#line 11847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					}
				}
															#line 2171 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				for( auto& p : db->get().client.grvProxies ) {
															#line 2172 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					auto worker = getWorker(workersMap, p.address());
															#line 2173 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					if (worker.present())
															#line 11856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					{
															#line 2174 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						grvProxyStatFutures.push_back(timeoutError( worker.get().interf.eventLogRequest.getReply(EventLogRequest("GrvProxyMetrics"_sr)), 1.0));
															#line 11860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					}
					else
					{
															#line 2177 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
						return a_body1Catch2(all_alternatives_failed(), loopDepth);
															#line 11866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					}
				}
															#line 2179 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<std::vector<TraceEventFields>> __when_expr_0 = getAll(commitProxyStatFutures);
															#line 2179 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 11873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 2179 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*>(static_cast<WorkloadStatusFetcherActor*>(this)));
															#line 11878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkloadStatusFetcherActorState();
		static_cast<WorkloadStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 2241 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			f1 = timeoutError(rkWorker.interf.eventLogRequest.getReply(EventLogRequest("RkUpdate"_sr)), 1.0);
															#line 2243 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			f2 = timeoutError(rkWorker.interf.eventLogRequest.getReply(EventLogRequest("RkUpdateBatch"_sr)), 1.0);
															#line 2245 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(f1) && success(f2);
															#line 2245 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 11914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 2245 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkloadStatusFetcherActor, 2, Void >*>(static_cast<WorkloadStatusFetcherActor*>(this)));
															#line 11919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2234 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 11935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2235 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 11939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 2236 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Unknown mutations, conflicts, and transactions state.");
															#line 11943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2180 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<std::vector<TraceEventFields>> __when_expr_1 = getAll(grvProxyStatFutures);
															#line 2180 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 11960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2180 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*>(static_cast<WorkloadStatusFetcherActor*>(this)));
															#line 11965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<TraceEventFields> const& __commitProxyStats,int loopDepth) 
	{
															#line 2179 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		commitProxyStats = __commitProxyStats;
															#line 11974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<TraceEventFields> && __commitProxyStats,int loopDepth) 
	{
		commitProxyStats = std::move(__commitProxyStats);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadStatusFetcherActor*>(this)->ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 2182 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnStartOut;
															#line 2183 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnSystemPriorityStartOut;
															#line 2184 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnDefaultPriorityStartOut;
															#line 2185 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnBatchPriorityStartOut;
															#line 2187 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter mutations;
															#line 2188 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter mutationBytes;
															#line 2189 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnConflicts;
															#line 2190 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnRejectedForQueuedTooLong;
															#line 2191 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnCommitOutSuccess;
															#line 2192 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnKeyLocationOut;
															#line 2193 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnMemoryErrors;
															#line 2195 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& gps : grvProxyStats ) {
															#line 2196 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			txnStartOut.updateValues(StatusCounter(gps.getValue("TxnStartOut")));
															#line 2197 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			txnSystemPriorityStartOut.updateValues(StatusCounter(gps.getValue("TxnSystemPriorityStartOut")));
															#line 2198 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			txnDefaultPriorityStartOut.updateValues(StatusCounter(gps.getValue("TxnDefaultPriorityStartOut")));
															#line 2199 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			txnBatchPriorityStartOut.updateValues(StatusCounter(gps.getValue("TxnBatchPriorityStartOut")));
															#line 2200 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			txnMemoryErrors.updateValues(StatusCounter(gps.getValue("TxnRequestErrors")));
															#line 12085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& cps : commitProxyStats ) {
															#line 2204 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			mutations.updateValues(StatusCounter(cps.getValue("Mutations")));
															#line 2205 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			mutationBytes.updateValues(StatusCounter(cps.getValue("MutationBytes")));
															#line 2206 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			txnConflicts.updateValues(StatusCounter(cps.getValue("TxnConflicts")));
															#line 2207 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			txnRejectedForQueuedTooLong.updateValues(StatusCounter(cps.getValue("TxnRejectedForQueuedTooLong")));
															#line 2208 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			txnCommitOutSuccess.updateValues(StatusCounter(cps.getValue("TxnCommitOutSuccess")));
															#line 2209 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			txnKeyLocationOut.updateValues(StatusCounter(cps.getValue("KeyServerLocationOut")));
															#line 2210 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			txnMemoryErrors.updateValues(StatusCounter(cps.getValue("KeyServerLocationErrors")));
															#line 2211 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			txnMemoryErrors.updateValues(StatusCounter(cps.getValue("TxnCommitErrors")));
															#line 12105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2214 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["writes"] = mutations.getStatus();
															#line 2215 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["location_requests"] = txnKeyLocationOut.getStatus();
															#line 2216 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["memory_errors"] = txnMemoryErrors.getStatus();
															#line 2217 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		bytesObj["written"] = mutationBytes.getStatus();
															#line 2219 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject transactions;
															#line 2220 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		transactions["conflicted"] = txnConflicts.getStatus();
															#line 2221 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		transactions["started"] = txnStartOut.getStatus();
															#line 2222 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		transactions["rejected_for_queued_too_long"] = txnRejectedForQueuedTooLong.getStatus();
															#line 2223 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		transactions["started_immediate_priority"] = txnSystemPriorityStartOut.getStatus();
															#line 2224 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		transactions["started_default_priority"] = txnDefaultPriorityStartOut.getStatus();
															#line 2225 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		transactions["started_batch_priority"] = txnBatchPriorityStartOut.getStatus();
															#line 2226 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		transactions["committed"] = txnCommitOutSuccess.getStatus();
															#line 2228 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["transactions"] = transactions;
															#line 2230 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (commitProxyStats.size() > 0)
															#line 12135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2231 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*tenants)["num_tenants"] = commitProxyStats[0].getUint64("NumTenants");
															#line 12139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont10cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<TraceEventFields> const& __grvProxyStats,int loopDepth) 
	{
															#line 2180 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		grvProxyStats = __grvProxyStats;
															#line 12149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<TraceEventFields> && __grvProxyStats,int loopDepth) 
	{
		grvProxyStats = std::move(__grvProxyStats);
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadStatusFetcherActor*>(this)->ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		try {
															#line 2326 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<ErrorOr<std::vector<StorageServerStatusInfo>>> __when_expr_3 = storageServerFuture;
															#line 2326 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1cont11Catch1(actor_cancelled(), loopDepth);
															#line 12244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont11Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont11when1(__when_expr_3.get(), loopDepth); };
			static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2326 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*>(static_cast<WorkloadStatusFetcherActor*>(this)));
															#line 12249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2319 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 12265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2320 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 12269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 2321 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Unknown performance state.");
															#line 12273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 2246 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields ratekeeper = f1.get();
															#line 2247 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields batchRatekeeper = f2.get();
															#line 2249 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		bool autoThrottlingEnabled = ratekeeper.getInt("AutoThrottlingEnabled");
															#line 2250 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double tpsLimit = ratekeeper.getDouble("TPSLimit");
															#line 2251 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double batchTpsLimit = batchRatekeeper.getDouble("TPSLimit");
															#line 2252 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double transPerSec = ratekeeper.getDouble("ReleasedTPS");
															#line 2253 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double batchTransPerSec = ratekeeper.getDouble("ReleasedBatchTPS");
															#line 2254 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTags = ratekeeper.getInt("TagsAutoThrottled");
															#line 2255 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTagsBusyRead = ratekeeper.getInt("TagsAutoThrottledBusyRead");
															#line 2256 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTagsBusyWrite = ratekeeper.getInt("TagsAutoThrottledBusyWrite");
															#line 2257 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int manualThrottledTags = ratekeeper.getInt("TagsManuallyThrottled");
															#line 2258 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int ssCount = ratekeeper.getInt("StorageServers");
															#line 2259 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int tlogCount = ratekeeper.getInt("TLogs");
															#line 2260 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int64_t worstFreeSpaceStorageServer = ratekeeper.getInt64("WorstFreeSpaceStorageServer");
															#line 2261 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int64_t worstFreeSpaceTLog = ratekeeper.getInt64("WorstFreeSpaceTLog");
															#line 2262 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		(*data_overlay).setKeyRawNumber("total_disk_used_bytes", ratekeeper.getValue("TotalDiskUsageBytes"));
															#line 2264 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (ssCount > 0)
															#line 12320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2265 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*data_overlay)["least_operating_space_bytes_storage_server"] = std::max(worstFreeSpaceStorageServer, (int64_t)0);
															#line 2267 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("worst_queue_bytes_storage_server", ratekeeper.getValue("WorstStorageServerQueue"));
															#line 2268 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("limiting_queue_bytes_storage_server", ratekeeper.getValue("LimitingStorageServerQueue"));
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["worst_data_lag_storage_server"] = getLagObject(ratekeeper.getInt64("WorstStorageServerVersionLag"));
															#line 2272 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["limiting_data_lag_storage_server"] = getLagObject(ratekeeper.getInt64("LimitingStorageServerVersionLag"));
															#line 2274 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["worst_durability_lag_storage_server"] = getLagObject(ratekeeper.getInt64("WorstStorageServerDurabilityLag"));
															#line 2276 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["limiting_durability_lag_storage_server"] = getLagObject(ratekeeper.getInt64("LimitingStorageServerDurabilityLag"));
															#line 12336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2280 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (tlogCount > 0)
															#line 12340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2281 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*data_overlay)["least_operating_space_bytes_log_server"] = std::max(worstFreeSpaceTLog, (int64_t)0);
															#line 2282 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("worst_queue_bytes_log_server", ratekeeper.getValue("WorstTLogQueue"));
															#line 12346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2285 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["transactions_per_second_limit"] = tpsLimit;
															#line 2286 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["batch_transactions_per_second_limit"] = batchTpsLimit;
															#line 2287 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["released_transactions_per_second"] = transPerSec;
															#line 2288 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["batch_released_transactions_per_second"] = batchTransPerSec;
															#line 2290 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject throttledTagsObj;
															#line 2291 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject autoThrottledTagsObj;
															#line 2292 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["count"] = autoThrottledTags;
															#line 2293 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["busy_read"] = autoThrottledTagsBusyRead;
															#line 2294 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["busy_write"] = autoThrottledTagsBusyWrite;
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (autoThrottlingEnabled)
															#line 12368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2296 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			autoThrottledTagsObj["recommended_only"] = 0;
															#line 12372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 2298 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			autoThrottledTagsObj["recommended_only"] = 1;
															#line 12378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2301 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		throttledTagsObj["auto"] = autoThrottledTagsObj;
															#line 2303 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject manualThrottledTagsObj;
															#line 2304 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		manualThrottledTagsObj["count"] = manualThrottledTags;
															#line 2305 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		throttledTagsObj["manual"] = manualThrottledTagsObj;
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["throttled_tags"] = throttledTagsObj;
															#line 2309 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject perfLimit = getPerfLimit(ratekeeper, transPerSec, tpsLimit);
															#line 2310 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!perfLimit.empty())
															#line 12394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2311 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["performance_limited_by"] = perfLimit;
															#line 12398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2314 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject batchPerfLimit = getPerfLimit(batchRatekeeper, transPerSec, batchTpsLimit);
															#line 2315 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!batchPerfLimit.empty())
															#line 12404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2316 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["batch_performance_limited_by"] = batchPerfLimit;
															#line 12408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 2246 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields ratekeeper = f1.get();
															#line 2247 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields batchRatekeeper = f2.get();
															#line 2249 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		bool autoThrottlingEnabled = ratekeeper.getInt("AutoThrottlingEnabled");
															#line 2250 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double tpsLimit = ratekeeper.getDouble("TPSLimit");
															#line 2251 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double batchTpsLimit = batchRatekeeper.getDouble("TPSLimit");
															#line 2252 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double transPerSec = ratekeeper.getDouble("ReleasedTPS");
															#line 2253 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double batchTransPerSec = ratekeeper.getDouble("ReleasedBatchTPS");
															#line 2254 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTags = ratekeeper.getInt("TagsAutoThrottled");
															#line 2255 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTagsBusyRead = ratekeeper.getInt("TagsAutoThrottledBusyRead");
															#line 2256 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTagsBusyWrite = ratekeeper.getInt("TagsAutoThrottledBusyWrite");
															#line 2257 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int manualThrottledTags = ratekeeper.getInt("TagsManuallyThrottled");
															#line 2258 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int ssCount = ratekeeper.getInt("StorageServers");
															#line 2259 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int tlogCount = ratekeeper.getInt("TLogs");
															#line 2260 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int64_t worstFreeSpaceStorageServer = ratekeeper.getInt64("WorstFreeSpaceStorageServer");
															#line 2261 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		int64_t worstFreeSpaceTLog = ratekeeper.getInt64("WorstFreeSpaceTLog");
															#line 2262 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		(*data_overlay).setKeyRawNumber("total_disk_used_bytes", ratekeeper.getValue("TotalDiskUsageBytes"));
															#line 2264 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (ssCount > 0)
															#line 12450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2265 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*data_overlay)["least_operating_space_bytes_storage_server"] = std::max(worstFreeSpaceStorageServer, (int64_t)0);
															#line 2267 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("worst_queue_bytes_storage_server", ratekeeper.getValue("WorstStorageServerQueue"));
															#line 2268 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("limiting_queue_bytes_storage_server", ratekeeper.getValue("LimitingStorageServerQueue"));
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["worst_data_lag_storage_server"] = getLagObject(ratekeeper.getInt64("WorstStorageServerVersionLag"));
															#line 2272 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["limiting_data_lag_storage_server"] = getLagObject(ratekeeper.getInt64("LimitingStorageServerVersionLag"));
															#line 2274 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["worst_durability_lag_storage_server"] = getLagObject(ratekeeper.getInt64("WorstStorageServerDurabilityLag"));
															#line 2276 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["limiting_durability_lag_storage_server"] = getLagObject(ratekeeper.getInt64("LimitingStorageServerDurabilityLag"));
															#line 12466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2280 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (tlogCount > 0)
															#line 12470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2281 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*data_overlay)["least_operating_space_bytes_log_server"] = std::max(worstFreeSpaceTLog, (int64_t)0);
															#line 2282 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("worst_queue_bytes_log_server", ratekeeper.getValue("WorstTLogQueue"));
															#line 12476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2285 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["transactions_per_second_limit"] = tpsLimit;
															#line 2286 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["batch_transactions_per_second_limit"] = batchTpsLimit;
															#line 2287 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["released_transactions_per_second"] = transPerSec;
															#line 2288 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["batch_released_transactions_per_second"] = batchTransPerSec;
															#line 2290 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject throttledTagsObj;
															#line 2291 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject autoThrottledTagsObj;
															#line 2292 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["count"] = autoThrottledTags;
															#line 2293 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["busy_read"] = autoThrottledTagsBusyRead;
															#line 2294 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["busy_write"] = autoThrottledTagsBusyWrite;
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (autoThrottlingEnabled)
															#line 12498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2296 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			autoThrottledTagsObj["recommended_only"] = 0;
															#line 12502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 2298 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			autoThrottledTagsObj["recommended_only"] = 1;
															#line 12508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2301 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		throttledTagsObj["auto"] = autoThrottledTagsObj;
															#line 2303 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject manualThrottledTagsObj;
															#line 2304 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		manualThrottledTagsObj["count"] = manualThrottledTags;
															#line 2305 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		throttledTagsObj["manual"] = manualThrottledTagsObj;
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["throttled_tags"] = throttledTagsObj;
															#line 2309 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject perfLimit = getPerfLimit(ratekeeper, transPerSec, tpsLimit);
															#line 2310 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!perfLimit.empty())
															#line 12524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2311 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["performance_limited_by"] = perfLimit;
															#line 12528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2314 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject batchPerfLimit = getPerfLimit(batchRatekeeper, transPerSec, batchTpsLimit);
															#line 2315 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!batchPerfLimit.empty())
															#line 12534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2316 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["batch_performance_limited_by"] = batchPerfLimit;
															#line 12538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadStatusFetcherActor*>(this)->ActorCallback< WorkloadStatusFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WorkloadStatusFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1(int loopDepth) 
	{
															#line 2360 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["operations"] = operationsObj;
															#line 2361 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["keys"] = keysObj;
															#line 2362 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["bytes"] = bytesObj;
															#line 2364 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<WorkloadStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~WorkloadStatusFetcherActorState(); static_cast<WorkloadStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 12642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<WorkloadStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~WorkloadStatusFetcherActorState();
		static_cast<WorkloadStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2355 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 12655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2356 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 12659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 2357 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Unknown read state.");
															#line 12663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont2(ErrorOr<std::vector<StorageServerStatusInfo>> const& storageServers,int loopDepth) 
	{
															#line 2327 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!storageServers.present())
															#line 12678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2328 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1cont11Catch1(storageServers.getError(), loopDepth);
															#line 12682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2331 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readRequests;
															#line 2332 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter reads;
															#line 2333 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readKeys;
															#line 2334 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readBytes;
															#line 2335 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter lowPriorityReads;
															#line 2337 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& ss : storageServers.get() ) {
															#line 2338 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			TraceEventFields const& storageMetrics = ss.eventMap.at("StorageMetrics");
															#line 2340 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (storageMetrics.size() > 0)
															#line 12700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2341 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				readRequests.updateValues(StatusCounter(storageMetrics.getValue("QueryQueue")));
															#line 2342 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				reads.updateValues(StatusCounter(storageMetrics.getValue("FinishedQueries")));
															#line 2343 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				readKeys.updateValues(StatusCounter(storageMetrics.getValue("RowsQueried")));
															#line 2344 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				readBytes.updateValues(StatusCounter(storageMetrics.getValue("BytesQueried")));
															#line 2345 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				lowPriorityReads.updateValues(StatusCounter(storageMetrics.getValue("LowPriorityQueries")));
															#line 12712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2349 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["read_requests"] = readRequests.getStatus();
															#line 2350 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["reads"] = reads.getStatus();
															#line 2351 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		keysObj["read"] = readKeys.getStatus();
															#line 2352 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		bytesObj["read"] = readBytes.getStatus();
															#line 2353 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["low_priority_reads"] = lowPriorityReads.getStatus();
															#line 12725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont11cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2(ErrorOr<std::vector<StorageServerStatusInfo>> && storageServers,int loopDepth) 
	{
															#line 2327 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!storageServers.present())
															#line 12734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2328 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1cont11Catch1(storageServers.getError(), loopDepth);
															#line 12738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2331 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readRequests;
															#line 2332 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter reads;
															#line 2333 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readKeys;
															#line 2334 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readBytes;
															#line 2335 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter lowPriorityReads;
															#line 2337 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& ss : storageServers.get() ) {
															#line 2338 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			TraceEventFields const& storageMetrics = ss.eventMap.at("StorageMetrics");
															#line 2340 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (storageMetrics.size() > 0)
															#line 12756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2341 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				readRequests.updateValues(StatusCounter(storageMetrics.getValue("QueryQueue")));
															#line 2342 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				reads.updateValues(StatusCounter(storageMetrics.getValue("FinishedQueries")));
															#line 2343 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				readKeys.updateValues(StatusCounter(storageMetrics.getValue("RowsQueried")));
															#line 2344 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				readBytes.updateValues(StatusCounter(storageMetrics.getValue("BytesQueried")));
															#line 2345 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				lowPriorityReads.updateValues(StatusCounter(storageMetrics.getValue("LowPriorityQueries")));
															#line 12768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2349 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["read_requests"] = readRequests.getStatus();
															#line 2350 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["reads"] = reads.getStatus();
															#line 2351 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		keysObj["read"] = readKeys.getStatus();
															#line 2352 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		bytesObj["read"] = readBytes.getStatus();
															#line 2353 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["low_priority_reads"] = lowPriorityReads.getStatus();
															#line 12781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont11cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(ErrorOr<std::vector<StorageServerStatusInfo>> const& storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(storageServers, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(ErrorOr<std::vector<StorageServerStatusInfo>> && storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(storageServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadStatusFetcherActor*>(this)->ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*,ErrorOr<std::vector<StorageServerStatusInfo>> const& value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*,ErrorOr<std::vector<StorageServerStatusInfo>> && value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*,Error err) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails mWorker;
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails rkWorker;
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject* qos;
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject* data_overlay;
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject* tenants;
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<ErrorOr<std::vector<StorageServerStatusInfo>>> storageServerFuture;
															#line 2150 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 2151 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject operationsObj;
															#line 2152 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject bytesObj;
															#line 2153 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject keysObj;
															#line 2157 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<TraceEventFields>> commitProxyStatFutures;
															#line 2158 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<TraceEventFields>> grvProxyStatFutures;
															#line 2179 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<TraceEventFields> commitProxyStats;
															#line 2180 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<TraceEventFields> grvProxyStats;
															#line 2241 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> f1;
															#line 2243 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> f2;
															#line 12912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via workloadStatusFetcher()
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class WorkloadStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >, public ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >, public ActorCallback< WorkloadStatusFetcherActor, 2, Void >, public ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >, public FastAllocated<WorkloadStatusFetcherActor>, public WorkloadStatusFetcherActorState<WorkloadStatusFetcherActor> {
															#line 12917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<WorkloadStatusFetcherActor>::operator new;
	using FastAllocated<WorkloadStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6433004001048361984UL, 7970343340191601152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >;
friend struct ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >;
friend struct ActorCallback< WorkloadStatusFetcherActor, 2, Void >;
friend struct ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >;
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkloadStatusFetcherActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::vector<WorkerDetails> const& workers,WorkerDetails const& mWorker,WorkerDetails const& rkWorker,JsonBuilderObject* const& qos,JsonBuilderObject* const& data_overlay,JsonBuilderObject* const& tenants,std::set<std::string>* const& incomplete_reasons,Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture) 
															#line 12937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   WorkloadStatusFetcherActorState<WorkloadStatusFetcherActor>(db, workers, mWorker, rkWorker, qos, data_overlay, tenants, incomplete_reasons, storageServerFuture),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1285460558980581376UL, 3509738831502872832UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workloadStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WorkloadStatusFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> workloadStatusFetcher( Reference<AsyncVar<ServerDBInfo>> const& db, std::vector<WorkerDetails> const& workers, WorkerDetails const& mWorker, WorkerDetails const& rkWorker, JsonBuilderObject* const& qos, JsonBuilderObject* const& data_overlay, JsonBuilderObject* const& tenants, std::set<std::string>* const& incomplete_reasons, Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture ) {
															#line 2140 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new WorkloadStatusFetcherActor(db, workers, mWorker, rkWorker, qos, data_overlay, tenants, incomplete_reasons, storageServerFuture));
															#line 12973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 2366 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 12978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterSummaryStatisticsFetcher()
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class ClusterSummaryStatisticsFetcherActor>
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class ClusterSummaryStatisticsFetcherActorState {
															#line 12985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	ClusterSummaryStatisticsFetcherActorState(WorkerEvents const& pMetrics,Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture,Future<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> const& tlogFuture,std::set<std::string>* const& incomplete_reasons) 
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : pMetrics(pMetrics),
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   storageServerFuture(storageServerFuture),
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   tlogFuture(tlogFuture),
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 2372 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj()
															#line 13000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this));

	}
	~ClusterSummaryStatisticsFetcherActorState() 
	{
		fdb_probe_actor_destroy("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2374 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				cacheStatistics = JsonBuilderObject();
															#line 2376 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<ErrorOr<std::vector<StorageServerStatusInfo>>> __when_expr_0 = storageServerFuture;
															#line 2376 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 1;
															#line 2376 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*>(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)));
															#line 13025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterSummaryStatisticsFetcherActorState();
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2429 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~ClusterSummaryStatisticsFetcherActorState(); static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->destroy(); return 0; }
															#line 13054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~ClusterSummaryStatisticsFetcherActorState();
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2423 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 13067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2424 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 13071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 2426 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Unknown cache statistics.");
															#line 13075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(ErrorOr<std::vector<StorageServerStatusInfo>> const& storageServers,int loopDepth) 
	{
															#line 2378 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!storageServers.present())
															#line 13090 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2379 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(storageServers.getError(), loopDepth);
															#line 13094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2382 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double storageCacheHitsHz = 0;
															#line 2383 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double storageCacheMissesHz = 0;
															#line 2385 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& ss : storageServers.get() ) {
															#line 2386 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto processMetrics = pMetrics.find(ss.address());
															#line 2387 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics != pMetrics.end())
															#line 13106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2388 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				int64_t hits = processMetrics->second.getInt64("CacheHits");
															#line 2389 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				int64_t misses = processMetrics->second.getInt64("CacheMisses");
															#line 2390 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double elapsed = processMetrics->second.getDouble("Elapsed");
															#line 2391 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				storageCacheHitsHz += hits / elapsed;
															#line 2392 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				storageCacheMissesHz += misses / elapsed;
															#line 13118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2396 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		cacheStatistics["storage_hit_rate"] = (storageCacheMissesHz == 0) ? 1.0 : storageCacheHitsHz / (storageCacheHitsHz + storageCacheMissesHz);
															#line 2399 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> __when_expr_1 = tlogFuture;
															#line 2399 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 2;
															#line 2399 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*>(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)));
															#line 13132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(ErrorOr<std::vector<StorageServerStatusInfo>> && storageServers,int loopDepth) 
	{
															#line 2378 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!storageServers.present())
															#line 13141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2379 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(storageServers.getError(), loopDepth);
															#line 13145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2382 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double storageCacheHitsHz = 0;
															#line 2383 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double storageCacheMissesHz = 0;
															#line 2385 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& ss : storageServers.get() ) {
															#line 2386 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto processMetrics = pMetrics.find(ss.address());
															#line 2387 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics != pMetrics.end())
															#line 13157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2388 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				int64_t hits = processMetrics->second.getInt64("CacheHits");
															#line 2389 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				int64_t misses = processMetrics->second.getInt64("CacheMisses");
															#line 2390 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double elapsed = processMetrics->second.getDouble("Elapsed");
															#line 2391 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				storageCacheHitsHz += hits / elapsed;
															#line 2392 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				storageCacheMissesHz += misses / elapsed;
															#line 13169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2396 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		cacheStatistics["storage_hit_rate"] = (storageCacheMissesHz == 0) ? 1.0 : storageCacheHitsHz / (storageCacheHitsHz + storageCacheMissesHz);
															#line 2399 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> __when_expr_1 = tlogFuture;
															#line 2399 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 2;
															#line 2399 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*>(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)));
															#line 13183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<std::vector<StorageServerStatusInfo>> const& storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont2(storageServers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<std::vector<StorageServerStatusInfo>> && storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(storageServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state > 0) static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*,ErrorOr<std::vector<StorageServerStatusInfo>> const& value) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*,ErrorOr<std::vector<StorageServerStatusInfo>> && value) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*,Error err) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> const& tlogServers,int loopDepth) 
	{
															#line 2401 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!tlogServers.present())
															#line 13267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2402 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(tlogServers.getError(), loopDepth);
															#line 13271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2405 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double logCacheHitsHz = 0;
															#line 2406 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double logCacheMissesHz = 0;
															#line 2408 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& log : tlogServers.get() ) {
															#line 2409 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto processMetrics = pMetrics.find(log.first.address());
															#line 2410 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics != pMetrics.end())
															#line 13283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2411 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				int64_t hits = processMetrics->second.getInt64("CacheHits");
															#line 2412 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				int64_t misses = processMetrics->second.getInt64("CacheMisses");
															#line 2413 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double elapsed = processMetrics->second.getDouble("Elapsed");
															#line 2414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				logCacheHitsHz += hits / elapsed;
															#line 2415 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				logCacheMissesHz += misses / elapsed;
															#line 13295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2419 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		cacheStatistics["log_hit_rate"] = (logCacheMissesHz == 0) ? 1.0 : logCacheHitsHz / (logCacheHitsHz + logCacheMissesHz);
															#line 2421 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["page_cache"] = cacheStatistics;
															#line 13302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> && tlogServers,int loopDepth) 
	{
															#line 2401 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!tlogServers.present())
															#line 13311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2402 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(tlogServers.getError(), loopDepth);
															#line 13315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2405 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double logCacheHitsHz = 0;
															#line 2406 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		double logCacheMissesHz = 0;
															#line 2408 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& log : tlogServers.get() ) {
															#line 2409 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto processMetrics = pMetrics.find(log.first.address());
															#line 2410 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics != pMetrics.end())
															#line 13327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2411 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				int64_t hits = processMetrics->second.getInt64("CacheHits");
															#line 2412 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				int64_t misses = processMetrics->second.getInt64("CacheMisses");
															#line 2413 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				double elapsed = processMetrics->second.getDouble("Elapsed");
															#line 2414 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				logCacheHitsHz += hits / elapsed;
															#line 2415 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				logCacheMissesHz += misses / elapsed;
															#line 13339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2419 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		cacheStatistics["log_hit_rate"] = (logCacheMissesHz == 0) ? 1.0 : logCacheHitsHz / (logCacheHitsHz + logCacheMissesHz);
															#line 2421 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["page_cache"] = cacheStatistics;
															#line 13346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> const& tlogServers,int loopDepth) 
	{
		loopDepth = a_body1cont3(tlogServers, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> && tlogServers,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(tlogServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state > 0) static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*,ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> const& value) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*,ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> && value) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*,Error err) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents pMetrics;
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<ErrorOr<std::vector<StorageServerStatusInfo>>> storageServerFuture;
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> tlogFuture;
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 2372 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 2374 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject cacheStatistics;
															#line 13451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via clusterSummaryStatisticsFetcher()
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class ClusterSummaryStatisticsFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >, public ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >, public FastAllocated<ClusterSummaryStatisticsFetcherActor>, public ClusterSummaryStatisticsFetcherActorState<ClusterSummaryStatisticsFetcherActor> {
															#line 13456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<ClusterSummaryStatisticsFetcherActor>::operator new;
	using FastAllocated<ClusterSummaryStatisticsFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10025855001297304320UL, 5378773805158708480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >;
friend struct ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >;
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	ClusterSummaryStatisticsFetcherActor(WorkerEvents const& pMetrics,Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture,Future<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> const& tlogFuture,std::set<std::string>* const& incomplete_reasons) 
															#line 13474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   ClusterSummaryStatisticsFetcherActorState<ClusterSummaryStatisticsFetcherActor>(pMetrics, storageServerFuture, tlogFuture, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10444091789670181888UL, 658604576535158016UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterSummaryStatisticsFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> clusterSummaryStatisticsFetcher( WorkerEvents const& pMetrics, Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture, Future<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> const& tlogFuture, std::set<std::string>* const& incomplete_reasons ) {
															#line 2367 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new ClusterSummaryStatisticsFetcherActor(pMetrics, storageServerFuture, tlogFuture, incomplete_reasons));
															#line 13508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 2431 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 13513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via blobGranulesStatusFetcher()
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class BlobGranulesStatusFetcherActor>
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class BlobGranulesStatusFetcherActorState {
															#line 13520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	BlobGranulesStatusFetcherActorState(Database const& cx,Optional<BlobManagerInterface> const& managerIntf,std::vector<BlobWorkerInterface> const& workers,std::unordered_map<NetworkAddress, WorkerInterface> const& addressWorkersMap,std::set<std::string>* const& incompleteReason) 
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   managerIntf(managerIntf),
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   workers(workers),
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   addressWorkersMap(addressWorkersMap),
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   incompleteReason(incompleteReason),
															#line 2439 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj(),
															#line 2440 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   futures()
															#line 13539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~BlobGranulesStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2442 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["number_of_blob_workers"] = static_cast<int>(workers.size());
															#line 13554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			try {
															#line 2444 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				config = BlobGranuleBackupConfig();
															#line 2445 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<bool> __when_expr_0 = config.enabled().getD(SystemDBWriteLockedNow(cx.getReference()));
															#line 2445 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 2445 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >*>(static_cast<BlobGranulesStatusFetcherActor*>(this)));
															#line 13567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobGranulesStatusFetcherActorState();
		static_cast<BlobGranulesStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2501 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<BlobGranulesStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~BlobGranulesStatusFetcherActorState(); static_cast<BlobGranulesStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 13596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<BlobGranulesStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~BlobGranulesStatusFetcherActorState();
		static_cast<BlobGranulesStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2497 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 13609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2498 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 13613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 2499 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incompleteReason->insert("Unknown blob worker stats");
															#line 13617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(bool const& backupEnabled,int loopDepth) 
	{
															#line 2446 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_granules_backup_enabled"] = backupEnabled;
															#line 2447 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (backupEnabled)
															#line 13634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2448 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::string> __when_expr_1 = config.manifestUrl().getD(SystemDBWriteLockedNow(cx.getReference()));
															#line 2448 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2448 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >*>(static_cast<BlobGranulesStatusFetcherActor*>(this)));
															#line 13645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(bool && backupEnabled,int loopDepth) 
	{
															#line 2446 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_granules_backup_enabled"] = backupEnabled;
															#line 2447 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (backupEnabled)
															#line 13661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2448 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::string> __when_expr_1 = config.manifestUrl().getD(SystemDBWriteLockedNow(cx.getReference()));
															#line 2448 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2448 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >*>(static_cast<BlobGranulesStatusFetcherActor*>(this)));
															#line 13672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(bool const& backupEnabled,int loopDepth) 
	{
		loopDepth = a_body1cont2(backupEnabled, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && backupEnabled,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(backupEnabled), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranulesStatusFetcherActor*>(this)->ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 2454 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (managerIntf.present())
															#line 13761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2455 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Optional<TraceEventFields>> __when_expr_3 = timeoutError( latestEventOnWorker(addressWorkersMap[managerIntf.get().address()], "BlobManagerMetrics"), 2.0);
															#line 2455 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2455 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >*>(static_cast<BlobGranulesStatusFetcherActor*>(this)));
															#line 13772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(std::string const& manifestUrl,int loopDepth) 
	{
															#line 2449 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_granules_manifest_url"] = manifestUrl;
															#line 2450 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = config.mutationLogsUrl().getD(SystemDBWriteLockedNow(cx.getReference()));
															#line 2450 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 2450 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >*>(static_cast<BlobGranulesStatusFetcherActor*>(this)));
															#line 13795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(std::string && manifestUrl,int loopDepth) 
	{
															#line 2449 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_granules_manifest_url"] = manifestUrl;
															#line 2450 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = config.mutationLogsUrl().getD(SystemDBWriteLockedNow(cx.getReference()));
															#line 2450 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 2450 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >*>(static_cast<BlobGranulesStatusFetcherActor*>(this)));
															#line 13813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::string const& manifestUrl,int loopDepth) 
	{
		loopDepth = a_body1cont4(manifestUrl, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::string && manifestUrl,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(manifestUrl), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranulesStatusFetcherActor*>(this)->ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(std::string const& mlogsUrl,int loopDepth) 
	{
															#line 2451 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_granules_mlogs_url"] = mlogsUrl;
															#line 13897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(std::string && mlogsUrl,int loopDepth) 
	{
															#line 2451 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_granules_mlogs_url"] = mlogsUrl;
															#line 13906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(std::string const& mlogsUrl,int loopDepth) 
	{
		loopDepth = a_body1cont5(mlogsUrl, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(std::string && mlogsUrl,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(mlogsUrl), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranulesStatusFetcherActor*>(this)->ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 2468 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& intf : workers ) {
															#line 2469 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto workerIntf = addressWorkersMap[intf.address()];
															#line 2470 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			futures.push_back(latestEventOnWorker(workerIntf, "BlobWorkerMetrics"));
															#line 13994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2473 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_4 = timeoutError(waitForAll(futures), 2.0);
															#line 2473 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 14000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 5;
															#line 2473 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >*>(static_cast<BlobGranulesStatusFetcherActor*>(this)));
															#line 14005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Optional<TraceEventFields> const& fields,int loopDepth) 
	{
															#line 2457 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (fields.present())
															#line 14014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2458 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_flush_version"] = fields.get().getUint64("LastFlushVersion");
															#line 2459 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_dump_ts"] = fields.get().getUint64("LastManifestDumpTs");
															#line 2460 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_seq_no"] = fields.get().getUint64("LastManifestSeqNo");
															#line 2461 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_epoch"] = fields.get().getUint64("Epoch");
															#line 2462 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_size_in_bytes"] = fields.get().getUint64("ManifestSizeInBytes");
															#line 2463 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_truncation_version"] = fields.get().getUint64("LastMLogTruncationVersion");
															#line 14028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Optional<TraceEventFields> && fields,int loopDepth) 
	{
															#line 2457 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (fields.present())
															#line 14038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2458 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_flush_version"] = fields.get().getUint64("LastFlushVersion");
															#line 2459 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_dump_ts"] = fields.get().getUint64("LastManifestDumpTs");
															#line 2460 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_seq_no"] = fields.get().getUint64("LastManifestSeqNo");
															#line 2461 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_epoch"] = fields.get().getUint64("Epoch");
															#line 2462 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_size_in_bytes"] = fields.get().getUint64("ManifestSizeInBytes");
															#line 2463 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_truncation_version"] = fields.get().getUint64("LastMLogTruncationVersion");
															#line 14052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<TraceEventFields> const& fields,int loopDepth) 
	{
		loopDepth = a_body1cont8(fields, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<TraceEventFields> && fields,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(fields), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranulesStatusFetcherActor*>(this)->ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >*,Optional<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >*,Optional<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 2475 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		totalRanges = 0;
															#line 2476 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto future : futures ) {
															#line 2477 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (future.get().present())
															#line 14141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2478 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				auto latestTrace = future.get().get();
															#line 2479 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				int numRanges = latestTrace.getInt("NumRangesAssigned");
															#line 2480 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				totalRanges += numRanges;
															#line 2482 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject workerStatusObj;
															#line 2483 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["number_of_key_ranges"] = numRanges;
															#line 2484 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["put_requests"] = StatusCounter(latestTrace.getValue("S3PutReqs")).getStatus();
															#line 2485 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["get_requests"] = StatusCounter(latestTrace.getValue("S3GetReqs")).getStatus();
															#line 2486 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["delete_requests"] = StatusCounter(latestTrace.getValue("S3DeleteReqs")).getStatus();
															#line 2487 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["bytes_buffered"] = latestTrace.getInt64("MutationBytesBuffered");
															#line 2488 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["compression_bytes_raw"] = StatusCounter(latestTrace.getValue("CompressionBytesRaw")).getStatus();
															#line 2490 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["compression_bytes_final"] = StatusCounter(latestTrace.getValue("CompressionBytesFinal")).getStatus();
															#line 2492 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj[latestTrace.getValue("ID")] = workerStatusObj;
															#line 14167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2495 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["number_of_key_ranges"] = totalRanges;
															#line 14172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 2475 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		totalRanges = 0;
															#line 2476 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto future : futures ) {
															#line 2477 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (future.get().present())
															#line 14185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2478 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				auto latestTrace = future.get().get();
															#line 2479 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				int numRanges = latestTrace.getInt("NumRangesAssigned");
															#line 2480 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				totalRanges += numRanges;
															#line 2482 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject workerStatusObj;
															#line 2483 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["number_of_key_ranges"] = numRanges;
															#line 2484 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["put_requests"] = StatusCounter(latestTrace.getValue("S3PutReqs")).getStatus();
															#line 2485 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["get_requests"] = StatusCounter(latestTrace.getValue("S3GetReqs")).getStatus();
															#line 2486 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["delete_requests"] = StatusCounter(latestTrace.getValue("S3DeleteReqs")).getStatus();
															#line 2487 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["bytes_buffered"] = latestTrace.getInt64("MutationBytesBuffered");
															#line 2488 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["compression_bytes_raw"] = StatusCounter(latestTrace.getValue("CompressionBytesRaw")).getStatus();
															#line 2490 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["compression_bytes_final"] = StatusCounter(latestTrace.getValue("CompressionBytesFinal")).getStatus();
															#line 2492 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj[latestTrace.getValue("ID")] = workerStatusObj;
															#line 14211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2495 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["number_of_key_ranges"] = totalRanges;
															#line 14216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranulesStatusFetcherActor*>(this)->ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Optional<BlobManagerInterface> managerIntf;
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<BlobWorkerInterface> workers;
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> addressWorkersMap;
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incompleteReason;
															#line 2439 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 2440 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<Optional<TraceEventFields>>> futures;
															#line 2444 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	BlobGranuleBackupConfig config;
															#line 2475 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	int totalRanges;
															#line 14327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via blobGranulesStatusFetcher()
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class BlobGranulesStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >, public ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >, public ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >, public ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >, public ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >, public FastAllocated<BlobGranulesStatusFetcherActor>, public BlobGranulesStatusFetcherActorState<BlobGranulesStatusFetcherActor> {
															#line 14332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<BlobGranulesStatusFetcherActor>::operator new;
	using FastAllocated<BlobGranulesStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6742085306492282624UL, 10039206883407723776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >;
friend struct ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >;
friend struct ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >;
friend struct ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >;
friend struct ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >;
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	BlobGranulesStatusFetcherActor(Database const& cx,Optional<BlobManagerInterface> const& managerIntf,std::vector<BlobWorkerInterface> const& workers,std::unordered_map<NetworkAddress, WorkerInterface> const& addressWorkersMap,std::set<std::string>* const& incompleteReason) 
															#line 14353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   BlobGranulesStatusFetcherActorState<BlobGranulesStatusFetcherActor>(cx, managerIntf, workers, addressWorkersMap, incompleteReason),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13293766905701207552UL, 14914104356464938496UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("blobGranulesStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> blobGranulesStatusFetcher( Database const& cx, Optional<BlobManagerInterface> const& managerIntf, std::vector<BlobWorkerInterface> const& workers, std::unordered_map<NetworkAddress, WorkerInterface> const& addressWorkersMap, std::set<std::string>* const& incompleteReason ) {
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new BlobGranulesStatusFetcherActor(cx, managerIntf, workers, addressWorkersMap, incompleteReason));
															#line 14390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 2503 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 14395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via blobRestoreStatusFetcher()
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class BlobRestoreStatusFetcherActor>
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class BlobRestoreStatusFetcherActorState {
															#line 14402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	BlobRestoreStatusFetcherActorState(Database const& db,std::set<std::string>* const& incompleteReason) 
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   incompleteReason(incompleteReason),
															#line 2505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj(),
															#line 2506 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   tr(db)
															#line 14415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~BlobRestoreStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2508 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				;
															#line 14431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobRestoreStatusFetcherActorState();
		static_cast<BlobRestoreStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2540 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<BlobRestoreStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~BlobRestoreStatusFetcherActorState(); static_cast<BlobRestoreStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 14460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<BlobRestoreStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~BlobRestoreStatusFetcherActorState();
		static_cast<BlobRestoreStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2535 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 14473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2536 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 14477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 2537 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incompleteReason->insert("Unable to query blob restore status");
															#line 14481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2510 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2511 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2512 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2513 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			config = BlobGranuleRestoreConfig();
															#line 2514 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<BlobRestorePhase> __when_expr_0 = config.phase().getD(&tr, Snapshot::False, BlobRestorePhase::UNINIT);
															#line 2514 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 2514 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2531 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr.onError(e);
															#line 2531 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 7;
															#line 2531 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 2516 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (phase > BlobRestorePhase::UNINIT)
															#line 14582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2517 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["blob_full_restore_phase"] = phase;
															#line 2518 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<int> __when_expr_1 = config.progress().getD(&tr);
															#line 2518 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2518 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 1, int >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(BlobRestorePhase const& __phase,int loopDepth) 
	{
															#line 2514 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		phase = __phase;
															#line 14609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(BlobRestorePhase && __phase,int loopDepth) 
	{
		phase = std::move(__phase);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreStatusFetcherActor*>(this)->ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >*,BlobRestorePhase const& value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >*,BlobRestorePhase && value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >*,Error err) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(int const& progress,int loopDepth) 
	{
															#line 2519 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_phase_progress"] = progress;
															#line 2520 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<int64_t> __when_expr_2 = config.phaseStartTs().getD(&tr, phase);
															#line 2520 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 2520 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(int && progress,int loopDepth) 
	{
															#line 2519 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_phase_progress"] = progress;
															#line 2520 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<int64_t> __when_expr_2 = config.phaseStartTs().getD(&tr, phase);
															#line 2520 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 2520 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(int const& progress,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(progress, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(int && progress,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(progress), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreStatusFetcherActor*>(this)->ActorCallback< BlobRestoreStatusFetcherActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BlobRestoreStatusFetcherActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int64_t const& phaseStartTs,int loopDepth) 
	{
															#line 2521 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_phase_start_ts"] = phaseStartTs;
															#line 2522 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<int64_t> __when_expr_3 = config.phaseStartTs().getD(&tr, BlobRestorePhase::INIT);
															#line 2522 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2522 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(int64_t && phaseStartTs,int loopDepth) 
	{
															#line 2521 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_phase_start_ts"] = phaseStartTs;
															#line 2522 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<int64_t> __when_expr_3 = config.phaseStartTs().getD(&tr, BlobRestorePhase::INIT);
															#line 2522 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2522 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(int64_t const& phaseStartTs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(phaseStartTs, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(int64_t && phaseStartTs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(phaseStartTs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreStatusFetcherActor*>(this)->ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(int64_t const& startTs,int loopDepth) 
	{
															#line 2523 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_start_ts"] = startTs;
															#line 2524 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<std::string> __when_expr_4 = config.error().getD(&tr);
															#line 2524 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 5;
															#line 2524 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(int64_t && startTs,int loopDepth) 
	{
															#line 2523 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_start_ts"] = startTs;
															#line 2524 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<std::string> __when_expr_4 = config.error().getD(&tr);
															#line 2524 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 5;
															#line 2524 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(int64_t const& startTs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(startTs, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(int64_t && startTs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(startTs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreStatusFetcherActor*>(this)->ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont7(std::string const& error,int loopDepth) 
	{
															#line 2525 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_error"] = error;
															#line 2526 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Version> __when_expr_5 = config.targetVersion().getD(&tr);
															#line 2526 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 6;
															#line 2526 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 15036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(std::string && error,int loopDepth) 
	{
															#line 2525 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_error"] = error;
															#line 2526 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Version> __when_expr_5 = config.targetVersion().getD(&tr);
															#line 2526 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 6;
															#line 2526 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 15054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(std::string const& error,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(error, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(std::string && error,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(error), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreStatusFetcherActor*>(this)->ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont8(Version const& targetVersion,int loopDepth) 
	{
															#line 2527 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_version"] = targetVersion;
															#line 15138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Version && targetVersion,int loopDepth) 
	{
															#line 2527 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_version"] = targetVersion;
															#line 15147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Version const& targetVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(targetVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Version && targetVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(targetVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreStatusFetcherActor*>(this)->ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >*,Error err) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreStatusFetcherActor*>(this)->ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database db;
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incompleteReason;
															#line 2505 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 2506 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 2513 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	BlobGranuleRestoreConfig config;
															#line 2514 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	BlobRestorePhase phase;
															#line 15339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via blobRestoreStatusFetcher()
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class BlobRestoreStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >, public ActorCallback< BlobRestoreStatusFetcherActor, 1, int >, public ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >, public ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >, public ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >, public ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >, public ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >, public FastAllocated<BlobRestoreStatusFetcherActor>, public BlobRestoreStatusFetcherActorState<BlobRestoreStatusFetcherActor> {
															#line 15344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<BlobRestoreStatusFetcherActor>::operator new;
	using FastAllocated<BlobRestoreStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7062627343453751040UL, 12781482856717426944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >;
friend struct ActorCallback< BlobRestoreStatusFetcherActor, 1, int >;
friend struct ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >;
friend struct ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >;
friend struct ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >;
friend struct ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >;
friend struct ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >;
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	BlobRestoreStatusFetcherActor(Database const& db,std::set<std::string>* const& incompleteReason) 
															#line 15367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   BlobRestoreStatusFetcherActorState<BlobRestoreStatusFetcherActor>(db, incompleteReason),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3301679672762546944UL, 427005505404888576UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("blobRestoreStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BlobRestoreStatusFetcherActor, 1, int >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> blobRestoreStatusFetcher( Database const& db, std::set<std::string>* const& incompleteReason ) {
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new BlobRestoreStatusFetcherActor(db, incompleteReason));
															#line 15406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 2542 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

static JsonBuilderObject tlogFetcher(int* logFaultTolerance,
                                     const std::vector<TLogSet>& tLogs,
                                     std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) {
	JsonBuilderObject statusObj;
	JsonBuilderArray logsObj;
	Optional<int32_t> sat_log_replication_factor, sat_log_write_anti_quorum, sat_log_fault_tolerance,
	    log_replication_factor, log_write_anti_quorum, log_fault_tolerance, remote_log_replication_factor,
	    remote_log_fault_tolerance;

	int minFaultTolerance = 1000;
	int localSetsWithNonNegativeFaultTolerance = 0;

	for (const auto& tLogSet : tLogs) {
		if (tLogSet.tLogs.size() == 0) {
			// We can have LogSets where there are no tLogs but some LogRouters. It's the way
			// recruiting is implemented for old LogRouters in TagPartitionedLogSystem, where
			// it adds an empty LogSet for missing locality.
			continue;
		}

		int failedLogs = 0;
		for (auto& log : tLogSet.tLogs) {
			JsonBuilderObject logObj;
			bool failed = !log.present() || !address_workers.contains(log.interf().address());
			logObj["id"] = log.id().shortString();
			logObj["healthy"] = !failed;
			if (log.present()) {
				logObj["address"] = log.interf().address().toString();
			}
			logsObj.push_back(logObj);
			if (failed) {
				failedLogs++;
			}
		}

		if (tLogSet.isLocal) {
			ASSERT_WE_THINK(tLogSet.tLogReplicationFactor > 0);
			int currentFaultTolerance = tLogSet.tLogReplicationFactor - 1 - tLogSet.tLogWriteAntiQuorum - failedLogs;
			if (currentFaultTolerance >= 0) {
				localSetsWithNonNegativeFaultTolerance++;
			}

			if (tLogSet.locality == tagLocalitySatellite) {
				// FIXME: This hack to bump satellite fault tolerance, is to make it consistent
				//  with 6.2.
				minFaultTolerance = std::min(minFaultTolerance, currentFaultTolerance + 1);
			} else {
				minFaultTolerance = std::min(minFaultTolerance, currentFaultTolerance);
			}
		}

		if (tLogSet.isLocal && tLogSet.locality == tagLocalitySatellite) {
			sat_log_replication_factor = tLogSet.tLogReplicationFactor;
			sat_log_write_anti_quorum = tLogSet.tLogWriteAntiQuorum;
			sat_log_fault_tolerance = tLogSet.tLogReplicationFactor - 1 - tLogSet.tLogWriteAntiQuorum - failedLogs;
		} else if (tLogSet.isLocal) {
			log_replication_factor = tLogSet.tLogReplicationFactor;
			log_write_anti_quorum = tLogSet.tLogWriteAntiQuorum;
			log_fault_tolerance = tLogSet.tLogReplicationFactor - 1 - tLogSet.tLogWriteAntiQuorum - failedLogs;
		} else {
			remote_log_replication_factor = tLogSet.tLogReplicationFactor;
			remote_log_fault_tolerance = tLogSet.tLogReplicationFactor - 1 - failedLogs;
		}
	}
	if (minFaultTolerance == 1000) {
		// just in case we do not have any tlog sets
		minFaultTolerance = 0;
	}
	if (localSetsWithNonNegativeFaultTolerance > 1) {
		minFaultTolerance++;
	}
	*logFaultTolerance = std::min(*logFaultTolerance, minFaultTolerance);
	statusObj["log_interfaces"] = logsObj;
	// We may lose logs in this log generation, storage servers may never be able to catch up this log
	// generation.
	statusObj["possibly_losing_data"] = minFaultTolerance < 0;

	if (sat_log_replication_factor.present())
		statusObj["satellite_log_replication_factor"] = sat_log_replication_factor.get();
	if (sat_log_write_anti_quorum.present())
		statusObj["satellite_log_write_anti_quorum"] = sat_log_write_anti_quorum.get();
	if (sat_log_fault_tolerance.present())
		statusObj["satellite_log_fault_tolerance"] = sat_log_fault_tolerance.get();

	if (log_replication_factor.present())
		statusObj["log_replication_factor"] = log_replication_factor.get();
	if (log_write_anti_quorum.present())
		statusObj["log_write_anti_quorum"] = log_write_anti_quorum.get();
	if (log_fault_tolerance.present())
		statusObj["log_fault_tolerance"] = log_fault_tolerance.get();

	if (remote_log_replication_factor.present())
		statusObj["remote_log_replication_factor"] = remote_log_replication_factor.get();
	if (remote_log_fault_tolerance.present())
		statusObj["remote_log_fault_tolerance"] = remote_log_fault_tolerance.get();

	return statusObj;
}

static JsonBuilderArray tlogFetcher(int* logFaultTolerance,
                                    Reference<AsyncVar<ServerDBInfo>> db,
                                    std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) {
	JsonBuilderArray tlogsArray;
	JsonBuilderObject tlogsStatus;

	// First, fetch from the current TLog generation.
	tlogsStatus = tlogFetcher(logFaultTolerance, db->get().logSystemConfig.tLogs, address_workers);
	tlogsStatus["epoch"] = db->get().logSystemConfig.epoch;
	tlogsStatus["current"] = true;
	if (db->get().logSystemConfig.recoveredAt.present()) {
		tlogsStatus["begin_version"] = db->get().logSystemConfig.recoveredAt.get();
	}
	tlogsArray.push_back(tlogsStatus);

	// fetch all the old generations of TLogs.
	for (auto it : db->get().logSystemConfig.oldTLogs) {
		JsonBuilderObject oldTlogsStatus = tlogFetcher(logFaultTolerance, it.tLogs, address_workers);
		oldTlogsStatus["epoch"] = it.epoch;
		oldTlogsStatus["current"] = false;
		oldTlogsStatus["begin_version"] = it.epochBegin;
		oldTlogsStatus["end_version"] = it.epochEnd;
		tlogsArray.push_back(oldTlogsStatus);
	}
	return tlogsArray;
}

static JsonBuilderObject faultToleranceStatusFetcher(DatabaseConfiguration configuration,
                                                     ServerCoordinators coordinators,
                                                     const std::vector<NetworkAddress>& coordinatorAddresses,
                                                     const std::vector<WorkerDetails>& workers,
                                                     int extraTlogEligibleZones,
                                                     int minStorageReplicasRemaining,
                                                     int oldLogFaultTolerance,
                                                     int fullyReplicatedRegions,
                                                     bool underMaintenance) {
	JsonBuilderObject statusObj;

	// without losing data
	int32_t maxZoneFailures = configuration.maxZoneFailuresTolerated(fullyReplicatedRegions, false);
	if (underMaintenance) {
		maxZoneFailures--;
	}
	int maxCoordinatorFailures = (coordinators.clientLeaderServers.size() - 1) / 2;

	std::map<NetworkAddress, StringRef> workerZones;
	for (const auto& worker : workers) {
		workerZones[worker.interf.address()] = worker.interf.locality.zoneId().orDefault(""_sr);
	}
	std::map<StringRef, int> coordinatorZoneCounts;
	for (const auto& coordinator : coordinatorAddresses) {
		auto zone = workerZones[coordinator];
		coordinatorZoneCounts[zone] += 1;
	}
	std::vector<std::pair<StringRef, int>> coordinatorZones(coordinatorZoneCounts.begin(), coordinatorZoneCounts.end());
	std::sort(coordinatorZones.begin(),
	          coordinatorZones.end(),
	          [](const std::pair<StringRef, int>& lhs, const std::pair<StringRef, int>& rhs) {
		          return lhs.second > rhs.second;
	          });
	int lostCoordinators = 0;
	int maxCoordinatorZoneFailures = 0;
	for (auto zone : coordinatorZones) {
		lostCoordinators += zone.second;
		if (lostCoordinators > maxCoordinatorFailures) {
			break;
		}
		maxCoordinatorZoneFailures += 1;
	}
	// max zone failures that we can tolerate to not lose data
	int zoneFailuresWithoutLosingData = std::min(maxZoneFailures, maxCoordinatorZoneFailures);

	if (minStorageReplicasRemaining >= 0) {
		zoneFailuresWithoutLosingData = std::min(zoneFailuresWithoutLosingData, minStorageReplicasRemaining - 1);
	}

	// oldLogFaultTolerance means max failures we can tolerate to lose logs data. -1 means we lose data or
	// availability.
	zoneFailuresWithoutLosingData = std::max(std::min(zoneFailuresWithoutLosingData, oldLogFaultTolerance), -1);
	statusObj["max_zone_failures_without_losing_data"] = zoneFailuresWithoutLosingData;

	int32_t maxAvaiabilityZoneFailures = configuration.maxZoneFailuresTolerated(fullyReplicatedRegions, true);
	if (underMaintenance) {
		maxAvaiabilityZoneFailures--;
	}

	statusObj["max_zone_failures_without_losing_availability"] = std::max(
	    std::min(maxAvaiabilityZoneFailures, std::min(extraTlogEligibleZones, zoneFailuresWithoutLosingData)), -1);
	return statusObj;
}

static std::string getIssueDescription(std::string name) {
	if (name == "incorrect_cluster_file_contents") {
		return "Cluster file contents do not match current cluster connection string. Verify the cluster file and "
		       "its "
		       "parent directory are writable and that the cluster file has not been overwritten externally.";
	}

	// FIXME: name and description will be the same unless the message is 'incorrect_cluster_file_contents', which
	// is currently the only possible message
	return name;
}

static std::map<std::string, std::vector<JsonBuilderObject>> getProcessIssuesAsMessages(
    std::vector<ProcessIssues> const& issues) {
	std::map<std::string, std::vector<JsonBuilderObject>> issuesMap;

	try {
		for (auto processIssues : issues) {
			for (auto issue : processIssues.issues) {
				std::string issueStr = issue.toString();
				issuesMap[processIssues.address.toString()].push_back(
				    JsonString::makeMessage(issueStr.c_str(), getIssueDescription(issueStr).c_str()));
			}
		}
	} catch (Error& e) {
		TraceEvent(SevError, "ErrorParsingProcessIssues").error(e);
		// swallow
	}

	return issuesMap;
}

static JsonBuilderArray getClientIssuesAsMessages(
    std::map<NetworkAddress, std::pair<double, OpenDatabaseRequest>>* clientStatusMap) {
	JsonBuilderArray issuesList;

	try {
		std::map<std::string, std::pair<int, std::vector<std::string>>> deduplicatedIssues;

		for (auto iter = clientStatusMap->begin(); iter != clientStatusMap->end();) {
			if (now() - iter->second.first >= 2 * SERVER_KNOBS->COORDINATOR_REGISTER_INTERVAL) {
				iter = clientStatusMap->erase(iter);
				continue;
			}

			for (const auto& [issueKey, samples] : iter->second.second.issues) {
				auto& t = deduplicatedIssues[issueKey.toString()];
				t.first += samples.count;
				for (const auto& sample : samples.samples) {
					t.second.push_back(formatIpPort(sample.first.ip, sample.first.port));
				}
			}
			++iter;
		}

		// FIXME: add the log_group in addition to the network address
		for (auto i : deduplicatedIssues) {
			JsonBuilderObject message = JsonString::makeMessage(i.first.c_str(), getIssueDescription(i.first).c_str());
			JsonBuilderArray addresses;
			for (auto addr : i.second.second) {
				addresses.push_back(addr);
			}

			message["count"] = i.second.first;
			message["addresses"] = addresses;
			issuesList.push_back(message);
		}
	} catch (Error& e) {
		TraceEvent(SevError, "ErrorParsingClientIssues").error(e);
		// swallow
	}

	return issuesList;
}

															#line 15676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via layerStatusFetcher()
															#line 2808 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class LayerStatusFetcherActor>
															#line 2808 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class LayerStatusFetcherActorState {
															#line 15683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 2808 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	LayerStatusFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 2808 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 2808 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 2808 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 2808 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 2811 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   result(),
															#line 2812 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   json(result),
															#line 2813 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   tStart(now())
															#line 15700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("layerStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~LayerStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("layerStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2816 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				tr = ReadYourWritesTransaction(cx);
															#line 2817 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				;
															#line 15718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LayerStatusFetcherActorState();
		static_cast<LayerStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2867 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		json.cleanOps();
															#line 2868 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject statusObj;
															#line 2869 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj.addContents(result);
															#line 2870 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		TraceEvent("LayerStatusFetcher") .detail("Duration", now() - tStart) .detail("StatusSize", statusObj.getFinalLength());
															#line 2873 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LayerStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~LayerStatusFetcherActorState(); static_cast<LayerStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 15755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LayerStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(statusObj);
		this->~LayerStatusFetcherActorState();
		static_cast<LayerStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2858 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			TraceEvent(SevWarn, "LayerStatusError").error(e);
															#line 2859 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 15770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2860 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 15774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 2862 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve layer status (%s).", e.what()));
															#line 2863 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			json.create("_error") = format("Unable to retrieve layer status (%s).", e.what());
															#line 2864 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			json.create("_valid") = false;
															#line 15782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2819 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2820 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			int64_t timeout_ms = 3000;
															#line 2821 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::TIMEOUT, StringRef((uint8_t*)&timeout_ms, sizeof(int64_t)));
															#line 2823 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			std::string jsonPrefix = layerStatusMetaPrefixRange.begin.toString() + "json/";
															#line 2824 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(KeyRangeRef(jsonPrefix, strinc(jsonPrefix)), 1000);
															#line 2824 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 2824 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 15826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2854 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 2854 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 5;
															#line 2854 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 4, Void >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 15868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& jsonLayers,int loopDepth) 
	{
															#line 2827 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		docFutures = std::vector<Future<RangeResult>>();
															#line 2828 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		i = int();
															#line 2829 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for(i = 0;i < jsonLayers.size();++i) {
															#line 2830 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			docFutures.push_back( tr.getRange(KeyRangeRef(jsonLayers[i].value, strinc(jsonLayers[i].value)), 1000));
															#line 15889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2833 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		result.clear();
															#line 2834 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JSONDoc::expires_reference_version = (uint64_t)tr.getReadVersion().get();
															#line 2836 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		i = 0;
															#line 15897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && jsonLayers,int loopDepth) 
	{
															#line 2827 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		docFutures = std::vector<Future<RangeResult>>();
															#line 2828 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		i = int();
															#line 2829 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for(i = 0;i < jsonLayers.size();++i) {
															#line 2830 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			docFutures.push_back( tr.getRange(KeyRangeRef(jsonLayers[i].value, strinc(jsonLayers[i].value)), 1000));
															#line 15912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2833 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		result.clear();
															#line 2834 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JSONDoc::expires_reference_version = (uint64_t)tr.getReadVersion().get();
															#line 2836 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		i = 0;
															#line 15920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& jsonLayers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(jsonLayers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && jsonLayers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(jsonLayers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 2851 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		json.create("_valid") = true;
															#line 16004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 2836 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!(i < docFutures.size()))
															#line 16020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2837 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = docFutures[i];
															#line 2837 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2837 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 16033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
															#line 2838 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		j = int();
															#line 2839 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		j = 0;
															#line 16057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(RangeResult const& __docs,int loopDepth) 
	{
															#line 2837 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		docs = __docs;
															#line 16066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(RangeResult && __docs,int loopDepth) 
	{
		docs = std::move(__docs);
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2loopBody1cont3(int loopDepth) 
	{
															#line 2836 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++i;
															#line 16145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 2839 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!(j < docs.size()))
															#line 16161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
			return a_body1loopBody1cont2loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2840 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		doc = json_spirit::mValue();
															#line 16167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		try {
															#line 2842 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			json_spirit::read_string(docs[j].value.toString(), doc);
															#line 2843 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = yield();
															#line 2843 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 2843 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 2, Void >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 16180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2839 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		++j;
															#line 16208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2847 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			TraceEvent(SevWarn, "LayerStatusBadJSON").detail("Key", docs[j].key);
															#line 16218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 2844 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		json.absorb(doc.get_obj());
															#line 2845 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 2845 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2845 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 3, Void >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 16242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 2844 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		json.absorb(doc.get_obj());
															#line 2845 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 2845 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2845 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 3, Void >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 16260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2808 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2808 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 2808 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 2811 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	StatusObject result;
															#line 2812 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JSONDoc json;
															#line 2813 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	double tStart;
															#line 2816 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2827 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<RangeResult>> docFutures;
															#line 2828 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	int i;
															#line 2837 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	RangeResult docs;
															#line 2838 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	int j;
															#line 2840 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	json_spirit::mValue doc;
															#line 16564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via layerStatusFetcher()
															#line 2808 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class LayerStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< LayerStatusFetcherActor, 0, RangeResult >, public ActorCallback< LayerStatusFetcherActor, 1, RangeResult >, public ActorCallback< LayerStatusFetcherActor, 2, Void >, public ActorCallback< LayerStatusFetcherActor, 3, Void >, public ActorCallback< LayerStatusFetcherActor, 4, Void >, public FastAllocated<LayerStatusFetcherActor>, public LayerStatusFetcherActorState<LayerStatusFetcherActor> {
															#line 16569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<LayerStatusFetcherActor>::operator new;
	using FastAllocated<LayerStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18359683766521696768UL, 3664565007504984320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LayerStatusFetcherActor, 0, RangeResult >;
friend struct ActorCallback< LayerStatusFetcherActor, 1, RangeResult >;
friend struct ActorCallback< LayerStatusFetcherActor, 2, Void >;
friend struct ActorCallback< LayerStatusFetcherActor, 3, Void >;
friend struct ActorCallback< LayerStatusFetcherActor, 4, Void >;
															#line 2808 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	LayerStatusFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 16590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   LayerStatusFetcherActorState<LayerStatusFetcherActor>(cx, messages, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17036008822344536576UL, 14869839289433060096UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("layerStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2808 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<JsonBuilderObject> layerStatusFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons ) {
															#line 2808 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new LayerStatusFetcherActor(cx, messages, incomplete_reasons));
															#line 16627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 2875 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 16632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via lockedStatusFetcher()
															#line 2876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class LockedStatusFetcherActor>
															#line 2876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class LockedStatusFetcherActorState {
															#line 16639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 2876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	LockedStatusFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 2876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 2876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 2876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 2876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 2879 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj(),
															#line 2881 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   tr(cx),
															#line 2882 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   timeoutSeconds(5),
															#line 2883 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   getTimeout(delay(timeoutSeconds))
															#line 16658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("lockedStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~LockedStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("lockedStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2885 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 16673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LockedStatusFetcherActorState();
		static_cast<LockedStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2918 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LockedStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~LockedStatusFetcherActorState(); static_cast<LockedStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 16696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LockedStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~LockedStatusFetcherActorState();
		static_cast<LockedStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2886 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2887 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 2888 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 16719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		try {
															#line 2891 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(databaseLockedKey);
															#line 2890 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2900 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = getTimeout;
															#line 16729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 2891 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*>(static_cast<LockedStatusFetcherActor*>(this)));
															#line 2900 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LockedStatusFetcherActor, 1, Void >*>(static_cast<LockedStatusFetcherActor*>(this)));
															#line 16736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
			try {
															#line 2908 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 2908 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 16774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2908 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LockedStatusFetcherActor, 2, Void >*>(static_cast<LockedStatusFetcherActor*>(this)));
															#line 16779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& lockUID,int loopDepth) 
	{
															#line 2892 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (lockUID.present())
															#line 16806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2893 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["locked"] = true;
															#line 2894 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["lock_uid"] = BinaryReader::fromStringRef<UID>(lockUID.get().substr(10), Unversioned()).toString();
															#line 16812 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 2897 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["locked"] = false;
															#line 16818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && lockUID,int loopDepth) 
	{
															#line 2892 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (lockUID.present())
															#line 16828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2893 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["locked"] = true;
															#line 2894 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["lock_uid"] = BinaryReader::fromStringRef<UID>(lockUID.get().substr(10), Unversioned()).toString();
															#line 16834 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 2897 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["locked"] = false;
															#line 16840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 2901 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		incomplete_reasons->insert( format("Unable to determine if database is locked after %d seconds.", timeoutSeconds));
															#line 16850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 2901 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		incomplete_reasons->insert( format("Unable to determine if database is locked after %d seconds.", timeoutSeconds));
															#line 16859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LockedStatusFetcherActor*>(this)->ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >::remove();
		static_cast<LockedStatusFetcherActor*>(this)->ActorCallback< LockedStatusFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LockedStatusFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2910 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 16996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2911 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 17000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 2913 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to determine if database is locked (%s).", e.what()));
															#line 17004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LockedStatusFetcherActor*>(this)->ActorCallback< LockedStatusFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LockedStatusFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 2876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 2876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 2879 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 2881 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 2882 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	int timeoutSeconds;
															#line 2883 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<Void> getTimeout;
															#line 17129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via lockedStatusFetcher()
															#line 2876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class LockedStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >, public ActorCallback< LockedStatusFetcherActor, 1, Void >, public ActorCallback< LockedStatusFetcherActor, 2, Void >, public FastAllocated<LockedStatusFetcherActor>, public LockedStatusFetcherActorState<LockedStatusFetcherActor> {
															#line 17134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<LockedStatusFetcherActor>::operator new;
	using FastAllocated<LockedStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5358939820452700672UL, 5092742831217651200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >;
friend struct ActorCallback< LockedStatusFetcherActor, 1, Void >;
friend struct ActorCallback< LockedStatusFetcherActor, 2, Void >;
															#line 2876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	LockedStatusFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 17153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   LockedStatusFetcherActorState<LockedStatusFetcherActor>(cx, messages, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14369978241092976128UL, 3028260835526008320UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lockedStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LockedStatusFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<JsonBuilderObject> lockedStatusFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons ) {
															#line 2876 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new LockedStatusFetcherActor(cx, messages, incomplete_reasons));
															#line 17187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 2920 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 17192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getActivePrimaryDC()
															#line 2921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class GetActivePrimaryDCActor>
															#line 2921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetActivePrimaryDCActorState {
															#line 17199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 2921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetActivePrimaryDCActorState(Database const& cx,int* const& fullyReplicatedRegions,JsonBuilderArray* const& messages) 
															#line 2921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 2921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 2921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   fullyReplicatedRegions(fullyReplicatedRegions),
															#line 2921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 2922 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   tr(cx),
															#line 2924 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   readTimeout(delay(5))
															#line 17214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getActivePrimaryDC", reinterpret_cast<unsigned long>(this));

	}
	~GetActivePrimaryDCActorState() 
	{
		fdb_probe_actor_destroy("getActivePrimaryDC", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2925 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 17229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetActivePrimaryDCActorState();
		static_cast<GetActivePrimaryDCActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2927 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (readTimeout.isReady())
															#line 17260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2928 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1loopBody1Catch1(timed_out(), loopDepth);
															#line 17264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 2930 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 2931 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2932 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			fReplicaKeys = tr.getRange(datacenterReplicasKeys, CLIENT_KNOBS->TOO_MANY);
															#line 2933 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			fPrimaryDatacenterKey = tr.get(primaryDatacenterKey);
															#line 2934 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeoutError(success(fPrimaryDatacenterKey) && success(fReplicaKeys), 5);
															#line 2934 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state = 1;
															#line 2934 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetActivePrimaryDCActor, 0, Void >*>(static_cast<GetActivePrimaryDCActor*>(this)));
															#line 17283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2944 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 17305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2945 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				messages->push_back( JsonString::makeMessage("fetch_primary_dc_timeout", "Fetching primary DC timed out."));
															#line 2947 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (!static_cast<GetActivePrimaryDCActor*>(this)->SAV<Optional<Value>>::futures) { (void)(Optional<Value>()); this->~GetActivePrimaryDCActorState(); static_cast<GetActivePrimaryDCActor*>(this)->destroy(); return 0; }
															#line 17311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				new (&static_cast<GetActivePrimaryDCActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(Optional<Value>());
				this->~GetActivePrimaryDCActorState();
				static_cast<GetActivePrimaryDCActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2949 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 2949 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
				static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state = 2;
															#line 2949 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetActivePrimaryDCActor, 1, Void >*>(static_cast<GetActivePrimaryDCActor*>(this)));
															#line 17328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2936 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		*fullyReplicatedRegions = fReplicaKeys.get().size();
															#line 2938 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!fPrimaryDatacenterKey.get().present())
															#line 17346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2939 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("primary_dc_missing", "Unable to determine primary datacenter."));
															#line 17350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2942 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetActivePrimaryDCActor*>(this)->SAV<Optional<Value>>::futures) { (void)(fPrimaryDatacenterKey.get()); this->~GetActivePrimaryDCActorState(); static_cast<GetActivePrimaryDCActor*>(this)->destroy(); return 0; }
															#line 17354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetActivePrimaryDCActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(fPrimaryDatacenterKey.get());
		this->~GetActivePrimaryDCActorState();
		static_cast<GetActivePrimaryDCActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2936 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		*fullyReplicatedRegions = fReplicaKeys.get().size();
															#line 2938 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!fPrimaryDatacenterKey.get().present())
															#line 17368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 2939 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("primary_dc_missing", "Unable to determine primary datacenter."));
															#line 17372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 2942 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetActivePrimaryDCActor*>(this)->SAV<Optional<Value>>::futures) { (void)(fPrimaryDatacenterKey.get()); this->~GetActivePrimaryDCActorState(); static_cast<GetActivePrimaryDCActor*>(this)->destroy(); return 0; }
															#line 17376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetActivePrimaryDCActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(fPrimaryDatacenterKey.get());
		this->~GetActivePrimaryDCActorState();
		static_cast<GetActivePrimaryDCActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state > 0) static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state = 0;
		static_cast<GetActivePrimaryDCActor*>(this)->ActorCallback< GetActivePrimaryDCActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetActivePrimaryDCActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetActivePrimaryDCActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetActivePrimaryDCActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state > 0) static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state = 0;
		static_cast<GetActivePrimaryDCActor*>(this)->ActorCallback< GetActivePrimaryDCActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetActivePrimaryDCActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetActivePrimaryDCActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetActivePrimaryDCActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	int* fullyReplicatedRegions;
															#line 2921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 2922 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2924 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<Void> readTimeout;
															#line 2932 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<RangeResult> fReplicaKeys;
															#line 2933 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<Optional<Value>> fPrimaryDatacenterKey;
															#line 17566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getActivePrimaryDC()
															#line 2921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetActivePrimaryDCActor final : public Actor<Optional<Value>>, public ActorCallback< GetActivePrimaryDCActor, 0, Void >, public ActorCallback< GetActivePrimaryDCActor, 1, Void >, public FastAllocated<GetActivePrimaryDCActor>, public GetActivePrimaryDCActorState<GetActivePrimaryDCActor> {
															#line 17571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetActivePrimaryDCActor>::operator new;
	using FastAllocated<GetActivePrimaryDCActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7754860302472936960UL, 2188564931561883392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetActivePrimaryDCActor, 0, Void >;
friend struct ActorCallback< GetActivePrimaryDCActor, 1, Void >;
															#line 2921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetActivePrimaryDCActor(Database const& cx,int* const& fullyReplicatedRegions,JsonBuilderArray* const& messages) 
															#line 17589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   GetActivePrimaryDCActorState<GetActivePrimaryDCActor>(cx, fullyReplicatedRegions, messages),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11163384421170287360UL, 3820190715572017408UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getActivePrimaryDC");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetActivePrimaryDCActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetActivePrimaryDCActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<Optional<Value>> getActivePrimaryDC( Database const& cx, int* const& fullyReplicatedRegions, JsonBuilderArray* const& messages ) {
															#line 2921 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Optional<Value>>(new GetActivePrimaryDCActor(cx, fullyReplicatedRegions, messages));
															#line 17623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 2954 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 17628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via readStorageWiggleMetrics()
															#line 2955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class ReadStorageWiggleMetricsActor>
															#line 2955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class ReadStorageWiggleMetricsActorState {
															#line 17635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 2955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	ReadStorageWiggleMetricsActorState(Database const& cx,bool const& use_system_priority) 
															#line 2955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 2955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 2955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   use_system_priority(use_system_priority),
															#line 2958 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   tr(new ReadYourWritesTransaction(cx)),
															#line 2959 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   primaryV(),
															#line 2960 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   remoteV(),
															#line 2961 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   wiggleState()
															#line 17652 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this));

	}
	~ReadStorageWiggleMetricsActorState() 
	{
		fdb_probe_actor_destroy("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2962 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 17667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadStorageWiggleMetricsActorState();
		static_cast<ReadStorageWiggleMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2964 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (use_system_priority)
															#line 17698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2965 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 17702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 2967 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 2968 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 2969 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(primaryV, wiggleState.storageWiggleMetrics(PrimaryRegion(true)).get(tr)) && store(remoteV, wiggleState.storageWiggleMetrics(PrimaryRegion(false)).get(tr));
															#line 2969 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state = 1;
															#line 2969 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >*>(static_cast<ReadStorageWiggleMetricsActor*>(this)));
															#line 17717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2973 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 2973 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state = 2;
															#line 2973 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >*>(static_cast<ReadStorageWiggleMetricsActor*>(this)));
															#line 17746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2971 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ReadStorageWiggleMetricsActor*>(this)->SAV<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>>::futures) { (void)(std::make_pair(primaryV, remoteV)); this->~ReadStorageWiggleMetricsActorState(); static_cast<ReadStorageWiggleMetricsActor*>(this)->destroy(); return 0; }
															#line 17761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<ReadStorageWiggleMetricsActor*>(this)->SAV< std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>> >::value()) std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>(std::make_pair(primaryV, remoteV));
		this->~ReadStorageWiggleMetricsActorState();
		static_cast<ReadStorageWiggleMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2971 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ReadStorageWiggleMetricsActor*>(this)->SAV<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>>::futures) { (void)(std::make_pair(primaryV, remoteV)); this->~ReadStorageWiggleMetricsActorState(); static_cast<ReadStorageWiggleMetricsActor*>(this)->destroy(); return 0; }
															#line 17773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<ReadStorageWiggleMetricsActor*>(this)->SAV< std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>> >::value()) std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>(std::make_pair(primaryV, remoteV));
		this->~ReadStorageWiggleMetricsActorState();
		static_cast<ReadStorageWiggleMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state > 0) static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<ReadStorageWiggleMetricsActor*>(this)->ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state > 0) static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<ReadStorageWiggleMetricsActor*>(this)->ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	bool use_system_priority;
															#line 2958 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2959 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Optional<StorageWiggleMetrics> primaryV;
															#line 2960 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Optional<StorageWiggleMetrics> remoteV;
															#line 2961 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	StorageWiggleData wiggleState;
															#line 17955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via readStorageWiggleMetrics()
															#line 2955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class ReadStorageWiggleMetricsActor final : public Actor<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>>, public ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >, public ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >, public FastAllocated<ReadStorageWiggleMetricsActor>, public ReadStorageWiggleMetricsActorState<ReadStorageWiggleMetricsActor> {
															#line 17960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<ReadStorageWiggleMetricsActor>::operator new;
	using FastAllocated<ReadStorageWiggleMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14715172936403665408UL, 12141335854655878656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >;
friend struct ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >;
															#line 2955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	ReadStorageWiggleMetricsActor(Database const& cx,bool const& use_system_priority) 
															#line 17978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>>(),
		   ReadStorageWiggleMetricsActorState<ReadStorageWiggleMetricsActor>(cx, use_system_priority),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14092575410789312000UL, 17117368816633130496UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readStorageWiggleMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>> readStorageWiggleMetrics( Database const& cx, bool const& use_system_priority ) {
															#line 2955 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>>(new ReadStorageWiggleMetricsActor(cx, use_system_priority));
															#line 18012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 2977 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

															#line 18017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getKMSHealthStatus()
															#line 2978 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class GetKMSHealthStatusActor>
															#line 2978 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetKMSHealthStatusActorState {
															#line 18024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 2978 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetKMSHealthStatusActorState(Reference<const AsyncVar<ServerDBInfo>> const& db) 
															#line 2978 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 2978 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   unhealthy()
															#line 18033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getKMSHealthStatus", reinterpret_cast<unsigned long>(this));

	}
	~GetKMSHealthStatusActorState() 
	{
		fdb_probe_actor_destroy("getKMSHealthStatus", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2980 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			unhealthy.canConnectToEKP = false;
															#line 2981 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			unhealthy.canConnectToKms = false;
															#line 2982 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			unhealthy.lastUpdatedTS = now();
															#line 18052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			try {
															#line 2984 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (!db->get().client.encryptKeyProxy.present())
															#line 18056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 2985 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					if (!static_cast<GetKMSHealthStatusActor*>(this)->SAV<KMSHealthStatus>::futures) { (void)(unhealthy); this->~GetKMSHealthStatusActorState(); static_cast<GetKMSHealthStatusActor*>(this)->destroy(); return 0; }
															#line 18060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					new (&static_cast<GetKMSHealthStatusActor*>(this)->SAV< KMSHealthStatus >::value()) KMSHealthStatus(std::move(unhealthy)); // state_var_RVO
					this->~GetKMSHealthStatusActorState();
					static_cast<GetKMSHealthStatusActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 2987 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<KMSHealthStatus> __when_expr_0 = timeoutError( db->get().client.encryptKeyProxy.get().getHealthStatus.getReply(EncryptKeyProxyHealthStatusRequest()), FLOW_KNOBS->EKP_HEALTH_CHECK_REQUEST_TIMEOUT);
															#line 2987 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<GetKMSHealthStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetKMSHealthStatusActor*>(this)->actor_wait_state = 1;
															#line 2987 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKMSHealthStatusActor, 0, KMSHealthStatus >*>(static_cast<GetKMSHealthStatusActor*>(this)));
															#line 18075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKMSHealthStatusActorState();
		static_cast<GetKMSHealthStatusActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2992 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() != error_code_timed_out)
															#line 18105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 2993 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 18109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 2995 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<GetKMSHealthStatusActor*>(this)->SAV<KMSHealthStatus>::futures) { (void)(unhealthy); this->~GetKMSHealthStatusActorState(); static_cast<GetKMSHealthStatusActor*>(this)->destroy(); return 0; }
															#line 18113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			new (&static_cast<GetKMSHealthStatusActor*>(this)->SAV< KMSHealthStatus >::value()) KMSHealthStatus(std::move(unhealthy)); // state_var_RVO
			this->~GetKMSHealthStatusActorState();
			static_cast<GetKMSHealthStatusActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(KMSHealthStatus const& reply,int loopDepth) 
	{
															#line 2990 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetKMSHealthStatusActor*>(this)->SAV<KMSHealthStatus>::futures) { (void)(reply); this->~GetKMSHealthStatusActorState(); static_cast<GetKMSHealthStatusActor*>(this)->destroy(); return 0; }
															#line 18131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetKMSHealthStatusActor*>(this)->SAV< KMSHealthStatus >::value()) KMSHealthStatus(reply);
		this->~GetKMSHealthStatusActorState();
		static_cast<GetKMSHealthStatusActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(KMSHealthStatus && reply,int loopDepth) 
	{
															#line 2990 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetKMSHealthStatusActor*>(this)->SAV<KMSHealthStatus>::futures) { (void)(reply); this->~GetKMSHealthStatusActorState(); static_cast<GetKMSHealthStatusActor*>(this)->destroy(); return 0; }
															#line 18143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetKMSHealthStatusActor*>(this)->SAV< KMSHealthStatus >::value()) KMSHealthStatus(reply);
		this->~GetKMSHealthStatusActorState();
		static_cast<GetKMSHealthStatusActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(KMSHealthStatus const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont2(reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(KMSHealthStatus && reply,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKMSHealthStatusActor*>(this)->actor_wait_state > 0) static_cast<GetKMSHealthStatusActor*>(this)->actor_wait_state = 0;
		static_cast<GetKMSHealthStatusActor*>(this)->ActorCallback< GetKMSHealthStatusActor, 0, KMSHealthStatus >::remove();

	}
	void a_callback_fire(ActorCallback< GetKMSHealthStatusActor, 0, KMSHealthStatus >*,KMSHealthStatus const& value) 
	{
		fdb_probe_actor_enter("getKMSHealthStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKMSHealthStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKMSHealthStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKMSHealthStatusActor, 0, KMSHealthStatus >*,KMSHealthStatus && value) 
	{
		fdb_probe_actor_enter("getKMSHealthStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKMSHealthStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKMSHealthStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKMSHealthStatusActor, 0, KMSHealthStatus >*,Error err) 
	{
		fdb_probe_actor_enter("getKMSHealthStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKMSHealthStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKMSHealthStatus", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2978 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Reference<const AsyncVar<ServerDBInfo>> db;
															#line 2979 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	KMSHealthStatus unhealthy;
															#line 18230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getKMSHealthStatus()
															#line 2978 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class GetKMSHealthStatusActor final : public Actor<KMSHealthStatus>, public ActorCallback< GetKMSHealthStatusActor, 0, KMSHealthStatus >, public FastAllocated<GetKMSHealthStatusActor>, public GetKMSHealthStatusActorState<GetKMSHealthStatusActor> {
															#line 18235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetKMSHealthStatusActor>::operator new;
	using FastAllocated<GetKMSHealthStatusActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10538001192976342528UL, 13700934855531126528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<KMSHealthStatus>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKMSHealthStatusActor, 0, KMSHealthStatus >;
															#line 2978 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	GetKMSHealthStatusActor(Reference<const AsyncVar<ServerDBInfo>> const& db) 
															#line 18252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<KMSHealthStatus>(),
		   GetKMSHealthStatusActorState<GetKMSHealthStatusActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKMSHealthStatus", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3384696709411250176UL, 3519187457003744768UL);
		ActorExecutionContextHelper __helper(static_cast<GetKMSHealthStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKMSHealthStatus");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKMSHealthStatus", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKMSHealthStatusActor, 0, KMSHealthStatus >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2978 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<KMSHealthStatus> getKMSHealthStatus( Reference<const AsyncVar<ServerDBInfo>> const& db ) {
															#line 2978 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<KMSHealthStatus>(new GetKMSHealthStatusActor(db));
															#line 18285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 2998 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

// read storageWigglerStats through Read-only tx, then convert it to JSON field
															#line 18291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via storageWigglerStatsFetcher()
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class StorageWigglerStatsFetcherActor>
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class StorageWigglerStatsFetcherActorState {
															#line 18298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	StorageWigglerStatsFetcherActorState(Optional<DataDistributorInterface> const& ddWorker,DatabaseConfiguration const& conf,Database const& cx,bool const& use_system_priority,JsonBuilderArray* const& messages) 
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : ddWorker(ddWorker),
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   conf(conf),
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   cx(cx),
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   use_system_priority(use_system_priority),
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 3006 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   stateFut(),
															#line 3007 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   wiggleMetricsFut(timeoutError(readStorageWiggleMetrics(cx, use_system_priority), 2.0)),
															#line 3009 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   res()
															#line 18319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this));

	}
	~StorageWigglerStatsFetcherActorState() 
	{
		fdb_probe_actor_destroy("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3010 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (ddWorker.present())
															#line 18334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 3011 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				stateFut = timeoutError(ddWorker.get().storageWigglerState.getReply(GetStorageWigglerStateRequest()), 2.0);
															#line 3012 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_0 = ready(stateFut);
															#line 3012 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state = 1;
															#line 3012 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >*>(static_cast<StorageWigglerStatsFetcherActor*>(this)));
															#line 18347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 3014 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (!static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(res); this->~StorageWigglerStatsFetcherActorState(); static_cast<StorageWigglerStatsFetcherActor*>(this)->destroy(); return 0; }
															#line 18354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				new (&static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(res)); // state_var_RVO
				this->~StorageWigglerStatsFetcherActorState();
				static_cast<StorageWigglerStatsFetcherActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StorageWigglerStatsFetcherActorState();
		static_cast<StorageWigglerStatsFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 3018 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.01))
															#line 18382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 3019 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1cont1Catch1(timed_out(), loopDepth);
															#line 18386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 3022 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(wiggleMetricsFut) && success(stateFut);
															#line 3022 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 18392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state = 2;
															#line 3022 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >*>(static_cast<StorageWigglerStatsFetcherActor*>(this)));
															#line 18397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state > 0) static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<StorageWigglerStatsFetcherActor*>(this)->ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageWigglerStatsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageWigglerStatsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageWigglerStatsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 3047 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(res); this->~StorageWigglerStatsFetcherActorState(); static_cast<StorageWigglerStatsFetcherActor*>(this)->destroy(); return 0; }
															#line 18499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(res)); // state_var_RVO
		this->~StorageWigglerStatsFetcherActorState();
		static_cast<StorageWigglerStatsFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3042 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 18512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 3043 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 18516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 3044 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back(JsonString::makeMessage("fetch_storage_wiggler_stats_timeout", "Fetching storage wiggler stats timed out."));
															#line 18520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 3023 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		auto [primaryV, remoteV] = wiggleMetricsFut.get();
															#line 3024 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (primaryV.present())
															#line 18537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3025 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto obj = primaryV.get().toJSON();
															#line 3026 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto& reply = stateFut.get();
															#line 3027 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			obj["state"] = StorageWiggler::getWiggleStateStr(static_cast<StorageWiggler::State>(reply.primary));
															#line 3028 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_timestamp"] = reply.lastStateChangePrimary;
															#line 3029 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_datetime"] = epochsToGMTString(reply.lastStateChangePrimary);
															#line 3030 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			res["primary"] = obj;
															#line 18551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3032 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (conf.regions.size() > 1 && remoteV.present())
															#line 18555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3033 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto obj = remoteV.get().toJSON();
															#line 3034 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto& reply = stateFut.get();
															#line 3035 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			obj["state"] = StorageWiggler::getWiggleStateStr(static_cast<StorageWiggler::State>(reply.remote));
															#line 3036 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_timestamp"] = reply.lastStateChangeRemote;
															#line 3037 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_datetime"] = epochsToGMTString(reply.lastStateChangeRemote);
															#line 3038 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			res["remote"] = obj;
															#line 18569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3040 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(res); this->~StorageWigglerStatsFetcherActorState(); static_cast<StorageWigglerStatsFetcherActor*>(this)->destroy(); return 0; }
															#line 18573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(res)); // state_var_RVO
		this->~StorageWigglerStatsFetcherActorState();
		static_cast<StorageWigglerStatsFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 3023 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		auto [primaryV, remoteV] = wiggleMetricsFut.get();
															#line 3024 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (primaryV.present())
															#line 18587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3025 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto obj = primaryV.get().toJSON();
															#line 3026 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto& reply = stateFut.get();
															#line 3027 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			obj["state"] = StorageWiggler::getWiggleStateStr(static_cast<StorageWiggler::State>(reply.primary));
															#line 3028 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_timestamp"] = reply.lastStateChangePrimary;
															#line 3029 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_datetime"] = epochsToGMTString(reply.lastStateChangePrimary);
															#line 3030 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			res["primary"] = obj;
															#line 18601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3032 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (conf.regions.size() > 1 && remoteV.present())
															#line 18605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3033 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto obj = remoteV.get().toJSON();
															#line 3034 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			auto& reply = stateFut.get();
															#line 3035 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			obj["state"] = StorageWiggler::getWiggleStateStr(static_cast<StorageWiggler::State>(reply.remote));
															#line 3036 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_timestamp"] = reply.lastStateChangeRemote;
															#line 3037 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_datetime"] = epochsToGMTString(reply.lastStateChangeRemote);
															#line 3038 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			res["remote"] = obj;
															#line 18619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3040 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(res); this->~StorageWigglerStatsFetcherActorState(); static_cast<StorageWigglerStatsFetcherActor*>(this)->destroy(); return 0; }
															#line 18623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		new (&static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(res)); // state_var_RVO
		this->~StorageWigglerStatsFetcherActorState();
		static_cast<StorageWigglerStatsFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state > 0) static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<StorageWigglerStatsFetcherActor*>(this)->ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageWigglerStatsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageWigglerStatsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageWigglerStatsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Optional<DataDistributorInterface> ddWorker;
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	DatabaseConfiguration conf;
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	bool use_system_priority;
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 3006 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<GetStorageWigglerStateReply> stateFut;
															#line 3007 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	Future<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>> wiggleMetricsFut;
															#line 3009 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject res;
															#line 18722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via storageWigglerStatsFetcher()
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class StorageWigglerStatsFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >, public ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >, public FastAllocated<StorageWigglerStatsFetcherActor>, public StorageWigglerStatsFetcherActorState<StorageWigglerStatsFetcherActor> {
															#line 18727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<StorageWigglerStatsFetcherActor>::operator new;
	using FastAllocated<StorageWigglerStatsFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16850379279703341568UL, 18264134714877243136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >;
friend struct ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >;
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	StorageWigglerStatsFetcherActor(Optional<DataDistributorInterface> const& ddWorker,DatabaseConfiguration const& conf,Database const& cx,bool const& use_system_priority,JsonBuilderArray* const& messages) 
															#line 18745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   StorageWigglerStatsFetcherActorState<StorageWigglerStatsFetcherActor>(ddWorker, conf, cx, use_system_priority, messages),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4661988479812632320UL, 8175584891990373120UL);
		ActorExecutionContextHelper __helper(static_cast<StorageWigglerStatsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("storageWigglerStatsFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<JsonBuilderObject> storageWigglerStatsFetcher( Optional<DataDistributorInterface> const& ddWorker, DatabaseConfiguration const& conf, Database const& cx, bool const& use_system_priority, JsonBuilderArray* const& messages ) {
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new StorageWigglerStatsFetcherActor(ddWorker, conf, cx, use_system_priority, messages));
															#line 18779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
}

#line 3049 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"

// constructs the cluster section of the json status output
															#line 18785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterGetStatus()
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
template <class ClusterGetStatusActor>
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
class ClusterGetStatusActorState {
															#line 18792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
public:
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
	ClusterGetStatusActorState(Reference<AsyncVar<ServerDBInfo>> const& db,Database const& cx,std::vector<WorkerDetails> const& workers,std::vector<ProcessIssues> const& workerIssues,std::vector<StorageServerMetaInfo> const& storageMetadatas,std::map<NetworkAddress, std::pair<double, OpenDatabaseRequest>>* const& clientStatus,ServerCoordinators const& coordinators,std::vector<NetworkAddress> const& incompatibleConnections,Version const& datacenterVersionDifference,Version const& dcLogServerVersionDifference,Version const& dcStorageServerVersionDifference,ConfigBroadcaster const* const& configBroadcaster,Optional<UnversionedMetaclusterRegistrationEntry> const& metaclusterRegistration,metacluster::MetaclusterMetrics const& metaclusterMetrics,std::unordered_map<NetworkAddress, double> const& excludedDegradedServers) 
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   cx(cx),
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   workers(workers),
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   workerIssues(workerIssues),
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   storageMetadatas(storageMetadatas),
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   clientStatus(clientStatus),
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   coordinators(coordinators),
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   incompatibleConnections(incompatibleConnections),
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   datacenterVersionDifference(datacenterVersionDifference),
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   dcLogServerVersionDifference(dcLogServerVersionDifference),
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   dcStorageServerVersionDifference(dcStorageServerVersionDifference),
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   configBroadcaster(configBroadcaster),
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   metaclusterRegistration(metaclusterRegistration),
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   metaclusterMetrics(metaclusterMetrics),
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   excludedDegradedServers(excludedDegradedServers),
															#line 3068 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   tStart(timer()),
															#line 3070 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   messages(),
															#line 3071 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   status_incomplete_reasons(),
															#line 3072 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   mWorker(),
															#line 3073 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   ccWorker(),
															#line 3074 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   ddWorker(),
															#line 3075 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   rkWorker(),
															#line 3076 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		   csWorker()
															#line 18843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterGetStatus", reinterpret_cast<unsigned long>(this));

	}
	~ClusterGetStatusActorState() 
	{
		fdb_probe_actor_destroy("clusterGetStatus", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 3080 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj = JsonBuilderObject();
															#line 3083 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (db->get().client.encryptKeyProxy.present())
															#line 18861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 3084 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					StrictFuture<KMSHealthStatus> __when_expr_0 = getKMSHealthStatus(db);
															#line 3084 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 1;
															#line 3084 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 0, KMSHealthStatus >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 18872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterGetStatusActorState();
		static_cast<ClusterGetStatusActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3713 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			TraceEvent(SevError, "StatusError").error(e);
															#line 3714 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 18909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 3111 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		Optional<WorkerDetails> _mWorker = getWorker(workers, db->get().master.address());
															#line 3112 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (_mWorker.present())
															#line 18925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3113 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			mWorker = _mWorker.get();
															#line 18929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 3115 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages.push_back( JsonString::makeMessage("unreachable_master_worker", "Unable to locate the master worker."));
															#line 18935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3120 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		Optional<WorkerDetails> _ccWorker = getWorker(workers, db->get().clusterInterface.address());
															#line 3121 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (_ccWorker.present())
															#line 18941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3122 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			ccWorker = _ccWorker.get();
															#line 18945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 3124 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages.push_back(JsonString::makeMessage("unreachable_cluster_controller_worker", "Unable to locate the cluster-controller worker."));
															#line 18951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3129 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		Optional<WorkerDetails> _ddWorker;
															#line 3130 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().distributor.present())
															#line 18957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3131 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			_ddWorker = getWorker(workers, db->get().distributor.get().address());
															#line 18961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3134 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!db->get().distributor.present() || !_ddWorker.present())
															#line 18965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3135 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages.push_back(JsonString::makeMessage("unreachable_dataDistributor_worker", "Unable to locate the data distributor worker."));
															#line 18969 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 3138 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			ddWorker = _ddWorker.get();
															#line 18975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3142 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		Optional<WorkerDetails> _rkWorker;
															#line 3143 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 18981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3144 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			_rkWorker = getWorker(workers, db->get().ratekeeper.get().address());
															#line 18985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3147 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!db->get().ratekeeper.present() || !_rkWorker.present())
															#line 18989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3148 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages.push_back( JsonString::makeMessage("unreachable_ratekeeper_worker", "Unable to locate the ratekeeper worker."));
															#line 18993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 3151 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			rkWorker = _rkWorker.get();
															#line 18999 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3155 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		Optional<WorkerDetails> _csWorker;
															#line 3156 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().consistencyScan.present())
															#line 19005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3157 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			_csWorker = getWorker(workers, db->get().consistencyScan.get().address());
															#line 19009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3160 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!db->get().consistencyScan.present() || !_csWorker.present())
															#line 19013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3161 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages.push_back(JsonString::makeMessage("unreachable_consistencyScan_worker", "Unable to locate the consistencyScan worker."));
															#line 19017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 3164 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			csWorker = _csWorker.get();
															#line 19023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3170 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		std::vector<Future<Optional<std::pair<WorkerEvents, std::set<std::string>>>>> futures;
															#line 3171 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		futures.push_back(latestEventOnWorkers(workers, "MachineMetrics"));
															#line 3172 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		futures.push_back(latestEventOnWorkers(workers, "ProcessMetrics"));
															#line 3173 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		futures.push_back(latestEventOnWorkers(workers, "NetworkMetrics"));
															#line 3174 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		futures.push_back(latestErrorOnWorkers(workers));
															#line 3175 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		futures.push_back(latestEventOnWorkers(workers, "TraceFileOpenError"));
															#line 3176 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		futures.push_back(latestEventOnWorkers(workers, "ProgramStart"));
															#line 3179 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>>> __when_expr_1 = getAll(futures);
															#line 3179 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 19043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 2;
															#line 3179 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 1, std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 19048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(KMSHealthStatus const& status,int loopDepth) 
	{
															#line 3087 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject earStatusObj;
															#line 3088 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		earStatusObj["ekp_is_healthy"] = status.canConnectToEKP;
															#line 3089 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["encryption_at_rest"] = earStatusObj;
															#line 3091 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject kmsStatusObj;
															#line 3092 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		kmsStatusObj["kms_is_healthy"] = status.canConnectToKms;
															#line 3093 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (status.canConnectToEKP)
															#line 19067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3094 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			kmsStatusObj["kms_connector_type"] = status.kmsConnectorType;
															#line 3095 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			kmsStatusObj["kms_stable"] = status.kmsStable;
															#line 3096 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderArray kmsUrlsArr;
															#line 3097 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			for( const auto& url : status.restKMSUrls ) {
															#line 3098 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				kmsUrlsArr.push_back(url);
															#line 19079 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 3100 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			kmsStatusObj["kms_urls"] = kmsUrlsArr;
															#line 19083 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3102 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["kms"] = kmsStatusObj;
															#line 3105 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!status.canConnectToKms || !status.canConnectToEKP)
															#line 19089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3106 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<ClusterGetStatusActor*>(this)->SAV<StatusReply>::futures) { (void)(StatusReply(statusObj.getJson())); this->~ClusterGetStatusActorState(); static_cast<ClusterGetStatusActor*>(this)->destroy(); return 0; }
															#line 19093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			new (&static_cast<ClusterGetStatusActor*>(this)->SAV< StatusReply >::value()) StatusReply(StatusReply(statusObj.getJson()));
			this->~ClusterGetStatusActorState();
			static_cast<ClusterGetStatusActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(KMSHealthStatus && status,int loopDepth) 
	{
															#line 3087 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject earStatusObj;
															#line 3088 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		earStatusObj["ekp_is_healthy"] = status.canConnectToEKP;
															#line 3089 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["encryption_at_rest"] = earStatusObj;
															#line 3091 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject kmsStatusObj;
															#line 3092 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		kmsStatusObj["kms_is_healthy"] = status.canConnectToKms;
															#line 3093 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (status.canConnectToEKP)
															#line 19117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3094 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			kmsStatusObj["kms_connector_type"] = status.kmsConnectorType;
															#line 3095 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			kmsStatusObj["kms_stable"] = status.kmsStable;
															#line 3096 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderArray kmsUrlsArr;
															#line 3097 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			for( const auto& url : status.restKMSUrls ) {
															#line 3098 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				kmsUrlsArr.push_back(url);
															#line 19129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 3100 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			kmsStatusObj["kms_urls"] = kmsUrlsArr;
															#line 19133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3102 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["kms"] = kmsStatusObj;
															#line 3105 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!status.canConnectToKms || !status.canConnectToEKP)
															#line 19139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3106 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<ClusterGetStatusActor*>(this)->SAV<StatusReply>::futures) { (void)(StatusReply(statusObj.getJson())); this->~ClusterGetStatusActorState(); static_cast<ClusterGetStatusActor*>(this)->destroy(); return 0; }
															#line 19143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			new (&static_cast<ClusterGetStatusActor*>(this)->SAV< StatusReply >::value()) StatusReply(StatusReply(statusObj.getJson()));
			this->~ClusterGetStatusActorState();
			static_cast<ClusterGetStatusActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(KMSHealthStatus const& status,int loopDepth) 
	{
		loopDepth = a_body1cont3(status, loopDepth);

		return loopDepth;
	}
	int a_body1when1(KMSHealthStatus && status,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state > 0) static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterGetStatusActor*>(this)->ActorCallback< ClusterGetStatusActor, 0, KMSHealthStatus >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 0, KMSHealthStatus >*,KMSHealthStatus const& value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 0, KMSHealthStatus >*,KMSHealthStatus && value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterGetStatusActor, 0, KMSHealthStatus >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 3185 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		std::set<std::string> mergeUnreachable;
															#line 3189 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		for( auto pair : workerEventsVec ) {
															#line 3190 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (pair.present() && !pair.get().second.empty())
															#line 19236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 3191 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				mergeUnreachable.insert(pair.get().second.begin(), pair.get().second.end());
															#line 19240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 3196 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (!mergeUnreachable.empty())
															#line 19245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3197 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject message = JsonBuilder::makeMessage("unreachable_processes", "The cluster has some unreachable processes.");
															#line 3199 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderArray unreachableProcs;
															#line 3200 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			for( auto m : mergeUnreachable ) {
															#line 3201 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				unreachableProcs.push_back(JsonBuilderObject().setKey("address", m));
															#line 19255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 3203 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			message["unreachable_processes"] = unreachableProcs;
															#line 3204 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			messages.push_back(message);
															#line 19261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3207 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<ProtocolVersionData> __when_expr_2 = getNewestProtocolVersion(cx, ccWorker);
															#line 3207 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 19267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont8when1(__when_expr_2.get(), loopDepth); };
		static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 3;
															#line 3207 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 2, ProtocolVersionData >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 19272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> const& __workerEventsVec,int loopDepth) 
	{
															#line 3179 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		workerEventsVec = __workerEventsVec;
															#line 19281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> && __workerEventsVec,int loopDepth) 
	{
		workerEventsVec = std::move(__workerEventsVec);
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state > 0) static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterGetStatusActor*>(this)->ActorCallback< ClusterGetStatusActor, 1, std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 1, std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> >*,std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> const& value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 1, std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> >*,std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> && value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterGetStatusActor, 1, std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont22(int loopDepth) 
	{
															#line 3210 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusCode = (int)RecoveryStatus::END;
															#line 3211 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		recoveryStateStatusFuture = recoveryStateStatusFetcher(cx, ccWorker, mWorker, workers.size(), &status_incomplete_reasons, &statusCode);
															#line 3214 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		idmpKeyStatusFuture = getIdmpKeyStatus(cx);
															#line 3216 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		versionEpochStatusFuture = versionEpochStatusFetcher(cx, &status_incomplete_reasons);
															#line 3219 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll<JsonBuilderObject>( { recoveryStateStatusFuture, idmpKeyStatusFuture, versionEpochStatusFuture });
															#line 3219 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 19370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont22when1(__when_expr_3.get(), loopDepth); };
		static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 4;
															#line 3219 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 3, Void >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 19375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(ProtocolVersionData const& __protocolVersion,int loopDepth) 
	{
															#line 3207 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		protocolVersion = __protocolVersion;
															#line 19384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(ProtocolVersionData && __protocolVersion,int loopDepth) 
	{
		protocolVersion = std::move(__protocolVersion);
		loopDepth = a_body1cont22(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state > 0) static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterGetStatusActor*>(this)->ActorCallback< ClusterGetStatusActor, 2, ProtocolVersionData >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 2, ProtocolVersionData >*,ProtocolVersionData const& value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 2, ProtocolVersionData >*,ProtocolVersionData && value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClusterGetStatusActor, 2, ProtocolVersionData >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont22cont1(Void const& _,int loopDepth) 
	{
															#line 3222 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		recoveryStateStatus = recoveryStateStatusFuture.get();
															#line 3223 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		idmpKeyStatus = idmpKeyStatusFuture.get();
															#line 3224 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		versionEpochStatus = versionEpochStatusFuture.get();
															#line 3227 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		mMetrics = workerEventsVec[0].present() ? workerEventsVec[0].get().first : WorkerEvents();
															#line 3229 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		pMetrics = workerEventsVec[1].present() ? workerEventsVec[1].get().first : WorkerEvents();
															#line 3230 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		networkMetrics = workerEventsVec[2].present() ? workerEventsVec[2].get().first : WorkerEvents();
															#line 3232 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		latestError = workerEventsVec[3].present() ? workerEventsVec[3].get().first : WorkerEvents();
															#line 3233 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		traceFileOpenErrors = workerEventsVec[4].present() ? workerEventsVec[4].get().first : WorkerEvents();
															#line 3235 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		programStarts = workerEventsVec[5].present() ? workerEventsVec[5].get().first : WorkerEvents();
															#line 3238 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().recoveryCount > 0)
															#line 19481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3239 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["generation"] = db->get().recoveryCount;
															#line 19485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3242 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		processIssues = getProcessIssuesAsMessages(workerIssues);
															#line 3244 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		storageServers = std::vector<StorageServerStatusInfo>();
															#line 3245 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tLogs = std::vector<std::pair<TLogInterface, EventMap>>();
															#line 3246 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		commitProxies = std::vector<std::pair<CommitProxyInterface, EventMap>>();
															#line 3247 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		grvProxies = std::vector<std::pair<GrvProxyInterface, EventMap>>();
															#line 3248 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		blobWorkers = std::vector<BlobWorkerInterface>();
															#line 3250 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		qos = JsonBuilderObject();
															#line 3251 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		dataOverlay = JsonBuilderObject();
															#line 3252 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tenants = JsonBuilderObject();
															#line 3253 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		metacluster = JsonBuilderObject();
															#line 3254 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		storageWiggler = JsonBuilderObject();
															#line 3255 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		wiggleServers = std::unordered_set<UID>();
															#line 3257 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["protocol_version"] = format("%" PRIx64, g_network->protocolVersion().version());
															#line 3258 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["connection_string"] = coordinators.ccr->getConnectionString().toString();
															#line 3259 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["bounce_impact"] = getBounceImpactInfo(statusCode);
															#line 3260 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["newest_protocol_version"] = format("%" PRIx64, protocolVersion.newestProtocolVersion.version());
															#line 3261 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["lowest_compatible_protocol_version"] = format("%" PRIx64, protocolVersion.lowestCompatibleProtocolVersion.version());
															#line 3264 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		configuration = Optional<DatabaseConfiguration>();
															#line 3265 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		loadResult = Optional<LoadConfigurationResult>();
															#line 3266 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		address_workers = std::unordered_map<NetworkAddress, WorkerInterface>();
															#line 3268 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (statusCode != RecoveryStatus::configuration_missing)
															#line 19529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3269 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>> __when_expr_4 = loadConfiguration(cx, &messages, &status_incomplete_reasons);
															#line 3269 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 19535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont22cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 5;
															#line 3269 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 4, std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 19540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont22cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont22cont1(Void && _,int loopDepth) 
	{
															#line 3222 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		recoveryStateStatus = recoveryStateStatusFuture.get();
															#line 3223 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		idmpKeyStatus = idmpKeyStatusFuture.get();
															#line 3224 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		versionEpochStatus = versionEpochStatusFuture.get();
															#line 3227 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		mMetrics = workerEventsVec[0].present() ? workerEventsVec[0].get().first : WorkerEvents();
															#line 3229 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		pMetrics = workerEventsVec[1].present() ? workerEventsVec[1].get().first : WorkerEvents();
															#line 3230 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		networkMetrics = workerEventsVec[2].present() ? workerEventsVec[2].get().first : WorkerEvents();
															#line 3232 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		latestError = workerEventsVec[3].present() ? workerEventsVec[3].get().first : WorkerEvents();
															#line 3233 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		traceFileOpenErrors = workerEventsVec[4].present() ? workerEventsVec[4].get().first : WorkerEvents();
															#line 3235 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		programStarts = workerEventsVec[5].present() ? workerEventsVec[5].get().first : WorkerEvents();
															#line 3238 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().recoveryCount > 0)
															#line 19572 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3239 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["generation"] = db->get().recoveryCount;
															#line 19576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		}
															#line 3242 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		processIssues = getProcessIssuesAsMessages(workerIssues);
															#line 3244 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		storageServers = std::vector<StorageServerStatusInfo>();
															#line 3245 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tLogs = std::vector<std::pair<TLogInterface, EventMap>>();
															#line 3246 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		commitProxies = std::vector<std::pair<CommitProxyInterface, EventMap>>();
															#line 3247 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		grvProxies = std::vector<std::pair<GrvProxyInterface, EventMap>>();
															#line 3248 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		blobWorkers = std::vector<BlobWorkerInterface>();
															#line 3250 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		qos = JsonBuilderObject();
															#line 3251 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		dataOverlay = JsonBuilderObject();
															#line 3252 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		tenants = JsonBuilderObject();
															#line 3253 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		metacluster = JsonBuilderObject();
															#line 3254 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		storageWiggler = JsonBuilderObject();
															#line 3255 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		wiggleServers = std::unordered_set<UID>();
															#line 3257 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["protocol_version"] = format("%" PRIx64, g_network->protocolVersion().version());
															#line 3258 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["connection_string"] = coordinators.ccr->getConnectionString().toString();
															#line 3259 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["bounce_impact"] = getBounceImpactInfo(statusCode);
															#line 3260 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["newest_protocol_version"] = format("%" PRIx64, protocolVersion.newestProtocolVersion.version());
															#line 3261 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["lowest_compatible_protocol_version"] = format("%" PRIx64, protocolVersion.lowestCompatibleProtocolVersion.version());
															#line 3264 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		configuration = Optional<DatabaseConfiguration>();
															#line 3265 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		loadResult = Optional<LoadConfigurationResult>();
															#line 3266 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		address_workers = std::unordered_map<NetworkAddress, WorkerInterface>();
															#line 3268 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (statusCode != RecoveryStatus::configuration_missing)
															#line 19620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3269 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>> __when_expr_4 = loadConfiguration(cx, &messages, &status_incomplete_reasons);
															#line 3269 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 19626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont22cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 5;
															#line 3269 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 4, std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 19631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont22cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont22when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont22cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont22when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont22cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state > 0) static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterGetStatusActor*>(this)->ActorCallback< ClusterGetStatusActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont22when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont22when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClusterGetStatusActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont22cont2(int loopDepth) 
	{
															#line 3275 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (loadResult.present())
															#line 19720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3276 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["full_replication"] = loadResult.get().fullReplication;
															#line 3277 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (loadResult.get().healthyZone.present())
															#line 19726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 3278 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				if (loadResult.get().healthyZone.get() != ignoreSSFailuresZoneString)
															#line 19730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				{
															#line 3279 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["maintenance_zone"] = loadResult.get().healthyZone.get().printable();
															#line 3280 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["maintenance_seconds_remaining"] = loadResult.get().healthyZoneSeconds;
															#line 19736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
				else
				{
															#line 3282 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["data_distribution_disabled_for_ss_failures"] = true;
															#line 19742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 3285 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (loadResult.get().rebalanceDDIgnored)
															#line 19747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 3287 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["data_distribution_disabled_for_rebalance"] = true;
															#line 3288 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["data_distribution_disabled_hex"] = loadResult.get().rebalanceDDIgnoreHex;
															#line 19753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
															#line 3290 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (loadResult.get().dataDistributionDisabled)
															#line 19757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			{
															#line 3291 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["data_distribution_disabled"] = true;
															#line 19761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 3295 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["machines"] = machineStatusFetcher(mMetrics, workers, configuration, &status_incomplete_reasons);
															#line 3297 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		coordinatorAddresses = std::vector<NetworkAddress>();
															#line 3298 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		if (configuration.present())
															#line 19770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		{
															#line 3300 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			isAvailable = true;
															#line 3301 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<JsonBuilderObject> __when_expr_5 = latencyProbeFetcher(cx, &messages, &status_incomplete_reasons, &isAvailable);
															#line 3301 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 19778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont22cont2when1(__when_expr_5.get(), loopDepth); };
			static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 6;
															#line 3301 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 5, JsonBuilderObject >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 19783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 3543 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject layers;
															#line 3544 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			layers["_valid"] = false;
															#line 3545 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			layers["_error"] = "configurationMissing";
															#line 3546 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["layers"] = layers;
															#line 19796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont22cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont22cont4(std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> const& loadResults,int loopDepth) 
	{
															#line 3271 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		configuration = loadResults.first;
															#line 3272 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		loadResult = loadResults.second;
															#line 19808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont22cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont22cont4(std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> && loadResults,int loopDepth) 
	{
															#line 3271 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		configuration = loadResults.first;
															#line 3272 "/Users/ec2-user/foundationdb/fdbserver/Status.actor.cpp"
		loadResult = loadResults.second;
															#line 19819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont22cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont22cont1when1(std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> const& loadResults,int loopDepth) 
	{
		loopDepth = a_body1cont22cont4(loadResults, loopDepth);

		return loopDepth;
	}
	int a_body1cont22cont1when1(std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> && loadResults,int loopDepth) 
	{
		loopDepth = a_body1cont22cont4(std::move(loadResults), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state > 0) static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterGetStatusActor*>(this)->ActorCallback< ClusterGetStatusActor, 4, std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 4, std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >*,std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> const& value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont22cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 4, std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >*,std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> && value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont22cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ClusterGetStatusActor, 4, std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error,