#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
/*
 * RestoreWorker.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <ctime>
#include <climits>
#include <numeric>
#include <algorithm>
#include <boost/algorithm/string/split.hpp>
#include <boost/algorithm/string/classification.hpp>

#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/MutationList.h"
#include "fdbclient/BackupContainer.h"
#include "flow/ApiVersion.h"
#include "flow/IAsyncFile.h"
#include "fdbrpc/simulator.h"
#include "flow/genericactors.actor.h"
#include "flow/Hash3.h"
#include "flow/ActorCollection.h"
#include "fdbserver/RestoreWorker.actor.h"
#include "fdbserver/RestoreController.actor.h"
#include "fdbrpc/SimulatorProcessInfo.h"

#include "flow/actorcompiler.h" // This must be the last #include.

class RestoreConfigFR;
struct RestoreWorkerData; // Only declare the struct exist but we cannot use its field

															#line 51 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
[[nodiscard]] Future<Void> handlerTerminateWorkerRequest( RestoreSimpleRequest const& req, Reference<RestoreWorkerData> const& self, RestoreWorkerInterface const& workerInterf, Database const& cx );

#line 53 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 55 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
[[nodiscard]] Future<Void> monitorWorkerLiveness( Reference<RestoreWorkerData> const& self );

#line 54 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
void handleRecruitRoleRequest(RestoreRecruitRoleRequest req,
                              Reference<RestoreWorkerData> self,
                              ActorCollection* actors,
                              Database cx);
															#line 63 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
[[nodiscard]] Future<Void> collectRestoreWorkerInterface( Reference<RestoreWorkerData> const& self, Database const& cx, int const& min_num_workers = 2 );

#line 61 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 67 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
[[nodiscard]] Future<Void> monitorleader( Reference<AsyncVar<RestoreWorkerInterface>> const& leader, Database const& cx, RestoreWorkerInterface const& myWorkerInterf );

#line 64 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 71 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
[[nodiscard]] Future<Void> startRestoreWorkerLeader( Reference<RestoreWorkerData> const& self, RestoreWorkerInterface const& workerInterf, Database const& cx );

#line 67 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"

// Remove the worker interface from restoreWorkerKey and remove its roles interfaces from their keys.
															#line 77 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via handlerTerminateWorkerRequest()
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class HandlerTerminateWorkerRequestActor>
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class HandlerTerminateWorkerRequestActorState {
															#line 84 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	HandlerTerminateWorkerRequestActorState(RestoreSimpleRequest const& req,Reference<RestoreWorkerData> const& self,RestoreWorkerInterface const& workerInterf,Database const& cx) 
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : req(req),
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   self(self),
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   workerInterf(workerInterf),
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   cx(cx)
															#line 97 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this));

	}
	~HandlerTerminateWorkerRequestActorState() 
	{
		fdb_probe_actor_destroy("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); tr->setOption(FDBTransactionOptions::LOCK_AWARE); tr->clear(restoreWorkerKeyFor(workerInterf.id())); return Void(); });
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<HandlerTerminateWorkerRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HandlerTerminateWorkerRequestActor*>(this)->actor_wait_state = 1;
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >*>(static_cast<HandlerTerminateWorkerRequestActor*>(this)));
															#line 119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandlerTerminateWorkerRequestActorState();
		static_cast<HandlerTerminateWorkerRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker").detail("HandleTerminateWorkerReq", self->id());
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<HandlerTerminateWorkerRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandlerTerminateWorkerRequestActorState(); static_cast<HandlerTerminateWorkerRequestActor*>(this)->destroy(); return 0; }
															#line 144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		new (&static_cast<HandlerTerminateWorkerRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandlerTerminateWorkerRequestActorState();
		static_cast<HandlerTerminateWorkerRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker").detail("HandleTerminateWorkerReq", self->id());
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<HandlerTerminateWorkerRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandlerTerminateWorkerRequestActorState(); static_cast<HandlerTerminateWorkerRequestActor*>(this)->destroy(); return 0; }
															#line 158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		new (&static_cast<HandlerTerminateWorkerRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandlerTerminateWorkerRequestActorState();
		static_cast<HandlerTerminateWorkerRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandlerTerminateWorkerRequestActor*>(this)->actor_wait_state > 0) static_cast<HandlerTerminateWorkerRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandlerTerminateWorkerRequestActor*>(this)->ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandlerTerminateWorkerRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandlerTerminateWorkerRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandlerTerminateWorkerRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreSimpleRequest req;
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<RestoreWorkerData> self;
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerInterface workerInterf;
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Database cx;
															#line 249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
};
// This generated class is to be used only via handlerTerminateWorkerRequest()
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class HandlerTerminateWorkerRequestActor final : public Actor<Void>, public ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >, public FastAllocated<HandlerTerminateWorkerRequestActor>, public HandlerTerminateWorkerRequestActorState<HandlerTerminateWorkerRequestActor> {
															#line 254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
	using FastAllocated<HandlerTerminateWorkerRequestActor>::operator new;
	using FastAllocated<HandlerTerminateWorkerRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1125685705307770112UL, 1085111201961629952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >;
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	HandlerTerminateWorkerRequestActor(RestoreSimpleRequest const& req,Reference<RestoreWorkerData> const& self,RestoreWorkerInterface const& workerInterf,Database const& cx) 
															#line 271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		 : Actor<Void>(),
		   HandlerTerminateWorkerRequestActorState<HandlerTerminateWorkerRequestActor>(req, self, workerInterf, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10091636684208773632UL, 5530680396984554496UL);
		ActorExecutionContextHelper __helper(static_cast<HandlerTerminateWorkerRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handlerTerminateWorkerRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> handlerTerminateWorkerRequest( RestoreSimpleRequest const& req, Reference<RestoreWorkerData> const& self, RestoreWorkerInterface const& workerInterf, Database const& cx ) {
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new HandlerTerminateWorkerRequestActor(req, self, workerInterf, cx));
															#line 304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
}

#line 84 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"

// Assume only 1 role on a restore worker.
// Future: Multiple roles in a restore worker
void handleRecruitRoleRequest(RestoreRecruitRoleRequest req,
                              Reference<RestoreWorkerData> self,
                              ActorCollection* actors,
                              Database cx) {
	// Future: Allow multiple restore roles on a restore worker. The design should easily allow this.
	ASSERT(!self->loaderInterf.present() || !self->applierInterf.present()); // Only one role per worker for now
	// Already recruited a role
	if (self->loaderInterf.present()) {
		ASSERT(req.role == RestoreRole::Loader);
		req.reply.send(RestoreRecruitRoleReply(self->id(), RestoreRole::Loader, self->loaderInterf.get()));
		return;
	} else if (self->applierInterf.present()) {
		req.reply.send(RestoreRecruitRoleReply(self->id(), RestoreRole::Applier, self->applierInterf.get()));
		return;
	}

	if (req.role == RestoreRole::Loader) {
		ASSERT(!self->loaderInterf.present());
		self->controllerInterf = req.ci;
		self->loaderInterf = RestoreLoaderInterface();
		self->loaderInterf.get().initEndpoints();
		RestoreLoaderInterface& recruited = self->loaderInterf.get();
		DUMPTOKEN(recruited.heartbeat);
		DUMPTOKEN(recruited.updateRestoreSysInfo);
		DUMPTOKEN(recruited.initVersionBatch);
		DUMPTOKEN(recruited.loadFile);
		DUMPTOKEN(recruited.sendMutations);
		DUMPTOKEN(recruited.initVersionBatch);
		DUMPTOKEN(recruited.finishVersionBatch);
		DUMPTOKEN(recruited.collectRestoreRoleInterfaces);
		DUMPTOKEN(recruited.finishRestore);
		actors->add(restoreLoaderCore(self->loaderInterf.get(), req.nodeIndex, cx, req.ci));
		TraceEvent("FastRestoreWorker").detail("RecruitedLoaderNodeIndex", req.nodeIndex);
		req.reply.send(
		    RestoreRecruitRoleReply(self->loaderInterf.get().id(), RestoreRole::Loader, self->loaderInterf.get()));
	} else if (req.role == RestoreRole::Applier) {
		ASSERT(!self->applierInterf.present());
		self->controllerInterf = req.ci;
		self->applierInterf = RestoreApplierInterface();
		self->applierInterf.get().initEndpoints();
		RestoreApplierInterface& recruited = self->applierInterf.get();
		DUMPTOKEN(recruited.heartbeat);
		DUMPTOKEN(recruited.sendMutationVector);
		DUMPTOKEN(recruited.applyToDB);
		DUMPTOKEN(recruited.initVersionBatch);
		DUMPTOKEN(recruited.collectRestoreRoleInterfaces);
		DUMPTOKEN(recruited.finishRestore);
		actors->add(restoreApplierCore(self->applierInterf.get(), req.nodeIndex, cx));
		TraceEvent("FastRestoreWorker").detail("RecruitedApplierNodeIndex", req.nodeIndex);
		req.reply.send(
		    RestoreRecruitRoleReply(self->applierInterf.get().id(), RestoreRole::Applier, self->applierInterf.get()));
	} else {
		TraceEvent(SevError, "FastRestoreWorkerHandleRecruitRoleRequestUnknownRole").detail("Request", req.toString());
	}

	return;
}

// Read restoreWorkersKeys from DB to get each restore worker's workerInterface and set it to self->workerInterfaces;
// This is done before we assign restore roles for restore workers.
															#line 371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via collectRestoreWorkerInterface()
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class CollectRestoreWorkerInterfaceActor>
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class CollectRestoreWorkerInterfaceActorState {
															#line 378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	CollectRestoreWorkerInterfaceActorState(Reference<RestoreWorkerData> const& self,Database const& cx,int const& min_num_workers) 
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : self(self),
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   cx(cx),
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   min_num_workers(min_num_workers),
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   tr(cx),
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   agents()
															#line 393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this));

	}
	~CollectRestoreWorkerInterfaceActorState() 
	{
		fdb_probe_actor_destroy("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			;
															#line 408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CollectRestoreWorkerInterfaceActorState();
		static_cast<CollectRestoreWorkerInterfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		ASSERT(agents.size() >= min_num_workers);
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker").detail("CollectWorkerInterfaceNumWorkers", self->workerInterfaces.size());
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<CollectRestoreWorkerInterfaceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CollectRestoreWorkerInterfaceActorState(); static_cast<CollectRestoreWorkerInterfaceActor*>(this)->destroy(); return 0; }
															#line 435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		new (&static_cast<CollectRestoreWorkerInterfaceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CollectRestoreWorkerInterfaceActorState();
		static_cast<CollectRestoreWorkerInterfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			self->workerInterfaces.clear();
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			agents.clear();
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.reset();
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(restoreWorkersKeys, CLIENT_KNOBS->TOO_MANY);
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state = 1;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >*>(static_cast<CollectRestoreWorkerInterfaceActor*>(this)));
															#line 472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state = 3;
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >*>(static_cast<CollectRestoreWorkerInterfaceActor*>(this)));
															#line 514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& agentValues,int loopDepth) 
	{
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		ASSERT(!agentValues.more);
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (agentValues.size() >= min_num_workers)
															#line 531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		{
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			for( auto& it : agentValues ) {
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				agents.push_back(BinaryReader::fromStringRef<RestoreWorkerInterface>(it.value, IncludeVersion()));
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				self->workerInterfaces.insert(std::make_pair(agents.back().id(), agents.back()));
															#line 539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			}
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker") .suppressFor(10.0) .detail("NotEnoughWorkers", agentValues.size()) .detail("MinWorkers", min_num_workers);
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state = 2;
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >*>(static_cast<CollectRestoreWorkerInterfaceActor*>(this)));
															#line 554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && agentValues,int loopDepth) 
	{
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		ASSERT(!agentValues.more);
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (agentValues.size() >= min_num_workers)
															#line 565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		{
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			for( auto& it : agentValues ) {
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				agents.push_back(BinaryReader::fromStringRef<RestoreWorkerInterface>(it.value, IncludeVersion()));
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				self->workerInterfaces.insert(std::make_pair(agents.back().id(), agents.back()));
															#line 573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			}
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker") .suppressFor(10.0) .detail("NotEnoughWorkers", agentValues.size()) .detail("MinWorkers", min_num_workers);
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state = 2;
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >*>(static_cast<CollectRestoreWorkerInterfaceActor*>(this)));
															#line 588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& agentValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(agentValues, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && agentValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(agentValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state > 0) static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<CollectRestoreWorkerInterfaceActor*>(this)->ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state > 0) static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<CollectRestoreWorkerInterfaceActor*>(this)->ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state > 0) static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<CollectRestoreWorkerInterfaceActor*>(this)->ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<RestoreWorkerData> self;
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Database cx;
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	int min_num_workers;
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Transaction tr;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	std::vector<RestoreWorkerInterface> agents;
															#line 865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
};
// This generated class is to be used only via collectRestoreWorkerInterface()
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class CollectRestoreWorkerInterfaceActor final : public Actor<Void>, public ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >, public ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >, public ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >, public FastAllocated<CollectRestoreWorkerInterfaceActor>, public CollectRestoreWorkerInterfaceActorState<CollectRestoreWorkerInterfaceActor> {
															#line 870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
	using FastAllocated<CollectRestoreWorkerInterfaceActor>::operator new;
	using FastAllocated<CollectRestoreWorkerInterfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12195508936199326720UL, 6110529681716299776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >;
friend struct ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >;
friend struct ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >;
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	CollectRestoreWorkerInterfaceActor(Reference<RestoreWorkerData> const& self,Database const& cx,int const& min_num_workers) 
															#line 889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		 : Actor<Void>(),
		   CollectRestoreWorkerInterfaceActorState<CollectRestoreWorkerInterfaceActor>(self, cx, min_num_workers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7649045598728601600UL, 11728192798239088128UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("collectRestoreWorkerInterface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> collectRestoreWorkerInterface( Reference<RestoreWorkerData> const& self, Database const& cx, int const& min_num_workers ) {
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new CollectRestoreWorkerInterfaceActor(self, cx, min_num_workers));
															#line 924 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
}

#line 185 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"

// Periodically send worker heartbeat to
															#line 930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorWorkerLiveness()
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class MonitorWorkerLivenessActor>
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class MonitorWorkerLivenessActorState {
															#line 937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	MonitorWorkerLivenessActorState(Reference<RestoreWorkerData> const& self) 
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : self(self)
															#line 944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this));

	}
	~MonitorWorkerLivenessActorState() 
	{
		fdb_probe_actor_destroy("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			ASSERT(!self->workerInterfaces.empty());
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			workerInterf = std::map<UID, RestoreWorkerInterface>::iterator();
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			;
															#line 963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorWorkerLivenessActorState();
		static_cast<MonitorWorkerLivenessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		std::vector<std::pair<UID, RestoreSimpleRequest>> requests;
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		for( auto& worker : self->workerInterfaces ) {
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			requests.emplace_back(worker.first, RestoreSimpleRequest());
															#line 997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		}
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = sendBatchRequests(&RestoreWorkerInterface::heartbeat, self->workerInterfaces, requests);
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state = 1;
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerLivenessActor, 0, Void >*>(static_cast<MonitorWorkerLivenessActor*>(this)));
															#line 1008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(60.0);
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state = 2;
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerLivenessActor, 1, Void >*>(static_cast<MonitorWorkerLivenessActor*>(this)));
															#line 1024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(60.0);
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state = 2;
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerLivenessActor, 1, Void >*>(static_cast<MonitorWorkerLivenessActor*>(this)));
															#line 1040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state > 0) static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorWorkerLivenessActor*>(this)->ActorCallback< MonitorWorkerLivenessActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorWorkerLivenessActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorWorkerLivenessActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorWorkerLivenessActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state > 0) static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorWorkerLivenessActor*>(this)->ActorCallback< MonitorWorkerLivenessActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorWorkerLivenessActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorWorkerLivenessActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorWorkerLivenessActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<RestoreWorkerData> self;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	std::map<UID, RestoreWorkerInterface>::iterator workerInterf;
															#line 1211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
};
// This generated class is to be used only via monitorWorkerLiveness()
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class MonitorWorkerLivenessActor final : public Actor<Void>, public ActorCallback< MonitorWorkerLivenessActor, 0, Void >, public ActorCallback< MonitorWorkerLivenessActor, 1, Void >, public FastAllocated<MonitorWorkerLivenessActor>, public MonitorWorkerLivenessActorState<MonitorWorkerLivenessActor> {
															#line 1216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
	using FastAllocated<MonitorWorkerLivenessActor>::operator new;
	using FastAllocated<MonitorWorkerLivenessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10535538984295822848UL, 4152984013463351296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorWorkerLivenessActor, 0, Void >;
friend struct ActorCallback< MonitorWorkerLivenessActor, 1, Void >;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	MonitorWorkerLivenessActor(Reference<RestoreWorkerData> const& self) 
															#line 1234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorWorkerLivenessActorState<MonitorWorkerLivenessActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4274100538724903424UL, 2910315914700105216UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorWorkerLiveness");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorWorkerLivenessActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorWorkerLivenessActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> monitorWorkerLiveness( Reference<RestoreWorkerData> const& self ) {
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new MonitorWorkerLivenessActor(self));
															#line 1268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
}

#line 200 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"

// RestoreWorkerLeader is the worker that runs RestoreController role
															#line 1274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via startRestoreWorkerLeader()
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class StartRestoreWorkerLeaderActor>
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class StartRestoreWorkerLeaderActorState {
															#line 1281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	StartRestoreWorkerLeaderActorState(Reference<RestoreWorkerData> const& self,RestoreWorkerInterface const& workerInterf,Database const& cx) 
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : self(self),
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   workerInterf(workerInterf),
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   cx(cx)
															#line 1292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this));

	}
	~StartRestoreWorkerLeaderActorState() 
	{
		fdb_probe_actor_destroy("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent("FastRestoreWorker") .detail("Controller", workerInterf.id()) .detail("WaitForRestoreWorkerInterfaces", SERVER_KNOBS->FASTRESTORE_NUM_LOADERS + SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS);
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(10.0);
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 1;
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >*>(static_cast<StartRestoreWorkerLeaderActor*>(this)));
															#line 1316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartRestoreWorkerLeaderActorState();
		static_cast<StartRestoreWorkerLeaderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker") .detail("Controller", workerInterf.id()) .detail("CollectRestoreWorkerInterfaces", SERVER_KNOBS->FASTRESTORE_NUM_LOADERS + SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS);
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = collectRestoreWorkerInterface( self, cx, SERVER_KNOBS->FASTRESTORE_NUM_LOADERS + SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS);
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 2;
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >*>(static_cast<StartRestoreWorkerLeaderActor*>(this)));
															#line 1348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker") .detail("Controller", workerInterf.id()) .detail("CollectRestoreWorkerInterfaces", SERVER_KNOBS->FASTRESTORE_NUM_LOADERS + SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS);
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = collectRestoreWorkerInterface( self, cx, SERVER_KNOBS->FASTRESTORE_NUM_LOADERS + SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS);
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 2;
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >*>(static_cast<StartRestoreWorkerLeaderActor*>(this)));
															#line 1366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state > 0) static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 0;
		static_cast<StartRestoreWorkerLeaderActor*>(this)->ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		workersFailureMonitor = monitorWorkerLiveness(self);
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		RestoreControllerInterface recruited;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		DUMPTOKEN(recruited.samples);
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		self->controllerInterf = recruited;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = startRestoreController(self, cx) || workersFailureMonitor;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 3;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >*>(static_cast<StartRestoreWorkerLeaderActor*>(this)));
															#line 1465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		workersFailureMonitor = monitorWorkerLiveness(self);
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		RestoreControllerInterface recruited;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		DUMPTOKEN(recruited.samples);
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		self->controllerInterf = recruited;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = startRestoreController(self, cx) || workersFailureMonitor;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 3;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >*>(static_cast<StartRestoreWorkerLeaderActor*>(this)));
															#line 1489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state > 0) static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 0;
		static_cast<StartRestoreWorkerLeaderActor*>(this)->ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<StartRestoreWorkerLeaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRestoreWorkerLeaderActorState(); static_cast<StartRestoreWorkerLeaderActor*>(this)->destroy(); return 0; }
															#line 1573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		new (&static_cast<StartRestoreWorkerLeaderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartRestoreWorkerLeaderActorState();
		static_cast<StartRestoreWorkerLeaderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<StartRestoreWorkerLeaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRestoreWorkerLeaderActorState(); static_cast<StartRestoreWorkerLeaderActor*>(this)->destroy(); return 0; }
															#line 1585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		new (&static_cast<StartRestoreWorkerLeaderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartRestoreWorkerLeaderActorState();
		static_cast<StartRestoreWorkerLeaderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state > 0) static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 0;
		static_cast<StartRestoreWorkerLeaderActor*>(this)->ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<RestoreWorkerData> self;
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerInterface workerInterf;
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Database cx;
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Future<Void> workersFailureMonitor;
															#line 1676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
};
// This generated class is to be used only via startRestoreWorkerLeader()
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class StartRestoreWorkerLeaderActor final : public Actor<Void>, public ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >, public ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >, public ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >, public FastAllocated<StartRestoreWorkerLeaderActor>, public StartRestoreWorkerLeaderActorState<StartRestoreWorkerLeaderActor> {
															#line 1681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
	using FastAllocated<StartRestoreWorkerLeaderActor>::operator new;
	using FastAllocated<StartRestoreWorkerLeaderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8919452039254449664UL, 5257222019018652160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >;
friend struct ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >;
friend struct ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >;
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	StartRestoreWorkerLeaderActor(Reference<RestoreWorkerData> const& self,RestoreWorkerInterface const& workerInterf,Database const& cx) 
															#line 1700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		 : Actor<Void>(),
		   StartRestoreWorkerLeaderActorState<StartRestoreWorkerLeaderActor>(self, workerInterf, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1672439484283100672UL, 10893048632981829376UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startRestoreWorkerLeader");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> startRestoreWorkerLeader( Reference<RestoreWorkerData> const& self, RestoreWorkerInterface const& workerInterf, Database const& cx ) {
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new StartRestoreWorkerLeaderActor(self, workerInterf, cx));
															#line 1735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
}

#line 230 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"

															#line 1740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via startRestoreWorker()
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class StartRestoreWorkerActor>
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class StartRestoreWorkerActorState {
															#line 1747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	StartRestoreWorkerActorState(Reference<RestoreWorkerData> const& self,RestoreWorkerInterface const& interf,Database const& cx) 
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : self(self),
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   interf(interf),
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   cx(cx),
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   lastLoopTopTime(now()),
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   actors(false),
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   exitRole(Never())
															#line 1764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("startRestoreWorker", reinterpret_cast<unsigned long>(this));

	}
	~StartRestoreWorkerActorState() 
	{
		fdb_probe_actor_destroy("startRestoreWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			;
															#line 1779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartRestoreWorkerActorState();
		static_cast<StartRestoreWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<StartRestoreWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRestoreWorkerActorState(); static_cast<StartRestoreWorkerActor*>(this)->destroy(); return 0; }
															#line 1802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		new (&static_cast<StartRestoreWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartRestoreWorkerActorState();
		static_cast<StartRestoreWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		double loopTopTime = now();
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		double elapsedTime = loopTopTime - lastLoopTopTime;
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (elapsedTime > 0.050)
															#line 1825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		{
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (deterministicRandom()->random01() < 0.01)
															#line 1829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			{
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				TraceEvent(SevWarn, "SlowRestoreWorkerLoopx100") .detail("NodeDesc", self->describeNode()) .detail("Elapsed", elapsedTime);
															#line 1833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			}
		}
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		lastLoopTopTime = loopTopTime;
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		requestTypeStr = "[Init]";
															#line 1840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		try {
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			FutureStream<RestoreSimpleRequest> __when_expr_0 = interf.heartbeat.getFuture();
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<StartRestoreWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			FutureStream<RestoreRecruitRoleRequest> __when_expr_1 = interf.recruitRole.getFuture();
															#line 1850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			FutureStream<RestoreSimpleRequest> __when_expr_2 = interf.terminateWorker.getFuture();
															#line 1854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = exitRole;
															#line 1858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
			static_cast<StartRestoreWorkerActor*>(this)->actor_wait_state = 1;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >*>(static_cast<StartRestoreWorkerActor*>(this)));
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< StartRestoreWorkerActor, 1, RestoreRecruitRoleRequest >*>(static_cast<StartRestoreWorkerActor*>(this)));
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< StartRestoreWorkerActor, 2, RestoreSimpleRequest >*>(static_cast<StartRestoreWorkerActor*>(this)));
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartRestoreWorkerActor, 3, Void >*>(static_cast<StartRestoreWorkerActor*>(this)));
															#line 1869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent(SevWarn, "FastRestoreWorkerError").errorUnsuppressed(e).detail("RequestType", requestTypeStr);
															#line 1904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RestoreSimpleRequest const& req,int loopDepth) 
	{
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		requestTypeStr = "heartbeat";
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		actors.add(handleHeartbeat(req, interf.id()));
															#line 1927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RestoreSimpleRequest && req,int loopDepth) 
	{
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		requestTypeStr = "heartbeat";
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		actors.add(handleHeartbeat(req, interf.id()));
															#line 1938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(RestoreRecruitRoleRequest const& req,int loopDepth) 
	{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		requestTypeStr = "recruitRole";
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		handleRecruitRoleRequest(req, self, &actors, cx);
															#line 1949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(RestoreRecruitRoleRequest && req,int loopDepth) 
	{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		requestTypeStr = "recruitRole";
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		handleRecruitRoleRequest(req, self, &actors, cx);
															#line 1960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(RestoreSimpleRequest const& req,int loopDepth) 
	{
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		requestTypeStr = "terminateWorker";
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		exitRole = handlerTerminateWorkerRequest(req, self, interf, cx);
															#line 1971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(RestoreSimpleRequest && req,int loopDepth) 
	{
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		requestTypeStr = "terminateWorker";
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		exitRole = handlerTerminateWorkerRequest(req, self, interf, cx);
															#line 1982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void const& _,int loopDepth) 
	{
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorkerCoreExitRole", self->id());
															#line 1991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when4(Void && _,int loopDepth) 
	{
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorkerCoreExitRole", self->id());
															#line 2000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartRestoreWorkerActor*>(this)->actor_wait_state > 0) static_cast<StartRestoreWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<StartRestoreWorkerActor*>(this)->ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >::remove();
		static_cast<StartRestoreWorkerActor*>(this)->ActorSingleCallback< StartRestoreWorkerActor, 1, RestoreRecruitRoleRequest >::remove();
		static_cast<StartRestoreWorkerActor*>(this)->ActorSingleCallback< StartRestoreWorkerActor, 2, RestoreSimpleRequest >::remove();
		static_cast<StartRestoreWorkerActor*>(this)->ActorCallback< StartRestoreWorkerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >*,RestoreSimpleRequest const& value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >*,RestoreSimpleRequest && value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< StartRestoreWorkerActor, 1, RestoreRecruitRoleRequest >*,RestoreRecruitRoleRequest const& value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< StartRestoreWorkerActor, 1, RestoreRecruitRoleRequest >*,RestoreRecruitRoleRequest && value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< StartRestoreWorkerActor, 1, RestoreRecruitRoleRequest >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< StartRestoreWorkerActor, 2, RestoreSimpleRequest >*,RestoreSimpleRequest const& value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< StartRestoreWorkerActor, 2, RestoreSimpleRequest >*,RestoreSimpleRequest && value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< StartRestoreWorkerActor, 2, RestoreSimpleRequest >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartRestoreWorkerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<RestoreWorkerData> self;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerInterface interf;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Database cx;
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	double lastLoopTopTime;
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	ActorCollection actors;
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Future<Void> exitRole;
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	std::string requestTypeStr;
															#line 2269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
};
// This generated class is to be used only via startRestoreWorker()
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class StartRestoreWorkerActor final : public Actor<Void>, public ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >, public ActorSingleCallback< StartRestoreWorkerActor, 1, RestoreRecruitRoleRequest >, public ActorSingleCallback< StartRestoreWorkerActor, 2, RestoreSimpleRequest >, public ActorCallback< StartRestoreWorkerActor, 3, Void >, public FastAllocated<StartRestoreWorkerActor>, public StartRestoreWorkerActorState<StartRestoreWorkerActor> {
															#line 2274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
	using FastAllocated<StartRestoreWorkerActor>::operator new;
	using FastAllocated<StartRestoreWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10481400081993086208UL, 844642554160052992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >;
friend struct ActorSingleCallback< StartRestoreWorkerActor, 1, RestoreRecruitRoleRequest >;
friend struct ActorSingleCallback< StartRestoreWorkerActor, 2, RestoreSimpleRequest >;
friend struct ActorCallback< StartRestoreWorkerActor, 3, Void >;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	StartRestoreWorkerActor(Reference<RestoreWorkerData> const& self,RestoreWorkerInterface const& interf,Database const& cx) 
															#line 2294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		 : Actor<Void>(),
		   StartRestoreWorkerActorState<StartRestoreWorkerActor>(self, interf, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15207208409390668800UL, 15937872900465846272UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startRestoreWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> startRestoreWorker( Reference<RestoreWorkerData> const& self, RestoreWorkerInterface const& interf, Database const& cx ) {
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new StartRestoreWorkerActor(self, interf, cx));
															#line 2327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
}

#line 276 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"

															#line 2332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via waitOnRestoreRequests()
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class WaitOnRestoreRequestsActor>
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class WaitOnRestoreRequestsActorState {
															#line 2339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	WaitOnRestoreRequestsActorState(Database const& cx,UID const& nodeID = UID()) 
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : cx(cx),
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   nodeID(nodeID),
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   tr(cx),
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   numRequests()
															#line 2352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this));

	}
	~WaitOnRestoreRequestsActorState() 
	{
		fdb_probe_actor_destroy("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent("FastRestoreWaitOnRestoreRequest", nodeID).log();
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			;
															#line 2369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitOnRestoreRequestsActorState();
		static_cast<WaitOnRestoreRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<WaitOnRestoreRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitOnRestoreRequestsActorState(); static_cast<WaitOnRestoreRequestsActor*>(this)->destroy(); return 0; }
															#line 2392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		new (&static_cast<WaitOnRestoreRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitOnRestoreRequestsActorState();
		static_cast<WaitOnRestoreRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.reset();
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(restoreRequestTriggerKey);
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 1;
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >*>(static_cast<WaitOnRestoreRequestsActor*>(this)));
															#line 2425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 4;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitOnRestoreRequestsActor, 3, Void >*>(static_cast<WaitOnRestoreRequestsActor*>(this)));
															#line 2467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& _numRequests,int loopDepth) 
	{
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		numRequests = _numRequests;
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!numRequests.present())
															#line 2484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		{
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			watchForRestoreRequest = tr.watch(restoreRequestTriggerKey);
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 2;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitOnRestoreRequestsActor, 1, Void >*>(static_cast<WaitOnRestoreRequestsActor*>(this)));
															#line 2497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent(SevInfo, "FastRestoreRestoreRequestTriggerKey", nodeID) .detail("TriggerKey", numRequests.get().toString());
															#line 2504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && _numRequests,int loopDepth) 
	{
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		numRequests = _numRequests;
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!numRequests.present())
															#line 2516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		{
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			watchForRestoreRequest = tr.watch(restoreRequestTriggerKey);
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 2;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitOnRestoreRequestsActor, 1, Void >*>(static_cast<WaitOnRestoreRequestsActor*>(this)));
															#line 2529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent(SevInfo, "FastRestoreRestoreRequestTriggerKey", nodeID) .detail("TriggerKey", numRequests.get().toString());
															#line 2536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& _numRequests,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_numRequests, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && _numRequests,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_numRequests), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOnRestoreRequestsActor*>(this)->ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent(SevInfo, "FastRestoreWaitOnRestoreRequestTriggerKey", nodeID).log();
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchForRestoreRequest;
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 3;
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitOnRestoreRequestsActor, 2, Void >*>(static_cast<WaitOnRestoreRequestsActor*>(this)));
															#line 2636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent(SevInfo, "FastRestoreWaitOnRestoreRequestTriggerKey", nodeID).log();
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchForRestoreRequest;
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 3;
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitOnRestoreRequestsActor, 2, Void >*>(static_cast<WaitOnRestoreRequestsActor*>(this)));
															#line 2654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOnRestoreRequestsActor*>(this)->ActorCallback< WaitOnRestoreRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitOnRestoreRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent(SevInfo, "FastRestoreDetectRestoreRequestTriggerKeyChanged", nodeID).log();
															#line 2738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent(SevInfo, "FastRestoreDetectRestoreRequestTriggerKeyChanged", nodeID).log();
															#line 2747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOnRestoreRequestsActor*>(this)->ActorCallback< WaitOnRestoreRequestsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitOnRestoreRequestsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOnRestoreRequestsActor*>(this)->ActorCallback< WaitOnRestoreRequestsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitOnRestoreRequestsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Database cx;
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	UID nodeID;
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Optional<Value> numRequests;
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Future<Void> watchForRestoreRequest;
															#line 2937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
};
// This generated class is to be used only via waitOnRestoreRequests()
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class WaitOnRestoreRequestsActor final : public Actor<Void>, public ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >, public ActorCallback< WaitOnRestoreRequestsActor, 1, Void >, public ActorCallback< WaitOnRestoreRequestsActor, 2, Void >, public ActorCallback< WaitOnRestoreRequestsActor, 3, Void >, public FastAllocated<WaitOnRestoreRequestsActor>, public WaitOnRestoreRequestsActorState<WaitOnRestoreRequestsActor> {
															#line 2942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
	using FastAllocated<WaitOnRestoreRequestsActor>::operator new;
	using FastAllocated<WaitOnRestoreRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15179565719669877504UL, 5251661657377501696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >;
friend struct ActorCallback< WaitOnRestoreRequestsActor, 1, Void >;
friend struct ActorCallback< WaitOnRestoreRequestsActor, 2, Void >;
friend struct ActorCallback< WaitOnRestoreRequestsActor, 3, Void >;
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	WaitOnRestoreRequestsActor(Database const& cx,UID const& nodeID = UID()) 
															#line 2962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		 : Actor<Void>(),
		   WaitOnRestoreRequestsActorState<WaitOnRestoreRequestsActor>(cx, nodeID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(738225061845553920UL, 4351482421154446592UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitOnRestoreRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitOnRestoreRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitOnRestoreRequestsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitOnRestoreRequestsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] static Future<Void> waitOnRestoreRequests( Database const& cx, UID const& nodeID = UID() ) {
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new WaitOnRestoreRequestsActor(cx, nodeID));
															#line 2998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
}

#line 308 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"

// RestoreController is the leader
															#line 3004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorleader()
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class MonitorleaderActor>
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class MonitorleaderActorState {
															#line 3011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	MonitorleaderActorState(Reference<AsyncVar<RestoreWorkerInterface>> const& leader,Database const& cx,RestoreWorkerInterface const& myWorkerInterf) 
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : leader(leader),
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   cx(cx),
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   myWorkerInterf(myWorkerInterf)
															#line 3022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorleader", reinterpret_cast<unsigned long>(this));

	}
	~MonitorleaderActorState() 
	{
		fdb_probe_actor_destroy("monitorleader", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->FASTRESTORE_MONITOR_LEADER_DELAY);
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<MonitorleaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorleaderActor*>(this)->actor_wait_state = 1;
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorleaderActor, 0, Void >*>(static_cast<MonitorleaderActor*>(this)));
															#line 3044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorleaderActorState();
		static_cast<MonitorleaderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker", myWorkerInterf.id()).detail("MonitorLeader", "StartLeaderElection");
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		count = 0;
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		leaderInterf = RestoreWorkerInterface();
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		;
															#line 3075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker", myWorkerInterf.id()).detail("MonitorLeader", "StartLeaderElection");
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		count = 0;
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		leaderInterf = RestoreWorkerInterface();
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		;
															#line 3092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorleaderActor*>(this)->actor_wait_state > 0) static_cast<MonitorleaderActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorleaderActor*>(this)->ActorCallback< MonitorleaderActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorleaderActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker", myWorkerInterf.id()) .detail("MonitorLeader", "FinishLeaderElection") .detail("Leader", leaderInterf.id()) .detail("IamLeader", leaderInterf == myWorkerInterf);
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<MonitorleaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorleaderActorState(); static_cast<MonitorleaderActor*>(this)->destroy(); return 0; }
															#line 3178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		new (&static_cast<MonitorleaderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MonitorleaderActorState();
		static_cast<MonitorleaderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			count++;
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.reset();
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(restoreLeaderKey);
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<MonitorleaderActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorleaderActor*>(this)->actor_wait_state = 2;
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorleaderActor, 1, Optional<Value> >*>(static_cast<MonitorleaderActor*>(this)));
															#line 3213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent(SevInfo, "FastRestoreLeaderElection").detail("ErrorCode", e.code()).detail("Error", e.what());
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<MonitorleaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorleaderActor*>(this)->actor_wait_state = 4;
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorleaderActor, 3, Void >*>(static_cast<MonitorleaderActor*>(this)));
															#line 3257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> const& leaderValue,int loopDepth) 
	{
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent(SevInfo, "FastRestoreLeaderElection") .detail("Round", count) .detail("LeaderExisted", leaderValue.present());
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (leaderValue.present())
															#line 3274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		{
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			leaderInterf = BinaryReader::fromStringRef<RestoreWorkerInterface>(leaderValue.get(), IncludeVersion());
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (leaderInterf != myWorkerInterf)
															#line 3280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			{
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				tr.set(restoreWorkerKeyFor(myWorkerInterf.id()), restoreWorkerInterfaceValue(myWorkerInterf));
															#line 3284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			}
		}
		else
		{
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.set(restoreLeaderKey, BinaryWriter::toValue(myWorkerInterf, IncludeVersion(ProtocolVersion::withRestoreWorkerInterfaceValue())));
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			leaderInterf = myWorkerInterf;
															#line 3293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		}
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<MonitorleaderActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorleaderActor*>(this)->actor_wait_state = 3;
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorleaderActor, 2, Void >*>(static_cast<MonitorleaderActor*>(this)));
															#line 3304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> && leaderValue,int loopDepth) 
	{
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent(SevInfo, "FastRestoreLeaderElection") .detail("Round", count) .detail("LeaderExisted", leaderValue.present());
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (leaderValue.present())
															#line 3315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		{
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			leaderInterf = BinaryReader::fromStringRef<RestoreWorkerInterface>(leaderValue.get(), IncludeVersion());
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (leaderInterf != myWorkerInterf)
															#line 3321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			{
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				tr.set(restoreWorkerKeyFor(myWorkerInterf.id()), restoreWorkerInterfaceValue(myWorkerInterf));
															#line 3325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			}
		}
		else
		{
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.set(restoreLeaderKey, BinaryWriter::toValue(myWorkerInterf, IncludeVersion(ProtocolVersion::withRestoreWorkerInterfaceValue())));
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			leaderInterf = myWorkerInterf;
															#line 3334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		}
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<MonitorleaderActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorleaderActor*>(this)->actor_wait_state = 3;
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorleaderActor, 2, Void >*>(static_cast<MonitorleaderActor*>(this)));
															#line 3345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> const& leaderValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(leaderValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> && leaderValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(leaderValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorleaderActor*>(this)->actor_wait_state > 0) static_cast<MonitorleaderActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorleaderActor*>(this)->ActorCallback< MonitorleaderActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorleaderActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		leader->set(leaderInterf);
															#line 3429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		leader->set(leaderInterf);
															#line 3438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorleaderActor*>(this)->actor_wait_state > 0) static_cast<MonitorleaderActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorleaderActor*>(this)->ActorCallback< MonitorleaderActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorleaderActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorleaderActor*>(this)->actor_wait_state > 0) static_cast<MonitorleaderActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorleaderActor*>(this)->ActorCallback< MonitorleaderActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorleaderActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<AsyncVar<RestoreWorkerInterface>> leader;
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Database cx;
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerInterface myWorkerInterf;
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	int count;
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerInterface leaderInterf;
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 3617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
};
// This generated class is to be used only via monitorleader()
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class MonitorleaderActor final : public Actor<Void>, public ActorCallback< MonitorleaderActor, 0, Void >, public ActorCallback< MonitorleaderActor, 1, Optional<Value> >, public ActorCallback< MonitorleaderActor, 2, Void >, public ActorCallback< MonitorleaderActor, 3, Void >, public FastAllocated<MonitorleaderActor>, public MonitorleaderActorState<MonitorleaderActor> {
															#line 3622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
	using FastAllocated<MonitorleaderActor>::operator new;
	using FastAllocated<MonitorleaderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9631205552733067776UL, 12366359122571917056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorleaderActor, 0, Void >;
friend struct ActorCallback< MonitorleaderActor, 1, Optional<Value> >;
friend struct ActorCallback< MonitorleaderActor, 2, Void >;
friend struct ActorCallback< MonitorleaderActor, 3, Void >;
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	MonitorleaderActor(Reference<AsyncVar<RestoreWorkerInterface>> const& leader,Database const& cx,RestoreWorkerInterface const& myWorkerInterf) 
															#line 3642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorleaderActorState<MonitorleaderActor>(leader, cx, myWorkerInterf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8771406609886211584UL, 5171815810999277056UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorleader");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorleaderActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorleaderActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorleaderActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorleaderActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> monitorleader( Reference<AsyncVar<RestoreWorkerInterface>> const& leader, Database const& cx, RestoreWorkerInterface const& myWorkerInterf ) {
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new MonitorleaderActor(leader, cx, myWorkerInterf));
															#line 3678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
}

#line 356 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"

															#line 3683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via _restoreWorker()
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class _restoreWorkerActor>
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class _restoreWorkerActorState {
															#line 3690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	_restoreWorkerActorState(Database const& cx,LocalityData const& locality) 
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : cx(cx),
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   locality(locality),
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   actors(false),
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   myWork(Never()),
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   leader(makeReference<AsyncVar<RestoreWorkerInterface>>()),
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   myWorkerInterf(),
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   self(makeReference<RestoreWorkerData>())
															#line 3709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("_restoreWorker", reinterpret_cast<unsigned long>(this));

	}
	~_restoreWorkerActorState() 
	{
		fdb_probe_actor_destroy("_restoreWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			myWorkerInterf.initEndpoints();
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			self->workerID = myWorkerInterf.id();
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (g_network->isSimulated())
															#line 3728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			{
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				auto addresses = g_simulator->getProcessByAddress(myWorkerInterf.address())->addresses;
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				g_simulator->protectedAddresses.insert(addresses.address);
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				if (addresses.secondaryAddress.present())
															#line 3736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
				{
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
					g_simulator->protectedAddresses.insert(addresses.secondaryAddress.get());
															#line 3740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
				}
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				ISimulator::ProcessInfo* p = g_simulator->getProcessByAddress(myWorkerInterf.address());
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				TraceEvent("ProtectRestoreWorker") .detail("Address", addresses.toString()) .detail("IsReliable", p->isReliable()) .detail("ReliableInfo", p->getReliableInfo()) .backtrace();
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				ASSERT(p->isReliable());
															#line 3748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			}
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent("FastRestoreWorkerKnobs", myWorkerInterf.id()) .detail("FailureTimeout", SERVER_KNOBS->FASTRESTORE_FAILURE_TIMEOUT) .detail("HeartBeat", SERVER_KNOBS->FASTRESTORE_HEARTBEAT_INTERVAL) .detail("SamplePercentage", SERVER_KNOBS->FASTRESTORE_SAMPLING_PERCENT) .detail("NumLoaders", SERVER_KNOBS->FASTRESTORE_NUM_LOADERS) .detail("NumAppliers", SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS) .detail("TxnBatchSize", SERVER_KNOBS->FASTRESTORE_TXN_BATCH_MAX_BYTES) .detail("VersionBatchSize", SERVER_KNOBS->FASTRESTORE_VERSIONBATCH_MAX_BYTES);
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitOnRestoreRequests(cx, myWorkerInterf.id());
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 1;
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _restoreWorkerActor, 0, Void >*>(static_cast<_restoreWorkerActor*>(this)));
															#line 3761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_restoreWorkerActorState();
		static_cast<_restoreWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = monitorleader(leader, cx, myWorkerInterf);
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 2;
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _restoreWorkerActor, 1, Void >*>(static_cast<_restoreWorkerActor*>(this)));
															#line 3791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = monitorleader(leader, cx, myWorkerInterf);
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 2;
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _restoreWorkerActor, 1, Void >*>(static_cast<_restoreWorkerActor*>(this)));
															#line 3807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state > 0) static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<_restoreWorkerActor*>(this)->ActorCallback< _restoreWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _restoreWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _restoreWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _restoreWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker", myWorkerInterf.id()).detail("LeaderElection", "WaitForLeader");
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (leader->get() == myWorkerInterf)
															#line 3893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		{
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			myWork = startRestoreWorkerLeader(self, myWorkerInterf, cx);
															#line 3897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		}
		else
		{
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			myWork = startRestoreWorker(self, myWorkerInterf, cx);
															#line 3903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		}
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = myWork;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 3;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _restoreWorkerActor, 2, Void >*>(static_cast<_restoreWorkerActor*>(this)));
															#line 3914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker", myWorkerInterf.id()).detail("LeaderElection", "WaitForLeader");
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (leader->get() == myWorkerInterf)
															#line 3925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		{
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			myWork = startRestoreWorkerLeader(self, myWorkerInterf, cx);
															#line 3929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		}
		else
		{
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			myWork = startRestoreWorker(self, myWorkerInterf, cx);
															#line 3935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		}
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = myWork;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 3;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _restoreWorkerActor, 2, Void >*>(static_cast<_restoreWorkerActor*>(this)));
															#line 3946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state > 0) static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<_restoreWorkerActor*>(this)->ActorCallback< _restoreWorkerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _restoreWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _restoreWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _restoreWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<_restoreWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_restoreWorkerActorState(); static_cast<_restoreWorkerActor*>(this)->destroy(); return 0; }
															#line 4030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		new (&static_cast<_restoreWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_restoreWorkerActorState();
		static_cast<_restoreWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<_restoreWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_restoreWorkerActorState(); static_cast<_restoreWorkerActor*>(this)->destroy(); return 0; }
															#line 4042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		new (&static_cast<_restoreWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_restoreWorkerActorState();
		static_cast<_restoreWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state > 0) static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<_restoreWorkerActor*>(this)->ActorCallback< _restoreWorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _restoreWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _restoreWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _restoreWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Database cx;
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	LocalityData locality;
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	ActorCollection actors;
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Future<Void> myWork;
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<AsyncVar<RestoreWorkerInterface>> leader;
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerInterface myWorkerInterf;
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<RestoreWorkerData> self;
															#line 4139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
};
// This generated class is to be used only via _restoreWorker()
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class _restoreWorkerActor final : public Actor<Void>, public ActorCallback< _restoreWorkerActor, 0, Void >, public ActorCallback< _restoreWorkerActor, 1, Void >, public ActorCallback< _restoreWorkerActor, 2, Void >, public FastAllocated<_restoreWorkerActor>, public _restoreWorkerActorState<_restoreWorkerActor> {
															#line 4144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
	using FastAllocated<_restoreWorkerActor>::operator new;
	using FastAllocated<_restoreWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10319904832142721536UL, 16099528993041163008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _restoreWorkerActor, 0, Void >;
friend struct ActorCallback< _restoreWorkerActor, 1, Void >;
friend struct ActorCallback< _restoreWorkerActor, 2, Void >;
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	_restoreWorkerActor(Database const& cx,LocalityData const& locality) 
															#line 4163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		 : Actor<Void>(),
		   _restoreWorkerActorState<_restoreWorkerActor>(cx, locality),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(716177972706002688UL, 17248404509278918400UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_restoreWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _restoreWorkerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _restoreWorkerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _restoreWorkerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> _restoreWorker( Database const& cx, LocalityData const& locality ) {
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new _restoreWorkerActor(cx, locality));
															#line 4198 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
}

#line 410 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"

															#line 4203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via restoreWorker()
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class RestoreWorkerActor>
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class RestoreWorkerActorState {
															#line 4210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerActorState(Reference<IClusterConnectionRecord> const& connRecord,LocalityData const& locality,std::string const& coordFolder) 
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : connRecord(connRecord),
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   locality(locality),
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   coordFolder(coordFolder)
															#line 4221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("restoreWorker", reinterpret_cast<unsigned long>(this));

	}
	~RestoreWorkerActorState() 
	{
		fdb_probe_actor_destroy("restoreWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				Database cx = Database::createDatabase(connRecord, ApiVersion::LATEST_VERSION, IsInternal::True, locality);
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = reportErrors(_restoreWorker(cx, locality), "RestoreWorker");
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				if (static_cast<RestoreWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RestoreWorkerActor*>(this)->actor_wait_state = 1;
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreWorkerActor, 0, Void >*>(static_cast<RestoreWorkerActor*>(this)));
															#line 4246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreWorkerActorState();
		static_cast<RestoreWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<RestoreWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreWorkerActorState(); static_cast<RestoreWorkerActor*>(this)->destroy(); return 0; }
															#line 4275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		new (&static_cast<RestoreWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestoreWorkerActorState();
		static_cast<RestoreWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent("FastRestoreWorker").detail("Error", e.what());
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreWorkerActor*>(this)->actor_wait_state > 0) static_cast<RestoreWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreWorkerActor*>(this)->ActorCallback< RestoreWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<IClusterConnectionRecord> connRecord;
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	LocalityData locality;
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	std::string coordFolder;
															#line 4406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
};
// This generated class is to be used only via restoreWorker()
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class RestoreWorkerActor final : public Actor<Void>, public ActorCallback< RestoreWorkerActor, 0, Void >, public FastAllocated<RestoreWorkerActor>, public RestoreWorkerActorState<RestoreWorkerActor> {
															#line 4411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
public:
	using FastAllocated<RestoreWorkerActor>::operator new;
	using FastAllocated<RestoreWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7156306547465891840UL, 17062158341534395136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreWorkerActor, 0, Void >;
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerActor(Reference<IClusterConnectionRecord> const& connRecord,LocalityData const& locality,std::string const& coordFolder) 
															#line 4428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
		 : Actor<Void>(),
		   RestoreWorkerActorState<RestoreWorkerActor>(connRecord, locality, coordFolder),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("restoreWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14619944290362987264UL, 9188536933563828992UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("restoreWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("restoreWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreWorkerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> restoreWorker( Reference<IClusterConnectionRecord> const& connRecord, LocalityData const& locality, std::string const& coordFolder ) {
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new RestoreWorkerActor(connRecord, locality, coordFolder));
															#line 4461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/RestoreWorker.actor.g.cpp"
}

#line 424 "/Users/ec2-user/foundationdb/fdbserver/RestoreWorker.actor.cpp"
