#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
/*
 * MoveKeys.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <vector>
#include <limits.h>

#include "fdbclient/BlobRestoreCommon.h"
#include "fdbclient/FDBOptions.g.h"
#include "flow/Error.h"
#include "flow/Trace.h"
#include "flow/Util.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/BulkLoadUtil.actor.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/BlobMigratorInterface.h"
#include "fdbserver/TSSMappingUtil.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

template <typename... T>
static inline void dprint(fmt::format_string<T...> fmt, T&&... args) {
	if (g_network->isSimulated())
		fmt::print(fmt, std::forward<T>(args)...);
}

namespace {
struct Shard {
	Shard() = default;
	Shard(KeyRangeRef range, const UID& id) : range(range), id(id) {}

	KeyRange range;
	UID id;
};

bool shouldCreateCheckpoint(const UID& dataMoveId) {
	bool assigned, emptyRange;
	DataMoveType type;
	DataMovementReason reason;
	decodeDataMoveId(dataMoveId, assigned, emptyRange, type, reason);
	return (type == DataMoveType::PHYSICAL || type == DataMoveType::PHYSICAL_EXP);
}

// Unassigns keyrange `range` from server `ssId`, except ranges in `shards`.
// Note: krmSetRangeCoalescing() doesn't work in this case since each shard is assigned an ID.
															#line 69 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via unassignServerKeys()
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class UnassignServerKeysActor>
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class UnassignServerKeysActorState {
															#line 75 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UnassignServerKeysActorState(Transaction* const& tr,UID const& ssId,KeyRange const& range,std::vector<Shard> const& shards,UID const& logId) 
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : tr(tr),
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ssId(ssId),
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   range(range),
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   shards(shards),
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   logId(logId),
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   mapPrefix(serverKeysPrefixFor(ssId))
															#line 92 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("unassignServerKeys", reinterpret_cast<unsigned long>(this));

	}
	~UnassignServerKeysActorState() 
	{
		fdb_probe_actor_destroy("unassignServerKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (shards.empty())
															#line 107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_0 = krmSetRangeCoalescing(tr, mapPrefix, range, allKeys, serverKeysFalse);
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<UnassignServerKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UnassignServerKeysActor*>(this)->actor_wait_state = 1;
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UnassignServerKeysActor, 0, Void >*>(static_cast<UnassignServerKeysActor*>(this)));
															#line 118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UnassignServerKeysActorState();
		static_cast<UnassignServerKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		withPrefix = KeyRangeRef(mapPrefix.toString() + range.begin.toString(), mapPrefix.toString() + range.end.toString());
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		maxWithPrefix = KeyRangeRef(mapPrefix.toString() + allKeys.begin.toString(), mapPrefix.toString() + allKeys.end.toString());
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keys = std::vector<Future<RangeResult>>();
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keys.push_back( tr->getRange(lastLessThan(withPrefix.begin), firstGreaterOrEqual(withPrefix.begin), 1, Snapshot::True));
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keys.push_back( tr->getRange(lastLessOrEqual(withPrefix.end), firstGreaterThan(withPrefix.end) + 1, 2, Snapshot::True));
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(keys);
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<UnassignServerKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UnassignServerKeysActor*>(this)->actor_wait_state = 2;
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UnassignServerKeysActor, 1, Void >*>(static_cast<UnassignServerKeysActor*>(this)));
															#line 163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<UnassignServerKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnassignServerKeysActorState(); static_cast<UnassignServerKeysActor*>(this)->destroy(); return 0; }
															#line 172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<UnassignServerKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnassignServerKeysActorState();
		static_cast<UnassignServerKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<UnassignServerKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnassignServerKeysActorState(); static_cast<UnassignServerKeysActor*>(this)->destroy(); return 0; }
															#line 184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<UnassignServerKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnassignServerKeysActorState();
		static_cast<UnassignServerKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UnassignServerKeysActor*>(this)->actor_wait_state > 0) static_cast<UnassignServerKeysActor*>(this)->actor_wait_state = 0;
		static_cast<UnassignServerKeysActor*>(this)->ActorCallback< UnassignServerKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnassignServerKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unassignServerKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnassignServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unassignServerKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UnassignServerKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unassignServerKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnassignServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unassignServerKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UnassignServerKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unassignServerKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnassignServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unassignServerKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		auto beginRange = keys[0].get();
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		bool hasBegin = beginRange.size() > 0 && beginRange[0].key.startsWith(mapPrefix);
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value beginValue = hasBegin ? beginRange[0].value : serverKeysFalse;
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Key beginKey = withPrefix.begin;
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value value = range.begin == shards[0].range.begin ? serverKeysValue(shards[0].id) : serverKeysFalse;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (beginValue == value)
															#line 281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool outsideRange = !hasBegin || beginRange[0].key < maxWithPrefix.begin;
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			beginKey = outsideRange ? maxWithPrefix.begin : beginRange[0].key;
															#line 287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<KeyValue> kvs;
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (beginKey < withPrefix.begin)
															#line 293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			kvs.push_back(KeyValueRef(beginKey, value));
															#line 297 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Key preEnd = range.begin;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < shards.size();++i) {
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const Shard& shard = shards[i];
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (shard.range.begin > preEnd && (kvs.empty() || kvs.back().value != serverKeysFalse))
															#line 307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				kvs.push_back(KeyValueRef(preEnd.withPrefix(mapPrefix), serverKeysFalse));
															#line 311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			preEnd = shard.range.end;
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			Value cv = serverKeysValue(shard.id);
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (kvs.empty() || cv != kvs.back().value)
															#line 319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				kvs.push_back(KeyValueRef(shard.range.begin.withPrefix(mapPrefix), cv));
															#line 323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (range.end > preEnd)
															#line 328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			kvs.push_back(KeyValueRef(preEnd.withPrefix(mapPrefix), serverKeysFalse));
															#line 332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		auto endRange = keys[1].get();
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		bool hasEnd = endRange.size() >= 1 && endRange[0].key.startsWith(mapPrefix) && endRange[0].key <= withPrefix.end;
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		bool hasNext = (endRange.size() == 2 && endRange[1].key.startsWith(mapPrefix)) || (endRange.size() == 1 && withPrefix.end < endRange[0].key && endRange[0].key.startsWith(mapPrefix));
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value existingValue = hasEnd ? endRange[0].value : serverKeysFalse;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Key endKey;
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value endValue;
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		const bool valueMatches = kvs.back().value == existingValue;
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (hasNext && endRange.back().key <= maxWithPrefix.end && valueMatches)
															#line 350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			endKey = endRange.back().key;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			endValue = endRange.back().value;
															#line 356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		else
		{
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (valueMatches)
															#line 362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endKey = maxWithPrefix.end;
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endValue = existingValue;
															#line 368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endKey = withPrefix.end;
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endValue = existingValue;
															#line 376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		kvs.push_back(KeyValueRef(endKey, endValue));
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < kvs.size();++i) {
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "UnassignServerKeys", logId) .detail("SSID", ssId) .detail("Range", range) .detail("Point", kvs[i]);
															#line 385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		KeyRange conflictRange = KeyRangeRef(hasBegin ? beginRange[0].key : mapPrefix, withPrefix.begin);
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!conflictRange.empty())
															#line 391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		conflictRange = KeyRangeRef(hasEnd ? endRange[0].key : mapPrefix, hasNext ? keyAfter(endRange.end()[-1].key) : strinc(mapPrefix));
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!conflictRange.empty())
															#line 401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr->clear(KeyRangeRef(beginKey, endKey));
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < kvs.size() - 1;++i) {
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(kvs[i].value != kvs[i + 1].value || kvs[i + 1].key.removePrefix(mapPrefix) == allKeys.end);
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(kvs[i].key, kvs[i].value);
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(kvs[i + 1].key, kvs[i + 1].value);
															#line 417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<UnassignServerKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnassignServerKeysActorState(); static_cast<UnassignServerKeysActor*>(this)->destroy(); return 0; }
															#line 421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<UnassignServerKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnassignServerKeysActorState();
		static_cast<UnassignServerKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		auto beginRange = keys[0].get();
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		bool hasBegin = beginRange.size() > 0 && beginRange[0].key.startsWith(mapPrefix);
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value beginValue = hasBegin ? beginRange[0].value : serverKeysFalse;
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Key beginKey = withPrefix.begin;
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value value = range.begin == shards[0].range.begin ? serverKeysValue(shards[0].id) : serverKeysFalse;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (beginValue == value)
															#line 443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool outsideRange = !hasBegin || beginRange[0].key < maxWithPrefix.begin;
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			beginKey = outsideRange ? maxWithPrefix.begin : beginRange[0].key;
															#line 449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<KeyValue> kvs;
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (beginKey < withPrefix.begin)
															#line 455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			kvs.push_back(KeyValueRef(beginKey, value));
															#line 459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Key preEnd = range.begin;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < shards.size();++i) {
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const Shard& shard = shards[i];
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (shard.range.begin > preEnd && (kvs.empty() || kvs.back().value != serverKeysFalse))
															#line 469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				kvs.push_back(KeyValueRef(preEnd.withPrefix(mapPrefix), serverKeysFalse));
															#line 473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			preEnd = shard.range.end;
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			Value cv = serverKeysValue(shard.id);
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (kvs.empty() || cv != kvs.back().value)
															#line 481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				kvs.push_back(KeyValueRef(shard.range.begin.withPrefix(mapPrefix), cv));
															#line 485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (range.end > preEnd)
															#line 490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			kvs.push_back(KeyValueRef(preEnd.withPrefix(mapPrefix), serverKeysFalse));
															#line 494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		auto endRange = keys[1].get();
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		bool hasEnd = endRange.size() >= 1 && endRange[0].key.startsWith(mapPrefix) && endRange[0].key <= withPrefix.end;
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		bool hasNext = (endRange.size() == 2 && endRange[1].key.startsWith(mapPrefix)) || (endRange.size() == 1 && withPrefix.end < endRange[0].key && endRange[0].key.startsWith(mapPrefix));
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value existingValue = hasEnd ? endRange[0].value : serverKeysFalse;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Key endKey;
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value endValue;
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		const bool valueMatches = kvs.back().value == existingValue;
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (hasNext && endRange.back().key <= maxWithPrefix.end && valueMatches)
															#line 512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			endKey = endRange.back().key;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			endValue = endRange.back().value;
															#line 518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		else
		{
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (valueMatches)
															#line 524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endKey = maxWithPrefix.end;
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endValue = existingValue;
															#line 530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endKey = withPrefix.end;
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endValue = existingValue;
															#line 538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		kvs.push_back(KeyValueRef(endKey, endValue));
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < kvs.size();++i) {
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "UnassignServerKeys", logId) .detail("SSID", ssId) .detail("Range", range) .detail("Point", kvs[i]);
															#line 547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		KeyRange conflictRange = KeyRangeRef(hasBegin ? beginRange[0].key : mapPrefix, withPrefix.begin);
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!conflictRange.empty())
															#line 553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		conflictRange = KeyRangeRef(hasEnd ? endRange[0].key : mapPrefix, hasNext ? keyAfter(endRange.end()[-1].key) : strinc(mapPrefix));
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!conflictRange.empty())
															#line 563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr->clear(KeyRangeRef(beginKey, endKey));
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < kvs.size() - 1;++i) {
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(kvs[i].value != kvs[i + 1].value || kvs[i + 1].key.removePrefix(mapPrefix) == allKeys.end);
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(kvs[i].key, kvs[i].value);
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(kvs[i + 1].key, kvs[i + 1].value);
															#line 579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<UnassignServerKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnassignServerKeysActorState(); static_cast<UnassignServerKeysActor*>(this)->destroy(); return 0; }
															#line 583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<UnassignServerKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnassignServerKeysActorState();
		static_cast<UnassignServerKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UnassignServerKeysActor*>(this)->actor_wait_state > 0) static_cast<UnassignServerKeysActor*>(this)->actor_wait_state = 0;
		static_cast<UnassignServerKeysActor*>(this)->ActorCallback< UnassignServerKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnassignServerKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unassignServerKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnassignServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unassignServerKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UnassignServerKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unassignServerKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnassignServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unassignServerKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UnassignServerKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unassignServerKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnassignServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unassignServerKeys", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction* tr;
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID ssId;
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange range;
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Shard> shards;
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID logId;
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key mapPrefix;
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange withPrefix;
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange maxWithPrefix;
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<RangeResult>> keys;
															#line 684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via unassignServerKeys()
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class UnassignServerKeysActor final : public Actor<Void>, public ActorCallback< UnassignServerKeysActor, 0, Void >, public ActorCallback< UnassignServerKeysActor, 1, Void >, public FastAllocated<UnassignServerKeysActor>, public UnassignServerKeysActorState<UnassignServerKeysActor> {
															#line 689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<UnassignServerKeysActor>::operator new;
	using FastAllocated<UnassignServerKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18446469095170682112UL, 16448631288106866944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UnassignServerKeysActor, 0, Void >;
friend struct ActorCallback< UnassignServerKeysActor, 1, Void >;
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UnassignServerKeysActor(Transaction* const& tr,UID const& ssId,KeyRange const& range,std::vector<Shard> const& shards,UID const& logId) 
															#line 707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   UnassignServerKeysActorState<UnassignServerKeysActor>(tr, ssId, range, shards, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("unassignServerKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16965164928171750144UL, 12742658307583911936UL);
		ActorExecutionContextHelper __helper(static_cast<UnassignServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("unassignServerKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("unassignServerKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UnassignServerKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UnassignServerKeysActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> unassignServerKeys( Transaction* const& tr, UID const& ssId, KeyRange const& range, std::vector<Shard> const& shards, UID const& logId ) {
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new UnassignServerKeysActor(tr, ssId, range, shards, logId));
															#line 740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 176 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via deleteCheckpoints()
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class DeleteCheckpointsActor>
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class DeleteCheckpointsActorState {
															#line 751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	DeleteCheckpointsActorState(Transaction* const& tr,std::set<UID> const& checkpointIds,UID const& dataMoveId) 
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : tr(tr),
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   checkpointIds(checkpointIds),
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId)
															#line 762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteCheckpoints", reinterpret_cast<unsigned long>(this));

	}
	~DeleteCheckpointsActorState() 
	{
		fdb_probe_actor_destroy("deleteCheckpoints", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!shouldCreateCheckpoint(dataMoveId))
															#line 777 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!static_cast<DeleteCheckpointsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteCheckpointsActorState(); static_cast<DeleteCheckpointsActor*>(this)->destroy(); return 0; }
															#line 781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				new (&static_cast<DeleteCheckpointsActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DeleteCheckpointsActorState();
				static_cast<DeleteCheckpointsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "DataMoveDeleteCheckpoints", dataMoveId).detail("Checkpoints", describe(checkpointIds));
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<Future<Optional<Value>>> checkpointEntries;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const UID& id : checkpointIds ) {
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				checkpointEntries.push_back(tr->get(checkpointKeyFor(id)));
															#line 795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<std::vector<Optional<Value>>> __when_expr_0 = getAll(checkpointEntries);
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state = 1;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*>(static_cast<DeleteCheckpointsActor*>(this)));
															#line 806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteCheckpointsActorState();
		static_cast<DeleteCheckpointsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<Value>> const& checkpointValues,int loopDepth) 
	{
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < checkpointIds.size();++i) {
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const auto& value = checkpointValues[i];
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!value.present())
															#line 833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevWarnAlways, "CheckpointNotFound", dataMoveId);
															#line 837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				continue;
			}
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			CheckpointMetaData checkpoint = decodeCheckpointValue(value.get());
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(checkpointIds.find(checkpoint.checkpointID) != checkpointIds.end());
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const Key key = checkpointKeyFor(checkpoint.checkpointID);
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			checkpoint.setState(CheckpointMetaData::Deleting);
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(key, checkpointValue(checkpoint));
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->clear(singleKeyRange(key));
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "DataMoveDeleteCheckpoint", dataMoveId).detail("Checkpoint", checkpoint.toString());
															#line 854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<DeleteCheckpointsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteCheckpointsActorState(); static_cast<DeleteCheckpointsActor*>(this)->destroy(); return 0; }
															#line 858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<DeleteCheckpointsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteCheckpointsActorState();
		static_cast<DeleteCheckpointsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<Value>> && checkpointValues,int loopDepth) 
	{
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < checkpointIds.size();++i) {
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const auto& value = checkpointValues[i];
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!value.present())
															#line 874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevWarnAlways, "CheckpointNotFound", dataMoveId);
															#line 878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				continue;
			}
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			CheckpointMetaData checkpoint = decodeCheckpointValue(value.get());
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(checkpointIds.find(checkpoint.checkpointID) != checkpointIds.end());
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const Key key = checkpointKeyFor(checkpoint.checkpointID);
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			checkpoint.setState(CheckpointMetaData::Deleting);
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(key, checkpointValue(checkpoint));
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->clear(singleKeyRange(key));
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "DataMoveDeleteCheckpoint", dataMoveId).detail("Checkpoint", checkpoint.toString());
															#line 895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<DeleteCheckpointsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteCheckpointsActorState(); static_cast<DeleteCheckpointsActor*>(this)->destroy(); return 0; }
															#line 899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<DeleteCheckpointsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteCheckpointsActorState();
		static_cast<DeleteCheckpointsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<Value>> const& checkpointValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(checkpointValues, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<Value>> && checkpointValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(checkpointValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state > 0) static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteCheckpointsActor*>(this)->ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction* tr;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::set<UID> checkpointIds;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 988 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via deleteCheckpoints()
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class DeleteCheckpointsActor final : public Actor<Void>, public ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >, public FastAllocated<DeleteCheckpointsActor>, public DeleteCheckpointsActorState<DeleteCheckpointsActor> {
															#line 993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<DeleteCheckpointsActor>::operator new;
	using FastAllocated<DeleteCheckpointsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13998084981423287040UL, 14593672364637185024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	DeleteCheckpointsActor(Transaction* const& tr,std::set<UID> const& checkpointIds,UID const& dataMoveId) 
															#line 1010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteCheckpointsActorState<DeleteCheckpointsActor>(tr, checkpointIds, dataMoveId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3647092636759606016UL, 17911147285598091008UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteCheckpoints");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> deleteCheckpoints( Transaction* const& tr, std::set<UID> const& checkpointIds, UID const& dataMoveId ) {
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new DeleteCheckpointsActor(tr, checkpointIds, dataMoveId));
															#line 1042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 205 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
} // namespace

bool DDEnabledState::sameId(const UID& id) const {
	return ddEnabledStatusUID == id;
}
bool DDEnabledState::isEnabled() const {
	return stateValue == ENABLED;
}

bool DDEnabledState::isBlobRestorePreparing() const {
	return stateValue == BLOB_RESTORE_PREPARING;
}

bool DDEnabledState::trySetSnapshot(UID requesterId) {
	ASSERT(requesterId != UID());
	// disabling DD
	if (!isEnabled()) {
		// only allow state modification to snapshot when DD is enabled.
		return false;
	}
	ddEnabledStatusUID = requesterId;
	stateValue = SNAPSHOT;
	TraceEvent("SetDDSnapshot").detail("RequesterUID", requesterId);

	return true;
}

bool DDEnabledState::trySetEnabled(UID requesterId) {
	ASSERT(requesterId != UID());
	// enabling DD
	if (!sameId(requesterId)) {
		// enabling DD not allowed if UID does not match with the previous request
		return false;
	}
	// reset to default status
	ddEnabledStatusUID = UID();
	stateValue = ENABLED;
	TraceEvent("SetDDEnabled").detail("RequesterUID", requesterId);
	return true;
}

bool DDEnabledState::trySetBlobRestorePreparing(UID requesterId) {
	ASSERT(requesterId != UID());
	if (!isEnabled()) {
		// only allow state modification to RestorePreparing when DD is enabled.
		return false;
	}
	ddEnabledStatusUID = requesterId;
	stateValue = BLOB_RESTORE_PREPARING;
	TraceEvent("SetDDBlobRestorePreparing").detail("RequesterUID", requesterId);
	return true;
}

															#line 1099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
namespace {
// This generated class is to be used only via readMoveKeysLock()
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class ReadMoveKeysLockActor>
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class ReadMoveKeysLockActorState {
															#line 1106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	ReadMoveKeysLockActorState(Transaction* const& tr,MoveKeysLock* const& lock) 
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : tr(tr),
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   lock(lock)
															#line 1115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("readMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	~ReadMoveKeysLockActorState() 
	{
		fdb_probe_actor_destroy("readMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_0 = tr->get(moveKeysLockOwnerKey);
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state = 1;
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >*>(static_cast<ReadMoveKeysLockActor*>(this)));
															#line 1138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadMoveKeysLockActorState();
		static_cast<ReadMoveKeysLockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(moveKeysLockWriteKey);
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state = 2;
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >*>(static_cast<ReadMoveKeysLockActor*>(this)));
															#line 1170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> const& readVal,int loopDepth) 
	{
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		lock->prevOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 1180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && readVal,int loopDepth) 
	{
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		lock->prevOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 1189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& readVal,int loopDepth) 
	{
		loopDepth = a_body1cont2(readVal, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && readVal,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(readVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<ReadMoveKeysLockActor*>(this)->ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<ReadMoveKeysLockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadMoveKeysLockActorState(); static_cast<ReadMoveKeysLockActor*>(this)->destroy(); return 0; }
															#line 1273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<ReadMoveKeysLockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadMoveKeysLockActorState();
		static_cast<ReadMoveKeysLockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Optional<Value> const& readVal,int loopDepth) 
	{
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		lock->prevWrite = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 1285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Optional<Value> && readVal,int loopDepth) 
	{
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		lock->prevWrite = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 1294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& readVal,int loopDepth) 
	{
		loopDepth = a_body1cont5(readVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && readVal,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(readVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<ReadMoveKeysLockActor*>(this)->ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction* tr;
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock* lock;
															#line 1378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via readMoveKeysLock()
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class ReadMoveKeysLockActor final : public Actor<Void>, public ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >, public ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >, public FastAllocated<ReadMoveKeysLockActor>, public ReadMoveKeysLockActorState<ReadMoveKeysLockActor> {
															#line 1383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<ReadMoveKeysLockActor>::operator new;
	using FastAllocated<ReadMoveKeysLockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1122037345432878336UL, 11537642686624392960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >;
friend struct ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >;
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	ReadMoveKeysLockActor(Transaction* const& tr,MoveKeysLock* const& lock) 
															#line 1401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   ReadMoveKeysLockActorState<ReadMoveKeysLockActor>(tr, lock),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18311156923523866624UL, 5785599686231584512UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readMoveKeysLock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> readMoveKeysLock( Transaction* const& tr, MoveKeysLock* const& lock ) {
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new ReadMoveKeysLockActor(tr, lock));
															#line 1435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 1440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
namespace {
// This generated class is to be used only via readMoveKeysLock()
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class ReadMoveKeysLockActor1>
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class ReadMoveKeysLockActor1State {
															#line 1447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	ReadMoveKeysLockActor1State(Database const& cx) 
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : cx(cx),
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tr(cx)
															#line 1456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("readMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	~ReadMoveKeysLockActor1State() 
	{
		fdb_probe_actor_destroy("readMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 1471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadMoveKeysLockActor1State();
		static_cast<ReadMoveKeysLockActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			lock = MoveKeysLock();
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = readMoveKeysLock(&tr, &lock);
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state = 1;
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadMoveKeysLockActor1, 0, Void >*>(static_cast<ReadMoveKeysLockActor1*>(this)));
															#line 1515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state = 2;
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadMoveKeysLockActor1, 1, Void >*>(static_cast<ReadMoveKeysLockActor1*>(this)));
															#line 1544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<ReadMoveKeysLockActor1*>(this)->SAV<MoveKeysLock>::futures) { (void)(lock); this->~ReadMoveKeysLockActor1State(); static_cast<ReadMoveKeysLockActor1*>(this)->destroy(); return 0; }
															#line 1559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<ReadMoveKeysLockActor1*>(this)->SAV< MoveKeysLock >::value()) MoveKeysLock(std::move(lock)); // state_var_RVO
		this->~ReadMoveKeysLockActor1State();
		static_cast<ReadMoveKeysLockActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<ReadMoveKeysLockActor1*>(this)->SAV<MoveKeysLock>::futures) { (void)(lock); this->~ReadMoveKeysLockActor1State(); static_cast<ReadMoveKeysLockActor1*>(this)->destroy(); return 0; }
															#line 1571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<ReadMoveKeysLockActor1*>(this)->SAV< MoveKeysLock >::value()) MoveKeysLock(std::move(lock)); // state_var_RVO
		this->~ReadMoveKeysLockActor1State();
		static_cast<ReadMoveKeysLockActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state > 0) static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state = 0;
		static_cast<ReadMoveKeysLockActor1*>(this)->ActorCallback< ReadMoveKeysLockActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadMoveKeysLockActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		CODE_PROBE(true, "readMoveKeysLock retry");
															#line 1658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		CODE_PROBE(true, "readMoveKeysLock retry");
															#line 1667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state > 0) static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state = 0;
		static_cast<ReadMoveKeysLockActor1*>(this)->ActorCallback< ReadMoveKeysLockActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadMoveKeysLockActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database cx;
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 1753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via readMoveKeysLock()
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class ReadMoveKeysLockActor1 final : public Actor<MoveKeysLock>, public ActorCallback< ReadMoveKeysLockActor1, 0, Void >, public ActorCallback< ReadMoveKeysLockActor1, 1, Void >, public FastAllocated<ReadMoveKeysLockActor1>, public ReadMoveKeysLockActor1State<ReadMoveKeysLockActor1> {
															#line 1758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<ReadMoveKeysLockActor1>::operator new;
	using FastAllocated<ReadMoveKeysLockActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1122037345432878336UL, 11537642686624392960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<MoveKeysLock>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadMoveKeysLockActor1, 0, Void >;
friend struct ActorCallback< ReadMoveKeysLockActor1, 1, Void >;
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	ReadMoveKeysLockActor1(Database const& cx) 
															#line 1776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<MoveKeysLock>(),
		   ReadMoveKeysLockActor1State<ReadMoveKeysLockActor1>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9018890959737607424UL, 7351906858584551936UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readMoveKeysLock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadMoveKeysLockActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadMoveKeysLockActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<MoveKeysLock> readMoveKeysLock( Database const& cx ) {
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<MoveKeysLock>(new ReadMoveKeysLockActor1(cx));
															#line 1810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 285 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 1815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
namespace {
// This generated class is to be used only via takeMoveKeysLock()
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class TakeMoveKeysLockActor>
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class TakeMoveKeysLockActorState {
															#line 1822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	TakeMoveKeysLockActorState(Database const& cx,UID const& ddId) 
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : cx(cx),
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ddId(ddId),
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tr(cx)
															#line 1833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("takeMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	~TakeMoveKeysLockActorState() 
	{
		fdb_probe_actor_destroy("takeMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 1848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TakeMoveKeysLockActorState();
		static_cast<TakeMoveKeysLockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			lock = MoveKeysLock();
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			txnId = UID();
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!g_network->isSimulated())
															#line 1889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				txnId = deterministicRandom()->randomUniqueID();
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr.debugTransaction(txnId);
															#line 1895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = readMoveKeysLock(&tr, &lock);
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state = 1;
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TakeMoveKeysLockActor, 0, Void >*>(static_cast<TakeMoveKeysLockActor*>(this)));
															#line 1906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state = 3;
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TakeMoveKeysLockActor, 2, Void >*>(static_cast<TakeMoveKeysLockActor*>(this)));
															#line 1935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		lock.myOwner = deterministicRandom()->randomUniqueID();
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.set(moveKeysLockOwnerKey, BinaryWriter::toValue(lock.myOwner, Unversioned()));
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state = 2;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TakeMoveKeysLockActor, 1, Void >*>(static_cast<TakeMoveKeysLockActor*>(this)));
															#line 1961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		lock.myOwner = deterministicRandom()->randomUniqueID();
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.set(moveKeysLockOwnerKey, BinaryWriter::toValue(lock.myOwner, Unversioned()));
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state = 2;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TakeMoveKeysLockActor, 1, Void >*>(static_cast<TakeMoveKeysLockActor*>(this)));
															#line 1981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<TakeMoveKeysLockActor*>(this)->ActorCallback< TakeMoveKeysLockActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TakeMoveKeysLockActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TakeMoveKeysLockActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TakeMoveKeysLockActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent("TakeMoveKeysLockTransaction", ddId) .detail("TransactionUID", txnId) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString());
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<TakeMoveKeysLockActor*>(this)->SAV<MoveKeysLock>::futures) { (void)(lock); this->~TakeMoveKeysLockActorState(); static_cast<TakeMoveKeysLockActor*>(this)->destroy(); return 0; }
															#line 2067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<TakeMoveKeysLockActor*>(this)->SAV< MoveKeysLock >::value()) MoveKeysLock(std::move(lock)); // state_var_RVO
		this->~TakeMoveKeysLockActorState();
		static_cast<TakeMoveKeysLockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent("TakeMoveKeysLockTransaction", ddId) .detail("TransactionUID", txnId) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString());
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<TakeMoveKeysLockActor*>(this)->SAV<MoveKeysLock>::futures) { (void)(lock); this->~TakeMoveKeysLockActorState(); static_cast<TakeMoveKeysLockActor*>(this)->destroy(); return 0; }
															#line 2081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<TakeMoveKeysLockActor*>(this)->SAV< MoveKeysLock >::value()) MoveKeysLock(std::move(lock)); // state_var_RVO
		this->~TakeMoveKeysLockActorState();
		static_cast<TakeMoveKeysLockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<TakeMoveKeysLockActor*>(this)->ActorCallback< TakeMoveKeysLockActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TakeMoveKeysLockActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TakeMoveKeysLockActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TakeMoveKeysLockActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		CODE_PROBE(true, "takeMoveKeysLock retry");
															#line 2168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		CODE_PROBE(true, "takeMoveKeysLock retry");
															#line 2177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<TakeMoveKeysLockActor*>(this)->ActorCallback< TakeMoveKeysLockActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TakeMoveKeysLockActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TakeMoveKeysLockActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TakeMoveKeysLockActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database cx;
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID ddId;
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID txnId;
															#line 2267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via takeMoveKeysLock()
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class TakeMoveKeysLockActor final : public Actor<MoveKeysLock>, public ActorCallback< TakeMoveKeysLockActor, 0, Void >, public ActorCallback< TakeMoveKeysLockActor, 1, Void >, public ActorCallback< TakeMoveKeysLockActor, 2, Void >, public FastAllocated<TakeMoveKeysLockActor>, public TakeMoveKeysLockActorState<TakeMoveKeysLockActor> {
															#line 2272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<TakeMoveKeysLockActor>::operator new;
	using FastAllocated<TakeMoveKeysLockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8287065474738403584UL, 8797680107083315456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<MoveKeysLock>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TakeMoveKeysLockActor, 0, Void >;
friend struct ActorCallback< TakeMoveKeysLockActor, 1, Void >;
friend struct ActorCallback< TakeMoveKeysLockActor, 2, Void >;
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	TakeMoveKeysLockActor(Database const& cx,UID const& ddId) 
															#line 2291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<MoveKeysLock>(),
		   TakeMoveKeysLockActorState<TakeMoveKeysLockActor>(cx, ddId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7589019723009657600UL, 17537804489524614912UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("takeMoveKeysLock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TakeMoveKeysLockActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TakeMoveKeysLockActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TakeMoveKeysLockActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<MoveKeysLock> takeMoveKeysLock( Database const& cx, UID const& ddId ) {
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<MoveKeysLock>(new TakeMoveKeysLockActor(cx, ddId));
															#line 2326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 315 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 2331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
namespace {
// This generated class is to be used only via checkPersistentMoveKeysLock()
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class CheckPersistentMoveKeysLockActor>
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckPersistentMoveKeysLockActorState {
															#line 2338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckPersistentMoveKeysLockActorState(Transaction* const& tr,MoveKeysLock const& lock,bool const& isWrite = true) 
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : tr(tr),
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   lock(lock),
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   isWrite(isWrite)
															#line 2349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	~CheckPersistentMoveKeysLockActorState() 
	{
		fdb_probe_actor_destroy("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(moveKeysLockOwnerKey);
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state = 1;
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >*>(static_cast<CheckPersistentMoveKeysLockActor*>(this)));
															#line 2373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckPersistentMoveKeysLockActorState();
		static_cast<CheckPersistentMoveKeysLockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& readVal,int loopDepth) 
	{
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentOwner == lock.prevOwner)
															#line 2398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(moveKeysLockWriteKey);
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state = 2;
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >*>(static_cast<CheckPersistentMoveKeysLockActor*>(this)));
															#line 2409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (currentOwner == lock.myOwner)
															#line 2416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (isWrite)
															#line 2420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					BinaryWriter wrLastWrite(Unversioned());
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					wrLastWrite << deterministicRandom()->randomUniqueID();
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					tr->makeSelfConflicting();
															#line 2430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckPersistentMoveKeysLockActorState(); static_cast<CheckPersistentMoveKeysLockActor*>(this)->destroy(); return 0; }
															#line 2434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				new (&static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckPersistentMoveKeysLockActorState();
				static_cast<CheckPersistentMoveKeysLockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				CODE_PROBE(true, "checkMoveKeysLock: Conflict with new owner");
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevDebug, "CheckPersistentMoveKeysLockOwnerConflict") .errorUnsuppressed(movekeys_conflict()) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("CurrentOwner", currentOwner.toString());
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && readVal,int loopDepth) 
	{
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentOwner == lock.prevOwner)
															#line 2460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(moveKeysLockWriteKey);
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state = 2;
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >*>(static_cast<CheckPersistentMoveKeysLockActor*>(this)));
															#line 2471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (currentOwner == lock.myOwner)
															#line 2478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (isWrite)
															#line 2482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					BinaryWriter wrLastWrite(Unversioned());
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					wrLastWrite << deterministicRandom()->randomUniqueID();
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					tr->makeSelfConflicting();
															#line 2492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckPersistentMoveKeysLockActorState(); static_cast<CheckPersistentMoveKeysLockActor*>(this)->destroy(); return 0; }
															#line 2496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				new (&static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckPersistentMoveKeysLockActorState();
				static_cast<CheckPersistentMoveKeysLockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				CODE_PROBE(true, "checkMoveKeysLock: Conflict with new owner");
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevDebug, "CheckPersistentMoveKeysLockOwnerConflict") .errorUnsuppressed(movekeys_conflict()) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("CurrentOwner", currentOwner.toString());
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& readVal,int loopDepth) 
	{
		loopDepth = a_body1cont1(readVal, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && readVal,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(readVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPersistentMoveKeysLockActor*>(this)->ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPersistentMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPersistentMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPersistentMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Optional<Value> const& readVal,int loopDepth) 
	{
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UID lastWrite = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (lastWrite != lock.prevWrite)
															#line 2597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			CODE_PROBE(true, "checkMoveKeysLock: Conflict with previous owner");
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "CheckPersistentMoveKeysWritterConflict") .errorUnsuppressed(movekeys_conflict()) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("CurrentOwner", currentOwner.toString()) .detail("Writer", lastWrite.toString());
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (isWrite)
															#line 2609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			BinaryWriter wrMyOwner(Unversioned());
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			wrMyOwner << lock.myOwner;
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(moveKeysLockOwnerKey, wrMyOwner.toValue());
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			BinaryWriter wrLastWrite(Unversioned());
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID lastWriter = deterministicRandom()->randomUniqueID();
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			wrLastWrite << lastWriter;
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent("CheckMoveKeysLock") .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("Writer", lastWriter.toString());
															#line 2627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckPersistentMoveKeysLockActorState(); static_cast<CheckPersistentMoveKeysLockActor*>(this)->destroy(); return 0; }
															#line 2631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckPersistentMoveKeysLockActorState();
		static_cast<CheckPersistentMoveKeysLockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> && readVal,int loopDepth) 
	{
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UID lastWrite = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (lastWrite != lock.prevWrite)
															#line 2645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			CODE_PROBE(true, "checkMoveKeysLock: Conflict with previous owner");
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "CheckPersistentMoveKeysWritterConflict") .errorUnsuppressed(movekeys_conflict()) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("CurrentOwner", currentOwner.toString()) .detail("Writer", lastWrite.toString());
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (isWrite)
															#line 2657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			BinaryWriter wrMyOwner(Unversioned());
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			wrMyOwner << lock.myOwner;
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(moveKeysLockOwnerKey, wrMyOwner.toValue());
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			BinaryWriter wrLastWrite(Unversioned());
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID lastWriter = deterministicRandom()->randomUniqueID();
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			wrLastWrite << lastWriter;
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent("CheckMoveKeysLock") .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("Writer", lastWriter.toString());
															#line 2675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckPersistentMoveKeysLockActorState(); static_cast<CheckPersistentMoveKeysLockActor*>(this)->destroy(); return 0; }
															#line 2679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckPersistentMoveKeysLockActorState();
		static_cast<CheckPersistentMoveKeysLockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& readVal,int loopDepth) 
	{
		loopDepth = a_body1cont3(readVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && readVal,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(readVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPersistentMoveKeysLockActor*>(this)->ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPersistentMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPersistentMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPersistentMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction* tr;
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool isWrite;
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID currentOwner;
															#line 2770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via checkPersistentMoveKeysLock()
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckPersistentMoveKeysLockActor final : public Actor<Void>, public ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >, public ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >, public FastAllocated<CheckPersistentMoveKeysLockActor>, public CheckPersistentMoveKeysLockActorState<CheckPersistentMoveKeysLockActor> {
															#line 2775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<CheckPersistentMoveKeysLockActor>::operator new;
	using FastAllocated<CheckPersistentMoveKeysLockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10383010694051433984UL, 16964656447352297472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >;
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckPersistentMoveKeysLockActor(Transaction* const& tr,MoveKeysLock const& lock,bool const& isWrite = true) 
															#line 2793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   CheckPersistentMoveKeysLockActorState<CheckPersistentMoveKeysLockActor>(tr, lock, isWrite),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6644785154087050496UL, 6768596532248216832UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPersistentMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkPersistentMoveKeysLock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] static Future<Void> checkPersistentMoveKeysLock( Transaction* const& tr, MoveKeysLock const& lock, bool const& isWrite = true ) {
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new CheckPersistentMoveKeysLockActor(tr, lock, isWrite));
															#line 2827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 377 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

Future<Void> checkMoveKeysLock(Transaction* tr,
                               MoveKeysLock const& lock,
                               const DDEnabledState* ddEnabledState,
                               bool isWrite) {
	if (!ddEnabledState->isEnabled()) {
		TraceEvent(SevDebug, "DDDisabledByInMemoryCheck").log();
		throw movekeys_conflict();
	}
	return checkPersistentMoveKeysLock(tr, lock, isWrite);
}

Future<Void> checkMoveKeysLockReadOnly(Transaction* tr, MoveKeysLock lock, const DDEnabledState* ddEnabledState) {
	return checkMoveKeysLock(tr, lock, ddEnabledState, false);
}

namespace {
															#line 2848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via checkReadWrite()
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class CheckReadWriteActor>
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckReadWriteActorState {
															#line 2854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckReadWriteActorState(Future<ErrorOr<GetShardStateReply>> const& fReply,UID const& uid,Version const& version) 
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : fReply(fReply),
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   uid(uid),
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   version(version)
															#line 2865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("checkReadWrite", reinterpret_cast<unsigned long>(this));

	}
	~CheckReadWriteActorState() 
	{
		fdb_probe_actor_destroy("checkReadWrite", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<ErrorOr<GetShardStateReply>> __when_expr_0 = fReply;
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckReadWriteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckReadWriteActor*>(this)->actor_wait_state = 1;
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >*>(static_cast<CheckReadWriteActor*>(this)));
															#line 2887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckReadWriteActorState();
		static_cast<CheckReadWriteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<GetShardStateReply> const& reply,int loopDepth) 
	{
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!reply.present() || reply.get().first < version)
															#line 2910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!static_cast<CheckReadWriteActor*>(this)->SAV<Optional<UID>>::futures) { (void)(Optional<UID>()); this->~CheckReadWriteActorState(); static_cast<CheckReadWriteActor*>(this)->destroy(); return 0; }
															#line 2914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			new (&static_cast<CheckReadWriteActor*>(this)->SAV< Optional<UID> >::value()) Optional<UID>(Optional<UID>());
			this->~CheckReadWriteActorState();
			static_cast<CheckReadWriteActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<CheckReadWriteActor*>(this)->SAV<Optional<UID>>::futures) { (void)(Optional<UID>(uid)); this->~CheckReadWriteActorState(); static_cast<CheckReadWriteActor*>(this)->destroy(); return 0; }
															#line 2922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<CheckReadWriteActor*>(this)->SAV< Optional<UID> >::value()) Optional<UID>(Optional<UID>(uid));
		this->~CheckReadWriteActorState();
		static_cast<CheckReadWriteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<GetShardStateReply> && reply,int loopDepth) 
	{
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!reply.present() || reply.get().first < version)
															#line 2934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!static_cast<CheckReadWriteActor*>(this)->SAV<Optional<UID>>::futures) { (void)(Optional<UID>()); this->~CheckReadWriteActorState(); static_cast<CheckReadWriteActor*>(this)->destroy(); return 0; }
															#line 2938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			new (&static_cast<CheckReadWriteActor*>(this)->SAV< Optional<UID> >::value()) Optional<UID>(Optional<UID>());
			this->~CheckReadWriteActorState();
			static_cast<CheckReadWriteActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<CheckReadWriteActor*>(this)->SAV<Optional<UID>>::futures) { (void)(Optional<UID>(uid)); this->~CheckReadWriteActorState(); static_cast<CheckReadWriteActor*>(this)->destroy(); return 0; }
															#line 2946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<CheckReadWriteActor*>(this)->SAV< Optional<UID> >::value()) Optional<UID>(Optional<UID>(uid));
		this->~CheckReadWriteActorState();
		static_cast<CheckReadWriteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<GetShardStateReply> const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<GetShardStateReply> && reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckReadWriteActor*>(this)->actor_wait_state > 0) static_cast<CheckReadWriteActor*>(this)->actor_wait_state = 0;
		static_cast<CheckReadWriteActor*>(this)->ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >*,ErrorOr<GetShardStateReply> const& value) 
	{
		fdb_probe_actor_enter("checkReadWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckReadWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkReadWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >*,ErrorOr<GetShardStateReply> && value) 
	{
		fdb_probe_actor_enter("checkReadWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckReadWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkReadWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >*,Error err) 
	{
		fdb_probe_actor_enter("checkReadWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckReadWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkReadWrite", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Future<ErrorOr<GetShardStateReply>> fReply;
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID uid;
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Version version;
															#line 3035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via checkReadWrite()
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckReadWriteActor final : public Actor<Optional<UID>>, public ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >, public FastAllocated<CheckReadWriteActor>, public CheckReadWriteActorState<CheckReadWriteActor> {
															#line 3040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<CheckReadWriteActor>::operator new;
	using FastAllocated<CheckReadWriteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6036151976672303872UL, 14958765323072762624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<UID>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >;
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckReadWriteActor(Future<ErrorOr<GetShardStateReply>> const& fReply,UID const& uid,Version const& version) 
															#line 3057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Optional<UID>>(),
		   CheckReadWriteActorState<CheckReadWriteActor>(fReply, uid, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkReadWrite", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12330645937060475904UL, 6831126454717508352UL);
		ActorExecutionContextHelper __helper(static_cast<CheckReadWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkReadWrite");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkReadWrite", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Optional<UID>> checkReadWrite( Future<ErrorOr<GetShardStateReply>> const& fReply, UID const& uid, Version const& version ) {
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Optional<UID>>(new CheckReadWriteActor(fReply, uid, version));
															#line 3089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 400 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

// Must propagate corruption signal to outside
															#line 3095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via validateRangeAssignment()
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class ValidateRangeAssignmentActor>
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class ValidateRangeAssignmentActorState {
															#line 3101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	ValidateRangeAssignmentActorState(Database const& occ,Transaction* const& tr,KeyRange const& range,UID const& ssid,std::string const& context,UID const& dataMoveId) 
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tr(tr),
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   range(range),
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ssid(ssid),
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   context(context),
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId)
															#line 3118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("validateRangeAssignment", reinterpret_cast<unsigned long>(this));

	}
	~ValidateRangeAssignmentActorState() 
	{
		fdb_probe_actor_destroy("validateRangeAssignment", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(!range.empty());
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			toReadRangeBegin = range.begin;
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			allCorrect = true;
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 3141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateRangeAssignmentActorState();
		static_cast<ValidateRangeAssignmentActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!allCorrect)
															#line 3164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
			try {
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_1 = success(setDDMode(occ, 2));
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state = 2;
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateRangeAssignmentActor, 1, Void >*>(static_cast<ValidateRangeAssignmentActor*>(this)));
															#line 3176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(tr, serverKeysPrefixFor(ssid), KeyRangeRef(toReadRangeBegin, range.end), CLIENT_KNOBS->KRM_GET_RANGE_LIMIT, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT_BYTES);
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3205 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state = 1;
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >*>(static_cast<ValidateRangeAssignmentActor*>(this)));
															#line 3210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult const& readResult,int loopDepth) 
	{
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;i++) {
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID shardId;
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool assigned, emptyRange;
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			DataMoveType dataMoveType = DataMoveType::LOGICAL;
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			DataMovementReason dataMoveReason = DataMovementReason::INVALID;
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeServerKeysValue(readResult[i].value, assigned, emptyRange, dataMoveType, shardId, dataMoveReason);
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!assigned)
															#line 3244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevError, "ValidateRangeAssignmentCorruptionDetected") .setMaxFieldLength(-1) .setMaxEventLength(-1) .detail("DataMoveID", dataMoveId) .detail("Context", context) .detail("AuditRange", range) .detail("ErrorMessage", "KeyServers has range but ServerKeys does not have") .detail("CurrentEmptyRange", emptyRange) .detail("CurrentAssignment", assigned) .detail("DataMoveType", static_cast<uint8_t>(dataMoveType)) .detail("ServerID", ssid) .detail("ShardID", shardId);
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				allCorrect = false;
															#line 3250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!allCorrect)
															#line 3255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readResult.back().key < range.end)
															#line 3261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			toReadRangeBegin = readResult.back().key;
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarnAlways, "ValidateRangeAssignmentMultipleReads") .detail("DataMoveID", dataMoveId) .detail("Range", range) .detail("StorageServer", ssid);
															#line 3267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult && readResult,int loopDepth) 
	{
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;i++) {
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID shardId;
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool assigned, emptyRange;
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			DataMoveType dataMoveType = DataMoveType::LOGICAL;
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			DataMovementReason dataMoveReason = DataMovementReason::INVALID;
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeServerKeysValue(readResult[i].value, assigned, emptyRange, dataMoveType, shardId, dataMoveReason);
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!assigned)
															#line 3293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevError, "ValidateRangeAssignmentCorruptionDetected") .setMaxFieldLength(-1) .setMaxEventLength(-1) .detail("DataMoveID", dataMoveId) .detail("Context", context) .detail("AuditRange", range) .detail("ErrorMessage", "KeyServers has range but ServerKeys does not have") .detail("CurrentEmptyRange", emptyRange) .detail("CurrentAssignment", assigned) .detail("DataMoveType", static_cast<uint8_t>(dataMoveType)) .detail("ServerID", ssid) .detail("ShardID", shardId);
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				allCorrect = false;
															#line 3299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!allCorrect)
															#line 3304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readResult.back().key < range.end)
															#line 3310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			toReadRangeBegin = readResult.back().key;
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarnAlways, "ValidateRangeAssignmentMultipleReads") .detail("DataMoveID", dataMoveId) .detail("Range", range) .detail("StorageServer", ssid);
															#line 3316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& readResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(readResult, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && readResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(readResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state > 0) static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateRangeAssignmentActor*>(this)->ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateRangeAssignmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateRangeAssignmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateRangeAssignmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 472 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<ValidateRangeAssignmentActor*>(this)->SAV<bool>::futures) { (void)(allCorrect); this->~ValidateRangeAssignmentActorState(); static_cast<ValidateRangeAssignmentActor*>(this)->destroy(); return 0; }
															#line 3405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<ValidateRangeAssignmentActor*>(this)->SAV< bool >::value()) bool(std::move(allCorrect)); // state_var_RVO
		this->~ValidateRangeAssignmentActorState();
		static_cast<ValidateRangeAssignmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarnAlways, "ValidateRangeAssignmentCorruptionDetectedButFailedToStopDD") .detail("DataMoveID", dataMoveId) .detail("Range", range) .detail("StorageServer", ssid);
															#line 3424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "ValidateRangeAssignmentCorruptionDetectedAndDDStopped") .detail("DataMoveID", dataMoveId) .detail("Range", range) .detail("StorageServer", ssid);
															#line 3439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "ValidateRangeAssignmentCorruptionDetectedAndDDStopped") .detail("DataMoveID", dataMoveId) .detail("Range", range) .detail("StorageServer", ssid);
															#line 3448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state > 0) static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateRangeAssignmentActor*>(this)->ActorCallback< ValidateRangeAssignmentActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateRangeAssignmentActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateRangeAssignmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateRangeAssignmentActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateRangeAssignmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateRangeAssignmentActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateRangeAssignmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction* tr;
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange range;
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID ssid;
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::string context;
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key toReadRangeBegin;
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool allCorrect;
															#line 3557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via validateRangeAssignment()
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class ValidateRangeAssignmentActor final : public Actor<bool>, public ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >, public ActorCallback< ValidateRangeAssignmentActor, 1, Void >, public FastAllocated<ValidateRangeAssignmentActor>, public ValidateRangeAssignmentActorState<ValidateRangeAssignmentActor> {
															#line 3562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<ValidateRangeAssignmentActor>::operator new;
	using FastAllocated<ValidateRangeAssignmentActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5087247297494765824UL, 1933962227069942016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >;
friend struct ActorCallback< ValidateRangeAssignmentActor, 1, Void >;
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	ValidateRangeAssignmentActor(Database const& occ,Transaction* const& tr,KeyRange const& range,UID const& ssid,std::string const& context,UID const& dataMoveId) 
															#line 3580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<bool>(),
		   ValidateRangeAssignmentActorState<ValidateRangeAssignmentActor>(occ, tr, range, ssid, context, dataMoveId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateRangeAssignment", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1410897700964751360UL, 1906203362245434880UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateRangeAssignmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateRangeAssignment");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateRangeAssignment", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateRangeAssignmentActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<bool> validateRangeAssignment( Database const& occ, Transaction* const& tr, KeyRange const& range, UID const& ssid, std::string const& context, UID const& dataMoveId ) {
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<bool>(new ValidateRangeAssignmentActor(occ, tr, range, ssid, context, dataMoveId));
															#line 3613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 474 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 3618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via auditLocationMetadataPreCheck()
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class AuditLocationMetadataPreCheckActor>
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AuditLocationMetadataPreCheckActorState {
															#line 3624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AuditLocationMetadataPreCheckActorState(Database const& occ,Transaction* const& tr,KeyRange const& range,std::vector<UID> const& servers,std::string const& context,UID const& dataMoveId) 
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tr(tr),
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   range(range),
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   servers(servers),
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   context(context),
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId)
															#line 3641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this));

	}
	~AuditLocationMetadataPreCheckActorState() 
	{
		fdb_probe_actor_destroy("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (range.empty())
															#line 3656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 482 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevWarn, "CheckLocationMetadataEmptyInputRange").detail("By", "PreCheck").detail("Range", range);
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!static_cast<AuditLocationMetadataPreCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditLocationMetadataPreCheckActorState(); static_cast<AuditLocationMetadataPreCheckActor*>(this)->destroy(); return 0; }
															#line 3662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				new (&static_cast<AuditLocationMetadataPreCheckActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~AuditLocationMetadataPreCheckActorState();
				static_cast<AuditLocationMetadataPreCheckActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors = std::vector<Future<Void>>();
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			results = std::unordered_map<UID, Optional<bool>>();
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevVerbose, "CheckLocationMetadataStart") .detail("By", "PreCheck") .detail("DataMoveID", dataMoveId) .detail("Servers", describe(servers)) .detail("Context", context) .detail("Range", range);
															#line 3674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			try {
															#line 494 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.clear();
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				results.clear();
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				for( const auto& ssid : servers ) {
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					actors.push_back(store(results[ssid], validateRangeAssignment(occ, tr, range, ssid, context, dataMoveId)));
															#line 3684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAllReadyThenThrow(actors);
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<AuditLocationMetadataPreCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<AuditLocationMetadataPreCheckActor*>(this)->actor_wait_state = 1;
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >*>(static_cast<AuditLocationMetadataPreCheckActor*>(this)));
															#line 3695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AuditLocationMetadataPreCheckActorState();
		static_cast<AuditLocationMetadataPreCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<AuditLocationMetadataPreCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditLocationMetadataPreCheckActorState(); static_cast<AuditLocationMetadataPreCheckActor*>(this)->destroy(); return 0; }
															#line 3724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<AuditLocationMetadataPreCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AuditLocationMetadataPreCheckActorState();
		static_cast<AuditLocationMetadataPreCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() == error_code_actor_cancelled || e.code() == error_code_location_metadata_corruption)
															#line 3737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 520 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevInfo, "CheckLocationMetadataFailed") .errorUnsuppressed(e) .detail("By", "PreCheck") .detail("DataMoveID", dataMoveId) .detail("Context", context) .detail("Range", range);
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				for( const auto& [ssid, res] : results ) {
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (res.present() && !res.get())
															#line 3751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					{
															#line 531 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						TraceEvent(SevError, "CheckLocationMetadataCorruptionDetectedWhenFailed") .detail("By", "PreCheck") .detail("DataMoveID", dataMoveId) .detail("Servers", describe(servers)) .detail("Context", context) .detail("Range", range);
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						return a_body1Catch1(location_metadata_corruption(), loopDepth);
															#line 3757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					}
				}
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& [ssid, res] : results ) {
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(res.present());
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!res.get())
															#line 3779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevError, "CheckLocationMetadataCorruptionDetected") .detail("By", "PreCheck") .detail("DataMoveID", dataMoveId) .detail("Servers", describe(servers)) .detail("Context", context) .detail("Range", range);
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch2(location_metadata_corruption(), loopDepth);
															#line 3785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevVerbose, "CheckLocationMetadataComplete") .detail("By", "PreCheck") .detail("DataMoveID", dataMoveId) .detail("Servers", describe(servers)) .detail("Context", context) .detail("Range", range);
															#line 3790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& [ssid, res] : results ) {
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(res.present());
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!res.get())
															#line 3803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevError, "CheckLocationMetadataCorruptionDetected") .detail("By", "PreCheck") .detail("DataMoveID", dataMoveId) .detail("Servers", describe(servers)) .detail("Context", context) .detail("Range", range);
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch2(location_metadata_corruption(), loopDepth);
															#line 3809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevVerbose, "CheckLocationMetadataComplete") .detail("By", "PreCheck") .detail("DataMoveID", dataMoveId) .detail("Servers", describe(servers)) .detail("Context", context) .detail("Range", range);
															#line 3814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AuditLocationMetadataPreCheckActor*>(this)->actor_wait_state > 0) static_cast<AuditLocationMetadataPreCheckActor*>(this)->actor_wait_state = 0;
		static_cast<AuditLocationMetadataPreCheckActor*>(this)->ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPreCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPreCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPreCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction* tr;
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange range;
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> servers;
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::string context;
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Void>> actors;
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::unordered_map<UID, Optional<bool>> results;
															#line 3923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via auditLocationMetadataPreCheck()
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AuditLocationMetadataPreCheckActor final : public Actor<Void>, public ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >, public FastAllocated<AuditLocationMetadataPreCheckActor>, public AuditLocationMetadataPreCheckActorState<AuditLocationMetadataPreCheckActor> {
															#line 3928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<AuditLocationMetadataPreCheckActor>::operator new;
	using FastAllocated<AuditLocationMetadataPreCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7278093519940169472UL, 11246418245101746176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >;
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AuditLocationMetadataPreCheckActor(Database const& occ,Transaction* const& tr,KeyRange const& range,std::vector<UID> const& servers,std::string const& context,UID const& dataMoveId) 
															#line 3945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   AuditLocationMetadataPreCheckActorState<AuditLocationMetadataPreCheckActor>(occ, tr, range, servers, context, dataMoveId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14141982025076651776UL, 5931598278174956800UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPreCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("auditLocationMetadataPreCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> auditLocationMetadataPreCheck( Database const& occ, Transaction* const& tr, KeyRange const& range, std::vector<UID> const& servers, std::string const& context, UID const& dataMoveId ) {
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new AuditLocationMetadataPreCheckActor(occ, tr, range, servers, context, dataMoveId));
															#line 3977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 545 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 3982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via auditLocationMetadataPostCheck()
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class AuditLocationMetadataPostCheckActor>
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AuditLocationMetadataPostCheckActorState {
															#line 3988 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AuditLocationMetadataPostCheckActorState(Database const& occ,KeyRange const& range,std::string const& context,UID const& dataMoveId) 
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   range(range),
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   context(context),
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId)
															#line 4001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this));

	}
	~AuditLocationMetadataPostCheckActorState() 
	{
		fdb_probe_actor_destroy("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (range.empty())
															#line 4016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "CheckLocationMetadataEmptyInputRange") .detail("By", "PostCheck") .detail("Range", range) .detail("Context", context) .detail("DataMoveId", dataMoveId.toString());
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!static_cast<AuditLocationMetadataPostCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditLocationMetadataPostCheckActorState(); static_cast<AuditLocationMetadataPostCheckActor*>(this)->destroy(); return 0; }
															#line 4022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				new (&static_cast<AuditLocationMetadataPostCheckActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~AuditLocationMetadataPostCheckActorState();
				static_cast<AuditLocationMetadataPostCheckActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors = std::vector<Future<Void>>();
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			results = std::unordered_map<uint64_t, Optional<bool>>();
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			rangeToReadBegin = range.begin;
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			readResultKS = RangeResult();
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UIDtoTagMap = RangeResult();
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr = Transaction(occ);
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			retryCount = 0;
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevVerbose, "CheckLocationMetadataStart") .detail("By", "PostCheck") .detail("Context", context) .detail("Range", range);
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 4046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AuditLocationMetadataPostCheckActorState();
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<AuditLocationMetadataPostCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditLocationMetadataPostCheckActorState(); static_cast<AuditLocationMetadataPostCheckActor*>(this)->destroy(); return 0; }
															#line 4069 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<AuditLocationMetadataPostCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AuditLocationMetadataPostCheckActorState();
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 4089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() == error_code_actor_cancelled || e.code() == error_code_location_metadata_corruption)
															#line 4124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				for( const auto& [idx, res] : results ) {
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (res.present() && !res.get())
															#line 4136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					{
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						TraceEvent(SevError, "CheckLocationMetadataCorruptionDetectedWhenFailed") .detail("By", "PostCheck") .detail("DataMoveID", dataMoveId) .detail("Context", context) .detail("Range", range);
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						return a_body1Catch1(location_metadata_corruption(), std::max(0, loopDepth - 1));
															#line 4142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					}
				}
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (retryCount > SERVER_KNOBS->AUDIT_DATAMOVE_POST_CHECK_RETRY_COUNT_MAX)
															#line 4147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 652 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					TraceEvent(SevInfo, "CheckLocationMetadataFailed") .errorUnsuppressed(e) .detail("By", "PostCheck") .detail("DataMoveID", dataMoveId) .detail("Context", context) .detail("Range", range);
															#line 4151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = a_body1loopBody1Catch1cont3(loopDepth);
				}
				else
				{
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Void> __when_expr_3 = delay(0.5);
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
					static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 4;
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >*>(static_cast<AuditLocationMetadataPostCheckActor*>(this)));
															#line 4165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.clear();
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			readResultKS.clear();
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			results.clear();
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.trState->taskID = TaskPriority::MoveKeys;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(store(readResultKS, krmGetRanges(&tr, keyServersPrefix, KeyRangeRef(rangeToReadBegin, range.end), CLIENT_KNOBS->KRM_GET_RANGE_LIMIT, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT_BYTES)));
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(store(UIDtoTagMap, tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY)));
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(actors);
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 1;
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >*>(static_cast<AuditLocationMetadataPostCheckActor*>(this)));
															#line 4219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 3;
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >*>(static_cast<AuditLocationMetadataPostCheckActor*>(this)));
															#line 4261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevVerbose, "CheckLocationMetadataReadDone") .detail("By", "PostCheck") .detail("ResultSize", readResultKS.size());
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		actors.clear();
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		resIdx = 0;
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < readResultKS.size() - 1;++i) {
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID srcID;
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID destID;
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, readResultKS[i].value, src, dest, srcID, destID);
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> servers(src.size() + dest.size());
															#line 599 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), servers.begin());
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const auto& ssid : servers ) {
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.push_back( store(results[resIdx], validateRangeAssignment(occ, &tr, KeyRangeRef(readResultKS[i].key, readResultKS[i + 1].key), ssid, context, dataMoveId)));
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				++resIdx;
															#line 4304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAllReadyThenThrow(actors);
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 2;
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >*>(static_cast<AuditLocationMetadataPostCheckActor*>(this)));
															#line 4316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevVerbose, "CheckLocationMetadataReadDone") .detail("By", "PostCheck") .detail("ResultSize", readResultKS.size());
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		actors.clear();
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		resIdx = 0;
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < readResultKS.size() - 1;++i) {
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID srcID;
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID destID;
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, readResultKS[i].value, src, dest, srcID, destID);
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> servers(src.size() + dest.size());
															#line 599 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), servers.begin());
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const auto& ssid : servers ) {
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.push_back( store(results[resIdx], validateRangeAssignment(occ, &tr, KeyRangeRef(readResultKS[i].key, readResultKS[i + 1].key), ssid, context, dataMoveId)));
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				++resIdx;
															#line 4353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAllReadyThenThrow(actors);
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 2;
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >*>(static_cast<AuditLocationMetadataPostCheckActor*>(this)));
															#line 4365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state > 0) static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 0;
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& [idx, res] : results ) {
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(res.present());
															#line 615 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!res.get())
															#line 4453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1loopBody1loopBody1Catch1(location_metadata_corruption(), loopDepth);
															#line 4457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readResultKS.back().key < range.end)
															#line 4462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			rangeToReadBegin = readResultKS.back().key;
															#line 4466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			return a_body1loopBody1loopHead1(loopDepth); // continue
		}
		else
		{
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevVerbose, "CheckLocationMetadataComplete") .detail("By", "PostCheck") .detail("DataMoveID", dataMoveId) .detail("Context", context) .detail("Range", range);
															#line 4473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& [idx, res] : results ) {
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(res.present());
															#line 615 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!res.get())
															#line 4487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1loopBody1loopBody1Catch1(location_metadata_corruption(), loopDepth);
															#line 4491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readResultKS.back().key < range.end)
															#line 4496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			rangeToReadBegin = readResultKS.back().key;
															#line 4500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			return a_body1loopBody1loopHead1(loopDepth); // continue
		}
		else
		{
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevVerbose, "CheckLocationMetadataComplete") .detail("By", "PostCheck") .detail("DataMoveID", dataMoveId) .detail("Context", context) .detail("Range", range);
															#line 4507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state > 0) static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 0;
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retryCount++;
															#line 4592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retryCount++;
															#line 4601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state > 0) static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 0;
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(Void const& _,int loopDepth) 
	{
															#line 661 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retryCount++;
															#line 4697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(Void && _,int loopDepth) 
	{
															#line 661 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retryCount++;
															#line 4706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state > 0) static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 0;
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange range;
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::string context;
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Void>> actors;
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::unordered_map<uint64_t, Optional<bool>> results;
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key rangeToReadBegin;
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult readResultKS;
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int retryCount;
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	uint64_t resIdx;
															#line 4810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via auditLocationMetadataPostCheck()
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AuditLocationMetadataPostCheckActor final : public Actor<Void>, public ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >, public ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >, public ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >, public ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >, public FastAllocated<AuditLocationMetadataPostCheckActor>, public AuditLocationMetadataPostCheckActorState<AuditLocationMetadataPostCheckActor> {
															#line 4815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<AuditLocationMetadataPostCheckActor>::operator new;
	using FastAllocated<AuditLocationMetadataPostCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6946068843265958912UL, 7673271359409127680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >;
friend struct ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >;
friend struct ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >;
friend struct ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >;
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AuditLocationMetadataPostCheckActor(Database const& occ,KeyRange const& range,std::string const& context,UID const& dataMoveId) 
															#line 4835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   AuditLocationMetadataPostCheckActorState<AuditLocationMetadataPostCheckActor>(occ, range, context, dataMoveId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2581926754743871744UL, 6396892187787654656UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("auditLocationMetadataPostCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> auditLocationMetadataPostCheck( Database const& occ, KeyRange const& range, std::string const& context, UID const& dataMoveId ) {
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new AuditLocationMetadataPostCheckActor(occ, range, context, dataMoveId));
															#line 4870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 668 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

// Cleans up dest servers of a single shard, and unassigns the keyrange from the dest servers if necessary.
															#line 4876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via cleanUpSingleShardDataMove()
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class CleanUpSingleShardDataMoveActor>
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CleanUpSingleShardDataMoveActorState {
															#line 4882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CleanUpSingleShardDataMoveActorState(Database const& occ,KeyRange const& keys,MoveKeysLock const& lock,FlowLock* const& cleanUpDataMoveParallelismLock,UID const& dataMoveId,const DDEnabledState* const& ddEnabledState) 
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   keys(keys),
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   lock(lock),
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   cleanUpDataMoveParallelismLock(cleanUpDataMoveParallelismLock),
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId),
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ddEnabledState(ddEnabledState)
															#line 4899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this));

	}
	~CleanUpSingleShardDataMoveActorState() 
	{
		fdb_probe_actor_destroy("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevInfo, "CleanUpSingleShardDataMoveBegin", dataMoveId).detail("Range", keys);
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			runPreCheck = true;
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 4920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CleanUpSingleShardDataMoveActorState();
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "CleanUpSingleShardDataMoveEnd", dataMoveId).detail("Range", keys);
															#line 766 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<CleanUpSingleShardDataMoveActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanUpSingleShardDataMoveActorState(); static_cast<CleanUpSingleShardDataMoveActor*>(this)->destroy(); return 0; }
															#line 4945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<CleanUpSingleShardDataMoveActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CleanUpSingleShardDataMoveActorState();
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 682 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr = Transaction(occ);
															#line 4964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.trState->taskID = TaskPriority::MoveKeys;
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, keyServersPrefix, keys, SERVER_KNOBS->MOVE_SHARD_KRM_ROW_LIMIT, SERVER_KNOBS->MOVE_SHARD_KRM_BYTE_LIMIT);
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 1;
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 4981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 750 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			err = e;
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (err.code() == error_code_location_metadata_corruption)
															#line 5018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch1(location_metadata_corruption(), std::max(0, loopDepth - 1));
															#line 5022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				runPreCheck = false;
															#line 755 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_6 = tr.onError(err);
															#line 755 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
				static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 7;
															#line 755 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!currentShards.empty() && !currentShards.more);
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 2;
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __currentShards,int loopDepth) 
	{
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentShards = __currentShards;
															#line 5071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __currentShards,int loopDepth) 
	{
		currentShards = std::move(__currentShards);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state > 0) static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 697 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (KeyRangeRef(currentShards[0].key, currentShards[1].key) != keys)
															#line 5152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1loopBody1Catch1(operation_cancelled(), loopDepth);
															#line 5156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		src = std::vector<UID>();
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dest = std::vector<UID>();
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		srcId = UID();
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		destId = UID();
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, currentShards[0].value, src, dest, srcId, destId);
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (dest.empty() || destId != anonymousShardId)
															#line 5170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!static_cast<CleanUpSingleShardDataMoveActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanUpSingleShardDataMoveActorState(); static_cast<CleanUpSingleShardDataMoveActor*>(this)->destroy(); return 0; }
															#line 5174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			new (&static_cast<CleanUpSingleShardDataMoveActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CleanUpSingleShardDataMoveActorState();
			static_cast<CleanUpSingleShardDataMoveActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 714 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (SERVER_KNOBS->AUDIT_DATAMOVE_PRE_CHECK && runPreCheck)
															#line 5182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> servers(src.size() + dest.size());
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), servers.begin());
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_2 = auditLocationMetadataPreCheck( occ, &tr, keys, servers, "cleanUpSingleShardDataMove_precheck", dataMoveId);
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 3;
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 5211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state > 0) static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "CleanUpSingleShardDataMove", dataMoveId) .detail("Range", keys) .detail("Src", describe(src)) .detail("Dest", describe(dest)) .detail("SrcID", srcId) .detail("DestID", destId) .detail("ReadVersion", tr.getReadVersion().get());
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		krmSetPreviouslyEmptyRange( &tr, keyServersPrefix, keys, keyServersValue(UIDtoTagMap, src, {}), currentShards[1].value);
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Void>> actors;
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& uid : dest ) {
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (std::find(src.begin(), src.end(), uid) == src.end())
															#line 5298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.push_back( krmSetRangeCoalescing(&tr, serverKeysPrefixFor(uid), keys, allKeys, serverKeysFalse));
															#line 5302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(actors);
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 4;
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state > 0) static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr.commit();
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 5;
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr.commit();
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 5;
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state > 0) static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (SERVER_KNOBS->AUDIT_DATAMOVE_POST_CHECK)
															#line 5517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_5 = auditLocationMetadataPostCheck(occ, keys, "cleanUpSingleShardDataMove_postcheck", dataMoveId);
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont11when1(__when_expr_5.get(), loopDepth); };
			static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 6;
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (SERVER_KNOBS->AUDIT_DATAMOVE_POST_CHECK)
															#line 5542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_5 = auditLocationMetadataPostCheck(occ, keys, "cleanUpSingleShardDataMove_postcheck", dataMoveId);
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont11when1(__when_expr_5.get(), loopDepth); };
			static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 6;
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state > 0) static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont11cont1(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont11cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state > 0) static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevWarn, "CleanUpSingleShardDataMoveRetriableError", dataMoveId) .error(err) .detail("Range", keys);
															#line 5735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state > 0) static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange keys;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock* cleanUpDataMoveParallelismLock;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool runPreCheck;
															#line 682 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult currentShards;
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> src;
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> dest;
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID srcId;
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID destId;
															#line 750 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Error err;
															#line 5857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via cleanUpSingleShardDataMove()
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CleanUpSingleShardDataMoveActor final : public Actor<Void>, public ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >, public ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >, public ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >, public ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >, public ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >, public ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >, public ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >, public FastAllocated<CleanUpSingleShardDataMoveActor>, public CleanUpSingleShardDataMoveActorState<CleanUpSingleShardDataMoveActor> {
															#line 5862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<CleanUpSingleShardDataMoveActor>::operator new;
	using FastAllocated<CleanUpSingleShardDataMoveActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17657745228699059968UL, 13708274127453837568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >;
friend struct ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >;
friend struct ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >;
friend struct ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >;
friend struct ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >;
friend struct ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >;
friend struct ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CleanUpSingleShardDataMoveActor(Database const& occ,KeyRange const& keys,MoveKeysLock const& lock,FlowLock* const& cleanUpDataMoveParallelismLock,UID const& dataMoveId,const DDEnabledState* const& ddEnabledState) 
															#line 5885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   CleanUpSingleShardDataMoveActorState<CleanUpSingleShardDataMoveActor>(occ, keys, lock, cleanUpDataMoveParallelismLock, dataMoveId, ddEnabledState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5109264975150891520UL, 10929003504954912000UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cleanUpSingleShardDataMove");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> cleanUpSingleShardDataMove( Database const& occ, KeyRange const& keys, MoveKeysLock const& lock, FlowLock* const& cleanUpDataMoveParallelismLock, UID const& dataMoveId, const DDEnabledState* const& ddEnabledState ) {
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new CleanUpSingleShardDataMoveActor(occ, keys, lock, cleanUpDataMoveParallelismLock, dataMoveId, ddEnabledState));
															#line 5923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 768 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

Future<Void> removeOldDestinations(Reference<ReadYourWritesTransaction> tr,
                                   UID oldDest,
                                   VectorRef<KeyRangeRef> shards,
                                   KeyRangeRef currentKeys) {
	KeyRef beginKey = currentKeys.begin;

	std::vector<Future<Void>> actors;
	for (int i = 0; i < shards.size(); i++) {
		if (beginKey < shards[i].begin)
			actors.push_back(krmSetRangeCoalescing(
			    tr, serverKeysPrefixFor(oldDest), KeyRangeRef(beginKey, shards[i].begin), allKeys, serverKeysFalse));

		beginKey = shards[i].end;
	}

	if (beginKey < currentKeys.end)
		actors.push_back(krmSetRangeCoalescing(
		    tr, serverKeysPrefixFor(oldDest), KeyRangeRef(beginKey, currentKeys.end), allKeys, serverKeysFalse));

	return waitForAll(actors);
}

															#line 5950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via addReadWriteDestinations()
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class AddReadWriteDestinationsActor>
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AddReadWriteDestinationsActorState {
															#line 5956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AddReadWriteDestinationsActorState(KeyRangeRef const& shard,std::vector<StorageServerInterface> const& srcInterfs,std::vector<StorageServerInterface> const& destInterfs,Version const& version,int const& desiredHealthy,int const& maxServers) 
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : shard(shard),
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   srcInterfs(srcInterfs),
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   destInterfs(destInterfs),
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   version(version),
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   desiredHealthy(desiredHealthy),
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   maxServers(maxServers)
															#line 5973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("addReadWriteDestinations", reinterpret_cast<unsigned long>(this));

	}
	~AddReadWriteDestinationsActorState() 
	{
		fdb_probe_actor_destroy("addReadWriteDestinations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (srcInterfs.size() >= maxServers)
															#line 5988 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!static_cast<AddReadWriteDestinationsActor*>(this)->SAV<std::vector<UID>>::futures) { (void)(std::vector<UID>()); this->~AddReadWriteDestinationsActorState(); static_cast<AddReadWriteDestinationsActor*>(this)->destroy(); return 0; }
															#line 5992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				new (&static_cast<AddReadWriteDestinationsActor*>(this)->SAV< std::vector<UID> >::value()) std::vector<UID>(std::vector<UID>());
				this->~AddReadWriteDestinationsActorState();
				static_cast<AddReadWriteDestinationsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 801 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			srcChecks = std::vector<Future<Optional<UID>>>();
															#line 802 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			srcChecks.reserve(srcInterfs.size());
															#line 803 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < srcInterfs.size();s++) {
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				srcChecks.push_back(checkReadWrite(srcInterfs[s].getShardState.getReplyUnlessFailedFor( GetShardStateRequest(shard, GetShardStateRequest::NO_WAIT), SERVER_KNOBS->SERVER_READY_QUORUM_INTERVAL, 0, TaskPriority::MoveKeys), srcInterfs[s].id(), 0));
															#line 6006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			destChecks = std::vector<Future<Optional<UID>>>();
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			destChecks.reserve(destInterfs.size());
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < destInterfs.size();s++) {
															#line 816 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				destChecks.push_back(checkReadWrite(destInterfs[s].getShardState.getReplyUnlessFailedFor( GetShardStateRequest(shard, GetShardStateRequest::NO_WAIT), SERVER_KNOBS->SERVER_READY_QUORUM_INTERVAL, 0, TaskPriority::MoveKeys), destInterfs[s].id(), version));
															#line 6016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(srcChecks) && waitForAll(destChecks);
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<AddReadWriteDestinationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddReadWriteDestinationsActor*>(this)->actor_wait_state = 1;
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddReadWriteDestinationsActor, 0, Void >*>(static_cast<AddReadWriteDestinationsActor*>(this)));
															#line 6027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddReadWriteDestinationsActorState();
		static_cast<AddReadWriteDestinationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 827 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int healthySrcs = 0;
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( auto it : srcChecks ) {
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (it.get().present())
															#line 6054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				healthySrcs++;
															#line 6058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<UID> result;
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int totalDesired = std::min<int>(desiredHealthy - healthySrcs, maxServers - srcInterfs.size());
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < destInterfs.size() && result.size() < totalDesired;s++) {
															#line 837 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (destChecks[s].get().present())
															#line 6069 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				result.push_back(destChecks[s].get().get());
															#line 6073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<AddReadWriteDestinationsActor*>(this)->SAV<std::vector<UID>>::futures) { (void)(result); this->~AddReadWriteDestinationsActorState(); static_cast<AddReadWriteDestinationsActor*>(this)->destroy(); return 0; }
															#line 6078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<AddReadWriteDestinationsActor*>(this)->SAV< std::vector<UID> >::value()) std::vector<UID>(result);
		this->~AddReadWriteDestinationsActorState();
		static_cast<AddReadWriteDestinationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 827 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int healthySrcs = 0;
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( auto it : srcChecks ) {
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (it.get().present())
															#line 6094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				healthySrcs++;
															#line 6098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<UID> result;
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int totalDesired = std::min<int>(desiredHealthy - healthySrcs, maxServers - srcInterfs.size());
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < destInterfs.size() && result.size() < totalDesired;s++) {
															#line 837 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (destChecks[s].get().present())
															#line 6109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				result.push_back(destChecks[s].get().get());
															#line 6113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<AddReadWriteDestinationsActor*>(this)->SAV<std::vector<UID>>::futures) { (void)(result); this->~AddReadWriteDestinationsActorState(); static_cast<AddReadWriteDestinationsActor*>(this)->destroy(); return 0; }
															#line 6118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<AddReadWriteDestinationsActor*>(this)->SAV< std::vector<UID> >::value()) std::vector<UID>(result);
		this->~AddReadWriteDestinationsActorState();
		static_cast<AddReadWriteDestinationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddReadWriteDestinationsActor*>(this)->actor_wait_state > 0) static_cast<AddReadWriteDestinationsActor*>(this)->actor_wait_state = 0;
		static_cast<AddReadWriteDestinationsActor*>(this)->ActorCallback< AddReadWriteDestinationsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddReadWriteDestinationsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddReadWriteDestinationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddReadWriteDestinationsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddReadWriteDestinationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddReadWriteDestinationsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddReadWriteDestinationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRangeRef shard;
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<StorageServerInterface> srcInterfs;
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<StorageServerInterface> destInterfs;
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Version version;
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int desiredHealthy;
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int maxServers;
															#line 801 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Optional<UID>>> srcChecks;
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Optional<UID>>> destChecks;
															#line 6217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via addReadWriteDestinations()
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AddReadWriteDestinationsActor final : public Actor<std::vector<UID>>, public ActorCallback< AddReadWriteDestinationsActor, 0, Void >, public FastAllocated<AddReadWriteDestinationsActor>, public AddReadWriteDestinationsActorState<AddReadWriteDestinationsActor> {
															#line 6222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<AddReadWriteDestinationsActor>::operator new;
	using FastAllocated<AddReadWriteDestinationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(779552608917206784UL, 16588894056386546432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<UID>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddReadWriteDestinationsActor, 0, Void >;
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AddReadWriteDestinationsActor(KeyRangeRef const& shard,std::vector<StorageServerInterface> const& srcInterfs,std::vector<StorageServerInterface> const& destInterfs,Version const& version,int const& desiredHealthy,int const& maxServers) 
															#line 6239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<std::vector<UID>>(),
		   AddReadWriteDestinationsActorState<AddReadWriteDestinationsActor>(shard, srcInterfs, destInterfs, version, desiredHealthy, maxServers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1693877289819123200UL, 6093049964566661888UL);
		ActorExecutionContextHelper __helper(static_cast<AddReadWriteDestinationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addReadWriteDestinations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddReadWriteDestinationsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<std::vector<UID>> addReadWriteDestinations( KeyRangeRef const& shard, std::vector<StorageServerInterface> const& srcInterfs, std::vector<StorageServerInterface> const& destInterfs, Version const& version, int const& desiredHealthy, int const& maxServers ) {
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<std::vector<UID>>(new AddReadWriteDestinationsActor(shard, srcInterfs, destInterfs, version, desiredHealthy, maxServers));
															#line 6271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 844 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

// Returns storage servers selected from 'candidates', who is serving a read-write copy of 'range'.
															#line 6277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via pickReadWriteServers()
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class PickReadWriteServersActor>
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class PickReadWriteServersActorState {
															#line 6283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	PickReadWriteServersActorState(Transaction* const& tr,std::vector<UID> const& candidates,KeyRangeRef const& range) 
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : tr(tr),
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   candidates(candidates),
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   range(range)
															#line 6294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("pickReadWriteServers", reinterpret_cast<unsigned long>(this));

	}
	~PickReadWriteServersActorState() 
	{
		fdb_probe_actor_destroy("pickReadWriteServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 847 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<Future<Optional<Value>>> serverListEntries;
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const UID id : candidates ) {
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				serverListEntries.push_back(tr->get(serverListKeyFor(id)));
															#line 6313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 853 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<std::vector<Optional<Value>>> __when_expr_0 = getAll(serverListEntries);
															#line 853 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<PickReadWriteServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PickReadWriteServersActor*>(this)->actor_wait_state = 1;
															#line 853 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >*>(static_cast<PickReadWriteServersActor*>(this)));
															#line 6324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PickReadWriteServersActorState();
		static_cast<PickReadWriteServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
															#line 855 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<StorageServerInterface> ssis;
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( auto& v : serverListValues ) {
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ssis.push_back(decodeServerListValue(v.get()));
															#line 6351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 860 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		checks = std::vector<Future<Optional<UID>>>();
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		checks.reserve(ssis.size());
															#line 862 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( auto& ssi : ssis ) {
															#line 863 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			checks.push_back(checkReadWrite( ssi.getShardState.getReplyUnlessFailedFor(GetShardStateRequest(range, GetShardStateRequest::NO_WAIT), SERVER_KNOBS->SERVER_READY_QUORUM_INTERVAL, 0, TaskPriority::MoveKeys), ssi.id(), 0));
															#line 6361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(checks);
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<PickReadWriteServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PickReadWriteServersActor*>(this)->actor_wait_state = 2;
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PickReadWriteServersActor, 1, Void >*>(static_cast<PickReadWriteServersActor*>(this)));
															#line 6372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
															#line 855 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<StorageServerInterface> ssis;
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( auto& v : serverListValues ) {
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ssis.push_back(decodeServerListValue(v.get()));
															#line 6385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 860 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		checks = std::vector<Future<Optional<UID>>>();
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		checks.reserve(ssis.size());
															#line 862 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( auto& ssi : ssis ) {
															#line 863 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			checks.push_back(checkReadWrite( ssi.getShardState.getReplyUnlessFailedFor(GetShardStateRequest(range, GetShardStateRequest::NO_WAIT), SERVER_KNOBS->SERVER_READY_QUORUM_INTERVAL, 0, TaskPriority::MoveKeys), ssi.id(), 0));
															#line 6395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(checks);
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<PickReadWriteServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PickReadWriteServersActor*>(this)->actor_wait_state = 2;
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PickReadWriteServersActor, 1, Void >*>(static_cast<PickReadWriteServersActor*>(this)));
															#line 6406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(serverListValues, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(serverListValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PickReadWriteServersActor*>(this)->actor_wait_state > 0) static_cast<PickReadWriteServersActor*>(this)->actor_wait_state = 0;
		static_cast<PickReadWriteServersActor*>(this)->ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PickReadWriteServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PickReadWriteServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PickReadWriteServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 874 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<UID> result;
															#line 875 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& it : checks ) {
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (it.get().present())
															#line 6494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 877 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				result.push_back(it.get().get());
															#line 6498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<PickReadWriteServersActor*>(this)->SAV<std::vector<UID>>::futures) { (void)(result); this->~PickReadWriteServersActorState(); static_cast<PickReadWriteServersActor*>(this)->destroy(); return 0; }
															#line 6503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<PickReadWriteServersActor*>(this)->SAV< std::vector<UID> >::value()) std::vector<UID>(result);
		this->~PickReadWriteServersActorState();
		static_cast<PickReadWriteServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 874 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<UID> result;
															#line 875 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& it : checks ) {
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (it.get().present())
															#line 6519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 877 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				result.push_back(it.get().get());
															#line 6523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<PickReadWriteServersActor*>(this)->SAV<std::vector<UID>>::futures) { (void)(result); this->~PickReadWriteServersActorState(); static_cast<PickReadWriteServersActor*>(this)->destroy(); return 0; }
															#line 6528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<PickReadWriteServersActor*>(this)->SAV< std::vector<UID> >::value()) std::vector<UID>(result);
		this->~PickReadWriteServersActorState();
		static_cast<PickReadWriteServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PickReadWriteServersActor*>(this)->actor_wait_state > 0) static_cast<PickReadWriteServersActor*>(this)->actor_wait_state = 0;
		static_cast<PickReadWriteServersActor*>(this)->ActorCallback< PickReadWriteServersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PickReadWriteServersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PickReadWriteServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PickReadWriteServersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PickReadWriteServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PickReadWriteServersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PickReadWriteServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction* tr;
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> candidates;
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRangeRef range;
															#line 860 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Optional<UID>>> checks;
															#line 6619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via pickReadWriteServers()
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class PickReadWriteServersActor final : public Actor<std::vector<UID>>, public ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >, public ActorCallback< PickReadWriteServersActor, 1, Void >, public FastAllocated<PickReadWriteServersActor>, public PickReadWriteServersActorState<PickReadWriteServersActor> {
															#line 6624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<PickReadWriteServersActor>::operator new;
	using FastAllocated<PickReadWriteServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6070751355115319296UL, 17992310007054736896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<UID>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >;
friend struct ActorCallback< PickReadWriteServersActor, 1, Void >;
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	PickReadWriteServersActor(Transaction* const& tr,std::vector<UID> const& candidates,KeyRangeRef const& range) 
															#line 6642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<std::vector<UID>>(),
		   PickReadWriteServersActorState<PickReadWriteServersActor>(tr, candidates, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("pickReadWriteServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8503206445238439424UL, 11680636101714118400UL);
		ActorExecutionContextHelper __helper(static_cast<PickReadWriteServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("pickReadWriteServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("pickReadWriteServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PickReadWriteServersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<std::vector<UID>> pickReadWriteServers( Transaction* const& tr, std::vector<UID> const& candidates, KeyRangeRef const& range ) {
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<std::vector<UID>>(new PickReadWriteServersActor(tr, candidates, range));
															#line 6675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 883 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 6680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via additionalSources()
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class AdditionalSourcesActor>
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AdditionalSourcesActorState {
															#line 6686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AdditionalSourcesActorState(RangeResult const& shards,Reference<ReadYourWritesTransaction> const& tr,int const& desiredHealthy,int const& maxServers) 
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : shards(shards),
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tr(tr),
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   desiredHealthy(desiredHealthy),
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   maxServers(maxServers)
															#line 6699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("additionalSources", reinterpret_cast<unsigned long>(this));

	}
	~AdditionalSourcesActorState() 
	{
		fdb_probe_actor_destroy("additionalSources", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 888 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 888 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<AdditionalSourcesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AdditionalSourcesActor*>(this)->actor_wait_state = 1;
															#line 888 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AdditionalSourcesActor, 0, RangeResult >*>(static_cast<AdditionalSourcesActor*>(this)));
															#line 6721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AdditionalSourcesActorState();
		static_cast<AdditionalSourcesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 889 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Optional<Value>>> serverListEntries;
															#line 891 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::set<UID> fetching;
															#line 892 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < shards.size() - 1;++i) {
															#line 893 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 894 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 896 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, shards[i].value, src, dest);
															#line 898 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < src.size();s++) {
															#line 899 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!fetching.contains(src[s]))
															#line 6760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					fetching.insert(src[s]);
															#line 901 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					serverListEntries.push_back(tr->get(serverListKeyFor(src[s])));
															#line 6766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < dest.size();s++) {
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!fetching.contains(dest[s]))
															#line 6773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 907 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					fetching.insert(dest[s]);
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					serverListEntries.push_back(tr->get(serverListKeyFor(dest[s])));
															#line 6779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
		}
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_1 = getAll(serverListEntries);
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<AdditionalSourcesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AdditionalSourcesActor*>(this)->actor_wait_state = 2;
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >*>(static_cast<AdditionalSourcesActor*>(this)));
															#line 6792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 888 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 6801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AdditionalSourcesActor*>(this)->actor_wait_state > 0) static_cast<AdditionalSourcesActor*>(this)->actor_wait_state = 0;
		static_cast<AdditionalSourcesActor*>(this)->ActorCallback< AdditionalSourcesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< AdditionalSourcesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AdditionalSourcesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AdditionalSourcesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
															#line 915 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::map<UID, StorageServerInterface> ssiMap;
															#line 916 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StorageServerInterface ssi = decodeServerListValue(serverListValues[s].get());
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ssiMap[ssi.id()] = ssi;
															#line 6886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<std::vector<UID>>> allChecks;
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < shards.size() - 1;++i) {
															#line 923 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			KeyRangeRef rangeIntersectKeys(shards[i].key, shards[i + 1].key);
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 925 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<StorageServerInterface> srcInterfs;
															#line 927 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<StorageServerInterface> destInterfs;
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, shards[i].value, src, dest);
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			srcInterfs.reserve(src.size());
															#line 932 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < src.size();s++) {
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				srcInterfs.push_back(ssiMap[src[s]]);
															#line 6910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < dest.size();s++) {
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (std::find(src.begin(), src.end(), dest[s]) == src.end())
															#line 6916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 938 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					destInterfs.push_back(ssiMap[dest[s]]);
															#line 6920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
															#line 942 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			allChecks.push_back(addReadWriteDestinations( rangeIntersectKeys, srcInterfs, destInterfs, tr->getReadVersion().get(), desiredHealthy, maxServers));
															#line 6925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<std::vector<UID>>> __when_expr_2 = getAll(allChecks);
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<AdditionalSourcesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AdditionalSourcesActor*>(this)->actor_wait_state = 3;
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >*>(static_cast<AdditionalSourcesActor*>(this)));
															#line 6936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
															#line 915 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::map<UID, StorageServerInterface> ssiMap;
															#line 916 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StorageServerInterface ssi = decodeServerListValue(serverListValues[s].get());
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ssiMap[ssi.id()] = ssi;
															#line 6951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<std::vector<UID>>> allChecks;
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < shards.size() - 1;++i) {
															#line 923 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			KeyRangeRef rangeIntersectKeys(shards[i].key, shards[i + 1].key);
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 925 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<StorageServerInterface> srcInterfs;
															#line 927 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<StorageServerInterface> destInterfs;
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, shards[i].value, src, dest);
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			srcInterfs.reserve(src.size());
															#line 932 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < src.size();s++) {
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				srcInterfs.push_back(ssiMap[src[s]]);
															#line 6975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < dest.size();s++) {
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (std::find(src.begin(), src.end(), dest[s]) == src.end())
															#line 6981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 938 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					destInterfs.push_back(ssiMap[dest[s]]);
															#line 6985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
															#line 942 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			allChecks.push_back(addReadWriteDestinations( rangeIntersectKeys, srcInterfs, destInterfs, tr->getReadVersion().get(), desiredHealthy, maxServers));
															#line 6990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<std::vector<UID>>> __when_expr_2 = getAll(allChecks);
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<AdditionalSourcesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AdditionalSourcesActor*>(this)->actor_wait_state = 3;
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >*>(static_cast<AdditionalSourcesActor*>(this)));
															#line 7001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont2(serverListValues, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(serverListValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AdditionalSourcesActor*>(this)->actor_wait_state > 0) static_cast<AdditionalSourcesActor*>(this)->actor_wait_state = 0;
		static_cast<AdditionalSourcesActor*>(this)->ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(std::vector<std::vector<UID>> const& result,int loopDepth) 
	{
															#line 947 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<AdditionalSourcesActor*>(this)->SAV<std::vector<std::vector<UID>>>::futures) { (void)(result); this->~AdditionalSourcesActorState(); static_cast<AdditionalSourcesActor*>(this)->destroy(); return 0; }
															#line 7085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<AdditionalSourcesActor*>(this)->SAV< std::vector<std::vector<UID>> >::value()) std::vector<std::vector<UID>>(result);
		this->~AdditionalSourcesActorState();
		static_cast<AdditionalSourcesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(std::vector<std::vector<UID>> && result,int loopDepth) 
	{
															#line 947 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<AdditionalSourcesActor*>(this)->SAV<std::vector<std::vector<UID>>>::futures) { (void)(result); this->~AdditionalSourcesActorState(); static_cast<AdditionalSourcesActor*>(this)->destroy(); return 0; }
															#line 7097 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<AdditionalSourcesActor*>(this)->SAV< std::vector<std::vector<UID>> >::value()) std::vector<std::vector<UID>>(result);
		this->~AdditionalSourcesActorState();
		static_cast<AdditionalSourcesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<std::vector<UID>> const& result,int loopDepth) 
	{
		loopDepth = a_body1cont8(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<std::vector<UID>> && result,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AdditionalSourcesActor*>(this)->actor_wait_state > 0) static_cast<AdditionalSourcesActor*>(this)->actor_wait_state = 0;
		static_cast<AdditionalSourcesActor*>(this)->ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >::remove();

	}
	void a_callback_fire(ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >*,std::vector<std::vector<UID>> const& value) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >*,std::vector<std::vector<UID>> && value) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >*,Error err) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult shards;
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int desiredHealthy;
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int maxServers;
															#line 888 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 7190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via additionalSources()
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AdditionalSourcesActor final : public Actor<std::vector<std::vector<UID>>>, public ActorCallback< AdditionalSourcesActor, 0, RangeResult >, public ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >, public ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >, public FastAllocated<AdditionalSourcesActor>, public AdditionalSourcesActorState<AdditionalSourcesActor> {
															#line 7195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<AdditionalSourcesActor>::operator new;
	using FastAllocated<AdditionalSourcesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2812569168320042496UL, 4775933929073667072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::vector<UID>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AdditionalSourcesActor, 0, RangeResult >;
friend struct ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >;
friend struct ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >;
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AdditionalSourcesActor(RangeResult const& shards,Reference<ReadYourWritesTransaction> const& tr,int const& desiredHealthy,int const& maxServers) 
															#line 7214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<std::vector<std::vector<UID>>>(),
		   AdditionalSourcesActorState<AdditionalSourcesActor>(shards, tr, desiredHealthy, maxServers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7335489034521655552UL, 3441724204008605440UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("additionalSources");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AdditionalSourcesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<std::vector<std::vector<UID>>> additionalSources( RangeResult const& shards, Reference<ReadYourWritesTransaction> const& tr, int const& desiredHealthy, int const& maxServers ) {
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<std::vector<std::vector<UID>>>(new AdditionalSourcesActor(shards, tr, desiredHealthy, maxServers));
															#line 7248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 949 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 7253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via logWarningAfter()
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class LogWarningAfterActor>
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class LogWarningAfterActorState {
															#line 7259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	LogWarningAfterActorState(const char* const& context,double const& duration,std::vector<UID> const& servers) 
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : context(context),
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   duration(duration),
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   servers(servers),
															#line 951 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   startTime(now())
															#line 7272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("logWarningAfter", reinterpret_cast<unsigned long>(this));

	}
	~LogWarningAfterActorState() 
	{
		fdb_probe_actor_destroy("logWarningAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 952 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 7287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogWarningAfterActorState();
		static_cast<LogWarningAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(duration);
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<LogWarningAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<LogWarningAfterActor*>(this)->actor_wait_state = 1;
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogWarningAfterActor, 0, Void >*>(static_cast<LogWarningAfterActor*>(this)));
															#line 7324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 954 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevWarnAlways, context).detail("Duration", now() - startTime).detail("Servers", describe(servers));
															#line 7333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 954 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevWarnAlways, context).detail("Duration", now() - startTime).detail("Servers", describe(servers));
															#line 7342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogWarningAfterActor*>(this)->actor_wait_state > 0) static_cast<LogWarningAfterActor*>(this)->actor_wait_state = 0;
		static_cast<LogWarningAfterActor*>(this)->ActorCallback< LogWarningAfterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogWarningAfterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logWarningAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogWarningAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logWarningAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogWarningAfterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logWarningAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogWarningAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logWarningAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogWarningAfterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logWarningAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogWarningAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logWarningAfter", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	const char* context;
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	double duration;
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> servers;
															#line 951 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	double startTime;
															#line 7430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via logWarningAfter()
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class LogWarningAfterActor final : public Actor<Void>, public ActorCallback< LogWarningAfterActor, 0, Void >, public FastAllocated<LogWarningAfterActor>, public LogWarningAfterActorState<LogWarningAfterActor> {
															#line 7435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<LogWarningAfterActor>::operator new;
	using FastAllocated<LogWarningAfterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14820173989657371392UL, 2133118312702215424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogWarningAfterActor, 0, Void >;
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	LogWarningAfterActor(const char* const& context,double const& duration,std::vector<UID> const& servers) 
															#line 7452 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   LogWarningAfterActorState<LogWarningAfterActor>(context, duration, servers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logWarningAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1066170188761392640UL, 13649371151223103488UL);
		ActorExecutionContextHelper __helper(static_cast<LogWarningAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logWarningAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logWarningAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogWarningAfterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> logWarningAfter( const char* const& context, double const& duration, std::vector<UID> const& servers ) {
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new LogWarningAfterActor(context, duration, servers));
															#line 7484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 957 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

// keyServer: map from keys to destination servers
// serverKeys: two-dimension map: [servers][keys], value is the servers' state of having the keys: active(not-have),
// complete(already has), ""(). Set keyServers[keys].dest = servers. Set serverKeys[servers][keys] = active for each
// subrange of keys that the server did not already have, = complete for each subrange that it already has. Set
// serverKeys[dest][keys] = "" for the dest servers of each existing shard in keys (unless that destination is a member
// of servers OR if the source list is sufficiently degraded)
															#line 7495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via startMoveKeys()
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class StartMoveKeysActor>
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class StartMoveKeysActorState {
															#line 7501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	StartMoveKeysActorState(Database const& occ,KeyRange const& keys,std::vector<UID> const& servers,MoveKeysLock const& lock,FlowLock* const& startMoveKeysLock,UID const& relocationIntervalId,std::map<UID, StorageServerInterface>* const& tssMapping,const DDEnabledState* const& ddEnabledState) 
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   keys(keys),
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   servers(servers),
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   lock(lock),
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   startMoveKeysLock(startMoveKeysLock),
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   relocationIntervalId(relocationIntervalId),
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tssMapping(tssMapping),
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   interval("RelocateShard_StartMoveKeys"),
															#line 973 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   warningLogger(logWarningAfter("StartMoveKeysTooLong", 600, servers))
															#line 7526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("startMoveKeys", reinterpret_cast<unsigned long>(this));

	}
	~StartMoveKeysActorState() 
	{
		fdb_probe_actor_destroy("startMoveKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = startMoveKeysLock->take(TaskPriority::DataDistributionLaunch);
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 1;
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 0, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 7548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartMoveKeysActorState();
		static_cast<StartMoveKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 977 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*startMoveKeysLock);
															#line 978 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = false;
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevDebug, interval.begin(), relocationIntervalId);
															#line 7575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			begin = keys.begin;
															#line 984 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			batches = 0;
															#line 985 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			shards = 0;
															#line 986 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			maxRetries = 0;
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 7587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 977 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*startMoveKeysLock);
															#line 978 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = false;
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevDebug, interval.begin(), relocationIntervalId);
															#line 7606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			begin = keys.begin;
															#line 984 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			batches = 0;
															#line 985 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			shards = 0;
															#line 986 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			maxRetries = 0;
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 7618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1169 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<StartMoveKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartMoveKeysActorState(); static_cast<StartMoveKeysActor*>(this)->destroy(); return 0; }
															#line 7708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<StartMoveKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartMoveKeysActorState();
		static_cast<StartMoveKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, interval.end(), relocationIntervalId).errorUnsuppressed(e);
															#line 1166 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 7723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1160 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevDebug, interval.end(), relocationIntervalId) .detail("Batches", batches) .detail("Shards", shards) .detail("MaxRetries", maxRetries);
															#line 7737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!(begin < keys.end))
															#line 7753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 992 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		CODE_PROBE(begin > keys.begin, "Multi-transactional startMoveKeys");
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		batches++;
															#line 996 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(occ);
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retries = 0;
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		;
															#line 7767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1153 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (retries > maxRetries)
															#line 7789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1154 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			maxRetries = retries;
															#line 7793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1001 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			retries++;
															#line 1004 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			oldDests = std::set<UID>();
															#line 1007 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			shardMap = Map<UID, VectorRef<KeyRangeRef>>();
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->getTransaction().trState->taskID = TaskPriority::MoveKeys;
															#line 1010 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_1 = checkMoveKeysLock(&(tr->getTransaction()), lock, ddEnabledState);
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 2;
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 1, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 7830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1137 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			err = e;
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (err.code() == error_code_move_to_removed_server)
															#line 7867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1139 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1Catch1(e, std::max(0, loopDepth - 2));
															#line 7871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1140 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_9 = tr->onError(e);
															#line 1140 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 7877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_9.get(), loopDepth); };
			static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 10;
															#line 1140 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 9, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 7882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!loadedTssMapping)
															#line 7897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1017 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_2 = readTSSMappingRYW(tr, tssMapping);
															#line 1017 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 3;
															#line 1017 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 2, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 7908 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!loadedTssMapping)
															#line 7922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1017 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_2 = readTSSMappingRYW(tr, tssMapping);
															#line 1017 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 3;
															#line 1017 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 2, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 7933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 1021 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Optional<Value>>> serverListEntries;
															#line 1022 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListEntries.reserve(servers.size());
															#line 1023 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < servers.size();s++) {
															#line 1024 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			serverListEntries.push_back(tr->get(serverListKeyFor(servers[s])));
															#line 8028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_3 = getAll(serverListEntries);
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 4;
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 1018 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = true;
															#line 8048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 1018 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = true;
															#line 8057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1cont6(int loopDepth) 
	{
															#line 1027 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1029 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!serverListValues[s].present())
															#line 8143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1030 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				CODE_PROBE(true, "start move keys moving to a removed server", probe::decoration::rare);
															#line 1031 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1loopBody1Catch1(move_to_removed_server(), loopDepth);
															#line 8149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1037 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(begin, keys.end);
															#line 1039 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = krmGetRanges(tr, keyServersPrefix, currentKeys, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES);
															#line 1039 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 5;
															#line 1039 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 4, RangeResult >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(std::vector<Optional<Value>> const& __serverListValues,int loopDepth) 
	{
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListValues = __serverListValues;
															#line 8172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(std::vector<Optional<Value>> && __serverListValues,int loopDepth) 
	{
		serverListValues = std::move(__serverListValues);
		loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1loopBody1cont8(int loopDepth) 
	{
															#line 1046 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		endKey = old.end()[-1].key;
															#line 1047 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(currentKeys.begin, endKey);
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_5 = tr->getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 6;
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 5, RangeResult >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont6when1(RangeResult const& __old,int loopDepth) 
	{
															#line 1039 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		old = __old;
															#line 8271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont6when1(RangeResult && __old,int loopDepth) 
	{
		old = std::move(__old);
		loopDepth = a_body1cont1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1loopBody1cont11(int loopDepth) 
	{
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<std::vector<UID>>> __when_expr_6 = additionalSources( old, tr, servers.size(), SERVER_KNOBS->MAX_ADDED_SOURCES_MULTIPLIER * servers.size());
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont11when1(__when_expr_6.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 7;
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont8when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 8368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont8when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1cont1loopBody1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 5, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 5, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 5, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 5, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1loopBody1cont11cont1(std::vector<std::vector<UID>> const& addAsSource,int loopDepth) 
	{
															#line 1065 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < old.size() - 1;++i) {
															#line 1066 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			KeyRangeRef rangeIntersectKeys(old[i].key, old[i + 1].key);
															#line 1067 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 1068 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 1069 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, old[i].value, src, dest);
															#line 1078 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& uid : addAsSource[i] ) {
															#line 1079 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				src.push_back(uid);
															#line 8459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			uniquify(src);
															#line 1084 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			krmSetPreviouslyEmptyRange(&(tr->getTransaction()), keyServersPrefix, rangeIntersectKeys, keyServersValue(UIDtoTagMap, src, servers), old[i + 1].value);
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(auto s = dest.begin();s != dest.end();++s) {
															#line 1093 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				oldDests.insert(*s);
															#line 8469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1098 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& uid : src ) {
															#line 1099 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				shardMap[uid].push_back(old.arena(), rangeIntersectKeys);
															#line 8475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		oldDest = std::set<UID>::iterator();
															#line 1111 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Void>> actors;
															#line 1112 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(oldDest = oldDests.begin();oldDest != oldDests.end();++oldDest) {
															#line 1113 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (std::find(servers.begin(), servers.end(), *oldDest) == servers.end())
															#line 8486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1114 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.push_back(removeOldDestinations(tr, *oldDest, shardMap[*oldDest], currentKeys));
															#line 8490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < servers.size();i++) {
															#line 1122 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(krmSetRangeCoalescing( tr, serverKeysPrefixFor(servers[i]), currentKeys, allKeys, serverKeysTrue));
															#line 8497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(actors);
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont11cont1when1(__when_expr_7.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 8;
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 7, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont1(std::vector<std::vector<UID>> && addAsSource,int loopDepth) 
	{
															#line 1065 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < old.size() - 1;++i) {
															#line 1066 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			KeyRangeRef rangeIntersectKeys(old[i].key, old[i + 1].key);
															#line 1067 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 1068 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 1069 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, old[i].value, src, dest);
															#line 1078 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& uid : addAsSource[i] ) {
															#line 1079 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				src.push_back(uid);
															#line 8529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			uniquify(src);
															#line 1084 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			krmSetPreviouslyEmptyRange(&(tr->getTransaction()), keyServersPrefix, rangeIntersectKeys, keyServersValue(UIDtoTagMap, src, servers), old[i + 1].value);
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(auto s = dest.begin();s != dest.end();++s) {
															#line 1093 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				oldDests.insert(*s);
															#line 8539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1098 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& uid : src ) {
															#line 1099 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				shardMap[uid].push_back(old.arena(), rangeIntersectKeys);
															#line 8545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		oldDest = std::set<UID>::iterator();
															#line 1111 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Void>> actors;
															#line 1112 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(oldDest = oldDests.begin();oldDest != oldDests.end();++oldDest) {
															#line 1113 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (std::find(servers.begin(), servers.end(), *oldDest) == servers.end())
															#line 8556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1114 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.push_back(removeOldDestinations(tr, *oldDest, shardMap[*oldDest], currentKeys));
															#line 8560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < servers.size();i++) {
															#line 1122 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(krmSetRangeCoalescing( tr, serverKeysPrefixFor(servers[i]), currentKeys, allKeys, serverKeysTrue));
															#line 8567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(actors);
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont11cont1when1(__when_expr_7.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 8;
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 7, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11when1(std::vector<std::vector<UID>> const& addAsSource,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont1(addAsSource, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11when1(std::vector<std::vector<UID>> && addAsSource,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont1(std::move(addAsSource), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >*,std::vector<std::vector<UID>> const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >*,std::vector<std::vector<UID>> && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1loopBody1cont11cont2(Void const& _,int loopDepth) 
	{
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_8 = tr->commit();
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont11cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 9;
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 8, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8669 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont2(Void && _,int loopDepth) 
	{
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_8 = tr->commit();
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont11cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 9;
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 8, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1loopBody1cont11cont10(Void const& _,int loopDepth) 
	{
															#line 1133 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		begin = endKey;
															#line 1134 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		shards += old.size() - 1;
															#line 8771 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont10(Void && _,int loopDepth) 
	{
															#line 1133 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		begin = endKey;
															#line 1134 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		shards += old.size() - 1;
															#line 8782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1loopBody1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1loopBody1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 1142 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (retries % 10 == 0)
															#line 8866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1143 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent( retries == 50 ? SevWarnAlways : SevWarn, "StartMoveKeysRetrying", relocationIntervalId) .error(err) .detail("Keys", keys) .detail("BeginKey", begin) .detail("NumTries", retries);
															#line 8870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 1142 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (retries % 10 == 0)
															#line 8880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1143 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent( retries == 50 ? SevWarnAlways : SevWarn, "StartMoveKeysRetrying", relocationIntervalId) .error(err) .detail("Keys", keys) .detail("BeginKey", begin) .detail("NumTries", retries);
															#line 8884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange keys;
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> servers;
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock* startMoveKeysLock;
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID relocationIntervalId;
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::map<UID, StorageServerInterface>* tssMapping;
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	TraceInterval interval;
															#line 973 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Future<Void> warningLogger;
															#line 977 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock::Releaser releaser;
															#line 978 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool loadedTssMapping;
															#line 983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key begin;
															#line 984 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int batches;
															#line 985 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int shards;
															#line 986 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int maxRetries;
															#line 996 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int retries;
															#line 1004 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::set<UID> oldDests;
															#line 1007 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Map<UID, VectorRef<KeyRangeRef>> shardMap;
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Optional<Value>> serverListValues;
															#line 1037 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange currentKeys;
															#line 1039 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult old;
															#line 1046 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key endKey;
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::set<UID>::iterator oldDest;
															#line 1137 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Error err;
															#line 9032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via startMoveKeys()
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class StartMoveKeysActor final : public Actor<Void>, public ActorCallback< StartMoveKeysActor, 0, Void >, public ActorCallback< StartMoveKeysActor, 1, Void >, public ActorCallback< StartMoveKeysActor, 2, Void >, public ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >, public ActorCallback< StartMoveKeysActor, 4, RangeResult >, public ActorCallback< StartMoveKeysActor, 5, RangeResult >, public ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >, public ActorCallback< StartMoveKeysActor, 7, Void >, public ActorCallback< StartMoveKeysActor, 8, Void >, public ActorCallback< StartMoveKeysActor, 9, Void >, public FastAllocated<StartMoveKeysActor>, public StartMoveKeysActorState<StartMoveKeysActor> {
															#line 9037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<StartMoveKeysActor>::operator new;
	using FastAllocated<StartMoveKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11811305082921346048UL, 3199269319355793152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartMoveKeysActor, 0, Void >;
friend struct ActorCallback< StartMoveKeysActor, 1, Void >;
friend struct ActorCallback< StartMoveKeysActor, 2, Void >;
friend struct ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >;
friend struct ActorCallback< StartMoveKeysActor, 4, RangeResult >;
friend struct ActorCallback< StartMoveKeysActor, 5, RangeResult >;
friend struct ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >;
friend struct ActorCallback< StartMoveKeysActor, 7, Void >;
friend struct ActorCallback< StartMoveKeysActor, 8, Void >;
friend struct ActorCallback< StartMoveKeysActor, 9, Void >;
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	StartMoveKeysActor(Database const& occ,KeyRange const& keys,std::vector<UID> const& servers,MoveKeysLock const& lock,FlowLock* const& startMoveKeysLock,UID const& relocationIntervalId,std::map<UID, StorageServerInterface>* const& tssMapping,const DDEnabledState* const& ddEnabledState) 
															#line 9063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   StartMoveKeysActorState<StartMoveKeysActor>(occ, keys, servers, lock, startMoveKeysLock, relocationIntervalId, tssMapping, ddEnabledState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16904875003351271680UL, 14119854258617811200UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startMoveKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartMoveKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartMoveKeysActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartMoveKeysActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< StartMoveKeysActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< StartMoveKeysActor, 5, RangeResult >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< StartMoveKeysActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< StartMoveKeysActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< StartMoveKeysActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] static Future<Void> startMoveKeys( Database const& occ, KeyRange const& keys, std::vector<UID> const& servers, MoveKeysLock const& lock, FlowLock* const& startMoveKeysLock, UID const& relocationIntervalId, std::map<UID, StorageServerInterface>* const& tssMapping, const DDEnabledState* const& ddEnabledState ) {
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new StartMoveKeysActor(occ, keys, servers, lock, startMoveKeysLock, relocationIntervalId, tssMapping, ddEnabledState));
															#line 9104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 1171 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 9109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via waitForShardReady()
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class WaitForShardReadyActor>
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class WaitForShardReadyActorState {
															#line 9115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	WaitForShardReadyActorState(StorageServerInterface const& server,KeyRange const& keys,Version const& minVersion,GetShardStateRequest::waitMode const& mode) 
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : server(server),
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   keys(keys),
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   minVersion(minVersion),
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   mode(mode)
															#line 9128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForShardReady", reinterpret_cast<unsigned long>(this));

	}
	~WaitForShardReadyActorState() 
	{
		fdb_probe_actor_destroy("waitForShardReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1176 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 9143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForShardReadyActorState();
		static_cast<WaitForShardReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1178 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<GetShardStateReply> __when_expr_0 = server.getShardState.getReply(GetShardStateRequest(keys, mode), TaskPriority::MoveKeys);
															#line 1178 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<WaitForShardReadyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitForShardReadyActor*>(this)->actor_wait_state = 1;
															#line 1178 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >*>(static_cast<WaitForShardReadyActor*>(this)));
															#line 9181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1185 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent("GetShardStateReadyError", server.id()).error(e).log();
															#line 1186 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() != error_code_timed_out)
															#line 9205 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (e.code() != error_code_broken_promise)
															#line 9209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1188 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
															#line 1189 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_2 = Never();
															#line 1189 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<WaitForShardReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<WaitForShardReadyActor*>(this)->actor_wait_state = 3;
															#line 1189 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForShardReadyActor, 2, Void >*>(static_cast<WaitForShardReadyActor*>(this)));
															#line 9224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(GetShardStateReply const& rep,int loopDepth) 
	{
															#line 1180 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (rep.first >= minVersion)
															#line 9244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1181 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!static_cast<WaitForShardReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForShardReadyActorState(); static_cast<WaitForShardReadyActor*>(this)->destroy(); return 0; }
															#line 9248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			new (&static_cast<WaitForShardReadyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForShardReadyActorState();
			static_cast<WaitForShardReadyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(SERVER_KNOBS->SHARD_READY_DELAY, TaskPriority::MoveKeys);
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<WaitForShardReadyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitForShardReadyActor*>(this)->actor_wait_state = 2;
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForShardReadyActor, 1, Void >*>(static_cast<WaitForShardReadyActor*>(this)));
															#line 9263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(GetShardStateReply && rep,int loopDepth) 
	{
															#line 1180 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (rep.first >= minVersion)
															#line 9272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1181 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!static_cast<WaitForShardReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForShardReadyActorState(); static_cast<WaitForShardReadyActor*>(this)->destroy(); return 0; }
															#line 9276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			new (&static_cast<WaitForShardReadyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForShardReadyActorState();
			static_cast<WaitForShardReadyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(SERVER_KNOBS->SHARD_READY_DELAY, TaskPriority::MoveKeys);
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<WaitForShardReadyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitForShardReadyActor*>(this)->actor_wait_state = 2;
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForShardReadyActor, 1, Void >*>(static_cast<WaitForShardReadyActor*>(this)));
															#line 9291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(GetShardStateReply const& rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(rep, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetShardStateReply && rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForShardReadyActor*>(this)->actor_wait_state > 0) static_cast<WaitForShardReadyActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForShardReadyActor*>(this)->ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >*,GetShardStateReply const& value) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >*,GetShardStateReply && value) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >*,Error err) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForShardReadyActor*>(this)->actor_wait_state > 0) static_cast<WaitForShardReadyActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForShardReadyActor*>(this)->ActorCallback< WaitForShardReadyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForShardReadyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForShardReadyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForShardReadyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 1190 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 9481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
															#line 1190 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 9489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitForShardReadyActor*>(this)->actor_wait_state > 0) static_cast<WaitForShardReadyActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForShardReadyActor*>(this)->ActorCallback< WaitForShardReadyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForShardReadyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForShardReadyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitForShardReadyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	StorageServerInterface server;
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange keys;
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Version minVersion;
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	GetShardStateRequest::waitMode mode;
															#line 9576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via waitForShardReady()
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class WaitForShardReadyActor final : public Actor<Void>, public ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >, public ActorCallback< WaitForShardReadyActor, 1, Void >, public ActorCallback< WaitForShardReadyActor, 2, Void >, public FastAllocated<WaitForShardReadyActor>, public WaitForShardReadyActorState<WaitForShardReadyActor> {
															#line 9581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<WaitForShardReadyActor>::operator new;
	using FastAllocated<WaitForShardReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8271155562771256064UL, 3226291795265357056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >;
friend struct ActorCallback< WaitForShardReadyActor, 1, Void >;
friend struct ActorCallback< WaitForShardReadyActor, 2, Void >;
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	WaitForShardReadyActor(StorageServerInterface const& server,KeyRange const& keys,Version const& minVersion,GetShardStateRequest::waitMode const& mode) 
															#line 9600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForShardReadyActorState<WaitForShardReadyActor>(server, keys, minVersion, mode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10925432230277775104UL, 4991613340205893120UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForShardReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForShardReadyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitForShardReadyActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> waitForShardReady( StorageServerInterface const& server, KeyRange const& keys, Version const& minVersion, GetShardStateRequest::waitMode const& mode ) {
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new WaitForShardReadyActor(server, keys, minVersion, mode));
															#line 9634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 1195 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

// best effort to also wait for TSS on data move

															#line 9641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via checkFetchingState()
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class CheckFetchingStateActor>
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckFetchingStateActorState {
															#line 9647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckFetchingStateActorState(Database const& cx,std::vector<UID> const& dest,KeyRange const& keys,Promise<Void> const& dataMovementComplete,UID const& relocationIntervalId,std::map<UID, StorageServerInterface> const& tssMapping) 
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : cx(cx),
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dest(dest),
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   keys(keys),
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMovementComplete(dataMovementComplete),
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   relocationIntervalId(relocationIntervalId),
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tssMapping(tssMapping),
															#line 1204 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tr(cx)
															#line 9666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("checkFetchingState", reinterpret_cast<unsigned long>(this));

	}
	~CheckFetchingStateActorState() 
	{
		fdb_probe_actor_destroy("checkFetchingState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1206 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 9681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckFetchingStateActorState();
		static_cast<CheckFetchingStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1208 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (BUGGIFY)
															#line 9712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1209 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(5);
															#line 1209 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 1;
															#line 1209 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckFetchingStateActor, 0, Void >*>(static_cast<CheckFetchingStateActor*>(this)));
															#line 9723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1257 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 9750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1258 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr.reset();
															#line 9754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
			else
			{
															#line 1260 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 1260 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 5;
															#line 1260 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckFetchingStateActor, 4, Void >*>(static_cast<CheckFetchingStateActor*>(this)));
															#line 9768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1211 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.trState->taskID = TaskPriority::MoveKeys;
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1213 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1215 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Optional<Value>>> serverListEntries;
															#line 1216 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListEntries.reserve(dest.size());
															#line 1217 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < dest.size();s++) {
															#line 1218 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			serverListEntries.push_back(tr.get(serverListKeyFor(dest[s])));
															#line 9796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1219 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_1 = getAll(serverListEntries);
															#line 1219 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 2;
															#line 1219 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >*>(static_cast<CheckFetchingStateActor*>(this)));
															#line 9807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state > 0) static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFetchingStateActor*>(this)->ActorCallback< CheckFetchingStateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckFetchingStateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 1220 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Void>> requests;
															#line 1221 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tssRequests = std::vector<Future<Void>>();
															#line 1222 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1225 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT_WE_THINK(serverListValues[s].present());
															#line 1226 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!serverListValues[s].present())
															#line 9911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1229 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1loopBody1Catch1(move_to_removed_server(), loopDepth);
															#line 9915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1231 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			auto si = decodeServerListValue(serverListValues[s].get());
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(si.id() == dest[s]);
															#line 1233 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			requests.push_back( waitForShardReady(si, keys, tr.getReadVersion().get(), GetShardStateRequest::FETCHING));
															#line 1236 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			auto tssPair = tssMapping.find(si.id());
															#line 1237 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (tssPair != tssMapping.end())
															#line 9927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1238 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssRequests.push_back(waitForShardReady( tssPair->second, keys, tr.getReadVersion().get(), GetShardStateRequest::FETCHING));
															#line 9931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1243 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_2 = timeoutError(waitForAll(requests), SERVER_KNOBS->SERVER_READY_QUORUM_TIMEOUT, TaskPriority::MoveKeys);
															#line 1243 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 3;
															#line 1243 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckFetchingStateActor, 2, Void >*>(static_cast<CheckFetchingStateActor*>(this)));
															#line 9943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<Optional<Value>> const& __serverListValues,int loopDepth) 
	{
															#line 1219 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListValues = __serverListValues;
															#line 9952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<Optional<Value>> && __serverListValues,int loopDepth) 
	{
		serverListValues = std::move(__serverListValues);
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state > 0) static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFetchingStateActor*>(this)->ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 1247 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (tssRequests.size())
															#line 10031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1248 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_3 = timeout(waitForAllReady(tssRequests), SERVER_KNOBS->SERVER_READY_QUORUM_TIMEOUT / 2, Void(), TaskPriority::MoveKeys);
															#line 1248 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 4;
															#line 1248 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckFetchingStateActor, 3, Void >*>(static_cast<CheckFetchingStateActor*>(this)));
															#line 10042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 1247 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (tssRequests.size())
															#line 10056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1248 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_3 = timeout(waitForAllReady(tssRequests), SERVER_KNOBS->SERVER_READY_QUORUM_TIMEOUT / 2, Void(), TaskPriority::MoveKeys);
															#line 1248 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 4;
															#line 1248 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckFetchingStateActor, 3, Void >*>(static_cast<CheckFetchingStateActor*>(this)));
															#line 10067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state > 0) static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFetchingStateActor*>(this)->ActorCallback< CheckFetchingStateActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckFetchingStateActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
															#line 1254 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMovementComplete.send(Void());
															#line 1255 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<CheckFetchingStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckFetchingStateActorState(); static_cast<CheckFetchingStateActor*>(this)->destroy(); return 0; }
															#line 10158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<CheckFetchingStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckFetchingStateActorState();
		static_cast<CheckFetchingStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state > 0) static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFetchingStateActor*>(this)->ActorCallback< CheckFetchingStateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckFetchingStateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state > 0) static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFetchingStateActor*>(this)->ActorCallback< CheckFetchingStateActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckFetchingStateActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database cx;
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> dest;
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange keys;
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Promise<Void> dataMovementComplete;
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID relocationIntervalId;
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 1204 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 1219 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Optional<Value>> serverListValues;
															#line 1221 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Void>> tssRequests;
															#line 10364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via checkFetchingState()
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckFetchingStateActor final : public Actor<Void>, public ActorCallback< CheckFetchingStateActor, 0, Void >, public ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >, public ActorCallback< CheckFetchingStateActor, 2, Void >, public ActorCallback< CheckFetchingStateActor, 3, Void >, public ActorCallback< CheckFetchingStateActor, 4, Void >, public FastAllocated<CheckFetchingStateActor>, public CheckFetchingStateActorState<CheckFetchingStateActor> {
															#line 10369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<CheckFetchingStateActor>::operator new;
	using FastAllocated<CheckFetchingStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17004698326077863936UL, 1789620543588160512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckFetchingStateActor, 0, Void >;
friend struct ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >;
friend struct ActorCallback< CheckFetchingStateActor, 2, Void >;
friend struct ActorCallback< CheckFetchingStateActor, 3, Void >;
friend struct ActorCallback< CheckFetchingStateActor, 4, Void >;
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckFetchingStateActor(Database const& cx,std::vector<UID> const& dest,KeyRange const& keys,Promise<Void> const& dataMovementComplete,UID const& relocationIntervalId,std::map<UID, StorageServerInterface> const& tssMapping) 
															#line 10390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   CheckFetchingStateActorState<CheckFetchingStateActor>(cx, dest, keys, dataMovementComplete, relocationIntervalId, tssMapping),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13605890424979058688UL, 18070830385337103360UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkFetchingState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckFetchingStateActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckFetchingStateActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckFetchingStateActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckFetchingStateActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> checkFetchingState( Database const& cx, std::vector<UID> const& dest, KeyRange const& keys, Promise<Void> const& dataMovementComplete, UID const& relocationIntervalId, std::map<UID, StorageServerInterface> const& tssMapping ) {
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new CheckFetchingStateActor(cx, dest, keys, dataMovementComplete, relocationIntervalId, tssMapping));
															#line 10426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 1264 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

// Set keyServers[keys].src = keyServers[keys].dest and keyServers[keys].dest=[], return when successful
// keyServers[k].dest must be the same for all k in keys
// Set serverKeys[dest][keys] = true; serverKeys[src][keys] = false for all src not in dest
// Should be cancelled and restarted if keyServers[keys].dest changes (?so this is no longer true?)
															#line 10435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via finishMoveKeys()
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class FinishMoveKeysActor>
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class FinishMoveKeysActorState {
															#line 10441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FinishMoveKeysActorState(Database const& occ,KeyRange const& keys,std::vector<UID> const& destinationTeam,MoveKeysLock const& lock,FlowLock* const& finishMoveKeysParallelismLock,bool const& hasRemote,UID const& relocationIntervalId,std::map<UID, StorageServerInterface> const& tssMapping,const DDEnabledState* const& ddEnabledState) 
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   keys(keys),
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   destinationTeam(destinationTeam),
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   lock(lock),
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   finishMoveKeysParallelismLock(finishMoveKeysParallelismLock),
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   hasRemote(hasRemote),
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   relocationIntervalId(relocationIntervalId),
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tssMapping(tssMapping),
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 1278 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   interval("RelocateShard_FinishMoveKeys"),
															#line 1279 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   waitInterval(""),
															#line 1280 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   warningLogger(logWarningAfter("FinishMoveKeysTooLong", 600, destinationTeam)),
															#line 1281 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   begin(keys.begin),
															#line 1282 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   endKey(),
															#line 1283 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   retries(0),
															#line 1284 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   releaser(),
															#line 1286 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tssToIgnore(),
															#line 1288 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   waitForTSSCounter(2)
															#line 10482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("finishMoveKeys", reinterpret_cast<unsigned long>(this));

	}
	~FinishMoveKeysActorState() 
	{
		fdb_probe_actor_destroy("finishMoveKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1290 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(!destinationTeam.empty());
															#line 10497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			try {
															#line 1293 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevDebug, interval.begin(), relocationIntervalId) .detail("KeyBegin", keys.begin) .detail("KeyEnd", keys.end);
															#line 1299 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				;
															#line 10503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinishMoveKeysActorState();
		static_cast<FinishMoveKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<FinishMoveKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishMoveKeysActorState(); static_cast<FinishMoveKeysActor*>(this)->destroy(); return 0; }
															#line 10532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<FinishMoveKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinishMoveKeysActorState();
		static_cast<FinishMoveKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1607 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, interval.end(), relocationIntervalId).errorUnsuppressed(e);
															#line 1608 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 10547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1605 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevDebug, interval.end(), relocationIntervalId);
															#line 10561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1299 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!(begin < keys.end))
															#line 10577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1300 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		CODE_PROBE(begin > keys.begin, "Multi-transactional finishMoveKeys");
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr = Transaction(occ);
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		;
															#line 10587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1308 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.trState->taskID = TaskPriority::MoveKeys;
															#line 1309 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1310 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1312 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			releaser.release();
															#line 1313 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = finishMoveKeysParallelismLock->take(TaskPriority::DataDistributionLaunch);
															#line 1313 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 1;
															#line 1313 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 0, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 10638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& error,int loopDepth=0) 
	{
		try {
															#line 1586 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (error.code() == error_code_actor_cancelled)
															#line 10673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch2(error, std::max(0, loopDepth - 2));
															#line 10677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			err = error;
															#line 1589 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_9 = tr.onError(error);
															#line 1589 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 10685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_9.get(), loopDepth); };
			static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 10;
															#line 1589 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 9, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 10690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*finishMoveKeysParallelismLock);
															#line 1316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = checkMoveKeysLock(&tr, lock, ddEnabledState);
															#line 1316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 2;
															#line 1316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 1, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 10714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*finishMoveKeysParallelismLock);
															#line 1316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = checkMoveKeysLock(&tr, lock, ddEnabledState);
															#line 1316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 2;
															#line 1316 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 1, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 10732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1318 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(begin, keys.end);
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 3;
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 2, RangeResult >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 10825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1318 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(begin, keys.end);
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 3;
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 2, RangeResult >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 10843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
															#line 1320 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1321 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = krmGetRanges(&tr, keyServersPrefix, currentKeys, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES);
															#line 1321 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 4;
															#line 1321 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 3, RangeResult >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 10936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 10945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont5(int loopDepth) 
	{
															#line 1328 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		endKey = keyServers.end()[-1].key;
															#line 1329 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(currentKeys.begin, endKey);
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		bool alreadyMoved = true;
															#line 1337 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dest = std::vector<UID>();
															#line 1338 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		allServers = std::set<UID>();
															#line 1339 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		intendedTeam = std::set<UID>(destinationTeam.begin(), destinationTeam.end());
															#line 1340 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		src = std::vector<UID>();
															#line 1341 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<UID> completeSrc;
															#line 1344 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int currentIndex;
															#line 1345 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(currentIndex = 0;currentIndex < keyServers.size() - 1 && alreadyMoved;currentIndex++) {
															#line 1346 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, keyServers[currentIndex].value, src, dest);
															#line 1348 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::set<UID> srcSet;
															#line 1349 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < src.size();s++) {
															#line 1350 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				srcSet.insert(src[s]);
															#line 11050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1353 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (currentIndex == 0)
															#line 11054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1354 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				completeSrc = src;
															#line 11058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 1356 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				for(int i = 0;i < completeSrc.size();i++) {
															#line 1357 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (!srcSet.contains(completeSrc[i]))
															#line 11066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					{
															#line 1358 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						swapAndPop(&completeSrc, i--);
															#line 11070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					}
				}
			}
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::set<UID> destSet;
															#line 1364 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < dest.size();s++) {
															#line 1365 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				destSet.insert(dest[s]);
															#line 11080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1368 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			allServers.insert(srcSet.begin(), srcSet.end());
															#line 1369 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			allServers.insert(destSet.begin(), destSet.end());
															#line 1373 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool isSubset = std::includes(intendedTeam.begin(), intendedTeam.end(), srcSet.begin(), srcSet.end());
															#line 1375 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			alreadyMoved = destSet.empty() && isSubset;
															#line 1376 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (destSet != intendedTeam && !alreadyMoved)
															#line 11092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1377 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevWarn, "MoveKeysDestTeamNotIntended", relocationIntervalId) .detail("KeyBegin", keys.begin) .detail("KeyEnd", keys.end) .detail("IterationBegin", begin) .detail("IterationEnd", endKey) .detail("SrcSet", describe(srcSet)) .detail("DestSet", describe(destSet)) .detail("IntendedTeam", describe(intendedTeam)) .detail("KeyServers", keyServers);
															#line 1388 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				ASSERT(!dest.empty());
															#line 1391 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				intendedTeam.clear();
															#line 1392 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				for(int i = 0;i < dest.size();i++) {
															#line 1393 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					intendedTeam.insert(dest[i]);
															#line 11104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
			else
			{
															#line 1394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (alreadyMoved)
															#line 11111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1395 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					dest.clear();
															#line 1396 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					src.clear();
															#line 1397 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					CODE_PROBE(true, "FinishMoveKeys first key in iteration sub-range has already been processed");
															#line 11119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
		}
															#line 1403 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(;currentIndex < keyServers.size() - 1;currentIndex++) {
															#line 1404 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src2, dest2;
															#line 1405 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, keyServers[currentIndex].value, src2, dest2);
															#line 1407 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::set<UID> srcSet;
															#line 1408 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < src2.size();s++) {
															#line 1409 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				srcSet.insert(src2[s]);
															#line 11135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1411 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int i = 0;i < completeSrc.size();i++) {
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!srcSet.contains(completeSrc[i]))
															#line 11141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1413 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					swapAndPop(&completeSrc, i--);
															#line 11145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
															#line 1417 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			allServers.insert(srcSet.begin(), srcSet.end());
															#line 1421 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool isSubset = std::includes(intendedTeam.begin(), intendedTeam.end(), srcSet.begin(), srcSet.end());
															#line 1423 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			alreadyMoved = dest2.empty() && isSubset;
															#line 1424 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (dest2 != dest && !alreadyMoved)
															#line 11156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1425 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevError, "FinishMoveKeysError", relocationIntervalId) .detail("Reason", "dest mismatch") .detail("Dest", describe(dest)) .detail("Dest2", describe(dest2));
															#line 1429 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				ASSERT(false);
															#line 11162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1432 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!dest.size())
															#line 11167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1433 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			CODE_PROBE(true, "A previous finishMoveKeys for this range committed just as it was cancelled to " "start this one?");
															#line 1436 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent("FinishMoveKeysNothingToDo", relocationIntervalId) .detail("KeyBegin", keys.begin) .detail("KeyEnd", keys.end) .detail("IterationBegin", begin) .detail("IterationEnd", endKey);
															#line 1441 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			begin = keyServers.end()[-1].key;
															#line 11175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1445 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		waitInterval = TraceInterval("RelocateShard_FinishMoveKeysWaitDurable");
															#line 1446 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevDebug, waitInterval.begin(), relocationIntervalId) .detail("KeyBegin", keys.begin) .detail("KeyEnd", keys.end);
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverReady = std::vector<Future<Void>>();
															#line 1454 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tssReady = std::vector<Future<Void>>();
															#line 1455 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tssReadyInterfs = std::vector<StorageServerInterface>();
															#line 1456 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newDestinations = std::vector<UID>();
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::set<UID> completeSrcSet(completeSrc.begin(), completeSrc.end());
															#line 1458 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( auto& it : dest ) {
															#line 1459 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!hasRemote || !completeSrcSet.contains(it))
															#line 11196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1460 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				newDestinations.push_back(it);
															#line 11200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1465 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		storageServerInterfaces = std::vector<StorageServerInterface>();
															#line 1466 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Optional<Value>>> serverListEntries;
															#line 1467 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListEntries.reserve(newDestinations.size());
															#line 1468 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < newDestinations.size();s++) {
															#line 1469 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			serverListEntries.push_back(tr.get(serverListKeyFor(newDestinations[s])));
															#line 11213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1470 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_4 = getAll(serverListEntries);
															#line 1470 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 5;
															#line 1470 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(RangeResult const& __keyServers,int loopDepth) 
	{
															#line 1321 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keyServers = __keyServers;
															#line 11233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(RangeResult && __keyServers,int loopDepth) 
	{
		keyServers = std::move(__keyServers);
		loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1cont6(int loopDepth) 
	{
															#line 1472 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser.release();
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1475 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(serverListValues[s] .present());
															#line 1477 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			auto si = decodeServerListValue(serverListValues[s].get());
															#line 1478 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(si.id() == newDestinations[s]);
															#line 1479 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			storageServerInterfaces.push_back(si);
															#line 11322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1486 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverReady.reserve(storageServerInterfaces.size());
															#line 1487 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tssReady.reserve(storageServerInterfaces.size());
															#line 1488 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tssReadyInterfs.reserve(storageServerInterfaces.size());
															#line 1489 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < storageServerInterfaces.size();s++) {
															#line 1490 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			serverReady.push_back(waitForShardReady(storageServerInterfaces[s], keys, tr.getReadVersion().get(), GetShardStateRequest::READABLE));
															#line 1495 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			auto tssPair = tssMapping.find(storageServerInterfaces[s].id());
															#line 1497 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (tssPair != tssMapping.end() && waitForTSSCounter > 0 && !tssToIgnore.contains(tssPair->second.id()))
															#line 11338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1499 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssReadyInterfs.push_back(tssPair->second);
															#line 1500 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssReady.push_back(waitForShardReady( tssPair->second, keys, tr.getReadVersion().get(), GetShardStateRequest::READABLE));
															#line 11344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1507 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_5 = timeout(waitForAll(serverReady) && waitForAllReady(tssReady), SERVER_KNOBS->SERVER_READY_QUORUM_TIMEOUT, Void(), TaskPriority::MoveKeys);
															#line 1507 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 6;
															#line 1507 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 5, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5when1(std::vector<Optional<Value>> const& __serverListValues,int loopDepth) 
	{
															#line 1470 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListValues = __serverListValues;
															#line 11365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5when1(std::vector<Optional<Value>> && __serverListValues,int loopDepth) 
	{
		serverListValues = std::move(__serverListValues);
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1loopBody1cont27(Void const& _,int loopDepth) 
	{
															#line 1515 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (tssReady.size())
															#line 11444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1516 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool allSSDone = true;
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& f : serverReady ) {
															#line 1518 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				allSSDone &= f.isReady() && !f.isError();
															#line 1519 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!allSSDone)
															#line 11454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
					break;
				}
			}
															#line 1524 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (allSSDone)
															#line 11461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1525 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				bool anyTssNotDone = false;
															#line 1527 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				for( auto& f : tssReady ) {
															#line 1528 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (!f.isReady() || f.isError())
															#line 11469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					{
															#line 1529 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						anyTssNotDone = true;
															#line 1530 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						waitForTSSCounter--;
															#line 11475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
						break;
					}
				}
															#line 1535 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (anyTssNotDone && waitForTSSCounter == 0)
															#line 11481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1536 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					for(int i = 0;i < tssReady.size();i++) {
															#line 1537 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						if (!tssReady[i].isReady() || tssReady[i].isError())
															#line 11487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
						{
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
							tssToIgnore.insert(tssReadyInterfs[i].id());
															#line 11491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
						}
					}
				}
			}
		}
															#line 1545 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int count = dest.size() - newDestinations.size();
															#line 1546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverReady.size();s++) {
															#line 1547 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			count += serverReady[s].isReady() && !serverReady[s].isError();
															#line 11503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1549 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int tssCount = 0;
															#line 1550 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < tssReady.size();s++) {
															#line 1551 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tssCount += tssReady[s].isReady() && !tssReady[s].isError();
															#line 11511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1553 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent readyServersEv(SevDebug, waitInterval.end(), relocationIntervalId);
															#line 1554 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		readyServersEv.detail("ReadyServers", count).detail("Dests", dest.size());
															#line 1555 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (tssReady.size())
															#line 11519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1556 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			readyServersEv.detail("ReadyTSS", tssCount);
															#line 11523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1559 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (count == dest.size())
															#line 11527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1563 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_6 = krmSetRangeCoalescing( &tr, keyServersPrefix, currentKeys, keys, keyServersValue(UIDtoTagMap, dest));
															#line 1563 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1loopBody1cont27when1(__when_expr_6.get(), loopDepth); };
			static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 7;
															#line 1563 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 6, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont27cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27(Void && _,int loopDepth) 
	{
															#line 1515 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (tssReady.size())
															#line 11552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1516 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool allSSDone = true;
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& f : serverReady ) {
															#line 1518 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				allSSDone &= f.isReady() && !f.isError();
															#line 1519 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!allSSDone)
															#line 11562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
					break;
				}
			}
															#line 1524 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (allSSDone)
															#line 11569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1525 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				bool anyTssNotDone = false;
															#line 1527 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				for( auto& f : tssReady ) {
															#line 1528 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (!f.isReady() || f.isError())
															#line 11577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					{
															#line 1529 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						anyTssNotDone = true;
															#line 1530 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						waitForTSSCounter--;
															#line 11583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
						break;
					}
				}
															#line 1535 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (anyTssNotDone && waitForTSSCounter == 0)
															#line 11589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1536 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					for(int i = 0;i < tssReady.size();i++) {
															#line 1537 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						if (!tssReady[i].isReady() || tssReady[i].isError())
															#line 11595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
						{
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
							tssToIgnore.insert(tssReadyInterfs[i].id());
															#line 11599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
						}
					}
				}
			}
		}
															#line 1545 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int count = dest.size() - newDestinations.size();
															#line 1546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverReady.size();s++) {
															#line 1547 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			count += serverReady[s].isReady() && !serverReady[s].isError();
															#line 11611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1549 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int tssCount = 0;
															#line 1550 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < tssReady.size();s++) {
															#line 1551 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tssCount += tssReady[s].isReady() && !tssReady[s].isError();
															#line 11619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1553 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent readyServersEv(SevDebug, waitInterval.end(), relocationIntervalId);
															#line 1554 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		readyServersEv.detail("ReadyServers", count).detail("Dests", dest.size());
															#line 1555 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (tssReady.size())
															#line 11627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1556 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			readyServersEv.detail("ReadyTSS", tssCount);
															#line 11631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1559 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (count == dest.size())
															#line 11635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1563 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_6 = krmSetRangeCoalescing( &tr, keyServersPrefix, currentKeys, keys, keyServersValue(UIDtoTagMap, dest));
															#line 1563 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1loopBody1cont27when1(__when_expr_6.get(), loopDepth); };
			static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 7;
															#line 1563 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 6, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont27cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1loopBody1cont27cont1(int loopDepth) 
	{
															#line 1584 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.reset();
															#line 11735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont27cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14(Void const& _,int loopDepth) 
	{
															#line 1566 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::set<UID>::iterator asi = allServers.begin();
															#line 1567 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Void>> actors;
															#line 1568 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(;asi != allServers.end();) {
															#line 1569 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool destHasServer = std::find(dest.begin(), dest.end(), *asi) != dest.end();
															#line 1570 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(krmSetRangeCoalescing(&tr, serverKeysPrefixFor(*asi), currentKeys, allKeys, destHasServer ? serverKeysTrue : serverKeysFalse));
															#line 1575 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			++asi;
															#line 11754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1578 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(actors);
															#line 1578 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1loopBody1cont27cont14when1(__when_expr_7.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 8;
															#line 1578 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 7, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11765 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14(Void && _,int loopDepth) 
	{
															#line 1566 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::set<UID>::iterator asi = allServers.begin();
															#line 1567 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Void>> actors;
															#line 1568 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(;asi != allServers.end();) {
															#line 1569 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool destHasServer = std::find(dest.begin(), dest.end(), *asi) != dest.end();
															#line 1570 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(krmSetRangeCoalescing(&tr, serverKeysPrefixFor(*asi), currentKeys, allKeys, destHasServer ? serverKeysTrue : serverKeysFalse));
															#line 1575 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			++asi;
															#line 11784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1578 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(actors);
															#line 1578 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1loopBody1cont27cont14when1(__when_expr_7.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 8;
															#line 1578 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 7, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody1cont27when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody1cont27when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1loopBody1cont27cont14cont1(Void const& _,int loopDepth) 
	{
															#line 1579 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_8 = tr.commit();
															#line 1579 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1loopBody1cont27cont14cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 9;
															#line 1579 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 8, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14cont1(Void && _,int loopDepth) 
	{
															#line 1579 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_8 = tr.commit();
															#line 1579 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1loopBody1cont27cont14cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 9;
															#line 1579 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 8, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27cont14cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27cont14cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1loopBody1cont27cont14when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1loopBody1cont27cont14when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1loopBody1cont27cont14cont3(Void const& _,int loopDepth) 
	{
															#line 1581 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		begin = endKey;
															#line 11986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14cont3(Void && _,int loopDepth) 
	{
															#line 1581 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		begin = endKey;
															#line 11995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27cont14cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27cont14cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1loopBody1cont27cont14cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1loopBody1cont27cont14cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1loopBody1cont27cont16(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 1590 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retries++;
															#line 1591 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (retries % 10 == 0)
															#line 12094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(retries == 20 ? SevWarnAlways : SevWarn, "RelocateShard_FinishMoveKeysRetrying", relocationIntervalId) .error(err) .detail("KeyBegin", keys.begin) .detail("KeyEnd", keys.end) .detail("IterationBegin", begin) .detail("IterationEnd", endKey);
															#line 12098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 1590 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retries++;
															#line 1591 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (retries % 10 == 0)
															#line 12110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(retries == 20 ? SevWarnAlways : SevWarn, "RelocateShard_FinishMoveKeysRetrying", relocationIntervalId) .error(err) .detail("KeyBegin", keys.begin) .detail("KeyEnd", keys.end) .detail("IterationBegin", begin) .detail("IterationEnd", endKey);
															#line 12114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange keys;
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> destinationTeam;
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock* finishMoveKeysParallelismLock;
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool hasRemote;
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID relocationIntervalId;
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 1278 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	TraceInterval interval;
															#line 1279 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	TraceInterval waitInterval;
															#line 1280 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Future<Void> warningLogger;
															#line 1281 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key begin;
															#line 1282 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key endKey;
															#line 1283 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int retries;
															#line 1284 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock::Releaser releaser;
															#line 1286 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::unordered_set<UID> tssToIgnore;
															#line 1288 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int waitForTSSCounter;
															#line 1302 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 1318 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange currentKeys;
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 1321 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult keyServers;
															#line 1337 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> dest;
															#line 1338 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::set<UID> allServers;
															#line 1339 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::set<UID> intendedTeam;
															#line 1340 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> src;
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Void>> serverReady;
															#line 1454 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Void>> tssReady;
															#line 1455 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<StorageServerInterface> tssReadyInterfs;
															#line 1456 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> newDestinations;
															#line 1465 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<StorageServerInterface> storageServerInterfaces;
															#line 1470 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Optional<Value>> serverListValues;
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Error err;
															#line 12274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via finishMoveKeys()
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class FinishMoveKeysActor final : public Actor<Void>, public ActorCallback< FinishMoveKeysActor, 0, Void >, public ActorCallback< FinishMoveKeysActor, 1, Void >, public ActorCallback< FinishMoveKeysActor, 2, RangeResult >, public ActorCallback< FinishMoveKeysActor, 3, RangeResult >, public ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >, public ActorCallback< FinishMoveKeysActor, 5, Void >, public ActorCallback< FinishMoveKeysActor, 6, Void >, public ActorCallback< FinishMoveKeysActor, 7, Void >, public ActorCallback< FinishMoveKeysActor, 8, Void >, public ActorCallback< FinishMoveKeysActor, 9, Void >, public FastAllocated<FinishMoveKeysActor>, public FinishMoveKeysActorState<FinishMoveKeysActor> {
															#line 12279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<FinishMoveKeysActor>::operator new;
	using FastAllocated<FinishMoveKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17704785174303059968UL, 17135810549237729792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FinishMoveKeysActor, 0, Void >;
friend struct ActorCallback< FinishMoveKeysActor, 1, Void >;
friend struct ActorCallback< FinishMoveKeysActor, 2, RangeResult >;
friend struct ActorCallback< FinishMoveKeysActor, 3, RangeResult >;
friend struct ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >;
friend struct ActorCallback< FinishMoveKeysActor, 5, Void >;
friend struct ActorCallback< FinishMoveKeysActor, 6, Void >;
friend struct ActorCallback< FinishMoveKeysActor, 7, Void >;
friend struct ActorCallback< FinishMoveKeysActor, 8, Void >;
friend struct ActorCallback< FinishMoveKeysActor, 9, Void >;
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FinishMoveKeysActor(Database const& occ,KeyRange const& keys,std::vector<UID> const& destinationTeam,MoveKeysLock const& lock,FlowLock* const& finishMoveKeysParallelismLock,bool const& hasRemote,UID const& relocationIntervalId,std::map<UID, StorageServerInterface> const& tssMapping,const DDEnabledState* const& ddEnabledState) 
															#line 12305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   FinishMoveKeysActorState<FinishMoveKeysActor>(occ, keys, destinationTeam, lock, finishMoveKeysParallelismLock, hasRemote, relocationIntervalId, tssMapping, ddEnabledState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14752164062687862784UL, 9104012867374661120UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finishMoveKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] static Future<Void> finishMoveKeys( Database const& occ, KeyRange const& keys, std::vector<UID> const& destinationTeam, MoveKeysLock const& lock, FlowLock* const& finishMoveKeysParallelismLock, bool const& hasRemote, UID const& relocationIntervalId, std::map<UID, StorageServerInterface> const& tssMapping, const DDEnabledState* const& ddEnabledState ) {
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new FinishMoveKeysActor(occ, keys, destinationTeam, lock, finishMoveKeysParallelismLock, hasRemote, relocationIntervalId, tssMapping, ddEnabledState));
															#line 12346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 1612 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

// keyServer: map from keys to destination servers.
// serverKeys: two-dimension map: [servers][keys], value is the servers' state of having the keys: active(not-have),
// complete(already has), ""().
// Set keyServers[keys].dest = servers Set serverKeys[servers][keys] = dataMoveId for each
// subrange of keys.
// Set dataMoves[dataMoveId] = DataMoveMetaData.
															#line 12357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via startMoveShards()
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class StartMoveShardsActor>
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class StartMoveShardsActorState {
															#line 12363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	StartMoveShardsActorState(Database const& occ,UID const& dataMoveId,std::vector<KeyRange> const& ranges,std::vector<UID> const& servers,MoveKeysLock const& lock,FlowLock* const& startMoveKeysLock,UID const& relocationIntervalId,std::map<UID, StorageServerInterface>* const& tssMapping,const DDEnabledState* const& ddEnabledState,CancelConflictingDataMoves const& cancelConflictingDataMoves,Optional<BulkLoadTaskState> const& bulkLoadTaskState) 
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId),
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ranges(ranges),
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   servers(servers),
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   lock(lock),
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   startMoveKeysLock(startMoveKeysLock),
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   relocationIntervalId(relocationIntervalId),
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tssMapping(tssMapping),
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   cancelConflictingDataMoves(cancelConflictingDataMoves),
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   bulkLoadTaskState(bulkLoadTaskState),
															#line 1630 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   warningLogger(logWarningAfter("StartMoveShardsTooLong", 600, servers))
															#line 12392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("startMoveShards", reinterpret_cast<unsigned long>(this));

	}
	~StartMoveShardsActorState() 
	{
		fdb_probe_actor_destroy("startMoveShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1632 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = startMoveKeysLock->take(TaskPriority::DataDistributionLaunch);
															#line 1632 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 1;
															#line 1632 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 0, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartMoveShardsActorState();
		static_cast<StartMoveShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1633 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*startMoveKeysLock);
															#line 1634 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = false;
															#line 1635 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove = DataMoveMetaData();
															#line 1636 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		sevDm = static_cast<Severity>(SERVER_KNOBS->PHYSICAL_SHARD_MOVE_LOG_SEVERITY);
															#line 1638 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "StartMoveShardsBegin", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("TargetRange", describe(ranges)) .detail("BulkLoadTaskID", bulkLoadTaskState.present() ? bulkLoadTaskState.get().getTaskId().toString() : "");
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(ranges.size() == 1);
															#line 1645 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keys = ranges[0];
															#line 1646 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		cancelDataMove = false;
															#line 1647 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		runPreCheck = true;
															#line 12453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 1649 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 12457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1633 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*startMoveKeysLock);
															#line 1634 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = false;
															#line 1635 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove = DataMoveMetaData();
															#line 1636 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		sevDm = static_cast<Severity>(SERVER_KNOBS->PHYSICAL_SHARD_MOVE_LOG_SEVERITY);
															#line 1638 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "StartMoveShardsBegin", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("TargetRange", describe(ranges)) .detail("BulkLoadTaskID", bulkLoadTaskState.present() ? bulkLoadTaskState.get().getTaskId().toString() : "");
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(ranges.size() == 1);
															#line 1645 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keys = ranges[0];
															#line 1646 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		cancelDataMove = false;
															#line 1647 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		runPreCheck = true;
															#line 12488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 1649 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 12492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1978 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "StartMoveShardsEnd", relocationIntervalId).detail("DataMoveID", dataMoveId);
															#line 1980 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<StartMoveShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartMoveShardsActorState(); static_cast<StartMoveShardsActor*>(this)->destroy(); return 0; }
															#line 12584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<StartMoveShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartMoveShardsActorState();
		static_cast<StartMoveShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1972 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarn, "StartMoveShardsError", relocationIntervalId) .errorUnsuppressed(e) .detail("DataMoveID", dataMoveId);
															#line 1975 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 12599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		begin = keys.begin;
															#line 1651 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = keys;
															#line 1653 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		actors = std::vector<Future<Void>>();
															#line 1654 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr = Transaction(occ);
															#line 12632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 1657 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.trState->taskID = TaskPriority::MoveKeys;
															#line 1658 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1659 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1660 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1662 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_1 = checkMoveKeysLock(&tr, lock, ddEnabledState);
															#line 1662 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 2;
															#line 1662 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 1, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() == error_code_location_metadata_corruption)
															#line 12686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1956 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1Catch1(location_metadata_corruption(), std::max(0, loopDepth - 1));
															#line 12690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 1957 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (e.code() == error_code_retry)
															#line 12696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1958 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					runPreCheck = false;
															#line 1959 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Void> __when_expr_17 = delay(1);
															#line 1959 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont1Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_17.get(), loopDepth); };
					static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 18;
															#line 1959 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 17, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1961 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					TraceEvent(SevWarn, "StartMoveShardsError", relocationIntervalId) .errorUnsuppressed(e) .detail("DataMoveID", dataMoveId) .detail("DataMoveRange", keys) .detail("CurrentDataMoveMetaData", dataMove.toString());
															#line 1966 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					runPreCheck = false;
															#line 1967 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Void> __when_expr_18 = tr.onError(e);
															#line 1967 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1Catch1(__when_expr_18.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when2(__when_expr_18.get(), loopDepth); };
					static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 19;
															#line 1967 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 18, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1664 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(dataMoveKeyFor(dataMoveId));
															#line 1664 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 3;
															#line 1664 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 2, Optional<Value> >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1664 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(dataMoveKeyFor(dataMoveId));
															#line 1664 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 3;
															#line 1664 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 2, Optional<Value> >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Optional<Value> const& val,int loopDepth) 
	{
															#line 1665 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (val.present())
															#line 12851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1666 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			DataMoveMetaData dmv = decodeDataMoveValue(val.get());
															#line 1667 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove = dmv;
															#line 1668 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "StartMoveShardsFoundDataMove", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString()) .detail("CancelDataMove", cancelDataMove);
															#line 1672 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (dataMove.getPhase() == DataMoveMetaData::Deleting)
															#line 12861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(sevDm, "StartMoveShardsDataMoveDeleted", relocationIntervalId) .detail("DataMove", dataMove.toString()) .detail("BackgroundCleanUp", dataMove.ranges.empty());
															#line 1676 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(data_move_cancelled(), loopDepth);
															#line 12867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1678 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(!dataMove.ranges.empty() && dataMove.ranges.front().begin == keys.begin);
															#line 1679 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (cancelDataMove)
															#line 12873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1680 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				dataMove.setPhase(DataMoveMetaData::Deleting);
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr.set(dataMoveKeyFor(dataMoveId), dataMoveValue(dataMove));
															#line 1682 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 1682 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
				static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 4;
															#line 1682 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 3, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont5(loopDepth);
			}
		}
		else
		{
															#line 1693 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (cancelDataMove)
															#line 12900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1694 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(movekeys_conflict(), loopDepth);
															#line 12904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1696 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove = DataMoveMetaData();
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove.id = dataMoveId;
															#line 1698 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "StartMoveShardssNewDataMove", relocationIntervalId) .detail("DataMoveRange", keys) .detail("DataMoveID", dataMoveId);
															#line 12912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Optional<Value> && val,int loopDepth) 
	{
															#line 1665 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (val.present())
															#line 12922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1666 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			DataMoveMetaData dmv = decodeDataMoveValue(val.get());
															#line 1667 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove = dmv;
															#line 1668 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "StartMoveShardsFoundDataMove", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString()) .detail("CancelDataMove", cancelDataMove);
															#line 1672 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (dataMove.getPhase() == DataMoveMetaData::Deleting)
															#line 12932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(sevDm, "StartMoveShardsDataMoveDeleted", relocationIntervalId) .detail("DataMove", dataMove.toString()) .detail("BackgroundCleanUp", dataMove.ranges.empty());
															#line 1676 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(data_move_cancelled(), loopDepth);
															#line 12938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1678 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(!dataMove.ranges.empty() && dataMove.ranges.front().begin == keys.begin);
															#line 1679 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (cancelDataMove)
															#line 12944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1680 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				dataMove.setPhase(DataMoveMetaData::Deleting);
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr.set(dataMoveKeyFor(dataMoveId), dataMoveValue(dataMove));
															#line 1682 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 1682 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
				static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 4;
															#line 1682 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 3, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont5(loopDepth);
			}
		}
		else
		{
															#line 1693 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (cancelDataMove)
															#line 12971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1694 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(movekeys_conflict(), loopDepth);
															#line 12975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1696 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove = DataMoveMetaData();
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove.id = dataMoveId;
															#line 1698 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "StartMoveShardssNewDataMove", relocationIntervalId) .detail("DataMoveRange", keys) .detail("DataMoveID", dataMoveId);
															#line 12983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
															#line 1703 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!loadedTssMapping)
															#line 13068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1705 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_4 = readTSSMapping(&tr, tssMapping);
															#line 1705 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
			static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 5;
															#line 1705 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 4, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13079 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
															#line 1685 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (dataMove.getPhase() == DataMoveMetaData::Running)
															#line 13093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1686 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "StartMoveShardsDataMove", relocationIntervalId) .detail("DataMoveAlreadyCommitted", dataMoveId);
															#line 1688 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(keys == dataMove.ranges.front());
															#line 1689 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!static_cast<StartMoveShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartMoveShardsActorState(); static_cast<StartMoveShardsActor*>(this)->destroy(); return 0; }
															#line 13101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			new (&static_cast<StartMoveShardsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartMoveShardsActorState();
			static_cast<StartMoveShardsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1691 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		begin = dataMove.ranges.front().end;
															#line 13109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 1683 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(movekeys_conflict(), loopDepth);
															#line 13118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 1683 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(movekeys_conflict(), loopDepth);
															#line 13126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont13(int loopDepth) 
	{
															#line 1709 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Optional<Value>>> serverListEntries;
															#line 1710 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListEntries.reserve(servers.size());
															#line 1711 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < servers.size();s++) {
															#line 1712 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			serverListEntries.push_back(tr.get(serverListKeyFor(servers[s])));
															#line 13215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_5 = getAll(serverListEntries);
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont13when1(__when_expr_5.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 6;
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont14(Void const& _,int loopDepth) 
	{
															#line 1706 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = true;
															#line 13235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont14(Void && _,int loopDepth) 
	{
															#line 1706 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = true;
															#line 13244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont13cont1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1717 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!serverListValues[s].present())
															#line 13330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1722 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(move_to_removed_server(), loopDepth);
															#line 13334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1726 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(begin, keys.end);
															#line 1728 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!currentKeys.empty())
															#line 13341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1729 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const int rowLimit = SERVER_KNOBS->MOVE_SHARD_KRM_ROW_LIMIT;
															#line 1730 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const int byteLimit = SERVER_KNOBS->MOVE_SHARD_KRM_BYTE_LIMIT;
															#line 1731 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<RangeResult> __when_expr_6 = krmGetRanges(&tr, keyServersPrefix, currentKeys, rowLimit, byteLimit);
															#line 1731 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont1when1(__when_expr_6.get(), loopDepth); };
			static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 7;
															#line 1731 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 6, RangeResult >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont13cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1717 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!serverListValues[s].present())
															#line 13372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1722 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(move_to_removed_server(), loopDepth);
															#line 13376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1726 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(begin, keys.end);
															#line 1728 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!currentKeys.empty())
															#line 13383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1729 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const int rowLimit = SERVER_KNOBS->MOVE_SHARD_KRM_ROW_LIMIT;
															#line 1730 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const int byteLimit = SERVER_KNOBS->MOVE_SHARD_KRM_BYTE_LIMIT;
															#line 1731 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<RangeResult> __when_expr_6 = krmGetRanges(&tr, keyServersPrefix, currentKeys, rowLimit, byteLimit);
															#line 1731 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont1when1(__when_expr_6.get(), loopDepth); };
			static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 7;
															#line 1731 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 6, RangeResult >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont13cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13when1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont1(serverListValues, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13when1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont1(std::move(serverListValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont13cont3(int loopDepth) 
	{
															#line 1873 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentKeys.end == keys.end)
															#line 13487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1874 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (bulkLoadTaskState.present())
															#line 13491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1875 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				newBulkLoadTaskState = BulkLoadTaskState();
															#line 13495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				try {
															#line 1877 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Void> __when_expr_12 = store(newBulkLoadTaskState, getBulkLoadTask(&tr, bulkLoadTaskState.get().getRange(), bulkLoadTaskState.get().getTaskId(), { BulkLoadPhase::Triggered, BulkLoadPhase::Running }));
															#line 1877 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont13cont3Catch1(actor_cancelled(), loopDepth);
															#line 13501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1loopBody1cont13cont3Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont3when1(__when_expr_12.get(), loopDepth); };
					static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 13;
															#line 1877 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 12, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1cont1loopBody1cont13cont3Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1loopBody1cont13cont3Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont13cont12(loopDepth);
			}
		}
		else
		{
															#line 1912 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove.setPhase(DataMoveMetaData::Prepare);
															#line 1913 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "StartMoveShardsDataMovePartial", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("CurrentRange", currentKeys) .detail("DataMoveRange", keys) .detail("NewDataMoveMetaData", dataMove.toString());
															#line 13526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont13cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont6(int loopDepth) 
	{
															#line 1733 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		endKey = old.back().key;
															#line 1734 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(currentKeys.begin, endKey);
															#line 1737 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_7 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1737 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont6when1(__when_expr_7.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 8;
															#line 1737 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 7, RangeResult >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont1when1(RangeResult const& __old,int loopDepth) 
	{
															#line 1731 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		old = __old;
															#line 13556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont1when1(RangeResult && __old,int loopDepth) 
	{
		old = std::move(__old);
		loopDepth = a_body1cont1loopBody1cont13cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont13cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont13cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1cont13cont7(int loopDepth) 
	{
															#line 1738 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1742 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		oldIndex = 0;
															#line 1743 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		;
															#line 13639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont6when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 1737 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 13648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont6when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1cont1loopBody1cont13cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 7, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 7, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont13cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 7, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont13cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 7, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1cont13cont8(int loopDepth) 
	{
															#line 1860 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < servers.size();i++) {
															#line 1864 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(krmSetRangeCoalescing( &tr, serverKeysPrefixFor(servers[i]), currentKeys, allKeys, serverKeysValue(dataMoveId)));
															#line 13729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1868 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.ranges.clear();
															#line 1869 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.ranges.push_back(KeyRangeRef(keys.begin, currentKeys.end));
															#line 1870 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.dest.insert(servers.begin(), servers.end());
															#line 13737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont13cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1(int loopDepth) 
	{
															#line 1743 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!(oldIndex < old.size() - 1))
															#line 13753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1cont1loopBody1cont13cont7break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1744 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		rangeIntersectKeys = KeyRangeRef(old[oldIndex].key, old[oldIndex + 1].key);
															#line 1745 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		src = std::vector<UID>();
															#line 1746 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dest = std::vector<UID>();
															#line 1747 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		srcId = UID();
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		destId = UID();
															#line 1749 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, old[oldIndex].value, src, dest, srcId, destId);
															#line 1750 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "StartMoveShardsProcessingShard", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("Range", rangeIntersectKeys) .detail("OldSrc", describe(src)) .detail("OldDest", describe(dest)) .detail("SrcID", srcId) .detail("DestID", destId) .detail("ReadVersion", tr.getReadVersion().get());
															#line 1759 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (bulkLoadTaskState.present())
															#line 13773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1760 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			owners = std::vector<UID>(src.size() + dest.size());
															#line 1761 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), owners.begin());
															#line 1762 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const auto& ssid : servers ) {
															#line 1763 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (std::find(owners.begin(), owners.end(), ssid) != owners.end())
															#line 13783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1764 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					TraceEvent(SevWarn, "DDBulkLoadTaskStartMoveShardsMoveInConflict") .detail("TaskID", bulkLoadTaskState.get().getTaskId()) .detail("JobID", bulkLoadTaskState.get().getJobId()) .detail("TaskRange", bulkLoadTaskState.get().getRange()) .detail("DestServerId", ssid) .detail("OwnerIds", describe(owners)) .detail("DataMove", dataMove.toString());
															#line 1771 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					cancelDataMove = true;
															#line 1772 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 13791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
		}
															#line 1778 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (SERVER_KNOBS->AUDIT_DATAMOVE_PRE_CHECK && runPreCheck)
															#line 13797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1779 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> servers(src.size() + dest.size());
															#line 1780 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), servers.begin());
															#line 1781 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_8 = auditLocationMetadataPreCheck( occ, &tr, rangeIntersectKeys, servers, "startMoveShards_precheck", dataMoveId);
															#line 1781 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont13cont7loopBody1when1(__when_expr_8.get(), loopDepth); };
			static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 9;
															#line 1781 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 8, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13812 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont13cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7continue1(int loopDepth) 
	{
															#line 1743 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		++oldIndex;
															#line 13839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont13cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont1(int loopDepth) 
	{
															#line 1785 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (destId.isValid())
															#line 13848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1786 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarn, "StartMoveShardsDestIDExist", relocationIntervalId) .detail("Range", rangeIntersectKeys) .detail("DataMoveID", dataMoveId.toString()) .detail("DestID", destId.toString()) .log();
															#line 1791 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(!dest.empty());
															#line 1793 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (destId == dataMoveId)
															#line 13856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1794 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevWarn, "StartMoveShardsRangeAlreadyCommitted", relocationIntervalId) .detail("Range", rangeIntersectKeys) .detail("DataMoveID", dataMoveId);
															#line 13860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				return a_body1cont1loopBody1cont13cont7continue1(loopDepth); // continue
			}
															#line 1800 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (destId == anonymousShardId)
															#line 13865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1801 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_9 = cleanUpSingleShardDataMove( occ, rangeIntersectKeys, lock, startMoveKeysLock, dataMoveId, ddEnabledState);
															#line 1801 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1loopBody1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont13cont7loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
				static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 10;
															#line 1801 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 9, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1805 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (cancelConflictingDataMoves)
															#line 13883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1806 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					TraceEvent( SevWarn, "StartMoveShardsCancelConflictingDataMove", relocationIntervalId) .detail("Range", rangeIntersectKeys) .detail("DataMoveID", dataMoveId.toString()) .detail("ExistingDataMoveID", destId.toString());
															#line 1811 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Void> __when_expr_10 = cleanUpDataMove(occ, destId, lock, startMoveKeysLock, keys, ddEnabledState);
															#line 1811 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont13cont7loopBody1cont1when2(__when_expr_10.get(), loopDepth); };
					static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 11;
															#line 1811 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 10, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1814 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Optional<Value>> __when_expr_11 = tr.get(dataMoveKeyFor(destId));
															#line 1814 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont13cont7loopBody1cont1when3(__when_expr_11.get(), loopDepth); };
					static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 12;
															#line 1814 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 11, Optional<Value> >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont7(int loopDepth) 
	{
															#line 1830 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		krmSetPreviouslyEmptyRange(&tr, keyServersPrefix, rangeIntersectKeys, keyServersValue(src, servers, srcId, dataMoveId), old[oldIndex + 1].value);
															#line 1836 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.src.insert(src.begin(), src.end());
															#line 1839 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (shouldCreateCheckpoint(dataMoveId) && !bulkLoadTaskState.present())
															#line 14017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1840 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const UID checkpointId = UID(deterministicRandom()->randomUInt64(), srcId.first());
															#line 1841 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			CheckpointMetaData checkpoint(std::vector<KeyRange>{ rangeIntersectKeys }, DataMoveRocksCF, src, checkpointId, dataMoveId);
															#line 1846 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			checkpoint.setState(CheckpointMetaData::Pending);
															#line 1847 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.set(checkpointKeyFor(checkpointId), checkpointValue(checkpoint));
															#line 1848 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove.checkpoints.insert(checkpointId);
															#line 1849 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "InitiatedCheckpoint", relocationIntervalId) .detail("CheckpointID", checkpointId.toString()) .detail("Range", rangeIntersectKeys) .detail("DataMoveID", dataMoveId) .detail("SrcServers", describe(src)) .detail("ReadVersion", tr.getReadVersion().get());
															#line 14031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1743 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		++oldIndex;
															#line 14035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont13cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 1803 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 14044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 1803 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 14052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont12(Void const& _,int loopDepth) 
	{
															#line 1812 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 14135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont12(Void && _,int loopDepth) 
	{
															#line 1812 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 14143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont13(Optional<Value> const& val,int loopDepth) 
	{
															#line 1815 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(val.present());
															#line 1816 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		DataMoveMetaData dmv = decodeDataMoveValue(val.get());
															#line 1817 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent( SevWarnAlways, "StartMoveShardsFoundConflictingDataMove", relocationIntervalId) .detail("Range", rangeIntersectKeys) .detail("DataMoveID", dataMoveId.toString()) .detail("ExistingDataMoveID", destId.toString()) .detail("ExistingDataMove", dmv.toString());
															#line 1823 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		cancelDataMove = true;
															#line 1824 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 14234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont13(Optional<Value> && val,int loopDepth) 
	{
															#line 1815 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(val.present());
															#line 1816 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		DataMoveMetaData dmv = decodeDataMoveValue(val.get());
															#line 1817 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent( SevWarnAlways, "StartMoveShardsFoundConflictingDataMove", relocationIntervalId) .detail("Range", rangeIntersectKeys) .detail("DataMoveID", dataMoveId.toString()) .detail("ExistingDataMoveID", destId.toString()) .detail("ExistingDataMove", dmv.toString());
															#line 1823 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		cancelDataMove = true;
															#line 1824 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 14250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont1when3(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont13(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont1when3(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont13(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 11, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 11, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1cont1when3(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 11, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1cont1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 11, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont1loopBody1cont13cont11(int loopDepth) 
	{
															#line 1920 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.set(dataMoveKeyFor(dataMoveId), dataMoveValue(dataMove));
															#line 1922 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_14 = waitForAll(actors);
															#line 1922 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont1loopBody1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont11when1(__when_expr_14.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 15;
															#line 1922 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 14, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 14342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont12(int loopDepth) 
	{
															#line 1905 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.setPhase(DataMoveMetaData::Running);
															#line 1906 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "StartMoveShardsDataMoveComplete", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString()) .detail("BulkLoadTaskID", bulkLoadTaskState.present() ? bulkLoadTaskState.get().getTaskId().toString() : "");
															#line 14353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont13(int loopDepth) 
	{
															#line 1892 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newBulkLoadTaskState.setDataMoveId(dataMoveId);
															#line 1893 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newBulkLoadTaskState.startTime = now();
															#line 1894 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_13 = krmSetRange(&tr, bulkLoadTaskPrefix, newBulkLoadTaskState.getRange(), bulkLoadTaskStateValue(newBulkLoadTaskState));
															#line 1894 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont1loopBody1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont13when1(__when_expr_13.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 14;
															#line 1894 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 13, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 14373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1886 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() == error_code_bulkload_task_outdated)
															#line 14383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1887 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				cancelDataMove = true;
															#line 1888 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(retry(), loopDepth);
															#line 14389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1890 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1cont1loopBody1Catch1(e, loopDepth);
															#line 14393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont14(Void const& _,int loopDepth) 
	{
															#line 1884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newBulkLoadTaskState.phase = BulkLoadPhase::Running;
															#line 14407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont14cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont14(Void && _,int loopDepth) 
	{
															#line 1884 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newBulkLoadTaskState.phase = BulkLoadPhase::Running;
															#line 14416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont14cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont13cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont13cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont13cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont1loopBody1cont13cont14cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont13cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont13cont1(Void const& _,int loopDepth) 
	{
															#line 1898 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent( bulkLoadVerboseEventSev(), "DDBulkLoadTaskSetRunningStateTransaction", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("JobID", newBulkLoadTaskState.getJobId()) .detail("TaskID", newBulkLoadTaskState.getTaskId());
															#line 1903 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.bulkLoadTaskState = newBulkLoadTaskState;
															#line 14515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont13cont1(Void && _,int loopDepth) 
	{
															#line 1898 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent( bulkLoadVerboseEventSev(), "DDBulkLoadTaskSetRunningStateTransaction", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("JobID", newBulkLoadTaskState.getJobId()) .detail("TaskID", newBulkLoadTaskState.getTaskId());
															#line 1903 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.bulkLoadTaskState = newBulkLoadTaskState;
															#line 14526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont13cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont13cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont13cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont13cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont1loopBody1cont13cont11cont1(Void const& _,int loopDepth) 
	{
															#line 1924 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_15 = tr.commit();
															#line 1924 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont1loopBody1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont11cont1when1(__when_expr_15.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 16;
															#line 1924 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 15, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 14617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont1(Void && _,int loopDepth) 
	{
															#line 1924 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_15 = tr.commit();
															#line 1924 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont1loopBody1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont11cont1when1(__when_expr_15.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 16;
															#line 1924 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 15, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 14633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1cont13cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1cont13cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont1loopBody1cont13cont11cont2(Void const& _,int loopDepth) 
	{
															#line 1926 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentKeys.end == keys.end && bulkLoadTaskState.present())
															#line 14717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1927 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			Version commitVersion = tr.getCommittedVersion();
															#line 1928 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(bulkLoadVerboseEventSev(), "DDBulkLoadTaskPersistRunningState", relocationIntervalId) .detail("JobID", bulkLoadTaskState.get().getJobId()) .detail("DataMoveID", dataMoveId.toString()) .detail("TaskID", bulkLoadTaskState.get().getTaskId()) .detail("TaskRange", bulkLoadTaskState.get().getRange()) .detail("CommitVersion", commitVersion);
															#line 14723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1936 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "DataMoveMetaDataCommit", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("DataMoveKey", dataMoveKeyFor(dataMoveId)) .detail("CommitVersion", tr.getCommittedVersion()) .detail("DeltaRange", currentKeys.toString()) .detail("Range", describe(dataMove.ranges)) .detail("DataMove", dataMove.toString()) .detail("BulkLoadTaskID", bulkLoadTaskState.present() ? bulkLoadTaskState.get().getTaskId().toString() : "");
															#line 1946 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove = DataMoveMetaData();
															#line 1947 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentKeys.end == keys.end)
															#line 14731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1949 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (SERVER_KNOBS->AUDIT_DATAMOVE_POST_CHECK)
															#line 14735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_16 = auditLocationMetadataPostCheck(occ, keys, "startMoveShards_postcheck", dataMoveId);
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont1loopBody1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont11cont2when1(__when_expr_16.get(), loopDepth); };
				static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 17;
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 16, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 14746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont13cont11cont5(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont13cont11cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont2(Void && _,int loopDepth) 
	{
															#line 1926 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentKeys.end == keys.end && bulkLoadTaskState.present())
															#line 14765 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1927 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			Version commitVersion = tr.getCommittedVersion();
															#line 1928 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(bulkLoadVerboseEventSev(), "DDBulkLoadTaskPersistRunningState", relocationIntervalId) .detail("JobID", bulkLoadTaskState.get().getJobId()) .detail("DataMoveID", dataMoveId.toString()) .detail("TaskID", bulkLoadTaskState.get().getTaskId()) .detail("TaskRange", bulkLoadTaskState.get().getRange()) .detail("CommitVersion", commitVersion);
															#line 14771 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1936 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "DataMoveMetaDataCommit", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("DataMoveKey", dataMoveKeyFor(dataMoveId)) .detail("CommitVersion", tr.getCommittedVersion()) .detail("DeltaRange", currentKeys.toString()) .detail("Range", describe(dataMove.ranges)) .detail("DataMove", dataMove.toString()) .detail("BulkLoadTaskID", bulkLoadTaskState.present() ? bulkLoadTaskState.get().getTaskId().toString() : "");
															#line 1946 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove = DataMoveMetaData();
															#line 1947 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentKeys.end == keys.end)
															#line 14779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1949 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (SERVER_KNOBS->AUDIT_DATAMOVE_POST_CHECK)
															#line 14783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_16 = auditLocationMetadataPostCheck(occ, keys, "startMoveShards_postcheck", dataMoveId);
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont1loopBody1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont11cont2when1(__when_expr_16.get(), loopDepth); };
				static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 17;
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 16, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 14794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont13cont11cont5(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont13cont11cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1cont13cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1cont13cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont1loopBody1cont13cont11cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont5(int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1loopBody1cont13cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1loopBody1cont13cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont1loopBody1cont13cont11cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont1loopBody1Catch1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 18, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 18, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 18, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 18, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> servers;
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock* startMoveKeysLock;
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID relocationIntervalId;
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::map<UID, StorageServerInterface>* tssMapping;
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CancelConflictingDataMoves cancelConflictingDataMoves;
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Optional<BulkLoadTaskState> bulkLoadTaskState;
															#line 1630 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Future<Void> warningLogger;
															#line 1633 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock::Releaser releaser;
															#line 1634 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool loadedTssMapping;
															#line 1635 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	DataMoveMetaData dataMove;
															#line 1636 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Severity sevDm;
															#line 1645 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRangeRef keys;
															#line 1646 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool cancelDataMove;
															#line 1647 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool runPreCheck;
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key begin;
															#line 1651 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange currentKeys;
															#line 1653 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Void>> actors;
															#line 1654 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 1731 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult old;
															#line 1733 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key endKey;
															#line 1737 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 1742 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int oldIndex;
															#line 1744 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRangeRef rangeIntersectKeys;
															#line 1745 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> src;
															#line 1746 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> dest;
															#line 1747 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID srcId;
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID destId;
															#line 1760 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> owners;
															#line 1875 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	BulkLoadTaskState newBulkLoadTaskState;
															#line 15263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via startMoveShards()
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class StartMoveShardsActor final : public Actor<Void>, public ActorCallback< StartMoveShardsActor, 0, Void >, public ActorCallback< StartMoveShardsActor, 1, Void >, public ActorCallback< StartMoveShardsActor, 2, Optional<Value> >, public ActorCallback< StartMoveShardsActor, 3, Void >, public ActorCallback< StartMoveShardsActor, 4, Void >, public ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >, public ActorCallback< StartMoveShardsActor, 6, RangeResult >, public ActorCallback< StartMoveShardsActor, 7, RangeResult >, public ActorCallback< StartMoveShardsActor, 8, Void >, public ActorCallback< StartMoveShardsActor, 9, Void >, public ActorCallback< StartMoveShardsActor, 10, Void >, public ActorCallback< StartMoveShardsActor, 11, Optional<Value> >, public ActorCallback< StartMoveShardsActor, 12, Void >, public ActorCallback< StartMoveShardsActor, 13, Void >, public ActorCallback< StartMoveShardsActor, 14, Void >, public ActorCallback< StartMoveShardsActor, 15, Void >, public ActorCallback< StartMoveShardsActor, 16, Void >, public ActorCallback< StartMoveShardsActor, 17, Void >, public ActorCallback< StartMoveShardsActor, 18, Void >, public FastAllocated<StartMoveShardsActor>, public StartMoveShardsActorState<StartMoveShardsActor> {
															#line 15268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<StartMoveShardsActor>::operator new;
	using FastAllocated<StartMoveShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13283337257364637184UL, 12750234454998480128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartMoveShardsActor, 0, Void >;
friend struct ActorCallback< StartMoveShardsActor, 1, Void >;
friend struct ActorCallback< StartMoveShardsActor, 2, Optional<Value> >;
friend struct ActorCallback< StartMoveShardsActor, 3, Void >;
friend struct ActorCallback< StartMoveShardsActor, 4, Void >;
friend struct ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >;
friend struct ActorCallback< StartMoveShardsActor, 6, RangeResult >;
friend struct ActorCallback< StartMoveShardsActor, 7, RangeResult >;
friend struct ActorCallback< StartMoveShardsActor, 8, Void >;
friend struct ActorCallback< StartMoveShardsActor, 9, Void >;
friend struct ActorCallback< StartMoveShardsActor, 10, Void >;
friend struct ActorCallback< StartMoveShardsActor, 11, Optional<Value> >;
friend struct ActorCallback< StartMoveShardsActor, 12, Void >;
friend struct ActorCallback< StartMoveShardsActor, 13, Void >;
friend struct ActorCallback< StartMoveShardsActor, 14, Void >;
friend struct ActorCallback< StartMoveShardsActor, 15, Void >;
friend struct ActorCallback< StartMoveShardsActor, 16, Void >;
friend struct ActorCallback< StartMoveShardsActor, 17, Void >;
friend struct ActorCallback< StartMoveShardsActor, 18, Void >;
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	StartMoveShardsActor(Database const& occ,UID const& dataMoveId,std::vector<KeyRange> const& ranges,std::vector<UID> const& servers,MoveKeysLock const& lock,FlowLock* const& startMoveKeysLock,UID const& relocationIntervalId,std::map<UID, StorageServerInterface>* const& tssMapping,const DDEnabledState* const& ddEnabledState,CancelConflictingDataMoves const& cancelConflictingDataMoves,Optional<BulkLoadTaskState> const& bulkLoadTaskState) 
															#line 15303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   StartMoveShardsActorState<StartMoveShardsActor>(occ, dataMoveId, ranges, servers, lock, startMoveKeysLock, relocationIntervalId, tssMapping, ddEnabledState, cancelConflictingDataMoves, bulkLoadTaskState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9292717044462406400UL, 7153354930560426240UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startMoveShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartMoveShardsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartMoveShardsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartMoveShardsActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StartMoveShardsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< StartMoveShardsActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< StartMoveShardsActor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< StartMoveShardsActor, 7, RangeResult >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< StartMoveShardsActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< StartMoveShardsActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< StartMoveShardsActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< StartMoveShardsActor, 11, Optional<Value> >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< StartMoveShardsActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< StartMoveShardsActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< StartMoveShardsActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< StartMoveShardsActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< StartMoveShardsActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< StartMoveShardsActor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< StartMoveShardsActor, 18, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] static Future<Void> startMoveShards( Database const& occ, UID const& dataMoveId, std::vector<KeyRange> const& ranges, std::vector<UID> const& servers, MoveKeysLock const& lock, FlowLock* const& startMoveKeysLock, UID const& relocationIntervalId, std::map<UID, StorageServerInterface>* const& tssMapping, const DDEnabledState* const& ddEnabledState, CancelConflictingDataMoves const& cancelConflictingDataMoves, Optional<BulkLoadTaskState> const& bulkLoadTaskState ) {
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new StartMoveShardsActor(occ, dataMoveId, ranges, servers, lock, startMoveKeysLock, relocationIntervalId, tssMapping, ddEnabledState, cancelConflictingDataMoves, bulkLoadTaskState));
															#line 15353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 1982 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 15358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via checkDataMoveComplete()
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class CheckDataMoveCompleteActor>
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckDataMoveCompleteActorState {
															#line 15364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckDataMoveCompleteActorState(Database const& occ,UID const& dataMoveId,KeyRange const& keys,UID const& relocationIntervalId) 
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId),
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   keys(keys),
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   relocationIntervalId(relocationIntervalId)
															#line 15377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("checkDataMoveComplete", reinterpret_cast<unsigned long>(this));

	}
	~CheckDataMoveCompleteActorState() 
	{
		fdb_probe_actor_destroy("checkDataMoveComplete", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1985 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr = makeReference<ReadYourWritesTransaction>(occ);
															#line 1986 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				begin = keys.begin;
															#line 1987 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				;
															#line 15397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckDataMoveCompleteActorState();
		static_cast<CheckDataMoveCompleteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2044 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<CheckDataMoveCompleteActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataMoveCompleteActorState(); static_cast<CheckDataMoveCompleteActor*>(this)->destroy(); return 0; }
															#line 15426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<CheckDataMoveCompleteActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckDataMoveCompleteActorState();
		static_cast<CheckDataMoveCompleteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2040 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "CheckDataMoveCompleteError", relocationIntervalId).errorUnsuppressed(e);
															#line 2041 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 15441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1987 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!(begin < keys.end))
															#line 15468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1988 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		;
															#line 15474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1990 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->getTransaction().trState->taskID = TaskPriority::MoveKeys;
															#line 1991 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1992 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1996 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			currentKeys = KeyRangeRef(begin, keys.end);
															#line 1998 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(tr, keyServersPrefix, currentKeys, SERVER_KNOBS->MOVE_SHARD_KRM_ROW_LIMIT, SERVER_KNOBS->MOVE_SHARD_KRM_BYTE_LIMIT);
															#line 1998 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state = 1;
															#line 1998 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >*>(static_cast<CheckDataMoveCompleteActor*>(this)));
															#line 15525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2035 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 2035 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 15562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state = 3;
															#line 2035 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckDataMoveCompleteActor, 2, Void >*>(static_cast<CheckDataMoveCompleteActor*>(this)));
															#line 15567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 2005 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		endKey = keyServers.back().key;
															#line 2006 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(currentKeys.begin, endKey);
															#line 2009 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 2009 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state = 2;
															#line 2009 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >*>(static_cast<CheckDataMoveCompleteActor*>(this)));
															#line 15593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& __keyServers,int loopDepth) 
	{
															#line 1998 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keyServers = __keyServers;
															#line 15602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && __keyServers,int loopDepth) 
	{
		keyServers = std::move(__keyServers);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state > 0) static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataMoveCompleteActor*>(this)->ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 2010 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 2012 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < keyServers.size() - 1;++i) {
															#line 2013 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			KeyRangeRef rangeIntersectKeys(keyServers[i].key, keyServers[i + 1].key);
															#line 2014 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 2015 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 2016 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID srcId;
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID destId;
															#line 2018 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, keyServers[i].value, src, dest, srcId, destId);
															#line 2019 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const KeyRange currentRange = KeyRangeRef(keyServers[i].key, keyServers[i + 1].key);
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevVerbose, "CheckDataMoveCompleteShard", relocationIntervalId) .detail("Range", currentRange) .detail("SrcID", srcId) .detail("Src", describe(src)) .detail("DestID", destId) .detail("Dest", describe(dest));
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!dest.empty() || srcId != dataMoveId)
															#line 15701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2028 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1loopBody1loopBody1Catch1(data_move_cancelled(), loopDepth);
															#line 15705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2032 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		begin = endKey;
															#line 15710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 2009 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 15719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state > 0) static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataMoveCompleteActor*>(this)->ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state > 0) static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataMoveCompleteActor*>(this)->ActorCallback< CheckDataMoveCompleteActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataMoveCompleteActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckDataMoveCompleteActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckDataMoveCompleteActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange keys;
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID relocationIntervalId;
															#line 1985 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1986 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key begin;
															#line 1996 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange currentKeys;
															#line 1998 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult keyServers;
															#line 2005 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key endKey;
															#line 2009 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 15914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via checkDataMoveComplete()
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckDataMoveCompleteActor final : public Actor<Void>, public ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >, public ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >, public ActorCallback< CheckDataMoveCompleteActor, 2, Void >, public FastAllocated<CheckDataMoveCompleteActor>, public CheckDataMoveCompleteActorState<CheckDataMoveCompleteActor> {
															#line 15919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<CheckDataMoveCompleteActor>::operator new;
	using FastAllocated<CheckDataMoveCompleteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14767747467471337728UL, 12366156598414981888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >;
friend struct ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >;
friend struct ActorCallback< CheckDataMoveCompleteActor, 2, Void >;
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckDataMoveCompleteActor(Database const& occ,UID const& dataMoveId,KeyRange const& keys,UID const& relocationIntervalId) 
															#line 15938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   CheckDataMoveCompleteActorState<CheckDataMoveCompleteActor>(occ, dataMoveId, keys, relocationIntervalId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(201830314997397504UL, 2479849471865947136UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkDataMoveComplete");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckDataMoveCompleteActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] static Future<Void> checkDataMoveComplete( Database const& occ, UID const& dataMoveId, KeyRange const& keys, UID const& relocationIntervalId ) {
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new CheckDataMoveCompleteActor(occ, dataMoveId, keys, relocationIntervalId));
															#line 15972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 2046 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

// Set keyServers[keys].src = keyServers[keys].dest and keyServers[keys].dest=[], return when successful
// keyServers[k].dest must be the same for all k in keys.
// Set serverKeys[dest][keys] = dataMoveId; serverKeys[src][keys] = false for all src not in dest.
// Clear dataMoves[dataMoveId].
															#line 15981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via finishMoveShards()
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class FinishMoveShardsActor>
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class FinishMoveShardsActorState {
															#line 15987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FinishMoveShardsActorState(Database const& occ,UID const& dataMoveId,std::vector<KeyRange> const& targetRanges,std::vector<UID> const& destinationTeam,MoveKeysLock const& lock,FlowLock* const& finishMoveKeysParallelismLock,bool const& hasRemote,UID const& relocationIntervalId,std::map<UID, StorageServerInterface> const& tssMapping,const DDEnabledState* const& ddEnabledState,Optional<BulkLoadTaskState> const& bulkLoadTaskState) 
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId),
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   targetRanges(targetRanges),
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   destinationTeam(destinationTeam),
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   lock(lock),
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   finishMoveKeysParallelismLock(finishMoveKeysParallelismLock),
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   hasRemote(hasRemote),
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   relocationIntervalId(relocationIntervalId),
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tssMapping(tssMapping),
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   bulkLoadTaskState(bulkLoadTaskState)
															#line 16014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("finishMoveShards", reinterpret_cast<unsigned long>(this));

	}
	~FinishMoveShardsActorState() 
	{
		fdb_probe_actor_destroy("finishMoveShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2063 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(targetRanges.size() == 1);
															#line 2064 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			keys = targetRanges[0];
															#line 2065 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			warningLogger = logWarningAfter("FinishMoveShardsTooLong", 600, destinationTeam);
															#line 2066 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			retries = 0;
															#line 2067 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove = DataMoveMetaData();
															#line 2068 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			cancelDataMove = false;
															#line 2069 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			sevDm = static_cast<Severity>(SERVER_KNOBS->PHYSICAL_SHARD_MOVE_LOG_SEVERITY);
															#line 2071 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = finishMoveKeysParallelismLock->take(TaskPriority::DataDistributionLaunch);
															#line 2071 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 1;
															#line 2071 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 0, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinishMoveShardsActorState();
		static_cast<FinishMoveShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2072 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*finishMoveKeysParallelismLock);
															#line 2073 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		runPreCheck = true;
															#line 2074 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		skipTss = false;
															#line 2075 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ssReadyTime = std::numeric_limits<double>::max();
															#line 2077 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!destinationTeam.empty());
															#line 16081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 2080 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevInfo, "FinishMoveShardsBegin", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("TargetRange", keys);
															#line 2086 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 16087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2072 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*finishMoveKeysParallelismLock);
															#line 2073 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		runPreCheck = true;
															#line 2074 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		skipTss = false;
															#line 2075 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ssReadyTime = std::numeric_limits<double>::max();
															#line 2077 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!destinationTeam.empty());
															#line 16110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 2080 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevInfo, "FinishMoveShardsBegin", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("TargetRange", keys);
															#line 2086 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 16116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2428 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "FinishMoveShardsEnd", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("BulkLoadTaskID", bulkLoadTaskState.present() ? bulkLoadTaskState.get().getTaskId().toString() : "") .detail("DataMove", dataMove.toString());
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<FinishMoveShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishMoveShardsActorState(); static_cast<FinishMoveShardsActor*>(this)->destroy(); return 0; }
															#line 16208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<FinishMoveShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinishMoveShardsActorState();
		static_cast<FinishMoveShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2424 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarn, "FinishMoveShardsError", relocationIntervalId).errorUnsuppressed(e);
															#line 2425 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 16223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2087 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		completeSrc = std::vector<UID>();
															#line 2088 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		destServers = std::vector<UID>();
															#line 2089 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		allServers = std::unordered_set<UID>();
															#line 2090 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		range = KeyRange();
															#line 2091 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr = Transaction(occ);
															#line 16258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 2093 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.trState->taskID = TaskPriority::MoveKeys;
															#line 2094 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2095 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2096 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2098 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_1 = checkMoveKeysLock(&tr, lock, ddEnabledState);
															#line 2098 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 2;
															#line 2098 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 1, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& error,int loopDepth=0) 
	{
		try {
															#line 2397 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarn, "TryFinishMoveShardsError", relocationIntervalId) .errorUnsuppressed(error) .detail("DataMoveID", dataMoveId);
															#line 2400 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (error.code() == error_code_location_metadata_corruption)
															#line 16314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2401 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1Catch1(location_metadata_corruption(), std::max(0, loopDepth - 1));
															#line 16318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 2402 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (error.code() == error_code_retry)
															#line 16324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 2403 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					runPreCheck = false;
															#line 2404 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					++retries;
															#line 2405 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Void> __when_expr_16 = delay(1);
															#line 2405 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont1Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_16.get(), loopDepth); };
					static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 17;
															#line 2405 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 16, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 2406 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (error.code() == error_code_actor_cancelled)
															#line 16346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					{
															#line 2407 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						return a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
															#line 16350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					}
					else
					{
															#line 2409 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						err = error;
															#line 2410 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						runPreCheck = false;
															#line 2411 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						StrictFuture<Void> __when_expr_17 = tr.onError(err);
															#line 2411 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
						if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont1Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when2(__when_expr_17.get(), loopDepth); };
						static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 18;
															#line 2411 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
						__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 17, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
						loopDepth = 0;
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2100 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(dataMoveKeyFor(dataMoveId));
															#line 2100 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 3;
															#line 2100 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2100 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(dataMoveKeyFor(dataMoveId));
															#line 2100 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 3;
															#line 2100 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Optional<Value> const& val,int loopDepth) 
	{
															#line 2101 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (val.present())
															#line 16492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove = decodeDataMoveValue(val.get());
															#line 2103 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "FinishMoveShardsFoundDataMove", relocationIntervalId) .detail("AtVerison", tr.getReadVersion().get()) .detail("DataMoveKey", dataMoveKeyFor(dataMoveId)) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString()) .detail("CancelDataMove", cancelDataMove);
															#line 2109 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (cancelDataMove)
															#line 16500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2110 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				dataMove.setPhase(DataMoveMetaData::Deleting);
															#line 2111 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr.set(dataMoveKeyFor(dataMoveId), dataMoveValue(dataMove));
															#line 2112 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 2112 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
				static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 4;
															#line 2112 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 3, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont5(loopDepth);
			}
		}
		else
		{
															#line 2127 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarn, "FinishMoveShardsDataMoveDeleted", relocationIntervalId) .detail("AtVerison", tr.getReadVersion().get()) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString());
															#line 2131 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_4 = checkDataMoveComplete(occ, dataMoveId, keys, relocationIntervalId);
															#line 2131 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont3when2(__when_expr_4.get(), loopDepth); };
			static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 5;
															#line 2131 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 4, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Optional<Value> && val,int loopDepth) 
	{
															#line 2101 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (val.present())
															#line 16546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove = decodeDataMoveValue(val.get());
															#line 2103 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "FinishMoveShardsFoundDataMove", relocationIntervalId) .detail("AtVerison", tr.getReadVersion().get()) .detail("DataMoveKey", dataMoveKeyFor(dataMoveId)) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString()) .detail("CancelDataMove", cancelDataMove);
															#line 2109 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (cancelDataMove)
															#line 16554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2110 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				dataMove.setPhase(DataMoveMetaData::Deleting);
															#line 2111 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr.set(dataMoveKeyFor(dataMoveId), dataMoveValue(dataMove));
															#line 2112 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 2112 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
				static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 4;
															#line 2112 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 3, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont5(loopDepth);
			}
		}
		else
		{
															#line 2127 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarn, "FinishMoveShardsDataMoveDeleted", relocationIntervalId) .detail("AtVerison", tr.getReadVersion().get()) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString());
															#line 2131 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_4 = checkDataMoveComplete(occ, dataMoveId, keys, relocationIntervalId);
															#line 2131 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont3when2(__when_expr_4.get(), loopDepth); };
			static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 5;
															#line 2131 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 4, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
															#line 2135 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_5 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 2135 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_5.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 6;
															#line 2135 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 5, RangeResult >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
															#line 2115 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		destServers.insert(destServers.end(), dataMove.dest.begin(), dataMove.dest.end());
															#line 2116 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::sort(destServers.begin(), destServers.end());
															#line 2117 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (dataMove.getPhase() == DataMoveMetaData::Deleting)
															#line 16695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2118 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarn, "FinishMoveShardsDataMoveDeleting", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString());
															#line 2121 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1cont1loopBody1Catch1(data_move_cancelled(), loopDepth);
															#line 16701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 2123 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(dataMove.getPhase() == DataMoveMetaData::Running);
															#line 2124 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!dataMove.ranges.empty());
															#line 2125 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		range = dataMove.ranges.front();
															#line 16709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 2113 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(movekeys_conflict(), loopDepth);
															#line 16718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 2113 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(movekeys_conflict(), loopDepth);
															#line 16726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 2132 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<FinishMoveShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishMoveShardsActorState(); static_cast<FinishMoveShardsActor*>(this)->destroy(); return 0; }
															#line 16809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<FinishMoveShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinishMoveShardsActorState();
		static_cast<FinishMoveShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 2132 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<FinishMoveShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishMoveShardsActorState(); static_cast<FinishMoveShardsActor*>(this)->destroy(); return 0; }
															#line 16821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<FinishMoveShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinishMoveShardsActorState();
		static_cast<FinishMoveShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont11(int loopDepth) 
	{
															#line 2136 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 2138 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = krmGetRanges(&tr, keyServersPrefix, range, SERVER_KNOBS->MOVE_SHARD_KRM_ROW_LIMIT, SERVER_KNOBS->MOVE_SHARD_KRM_BYTE_LIMIT);
															#line 2138 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont11when1(__when_expr_6.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 7;
															#line 2138 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 6, RangeResult >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 2135 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 16926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 5, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 5, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 5, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 5, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont11cont1(int loopDepth) 
	{
															#line 2143 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!keyServers.empty());
															#line 2144 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		range = KeyRangeRef(range.begin, keyServers.back().key);
															#line 2145 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!range.empty());
															#line 2147 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentIndex = 0;
															#line 2148 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		;
															#line 17013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11when1(RangeResult const& __keyServers,int loopDepth) 
	{
															#line 2138 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keyServers = __keyServers;
															#line 17022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11when1(RangeResult && __keyServers,int loopDepth) 
	{
		keyServers = std::move(__keyServers);
		loopDepth = a_body1cont1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1cont11cont2(int loopDepth) 
	{
															#line 2204 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverReady = std::vector<Future<Void>>();
															#line 2205 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tssReady = std::vector<Future<Void>>();
															#line 2206 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tssReadyInterfs = std::vector<StorageServerInterface>();
															#line 2207 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newDestinations = std::vector<UID>();
															#line 2208 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::set<UID> completeSrcSet(completeSrc.begin(), completeSrc.end());
															#line 2209 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const UID& id : destServers ) {
															#line 2210 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!hasRemote || !completeSrcSet.contains(id))
															#line 17113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2211 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				newDestinations.push_back(id);
															#line 17117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2215 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		storageServerInterfaces = std::vector<StorageServerInterface>();
															#line 2216 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Optional<Value>>> serverListEntries;
															#line 2217 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListEntries.reserve(newDestinations.size());
															#line 2218 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const UID& id : newDestinations ) {
															#line 2219 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			serverListEntries.push_back(tr.get(serverListKeyFor(id)));
															#line 17130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 2221 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_8 = getAll(serverListEntries);
															#line 2221 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 9;
															#line 2221 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 8, std::vector<Optional<Value>> >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 17141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont11cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1loopBody1(int loopDepth) 
	{
															#line 2148 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!(currentIndex < keyServers.size() - 1))
															#line 17157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1cont1loopBody1cont11cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2149 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		src = std::vector<UID>();
															#line 2150 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dest = std::vector<UID>();
															#line 2151 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		srcId = UID();
															#line 2152 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		destId = UID();
															#line 2153 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, keyServers[currentIndex].value, src, dest, srcId, destId);
															#line 2154 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		const KeyRange currentRange = KeyRangeRef(keyServers[currentIndex].key, keyServers[currentIndex + 1].key);
															#line 2156 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "FinishMoveShardsProcessingShard", relocationIntervalId) .detail("Range", currentRange) .detail("SrcID", srcId) .detail("Src", describe(src)) .detail("DestID", destId) .detail("Dest", describe(dest)) .detail("DataMove", dataMove.toString());
															#line 2163 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		allServers.insert(src.begin(), src.end());
															#line 2164 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		allServers.insert(dest.begin(), dest.end());
															#line 2165 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (destId != dataMoveId)
															#line 17181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2166 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarnAlways, "FinishMoveShardsInconsistentIDs", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("ExistingShardID", destId) .detail("DataMove", dataMove.toString());
															#line 2170 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			cancelDataMove = true;
															#line 2171 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 17189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (SERVER_KNOBS->AUDIT_DATAMOVE_PRE_CHECK && runPreCheck)
															#line 17193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2176 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> servers(src.size() + dest.size());
															#line 2177 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), servers.begin());
															#line 2178 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_7 = auditLocationMetadataPreCheck( occ, &tr, currentRange, servers, "finishMoveShards_precheck", dataMoveId);
															#line 2178 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont11cont1loopBody1when1(__when_expr_7.get(), loopDepth); };
			static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 8;
															#line 2178 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 7, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 17208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont11cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont11cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1loopBody1cont1(int loopDepth) 
	{
															#line 2182 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::sort(dest.begin(), dest.end());
															#line 2183 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(std::equal(destServers.begin(), destServers.end(), dest.begin(), dest.end()));
															#line 2185 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::set<UID> srcSet;
															#line 2186 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < src.size();s++) {
															#line 2187 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			srcSet.insert(src[s]);
															#line 17243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 2190 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentIndex == 0)
															#line 17247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2191 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			completeSrc = src;
															#line 17251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		else
		{
															#line 2193 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int i = 0;i < completeSrc.size();i++) {
															#line 2194 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!srcSet.contains(completeSrc[i]))
															#line 17259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 2195 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					swapAndPop(&completeSrc, i--);
															#line 17263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
		}
															#line 2148 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		++currentIndex;
															#line 17269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont11cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont11cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont11cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1cont11cont3(int loopDepth) 
	{
															#line 2223 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser.release();
															#line 2225 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 2227 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!serverListValues[s].present())
															#line 17369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2228 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(retry(), loopDepth);
															#line 17373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 2230 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			auto si = decodeServerListValue(serverListValues[s].get());
															#line 2231 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(si.id() == newDestinations[s]);
															#line 2232 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			storageServerInterfaces.push_back(si);
															#line 17381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 2238 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverReady.reserve(storageServerInterfaces.size());
															#line 2239 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < storageServerInterfaces.size();s++) {
															#line 2240 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			serverReady.push_back(waitForShardReady( storageServerInterfaces[s], range, tr.getReadVersion().get(), GetShardStateRequest::READABLE));
															#line 2243 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (skipTss)
															#line 17391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
				continue;
			}
															#line 2246 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			auto tssPair = tssMapping.find(storageServerInterfaces[s].id());
															#line 2248 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (tssPair != tssMapping.end())
															#line 17399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2249 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssReadyInterfs.push_back(tssPair->second);
															#line 2250 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssReady.push_back(waitForShardReady( tssPair->second, range, tr.getReadVersion().get(), GetShardStateRequest::READABLE));
															#line 17405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2255 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "FinishMoveShardsWaitingServers", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("NewDestinations", describe(newDestinations)) .detail("DataMove", dataMove.toString());
															#line 2262 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_9 = timeout(waitForAll(serverReady) && waitForAllReady(tssReady), SERVER_KNOBS->SERVER_READY_QUORUM_TIMEOUT, Void(), TaskPriority::MoveKeys);
															#line 2262 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont3when1(__when_expr_9.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 10;
															#line 2262 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 9, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 17419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont2when1(std::vector<Optional<Value>> const& __serverListValues,int loopDepth) 
	{
															#line 2221 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListValues = __serverListValues;
															#line 17428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont2when1(std::vector<Optional<Value>> && __serverListValues,int loopDepth) 
	{
		serverListValues = std::move(__serverListValues);
		loopDepth = a_body1cont1loopBody1cont11cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 8, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 8, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 8, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 8, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1cont11cont7(Void const& _,int loopDepth) 
	{
															#line 2267 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		readyServers = std::vector<UID>();
															#line 2268 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverReady.size();++s) {
															#line 2269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (serverReady[s].isReady() && !serverReady[s].isError())
															#line 17511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2270 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				readyServers.push_back(storageServerInterfaces[s].uniqueID);
															#line 17515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2273 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int tssCount = 0;
															#line 2274 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < tssReady.size();s++) {
															#line 2275 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (tssReady[s].isReady() && !tssReady[s].isError())
															#line 17524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2276 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssCount += 1;
															#line 17528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2280 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readyServers.size() == serverReady.size() && !skipTss)
															#line 17533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2281 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ssReadyTime = std::min(now(), ssReadyTime);
															#line 2282 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (tssCount < tssReady.size() && now() - ssReadyTime >= SERVER_KNOBS->DD_WAIT_TSS_DATA_MOVE_DELAY)
															#line 17539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2284 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				skipTss = true;
															#line 2285 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevWarnAlways, "FinishMoveShardsSkipTSS") .detail("DataMoveID", dataMoveId) .detail("ReadyServers", describe(readyServers)) .detail("NewDestinations", describe(newDestinations)) .detail("ReadyTSS", tssCount) .detail("TSSInfo", describe(tssReadyInterfs)) .detail("SSReadyTime", ssReadyTime);
															#line 17545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "FinishMoveShardsWaitedServers", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("ReadyServers", describe(readyServers)) .detail("NewDestinations", describe(newDestinations)) .detail("ReadyTSS", tssCount) .detail("DataMove", dataMove.toString());
															#line 2302 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readyServers.size() == newDestinations.size())
															#line 17552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2304 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<Future<Void>> actors;
															#line 2305 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(krmSetRangeCoalescing( &tr, keyServersPrefix, range, allKeys, keyServersValue(destServers, {}, dataMoveId, UID())));
															#line 2308 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const UID& ssId : allServers ) {
															#line 2309 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				const bool destHasServer = std::find(destServers.begin(), destServers.end(), ssId) != destServers.end();
															#line 2311 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.push_back( krmSetRangeCoalescing(&tr, serverKeysPrefixFor(ssId), range, allKeys, destHasServer ? serverKeysValue(dataMoveId) : serverKeysFalse));
															#line 2317 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(sevDm, "FinishMoveShardsSetServerKeyRange", relocationIntervalId) .detail("StorageServerID", ssId) .detail("KeyRange", range) .detail("ShardID", destHasServer ? dataMoveId : UID()) .detail("DataMove", dataMove.toString());
															#line 17566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_10 = waitForAll(actors);
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17572 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont7when1(__when_expr_10.get(), loopDepth); };
			static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 11;
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 10, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 17577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.reset();
															#line 17584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont11cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont7(Void && _,int loopDepth) 
	{
															#line 2267 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		readyServers = std::vector<UID>();
															#line 2268 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverReady.size();++s) {
															#line 2269 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (serverReady[s].isReady() && !serverReady[s].isError())
															#line 17598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2270 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				readyServers.push_back(storageServerInterfaces[s].uniqueID);
															#line 17602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2273 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int tssCount = 0;
															#line 2274 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < tssReady.size();s++) {
															#line 2275 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (tssReady[s].isReady() && !tssReady[s].isError())
															#line 17611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2276 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssCount += 1;
															#line 17615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2280 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readyServers.size() == serverReady.size() && !skipTss)
															#line 17620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2281 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ssReadyTime = std::min(now(), ssReadyTime);
															#line 2282 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (tssCount < tssReady.size() && now() - ssReadyTime >= SERVER_KNOBS->DD_WAIT_TSS_DATA_MOVE_DELAY)
															#line 17626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2284 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				skipTss = true;
															#line 2285 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevWarnAlways, "FinishMoveShardsSkipTSS") .detail("DataMoveID", dataMoveId) .detail("ReadyServers", describe(readyServers)) .detail("NewDestinations", describe(newDestinations)) .detail("ReadyTSS", tssCount) .detail("TSSInfo", describe(tssReadyInterfs)) .detail("SSReadyTime", ssReadyTime);
															#line 17632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "FinishMoveShardsWaitedServers", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("ReadyServers", describe(readyServers)) .detail("NewDestinations", describe(newDestinations)) .detail("ReadyTSS", tssCount) .detail("DataMove", dataMove.toString());
															#line 2302 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readyServers.size() == newDestinations.size())
															#line 17639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2304 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<Future<Void>> actors;
															#line 2305 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(krmSetRangeCoalescing( &tr, keyServersPrefix, range, allKeys, keyServersValue(destServers, {}, dataMoveId, UID())));
															#line 2308 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const UID& ssId : allServers ) {
															#line 2309 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				const bool destHasServer = std::find(destServers.begin(), destServers.end(), ssId) != destServers.end();
															#line 2311 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.push_back( krmSetRangeCoalescing(&tr, serverKeysPrefixFor(ssId), range, allKeys, destHasServer ? serverKeysValue(dataMoveId) : serverKeysFalse));
															#line 2317 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(sevDm, "FinishMoveShardsSetServerKeyRange", relocationIntervalId) .detail("StorageServerID", ssId) .detail("KeyRange", range) .detail("ShardID", destHasServer ? dataMoveId : UID()) .detail("DataMove", dataMove.toString());
															#line 17653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_10 = waitForAll(actors);
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont7when1(__when_expr_10.get(), loopDepth); };
			static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 11;
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 10, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 17664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2394 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.reset();
															#line 17671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont11cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont11cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont11cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont1loopBody1cont11cont13(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20(Void const& _,int loopDepth) 
	{
															#line 2326 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (range.end == dataMove.ranges.front().end)
															#line 17762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2327 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (bulkLoadTaskState.present())
															#line 17766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2328 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				newBulkLoadTaskState = BulkLoadTaskState();
															#line 17770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				try {
															#line 2330 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Void> __when_expr_11 = store(newBulkLoadTaskState, getBulkLoadTask(&tr, bulkLoadTaskState.get().getRange(), bulkLoadTaskState.get().getTaskId(), { BulkLoadPhase::Running, BulkLoadPhase::Complete }));
															#line 2330 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont11cont20Catch1(actor_cancelled(), loopDepth);
															#line 17776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1cont11cont20Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont20when1(__when_expr_11.get(), loopDepth); };
					static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 12;
															#line 2330 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 11, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 17781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1cont1loopBody1cont11cont20Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1loopBody1cont11cont20Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont11cont20cont2(loopDepth);
			}
		}
		else
		{
															#line 2361 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!bulkLoadTaskState.present())
															#line 17799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevInfo, "FinishMoveShardsPartialComplete", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("CurrentRange", range) .detail("NewDataMoveMetaData", dataMove.toString()) .detail("DataMove", dataMove.toString());
															#line 2368 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				dataMove.ranges.front() = KeyRangeRef(range.end, dataMove.ranges.front().end);
															#line 2369 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr.set(dataMoveKeyFor(dataMoveId), dataMoveValue(dataMove));
															#line 17807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
			loopDepth = a_body1cont1loopBody1cont11cont20cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20(Void && _,int loopDepth) 
	{
															#line 2326 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (range.end == dataMove.ranges.front().end)
															#line 17818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2327 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (bulkLoadTaskState.present())
															#line 17822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2328 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				newBulkLoadTaskState = BulkLoadTaskState();
															#line 17826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				try {
															#line 2330 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Void> __when_expr_11 = store(newBulkLoadTaskState, getBulkLoadTask(&tr, bulkLoadTaskState.get().getRange(), bulkLoadTaskState.get().getTaskId(), { BulkLoadPhase::Running, BulkLoadPhase::Complete }));
															#line 2330 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont11cont20Catch1(actor_cancelled(), loopDepth);
															#line 17832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1cont11cont20Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont20when1(__when_expr_11.get(), loopDepth); };
					static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 12;
															#line 2330 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 11, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 17837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1cont1loopBody1cont11cont20Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1loopBody1cont11cont20Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont11cont20cont2(loopDepth);
			}
		}
		else
		{
															#line 2361 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!bulkLoadTaskState.present())
															#line 17855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevInfo, "FinishMoveShardsPartialComplete", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("CurrentRange", range) .detail("NewDataMoveMetaData", dataMove.toString()) .detail("DataMove", dataMove.toString());
															#line 2368 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				dataMove.ranges.front() = KeyRangeRef(range.end, dataMove.ranges.front().end);
															#line 2369 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr.set(dataMoveKeyFor(dataMoveId), dataMoveValue(dataMove));
															#line 17863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
			loopDepth = a_body1cont1loopBody1cont11cont20cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont20(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont20(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont11cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont11cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont1loopBody1cont11cont20cont1(int loopDepth) 
	{
															#line 2372 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_14 = tr.commit();
															#line 2372 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont1loopBody1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont20cont1when1(__when_expr_14.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 15;
															#line 2372 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 14, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 17956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont2(int loopDepth) 
	{
															#line 2357 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_13 = deleteCheckpoints(&tr, dataMove.checkpoints, dataMoveId);
															#line 2357 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont1loopBody1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont20cont2when1(__when_expr_13.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 14;
															#line 2357 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 13, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 17972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont3(int loopDepth) 
	{
															#line 2343 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(newBulkLoadTaskState.getDataMoveId().present() && newBulkLoadTaskState.getDataMoveId().get() == dataMoveId);
															#line 2345 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newBulkLoadTaskState.completeTime = now();
															#line 2346 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_12 = krmSetRange(&tr, bulkLoadTaskPrefix, newBulkLoadTaskState.getRange(), bulkLoadTaskStateValue(newBulkLoadTaskState));
															#line 2346 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1loopBody1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont20cont3when1(__when_expr_12.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 13;
															#line 2346 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 12, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 17992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2337 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() == error_code_bulkload_task_outdated)
															#line 18002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2338 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				cancelDataMove = true;
															#line 2339 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(retry(), loopDepth);
															#line 18008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 2341 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1cont1loopBody1Catch1(e, loopDepth);
															#line 18012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont4(Void const& _,int loopDepth) 
	{
															#line 2335 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newBulkLoadTaskState.phase = BulkLoadPhase::Complete;
															#line 18026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11cont20cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont4(Void && _,int loopDepth) 
	{
															#line 2335 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newBulkLoadTaskState.phase = BulkLoadPhase::Complete;
															#line 18035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11cont20cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont20cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont20cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont11cont20when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont11cont20Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont11cont20Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont11cont20when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont11cont20Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont11cont20Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont11cont20Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont11cont20Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont11cont20Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont1loopBody1cont11cont20cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont11cont20cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont7(Void const& _,int loopDepth) 
	{
															#line 2350 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent( bulkLoadVerboseEventSev(), "DDBulkLoadTaskSetCompleteTransaction", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("JobID", newBulkLoadTaskState.getJobId()) .detail("TaskID", newBulkLoadTaskState.getTaskId());
															#line 2355 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.bulkLoadTaskState = newBulkLoadTaskState;
															#line 18134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11cont20cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont7(Void && _,int loopDepth) 
	{
															#line 2350 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent( bulkLoadVerboseEventSev(), "DDBulkLoadTaskSetCompleteTransaction", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("JobID", newBulkLoadTaskState.getJobId()) .detail("TaskID", newBulkLoadTaskState.getTaskId());
															#line 2355 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.bulkLoadTaskState = newBulkLoadTaskState;
															#line 18145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11cont20cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont20cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont20cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont11cont20cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont11cont20cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont1loopBody1cont11cont20cont9(Void const& _,int loopDepth) 
	{
															#line 2358 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.clear(dataMoveKeyFor(dataMoveId));
															#line 2359 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "FinishMoveShardsDeleteMetaData", relocationIntervalId) .detail("DataMove", dataMove.toString());
															#line 18231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11cont20cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont9(Void && _,int loopDepth) 
	{
															#line 2358 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.clear(dataMoveKeyFor(dataMoveId));
															#line 2359 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "FinishMoveShardsDeleteMetaData", relocationIntervalId) .detail("DataMove", dataMove.toString());
															#line 18242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11cont20cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont20cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont20cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont11cont20cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont11cont20cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont1loopBody1cont11cont20cont13(Void const& _,int loopDepth) 
	{
															#line 2374 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (range.end == dataMove.ranges.front().end && bulkLoadTaskState.present())
															#line 18326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2375 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			Version commitVersion = tr.getCommittedVersion();
															#line 2376 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent( bulkLoadVerboseEventSev(), "DDBulkLoadTaskPersistCompleteState", relocationIntervalId) .detail("JobID", bulkLoadTaskState.get().getJobId()) .detail("DataMoveID", dataMoveId) .detail("TaskID", bulkLoadTaskState.get().getTaskId()) .detail("TaskRange", bulkLoadTaskState.get().getRange()) .detail("CommitVersion", commitVersion);
															#line 18332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 2385 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (range.end == dataMove.ranges.front().end)
															#line 18336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2387 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (SERVER_KNOBS->AUDIT_DATAMOVE_POST_CHECK)
															#line 18340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2388 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_15 = auditLocationMetadataPostCheck( occ, dataMove.ranges.front(), "finishMoveShards_postcheck", relocationIntervalId);
															#line 2388 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 18346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont1loopBody1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont20cont13when1(__when_expr_15.get(), loopDepth); };
				static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 16;
															#line 2388 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 15, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 18351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont11cont20cont13cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont11cont20cont13cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont13(Void && _,int loopDepth) 
	{
															#line 2374 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (range.end == dataMove.ranges.front().end && bulkLoadTaskState.present())
															#line 18370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2375 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			Version commitVersion = tr.getCommittedVersion();
															#line 2376 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent( bulkLoadVerboseEventSev(), "DDBulkLoadTaskPersistCompleteState", relocationIntervalId) .detail("JobID", bulkLoadTaskState.get().getJobId()) .detail("DataMoveID", dataMoveId) .detail("TaskID", bulkLoadTaskState.get().getTaskId()) .detail("TaskRange", bulkLoadTaskState.get().getRange()) .detail("CommitVersion", commitVersion);
															#line 18376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 2385 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (range.end == dataMove.ranges.front().end)
															#line 18380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2387 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (SERVER_KNOBS->AUDIT_DATAMOVE_POST_CHECK)
															#line 18384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2388 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_15 = auditLocationMetadataPostCheck( occ, dataMove.ranges.front(), "finishMoveShards_postcheck", relocationIntervalId);
															#line 2388 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 18390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont1loopBody1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont20cont13when1(__when_expr_15.get(), loopDepth); };
				static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 16;
															#line 2388 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 15, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 18395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont11cont20cont13cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont11cont20cont13cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont20cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont20cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1cont11cont20cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1cont11cont20cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont1loopBody1cont11cont20cont13cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont13cont3(int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont13cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont20cont13cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont13cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont20cont13cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont20cont13cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont20cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont20cont13cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1cont11cont20cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1cont11cont20cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont1loopBody1cont11cont13cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont1loopBody1Catch1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont7(Void const& _,int loopDepth) 
	{
															#line 2412 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retries++;
															#line 2413 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (retries % 10 == 0)
															#line 18708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2414 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(retries == 20 ? SevWarnAlways : SevWarn, "RelocateShard_FinishMoveShardsRetrying", relocationIntervalId) .error(err) .detail("DataMoveID", dataMoveId);
															#line 18712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont7(Void && _,int loopDepth) 
	{
															#line 2412 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retries++;
															#line 2413 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (retries % 10 == 0)
															#line 18724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2414 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(retries == 20 ? SevWarnAlways : SevWarn, "RelocateShard_FinishMoveShardsRetrying", relocationIntervalId) .error(err) .detail("DataMoveID", dataMoveId);
															#line 18728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<KeyRange> targetRanges;
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> destinationTeam;
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock* finishMoveKeysParallelismLock;
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool hasRemote;
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID relocationIntervalId;
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Optional<BulkLoadTaskState> bulkLoadTaskState;
															#line 2064 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange keys;
															#line 2065 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Future<Void> warningLogger;
															#line 2066 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int retries;
															#line 2067 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	DataMoveMetaData dataMove;
															#line 2068 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool cancelDataMove;
															#line 2069 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Severity sevDm;
															#line 2072 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock::Releaser releaser;
															#line 2073 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool runPreCheck;
															#line 2074 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool skipTss;
															#line 2075 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	double ssReadyTime;
															#line 2087 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> completeSrc;
															#line 2088 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> destServers;
															#line 2089 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::unordered_set<UID> allServers;
															#line 2090 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange range;
															#line 2091 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 2135 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 2138 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult keyServers;
															#line 2147 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int currentIndex;
															#line 2149 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> src;
															#line 2150 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> dest;
															#line 2151 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID srcId;
															#line 2152 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID destId;
															#line 2204 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Void>> serverReady;
															#line 2205 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Void>> tssReady;
															#line 2206 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<StorageServerInterface> tssReadyInterfs;
															#line 2207 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> newDestinations;
															#line 2215 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<StorageServerInterface> storageServerInterfaces;
															#line 2221 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Optional<Value>> serverListValues;
															#line 2267 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> readyServers;
															#line 2328 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	BulkLoadTaskState newBulkLoadTaskState;
															#line 2409 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Error err;
															#line 18906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via finishMoveShards()
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class FinishMoveShardsActor final : public Actor<Void>, public ActorCallback< FinishMoveShardsActor, 0, Void >, public ActorCallback< FinishMoveShardsActor, 1, Void >, public ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >, public ActorCallback< FinishMoveShardsActor, 3, Void >, public ActorCallback< FinishMoveShardsActor, 4, Void >, public ActorCallback< FinishMoveShardsActor, 5, RangeResult >, public ActorCallback< FinishMoveShardsActor, 6, RangeResult >, public ActorCallback< FinishMoveShardsActor, 7, Void >, public ActorCallback< FinishMoveShardsActor, 8, std::vector<Optional<Value>> >, public ActorCallback< FinishMoveShardsActor, 9, Void >, public ActorCallback< FinishMoveShardsActor, 10, Void >, public ActorCallback< FinishMoveShardsActor, 11, Void >, public ActorCallback< FinishMoveShardsActor, 12, Void >, public ActorCallback< FinishMoveShardsActor, 13, Void >, public ActorCallback< FinishMoveShardsActor, 14, Void >, public ActorCallback< FinishMoveShardsActor, 15, Void >, public ActorCallback< FinishMoveShardsActor, 16, Void >, public ActorCallback< FinishMoveShardsActor, 17, Void >, public FastAllocated<FinishMoveShardsActor>, public FinishMoveShardsActorState<FinishMoveShardsActor> {
															#line 18911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<FinishMoveShardsActor>::operator new;
	using FastAllocated<FinishMoveShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6129040941470853376UL, 9605260743595500288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FinishMoveShardsActor, 0, Void >;
friend struct ActorCallback< FinishMoveShardsActor, 1, Void >;
friend struct ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >;
friend struct ActorCallback< FinishMoveShardsActor, 3, Void >;
friend struct ActorCallback< FinishMoveShardsActor, 4, Void >;
friend struct ActorCallback< FinishMoveShardsActor, 5, RangeResult >;
friend struct ActorCallback< FinishMoveShardsActor, 6, RangeResult >;
friend struct ActorCallback< FinishMoveShardsActor, 7, Void >;
friend struct ActorCallback< FinishMoveShardsActor, 8, std::vector<Optional<Value>> >;
friend struct ActorCallback< FinishMoveShardsActor, 9, Void >;
friend struct ActorCallback< FinishMoveShardsActor, 10, Void >;
friend struct ActorCallback< FinishMoveShardsActor, 11, Void >;
friend struct ActorCallback< FinishMoveShardsActor, 12, Void >;
friend struct ActorCallback< FinishMoveShardsActor, 13, Void >;
friend struct ActorCallback< FinishMoveShardsActor, 14, Void >;
friend struct ActorCallback< FinishMoveShardsActor, 15, Void >;
friend struct ActorCallback< FinishMoveShardsActor, 16, Void >;
friend struct ActorCallback< FinishMoveShardsActor, 17, Void >;
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FinishMoveShardsActor(Database const& occ,UID const& dataMoveId,std::vector<KeyRange> const& targetRanges,std::vector<UID> const& destinationTeam,MoveKeysLock const& lock,FlowLock* const& finishMoveKeysParallelismLock,bool const& hasRemote,UID const& relocationIntervalId,std::map<UID, StorageServerInterface> const& tssMapping,const DDEnabledState* const& ddEnabledState,Optional<BulkLoadTaskState> const& bulkLoadTaskState) 
															#line 18945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   FinishMoveShardsActorState<FinishMoveShardsActor>(occ, dataMoveId, targetRanges, destinationTeam, lock, finishMoveKeysParallelismLock, hasRemote, relocationIntervalId, tssMapping, ddEnabledState, bulkLoadTaskState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6125936273252418048UL, 100860356525693184UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finishMoveShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 5, RangeResult >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 8, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< FinishMoveShardsActor, 17, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] static Future<Void> finishMoveShards( Database const& occ, UID const& dataMoveId, std::vector<KeyRange> const& targetRanges, std::vector<UID> const& destinationTeam, MoveKeysLock const& lock, FlowLock* const& finishMoveKeysParallelismLock, bool const& hasRemote, UID const& relocationIntervalId, std::map<UID, StorageServerInterface> const& tssMapping, const DDEnabledState* const& ddEnabledState, Optional<BulkLoadTaskState> const& bulkLoadTaskState ) {
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new FinishMoveShardsActor(occ, dataMoveId, targetRanges, destinationTeam, lock, finishMoveKeysParallelismLock, hasRemote, relocationIntervalId, tssMapping, ddEnabledState, bulkLoadTaskState));
															#line 18994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
}

#line 2434 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"

}; // anonymous namespace

															#line 19001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
namespace {
// This generated class is to be used only via addStorageServer()
															#line 2437 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class AddStorageServerActor>
															#line 2437 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AddStorageServerActorState {
															#line 19008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 2437 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AddStorageServerActorState(Database const& cx,StorageServerInterface const& server) 
															#line 2437 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 2437 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : cx(cx),
															#line 2437 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   server(server),
															#line 2438 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(cx)),
															#line 2439 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tssMapDB(KeyBackedMap<UID, UID>(tssMappingKeys.begin)),
															#line 2440 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   metadataMap(serverMetadataKeys.begin, IncludeVersion()),
															#line 2443 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   maxSkipTags(1)
															#line 19025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("addStorageServer", reinterpret_cast<unsigned long>(this));

	}
	~AddStorageServerActorState() 
	{
		fdb_probe_actor_destroy("addStorageServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2445 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 19040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddStorageServerActorState();
		static_cast<AddStorageServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2447 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2448 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2451 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			fTagLocalities = tr->getRange(tagLocalityListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 2452 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			fv = tr->get(serverListKeyFor(server.id()));
															#line 2454 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			fExclProc = tr->get( StringRef(encodeExcludedServersKey(AddressExclusion(server.address().ip, server.address().port))));
															#line 2456 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			fExclIP = tr->get(StringRef(encodeExcludedServersKey(AddressExclusion(server.address().ip))));
															#line 2458 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			fFailProc = tr->get( StringRef(encodeFailedServersKey(AddressExclusion(server.address().ip, server.address().port))));
															#line 2460 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			fFailIP = tr->get(StringRef(encodeFailedServersKey(AddressExclusion(server.address().ip))));
															#line 2463 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			fExclProc2 = server.secondaryAddress().present() ? tr->get(StringRef(encodeExcludedServersKey( AddressExclusion(server.secondaryAddress().get().ip, server.secondaryAddress().get().port)))) : Future<Optional<Value>>(Optional<Value>());
															#line 2468 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			fExclIP2 = server.secondaryAddress().present() ? tr->get(StringRef(encodeExcludedServersKey(AddressExclusion(server.secondaryAddress().get().ip)))) : Future<Optional<Value>>(Optional<Value>());
															#line 2472 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			fFailProc2 = server.secondaryAddress().present() ? tr->get(StringRef(encodeFailedServersKey( AddressExclusion(server.secondaryAddress().get().ip, server.secondaryAddress().get().port)))) : Future<Optional<Value>>(Optional<Value>());
															#line 2477 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			fFailIP2 = server.secondaryAddress().present() ? tr->get(StringRef(encodeFailedServersKey(AddressExclusion(server.secondaryAddress().get().ip)))) : Future<Optional<Value>>(Optional<Value>());
															#line 2482 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			localityExclusions = std::vector<Future<Optional<Value>>>();
															#line 2483 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::map<std::string, std::string> localityData = server.locality.getAllData();
															#line 2484 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const auto& l : localityData ) {
															#line 2485 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				localityExclusions.push_back(tr->get(StringRef(encodeExcludedLocalityKey( LocalityData::ExcludeLocalityPrefix.toString() + l.first + ":" + l.second))));
															#line 19101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 2489 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			fTags = tr->getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY, Snapshot::True);
															#line 2490 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			fHistoryTags = tr->getRange(serverTagHistoryKeys, CLIENT_KNOBS->TOO_MANY, Snapshot::True);
															#line 2493 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(fTagLocalities) && success(fv) && success(fTags) && success(fHistoryTags) && success(fExclProc) && success(fExclIP) && success(fFailProc) && success(fFailIP) && success(fExclProc2) && success(fExclIP2) && success(fFailProc2) && success(fFailIP2);
															#line 2493 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<AddStorageServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 19111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddStorageServerActor*>(this)->actor_wait_state = 1;
															#line 2493 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddStorageServerActor, 0, Void >*>(static_cast<AddStorageServerActor*>(this)));
															#line 19116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2610 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() == error_code_commit_unknown_result)
															#line 19138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2611 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch1(recruitment_failed(), std::max(0, loopDepth - 1));
															#line 19142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 2614 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() == error_code_not_committed)
															#line 19146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2615 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				maxSkipTags = SERVER_KNOBS->MAX_SKIP_TAGS;
															#line 19150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 2618 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 2618 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<AddStorageServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 19156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<AddStorageServerActor*>(this)->actor_wait_state = 4;
															#line 2618 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AddStorageServerActor, 3, Void >*>(static_cast<AddStorageServerActor*>(this)));
															#line 19161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2497 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		RangeForbody1loopBody1cont2Iterator0 = std::begin(localityExclusions);
															#line 19176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2497 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		RangeForbody1loopBody1cont2Iterator0 = std::begin(localityExclusions);
															#line 19185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddStorageServerActor*>(this)->actor_wait_state > 0) static_cast<AddStorageServerActor*>(this)->actor_wait_state = 0;
		static_cast<AddStorageServerActor*>(this)->ActorCallback< AddStorageServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddStorageServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addStorageServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addStorageServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddStorageServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addStorageServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addStorageServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddStorageServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addStorageServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addStorageServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 2502 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (fExclProc.get().present() || fExclIP.get().present() || fFailProc.get().present() || fFailIP.get().present() || fExclProc2.get().present() || fExclIP2.get().present() || fFailProc2.get().present() || fFailIP2.get().present())
															#line 19269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2505 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1loopBody1Catch1(recruitment_failed(), loopDepth);
															#line 19273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 2508 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& exclusion : localityExclusions ) {
															#line 2509 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (exclusion.get().present())
															#line 19279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2510 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1loopBody1Catch1(recruitment_failed(), loopDepth);
															#line 19283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2514 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (fTagLocalities.get().more || fTags.get().more || fHistoryTags.get().more)
															#line 19288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2515 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(false);
															#line 19292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 2517 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tag = Tag();
															#line 2518 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (server.isTss())
															#line 19298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2519 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool foundTag = false;
															#line 2520 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& it : fTags.get() ) {
															#line 2521 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				UID key = decodeServerTagKey(it.key);
															#line 2522 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (key == server.tssPairID.get())
															#line 19308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 2523 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					tag = decodeServerTagValue(it.value);
															#line 2524 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					foundTag = true;
															#line 19314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					break;
				}
			}
															#line 2528 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!foundTag)
															#line 19320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2529 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1loopBody1Catch1(recruitment_failed(), loopDepth);
															#line 19324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 2532 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tssMapDB.set(tr, server.tssPairID.get(), server.id());
															#line 19328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		}
		else
		{
															#line 2535 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			int8_t maxTagLocality = 0;
															#line 2536 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			locality = -1;
															#line 2537 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& kv : fTagLocalities.get() ) {
															#line 2538 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				int8_t loc = decodeTagLocalityListValue(kv.value);
															#line 2539 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (decodeTagLocalityListKey(kv.key) == server.locality.dcId())
															#line 19342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 2540 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					locality = loc;
															#line 19346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					break;
				}
															#line 2543 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				maxTagLocality = std::max(maxTagLocality, loc);
															#line 19351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 2546 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (locality == -1)
															#line 19355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2547 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				locality = maxTagLocality + 1;
															#line 2548 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (locality < 0)
															#line 19361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 2549 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					return a_body1loopBody1Catch1(recruitment_failed(), loopDepth);
															#line 19365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
															#line 2551 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr->set(tagLocalityListKeyFor(server.locality.dcId()), tagLocalityListValue(locality));
															#line 19369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 2554 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			int skipTags = deterministicRandom()->randomInt(0, maxSkipTags);
															#line 2556 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tagId = 0;
															#line 2557 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<uint16_t> usedTags;
															#line 2558 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& it : fTags.get() ) {
															#line 2559 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				Tag t = decodeServerTagValue(it.value);
															#line 2560 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (t.locality == locality)
															#line 19383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 2561 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					usedTags.push_back(t.id);
															#line 19387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
															#line 2564 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& it : fHistoryTags.get() ) {
															#line 2565 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				Tag t = decodeServerTagValue(it.value);
															#line 2566 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (t.locality == locality)
															#line 19396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 2567 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					usedTags.push_back(t.id);
															#line 19400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
															#line 2570 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::sort(usedTags.begin(), usedTags.end());
															#line 2572 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			int usedIdx = 0;
															#line 2573 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(;usedTags.size() > 0 && tagId <= usedTags.end()[-1];tagId++) {
															#line 2574 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (tagId < usedTags[usedIdx])
															#line 19411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 2575 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (skipTags == 0)
															#line 19415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
					{
						break;
					}
															#line 2577 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					skipTags--;
															#line 19421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
				else
				{
															#line 2579 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
					usedIdx++;
															#line 19427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
															#line 2582 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tagId += skipTags;
															#line 2584 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tag = Tag(locality, tagId);
															#line 2586 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(serverTagKeyFor(server.id()), serverTagValue(tag));
															#line 2587 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			KeyRange conflictRange = singleKeyRange(serverTagConflictKeyFor(tag));
															#line 2588 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 2589 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->addWriteConflictRange(conflictRange);
															#line 2591 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (SERVER_KNOBS->TSS_HACK_IDENTITY_MAPPING)
															#line 19444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2593 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevError, "TSSIdentityMappingEnabled").log();
															#line 2594 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssMapDB.set(tr, server.id(), server.id());
															#line 19450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2598 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StorageMetadataType metadata(StorageMetadataType::currentTime());
															#line 2599 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		metadataMap.set(tr, server.id(), metadata);
															#line 2600 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr->set(serverMetadataChangeKey, deterministicRandom()->randomUniqueID().toString());
															#line 2602 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr->set(serverListKeyFor(server.id()), serverListValue(server));
															#line 2603 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 2603 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<AddStorageServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 19465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<AddStorageServerActor*>(this)->actor_wait_state = 3;
															#line 2603 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AddStorageServerActor, 2, Void >*>(static_cast<AddStorageServerActor*>(this)));
															#line 19470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 2497 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!(RangeForbody1loopBody1cont2Iterator0 != std::end(localityExclusions)))
															#line 19486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2497 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		const auto& exclusion = *RangeForbody1loopBody1cont2Iterator0;
															#line 19492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2498 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(exclusion);
															#line 2498 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<AddStorageServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 19498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<AddStorageServerActor*>(this)->actor_wait_state = 2;
															#line 2498 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddStorageServerActor, 1, Void >*>(static_cast<AddStorageServerActor*>(this)));
															#line 19503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
															#line 2497 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		++RangeForbody1loopBody1cont2Iterator0;
															#line 19526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddStorageServerActor*>(this)->actor_wait_state > 0) static_cast<AddStorageServerActor*>(this)->actor_wait_state = 0;
		static_cast<AddStorageServerActor*>(this)->ActorCallback< AddStorageServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddStorageServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addStorageServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addStorageServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddStorageServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addStorageServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addStorageServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddStorageServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addStorageServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addStorageServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 2604 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent("AddedStorageServerSystemKey") .detail("ServerID", server.id()) .detail("CommitVersion", tr->getCommittedVersion());
															#line 2608 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<AddStorageServerActor*>(this)->SAV<std::pair<Version, Tag>>::futures) { (void)(std::make_pair(tr->getCommittedVersion(), tag)); this->~AddStorageServerActorState(); static_cast<AddStorageServerActor*>(this)->destroy(); return 0; }
															#line 19624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<AddStorageServerActor*>(this)->SAV< std::pair<Version, Tag> >::value()) std::pair<Version, Tag>(std::make_pair(tr->getCommittedVersion(), tag));
		this->~AddStorageServerActorState();
		static_cast<AddStorageServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 2604 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent("AddedStorageServerSystemKey") .detail("ServerID", server.id()) .detail("CommitVersion", tr->getCommittedVersion());
															#line 2608 "/Users/ec2-user/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<AddStorageServerActor*>(this)->SAV<std::pair<Version, Tag>>::futures) { (void)(std::make_pair(tr->getCommittedVersion(), tag)); this->~AddStorageServerActorState(); static_cast<AddStorageServerActor*>(this)->destroy(); return 0; }
															#line 19638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<AddStorageServerActor*>(this)->SAV< std::pair<Version, Tag> >::value()) std::pair<Version, Tag>(std::make_pair(tr->getCommittedVersion(), tag));
		this->~AddStorageServerActorState();
		static_cast<AddStorageServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
