#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
/*
 * GrvProxyServer.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ClientKnobs.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/Notified.h"
#include "fdbclient/TransactionLineage.h"
#include "fdbclient/Tuple.h"
#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/GrvProxyInterface.h"
#include "fdbclient/VersionVector.h"
#include "fdbserver/GrvProxyTagThrottler.h"
#include "fdbserver/GrvTransactionRateInfo.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/LogSystemDiskQueueAdapter.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbrpc/sim_validation.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "flow/actorcompiler.h" // This must be the last #include.
#include "flow/genericactors.actor.h"

struct GrvProxyStats {
	CounterCollection cc;
	Counter txnRequestIn, txnRequestOut, txnRequestErrors;
	Counter txnStartIn, txnStartOut, txnStartBatch;
	Counter txnSystemPriorityStartIn, txnSystemPriorityStartOut;
	Counter txnBatchPriorityStartIn, txnBatchPriorityStartOut;
	Counter txnDefaultPriorityStartIn, txnDefaultPriorityStartOut;
	Counter txnTagThrottlerIn, txnTagThrottlerOut;
	Counter txnThrottled;
	Counter updatesFromRatekeeper, leaseTimeouts;
	int systemGRVQueueSize, defaultGRVQueueSize, batchGRVQueueSize;
	int tagThrottlerGRVQueueSize;
	double transactionRateAllowed, batchTransactionRateAllowed;
	double transactionLimit, batchTransactionLimit;
	// how much of the GRV requests queue was processed in one attempt to hand out read version.
	double percentageOfDefaultGRVQueueProcessed;
	double percentageOfBatchGRVQueueProcessed;

	bool lastBatchQueueThrottled;
	bool lastDefaultQueueThrottled;
	double batchThrottleStartTime;
	double defaultThrottleStartTime;

	LatencySample defaultTxnGRVTimeInQueue;
	LatencySample batchTxnGRVTimeInQueue;

	// These latency bands and samples ignore latency injected by the GrvProxyTagThrottler
	LatencyBands grvLatencyBands;
	LatencySample grvLatencySample; // GRV latency metric sample of default priority
	LatencySample grvBatchLatencySample; // GRV latency metric sample of batched priority

	Future<Void> logger;

	int recentRequests;
	Deque<int> requestBuckets;
	double lastBucketBegin;
	double bucketInterval;
	Reference<Histogram> grvConfirmEpochLiveDist;
	Reference<Histogram> grvGetCommittedVersionRpcDist;

	void updateRequestBuckets() {
		while (now() - lastBucketBegin > bucketInterval) {
			lastBucketBegin += bucketInterval;
			recentRequests -= requestBuckets.front();
			requestBuckets.pop_front();
			requestBuckets.push_back(0);
		}
	}

	void addRequest(int transactionCount) {
		updateRequestBuckets();
		recentRequests += transactionCount;
		requestBuckets.back() += transactionCount;
	}

	int getRecentRequests() {
		updateRequestBuckets();
		return recentRequests /
		       (FLOW_KNOBS->BASIC_LOAD_BALANCE_UPDATE_RATE - (lastBucketBegin + bucketInterval - now()));
	}

	void update(GrvProxyTagThrottler::ReleaseTransactionsResult const& releaseStats) {
		auto const totalReleasedRequests =
		    releaseStats.batchPriorityRequestsReleased + releaseStats.defaultPriorityRequestsReleased;
		auto const totalReleasedTransactions =
		    releaseStats.batchPriorityTransactionsReleased + releaseStats.defaultPriorityTransactionsReleased;

		txnRequestIn += totalReleasedRequests;
		txnStartIn += totalReleasedTransactions;
		txnBatchPriorityStartIn += releaseStats.batchPriorityTransactionsReleased;
		txnDefaultPriorityStartIn += releaseStats.defaultPriorityTransactionsReleased;
		batchGRVQueueSize += releaseStats.batchPriorityRequestsReleased;
		defaultGRVQueueSize += releaseStats.defaultPriorityRequestsReleased;
		txnRequestErrors += releaseStats.rejectedRequests;
		txnTagThrottlerOut += totalReleasedTransactions;
		tagThrottlerGRVQueueSize -= totalReleasedRequests;
	}

	// Current stats maintained for a given grv proxy server
	explicit GrvProxyStats(UID id)
	  : cc("GrvProxyStats", id.toString()),

	    txnRequestIn("TxnRequestIn", cc), txnRequestOut("TxnRequestOut", cc), txnRequestErrors("TxnRequestErrors", cc),
	    txnStartIn("TxnStartIn", cc), txnStartOut("TxnStartOut", cc), txnStartBatch("TxnStartBatch", cc),
	    txnSystemPriorityStartIn("TxnSystemPriorityStartIn", cc),
	    txnSystemPriorityStartOut("TxnSystemPriorityStartOut", cc),
	    txnBatchPriorityStartIn("TxnBatchPriorityStartIn", cc),
	    txnBatchPriorityStartOut("TxnBatchPriorityStartOut", cc),
	    txnDefaultPriorityStartIn("TxnDefaultPriorityStartIn", cc),
	    txnDefaultPriorityStartOut("TxnDefaultPriorityStartOut", cc), txnTagThrottlerIn("TxnTagThrottlerIn", cc),
	    txnTagThrottlerOut("TxnTagThrottlerOut", cc), txnThrottled("TxnThrottled", cc),
	    updatesFromRatekeeper("UpdatesFromRatekeeper", cc), leaseTimeouts("LeaseTimeouts", cc), systemGRVQueueSize(0),
	    defaultGRVQueueSize(0), batchGRVQueueSize(0), tagThrottlerGRVQueueSize(0), transactionRateAllowed(0),
	    batchTransactionRateAllowed(0), transactionLimit(0), batchTransactionLimit(0),
	    percentageOfDefaultGRVQueueProcessed(0), percentageOfBatchGRVQueueProcessed(0), lastBatchQueueThrottled(false),
	    lastDefaultQueueThrottled(false), batchThrottleStartTime(0.0), defaultThrottleStartTime(0.0),
	    defaultTxnGRVTimeInQueue("DefaultTxnGRVTimeInQueue",
	                             id,
	                             SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
	                             SERVER_KNOBS->LATENCY_SKETCH_ACCURACY),
	    batchTxnGRVTimeInQueue("BatchTxnGRVTimeInQueue",
	                           id,
	                           SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
	                           SERVER_KNOBS->LATENCY_SKETCH_ACCURACY),
	    grvLatencyBands("GRVLatencyBands", id, SERVER_KNOBS->STORAGE_LOGGING_DELAY),
	    grvLatencySample("GRVLatencyMetrics",
	                     id,
	                     SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
	                     SERVER_KNOBS->LATENCY_SKETCH_ACCURACY),
	    grvBatchLatencySample("GRVBatchLatencyMetrics",
	                          id,
	                          SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
	                          SERVER_KNOBS->LATENCY_SKETCH_ACCURACY),
	    recentRequests(0), lastBucketBegin(now()),
	    bucketInterval(FLOW_KNOBS->BASIC_LOAD_BALANCE_UPDATE_RATE / FLOW_KNOBS->BASIC_LOAD_BALANCE_BUCKETS),
	    grvConfirmEpochLiveDist(
	        Histogram::getHistogram("GrvProxy"_sr, "GrvConfirmEpochLive"_sr, Histogram::Unit::milliseconds)),
	    grvGetCommittedVersionRpcDist(
	        Histogram::getHistogram("GrvProxy"_sr, "GrvGetCommittedVersionRpc"_sr, Histogram::Unit::milliseconds)) {
		// The rate at which the limit(budget) is allowed to grow.
		specialCounter(cc, "SystemGRVQueueSize", [this]() { return this->systemGRVQueueSize; });
		specialCounter(cc, "DefaultGRVQueueSize", [this]() { return this->defaultGRVQueueSize; });
		specialCounter(cc, "BatchGRVQueueSize", [this]() { return this->batchGRVQueueSize; });
		specialCounter(cc, "TagThrottlerGRVQueueSize", [this]() { return this->tagThrottlerGRVQueueSize; });
		specialCounter(
		    cc, "SystemAndDefaultTxnRateAllowed", [this]() { return int64_t(this->transactionRateAllowed); });
		specialCounter(
		    cc, "BatchTransactionRateAllowed", [this]() { return int64_t(this->batchTransactionRateAllowed); });
		specialCounter(cc, "SystemAndDefaultTxnLimit", [this]() { return int64_t(this->transactionLimit); });
		specialCounter(cc, "BatchTransactionLimit", [this]() { return int64_t(this->batchTransactionLimit); });
		specialCounter(cc, "PercentageOfDefaultGRVQueueProcessed", [this]() {
			return int64_t(100 * this->percentageOfDefaultGRVQueueProcessed);
		});
		specialCounter(cc, "PercentageOfBatchGRVQueueProcessed", [this]() {
			return int64_t(100 * this->percentageOfBatchGRVQueueProcessed);
		});

		logger = cc.traceCounters("GrvProxyMetrics", id, SERVER_KNOBS->WORKER_LOGGING_INTERVAL, "GrvProxyMetrics");
		for (int i = 0; i < FLOW_KNOBS->BASIC_LOAD_BALANCE_BUCKETS; i++) {
			requestBuckets.push_back(0);
		}
	}
};

struct GrvProxyData {
	GrvProxyInterface proxy;
	UID dbgid;

	GrvProxyStats stats;
	MasterInterface master;
	PublicRequestStream<GetReadVersionRequest> getConsistentReadVersion;
	Reference<ILogSystem> logSystem;

	Database cx;
	Reference<AsyncVar<ServerDBInfo> const> db;

	Optional<LatencyBandConfig> latencyBandConfig;
	double lastStartCommit;
	double lastCommitLatency;
	std::unique_ptr<LatencySample> versionVectorSizeOnGRVReply;
	int updateCommitRequests;
	NotifiedDouble lastCommitTime;

	Version version;
	Version minKnownCommittedVersion; // we should ask master for this version.

	GrvProxyTagThrottler tagThrottler;

	// Cache of the latest commit versions of storage servers.
	VersionVector ssVersionVectorCache;

	void updateLatencyBandConfig(Optional<LatencyBandConfig> newLatencyBandConfig) {
		if (newLatencyBandConfig.present() != latencyBandConfig.present() ||
		    (newLatencyBandConfig.present() &&
		     newLatencyBandConfig.get().grvConfig != latencyBandConfig.get().grvConfig)) {
			TraceEvent("LatencyBandGrvUpdatingConfig").detail("Present", newLatencyBandConfig.present());
			stats.grvLatencyBands.clearBands();
			if (newLatencyBandConfig.present()) {
				for (auto band : newLatencyBandConfig.get().grvConfig.bands) {
					stats.grvLatencyBands.addThreshold(band);
					tagThrottler.addLatencyBandThreshold(band);
				}
			}
		}

		latencyBandConfig = newLatencyBandConfig;
	}

	GrvProxyData(UID dbgid,
	             MasterInterface master,
	             PublicRequestStream<GetReadVersionRequest> getConsistentReadVersion,
	             Reference<AsyncVar<ServerDBInfo> const> db)
	  : dbgid(dbgid), stats(dbgid), master(master), getConsistentReadVersion(getConsistentReadVersion),
	    cx(openDBOnServer(db, TaskPriority::DefaultEndpoint, LockAware::True)), db(db), lastStartCommit(0),
	    lastCommitLatency(SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION), updateCommitRequests(0), lastCommitTime(0),
	    version(0), minKnownCommittedVersion(invalidVersion),
	    tagThrottler(CLIENT_KNOBS->PROXY_MAX_TAG_THROTTLE_DURATION) {
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR) {
			versionVectorSizeOnGRVReply =
			    std::make_unique<LatencySample>("VersionVectorSizeOnGRVReply",
			                                    dbgid,
			                                    SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
			                                    SERVER_KNOBS->LATENCY_SKETCH_ACCURACY);
		}
	}
};

															#line 252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via healthMetricsRequestServer()
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class HealthMetricsRequestServerActor>
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class HealthMetricsRequestServerActorState {
															#line 259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	HealthMetricsRequestServerActorState(GrvProxyInterface const& grvProxy,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply) 
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : grvProxy(grvProxy),
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   healthMetricsReply(healthMetricsReply),
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   detailedHealthMetricsReply(detailedHealthMetricsReply)
															#line 270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this));

	}
	~HealthMetricsRequestServerActorState() 
	{
		fdb_probe_actor_destroy("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HealthMetricsRequestServerActorState();
		static_cast<HealthMetricsRequestServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		FutureStream<GetHealthMetricsRequest> __when_expr_0 = grvProxy.getHealthMetrics.getFuture();
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<HealthMetricsRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<HealthMetricsRequestServerActor*>(this)->actor_wait_state = 1;
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*>(static_cast<HealthMetricsRequestServerActor*>(this)));
															#line 322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetHealthMetricsRequest const& req,int loopDepth) 
	{
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (req.detailed)
															#line 337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			req.reply.send(*detailedHealthMetricsReply);
															#line 341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			req.reply.send(*healthMetricsReply);
															#line 347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetHealthMetricsRequest && req,int loopDepth) 
	{
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (req.detailed)
															#line 357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			req.reply.send(*detailedHealthMetricsReply);
															#line 361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			req.reply.send(*healthMetricsReply);
															#line 367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HealthMetricsRequestServerActor*>(this)->actor_wait_state > 0) static_cast<HealthMetricsRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMetricsRequestServerActor*>(this)->ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*,GetHealthMetricsRequest const& value) 
	{
		fdb_probe_actor_enter("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*,GetHealthMetricsRequest && value) 
	{
		fdb_probe_actor_enter("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface grvProxy;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* healthMetricsReply;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* detailedHealthMetricsReply;
															#line 442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via healthMetricsRequestServer()
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class HealthMetricsRequestServerActor final : public Actor<Void>, public ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >, public FastAllocated<HealthMetricsRequestServerActor>, public HealthMetricsRequestServerActorState<HealthMetricsRequestServerActor> {
															#line 447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<HealthMetricsRequestServerActor>::operator new;
	using FastAllocated<HealthMetricsRequestServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1437005913898334976UL, 9685340650771797504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	HealthMetricsRequestServerActor(GrvProxyInterface const& grvProxy,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply) 
															#line 464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   HealthMetricsRequestServerActorState<HealthMetricsRequestServerActor>(grvProxy, healthMetricsReply, detailedHealthMetricsReply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15006378439154462208UL, 8394861280111908096UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("healthMetricsRequestServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> healthMetricsRequestServer( GrvProxyInterface const& grvProxy, GetHealthMetricsReply* const& healthMetricsReply, GetHealthMetricsReply* const& detailedHealthMetricsReply ) {
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new HealthMetricsRequestServerActor(grvProxy, healthMetricsReply, detailedHealthMetricsReply));
															#line 497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Older FDB versions used different keys for client profiling data. This
// function performs a one-time migration of data in these keys to the new
// global configuration key space.
															#line 505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via globalConfigMigrate()
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GlobalConfigMigrateActor>
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigMigrateActorState {
															#line 512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigMigrateActorState(GrvProxyData* const& grvProxyData) 
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : grvProxyData(grvProxyData),
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   migratedKey("\xff\x02/fdbClientInfo/migrated/"_sr),
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(grvProxyData->cx))
															#line 523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("globalConfigMigrate", reinterpret_cast<unsigned long>(this));

	}
	~GlobalConfigMigrateActorState() 
	{
		fdb_probe_actor_destroy("globalConfigMigrate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				;
															#line 539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GlobalConfigMigrateActorState();
		static_cast<GlobalConfigMigrateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GlobalConfigMigrateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GlobalConfigMigrateActorState(); static_cast<GlobalConfigMigrateActor*>(this)->destroy(); return 0; }
															#line 568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GlobalConfigMigrateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GlobalConfigMigrateActorState();
		static_cast<GlobalConfigMigrateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "GlobalConfigMigrationError").error(e);
															#line 581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		try {
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(migratedKey);
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 1;
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent(SevInfo, "GlobalConfigRetryableMigrationError").errorUnsuppressed(e).suppressFor(1.0);
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 5;
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 4, Void >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (migrated.present())
															#line 679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr->get(Key("\xff\x02/fdbClientInfo/client_txn_sample_rate/"_sr));
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 2;
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __migrated,int loopDepth) 
	{
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		migrated = __migrated;
															#line 701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __migrated,int loopDepth) 
	{
		migrated = std::move(__migrated);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr->get(Key("\xff\x02/fdbClientInfo/client_txn_size_limit/"_sr));
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 3;
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& __sampleRate,int loopDepth) 
	{
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		sampleRate = __sampleRate;
															#line 796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && __sampleRate,int loopDepth) 
	{
		sampleRate = std::move(__sampleRate);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		tr->set(migratedKey.contents(), "1"_sr);
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (sampleRate.present())
															#line 879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			const double sampleRateDbl = BinaryReader::fromStringRef<double>(sampleRate.get().contents(), Unversioned());
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Tuple rate = Tuple::makeTuple(sampleRateDbl);
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			tr->set(GlobalConfig::prefixedKey(fdbClientInfoTxnSampleRate), rate.pack());
															#line 887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (sizeLimit.present())
															#line 891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			const int64_t sizeLimitInt = BinaryReader::fromStringRef<int64_t>(sizeLimit.get().contents(), Unversioned());
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Tuple size = Tuple::makeTuple(sizeLimitInt);
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			tr->set(GlobalConfig::prefixedKey(fdbClientInfoTxnSizeLimit), size.pack());
															#line 899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 4;
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 3, Void >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Optional<Value> const& __sizeLimit,int loopDepth) 
	{
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		sizeLimit = __sizeLimit;
															#line 919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Optional<Value> && __sizeLimit,int loopDepth) 
	{
		sizeLimit = std::move(__sizeLimit);
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Key migratedKey;
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<Value> migrated;
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<Value> sampleRate;
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<Value> sizeLimit;
															#line 1193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via globalConfigMigrate()
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigMigrateActor final : public Actor<Void>, public ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >, public ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >, public ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >, public ActorCallback< GlobalConfigMigrateActor, 3, Void >, public ActorCallback< GlobalConfigMigrateActor, 4, Void >, public FastAllocated<GlobalConfigMigrateActor>, public GlobalConfigMigrateActorState<GlobalConfigMigrateActor> {
															#line 1198 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GlobalConfigMigrateActor>::operator new;
	using FastAllocated<GlobalConfigMigrateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14765531529710091008UL, 11366916293124518144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >;
friend struct ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >;
friend struct ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >;
friend struct ActorCallback< GlobalConfigMigrateActor, 3, Void >;
friend struct ActorCallback< GlobalConfigMigrateActor, 4, Void >;
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigMigrateActor(GrvProxyData* const& grvProxyData) 
															#line 1219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GlobalConfigMigrateActorState<GlobalConfigMigrateActor>(grvProxyData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(154511452753742592UL, 13598310903932054784UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("globalConfigMigrate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> globalConfigMigrate( GrvProxyData* const& grvProxyData ) {
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GlobalConfigMigrateActor(grvProxyData));
															#line 1256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 318 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Periodically refresh local copy of global configuration.
															#line 1262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via globalConfigRefresh()
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GlobalConfigRefreshActor>
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigRefreshActorState {
															#line 1269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigRefreshActorState(GrvProxyData* const& grvProxyData,Version* const& cachedVersion,RangeResult* const& cachedData) 
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : grvProxyData(grvProxyData),
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   cachedVersion(cachedVersion),
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   cachedData(cachedData),
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(grvProxyData->cx))
															#line 1282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("globalConfigRefresh", reinterpret_cast<unsigned long>(this));

	}
	~GlobalConfigRefreshActorState() 
	{
		fdb_probe_actor_destroy("globalConfigRefresh", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 1297 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GlobalConfigRefreshActorState();
		static_cast<GlobalConfigRefreshActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			globalConfigVersionFuture = tr->get(globalConfigVersionKey);
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			tmpCachedDataFuture = tr->getRange(globalConfigDataKeys, CLIENT_KNOBS->TOO_MANY);
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = globalConfigVersionFuture;
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 1;
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*>(static_cast<GlobalConfigRefreshActor*>(this)));
															#line 1341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 3;
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRefreshActor, 2, Void >*>(static_cast<GlobalConfigRefreshActor*>(this)));
															#line 1370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tmpCachedDataFuture;
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 2;
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*>(static_cast<GlobalConfigRefreshActor*>(this)));
															#line 1392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __globalConfigVersion,int loopDepth) 
	{
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		globalConfigVersion = __globalConfigVersion;
															#line 1401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __globalConfigVersion,int loopDepth) 
	{
		globalConfigVersion = std::move(__globalConfigVersion);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRefreshActor*>(this)->ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& tmpCachedData,int loopDepth) 
	{
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*cachedData = tmpCachedData;
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (globalConfigVersion.present())
															#line 1482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Version parsedVersion;
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			memcpy(&parsedVersion, globalConfigVersion.get().begin(), sizeof(Version));
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			*cachedVersion = bigEndian64(parsedVersion);
															#line 1490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GlobalConfigRefreshActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GlobalConfigRefreshActorState(); static_cast<GlobalConfigRefreshActor*>(this)->destroy(); return 0; }
															#line 1494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GlobalConfigRefreshActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GlobalConfigRefreshActorState();
		static_cast<GlobalConfigRefreshActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && tmpCachedData,int loopDepth) 
	{
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*cachedData = tmpCachedData;
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (globalConfigVersion.present())
															#line 1508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Version parsedVersion;
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			memcpy(&parsedVersion, globalConfigVersion.get().begin(), sizeof(Version));
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			*cachedVersion = bigEndian64(parsedVersion);
															#line 1516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GlobalConfigRefreshActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GlobalConfigRefreshActorState(); static_cast<GlobalConfigRefreshActor*>(this)->destroy(); return 0; }
															#line 1520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GlobalConfigRefreshActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GlobalConfigRefreshActorState();
		static_cast<GlobalConfigRefreshActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& tmpCachedData,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(tmpCachedData, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && tmpCachedData,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(tmpCachedData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRefreshActor*>(this)->ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRefreshActor*>(this)->ActorCallback< GlobalConfigRefreshActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GlobalConfigRefreshActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Version* cachedVersion;
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	RangeResult* cachedData;
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Optional<Value>> globalConfigVersionFuture;
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<RangeResult> tmpCachedDataFuture;
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<Value> globalConfigVersion;
															#line 1704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via globalConfigRefresh()
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigRefreshActor final : public Actor<Void>, public ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >, public ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >, public ActorCallback< GlobalConfigRefreshActor, 2, Void >, public FastAllocated<GlobalConfigRefreshActor>, public GlobalConfigRefreshActorState<GlobalConfigRefreshActor> {
															#line 1709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GlobalConfigRefreshActor>::operator new;
	using FastAllocated<GlobalConfigRefreshActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9954786865673496576UL, 2880703884710795008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >;
friend struct ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >;
friend struct ActorCallback< GlobalConfigRefreshActor, 2, Void >;
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigRefreshActor(GrvProxyData* const& grvProxyData,Version* const& cachedVersion,RangeResult* const& cachedData) 
															#line 1728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GlobalConfigRefreshActorState<GlobalConfigRefreshActor>(grvProxyData, cachedVersion, cachedData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10827479308140659200UL, 8791014497271066624UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("globalConfigRefresh");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GlobalConfigRefreshActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> globalConfigRefresh( GrvProxyData* const& grvProxyData, Version* const& cachedVersion, RangeResult* const& cachedData ) {
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GlobalConfigRefreshActor(grvProxyData, cachedVersion, cachedData));
															#line 1763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 341 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Handle common GlobalConfig transactions on the server side, because not all
// clients are allowed to read system keys. Eventually, this could become its
// own role.
															#line 1771 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via globalConfigRequestServer()
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GlobalConfigRequestServerActor>
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigRequestServerActorState {
															#line 1778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigRequestServerActorState(GrvProxyData* const& grvProxyData,GrvProxyInterface const& grvProxy) 
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : grvProxyData(grvProxyData),
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxy(grvProxy),
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   actors(false),
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   refreshFuture(),
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   cachedVersion(0),
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   cachedData()
															#line 1795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("globalConfigRequestServer", reinterpret_cast<unsigned long>(this));

	}
	~GlobalConfigRequestServerActorState() 
	{
		fdb_probe_actor_destroy("globalConfigRequestServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refreshFuture = timeout(globalConfigRefresh(grvProxyData, &cachedVersion, &cachedData), SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_TIMEOUT, Void()) && delay(SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_INTERVAL);
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(timeout(globalConfigMigrate(grvProxyData), SERVER_KNOBS->GLOBAL_CONFIG_MIGRATE_TIMEOUT));
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state = 1;
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRequestServerActor, 0, Void >*>(static_cast<GlobalConfigRequestServerActor*>(this)));
															#line 1819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GlobalConfigRequestServerActorState();
		static_cast<GlobalConfigRequestServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		;
															#line 1842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		;
															#line 1851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRequestServerActor*>(this)->ActorCallback< GlobalConfigRequestServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GlobalConfigRequestServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		FutureStream<GlobalConfigRefreshRequest> __when_expr_1 = grvProxy.refreshGlobalConfig.getFuture();
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = refreshFuture;
															#line 1948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = actors.getResult();
															#line 1952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_3.get(), loopDepth); };
		static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state = 2;
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*>(static_cast<GlobalConfigRequestServerActor*>(this)));
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRequestServerActor, 2, Void >*>(static_cast<GlobalConfigRequestServerActor*>(this)));
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRequestServerActor, 3, Void >*>(static_cast<GlobalConfigRequestServerActor*>(this)));
															#line 1961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GlobalConfigRefreshRequest const& refresh,int loopDepth) 
	{
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (refresh.lastKnown <= cachedVersion)
															#line 1976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refresh.reply.send(GlobalConfigRefreshReply{ cachedData.arena(), cachedVersion, cachedData });
															#line 1980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refresh.reply.sendError(future_version());
															#line 1986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GlobalConfigRefreshRequest && refresh,int loopDepth) 
	{
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (refresh.lastKnown <= cachedVersion)
															#line 1996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refresh.reply.send(GlobalConfigRefreshReply{ cachedData.arena(), cachedVersion, cachedData });
															#line 2000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refresh.reply.sendError(future_version());
															#line 2006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		refreshFuture = timeout(globalConfigRefresh(grvProxyData, &cachedVersion, &cachedData), SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_TIMEOUT, Void()) && delay(SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_INTERVAL);
															#line 2016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		refreshFuture = timeout(globalConfigRefresh(grvProxyData, &cachedVersion, &cachedData), SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_TIMEOUT, Void()) && delay(SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_INTERVAL);
															#line 2025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(false);
															#line 2034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(false);
															#line 2043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRequestServerActor*>(this)->ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >::remove();
		static_cast<GlobalConfigRequestServerActor*>(this)->ActorCallback< GlobalConfigRequestServerActor, 2, Void >::remove();
		static_cast<GlobalConfigRequestServerActor*>(this)->ActorCallback< GlobalConfigRequestServerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*,GlobalConfigRefreshRequest const& value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*,GlobalConfigRefreshRequest && value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GlobalConfigRequestServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GlobalConfigRequestServerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface grvProxy;
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	ActorCollection actors;
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> refreshFuture;
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Version cachedVersion;
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	RangeResult cachedData;
															#line 2239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via globalConfigRequestServer()
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigRequestServerActor final : public Actor<Void>, public ActorCallback< GlobalConfigRequestServerActor, 0, Void >, public ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >, public ActorCallback< GlobalConfigRequestServerActor, 2, Void >, public ActorCallback< GlobalConfigRequestServerActor, 3, Void >, public FastAllocated<GlobalConfigRequestServerActor>, public GlobalConfigRequestServerActorState<GlobalConfigRequestServerActor> {
															#line 2244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GlobalConfigRequestServerActor>::operator new;
	using FastAllocated<GlobalConfigRequestServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8394424975981324288UL, 13933642361285330176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GlobalConfigRequestServerActor, 0, Void >;
friend struct ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >;
friend struct ActorCallback< GlobalConfigRequestServerActor, 2, Void >;
friend struct ActorCallback< GlobalConfigRequestServerActor, 3, Void >;
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigRequestServerActor(GrvProxyData* const& grvProxyData,GrvProxyInterface const& grvProxy) 
															#line 2264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GlobalConfigRequestServerActorState<GlobalConfigRequestServerActor>(grvProxyData, grvProxy),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15730633037479306240UL, 7934117556835500544UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("globalConfigRequestServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GlobalConfigRequestServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> globalConfigRequestServer( GrvProxyData* const& grvProxyData, GrvProxyInterface const& grvProxy ) {
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GlobalConfigRequestServerActor(grvProxyData, grvProxy));
															#line 2298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 387 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Get transaction rate info from RateKeeper.
															#line 2304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via getRate()
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GetRateActor>
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GetRateActorState {
															#line 2311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetRateActorState(UID const& myID,Reference<AsyncVar<ServerDBInfo> const> const& db,int64_t* const& inTransactionCount,int64_t* const& inBatchTransactionCount,GrvTransactionRateInfo* const& transactionRateInfo,GrvTransactionRateInfo* const& batchTransactionRateInfo,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply,TransactionTagMap<uint64_t>* const& transactionTagCounter,PrioritizedTransactionTagMap<ClientTagThrottleLimits>* const& clientThrottledTags,GrvProxyStats* const& stats,GrvProxyData* const& proxyData) 
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : myID(myID),
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db),
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   inTransactionCount(inTransactionCount),
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   inBatchTransactionCount(inBatchTransactionCount),
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionRateInfo(transactionRateInfo),
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchTransactionRateInfo(batchTransactionRateInfo),
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   healthMetricsReply(healthMetricsReply),
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   detailedHealthMetricsReply(detailedHealthMetricsReply),
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionTagCounter(transactionTagCounter),
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   clientThrottledTags(clientThrottledTags),
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   stats(stats),
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   proxyData(proxyData),
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   nextRequestTimer(Never()),
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   leaseTimeout(Never()),
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   reply(Never()),
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   lastDetailedReply(0.0),
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   expectingDetailedReply(false)
															#line 2350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("getRate", reinterpret_cast<unsigned long>(this));

	}
	~GetRateActorState() 
	{
		fdb_probe_actor_destroy("getRate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (db->get().ratekeeper.present())
															#line 2365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				nextRequestTimer = Void();
															#line 2369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 2373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRateActorState();
		static_cast<GetRateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GetRateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = nextRequestTimer;
															#line 2409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<GetRateInfoReply> __when_expr_2 = reply;
															#line 2413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = leaseTimeout;
															#line 2417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
		static_cast<GetRateActor*>(this)->actor_wait_state = 1;
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRateActor, 0, Void >*>(static_cast<GetRateActor*>(this)));
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRateActor, 1, Void >*>(static_cast<GetRateActor*>(this)));
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRateActor, 2, GetRateInfoReply >*>(static_cast<GetRateActor*>(this)));
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRateActor, 3, Void >*>(static_cast<GetRateActor*>(this)));
															#line 2428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 2443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperChanged", myID).detail("RKID", db->get().ratekeeper.get().id());
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 2449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperDied", myID).log();
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply = Never();
															#line 2459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 2469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperChanged", myID).detail("RKID", db->get().ratekeeper.get().id());
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 2475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperDied", myID).log();
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply = Never();
															#line 2485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		bool detailed = now() - lastDetailedReply > SERVER_KNOBS->DETAILED_METRIC_UPDATE_RATE;
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		reply = brokenPromiseToNever( db->get().ratekeeper.get().getRateInfo.getReply(GetRateInfoRequest(myID, *inTransactionCount, *inBatchTransactionCount, proxyData->version, *transactionTagCounter, detailed)));
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionTagCounter->clear();
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		expectingDetailedReply = detailed;
															#line 2503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		bool detailed = now() - lastDetailedReply > SERVER_KNOBS->DETAILED_METRIC_UPDATE_RATE;
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		reply = brokenPromiseToNever( db->get().ratekeeper.get().getRateInfo.getReply(GetRateInfoRequest(myID, *inTransactionCount, *inBatchTransactionCount, proxyData->version, *transactionTagCounter, detailed)));
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionTagCounter->clear();
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		expectingDetailedReply = detailed;
															#line 2520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetRateInfoReply const& rep,int loopDepth) 
	{
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		reply = Never();
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionRateInfo->setRate(rep.transactionRate);
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionRateInfo->setRate(rep.batchTransactionRate);
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		stats->transactionRateAllowed = rep.transactionRate;
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		stats->batchTransactionRateAllowed = rep.batchTransactionRate;
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		++stats->updatesFromRatekeeper;
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		leaseTimeout = delay(rep.leaseDuration);
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = delayJittered(rep.leaseDuration / 2);
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		healthMetricsReply->update(rep.healthMetrics, expectingDetailedReply, true);
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (expectingDetailedReply)
															#line 2547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			detailedHealthMetricsReply->update(rep.healthMetrics, true, true);
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			lastDetailedReply = now();
															#line 2553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (rep.clientThrottledTags.present())
															#line 2557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			*clientThrottledTags = std::move(rep.clientThrottledTags.get());
															#line 2561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (rep.proxyThrottledTags.present())
															#line 2565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			proxyData->tagThrottler.updateRates(rep.proxyThrottledTags.get());
															#line 2569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetRateInfoReply && rep,int loopDepth) 
	{
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		reply = Never();
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionRateInfo->setRate(rep.transactionRate);
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionRateInfo->setRate(rep.batchTransactionRate);
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		stats->transactionRateAllowed = rep.transactionRate;
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		stats->batchTransactionRateAllowed = rep.batchTransactionRate;
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		++stats->updatesFromRatekeeper;
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		leaseTimeout = delay(rep.leaseDuration);
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = delayJittered(rep.leaseDuration / 2);
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		healthMetricsReply->update(rep.healthMetrics, expectingDetailedReply, true);
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (expectingDetailedReply)
															#line 2597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			detailedHealthMetricsReply->update(rep.healthMetrics, true, true);
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			lastDetailedReply = now();
															#line 2603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (rep.clientThrottledTags.present())
															#line 2607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			*clientThrottledTags = std::move(rep.clientThrottledTags.get());
															#line 2611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (rep.proxyThrottledTags.present())
															#line 2615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			proxyData->tagThrottler.updateRates(rep.proxyThrottledTags.get());
															#line 2619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void const& _,int loopDepth) 
	{
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionRateInfo->disable();
															#line 464 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionRateInfo->disable();
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		++stats->leaseTimeouts;
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		TraceEvent(SevWarn, "GrvProxyRateLeaseExpired", myID).suppressFor(5.0);
															#line 468 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		leaseTimeout = Never();
															#line 2637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void && _,int loopDepth) 
	{
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionRateInfo->disable();
															#line 464 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionRateInfo->disable();
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		++stats->leaseTimeouts;
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		TraceEvent(SevWarn, "GrvProxyRateLeaseExpired", myID).suppressFor(5.0);
															#line 468 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		leaseTimeout = Never();
															#line 2654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRateActor*>(this)->actor_wait_state > 0) static_cast<GetRateActor*>(this)->actor_wait_state = 0;
		static_cast<GetRateActor*>(this)->ActorCallback< GetRateActor, 0, Void >::remove();
		static_cast<GetRateActor*>(this)->ActorCallback< GetRateActor, 1, Void >::remove();
		static_cast<GetRateActor*>(this)->ActorCallback< GetRateActor, 2, GetRateInfoReply >::remove();
		static_cast<GetRateActor*>(this)->ActorCallback< GetRateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 2, GetRateInfoReply >*,GetRateInfoReply const& value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 2, GetRateInfoReply >*,GetRateInfoReply && value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRateActor, 2, GetRateInfoReply >*,Error err) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetRateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	UID myID;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t* inTransactionCount;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t* inBatchTransactionCount;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo* transactionRateInfo;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo* batchTransactionRateInfo;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* healthMetricsReply;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* detailedHealthMetricsReply;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	TransactionTagMap<uint64_t>* transactionTagCounter;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PrioritizedTransactionTagMap<ClientTagThrottleLimits>* clientThrottledTags;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyStats* stats;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* proxyData;
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> nextRequestTimer;
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> leaseTimeout;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<GetRateInfoReply> reply;
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double lastDetailedReply;
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	bool expectingDetailedReply;
															#line 2930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via getRate()
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GetRateActor final : public Actor<Void>, public ActorCallback< GetRateActor, 0, Void >, public ActorCallback< GetRateActor, 1, Void >, public ActorCallback< GetRateActor, 2, GetRateInfoReply >, public ActorCallback< GetRateActor, 3, Void >, public FastAllocated<GetRateActor>, public GetRateActorState<GetRateActor> {
															#line 2935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GetRateActor>::operator new;
	using FastAllocated<GetRateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3323917690499416576UL, 14393102557001045504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRateActor, 0, Void >;
friend struct ActorCallback< GetRateActor, 1, Void >;
friend struct ActorCallback< GetRateActor, 2, GetRateInfoReply >;
friend struct ActorCallback< GetRateActor, 3, Void >;
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetRateActor(UID const& myID,Reference<AsyncVar<ServerDBInfo> const> const& db,int64_t* const& inTransactionCount,int64_t* const& inBatchTransactionCount,GrvTransactionRateInfo* const& transactionRateInfo,GrvTransactionRateInfo* const& batchTransactionRateInfo,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply,TransactionTagMap<uint64_t>* const& transactionTagCounter,PrioritizedTransactionTagMap<ClientTagThrottleLimits>* const& clientThrottledTags,GrvProxyStats* const& stats,GrvProxyData* const& proxyData) 
															#line 2955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GetRateActorState<GetRateActor>(myID, db, inTransactionCount, inBatchTransactionCount, transactionRateInfo, batchTransactionRateInfo, healthMetricsReply, detailedHealthMetricsReply, transactionTagCounter, clientThrottledTags, stats, proxyData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3946064217190820608UL, 8787252396757706496UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRateActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> getRate( UID const& myID, Reference<AsyncVar<ServerDBInfo> const> const& db, int64_t* const& inTransactionCount, int64_t* const& inBatchTransactionCount, GrvTransactionRateInfo* const& transactionRateInfo, GrvTransactionRateInfo* const& batchTransactionRateInfo, GetHealthMetricsReply* const& healthMetricsReply, GetHealthMetricsReply* const& detailedHealthMetricsReply, TransactionTagMap<uint64_t>* const& transactionTagCounter, PrioritizedTransactionTagMap<ClientTagThrottleLimits>* const& clientThrottledTags, GrvProxyStats* const& stats, GrvProxyData* const& proxyData ) {
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GetRateActor(myID, db, inTransactionCount, inBatchTransactionCount, transactionRateInfo, batchTransactionRateInfo, healthMetricsReply, detailedHealthMetricsReply, transactionTagCounter, clientThrottledTags, stats, proxyData));
															#line 2988 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 472 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Respond with an error to the GetReadVersion request when the GRV limit is hit.
void proxyGRVThresholdExceeded(const GetReadVersionRequest* req, GrvProxyStats* stats) {
	++stats->txnRequestErrors;
	req->reply.sendError(grv_proxy_memory_limit_exceeded());
	if (req->priority == TransactionPriority::IMMEDIATE) {
		TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyGRVThresholdExceededSystem")
		    .suppressFor(60);
	} else if (req->priority == TransactionPriority::DEFAULT) {
		TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyGRVThresholdExceededDefault")
		    .suppressFor(60);
	} else {
		TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyGRVThresholdExceededBatch")
		    .suppressFor(60);
	}
}

// Drop a GetReadVersion request from a queue, by responding an error to the request.
void dropRequestFromQueue(Deque<GetReadVersionRequest>* queue, GrvProxyStats* stats) {
	proxyGRVThresholdExceeded(&queue->front(), stats);
	++stats->txnRequestOut;
	queue->pop_front();
}

// Put a GetReadVersion request into the queue corresponding to its priority.
															#line 3017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via queueGetReadVersionRequests()
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class QueueGetReadVersionRequestsActor>
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class QueueGetReadVersionRequestsActorState {
															#line 3024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	QueueGetReadVersionRequestsActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,Deque<GetReadVersionRequest>* const& systemQueue,Deque<GetReadVersionRequest>* const& defaultQueue,Deque<GetReadVersionRequest>* const& batchQueue,FutureStream<GetReadVersionRequest> const& readVersionRequests,PromiseStream<Void> const& GRVTimer,double* const& lastGRVTime,double* const& GRVBatchTime,FutureStream<double> const& normalGRVLatency,GrvProxyStats* const& stats,GrvTransactionRateInfo* const& batchRateInfo,GrvProxyTagThrottler* const& tagThrottler) 
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : db(db),
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   systemQueue(systemQueue),
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   defaultQueue(defaultQueue),
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchQueue(batchQueue),
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   readVersionRequests(readVersionRequests),
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   GRVTimer(GRVTimer),
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   lastGRVTime(lastGRVTime),
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   GRVBatchTime(GRVBatchTime),
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   normalGRVLatency(normalGRVLatency),
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   stats(stats),
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchRateInfo(batchRateInfo),
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   tagThrottler(tagThrottler)
															#line 3053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this));

	}
	~QueueGetReadVersionRequestsActorState() 
	{
		fdb_probe_actor_destroy("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::operation) = TransactionLineage::Operation::GetConsistentReadVersion;
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 3070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~QueueGetReadVersionRequestsActorState();
		static_cast<QueueGetReadVersionRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		FutureStream<GetReadVersionRequest> __when_expr_0 = readVersionRequests;
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<QueueGetReadVersionRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		FutureStream<double> __when_expr_1 = normalGRVLatency;
															#line 3106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
		static_cast<QueueGetReadVersionRequestsActor*>(this)->actor_wait_state = 1;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*>(static_cast<QueueGetReadVersionRequestsActor*>(this)));
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >*>(static_cast<QueueGetReadVersionRequestsActor*>(this)));
															#line 3113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetReadVersionRequest const& req,int loopDepth) 
	{
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		bool canBeQueued = true;
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (stats->txnRequestIn.getValue() - stats->txnRequestOut.getValue() > SERVER_KNOBS->START_TRANSACTION_MAX_QUEUE_SIZE || (g_network->isSimulated() && !g_simulator->speedUpSimulation && deterministicRandom()->random01() < 0.01))
															#line 3130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority == TransactionPriority::BATCH)
															#line 3134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 523 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				canBeQueued = false;
															#line 3138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 524 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority == TransactionPriority::DEFAULT)
															#line 3144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue->empty())
															#line 3148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						dropRequestFromQueue(batchQueue, stats);
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						--stats->batchGRVQueueSize;
															#line 3154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						canBeQueued = false;
															#line 3160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
				}
				else
				{
															#line 532 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue->empty())
															#line 3167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						dropRequestFromQueue(batchQueue, stats);
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						--stats->batchGRVQueueSize;
															#line 3173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 535 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (!defaultQueue->empty())
															#line 3179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							dropRequestFromQueue(defaultQueue, stats);
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							--stats->defaultGRVQueueSize;
															#line 3185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
						else
						{
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							canBeQueued = false;
															#line 3191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
		}
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!canBeQueued)
															#line 3199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			proxyGRVThresholdExceeded(&req, stats);
															#line 3203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			stats->addRequest(req.transactionCount);
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.debugID.present())
															#line 3211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", req.debugID.get().first(), "GrvProxyServer.queueTransactionStartRequests.Before");
															#line 3215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (systemQueue->empty() && defaultQueue->empty() && batchQueue->empty())
															#line 3219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				forwardPromise(GRVTimer, delayJittered(std::max(0.0, *GRVBatchTime - (now() - *lastGRVTime)), TaskPriority::ProxyGRVTimer));
															#line 3223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority >= TransactionPriority::IMMEDIATE)
															#line 3227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				++stats->txnRequestIn;
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->txnStartIn += req.transactionCount;
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->txnSystemPriorityStartIn += req.transactionCount;
															#line 563 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				++stats->systemGRVQueueSize;
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				systemQueue->push_back(req);
															#line 3239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority >= TransactionPriority::DEFAULT)
															#line 3245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (SERVER_KNOBS->ENFORCE_TAG_THROTTLING_ON_PROXIES && req.isTagged())
															#line 3249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->tagThrottlerGRVQueueSize;
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnTagThrottlerIn += req.transactionCount;
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						tagThrottler->addRequest(req);
															#line 3257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->txnRequestIn;
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnStartIn += req.transactionCount;
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnDefaultPriorityStartIn += req.transactionCount;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->defaultGRVQueueSize;
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						defaultQueue->push_back(req);
															#line 3271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
				}
				else
				{
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					int64_t proxiesCount = std::max((int)db->get().client.grvProxies.size(), 1);
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (batchRateInfo->getRate() <= (1.0 / proxiesCount))
															#line 3280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						req.reply.sendError(batch_transaction_throttled());
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnThrottled += req.transactionCount;
															#line 3286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (SERVER_KNOBS->ENFORCE_TAG_THROTTLING_ON_PROXIES && req.isTagged())
															#line 3292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->tagThrottlerGRVQueueSize;
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnTagThrottlerIn += req.transactionCount;
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							tagThrottler->addRequest(req);
															#line 3300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
						else
						{
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->txnRequestIn;
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnStartIn += req.transactionCount;
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnBatchPriorityStartIn += req.transactionCount;
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->batchGRVQueueSize;
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							batchQueue->push_back(req);
															#line 3314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetReadVersionRequest && req,int loopDepth) 
	{
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		bool canBeQueued = true;
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (stats->txnRequestIn.getValue() - stats->txnRequestOut.getValue() > SERVER_KNOBS->START_TRANSACTION_MAX_QUEUE_SIZE || (g_network->isSimulated() && !g_simulator->speedUpSimulation && deterministicRandom()->random01() < 0.01))
															#line 3330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority == TransactionPriority::BATCH)
															#line 3334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 523 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				canBeQueued = false;
															#line 3338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 524 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority == TransactionPriority::DEFAULT)
															#line 3344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue->empty())
															#line 3348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						dropRequestFromQueue(batchQueue, stats);
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						--stats->batchGRVQueueSize;
															#line 3354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						canBeQueued = false;
															#line 3360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
				}
				else
				{
															#line 532 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue->empty())
															#line 3367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						dropRequestFromQueue(batchQueue, stats);
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						--stats->batchGRVQueueSize;
															#line 3373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 535 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (!defaultQueue->empty())
															#line 3379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							dropRequestFromQueue(defaultQueue, stats);
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							--stats->defaultGRVQueueSize;
															#line 3385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
						else
						{
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							canBeQueued = false;
															#line 3391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
		}
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!canBeQueued)
															#line 3399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			proxyGRVThresholdExceeded(&req, stats);
															#line 3403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			stats->addRequest(req.transactionCount);
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.debugID.present())
															#line 3411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", req.debugID.get().first(), "GrvProxyServer.queueTransactionStartRequests.Before");
															#line 3415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (systemQueue->empty() && defaultQueue->empty() && batchQueue->empty())
															#line 3419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				forwardPromise(GRVTimer, delayJittered(std::max(0.0, *GRVBatchTime - (now() - *lastGRVTime)), TaskPriority::ProxyGRVTimer));
															#line 3423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority >= TransactionPriority::IMMEDIATE)
															#line 3427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				++stats->txnRequestIn;
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->txnStartIn += req.transactionCount;
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->txnSystemPriorityStartIn += req.transactionCount;
															#line 563 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				++stats->systemGRVQueueSize;
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				systemQueue->push_back(req);
															#line 3439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority >= TransactionPriority::DEFAULT)
															#line 3445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (SERVER_KNOBS->ENFORCE_TAG_THROTTLING_ON_PROXIES && req.isTagged())
															#line 3449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->tagThrottlerGRVQueueSize;
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnTagThrottlerIn += req.transactionCount;
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						tagThrottler->addRequest(req);
															#line 3457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->txnRequestIn;
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnStartIn += req.transactionCount;
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnDefaultPriorityStartIn += req.transactionCount;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->defaultGRVQueueSize;
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						defaultQueue->push_back(req);
															#line 3471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
				}
				else
				{
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					int64_t proxiesCount = std::max((int)db->get().client.grvProxies.size(), 1);
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (batchRateInfo->getRate() <= (1.0 / proxiesCount))
															#line 3480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						req.reply.sendError(batch_transaction_throttled());
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnThrottled += req.transactionCount;
															#line 3486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (SERVER_KNOBS->ENFORCE_TAG_THROTTLING_ON_PROXIES && req.isTagged())
															#line 3492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->tagThrottlerGRVQueueSize;
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnTagThrottlerIn += req.transactionCount;
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							tagThrottler->addRequest(req);
															#line 3500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
						else
						{
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->txnRequestIn;
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnStartIn += req.transactionCount;
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnBatchPriorityStartIn += req.transactionCount;
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->batchGRVQueueSize;
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							batchQueue->push_back(req);
															#line 3514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(double const& reply_latency,int loopDepth) 
	{
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double target_latency = reply_latency * SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_LATENCY_FRACTION;
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*GRVBatchTime = std::max( SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MIN, std::min(SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MAX, target_latency * SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA + *GRVBatchTime * (1 - SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA)));
															#line 3530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(double && reply_latency,int loopDepth) 
	{
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double target_latency = reply_latency * SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_LATENCY_FRACTION;
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*GRVBatchTime = std::max( SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MIN, std::min(SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MAX, target_latency * SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA + *GRVBatchTime * (1 - SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA)));
															#line 3541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<QueueGetReadVersionRequestsActor*>(this)->actor_wait_state > 0) static_cast<QueueGetReadVersionRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<QueueGetReadVersionRequestsActor*>(this)->ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >::remove();
		static_cast<QueueGetReadVersionRequestsActor*>(this)->ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >::remove();

	}
	void a_callback_fire(ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*,GetReadVersionRequest const& value) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*,GetReadVersionRequest && value) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >*,double const& value) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >*,double && value) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >*,Error err) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest>* systemQueue;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest>* defaultQueue;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest>* batchQueue;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	FutureStream<GetReadVersionRequest> readVersionRequests;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Void> GRVTimer;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double* lastGRVTime;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double* GRVBatchTime;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	FutureStream<double> normalGRVLatency;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyStats* stats;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo* batchRateInfo;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyTagThrottler* tagThrottler;
															#line 3691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via queueGetReadVersionRequests()
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class QueueGetReadVersionRequestsActor final : public Actor<Void>, public ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >, public ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >, public FastAllocated<QueueGetReadVersionRequestsActor>, public QueueGetReadVersionRequestsActorState<QueueGetReadVersionRequestsActor> {
															#line 3696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<QueueGetReadVersionRequestsActor>::operator new;
	using FastAllocated<QueueGetReadVersionRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7826674072398249984UL, 14796349763608442368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >;
friend struct ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	QueueGetReadVersionRequestsActor(Reference<AsyncVar<ServerDBInfo> const> const& db,Deque<GetReadVersionRequest>* const& systemQueue,Deque<GetReadVersionRequest>* const& defaultQueue,Deque<GetReadVersionRequest>* const& batchQueue,FutureStream<GetReadVersionRequest> const& readVersionRequests,PromiseStream<Void> const& GRVTimer,double* const& lastGRVTime,double* const& GRVBatchTime,FutureStream<double> const& normalGRVLatency,GrvProxyStats* const& stats,GrvTransactionRateInfo* const& batchRateInfo,GrvProxyTagThrottler* const& tagThrottler) 
															#line 3714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   QueueGetReadVersionRequestsActorState<QueueGetReadVersionRequestsActor>(db, systemQueue, defaultQueue, batchQueue, readVersionRequests, GRVTimer, lastGRVTime, GRVBatchTime, normalGRVLatency, stats, batchRateInfo, tagThrottler),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16228072202774818048UL, 4568169853275226880UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("queueGetReadVersionRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> queueGetReadVersionRequests( Reference<AsyncVar<ServerDBInfo> const> const& db, Deque<GetReadVersionRequest>* const& systemQueue, Deque<GetReadVersionRequest>* const& defaultQueue, Deque<GetReadVersionRequest>* const& batchQueue, FutureStream<GetReadVersionRequest> const& readVersionRequests, PromiseStream<Void> const& GRVTimer, double* const& lastGRVTime, double* const& GRVBatchTime, FutureStream<double> const& normalGRVLatency, GrvProxyStats* const& stats, GrvTransactionRateInfo* const& batchRateInfo, GrvProxyTagThrottler* const& tagThrottler ) {
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new QueueGetReadVersionRequestsActor(db, systemQueue, defaultQueue, batchQueue, readVersionRequests, GRVTimer, lastGRVTime, GRVBatchTime, normalGRVLatency, stats, batchRateInfo, tagThrottler));
															#line 3747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 610 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 3752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via updateLastCommit()
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class UpdateLastCommitActor>
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class UpdateLastCommitActorState {
															#line 3759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	UpdateLastCommitActorState(GrvProxyData* const& self,Optional<UID> const& debugID = Optional<UID>()) 
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : self(self),
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   debugID(debugID),
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   confirmStart(now())
															#line 3770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("updateLastCommit", reinterpret_cast<unsigned long>(this));

	}
	~UpdateLastCommitActorState() 
	{
		fdb_probe_actor_destroy("updateLastCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			self->lastStartCommit = confirmStart;
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			self->updateCommitRequests++;
															#line 615 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->logSystem->confirmEpochLive(debugID);
															#line 615 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<UpdateLastCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateLastCommitActor*>(this)->actor_wait_state = 1;
															#line 615 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateLastCommitActor, 0, Void >*>(static_cast<UpdateLastCommitActor*>(this)));
															#line 3796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateLastCommitActorState();
		static_cast<UpdateLastCommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->updateCommitRequests--;
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->lastCommitLatency = now() - confirmStart;
															#line 618 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->lastCommitTime = std::max(self->lastCommitTime.get(), confirmStart);
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<UpdateLastCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLastCommitActorState(); static_cast<UpdateLastCommitActor*>(this)->destroy(); return 0; }
															#line 3825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<UpdateLastCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLastCommitActorState();
		static_cast<UpdateLastCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->updateCommitRequests--;
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->lastCommitLatency = now() - confirmStart;
															#line 618 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->lastCommitTime = std::max(self->lastCommitTime.get(), confirmStart);
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<UpdateLastCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLastCommitActorState(); static_cast<UpdateLastCommitActor*>(this)->destroy(); return 0; }
															#line 3843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<UpdateLastCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLastCommitActorState();
		static_cast<UpdateLastCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateLastCommitActor*>(this)->actor_wait_state > 0) static_cast<UpdateLastCommitActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLastCommitActor*>(this)->ActorCallback< UpdateLastCommitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLastCommitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateLastCommitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateLastCommitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* self;
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<UID> debugID;
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double confirmStart;
															#line 3932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via updateLastCommit()
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class UpdateLastCommitActor final : public Actor<Void>, public ActorCallback< UpdateLastCommitActor, 0, Void >, public FastAllocated<UpdateLastCommitActor>, public UpdateLastCommitActorState<UpdateLastCommitActor> {
															#line 3937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<UpdateLastCommitActor>::operator new;
	using FastAllocated<UpdateLastCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(914631019227582976UL, 9879438750253223424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateLastCommitActor, 0, Void >;
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	UpdateLastCommitActor(GrvProxyData* const& self,Optional<UID> const& debugID = Optional<UID>()) 
															#line 3954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateLastCommitActorState<UpdateLastCommitActor>(self, debugID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateLastCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6267630262008360960UL, 2835741678179808768UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateLastCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateLastCommit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateLastCommitActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> updateLastCommit( GrvProxyData* const& self, Optional<UID> const& debugID = Optional<UID>() ) {
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new UpdateLastCommitActor(self, debugID));
															#line 3987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 621 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 3992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via lastCommitUpdater()
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class LastCommitUpdaterActor>
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class LastCommitUpdaterActorState {
															#line 3999 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	LastCommitUpdaterActorState(GrvProxyData* const& self,PromiseStream<Future<Void>> const& addActor) 
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : self(self),
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   addActor(addActor)
															#line 4008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("lastCommitUpdater", reinterpret_cast<unsigned long>(this));

	}
	~LastCommitUpdaterActorState() 
	{
		fdb_probe_actor_destroy("lastCommitUpdater", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 4023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LastCommitUpdaterActorState();
		static_cast<LastCommitUpdaterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double interval = std::max(SERVER_KNOBS->MIN_CONFIRM_INTERVAL, (SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION - self->lastCommitLatency) / 2.0);
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double elapsed = now() - self->lastStartCommit;
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (elapsed < interval)
															#line 4057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(interval + 0.0001 - elapsed);
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<LastCommitUpdaterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LastCommitUpdaterActor*>(this)->actor_wait_state = 1;
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LastCommitUpdaterActor, 0, Void >*>(static_cast<LastCommitUpdaterActor*>(this)));
															#line 4068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (self->updateCommitRequests < SERVER_KNOBS->MAX_COMMIT_UPDATES)
															#line 4075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				addActor.send(updateLastCommit(self));
															#line 4079 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "TooManyLastCommitUpdates") .suppressFor(1.0);
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				self->lastStartCommit = now();
															#line 4087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LastCommitUpdaterActor*>(this)->actor_wait_state > 0) static_cast<LastCommitUpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<LastCommitUpdaterActor*>(this)->ActorCallback< LastCommitUpdaterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LastCommitUpdaterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LastCommitUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LastCommitUpdaterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LastCommitUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LastCommitUpdaterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LastCommitUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* self;
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 4191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via lastCommitUpdater()
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class LastCommitUpdaterActor final : public Actor<Void>, public ActorCallback< LastCommitUpdaterActor, 0, Void >, public FastAllocated<LastCommitUpdaterActor>, public LastCommitUpdaterActorState<LastCommitUpdaterActor> {
															#line 4196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<LastCommitUpdaterActor>::operator new;
	using FastAllocated<LastCommitUpdaterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16378800620607014400UL, 8450292641765966592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LastCommitUpdaterActor, 0, Void >;
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	LastCommitUpdaterActor(GrvProxyData* const& self,PromiseStream<Future<Void>> const& addActor) 
															#line 4213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   LastCommitUpdaterActorState<LastCommitUpdaterActor>(self, addActor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lastCommitUpdater", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5278625381336097792UL, 45007184844760832UL);
		ActorExecutionContextHelper __helper(static_cast<LastCommitUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lastCommitUpdater");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lastCommitUpdater", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LastCommitUpdaterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> lastCommitUpdater( GrvProxyData* const& self, PromiseStream<Future<Void>> const& addActor ) {
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new LastCommitUpdaterActor(self, addActor));
															#line 4246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 641 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 4251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via getLiveCommittedVersion()
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GetLiveCommittedVersionActor>
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GetLiveCommittedVersionActorState {
															#line 4258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetLiveCommittedVersionActorState(std::vector<SpanContext> const& spanContexts,GrvProxyData* const& grvProxyData,uint32_t const& flags,Optional<UID> const& debugID,int const& transactionCount,int const& systemTransactionCount,int const& defaultPriTransactionCount,int const& batchPriTransactionCount) 
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : spanContexts(spanContexts),
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxyData(grvProxyData),
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   flags(flags),
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   debugID(debugID),
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionCount(transactionCount),
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   systemTransactionCount(systemTransactionCount),
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   defaultPriTransactionCount(defaultPriTransactionCount),
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchPriTransactionCount(batchPriTransactionCount),
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   span("GP:getLiveCommittedVersion"_loc)
															#line 4281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetLiveCommittedVersionActorState() 
	{
		fdb_probe_actor_destroy("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 656 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			for( const SpanContext& spanContext : spanContexts ) {
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				span.addLink(spanContext);
															#line 4298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 659 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			++grvProxyData->stats.txnStartBatch;
															#line 661 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvStart = now();
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			replyFromMasterFuture = Future<GetRawCommittedVersionReply>();
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			replyFromMasterFuture = grvProxyData->master.getLiveCommittedVersion.getReply( GetRawCommittedVersionRequest(span.context, debugID, grvProxyData->ssVersionVectorCache.getMaxVersion()), TaskPriority::GetLiveCommittedVersionReply);
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!SERVER_KNOBS->ALWAYS_CAUSAL_READ_RISKY && !(flags & GetReadVersionRequest::FLAG_CAUSAL_READ_RISKY))
															#line 4310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 668 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = transformError(updateLastCommit(grvProxyData, debugID), broken_promise(), tlog_failed());
															#line 668 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 1;
															#line 668 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLiveCommittedVersionActor, 0, Void >*>(static_cast<GetLiveCommittedVersionActor*>(this)));
															#line 4321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION > 0 && now() - SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION > grvProxyData->lastCommitTime.get())
															#line 4328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					StrictFuture<Void> __when_expr_1 = grvProxyData->lastCommitTime.whenAtLeast(now() - SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION);
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetLiveCommittedVersionActor, 1, Void >*>(static_cast<GetLiveCommittedVersionActor*>(this)));
															#line 4339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont4(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLiveCommittedVersionActorState();
		static_cast<GetLiveCommittedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvConfirmEpochLive = now();
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.grvConfirmEpochLiveDist->sampleSeconds(grvConfirmEpochLive - grvStart);
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 4372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "GrvProxyServer.getLiveCommittedVersion.confirmEpochLive");
															#line 4376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<GetRawCommittedVersionReply> __when_expr_2 = transformError(replyFromMasterFuture, broken_promise(), master_failed());
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 3;
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*>(static_cast<GetLiveCommittedVersionActor*>(this)));
															#line 4387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLiveCommittedVersionActor*>(this)->ActorCallback< GetLiveCommittedVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLiveCommittedVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLiveCommittedVersionActor*>(this)->ActorCallback< GetLiveCommittedVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetLiveCommittedVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(GetRawCommittedVersionReply const& repFromMaster,int loopDepth) 
	{
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->version = std::max(grvProxyData->version, repFromMaster.version);
															#line 684 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->minKnownCommittedVersion = std::max(grvProxyData->minKnownCommittedVersion, repFromMaster.minKnownCommittedVersion);
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 4580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->ssVersionVectorCache.applyDelta(repFromMaster.ssVersionVectorDelta);
															#line 4584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.grvGetCommittedVersionRpcDist->sampleSeconds(now() - grvConfirmEpochLive);
															#line 691 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		GetReadVersionReply rep;
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.version = repFromMaster.version;
															#line 693 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.locked = repFromMaster.locked;
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.metadataVersion = repFromMaster.metadataVersion;
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.processBusyTime = FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION * std::min((std::numeric_limits<int>::max() / FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION) - 1, grvProxyData->stats.getRecentRequests());
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.processBusyTime += FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION * (g_network->isSimulated() ? deterministicRandom()->random01() : g_network->networkInfo.metrics.lastRunLoopBusyness);
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 4602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "GrvProxyServer.getLiveCommittedVersion.After");
															#line 4606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnStartOut += transactionCount;
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnSystemPriorityStartOut += systemTransactionCount;
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnDefaultPriorityStartOut += defaultPriTransactionCount;
															#line 711 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnBatchPriorityStartOut += batchPriTransactionCount;
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GetLiveCommittedVersionActor*>(this)->SAV<GetReadVersionReply>::futures) { (void)(rep); this->~GetLiveCommittedVersionActorState(); static_cast<GetLiveCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 4618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GetLiveCommittedVersionActor*>(this)->SAV< GetReadVersionReply >::value()) GetReadVersionReply(rep);
		this->~GetLiveCommittedVersionActorState();
		static_cast<GetLiveCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(GetRawCommittedVersionReply && repFromMaster,int loopDepth) 
	{
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->version = std::max(grvProxyData->version, repFromMaster.version);
															#line 684 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->minKnownCommittedVersion = std::max(grvProxyData->minKnownCommittedVersion, repFromMaster.minKnownCommittedVersion);
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 4634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->ssVersionVectorCache.applyDelta(repFromMaster.ssVersionVectorDelta);
															#line 4638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.grvGetCommittedVersionRpcDist->sampleSeconds(now() - grvConfirmEpochLive);
															#line 691 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		GetReadVersionReply rep;
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.version = repFromMaster.version;
															#line 693 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.locked = repFromMaster.locked;
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.metadataVersion = repFromMaster.metadataVersion;
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.processBusyTime = FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION * std::min((std::numeric_limits<int>::max() / FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION) - 1, grvProxyData->stats.getRecentRequests());
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.processBusyTime += FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION * (g_network->isSimulated() ? deterministicRandom()->random01() : g_network->networkInfo.metrics.lastRunLoopBusyness);
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 4656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "GrvProxyServer.getLiveCommittedVersion.After");
															#line 4660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnStartOut += transactionCount;
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnSystemPriorityStartOut += systemTransactionCount;
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnDefaultPriorityStartOut += defaultPriTransactionCount;
															#line 711 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnBatchPriorityStartOut += batchPriTransactionCount;
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GetLiveCommittedVersionActor*>(this)->SAV<GetReadVersionReply>::futures) { (void)(rep); this->~GetLiveCommittedVersionActorState(); static_cast<GetLiveCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 4672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GetLiveCommittedVersionActor*>(this)->SAV< GetReadVersionReply >::value()) GetReadVersionReply(rep);
		this->~GetLiveCommittedVersionActorState();
		static_cast<GetLiveCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(GetRawCommittedVersionReply const& repFromMaster,int loopDepth) 
	{
		loopDepth = a_body1cont6(repFromMaster, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(GetRawCommittedVersionReply && repFromMaster,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(repFromMaster), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLiveCommittedVersionActor*>(this)->ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*,GetRawCommittedVersionReply const& value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*,GetRawCommittedVersionReply && value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	std::vector<SpanContext> spanContexts;
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	uint32_t flags;
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<UID> debugID;
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int transactionCount;
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int systemTransactionCount;
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int defaultPriTransactionCount;
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int batchPriTransactionCount;
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Span span;
															#line 661 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double grvStart;
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<GetRawCommittedVersionReply> replyFromMasterFuture;
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double grvConfirmEpochLive;
															#line 4779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via getLiveCommittedVersion()
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GetLiveCommittedVersionActor final : public Actor<GetReadVersionReply>, public ActorCallback< GetLiveCommittedVersionActor, 0, Void >, public ActorCallback< GetLiveCommittedVersionActor, 1, Void >, public ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >, public FastAllocated<GetLiveCommittedVersionActor>, public GetLiveCommittedVersionActorState<GetLiveCommittedVersionActor> {
															#line 4784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GetLiveCommittedVersionActor>::operator new;
	using FastAllocated<GetLiveCommittedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16153205486833141504UL, 5522359295069000960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<GetReadVersionReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLiveCommittedVersionActor, 0, Void >;
friend struct ActorCallback< GetLiveCommittedVersionActor, 1, Void >;
friend struct ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >;
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetLiveCommittedVersionActor(std::vector<SpanContext> const& spanContexts,GrvProxyData* const& grvProxyData,uint32_t const& flags,Optional<UID> const& debugID,int const& transactionCount,int const& systemTransactionCount,int const& defaultPriTransactionCount,int const& batchPriTransactionCount) 
															#line 4803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<GetReadVersionReply>(),
		   GetLiveCommittedVersionActorState<GetLiveCommittedVersionActor>(spanContexts, grvProxyData, flags, debugID, transactionCount, systemTransactionCount, defaultPriTransactionCount, batchPriTransactionCount),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2565788491578482432UL, 13699237086852491520UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLiveCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLiveCommittedVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetLiveCommittedVersionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<GetReadVersionReply> getLiveCommittedVersion( std::vector<SpanContext> const& spanContexts, GrvProxyData* const& grvProxyData, uint32_t const& flags, Optional<UID> const& debugID, int const& transactionCount, int const& systemTransactionCount, int const& defaultPriTransactionCount, int const& batchPriTransactionCount ) {
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<GetReadVersionReply>(new GetLiveCommittedVersionActor(spanContexts, grvProxyData, flags, debugID, transactionCount, systemTransactionCount, defaultPriTransactionCount, batchPriTransactionCount));
															#line 4838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 715 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Returns the current read version (or minimum known committed version if requested),
// to each request in the provided list. Also check if the request should be throttled.
// Update GRV statistics according to the request's priority.
															#line 4846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via sendGrvReplies()
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class SendGrvRepliesActor>
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class SendGrvRepliesActorState {
															#line 4853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	SendGrvRepliesActorState(Future<GetReadVersionReply> const& replyFuture,std::vector<GetReadVersionRequest> const& requests,GrvProxyData* const& grvProxyData,GrvProxyStats* const& stats,Version const& minKnownCommittedVersion,PrioritizedTransactionTagMap<ClientTagThrottleLimits> const& clientThrottledTags,int64_t const& midShardSize = 0) 
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : replyFuture(replyFuture),
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   requests(requests),
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxyData(grvProxyData),
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   stats(stats),
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   minKnownCommittedVersion(minKnownCommittedVersion),
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   clientThrottledTags(clientThrottledTags),
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   midShardSize(midShardSize)
															#line 4872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("sendGrvReplies", reinterpret_cast<unsigned long>(this));

	}
	~SendGrvRepliesActorState() 
	{
		fdb_probe_actor_destroy("sendGrvReplies", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 726 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<GetReadVersionReply> __when_expr_0 = replyFuture;
															#line 726 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<SendGrvRepliesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SendGrvRepliesActor*>(this)->actor_wait_state = 1;
															#line 726 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*>(static_cast<SendGrvRepliesActor*>(this)));
															#line 4894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SendGrvRepliesActorState();
		static_cast<SendGrvRepliesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(GetReadVersionReply const& _reply,int loopDepth) 
	{
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		GetReadVersionReply reply = _reply;
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		Version replyVersion = reply.version;
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double end = g_network->timer();
															#line 731 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for( GetReadVersionRequest const& request : requests ) {
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			double duration = end - request.requestTime() - request.proxyTagThrottledDuration;
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority == TransactionPriority::BATCH)
															#line 4927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvBatchLatencySample.addMeasurement(duration);
															#line 4931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority == TransactionPriority::DEFAULT)
															#line 4935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 738 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvLatencySample.addMeasurement(duration);
															#line 4939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority >= TransactionPriority::DEFAULT)
															#line 4943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvLatencyBands.addMeasurement(duration);
															#line 4947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.flags & GetReadVersionRequest::FLAG_USE_MIN_KNOWN_COMMITTED_VERSION)
															#line 4951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				reply.version = minKnownCommittedVersion;
															#line 4955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				reply.version = replyVersion;
															#line 4961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.midShardSize = midShardSize;
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.tagThrottleInfo.clear();
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 4969 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->ssVersionVectorCache.getDelta(request.maxVersion, reply.ssVersionVectorDelta);
															#line 755 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->versionVectorSizeOnGRVReply->addMeasurement(reply.ssVersionVectorDelta.size());
															#line 4975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.proxyId = grvProxyData->dbgid;
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.proxyTagThrottledDuration = request.proxyTagThrottledDuration;
															#line 760 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.isTagged())
															#line 4983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				auto& priorityThrottledTags = clientThrottledTags[request.priority];
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				for( auto tag : request.tags ) {
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					auto tagItr = priorityThrottledTags.find(tag.first);
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (tagItr != priorityThrottledTags.end())
															#line 4993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 765 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (tagItr->second.expiration > now())
															#line 4997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 766 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							if (tagItr->second.tpsRate == std::numeric_limits<double>::max())
															#line 5001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
							{
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								CODE_PROBE(true, "Auto TPS rate is unlimited");
															#line 5005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
							}
							else
							{
															#line 769 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								CODE_PROBE(true, "GRV proxy returning tag throttle");
															#line 770 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								reply.tagThrottleInfo[tag.first] = tagItr->second;
															#line 5013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
							}
						}
						else
						{
															#line 774 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							CODE_PROBE(true, "GRV proxy expiring tag throttle");
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							priorityThrottledTags.erase(tagItr);
															#line 5022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
															#line 781 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (stats->lastBatchQueueThrottled)
															#line 5029 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (now() - stats->batchThrottleStartTime > CLIENT_KNOBS->GRV_SUSTAINED_THROTTLING_THRESHOLD)
															#line 5033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkBatchThrottled = true;
															#line 5037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 787 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (stats->lastDefaultQueueThrottled)
															#line 5042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (now() - stats->defaultThrottleStartTime > CLIENT_KNOBS->GRV_SUSTAINED_THROTTLING_THRESHOLD)
															#line 5046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 793 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkBatchThrottled = true;
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkDefaultThrottled = true;
															#line 5052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			request.reply.send(reply);
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			++stats->txnRequestOut;
															#line 5059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 801 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<SendGrvRepliesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendGrvRepliesActorState(); static_cast<SendGrvRepliesActor*>(this)->destroy(); return 0; }
															#line 5063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<SendGrvRepliesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendGrvRepliesActorState();
		static_cast<SendGrvRepliesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(GetReadVersionReply && _reply,int loopDepth) 
	{
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		GetReadVersionReply reply = _reply;
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		Version replyVersion = reply.version;
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double end = g_network->timer();
															#line 731 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for( GetReadVersionRequest const& request : requests ) {
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			double duration = end - request.requestTime() - request.proxyTagThrottledDuration;
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority == TransactionPriority::BATCH)
															#line 5085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvBatchLatencySample.addMeasurement(duration);
															#line 5089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority == TransactionPriority::DEFAULT)
															#line 5093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 738 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvLatencySample.addMeasurement(duration);
															#line 5097 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority >= TransactionPriority::DEFAULT)
															#line 5101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvLatencyBands.addMeasurement(duration);
															#line 5105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.flags & GetReadVersionRequest::FLAG_USE_MIN_KNOWN_COMMITTED_VERSION)
															#line 5109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				reply.version = minKnownCommittedVersion;
															#line 5113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				reply.version = replyVersion;
															#line 5119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.midShardSize = midShardSize;
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.tagThrottleInfo.clear();
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 5127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->ssVersionVectorCache.getDelta(request.maxVersion, reply.ssVersionVectorDelta);
															#line 755 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->versionVectorSizeOnGRVReply->addMeasurement(reply.ssVersionVectorDelta.size());
															#line 5133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.proxyId = grvProxyData->dbgid;
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.proxyTagThrottledDuration = request.proxyTagThrottledDuration;
															#line 760 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.isTagged())
															#line 5141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				auto& priorityThrottledTags = clientThrottledTags[request.priority];
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				for( auto tag : request.tags ) {
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					auto tagItr = priorityThrottledTags.find(tag.first);
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (tagItr != priorityThrottledTags.end())
															#line 5151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 765 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (tagItr->second.expiration > now())
															#line 5155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 766 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							if (tagItr->second.tpsRate == std::numeric_limits<double>::max())
															#line 5159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
							{
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								CODE_PROBE(true, "Auto TPS rate is unlimited");
															#line 5163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
							}
							else
							{
															#line 769 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								CODE_PROBE(true, "GRV proxy returning tag throttle");
															#line 770 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								reply.tagThrottleInfo[tag.first] = tagItr->second;
															#line 5171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
							}
						}
						else
						{
															#line 774 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							CODE_PROBE(true, "GRV proxy expiring tag throttle");
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							priorityThrottledTags.erase(tagItr);
															#line 5180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
															#line 781 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (stats->lastBatchQueueThrottled)
															#line 5187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (now() - stats->batchThrottleStartTime > CLIENT_KNOBS->GRV_SUSTAINED_THROTTLING_THRESHOLD)
															#line 5191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkBatchThrottled = true;
															#line 5195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 787 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (stats->lastDefaultQueueThrottled)
															#line 5200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (now() - stats->defaultThrottleStartTime > CLIENT_KNOBS->GRV_SUSTAINED_THROTTLING_THRESHOLD)
															#line 5204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 793 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkBatchThrottled = true;
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkDefaultThrottled = true;
															#line 5210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			request.reply.send(reply);
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			++stats->txnRequestOut;
															#line 5217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 801 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<SendGrvRepliesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendGrvRepliesActorState(); static_cast<SendGrvRepliesActor*>(this)->destroy(); return 0; }
															#line 5221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<SendGrvRepliesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendGrvRepliesActorState();
		static_cast<SendGrvRepliesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(GetReadVersionReply const& _reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(_reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(GetReadVersionReply && _reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SendGrvRepliesActor*>(this)->actor_wait_state > 0) static_cast<SendGrvRepliesActor*>(this)->actor_wait_state = 0;
		static_cast<SendGrvRepliesActor*>(this)->ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*,GetReadVersionReply const& value) 
	{
		fdb_probe_actor_enter("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendGrvRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*,GetReadVersionReply && value) 
	{
		fdb_probe_actor_enter("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendGrvRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendGrvRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<GetReadVersionReply> replyFuture;
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	std::vector<GetReadVersionRequest> requests;
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyStats* stats;
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Version minKnownCommittedVersion;
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PrioritizedTransactionTagMap<ClientTagThrottleLimits> clientThrottledTags;
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t midShardSize;
															#line 5318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via sendGrvReplies()
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class SendGrvRepliesActor final : public Actor<Void>, public ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >, public FastAllocated<SendGrvRepliesActor>, public SendGrvRepliesActorState<SendGrvRepliesActor> {
															#line 5323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<SendGrvRepliesActor>::operator new;
	using FastAllocated<SendGrvRepliesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3828443350084619008UL, 13159052160542448640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >;
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	SendGrvRepliesActor(Future<GetReadVersionReply> const& replyFuture,std::vector<GetReadVersionRequest> const& requests,GrvProxyData* const& grvProxyData,GrvProxyStats* const& stats,Version const& minKnownCommittedVersion,PrioritizedTransactionTagMap<ClientTagThrottleLimits> const& clientThrottledTags,int64_t const& midShardSize = 0) 
															#line 5340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   SendGrvRepliesActorState<SendGrvRepliesActor>(replyFuture, requests, grvProxyData, stats, minKnownCommittedVersion, clientThrottledTags, midShardSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sendGrvReplies", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6621363967670553088UL, 9891954819986612480UL);
		ActorExecutionContextHelper __helper(static_cast<SendGrvRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sendGrvReplies");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sendGrvReplies", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> sendGrvReplies( Future<GetReadVersionReply> const& replyFuture, std::vector<GetReadVersionRequest> const& requests, GrvProxyData* const& grvProxyData, GrvProxyStats* const& stats, Version const& minKnownCommittedVersion, PrioritizedTransactionTagMap<ClientTagThrottleLimits> const& clientThrottledTags, int64_t const& midShardSize = 0 ) {
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new SendGrvRepliesActor(replyFuture, requests, grvProxyData, stats, minKnownCommittedVersion, clientThrottledTags, midShardSize));
															#line 5373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 803 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 5378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorDDMetricsChanges()
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class MonitorDDMetricsChangesActor>
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class MonitorDDMetricsChangesActorState {
															#line 5385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	MonitorDDMetricsChangesActorState(int64_t* const& midShardSize,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : midShardSize(midShardSize),
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db),
															#line 805 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   nextRequestTimer(Never()),
															#line 806 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   nextReply(Never())
															#line 5398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this));

	}
	~MonitorDDMetricsChangesActorState() 
	{
		fdb_probe_actor_destroy("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 808 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (db->get().distributor.present())
															#line 5413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				nextRequestTimer = Void();
															#line 5417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 810 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 5421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorDDMetricsChangesActorState();
		static_cast<MonitorDDMetricsChangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 812 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<MonitorDDMetricsChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = nextRequestTimer;
															#line 5458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 832 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<GetDataDistributorMetricsReply> __when_expr_2 = nextReply;
															#line 5462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorDDMetricsChangesActor*>(this)->actor_wait_state = 1;
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*>(static_cast<MonitorDDMetricsChangesActor*>(this)));
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorDDMetricsChangesActor, 1, Void >*>(static_cast<MonitorDDMetricsChangesActor*>(this)));
															#line 832 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >*>(static_cast<MonitorDDMetricsChangesActor*>(this)));
															#line 5471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 840 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DDMidShardSizeUpdateFail").error(e);
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (e.code() != error_code_timed_out && e.code() != error_code_dd_not_found)
															#line 5495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 843 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = delay(CLIENT_KNOBS->MID_SHARD_SIZE_MAX_STALENESS);
															#line 844 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = Never();
															#line 5505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().distributor.present())
															#line 5526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DataDistributorChanged", db->get().id) .detail("DDID", db->get().distributor.get().id());
															#line 817 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 5532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DataDistributorDied", db->get().id);
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 5540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 822 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextReply = Never();
															#line 5544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().distributor.present())
															#line 5553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DataDistributorChanged", db->get().id) .detail("DDID", db->get().distributor.get().id());
															#line 817 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 5559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DataDistributorDied", db->get().id);
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 5567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 822 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextReply = Never();
															#line 5571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 826 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().distributor.present())
															#line 5582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 827 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = brokenPromiseToNever(db->get().distributor.get().dataDistributorMetrics.getReply( GetDataDistributorMetricsRequest(normalKeys, CLIENT_KNOBS->TOO_MANY, true)));
															#line 5586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = Never();
															#line 5592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 826 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().distributor.present())
															#line 5604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 827 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = brokenPromiseToNever(db->get().distributor.get().dataDistributorMetrics.getReply( GetDataDistributorMetricsRequest(normalKeys, CLIENT_KNOBS->TOO_MANY, true)));
															#line 5608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = Never();
															#line 5614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetDataDistributorMetricsReply const& reply,int loopDepth) 
	{
															#line 833 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextReply = Never();
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(reply.midShardSize.present());
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*midShardSize = reply.midShardSize.get();
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = delay(CLIENT_KNOBS->MID_SHARD_SIZE_MAX_STALENESS);
															#line 5630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetDataDistributorMetricsReply && reply,int loopDepth) 
	{
															#line 833 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextReply = Never();
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(reply.midShardSize.present());
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*midShardSize = reply.midShardSize.get();
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = delay(CLIENT_KNOBS->MID_SHARD_SIZE_MAX_STALENESS);
															#line 5645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorDDMetricsChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorDDMetricsChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorDDMetricsChangesActor*>(this)->ActorCallback< MonitorDDMetricsChangesActor, 0, Void >::remove();
		static_cast<MonitorDDMetricsChangesActor*>(this)->ActorCallback< MonitorDDMetricsChangesActor, 1, Void >::remove();
		static_cast<MonitorDDMetricsChangesActor*>(this)->ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorDDMetricsChangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >*,GetDataDistributorMetricsReply const& value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >*,GetDataDistributorMetricsReply && value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t* midShardSize;
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 805 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> nextRequestTimer;
															#line 806 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<GetDataDistributorMetricsReply> nextReply;
															#line 5850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via monitorDDMetricsChanges()
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class MonitorDDMetricsChangesActor final : public Actor<Void>, public ActorCallback< MonitorDDMetricsChangesActor, 0, Void >, public ActorCallback< MonitorDDMetricsChangesActor, 1, Void >, public ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >, public FastAllocated<MonitorDDMetricsChangesActor>, public MonitorDDMetricsChangesActorState<MonitorDDMetricsChangesActor> {
															#line 5855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<MonitorDDMetricsChangesActor>::operator new;
	using FastAllocated<MonitorDDMetricsChangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14609664056956031744UL, 16494487752674409728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorDDMetricsChangesActor, 0, Void >;
friend struct ActorCallback< MonitorDDMetricsChangesActor, 1, Void >;
friend struct ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >;
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	MonitorDDMetricsChangesActor(int64_t* const& midShardSize,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 5874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorDDMetricsChangesActorState<MonitorDDMetricsChangesActor>(midShardSize, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16350006110712773376UL, 12950337145856341760UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorDDMetricsChanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> monitorDDMetricsChanges( int64_t* const& midShardSize, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new MonitorDDMetricsChangesActor(midShardSize, db));
															#line 5907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 848 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 5912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via transactionStarter()
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class TransactionStarterActor>
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class TransactionStarterActorState {
															#line 5919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	TransactionStarterActorState(GrvProxyInterface const& proxy,Reference<AsyncVar<ServerDBInfo> const> const& db,PromiseStream<Future<Void>> const& addActor,GrvProxyData* const& grvProxyData,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply) 
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db),
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   addActor(addActor),
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxyData(grvProxyData),
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   healthMetricsReply(healthMetricsReply),
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   detailedHealthMetricsReply(detailedHealthMetricsReply),
															#line 855 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   lastGRVTime(0),
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   GRVTimer(),
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   GRVBatchTime(SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MIN),
															#line 859 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionCount(0),
															#line 860 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchTransactionCount(0),
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   normalRateInfo(SERVER_KNOBS->START_TRANSACTION_RATE_WINDOW, SERVER_KNOBS->START_TRANSACTION_MAX_EMPTY_QUEUE_BUDGET, 10),
															#line 864 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchRateInfo(SERVER_KNOBS->START_TRANSACTION_RATE_WINDOW, SERVER_KNOBS->START_TRANSACTION_MAX_EMPTY_QUEUE_BUDGET, 0),
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   systemQueue(),
															#line 869 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   defaultQueue(),
															#line 870 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchQueue(),
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionTagCounter(),
															#line 873 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   clientThrottledTags(),
															#line 875 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   normalGRVLatency(),
															#line 877 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   midShardSize(SERVER_KNOBS->MIN_SHARD_BYTES)
															#line 5964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("transactionStarter", reinterpret_cast<unsigned long>(this));

	}
	~TransactionStarterActorState() 
	{
		fdb_probe_actor_destroy("transactionStarter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 878 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::operation) = TransactionLineage::Operation::GetConsistentReadVersion;
															#line 880 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(monitorDDMetricsChanges(&midShardSize, db));
															#line 882 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(getRate(proxy.id(), db, &transactionCount, &batchTransactionCount, &normalRateInfo, &batchRateInfo, healthMetricsReply, detailedHealthMetricsReply, &transactionTagCounter, &clientThrottledTags, &grvProxyData->stats, grvProxyData));
															#line 894 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(queueGetReadVersionRequests(db, &systemQueue, &defaultQueue, &batchQueue, proxy.getConsistentReadVersion.getFuture(), GRVTimer, &lastGRVTime, &GRVBatchTime, normalGRVLatency.getFuture(), &grvProxyData->stats, &batchRateInfo, &grvProxyData->tagThrottler));
															#line 907 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 5987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TransactionStarterActorState();
		static_cast<TransactionStarterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 912 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(db->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS);
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		TraceEvent("GrvProxyReadyForTxnStarts", proxy.id());
															#line 916 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		;
															#line 6014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 907 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!(std::find(db->get().client.grvProxies.begin(), db->get().client.grvProxies.end(), proxy) == db->get().client.grvProxies.end()))
															#line 6030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<TransactionStarterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TransactionStarterActor*>(this)->actor_wait_state = 1;
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TransactionStarterActor, 0, Void >*>(static_cast<TransactionStarterActor*>(this)));
															#line 6043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TransactionStarterActor*>(this)->actor_wait_state > 0) static_cast<TransactionStarterActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionStarterActor*>(this)->ActorCallback< TransactionStarterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TransactionStarterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransactionStarterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TransactionStarterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		FutureStream<Void> __when_expr_1 = GRVTimer.getFuture();
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<TransactionStarterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<TransactionStarterActor*>(this)->actor_wait_state = 2;
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< TransactionStarterActor, 1, Void >*>(static_cast<TransactionStarterActor*>(this)));
															#line 6166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double t = now();
															#line 920 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double elapsed = now() - lastGRVTime;
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		lastGRVTime = t;
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (elapsed == 0)
															#line 6181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 925 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			elapsed = 1e-15;
															#line 6185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 928 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.update(grvProxyData->tagThrottler.releaseTransactions(elapsed, batchQueue, defaultQueue));
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		normalRateInfo.startReleaseWindow();
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchRateInfo.startReleaseWindow();
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.transactionLimit = normalRateInfo.getLimit();
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.batchTransactionLimit = batchRateInfo.getLimit();
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int transactionsStarted[2] = { 0, 0 };
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int systemTransactionsStarted[2] = { 0, 0 };
															#line 938 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int defaultPriTransactionsStarted[2] = { 0, 0 };
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchPriTransactionsStarted[2] = { 0, 0 };
															#line 941 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		std::vector<std::vector<GetReadVersionRequest>> start( 2);
															#line 944 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		Optional<UID> debugID;
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int requestsToStart = 0;
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		uint32_t defaultQueueSize = defaultQueue.size();
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		uint32_t batchQueueSize = batchQueue.size();
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for(;requestsToStart < SERVER_KNOBS->START_TRANSACTION_MAX_REQUESTS_TO_START;) {
															#line 951 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Deque<GetReadVersionRequest>* transactionQueue;
															#line 952 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!systemQueue.empty())
															#line 6221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				transactionQueue = &systemQueue;
															#line 6225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 954 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (!defaultQueue.empty())
															#line 6231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					transactionQueue = &defaultQueue;
															#line 6235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
				else
				{
															#line 956 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue.empty())
															#line 6241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 957 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						transactionQueue = &batchQueue;
															#line 6245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
						break;
					}
				}
			}
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			auto& req = transactionQueue->front();
															#line 963 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			int tc = req.transactionCount;
															#line 965 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority < TransactionPriority::DEFAULT && !batchRateInfo.canStart(transactionsStarted[0] + transactionsStarted[1], tc))
															#line 6259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
				break;
			}
			else
			{
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority < TransactionPriority::IMMEDIATE && !normalRateInfo.canStart(transactionsStarted[0] + transactionsStarted[1], tc))
															#line 6267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
					break;
				}
			}
															#line 973 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.debugID.present())
															#line 6274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 974 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (!debugID.present())
															#line 6278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 975 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					debugID = nondeterministicRandom()->randomUniqueID();
															#line 6282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				g_traceBatch.addAttach("TransactionAttachID", req.debugID.get().first(), debugID.get().first());
															#line 6286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 979 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			transactionsStarted[req.flags & 1] += tc;
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			double currentTime = g_network->timer();
															#line 981 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority >= TransactionPriority::IMMEDIATE)
															#line 6294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 982 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				systemTransactionsStarted[req.flags & 1] += tc;
															#line 983 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				--grvProxyData->stats.systemGRVQueueSize;
															#line 6300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 984 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority >= TransactionPriority::DEFAULT)
															#line 6306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 985 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					defaultPriTransactionsStarted[req.flags & 1] += tc;
															#line 986 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					grvProxyData->stats.defaultTxnGRVTimeInQueue.addMeasurement(currentTime - req.requestTime());
															#line 987 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					--grvProxyData->stats.defaultGRVQueueSize;
															#line 6314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
				else
				{
															#line 989 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					batchPriTransactionsStarted[req.flags & 1] += tc;
															#line 990 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					grvProxyData->stats.batchTxnGRVTimeInQueue.addMeasurement(currentTime - req.requestTime());
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					--grvProxyData->stats.batchGRVQueueSize;
															#line 6324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			for( auto tag : req.tags ) {
															#line 994 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				transactionTagCounter[tag.first] += tag.second;
															#line 6331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 996 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			start[req.flags & 1].push_back(std::move(req));
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			static_assert(GetReadVersionRequest::FLAG_CAUSAL_READ_RISKY == 1, "Implementation dependent on flag value");
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			transactionQueue->pop_front();
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			requestsToStart++;
															#line 6341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1001 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!batchQueue.empty())
															#line 6345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1002 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!grvProxyData->stats.lastBatchQueueThrottled)
															#line 6349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1003 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.lastBatchQueueThrottled = true;
															#line 1004 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.batchThrottleStartTime = now();
															#line 6355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
		else
		{
															#line 1007 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->stats.lastBatchQueueThrottled = false;
															#line 6362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!defaultQueue.empty())
															#line 6366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1010 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!grvProxyData->stats.lastDefaultQueueThrottled)
															#line 6370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.lastDefaultQueueThrottled = true;
															#line 1012 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.defaultThrottleStartTime = now();
															#line 6376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
		else
		{
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->stats.lastDefaultQueueThrottled = false;
															#line 6383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1018 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!systemQueue.empty() || !defaultQueue.empty() || !batchQueue.empty())
															#line 6387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1019 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			forwardPromise( GRVTimer, delayJittered(SERVER_KNOBS->START_TRANSACTION_BATCH_QUEUE_CHECK_INTERVAL, TaskPriority::ProxyGRVTimer));
															#line 6391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1036 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int systemTotalStarted = systemTransactionsStarted[0] + systemTransactionsStarted[1];
															#line 1037 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int normalTotalStarted = defaultPriTransactionsStarted[0] + defaultPriTransactionsStarted[1];
															#line 1038 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchTotalStarted = batchPriTransactionsStarted[0] + batchPriTransactionsStarted[1];
															#line 1040 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionCount += transactionsStarted[0] + transactionsStarted[1];
															#line 1041 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionCount += batchTotalStarted;
															#line 1043 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		normalRateInfo.endReleaseWindow( systemTotalStarted + normalTotalStarted, systemQueue.empty() && defaultQueue.empty(), elapsed);
															#line 1045 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchRateInfo.endReleaseWindow(systemTotalStarted + normalTotalStarted + batchTotalStarted, systemQueue.empty() && defaultQueue.empty() && batchQueue.empty(), elapsed);
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 6409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1050 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", debugID.get().first(), "GrvProxyServer.transactionStarter.AskLiveCommittedVersionFromMaster");
															#line 6413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1055 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int defaultGRVProcessed = 0;
															#line 1056 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchGRVProcessed = 0;
															#line 1057 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for(int i = 0;i < start.size();i++) {
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (start[i].size())
															#line 6423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				std::vector<SpanContext> spanContexts;
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				spanContexts.reserve(start[i].size());
															#line 1061 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				for( const GetReadVersionRequest& request : start[i] ) {
															#line 1062 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					spanContexts.push_back(request.spanContext);
															#line 6433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 1065 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				Future<GetReadVersionReply> readVersionReply = getLiveCommittedVersion(spanContexts, grvProxyData, i, debugID, transactionsStarted[i], systemTransactionsStarted[i], defaultPriTransactionsStarted[i], batchPriTransactionsStarted[i]);
															#line 1073 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				addActor.send(sendGrvReplies(readVersionReply, start[i], grvProxyData, &grvProxyData->stats, grvProxyData->minKnownCommittedVersion, clientThrottledTags, midShardSize));
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (i == 0)
															#line 6441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 1083 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					addActor.send(timeReply(readVersionReply, normalGRVLatency));
															#line 6445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 1085 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				defaultGRVProcessed += defaultPriTransactionsStarted[i];
															#line 1086 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				batchGRVProcessed += batchPriTransactionsStarted[i];
															#line 6451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
															#line 1090 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.percentageOfDefaultGRVQueueProcessed = defaultQueueSize ? (double)defaultGRVProcessed / defaultQueueSize : 1;
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.percentageOfBatchGRVQueueProcessed = batchQueueSize ? (double)batchGRVProcessed / batchQueueSize : 1;
															#line 6458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double t = now();
															#line 920 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double elapsed = now() - lastGRVTime;
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		lastGRVTime = t;
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (elapsed == 0)
															#line 6473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 925 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			elapsed = 1e-15;
															#line 6477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 928 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.update(grvProxyData->tagThrottler.releaseTransactions(elapsed, batchQueue, defaultQueue));
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		normalRateInfo.startReleaseWindow();
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchRateInfo.startReleaseWindow();
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.transactionLimit = normalRateInfo.getLimit();
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.batchTransactionLimit = batchRateInfo.getLimit();
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int transactionsStarted[2] = { 0, 0 };
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int systemTransactionsStarted[2] = { 0, 0 };
															#line 938 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int defaultPriTransactionsStarted[2] = { 0, 0 };
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchPriTransactionsStarted[2] = { 0, 0 };
															#line 941 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		std::vector<std::vector<GetReadVersionRequest>> start( 2);
															#line 944 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		Optional<UID> debugID;
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int requestsToStart = 0;
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		uint32_t defaultQueueSize = defaultQueue.size();
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		uint32_t batchQueueSize = batchQueue.size();
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for(;requestsToStart < SERVER_KNOBS->START_TRANSACTION_MAX_REQUESTS_TO_START;) {
															#line 951 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Deque<GetReadVersionRequest>* transactionQueue;
															#line 952 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!systemQueue.empty())
															#line 6513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				transactionQueue = &systemQueue;
															#line 6517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 954 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (!defaultQueue.empty())
															#line 6523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					transactionQueue = &defaultQueue;
															#line 6527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
				else
				{
															#line 956 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue.empty())
															#line 6533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 957 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						transactionQueue = &batchQueue;
															#line 6537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
						break;
					}
				}
			}
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			auto& req = transactionQueue->front();
															#line 963 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			int tc = req.transactionCount;
															#line 965 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority < TransactionPriority::DEFAULT && !batchRateInfo.canStart(transactionsStarted[0] + transactionsStarted[1], tc))
															#line 6551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
				break;
			}
			else
			{
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority < TransactionPriority::IMMEDIATE && !normalRateInfo.canStart(transactionsStarted[0] + transactionsStarted[1], tc))
															#line 6559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
					break;
				}
			}
															#line 973 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.debugID.present())
															#line 6566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 974 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (!debugID.present())
															#line 6570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 975 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					debugID = nondeterministicRandom()->randomUniqueID();
															#line 6574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				g_traceBatch.addAttach("TransactionAttachID", req.debugID.get().first(), debugID.get().first());
															#line 6578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 979 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			transactionsStarted[req.flags & 1] += tc;
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			double currentTime = g_network->timer();
															#line 981 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority >= TransactionPriority::IMMEDIATE)
															#line 6586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 982 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				systemTransactionsStarted[req.flags & 1] += tc;
															#line 983 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				--grvProxyData->stats.systemGRVQueueSize;
															#line 6592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 984 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority >= TransactionPriority::DEFAULT)
															#line 6598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 985 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					defaultPriTransactionsStarted[req.flags & 1] += tc;
															#line 986 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					grvProxyData->stats.defaultTxnGRVTimeInQueue.addMeasurement(currentTime - req.requestTime());
															#line 987 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					--grvProxyData->stats.defaultGRVQueueSize;
															#line 6606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
				else
				{
															#line 989 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					batchPriTransactionsStarted[req.flags & 1] += tc;
															#line 990 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					grvProxyData->stats.batchTxnGRVTimeInQueue.addMeasurement(currentTime - req.requestTime());
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					--grvProxyData->stats.batchGRVQueueSize;
															#line 6616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			for( auto tag : req.tags ) {
															#line 994 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				transactionTagCounter[tag.first] += tag.second;
															#line 6623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 996 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			start[req.flags & 1].push_back(std::move(req));
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			static_assert(GetReadVersionRequest::FLAG_CAUSAL_READ_RISKY == 1, "Implementation dependent on flag value");
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			transactionQueue->pop_front();
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			requestsToStart++;
															#line 6633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1001 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!batchQueue.empty())
															#line 6637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1002 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!grvProxyData->stats.lastBatchQueueThrottled)
															#line 6641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1003 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.lastBatchQueueThrottled = true;
															#line 1004 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.batchThrottleStartTime = now();
															#line 6647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
		else
		{
															#line 1007 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->stats.lastBatchQueueThrottled = false;
															#line 6654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!defaultQueue.empty())
															#line 6658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1010 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!grvProxyData->stats.lastDefaultQueueThrottled)
															#line 6662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.lastDefaultQueueThrottled = true;
															#line 1012 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.defaultThrottleStartTime = now();
															#line 6668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
		else
		{
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->stats.lastDefaultQueueThrottled = false;
															#line 6675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1018 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!systemQueue.empty() || !defaultQueue.empty() || !batchQueue.empty())
															#line 6679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1019 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			forwardPromise( GRVTimer, delayJittered(SERVER_KNOBS->START_TRANSACTION_BATCH_QUEUE_CHECK_INTERVAL, TaskPriority::ProxyGRVTimer));
															#line 6683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1036 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int systemTotalStarted = systemTransactionsStarted[0] + systemTransactionsStarted[1];
															#line 1037 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int normalTotalStarted = defaultPriTransactionsStarted[0] + defaultPriTransactionsStarted[1];
															#line 1038 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchTotalStarted = batchPriTransactionsStarted[0] + batchPriTransactionsStarted[1];
															#line 1040 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionCount += transactionsStarted[0] + transactionsStarted[1];
															#line 1041 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionCount += batchTotalStarted;
															#line 1043 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		normalRateInfo.endReleaseWindow( systemTotalStarted + normalTotalStarted, systemQueue.empty() && defaultQueue.empty(), elapsed);
															#line 1045 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchRateInfo.endReleaseWindow(systemTotalStarted + normalTotalStarted + batchTotalStarted, systemQueue.empty() && defaultQueue.empty() && batchQueue.empty(), elapsed);
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 6701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1050 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", debugID.get().first(), "GrvProxyServer.transactionStarter.AskLiveCommittedVersionFromMaster");
															#line 6705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1055 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int defaultGRVProcessed = 0;
															#line 1056 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchGRVProcessed = 0;
															#line 1057 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for(int i = 0;i < start.size();i++) {
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (start[i].size())
															#line 6715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				std::vector<SpanContext> spanContexts;
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				spanContexts.reserve(start[i].size());
															#line 1061 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				for( const GetReadVersionRequest& request : start[i] ) {
															#line 1062 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					spanContexts.push_back(request.spanContext);
															#line 6725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 1065 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				Future<GetReadVersionReply> readVersionReply = getLiveCommittedVersion(spanContexts, grvProxyData, i, debugID, transactionsStarted[i], systemTransactionsStarted[i], defaultPriTransactionsStarted[i], batchPriTransactionsStarted[i]);
															#line 1073 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				addActor.send(sendGrvReplies(readVersionReply, start[i], grvProxyData, &grvProxyData->stats, grvProxyData->minKnownCommittedVersion, clientThrottledTags, midShardSize));
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (i == 0)
															#line 6733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 1083 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					addActor.send(timeReply(readVersionReply, normalGRVLatency));
															#line 6737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 1085 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				defaultGRVProcessed += defaultPriTransactionsStarted[i];
															#line 1086 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				batchGRVProcessed += batchPriTransactionsStarted[i];
															#line 6743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
															#line 1090 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.percentageOfDefaultGRVQueueProcessed = defaultQueueSize ? (double)defaultGRVProcessed / defaultQueueSize : 1;
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.percentageOfBatchGRVQueueProcessed = batchQueueSize ? (double)batchGRVProcessed / batchQueueSize : 1;
															#line 6750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TransactionStarterActor*>(this)->actor_wait_state > 0) static_cast<TransactionStarterActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionStarterActor*>(this)->ActorSingleCallback< TransactionStarterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< TransactionStarterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< TransactionStarterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< TransactionStarterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface proxy;
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* healthMetricsReply;
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* detailedHealthMetricsReply;
															#line 855 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double lastGRVTime;
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Void> GRVTimer;
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double GRVBatchTime;
															#line 859 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t transactionCount;
															#line 860 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t batchTransactionCount;
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo normalRateInfo;
															#line 864 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo batchRateInfo;
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest> systemQueue;
															#line 869 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest> defaultQueue;
															#line 870 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest> batchQueue;
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	TransactionTagMap<uint64_t> transactionTagCounter;
															#line 873 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PrioritizedTransactionTagMap<ClientTagThrottleLimits> clientThrottledTags;
															#line 875 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<double> normalGRVLatency;
															#line 877 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t midShardSize;
															#line 6870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via transactionStarter()
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class TransactionStarterActor final : public Actor<Void>, public ActorCallback< TransactionStarterActor, 0, Void >, public ActorSingleCallback< TransactionStarterActor, 1, Void >, public FastAllocated<TransactionStarterActor>, public TransactionStarterActorState<TransactionStarterActor> {
															#line 6875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<TransactionStarterActor>::operator new;
	using FastAllocated<TransactionStarterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8009002988159687936UL, 7128663861221672192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TransactionStarterActor, 0, Void >;
friend struct ActorSingleCallback< TransactionStarterActor, 1, Void >;
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	TransactionStarterActor(GrvProxyInterface const& proxy,Reference<AsyncVar<ServerDBInfo> const> const& db,PromiseStream<Future<Void>> const& addActor,GrvProxyData* const& grvProxyData,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply) 
															#line 6893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   TransactionStarterActorState<TransactionStarterActor>(proxy, db, addActor, grvProxyData, healthMetricsReply, detailedHealthMetricsReply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10700198538979324160UL, 3557432467917975808UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("transactionStarter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TransactionStarterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< TransactionStarterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> transactionStarter( GrvProxyInterface const& proxy, Reference<AsyncVar<ServerDBInfo> const> const& db, PromiseStream<Future<Void>> const& addActor, GrvProxyData* const& grvProxyData, GetHealthMetricsReply* const& healthMetricsReply, GetHealthMetricsReply* const& detailedHealthMetricsReply ) {
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new TransactionStarterActor(proxy, db, addActor, grvProxyData, healthMetricsReply, detailedHealthMetricsReply));
															#line 6927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 1096 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 6932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via grvProxyServerCore()
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GrvProxyServerCoreActor>
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GrvProxyServerCoreActorState {
															#line 6939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyServerCoreActorState(GrvProxyInterface const& proxy,MasterInterface const& master,LifetimeToken const& masterLifetime,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   master(master),
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   masterLifetime(masterLifetime),
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db),
															#line 1101 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxyData(proxy.id(), master, proxy.getConsistentReadVersion, db),
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   addActor(),
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   onError(actorCollection(addActor.getFuture())),
															#line 1106 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   healthMetricsReply(),
															#line 1107 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   detailedHealthMetricsReply()
															#line 6962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("grvProxyServerCore", reinterpret_cast<unsigned long>(this));

	}
	~GrvProxyServerCoreActorState() 
	{
		fdb_probe_actor_destroy("grvProxyServerCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1109 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(waitFailureServer(proxy.waitFailure.getFuture()));
															#line 1110 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(traceRole(Role::GRV_PROXY, proxy.id()));
															#line 1112 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("GrvProxyServerCore", proxy.id()) .detail("MasterId", master.id()) .detail("MasterLifetime", masterLifetime.toString()) .detail("RecoveryCount", db->get().recoveryCount);
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 6983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GrvProxyServerCoreActorState();
		static_cast<GrvProxyServerCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1123 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		dbInfoChange = grvProxyData.db->onChange();
															#line 1124 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), grvProxyData.db->get(), false, addActor);
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData.updateLatencyBandConfig(grvProxyData.db->get().latencyBandConfig);
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		addActor.send(transactionStarter( proxy, grvProxyData.db, addActor, &grvProxyData, &healthMetricsReply, &detailedHealthMetricsReply));
															#line 1130 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		addActor.send(healthMetricsRequestServer(proxy, &healthMetricsReply, &detailedHealthMetricsReply));
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		addActor.send(globalConfigRequestServer(&grvProxyData, proxy));
															#line 1133 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION > 0)
															#line 7018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1134 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(lastCommitUpdater(&grvProxyData, addActor));
															#line 7022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1137 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		;
															#line 7026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!(!(masterLifetime.isEqual(grvProxyData.db->get().masterLifetime) && grvProxyData.db->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS)))
															#line 7042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = grvProxyData.db->onChange();
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state = 1;
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GrvProxyServerCoreActor, 0, Void >*>(static_cast<GrvProxyServerCoreActor*>(this)));
															#line 7055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state > 0) static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state = 0;
		static_cast<GrvProxyServerCoreActor*>(this)->ActorCallback< GrvProxyServerCoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GrvProxyServerCoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = dbInfoChange;
															#line 1137 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 1148 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = onError;
															#line 7177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state = 2;
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GrvProxyServerCoreActor, 1, Void >*>(static_cast<GrvProxyServerCoreActor*>(this)));
															#line 1148 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GrvProxyServerCoreActor, 2, Void >*>(static_cast<GrvProxyServerCoreActor*>(this)));
															#line 7184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1139 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		dbInfoChange = grvProxyData.db->onChange();
															#line 1141 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (masterLifetime.isEqual(grvProxyData.db->get().masterLifetime) && grvProxyData.db->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION)
															#line 7201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1143 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), grvProxyData.db->get(), false, addActor);
															#line 7205 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1146 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData.updateLatencyBandConfig(grvProxyData.db->get().latencyBandConfig);
															#line 7209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1139 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		dbInfoChange = grvProxyData.db->onChange();
															#line 1141 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (masterLifetime.isEqual(grvProxyData.db->get().masterLifetime) && grvProxyData.db->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION)
															#line 7220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1143 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), grvProxyData.db->get(), false, addActor);
															#line 7224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1146 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData.updateLatencyBandConfig(grvProxyData.db->get().latencyBandConfig);
															#line 7228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state > 0) static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state = 0;
		static_cast<GrvProxyServerCoreActor*>(this)->ActorCallback< GrvProxyServerCoreActor, 1, Void >::remove();
		static_cast<GrvProxyServerCoreActor*>(this)->ActorCallback< GrvProxyServerCoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GrvProxyServerCoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GrvProxyServerCoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface proxy;
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	MasterInterface master;
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	LifetimeToken masterLifetime;
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1101 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData grvProxyData;
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> onError;
															#line 1106 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply healthMetricsReply;
															#line 1107 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply detailedHealthMetricsReply;
															#line 1123 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> dbInfoChange;
															#line 7386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via grvProxyServerCore()
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GrvProxyServerCoreActor final : public Actor<Void>, public ActorCallback< GrvProxyServerCoreActor, 0, Void >, public ActorCallback< GrvProxyServerCoreActor, 1, Void >, public ActorCallback< GrvProxyServerCoreActor, 2, Void >, public FastAllocated<GrvProxyServerCoreActor>, public GrvProxyServerCoreActorState<GrvProxyServerCoreActor> {
															#line 7391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GrvProxyServerCoreActor>::operator new;
	using FastAllocated<GrvProxyServerCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9250782908098323456UL, 9712039773009802240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GrvProxyServerCoreActor, 0, Void >;
friend struct ActorCallback< GrvProxyServerCoreActor, 1, Void >;
friend struct ActorCallback< GrvProxyServerCoreActor, 2, Void >;
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyServerCoreActor(GrvProxyInterface const& proxy,MasterInterface const& master,LifetimeToken const& masterLifetime,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 7410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GrvProxyServerCoreActorState<GrvProxyServerCoreActor>(proxy, master, masterLifetime, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6046041477836266752UL, 214675386595290880UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("grvProxyServerCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GrvProxyServerCoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GrvProxyServerCoreActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> grvProxyServerCore( GrvProxyInterface const& proxy, MasterInterface const& master, LifetimeToken const& masterLifetime, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GrvProxyServerCoreActor(proxy, master, masterLifetime, db));
															#line 7444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 1151 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 7449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via checkRemoved()
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class CheckRemovedActor>
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class CheckRemovedActorState {
															#line 7456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	CheckRemovedActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,uint64_t const& recoveryCount,GrvProxyInterface const& myInterface) 
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : db(db),
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   recoveryCount(recoveryCount),
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   myInterface(myInterface)
															#line 7467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("checkRemoved", reinterpret_cast<unsigned long>(this));

	}
	~CheckRemovedActorState() 
	{
		fdb_probe_actor_destroy("checkRemoved", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1155 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 7482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckRemovedActorState();
		static_cast<CheckRemovedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1156 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().recoveryCount >= recoveryCount && std::find(db->get().client.grvProxies.begin(), db->get().client.grvProxies.end(), myInterface) == db->get().client.grvProxies.end())
															#line 7512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1159 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 7516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1161 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 1161 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<CheckRemovedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckRemovedActor*>(this)->actor_wait_state = 1;
															#line 1161 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckRemovedActor, 0, Void >*>(static_cast<CheckRemovedActor*>(this)));
															#line 7527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckRemovedActor*>(this)->actor_wait_state > 0) static_cast<CheckRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRemovedActor*>(this)->ActorCallback< CheckRemovedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRemovedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckRemovedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckRemovedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	uint64_t recoveryCount;
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface myInterface;
															#line 7625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via checkRemoved()
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class CheckRemovedActor final : public Actor<Void>, public ActorCallback< CheckRemovedActor, 0, Void >, public FastAllocated<CheckRemovedActor>, public CheckRemovedActorState<CheckRemovedActor> {
															#line 7630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<CheckRemovedActor>::operator new;
	using FastAllocated<CheckRemovedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1223928105225223936UL, 13007296679825793280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckRemovedActor, 0, Void >;
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	CheckRemovedActor(Reference<AsyncVar<ServerDBInfo> const> const& db,uint64_t const& recoveryCount,GrvProxyInterface const& myInterface) 
															#line 7647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   CheckRemovedActorState<CheckRemovedActor>(db, recoveryCount, myInterface),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15518436168711072512UL, 6662910151609573120UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkRemoved");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckRemovedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> checkRemoved( Reference<AsyncVar<ServerDBInfo> const> const& db, uint64_t const& recoveryCount, GrvProxyInterface const& myInterface ) {
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new CheckRemovedActor(db, recoveryCount, myInterface));
															#line 7680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 1164 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 7685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via grvProxyServer()
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GrvProxyServerActor>
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GrvProxyServerActorState {
															#line 7692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyServerActorState(GrvProxyInterface const& proxy,InitializeGrvProxyRequest const& req,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   req(req),
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db)
															#line 7703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("grvProxyServer", reinterpret_cast<unsigned long>(this));

	}
	~GrvProxyServerActorState() 
	{
		fdb_probe_actor_destroy("grvProxyServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1169 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				core = grvProxyServerCore(proxy, req.master, req.masterLifetime, db);
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = core || checkRemoved(db, req.recoveryCount, proxy);
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (static_cast<GrvProxyServerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GrvProxyServerActor*>(this)->actor_wait_state = 1;
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GrvProxyServerActor, 0, Void >*>(static_cast<GrvProxyServerActor*>(this)));
															#line 7728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GrvProxyServerActorState();
		static_cast<GrvProxyServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1184 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GrvProxyServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GrvProxyServerActorState(); static_cast<GrvProxyServerActor*>(this)->destroy(); return 0; }
															#line 7757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GrvProxyServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GrvProxyServerActorState();
		static_cast<GrvProxyServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("GrvProxyTerminated", proxy.id()).errorUnsuppressed(e);
															#line 1173 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			ASSERT(e.code() != error_code_broken_promise);
															#line 1175 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			CODE_PROBE(e.code() == error_code_master_failed, "GrvProxyServer master failed");
															#line 1176 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			CODE_PROBE(e.code() == error_code_tlog_failed, "GrvProxyServer tlog failed");
															#line 1177 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (e.code() != error_code_worker_removed && e.code() != error_code_tlog_stopped && e.code() != error_code_tlog_failed && e.code() != error_code_coordinators_changed && e.code() != error_code_coordinated_state_conflict && e.code() != error_code_new_coordinators_timed_out && e.code() != error_code_master_failed)
															#line 7778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1181 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 7782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GrvProxyServerActor*>(this)->actor_wait_state > 0) static_cast<GrvProxyServerActor*>(this)->actor_wait_state = 0;
		static_cast<GrvProxyServerActor*>(this)->ActorCallback< GrvProxyServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GrvProxyServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GrvProxyServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface proxy;
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	InitializeGrvProxyRequest req;
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1169 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> core;
															#line 7902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via grvProxyServer()
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GrvProxyServerActor final : public Actor<Void>, public ActorCallback< GrvProxyServerActor, 0, Void >, public FastAllocated<GrvProxyServerActor>, public GrvProxyServerActorState<GrvProxyServerActor> {
															#line 7907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GrvProxyServerActor>::operator new;
	using FastAllocated<GrvProxyServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17607870031197260800UL, 8472446375332268032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GrvProxyServerActor, 0, Void >;
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyServerActor(GrvProxyInterface const& proxy,InitializeGrvProxyRequest const& req,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 7924 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GrvProxyServerActorState<GrvProxyServerActor>(proxy, req, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("grvProxyServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13905335545483414272UL, 8240318245689050112UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("grvProxyServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("grvProxyServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GrvProxyServerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> grvProxyServer( GrvProxyInterface const& proxy, InitializeGrvProxyRequest const& req, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GrvProxyServerActor(proxy, req, db));
															#line 7957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 1186 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
