#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
/*
 * BlobRestoreController.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "fdbclient/BlobGranuleCommon.h"
#include "fdbclient/BlobRestoreCommon.h"
#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/BlobGranuleServerCommon.actor.h"

#include "flow/IRandom.h"
#include "flow/actorcompiler.h" // has to be last include

//
// This module offers routines to manage blob restore state for given range.
//

// Return true if the given key range is restoring. It returns true even if part of the key range is restoring
															#line 38 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
// This generated class is to be used only via isRestoring()
															#line 36 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
template <class BlobRestoreController_IsRestoringActor>
															#line 36 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_IsRestoringActorState {
															#line 44 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
															#line 36 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_IsRestoringActorState(Reference<BlobRestoreController> const& self) 
															#line 36 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
															#line 36 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		 : self(self)
															#line 51 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
	{
		fdb_probe_actor_create("isRestoring", reinterpret_cast<unsigned long>(this));

	}
	~BlobRestoreController_IsRestoringActorState() 
	{
		fdb_probe_actor_destroy("isRestoring", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 37 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			StrictFuture<BlobRestorePhase> __when_expr_0 = BlobRestoreController::currentPhase(self);
															#line 37 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (static_cast<BlobRestoreController_IsRestoringActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 68 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BlobRestoreController_IsRestoringActor*>(this)->actor_wait_state = 1;
															#line 37 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_IsRestoringActor, 0, BlobRestorePhase >*>(static_cast<BlobRestoreController_IsRestoringActor*>(this)));
															#line 73 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobRestoreController_IsRestoringActorState();
		static_cast<BlobRestoreController_IsRestoringActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(BlobRestorePhase const& phase,int loopDepth) 
	{
															#line 38 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!self->range_.intersects(normalKeys))
															#line 96 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		{
															#line 39 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (!static_cast<BlobRestoreController_IsRestoringActor*>(this)->SAV<bool>::futures) { (void)(false); this->~BlobRestoreController_IsRestoringActorState(); static_cast<BlobRestoreController_IsRestoringActor*>(this)->destroy(); return 0; }
															#line 100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			new (&static_cast<BlobRestoreController_IsRestoringActor*>(this)->SAV< bool >::value()) bool(false);
			this->~BlobRestoreController_IsRestoringActorState();
			static_cast<BlobRestoreController_IsRestoringActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 41 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (phase < BlobRestorePhase::INIT || phase == BlobRestorePhase::DONE)
															#line 108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		{
															#line 42 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (!static_cast<BlobRestoreController_IsRestoringActor*>(this)->SAV<bool>::futures) { (void)(false); this->~BlobRestoreController_IsRestoringActorState(); static_cast<BlobRestoreController_IsRestoringActor*>(this)->destroy(); return 0; }
															#line 112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			new (&static_cast<BlobRestoreController_IsRestoringActor*>(this)->SAV< bool >::value()) bool(false);
			this->~BlobRestoreController_IsRestoringActorState();
			static_cast<BlobRestoreController_IsRestoringActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 44 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_IsRestoringActor*>(this)->SAV<bool>::futures) { (void)(true); this->~BlobRestoreController_IsRestoringActorState(); static_cast<BlobRestoreController_IsRestoringActor*>(this)->destroy(); return 0; }
															#line 120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_IsRestoringActor*>(this)->SAV< bool >::value()) bool(true);
		this->~BlobRestoreController_IsRestoringActorState();
		static_cast<BlobRestoreController_IsRestoringActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(BlobRestorePhase && phase,int loopDepth) 
	{
															#line 38 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!self->range_.intersects(normalKeys))
															#line 132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		{
															#line 39 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (!static_cast<BlobRestoreController_IsRestoringActor*>(this)->SAV<bool>::futures) { (void)(false); this->~BlobRestoreController_IsRestoringActorState(); static_cast<BlobRestoreController_IsRestoringActor*>(this)->destroy(); return 0; }
															#line 136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			new (&static_cast<BlobRestoreController_IsRestoringActor*>(this)->SAV< bool >::value()) bool(false);
			this->~BlobRestoreController_IsRestoringActorState();
			static_cast<BlobRestoreController_IsRestoringActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 41 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (phase < BlobRestorePhase::INIT || phase == BlobRestorePhase::DONE)
															#line 144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		{
															#line 42 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (!static_cast<BlobRestoreController_IsRestoringActor*>(this)->SAV<bool>::futures) { (void)(false); this->~BlobRestoreController_IsRestoringActorState(); static_cast<BlobRestoreController_IsRestoringActor*>(this)->destroy(); return 0; }
															#line 148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			new (&static_cast<BlobRestoreController_IsRestoringActor*>(this)->SAV< bool >::value()) bool(false);
			this->~BlobRestoreController_IsRestoringActorState();
			static_cast<BlobRestoreController_IsRestoringActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 44 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_IsRestoringActor*>(this)->SAV<bool>::futures) { (void)(true); this->~BlobRestoreController_IsRestoringActorState(); static_cast<BlobRestoreController_IsRestoringActor*>(this)->destroy(); return 0; }
															#line 156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_IsRestoringActor*>(this)->SAV< bool >::value()) bool(true);
		this->~BlobRestoreController_IsRestoringActorState();
		static_cast<BlobRestoreController_IsRestoringActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(BlobRestorePhase const& phase,int loopDepth) 
	{
		loopDepth = a_body1cont1(phase, loopDepth);

		return loopDepth;
	}
	int a_body1when1(BlobRestorePhase && phase,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(phase), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobRestoreController_IsRestoringActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_IsRestoringActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_IsRestoringActor*>(this)->ActorCallback< BlobRestoreController_IsRestoringActor, 0, BlobRestorePhase >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_IsRestoringActor, 0, BlobRestorePhase >*,BlobRestorePhase const& value) 
	{
		fdb_probe_actor_enter("isRestoring", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_IsRestoringActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isRestoring", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_IsRestoringActor, 0, BlobRestorePhase >*,BlobRestorePhase && value) 
	{
		fdb_probe_actor_enter("isRestoring", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_IsRestoringActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isRestoring", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_IsRestoringActor, 0, BlobRestorePhase >*,Error err) 
	{
		fdb_probe_actor_enter("isRestoring", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_IsRestoringActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isRestoring", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 36 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	Reference<BlobRestoreController> self;
															#line 241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
};
// This generated class is to be used only via isRestoring()
															#line 36 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_IsRestoringActor final : public Actor<bool>, public ActorCallback< BlobRestoreController_IsRestoringActor, 0, BlobRestorePhase >, public FastAllocated<BlobRestoreController_IsRestoringActor>, public BlobRestoreController_IsRestoringActorState<BlobRestoreController_IsRestoringActor> {
															#line 246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
	using FastAllocated<BlobRestoreController_IsRestoringActor>::operator new;
	using FastAllocated<BlobRestoreController_IsRestoringActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1387537239268722432UL, 15508479884467479296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobRestoreController_IsRestoringActor, 0, BlobRestorePhase >;
															#line 36 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_IsRestoringActor(Reference<BlobRestoreController> const& self) 
															#line 263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		 : Actor<bool>(),
		   BlobRestoreController_IsRestoringActorState<BlobRestoreController_IsRestoringActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("isRestoring", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(443616591206809344UL, 10220002922018488320UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_IsRestoringActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("isRestoring");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("isRestoring", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobRestoreController_IsRestoringActor, 0, BlobRestorePhase >*)0, actor_cancelled()); break;
		}

	}
};
															#line 36 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
[[nodiscard]] Future<bool> BlobRestoreController::isRestoring( Reference<BlobRestoreController> const& self ) {
															#line 36 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	return Future<bool>(new BlobRestoreController_IsRestoringActor(self));
															#line 295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
}

#line 46 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"

// Get restore target version. Return defaultVersion if no restore argument available for the range
															#line 301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
// This generated class is to be used only via getTargetVersion()
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
template <class BlobRestoreController_GetTargetVersionActor>
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_GetTargetVersionActorState {
															#line 307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_GetTargetVersionActorState(Reference<BlobRestoreController> const& self,Version const& defaultVersion) 
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		 : self(self),
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		   defaultVersion(defaultVersion)
															#line 316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
	{
		fdb_probe_actor_create("getTargetVersion", reinterpret_cast<unsigned long>(this));

	}
	~BlobRestoreController_GetTargetVersionActorState() 
	{
		fdb_probe_actor_destroy("getTargetVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 51 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			BlobGranuleRestoreConfig config;
															#line 52 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			StrictFuture<Version> __when_expr_0 = config.targetVersion().getD(SystemDBWriteLockedNow(self->db_.getReference()));
															#line 52 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->actor_wait_state = 1;
															#line 52 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_GetTargetVersionActor, 0, Version >*>(static_cast<BlobRestoreController_GetTargetVersionActor*>(this)));
															#line 340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobRestoreController_GetTargetVersionActorState();
		static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Version const& version,int loopDepth) 
	{
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~BlobRestoreController_GetTargetVersionActorState(); static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->destroy(); return 0; }
															#line 363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->SAV< Version >::value()) Version(version);
		this->~BlobRestoreController_GetTargetVersionActorState();
		static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Version && version,int loopDepth) 
	{
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~BlobRestoreController_GetTargetVersionActorState(); static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->destroy(); return 0; }
															#line 375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->SAV< Version >::value()) Version(version);
		this->~BlobRestoreController_GetTargetVersionActorState();
		static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1cont1(version, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->ActorCallback< BlobRestoreController_GetTargetVersionActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_GetTargetVersionActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getTargetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTargetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_GetTargetVersionActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getTargetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTargetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_GetTargetVersionActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getTargetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTargetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	Reference<BlobRestoreController> self;
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	Version defaultVersion;
															#line 462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
};
// This generated class is to be used only via getTargetVersion()
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_GetTargetVersionActor final : public Actor<Version>, public ActorCallback< BlobRestoreController_GetTargetVersionActor, 0, Version >, public FastAllocated<BlobRestoreController_GetTargetVersionActor>, public BlobRestoreController_GetTargetVersionActorState<BlobRestoreController_GetTargetVersionActor> {
															#line 467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
	using FastAllocated<BlobRestoreController_GetTargetVersionActor>::operator new;
	using FastAllocated<BlobRestoreController_GetTargetVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13098931820037348096UL, 4120879543613238784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobRestoreController_GetTargetVersionActor, 0, Version >;
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_GetTargetVersionActor(Reference<BlobRestoreController> const& self,Version const& defaultVersion) 
															#line 484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		 : Actor<Version>(),
		   BlobRestoreController_GetTargetVersionActorState<BlobRestoreController_GetTargetVersionActor>(self, defaultVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTargetVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13441929407143546112UL, 17228936866798269696UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_GetTargetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTargetVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTargetVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobRestoreController_GetTargetVersionActor, 0, Version >*)0, actor_cancelled()); break;
		}

	}
};
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
[[nodiscard]] Future<Version> BlobRestoreController::getTargetVersion( Reference<BlobRestoreController> const& self, Version const& defaultVersion ) {
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	return Future<Version>(new BlobRestoreController_GetTargetVersionActor(self, defaultVersion));
															#line 516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
}

#line 55 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"

// Get current restore phase
															#line 522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
// This generated class is to be used only via currentPhase()
															#line 57 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
template <class BlobRestoreController_CurrentPhaseActor>
															#line 57 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_CurrentPhaseActorState {
															#line 528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
															#line 57 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_CurrentPhaseActorState(Reference<BlobRestoreController> const& self) 
															#line 57 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
															#line 57 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		 : self(self)
															#line 535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
	{
		fdb_probe_actor_create("currentPhase", reinterpret_cast<unsigned long>(this));

	}
	~BlobRestoreController_CurrentPhaseActorState() 
	{
		fdb_probe_actor_destroy("currentPhase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			BlobGranuleRestoreConfig config;
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			auto db = SystemDBWriteLockedNow(self->db_.getReference());
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			StrictFuture<BlobRestorePhase> __when_expr_0 = config.phase().getD(db, Snapshot::False, BlobRestorePhase::UNINIT);
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->actor_wait_state = 1;
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_CurrentPhaseActor, 0, BlobRestorePhase >*>(static_cast<BlobRestoreController_CurrentPhaseActor*>(this)));
															#line 561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobRestoreController_CurrentPhaseActorState();
		static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(BlobRestorePhase const& phase,int loopDepth) 
	{
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->SAV<BlobRestorePhase>::futures) { (void)(phase); this->~BlobRestoreController_CurrentPhaseActorState(); static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->destroy(); return 0; }
															#line 584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->SAV< BlobRestorePhase >::value()) BlobRestorePhase(phase);
		this->~BlobRestoreController_CurrentPhaseActorState();
		static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(BlobRestorePhase && phase,int loopDepth) 
	{
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->SAV<BlobRestorePhase>::futures) { (void)(phase); this->~BlobRestoreController_CurrentPhaseActorState(); static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->destroy(); return 0; }
															#line 596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->SAV< BlobRestorePhase >::value()) BlobRestorePhase(phase);
		this->~BlobRestoreController_CurrentPhaseActorState();
		static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(BlobRestorePhase const& phase,int loopDepth) 
	{
		loopDepth = a_body1cont1(phase, loopDepth);

		return loopDepth;
	}
	int a_body1when1(BlobRestorePhase && phase,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(phase), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->ActorCallback< BlobRestoreController_CurrentPhaseActor, 0, BlobRestorePhase >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_CurrentPhaseActor, 0, BlobRestorePhase >*,BlobRestorePhase const& value) 
	{
		fdb_probe_actor_enter("currentPhase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("currentPhase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_CurrentPhaseActor, 0, BlobRestorePhase >*,BlobRestorePhase && value) 
	{
		fdb_probe_actor_enter("currentPhase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("currentPhase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_CurrentPhaseActor, 0, BlobRestorePhase >*,Error err) 
	{
		fdb_probe_actor_enter("currentPhase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("currentPhase", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 57 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	Reference<BlobRestoreController> self;
															#line 681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
};
// This generated class is to be used only via currentPhase()
															#line 57 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_CurrentPhaseActor final : public Actor<BlobRestorePhase>, public ActorCallback< BlobRestoreController_CurrentPhaseActor, 0, BlobRestorePhase >, public FastAllocated<BlobRestoreController_CurrentPhaseActor>, public BlobRestoreController_CurrentPhaseActorState<BlobRestoreController_CurrentPhaseActor> {
															#line 686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
	using FastAllocated<BlobRestoreController_CurrentPhaseActor>::operator new;
	using FastAllocated<BlobRestoreController_CurrentPhaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9835471862606747392UL, 5034873449062556928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BlobRestorePhase>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobRestoreController_CurrentPhaseActor, 0, BlobRestorePhase >;
															#line 57 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_CurrentPhaseActor(Reference<BlobRestoreController> const& self) 
															#line 703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		 : Actor<BlobRestorePhase>(),
		   BlobRestoreController_CurrentPhaseActorState<BlobRestoreController_CurrentPhaseActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("currentPhase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16532786607500197888UL, 1704781393285393920UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_CurrentPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("currentPhase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("currentPhase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobRestoreController_CurrentPhaseActor, 0, BlobRestorePhase >*)0, actor_cancelled()); break;
		}

	}
};
															#line 57 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
[[nodiscard]] Future<BlobRestorePhase> BlobRestoreController::currentPhase( Reference<BlobRestoreController> const& self ) {
															#line 57 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	return Future<BlobRestorePhase>(new BlobRestoreController_CurrentPhaseActor(self));
															#line 735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
}

#line 63 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"

// Set current restore phase
															#line 741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
// This generated class is to be used only via setPhase()
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
template <class BlobRestoreController_SetPhaseActor>
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_SetPhaseActorState {
															#line 747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_SetPhaseActorState(Reference<BlobRestoreController> const& self,BlobRestorePhase const& newPhase,Optional<UID> const& owerId) 
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		 : self(self),
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		   newPhase(newPhase),
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		   owerId(owerId),
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		   tr(new ReadYourWritesTransaction(self->db_))
															#line 760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
	{
		fdb_probe_actor_create("setPhase", reinterpret_cast<unsigned long>(this));

	}
	~BlobRestoreController_SetPhaseActorState() 
	{
		fdb_probe_actor_destroy("setPhase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			;
															#line 775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobRestoreController_SetPhaseActorState();
		static_cast<BlobRestoreController_SetPhaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			config = BlobGranuleRestoreConfig();
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			StrictFuture<BlobRestorePhase> __when_expr_0 = config.phase().getD(tr, Snapshot::True, BlobRestorePhase::MAX);
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state = 1;
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_SetPhaseActor, 0, BlobRestorePhase >*>(static_cast<BlobRestoreController_SetPhaseActor*>(this)));
															#line 821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state = 4;
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_SetPhaseActor, 3, Void >*>(static_cast<BlobRestoreController_SetPhaseActor*>(this)));
															#line 850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		StrictFuture<UID> __when_expr_1 = config.lock().getD(tr);
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state = 2;
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_SetPhaseActor, 1, UID >*>(static_cast<BlobRestoreController_SetPhaseActor*>(this)));
															#line 872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(BlobRestorePhase const& __phase,int loopDepth) 
	{
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		phase = __phase;
															#line 881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(BlobRestorePhase && __phase,int loopDepth) 
	{
		phase = std::move(__phase);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_SetPhaseActor*>(this)->ActorCallback< BlobRestoreController_SetPhaseActor, 0, BlobRestorePhase >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetPhaseActor, 0, BlobRestorePhase >*,BlobRestorePhase const& value) 
	{
		fdb_probe_actor_enter("setPhase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPhase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetPhaseActor, 0, BlobRestorePhase >*,BlobRestorePhase && value) 
	{
		fdb_probe_actor_enter("setPhase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPhase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_SetPhaseActor, 0, BlobRestorePhase >*,Error err) 
	{
		fdb_probe_actor_enter("setPhase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPhase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (owerId.present() && currentOwnerId != owerId.get())
															#line 960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		{
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			CODE_PROBE(true, "Blob migrator replaced in setPhase");
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			TraceEvent("BlobMigratorReplaced").detail("Expected", owerId).detail("Current", currentOwnerId);
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			return a_body1loopBody1Catch1(blob_migrator_replaced(), loopDepth);
															#line 968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		}
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (phase > newPhase)
															#line 972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		{
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			CODE_PROBE(true, "Blob migrator unexpected phase");
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			TraceEvent("BlobMigratorUnexpectedPhase").detail("Phase", newPhase).detail("Current", phase);
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			return a_body1loopBody1Catch1(restore_error(), loopDepth);
															#line 980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		}
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (phase != newPhase)
															#line 984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		{
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			config.phaseStartTs().set(tr, newPhase, now());
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			config.phase().set(tr, newPhase);
															#line 990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		}
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state = 3;
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_SetPhaseActor, 2, Void >*>(static_cast<BlobRestoreController_SetPhaseActor*>(this)));
															#line 1001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(UID const& __currentOwnerId,int loopDepth) 
	{
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		currentOwnerId = __currentOwnerId;
															#line 1010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(UID && __currentOwnerId,int loopDepth) 
	{
		currentOwnerId = std::move(__currentOwnerId);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_SetPhaseActor*>(this)->ActorCallback< BlobRestoreController_SetPhaseActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetPhaseActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("setPhase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPhase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetPhaseActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("setPhase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPhase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_SetPhaseActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("setPhase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPhase", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		TraceEvent("BlobRestoreSetPhase").detail("Phase", newPhase);
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_SetPhaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobRestoreController_SetPhaseActorState(); static_cast<BlobRestoreController_SetPhaseActor*>(this)->destroy(); return 0; }
															#line 1091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_SetPhaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BlobRestoreController_SetPhaseActorState();
		static_cast<BlobRestoreController_SetPhaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		TraceEvent("BlobRestoreSetPhase").detail("Phase", newPhase);
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_SetPhaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobRestoreController_SetPhaseActorState(); static_cast<BlobRestoreController_SetPhaseActor*>(this)->destroy(); return 0; }
															#line 1105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_SetPhaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BlobRestoreController_SetPhaseActorState();
		static_cast<BlobRestoreController_SetPhaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_SetPhaseActor*>(this)->ActorCallback< BlobRestoreController_SetPhaseActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetPhaseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setPhase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPhase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetPhaseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setPhase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPhase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_SetPhaseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setPhase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPhase", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_SetPhaseActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_SetPhaseActor*>(this)->ActorCallback< BlobRestoreController_SetPhaseActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetPhaseActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setPhase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPhase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetPhaseActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setPhase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPhase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_SetPhaseActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setPhase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPhase", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	Reference<BlobRestoreController> self;
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestorePhase newPhase;
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	Optional<UID> owerId;
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobGranuleRestoreConfig config;
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestorePhase phase;
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	UID currentOwnerId;
															#line 1289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
};
// This generated class is to be used only via setPhase()
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_SetPhaseActor final : public Actor<Void>, public ActorCallback< BlobRestoreController_SetPhaseActor, 0, BlobRestorePhase >, public ActorCallback< BlobRestoreController_SetPhaseActor, 1, UID >, public ActorCallback< BlobRestoreController_SetPhaseActor, 2, Void >, public ActorCallback< BlobRestoreController_SetPhaseActor, 3, Void >, public FastAllocated<BlobRestoreController_SetPhaseActor>, public BlobRestoreController_SetPhaseActorState<BlobRestoreController_SetPhaseActor> {
															#line 1294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
	using FastAllocated<BlobRestoreController_SetPhaseActor>::operator new;
	using FastAllocated<BlobRestoreController_SetPhaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15217856726774200064UL, 10255225882532047616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobRestoreController_SetPhaseActor, 0, BlobRestorePhase >;
friend struct ActorCallback< BlobRestoreController_SetPhaseActor, 1, UID >;
friend struct ActorCallback< BlobRestoreController_SetPhaseActor, 2, Void >;
friend struct ActorCallback< BlobRestoreController_SetPhaseActor, 3, Void >;
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_SetPhaseActor(Reference<BlobRestoreController> const& self,BlobRestorePhase const& newPhase,Optional<UID> const& owerId) 
															#line 1314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		 : Actor<Void>(),
		   BlobRestoreController_SetPhaseActorState<BlobRestoreController_SetPhaseActor>(self, newPhase, owerId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setPhase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8464342373108714752UL, 9666469249192704UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetPhaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setPhase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setPhase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobRestoreController_SetPhaseActor, 0, BlobRestorePhase >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BlobRestoreController_SetPhaseActor, 1, UID >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BlobRestoreController_SetPhaseActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BlobRestoreController_SetPhaseActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
[[nodiscard]] Future<Void> BlobRestoreController::setPhase( Reference<BlobRestoreController> const& self, BlobRestorePhase const& newPhase, Optional<UID> const& owerId ) {
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	return Future<Void>(new BlobRestoreController_SetPhaseActor(self, newPhase, owerId));
															#line 1349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
}

#line 104 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"

// Wait on restore phase change
															#line 1355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
// This generated class is to be used only via onPhaseChange()
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
template <class BlobRestoreController_OnPhaseChangeActor>
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_OnPhaseChangeActorState {
															#line 1361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_OnPhaseChangeActorState(Reference<BlobRestoreController> const& self,BlobRestorePhase const& expectedPhase) 
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		 : self(self),
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		   expectedPhase(expectedPhase),
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		   tr(new ReadYourWritesTransaction(self->db_))
															#line 1372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
	{
		fdb_probe_actor_create("onPhaseChange", reinterpret_cast<unsigned long>(this));

	}
	~BlobRestoreController_OnPhaseChangeActorState() 
	{
		fdb_probe_actor_destroy("onPhaseChange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			;
															#line 1387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobRestoreController_OnPhaseChangeActorState();
		static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			StrictFuture<BlobRestorePhase> __when_expr_0 = BlobGranuleRestoreConfig().phase().getD(tr, Snapshot::False, BlobRestorePhase::UNINIT);
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state = 1;
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_OnPhaseChangeActor, 0, BlobRestorePhase >*>(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)));
															#line 1431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state = 4;
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_OnPhaseChangeActor, 3, Void >*>(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)));
															#line 1460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(BlobRestorePhase const& phase,int loopDepth) 
	{
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (expectedPhase == phase)
															#line 1475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		{
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (!static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobRestoreController_OnPhaseChangeActorState(); static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->destroy(); return 0; }
															#line 1479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			new (&static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~BlobRestoreController_OnPhaseChangeActorState();
			static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		watch = BlobGranuleRestoreConfig().trigger.watch(tr);
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state = 2;
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_OnPhaseChangeActor, 1, Void >*>(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)));
															#line 1496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(BlobRestorePhase && phase,int loopDepth) 
	{
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (expectedPhase == phase)
															#line 1505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		{
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (!static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobRestoreController_OnPhaseChangeActorState(); static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->destroy(); return 0; }
															#line 1509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			new (&static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~BlobRestoreController_OnPhaseChangeActorState();
			static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		watch = BlobGranuleRestoreConfig().trigger.watch(tr);
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state = 2;
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_OnPhaseChangeActor, 1, Void >*>(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)));
															#line 1526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(BlobRestorePhase const& phase,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(phase, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(BlobRestorePhase && phase,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(phase), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->ActorCallback< BlobRestoreController_OnPhaseChangeActor, 0, BlobRestorePhase >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_OnPhaseChangeActor, 0, BlobRestorePhase >*,BlobRestorePhase const& value) 
	{
		fdb_probe_actor_enter("onPhaseChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onPhaseChange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_OnPhaseChangeActor, 0, BlobRestorePhase >*,BlobRestorePhase && value) 
	{
		fdb_probe_actor_enter("onPhaseChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onPhaseChange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_OnPhaseChangeActor, 0, BlobRestorePhase >*,Error err) 
	{
		fdb_probe_actor_enter("onPhaseChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onPhaseChange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watch;
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state = 3;
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_OnPhaseChangeActor, 2, Void >*>(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)));
															#line 1617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watch;
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state = 3;
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_OnPhaseChangeActor, 2, Void >*>(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)));
															#line 1633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->ActorCallback< BlobRestoreController_OnPhaseChangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_OnPhaseChangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onPhaseChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onPhaseChange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_OnPhaseChangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onPhaseChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onPhaseChange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_OnPhaseChangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onPhaseChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onPhaseChange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobRestoreController_OnPhaseChangeActorState(); static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->destroy(); return 0; }
															#line 1717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BlobRestoreController_OnPhaseChangeActorState();
		static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobRestoreController_OnPhaseChangeActorState(); static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->destroy(); return 0; }
															#line 1729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BlobRestoreController_OnPhaseChangeActorState();
		static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->ActorCallback< BlobRestoreController_OnPhaseChangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_OnPhaseChangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onPhaseChange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onPhaseChange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_OnPhaseChangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onPhaseChange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onPhaseChange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_OnPhaseChangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onPhaseChange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onPhaseChange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->ActorCallback< BlobRestoreController_OnPhaseChangeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_OnPhaseChangeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onPhaseChange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onPhaseChange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_OnPhaseChangeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onPhaseChange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onPhaseChange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_OnPhaseChangeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onPhaseChange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onPhaseChange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	Reference<BlobRestoreController> self;
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestorePhase expectedPhase;
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	Future<Void> watch;
															#line 1907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
};
// This generated class is to be used only via onPhaseChange()
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_OnPhaseChangeActor final : public Actor<Void>, public ActorCallback< BlobRestoreController_OnPhaseChangeActor, 0, BlobRestorePhase >, public ActorCallback< BlobRestoreController_OnPhaseChangeActor, 1, Void >, public ActorCallback< BlobRestoreController_OnPhaseChangeActor, 2, Void >, public ActorCallback< BlobRestoreController_OnPhaseChangeActor, 3, Void >, public FastAllocated<BlobRestoreController_OnPhaseChangeActor>, public BlobRestoreController_OnPhaseChangeActorState<BlobRestoreController_OnPhaseChangeActor> {
															#line 1912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
	using FastAllocated<BlobRestoreController_OnPhaseChangeActor>::operator new;
	using FastAllocated<BlobRestoreController_OnPhaseChangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11017388006681826048UL, 1379303957272999424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobRestoreController_OnPhaseChangeActor, 0, BlobRestorePhase >;
friend struct ActorCallback< BlobRestoreController_OnPhaseChangeActor, 1, Void >;
friend struct ActorCallback< BlobRestoreController_OnPhaseChangeActor, 2, Void >;
friend struct ActorCallback< BlobRestoreController_OnPhaseChangeActor, 3, Void >;
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_OnPhaseChangeActor(Reference<BlobRestoreController> const& self,BlobRestorePhase const& expectedPhase) 
															#line 1932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		 : Actor<Void>(),
		   BlobRestoreController_OnPhaseChangeActorState<BlobRestoreController_OnPhaseChangeActor>(self, expectedPhase),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("onPhaseChange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15801983114147622912UL, 13793642299380597504UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_OnPhaseChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("onPhaseChange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("onPhaseChange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobRestoreController_OnPhaseChangeActor, 0, BlobRestorePhase >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BlobRestoreController_OnPhaseChangeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BlobRestoreController_OnPhaseChangeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BlobRestoreController_OnPhaseChangeActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
[[nodiscard]] Future<Void> BlobRestoreController::onPhaseChange( Reference<BlobRestoreController> const& self, BlobRestorePhase const& expectedPhase ) {
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	return Future<Void>(new BlobRestoreController_OnPhaseChangeActor(self, expectedPhase));
															#line 1967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
}

#line 130 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"

// Update restore progress
															#line 1973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
// This generated class is to be used only via setProgress()
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
template <class BlobRestoreController_SetProgressActor>
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_SetProgressActorState {
															#line 1979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_SetProgressActorState(Reference<BlobRestoreController> const& self,int const& progress,UID const& ownerId) 
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		 : self(self),
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		   progress(progress),
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		   ownerId(ownerId),
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		   tr(new ReadYourWritesTransaction(self->db_))
															#line 1992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
	{
		fdb_probe_actor_create("setProgress", reinterpret_cast<unsigned long>(this));

	}
	~BlobRestoreController_SetProgressActorState() 
	{
		fdb_probe_actor_destroy("setProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			;
															#line 2007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobRestoreController_SetProgressActorState();
		static_cast<BlobRestoreController_SetProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			StrictFuture<UID> __when_expr_0 = BlobGranuleRestoreConfig().lock().getD(tr);
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (static_cast<BlobRestoreController_SetProgressActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BlobRestoreController_SetProgressActor*>(this)->actor_wait_state = 1;
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_SetProgressActor, 0, UID >*>(static_cast<BlobRestoreController_SetProgressActor*>(this)));
															#line 2051 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (static_cast<BlobRestoreController_SetProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<BlobRestoreController_SetProgressActor*>(this)->actor_wait_state = 3;
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_SetProgressActor, 2, Void >*>(static_cast<BlobRestoreController_SetProgressActor*>(this)));
															#line 2080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(UID const& currentOwner,int loopDepth) 
	{
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (currentOwner != ownerId)
															#line 2095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		{
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			CODE_PROBE(true, "Blob migrator replaced in setProgress");
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			TraceEvent("BlobMigratorReplaced").detail("ActiveId", currentOwner).detail("CallerId", ownerId);
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			return a_body1loopBody1Catch1(blob_migrator_replaced(), loopDepth);
															#line 2103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		}
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		BlobGranuleRestoreConfig().progress().set(tr, progress);
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (static_cast<BlobRestoreController_SetProgressActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<BlobRestoreController_SetProgressActor*>(this)->actor_wait_state = 2;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_SetProgressActor, 1, Void >*>(static_cast<BlobRestoreController_SetProgressActor*>(this)));
															#line 2116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(UID && currentOwner,int loopDepth) 
	{
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (currentOwner != ownerId)
															#line 2125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		{
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			CODE_PROBE(true, "Blob migrator replaced in setProgress");
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			TraceEvent("BlobMigratorReplaced").detail("ActiveId", currentOwner).detail("CallerId", ownerId);
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			return a_body1loopBody1Catch1(blob_migrator_replaced(), loopDepth);
															#line 2133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		}
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		BlobGranuleRestoreConfig().progress().set(tr, progress);
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (static_cast<BlobRestoreController_SetProgressActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<BlobRestoreController_SetProgressActor*>(this)->actor_wait_state = 2;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_SetProgressActor, 1, Void >*>(static_cast<BlobRestoreController_SetProgressActor*>(this)));
															#line 2146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(UID const& currentOwner,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(currentOwner, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(UID && currentOwner,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(currentOwner), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobRestoreController_SetProgressActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_SetProgressActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_SetProgressActor*>(this)->ActorCallback< BlobRestoreController_SetProgressActor, 0, UID >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetProgressActor, 0, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("setProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetProgressActor, 0, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("setProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_SetProgressActor, 0, UID >*,Error err) 
	{
		fdb_probe_actor_enter("setProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_SetProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobRestoreController_SetProgressActorState(); static_cast<BlobRestoreController_SetProgressActor*>(this)->destroy(); return 0; }
															#line 2230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_SetProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BlobRestoreController_SetProgressActorState();
		static_cast<BlobRestoreController_SetProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_SetProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobRestoreController_SetProgressActorState(); static_cast<BlobRestoreController_SetProgressActor*>(this)->destroy(); return 0; }
															#line 2242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_SetProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BlobRestoreController_SetProgressActorState();
		static_cast<BlobRestoreController_SetProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BlobRestoreController_SetProgressActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_SetProgressActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_SetProgressActor*>(this)->ActorCallback< BlobRestoreController_SetProgressActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetProgressActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetProgressActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_SetProgressActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BlobRestoreController_SetProgressActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_SetProgressActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_SetProgressActor*>(this)->ActorCallback< BlobRestoreController_SetProgressActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetProgressActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetProgressActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_SetProgressActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setProgress", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	Reference<BlobRestoreController> self;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	int progress;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	UID ownerId;
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
};
// This generated class is to be used only via setProgress()
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_SetProgressActor final : public Actor<Void>, public ActorCallback< BlobRestoreController_SetProgressActor, 0, UID >, public ActorCallback< BlobRestoreController_SetProgressActor, 1, Void >, public ActorCallback< BlobRestoreController_SetProgressActor, 2, Void >, public FastAllocated<BlobRestoreController_SetProgressActor>, public BlobRestoreController_SetProgressActorState<BlobRestoreController_SetProgressActor> {
															#line 2425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
	using FastAllocated<BlobRestoreController_SetProgressActor>::operator new;
	using FastAllocated<BlobRestoreController_SetProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1648884929609656064UL, 15201882933053659392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobRestoreController_SetProgressActor, 0, UID >;
friend struct ActorCallback< BlobRestoreController_SetProgressActor, 1, Void >;
friend struct ActorCallback< BlobRestoreController_SetProgressActor, 2, Void >;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_SetProgressActor(Reference<BlobRestoreController> const& self,int const& progress,UID const& ownerId) 
															#line 2444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		 : Actor<Void>(),
		   BlobRestoreController_SetProgressActorState<BlobRestoreController_SetProgressActor>(self, progress, ownerId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2102796768805550336UL, 7276854258997270784UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobRestoreController_SetProgressActor, 0, UID >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BlobRestoreController_SetProgressActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BlobRestoreController_SetProgressActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
[[nodiscard]] Future<Void> BlobRestoreController::setProgress( Reference<BlobRestoreController> const& self, int const& progress, UID const& ownerId ) {
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	return Future<Void>(new BlobRestoreController_SetProgressActor(self, progress, ownerId));
															#line 2478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
}

#line 156 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"

// Set lock owner for current restore. Owner will be checked for further updates of restore config
															#line 2484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
// This generated class is to be used only via setLockOwner()
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
template <class BlobRestoreController_SetLockOwnerActor>
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_SetLockOwnerActorState {
															#line 2490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_SetLockOwnerActorState(Reference<BlobRestoreController> const& self,UID const& ownerId) 
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		 : self(self),
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		   ownerId(ownerId)
															#line 2499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
	{
		fdb_probe_actor_create("setLockOwner", reinterpret_cast<unsigned long>(this));

	}
	~BlobRestoreController_SetLockOwnerActorState() 
	{
		fdb_probe_actor_destroy("setLockOwner", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransaction(self->db_, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); tr->setOption(FDBTransactionOptions::LOCK_AWARE); tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE); BlobGranuleRestoreConfig().lock().set(tr, ownerId); return Void(); });
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->actor_wait_state = 1;
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_SetLockOwnerActor, 0, Void >*>(static_cast<BlobRestoreController_SetLockOwnerActor*>(this)));
															#line 2521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobRestoreController_SetLockOwnerActorState();
		static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobRestoreController_SetLockOwnerActorState(); static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->destroy(); return 0; }
															#line 2544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BlobRestoreController_SetLockOwnerActorState();
		static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobRestoreController_SetLockOwnerActorState(); static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->destroy(); return 0; }
															#line 2556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BlobRestoreController_SetLockOwnerActorState();
		static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->ActorCallback< BlobRestoreController_SetLockOwnerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetLockOwnerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setLockOwner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setLockOwner", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetLockOwnerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setLockOwner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setLockOwner", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_SetLockOwnerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setLockOwner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setLockOwner", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	Reference<BlobRestoreController> self;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	UID ownerId;
															#line 2643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
};
// This generated class is to be used only via setLockOwner()
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_SetLockOwnerActor final : public Actor<Void>, public ActorCallback< BlobRestoreController_SetLockOwnerActor, 0, Void >, public FastAllocated<BlobRestoreController_SetLockOwnerActor>, public BlobRestoreController_SetLockOwnerActorState<BlobRestoreController_SetLockOwnerActor> {
															#line 2648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
	using FastAllocated<BlobRestoreController_SetLockOwnerActor>::operator new;
	using FastAllocated<BlobRestoreController_SetLockOwnerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12250888286938932736UL, 11625317304807709696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobRestoreController_SetLockOwnerActor, 0, Void >;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_SetLockOwnerActor(Reference<BlobRestoreController> const& self,UID const& ownerId) 
															#line 2665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		 : Actor<Void>(),
		   BlobRestoreController_SetLockOwnerActorState<BlobRestoreController_SetLockOwnerActor>(self, ownerId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setLockOwner", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10033962100285563136UL, 14237500053045364480UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetLockOwnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setLockOwner");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setLockOwner", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobRestoreController_SetLockOwnerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
[[nodiscard]] Future<Void> BlobRestoreController::setLockOwner( Reference<BlobRestoreController> const& self, UID const& ownerId ) {
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	return Future<Void>(new BlobRestoreController_SetLockOwnerActor(self, ownerId));
															#line 2697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
}

#line 168 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"

// Fail the restore with an error message
															#line 2703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
// This generated class is to be used only via setError()
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
template <class BlobRestoreController_SetErrorActor>
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_SetErrorActorState {
															#line 2709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_SetErrorActorState(Reference<BlobRestoreController> const& self,std::string const& errorMessage) 
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		 : self(self),
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		   errorMessage(errorMessage)
															#line 2718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
	{
		fdb_probe_actor_create("setError", reinterpret_cast<unsigned long>(this));

	}
	~BlobRestoreController_SetErrorActorState() 
	{
		fdb_probe_actor_destroy("setError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransaction(self->db_, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); tr->setOption(FDBTransactionOptions::LOCK_AWARE); BlobGranuleRestoreConfig config; config.phase().set(tr, BlobRestorePhase::ERROR); config.phaseStartTs().set(tr, BlobRestorePhase::ERROR, now()); config.error().set(tr, errorMessage); return Void(); });
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			if (static_cast<BlobRestoreController_SetErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BlobRestoreController_SetErrorActor*>(this)->actor_wait_state = 1;
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreController_SetErrorActor, 0, Void >*>(static_cast<BlobRestoreController_SetErrorActor*>(this)));
															#line 2740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobRestoreController_SetErrorActorState();
		static_cast<BlobRestoreController_SetErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_SetErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobRestoreController_SetErrorActorState(); static_cast<BlobRestoreController_SetErrorActor*>(this)->destroy(); return 0; }
															#line 2763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_SetErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BlobRestoreController_SetErrorActorState();
		static_cast<BlobRestoreController_SetErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
		if (!static_cast<BlobRestoreController_SetErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobRestoreController_SetErrorActorState(); static_cast<BlobRestoreController_SetErrorActor*>(this)->destroy(); return 0; }
															#line 2775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		new (&static_cast<BlobRestoreController_SetErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BlobRestoreController_SetErrorActorState();
		static_cast<BlobRestoreController_SetErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobRestoreController_SetErrorActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreController_SetErrorActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreController_SetErrorActor*>(this)->ActorCallback< BlobRestoreController_SetErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobRestoreController_SetErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobRestoreController_SetErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setError", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	Reference<BlobRestoreController> self;
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	std::string errorMessage;
															#line 2862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
};
// This generated class is to be used only via setError()
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
class BlobRestoreController_SetErrorActor final : public Actor<Void>, public ActorCallback< BlobRestoreController_SetErrorActor, 0, Void >, public FastAllocated<BlobRestoreController_SetErrorActor>, public BlobRestoreController_SetErrorActorState<BlobRestoreController_SetErrorActor> {
															#line 2867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
public:
	using FastAllocated<BlobRestoreController_SetErrorActor>::operator new;
	using FastAllocated<BlobRestoreController_SetErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6234927783598478592UL, 2316197492373052416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobRestoreController_SetErrorActor, 0, Void >;
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	BlobRestoreController_SetErrorActor(Reference<BlobRestoreController> const& self,std::string const& errorMessage) 
															#line 2884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
		 : Actor<Void>(),
		   BlobRestoreController_SetErrorActorState<BlobRestoreController_SetErrorActor>(self, errorMessage),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1361153766760754432UL, 11052006489046303232UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreController_SetErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobRestoreController_SetErrorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
[[nodiscard]] Future<Void> BlobRestoreController::setError( Reference<BlobRestoreController> const& self, std::string const& errorMessage ) {
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
	return Future<Void>(new BlobRestoreController_SetErrorActor(self, errorMessage));
															#line 2916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BlobRestoreController.actor.g.cpp"
}

#line 182 "/Users/ec2-user/foundationdb/fdbserver/BlobRestoreController.actor.cpp"
